/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProviderName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PROVIDER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/providers/{provider}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String provider;

    @Deprecated
    protected ProviderName() {
        this.project = null;
        this.location = null;
        this.provider = null;
    }

    private ProviderName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.provider = (String)Preconditions.checkNotNull((Object)builder.getProvider());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProvider() {
        return this.provider;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProviderName of(String project, String location, String provider) {
        return ProviderName.newBuilder().setProject(project).setLocation(location).setProvider(provider).build();
    }

    public static String format(String project, String location, String provider) {
        return ProviderName.newBuilder().setProject(project).setLocation(location).setProvider(provider).build().toString();
    }

    public static ProviderName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PROVIDER.validatedMatch(formattedString, "ProviderName.parse: formattedString not in valid format");
        return ProviderName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("provider"));
    }

    public static List<ProviderName> parseList(List<String> formattedStrings) {
        ArrayList<ProviderName> list = new ArrayList<ProviderName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProviderName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProviderName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProviderName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PROVIDER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProviderName providerName = this;
            synchronized (providerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.provider != null) {
                        fieldMapBuilder.put((Object)"provider", (Object)this.provider);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PROVIDER.instantiate(new String[]{"project", this.project, "location", this.location, "provider", this.provider});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ProviderName that = (ProviderName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.provider, that.provider);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.provider);
    }

    public static class Builder {
        private String project;
        private String location;
        private String provider;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProvider() {
            return this.provider;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProvider(String provider) {
            this.provider = provider;
            return this;
        }

        private Builder(ProviderName providerName) {
            this.project = providerName.project;
            this.location = providerName.location;
            this.provider = providerName.provider;
        }

        public ProviderName build() {
            return new ProviderName(this);
        }
    }
}

