/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.enterpriseknowledgegraph.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntityReconciliationJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENTITY_RECONCILIATION_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entityReconciliationJobs/{entity_reconciliation_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String entityReconciliationJob;

    @Deprecated
    protected EntityReconciliationJobName() {
        this.project = null;
        this.location = null;
        this.entityReconciliationJob = null;
    }

    private EntityReconciliationJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entityReconciliationJob = (String)Preconditions.checkNotNull((Object)builder.getEntityReconciliationJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEntityReconciliationJob() {
        return this.entityReconciliationJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EntityReconciliationJobName of(String project, String location, String entityReconciliationJob) {
        return EntityReconciliationJobName.newBuilder().setProject(project).setLocation(location).setEntityReconciliationJob(entityReconciliationJob).build();
    }

    public static String format(String project, String location, String entityReconciliationJob) {
        return EntityReconciliationJobName.newBuilder().setProject(project).setLocation(location).setEntityReconciliationJob(entityReconciliationJob).build().toString();
    }

    public static EntityReconciliationJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ENTITY_RECONCILIATION_JOB.validatedMatch(formattedString, "EntityReconciliationJobName.parse: formattedString not in valid format");
        return EntityReconciliationJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("entity_reconciliation_job"));
    }

    public static List<EntityReconciliationJobName> parseList(List<String> formattedStrings) {
        ArrayList<EntityReconciliationJobName> list = new ArrayList<EntityReconciliationJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntityReconciliationJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntityReconciliationJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntityReconciliationJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENTITY_RECONCILIATION_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntityReconciliationJobName entityReconciliationJobName = this;
            synchronized (entityReconciliationJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.entityReconciliationJob != null) {
                        fieldMapBuilder.put((Object)"entity_reconciliation_job", (Object)this.entityReconciliationJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ENTITY_RECONCILIATION_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "entity_reconciliation_job", this.entityReconciliationJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            EntityReconciliationJobName that = (EntityReconciliationJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.entityReconciliationJob, that.entityReconciliationJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.entityReconciliationJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String entityReconciliationJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntityReconciliationJob() {
            return this.entityReconciliationJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEntityReconciliationJob(String entityReconciliationJob) {
            this.entityReconciliationJob = entityReconciliationJob;
            return this;
        }

        private Builder(EntityReconciliationJobName entityReconciliationJobName) {
            this.project = entityReconciliationJobName.project;
            this.location = entityReconciliationJobName.location;
            this.entityReconciliationJob = entityReconciliationJobName.entityReconciliationJob;
        }

        public EntityReconciliationJobName build() {
            return new EntityReconciliationJobName(this);
        }
    }
}

