/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgenetwork.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RouterName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ZONE_ROUTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/zones/{zone}/routers/{router}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String zone;
    private final String router;

    @Deprecated
    protected RouterName() {
        this.project = null;
        this.location = null;
        this.zone = null;
        this.router = null;
    }

    private RouterName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
        this.router = (String)Preconditions.checkNotNull((Object)builder.getRouter());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getZone() {
        return this.zone;
    }

    public String getRouter() {
        return this.router;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RouterName of(String project, String location, String zone, String router) {
        return RouterName.newBuilder().setProject(project).setLocation(location).setZone(zone).setRouter(router).build();
    }

    public static String format(String project, String location, String zone, String router) {
        return RouterName.newBuilder().setProject(project).setLocation(location).setZone(zone).setRouter(router).build().toString();
    }

    public static RouterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ZONE_ROUTER.validatedMatch(formattedString, "RouterName.parse: formattedString not in valid format");
        return RouterName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("zone"), (String)matchMap.get("router"));
    }

    public static List<RouterName> parseList(List<String> formattedStrings) {
        ArrayList<RouterName> list = new ArrayList<RouterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RouterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RouterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RouterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ZONE_ROUTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RouterName routerName = this;
            synchronized (routerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.zone != null) {
                        fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    }
                    if (this.router != null) {
                        fieldMapBuilder.put((Object)"router", (Object)this.router);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ZONE_ROUTER.instantiate(new String[]{"project", this.project, "location", this.location, "zone", this.zone, "router", this.router});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RouterName that = (RouterName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.zone, that.zone) && Objects.equals(this.router, that.router);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.zone);
        h *= 1000003;
        return h ^= Objects.hashCode(this.router);
    }

    public static class Builder {
        private String project;
        private String location;
        private String zone;
        private String router;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getZone() {
            return this.zone;
        }

        public String getRouter() {
            return this.router;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder setRouter(String router) {
            this.router = router;
            return this;
        }

        private Builder(RouterName routerName) {
            this.project = routerName.project;
            this.location = routerName.location;
            this.zone = routerName.zone;
            this.router = routerName.router;
        }

        public RouterName build() {
            return new RouterName(this);
        }
    }
}

