/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgenetwork.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SubnetName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ZONE_SUBNET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/zones/{zone}/subnets/{subnet}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String zone;
    private final String subnet;

    @Deprecated
    protected SubnetName() {
        this.project = null;
        this.location = null;
        this.zone = null;
        this.subnet = null;
    }

    private SubnetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
        this.subnet = (String)Preconditions.checkNotNull((Object)builder.getSubnet());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getZone() {
        return this.zone;
    }

    public String getSubnet() {
        return this.subnet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SubnetName of(String project, String location, String zone, String subnet) {
        return SubnetName.newBuilder().setProject(project).setLocation(location).setZone(zone).setSubnet(subnet).build();
    }

    public static String format(String project, String location, String zone, String subnet) {
        return SubnetName.newBuilder().setProject(project).setLocation(location).setZone(zone).setSubnet(subnet).build().toString();
    }

    public static SubnetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ZONE_SUBNET.validatedMatch(formattedString, "SubnetName.parse: formattedString not in valid format");
        return SubnetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("zone"), (String)matchMap.get("subnet"));
    }

    public static List<SubnetName> parseList(List<String> formattedStrings) {
        ArrayList<SubnetName> list = new ArrayList<SubnetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SubnetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SubnetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SubnetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ZONE_SUBNET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SubnetName subnetName = this;
            synchronized (subnetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.zone != null) {
                        fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    }
                    if (this.subnet != null) {
                        fieldMapBuilder.put((Object)"subnet", (Object)this.subnet);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ZONE_SUBNET.instantiate(new String[]{"project", this.project, "location", this.location, "zone", this.zone, "subnet", this.subnet});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SubnetName that = (SubnetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.zone, that.zone) && Objects.equals(this.subnet, that.subnet);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.zone);
        h *= 1000003;
        return h ^= Objects.hashCode(this.subnet);
    }

    public static class Builder {
        private String project;
        private String location;
        private String zone;
        private String subnet;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getZone() {
            return this.zone;
        }

        public String getSubnet() {
            return this.subnet;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder setSubnet(String subnet) {
            this.subnet = subnet;
            return this;
        }

        private Builder(SubnetName subnetName) {
            this.project = subnetName.project;
            this.location = subnetName.location;
            this.zone = subnetName.zone;
            this.subnet = subnetName.subnet;
        }

        public SubnetName build() {
            return new SubnetName(this);
        }
    }
}

