/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EvaluationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PROCESSOR_PROCESSOR_VERSION_EVALUATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}/evaluations/{evaluation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String processor;
    private final String processorVersion;
    private final String evaluation;

    @Deprecated
    protected EvaluationName() {
        this.project = null;
        this.location = null;
        this.processor = null;
        this.processorVersion = null;
        this.evaluation = null;
    }

    private EvaluationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.processor = (String)Preconditions.checkNotNull((Object)builder.getProcessor());
        this.processorVersion = (String)Preconditions.checkNotNull((Object)builder.getProcessorVersion());
        this.evaluation = (String)Preconditions.checkNotNull((Object)builder.getEvaluation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProcessor() {
        return this.processor;
    }

    public String getProcessorVersion() {
        return this.processorVersion;
    }

    public String getEvaluation() {
        return this.evaluation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EvaluationName of(String project, String location, String processor, String processorVersion, String evaluation) {
        return EvaluationName.newBuilder().setProject(project).setLocation(location).setProcessor(processor).setProcessorVersion(processorVersion).setEvaluation(evaluation).build();
    }

    public static String format(String project, String location, String processor, String processorVersion, String evaluation) {
        return EvaluationName.newBuilder().setProject(project).setLocation(location).setProcessor(processor).setProcessorVersion(processorVersion).setEvaluation(evaluation).build().toString();
    }

    public static EvaluationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PROCESSOR_PROCESSOR_VERSION_EVALUATION.validatedMatch(formattedString, "EvaluationName.parse: formattedString not in valid format");
        return EvaluationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("processor"), (String)matchMap.get("processor_version"), (String)matchMap.get("evaluation"));
    }

    public static List<EvaluationName> parseList(List<String> formattedStrings) {
        ArrayList<EvaluationName> list = new ArrayList<EvaluationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EvaluationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EvaluationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EvaluationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PROCESSOR_PROCESSOR_VERSION_EVALUATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EvaluationName evaluationName = this;
            synchronized (evaluationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.processor != null) {
                        fieldMapBuilder.put((Object)"processor", (Object)this.processor);
                    }
                    if (this.processorVersion != null) {
                        fieldMapBuilder.put((Object)"processor_version", (Object)this.processorVersion);
                    }
                    if (this.evaluation != null) {
                        fieldMapBuilder.put((Object)"evaluation", (Object)this.evaluation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PROCESSOR_PROCESSOR_VERSION_EVALUATION.instantiate(new String[]{"project", this.project, "location", this.location, "processor", this.processor, "processor_version", this.processorVersion, "evaluation", this.evaluation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            EvaluationName that = (EvaluationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.processor, that.processor) && Objects.equals(this.processorVersion, that.processorVersion) && Objects.equals(this.evaluation, that.evaluation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.processor);
        h *= 1000003;
        h ^= Objects.hashCode(this.processorVersion);
        h *= 1000003;
        return h ^= Objects.hashCode(this.evaluation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String processor;
        private String processorVersion;
        private String evaluation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProcessor() {
            return this.processor;
        }

        public String getProcessorVersion() {
            return this.processorVersion;
        }

        public String getEvaluation() {
            return this.evaluation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProcessor(String processor) {
            this.processor = processor;
            return this;
        }

        public Builder setProcessorVersion(String processorVersion) {
            this.processorVersion = processorVersion;
            return this;
        }

        public Builder setEvaluation(String evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        private Builder(EvaluationName evaluationName) {
            this.project = evaluationName.project;
            this.location = evaluationName.location;
            this.processor = evaluationName.processor;
            this.processorVersion = evaluationName.processorVersion;
            this.evaluation = evaluationName.evaluation;
        }

        public EvaluationName build() {
            return new EvaluationName(this);
        }
    }
}

