/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProcessorTypeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PROCESSOR_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/processorTypes/{processor_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String processorType;

    @Deprecated
    protected ProcessorTypeName() {
        this.project = null;
        this.location = null;
        this.processorType = null;
    }

    private ProcessorTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.processorType = (String)Preconditions.checkNotNull((Object)builder.getProcessorType());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProcessorType() {
        return this.processorType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProcessorTypeName of(String project, String location, String processorType) {
        return ProcessorTypeName.newBuilder().setProject(project).setLocation(location).setProcessorType(processorType).build();
    }

    public static String format(String project, String location, String processorType) {
        return ProcessorTypeName.newBuilder().setProject(project).setLocation(location).setProcessorType(processorType).build().toString();
    }

    public static ProcessorTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PROCESSOR_TYPE.validatedMatch(formattedString, "ProcessorTypeName.parse: formattedString not in valid format");
        return ProcessorTypeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("processor_type"));
    }

    public static List<ProcessorTypeName> parseList(List<String> formattedStrings) {
        ArrayList<ProcessorTypeName> list = new ArrayList<ProcessorTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProcessorTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProcessorTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProcessorTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PROCESSOR_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProcessorTypeName processorTypeName = this;
            synchronized (processorTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.processorType != null) {
                        fieldMapBuilder.put((Object)"processor_type", (Object)this.processorType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PROCESSOR_TYPE.instantiate(new String[]{"project", this.project, "location", this.location, "processor_type", this.processorType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ProcessorTypeName that = (ProcessorTypeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.processorType, that.processorType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.processorType);
    }

    public static class Builder {
        private String project;
        private String location;
        private String processorType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProcessorType() {
            return this.processorType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProcessorType(String processorType) {
            this.processorType = processorType;
            return this;
        }

        private Builder(ProcessorTypeName processorTypeName) {
            this.project = processorTypeName.project;
            this.location = processorTypeName.location;
            this.processorType = processorTypeName.processorType;
        }

        public ProcessorTypeName build() {
            return new ProcessorTypeName(this);
        }
    }
}

