/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProjectDataProfileName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_PROJECT_DATA_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/projectDataProfiles/{project_data_profile}");
    private static final PathTemplate PROJECT_LOCATION_PROJECT_DATA_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/projectDataProfiles/{project_data_profile}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String projectDataProfile;
    private final String project;

    @Deprecated
    protected ProjectDataProfileName() {
        this.organization = null;
        this.location = null;
        this.projectDataProfile = null;
        this.project = null;
    }

    private ProjectDataProfileName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.projectDataProfile = (String)Preconditions.checkNotNull((Object)builder.getProjectDataProfile());
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_PROJECT_DATA_PROFILE;
    }

    private ProjectDataProfileName(ProjectLocationProjectDataProfileBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.projectDataProfile = (String)Preconditions.checkNotNull((Object)builder.getProjectDataProfile());
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_PROJECT_DATA_PROFILE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProjectDataProfile() {
        return this.projectDataProfile;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationLocationProjectDataProfileBuilder() {
        return new Builder();
    }

    public static ProjectLocationProjectDataProfileBuilder newProjectLocationProjectDataProfileBuilder() {
        return new ProjectLocationProjectDataProfileBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProjectDataProfileName of(String organization, String location, String projectDataProfile) {
        return ProjectDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setProjectDataProfile(projectDataProfile).build();
    }

    public static ProjectDataProfileName ofOrganizationLocationProjectDataProfileName(String organization, String location, String projectDataProfile) {
        return ProjectDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setProjectDataProfile(projectDataProfile).build();
    }

    public static ProjectDataProfileName ofProjectLocationProjectDataProfileName(String project, String location, String projectDataProfile) {
        return ProjectDataProfileName.newProjectLocationProjectDataProfileBuilder().setProject(project).setLocation(location).setProjectDataProfile(projectDataProfile).build();
    }

    public static String format(String organization, String location, String projectDataProfile) {
        return ProjectDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setProjectDataProfile(projectDataProfile).build().toString();
    }

    public static String formatOrganizationLocationProjectDataProfileName(String organization, String location, String projectDataProfile) {
        return ProjectDataProfileName.newBuilder().setOrganization(organization).setLocation(location).setProjectDataProfile(projectDataProfile).build().toString();
    }

    public static String formatProjectLocationProjectDataProfileName(String project, String location, String projectDataProfile) {
        return ProjectDataProfileName.newProjectLocationProjectDataProfileBuilder().setProject(project).setLocation(location).setProjectDataProfile(projectDataProfile).build().toString();
    }

    public static ProjectDataProfileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION_PROJECT_DATA_PROFILE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_PROJECT_DATA_PROFILE.match(formattedString);
            return ProjectDataProfileName.ofOrganizationLocationProjectDataProfileName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("project_data_profile"));
        }
        if (PROJECT_LOCATION_PROJECT_DATA_PROFILE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_PROJECT_DATA_PROFILE.match(formattedString);
            return ProjectDataProfileName.ofProjectLocationProjectDataProfileName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("project_data_profile"));
        }
        throw new ValidationException("ProjectDataProfileName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ProjectDataProfileName> parseList(List<String> formattedStrings) {
        ArrayList<ProjectDataProfileName> list = new ArrayList<ProjectDataProfileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProjectDataProfileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProjectDataProfileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProjectDataProfileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_PROJECT_DATA_PROFILE.matches(formattedString) || PROJECT_LOCATION_PROJECT_DATA_PROFILE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectDataProfileName projectDataProfileName = this;
            synchronized (projectDataProfileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.projectDataProfile != null) {
                        fieldMapBuilder.put((Object)"project_data_profile", (Object)this.projectDataProfile);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ProjectDataProfileName that = (ProjectDataProfileName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.projectDataProfile, that.projectDataProfile) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.projectDataProfile);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectLocationProjectDataProfileBuilder {
        private String project;
        private String location;
        private String projectDataProfile;

        protected ProjectLocationProjectDataProfileBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProjectDataProfile() {
            return this.projectDataProfile;
        }

        public ProjectLocationProjectDataProfileBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationProjectDataProfileBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationProjectDataProfileBuilder setProjectDataProfile(String projectDataProfile) {
            this.projectDataProfile = projectDataProfile;
            return this;
        }

        public ProjectDataProfileName build() {
            return new ProjectDataProfileName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;
        private String projectDataProfile;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProjectDataProfile() {
            return this.projectDataProfile;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProjectDataProfile(String projectDataProfile) {
            this.projectDataProfile = projectDataProfile;
            return this;
        }

        private Builder(ProjectDataProfileName projectDataProfileName) {
            Preconditions.checkArgument((boolean)Objects.equals(projectDataProfileName.pathTemplate, ORGANIZATION_LOCATION_PROJECT_DATA_PROFILE), (Object)"toBuilder is only supported when ProjectDataProfileName has the pattern of organizations/{organization}/locations/{location}/projectDataProfiles/{project_data_profile}");
            this.organization = projectDataProfileName.organization;
            this.location = projectDataProfileName.location;
            this.projectDataProfile = projectDataProfileName.projectDataProfile;
        }

        public ProjectDataProfileName build() {
            return new ProjectDataProfileName(this);
        }
    }
}

