/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DiscoveryConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DISCOVERY_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/discoveryConfigs/{discovery_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String discoveryConfig;

    @Deprecated
    protected DiscoveryConfigName() {
        this.project = null;
        this.location = null;
        this.discoveryConfig = null;
    }

    private DiscoveryConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.discoveryConfig = (String)Preconditions.checkNotNull((Object)builder.getDiscoveryConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDiscoveryConfig() {
        return this.discoveryConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DiscoveryConfigName of(String project, String location, String discoveryConfig) {
        return DiscoveryConfigName.newBuilder().setProject(project).setLocation(location).setDiscoveryConfig(discoveryConfig).build();
    }

    public static String format(String project, String location, String discoveryConfig) {
        return DiscoveryConfigName.newBuilder().setProject(project).setLocation(location).setDiscoveryConfig(discoveryConfig).build().toString();
    }

    public static DiscoveryConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DISCOVERY_CONFIG.validatedMatch(formattedString, "DiscoveryConfigName.parse: formattedString not in valid format");
        return DiscoveryConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("discovery_config"));
    }

    public static List<DiscoveryConfigName> parseList(List<String> formattedStrings) {
        ArrayList<DiscoveryConfigName> list = new ArrayList<DiscoveryConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DiscoveryConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DiscoveryConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DiscoveryConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DISCOVERY_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DiscoveryConfigName discoveryConfigName = this;
            synchronized (discoveryConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.discoveryConfig != null) {
                        fieldMapBuilder.put((Object)"discovery_config", (Object)this.discoveryConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DISCOVERY_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "discovery_config", this.discoveryConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DiscoveryConfigName that = (DiscoveryConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.discoveryConfig, that.discoveryConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.discoveryConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String discoveryConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDiscoveryConfig() {
            return this.discoveryConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDiscoveryConfig(String discoveryConfig) {
            this.discoveryConfig = discoveryConfig;
            return this;
        }

        private Builder(DiscoveryConfigName discoveryConfigName) {
            this.project = discoveryConfigName.project;
            this.location = discoveryConfigName.location;
            this.discoveryConfig = discoveryConfigName.discoveryConfig;
        }

        public DiscoveryConfigName build() {
            return new DiscoveryConfigName(this);
        }
    }
}

