/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.privacy.dlp.v2.ContentOption;
import com.google.privacy.dlp.v2.CustomInfoType;
import com.google.privacy.dlp.v2.CustomInfoTypeOrBuilder;
import com.google.privacy.dlp.v2.DlpProto;
import com.google.privacy.dlp.v2.InfoType;
import com.google.privacy.dlp.v2.InfoTypeOrBuilder;
import com.google.privacy.dlp.v2.InspectConfigOrBuilder;
import com.google.privacy.dlp.v2.InspectionRuleSet;
import com.google.privacy.dlp.v2.InspectionRuleSetOrBuilder;
import com.google.privacy.dlp.v2.Likelihood;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class InspectConfig
extends GeneratedMessageV3
implements InspectConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int INFO_TYPES_FIELD_NUMBER = 1;
    private List<InfoType> infoTypes_;
    public static final int MIN_LIKELIHOOD_FIELD_NUMBER = 2;
    private int minLikelihood_ = 0;
    public static final int LIMITS_FIELD_NUMBER = 3;
    private FindingLimits limits_;
    public static final int INCLUDE_QUOTE_FIELD_NUMBER = 4;
    private boolean includeQuote_ = false;
    public static final int EXCLUDE_INFO_TYPES_FIELD_NUMBER = 5;
    private boolean excludeInfoTypes_ = false;
    public static final int CUSTOM_INFO_TYPES_FIELD_NUMBER = 6;
    private List<CustomInfoType> customInfoTypes_;
    public static final int CONTENT_OPTIONS_FIELD_NUMBER = 8;
    private List<Integer> contentOptions_;
    private static final Internal.ListAdapter.Converter<Integer, ContentOption> contentOptions_converter_ = new Internal.ListAdapter.Converter<Integer, ContentOption>(){

        public ContentOption convert(Integer from) {
            ContentOption result = ContentOption.forNumber(from);
            return result == null ? ContentOption.UNRECOGNIZED : result;
        }
    };
    private int contentOptionsMemoizedSerializedSize;
    public static final int RULE_SET_FIELD_NUMBER = 10;
    private List<InspectionRuleSet> ruleSet_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final InspectConfig DEFAULT_INSTANCE = new InspectConfig();
    private static final Parser<InspectConfig> PARSER = new AbstractParser<InspectConfig>(){

        public InspectConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = InspectConfig.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private InspectConfig(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private InspectConfig() {
        this.infoTypes_ = Collections.emptyList();
        this.minLikelihood_ = 0;
        this.customInfoTypes_ = Collections.emptyList();
        this.contentOptions_ = Collections.emptyList();
        this.ruleSet_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new InspectConfig();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(InspectConfig.class, Builder.class);
    }

    @Override
    public List<InfoType> getInfoTypesList() {
        return this.infoTypes_;
    }

    @Override
    public List<? extends InfoTypeOrBuilder> getInfoTypesOrBuilderList() {
        return this.infoTypes_;
    }

    @Override
    public int getInfoTypesCount() {
        return this.infoTypes_.size();
    }

    @Override
    public InfoType getInfoTypes(int index) {
        return this.infoTypes_.get(index);
    }

    @Override
    public InfoTypeOrBuilder getInfoTypesOrBuilder(int index) {
        return this.infoTypes_.get(index);
    }

    @Override
    public int getMinLikelihoodValue() {
        return this.minLikelihood_;
    }

    @Override
    public Likelihood getMinLikelihood() {
        Likelihood result = Likelihood.forNumber(this.minLikelihood_);
        return result == null ? Likelihood.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasLimits() {
        return this.limits_ != null;
    }

    @Override
    public FindingLimits getLimits() {
        return this.limits_ == null ? FindingLimits.getDefaultInstance() : this.limits_;
    }

    @Override
    public FindingLimitsOrBuilder getLimitsOrBuilder() {
        return this.limits_ == null ? FindingLimits.getDefaultInstance() : this.limits_;
    }

    @Override
    public boolean getIncludeQuote() {
        return this.includeQuote_;
    }

    @Override
    public boolean getExcludeInfoTypes() {
        return this.excludeInfoTypes_;
    }

    @Override
    public List<CustomInfoType> getCustomInfoTypesList() {
        return this.customInfoTypes_;
    }

    @Override
    public List<? extends CustomInfoTypeOrBuilder> getCustomInfoTypesOrBuilderList() {
        return this.customInfoTypes_;
    }

    @Override
    public int getCustomInfoTypesCount() {
        return this.customInfoTypes_.size();
    }

    @Override
    public CustomInfoType getCustomInfoTypes(int index) {
        return this.customInfoTypes_.get(index);
    }

    @Override
    public CustomInfoTypeOrBuilder getCustomInfoTypesOrBuilder(int index) {
        return this.customInfoTypes_.get(index);
    }

    @Override
    public List<ContentOption> getContentOptionsList() {
        return new Internal.ListAdapter(this.contentOptions_, contentOptions_converter_);
    }

    @Override
    public int getContentOptionsCount() {
        return this.contentOptions_.size();
    }

    @Override
    public ContentOption getContentOptions(int index) {
        return (ContentOption)((Object)contentOptions_converter_.convert((Object)this.contentOptions_.get(index)));
    }

    @Override
    public List<Integer> getContentOptionsValueList() {
        return this.contentOptions_;
    }

    @Override
    public int getContentOptionsValue(int index) {
        return this.contentOptions_.get(index);
    }

    @Override
    public List<InspectionRuleSet> getRuleSetList() {
        return this.ruleSet_;
    }

    @Override
    public List<? extends InspectionRuleSetOrBuilder> getRuleSetOrBuilderList() {
        return this.ruleSet_;
    }

    @Override
    public int getRuleSetCount() {
        return this.ruleSet_.size();
    }

    @Override
    public InspectionRuleSet getRuleSet(int index) {
        return this.ruleSet_.get(index);
    }

    @Override
    public InspectionRuleSetOrBuilder getRuleSetOrBuilder(int index) {
        return this.ruleSet_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        for (i = 0; i < this.infoTypes_.size(); ++i) {
            output.writeMessage(1, (MessageLite)this.infoTypes_.get(i));
        }
        if (this.minLikelihood_ != Likelihood.LIKELIHOOD_UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.minLikelihood_);
        }
        if (this.limits_ != null) {
            output.writeMessage(3, (MessageLite)this.getLimits());
        }
        if (this.includeQuote_) {
            output.writeBool(4, this.includeQuote_);
        }
        if (this.excludeInfoTypes_) {
            output.writeBool(5, this.excludeInfoTypes_);
        }
        for (i = 0; i < this.customInfoTypes_.size(); ++i) {
            output.writeMessage(6, (MessageLite)this.customInfoTypes_.get(i));
        }
        if (this.getContentOptionsList().size() > 0) {
            output.writeUInt32NoTag(66);
            output.writeUInt32NoTag(this.contentOptionsMemoizedSerializedSize);
        }
        for (i = 0; i < this.contentOptions_.size(); ++i) {
            output.writeEnumNoTag(this.contentOptions_.get(i).intValue());
        }
        for (i = 0; i < this.ruleSet_.size(); ++i) {
            output.writeMessage(10, (MessageLite)this.ruleSet_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (i = 0; i < this.infoTypes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.infoTypes_.get(i)));
        }
        if (this.minLikelihood_ != Likelihood.LIKELIHOOD_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.minLikelihood_);
        }
        if (this.limits_ != null) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getLimits());
        }
        if (this.includeQuote_) {
            size += CodedOutputStream.computeBoolSize((int)4, (boolean)this.includeQuote_);
        }
        if (this.excludeInfoTypes_) {
            size += CodedOutputStream.computeBoolSize((int)5, (boolean)this.excludeInfoTypes_);
        }
        for (i = 0; i < this.customInfoTypes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((MessageLite)this.customInfoTypes_.get(i)));
        }
        int dataSize = 0;
        for (int i2 = 0; i2 < this.contentOptions_.size(); ++i2) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.contentOptions_.get(i2));
        }
        size += dataSize;
        if (!this.getContentOptionsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.contentOptionsMemoizedSerializedSize = dataSize;
        for (i = 0; i < this.ruleSet_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)((MessageLite)this.ruleSet_.get(i)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InspectConfig)) {
            return super.equals(obj);
        }
        InspectConfig other = (InspectConfig)obj;
        if (!this.getInfoTypesList().equals(other.getInfoTypesList())) {
            return false;
        }
        if (this.minLikelihood_ != other.minLikelihood_) {
            return false;
        }
        if (this.hasLimits() != other.hasLimits()) {
            return false;
        }
        if (this.hasLimits() && !this.getLimits().equals(other.getLimits())) {
            return false;
        }
        if (this.getIncludeQuote() != other.getIncludeQuote()) {
            return false;
        }
        if (this.getExcludeInfoTypes() != other.getExcludeInfoTypes()) {
            return false;
        }
        if (!this.getCustomInfoTypesList().equals(other.getCustomInfoTypesList())) {
            return false;
        }
        if (!this.contentOptions_.equals(other.contentOptions_)) {
            return false;
        }
        if (!this.getRuleSetList().equals(other.getRuleSetList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + InspectConfig.getDescriptor().hashCode();
        if (this.getInfoTypesCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getInfoTypesList().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.minLikelihood_;
        if (this.hasLimits()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getLimits().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIncludeQuote());
        hash = 37 * hash + 5;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getExcludeInfoTypes());
        if (this.getCustomInfoTypesCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getCustomInfoTypesList().hashCode();
        }
        if (this.getContentOptionsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.contentOptions_.hashCode();
        }
        if (this.getRuleSetCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getRuleSetList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static InspectConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (InspectConfig)PARSER.parseFrom(data);
    }

    public static InspectConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (InspectConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static InspectConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (InspectConfig)PARSER.parseFrom(data);
    }

    public static InspectConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (InspectConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static InspectConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (InspectConfig)PARSER.parseFrom(data);
    }

    public static InspectConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (InspectConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static InspectConfig parseFrom(InputStream input) throws IOException {
        return (InspectConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static InspectConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (InspectConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static InspectConfig parseDelimitedFrom(InputStream input) throws IOException {
        return (InspectConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static InspectConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (InspectConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static InspectConfig parseFrom(CodedInputStream input) throws IOException {
        return (InspectConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static InspectConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (InspectConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return InspectConfig.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InspectConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static InspectConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<InspectConfig> parser() {
        return PARSER;
    }

    public Parser<InspectConfig> getParserForType() {
        return PARSER;
    }

    public InspectConfig getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements InspectConfigOrBuilder {
        private int bitField0_;
        private List<InfoType> infoTypes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<InfoType, InfoType.Builder, InfoTypeOrBuilder> infoTypesBuilder_;
        private int minLikelihood_ = 0;
        private FindingLimits limits_;
        private SingleFieldBuilderV3<FindingLimits, FindingLimits.Builder, FindingLimitsOrBuilder> limitsBuilder_;
        private boolean includeQuote_;
        private boolean excludeInfoTypes_;
        private List<CustomInfoType> customInfoTypes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<CustomInfoType, CustomInfoType.Builder, CustomInfoTypeOrBuilder> customInfoTypesBuilder_;
        private List<Integer> contentOptions_ = Collections.emptyList();
        private List<InspectionRuleSet> ruleSet_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<InspectionRuleSet, InspectionRuleSet.Builder, InspectionRuleSetOrBuilder> ruleSetBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(InspectConfig.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            if (this.infoTypesBuilder_ == null) {
                this.infoTypes_ = Collections.emptyList();
            } else {
                this.infoTypes_ = null;
                this.infoTypesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFE;
            this.minLikelihood_ = 0;
            this.limits_ = null;
            if (this.limitsBuilder_ != null) {
                this.limitsBuilder_.dispose();
                this.limitsBuilder_ = null;
            }
            this.includeQuote_ = false;
            this.excludeInfoTypes_ = false;
            if (this.customInfoTypesBuilder_ == null) {
                this.customInfoTypes_ = Collections.emptyList();
            } else {
                this.customInfoTypes_ = null;
                this.customInfoTypesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFDF;
            this.contentOptions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFBF;
            if (this.ruleSetBuilder_ == null) {
                this.ruleSet_ = Collections.emptyList();
            } else {
                this.ruleSet_ = null;
                this.ruleSetBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFF7F;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_descriptor;
        }

        public InspectConfig getDefaultInstanceForType() {
            return InspectConfig.getDefaultInstance();
        }

        public InspectConfig build() {
            InspectConfig result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public InspectConfig buildPartial() {
            InspectConfig result = new InspectConfig(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(InspectConfig result) {
            if (this.infoTypesBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.infoTypes_ = Collections.unmodifiableList(this.infoTypes_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.infoTypes_ = this.infoTypes_;
            } else {
                result.infoTypes_ = this.infoTypesBuilder_.build();
            }
            if (this.customInfoTypesBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0) {
                    this.customInfoTypes_ = Collections.unmodifiableList(this.customInfoTypes_);
                    this.bitField0_ &= 0xFFFFFFDF;
                }
                result.customInfoTypes_ = this.customInfoTypes_;
            } else {
                result.customInfoTypes_ = this.customInfoTypesBuilder_.build();
            }
            if ((this.bitField0_ & 0x40) != 0) {
                this.contentOptions_ = Collections.unmodifiableList(this.contentOptions_);
                this.bitField0_ &= 0xFFFFFFBF;
            }
            result.contentOptions_ = this.contentOptions_;
            if (this.ruleSetBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0) {
                    this.ruleSet_ = Collections.unmodifiableList(this.ruleSet_);
                    this.bitField0_ &= 0xFFFFFF7F;
                }
                result.ruleSet_ = this.ruleSet_;
            } else {
                result.ruleSet_ = this.ruleSetBuilder_.build();
            }
        }

        private void buildPartial0(InspectConfig result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 2) != 0) {
                result.minLikelihood_ = this.minLikelihood_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.limits_ = this.limitsBuilder_ == null ? this.limits_ : (FindingLimits)this.limitsBuilder_.build();
            }
            if ((from_bitField0_ & 8) != 0) {
                result.includeQuote_ = this.includeQuote_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.excludeInfoTypes_ = this.excludeInfoTypes_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof InspectConfig) {
                return this.mergeFrom((InspectConfig)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(InspectConfig other) {
            if (other == InspectConfig.getDefaultInstance()) {
                return this;
            }
            if (this.infoTypesBuilder_ == null) {
                if (!other.infoTypes_.isEmpty()) {
                    if (this.infoTypes_.isEmpty()) {
                        this.infoTypes_ = other.infoTypes_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureInfoTypesIsMutable();
                        this.infoTypes_.addAll(other.infoTypes_);
                    }
                    this.onChanged();
                }
            } else if (!other.infoTypes_.isEmpty()) {
                if (this.infoTypesBuilder_.isEmpty()) {
                    this.infoTypesBuilder_.dispose();
                    this.infoTypesBuilder_ = null;
                    this.infoTypes_ = other.infoTypes_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.infoTypesBuilder_ = alwaysUseFieldBuilders ? this.getInfoTypesFieldBuilder() : null;
                } else {
                    this.infoTypesBuilder_.addAllMessages((Iterable)other.infoTypes_);
                }
            }
            if (other.minLikelihood_ != 0) {
                this.setMinLikelihoodValue(other.getMinLikelihoodValue());
            }
            if (other.hasLimits()) {
                this.mergeLimits(other.getLimits());
            }
            if (other.getIncludeQuote()) {
                this.setIncludeQuote(other.getIncludeQuote());
            }
            if (other.getExcludeInfoTypes()) {
                this.setExcludeInfoTypes(other.getExcludeInfoTypes());
            }
            if (this.customInfoTypesBuilder_ == null) {
                if (!other.customInfoTypes_.isEmpty()) {
                    if (this.customInfoTypes_.isEmpty()) {
                        this.customInfoTypes_ = other.customInfoTypes_;
                        this.bitField0_ &= 0xFFFFFFDF;
                    } else {
                        this.ensureCustomInfoTypesIsMutable();
                        this.customInfoTypes_.addAll(other.customInfoTypes_);
                    }
                    this.onChanged();
                }
            } else if (!other.customInfoTypes_.isEmpty()) {
                if (this.customInfoTypesBuilder_.isEmpty()) {
                    this.customInfoTypesBuilder_.dispose();
                    this.customInfoTypesBuilder_ = null;
                    this.customInfoTypes_ = other.customInfoTypes_;
                    this.bitField0_ &= 0xFFFFFFDF;
                    this.customInfoTypesBuilder_ = alwaysUseFieldBuilders ? this.getCustomInfoTypesFieldBuilder() : null;
                } else {
                    this.customInfoTypesBuilder_.addAllMessages((Iterable)other.customInfoTypes_);
                }
            }
            if (!other.contentOptions_.isEmpty()) {
                if (this.contentOptions_.isEmpty()) {
                    this.contentOptions_ = other.contentOptions_;
                    this.bitField0_ &= 0xFFFFFFBF;
                } else {
                    this.ensureContentOptionsIsMutable();
                    this.contentOptions_.addAll(other.contentOptions_);
                }
                this.onChanged();
            }
            if (this.ruleSetBuilder_ == null) {
                if (!other.ruleSet_.isEmpty()) {
                    if (this.ruleSet_.isEmpty()) {
                        this.ruleSet_ = other.ruleSet_;
                        this.bitField0_ &= 0xFFFFFF7F;
                    } else {
                        this.ensureRuleSetIsMutable();
                        this.ruleSet_.addAll(other.ruleSet_);
                    }
                    this.onChanged();
                }
            } else if (!other.ruleSet_.isEmpty()) {
                if (this.ruleSetBuilder_.isEmpty()) {
                    this.ruleSetBuilder_.dispose();
                    this.ruleSetBuilder_ = null;
                    this.ruleSet_ = other.ruleSet_;
                    this.bitField0_ &= 0xFFFFFF7F;
                    this.ruleSetBuilder_ = alwaysUseFieldBuilders ? this.getRuleSetFieldBuilder() : null;
                } else {
                    this.ruleSetBuilder_.addAllMessages((Iterable)other.ruleSet_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block17: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block17;
                        }
                        case 10: {
                            InfoType m = (InfoType)input.readMessage(InfoType.parser(), extensionRegistry);
                            if (this.infoTypesBuilder_ == null) {
                                this.ensureInfoTypesIsMutable();
                                this.infoTypes_.add(m);
                                continue block17;
                            }
                            this.infoTypesBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                        case 16: {
                            this.minLikelihood_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block17;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getLimitsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block17;
                        }
                        case 32: {
                            this.includeQuote_ = input.readBool();
                            this.bitField0_ |= 8;
                            continue block17;
                        }
                        case 40: {
                            this.excludeInfoTypes_ = input.readBool();
                            this.bitField0_ |= 0x10;
                            continue block17;
                        }
                        case 50: {
                            CustomInfoType m = (CustomInfoType)input.readMessage(CustomInfoType.parser(), extensionRegistry);
                            if (this.customInfoTypesBuilder_ == null) {
                                this.ensureCustomInfoTypesIsMutable();
                                this.customInfoTypes_.add(m);
                                continue block17;
                            }
                            this.customInfoTypesBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                        case 64: {
                            int tmpRaw = input.readEnum();
                            this.ensureContentOptionsIsMutable();
                            this.contentOptions_.add(tmpRaw);
                            continue block17;
                        }
                        case 66: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureContentOptionsIsMutable();
                                this.contentOptions_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block17;
                        }
                        case 82: {
                            InspectionRuleSet m = (InspectionRuleSet)input.readMessage(InspectionRuleSet.parser(), extensionRegistry);
                            if (this.ruleSetBuilder_ == null) {
                                this.ensureRuleSetIsMutable();
                                this.ruleSet_.add(m);
                                continue block17;
                            }
                            this.ruleSetBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        private void ensureInfoTypesIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.infoTypes_ = new ArrayList<InfoType>(this.infoTypes_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<InfoType> getInfoTypesList() {
            if (this.infoTypesBuilder_ == null) {
                return Collections.unmodifiableList(this.infoTypes_);
            }
            return this.infoTypesBuilder_.getMessageList();
        }

        @Override
        public int getInfoTypesCount() {
            if (this.infoTypesBuilder_ == null) {
                return this.infoTypes_.size();
            }
            return this.infoTypesBuilder_.getCount();
        }

        @Override
        public InfoType getInfoTypes(int index) {
            if (this.infoTypesBuilder_ == null) {
                return this.infoTypes_.get(index);
            }
            return (InfoType)this.infoTypesBuilder_.getMessage(index);
        }

        public Builder setInfoTypes(int index, InfoType value) {
            if (this.infoTypesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInfoTypesIsMutable();
                this.infoTypes_.set(index, value);
                this.onChanged();
            } else {
                this.infoTypesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setInfoTypes(int index, InfoType.Builder builderForValue) {
            if (this.infoTypesBuilder_ == null) {
                this.ensureInfoTypesIsMutable();
                this.infoTypes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.infoTypesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addInfoTypes(InfoType value) {
            if (this.infoTypesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInfoTypesIsMutable();
                this.infoTypes_.add(value);
                this.onChanged();
            } else {
                this.infoTypesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addInfoTypes(int index, InfoType value) {
            if (this.infoTypesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInfoTypesIsMutable();
                this.infoTypes_.add(index, value);
                this.onChanged();
            } else {
                this.infoTypesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addInfoTypes(InfoType.Builder builderForValue) {
            if (this.infoTypesBuilder_ == null) {
                this.ensureInfoTypesIsMutable();
                this.infoTypes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.infoTypesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addInfoTypes(int index, InfoType.Builder builderForValue) {
            if (this.infoTypesBuilder_ == null) {
                this.ensureInfoTypesIsMutable();
                this.infoTypes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.infoTypesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllInfoTypes(Iterable<? extends InfoType> values) {
            if (this.infoTypesBuilder_ == null) {
                this.ensureInfoTypesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.infoTypes_);
                this.onChanged();
            } else {
                this.infoTypesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearInfoTypes() {
            if (this.infoTypesBuilder_ == null) {
                this.infoTypes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.infoTypesBuilder_.clear();
            }
            return this;
        }

        public Builder removeInfoTypes(int index) {
            if (this.infoTypesBuilder_ == null) {
                this.ensureInfoTypesIsMutable();
                this.infoTypes_.remove(index);
                this.onChanged();
            } else {
                this.infoTypesBuilder_.remove(index);
            }
            return this;
        }

        public InfoType.Builder getInfoTypesBuilder(int index) {
            return (InfoType.Builder)this.getInfoTypesFieldBuilder().getBuilder(index);
        }

        @Override
        public InfoTypeOrBuilder getInfoTypesOrBuilder(int index) {
            if (this.infoTypesBuilder_ == null) {
                return this.infoTypes_.get(index);
            }
            return (InfoTypeOrBuilder)this.infoTypesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends InfoTypeOrBuilder> getInfoTypesOrBuilderList() {
            if (this.infoTypesBuilder_ != null) {
                return this.infoTypesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.infoTypes_);
        }

        public InfoType.Builder addInfoTypesBuilder() {
            return (InfoType.Builder)this.getInfoTypesFieldBuilder().addBuilder((AbstractMessage)InfoType.getDefaultInstance());
        }

        public InfoType.Builder addInfoTypesBuilder(int index) {
            return (InfoType.Builder)this.getInfoTypesFieldBuilder().addBuilder(index, (AbstractMessage)InfoType.getDefaultInstance());
        }

        public List<InfoType.Builder> getInfoTypesBuilderList() {
            return this.getInfoTypesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<InfoType, InfoType.Builder, InfoTypeOrBuilder> getInfoTypesFieldBuilder() {
            if (this.infoTypesBuilder_ == null) {
                this.infoTypesBuilder_ = new RepeatedFieldBuilderV3(this.infoTypes_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.infoTypes_ = null;
            }
            return this.infoTypesBuilder_;
        }

        @Override
        public int getMinLikelihoodValue() {
            return this.minLikelihood_;
        }

        public Builder setMinLikelihoodValue(int value) {
            this.minLikelihood_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public Likelihood getMinLikelihood() {
            Likelihood result = Likelihood.forNumber(this.minLikelihood_);
            return result == null ? Likelihood.UNRECOGNIZED : result;
        }

        public Builder setMinLikelihood(Likelihood value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.minLikelihood_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearMinLikelihood() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.minLikelihood_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLimits() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public FindingLimits getLimits() {
            if (this.limitsBuilder_ == null) {
                return this.limits_ == null ? FindingLimits.getDefaultInstance() : this.limits_;
            }
            return (FindingLimits)this.limitsBuilder_.getMessage();
        }

        public Builder setLimits(FindingLimits value) {
            if (this.limitsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.limits_ = value;
            } else {
                this.limitsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setLimits(FindingLimits.Builder builderForValue) {
            if (this.limitsBuilder_ == null) {
                this.limits_ = builderForValue.build();
            } else {
                this.limitsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeLimits(FindingLimits value) {
            if (this.limitsBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.limits_ != null && this.limits_ != FindingLimits.getDefaultInstance()) {
                    this.getLimitsBuilder().mergeFrom(value);
                } else {
                    this.limits_ = value;
                }
            } else {
                this.limitsBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearLimits() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.limits_ = null;
            if (this.limitsBuilder_ != null) {
                this.limitsBuilder_.dispose();
                this.limitsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public FindingLimits.Builder getLimitsBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (FindingLimits.Builder)this.getLimitsFieldBuilder().getBuilder();
        }

        @Override
        public FindingLimitsOrBuilder getLimitsOrBuilder() {
            if (this.limitsBuilder_ != null) {
                return (FindingLimitsOrBuilder)this.limitsBuilder_.getMessageOrBuilder();
            }
            return this.limits_ == null ? FindingLimits.getDefaultInstance() : this.limits_;
        }

        private SingleFieldBuilderV3<FindingLimits, FindingLimits.Builder, FindingLimitsOrBuilder> getLimitsFieldBuilder() {
            if (this.limitsBuilder_ == null) {
                this.limitsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLimits(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.limits_ = null;
            }
            return this.limitsBuilder_;
        }

        @Override
        public boolean getIncludeQuote() {
            return this.includeQuote_;
        }

        public Builder setIncludeQuote(boolean value) {
            this.includeQuote_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearIncludeQuote() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.includeQuote_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getExcludeInfoTypes() {
            return this.excludeInfoTypes_;
        }

        public Builder setExcludeInfoTypes(boolean value) {
            this.excludeInfoTypes_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearExcludeInfoTypes() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.excludeInfoTypes_ = false;
            this.onChanged();
            return this;
        }

        private void ensureCustomInfoTypesIsMutable() {
            if ((this.bitField0_ & 0x20) == 0) {
                this.customInfoTypes_ = new ArrayList<CustomInfoType>(this.customInfoTypes_);
                this.bitField0_ |= 0x20;
            }
        }

        @Override
        public List<CustomInfoType> getCustomInfoTypesList() {
            if (this.customInfoTypesBuilder_ == null) {
                return Collections.unmodifiableList(this.customInfoTypes_);
            }
            return this.customInfoTypesBuilder_.getMessageList();
        }

        @Override
        public int getCustomInfoTypesCount() {
            if (this.customInfoTypesBuilder_ == null) {
                return this.customInfoTypes_.size();
            }
            return this.customInfoTypesBuilder_.getCount();
        }

        @Override
        public CustomInfoType getCustomInfoTypes(int index) {
            if (this.customInfoTypesBuilder_ == null) {
                return this.customInfoTypes_.get(index);
            }
            return (CustomInfoType)this.customInfoTypesBuilder_.getMessage(index);
        }

        public Builder setCustomInfoTypes(int index, CustomInfoType value) {
            if (this.customInfoTypesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCustomInfoTypesIsMutable();
                this.customInfoTypes_.set(index, value);
                this.onChanged();
            } else {
                this.customInfoTypesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setCustomInfoTypes(int index, CustomInfoType.Builder builderForValue) {
            if (this.customInfoTypesBuilder_ == null) {
                this.ensureCustomInfoTypesIsMutable();
                this.customInfoTypes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.customInfoTypesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addCustomInfoTypes(CustomInfoType value) {
            if (this.customInfoTypesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCustomInfoTypesIsMutable();
                this.customInfoTypes_.add(value);
                this.onChanged();
            } else {
                this.customInfoTypesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addCustomInfoTypes(int index, CustomInfoType value) {
            if (this.customInfoTypesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCustomInfoTypesIsMutable();
                this.customInfoTypes_.add(index, value);
                this.onChanged();
            } else {
                this.customInfoTypesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addCustomInfoTypes(CustomInfoType.Builder builderForValue) {
            if (this.customInfoTypesBuilder_ == null) {
                this.ensureCustomInfoTypesIsMutable();
                this.customInfoTypes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.customInfoTypesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addCustomInfoTypes(int index, CustomInfoType.Builder builderForValue) {
            if (this.customInfoTypesBuilder_ == null) {
                this.ensureCustomInfoTypesIsMutable();
                this.customInfoTypes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.customInfoTypesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllCustomInfoTypes(Iterable<? extends CustomInfoType> values) {
            if (this.customInfoTypesBuilder_ == null) {
                this.ensureCustomInfoTypesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.customInfoTypes_);
                this.onChanged();
            } else {
                this.customInfoTypesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearCustomInfoTypes() {
            if (this.customInfoTypesBuilder_ == null) {
                this.customInfoTypes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFDF;
                this.onChanged();
            } else {
                this.customInfoTypesBuilder_.clear();
            }
            return this;
        }

        public Builder removeCustomInfoTypes(int index) {
            if (this.customInfoTypesBuilder_ == null) {
                this.ensureCustomInfoTypesIsMutable();
                this.customInfoTypes_.remove(index);
                this.onChanged();
            } else {
                this.customInfoTypesBuilder_.remove(index);
            }
            return this;
        }

        public CustomInfoType.Builder getCustomInfoTypesBuilder(int index) {
            return (CustomInfoType.Builder)this.getCustomInfoTypesFieldBuilder().getBuilder(index);
        }

        @Override
        public CustomInfoTypeOrBuilder getCustomInfoTypesOrBuilder(int index) {
            if (this.customInfoTypesBuilder_ == null) {
                return this.customInfoTypes_.get(index);
            }
            return (CustomInfoTypeOrBuilder)this.customInfoTypesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends CustomInfoTypeOrBuilder> getCustomInfoTypesOrBuilderList() {
            if (this.customInfoTypesBuilder_ != null) {
                return this.customInfoTypesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.customInfoTypes_);
        }

        public CustomInfoType.Builder addCustomInfoTypesBuilder() {
            return (CustomInfoType.Builder)this.getCustomInfoTypesFieldBuilder().addBuilder((AbstractMessage)CustomInfoType.getDefaultInstance());
        }

        public CustomInfoType.Builder addCustomInfoTypesBuilder(int index) {
            return (CustomInfoType.Builder)this.getCustomInfoTypesFieldBuilder().addBuilder(index, (AbstractMessage)CustomInfoType.getDefaultInstance());
        }

        public List<CustomInfoType.Builder> getCustomInfoTypesBuilderList() {
            return this.getCustomInfoTypesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<CustomInfoType, CustomInfoType.Builder, CustomInfoTypeOrBuilder> getCustomInfoTypesFieldBuilder() {
            if (this.customInfoTypesBuilder_ == null) {
                this.customInfoTypesBuilder_ = new RepeatedFieldBuilderV3(this.customInfoTypes_, (this.bitField0_ & 0x20) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.customInfoTypes_ = null;
            }
            return this.customInfoTypesBuilder_;
        }

        private void ensureContentOptionsIsMutable() {
            if ((this.bitField0_ & 0x40) == 0) {
                this.contentOptions_ = new ArrayList<Integer>(this.contentOptions_);
                this.bitField0_ |= 0x40;
            }
        }

        @Override
        public List<ContentOption> getContentOptionsList() {
            return new Internal.ListAdapter(this.contentOptions_, contentOptions_converter_);
        }

        @Override
        public int getContentOptionsCount() {
            return this.contentOptions_.size();
        }

        @Override
        public ContentOption getContentOptions(int index) {
            return (ContentOption)((Object)contentOptions_converter_.convert((Object)this.contentOptions_.get(index)));
        }

        public Builder setContentOptions(int index, ContentOption value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureContentOptionsIsMutable();
            this.contentOptions_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addContentOptions(ContentOption value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureContentOptionsIsMutable();
            this.contentOptions_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllContentOptions(Iterable<? extends ContentOption> values) {
            this.ensureContentOptionsIsMutable();
            for (ContentOption contentOption : values) {
                this.contentOptions_.add(contentOption.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearContentOptions() {
            this.contentOptions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getContentOptionsValueList() {
            return Collections.unmodifiableList(this.contentOptions_);
        }

        @Override
        public int getContentOptionsValue(int index) {
            return this.contentOptions_.get(index);
        }

        public Builder setContentOptionsValue(int index, int value) {
            this.ensureContentOptionsIsMutable();
            this.contentOptions_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addContentOptionsValue(int value) {
            this.ensureContentOptionsIsMutable();
            this.contentOptions_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllContentOptionsValue(Iterable<Integer> values) {
            this.ensureContentOptionsIsMutable();
            for (int value : values) {
                this.contentOptions_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureRuleSetIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.ruleSet_ = new ArrayList<InspectionRuleSet>(this.ruleSet_);
                this.bitField0_ |= 0x80;
            }
        }

        @Override
        public List<InspectionRuleSet> getRuleSetList() {
            if (this.ruleSetBuilder_ == null) {
                return Collections.unmodifiableList(this.ruleSet_);
            }
            return this.ruleSetBuilder_.getMessageList();
        }

        @Override
        public int getRuleSetCount() {
            if (this.ruleSetBuilder_ == null) {
                return this.ruleSet_.size();
            }
            return this.ruleSetBuilder_.getCount();
        }

        @Override
        public InspectionRuleSet getRuleSet(int index) {
            if (this.ruleSetBuilder_ == null) {
                return this.ruleSet_.get(index);
            }
            return (InspectionRuleSet)this.ruleSetBuilder_.getMessage(index);
        }

        public Builder setRuleSet(int index, InspectionRuleSet value) {
            if (this.ruleSetBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRuleSetIsMutable();
                this.ruleSet_.set(index, value);
                this.onChanged();
            } else {
                this.ruleSetBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setRuleSet(int index, InspectionRuleSet.Builder builderForValue) {
            if (this.ruleSetBuilder_ == null) {
                this.ensureRuleSetIsMutable();
                this.ruleSet_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.ruleSetBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRuleSet(InspectionRuleSet value) {
            if (this.ruleSetBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRuleSetIsMutable();
                this.ruleSet_.add(value);
                this.onChanged();
            } else {
                this.ruleSetBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addRuleSet(int index, InspectionRuleSet value) {
            if (this.ruleSetBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRuleSetIsMutable();
                this.ruleSet_.add(index, value);
                this.onChanged();
            } else {
                this.ruleSetBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addRuleSet(InspectionRuleSet.Builder builderForValue) {
            if (this.ruleSetBuilder_ == null) {
                this.ensureRuleSetIsMutable();
                this.ruleSet_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.ruleSetBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRuleSet(int index, InspectionRuleSet.Builder builderForValue) {
            if (this.ruleSetBuilder_ == null) {
                this.ensureRuleSetIsMutable();
                this.ruleSet_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.ruleSetBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllRuleSet(Iterable<? extends InspectionRuleSet> values) {
            if (this.ruleSetBuilder_ == null) {
                this.ensureRuleSetIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.ruleSet_);
                this.onChanged();
            } else {
                this.ruleSetBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearRuleSet() {
            if (this.ruleSetBuilder_ == null) {
                this.ruleSet_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFF7F;
                this.onChanged();
            } else {
                this.ruleSetBuilder_.clear();
            }
            return this;
        }

        public Builder removeRuleSet(int index) {
            if (this.ruleSetBuilder_ == null) {
                this.ensureRuleSetIsMutable();
                this.ruleSet_.remove(index);
                this.onChanged();
            } else {
                this.ruleSetBuilder_.remove(index);
            }
            return this;
        }

        public InspectionRuleSet.Builder getRuleSetBuilder(int index) {
            return (InspectionRuleSet.Builder)this.getRuleSetFieldBuilder().getBuilder(index);
        }

        @Override
        public InspectionRuleSetOrBuilder getRuleSetOrBuilder(int index) {
            if (this.ruleSetBuilder_ == null) {
                return this.ruleSet_.get(index);
            }
            return (InspectionRuleSetOrBuilder)this.ruleSetBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends InspectionRuleSetOrBuilder> getRuleSetOrBuilderList() {
            if (this.ruleSetBuilder_ != null) {
                return this.ruleSetBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.ruleSet_);
        }

        public InspectionRuleSet.Builder addRuleSetBuilder() {
            return (InspectionRuleSet.Builder)this.getRuleSetFieldBuilder().addBuilder((AbstractMessage)InspectionRuleSet.getDefaultInstance());
        }

        public InspectionRuleSet.Builder addRuleSetBuilder(int index) {
            return (InspectionRuleSet.Builder)this.getRuleSetFieldBuilder().addBuilder(index, (AbstractMessage)InspectionRuleSet.getDefaultInstance());
        }

        public List<InspectionRuleSet.Builder> getRuleSetBuilderList() {
            return this.getRuleSetFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<InspectionRuleSet, InspectionRuleSet.Builder, InspectionRuleSetOrBuilder> getRuleSetFieldBuilder() {
            if (this.ruleSetBuilder_ == null) {
                this.ruleSetBuilder_ = new RepeatedFieldBuilderV3(this.ruleSet_, (this.bitField0_ & 0x80) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.ruleSet_ = null;
            }
            return this.ruleSetBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class FindingLimits
    extends GeneratedMessageV3
    implements FindingLimitsOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int MAX_FINDINGS_PER_ITEM_FIELD_NUMBER = 1;
        private int maxFindingsPerItem_ = 0;
        public static final int MAX_FINDINGS_PER_REQUEST_FIELD_NUMBER = 2;
        private int maxFindingsPerRequest_ = 0;
        public static final int MAX_FINDINGS_PER_INFO_TYPE_FIELD_NUMBER = 3;
        private List<InfoTypeLimit> maxFindingsPerInfoType_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final FindingLimits DEFAULT_INSTANCE = new FindingLimits();
        private static final Parser<FindingLimits> PARSER = new AbstractParser<FindingLimits>(){

            public FindingLimits parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = FindingLimits.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private FindingLimits(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private FindingLimits() {
            this.maxFindingsPerInfoType_ = Collections.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new FindingLimits();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_fieldAccessorTable.ensureFieldAccessorsInitialized(FindingLimits.class, Builder.class);
        }

        @Override
        public int getMaxFindingsPerItem() {
            return this.maxFindingsPerItem_;
        }

        @Override
        public int getMaxFindingsPerRequest() {
            return this.maxFindingsPerRequest_;
        }

        @Override
        public List<InfoTypeLimit> getMaxFindingsPerInfoTypeList() {
            return this.maxFindingsPerInfoType_;
        }

        @Override
        public List<? extends InfoTypeLimitOrBuilder> getMaxFindingsPerInfoTypeOrBuilderList() {
            return this.maxFindingsPerInfoType_;
        }

        @Override
        public int getMaxFindingsPerInfoTypeCount() {
            return this.maxFindingsPerInfoType_.size();
        }

        @Override
        public InfoTypeLimit getMaxFindingsPerInfoType(int index) {
            return this.maxFindingsPerInfoType_.get(index);
        }

        @Override
        public InfoTypeLimitOrBuilder getMaxFindingsPerInfoTypeOrBuilder(int index) {
            return this.maxFindingsPerInfoType_.get(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.maxFindingsPerItem_ != 0) {
                output.writeInt32(1, this.maxFindingsPerItem_);
            }
            if (this.maxFindingsPerRequest_ != 0) {
                output.writeInt32(2, this.maxFindingsPerRequest_);
            }
            for (int i = 0; i < this.maxFindingsPerInfoType_.size(); ++i) {
                output.writeMessage(3, (MessageLite)this.maxFindingsPerInfoType_.get(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.maxFindingsPerItem_ != 0) {
                size += CodedOutputStream.computeInt32Size((int)1, (int)this.maxFindingsPerItem_);
            }
            if (this.maxFindingsPerRequest_ != 0) {
                size += CodedOutputStream.computeInt32Size((int)2, (int)this.maxFindingsPerRequest_);
            }
            for (int i = 0; i < this.maxFindingsPerInfoType_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MessageLite)this.maxFindingsPerInfoType_.get(i)));
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FindingLimits)) {
                return super.equals(obj);
            }
            FindingLimits other = (FindingLimits)obj;
            if (this.getMaxFindingsPerItem() != other.getMaxFindingsPerItem()) {
                return false;
            }
            if (this.getMaxFindingsPerRequest() != other.getMaxFindingsPerRequest()) {
                return false;
            }
            if (!this.getMaxFindingsPerInfoTypeList().equals(other.getMaxFindingsPerInfoTypeList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + FindingLimits.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getMaxFindingsPerItem();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getMaxFindingsPerRequest();
            if (this.getMaxFindingsPerInfoTypeCount() > 0) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getMaxFindingsPerInfoTypeList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static FindingLimits parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (FindingLimits)PARSER.parseFrom(data);
        }

        public static FindingLimits parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (FindingLimits)PARSER.parseFrom(data, extensionRegistry);
        }

        public static FindingLimits parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (FindingLimits)PARSER.parseFrom(data);
        }

        public static FindingLimits parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (FindingLimits)PARSER.parseFrom(data, extensionRegistry);
        }

        public static FindingLimits parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (FindingLimits)PARSER.parseFrom(data);
        }

        public static FindingLimits parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (FindingLimits)PARSER.parseFrom(data, extensionRegistry);
        }

        public static FindingLimits parseFrom(InputStream input) throws IOException {
            return (FindingLimits)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static FindingLimits parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (FindingLimits)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static FindingLimits parseDelimitedFrom(InputStream input) throws IOException {
            return (FindingLimits)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static FindingLimits parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (FindingLimits)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static FindingLimits parseFrom(CodedInputStream input) throws IOException {
            return (FindingLimits)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static FindingLimits parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (FindingLimits)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return FindingLimits.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(FindingLimits prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static FindingLimits getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<FindingLimits> parser() {
            return PARSER;
        }

        public Parser<FindingLimits> getParserForType() {
            return PARSER;
        }

        public FindingLimits getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements FindingLimitsOrBuilder {
            private int bitField0_;
            private int maxFindingsPerItem_;
            private int maxFindingsPerRequest_;
            private List<InfoTypeLimit> maxFindingsPerInfoType_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<InfoTypeLimit, InfoTypeLimit.Builder, InfoTypeLimitOrBuilder> maxFindingsPerInfoTypeBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_fieldAccessorTable.ensureFieldAccessorsInitialized(FindingLimits.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.maxFindingsPerItem_ = 0;
                this.maxFindingsPerRequest_ = 0;
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    this.maxFindingsPerInfoType_ = Collections.emptyList();
                } else {
                    this.maxFindingsPerInfoType_ = null;
                    this.maxFindingsPerInfoTypeBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFFFFB;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_descriptor;
            }

            public FindingLimits getDefaultInstanceForType() {
                return FindingLimits.getDefaultInstance();
            }

            public FindingLimits build() {
                FindingLimits result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public FindingLimits buildPartial() {
                FindingLimits result = new FindingLimits(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(FindingLimits result) {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    if ((this.bitField0_ & 4) != 0) {
                        this.maxFindingsPerInfoType_ = Collections.unmodifiableList(this.maxFindingsPerInfoType_);
                        this.bitField0_ &= 0xFFFFFFFB;
                    }
                    result.maxFindingsPerInfoType_ = this.maxFindingsPerInfoType_;
                } else {
                    result.maxFindingsPerInfoType_ = this.maxFindingsPerInfoTypeBuilder_.build();
                }
            }

            private void buildPartial0(FindingLimits result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.maxFindingsPerItem_ = this.maxFindingsPerItem_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.maxFindingsPerRequest_ = this.maxFindingsPerRequest_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof FindingLimits) {
                    return this.mergeFrom((FindingLimits)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(FindingLimits other) {
                if (other == FindingLimits.getDefaultInstance()) {
                    return this;
                }
                if (other.getMaxFindingsPerItem() != 0) {
                    this.setMaxFindingsPerItem(other.getMaxFindingsPerItem());
                }
                if (other.getMaxFindingsPerRequest() != 0) {
                    this.setMaxFindingsPerRequest(other.getMaxFindingsPerRequest());
                }
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    if (!other.maxFindingsPerInfoType_.isEmpty()) {
                        if (this.maxFindingsPerInfoType_.isEmpty()) {
                            this.maxFindingsPerInfoType_ = other.maxFindingsPerInfoType_;
                            this.bitField0_ &= 0xFFFFFFFB;
                        } else {
                            this.ensureMaxFindingsPerInfoTypeIsMutable();
                            this.maxFindingsPerInfoType_.addAll(other.maxFindingsPerInfoType_);
                        }
                        this.onChanged();
                    }
                } else if (!other.maxFindingsPerInfoType_.isEmpty()) {
                    if (this.maxFindingsPerInfoTypeBuilder_.isEmpty()) {
                        this.maxFindingsPerInfoTypeBuilder_.dispose();
                        this.maxFindingsPerInfoTypeBuilder_ = null;
                        this.maxFindingsPerInfoType_ = other.maxFindingsPerInfoType_;
                        this.bitField0_ &= 0xFFFFFFFB;
                        this.maxFindingsPerInfoTypeBuilder_ = alwaysUseFieldBuilders ? this.getMaxFindingsPerInfoTypeFieldBuilder() : null;
                    } else {
                        this.maxFindingsPerInfoTypeBuilder_.addAllMessages((Iterable)other.maxFindingsPerInfoType_);
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block11: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block11;
                            }
                            case 8: {
                                this.maxFindingsPerItem_ = input.readInt32();
                                this.bitField0_ |= 1;
                                continue block11;
                            }
                            case 16: {
                                this.maxFindingsPerRequest_ = input.readInt32();
                                this.bitField0_ |= 2;
                                continue block11;
                            }
                            case 26: {
                                InfoTypeLimit m = (InfoTypeLimit)input.readMessage(InfoTypeLimit.parser(), extensionRegistry);
                                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                                    this.ensureMaxFindingsPerInfoTypeIsMutable();
                                    this.maxFindingsPerInfoType_.add(m);
                                    continue block11;
                                }
                                this.maxFindingsPerInfoTypeBuilder_.addMessage((AbstractMessage)m);
                                continue block11;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public int getMaxFindingsPerItem() {
                return this.maxFindingsPerItem_;
            }

            public Builder setMaxFindingsPerItem(int value) {
                this.maxFindingsPerItem_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearMaxFindingsPerItem() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.maxFindingsPerItem_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public int getMaxFindingsPerRequest() {
                return this.maxFindingsPerRequest_;
            }

            public Builder setMaxFindingsPerRequest(int value) {
                this.maxFindingsPerRequest_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearMaxFindingsPerRequest() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.maxFindingsPerRequest_ = 0;
                this.onChanged();
                return this;
            }

            private void ensureMaxFindingsPerInfoTypeIsMutable() {
                if ((this.bitField0_ & 4) == 0) {
                    this.maxFindingsPerInfoType_ = new ArrayList<InfoTypeLimit>(this.maxFindingsPerInfoType_);
                    this.bitField0_ |= 4;
                }
            }

            @Override
            public List<InfoTypeLimit> getMaxFindingsPerInfoTypeList() {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    return Collections.unmodifiableList(this.maxFindingsPerInfoType_);
                }
                return this.maxFindingsPerInfoTypeBuilder_.getMessageList();
            }

            @Override
            public int getMaxFindingsPerInfoTypeCount() {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    return this.maxFindingsPerInfoType_.size();
                }
                return this.maxFindingsPerInfoTypeBuilder_.getCount();
            }

            @Override
            public InfoTypeLimit getMaxFindingsPerInfoType(int index) {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    return this.maxFindingsPerInfoType_.get(index);
                }
                return (InfoTypeLimit)this.maxFindingsPerInfoTypeBuilder_.getMessage(index);
            }

            public Builder setMaxFindingsPerInfoType(int index, InfoTypeLimit value) {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureMaxFindingsPerInfoTypeIsMutable();
                    this.maxFindingsPerInfoType_.set(index, value);
                    this.onChanged();
                } else {
                    this.maxFindingsPerInfoTypeBuilder_.setMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder setMaxFindingsPerInfoType(int index, InfoTypeLimit.Builder builderForValue) {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    this.ensureMaxFindingsPerInfoTypeIsMutable();
                    this.maxFindingsPerInfoType_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.maxFindingsPerInfoTypeBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addMaxFindingsPerInfoType(InfoTypeLimit value) {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureMaxFindingsPerInfoTypeIsMutable();
                    this.maxFindingsPerInfoType_.add(value);
                    this.onChanged();
                } else {
                    this.maxFindingsPerInfoTypeBuilder_.addMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder addMaxFindingsPerInfoType(int index, InfoTypeLimit value) {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureMaxFindingsPerInfoTypeIsMutable();
                    this.maxFindingsPerInfoType_.add(index, value);
                    this.onChanged();
                } else {
                    this.maxFindingsPerInfoTypeBuilder_.addMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder addMaxFindingsPerInfoType(InfoTypeLimit.Builder builderForValue) {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    this.ensureMaxFindingsPerInfoTypeIsMutable();
                    this.maxFindingsPerInfoType_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.maxFindingsPerInfoTypeBuilder_.addMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addMaxFindingsPerInfoType(int index, InfoTypeLimit.Builder builderForValue) {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    this.ensureMaxFindingsPerInfoTypeIsMutable();
                    this.maxFindingsPerInfoType_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.maxFindingsPerInfoTypeBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllMaxFindingsPerInfoType(Iterable<? extends InfoTypeLimit> values) {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    this.ensureMaxFindingsPerInfoTypeIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.maxFindingsPerInfoType_);
                    this.onChanged();
                } else {
                    this.maxFindingsPerInfoTypeBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearMaxFindingsPerInfoType() {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    this.maxFindingsPerInfoType_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.onChanged();
                } else {
                    this.maxFindingsPerInfoTypeBuilder_.clear();
                }
                return this;
            }

            public Builder removeMaxFindingsPerInfoType(int index) {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    this.ensureMaxFindingsPerInfoTypeIsMutable();
                    this.maxFindingsPerInfoType_.remove(index);
                    this.onChanged();
                } else {
                    this.maxFindingsPerInfoTypeBuilder_.remove(index);
                }
                return this;
            }

            public InfoTypeLimit.Builder getMaxFindingsPerInfoTypeBuilder(int index) {
                return (InfoTypeLimit.Builder)this.getMaxFindingsPerInfoTypeFieldBuilder().getBuilder(index);
            }

            @Override
            public InfoTypeLimitOrBuilder getMaxFindingsPerInfoTypeOrBuilder(int index) {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    return this.maxFindingsPerInfoType_.get(index);
                }
                return (InfoTypeLimitOrBuilder)this.maxFindingsPerInfoTypeBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends InfoTypeLimitOrBuilder> getMaxFindingsPerInfoTypeOrBuilderList() {
                if (this.maxFindingsPerInfoTypeBuilder_ != null) {
                    return this.maxFindingsPerInfoTypeBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.maxFindingsPerInfoType_);
            }

            public InfoTypeLimit.Builder addMaxFindingsPerInfoTypeBuilder() {
                return (InfoTypeLimit.Builder)this.getMaxFindingsPerInfoTypeFieldBuilder().addBuilder((AbstractMessage)InfoTypeLimit.getDefaultInstance());
            }

            public InfoTypeLimit.Builder addMaxFindingsPerInfoTypeBuilder(int index) {
                return (InfoTypeLimit.Builder)this.getMaxFindingsPerInfoTypeFieldBuilder().addBuilder(index, (AbstractMessage)InfoTypeLimit.getDefaultInstance());
            }

            public List<InfoTypeLimit.Builder> getMaxFindingsPerInfoTypeBuilderList() {
                return this.getMaxFindingsPerInfoTypeFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<InfoTypeLimit, InfoTypeLimit.Builder, InfoTypeLimitOrBuilder> getMaxFindingsPerInfoTypeFieldBuilder() {
                if (this.maxFindingsPerInfoTypeBuilder_ == null) {
                    this.maxFindingsPerInfoTypeBuilder_ = new RepeatedFieldBuilderV3(this.maxFindingsPerInfoType_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.maxFindingsPerInfoType_ = null;
                }
                return this.maxFindingsPerInfoTypeBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static final class InfoTypeLimit
        extends GeneratedMessageV3
        implements InfoTypeLimitOrBuilder {
            private static final long serialVersionUID = 0L;
            public static final int INFO_TYPE_FIELD_NUMBER = 1;
            private InfoType infoType_;
            public static final int MAX_FINDINGS_FIELD_NUMBER = 2;
            private int maxFindings_ = 0;
            private byte memoizedIsInitialized = (byte)-1;
            private static final InfoTypeLimit DEFAULT_INSTANCE = new InfoTypeLimit();
            private static final Parser<InfoTypeLimit> PARSER = new AbstractParser<InfoTypeLimit>(){

                public InfoTypeLimit parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = InfoTypeLimit.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private InfoTypeLimit(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private InfoTypeLimit() {
            }

            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new InfoTypeLimit();
            }

            public final UnknownFieldSet getUnknownFields() {
                return this.unknownFields;
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_InfoTypeLimit_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_InfoTypeLimit_fieldAccessorTable.ensureFieldAccessorsInitialized(InfoTypeLimit.class, Builder.class);
            }

            @Override
            public boolean hasInfoType() {
                return this.infoType_ != null;
            }

            @Override
            public InfoType getInfoType() {
                return this.infoType_ == null ? InfoType.getDefaultInstance() : this.infoType_;
            }

            @Override
            public InfoTypeOrBuilder getInfoTypeOrBuilder() {
                return this.infoType_ == null ? InfoType.getDefaultInstance() : this.infoType_;
            }

            @Override
            public int getMaxFindings() {
                return this.maxFindings_;
            }

            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            public void writeTo(CodedOutputStream output) throws IOException {
                if (this.infoType_ != null) {
                    output.writeMessage(1, (MessageLite)this.getInfoType());
                }
                if (this.maxFindings_ != 0) {
                    output.writeInt32(2, this.maxFindings_);
                }
                this.getUnknownFields().writeTo(output);
            }

            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if (this.infoType_ != null) {
                    size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getInfoType());
                }
                if (this.maxFindings_ != 0) {
                    size += CodedOutputStream.computeInt32Size((int)2, (int)this.maxFindings_);
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof InfoTypeLimit)) {
                    return super.equals(obj);
                }
                InfoTypeLimit other = (InfoTypeLimit)obj;
                if (this.hasInfoType() != other.hasInfoType()) {
                    return false;
                }
                if (this.hasInfoType() && !this.getInfoType().equals(other.getInfoType())) {
                    return false;
                }
                if (this.getMaxFindings() != other.getMaxFindings()) {
                    return false;
                }
                return this.getUnknownFields().equals((Object)other.getUnknownFields());
            }

            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + InfoTypeLimit.getDescriptor().hashCode();
                if (this.hasInfoType()) {
                    hash = 37 * hash + 1;
                    hash = 53 * hash + this.getInfoType().hashCode();
                }
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getMaxFindings();
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static InfoTypeLimit parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return (InfoTypeLimit)PARSER.parseFrom(data);
            }

            public static InfoTypeLimit parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (InfoTypeLimit)PARSER.parseFrom(data, extensionRegistry);
            }

            public static InfoTypeLimit parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return (InfoTypeLimit)PARSER.parseFrom(data);
            }

            public static InfoTypeLimit parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (InfoTypeLimit)PARSER.parseFrom(data, extensionRegistry);
            }

            public static InfoTypeLimit parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return (InfoTypeLimit)PARSER.parseFrom(data);
            }

            public static InfoTypeLimit parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (InfoTypeLimit)PARSER.parseFrom(data, extensionRegistry);
            }

            public static InfoTypeLimit parseFrom(InputStream input) throws IOException {
                return (InfoTypeLimit)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
            }

            public static InfoTypeLimit parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (InfoTypeLimit)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static InfoTypeLimit parseDelimitedFrom(InputStream input) throws IOException {
                return (InfoTypeLimit)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
            }

            public static InfoTypeLimit parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (InfoTypeLimit)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static InfoTypeLimit parseFrom(CodedInputStream input) throws IOException {
                return (InfoTypeLimit)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
            }

            public static InfoTypeLimit parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (InfoTypeLimit)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public Builder newBuilderForType() {
                return InfoTypeLimit.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(InfoTypeLimit prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static InfoTypeLimit getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<InfoTypeLimit> parser() {
                return PARSER;
            }

            public Parser<InfoTypeLimit> getParserForType() {
                return PARSER;
            }

            public InfoTypeLimit getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements InfoTypeLimitOrBuilder {
                private int bitField0_;
                private InfoType infoType_;
                private SingleFieldBuilderV3<InfoType, InfoType.Builder, InfoTypeOrBuilder> infoTypeBuilder_;
                private int maxFindings_;

                public static final Descriptors.Descriptor getDescriptor() {
                    return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_InfoTypeLimit_descriptor;
                }

                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_InfoTypeLimit_fieldAccessorTable.ensureFieldAccessorsInitialized(InfoTypeLimit.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                }

                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    this.infoType_ = null;
                    if (this.infoTypeBuilder_ != null) {
                        this.infoTypeBuilder_.dispose();
                        this.infoTypeBuilder_ = null;
                    }
                    this.maxFindings_ = 0;
                    return this;
                }

                public Descriptors.Descriptor getDescriptorForType() {
                    return DlpProto.internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_InfoTypeLimit_descriptor;
                }

                public InfoTypeLimit getDefaultInstanceForType() {
                    return InfoTypeLimit.getDefaultInstance();
                }

                public InfoTypeLimit build() {
                    InfoTypeLimit result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException((Message)result);
                    }
                    return result;
                }

                public InfoTypeLimit buildPartial() {
                    InfoTypeLimit result = new InfoTypeLimit(this);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.onBuilt();
                    return result;
                }

                private void buildPartial0(InfoTypeLimit result) {
                    int from_bitField0_ = this.bitField0_;
                    if ((from_bitField0_ & 1) != 0) {
                        result.infoType_ = this.infoTypeBuilder_ == null ? this.infoType_ : (InfoType)this.infoTypeBuilder_.build();
                    }
                    if ((from_bitField0_ & 2) != 0) {
                        result.maxFindings_ = this.maxFindings_;
                    }
                }

                public Builder clone() {
                    return (Builder)super.clone();
                }

                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                public Builder mergeFrom(Message other) {
                    if (other instanceof InfoTypeLimit) {
                        return this.mergeFrom((InfoTypeLimit)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(InfoTypeLimit other) {
                    if (other == InfoTypeLimit.getDefaultInstance()) {
                        return this;
                    }
                    if (other.hasInfoType()) {
                        this.mergeInfoType(other.getInfoType());
                    }
                    if (other.getMaxFindings() != 0) {
                        this.setMaxFindings(other.getMaxFindings());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                public final boolean isInitialized() {
                    return true;
                }

                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block10: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block10;
                                }
                                case 10: {
                                    input.readMessage((MessageLite.Builder)this.getInfoTypeFieldBuilder().getBuilder(), extensionRegistry);
                                    this.bitField0_ |= 1;
                                    continue block10;
                                }
                                case 16: {
                                    this.maxFindings_ = input.readInt32();
                                    this.bitField0_ |= 2;
                                    continue block10;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public boolean hasInfoType() {
                    return (this.bitField0_ & 1) != 0;
                }

                @Override
                public InfoType getInfoType() {
                    if (this.infoTypeBuilder_ == null) {
                        return this.infoType_ == null ? InfoType.getDefaultInstance() : this.infoType_;
                    }
                    return (InfoType)this.infoTypeBuilder_.getMessage();
                }

                public Builder setInfoType(InfoType value) {
                    if (this.infoTypeBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.infoType_ = value;
                    } else {
                        this.infoTypeBuilder_.setMessage((AbstractMessage)value);
                    }
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder setInfoType(InfoType.Builder builderForValue) {
                    if (this.infoTypeBuilder_ == null) {
                        this.infoType_ = builderForValue.build();
                    } else {
                        this.infoTypeBuilder_.setMessage((AbstractMessage)builderForValue.build());
                    }
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder mergeInfoType(InfoType value) {
                    if (this.infoTypeBuilder_ == null) {
                        if ((this.bitField0_ & 1) != 0 && this.infoType_ != null && this.infoType_ != InfoType.getDefaultInstance()) {
                            this.getInfoTypeBuilder().mergeFrom(value);
                        } else {
                            this.infoType_ = value;
                        }
                    } else {
                        this.infoTypeBuilder_.mergeFrom((AbstractMessage)value);
                    }
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder clearInfoType() {
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.infoType_ = null;
                    if (this.infoTypeBuilder_ != null) {
                        this.infoTypeBuilder_.dispose();
                        this.infoTypeBuilder_ = null;
                    }
                    this.onChanged();
                    return this;
                }

                public InfoType.Builder getInfoTypeBuilder() {
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return (InfoType.Builder)this.getInfoTypeFieldBuilder().getBuilder();
                }

                @Override
                public InfoTypeOrBuilder getInfoTypeOrBuilder() {
                    if (this.infoTypeBuilder_ != null) {
                        return (InfoTypeOrBuilder)this.infoTypeBuilder_.getMessageOrBuilder();
                    }
                    return this.infoType_ == null ? InfoType.getDefaultInstance() : this.infoType_;
                }

                private SingleFieldBuilderV3<InfoType, InfoType.Builder, InfoTypeOrBuilder> getInfoTypeFieldBuilder() {
                    if (this.infoTypeBuilder_ == null) {
                        this.infoTypeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getInfoType(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                        this.infoType_ = null;
                    }
                    return this.infoTypeBuilder_;
                }

                @Override
                public int getMaxFindings() {
                    return this.maxFindings_;
                }

                public Builder setMaxFindings(int value) {
                    this.maxFindings_ = value;
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                public Builder clearMaxFindings() {
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.maxFindings_ = 0;
                    this.onChanged();
                    return this;
                }

                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }
        }

        public static interface InfoTypeLimitOrBuilder
        extends MessageOrBuilder {
            public boolean hasInfoType();

            public InfoType getInfoType();

            public InfoTypeOrBuilder getInfoTypeOrBuilder();

            public int getMaxFindings();
        }
    }

    public static interface FindingLimitsOrBuilder
    extends MessageOrBuilder {
        public int getMaxFindingsPerItem();

        public int getMaxFindingsPerRequest();

        public List<FindingLimits.InfoTypeLimit> getMaxFindingsPerInfoTypeList();

        public FindingLimits.InfoTypeLimit getMaxFindingsPerInfoType(int var1);

        public int getMaxFindingsPerInfoTypeCount();

        public List<? extends FindingLimits.InfoTypeLimitOrBuilder> getMaxFindingsPerInfoTypeOrBuilderList();

        public FindingLimits.InfoTypeLimitOrBuilder getMaxFindingsPerInfoTypeOrBuilder(int var1);
    }
}

