/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.dlp.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FindingName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FINDING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/findings/{finding}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String finding;

    @Deprecated
    protected FindingName() {
        this.project = null;
        this.location = null;
        this.finding = null;
    }

    private FindingName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFinding() {
        return this.finding;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FindingName of(String project, String location, String finding) {
        return FindingName.newBuilder().setProject(project).setLocation(location).setFinding(finding).build();
    }

    public static String format(String project, String location, String finding) {
        return FindingName.newBuilder().setProject(project).setLocation(location).setFinding(finding).build().toString();
    }

    public static FindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FINDING.validatedMatch(formattedString, "FindingName.parse: formattedString not in valid format");
        return FindingName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("finding"));
    }

    public static List<FindingName> parseList(List<String> formattedStrings) {
        ArrayList<FindingName> list = new ArrayList<FindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FindingName findingName = this;
            synchronized (findingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.finding != null) {
                        fieldMapBuilder.put((Object)"finding", (Object)this.finding);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FINDING.instantiate(new String[]{"project", this.project, "location", this.location, "finding", this.finding});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            FindingName that = (FindingName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.finding, that.finding);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.finding);
    }

    public static class Builder {
        private String project;
        private String location;
        private String finding;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFinding() {
            return this.finding;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        private Builder(FindingName findingName) {
            this.project = findingName.project;
            this.location = findingName.location;
            this.finding = findingName.finding;
        }

        public FindingName build() {
            return new FindingName(this);
        }
    }
}

