/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/search_service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Response message for
 * [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse}
 */
public final class SearchResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse)
    SearchResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchResponse.newBuilder() to construct.
  private SearchResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchResponse() {
    results_ = java.util.Collections.emptyList();
    facets_ = java.util.Collections.emptyList();
    attributionToken_ = "";
    redirectUri_ = "";
    nextPageToken_ = "";
    correctedQuery_ = "";
    appliedControls_ = com.google.protobuf.LazyStringArrayList.emptyList();
    geoSearchDebugInfo_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.class,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Builder.class);
  }

  public interface SearchResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * [Document.id][google.cloud.discoveryengine.v1beta.Document.id] of the
     * searched [Document][google.cloud.discoveryengine.v1beta.Document].
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * [Document.id][google.cloud.discoveryengine.v1beta.Document.id] of the
     * searched [Document][google.cloud.discoveryengine.v1beta.Document].
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * The document data snippet in the search response. Only fields that are
     * marked as `retrievable` are populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
     *
     * @return Whether the document field is set.
     */
    boolean hasDocument();
    /**
     *
     *
     * <pre>
     * The document data snippet in the search response. Only fields that are
     * marked as `retrievable` are populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
     *
     * @return The document.
     */
    com.google.cloud.discoveryengine.v1beta.Document getDocument();
    /**
     *
     *
     * <pre>
     * The document data snippet in the search response. Only fields that are
     * marked as `retrievable` are populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
     */
    com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder getDocumentOrBuilder();

    /**
     *
     *
     * <pre>
     * The chunk data in the search response if the
     * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
     * is set to
     * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
     *
     * @return Whether the chunk field is set.
     */
    boolean hasChunk();
    /**
     *
     *
     * <pre>
     * The chunk data in the search response if the
     * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
     * is set to
     * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
     *
     * @return The chunk.
     */
    com.google.cloud.discoveryengine.v1beta.Chunk getChunk();
    /**
     *
     *
     * <pre>
     * The chunk data in the search response if the
     * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
     * is set to
     * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
     */
    com.google.cloud.discoveryengine.v1beta.ChunkOrBuilder getChunkOrBuilder();

    /**
     *
     *
     * <pre>
     * Google provided available scores.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
     * </code>
     */
    int getModelScoresCount();
    /**
     *
     *
     * <pre>
     * Google provided available scores.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
     * </code>
     */
    boolean containsModelScores(java.lang.String key);
    /** Use {@link #getModelScoresMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
        getModelScores();
    /**
     *
     *
     * <pre>
     * Google provided available scores.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
     * </code>
     */
    java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
        getModelScoresMap();
    /**
     *
     *
     * <pre>
     * Google provided available scores.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
     * </code>
     */
    /* nullable */
    com.google.cloud.discoveryengine.v1beta.DoubleList getModelScoresOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.discoveryengine.v1beta.DoubleList defaultValue);
    /**
     *
     *
     * <pre>
     * Google provided available scores.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.DoubleList getModelScoresOrThrow(java.lang.String key);
  }
  /**
   *
   *
   * <pre>
   * Represents the search results.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult}
   */
  public static final class SearchResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult)
      SearchResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SearchResult.newBuilder() to construct.
    private SearchResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SearchResult() {
      id_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SearchResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_SearchResult_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetModelScores();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_SearchResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult.class,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult.Builder.class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * [Document.id][google.cloud.discoveryengine.v1beta.Document.id] of the
     * searched [Document][google.cloud.discoveryengine.v1beta.Document].
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * [Document.id][google.cloud.discoveryengine.v1beta.Document.id] of the
     * searched [Document][google.cloud.discoveryengine.v1beta.Document].
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DOCUMENT_FIELD_NUMBER = 2;
    private com.google.cloud.discoveryengine.v1beta.Document document_;
    /**
     *
     *
     * <pre>
     * The document data snippet in the search response. Only fields that are
     * marked as `retrievable` are populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
     *
     * @return Whether the document field is set.
     */
    @java.lang.Override
    public boolean hasDocument() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The document data snippet in the search response. Only fields that are
     * marked as `retrievable` are populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
     *
     * @return The document.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Document getDocument() {
      return document_ == null
          ? com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()
          : document_;
    }
    /**
     *
     *
     * <pre>
     * The document data snippet in the search response. Only fields that are
     * marked as `retrievable` are populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder getDocumentOrBuilder() {
      return document_ == null
          ? com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()
          : document_;
    }

    public static final int CHUNK_FIELD_NUMBER = 18;
    private com.google.cloud.discoveryengine.v1beta.Chunk chunk_;
    /**
     *
     *
     * <pre>
     * The chunk data in the search response if the
     * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
     * is set to
     * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
     *
     * @return Whether the chunk field is set.
     */
    @java.lang.Override
    public boolean hasChunk() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The chunk data in the search response if the
     * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
     * is set to
     * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
     *
     * @return The chunk.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.Chunk getChunk() {
      return chunk_ == null
          ? com.google.cloud.discoveryengine.v1beta.Chunk.getDefaultInstance()
          : chunk_;
    }
    /**
     *
     *
     * <pre>
     * The chunk data in the search response if the
     * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
     * is set to
     * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.ChunkOrBuilder getChunkOrBuilder() {
      return chunk_ == null
          ? com.google.cloud.discoveryengine.v1beta.Chunk.getDefaultInstance()
          : chunk_;
    }

    public static final int MODEL_SCORES_FIELD_NUMBER = 4;

    private static final class ModelScoresDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
                      newDefaultInstance(
                          com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_SearchResult_ModelScoresEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.discoveryengine.v1beta.DoubleList.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
        modelScores_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
        internalGetModelScores() {
      if (modelScores_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ModelScoresDefaultEntryHolder.defaultEntry);
      }
      return modelScores_;
    }

    public int getModelScoresCount() {
      return internalGetModelScores().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Google provided available scores.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
     * </code>
     */
    @java.lang.Override
    public boolean containsModelScores(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetModelScores().getMap().containsKey(key);
    }
    /** Use {@link #getModelScoresMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
        getModelScores() {
      return getModelScoresMap();
    }
    /**
     *
     *
     * <pre>
     * Google provided available scores.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
        getModelScoresMap() {
      return internalGetModelScores().getMap();
    }
    /**
     *
     *
     * <pre>
     * Google provided available scores.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.discoveryengine.v1beta.DoubleList
        getModelScoresOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.discoveryengine.v1beta.DoubleList defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList> map =
          internalGetModelScores().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Google provided available scores.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.DoubleList getModelScoresOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList> map =
          internalGetModelScores().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getDocument());
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetModelScores(), ModelScoresDefaultEntryHolder.defaultEntry, 4);
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(18, getChunk());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDocument());
      }
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
          entry : internalGetModelScores().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
            modelScores__ =
                ModelScoresDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, modelScores__);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getChunk());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult other =
          (com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult) obj;

      if (!getId().equals(other.getId())) return false;
      if (hasDocument() != other.hasDocument()) return false;
      if (hasDocument()) {
        if (!getDocument().equals(other.getDocument())) return false;
      }
      if (hasChunk() != other.hasChunk()) return false;
      if (hasChunk()) {
        if (!getChunk().equals(other.getChunk())) return false;
      }
      if (!internalGetModelScores().equals(other.internalGetModelScores())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (hasDocument()) {
        hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getDocument().hashCode();
      }
      if (hasChunk()) {
        hash = (37 * hash) + CHUNK_FIELD_NUMBER;
        hash = (53 * hash) + getChunk().hashCode();
      }
      if (!internalGetModelScores().getMap().isEmpty()) {
        hash = (37 * hash) + MODEL_SCORES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetModelScores().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents the search results.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult)
        com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_SearchResult_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 4:
            return internalGetModelScores();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 4:
            return internalGetMutableModelScores();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_SearchResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult.class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDocumentFieldBuilder();
          getChunkFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        document_ = null;
        if (documentBuilder_ != null) {
          documentBuilder_.dispose();
          documentBuilder_ = null;
        }
        chunk_ = null;
        if (chunkBuilder_ != null) {
          chunkBuilder_.dispose();
          chunkBuilder_ = null;
        }
        internalGetMutableModelScores().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_SearchResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult build() {
        com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult result =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.document_ = documentBuilder_ == null ? document_ : documentBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.chunk_ = chunkBuilder_ == null ? chunk_ : chunkBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.modelScores_ =
              internalGetModelScores().build(ModelScoresDefaultEntryHolder.defaultEntry);
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult
                .getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasDocument()) {
          mergeDocument(other.getDocument());
        }
        if (other.hasChunk()) {
          mergeChunk(other.getChunk());
        }
        internalGetMutableModelScores().mergeFrom(other.internalGetModelScores());
        bitField0_ |= 0x00000008;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 34:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
                      modelScores__ =
                          input.readMessage(
                              ModelScoresDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableModelScores()
                      .ensureBuilderMap()
                      .put(modelScores__.getKey(), modelScores__.getValue());
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 146:
                {
                  input.readMessage(getChunkFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 146
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * [Document.id][google.cloud.discoveryengine.v1beta.Document.id] of the
       * searched [Document][google.cloud.discoveryengine.v1beta.Document].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Document.id][google.cloud.discoveryengine.v1beta.Document.id] of the
       * searched [Document][google.cloud.discoveryengine.v1beta.Document].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Document.id][google.cloud.discoveryengine.v1beta.Document.id] of the
       * searched [Document][google.cloud.discoveryengine.v1beta.Document].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Document.id][google.cloud.discoveryengine.v1beta.Document.id] of the
       * searched [Document][google.cloud.discoveryengine.v1beta.Document].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Document.id][google.cloud.discoveryengine.v1beta.Document.id] of the
       * searched [Document][google.cloud.discoveryengine.v1beta.Document].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.discoveryengine.v1beta.Document document_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Document,
              com.google.cloud.discoveryengine.v1beta.Document.Builder,
              com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>
          documentBuilder_;
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as `retrievable` are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
       *
       * @return Whether the document field is set.
       */
      public boolean hasDocument() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as `retrievable` are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
       *
       * @return The document.
       */
      public com.google.cloud.discoveryengine.v1beta.Document getDocument() {
        if (documentBuilder_ == null) {
          return document_ == null
              ? com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()
              : document_;
        } else {
          return documentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as `retrievable` are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
       */
      public Builder setDocument(com.google.cloud.discoveryengine.v1beta.Document value) {
        if (documentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          document_ = value;
        } else {
          documentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as `retrievable` are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
       */
      public Builder setDocument(
          com.google.cloud.discoveryengine.v1beta.Document.Builder builderForValue) {
        if (documentBuilder_ == null) {
          document_ = builderForValue.build();
        } else {
          documentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as `retrievable` are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
       */
      public Builder mergeDocument(com.google.cloud.discoveryengine.v1beta.Document value) {
        if (documentBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && document_ != null
              && document_
                  != com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()) {
            getDocumentBuilder().mergeFrom(value);
          } else {
            document_ = value;
          }
        } else {
          documentBuilder_.mergeFrom(value);
        }
        if (document_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as `retrievable` are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
       */
      public Builder clearDocument() {
        bitField0_ = (bitField0_ & ~0x00000002);
        document_ = null;
        if (documentBuilder_ != null) {
          documentBuilder_.dispose();
          documentBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as `retrievable` are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1beta.Document.Builder getDocumentBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDocumentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as `retrievable` are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder getDocumentOrBuilder() {
        if (documentBuilder_ != null) {
          return documentBuilder_.getMessageOrBuilder();
        } else {
          return document_ == null
              ? com.google.cloud.discoveryengine.v1beta.Document.getDefaultInstance()
              : document_;
        }
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as `retrievable` are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Document document = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Document,
              com.google.cloud.discoveryengine.v1beta.Document.Builder,
              com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>
          getDocumentFieldBuilder() {
        if (documentBuilder_ == null) {
          documentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.Document,
                  com.google.cloud.discoveryengine.v1beta.Document.Builder,
                  com.google.cloud.discoveryengine.v1beta.DocumentOrBuilder>(
                  getDocument(), getParentForChildren(), isClean());
          document_ = null;
        }
        return documentBuilder_;
      }

      private com.google.cloud.discoveryengine.v1beta.Chunk chunk_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Chunk,
              com.google.cloud.discoveryengine.v1beta.Chunk.Builder,
              com.google.cloud.discoveryengine.v1beta.ChunkOrBuilder>
          chunkBuilder_;
      /**
       *
       *
       * <pre>
       * The chunk data in the search response if the
       * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
       * is set to
       * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
       *
       * @return Whether the chunk field is set.
       */
      public boolean hasChunk() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The chunk data in the search response if the
       * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
       * is set to
       * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
       *
       * @return The chunk.
       */
      public com.google.cloud.discoveryengine.v1beta.Chunk getChunk() {
        if (chunkBuilder_ == null) {
          return chunk_ == null
              ? com.google.cloud.discoveryengine.v1beta.Chunk.getDefaultInstance()
              : chunk_;
        } else {
          return chunkBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The chunk data in the search response if the
       * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
       * is set to
       * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
       */
      public Builder setChunk(com.google.cloud.discoveryengine.v1beta.Chunk value) {
        if (chunkBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          chunk_ = value;
        } else {
          chunkBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The chunk data in the search response if the
       * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
       * is set to
       * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
       */
      public Builder setChunk(
          com.google.cloud.discoveryengine.v1beta.Chunk.Builder builderForValue) {
        if (chunkBuilder_ == null) {
          chunk_ = builderForValue.build();
        } else {
          chunkBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The chunk data in the search response if the
       * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
       * is set to
       * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
       */
      public Builder mergeChunk(com.google.cloud.discoveryengine.v1beta.Chunk value) {
        if (chunkBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && chunk_ != null
              && chunk_ != com.google.cloud.discoveryengine.v1beta.Chunk.getDefaultInstance()) {
            getChunkBuilder().mergeFrom(value);
          } else {
            chunk_ = value;
          }
        } else {
          chunkBuilder_.mergeFrom(value);
        }
        if (chunk_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The chunk data in the search response if the
       * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
       * is set to
       * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
       */
      public Builder clearChunk() {
        bitField0_ = (bitField0_ & ~0x00000004);
        chunk_ = null;
        if (chunkBuilder_ != null) {
          chunkBuilder_.dispose();
          chunkBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The chunk data in the search response if the
       * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
       * is set to
       * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
       */
      public com.google.cloud.discoveryengine.v1beta.Chunk.Builder getChunkBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getChunkFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The chunk data in the search response if the
       * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
       * is set to
       * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
       */
      public com.google.cloud.discoveryengine.v1beta.ChunkOrBuilder getChunkOrBuilder() {
        if (chunkBuilder_ != null) {
          return chunkBuilder_.getMessageOrBuilder();
        } else {
          return chunk_ == null
              ? com.google.cloud.discoveryengine.v1beta.Chunk.getDefaultInstance()
              : chunk_;
        }
      }
      /**
       *
       *
       * <pre>
       * The chunk data in the search response if the
       * [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.search_result_mode]
       * is set to
       * [CHUNKS][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Chunk chunk = 18;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.Chunk,
              com.google.cloud.discoveryengine.v1beta.Chunk.Builder,
              com.google.cloud.discoveryengine.v1beta.ChunkOrBuilder>
          getChunkFieldBuilder() {
        if (chunkBuilder_ == null) {
          chunkBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.Chunk,
                  com.google.cloud.discoveryengine.v1beta.Chunk.Builder,
                  com.google.cloud.discoveryengine.v1beta.ChunkOrBuilder>(
                  getChunk(), getParentForChildren(), isClean());
          chunk_ = null;
        }
        return chunkBuilder_;
      }

      private static final class ModelScoresConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.DoubleListOrBuilder,
              com.google.cloud.discoveryengine.v1beta.DoubleList> {
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.DoubleList build(
            com.google.cloud.discoveryengine.v1beta.DoubleListOrBuilder val) {
          if (val instanceof com.google.cloud.discoveryengine.v1beta.DoubleList) {
            return (com.google.cloud.discoveryengine.v1beta.DoubleList) val;
          }
          return ((com.google.cloud.discoveryengine.v1beta.DoubleList.Builder) val).build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
            defaultEntry() {
          return ModelScoresDefaultEntryHolder.defaultEntry;
        }
      };

      private static final ModelScoresConverter modelScoresConverter = new ModelScoresConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.DoubleListOrBuilder,
              com.google.cloud.discoveryengine.v1beta.DoubleList,
              com.google.cloud.discoveryengine.v1beta.DoubleList.Builder>
          modelScores_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.DoubleListOrBuilder,
              com.google.cloud.discoveryengine.v1beta.DoubleList,
              com.google.cloud.discoveryengine.v1beta.DoubleList.Builder>
          internalGetModelScores() {
        if (modelScores_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(modelScoresConverter);
        }
        return modelScores_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.cloud.discoveryengine.v1beta.DoubleListOrBuilder,
              com.google.cloud.discoveryengine.v1beta.DoubleList,
              com.google.cloud.discoveryengine.v1beta.DoubleList.Builder>
          internalGetMutableModelScores() {
        if (modelScores_ == null) {
          modelScores_ = new com.google.protobuf.MapFieldBuilder<>(modelScoresConverter);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return modelScores_;
      }

      public int getModelScoresCount() {
        return internalGetModelScores().ensureBuilderMap().size();
      }
      /**
       *
       *
       * <pre>
       * Google provided available scores.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
       * </code>
       */
      @java.lang.Override
      public boolean containsModelScores(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetModelScores().ensureBuilderMap().containsKey(key);
      }
      /** Use {@link #getModelScoresMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
          getModelScores() {
        return getModelScoresMap();
      }
      /**
       *
       *
       * <pre>
       * Google provided available scores.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
          getModelScoresMap() {
        return internalGetModelScores().getImmutableMap();
      }
      /**
       *
       *
       * <pre>
       * Google provided available scores.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.discoveryengine.v1beta.DoubleList
          getModelScoresOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.discoveryengine.v1beta.DoubleList defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleListOrBuilder>
            map = internalGetMutableModelScores().ensureBuilderMap();
        return map.containsKey(key) ? modelScoresConverter.build(map.get(key)) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Google provided available scores.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.DoubleList getModelScoresOrThrow(
          java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleListOrBuilder>
            map = internalGetMutableModelScores().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return modelScoresConverter.build(map.get(key));
      }

      public Builder clearModelScores() {
        bitField0_ = (bitField0_ & ~0x00000008);
        internalGetMutableModelScores().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google provided available scores.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
       * </code>
       */
      public Builder removeModelScores(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableModelScores().ensureBuilderMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
          getMutableModelScores() {
        bitField0_ |= 0x00000008;
        return internalGetMutableModelScores().ensureMessageMap();
      }
      /**
       *
       *
       * <pre>
       * Google provided available scores.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
       * </code>
       */
      public Builder putModelScores(
          java.lang.String key, com.google.cloud.discoveryengine.v1beta.DoubleList value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableModelScores().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google provided available scores.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
       * </code>
       */
      public Builder putAllModelScores(
          java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
              values) {
        for (java.util.Map.Entry<
                java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleList>
            e : values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableModelScores().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Google provided available scores.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.DoubleList&gt; model_scores = 4;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.DoubleList.Builder
          putModelScoresBuilderIfAbsent(java.lang.String key) {
        java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.DoubleListOrBuilder>
            builderMap = internalGetMutableModelScores().ensureBuilderMap();
        com.google.cloud.discoveryengine.v1beta.DoubleListOrBuilder entry = builderMap.get(key);
        if (entry == null) {
          entry = com.google.cloud.discoveryengine.v1beta.DoubleList.newBuilder();
          builderMap.put(key, entry);
        }
        if (entry instanceof com.google.cloud.discoveryengine.v1beta.DoubleList) {
          entry = ((com.google.cloud.discoveryengine.v1beta.DoubleList) entry).toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.cloud.discoveryengine.v1beta.DoubleList.Builder) entry;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult)
    private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SearchResult> PARSER =
        new com.google.protobuf.AbstractParser<SearchResult>() {
          @java.lang.Override
          public SearchResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SearchResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SearchResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.SearchResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FacetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.Facet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The key for this facet. For example, `"colors"` or `"price"`. It matches
     * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key].
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    java.lang.String getKey();
    /**
     *
     *
     * <pre>
     * The key for this facet. For example, `"colors"` or `"price"`. It matches
     * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key].
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString getKeyBytes();

    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue>
        getValuesList();
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue getValues(int index);
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    int getValuesCount();
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValueOrBuilder>
        getValuesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValueOrBuilder
        getValuesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Whether the facet is dynamically generated.
     * </pre>
     *
     * <code>bool dynamic_facet = 3;</code>
     *
     * @return The dynamicFacet.
     */
    boolean getDynamicFacet();
  }
  /**
   *
   *
   * <pre>
   * A facet result.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.Facet}
   */
  public static final class Facet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Facet)
      FacetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Facet.newBuilder() to construct.
    private Facet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Facet() {
      key_ = "";
      values_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Facet();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Facet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Facet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.class,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.Builder.class);
    }

    public interface FacetValueOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colors".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colors".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The value.
       */
      java.lang.String getValue();
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colors".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The bytes for value.
       */
      com.google.protobuf.ByteString getValueBytes();

      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price". It
       * matches
       * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
       *
       * @return Whether the interval field is set.
       */
      boolean hasInterval();
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price". It
       * matches
       * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
       *
       * @return The interval.
       */
      com.google.cloud.discoveryengine.v1beta.Interval getInterval();
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price". It
       * matches
       * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
       */
      com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder getIntervalOrBuilder();

      /**
       *
       *
       * <pre>
       * Number of items that have this facet value.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @return The count.
       */
      long getCount();

      com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.FacetValueCase
          getFacetValueCase();
    }
    /**
     *
     *
     * <pre>
     * A facet value which contains value names and their count.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue}
     */
    public static final class FacetValue extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue)
        FacetValueOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FacetValue.newBuilder() to construct.
      private FacetValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FacetValue() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FacetValue();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Facet_FacetValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Facet_FacetValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.Builder
                    .class);
      }

      private int facetValueCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object facetValue_;

      public enum FacetValueCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        VALUE(1),
        INTERVAL(2),
        FACETVALUE_NOT_SET(0);
        private final int value;

        private FacetValueCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static FacetValueCase valueOf(int value) {
          return forNumber(value);
        }

        public static FacetValueCase forNumber(int value) {
          switch (value) {
            case 1:
              return VALUE;
            case 2:
              return INTERVAL;
            case 0:
              return FACETVALUE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public FacetValueCase getFacetValueCase() {
        return FacetValueCase.forNumber(facetValueCase_);
      }

      public static final int VALUE_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colors".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return Whether the value field is set.
       */
      public boolean hasValue() {
        return facetValueCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colors".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = "";
        if (facetValueCase_ == 1) {
          ref = facetValue_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (facetValueCase_ == 1) {
            facetValue_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colors".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = "";
        if (facetValueCase_ == 1) {
          ref = facetValue_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (facetValueCase_ == 1) {
            facetValue_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int INTERVAL_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price". It
       * matches
       * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
       *
       * @return Whether the interval field is set.
       */
      @java.lang.Override
      public boolean hasInterval() {
        return facetValueCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price". It
       * matches
       * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
       *
       * @return The interval.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.Interval getInterval() {
        if (facetValueCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1beta.Interval) facetValue_;
        }
        return com.google.cloud.discoveryengine.v1beta.Interval.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price". It
       * matches
       * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder getIntervalOrBuilder() {
        if (facetValueCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1beta.Interval) facetValue_;
        }
        return com.google.cloud.discoveryengine.v1beta.Interval.getDefaultInstance();
      }

      public static final int COUNT_FIELD_NUMBER = 3;
      private long count_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of items that have this facet value.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public long getCount() {
        return count_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (facetValueCase_ == 1) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, facetValue_);
        }
        if (facetValueCase_ == 2) {
          output.writeMessage(2, (com.google.cloud.discoveryengine.v1beta.Interval) facetValue_);
        }
        if (count_ != 0L) {
          output.writeInt64(3, count_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (facetValueCase_ == 1) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, facetValue_);
        }
        if (facetValueCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, (com.google.cloud.discoveryengine.v1beta.Interval) facetValue_);
        }
        if (count_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, count_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue other =
            (com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue) obj;

        if (getCount() != other.getCount()) return false;
        if (!getFacetValueCase().equals(other.getFacetValueCase())) return false;
        switch (facetValueCase_) {
          case 1:
            if (!getValue().equals(other.getValue())) return false;
            break;
          case 2:
            if (!getInterval().equals(other.getInterval())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCount());
        switch (facetValueCase_) {
          case 1:
            hash = (37 * hash) + VALUE_FIELD_NUMBER;
            hash = (53 * hash) + getValue().hashCode();
            break;
          case 2:
            hash = (37 * hash) + INTERVAL_FIELD_NUMBER;
            hash = (53 * hash) + getInterval().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A facet value which contains value names and their count.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue)
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValueOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Facet_FacetValue_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Facet_FacetValue_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (intervalBuilder_ != null) {
            intervalBuilder_.clear();
          }
          count_ = 0L;
          facetValueCase_ = 0;
          facetValue_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Facet_FacetValue_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue build() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue result =
              new com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.count_ = count_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue result) {
          result.facetValueCase_ = facetValueCase_;
          result.facetValue_ = this.facetValue_;
          if (facetValueCase_ == 2 && intervalBuilder_ != null) {
            result.facetValue_ = intervalBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
                  .getDefaultInstance()) return this;
          if (other.getCount() != 0L) {
            setCount(other.getCount());
          }
          switch (other.getFacetValueCase()) {
            case VALUE:
              {
                facetValueCase_ = 1;
                facetValue_ = other.facetValue_;
                onChanged();
                break;
              }
            case INTERVAL:
              {
                mergeInterval(other.getInterval());
                break;
              }
            case FACETVALUE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    facetValueCase_ = 1;
                    facetValue_ = s;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getIntervalFieldBuilder().getBuilder(), extensionRegistry);
                    facetValueCase_ = 2;
                    break;
                  } // case 18
                case 24:
                  {
                    count_ = input.readInt64();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int facetValueCase_ = 0;
        private java.lang.Object facetValue_;

        public FacetValueCase getFacetValueCase() {
          return FacetValueCase.forNumber(facetValueCase_);
        }

        public Builder clearFacetValue() {
          facetValueCase_ = 0;
          facetValue_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colors".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @return Whether the value field is set.
         */
        @java.lang.Override
        public boolean hasValue() {
          return facetValueCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colors".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @return The value.
         */
        @java.lang.Override
        public java.lang.String getValue() {
          java.lang.Object ref = "";
          if (facetValueCase_ == 1) {
            ref = facetValue_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (facetValueCase_ == 1) {
              facetValue_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colors".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @return The bytes for value.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getValueBytes() {
          java.lang.Object ref = "";
          if (facetValueCase_ == 1) {
            ref = facetValue_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (facetValueCase_ == 1) {
              facetValue_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colors".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @param value The value to set.
         * @return This builder for chaining.
         */
        public Builder setValue(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          facetValueCase_ = 1;
          facetValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colors".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearValue() {
          if (facetValueCase_ == 1) {
            facetValueCase_ = 0;
            facetValue_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colors".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @param value The bytes for value to set.
         * @return This builder for chaining.
         */
        public Builder setValueBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          facetValueCase_ = 1;
          facetValue_ = value;
          onChanged();
          return this;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Interval,
                com.google.cloud.discoveryengine.v1beta.Interval.Builder,
                com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder>
            intervalBuilder_;
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
         *
         * @return Whether the interval field is set.
         */
        @java.lang.Override
        public boolean hasInterval() {
          return facetValueCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
         *
         * @return The interval.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.Interval getInterval() {
          if (intervalBuilder_ == null) {
            if (facetValueCase_ == 2) {
              return (com.google.cloud.discoveryengine.v1beta.Interval) facetValue_;
            }
            return com.google.cloud.discoveryengine.v1beta.Interval.getDefaultInstance();
          } else {
            if (facetValueCase_ == 2) {
              return intervalBuilder_.getMessage();
            }
            return com.google.cloud.discoveryengine.v1beta.Interval.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
         */
        public Builder setInterval(com.google.cloud.discoveryengine.v1beta.Interval value) {
          if (intervalBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            facetValue_ = value;
            onChanged();
          } else {
            intervalBuilder_.setMessage(value);
          }
          facetValueCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
         */
        public Builder setInterval(
            com.google.cloud.discoveryengine.v1beta.Interval.Builder builderForValue) {
          if (intervalBuilder_ == null) {
            facetValue_ = builderForValue.build();
            onChanged();
          } else {
            intervalBuilder_.setMessage(builderForValue.build());
          }
          facetValueCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
         */
        public Builder mergeInterval(com.google.cloud.discoveryengine.v1beta.Interval value) {
          if (intervalBuilder_ == null) {
            if (facetValueCase_ == 2
                && facetValue_
                    != com.google.cloud.discoveryengine.v1beta.Interval.getDefaultInstance()) {
              facetValue_ =
                  com.google.cloud.discoveryengine.v1beta.Interval.newBuilder(
                          (com.google.cloud.discoveryengine.v1beta.Interval) facetValue_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              facetValue_ = value;
            }
            onChanged();
          } else {
            if (facetValueCase_ == 2) {
              intervalBuilder_.mergeFrom(value);
            } else {
              intervalBuilder_.setMessage(value);
            }
          }
          facetValueCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
         */
        public Builder clearInterval() {
          if (intervalBuilder_ == null) {
            if (facetValueCase_ == 2) {
              facetValueCase_ = 0;
              facetValue_ = null;
              onChanged();
            }
          } else {
            if (facetValueCase_ == 2) {
              facetValueCase_ = 0;
              facetValue_ = null;
            }
            intervalBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.Interval.Builder getIntervalBuilder() {
          return getIntervalFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder getIntervalOrBuilder() {
          if ((facetValueCase_ == 2) && (intervalBuilder_ != null)) {
            return intervalBuilder_.getMessageOrBuilder();
          } else {
            if (facetValueCase_ == 2) {
              return (com.google.cloud.discoveryengine.v1beta.Interval) facetValue_;
            }
            return com.google.cloud.discoveryengine.v1beta.Interval.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1beta.Interval interval = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.Interval,
                com.google.cloud.discoveryengine.v1beta.Interval.Builder,
                com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder>
            getIntervalFieldBuilder() {
          if (intervalBuilder_ == null) {
            if (!(facetValueCase_ == 2)) {
              facetValue_ = com.google.cloud.discoveryengine.v1beta.Interval.getDefaultInstance();
            }
            intervalBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.Interval,
                    com.google.cloud.discoveryengine.v1beta.Interval.Builder,
                    com.google.cloud.discoveryengine.v1beta.IntervalOrBuilder>(
                    (com.google.cloud.discoveryengine.v1beta.Interval) facetValue_,
                    getParentForChildren(),
                    isClean());
            facetValue_ = null;
          }
          facetValueCase_ = 2;
          onChanged();
          return intervalBuilder_;
        }

        private long count_;
        /**
         *
         *
         * <pre>
         * Number of items that have this facet value.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @return The count.
         */
        @java.lang.Override
        public long getCount() {
          return count_;
        }
        /**
         *
         *
         * <pre>
         * Number of items that have this facet value.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @param value The count to set.
         * @return This builder for chaining.
         */
        public Builder setCount(long value) {

          count_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of items that have this facet value.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCount() {
          bitField0_ = (bitField0_ & ~0x00000004);
          count_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue)
      private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FacetValue> PARSER =
          new com.google.protobuf.AbstractParser<FacetValue>() {
            @java.lang.Override
            public FacetValue parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FacetValue> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FacetValue> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * The key for this facet. For example, `"colors"` or `"price"`. It matches
     * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key].
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The key for this facet. For example, `"colors"` or `"price"`. It matches
     * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key].
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue>
        values_;
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue>
        getValuesList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValueOrBuilder>
        getValuesOrBuilderList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    @java.lang.Override
    public int getValuesCount() {
      return values_.size();
    }
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue getValues(
        int index) {
      return values_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValueOrBuilder
        getValuesOrBuilder(int index) {
      return values_.get(index);
    }

    public static final int DYNAMIC_FACET_FIELD_NUMBER = 3;
    private boolean dynamicFacet_ = false;
    /**
     *
     *
     * <pre>
     * Whether the facet is dynamically generated.
     * </pre>
     *
     * <code>bool dynamic_facet = 3;</code>
     *
     * @return The dynamicFacet.
     */
    @java.lang.Override
    public boolean getDynamicFacet() {
      return dynamicFacet_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      for (int i = 0; i < values_.size(); i++) {
        output.writeMessage(2, values_.get(i));
      }
      if (dynamicFacet_ != false) {
        output.writeBool(3, dynamicFacet_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      for (int i = 0; i < values_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, values_.get(i));
      }
      if (dynamicFacet_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, dynamicFacet_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet other =
          (com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet) obj;

      if (!getKey().equals(other.getKey())) return false;
      if (!getValuesList().equals(other.getValuesList())) return false;
      if (getDynamicFacet() != other.getDynamicFacet()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      if (getValuesCount() > 0) {
        hash = (37 * hash) + VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getValuesList().hashCode();
      }
      hash = (37 * hash) + DYNAMIC_FACET_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDynamicFacet());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A facet result.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.Facet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Facet)
        com.google.cloud.discoveryengine.v1beta.SearchResponse.FacetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Facet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Facet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        key_ = "";
        if (valuesBuilder_ == null) {
          values_ = java.util.Collections.emptyList();
        } else {
          values_ = null;
          valuesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        dynamicFacet_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Facet_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet build() {
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet result =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet result) {
        if (valuesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            values_ = java.util.Collections.unmodifiableList(values_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.values_ = values_;
        } else {
          result.values_ = valuesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.key_ = key_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.dynamicFacet_ = dynamicFacet_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.getDefaultInstance())
          return this;
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (valuesBuilder_ == null) {
          if (!other.values_.isEmpty()) {
            if (values_.isEmpty()) {
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureValuesIsMutable();
              values_.addAll(other.values_);
            }
            onChanged();
          }
        } else {
          if (!other.values_.isEmpty()) {
            if (valuesBuilder_.isEmpty()) {
              valuesBuilder_.dispose();
              valuesBuilder_ = null;
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000002);
              valuesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getValuesFieldBuilder()
                      : null;
            } else {
              valuesBuilder_.addAllMessages(other.values_);
            }
          }
        }
        if (other.getDynamicFacet() != false) {
          setDynamicFacet(other.getDynamicFacet());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  key_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
                              .parser(),
                          extensionRegistry);
                  if (valuesBuilder_ == null) {
                    ensureValuesIsMutable();
                    values_.add(m);
                  } else {
                    valuesBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 24:
                {
                  dynamicFacet_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * The key for this facet. For example, `"colors"` or `"price"`. It matches
       * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key].
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The key for this facet. For example, `"colors"` or `"price"`. It matches
       * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key].
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The key for this facet. For example, `"colors"` or `"price"`. It matches
       * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key].
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        key_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The key for this facet. For example, `"colors"` or `"price"`. It matches
       * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key].
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        key_ = getDefaultInstance().getKey();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The key for this facet. For example, `"colors"` or `"price"`. It matches
       * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1beta.SearchRequest.FacetSpec.FacetKey.key].
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        key_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue>
          values_ = java.util.Collections.emptyList();

      private void ensureValuesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          values_ =
              new java.util.ArrayList<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue>(values_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.Builder,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValueOrBuilder>
          valuesBuilder_;

      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue>
          getValuesList() {
        if (valuesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(values_);
        } else {
          return valuesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public int getValuesCount() {
        if (valuesBuilder_ == null) {
          return values_.size();
        } else {
          return valuesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue getValues(
          int index) {
        if (valuesBuilder_ == null) {
          return values_.get(index);
        } else {
          return valuesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder setValues(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.set(index, value);
          onChanged();
        } else {
          valuesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder setValues(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.Builder
              builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.set(index, builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder addValues(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(value);
          onChanged();
        } else {
          valuesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder addValues(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(index, value);
          onChanged();
        } else {
          valuesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder addValues(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.Builder
              builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.add(builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder addValues(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.Builder
              builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.add(index, builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder addAllValues(
          java.lang.Iterable<
                  ? extends com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue>
              values) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
          onChanged();
        } else {
          valuesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder clearValues() {
        if (valuesBuilder_ == null) {
          values_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          valuesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder removeValues(int index) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.remove(index);
          onChanged();
        } else {
          valuesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.Builder
          getValuesBuilder(int index) {
        return getValuesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValueOrBuilder
          getValuesOrBuilder(int index) {
        if (valuesBuilder_ == null) {
          return values_.get(index);
        } else {
          return valuesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValueOrBuilder>
          getValuesOrBuilderList() {
        if (valuesBuilder_ != null) {
          return valuesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(values_);
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.Builder
          addValuesBuilder() {
        return getValuesFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.Builder
          addValuesBuilder(int index) {
        return getValuesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.Builder>
          getValuesBuilderList() {
        return getValuesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.Builder,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValueOrBuilder>
          getValuesFieldBuilder() {
        if (valuesBuilder_ == null) {
          valuesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValue.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet.FacetValueOrBuilder>(
                  values_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          values_ = null;
        }
        return valuesBuilder_;
      }

      private boolean dynamicFacet_;
      /**
       *
       *
       * <pre>
       * Whether the facet is dynamically generated.
       * </pre>
       *
       * <code>bool dynamic_facet = 3;</code>
       *
       * @return The dynamicFacet.
       */
      @java.lang.Override
      public boolean getDynamicFacet() {
        return dynamicFacet_;
      }
      /**
       *
       *
       * <pre>
       * Whether the facet is dynamically generated.
       * </pre>
       *
       * <code>bool dynamic_facet = 3;</code>
       *
       * @param value The dynamicFacet to set.
       * @return This builder for chaining.
       */
      public Builder setDynamicFacet(boolean value) {

        dynamicFacet_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether the facet is dynamically generated.
       * </pre>
       *
       * <code>bool dynamic_facet = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDynamicFacet() {
        bitField0_ = (bitField0_ & ~0x00000004);
        dynamicFacet_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Facet)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Facet)
    private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Facet> PARSER =
        new com.google.protobuf.AbstractParser<Facet>() {
          @java.lang.Override
          public Facet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Facet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Facet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.Facet
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GuidedSearchResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of ranked refinement attributes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
     * </code>
     */
    java.util.List<
            com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                .RefinementAttribute>
        getRefinementAttributesList();
    /**
     *
     *
     * <pre>
     * A list of ranked refinement attributes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute
        getRefinementAttributes(int index);
    /**
     *
     *
     * <pre>
     * A list of ranked refinement attributes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
     * </code>
     */
    int getRefinementAttributesCount();
    /**
     *
     *
     * <pre>
     * A list of ranked refinement attributes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                    .RefinementAttributeOrBuilder>
        getRefinementAttributesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of ranked refinement attributes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
            .RefinementAttributeOrBuilder
        getRefinementAttributesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Suggested follow-up questions.
     * </pre>
     *
     * <code>repeated string follow_up_questions = 2;</code>
     *
     * @return A list containing the followUpQuestions.
     */
    java.util.List<java.lang.String> getFollowUpQuestionsList();
    /**
     *
     *
     * <pre>
     * Suggested follow-up questions.
     * </pre>
     *
     * <code>repeated string follow_up_questions = 2;</code>
     *
     * @return The count of followUpQuestions.
     */
    int getFollowUpQuestionsCount();
    /**
     *
     *
     * <pre>
     * Suggested follow-up questions.
     * </pre>
     *
     * <code>repeated string follow_up_questions = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The followUpQuestions at the given index.
     */
    java.lang.String getFollowUpQuestions(int index);
    /**
     *
     *
     * <pre>
     * Suggested follow-up questions.
     * </pre>
     *
     * <code>repeated string follow_up_questions = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the followUpQuestions at the given index.
     */
    com.google.protobuf.ByteString getFollowUpQuestionsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Guided search result. The guided search helps user to refine the search
   * results and narrow down to the real needs from a broaded search results.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult}
   */
  public static final class GuidedSearchResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult)
      GuidedSearchResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GuidedSearchResult.newBuilder() to construct.
    private GuidedSearchResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GuidedSearchResult() {
      refinementAttributes_ = java.util.Collections.emptyList();
      followUpQuestions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GuidedSearchResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GuidedSearchResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GuidedSearchResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.class,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.Builder
                  .class);
    }

    public interface RefinementAttributeOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Attribute key used to refine the results. For example, `"movie_type"`.
       * </pre>
       *
       * <code>string attribute_key = 1;</code>
       *
       * @return The attributeKey.
       */
      java.lang.String getAttributeKey();
      /**
       *
       *
       * <pre>
       * Attribute key used to refine the results. For example, `"movie_type"`.
       * </pre>
       *
       * <code>string attribute_key = 1;</code>
       *
       * @return The bytes for attributeKey.
       */
      com.google.protobuf.ByteString getAttributeKeyBytes();

      /**
       *
       *
       * <pre>
       * Attribute value used to refine the results. For example, `"drama"`.
       * </pre>
       *
       * <code>string attribute_value = 2;</code>
       *
       * @return The attributeValue.
       */
      java.lang.String getAttributeValue();
      /**
       *
       *
       * <pre>
       * Attribute value used to refine the results. For example, `"drama"`.
       * </pre>
       *
       * <code>string attribute_value = 2;</code>
       *
       * @return The bytes for attributeValue.
       */
      com.google.protobuf.ByteString getAttributeValueBytes();
    }
    /**
     *
     *
     * <pre>
     * Useful attribute for search result refinements.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute}
     */
    public static final class RefinementAttribute extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute)
        RefinementAttributeOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use RefinementAttribute.newBuilder() to construct.
      private RefinementAttribute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private RefinementAttribute() {
        attributeKey_ = "";
        attributeValue_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new RefinementAttribute();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GuidedSearchResult_RefinementAttribute_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GuidedSearchResult_RefinementAttribute_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                    .RefinementAttribute.class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                    .RefinementAttribute.Builder.class);
      }

      public static final int ATTRIBUTE_KEY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object attributeKey_ = "";
      /**
       *
       *
       * <pre>
       * Attribute key used to refine the results. For example, `"movie_type"`.
       * </pre>
       *
       * <code>string attribute_key = 1;</code>
       *
       * @return The attributeKey.
       */
      @java.lang.Override
      public java.lang.String getAttributeKey() {
        java.lang.Object ref = attributeKey_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          attributeKey_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Attribute key used to refine the results. For example, `"movie_type"`.
       * </pre>
       *
       * <code>string attribute_key = 1;</code>
       *
       * @return The bytes for attributeKey.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAttributeKeyBytes() {
        java.lang.Object ref = attributeKey_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          attributeKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ATTRIBUTE_VALUE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object attributeValue_ = "";
      /**
       *
       *
       * <pre>
       * Attribute value used to refine the results. For example, `"drama"`.
       * </pre>
       *
       * <code>string attribute_value = 2;</code>
       *
       * @return The attributeValue.
       */
      @java.lang.Override
      public java.lang.String getAttributeValue() {
        java.lang.Object ref = attributeValue_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          attributeValue_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Attribute value used to refine the results. For example, `"drama"`.
       * </pre>
       *
       * <code>string attribute_value = 2;</code>
       *
       * @return The bytes for attributeValue.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAttributeValueBytes() {
        java.lang.Object ref = attributeValue_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          attributeValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributeKey_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, attributeKey_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributeValue_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, attributeValue_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributeKey_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, attributeKey_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributeValue_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, attributeValue_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                .RefinementAttribute)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                .RefinementAttribute
            other =
                (com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                        .RefinementAttribute)
                    obj;

        if (!getAttributeKey().equals(other.getAttributeKey())) return false;
        if (!getAttributeValue().equals(other.getAttributeValue())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ATTRIBUTE_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getAttributeKey().hashCode();
        hash = (37 * hash) + ATTRIBUTE_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getAttributeValue().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Useful attribute for search result refinements.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute)
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttributeOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GuidedSearchResult_RefinementAttribute_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GuidedSearchResult_RefinementAttribute_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                      .RefinementAttribute.class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                      .RefinementAttribute.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          attributeKey_ = "";
          attributeValue_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GuidedSearchResult_RefinementAttribute_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                .RefinementAttribute
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                .RefinementAttribute
            build() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                .RefinementAttribute
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute
              result =
                  new com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                      .RefinementAttribute(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                    .RefinementAttribute
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.attributeKey_ = attributeKey_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.attributeValue_ = attributeValue_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                        .RefinementAttribute)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                    .RefinementAttribute
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute.getDefaultInstance()) return this;
          if (!other.getAttributeKey().isEmpty()) {
            attributeKey_ = other.attributeKey_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getAttributeValue().isEmpty()) {
            attributeValue_ = other.attributeValue_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    attributeKey_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    attributeValue_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object attributeKey_ = "";
        /**
         *
         *
         * <pre>
         * Attribute key used to refine the results. For example, `"movie_type"`.
         * </pre>
         *
         * <code>string attribute_key = 1;</code>
         *
         * @return The attributeKey.
         */
        public java.lang.String getAttributeKey() {
          java.lang.Object ref = attributeKey_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            attributeKey_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Attribute key used to refine the results. For example, `"movie_type"`.
         * </pre>
         *
         * <code>string attribute_key = 1;</code>
         *
         * @return The bytes for attributeKey.
         */
        public com.google.protobuf.ByteString getAttributeKeyBytes() {
          java.lang.Object ref = attributeKey_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            attributeKey_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Attribute key used to refine the results. For example, `"movie_type"`.
         * </pre>
         *
         * <code>string attribute_key = 1;</code>
         *
         * @param value The attributeKey to set.
         * @return This builder for chaining.
         */
        public Builder setAttributeKey(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          attributeKey_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Attribute key used to refine the results. For example, `"movie_type"`.
         * </pre>
         *
         * <code>string attribute_key = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAttributeKey() {
          attributeKey_ = getDefaultInstance().getAttributeKey();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Attribute key used to refine the results. For example, `"movie_type"`.
         * </pre>
         *
         * <code>string attribute_key = 1;</code>
         *
         * @param value The bytes for attributeKey to set.
         * @return This builder for chaining.
         */
        public Builder setAttributeKeyBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          attributeKey_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object attributeValue_ = "";
        /**
         *
         *
         * <pre>
         * Attribute value used to refine the results. For example, `"drama"`.
         * </pre>
         *
         * <code>string attribute_value = 2;</code>
         *
         * @return The attributeValue.
         */
        public java.lang.String getAttributeValue() {
          java.lang.Object ref = attributeValue_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            attributeValue_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Attribute value used to refine the results. For example, `"drama"`.
         * </pre>
         *
         * <code>string attribute_value = 2;</code>
         *
         * @return The bytes for attributeValue.
         */
        public com.google.protobuf.ByteString getAttributeValueBytes() {
          java.lang.Object ref = attributeValue_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            attributeValue_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Attribute value used to refine the results. For example, `"drama"`.
         * </pre>
         *
         * <code>string attribute_value = 2;</code>
         *
         * @param value The attributeValue to set.
         * @return This builder for chaining.
         */
        public Builder setAttributeValue(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          attributeValue_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Attribute value used to refine the results. For example, `"drama"`.
         * </pre>
         *
         * <code>string attribute_value = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAttributeValue() {
          attributeValue_ = getDefaultInstance().getAttributeValue();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Attribute value used to refine the results. For example, `"drama"`.
         * </pre>
         *
         * <code>string attribute_value = 2;</code>
         *
         * @param value The bytes for attributeValue to set.
         * @return This builder for chaining.
         */
        public Builder setAttributeValueBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          attributeValue_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute)
      private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                .RefinementAttribute();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<RefinementAttribute> PARSER =
          new com.google.protobuf.AbstractParser<RefinementAttribute>() {
            @java.lang.Override
            public RefinementAttribute parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<RefinementAttribute> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<RefinementAttribute> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int REFINEMENT_ATTRIBUTES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                .RefinementAttribute>
        refinementAttributes_;
    /**
     *
     *
     * <pre>
     * A list of ranked refinement attributes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                .RefinementAttribute>
        getRefinementAttributesList() {
      return refinementAttributes_;
    }
    /**
     *
     *
     * <pre>
     * A list of ranked refinement attributes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                    .RefinementAttributeOrBuilder>
        getRefinementAttributesOrBuilderList() {
      return refinementAttributes_;
    }
    /**
     *
     *
     * <pre>
     * A list of ranked refinement attributes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
     * </code>
     */
    @java.lang.Override
    public int getRefinementAttributesCount() {
      return refinementAttributes_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of ranked refinement attributes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
            .RefinementAttribute
        getRefinementAttributes(int index) {
      return refinementAttributes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of ranked refinement attributes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
            .RefinementAttributeOrBuilder
        getRefinementAttributesOrBuilder(int index) {
      return refinementAttributes_.get(index);
    }

    public static final int FOLLOW_UP_QUESTIONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList followUpQuestions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Suggested follow-up questions.
     * </pre>
     *
     * <code>repeated string follow_up_questions = 2;</code>
     *
     * @return A list containing the followUpQuestions.
     */
    public com.google.protobuf.ProtocolStringList getFollowUpQuestionsList() {
      return followUpQuestions_;
    }
    /**
     *
     *
     * <pre>
     * Suggested follow-up questions.
     * </pre>
     *
     * <code>repeated string follow_up_questions = 2;</code>
     *
     * @return The count of followUpQuestions.
     */
    public int getFollowUpQuestionsCount() {
      return followUpQuestions_.size();
    }
    /**
     *
     *
     * <pre>
     * Suggested follow-up questions.
     * </pre>
     *
     * <code>repeated string follow_up_questions = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The followUpQuestions at the given index.
     */
    public java.lang.String getFollowUpQuestions(int index) {
      return followUpQuestions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Suggested follow-up questions.
     * </pre>
     *
     * <code>repeated string follow_up_questions = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the followUpQuestions at the given index.
     */
    public com.google.protobuf.ByteString getFollowUpQuestionsBytes(int index) {
      return followUpQuestions_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < refinementAttributes_.size(); i++) {
        output.writeMessage(1, refinementAttributes_.get(i));
      }
      for (int i = 0; i < followUpQuestions_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, followUpQuestions_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < refinementAttributes_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, refinementAttributes_.get(i));
      }
      {
        int dataSize = 0;
        for (int i = 0; i < followUpQuestions_.size(); i++) {
          dataSize += computeStringSizeNoTag(followUpQuestions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getFollowUpQuestionsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult other =
          (com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult) obj;

      if (!getRefinementAttributesList().equals(other.getRefinementAttributesList())) return false;
      if (!getFollowUpQuestionsList().equals(other.getFollowUpQuestionsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getRefinementAttributesCount() > 0) {
        hash = (37 * hash) + REFINEMENT_ATTRIBUTES_FIELD_NUMBER;
        hash = (53 * hash) + getRefinementAttributesList().hashCode();
      }
      if (getFollowUpQuestionsCount() > 0) {
        hash = (37 * hash) + FOLLOW_UP_QUESTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getFollowUpQuestionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Guided search result. The guided search helps user to refine the search
     * results and narrow down to the real needs from a broaded search results.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult)
        com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GuidedSearchResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GuidedSearchResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (refinementAttributesBuilder_ == null) {
          refinementAttributes_ = java.util.Collections.emptyList();
        } else {
          refinementAttributes_ = null;
          refinementAttributesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        followUpQuestions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GuidedSearchResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult build() {
        com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult result =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult result) {
        if (refinementAttributesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            refinementAttributes_ = java.util.Collections.unmodifiableList(refinementAttributes_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.refinementAttributes_ = refinementAttributes_;
        } else {
          result.refinementAttributes_ = refinementAttributesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          followUpQuestions_.makeImmutable();
          result.followUpQuestions_ = followUpQuestions_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                .getDefaultInstance()) return this;
        if (refinementAttributesBuilder_ == null) {
          if (!other.refinementAttributes_.isEmpty()) {
            if (refinementAttributes_.isEmpty()) {
              refinementAttributes_ = other.refinementAttributes_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureRefinementAttributesIsMutable();
              refinementAttributes_.addAll(other.refinementAttributes_);
            }
            onChanged();
          }
        } else {
          if (!other.refinementAttributes_.isEmpty()) {
            if (refinementAttributesBuilder_.isEmpty()) {
              refinementAttributesBuilder_.dispose();
              refinementAttributesBuilder_ = null;
              refinementAttributes_ = other.refinementAttributes_;
              bitField0_ = (bitField0_ & ~0x00000001);
              refinementAttributesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getRefinementAttributesFieldBuilder()
                      : null;
            } else {
              refinementAttributesBuilder_.addAllMessages(other.refinementAttributes_);
            }
          }
        }
        if (!other.followUpQuestions_.isEmpty()) {
          if (followUpQuestions_.isEmpty()) {
            followUpQuestions_ = other.followUpQuestions_;
            bitField0_ |= 0x00000002;
          } else {
            ensureFollowUpQuestionsIsMutable();
            followUpQuestions_.addAll(other.followUpQuestions_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                          .RefinementAttribute
                      m =
                          input.readMessage(
                              com.google.cloud.discoveryengine.v1beta.SearchResponse
                                  .GuidedSearchResult.RefinementAttribute.parser(),
                              extensionRegistry);
                  if (refinementAttributesBuilder_ == null) {
                    ensureRefinementAttributesIsMutable();
                    refinementAttributes_.add(m);
                  } else {
                    refinementAttributesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureFollowUpQuestionsIsMutable();
                  followUpQuestions_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute>
          refinementAttributes_ = java.util.Collections.emptyList();

      private void ensureRefinementAttributesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          refinementAttributes_ =
              new java.util.ArrayList<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                      .RefinementAttribute>(refinementAttributes_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute.Builder,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttributeOrBuilder>
          refinementAttributesBuilder_;

      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute>
          getRefinementAttributesList() {
        if (refinementAttributesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(refinementAttributes_);
        } else {
          return refinementAttributesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public int getRefinementAttributesCount() {
        if (refinementAttributesBuilder_ == null) {
          return refinementAttributes_.size();
        } else {
          return refinementAttributesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute
          getRefinementAttributes(int index) {
        if (refinementAttributesBuilder_ == null) {
          return refinementAttributes_.get(index);
        } else {
          return refinementAttributesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public Builder setRefinementAttributes(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute
              value) {
        if (refinementAttributesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRefinementAttributesIsMutable();
          refinementAttributes_.set(index, value);
          onChanged();
        } else {
          refinementAttributesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public Builder setRefinementAttributes(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute.Builder
              builderForValue) {
        if (refinementAttributesBuilder_ == null) {
          ensureRefinementAttributesIsMutable();
          refinementAttributes_.set(index, builderForValue.build());
          onChanged();
        } else {
          refinementAttributesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public Builder addRefinementAttributes(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute
              value) {
        if (refinementAttributesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRefinementAttributesIsMutable();
          refinementAttributes_.add(value);
          onChanged();
        } else {
          refinementAttributesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public Builder addRefinementAttributes(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute
              value) {
        if (refinementAttributesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRefinementAttributesIsMutable();
          refinementAttributes_.add(index, value);
          onChanged();
        } else {
          refinementAttributesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public Builder addRefinementAttributes(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute.Builder
              builderForValue) {
        if (refinementAttributesBuilder_ == null) {
          ensureRefinementAttributesIsMutable();
          refinementAttributes_.add(builderForValue.build());
          onChanged();
        } else {
          refinementAttributesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public Builder addRefinementAttributes(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute.Builder
              builderForValue) {
        if (refinementAttributesBuilder_ == null) {
          ensureRefinementAttributesIsMutable();
          refinementAttributes_.add(index, builderForValue.build());
          onChanged();
        } else {
          refinementAttributesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public Builder addAllRefinementAttributes(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                          .RefinementAttribute>
              values) {
        if (refinementAttributesBuilder_ == null) {
          ensureRefinementAttributesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, refinementAttributes_);
          onChanged();
        } else {
          refinementAttributesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public Builder clearRefinementAttributes() {
        if (refinementAttributesBuilder_ == null) {
          refinementAttributes_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          refinementAttributesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public Builder removeRefinementAttributes(int index) {
        if (refinementAttributesBuilder_ == null) {
          ensureRefinementAttributesIsMutable();
          refinementAttributes_.remove(index);
          onChanged();
        } else {
          refinementAttributesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute.Builder
          getRefinementAttributesBuilder(int index) {
        return getRefinementAttributesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttributeOrBuilder
          getRefinementAttributesOrBuilder(int index) {
        if (refinementAttributesBuilder_ == null) {
          return refinementAttributes_.get(index);
        } else {
          return refinementAttributesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                      .RefinementAttributeOrBuilder>
          getRefinementAttributesOrBuilderList() {
        if (refinementAttributesBuilder_ != null) {
          return refinementAttributesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(refinementAttributes_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute.Builder
          addRefinementAttributesBuilder() {
        return getRefinementAttributesFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                    .RefinementAttribute.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
              .RefinementAttribute.Builder
          addRefinementAttributesBuilder(int index) {
        return getRefinementAttributesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                    .RefinementAttribute.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of ranked refinement attributes.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult.RefinementAttribute refinement_attributes = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute.Builder>
          getRefinementAttributesBuilderList() {
        return getRefinementAttributesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttribute.Builder,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                  .RefinementAttributeOrBuilder>
          getRefinementAttributesFieldBuilder() {
        if (refinementAttributesBuilder_ == null) {
          refinementAttributesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                      .RefinementAttribute,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                      .RefinementAttribute.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
                      .RefinementAttributeOrBuilder>(
                  refinementAttributes_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          refinementAttributes_ = null;
        }
        return refinementAttributesBuilder_;
      }

      private com.google.protobuf.LazyStringArrayList followUpQuestions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureFollowUpQuestionsIsMutable() {
        if (!followUpQuestions_.isModifiable()) {
          followUpQuestions_ = new com.google.protobuf.LazyStringArrayList(followUpQuestions_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Suggested follow-up questions.
       * </pre>
       *
       * <code>repeated string follow_up_questions = 2;</code>
       *
       * @return A list containing the followUpQuestions.
       */
      public com.google.protobuf.ProtocolStringList getFollowUpQuestionsList() {
        followUpQuestions_.makeImmutable();
        return followUpQuestions_;
      }
      /**
       *
       *
       * <pre>
       * Suggested follow-up questions.
       * </pre>
       *
       * <code>repeated string follow_up_questions = 2;</code>
       *
       * @return The count of followUpQuestions.
       */
      public int getFollowUpQuestionsCount() {
        return followUpQuestions_.size();
      }
      /**
       *
       *
       * <pre>
       * Suggested follow-up questions.
       * </pre>
       *
       * <code>repeated string follow_up_questions = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The followUpQuestions at the given index.
       */
      public java.lang.String getFollowUpQuestions(int index) {
        return followUpQuestions_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Suggested follow-up questions.
       * </pre>
       *
       * <code>repeated string follow_up_questions = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the followUpQuestions at the given index.
       */
      public com.google.protobuf.ByteString getFollowUpQuestionsBytes(int index) {
        return followUpQuestions_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Suggested follow-up questions.
       * </pre>
       *
       * <code>repeated string follow_up_questions = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The followUpQuestions to set.
       * @return This builder for chaining.
       */
      public Builder setFollowUpQuestions(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFollowUpQuestionsIsMutable();
        followUpQuestions_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Suggested follow-up questions.
       * </pre>
       *
       * <code>repeated string follow_up_questions = 2;</code>
       *
       * @param value The followUpQuestions to add.
       * @return This builder for chaining.
       */
      public Builder addFollowUpQuestions(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFollowUpQuestionsIsMutable();
        followUpQuestions_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Suggested follow-up questions.
       * </pre>
       *
       * <code>repeated string follow_up_questions = 2;</code>
       *
       * @param values The followUpQuestions to add.
       * @return This builder for chaining.
       */
      public Builder addAllFollowUpQuestions(java.lang.Iterable<java.lang.String> values) {
        ensureFollowUpQuestionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, followUpQuestions_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Suggested follow-up questions.
       * </pre>
       *
       * <code>repeated string follow_up_questions = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFollowUpQuestions() {
        followUpQuestions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Suggested follow-up questions.
       * </pre>
       *
       * <code>repeated string follow_up_questions = 2;</code>
       *
       * @param value The bytes of the followUpQuestions to add.
       * @return This builder for chaining.
       */
      public Builder addFollowUpQuestionsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureFollowUpQuestionsIsMutable();
        followUpQuestions_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult)
    private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GuidedSearchResult> PARSER =
        new com.google.protobuf.AbstractParser<GuidedSearchResult>() {
          @java.lang.Override
          public GuidedSearchResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GuidedSearchResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GuidedSearchResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.GuidedSearchResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SummaryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.Summary)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The summary content.
     * </pre>
     *
     * <code>string summary_text = 1;</code>
     *
     * @return The summaryText.
     */
    java.lang.String getSummaryText();
    /**
     *
     *
     * <pre>
     * The summary content.
     * </pre>
     *
     * <code>string summary_text = 1;</code>
     *
     * @return The bytes for summaryText.
     */
    com.google.protobuf.ByteString getSummaryTextBytes();

    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @return A list containing the summarySkippedReasons.
     */
    java.util.List<
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason>
        getSummarySkippedReasonsList();
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @return The count of summarySkippedReasons.
     */
    int getSummarySkippedReasonsCount();
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The summarySkippedReasons at the given index.
     */
    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason
        getSummarySkippedReasons(int index);
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for summarySkippedReasons.
     */
    java.util.List<java.lang.Integer> getSummarySkippedReasonsValueList();
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of summarySkippedReasons at the given index.
     */
    int getSummarySkippedReasonsValue(int index);

    /**
     *
     *
     * <pre>
     * A collection of Safety Attribute categories and their associated
     * confidence scores.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
     * </code>
     *
     * @return Whether the safetyAttributes field is set.
     */
    boolean hasSafetyAttributes();
    /**
     *
     *
     * <pre>
     * A collection of Safety Attribute categories and their associated
     * confidence scores.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
     * </code>
     *
     * @return The safetyAttributes.
     */
    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
        getSafetyAttributes();
    /**
     *
     *
     * <pre>
     * A collection of Safety Attribute categories and their associated
     * confidence scores.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributesOrBuilder
        getSafetyAttributesOrBuilder();

    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
     * </code>
     *
     * @return Whether the summaryWithMetadata field is set.
     */
    boolean hasSummaryWithMetadata();
    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
     * </code>
     *
     * @return The summaryWithMetadata.
     */
    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
        getSummaryWithMetadata();
    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadataOrBuilder
        getSummaryWithMetadataOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Summary of the top N search results specified by the summary spec.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.Summary}
   */
  public static final class Summary extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary)
      SummaryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Summary.newBuilder() to construct.
    private Summary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Summary() {
      summaryText_ = "";
      summarySkippedReasons_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Summary();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.class,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * An Enum for summary-skipped reasons.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason}
     */
    public enum SummarySkippedReason implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. The summary skipped reason is not specified.
       * </pre>
       *
       * <code>SUMMARY_SKIPPED_REASON_UNSPECIFIED = 0;</code>
       */
      SUMMARY_SKIPPED_REASON_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The adversarial query ignored case.
       *
       * Only populated when
       * [SummarySpec.ignore_adversarial_query][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ignore_adversarial_query]
       * is set to `true`.
       * </pre>
       *
       * <code>ADVERSARIAL_QUERY_IGNORED = 1;</code>
       */
      ADVERSARIAL_QUERY_IGNORED(1),
      /**
       *
       *
       * <pre>
       * The non-summary seeking query ignored case.
       *
       * Only populated when
       * [SummarySpec.ignore_non_summary_seeking_query][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ignore_non_summary_seeking_query]
       * is set to `true`.
       * </pre>
       *
       * <code>NON_SUMMARY_SEEKING_QUERY_IGNORED = 2;</code>
       */
      NON_SUMMARY_SEEKING_QUERY_IGNORED(2),
      /**
       *
       *
       * <pre>
       * The out-of-domain query ignored case.
       *
       * Google skips the summary if there are no high-relevance search results.
       * For example, the data store contains facts about company A but the
       * user query is asking questions about company B.
       * </pre>
       *
       * <code>OUT_OF_DOMAIN_QUERY_IGNORED = 3;</code>
       */
      OUT_OF_DOMAIN_QUERY_IGNORED(3),
      /**
       *
       *
       * <pre>
       * The potential policy violation case.
       *
       * Google skips the summary if there is a potential policy violation
       * detected. This includes content that may be violent or toxic.
       * </pre>
       *
       * <code>POTENTIAL_POLICY_VIOLATION = 4;</code>
       */
      POTENTIAL_POLICY_VIOLATION(4),
      /**
       *
       *
       * <pre>
       * The LLM addon not enabled case.
       *
       * Google skips the summary if the LLM addon is not enabled.
       * </pre>
       *
       * <code>LLM_ADDON_NOT_ENABLED = 5;</code>
       */
      LLM_ADDON_NOT_ENABLED(5),
      /**
       *
       *
       * <pre>
       * The no relevant content case.
       *
       * Google skips the summary if there is no relevant content in the
       * retrieved search results.
       * </pre>
       *
       * <code>NO_RELEVANT_CONTENT = 6;</code>
       */
      NO_RELEVANT_CONTENT(6),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. The summary skipped reason is not specified.
       * </pre>
       *
       * <code>SUMMARY_SKIPPED_REASON_UNSPECIFIED = 0;</code>
       */
      public static final int SUMMARY_SKIPPED_REASON_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The adversarial query ignored case.
       *
       * Only populated when
       * [SummarySpec.ignore_adversarial_query][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ignore_adversarial_query]
       * is set to `true`.
       * </pre>
       *
       * <code>ADVERSARIAL_QUERY_IGNORED = 1;</code>
       */
      public static final int ADVERSARIAL_QUERY_IGNORED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The non-summary seeking query ignored case.
       *
       * Only populated when
       * [SummarySpec.ignore_non_summary_seeking_query][google.cloud.discoveryengine.v1beta.SearchRequest.ContentSearchSpec.SummarySpec.ignore_non_summary_seeking_query]
       * is set to `true`.
       * </pre>
       *
       * <code>NON_SUMMARY_SEEKING_QUERY_IGNORED = 2;</code>
       */
      public static final int NON_SUMMARY_SEEKING_QUERY_IGNORED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The out-of-domain query ignored case.
       *
       * Google skips the summary if there are no high-relevance search results.
       * For example, the data store contains facts about company A but the
       * user query is asking questions about company B.
       * </pre>
       *
       * <code>OUT_OF_DOMAIN_QUERY_IGNORED = 3;</code>
       */
      public static final int OUT_OF_DOMAIN_QUERY_IGNORED_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The potential policy violation case.
       *
       * Google skips the summary if there is a potential policy violation
       * detected. This includes content that may be violent or toxic.
       * </pre>
       *
       * <code>POTENTIAL_POLICY_VIOLATION = 4;</code>
       */
      public static final int POTENTIAL_POLICY_VIOLATION_VALUE = 4;
      /**
       *
       *
       * <pre>
       * The LLM addon not enabled case.
       *
       * Google skips the summary if the LLM addon is not enabled.
       * </pre>
       *
       * <code>LLM_ADDON_NOT_ENABLED = 5;</code>
       */
      public static final int LLM_ADDON_NOT_ENABLED_VALUE = 5;
      /**
       *
       *
       * <pre>
       * The no relevant content case.
       *
       * Google skips the summary if there is no relevant content in the
       * retrieved search results.
       * </pre>
       *
       * <code>NO_RELEVANT_CONTENT = 6;</code>
       */
      public static final int NO_RELEVANT_CONTENT_VALUE = 6;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SummarySkippedReason valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static SummarySkippedReason forNumber(int value) {
        switch (value) {
          case 0:
            return SUMMARY_SKIPPED_REASON_UNSPECIFIED;
          case 1:
            return ADVERSARIAL_QUERY_IGNORED;
          case 2:
            return NON_SUMMARY_SEEKING_QUERY_IGNORED;
          case 3:
            return OUT_OF_DOMAIN_QUERY_IGNORED;
          case 4:
            return POTENTIAL_POLICY_VIOLATION;
          case 5:
            return LLM_ADDON_NOT_ENABLED;
          case 6:
            return NO_RELEVANT_CONTENT;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<SummarySkippedReason>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<SummarySkippedReason>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<SummarySkippedReason>() {
                public SummarySkippedReason findValueByNumber(int number) {
                  return SummarySkippedReason.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final SummarySkippedReason[] VALUES = values();

      public static SummarySkippedReason valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private SummarySkippedReason(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason)
    }

    public interface SafetyAttributesOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @return A list containing the categories.
       */
      java.util.List<java.lang.String> getCategoriesList();
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @return The count of categories.
       */
      int getCategoriesCount();
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The categories at the given index.
       */
      java.lang.String getCategories(int index);
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the categories at the given index.
       */
      com.google.protobuf.ByteString getCategoriesBytes(int index);

      /**
       *
       *
       * <pre>
       * The confidence scores of the each category, higher
       * value means higher confidence. Order matches the Categories.
       * </pre>
       *
       * <code>repeated float scores = 2;</code>
       *
       * @return A list containing the scores.
       */
      java.util.List<java.lang.Float> getScoresList();
      /**
       *
       *
       * <pre>
       * The confidence scores of the each category, higher
       * value means higher confidence. Order matches the Categories.
       * </pre>
       *
       * <code>repeated float scores = 2;</code>
       *
       * @return The count of scores.
       */
      int getScoresCount();
      /**
       *
       *
       * <pre>
       * The confidence scores of the each category, higher
       * value means higher confidence. Order matches the Categories.
       * </pre>
       *
       * <code>repeated float scores = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The scores at the given index.
       */
      float getScores(int index);
    }
    /**
     *
     *
     * <pre>
     * Safety Attribute categories and their associated confidence scores.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes}
     */
    public static final class SafetyAttributes extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes)
        SafetyAttributesOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SafetyAttributes.newBuilder() to construct.
      private SafetyAttributes(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SafetyAttributes() {
        categories_ = com.google.protobuf.LazyStringArrayList.emptyList();
        scores_ = emptyFloatList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SafetyAttributes();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_SafetyAttributes_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_SafetyAttributes_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
                    .class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
                    .Builder.class);
      }

      public static final int CATEGORIES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList categories_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @return A list containing the categories.
       */
      public com.google.protobuf.ProtocolStringList getCategoriesList() {
        return categories_;
      }
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @return The count of categories.
       */
      public int getCategoriesCount() {
        return categories_.size();
      }
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The categories at the given index.
       */
      public java.lang.String getCategories(int index) {
        return categories_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the categories at the given index.
       */
      public com.google.protobuf.ByteString getCategoriesBytes(int index) {
        return categories_.getByteString(index);
      }

      public static final int SCORES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.Internal.FloatList scores_ = emptyFloatList();
      /**
       *
       *
       * <pre>
       * The confidence scores of the each category, higher
       * value means higher confidence. Order matches the Categories.
       * </pre>
       *
       * <code>repeated float scores = 2;</code>
       *
       * @return A list containing the scores.
       */
      @java.lang.Override
      public java.util.List<java.lang.Float> getScoresList() {
        return scores_;
      }
      /**
       *
       *
       * <pre>
       * The confidence scores of the each category, higher
       * value means higher confidence. Order matches the Categories.
       * </pre>
       *
       * <code>repeated float scores = 2;</code>
       *
       * @return The count of scores.
       */
      public int getScoresCount() {
        return scores_.size();
      }
      /**
       *
       *
       * <pre>
       * The confidence scores of the each category, higher
       * value means higher confidence. Order matches the Categories.
       * </pre>
       *
       * <code>repeated float scores = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The scores at the given index.
       */
      public float getScores(int index) {
        return scores_.getFloat(index);
      }

      private int scoresMemoizedSerializedSize = -1;

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        for (int i = 0; i < categories_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, categories_.getRaw(i));
        }
        if (getScoresList().size() > 0) {
          output.writeUInt32NoTag(18);
          output.writeUInt32NoTag(scoresMemoizedSerializedSize);
        }
        for (int i = 0; i < scores_.size(); i++) {
          output.writeFloatNoTag(scores_.getFloat(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < categories_.size(); i++) {
            dataSize += computeStringSizeNoTag(categories_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getCategoriesList().size();
        }
        {
          int dataSize = 0;
          dataSize = 4 * getScoresList().size();
          size += dataSize;
          if (!getScoresList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
          }
          scoresMemoizedSerializedSize = dataSize;
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes other =
            (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes) obj;

        if (!getCategoriesList().equals(other.getCategoriesList())) return false;
        if (!getScoresList().equals(other.getScoresList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getCategoriesCount() > 0) {
          hash = (37 * hash) + CATEGORIES_FIELD_NUMBER;
          hash = (53 * hash) + getCategoriesList().hashCode();
        }
        if (getScoresCount() > 0) {
          hash = (37 * hash) + SCORES_FIELD_NUMBER;
          hash = (53 * hash) + getScoresList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Safety Attribute categories and their associated confidence scores.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes)
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributesOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_SafetyAttributes_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_SafetyAttributes_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
                      .class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          categories_ = com.google.protobuf.LazyStringArrayList.emptyList();
          scores_ = emptyFloatList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_SafetyAttributes_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
            build() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes result =
              new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            categories_.makeImmutable();
            result.categories_ = categories_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            scores_.makeImmutable();
            result.scores_ = scores_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
                  .getDefaultInstance()) return this;
          if (!other.categories_.isEmpty()) {
            if (categories_.isEmpty()) {
              categories_ = other.categories_;
              bitField0_ |= 0x00000001;
            } else {
              ensureCategoriesIsMutable();
              categories_.addAll(other.categories_);
            }
            onChanged();
          }
          if (!other.scores_.isEmpty()) {
            if (scores_.isEmpty()) {
              scores_ = other.scores_;
              scores_.makeImmutable();
              bitField0_ |= 0x00000002;
            } else {
              ensureScoresIsMutable();
              scores_.addAll(other.scores_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureCategoriesIsMutable();
                    categories_.add(s);
                    break;
                  } // case 10
                case 21:
                  {
                    float v = input.readFloat();
                    ensureScoresIsMutable();
                    scores_.addFloat(v);
                    break;
                  } // case 21
                case 18:
                  {
                    int length = input.readRawVarint32();
                    int limit = input.pushLimit(length);
                    int alloc = length > 4096 ? 4096 : length;
                    ensureScoresIsMutable(alloc / 4);
                    while (input.getBytesUntilLimit() > 0) {
                      scores_.addFloat(input.readFloat());
                    }
                    input.popLimit(limit);
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList categories_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureCategoriesIsMutable() {
          if (!categories_.isModifiable()) {
            categories_ = new com.google.protobuf.LazyStringArrayList(categories_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @return A list containing the categories.
         */
        public com.google.protobuf.ProtocolStringList getCategoriesList() {
          categories_.makeImmutable();
          return categories_;
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @return The count of categories.
         */
        public int getCategoriesCount() {
          return categories_.size();
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @param index The index of the element to return.
         * @return The categories at the given index.
         */
        public java.lang.String getCategories(int index) {
          return categories_.get(index);
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the categories at the given index.
         */
        public com.google.protobuf.ByteString getCategoriesBytes(int index) {
          return categories_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @param index The index to set the value at.
         * @param value The categories to set.
         * @return This builder for chaining.
         */
        public Builder setCategories(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCategoriesIsMutable();
          categories_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @param value The categories to add.
         * @return This builder for chaining.
         */
        public Builder addCategories(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCategoriesIsMutable();
          categories_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @param values The categories to add.
         * @return This builder for chaining.
         */
        public Builder addAllCategories(java.lang.Iterable<java.lang.String> values) {
          ensureCategoriesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, categories_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCategories() {
          categories_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @param value The bytes of the categories to add.
         * @return This builder for chaining.
         */
        public Builder addCategoriesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureCategoriesIsMutable();
          categories_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Internal.FloatList scores_ = emptyFloatList();

        private void ensureScoresIsMutable() {
          if (!scores_.isModifiable()) {
            scores_ = makeMutableCopy(scores_);
          }
          bitField0_ |= 0x00000002;
        }

        private void ensureScoresIsMutable(int capacity) {
          if (!scores_.isModifiable()) {
            scores_ = makeMutableCopy(scores_, capacity);
          }
          bitField0_ |= 0x00000002;
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @return A list containing the scores.
         */
        public java.util.List<java.lang.Float> getScoresList() {
          scores_.makeImmutable();
          return scores_;
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @return The count of scores.
         */
        public int getScoresCount() {
          return scores_.size();
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @param index The index of the element to return.
         * @return The scores at the given index.
         */
        public float getScores(int index) {
          return scores_.getFloat(index);
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @param index The index to set the value at.
         * @param value The scores to set.
         * @return This builder for chaining.
         */
        public Builder setScores(int index, float value) {

          ensureScoresIsMutable();
          scores_.setFloat(index, value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @param value The scores to add.
         * @return This builder for chaining.
         */
        public Builder addScores(float value) {

          ensureScoresIsMutable();
          scores_.addFloat(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @param values The scores to add.
         * @return This builder for chaining.
         */
        public Builder addAllScores(java.lang.Iterable<? extends java.lang.Float> values) {
          ensureScoresIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, scores_);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearScores() {
          scores_ = emptyFloatList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes)
      private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SafetyAttributes
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SafetyAttributes> PARSER =
          new com.google.protobuf.AbstractParser<SafetyAttributes>() {
            @java.lang.Override
            public SafetyAttributes parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SafetyAttributes> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SafetyAttributes> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CitationMetadataOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      java.util.List<com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation>
          getCitationsList();
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation getCitations(
          int index);
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      int getCitationsCount();
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationOrBuilder>
          getCitationsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationOrBuilder
          getCitationsOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Citation metadata.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata}
     */
    public static final class CitationMetadata extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata)
        CitationMetadataOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CitationMetadata.newBuilder() to construct.
      private CitationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CitationMetadata() {
        citations_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CitationMetadata();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_CitationMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_CitationMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                    .class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                    .Builder.class);
      }

      public static final int CITATIONS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation>
          citations_;
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation>
          getCitationsList() {
        return citations_;
      }
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationOrBuilder>
          getCitationsOrBuilderList() {
        return citations_;
      }
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      @java.lang.Override
      public int getCitationsCount() {
        return citations_.size();
      }
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation getCitations(
          int index) {
        return citations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationOrBuilder
          getCitationsOrBuilder(int index) {
        return citations_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < citations_.size(); i++) {
          output.writeMessage(1, citations_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < citations_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, citations_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata other =
            (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata) obj;

        if (!getCitationsList().equals(other.getCitationsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getCitationsCount() > 0) {
          hash = (37 * hash) + CITATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getCitationsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Citation metadata.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata)
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadataOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_CitationMetadata_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_CitationMetadata_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                      .class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (citationsBuilder_ == null) {
            citations_ = java.util.Collections.emptyList();
          } else {
            citations_ = null;
            citationsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_CitationMetadata_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
            build() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata result =
              new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata(
                  this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                result) {
          if (citationsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              citations_ = java.util.Collections.unmodifiableList(citations_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.citations_ = citations_;
          } else {
            result.citations_ = citationsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                result) {
          int from_bitField0_ = bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                  .getDefaultInstance()) return this;
          if (citationsBuilder_ == null) {
            if (!other.citations_.isEmpty()) {
              if (citations_.isEmpty()) {
                citations_ = other.citations_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureCitationsIsMutable();
                citations_.addAll(other.citations_);
              }
              onChanged();
            }
          } else {
            if (!other.citations_.isEmpty()) {
              if (citationsBuilder_.isEmpty()) {
                citationsBuilder_.dispose();
                citationsBuilder_ = null;
                citations_ = other.citations_;
                bitField0_ = (bitField0_ & ~0x00000001);
                citationsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getCitationsFieldBuilder()
                        : null;
              } else {
                citationsBuilder_.addAllMessages(other.citations_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
                                .parser(),
                            extensionRegistry);
                    if (citationsBuilder_ == null) {
                      ensureCitationsIsMutable();
                      citations_.add(m);
                    } else {
                      citationsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation>
            citations_ = java.util.Collections.emptyList();

        private void ensureCitationsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            citations_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation>(
                    citations_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationOrBuilder>
            citationsBuilder_;

        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation>
            getCitationsList() {
          if (citationsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(citations_);
          } else {
            return citationsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public int getCitationsCount() {
          if (citationsBuilder_ == null) {
            return citations_.size();
          } else {
            return citationsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation getCitations(
            int index) {
          if (citationsBuilder_ == null) {
            return citations_.get(index);
          } else {
            return citationsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder setCitations(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation value) {
          if (citationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCitationsIsMutable();
            citations_.set(index, value);
            onChanged();
          } else {
            citationsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder setCitations(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.Builder
                builderForValue) {
          if (citationsBuilder_ == null) {
            ensureCitationsIsMutable();
            citations_.set(index, builderForValue.build());
            onChanged();
          } else {
            citationsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder addCitations(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation value) {
          if (citationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCitationsIsMutable();
            citations_.add(value);
            onChanged();
          } else {
            citationsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder addCitations(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation value) {
          if (citationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCitationsIsMutable();
            citations_.add(index, value);
            onChanged();
          } else {
            citationsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder addCitations(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.Builder
                builderForValue) {
          if (citationsBuilder_ == null) {
            ensureCitationsIsMutable();
            citations_.add(builderForValue.build());
            onChanged();
          } else {
            citationsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder addCitations(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.Builder
                builderForValue) {
          if (citationsBuilder_ == null) {
            ensureCitationsIsMutable();
            citations_.add(index, builderForValue.build());
            onChanged();
          } else {
            citationsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder addAllCitations(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation>
                values) {
          if (citationsBuilder_ == null) {
            ensureCitationsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, citations_);
            onChanged();
          } else {
            citationsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder clearCitations() {
          if (citationsBuilder_ == null) {
            citations_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            citationsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder removeCitations(int index) {
          if (citationsBuilder_ == null) {
            ensureCitationsIsMutable();
            citations_.remove(index);
            onChanged();
          } else {
            citationsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.Builder
            getCitationsBuilder(int index) {
          return getCitationsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationOrBuilder
            getCitationsOrBuilder(int index) {
          if (citationsBuilder_ == null) {
            return citations_.get(index);
          } else {
            return citationsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                        .CitationOrBuilder>
            getCitationsOrBuilderList() {
          if (citationsBuilder_ != null) {
            return citationsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(citations_);
          }
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.Builder
            addCitationsBuilder() {
          return getCitationsFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.Builder
            addCitationsBuilder(int index) {
          return getCitationsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.Builder>
            getCitationsBuilderList() {
          return getCitationsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationOrBuilder>
            getCitationsFieldBuilder() {
          if (citationsBuilder_ == null) {
            citationsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.Builder,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                        .CitationOrBuilder>(
                    citations_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            citations_ = null;
          }
          return citationsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata)
      private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .CitationMetadata
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CitationMetadata> PARSER =
          new com.google.protobuf.AbstractParser<CitationMetadata>() {
            @java.lang.Override
            public CitationMetadata parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CitationMetadata> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CitationMetadata> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CitationOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Index indicates the start of the segment, measured in bytes/unicode.
       * </pre>
       *
       * <code>int64 start_index = 1;</code>
       *
       * @return The startIndex.
       */
      long getStartIndex();

      /**
       *
       *
       * <pre>
       * End of the attributed segment, exclusive.
       * </pre>
       *
       * <code>int64 end_index = 2;</code>
       *
       * @return The endIndex.
       */
      long getEndIndex();

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      java.util.List<com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource>
          getSourcesList();
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource getSources(
          int index);
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      int getSourcesCount();
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                      .CitationSourceOrBuilder>
          getSourcesOrBuilderList();
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSourceOrBuilder
          getSourcesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Citation info for a segment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation}
     */
    public static final class Citation extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation)
        CitationOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Citation.newBuilder() to construct.
      private Citation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Citation() {
        sources_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Citation();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Citation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Citation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.Builder
                    .class);
      }

      public static final int START_INDEX_FIELD_NUMBER = 1;
      private long startIndex_ = 0L;
      /**
       *
       *
       * <pre>
       * Index indicates the start of the segment, measured in bytes/unicode.
       * </pre>
       *
       * <code>int64 start_index = 1;</code>
       *
       * @return The startIndex.
       */
      @java.lang.Override
      public long getStartIndex() {
        return startIndex_;
      }

      public static final int END_INDEX_FIELD_NUMBER = 2;
      private long endIndex_ = 0L;
      /**
       *
       *
       * <pre>
       * End of the attributed segment, exclusive.
       * </pre>
       *
       * <code>int64 end_index = 2;</code>
       *
       * @return The endIndex.
       */
      @java.lang.Override
      public long getEndIndex() {
        return endIndex_;
      }

      public static final int SOURCES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource>
          sources_;
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource>
          getSourcesList() {
        return sources_;
      }
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                      .CitationSourceOrBuilder>
          getSourcesOrBuilderList() {
        return sources_;
      }
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      @java.lang.Override
      public int getSourcesCount() {
        return sources_.size();
      }
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          getSources(int index) {
        return sources_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSourceOrBuilder
          getSourcesOrBuilder(int index) {
        return sources_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (startIndex_ != 0L) {
          output.writeInt64(1, startIndex_);
        }
        if (endIndex_ != 0L) {
          output.writeInt64(2, endIndex_);
        }
        for (int i = 0; i < sources_.size(); i++) {
          output.writeMessage(3, sources_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (startIndex_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, startIndex_);
        }
        if (endIndex_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, endIndex_);
        }
        for (int i = 0; i < sources_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, sources_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation other =
            (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation) obj;

        if (getStartIndex() != other.getStartIndex()) return false;
        if (getEndIndex() != other.getEndIndex()) return false;
        if (!getSourcesList().equals(other.getSourcesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + START_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStartIndex());
        hash = (37 * hash) + END_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEndIndex());
        if (getSourcesCount() > 0) {
          hash = (37 * hash) + SOURCES_FIELD_NUMBER;
          hash = (53 * hash) + getSourcesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Citation info for a segment.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation)
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Citation_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Citation_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          startIndex_ = 0L;
          endIndex_ = 0L;
          if (sourcesBuilder_ == null) {
            sources_ = java.util.Collections.emptyList();
          } else {
            sources_ = null;
            sourcesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Citation_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation build() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation result =
              new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation result) {
          if (sourcesBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              sources_ = java.util.Collections.unmodifiableList(sources_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.sources_ = sources_;
          } else {
            result.sources_ = sourcesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.startIndex_ = startIndex_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.endIndex_ = endIndex_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
                  .getDefaultInstance()) return this;
          if (other.getStartIndex() != 0L) {
            setStartIndex(other.getStartIndex());
          }
          if (other.getEndIndex() != 0L) {
            setEndIndex(other.getEndIndex());
          }
          if (sourcesBuilder_ == null) {
            if (!other.sources_.isEmpty()) {
              if (sources_.isEmpty()) {
                sources_ = other.sources_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureSourcesIsMutable();
                sources_.addAll(other.sources_);
              }
              onChanged();
            }
          } else {
            if (!other.sources_.isEmpty()) {
              if (sourcesBuilder_.isEmpty()) {
                sourcesBuilder_.dispose();
                sourcesBuilder_ = null;
                sources_ = other.sources_;
                bitField0_ = (bitField0_ & ~0x00000004);
                sourcesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getSourcesFieldBuilder()
                        : null;
              } else {
                sourcesBuilder_.addAllMessages(other.sources_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    startIndex_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    endIndex_ = input.readInt64();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 26:
                  {
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
                        m =
                            input.readMessage(
                                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                                    .CitationSource.parser(),
                                extensionRegistry);
                    if (sourcesBuilder_ == null) {
                      ensureSourcesIsMutable();
                      sources_.add(m);
                    } else {
                      sourcesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long startIndex_;
        /**
         *
         *
         * <pre>
         * Index indicates the start of the segment, measured in bytes/unicode.
         * </pre>
         *
         * <code>int64 start_index = 1;</code>
         *
         * @return The startIndex.
         */
        @java.lang.Override
        public long getStartIndex() {
          return startIndex_;
        }
        /**
         *
         *
         * <pre>
         * Index indicates the start of the segment, measured in bytes/unicode.
         * </pre>
         *
         * <code>int64 start_index = 1;</code>
         *
         * @param value The startIndex to set.
         * @return This builder for chaining.
         */
        public Builder setStartIndex(long value) {

          startIndex_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Index indicates the start of the segment, measured in bytes/unicode.
         * </pre>
         *
         * <code>int64 start_index = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearStartIndex() {
          bitField0_ = (bitField0_ & ~0x00000001);
          startIndex_ = 0L;
          onChanged();
          return this;
        }

        private long endIndex_;
        /**
         *
         *
         * <pre>
         * End of the attributed segment, exclusive.
         * </pre>
         *
         * <code>int64 end_index = 2;</code>
         *
         * @return The endIndex.
         */
        @java.lang.Override
        public long getEndIndex() {
          return endIndex_;
        }
        /**
         *
         *
         * <pre>
         * End of the attributed segment, exclusive.
         * </pre>
         *
         * <code>int64 end_index = 2;</code>
         *
         * @param value The endIndex to set.
         * @return This builder for chaining.
         */
        public Builder setEndIndex(long value) {

          endIndex_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * End of the attributed segment, exclusive.
         * </pre>
         *
         * <code>int64 end_index = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEndIndex() {
          bitField0_ = (bitField0_ & ~0x00000002);
          endIndex_ = 0L;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource>
            sources_ = java.util.Collections.emptyList();

        private void ensureSourcesIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            sources_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource>(
                    sources_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
                    .Builder,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                    .CitationSourceOrBuilder>
            sourcesBuilder_;

        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource>
            getSourcesList() {
          if (sourcesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(sources_);
          } else {
            return sourcesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public int getSourcesCount() {
          if (sourcesBuilder_ == null) {
            return sources_.size();
          } else {
            return sourcesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
            getSources(int index) {
          if (sourcesBuilder_ == null) {
            return sources_.get(index);
          } else {
            return sourcesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder setSources(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource value) {
          if (sourcesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSourcesIsMutable();
            sources_.set(index, value);
            onChanged();
          } else {
            sourcesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder setSources(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource.Builder
                builderForValue) {
          if (sourcesBuilder_ == null) {
            ensureSourcesIsMutable();
            sources_.set(index, builderForValue.build());
            onChanged();
          } else {
            sourcesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder addSources(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource value) {
          if (sourcesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSourcesIsMutable();
            sources_.add(value);
            onChanged();
          } else {
            sourcesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder addSources(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource value) {
          if (sourcesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSourcesIsMutable();
            sources_.add(index, value);
            onChanged();
          } else {
            sourcesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder addSources(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource.Builder
                builderForValue) {
          if (sourcesBuilder_ == null) {
            ensureSourcesIsMutable();
            sources_.add(builderForValue.build());
            onChanged();
          } else {
            sourcesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder addSources(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource.Builder
                builderForValue) {
          if (sourcesBuilder_ == null) {
            ensureSourcesIsMutable();
            sources_.add(index, builderForValue.build());
            onChanged();
          } else {
            sourcesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder addAllSources(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                            .CitationSource>
                values) {
          if (sourcesBuilder_ == null) {
            ensureSourcesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sources_);
            onChanged();
          } else {
            sourcesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder clearSources() {
          if (sourcesBuilder_ == null) {
            sources_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            sourcesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder removeSources(int index) {
          if (sourcesBuilder_ == null) {
            ensureSourcesIsMutable();
            sources_.remove(index);
            onChanged();
          } else {
            sourcesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource.Builder
            getSourcesBuilder(int index) {
          return getSourcesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                .CitationSourceOrBuilder
            getSourcesOrBuilder(int index) {
          if (sourcesBuilder_ == null) {
            return sources_.get(index);
          } else {
            return sourcesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                        .CitationSourceOrBuilder>
            getSourcesOrBuilderList() {
          if (sourcesBuilder_ != null) {
            return sourcesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(sources_);
          }
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource.Builder
            addSourcesBuilder() {
          return getSourcesFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource.Builder
            addSourcesBuilder(int index) {
          return getSourcesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
                    .Builder>
            getSourcesBuilderList() {
          return getSourcesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
                    .Builder,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                    .CitationSourceOrBuilder>
            getSourcesFieldBuilder() {
          if (sourcesBuilder_ == null) {
            sourcesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
                        .Builder,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                        .CitationSourceOrBuilder>(
                    sources_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
            sources_ = null;
          }
          return sourcesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation)
      private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Citation> PARSER =
          new com.google.protobuf.AbstractParser<Citation>() {
            @java.lang.Override
            public Citation parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Citation> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Citation> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Citation
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CitationSourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Document reference index from SummaryWithMetadata.references.
       * It is 0-indexed and the value will be zero if the reference_index is
       * not set explicitly.
       * </pre>
       *
       * <code>int64 reference_index = 4;</code>
       *
       * @return The referenceIndex.
       */
      long getReferenceIndex();
    }
    /**
     *
     *
     * <pre>
     * Citation source.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource}
     */
    public static final class CitationSource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource)
        CitationSourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CitationSource.newBuilder() to construct.
      private CitationSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CitationSource() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CitationSource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_CitationSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_CitationSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource.class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
                    .Builder.class);
      }

      public static final int REFERENCE_INDEX_FIELD_NUMBER = 4;
      private long referenceIndex_ = 0L;
      /**
       *
       *
       * <pre>
       * Document reference index from SummaryWithMetadata.references.
       * It is 0-indexed and the value will be zero if the reference_index is
       * not set explicitly.
       * </pre>
       *
       * <code>int64 reference_index = 4;</code>
       *
       * @return The referenceIndex.
       */
      @java.lang.Override
      public long getReferenceIndex() {
        return referenceIndex_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (referenceIndex_ != 0L) {
          output.writeInt64(4, referenceIndex_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (referenceIndex_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, referenceIndex_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource other =
            (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource) obj;

        if (getReferenceIndex() != other.getReferenceIndex()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + REFERENCE_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getReferenceIndex());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Citation source.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource)
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_CitationSource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_CitationSource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
                      .class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          referenceIndex_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_CitationSource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
            build() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource result =
              new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.referenceIndex_ = referenceIndex_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
                  .getDefaultInstance()) return this;
          if (other.getReferenceIndex() != 0L) {
            setReferenceIndex(other.getReferenceIndex());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 32:
                  {
                    referenceIndex_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long referenceIndex_;
        /**
         *
         *
         * <pre>
         * Document reference index from SummaryWithMetadata.references.
         * It is 0-indexed and the value will be zero if the reference_index is
         * not set explicitly.
         * </pre>
         *
         * <code>int64 reference_index = 4;</code>
         *
         * @return The referenceIndex.
         */
        @java.lang.Override
        public long getReferenceIndex() {
          return referenceIndex_;
        }
        /**
         *
         *
         * <pre>
         * Document reference index from SummaryWithMetadata.references.
         * It is 0-indexed and the value will be zero if the reference_index is
         * not set explicitly.
         * </pre>
         *
         * <code>int64 reference_index = 4;</code>
         *
         * @param value The referenceIndex to set.
         * @return This builder for chaining.
         */
        public Builder setReferenceIndex(long value) {

          referenceIndex_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document reference index from SummaryWithMetadata.references.
         * It is 0-indexed and the value will be zero if the reference_index is
         * not set explicitly.
         * </pre>
         *
         * <code>int64 reference_index = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearReferenceIndex() {
          bitField0_ = (bitField0_ & ~0x00000001);
          referenceIndex_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource)
      private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .CitationSource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CitationSource> PARSER =
          new com.google.protobuf.AbstractParser<CitationSource>() {
            @java.lang.Override
            public CitationSource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CitationSource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CitationSource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationSource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ReferenceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();

      /**
       *
       *
       * <pre>
       * Required.
       * [Document.name][google.cloud.discoveryengine.v1beta.Document.name] of
       * the document. Full resource name of the referenced document, in the
       * format
       * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
       * </pre>
       *
       * <code>
       * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The document.
       */
      java.lang.String getDocument();
      /**
       *
       *
       * <pre>
       * Required.
       * [Document.name][google.cloud.discoveryengine.v1beta.Document.name] of
       * the document. Full resource name of the referenced document, in the
       * format
       * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
       * </pre>
       *
       * <code>
       * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for document.
       */
      com.google.protobuf.ByteString getDocumentBytes();

      /**
       *
       *
       * <pre>
       * Cloud Storage or HTTP uri for the document.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @return The uri.
       */
      java.lang.String getUri();
      /**
       *
       *
       * <pre>
       * Cloud Storage or HTTP uri for the document.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @return The bytes for uri.
       */
      com.google.protobuf.ByteString getUriBytes();

      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent>
          getChunkContentsList();
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
          getChunkContents(int index);
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      int getChunkContentsCount();
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                      .ChunkContentOrBuilder>
          getChunkContentsOrBuilderList();
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContentOrBuilder
          getChunkContentsOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Document reference.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference}
     */
    public static final class Reference extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference)
        ReferenceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Reference.newBuilder() to construct.
      private Reference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Reference() {
        title_ = "";
        document_ = "";
        uri_ = "";
        chunkContents_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Reference();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Reference_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Reference_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.Builder
                    .class);
      }

      public interface ChunkContentOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 1;</code>
         *
         * @return The content.
         */
        java.lang.String getContent();
        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 1;</code>
         *
         * @return The bytes for content.
         */
        com.google.protobuf.ByteString getContentBytes();

        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 2;</code>
         *
         * @return The pageIdentifier.
         */
        java.lang.String getPageIdentifier();
        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 2;</code>
         *
         * @return The bytes for pageIdentifier.
         */
        com.google.protobuf.ByteString getPageIdentifierBytes();
      }
      /**
       *
       *
       * <pre>
       * Chunk content.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent}
       */
      public static final class ChunkContent extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent)
          ChunkContentOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use ChunkContent.newBuilder() to construct.
        private ChunkContent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ChunkContent() {
          content_ = "";
          pageIdentifier_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ChunkContent();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Reference_ChunkContent_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Reference_ChunkContent_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                      .ChunkContent.class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                      .ChunkContent.Builder.class);
        }

        public static final int CONTENT_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object content_ = "";
        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 1;</code>
         *
         * @return The content.
         */
        @java.lang.Override
        public java.lang.String getContent() {
          java.lang.Object ref = content_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            content_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 1;</code>
         *
         * @return The bytes for content.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getContentBytes() {
          java.lang.Object ref = content_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            content_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int PAGE_IDENTIFIER_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object pageIdentifier_ = "";
        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 2;</code>
         *
         * @return The pageIdentifier.
         */
        @java.lang.Override
        public java.lang.String getPageIdentifier() {
          java.lang.Object ref = pageIdentifier_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            pageIdentifier_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 2;</code>
         *
         * @return The bytes for pageIdentifier.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getPageIdentifierBytes() {
          java.lang.Object ref = pageIdentifier_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            pageIdentifier_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, content_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, pageIdentifier_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, content_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, pageIdentifier_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                  .ChunkContent)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
              other =
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                          .ChunkContent)
                      obj;

          if (!getContent().equals(other.getContent())) return false;
          if (!getPageIdentifier().equals(other.getPageIdentifier())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + CONTENT_FIELD_NUMBER;
          hash = (53 * hash) + getContent().hashCode();
          hash = (37 * hash) + PAGE_IDENTIFIER_FIELD_NUMBER;
          hash = (53 * hash) + getPageIdentifier().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Chunk content.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent)
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContentOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Reference_ChunkContent_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Reference_ChunkContent_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                        .ChunkContent.class,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                        .ChunkContent.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            content_ = "";
            pageIdentifier_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Reference_ChunkContent_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                  .ChunkContent
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                  .ChunkContent
              build() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                  .ChunkContent
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                result =
                    new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                        .ChunkContent(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.content_ = content_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.pageIdentifier_ = pageIdentifier_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                    .ChunkContent) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                          .ChunkContent)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                    .ChunkContent.getDefaultInstance()) return this;
            if (!other.getContent().isEmpty()) {
              content_ = other.content_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getPageIdentifier().isEmpty()) {
              pageIdentifier_ = other.pageIdentifier_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      content_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      pageIdentifier_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object content_ = "";
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @return The content.
           */
          public java.lang.String getContent() {
            java.lang.Object ref = content_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              content_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @return The bytes for content.
           */
          public com.google.protobuf.ByteString getContentBytes() {
            java.lang.Object ref = content_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              content_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @param value The content to set.
           * @return This builder for chaining.
           */
          public Builder setContent(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            content_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearContent() {
            content_ = getDefaultInstance().getContent();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @param value The bytes for content to set.
           * @return This builder for chaining.
           */
          public Builder setContentBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            content_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object pageIdentifier_ = "";
          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @return The pageIdentifier.
           */
          public java.lang.String getPageIdentifier() {
            java.lang.Object ref = pageIdentifier_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              pageIdentifier_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @return The bytes for pageIdentifier.
           */
          public com.google.protobuf.ByteString getPageIdentifierBytes() {
            java.lang.Object ref = pageIdentifier_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              pageIdentifier_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @param value The pageIdentifier to set.
           * @return This builder for chaining.
           */
          public Builder setPageIdentifier(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            pageIdentifier_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPageIdentifier() {
            pageIdentifier_ = getDefaultInstance().getPageIdentifier();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @param value The bytes for pageIdentifier to set.
           * @return This builder for chaining.
           */
          public Builder setPageIdentifierBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            pageIdentifier_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent)
        private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                .Reference.ChunkContent
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                  .ChunkContent();
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContent
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<ChunkContent> PARSER =
            new com.google.protobuf.AbstractParser<ChunkContent>() {
              @java.lang.Override
              public ChunkContent parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<ChunkContent> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<ChunkContent> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int TITLE_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DOCUMENT_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object document_ = "";
      /**
       *
       *
       * <pre>
       * Required.
       * [Document.name][google.cloud.discoveryengine.v1beta.Document.name] of
       * the document. Full resource name of the referenced document, in the
       * format
       * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
       * </pre>
       *
       * <code>
       * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The document.
       */
      @java.lang.Override
      public java.lang.String getDocument() {
        java.lang.Object ref = document_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          document_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required.
       * [Document.name][google.cloud.discoveryengine.v1beta.Document.name] of
       * the document. Full resource name of the referenced document, in the
       * format
       * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
       * </pre>
       *
       * <code>
       * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for document.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDocumentBytes() {
        java.lang.Object ref = document_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          document_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int URI_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * Cloud Storage or HTTP uri for the document.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @return The uri.
       */
      @java.lang.Override
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage or HTTP uri for the document.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @return The bytes for uri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CHUNK_CONTENTS_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent>
          chunkContents_;
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent>
          getChunkContentsList() {
        return chunkContents_;
      }
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                      .ChunkContentOrBuilder>
          getChunkContentsOrBuilderList() {
        return chunkContents_;
      }
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public int getChunkContentsCount() {
        return chunkContents_.size();
      }
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
          getChunkContents(int index) {
        return chunkContents_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
              .ChunkContentOrBuilder
          getChunkContentsOrBuilder(int index) {
        return chunkContents_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, document_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uri_);
        }
        for (int i = 0; i < chunkContents_.size(); i++) {
          output.writeMessage(4, chunkContents_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, document_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uri_);
        }
        for (int i = 0; i < chunkContents_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(4, chunkContents_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference other =
            (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference) obj;

        if (!getTitle().equals(other.getTitle())) return false;
        if (!getDocument().equals(other.getDocument())) return false;
        if (!getUri().equals(other.getUri())) return false;
        if (!getChunkContentsList().equals(other.getChunkContentsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getDocument().hashCode();
        hash = (37 * hash) + URI_FIELD_NUMBER;
        hash = (53 * hash) + getUri().hashCode();
        if (getChunkContentsCount() > 0) {
          hash = (37 * hash) + CHUNK_CONTENTS_FIELD_NUMBER;
          hash = (53 * hash) + getChunkContentsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Document reference.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference)
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.ReferenceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Reference_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Reference_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          title_ = "";
          document_ = "";
          uri_ = "";
          if (chunkContentsBuilder_ == null) {
            chunkContents_ = java.util.Collections.emptyList();
          } else {
            chunkContents_ = null;
            chunkContentsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_Reference_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference build() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference result =
              new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference result) {
          if (chunkContentsBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              chunkContents_ = java.util.Collections.unmodifiableList(chunkContents_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.chunkContents_ = chunkContents_;
          } else {
            result.chunkContents_ = chunkContentsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.title_ = title_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.document_ = document_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.uri_ = uri_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                  .getDefaultInstance()) return this;
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getDocument().isEmpty()) {
            document_ = other.document_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getUri().isEmpty()) {
            uri_ = other.uri_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (chunkContentsBuilder_ == null) {
            if (!other.chunkContents_.isEmpty()) {
              if (chunkContents_.isEmpty()) {
                chunkContents_ = other.chunkContents_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureChunkContentsIsMutable();
                chunkContents_.addAll(other.chunkContents_);
              }
              onChanged();
            }
          } else {
            if (!other.chunkContents_.isEmpty()) {
              if (chunkContentsBuilder_.isEmpty()) {
                chunkContentsBuilder_.dispose();
                chunkContentsBuilder_ = null;
                chunkContents_ = other.chunkContents_;
                bitField0_ = (bitField0_ & ~0x00000008);
                chunkContentsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getChunkContentsFieldBuilder()
                        : null;
              } else {
                chunkContentsBuilder_.addAllMessages(other.chunkContents_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    title_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    document_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    uri_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                            .ChunkContent
                        m =
                            input.readMessage(
                                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                                    .Reference.ChunkContent.parser(),
                                extensionRegistry);
                    if (chunkContentsBuilder_ == null) {
                      ensureChunkContentsIsMutable();
                      chunkContents_.add(m);
                    } else {
                      chunkContentsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Title of the document.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Title of the document.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Title of the document.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          title_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Title of the document.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {
          title_ = getDefaultInstance().getTitle();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Title of the document.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          title_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object document_ = "";
        /**
         *
         *
         * <pre>
         * Required.
         * [Document.name][google.cloud.discoveryengine.v1beta.Document.name] of
         * the document. Full resource name of the referenced document, in the
         * format
         * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
         * </pre>
         *
         * <code>
         * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The document.
         */
        public java.lang.String getDocument() {
          java.lang.Object ref = document_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            document_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * [Document.name][google.cloud.discoveryengine.v1beta.Document.name] of
         * the document. Full resource name of the referenced document, in the
         * format
         * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
         * </pre>
         *
         * <code>
         * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for document.
         */
        public com.google.protobuf.ByteString getDocumentBytes() {
          java.lang.Object ref = document_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            document_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * [Document.name][google.cloud.discoveryengine.v1beta.Document.name] of
         * the document. Full resource name of the referenced document, in the
         * format
         * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
         * </pre>
         *
         * <code>
         * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The document to set.
         * @return This builder for chaining.
         */
        public Builder setDocument(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          document_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * [Document.name][google.cloud.discoveryengine.v1beta.Document.name] of
         * the document. Full resource name of the referenced document, in the
         * format
         * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
         * </pre>
         *
         * <code>
         * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDocument() {
          document_ = getDefaultInstance().getDocument();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * [Document.name][google.cloud.discoveryengine.v1beta.Document.name] of
         * the document. Full resource name of the referenced document, in the
         * format
         * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
         * </pre>
         *
         * <code>
         * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for document to set.
         * @return This builder for chaining.
         */
        public Builder setDocumentBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          document_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object uri_ = "";
        /**
         *
         *
         * <pre>
         * Cloud Storage or HTTP uri for the document.
         * </pre>
         *
         * <code>string uri = 3;</code>
         *
         * @return The uri.
         */
        public java.lang.String getUri() {
          java.lang.Object ref = uri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            uri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage or HTTP uri for the document.
         * </pre>
         *
         * <code>string uri = 3;</code>
         *
         * @return The bytes for uri.
         */
        public com.google.protobuf.ByteString getUriBytes() {
          java.lang.Object ref = uri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            uri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage or HTTP uri for the document.
         * </pre>
         *
         * <code>string uri = 3;</code>
         *
         * @param value The uri to set.
         * @return This builder for chaining.
         */
        public Builder setUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          uri_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage or HTTP uri for the document.
         * </pre>
         *
         * <code>string uri = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUri() {
          uri_ = getDefaultInstance().getUri();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage or HTTP uri for the document.
         * </pre>
         *
         * <code>string uri = 3;</code>
         *
         * @param value The bytes for uri to set.
         * @return This builder for chaining.
         */
        public Builder setUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          uri_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                    .ChunkContent>
            chunkContents_ = java.util.Collections.emptyList();

        private void ensureChunkContentsIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            chunkContents_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                        .ChunkContent>(chunkContents_);
            bitField0_ |= 0x00000008;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                    .ChunkContent,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                    .ChunkContent.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                    .ChunkContentOrBuilder>
            chunkContentsBuilder_;

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                    .ChunkContent>
            getChunkContentsList() {
          if (chunkContentsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(chunkContents_);
          } else {
            return chunkContentsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public int getChunkContentsCount() {
          if (chunkContentsBuilder_ == null) {
            return chunkContents_.size();
          } else {
            return chunkContentsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
            getChunkContents(int index) {
          if (chunkContentsBuilder_ == null) {
            return chunkContents_.get(index);
          } else {
            return chunkContentsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder setChunkContents(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                value) {
          if (chunkContentsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureChunkContentsIsMutable();
            chunkContents_.set(index, value);
            onChanged();
          } else {
            chunkContentsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder setChunkContents(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                    .Builder
                builderForValue) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            chunkContents_.set(index, builderForValue.build());
            onChanged();
          } else {
            chunkContentsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addChunkContents(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                value) {
          if (chunkContentsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureChunkContentsIsMutable();
            chunkContents_.add(value);
            onChanged();
          } else {
            chunkContentsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addChunkContents(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                value) {
          if (chunkContentsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureChunkContentsIsMutable();
            chunkContents_.add(index, value);
            onChanged();
          } else {
            chunkContentsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addChunkContents(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                    .Builder
                builderForValue) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            chunkContents_.add(builderForValue.build());
            onChanged();
          } else {
            chunkContentsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addChunkContents(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                    .Builder
                builderForValue) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            chunkContents_.add(index, builderForValue.build());
            onChanged();
          } else {
            chunkContentsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addAllChunkContents(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                            .ChunkContent>
                values) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, chunkContents_);
            onChanged();
          } else {
            chunkContentsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder clearChunkContents() {
          if (chunkContentsBuilder_ == null) {
            chunkContents_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
          } else {
            chunkContentsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder removeChunkContents(int index) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            chunkContents_.remove(index);
            onChanged();
          } else {
            chunkContentsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                .Builder
            getChunkContentsBuilder(int index) {
          return getChunkContentsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                .ChunkContentOrBuilder
            getChunkContentsOrBuilder(int index) {
          if (chunkContentsBuilder_ == null) {
            return chunkContents_.get(index);
          } else {
            return chunkContentsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                        .ChunkContentOrBuilder>
            getChunkContentsOrBuilderList() {
          if (chunkContentsBuilder_ != null) {
            return chunkContentsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(chunkContents_);
          }
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                .Builder
            addChunkContentsBuilder() {
          return getChunkContentsFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                      .ChunkContent.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent
                .Builder
            addChunkContentsBuilder(int index) {
          return getChunkContentsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                      .ChunkContent.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                    .ChunkContent.Builder>
            getChunkContentsBuilderList() {
          return getChunkContentsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                    .ChunkContent,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                    .ChunkContent.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                    .ChunkContentOrBuilder>
            getChunkContentsFieldBuilder() {
          if (chunkContentsBuilder_ == null) {
            chunkContentsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                        .ChunkContent,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                        .ChunkContent.Builder,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                        .ChunkContentOrBuilder>(
                    chunkContents_,
                    ((bitField0_ & 0x00000008) != 0),
                    getParentForChildren(),
                    isClean());
            chunkContents_ = null;
          }
          return chunkContentsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference)
      private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Reference> PARSER =
          new com.google.protobuf.AbstractParser<Reference>() {
            @java.lang.Override
            public Reference parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Reference> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Reference> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SummaryWithMetadataOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Summary text with no citation information.
       * </pre>
       *
       * <code>string summary = 1;</code>
       *
       * @return The summary.
       */
      java.lang.String getSummary();
      /**
       *
       *
       * <pre>
       * Summary text with no citation information.
       * </pre>
       *
       * <code>string summary = 1;</code>
       *
       * @return The bytes for summary.
       */
      com.google.protobuf.ByteString getSummaryBytes();

      /**
       *
       *
       * <pre>
       * Citation metadata for given summary.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
       * </code>
       *
       * @return Whether the citationMetadata field is set.
       */
      boolean hasCitationMetadata();
      /**
       *
       *
       * <pre>
       * Citation metadata for given summary.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
       * </code>
       *
       * @return The citationMetadata.
       */
      com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          getCitationMetadata();
      /**
       *
       *
       * <pre>
       * Citation metadata for given summary.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadataOrBuilder
          getCitationMetadataOrBuilder();

      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      java.util.List<com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference>
          getReferencesList();
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference getReferences(
          int index);
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      int getReferencesCount();
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.ReferenceOrBuilder>
          getReferencesOrBuilderList();
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.ReferenceOrBuilder
          getReferencesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata}
     */
    public static final class SummaryWithMetadata extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata)
        SummaryWithMetadataOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SummaryWithMetadata.newBuilder() to construct.
      private SummaryWithMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SummaryWithMetadata() {
        summary_ = "";
        references_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SummaryWithMetadata();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_SummaryWithMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_SummaryWithMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                    .class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                    .Builder.class);
      }

      private int bitField0_;
      public static final int SUMMARY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object summary_ = "";
      /**
       *
       *
       * <pre>
       * Summary text with no citation information.
       * </pre>
       *
       * <code>string summary = 1;</code>
       *
       * @return The summary.
       */
      @java.lang.Override
      public java.lang.String getSummary() {
        java.lang.Object ref = summary_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          summary_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Summary text with no citation information.
       * </pre>
       *
       * <code>string summary = 1;</code>
       *
       * @return The bytes for summary.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSummaryBytes() {
        java.lang.Object ref = summary_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          summary_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CITATION_METADATA_FIELD_NUMBER = 2;
      private com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          citationMetadata_;
      /**
       *
       *
       * <pre>
       * Citation metadata for given summary.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
       * </code>
       *
       * @return Whether the citationMetadata field is set.
       */
      @java.lang.Override
      public boolean hasCitationMetadata() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Citation metadata for given summary.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
       * </code>
       *
       * @return The citationMetadata.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
          getCitationMetadata() {
        return citationMetadata_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                .getDefaultInstance()
            : citationMetadata_;
      }
      /**
       *
       *
       * <pre>
       * Citation metadata for given summary.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .CitationMetadataOrBuilder
          getCitationMetadataOrBuilder() {
        return citationMetadata_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                .getDefaultInstance()
            : citationMetadata_;
      }

      public static final int REFERENCES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference>
          references_;
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference>
          getReferencesList() {
        return references_;
      }
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.ReferenceOrBuilder>
          getReferencesOrBuilderList() {
        return references_;
      }
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      @java.lang.Override
      public int getReferencesCount() {
        return references_.size();
      }
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference getReferences(
          int index) {
        return references_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.ReferenceOrBuilder
          getReferencesOrBuilder(int index) {
        return references_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summary_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, summary_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getCitationMetadata());
        }
        for (int i = 0; i < references_.size(); i++) {
          output.writeMessage(3, references_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summary_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, summary_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCitationMetadata());
        }
        for (int i = 0; i < references_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, references_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata other =
            (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata)
                obj;

        if (!getSummary().equals(other.getSummary())) return false;
        if (hasCitationMetadata() != other.hasCitationMetadata()) return false;
        if (hasCitationMetadata()) {
          if (!getCitationMetadata().equals(other.getCitationMetadata())) return false;
        }
        if (!getReferencesList().equals(other.getReferencesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SUMMARY_FIELD_NUMBER;
        hash = (53 * hash) + getSummary().hashCode();
        if (hasCitationMetadata()) {
          hash = (37 * hash) + CITATION_METADATA_FIELD_NUMBER;
          hash = (53 * hash) + getCitationMetadata().hashCode();
        }
        if (getReferencesCount() > 0) {
          hash = (37 * hash) + REFERENCES_FIELD_NUMBER;
          hash = (53 * hash) + getReferencesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata)
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadataOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_SummaryWithMetadata_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_SummaryWithMetadata_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                      .class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getCitationMetadataFieldBuilder();
            getReferencesFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          summary_ = "";
          citationMetadata_ = null;
          if (citationMetadataBuilder_ != null) {
            citationMetadataBuilder_.dispose();
            citationMetadataBuilder_ = null;
          }
          if (referencesBuilder_ == null) {
            references_ = java.util.Collections.emptyList();
          } else {
            references_ = null;
            referencesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_SummaryWithMetadata_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
            build() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
              result =
                  new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                      .SummaryWithMetadata(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                result) {
          if (referencesBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              references_ = java.util.Collections.unmodifiableList(references_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.references_ = references_;
          } else {
            result.references_ = referencesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.summary_ = summary_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.citationMetadata_ =
                citationMetadataBuilder_ == null
                    ? citationMetadata_
                    : citationMetadataBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                  .getDefaultInstance()) return this;
          if (!other.getSummary().isEmpty()) {
            summary_ = other.summary_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasCitationMetadata()) {
            mergeCitationMetadata(other.getCitationMetadata());
          }
          if (referencesBuilder_ == null) {
            if (!other.references_.isEmpty()) {
              if (references_.isEmpty()) {
                references_ = other.references_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureReferencesIsMutable();
                references_.addAll(other.references_);
              }
              onChanged();
            }
          } else {
            if (!other.references_.isEmpty()) {
              if (referencesBuilder_.isEmpty()) {
                referencesBuilder_.dispose();
                referencesBuilder_ = null;
                references_ = other.references_;
                bitField0_ = (bitField0_ & ~0x00000004);
                referencesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getReferencesFieldBuilder()
                        : null;
              } else {
                referencesBuilder_.addAllMessages(other.references_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    summary_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getCitationMetadataFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                                .parser(),
                            extensionRegistry);
                    if (referencesBuilder_ == null) {
                      ensureReferencesIsMutable();
                      references_.add(m);
                    } else {
                      referencesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object summary_ = "";
        /**
         *
         *
         * <pre>
         * Summary text with no citation information.
         * </pre>
         *
         * <code>string summary = 1;</code>
         *
         * @return The summary.
         */
        public java.lang.String getSummary() {
          java.lang.Object ref = summary_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            summary_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Summary text with no citation information.
         * </pre>
         *
         * <code>string summary = 1;</code>
         *
         * @return The bytes for summary.
         */
        public com.google.protobuf.ByteString getSummaryBytes() {
          java.lang.Object ref = summary_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            summary_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Summary text with no citation information.
         * </pre>
         *
         * <code>string summary = 1;</code>
         *
         * @param value The summary to set.
         * @return This builder for chaining.
         */
        public Builder setSummary(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          summary_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Summary text with no citation information.
         * </pre>
         *
         * <code>string summary = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSummary() {
          summary_ = getDefaultInstance().getSummary();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Summary text with no citation information.
         * </pre>
         *
         * <code>string summary = 1;</code>
         *
         * @param value The bytes for summary to set.
         * @return This builder for chaining.
         */
        public Builder setSummaryBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          summary_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
            citationMetadata_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                    .Builder,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                    .CitationMetadataOrBuilder>
            citationMetadataBuilder_;
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         *
         * @return Whether the citationMetadata field is set.
         */
        public boolean hasCitationMetadata() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         *
         * @return The citationMetadata.
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
            getCitationMetadata() {
          if (citationMetadataBuilder_ == null) {
            return citationMetadata_ == null
                ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                    .getDefaultInstance()
                : citationMetadata_;
          } else {
            return citationMetadataBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        public Builder setCitationMetadata(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata value) {
          if (citationMetadataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            citationMetadata_ = value;
          } else {
            citationMetadataBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        public Builder setCitationMetadata(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata.Builder
                builderForValue) {
          if (citationMetadataBuilder_ == null) {
            citationMetadata_ = builderForValue.build();
          } else {
            citationMetadataBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        public Builder mergeCitationMetadata(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata value) {
          if (citationMetadataBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && citationMetadata_ != null
                && citationMetadata_
                    != com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                        .CitationMetadata.getDefaultInstance()) {
              getCitationMetadataBuilder().mergeFrom(value);
            } else {
              citationMetadata_ = value;
            }
          } else {
            citationMetadataBuilder_.mergeFrom(value);
          }
          if (citationMetadata_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        public Builder clearCitationMetadata() {
          bitField0_ = (bitField0_ & ~0x00000002);
          citationMetadata_ = null;
          if (citationMetadataBuilder_ != null) {
            citationMetadataBuilder_.dispose();
            citationMetadataBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                .Builder
            getCitationMetadataBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getCitationMetadataFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                .CitationMetadataOrBuilder
            getCitationMetadataOrBuilder() {
          if (citationMetadataBuilder_ != null) {
            return citationMetadataBuilder_.getMessageOrBuilder();
          } else {
            return citationMetadata_ == null
                ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                    .getDefaultInstance()
                : citationMetadata_;
          }
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                    .Builder,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                    .CitationMetadataOrBuilder>
            getCitationMetadataFieldBuilder() {
          if (citationMetadataBuilder_ == null) {
            citationMetadataBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.CitationMetadata
                        .Builder,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                        .CitationMetadataOrBuilder>(
                    getCitationMetadata(), getParentForChildren(), isClean());
            citationMetadata_ = null;
          }
          return citationMetadataBuilder_;
        }

        private java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference>
            references_ = java.util.Collections.emptyList();

        private void ensureReferencesIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            references_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference>(
                    references_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.ReferenceOrBuilder>
            referencesBuilder_;

        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference>
            getReferencesList() {
          if (referencesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(references_);
          } else {
            return referencesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public int getReferencesCount() {
          if (referencesBuilder_ == null) {
            return references_.size();
          } else {
            return referencesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
            getReferences(int index) {
          if (referencesBuilder_ == null) {
            return references_.get(index);
          } else {
            return referencesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder setReferences(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference value) {
          if (referencesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureReferencesIsMutable();
            references_.set(index, value);
            onChanged();
          } else {
            referencesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder setReferences(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.Builder
                builderForValue) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            references_.set(index, builderForValue.build());
            onChanged();
          } else {
            referencesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder addReferences(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference value) {
          if (referencesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureReferencesIsMutable();
            references_.add(value);
            onChanged();
          } else {
            referencesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder addReferences(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference value) {
          if (referencesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureReferencesIsMutable();
            references_.add(index, value);
            onChanged();
          } else {
            referencesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder addReferences(
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.Builder
                builderForValue) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            references_.add(builderForValue.build());
            onChanged();
          } else {
            referencesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder addReferences(
            int index,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.Builder
                builderForValue) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            references_.add(index, builderForValue.build());
            onChanged();
          } else {
            referencesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder addAllReferences(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference>
                values) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, references_);
            onChanged();
          } else {
            referencesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder clearReferences() {
          if (referencesBuilder_ == null) {
            references_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            referencesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder removeReferences(int index) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            references_.remove(index);
            onChanged();
          } else {
            referencesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.Builder
            getReferencesBuilder(int index) {
          return getReferencesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.ReferenceOrBuilder
            getReferencesOrBuilder(int index) {
          if (referencesBuilder_ == null) {
            return references_.get(index);
          } else {
            return referencesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                        .ReferenceOrBuilder>
            getReferencesOrBuilderList() {
          if (referencesBuilder_ != null) {
            return referencesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(references_);
          }
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.Builder
            addReferencesBuilder() {
          return getReferencesFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.Builder
            addReferencesBuilder(int index) {
          return getReferencesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.Builder>
            getReferencesBuilderList() {
          return getReferencesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.ReferenceOrBuilder>
            getReferencesFieldBuilder() {
          if (referencesBuilder_ == null) {
            referencesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Reference
                        .Builder,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                        .ReferenceOrBuilder>(
                    references_,
                    ((bitField0_ & 0x00000004) != 0),
                    getParentForChildren(),
                    isClean());
            references_ = null;
          }
          return referencesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata)
      private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                .SummaryWithMetadata();
      }

      public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadata
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SummaryWithMetadata> PARSER =
          new com.google.protobuf.AbstractParser<SummaryWithMetadata>() {
            @java.lang.Override
            public SummaryWithMetadata parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SummaryWithMetadata> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SummaryWithMetadata> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int SUMMARY_TEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object summaryText_ = "";
    /**
     *
     *
     * <pre>
     * The summary content.
     * </pre>
     *
     * <code>string summary_text = 1;</code>
     *
     * @return The summaryText.
     */
    @java.lang.Override
    public java.lang.String getSummaryText() {
      java.lang.Object ref = summaryText_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        summaryText_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The summary content.
     * </pre>
     *
     * <code>string summary_text = 1;</code>
     *
     * @return The bytes for summaryText.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSummaryTextBytes() {
      java.lang.Object ref = summaryText_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        summaryText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUMMARY_SKIPPED_REASONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> summarySkippedReasons_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason>
        summarySkippedReasons_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                    .SummarySkippedReason>() {
              public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                      .SummarySkippedReason
                  convert(java.lang.Integer from) {
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason
                    result =
                        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                            .SummarySkippedReason.forNumber(from);
                return result == null
                    ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                        .SummarySkippedReason.UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @return A list containing the summarySkippedReasons.
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason>
        getSummarySkippedReasonsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason>(
          summarySkippedReasons_, summarySkippedReasons_converter_);
    }
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @return The count of summarySkippedReasons.
     */
    @java.lang.Override
    public int getSummarySkippedReasonsCount() {
      return summarySkippedReasons_.size();
    }
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The summarySkippedReasons at the given index.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason
        getSummarySkippedReasons(int index) {
      return summarySkippedReasons_converter_.convert(summarySkippedReasons_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for summarySkippedReasons.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getSummarySkippedReasonsValueList() {
      return summarySkippedReasons_;
    }
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of summarySkippedReasons at the given index.
     */
    @java.lang.Override
    public int getSummarySkippedReasonsValue(int index) {
      return summarySkippedReasons_.get(index);
    }

    private int summarySkippedReasonsMemoizedSerializedSize;

    public static final int SAFETY_ATTRIBUTES_FIELD_NUMBER = 3;
    private com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
        safetyAttributes_;
    /**
     *
     *
     * <pre>
     * A collection of Safety Attribute categories and their associated
     * confidence scores.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
     * </code>
     *
     * @return Whether the safetyAttributes field is set.
     */
    @java.lang.Override
    public boolean hasSafetyAttributes() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * A collection of Safety Attribute categories and their associated
     * confidence scores.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
     * </code>
     *
     * @return The safetyAttributes.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
        getSafetyAttributes() {
      return safetyAttributes_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
              .getDefaultInstance()
          : safetyAttributes_;
    }
    /**
     *
     *
     * <pre>
     * A collection of Safety Attribute categories and their associated
     * confidence scores.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributesOrBuilder
        getSafetyAttributesOrBuilder() {
      return safetyAttributes_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
              .getDefaultInstance()
          : safetyAttributes_;
    }

    public static final int SUMMARY_WITH_METADATA_FIELD_NUMBER = 4;
    private com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
        summaryWithMetadata_;
    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
     * </code>
     *
     * @return Whether the summaryWithMetadata field is set.
     */
    @java.lang.Override
    public boolean hasSummaryWithMetadata() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
     * </code>
     *
     * @return The summaryWithMetadata.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
        getSummaryWithMetadata() {
      return summaryWithMetadata_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
              .getDefaultInstance()
          : summaryWithMetadata_;
    }
    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
            .SummaryWithMetadataOrBuilder
        getSummaryWithMetadataOrBuilder() {
      return summaryWithMetadata_ == null
          ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
              .getDefaultInstance()
          : summaryWithMetadata_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summaryText_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, summaryText_);
      }
      if (getSummarySkippedReasonsList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(summarySkippedReasonsMemoizedSerializedSize);
      }
      for (int i = 0; i < summarySkippedReasons_.size(); i++) {
        output.writeEnumNoTag(summarySkippedReasons_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getSafetyAttributes());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getSummaryWithMetadata());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summaryText_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, summaryText_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < summarySkippedReasons_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                  summarySkippedReasons_.get(i));
        }
        size += dataSize;
        if (!getSummarySkippedReasonsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        summarySkippedReasonsMemoizedSerializedSize = dataSize;
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSafetyAttributes());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSummaryWithMetadata());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary other =
          (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary) obj;

      if (!getSummaryText().equals(other.getSummaryText())) return false;
      if (!summarySkippedReasons_.equals(other.summarySkippedReasons_)) return false;
      if (hasSafetyAttributes() != other.hasSafetyAttributes()) return false;
      if (hasSafetyAttributes()) {
        if (!getSafetyAttributes().equals(other.getSafetyAttributes())) return false;
      }
      if (hasSummaryWithMetadata() != other.hasSummaryWithMetadata()) return false;
      if (hasSummaryWithMetadata()) {
        if (!getSummaryWithMetadata().equals(other.getSummaryWithMetadata())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUMMARY_TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getSummaryText().hashCode();
      if (getSummarySkippedReasonsCount() > 0) {
        hash = (37 * hash) + SUMMARY_SKIPPED_REASONS_FIELD_NUMBER;
        hash = (53 * hash) + summarySkippedReasons_.hashCode();
      }
      if (hasSafetyAttributes()) {
        hash = (37 * hash) + SAFETY_ATTRIBUTES_FIELD_NUMBER;
        hash = (53 * hash) + getSafetyAttributes().hashCode();
      }
      if (hasSummaryWithMetadata()) {
        hash = (37 * hash) + SUMMARY_WITH_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getSummaryWithMetadata().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Summary of the top N search results specified by the summary spec.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.Summary}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.Summary)
        com.google.cloud.discoveryengine.v1beta.SearchResponse.SummaryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSafetyAttributesFieldBuilder();
          getSummaryWithMetadataFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        summaryText_ = "";
        summarySkippedReasons_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        safetyAttributes_ = null;
        if (safetyAttributesBuilder_ != null) {
          safetyAttributesBuilder_.dispose();
          safetyAttributesBuilder_ = null;
        }
        summaryWithMetadata_ = null;
        if (summaryWithMetadataBuilder_ != null) {
          summaryWithMetadataBuilder_.dispose();
          summaryWithMetadataBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_Summary_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary build() {
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary result =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary result) {
        if (((bitField0_ & 0x00000002) != 0)) {
          summarySkippedReasons_ = java.util.Collections.unmodifiableList(summarySkippedReasons_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.summarySkippedReasons_ = summarySkippedReasons_;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.summaryText_ = summaryText_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.safetyAttributes_ =
              safetyAttributesBuilder_ == null
                  ? safetyAttributes_
                  : safetyAttributesBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.summaryWithMetadata_ =
              summaryWithMetadataBuilder_ == null
                  ? summaryWithMetadata_
                  : summaryWithMetadataBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary) {
          return mergeFrom((com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.getDefaultInstance())
          return this;
        if (!other.getSummaryText().isEmpty()) {
          summaryText_ = other.summaryText_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.summarySkippedReasons_.isEmpty()) {
          if (summarySkippedReasons_.isEmpty()) {
            summarySkippedReasons_ = other.summarySkippedReasons_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSummarySkippedReasonsIsMutable();
            summarySkippedReasons_.addAll(other.summarySkippedReasons_);
          }
          onChanged();
        }
        if (other.hasSafetyAttributes()) {
          mergeSafetyAttributes(other.getSafetyAttributes());
        }
        if (other.hasSummaryWithMetadata()) {
          mergeSummaryWithMetadata(other.getSummaryWithMetadata());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  summaryText_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  int tmpRaw = input.readEnum();
                  ensureSummarySkippedReasonsIsMutable();
                  summarySkippedReasons_.add(tmpRaw);
                  break;
                } // case 16
              case 18:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureSummarySkippedReasonsIsMutable();
                    summarySkippedReasons_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getSafetyAttributesFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getSummaryWithMetadataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object summaryText_ = "";
      /**
       *
       *
       * <pre>
       * The summary content.
       * </pre>
       *
       * <code>string summary_text = 1;</code>
       *
       * @return The summaryText.
       */
      public java.lang.String getSummaryText() {
        java.lang.Object ref = summaryText_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          summaryText_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The summary content.
       * </pre>
       *
       * <code>string summary_text = 1;</code>
       *
       * @return The bytes for summaryText.
       */
      public com.google.protobuf.ByteString getSummaryTextBytes() {
        java.lang.Object ref = summaryText_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          summaryText_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The summary content.
       * </pre>
       *
       * <code>string summary_text = 1;</code>
       *
       * @param value The summaryText to set.
       * @return This builder for chaining.
       */
      public Builder setSummaryText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        summaryText_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The summary content.
       * </pre>
       *
       * <code>string summary_text = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSummaryText() {
        summaryText_ = getDefaultInstance().getSummaryText();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The summary content.
       * </pre>
       *
       * <code>string summary_text = 1;</code>
       *
       * @param value The bytes for summaryText to set.
       * @return This builder for chaining.
       */
      public Builder setSummaryTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        summaryText_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> summarySkippedReasons_ =
          java.util.Collections.emptyList();

      private void ensureSummarySkippedReasonsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          summarySkippedReasons_ =
              new java.util.ArrayList<java.lang.Integer>(summarySkippedReasons_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @return A list containing the summarySkippedReasons.
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason>
          getSummarySkippedReasonsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer,
            com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason>(
            summarySkippedReasons_, summarySkippedReasons_converter_);
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @return The count of summarySkippedReasons.
       */
      public int getSummarySkippedReasonsCount() {
        return summarySkippedReasons_.size();
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The summarySkippedReasons at the given index.
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason
          getSummarySkippedReasons(int index) {
        return summarySkippedReasons_converter_.convert(summarySkippedReasons_.get(index));
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The summarySkippedReasons to set.
       * @return This builder for chaining.
       */
      public Builder setSummarySkippedReasons(
          int index,
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSummarySkippedReasonsIsMutable();
        summarySkippedReasons_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param value The summarySkippedReasons to add.
       * @return This builder for chaining.
       */
      public Builder addSummarySkippedReasons(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSummarySkippedReasonsIsMutable();
        summarySkippedReasons_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param values The summarySkippedReasons to add.
       * @return This builder for chaining.
       */
      public Builder addAllSummarySkippedReasons(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                          .SummarySkippedReason>
              values) {
        ensureSummarySkippedReasonsIsMutable();
        for (com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason
            value : values) {
          summarySkippedReasons_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSummarySkippedReasons() {
        summarySkippedReasons_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for summarySkippedReasons.
       */
      public java.util.List<java.lang.Integer> getSummarySkippedReasonsValueList() {
        return java.util.Collections.unmodifiableList(summarySkippedReasons_);
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of summarySkippedReasons at the given index.
       */
      public int getSummarySkippedReasonsValue(int index) {
        return summarySkippedReasons_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for summarySkippedReasons to set.
       * @return This builder for chaining.
       */
      public Builder setSummarySkippedReasonsValue(int index, int value) {
        ensureSummarySkippedReasonsIsMutable();
        summarySkippedReasons_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for summarySkippedReasons to add.
       * @return This builder for chaining.
       */
      public Builder addSummarySkippedReasonsValue(int value) {
        ensureSummarySkippedReasonsIsMutable();
        summarySkippedReasons_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param values The enum numeric values on the wire for summarySkippedReasons to add.
       * @return This builder for chaining.
       */
      public Builder addAllSummarySkippedReasonsValue(
          java.lang.Iterable<java.lang.Integer> values) {
        ensureSummarySkippedReasonsIsMutable();
        for (int value : values) {
          summarySkippedReasons_.add(value);
        }
        onChanged();
        return this;
      }

      private com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          safetyAttributes_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                  .SafetyAttributesOrBuilder>
          safetyAttributesBuilder_;
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       *
       * @return Whether the safetyAttributes field is set.
       */
      public boolean hasSafetyAttributes() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       *
       * @return The safetyAttributes.
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
          getSafetyAttributes() {
        if (safetyAttributesBuilder_ == null) {
          return safetyAttributes_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
                  .getDefaultInstance()
              : safetyAttributes_;
        } else {
          return safetyAttributesBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      public Builder setSafetyAttributes(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes value) {
        if (safetyAttributesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          safetyAttributes_ = value;
        } else {
          safetyAttributesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      public Builder setSafetyAttributes(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes.Builder
              builderForValue) {
        if (safetyAttributesBuilder_ == null) {
          safetyAttributes_ = builderForValue.build();
        } else {
          safetyAttributesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      public Builder mergeSafetyAttributes(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes value) {
        if (safetyAttributesBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && safetyAttributes_ != null
              && safetyAttributes_
                  != com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
                      .getDefaultInstance()) {
            getSafetyAttributesBuilder().mergeFrom(value);
          } else {
            safetyAttributes_ = value;
          }
        } else {
          safetyAttributesBuilder_.mergeFrom(value);
        }
        if (safetyAttributes_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      public Builder clearSafetyAttributes() {
        bitField0_ = (bitField0_ & ~0x00000004);
        safetyAttributes_ = null;
        if (safetyAttributesBuilder_ != null) {
          safetyAttributesBuilder_.dispose();
          safetyAttributesBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes.Builder
          getSafetyAttributesBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getSafetyAttributesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SafetyAttributesOrBuilder
          getSafetyAttributesOrBuilder() {
        if (safetyAttributesBuilder_ != null) {
          return safetyAttributesBuilder_.getMessageOrBuilder();
        } else {
          return safetyAttributes_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
                  .getDefaultInstance()
              : safetyAttributes_;
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                  .SafetyAttributesOrBuilder>
          getSafetyAttributesFieldBuilder() {
        if (safetyAttributesBuilder_ == null) {
          safetyAttributesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SafetyAttributes
                      .Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                      .SafetyAttributesOrBuilder>(
                  getSafetyAttributes(), getParentForChildren(), isClean());
          safetyAttributes_ = null;
        }
        return safetyAttributesBuilder_;
      }

      private com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
          summaryWithMetadata_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                  .SummaryWithMetadataOrBuilder>
          summaryWithMetadataBuilder_;
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       *
       * @return Whether the summaryWithMetadata field is set.
       */
      public boolean hasSummaryWithMetadata() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       *
       * @return The summaryWithMetadata.
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
          getSummaryWithMetadata() {
        if (summaryWithMetadataBuilder_ == null) {
          return summaryWithMetadata_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                  .getDefaultInstance()
              : summaryWithMetadata_;
        } else {
          return summaryWithMetadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      public Builder setSummaryWithMetadata(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
              value) {
        if (summaryWithMetadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          summaryWithMetadata_ = value;
        } else {
          summaryWithMetadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      public Builder setSummaryWithMetadata(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata.Builder
              builderForValue) {
        if (summaryWithMetadataBuilder_ == null) {
          summaryWithMetadata_ = builderForValue.build();
        } else {
          summaryWithMetadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      public Builder mergeSummaryWithMetadata(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
              value) {
        if (summaryWithMetadataBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && summaryWithMetadata_ != null
              && summaryWithMetadata_
                  != com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                      .SummaryWithMetadata.getDefaultInstance()) {
            getSummaryWithMetadataBuilder().mergeFrom(value);
          } else {
            summaryWithMetadata_ = value;
          }
        } else {
          summaryWithMetadataBuilder_.mergeFrom(value);
        }
        if (summaryWithMetadata_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      public Builder clearSummaryWithMetadata() {
        bitField0_ = (bitField0_ & ~0x00000008);
        summaryWithMetadata_ = null;
        if (summaryWithMetadataBuilder_ != null) {
          summaryWithMetadataBuilder_.dispose();
          summaryWithMetadataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
              .Builder
          getSummaryWithMetadataBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getSummaryWithMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
              .SummaryWithMetadataOrBuilder
          getSummaryWithMetadataOrBuilder() {
        if (summaryWithMetadataBuilder_ != null) {
          return summaryWithMetadataBuilder_.getMessageOrBuilder();
        } else {
          return summaryWithMetadata_ == null
              ? com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                  .getDefaultInstance()
              : summaryWithMetadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                  .Builder,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                  .SummaryWithMetadataOrBuilder>
          getSummaryWithMetadataFieldBuilder() {
        if (summaryWithMetadataBuilder_ == null) {
          summaryWithMetadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                      .SummaryWithMetadata,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary.SummaryWithMetadata
                      .Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
                      .SummaryWithMetadataOrBuilder>(
                  getSummaryWithMetadata(), getParentForChildren(), isClean());
          summaryWithMetadata_ = null;
        }
        return summaryWithMetadataBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.Summary)
    private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Summary> PARSER =
        new com.google.protobuf.AbstractParser<Summary>() {
          @java.lang.Override
          public Summary parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Summary> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Summary> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.Summary
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GeoSearchDebugInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The address from which forward geocoding ingestion produced issues.
     * </pre>
     *
     * <code>string original_address_query = 1;</code>
     *
     * @return The originalAddressQuery.
     */
    java.lang.String getOriginalAddressQuery();
    /**
     *
     *
     * <pre>
     * The address from which forward geocoding ingestion produced issues.
     * </pre>
     *
     * <code>string original_address_query = 1;</code>
     *
     * @return The bytes for originalAddressQuery.
     */
    com.google.protobuf.ByteString getOriginalAddressQueryBytes();

    /**
     *
     *
     * <pre>
     * The error produced.
     * </pre>
     *
     * <code>string error_message = 2;</code>
     *
     * @return The errorMessage.
     */
    java.lang.String getErrorMessage();
    /**
     *
     *
     * <pre>
     * The error produced.
     * </pre>
     *
     * <code>string error_message = 2;</code>
     *
     * @return The bytes for errorMessage.
     */
    com.google.protobuf.ByteString getErrorMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * Debug information specifically related to forward geocoding issues arising
   * from Geolocation Search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo}
   */
  public static final class GeoSearchDebugInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo)
      GeoSearchDebugInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GeoSearchDebugInfo.newBuilder() to construct.
    private GeoSearchDebugInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GeoSearchDebugInfo() {
      originalAddressQuery_ = "";
      errorMessage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GeoSearchDebugInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GeoSearchDebugInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GeoSearchDebugInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo.class,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo.Builder
                  .class);
    }

    public static final int ORIGINAL_ADDRESS_QUERY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object originalAddressQuery_ = "";
    /**
     *
     *
     * <pre>
     * The address from which forward geocoding ingestion produced issues.
     * </pre>
     *
     * <code>string original_address_query = 1;</code>
     *
     * @return The originalAddressQuery.
     */
    @java.lang.Override
    public java.lang.String getOriginalAddressQuery() {
      java.lang.Object ref = originalAddressQuery_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        originalAddressQuery_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The address from which forward geocoding ingestion produced issues.
     * </pre>
     *
     * <code>string original_address_query = 1;</code>
     *
     * @return The bytes for originalAddressQuery.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOriginalAddressQueryBytes() {
      java.lang.Object ref = originalAddressQuery_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        originalAddressQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ERROR_MESSAGE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * The error produced.
     * </pre>
     *
     * <code>string error_message = 2;</code>
     *
     * @return The errorMessage.
     */
    @java.lang.Override
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The error produced.
     * </pre>
     *
     * <code>string error_message = 2;</code>
     *
     * @return The bytes for errorMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(originalAddressQuery_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, originalAddressQuery_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, errorMessage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(originalAddressQuery_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, originalAddressQuery_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, errorMessage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo other =
          (com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo) obj;

      if (!getOriginalAddressQuery().equals(other.getOriginalAddressQuery())) return false;
      if (!getErrorMessage().equals(other.getErrorMessage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ORIGINAL_ADDRESS_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getOriginalAddressQuery().hashCode();
      hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getErrorMessage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Debug information specifically related to forward geocoding issues arising
     * from Geolocation Search.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo)
        com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GeoSearchDebugInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GeoSearchDebugInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo.class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        originalAddressQuery_ = "";
        errorMessage_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_GeoSearchDebugInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo build() {
        com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo result =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.originalAddressQuery_ = originalAddressQuery_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.errorMessage_ = errorMessage_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
                .getDefaultInstance()) return this;
        if (!other.getOriginalAddressQuery().isEmpty()) {
          originalAddressQuery_ = other.originalAddressQuery_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getErrorMessage().isEmpty()) {
          errorMessage_ = other.errorMessage_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  originalAddressQuery_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  errorMessage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object originalAddressQuery_ = "";
      /**
       *
       *
       * <pre>
       * The address from which forward geocoding ingestion produced issues.
       * </pre>
       *
       * <code>string original_address_query = 1;</code>
       *
       * @return The originalAddressQuery.
       */
      public java.lang.String getOriginalAddressQuery() {
        java.lang.Object ref = originalAddressQuery_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          originalAddressQuery_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The address from which forward geocoding ingestion produced issues.
       * </pre>
       *
       * <code>string original_address_query = 1;</code>
       *
       * @return The bytes for originalAddressQuery.
       */
      public com.google.protobuf.ByteString getOriginalAddressQueryBytes() {
        java.lang.Object ref = originalAddressQuery_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          originalAddressQuery_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The address from which forward geocoding ingestion produced issues.
       * </pre>
       *
       * <code>string original_address_query = 1;</code>
       *
       * @param value The originalAddressQuery to set.
       * @return This builder for chaining.
       */
      public Builder setOriginalAddressQuery(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        originalAddressQuery_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The address from which forward geocoding ingestion produced issues.
       * </pre>
       *
       * <code>string original_address_query = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOriginalAddressQuery() {
        originalAddressQuery_ = getDefaultInstance().getOriginalAddressQuery();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The address from which forward geocoding ingestion produced issues.
       * </pre>
       *
       * <code>string original_address_query = 1;</code>
       *
       * @param value The bytes for originalAddressQuery to set.
       * @return This builder for chaining.
       */
      public Builder setOriginalAddressQueryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        originalAddressQuery_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object errorMessage_ = "";
      /**
       *
       *
       * <pre>
       * The error produced.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return The errorMessage.
       */
      public java.lang.String getErrorMessage() {
        java.lang.Object ref = errorMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          errorMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The error produced.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return The bytes for errorMessage.
       */
      public com.google.protobuf.ByteString getErrorMessageBytes() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          errorMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The error produced.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @param value The errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error produced.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearErrorMessage() {
        errorMessage_ = getDefaultInstance().getErrorMessage();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error produced.
       * </pre>
       *
       * <code>string error_message = 2;</code>
       *
       * @param value The bytes for errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        errorMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo)
    private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GeoSearchDebugInfo> PARSER =
        new com.google.protobuf.AbstractParser<GeoSearchDebugInfo>() {
          @java.lang.Override
          public GeoSearchDebugInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GeoSearchDebugInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GeoSearchDebugInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.GeoSearchDebugInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QueryExpansionInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Bool describing whether query expansion has occurred.
     * </pre>
     *
     * <code>bool expanded_query = 1;</code>
     *
     * @return The expandedQuery.
     */
    boolean getExpandedQuery();

    /**
     *
     *
     * <pre>
     * Number of pinned results. This field will only be set when expansion
     * happens and
     * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
     * is set to true.
     * </pre>
     *
     * <code>int64 pinned_result_count = 2;</code>
     *
     * @return The pinnedResultCount.
     */
    long getPinnedResultCount();
  }
  /**
   *
   *
   * <pre>
   * Information describing query expansion including whether expansion has
   * occurred.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo}
   */
  public static final class QueryExpansionInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo)
      QueryExpansionInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QueryExpansionInfo.newBuilder() to construct.
    private QueryExpansionInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueryExpansionInfo() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueryExpansionInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_QueryExpansionInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_QueryExpansionInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo.class,
              com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo.Builder
                  .class);
    }

    public static final int EXPANDED_QUERY_FIELD_NUMBER = 1;
    private boolean expandedQuery_ = false;
    /**
     *
     *
     * <pre>
     * Bool describing whether query expansion has occurred.
     * </pre>
     *
     * <code>bool expanded_query = 1;</code>
     *
     * @return The expandedQuery.
     */
    @java.lang.Override
    public boolean getExpandedQuery() {
      return expandedQuery_;
    }

    public static final int PINNED_RESULT_COUNT_FIELD_NUMBER = 2;
    private long pinnedResultCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Number of pinned results. This field will only be set when expansion
     * happens and
     * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
     * is set to true.
     * </pre>
     *
     * <code>int64 pinned_result_count = 2;</code>
     *
     * @return The pinnedResultCount.
     */
    @java.lang.Override
    public long getPinnedResultCount() {
      return pinnedResultCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (expandedQuery_ != false) {
        output.writeBool(1, expandedQuery_);
      }
      if (pinnedResultCount_ != 0L) {
        output.writeInt64(2, pinnedResultCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (expandedQuery_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, expandedQuery_);
      }
      if (pinnedResultCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, pinnedResultCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo other =
          (com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo) obj;

      if (getExpandedQuery() != other.getExpandedQuery()) return false;
      if (getPinnedResultCount() != other.getPinnedResultCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EXPANDED_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExpandedQuery());
      hash = (37 * hash) + PINNED_RESULT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPinnedResultCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information describing query expansion including whether expansion has
     * occurred.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo)
        com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_QueryExpansionInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_QueryExpansionInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo.class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        expandedQuery_ = false;
        pinnedResultCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_QueryExpansionInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo build() {
        com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo result =
            new com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.expandedQuery_ = expandedQuery_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pinnedResultCount_ = pinnedResultCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
                .getDefaultInstance()) return this;
        if (other.getExpandedQuery() != false) {
          setExpandedQuery(other.getExpandedQuery());
        }
        if (other.getPinnedResultCount() != 0L) {
          setPinnedResultCount(other.getPinnedResultCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  expandedQuery_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  pinnedResultCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean expandedQuery_;
      /**
       *
       *
       * <pre>
       * Bool describing whether query expansion has occurred.
       * </pre>
       *
       * <code>bool expanded_query = 1;</code>
       *
       * @return The expandedQuery.
       */
      @java.lang.Override
      public boolean getExpandedQuery() {
        return expandedQuery_;
      }
      /**
       *
       *
       * <pre>
       * Bool describing whether query expansion has occurred.
       * </pre>
       *
       * <code>bool expanded_query = 1;</code>
       *
       * @param value The expandedQuery to set.
       * @return This builder for chaining.
       */
      public Builder setExpandedQuery(boolean value) {

        expandedQuery_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Bool describing whether query expansion has occurred.
       * </pre>
       *
       * <code>bool expanded_query = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExpandedQuery() {
        bitField0_ = (bitField0_ & ~0x00000001);
        expandedQuery_ = false;
        onChanged();
        return this;
      }

      private long pinnedResultCount_;
      /**
       *
       *
       * <pre>
       * Number of pinned results. This field will only be set when expansion
       * happens and
       * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
       * is set to true.
       * </pre>
       *
       * <code>int64 pinned_result_count = 2;</code>
       *
       * @return The pinnedResultCount.
       */
      @java.lang.Override
      public long getPinnedResultCount() {
        return pinnedResultCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of pinned results. This field will only be set when expansion
       * happens and
       * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
       * is set to true.
       * </pre>
       *
       * <code>int64 pinned_result_count = 2;</code>
       *
       * @param value The pinnedResultCount to set.
       * @return This builder for chaining.
       */
      public Builder setPinnedResultCount(long value) {

        pinnedResultCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of pinned results. This field will only be set when expansion
       * happens and
       * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.discoveryengine.v1beta.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
       * is set to true.
       * </pre>
       *
       * <code>int64 pinned_result_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPinnedResultCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pinnedResultCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo)
    private static final com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo();
    }

    public static com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryExpansionInfo> PARSER =
        new com.google.protobuf.AbstractParser<QueryExpansionInfo>() {
          @java.lang.Override
          public QueryExpansionInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QueryExpansionInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryExpansionInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.SearchResponse.QueryExpansionInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NaturalLanguageQueryUnderstandingInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The filters that were extracted from the input query.
     * </pre>
     *
     * <code>string extracted_filters = 1;</code>
     *
     * @return The extractedFilters.
     */
    java.lang.String getExtractedFilters();
    /**
     *
     *
     * <pre>
     * The filters that were extracted from the input query.
     * </pre>
     *
     * <code>string extracted_filters = 1;</code>
     *
     * @return The bytes for extractedFilters.
     */
    com.google.protobuf.ByteString getExtractedFiltersBytes();

    /**
     *
     *
     * <pre>
     * Rewritten input query minus the extracted filters.
     * </pre>
     *
     * <code>string rewritten_query = 2;</code>
     *
     * @return The rewrittenQuery.
     */
    java.lang.String getRewrittenQuery();
    /**
     *
     *
     * <pre>
     * Rewritten input query minus the extracted filters.
     * </pre>
     *
     * <code>string rewritten_query = 2;</code>
     *
     * @return The bytes for rewrittenQuery.
     */
    com.google.protobuf.ByteString getRewrittenQueryBytes();

    /**
     *
     *
     * <pre>
     * The filters that were extracted from the input query represented in a
     * structured form.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter structured_extracted_filter = 3;
     * </code>
     *
     * @return Whether the structuredExtractedFilter field is set.
     */
    boolean hasStructuredExtractedFilter();
    /**
     *
     *
     * <pre>
     * The filters that were extracted from the input query represented in a
     * structured form.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter structured_extracted_filter = 3;
     * </code>
     *
     * @return The structuredExtractedFilter.
     */
    com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
            .StructuredExtractedFilter
        getStructuredExtractedFilter();
    /**
     *
     *
     * <pre>
     * The filters that were extracted from the input query represented in a
     * structured form.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter structured_extracted_filter = 3;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
            .StructuredExtractedFilterOrBuilder
        getStructuredExtractedFilterOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Information describing what natural language understanding was
   * done on the input query.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo}
   */
  public static final class NaturalLanguageQueryUnderstandingInfo
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo)
      NaturalLanguageQueryUnderstandingInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NaturalLanguageQueryUnderstandingInfo.newBuilder() to construct.
    private NaturalLanguageQueryUnderstandingInfo(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NaturalLanguageQueryUnderstandingInfo() {
      extractedFilters_ = "";
      rewrittenQuery_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NaturalLanguageQueryUnderstandingInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.class,
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.Builder.class);
    }

    public interface StructuredExtractedFilterOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The expression denoting the filter that was extracted from the input
       * query in a structured form. It can be a simple expression denoting a
       * single string, numerical or geolocation constraint or a compound
       * expression which is a combination of multiple expressions connected
       * using logical (OR and AND) operators.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expression = 1;
       * </code>
       *
       * @return Whether the expression field is set.
       */
      boolean hasExpression();
      /**
       *
       *
       * <pre>
       * The expression denoting the filter that was extracted from the input
       * query in a structured form. It can be a simple expression denoting a
       * single string, numerical or geolocation constraint or a compound
       * expression which is a combination of multiple expressions connected
       * using logical (OR and AND) operators.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expression = 1;
       * </code>
       *
       * @return The expression.
       */
      com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
              .StructuredExtractedFilter.Expression
          getExpression();
      /**
       *
       *
       * <pre>
       * The expression denoting the filter that was extracted from the input
       * query in a structured form. It can be a simple expression denoting a
       * single string, numerical or geolocation constraint or a compound
       * expression which is a combination of multiple expressions connected
       * using logical (OR and AND) operators.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expression = 1;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
              .StructuredExtractedFilter.ExpressionOrBuilder
          getExpressionOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * The filters that were extracted from the input query represented in a
     * structured form.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter}
     */
    public static final class StructuredExtractedFilter
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter)
        StructuredExtractedFilterOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use StructuredExtractedFilter.newBuilder() to construct.
      private StructuredExtractedFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private StructuredExtractedFilter() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new StructuredExtractedFilter();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.class,
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Builder.class);
      }

      public interface StringConstraintOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Name of the string field as defined in the schema.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The fieldName.
         */
        java.lang.String getFieldName();
        /**
         *
         *
         * <pre>
         * Name of the string field as defined in the schema.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The bytes for fieldName.
         */
        com.google.protobuf.ByteString getFieldNameBytes();

        /**
         *
         *
         * <pre>
         * Values of the string field. The record will only be returned if the
         * field value matches one of the values specified here.
         * </pre>
         *
         * <code>repeated string values = 2;</code>
         *
         * @return A list containing the values.
         */
        java.util.List<java.lang.String> getValuesList();
        /**
         *
         *
         * <pre>
         * Values of the string field. The record will only be returned if the
         * field value matches one of the values specified here.
         * </pre>
         *
         * <code>repeated string values = 2;</code>
         *
         * @return The count of values.
         */
        int getValuesCount();
        /**
         *
         *
         * <pre>
         * Values of the string field. The record will only be returned if the
         * field value matches one of the values specified here.
         * </pre>
         *
         * <code>repeated string values = 2;</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        java.lang.String getValues(int index);
        /**
         *
         *
         * <pre>
         * Values of the string field. The record will only be returned if the
         * field value matches one of the values specified here.
         * </pre>
         *
         * <code>repeated string values = 2;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the values at the given index.
         */
        com.google.protobuf.ByteString getValuesBytes(int index);
      }
      /**
       *
       *
       * <pre>
       * Constraint expression of a string field.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint}
       */
      public static final class StringConstraint extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint)
          StringConstraintOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use StringConstraint.newBuilder() to construct.
        private StringConstraint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private StringConstraint() {
          fieldName_ = "";
          values_ = com.google.protobuf.LazyStringArrayList.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new StringConstraint();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_StringConstraint_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_StringConstraint_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraint.class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraint.Builder.class);
        }

        public static final int FIELD_NAME_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object fieldName_ = "";
        /**
         *
         *
         * <pre>
         * Name of the string field as defined in the schema.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The fieldName.
         */
        @java.lang.Override
        public java.lang.String getFieldName() {
          java.lang.Object ref = fieldName_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            fieldName_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of the string field as defined in the schema.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The bytes for fieldName.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getFieldNameBytes() {
          java.lang.Object ref = fieldName_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            fieldName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int VALUES_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList values_ =
            com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         *
         *
         * <pre>
         * Values of the string field. The record will only be returned if the
         * field value matches one of the values specified here.
         * </pre>
         *
         * <code>repeated string values = 2;</code>
         *
         * @return A list containing the values.
         */
        public com.google.protobuf.ProtocolStringList getValuesList() {
          return values_;
        }
        /**
         *
         *
         * <pre>
         * Values of the string field. The record will only be returned if the
         * field value matches one of the values specified here.
         * </pre>
         *
         * <code>repeated string values = 2;</code>
         *
         * @return The count of values.
         */
        public int getValuesCount() {
          return values_.size();
        }
        /**
         *
         *
         * <pre>
         * Values of the string field. The record will only be returned if the
         * field value matches one of the values specified here.
         * </pre>
         *
         * <code>repeated string values = 2;</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        public java.lang.String getValues(int index) {
          return values_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Values of the string field. The record will only be returned if the
         * field value matches one of the values specified here.
         * </pre>
         *
         * <code>repeated string values = 2;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the values at the given index.
         */
        public com.google.protobuf.ByteString getValuesBytes(int index) {
          return values_.getByteString(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldName_);
          }
          for (int i = 0; i < values_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, values_.getRaw(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldName_);
          }
          {
            int dataSize = 0;
            for (int i = 0; i < values_.size(); i++) {
              dataSize += computeStringSizeNoTag(values_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getValuesList().size();
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .StringConstraint)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
              other =
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .StringConstraint)
                      obj;

          if (!getFieldName().equals(other.getFieldName())) return false;
          if (!getValuesList().equals(other.getValuesList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getFieldName().hashCode();
          if (getValuesCount() > 0) {
            hash = (37 * hash) + VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getValuesList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .StringConstraint
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Constraint expression of a string field.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint)
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .StringConstraintOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_StringConstraint_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_StringConstraint_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .StringConstraint.class,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .StringConstraint.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            fieldName_ = "";
            values_ = com.google.protobuf.LazyStringArrayList.emptyList();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_StringConstraint_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
              build() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .StringConstraint
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .StringConstraint
                result =
                    new com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .StringConstraint(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraint
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.fieldName_ = fieldName_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              values_.makeImmutable();
              result.values_ = values_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .StringConstraint) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .StringConstraint)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraint
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .StringConstraint.getDefaultInstance()) return this;
            if (!other.getFieldName().isEmpty()) {
              fieldName_ = other.fieldName_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.values_.isEmpty()) {
              if (values_.isEmpty()) {
                values_ = other.values_;
                bitField0_ |= 0x00000002;
              } else {
                ensureValuesIsMutable();
                values_.addAll(other.values_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      fieldName_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureValuesIsMutable();
                      values_.add(s);
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object fieldName_ = "";
          /**
           *
           *
           * <pre>
           * Name of the string field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @return The fieldName.
           */
          public java.lang.String getFieldName() {
            java.lang.Object ref = fieldName_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              fieldName_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Name of the string field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @return The bytes for fieldName.
           */
          public com.google.protobuf.ByteString getFieldNameBytes() {
            java.lang.Object ref = fieldName_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              fieldName_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Name of the string field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @param value The fieldName to set.
           * @return This builder for chaining.
           */
          public Builder setFieldName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            fieldName_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Name of the string field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearFieldName() {
            fieldName_ = getDefaultInstance().getFieldName();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Name of the string field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @param value The bytes for fieldName to set.
           * @return This builder for chaining.
           */
          public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            fieldName_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringArrayList values_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureValuesIsMutable() {
            if (!values_.isModifiable()) {
              values_ = new com.google.protobuf.LazyStringArrayList(values_);
            }
            bitField0_ |= 0x00000002;
          }
          /**
           *
           *
           * <pre>
           * Values of the string field. The record will only be returned if the
           * field value matches one of the values specified here.
           * </pre>
           *
           * <code>repeated string values = 2;</code>
           *
           * @return A list containing the values.
           */
          public com.google.protobuf.ProtocolStringList getValuesList() {
            values_.makeImmutable();
            return values_;
          }
          /**
           *
           *
           * <pre>
           * Values of the string field. The record will only be returned if the
           * field value matches one of the values specified here.
           * </pre>
           *
           * <code>repeated string values = 2;</code>
           *
           * @return The count of values.
           */
          public int getValuesCount() {
            return values_.size();
          }
          /**
           *
           *
           * <pre>
           * Values of the string field. The record will only be returned if the
           * field value matches one of the values specified here.
           * </pre>
           *
           * <code>repeated string values = 2;</code>
           *
           * @param index The index of the element to return.
           * @return The values at the given index.
           */
          public java.lang.String getValues(int index) {
            return values_.get(index);
          }
          /**
           *
           *
           * <pre>
           * Values of the string field. The record will only be returned if the
           * field value matches one of the values specified here.
           * </pre>
           *
           * <code>repeated string values = 2;</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the values at the given index.
           */
          public com.google.protobuf.ByteString getValuesBytes(int index) {
            return values_.getByteString(index);
          }
          /**
           *
           *
           * <pre>
           * Values of the string field. The record will only be returned if the
           * field value matches one of the values specified here.
           * </pre>
           *
           * <code>repeated string values = 2;</code>
           *
           * @param index The index to set the value at.
           * @param value The values to set.
           * @return This builder for chaining.
           */
          public Builder setValues(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureValuesIsMutable();
            values_.set(index, value);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Values of the string field. The record will only be returned if the
           * field value matches one of the values specified here.
           * </pre>
           *
           * <code>repeated string values = 2;</code>
           *
           * @param value The values to add.
           * @return This builder for chaining.
           */
          public Builder addValues(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureValuesIsMutable();
            values_.add(value);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Values of the string field. The record will only be returned if the
           * field value matches one of the values specified here.
           * </pre>
           *
           * <code>repeated string values = 2;</code>
           *
           * @param values The values to add.
           * @return This builder for chaining.
           */
          public Builder addAllValues(java.lang.Iterable<java.lang.String> values) {
            ensureValuesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Values of the string field. The record will only be returned if the
           * field value matches one of the values specified here.
           * </pre>
           *
           * <code>repeated string values = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearValues() {
            values_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            ;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Values of the string field. The record will only be returned if the
           * field value matches one of the values specified here.
           * </pre>
           *
           * <code>repeated string values = 2;</code>
           *
           * @param value The bytes of the values to add.
           * @return This builder for chaining.
           */
          public Builder addValuesBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureValuesIsMutable();
            values_.add(value);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint)
        private static final com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .StringConstraint();
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<StringConstraint> PARSER =
            new com.google.protobuf.AbstractParser<StringConstraint>() {
              @java.lang.Override
              public StringConstraint parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<StringConstraint> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<StringConstraint> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface NumberConstraintOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Name of the numerical field as defined in the schema.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The fieldName.
         */
        java.lang.String getFieldName();
        /**
         *
         *
         * <pre>
         * Name of the numerical field as defined in the schema.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The bytes for fieldName.
         */
        com.google.protobuf.ByteString getFieldNameBytes();

        /**
         *
         *
         * <pre>
         * The comparison operation performed between the field value and the
         * value specified in the constraint.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint.Comparison comparison = 2;
         * </code>
         *
         * @return The enum numeric value on the wire for comparison.
         */
        int getComparisonValue();
        /**
         *
         *
         * <pre>
         * The comparison operation performed between the field value and the
         * value specified in the constraint.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint.Comparison comparison = 2;
         * </code>
         *
         * @return The comparison.
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.NumberConstraint.Comparison
            getComparison();

        /**
         *
         *
         * <pre>
         * The value specified in the numerical constraint.
         * </pre>
         *
         * <code>double value = 3;</code>
         *
         * @return The value.
         */
        double getValue();
      }
      /**
       *
       *
       * <pre>
       * Constraint expression of a number field. Example: price &lt; 100.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint}
       */
      public static final class NumberConstraint extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint)
          NumberConstraintOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use NumberConstraint.newBuilder() to construct.
        private NumberConstraint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private NumberConstraint() {
          fieldName_ = "";
          comparison_ = 0;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new NumberConstraint();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_NumberConstraint_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_NumberConstraint_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .NumberConstraint.class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .NumberConstraint.Builder.class);
        }

        /**
         *
         *
         * <pre>
         * The comparison operation that was performed.
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint.Comparison}
         */
        public enum Comparison implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * Undefined comparison operator.
           * </pre>
           *
           * <code>COMPARISON_UNSPECIFIED = 0;</code>
           */
          COMPARISON_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * Denotes equality `=` operator.
           * </pre>
           *
           * <code>EQUALS = 1;</code>
           */
          EQUALS(1),
          /**
           *
           *
           * <pre>
           * Denotes less than or equal to `&lt;=` operator.
           * </pre>
           *
           * <code>LESS_THAN_EQUALS = 2;</code>
           */
          LESS_THAN_EQUALS(2),
          /**
           *
           *
           * <pre>
           * Denotes less than `&lt;` operator.
           * </pre>
           *
           * <code>LESS_THAN = 3;</code>
           */
          LESS_THAN(3),
          /**
           *
           *
           * <pre>
           * Denotes greater than or equal to `&gt;=` operator.
           * </pre>
           *
           * <code>GREATER_THAN_EQUALS = 4;</code>
           */
          GREATER_THAN_EQUALS(4),
          /**
           *
           *
           * <pre>
           * Denotes greater than `&gt;` operator.
           * </pre>
           *
           * <code>GREATER_THAN = 5;</code>
           */
          GREATER_THAN(5),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * Undefined comparison operator.
           * </pre>
           *
           * <code>COMPARISON_UNSPECIFIED = 0;</code>
           */
          public static final int COMPARISON_UNSPECIFIED_VALUE = 0;
          /**
           *
           *
           * <pre>
           * Denotes equality `=` operator.
           * </pre>
           *
           * <code>EQUALS = 1;</code>
           */
          public static final int EQUALS_VALUE = 1;
          /**
           *
           *
           * <pre>
           * Denotes less than or equal to `&lt;=` operator.
           * </pre>
           *
           * <code>LESS_THAN_EQUALS = 2;</code>
           */
          public static final int LESS_THAN_EQUALS_VALUE = 2;
          /**
           *
           *
           * <pre>
           * Denotes less than `&lt;` operator.
           * </pre>
           *
           * <code>LESS_THAN = 3;</code>
           */
          public static final int LESS_THAN_VALUE = 3;
          /**
           *
           *
           * <pre>
           * Denotes greater than or equal to `&gt;=` operator.
           * </pre>
           *
           * <code>GREATER_THAN_EQUALS = 4;</code>
           */
          public static final int GREATER_THAN_EQUALS_VALUE = 4;
          /**
           *
           *
           * <pre>
           * Denotes greater than `&gt;` operator.
           * </pre>
           *
           * <code>GREATER_THAN = 5;</code>
           */
          public static final int GREATER_THAN_VALUE = 5;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static Comparison valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static Comparison forNumber(int value) {
            switch (value) {
              case 0:
                return COMPARISON_UNSPECIFIED;
              case 1:
                return EQUALS;
              case 2:
                return LESS_THAN_EQUALS;
              case 3:
                return LESS_THAN;
              case 4:
                return GREATER_THAN_EQUALS;
              case 5:
                return GREATER_THAN;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<Comparison> internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<Comparison>
              internalValueMap =
                  new com.google.protobuf.Internal.EnumLiteMap<Comparison>() {
                    public Comparison findValueByNumber(int number) {
                      return Comparison.forNumber(number);
                    }
                  };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
                .getDescriptor()
                .getEnumTypes()
                .get(0);
          }

          private static final Comparison[] VALUES = values();

          public static Comparison valueOf(
              com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private Comparison(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint.Comparison)
        }

        public static final int FIELD_NAME_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object fieldName_ = "";
        /**
         *
         *
         * <pre>
         * Name of the numerical field as defined in the schema.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The fieldName.
         */
        @java.lang.Override
        public java.lang.String getFieldName() {
          java.lang.Object ref = fieldName_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            fieldName_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of the numerical field as defined in the schema.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The bytes for fieldName.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getFieldNameBytes() {
          java.lang.Object ref = fieldName_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            fieldName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int COMPARISON_FIELD_NUMBER = 2;
        private int comparison_ = 0;
        /**
         *
         *
         * <pre>
         * The comparison operation performed between the field value and the
         * value specified in the constraint.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint.Comparison comparison = 2;
         * </code>
         *
         * @return The enum numeric value on the wire for comparison.
         */
        @java.lang.Override
        public int getComparisonValue() {
          return comparison_;
        }
        /**
         *
         *
         * <pre>
         * The comparison operation performed between the field value and the
         * value specified in the constraint.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint.Comparison comparison = 2;
         * </code>
         *
         * @return The comparison.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
                .Comparison
            getComparison() {
          com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
                  .Comparison
              result =
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .NumberConstraint.Comparison.forNumber(comparison_);
          return result == null
              ? com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
                  .Comparison.UNRECOGNIZED
              : result;
        }

        public static final int VALUE_FIELD_NUMBER = 3;
        private double value_ = 0D;
        /**
         *
         *
         * <pre>
         * The value specified in the numerical constraint.
         * </pre>
         *
         * <code>double value = 3;</code>
         *
         * @return The value.
         */
        @java.lang.Override
        public double getValue() {
          return value_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldName_);
          }
          if (comparison_
              != com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
                  .Comparison.COMPARISON_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(2, comparison_);
          }
          if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
            output.writeDouble(3, value_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldName_);
          }
          if (comparison_
              != com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
                  .Comparison.COMPARISON_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, comparison_);
          }
          if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
            size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, value_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .NumberConstraint)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
              other =
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .NumberConstraint)
                      obj;

          if (!getFieldName().equals(other.getFieldName())) return false;
          if (comparison_ != other.comparison_) return false;
          if (java.lang.Double.doubleToLongBits(getValue())
              != java.lang.Double.doubleToLongBits(other.getValue())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getFieldName().hashCode();
          hash = (37 * hash) + COMPARISON_FIELD_NUMBER;
          hash = (53 * hash) + comparison_;
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getValue()));
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .NumberConstraint
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Constraint expression of a number field. Example: price &lt; 100.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint)
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .NumberConstraintOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_NumberConstraint_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_NumberConstraint_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .NumberConstraint.class,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .NumberConstraint.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            fieldName_ = "";
            comparison_ = 0;
            value_ = 0D;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_NumberConstraint_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
              build() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .NumberConstraint
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .NumberConstraint
                result =
                    new com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .NumberConstraint(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .NumberConstraint
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.fieldName_ = fieldName_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.comparison_ = comparison_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.value_ = value_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .NumberConstraint) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .NumberConstraint)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .NumberConstraint
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .NumberConstraint.getDefaultInstance()) return this;
            if (!other.getFieldName().isEmpty()) {
              fieldName_ = other.fieldName_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (other.comparison_ != 0) {
              setComparisonValue(other.getComparisonValue());
            }
            if (other.getValue() != 0D) {
              setValue(other.getValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      fieldName_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 16:
                    {
                      comparison_ = input.readEnum();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 16
                  case 25:
                    {
                      value_ = input.readDouble();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 25
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object fieldName_ = "";
          /**
           *
           *
           * <pre>
           * Name of the numerical field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @return The fieldName.
           */
          public java.lang.String getFieldName() {
            java.lang.Object ref = fieldName_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              fieldName_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Name of the numerical field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @return The bytes for fieldName.
           */
          public com.google.protobuf.ByteString getFieldNameBytes() {
            java.lang.Object ref = fieldName_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              fieldName_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Name of the numerical field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @param value The fieldName to set.
           * @return This builder for chaining.
           */
          public Builder setFieldName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            fieldName_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Name of the numerical field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearFieldName() {
            fieldName_ = getDefaultInstance().getFieldName();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Name of the numerical field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @param value The bytes for fieldName to set.
           * @return This builder for chaining.
           */
          public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            fieldName_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private int comparison_ = 0;
          /**
           *
           *
           * <pre>
           * The comparison operation performed between the field value and the
           * value specified in the constraint.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint.Comparison comparison = 2;
           * </code>
           *
           * @return The enum numeric value on the wire for comparison.
           */
          @java.lang.Override
          public int getComparisonValue() {
            return comparison_;
          }
          /**
           *
           *
           * <pre>
           * The comparison operation performed between the field value and the
           * value specified in the constraint.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint.Comparison comparison = 2;
           * </code>
           *
           * @param value The enum numeric value on the wire for comparison to set.
           * @return This builder for chaining.
           */
          public Builder setComparisonValue(int value) {
            comparison_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The comparison operation performed between the field value and the
           * value specified in the constraint.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint.Comparison comparison = 2;
           * </code>
           *
           * @return The comparison.
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
                  .Comparison
              getComparison() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .NumberConstraint.Comparison
                result =
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .NumberConstraint.Comparison.forNumber(comparison_);
            return result == null
                ? com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .NumberConstraint.Comparison.UNRECOGNIZED
                : result;
          }
          /**
           *
           *
           * <pre>
           * The comparison operation performed between the field value and the
           * value specified in the constraint.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint.Comparison comparison = 2;
           * </code>
           *
           * @param value The comparison to set.
           * @return This builder for chaining.
           */
          public Builder setComparison(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .NumberConstraint.Comparison
                  value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000002;
            comparison_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The comparison operation performed between the field value and the
           * value specified in the constraint.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint.Comparison comparison = 2;
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearComparison() {
            bitField0_ = (bitField0_ & ~0x00000002);
            comparison_ = 0;
            onChanged();
            return this;
          }

          private double value_;
          /**
           *
           *
           * <pre>
           * The value specified in the numerical constraint.
           * </pre>
           *
           * <code>double value = 3;</code>
           *
           * @return The value.
           */
          @java.lang.Override
          public double getValue() {
            return value_;
          }
          /**
           *
           *
           * <pre>
           * The value specified in the numerical constraint.
           * </pre>
           *
           * <code>double value = 3;</code>
           *
           * @param value The value to set.
           * @return This builder for chaining.
           */
          public Builder setValue(double value) {

            value_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The value specified in the numerical constraint.
           * </pre>
           *
           * <code>double value = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearValue() {
            bitField0_ = (bitField0_ & ~0x00000004);
            value_ = 0D;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint)
        private static final com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .NumberConstraint();
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<NumberConstraint> PARSER =
            new com.google.protobuf.AbstractParser<NumberConstraint>() {
              @java.lang.Override
              public NumberConstraint parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<NumberConstraint> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<NumberConstraint> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface GeolocationConstraintOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * The name of the geolocation field as defined in the schema.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The fieldName.
         */
        java.lang.String getFieldName();
        /**
         *
         *
         * <pre>
         * The name of the geolocation field as defined in the schema.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The bytes for fieldName.
         */
        com.google.protobuf.ByteString getFieldNameBytes();

        /**
         *
         *
         * <pre>
         * The reference address that was inferred from the input query. The
         * proximity of the reference address to the geolocation field will be
         * used to filter the results.
         * </pre>
         *
         * <code>string address = 2;</code>
         *
         * @return The address.
         */
        java.lang.String getAddress();
        /**
         *
         *
         * <pre>
         * The reference address that was inferred from the input query. The
         * proximity of the reference address to the geolocation field will be
         * used to filter the results.
         * </pre>
         *
         * <code>string address = 2;</code>
         *
         * @return The bytes for address.
         */
        com.google.protobuf.ByteString getAddressBytes();

        /**
         *
         *
         * <pre>
         * The radius in meters around the address. The record is returned if
         * the location of the geolocation field is within the radius.
         * </pre>
         *
         * <code>float radius_in_meters = 3;</code>
         *
         * @return The radiusInMeters.
         */
        float getRadiusInMeters();
      }
      /**
       *
       *
       * <pre>
       * Constraint of a geolocation field.
       * Name of the geolocation field as defined in the schema.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint}
       */
      public static final class GeolocationConstraint extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint)
          GeolocationConstraintOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use GeolocationConstraint.newBuilder() to construct.
        private GeolocationConstraint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private GeolocationConstraint() {
          fieldName_ = "";
          address_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new GeolocationConstraint();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_GeolocationConstraint_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_GeolocationConstraint_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .GeolocationConstraint.class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .GeolocationConstraint.Builder.class);
        }

        public static final int FIELD_NAME_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object fieldName_ = "";
        /**
         *
         *
         * <pre>
         * The name of the geolocation field as defined in the schema.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The fieldName.
         */
        @java.lang.Override
        public java.lang.String getFieldName() {
          java.lang.Object ref = fieldName_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            fieldName_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the geolocation field as defined in the schema.
         * </pre>
         *
         * <code>string field_name = 1;</code>
         *
         * @return The bytes for fieldName.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getFieldNameBytes() {
          java.lang.Object ref = fieldName_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            fieldName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int ADDRESS_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object address_ = "";
        /**
         *
         *
         * <pre>
         * The reference address that was inferred from the input query. The
         * proximity of the reference address to the geolocation field will be
         * used to filter the results.
         * </pre>
         *
         * <code>string address = 2;</code>
         *
         * @return The address.
         */
        @java.lang.Override
        public java.lang.String getAddress() {
          java.lang.Object ref = address_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            address_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The reference address that was inferred from the input query. The
         * proximity of the reference address to the geolocation field will be
         * used to filter the results.
         * </pre>
         *
         * <code>string address = 2;</code>
         *
         * @return The bytes for address.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getAddressBytes() {
          java.lang.Object ref = address_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            address_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int RADIUS_IN_METERS_FIELD_NUMBER = 3;
        private float radiusInMeters_ = 0F;
        /**
         *
         *
         * <pre>
         * The radius in meters around the address. The record is returned if
         * the location of the geolocation field is within the radius.
         * </pre>
         *
         * <code>float radius_in_meters = 3;</code>
         *
         * @return The radiusInMeters.
         */
        @java.lang.Override
        public float getRadiusInMeters() {
          return radiusInMeters_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldName_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(address_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, address_);
          }
          if (java.lang.Float.floatToRawIntBits(radiusInMeters_) != 0) {
            output.writeFloat(3, radiusInMeters_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldName_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(address_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, address_);
          }
          if (java.lang.Float.floatToRawIntBits(radiusInMeters_) != 0) {
            size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, radiusInMeters_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .GeolocationConstraint)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .GeolocationConstraint
              other =
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .GeolocationConstraint)
                      obj;

          if (!getFieldName().equals(other.getFieldName())) return false;
          if (!getAddress().equals(other.getAddress())) return false;
          if (java.lang.Float.floatToIntBits(getRadiusInMeters())
              != java.lang.Float.floatToIntBits(other.getRadiusInMeters())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getFieldName().hashCode();
          hash = (37 * hash) + ADDRESS_FIELD_NUMBER;
          hash = (53 * hash) + getAddress().hashCode();
          hash = (37 * hash) + RADIUS_IN_METERS_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getRadiusInMeters());
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .GeolocationConstraint
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Constraint of a geolocation field.
         * Name of the geolocation field as defined in the schema.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint)
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraintOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_GeolocationConstraint_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_GeolocationConstraint_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .GeolocationConstraint.class,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .GeolocationConstraint.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            fieldName_ = "";
            address_ = "";
            radiusInMeters_ = 0F;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_GeolocationConstraint_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .GeolocationConstraint
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .GeolocationConstraint
              build() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .GeolocationConstraint
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .GeolocationConstraint
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .GeolocationConstraint
                result =
                    new com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .GeolocationConstraint(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .GeolocationConstraint
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.fieldName_ = fieldName_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.address_ = address_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.radiusInMeters_ = radiusInMeters_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .GeolocationConstraint) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .GeolocationConstraint)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .GeolocationConstraint
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .GeolocationConstraint.getDefaultInstance()) return this;
            if (!other.getFieldName().isEmpty()) {
              fieldName_ = other.fieldName_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getAddress().isEmpty()) {
              address_ = other.address_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            if (other.getRadiusInMeters() != 0F) {
              setRadiusInMeters(other.getRadiusInMeters());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      fieldName_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      address_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  case 29:
                    {
                      radiusInMeters_ = input.readFloat();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 29
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object fieldName_ = "";
          /**
           *
           *
           * <pre>
           * The name of the geolocation field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @return The fieldName.
           */
          public java.lang.String getFieldName() {
            java.lang.Object ref = fieldName_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              fieldName_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The name of the geolocation field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @return The bytes for fieldName.
           */
          public com.google.protobuf.ByteString getFieldNameBytes() {
            java.lang.Object ref = fieldName_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              fieldName_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The name of the geolocation field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @param value The fieldName to set.
           * @return This builder for chaining.
           */
          public Builder setFieldName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            fieldName_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The name of the geolocation field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearFieldName() {
            fieldName_ = getDefaultInstance().getFieldName();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The name of the geolocation field as defined in the schema.
           * </pre>
           *
           * <code>string field_name = 1;</code>
           *
           * @param value The bytes for fieldName to set.
           * @return This builder for chaining.
           */
          public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            fieldName_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object address_ = "";
          /**
           *
           *
           * <pre>
           * The reference address that was inferred from the input query. The
           * proximity of the reference address to the geolocation field will be
           * used to filter the results.
           * </pre>
           *
           * <code>string address = 2;</code>
           *
           * @return The address.
           */
          public java.lang.String getAddress() {
            java.lang.Object ref = address_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              address_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The reference address that was inferred from the input query. The
           * proximity of the reference address to the geolocation field will be
           * used to filter the results.
           * </pre>
           *
           * <code>string address = 2;</code>
           *
           * @return The bytes for address.
           */
          public com.google.protobuf.ByteString getAddressBytes() {
            java.lang.Object ref = address_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              address_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The reference address that was inferred from the input query. The
           * proximity of the reference address to the geolocation field will be
           * used to filter the results.
           * </pre>
           *
           * <code>string address = 2;</code>
           *
           * @param value The address to set.
           * @return This builder for chaining.
           */
          public Builder setAddress(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            address_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The reference address that was inferred from the input query. The
           * proximity of the reference address to the geolocation field will be
           * used to filter the results.
           * </pre>
           *
           * <code>string address = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAddress() {
            address_ = getDefaultInstance().getAddress();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The reference address that was inferred from the input query. The
           * proximity of the reference address to the geolocation field will be
           * used to filter the results.
           * </pre>
           *
           * <code>string address = 2;</code>
           *
           * @param value The bytes for address to set.
           * @return This builder for chaining.
           */
          public Builder setAddressBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            address_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          private float radiusInMeters_;
          /**
           *
           *
           * <pre>
           * The radius in meters around the address. The record is returned if
           * the location of the geolocation field is within the radius.
           * </pre>
           *
           * <code>float radius_in_meters = 3;</code>
           *
           * @return The radiusInMeters.
           */
          @java.lang.Override
          public float getRadiusInMeters() {
            return radiusInMeters_;
          }
          /**
           *
           *
           * <pre>
           * The radius in meters around the address. The record is returned if
           * the location of the geolocation field is within the radius.
           * </pre>
           *
           * <code>float radius_in_meters = 3;</code>
           *
           * @param value The radiusInMeters to set.
           * @return This builder for chaining.
           */
          public Builder setRadiusInMeters(float value) {

            radiusInMeters_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The radius in meters around the address. The record is returned if
           * the location of the geolocation field is within the radius.
           * </pre>
           *
           * <code>float radius_in_meters = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearRadiusInMeters() {
            bitField0_ = (bitField0_ & ~0x00000004);
            radiusInMeters_ = 0F;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint)
        private static final com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .GeolocationConstraint();
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<GeolocationConstraint> PARSER =
            new com.google.protobuf.AbstractParser<GeolocationConstraint>() {
              @java.lang.Override
              public GeolocationConstraint parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<GeolocationConstraint> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<GeolocationConstraint> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface AndExpressionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * The expressions that were ANDed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression>
            getExpressionsList();
        /**
         *
         *
         * <pre>
         * The expressions that were ANDed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.Expression
            getExpressions(int index);
        /**
         *
         *
         * <pre>
         * The expressions that were ANDed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        int getExpressionsCount();
        /**
         *
         *
         * <pre>
         * The expressions that were ANDed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .ExpressionOrBuilder>
            getExpressionsOrBuilderList();
        /**
         *
         *
         * <pre>
         * The expressions that were ANDed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.ExpressionOrBuilder
            getExpressionsOrBuilder(int index);
      }
      /**
       *
       *
       * <pre>
       * Logical `And` operator.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression}
       */
      public static final class AndExpression extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression)
          AndExpressionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use AndExpression.newBuilder() to construct.
        private AndExpression(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private AndExpression() {
          expressions_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new AndExpression();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_AndExpression_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_AndExpression_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
                      .class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
                      .Builder.class);
        }

        public static final int EXPRESSIONS_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression>
            expressions_;
        /**
         *
         *
         * <pre>
         * The expressions that were ANDed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression>
            getExpressionsList() {
          return expressions_;
        }
        /**
         *
         *
         * <pre>
         * The expressions that were ANDed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .ExpressionOrBuilder>
            getExpressionsOrBuilderList() {
          return expressions_;
        }
        /**
         *
         *
         * <pre>
         * The expressions that were ANDed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        @java.lang.Override
        public int getExpressionsCount() {
          return expressions_.size();
        }
        /**
         *
         *
         * <pre>
         * The expressions that were ANDed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            getExpressions(int index) {
          return expressions_.get(index);
        }
        /**
         *
         *
         * <pre>
         * The expressions that were ANDed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.ExpressionOrBuilder
            getExpressionsOrBuilder(int index) {
          return expressions_.get(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          for (int i = 0; i < expressions_.size(); i++) {
            output.writeMessage(1, expressions_.get(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          for (int i = 0; i < expressions_.size(); i++) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(1, expressions_.get(i));
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
              other =
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .AndExpression)
                      obj;

          if (!getExpressionsList().equals(other.getExpressionsList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getExpressionsCount() > 0) {
            hash = (37 * hash) + EXPRESSIONS_FIELD_NUMBER;
            hash = (53 * hash) + getExpressionsList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Logical `And` operator.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression)
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .AndExpressionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_AndExpression_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_AndExpression_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .AndExpression.class,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .AndExpression.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            if (expressionsBuilder_ == null) {
              expressions_ = java.util.Collections.emptyList();
            } else {
              expressions_ = null;
              expressionsBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000001);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_AndExpression_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
              build() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
                result =
                    new com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .AndExpression(this);
            buildPartialRepeatedFields(result);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartialRepeatedFields(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
                  result) {
            if (expressionsBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)) {
                expressions_ = java.util.Collections.unmodifiableList(expressions_);
                bitField0_ = (bitField0_ & ~0x00000001);
              }
              result.expressions_ = expressions_;
            } else {
              result.expressions_ = expressionsBuilder_.build();
            }
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
                  result) {
            int from_bitField0_ = bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .AndExpression) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .AndExpression)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
                    .getDefaultInstance()) return this;
            if (expressionsBuilder_ == null) {
              if (!other.expressions_.isEmpty()) {
                if (expressions_.isEmpty()) {
                  expressions_ = other.expressions_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                } else {
                  ensureExpressionsIsMutable();
                  expressions_.addAll(other.expressions_);
                }
                onChanged();
              }
            } else {
              if (!other.expressions_.isEmpty()) {
                if (expressionsBuilder_.isEmpty()) {
                  expressionsBuilder_.dispose();
                  expressionsBuilder_ = null;
                  expressions_ = other.expressions_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                  expressionsBuilder_ =
                      com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                          ? getExpressionsFieldBuilder()
                          : null;
                } else {
                  expressionsBuilder_.addAllMessages(other.expressions_);
                }
              }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                              .Expression
                          m =
                              input.readMessage(
                                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                                      .NaturalLanguageQueryUnderstandingInfo
                                      .StructuredExtractedFilter.Expression.parser(),
                                  extensionRegistry);
                      if (expressionsBuilder_ == null) {
                        ensureExpressionsIsMutable();
                        expressions_.add(m);
                      } else {
                        expressionsBuilder_.addMessage(m);
                      }
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.util.List<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression>
              expressions_ = java.util.Collections.emptyList();

          private void ensureExpressionsIsMutable() {
            if (!((bitField0_ & 0x00000001) != 0)) {
              expressions_ =
                  new java.util.ArrayList<
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .Expression>(expressions_);
              bitField0_ |= 0x00000001;
            }
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .ExpressionOrBuilder>
              expressionsBuilder_;

          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression>
              getExpressionsList() {
            if (expressionsBuilder_ == null) {
              return java.util.Collections.unmodifiableList(expressions_);
            } else {
              return expressionsBuilder_.getMessageList();
            }
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public int getExpressionsCount() {
            if (expressionsBuilder_ == null) {
              return expressions_.size();
            } else {
              return expressionsBuilder_.getCount();
            }
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
              getExpressions(int index) {
            if (expressionsBuilder_ == null) {
              return expressions_.get(index);
            } else {
              return expressionsBuilder_.getMessage(index);
            }
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder setExpressions(
              int index,
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  value) {
            if (expressionsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureExpressionsIsMutable();
              expressions_.set(index, value);
              onChanged();
            } else {
              expressionsBuilder_.setMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder setExpressions(
              int index,
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder
                  builderForValue) {
            if (expressionsBuilder_ == null) {
              ensureExpressionsIsMutable();
              expressions_.set(index, builderForValue.build());
              onChanged();
            } else {
              expressionsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder addExpressions(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  value) {
            if (expressionsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureExpressionsIsMutable();
              expressions_.add(value);
              onChanged();
            } else {
              expressionsBuilder_.addMessage(value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder addExpressions(
              int index,
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  value) {
            if (expressionsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureExpressionsIsMutable();
              expressions_.add(index, value);
              onChanged();
            } else {
              expressionsBuilder_.addMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder addExpressions(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder
                  builderForValue) {
            if (expressionsBuilder_ == null) {
              ensureExpressionsIsMutable();
              expressions_.add(builderForValue.build());
              onChanged();
            } else {
              expressionsBuilder_.addMessage(builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder addExpressions(
              int index,
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder
                  builderForValue) {
            if (expressionsBuilder_ == null) {
              ensureExpressionsIsMutable();
              expressions_.add(index, builderForValue.build());
              onChanged();
            } else {
              expressionsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder addAllExpressions(
              java.lang.Iterable<
                      ? extends
                          com.google.cloud.discoveryengine.v1beta.SearchResponse
                              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                              .Expression>
                  values) {
            if (expressionsBuilder_ == null) {
              ensureExpressionsIsMutable();
              com.google.protobuf.AbstractMessageLite.Builder.addAll(values, expressions_);
              onChanged();
            } else {
              expressionsBuilder_.addAllMessages(values);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder clearExpressions() {
            if (expressionsBuilder_ == null) {
              expressions_ = java.util.Collections.emptyList();
              bitField0_ = (bitField0_ & ~0x00000001);
              onChanged();
            } else {
              expressionsBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder removeExpressions(int index) {
            if (expressionsBuilder_ == null) {
              ensureExpressionsIsMutable();
              expressions_.remove(index);
              onChanged();
            } else {
              expressionsBuilder_.remove(index);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  .Builder
              getExpressionsBuilder(int index) {
            return getExpressionsFieldBuilder().getBuilder(index);
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .ExpressionOrBuilder
              getExpressionsOrBuilder(int index) {
            if (expressionsBuilder_ == null) {
              return expressions_.get(index);
            } else {
              return expressionsBuilder_.getMessageOrBuilder(index);
            }
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .ExpressionOrBuilder>
              getExpressionsOrBuilderList() {
            if (expressionsBuilder_ != null) {
              return expressionsBuilder_.getMessageOrBuilderList();
            } else {
              return java.util.Collections.unmodifiableList(expressions_);
            }
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  .Builder
              addExpressionsBuilder() {
            return getExpressionsFieldBuilder()
                .addBuilder(
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                        .getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  .Builder
              addExpressionsBuilder(int index) {
            return getExpressionsFieldBuilder()
                .addBuilder(
                    index,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                        .getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ANDed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder>
              getExpressionsBuilderList() {
            return getExpressionsFieldBuilder().getBuilderList();
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .ExpressionOrBuilder>
              getExpressionsFieldBuilder() {
            if (expressionsBuilder_ == null) {
              expressionsBuilder_ =
                  new com.google.protobuf.RepeatedFieldBuilderV3<
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .Expression,
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .Expression.Builder,
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .ExpressionOrBuilder>(
                      expressions_,
                      ((bitField0_ & 0x00000001) != 0),
                      getParentForChildren(),
                      isClean());
              expressions_ = null;
            }
            return expressionsBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression)
        private static final com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression();
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<AndExpression> PARSER =
            new com.google.protobuf.AbstractParser<AndExpression>() {
              @java.lang.Override
              public AndExpression parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<AndExpression> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<AndExpression> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface OrExpressionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * The expressions that were ORed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression>
            getExpressionsList();
        /**
         *
         *
         * <pre>
         * The expressions that were ORed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.Expression
            getExpressions(int index);
        /**
         *
         *
         * <pre>
         * The expressions that were ORed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        int getExpressionsCount();
        /**
         *
         *
         * <pre>
         * The expressions that were ORed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .ExpressionOrBuilder>
            getExpressionsOrBuilderList();
        /**
         *
         *
         * <pre>
         * The expressions that were ORed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.ExpressionOrBuilder
            getExpressionsOrBuilder(int index);
      }
      /**
       *
       *
       * <pre>
       * Logical `Or` operator.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression}
       */
      public static final class OrExpression extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression)
          OrExpressionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use OrExpression.newBuilder() to construct.
        private OrExpression(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private OrExpression() {
          expressions_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new OrExpression();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_OrExpression_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_OrExpression_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
                      .class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
                      .Builder.class);
        }

        public static final int EXPRESSIONS_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression>
            expressions_;
        /**
         *
         *
         * <pre>
         * The expressions that were ORed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression>
            getExpressionsList() {
          return expressions_;
        }
        /**
         *
         *
         * <pre>
         * The expressions that were ORed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .ExpressionOrBuilder>
            getExpressionsOrBuilderList() {
          return expressions_;
        }
        /**
         *
         *
         * <pre>
         * The expressions that were ORed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        @java.lang.Override
        public int getExpressionsCount() {
          return expressions_.size();
        }
        /**
         *
         *
         * <pre>
         * The expressions that were ORed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            getExpressions(int index) {
          return expressions_.get(index);
        }
        /**
         *
         *
         * <pre>
         * The expressions that were ORed together.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.ExpressionOrBuilder
            getExpressionsOrBuilder(int index) {
          return expressions_.get(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          for (int i = 0; i < expressions_.size(); i++) {
            output.writeMessage(1, expressions_.get(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          for (int i = 0; i < expressions_.size(); i++) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(1, expressions_.get(i));
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
              other =
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .OrExpression)
                      obj;

          if (!getExpressionsList().equals(other.getExpressionsList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getExpressionsCount() > 0) {
            hash = (37 * hash) + EXPRESSIONS_FIELD_NUMBER;
            hash = (53 * hash) + getExpressionsList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Logical `Or` operator.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression)
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .OrExpressionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_OrExpression_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_OrExpression_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .OrExpression.class,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .OrExpression.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            if (expressionsBuilder_ == null) {
              expressions_ = java.util.Collections.emptyList();
            } else {
              expressions_ = null;
              expressionsBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000001);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_OrExpression_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
              build() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
                result =
                    new com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .OrExpression(this);
            buildPartialRepeatedFields(result);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartialRepeatedFields(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
                  result) {
            if (expressionsBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)) {
                expressions_ = java.util.Collections.unmodifiableList(expressions_);
                bitField0_ = (bitField0_ & ~0x00000001);
              }
              result.expressions_ = expressions_;
            } else {
              result.expressions_ = expressionsBuilder_.build();
            }
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
                  result) {
            int from_bitField0_ = bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .OrExpression)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
                    .getDefaultInstance()) return this;
            if (expressionsBuilder_ == null) {
              if (!other.expressions_.isEmpty()) {
                if (expressions_.isEmpty()) {
                  expressions_ = other.expressions_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                } else {
                  ensureExpressionsIsMutable();
                  expressions_.addAll(other.expressions_);
                }
                onChanged();
              }
            } else {
              if (!other.expressions_.isEmpty()) {
                if (expressionsBuilder_.isEmpty()) {
                  expressionsBuilder_.dispose();
                  expressionsBuilder_ = null;
                  expressions_ = other.expressions_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                  expressionsBuilder_ =
                      com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                          ? getExpressionsFieldBuilder()
                          : null;
                } else {
                  expressionsBuilder_.addAllMessages(other.expressions_);
                }
              }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                              .Expression
                          m =
                              input.readMessage(
                                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                                      .NaturalLanguageQueryUnderstandingInfo
                                      .StructuredExtractedFilter.Expression.parser(),
                                  extensionRegistry);
                      if (expressionsBuilder_ == null) {
                        ensureExpressionsIsMutable();
                        expressions_.add(m);
                      } else {
                        expressionsBuilder_.addMessage(m);
                      }
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.util.List<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression>
              expressions_ = java.util.Collections.emptyList();

          private void ensureExpressionsIsMutable() {
            if (!((bitField0_ & 0x00000001) != 0)) {
              expressions_ =
                  new java.util.ArrayList<
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .Expression>(expressions_);
              bitField0_ |= 0x00000001;
            }
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .ExpressionOrBuilder>
              expressionsBuilder_;

          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression>
              getExpressionsList() {
            if (expressionsBuilder_ == null) {
              return java.util.Collections.unmodifiableList(expressions_);
            } else {
              return expressionsBuilder_.getMessageList();
            }
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public int getExpressionsCount() {
            if (expressionsBuilder_ == null) {
              return expressions_.size();
            } else {
              return expressionsBuilder_.getCount();
            }
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
              getExpressions(int index) {
            if (expressionsBuilder_ == null) {
              return expressions_.get(index);
            } else {
              return expressionsBuilder_.getMessage(index);
            }
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder setExpressions(
              int index,
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  value) {
            if (expressionsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureExpressionsIsMutable();
              expressions_.set(index, value);
              onChanged();
            } else {
              expressionsBuilder_.setMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder setExpressions(
              int index,
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder
                  builderForValue) {
            if (expressionsBuilder_ == null) {
              ensureExpressionsIsMutable();
              expressions_.set(index, builderForValue.build());
              onChanged();
            } else {
              expressionsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder addExpressions(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  value) {
            if (expressionsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureExpressionsIsMutable();
              expressions_.add(value);
              onChanged();
            } else {
              expressionsBuilder_.addMessage(value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder addExpressions(
              int index,
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  value) {
            if (expressionsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureExpressionsIsMutable();
              expressions_.add(index, value);
              onChanged();
            } else {
              expressionsBuilder_.addMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder addExpressions(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder
                  builderForValue) {
            if (expressionsBuilder_ == null) {
              ensureExpressionsIsMutable();
              expressions_.add(builderForValue.build());
              onChanged();
            } else {
              expressionsBuilder_.addMessage(builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder addExpressions(
              int index,
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder
                  builderForValue) {
            if (expressionsBuilder_ == null) {
              ensureExpressionsIsMutable();
              expressions_.add(index, builderForValue.build());
              onChanged();
            } else {
              expressionsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder addAllExpressions(
              java.lang.Iterable<
                      ? extends
                          com.google.cloud.discoveryengine.v1beta.SearchResponse
                              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                              .Expression>
                  values) {
            if (expressionsBuilder_ == null) {
              ensureExpressionsIsMutable();
              com.google.protobuf.AbstractMessageLite.Builder.addAll(values, expressions_);
              onChanged();
            } else {
              expressionsBuilder_.addAllMessages(values);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder clearExpressions() {
            if (expressionsBuilder_ == null) {
              expressions_ = java.util.Collections.emptyList();
              bitField0_ = (bitField0_ & ~0x00000001);
              onChanged();
            } else {
              expressionsBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public Builder removeExpressions(int index) {
            if (expressionsBuilder_ == null) {
              ensureExpressionsIsMutable();
              expressions_.remove(index);
              onChanged();
            } else {
              expressionsBuilder_.remove(index);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  .Builder
              getExpressionsBuilder(int index) {
            return getExpressionsFieldBuilder().getBuilder(index);
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .ExpressionOrBuilder
              getExpressionsOrBuilder(int index) {
            if (expressionsBuilder_ == null) {
              return expressions_.get(index);
            } else {
              return expressionsBuilder_.getMessageOrBuilder(index);
            }
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .ExpressionOrBuilder>
              getExpressionsOrBuilderList() {
            if (expressionsBuilder_ != null) {
              return expressionsBuilder_.getMessageOrBuilderList();
            } else {
              return java.util.Collections.unmodifiableList(expressions_);
            }
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  .Builder
              addExpressionsBuilder() {
            return getExpressionsFieldBuilder()
                .addBuilder(
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                        .getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  .Builder
              addExpressionsBuilder(int index) {
            return getExpressionsFieldBuilder()
                .addBuilder(
                    index,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                        .getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * The expressions that were ORed together.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression expressions = 1;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder>
              getExpressionsBuilderList() {
            return getExpressionsFieldBuilder().getBuilderList();
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .ExpressionOrBuilder>
              getExpressionsFieldBuilder() {
            if (expressionsBuilder_ == null) {
              expressionsBuilder_ =
                  new com.google.protobuf.RepeatedFieldBuilderV3<
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .Expression,
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .Expression.Builder,
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .ExpressionOrBuilder>(
                      expressions_,
                      ((bitField0_ & 0x00000001) != 0),
                      getParentForChildren(),
                      isClean());
              expressions_ = null;
            }
            return expressionsBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression)
        private static final com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression();
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<OrExpression> PARSER =
            new com.google.protobuf.AbstractParser<OrExpression>() {
              @java.lang.Override
              public OrExpression parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<OrExpression> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<OrExpression> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface ExpressionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * String constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
         * </code>
         *
         * @return Whether the stringConstraint field is set.
         */
        boolean hasStringConstraint();
        /**
         *
         *
         * <pre>
         * String constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
         * </code>
         *
         * @return The stringConstraint.
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.StringConstraint
            getStringConstraint();
        /**
         *
         *
         * <pre>
         * String constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.StringConstraintOrBuilder
            getStringConstraintOrBuilder();

        /**
         *
         *
         * <pre>
         * Numerical constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
         * </code>
         *
         * @return Whether the numberConstraint field is set.
         */
        boolean hasNumberConstraint();
        /**
         *
         *
         * <pre>
         * Numerical constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
         * </code>
         *
         * @return The numberConstraint.
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.NumberConstraint
            getNumberConstraint();
        /**
         *
         *
         * <pre>
         * Numerical constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.NumberConstraintOrBuilder
            getNumberConstraintOrBuilder();

        /**
         *
         *
         * <pre>
         * Geolocation constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint geolocation_constraint = 3;
         * </code>
         *
         * @return Whether the geolocationConstraint field is set.
         */
        boolean hasGeolocationConstraint();
        /**
         *
         *
         * <pre>
         * Geolocation constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint geolocation_constraint = 3;
         * </code>
         *
         * @return The geolocationConstraint.
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.GeolocationConstraint
            getGeolocationConstraint();
        /**
         *
         *
         * <pre>
         * Geolocation constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint geolocation_constraint = 3;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.GeolocationConstraintOrBuilder
            getGeolocationConstraintOrBuilder();

        /**
         *
         *
         * <pre>
         * Logical "And" compound operator connecting multiple expressions.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression and_expr = 4;
         * </code>
         *
         * @return Whether the andExpr field is set.
         */
        boolean hasAndExpr();
        /**
         *
         *
         * <pre>
         * Logical "And" compound operator connecting multiple expressions.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression and_expr = 4;
         * </code>
         *
         * @return The andExpr.
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.AndExpression
            getAndExpr();
        /**
         *
         *
         * <pre>
         * Logical "And" compound operator connecting multiple expressions.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression and_expr = 4;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.AndExpressionOrBuilder
            getAndExprOrBuilder();

        /**
         *
         *
         * <pre>
         * Logical "Or" compound operator connecting multiple expressions.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression or_expr = 5;
         * </code>
         *
         * @return Whether the orExpr field is set.
         */
        boolean hasOrExpr();
        /**
         *
         *
         * <pre>
         * Logical "Or" compound operator connecting multiple expressions.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression or_expr = 5;
         * </code>
         *
         * @return The orExpr.
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.OrExpression
            getOrExpr();
        /**
         *
         *
         * <pre>
         * Logical "Or" compound operator connecting multiple expressions.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression or_expr = 5;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.OrExpressionOrBuilder
            getOrExprOrBuilder();

        com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo
                .StructuredExtractedFilter.Expression.ExprCase
            getExprCase();
      }
      /**
       *
       *
       * <pre>
       * The expression denoting the filter that was extracted from the input
       * query.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression}
       */
      public static final class Expression extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression)
          ExpressionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Expression.newBuilder() to construct.
        private Expression(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Expression() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Expression();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_Expression_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_Expression_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .class,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                      .Builder.class);
        }

        private int exprCase_ = 0;

        @SuppressWarnings("serial")
        private java.lang.Object expr_;

        public enum ExprCase
            implements
                com.google.protobuf.Internal.EnumLite,
                com.google.protobuf.AbstractMessage.InternalOneOfEnum {
          STRING_CONSTRAINT(1),
          NUMBER_CONSTRAINT(2),
          GEOLOCATION_CONSTRAINT(3),
          AND_EXPR(4),
          OR_EXPR(5),
          EXPR_NOT_SET(0);
          private final int value;

          private ExprCase(int value) {
            this.value = value;
          }
          /**
           * @param value The number of the enum to look for.
           * @return The enum associated with the given number.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static ExprCase valueOf(int value) {
            return forNumber(value);
          }

          public static ExprCase forNumber(int value) {
            switch (value) {
              case 1:
                return STRING_CONSTRAINT;
              case 2:
                return NUMBER_CONSTRAINT;
              case 3:
                return GEOLOCATION_CONSTRAINT;
              case 4:
                return AND_EXPR;
              case 5:
                return OR_EXPR;
              case 0:
                return EXPR_NOT_SET;
              default:
                return null;
            }
          }

          public int getNumber() {
            return this.value;
          }
        };

        public ExprCase getExprCase() {
          return ExprCase.forNumber(exprCase_);
        }

        public static final int STRING_CONSTRAINT_FIELD_NUMBER = 1;
        /**
         *
         *
         * <pre>
         * String constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
         * </code>
         *
         * @return Whether the stringConstraint field is set.
         */
        @java.lang.Override
        public boolean hasStringConstraint() {
          return exprCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * String constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
         * </code>
         *
         * @return The stringConstraint.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
            getStringConstraint() {
          if (exprCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .StringConstraint)
                expr_;
          }
          return com.google.cloud.discoveryengine.v1beta.SearchResponse
              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
              .getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * String constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .StringConstraintOrBuilder
            getStringConstraintOrBuilder() {
          if (exprCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .StringConstraint)
                expr_;
          }
          return com.google.cloud.discoveryengine.v1beta.SearchResponse
              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
              .getDefaultInstance();
        }

        public static final int NUMBER_CONSTRAINT_FIELD_NUMBER = 2;
        /**
         *
         *
         * <pre>
         * Numerical constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
         * </code>
         *
         * @return Whether the numberConstraint field is set.
         */
        @java.lang.Override
        public boolean hasNumberConstraint() {
          return exprCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Numerical constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
         * </code>
         *
         * @return The numberConstraint.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
            getNumberConstraint() {
          if (exprCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .NumberConstraint)
                expr_;
          }
          return com.google.cloud.discoveryengine.v1beta.SearchResponse
              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
              .getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * Numerical constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .NumberConstraintOrBuilder
            getNumberConstraintOrBuilder() {
          if (exprCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .NumberConstraint)
                expr_;
          }
          return com.google.cloud.discoveryengine.v1beta.SearchResponse
              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
              .getDefaultInstance();
        }

        public static final int GEOLOCATION_CONSTRAINT_FIELD_NUMBER = 3;
        /**
         *
         *
         * <pre>
         * Geolocation constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint geolocation_constraint = 3;
         * </code>
         *
         * @return Whether the geolocationConstraint field is set.
         */
        @java.lang.Override
        public boolean hasGeolocationConstraint() {
          return exprCase_ == 3;
        }
        /**
         *
         *
         * <pre>
         * Geolocation constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint geolocation_constraint = 3;
         * </code>
         *
         * @return The geolocationConstraint.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraint
            getGeolocationConstraint() {
          if (exprCase_ == 3) {
            return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .GeolocationConstraint)
                expr_;
          }
          return com.google.cloud.discoveryengine.v1beta.SearchResponse
              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint
              .getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * Geolocation constraint expression.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint geolocation_constraint = 3;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .GeolocationConstraintOrBuilder
            getGeolocationConstraintOrBuilder() {
          if (exprCase_ == 3) {
            return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                    .GeolocationConstraint)
                expr_;
          }
          return com.google.cloud.discoveryengine.v1beta.SearchResponse
              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.GeolocationConstraint
              .getDefaultInstance();
        }

        public static final int AND_EXPR_FIELD_NUMBER = 4;
        /**
         *
         *
         * <pre>
         * Logical "And" compound operator connecting multiple expressions.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression and_expr = 4;
         * </code>
         *
         * @return Whether the andExpr field is set.
         */
        @java.lang.Override
        public boolean hasAndExpr() {
          return exprCase_ == 4;
        }
        /**
         *
         *
         * <pre>
         * Logical "And" compound operator connecting multiple expressions.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression and_expr = 4;
         * </code>
         *
         * @return The andExpr.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
            getAndExpr() {
          if (exprCase_ == 4) {
            return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression)
                expr_;
          }
          return com.google.cloud.discoveryengine.v1beta.SearchResponse
              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
              .getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * Logical "And" compound operator connecting multiple expressions.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression and_expr = 4;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .AndExpressionOrBuilder
            getAndExprOrBuilder() {
          if (exprCase_ == 4) {
            return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression)
                expr_;
          }
          return com.google.cloud.discoveryengine.v1beta.SearchResponse
              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.AndExpression
              .getDefaultInstance();
        }

        public static final int OR_EXPR_FIELD_NUMBER = 5;
        /**
         *
         *
         * <pre>
         * Logical "Or" compound operator connecting multiple expressions.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression or_expr = 5;
         * </code>
         *
         * @return Whether the orExpr field is set.
         */
        @java.lang.Override
        public boolean hasOrExpr() {
          return exprCase_ == 5;
        }
        /**
         *
         *
         * <pre>
         * Logical "Or" compound operator connecting multiple expressions.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression or_expr = 5;
         * </code>
         *
         * @return The orExpr.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
            getOrExpr() {
          if (exprCase_ == 5) {
            return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression)
                expr_;
          }
          return com.google.cloud.discoveryengine.v1beta.SearchResponse
              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
              .getDefaultInstance();
        }
        /**
         *
         *
         * <pre>
         * Logical "Or" compound operator connecting multiple expressions.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression or_expr = 5;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .OrExpressionOrBuilder
            getOrExprOrBuilder() {
          if (exprCase_ == 5) {
            return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression)
                expr_;
          }
          return com.google.cloud.discoveryengine.v1beta.SearchResponse
              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.OrExpression
              .getDefaultInstance();
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (exprCase_ == 1) {
            output.writeMessage(
                1,
                (com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .StringConstraint)
                    expr_);
          }
          if (exprCase_ == 2) {
            output.writeMessage(
                2,
                (com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .NumberConstraint)
                    expr_);
          }
          if (exprCase_ == 3) {
            output.writeMessage(
                3,
                (com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .GeolocationConstraint)
                    expr_);
          }
          if (exprCase_ == 4) {
            output.writeMessage(
                4,
                (com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .AndExpression)
                    expr_);
          }
          if (exprCase_ == 5) {
            output.writeMessage(
                5,
                (com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .OrExpression)
                    expr_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (exprCase_ == 1) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    1,
                    (com.google.cloud.discoveryengine.v1beta.SearchResponse
                            .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                            .StringConstraint)
                        expr_);
          }
          if (exprCase_ == 2) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    2,
                    (com.google.cloud.discoveryengine.v1beta.SearchResponse
                            .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                            .NumberConstraint)
                        expr_);
          }
          if (exprCase_ == 3) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    3,
                    (com.google.cloud.discoveryengine.v1beta.SearchResponse
                            .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                            .GeolocationConstraint)
                        expr_);
          }
          if (exprCase_ == 4) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    4,
                    (com.google.cloud.discoveryengine.v1beta.SearchResponse
                            .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                            .AndExpression)
                        expr_);
          }
          if (exprCase_ == 5) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    5,
                    (com.google.cloud.discoveryengine.v1beta.SearchResponse
                            .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                            .OrExpression)
                        expr_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
              other =
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .Expression)
                      obj;

          if (!getExprCase().equals(other.getExprCase())) return false;
          switch (exprCase_) {
            case 1:
              if (!getStringConstraint().equals(other.getStringConstraint())) return false;
              break;
            case 2:
              if (!getNumberConstraint().equals(other.getNumberConstraint())) return false;
              break;
            case 3:
              if (!getGeolocationConstraint().equals(other.getGeolocationConstraint()))
                return false;
              break;
            case 4:
              if (!getAndExpr().equals(other.getAndExpr())) return false;
              break;
            case 5:
              if (!getOrExpr().equals(other.getOrExpr())) return false;
              break;
            case 0:
            default:
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          switch (exprCase_) {
            case 1:
              hash = (37 * hash) + STRING_CONSTRAINT_FIELD_NUMBER;
              hash = (53 * hash) + getStringConstraint().hashCode();
              break;
            case 2:
              hash = (37 * hash) + NUMBER_CONSTRAINT_FIELD_NUMBER;
              hash = (53 * hash) + getNumberConstraint().hashCode();
              break;
            case 3:
              hash = (37 * hash) + GEOLOCATION_CONSTRAINT_FIELD_NUMBER;
              hash = (53 * hash) + getGeolocationConstraint().hashCode();
              break;
            case 4:
              hash = (37 * hash) + AND_EXPR_FIELD_NUMBER;
              hash = (53 * hash) + getAndExpr().hashCode();
              break;
            case 5:
              hash = (37 * hash) + OR_EXPR_FIELD_NUMBER;
              hash = (53 * hash) + getOrExpr().hashCode();
              break;
            case 0:
            default:
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * The expression denoting the filter that was extracted from the input
         * query.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression)
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                .ExpressionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_Expression_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_Expression_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                        .class,
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                        .Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            if (stringConstraintBuilder_ != null) {
              stringConstraintBuilder_.clear();
            }
            if (numberConstraintBuilder_ != null) {
              numberConstraintBuilder_.clear();
            }
            if (geolocationConstraintBuilder_ != null) {
              geolocationConstraintBuilder_.clear();
            }
            if (andExprBuilder_ != null) {
              andExprBuilder_.clear();
            }
            if (orExprBuilder_ != null) {
              orExprBuilder_.clear();
            }
            exprCase_ = 0;
            expr_ = null;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_SearchResponse_NaturalLanguageQueryUnderstandingInfo_StructuredExtractedFilter_Expression_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.SearchResponse
                .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
              build() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                result =
                    new com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression(
                        this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            buildPartialOneofs(result);
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  result) {
            int from_bitField0_ = bitField0_;
          }

          private void buildPartialOneofs(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  result) {
            result.exprCase_ = exprCase_;
            result.expr_ = this.expr_;
            if (exprCase_ == 1 && stringConstraintBuilder_ != null) {
              result.expr_ = stringConstraintBuilder_.build();
            }
            if (exprCase_ == 2 && numberConstraintBuilder_ != null) {
              result.expr_ = numberConstraintBuilder_.build();
            }
            if (exprCase_ == 3 && geolocationConstraintBuilder_ != null) {
              result.expr_ = geolocationConstraintBuilder_.build();
            }
            if (exprCase_ == 4 && andExprBuilder_ != null) {
              result.expr_ = andExprBuilder_.build();
            }
            if (exprCase_ == 5 && orExprBuilder_ != null) {
              result.expr_ = orExprBuilder_.build();
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .Expression)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.SearchResponse
                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.Expression
                    .getDefaultInstance()) return this;
            switch (other.getExprCase()) {
              case STRING_CONSTRAINT:
                {
                  mergeStringConstraint(other.getStringConstraint());
                  break;
                }
              case NUMBER_CONSTRAINT:
                {
                  mergeNumberConstraint(other.getNumberConstraint());
                  break;
                }
              case GEOLOCATION_CONSTRAINT:
                {
                  mergeGeolocationConstraint(other.getGeolocationConstraint());
                  break;
                }
              case AND_EXPR:
                {
                  mergeAndExpr(other.getAndExpr());
                  break;
                }
              case OR_EXPR:
                {
                  mergeOrExpr(other.getOrExpr());
                  break;
                }
              case EXPR_NOT_SET:
                {
                  break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(
                          getStringConstraintFieldBuilder().getBuilder(), extensionRegistry);
                      exprCase_ = 1;
                      break;
                    } // case 10
                  case 18:
                    {
                      input.readMessage(
                          getNumberConstraintFieldBuilder().getBuilder(), extensionRegistry);
                      exprCase_ = 2;
                      break;
                    } // case 18
                  case 26:
                    {
                      input.readMessage(
                          getGeolocationConstraintFieldBuilder().getBuilder(), extensionRegistry);
                      exprCase_ = 3;
                      break;
                    } // case 26
                  case 34:
                    {
                      input.readMessage(getAndExprFieldBuilder().getBuilder(), extensionRegistry);
                      exprCase_ = 4;
                      break;
                    } // case 34
                  case 42:
                    {
                      input.readMessage(getOrExprFieldBuilder().getBuilder(), extensionRegistry);
                      exprCase_ = 5;
                      break;
                    } // case 42
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int exprCase_ = 0;
          private java.lang.Object expr_;

          public ExprCase getExprCase() {
            return ExprCase.forNumber(exprCase_);
          }

          public Builder clearExpr() {
            exprCase_ = 0;
            expr_ = null;
            onChanged();
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraint,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraint.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraintOrBuilder>
              stringConstraintBuilder_;
          /**
           *
           *
           * <pre>
           * String constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
           * </code>
           *
           * @return Whether the stringConstraint field is set.
           */
          @java.lang.Override
          public boolean hasStringConstraint() {
            return exprCase_ == 1;
          }
          /**
           *
           *
           * <pre>
           * String constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
           * </code>
           *
           * @return The stringConstraint.
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
              getStringConstraint() {
            if (stringConstraintBuilder_ == null) {
              if (exprCase_ == 1) {
                return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .StringConstraint)
                    expr_;
              }
              return com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
                  .getDefaultInstance();
            } else {
              if (exprCase_ == 1) {
                return stringConstraintBuilder_.getMessage();
              }
              return com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
                  .getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * String constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
           * </code>
           */
          public Builder setStringConstraint(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraint
                  value) {
            if (stringConstraintBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              expr_ = value;
              onChanged();
            } else {
              stringConstraintBuilder_.setMessage(value);
            }
            exprCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * String constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
           * </code>
           */
          public Builder setStringConstraint(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraint.Builder
                  builderForValue) {
            if (stringConstraintBuilder_ == null) {
              expr_ = builderForValue.build();
              onChanged();
            } else {
              stringConstraintBuilder_.setMessage(builderForValue.build());
            }
            exprCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * String constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
           * </code>
           */
          public Builder mergeStringConstraint(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraint
                  value) {
            if (stringConstraintBuilder_ == null) {
              if (exprCase_ == 1
                  && expr_
                      != com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .StringConstraint.getDefaultInstance()) {
                expr_ =
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .StringConstraint.newBuilder(
                            (com.google.cloud.discoveryengine.v1beta.SearchResponse
                                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                                    .StringConstraint)
                                expr_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                expr_ = value;
              }
              onChanged();
            } else {
              if (exprCase_ == 1) {
                stringConstraintBuilder_.mergeFrom(value);
              } else {
                stringConstraintBuilder_.setMessage(value);
              }
            }
            exprCase_ = 1;
            return this;
          }
          /**
           *
           *
           * <pre>
           * String constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
           * </code>
           */
          public Builder clearStringConstraint() {
            if (stringConstraintBuilder_ == null) {
              if (exprCase_ == 1) {
                exprCase_ = 0;
                expr_ = null;
                onChanged();
              }
            } else {
              if (exprCase_ == 1) {
                exprCase_ = 0;
                expr_ = null;
              }
              stringConstraintBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * String constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
                  .Builder
              getStringConstraintBuilder() {
            return getStringConstraintFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * String constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                  .StringConstraintOrBuilder
              getStringConstraintOrBuilder() {
            if ((exprCase_ == 1) && (stringConstraintBuilder_ != null)) {
              return stringConstraintBuilder_.getMessageOrBuilder();
            } else {
              if (exprCase_ == 1) {
                return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .StringConstraint)
                    expr_;
              }
              return com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint
                  .getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * String constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.StringConstraint string_constraint = 1;
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraint,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraint.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .StringConstraintOrBuilder>
              getStringConstraintFieldBuilder() {
            if (stringConstraintBuilder_ == null) {
              if (!(exprCase_ == 1)) {
                expr_ =
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .StringConstraint.getDefaultInstance();
              }
              stringConstraintBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .StringConstraint,
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .StringConstraint.Builder,
                      com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .StringConstraintOrBuilder>(
                      (com.google.cloud.discoveryengine.v1beta.SearchResponse
                              .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                              .StringConstraint)
                          expr_,
                      getParentForChildren(),
                      isClean());
              expr_ = null;
            }
            exprCase_ = 1;
            onChanged();
            return stringConstraintBuilder_;
          }

          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .NumberConstraint,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .NumberConstraint.Builder,
                  com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .NumberConstraintOrBuilder>
              numberConstraintBuilder_;
          /**
           *
           *
           * <pre>
           * Numerical constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
           * </code>
           *
           * @return Whether the numberConstraint field is set.
           */
          @java.lang.Override
          public boolean hasNumberConstraint() {
            return exprCase_ == 2;
          }
          /**
           *
           *
           * <pre>
           * Numerical constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
           * </code>
           *
           * @return The numberConstraint.
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
              getNumberConstraint() {
            if (numberConstraintBuilder_ == null) {
              if (exprCase_ == 2) {
                return (com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .NumberConstraint)
                    expr_;
              }
              return com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
                  .getDefaultInstance();
            } else {
              if (exprCase_ == 2) {
                return numberConstraintBuilder_.getMessage();
              }
              return com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
                  .getDefaultInstance();
            }
          }
          /**
           *
           *
           * <pre>
           * Numerical constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
           * </code>
           */
          public Builder setNumberConstraint(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .NumberConstraint
                  value) {
            if (numberConstraintBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              expr_ = value;
              onChanged();
            } else {
              numberConstraintBuilder_.setMessage(value);
            }
            exprCase_ = 2;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Numerical constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
           * </code>
           */
          public Builder setNumberConstraint(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .NumberConstraint.Builder
                  builderForValue) {
            if (numberConstraintBuilder_ == null) {
              expr_ = builderForValue.build();
              onChanged();
            } else {
              numberConstraintBuilder_.setMessage(builderForValue.build());
            }
            exprCase_ = 2;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Numerical constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
           * </code>
           */
          public Builder mergeNumberConstraint(
              com.google.cloud.discoveryengine.v1beta.SearchResponse
                      .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                      .NumberConstraint
                  value) {
            if (numberConstraintBuilder_ == null) {
              if (exprCase_ == 2
                  && expr_
                      != com.google.cloud.discoveryengine.v1beta.SearchResponse
                          .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                          .NumberConstraint.getDefaultInstance()) {
                expr_ =
                    com.google.cloud.discoveryengine.v1beta.SearchResponse
                        .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                        .NumberConstraint.newBuilder(
                            (com.google.cloud.discoveryengine.v1beta.SearchResponse
                                    .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter
                                    .NumberConstraint)
                                expr_)
                        .mergeFrom(value)
                        .buildPartial();
              } else {
                expr_ = value;
              }
              onChanged();
            } else {
              if (exprCase_ == 2) {
                numberConstraintBuilder_.mergeFrom(value);
              } else {
                numberConstraintBuilder_.setMessage(value);
              }
            }
            exprCase_ = 2;
            return this;
          }
          /**
           *
           *
           * <pre>
           * Numerical constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
           * </code>
           */
          public Builder clearNumberConstraint() {
            if (numberConstraintBuilder_ == null) {
              if (exprCase_ == 2) {
                exprCase_ = 0;
                expr_ = null;
                onChanged();
              }
            } else {
              if (exprCase_ == 2) {
                exprCase_ = 0;
                expr_ = null;
              }
              numberConstraintBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Numerical constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
                  .NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint
                  .Builder
              getNumberConstraintBuilder() {
            return getNumberConstraintFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Numerical constraint expression.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.SearchResponse.NaturalLanguageQueryUnderstandingInfo.StructuredExtractedFilter.NumberConstraint number_constraint = 2;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.SearchResponse
