/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1alpha/import_config.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1alpha;

/**
 *
 *
 * <pre>
 * Request message for Import methods.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest}
 */
public final class ImportDocumentsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest)
    ImportDocumentsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportDocumentsRequest.newBuilder() to construct.
  private ImportDocumentsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportDocumentsRequest() {
    parent_ = "";
    reconciliationMode_ = 0;
    idField_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportDocumentsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1alpha_ImportDocumentsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1alpha_ImportDocumentsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.class,
            com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates how imported documents are reconciled with the existing documents
   * created or imported before.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode}
   */
  public enum ReconciliationMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Defaults to `INCREMENTAL`.
     * </pre>
     *
     * <code>RECONCILIATION_MODE_UNSPECIFIED = 0;</code>
     */
    RECONCILIATION_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Inserts new documents or updates existing documents.
     * </pre>
     *
     * <code>INCREMENTAL = 1;</code>
     */
    INCREMENTAL(1),
    /**
     *
     *
     * <pre>
     * Calculates diff and replaces the entire document dataset. Existing
     * documents may be deleted if they are not present in the source location.
     * </pre>
     *
     * <code>FULL = 2;</code>
     */
    FULL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Defaults to `INCREMENTAL`.
     * </pre>
     *
     * <code>RECONCILIATION_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int RECONCILIATION_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Inserts new documents or updates existing documents.
     * </pre>
     *
     * <code>INCREMENTAL = 1;</code>
     */
    public static final int INCREMENTAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Calculates diff and replaces the entire document dataset. Existing
     * documents may be deleted if they are not present in the source location.
     * </pre>
     *
     * <code>FULL = 2;</code>
     */
    public static final int FULL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReconciliationMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ReconciliationMode forNumber(int value) {
      switch (value) {
        case 0:
          return RECONCILIATION_MODE_UNSPECIFIED;
        case 1:
          return INCREMENTAL;
        case 2:
          return FULL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ReconciliationMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ReconciliationMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ReconciliationMode>() {
              public ReconciliationMode findValueByNumber(int number) {
                return ReconciliationMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ReconciliationMode[] VALUES = values();

    public static ReconciliationMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ReconciliationMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode)
  }

  public interface InlineSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1alpha.Document> getDocumentsList();
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1alpha.Document getDocuments(int index);
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getDocumentsCount();
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<? extends com.google.cloud.discoveryengine.v1alpha.DocumentOrBuilder>
        getDocumentsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1alpha.DocumentOrBuilder getDocumentsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * The inline source for the input config for ImportDocuments method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource}
   */
  public static final class InlineSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource)
      InlineSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InlineSource.newBuilder() to construct.
    private InlineSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InlineSource() {
      documents_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InlineSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ImportDocumentsRequest_InlineSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ImportDocumentsRequest_InlineSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource.class,
              com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource.Builder
                  .class);
    }

    public static final int DOCUMENTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1alpha.Document> documents_;
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1alpha.Document> getDocumentsList() {
      return documents_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.discoveryengine.v1alpha.DocumentOrBuilder>
        getDocumentsOrBuilderList() {
      return documents_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getDocumentsCount() {
      return documents_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.Document getDocuments(int index) {
      return documents_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A list of documents to update/create. Each document must have a
     * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
     * Recommended max of 100 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.DocumentOrBuilder getDocumentsOrBuilder(
        int index) {
      return documents_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < documents_.size(); i++) {
        output.writeMessage(1, documents_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < documents_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, documents_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource other =
          (com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource) obj;

      if (!getDocumentsList().equals(other.getDocumentsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDocumentsCount() > 0) {
        hash = (37 * hash) + DOCUMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The inline source for the input config for ImportDocuments method.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource)
        com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1alpha_ImportDocumentsRequest_InlineSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1alpha_ImportDocumentsRequest_InlineSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource.class,
                com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (documentsBuilder_ == null) {
          documents_ = java.util.Collections.emptyList();
        } else {
          documents_ = null;
          documentsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1alpha_ImportDocumentsRequest_InlineSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource build() {
        com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
          buildPartial() {
        com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource result =
            new com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource result) {
        if (documentsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            documents_ = java.util.Collections.unmodifiableList(documents_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.documents_ = documents_;
        } else {
          result.documents_ = documentsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource other) {
        if (other
            == com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
                .getDefaultInstance()) return this;
        if (documentsBuilder_ == null) {
          if (!other.documents_.isEmpty()) {
            if (documents_.isEmpty()) {
              documents_ = other.documents_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDocumentsIsMutable();
              documents_.addAll(other.documents_);
            }
            onChanged();
          }
        } else {
          if (!other.documents_.isEmpty()) {
            if (documentsBuilder_.isEmpty()) {
              documentsBuilder_.dispose();
              documentsBuilder_ = null;
              documents_ = other.documents_;
              bitField0_ = (bitField0_ & ~0x00000001);
              documentsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDocumentsFieldBuilder()
                      : null;
            } else {
              documentsBuilder_.addAllMessages(other.documents_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1alpha.Document m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1alpha.Document.parser(),
                          extensionRegistry);
                  if (documentsBuilder_ == null) {
                    ensureDocumentsIsMutable();
                    documents_.add(m);
                  } else {
                    documentsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.discoveryengine.v1alpha.Document> documents_ =
          java.util.Collections.emptyList();

      private void ensureDocumentsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          documents_ =
              new java.util.ArrayList<com.google.cloud.discoveryengine.v1alpha.Document>(
                  documents_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.Document,
              com.google.cloud.discoveryengine.v1alpha.Document.Builder,
              com.google.cloud.discoveryengine.v1alpha.DocumentOrBuilder>
          documentsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1alpha.Document> getDocumentsList() {
        if (documentsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(documents_);
        } else {
          return documentsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getDocumentsCount() {
        if (documentsBuilder_ == null) {
          return documents_.size();
        } else {
          return documentsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.Document getDocuments(int index) {
        if (documentsBuilder_ == null) {
          return documents_.get(index);
        } else {
          return documentsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDocuments(
          int index, com.google.cloud.discoveryengine.v1alpha.Document value) {
        if (documentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentsIsMutable();
          documents_.set(index, value);
          onChanged();
        } else {
          documentsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDocuments(
          int index, com.google.cloud.discoveryengine.v1alpha.Document.Builder builderForValue) {
        if (documentsBuilder_ == null) {
          ensureDocumentsIsMutable();
          documents_.set(index, builderForValue.build());
          onChanged();
        } else {
          documentsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDocuments(com.google.cloud.discoveryengine.v1alpha.Document value) {
        if (documentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentsIsMutable();
          documents_.add(value);
          onChanged();
        } else {
          documentsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDocuments(
          int index, com.google.cloud.discoveryengine.v1alpha.Document value) {
        if (documentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentsIsMutable();
          documents_.add(index, value);
          onChanged();
        } else {
          documentsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDocuments(
          com.google.cloud.discoveryengine.v1alpha.Document.Builder builderForValue) {
        if (documentsBuilder_ == null) {
          ensureDocumentsIsMutable();
          documents_.add(builderForValue.build());
          onChanged();
        } else {
          documentsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDocuments(
          int index, com.google.cloud.discoveryengine.v1alpha.Document.Builder builderForValue) {
        if (documentsBuilder_ == null) {
          ensureDocumentsIsMutable();
          documents_.add(index, builderForValue.build());
          onChanged();
        } else {
          documentsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllDocuments(
          java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1alpha.Document> values) {
        if (documentsBuilder_ == null) {
          ensureDocumentsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documents_);
          onChanged();
        } else {
          documentsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearDocuments() {
        if (documentsBuilder_ == null) {
          documents_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          documentsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeDocuments(int index) {
        if (documentsBuilder_ == null) {
          ensureDocumentsIsMutable();
          documents_.remove(index);
          onChanged();
        } else {
          documentsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.Document.Builder getDocumentsBuilder(
          int index) {
        return getDocumentsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.DocumentOrBuilder getDocumentsOrBuilder(
          int index) {
        if (documentsBuilder_ == null) {
          return documents_.get(index);
        } else {
          return documentsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.discoveryengine.v1alpha.DocumentOrBuilder>
          getDocumentsOrBuilderList() {
        if (documentsBuilder_ != null) {
          return documentsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(documents_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.Document.Builder addDocumentsBuilder() {
        return getDocumentsFieldBuilder()
            .addBuilder(com.google.cloud.discoveryengine.v1alpha.Document.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.Document.Builder addDocumentsBuilder(
          int index) {
        return getDocumentsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.discoveryengine.v1alpha.Document.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. A list of documents to update/create. Each document must have a
       * valid [Document.id][google.cloud.discoveryengine.v1alpha.Document.id].
       * Recommended max of 100 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.Document documents = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1alpha.Document.Builder>
          getDocumentsBuilderList() {
        return getDocumentsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.Document,
              com.google.cloud.discoveryengine.v1alpha.Document.Builder,
              com.google.cloud.discoveryengine.v1alpha.DocumentOrBuilder>
          getDocumentsFieldBuilder() {
        if (documentsBuilder_ == null) {
          documentsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1alpha.Document,
                  com.google.cloud.discoveryengine.v1alpha.Document.Builder,
                  com.google.cloud.discoveryengine.v1alpha.DocumentOrBuilder>(
                  documents_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          documents_ = null;
        }
        return documentsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource)
    private static final com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest
            .InlineSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource();
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InlineSource> PARSER =
        new com.google.protobuf.AbstractParser<InlineSource>() {
          @java.lang.Override
          public InlineSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InlineSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InlineSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INLINE_SOURCE(2),
    GCS_SOURCE(3),
    BIGQUERY_SOURCE(4),
    FHIR_STORE_SOURCE(10),
    SPANNER_SOURCE(11),
    CLOUD_SQL_SOURCE(12),
    FIRESTORE_SOURCE(13),
    ALLOY_DB_SOURCE(14),
    BIGTABLE_SOURCE(15),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return INLINE_SOURCE;
        case 3:
          return GCS_SOURCE;
        case 4:
          return BIGQUERY_SOURCE;
        case 10:
          return FHIR_STORE_SOURCE;
        case 11:
          return SPANNER_SOURCE;
        case 12:
          return CLOUD_SQL_SOURCE;
        case 13:
          return FIRESTORE_SOURCE;
        case 14:
          return ALLOY_DB_SOURCE;
        case 15:
          return BIGTABLE_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int INLINE_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The Inline source for the input content for documents.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource inline_source = 2;
   * </code>
   *
   * @return Whether the inlineSource field is set.
   */
  @java.lang.Override
  public boolean hasInlineSource() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The Inline source for the input content for documents.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource inline_source = 2;
   * </code>
   *
   * @return The inlineSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
      getInlineSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Inline source for the input content for documents.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource inline_source = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSourceOrBuilder
      getInlineSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        .getDefaultInstance();
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Cloud Storage location for the input content.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return sourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage location for the input content.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.GcsSource getGcsSource() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage location for the input content.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder getGcsSourceOrBuilder() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
  }

  public static final int BIGQUERY_SOURCE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * BigQuery input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
   *
   * @return Whether the bigquerySource field is set.
   */
  @java.lang.Override
  public boolean hasBigquerySource() {
    return sourceCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * BigQuery input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
   *
   * @return The bigquerySource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.BigQuerySource getBigquerySource() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * BigQuery input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder
      getBigquerySourceOrBuilder() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
  }

  public static final int FHIR_STORE_SOURCE_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * FhirStore input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.FhirStoreSource fhir_store_source = 10;</code>
   *
   * @return Whether the fhirStoreSource field is set.
   */
  @java.lang.Override
  public boolean hasFhirStoreSource() {
    return sourceCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * FhirStore input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.FhirStoreSource fhir_store_source = 10;</code>
   *
   * @return The fhirStoreSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FhirStoreSource getFhirStoreSource() {
    if (sourceCase_ == 10) {
      return (com.google.cloud.discoveryengine.v1alpha.FhirStoreSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * FhirStore input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.FhirStoreSource fhir_store_source = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FhirStoreSourceOrBuilder
      getFhirStoreSourceOrBuilder() {
    if (sourceCase_ == 10) {
      return (com.google.cloud.discoveryengine.v1alpha.FhirStoreSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.getDefaultInstance();
  }

  public static final int SPANNER_SOURCE_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Spanner input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.SpannerSource spanner_source = 11;</code>
   *
   * @return Whether the spannerSource field is set.
   */
  @java.lang.Override
  public boolean hasSpannerSource() {
    return sourceCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Spanner input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.SpannerSource spanner_source = 11;</code>
   *
   * @return The spannerSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.SpannerSource getSpannerSource() {
    if (sourceCase_ == 11) {
      return (com.google.cloud.discoveryengine.v1alpha.SpannerSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.SpannerSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Spanner input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.SpannerSource spanner_source = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.SpannerSourceOrBuilder
      getSpannerSourceOrBuilder() {
    if (sourceCase_ == 11) {
      return (com.google.cloud.discoveryengine.v1alpha.SpannerSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.SpannerSource.getDefaultInstance();
  }

  public static final int CLOUD_SQL_SOURCE_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Cloud SQL input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.CloudSqlSource cloud_sql_source = 12;</code>
   *
   * @return Whether the cloudSqlSource field is set.
   */
  @java.lang.Override
  public boolean hasCloudSqlSource() {
    return sourceCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Cloud SQL input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.CloudSqlSource cloud_sql_source = 12;</code>
   *
   * @return The cloudSqlSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.CloudSqlSource getCloudSqlSource() {
    if (sourceCase_ == 12) {
      return (com.google.cloud.discoveryengine.v1alpha.CloudSqlSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Cloud SQL input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.CloudSqlSource cloud_sql_source = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.CloudSqlSourceOrBuilder
      getCloudSqlSourceOrBuilder() {
    if (sourceCase_ == 12) {
      return (com.google.cloud.discoveryengine.v1alpha.CloudSqlSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.getDefaultInstance();
  }

  public static final int FIRESTORE_SOURCE_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Firestore input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.FirestoreSource firestore_source = 13;</code>
   *
   * @return Whether the firestoreSource field is set.
   */
  @java.lang.Override
  public boolean hasFirestoreSource() {
    return sourceCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Firestore input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.FirestoreSource firestore_source = 13;</code>
   *
   * @return The firestoreSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FirestoreSource getFirestoreSource() {
    if (sourceCase_ == 13) {
      return (com.google.cloud.discoveryengine.v1alpha.FirestoreSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.FirestoreSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Firestore input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.FirestoreSource firestore_source = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.FirestoreSourceOrBuilder
      getFirestoreSourceOrBuilder() {
    if (sourceCase_ == 13) {
      return (com.google.cloud.discoveryengine.v1alpha.FirestoreSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.FirestoreSource.getDefaultInstance();
  }

  public static final int ALLOY_DB_SOURCE_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * AlloyDB input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.AlloyDbSource alloy_db_source = 14;</code>
   *
   * @return Whether the alloyDbSource field is set.
   */
  @java.lang.Override
  public boolean hasAlloyDbSource() {
    return sourceCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * AlloyDB input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.AlloyDbSource alloy_db_source = 14;</code>
   *
   * @return The alloyDbSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.AlloyDbSource getAlloyDbSource() {
    if (sourceCase_ == 14) {
      return (com.google.cloud.discoveryengine.v1alpha.AlloyDbSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * AlloyDB input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.AlloyDbSource alloy_db_source = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.AlloyDbSourceOrBuilder
      getAlloyDbSourceOrBuilder() {
    if (sourceCase_ == 14) {
      return (com.google.cloud.discoveryengine.v1alpha.AlloyDbSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.getDefaultInstance();
  }

  public static final int BIGTABLE_SOURCE_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Cloud Bigtable input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.BigtableSource bigtable_source = 15;</code>
   *
   * @return Whether the bigtableSource field is set.
   */
  @java.lang.Override
  public boolean hasBigtableSource() {
    return sourceCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Cloud Bigtable input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.BigtableSource bigtable_source = 15;</code>
   *
   * @return The bigtableSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.BigtableSource getBigtableSource() {
    if (sourceCase_ == 15) {
      return (com.google.cloud.discoveryengine.v1alpha.BigtableSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.BigtableSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Cloud Bigtable input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.BigtableSource bigtable_source = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.BigtableSourceOrBuilder
      getBigtableSourceOrBuilder() {
    if (sourceCase_ == 15) {
      return (com.google.cloud.discoveryengine.v1alpha.BigtableSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.BigtableSource.getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent branch resource name, such as
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
   * Requires create/update permission.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent branch resource name, such as
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
   * Requires create/update permission.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig errorConfig_;
  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the Import.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
   *
   * @return Whether the errorConfig field is set.
   */
  @java.lang.Override
  public boolean hasErrorConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the Import.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
   *
   * @return The errorConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig getErrorConfig() {
    return errorConfig_ == null
        ? com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.getDefaultInstance()
        : errorConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the Import.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ImportErrorConfigOrBuilder
      getErrorConfigOrBuilder() {
    return errorConfig_ == null
        ? com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.getDefaultInstance()
        : errorConfig_;
  }

  public static final int RECONCILIATION_MODE_FIELD_NUMBER = 6;
  private int reconciliationMode_ = 0;
  /**
   *
   *
   * <pre>
   * The mode of reconciliation between existing documents and the documents to
   * be imported. Defaults to
   * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
   * </code>
   *
   * @return The enum numeric value on the wire for reconciliationMode.
   */
  @java.lang.Override
  public int getReconciliationModeValue() {
    return reconciliationMode_;
  }
  /**
   *
   *
   * <pre>
   * The mode of reconciliation between existing documents and the documents to
   * be imported. Defaults to
   * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
   * </code>
   *
   * @return The reconciliationMode.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode
      getReconciliationMode() {
    com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode result =
        com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode
            .forNumber(reconciliationMode_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode
            .UNRECOGNIZED
        : result;
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 7;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Indicates which fields in the provided imported documents to update. If
   * not set, the default is to update all fields.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 7;</code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indicates which fields in the provided imported documents to update. If
   * not set, the default is to update all fields.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 7;</code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Indicates which fields in the provided imported documents to update. If
   * not set, the default is to update all fields.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  public static final int AUTO_GENERATE_IDS_FIELD_NUMBER = 8;
  private boolean autoGenerateIds_ = false;
  /**
   *
   *
   * <pre>
   * Whether to automatically generate IDs for the documents if absent.
   *
   * If set to `true`,
   * [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s are
   * automatically generated based on the hash of the payload, where IDs may not
   * be consistent during multiple imports. In which case
   * [ReconciliationMode.FULL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.FULL]
   * is highly recommended to avoid duplicate contents. If unset or set to
   * `false`, [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s
   * have to be specified using
   * [id_field][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.id_field],
   * otherwise, documents without IDs fail to be imported.
   *
   * Supported data sources:
   *
   * * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
   * [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
   * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
   * * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
   * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
   * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
   * * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
   * * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
   * * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
   * * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
   * </pre>
   *
   * <code>bool auto_generate_ids = 8;</code>
   *
   * @return The autoGenerateIds.
   */
  @java.lang.Override
  public boolean getAutoGenerateIds() {
    return autoGenerateIds_;
  }

  public static final int ID_FIELD_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object idField_ = "";
  /**
   *
   *
   * <pre>
   * The field indicates the ID field or column to be used as unique IDs of
   * the documents.
   *
   * For [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource] it is the
   * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
   * "some_uuid"}`. For others, it may be the column name of the table where the
   * unique ids are stored.
   *
   * The values of the JSON field or the table column are used as the
   * [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s. The JSON
   * field or the table column must be of string type, and the values must be
   * set as valid strings conform to
   * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
   * Otherwise, documents without valid IDs fail to be imported.
   *
   * Only set this field when
   * [auto_generate_ids][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.auto_generate_ids]
   * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
   *
   * If it is unset, a default value `_id` is used when importing from the
   * allowed data sources.
   *
   * Supported data sources:
   *
   * * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
   * [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
   * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
   * * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
   * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
   * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
   * * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
   * * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
   * * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
   * * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
   * </pre>
   *
   * <code>string id_field = 9;</code>
   *
   * @return The idField.
   */
  @java.lang.Override
  public java.lang.String getIdField() {
    java.lang.Object ref = idField_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      idField_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The field indicates the ID field or column to be used as unique IDs of
   * the documents.
   *
   * For [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource] it is the
   * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
   * "some_uuid"}`. For others, it may be the column name of the table where the
   * unique ids are stored.
   *
   * The values of the JSON field or the table column are used as the
   * [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s. The JSON
   * field or the table column must be of string type, and the values must be
   * set as valid strings conform to
   * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
   * Otherwise, documents without valid IDs fail to be imported.
   *
   * Only set this field when
   * [auto_generate_ids][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.auto_generate_ids]
   * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
   *
   * If it is unset, a default value `_id` is used when importing from the
   * allowed data sources.
   *
   * Supported data sources:
   *
   * * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
   * [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
   * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
   * * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
   * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
   * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
   * * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
   * * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
   * * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
   * * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
   * </pre>
   *
   * <code>string id_field = 9;</code>
   *
   * @return The bytes for idField.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdFieldBytes() {
    java.lang.Object ref = idField_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      idField_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource) source_);
    }
    if (sourceCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_);
    }
    if (sourceCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getErrorConfig());
    }
    if (reconciliationMode_
        != com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode
            .RECONCILIATION_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, reconciliationMode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getUpdateMask());
    }
    if (autoGenerateIds_ != false) {
      output.writeBool(8, autoGenerateIds_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(idField_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, idField_);
    }
    if (sourceCase_ == 10) {
      output.writeMessage(10, (com.google.cloud.discoveryengine.v1alpha.FhirStoreSource) source_);
    }
    if (sourceCase_ == 11) {
      output.writeMessage(11, (com.google.cloud.discoveryengine.v1alpha.SpannerSource) source_);
    }
    if (sourceCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.discoveryengine.v1alpha.CloudSqlSource) source_);
    }
    if (sourceCase_ == 13) {
      output.writeMessage(13, (com.google.cloud.discoveryengine.v1alpha.FirestoreSource) source_);
    }
    if (sourceCase_ == 14) {
      output.writeMessage(14, (com.google.cloud.discoveryengine.v1alpha.AlloyDbSource) source_);
    }
    if (sourceCase_ == 15) {
      output.writeMessage(15, (com.google.cloud.discoveryengine.v1alpha.BigtableSource) source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource)
                  source_);
    }
    if (sourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_);
    }
    if (sourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getErrorConfig());
    }
    if (reconciliationMode_
        != com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode
            .RECONCILIATION_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, reconciliationMode_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateMask());
    }
    if (autoGenerateIds_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, autoGenerateIds_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(idField_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, idField_);
    }
    if (sourceCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.discoveryengine.v1alpha.FhirStoreSource) source_);
    }
    if (sourceCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.discoveryengine.v1alpha.SpannerSource) source_);
    }
    if (sourceCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.discoveryengine.v1alpha.CloudSqlSource) source_);
    }
    if (sourceCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.discoveryengine.v1alpha.FirestoreSource) source_);
    }
    if (sourceCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.discoveryengine.v1alpha.AlloyDbSource) source_);
    }
    if (sourceCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.discoveryengine.v1alpha.BigtableSource) source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest other =
        (com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasErrorConfig() != other.hasErrorConfig()) return false;
    if (hasErrorConfig()) {
      if (!getErrorConfig().equals(other.getErrorConfig())) return false;
    }
    if (reconciliationMode_ != other.reconciliationMode_) return false;
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (getAutoGenerateIds() != other.getAutoGenerateIds()) return false;
    if (!getIdField().equals(other.getIdField())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getInlineSource().equals(other.getInlineSource())) return false;
        break;
      case 3:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 4:
        if (!getBigquerySource().equals(other.getBigquerySource())) return false;
        break;
      case 10:
        if (!getFhirStoreSource().equals(other.getFhirStoreSource())) return false;
        break;
      case 11:
        if (!getSpannerSource().equals(other.getSpannerSource())) return false;
        break;
      case 12:
        if (!getCloudSqlSource().equals(other.getCloudSqlSource())) return false;
        break;
      case 13:
        if (!getFirestoreSource().equals(other.getFirestoreSource())) return false;
        break;
      case 14:
        if (!getAlloyDbSource().equals(other.getAlloyDbSource())) return false;
        break;
      case 15:
        if (!getBigtableSource().equals(other.getBigtableSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasErrorConfig()) {
      hash = (37 * hash) + ERROR_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getErrorConfig().hashCode();
    }
    hash = (37 * hash) + RECONCILIATION_MODE_FIELD_NUMBER;
    hash = (53 * hash) + reconciliationMode_;
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    hash = (37 * hash) + AUTO_GENERATE_IDS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoGenerateIds());
    hash = (37 * hash) + ID_FIELD_FIELD_NUMBER;
    hash = (53 * hash) + getIdField().hashCode();
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + INLINE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getInlineSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 4:
        hash = (37 * hash) + BIGQUERY_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getBigquerySource().hashCode();
        break;
      case 10:
        hash = (37 * hash) + FHIR_STORE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getFhirStoreSource().hashCode();
        break;
      case 11:
        hash = (37 * hash) + SPANNER_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getSpannerSource().hashCode();
        break;
      case 12:
        hash = (37 * hash) + CLOUD_SQL_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getCloudSqlSource().hashCode();
        break;
      case 13:
        hash = (37 * hash) + FIRESTORE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getFirestoreSource().hashCode();
        break;
      case 14:
        hash = (37 * hash) + ALLOY_DB_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getAlloyDbSource().hashCode();
        break;
      case 15:
        hash = (37 * hash) + BIGTABLE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getBigtableSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for Import methods.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest)
      com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ImportDocumentsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ImportDocumentsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.class,
              com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getErrorConfigFieldBuilder();
        getUpdateMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (inlineSourceBuilder_ != null) {
        inlineSourceBuilder_.clear();
      }
      if (gcsSourceBuilder_ != null) {
        gcsSourceBuilder_.clear();
      }
      if (bigquerySourceBuilder_ != null) {
        bigquerySourceBuilder_.clear();
      }
      if (fhirStoreSourceBuilder_ != null) {
        fhirStoreSourceBuilder_.clear();
      }
      if (spannerSourceBuilder_ != null) {
        spannerSourceBuilder_.clear();
      }
      if (cloudSqlSourceBuilder_ != null) {
        cloudSqlSourceBuilder_.clear();
      }
      if (firestoreSourceBuilder_ != null) {
        firestoreSourceBuilder_.clear();
      }
      if (alloyDbSourceBuilder_ != null) {
        alloyDbSourceBuilder_.clear();
      }
      if (bigtableSourceBuilder_ != null) {
        bigtableSourceBuilder_.clear();
      }
      parent_ = "";
      errorConfig_ = null;
      if (errorConfigBuilder_ != null) {
        errorConfigBuilder_.dispose();
        errorConfigBuilder_ = null;
      }
      reconciliationMode_ = 0;
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      autoGenerateIds_ = false;
      idField_ = "";
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ImportDocumentsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest build() {
      com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest buildPartial() {
      com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest result =
          new com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.errorConfig_ =
            errorConfigBuilder_ == null ? errorConfig_ : errorConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.reconciliationMode_ = reconciliationMode_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.autoGenerateIds_ = autoGenerateIds_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.idField_ = idField_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 2 && inlineSourceBuilder_ != null) {
        result.source_ = inlineSourceBuilder_.build();
      }
      if (sourceCase_ == 3 && gcsSourceBuilder_ != null) {
        result.source_ = gcsSourceBuilder_.build();
      }
      if (sourceCase_ == 4 && bigquerySourceBuilder_ != null) {
        result.source_ = bigquerySourceBuilder_.build();
      }
      if (sourceCase_ == 10 && fhirStoreSourceBuilder_ != null) {
        result.source_ = fhirStoreSourceBuilder_.build();
      }
      if (sourceCase_ == 11 && spannerSourceBuilder_ != null) {
        result.source_ = spannerSourceBuilder_.build();
      }
      if (sourceCase_ == 12 && cloudSqlSourceBuilder_ != null) {
        result.source_ = cloudSqlSourceBuilder_.build();
      }
      if (sourceCase_ == 13 && firestoreSourceBuilder_ != null) {
        result.source_ = firestoreSourceBuilder_.build();
      }
      if (sourceCase_ == 14 && alloyDbSourceBuilder_ != null) {
        result.source_ = alloyDbSourceBuilder_.build();
      }
      if (sourceCase_ == 15 && bigtableSourceBuilder_ != null) {
        result.source_ = bigtableSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasErrorConfig()) {
        mergeErrorConfig(other.getErrorConfig());
      }
      if (other.reconciliationMode_ != 0) {
        setReconciliationModeValue(other.getReconciliationModeValue());
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (other.getAutoGenerateIds() != false) {
        setAutoGenerateIds(other.getAutoGenerateIds());
      }
      if (!other.getIdField().isEmpty()) {
        idField_ = other.idField_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      switch (other.getSourceCase()) {
        case INLINE_SOURCE:
          {
            mergeInlineSource(other.getInlineSource());
            break;
          }
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case BIGQUERY_SOURCE:
          {
            mergeBigquerySource(other.getBigquerySource());
            break;
          }
        case FHIR_STORE_SOURCE:
          {
            mergeFhirStoreSource(other.getFhirStoreSource());
            break;
          }
        case SPANNER_SOURCE:
          {
            mergeSpannerSource(other.getSpannerSource());
            break;
          }
        case CLOUD_SQL_SOURCE:
          {
            mergeCloudSqlSource(other.getCloudSqlSource());
            break;
          }
        case FIRESTORE_SOURCE:
          {
            mergeFirestoreSource(other.getFirestoreSource());
            break;
          }
        case ALLOY_DB_SOURCE:
          {
            mergeAlloyDbSource(other.getAlloyDbSource());
            break;
          }
        case BIGTABLE_SOURCE:
          {
            mergeBigtableSource(other.getBigtableSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInlineSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getBigquerySourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getErrorConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 42
            case 48:
              {
                reconciliationMode_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 58
            case 64:
              {
                autoGenerateIds_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 64
            case 74:
              {
                idField_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getFhirStoreSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getSpannerSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getCloudSqlSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getFirestoreSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getAlloyDbSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getBigtableSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 15;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource,
            com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSourceOrBuilder>
        inlineSourceBuilder_;
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     *
     * @return Whether the inlineSource field is set.
     */
    @java.lang.Override
    public boolean hasInlineSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     *
     * @return The inlineSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
        getInlineSource() {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource)
              source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
            .getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return inlineSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder setInlineSource(
        com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource value) {
      if (inlineSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        inlineSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder setInlineSource(
        com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource.Builder
            builderForValue) {
      if (inlineSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        inlineSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder mergeInlineSource(
        com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource value) {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_
                != com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
                    .getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
                  .newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource)
                          source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          inlineSourceBuilder_.mergeFrom(value);
        } else {
          inlineSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder clearInlineSource() {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        inlineSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource.Builder
        getInlineSourceBuilder() {
      return getInlineSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSourceOrBuilder
        getInlineSourceOrBuilder() {
      if ((sourceCase_ == 2) && (inlineSourceBuilder_ != null)) {
        return inlineSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource)
              source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Inline source for the input content for documents.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource inline_source = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource,
            com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSourceOrBuilder>
        getInlineSourceFieldBuilder() {
      if (inlineSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
                  .getDefaultInstance();
        }
        inlineSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource,
                com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource
                    .Builder,
                com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest
                    .InlineSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.InlineSource)
                    source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return inlineSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.GcsSource,
            com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder>
        gcsSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.GcsSource getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          return (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 3) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    public Builder setGcsSource(com.google.cloud.discoveryengine.v1alpha.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    public Builder setGcsSource(
        com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder builderForValue) {
      if (gcsSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    public Builder mergeGcsSource(com.google.cloud.discoveryengine.v1alpha.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 3
            && source_ != com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.GcsSource.newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 3) {
          gcsSourceBuilder_.mergeFrom(value);
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if ((sourceCase_ == 3) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 3) {
          return (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.GcsSource,
            com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(sourceCase_ == 3)) {
          source_ = com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.GcsSource,
                com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder,
                com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 3;
      onChanged();
      return gcsSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.BigQuerySource,
            com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder,
            com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder>
        bigquerySourceBuilder_;
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigquerySource() {
      return sourceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     *
     * @return The bigquerySource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BigQuerySource getBigquerySource() {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 4) {
          return (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
      } else {
        if (sourceCase_ == 4) {
          return bigquerySourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    public Builder setBigquerySource(
        com.google.cloud.discoveryengine.v1alpha.BigQuerySource value) {
      if (bigquerySourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        bigquerySourceBuilder_.setMessage(value);
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    public Builder setBigquerySource(
        com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder builderForValue) {
      if (bigquerySourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        bigquerySourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    public Builder mergeBigquerySource(
        com.google.cloud.discoveryengine.v1alpha.BigQuerySource value) {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 4
            && source_
                != com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.BigQuerySource.newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 4) {
          bigquerySourceBuilder_.mergeFrom(value);
        } else {
          bigquerySourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    public Builder clearBigquerySource() {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
        }
        bigquerySourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder
        getBigquerySourceBuilder() {
      return getBigquerySourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder
        getBigquerySourceOrBuilder() {
      if ((sourceCase_ == 4) && (bigquerySourceBuilder_ != null)) {
        return bigquerySourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 4) {
          return (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.BigQuerySource,
            com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder,
            com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder>
        getBigquerySourceFieldBuilder() {
      if (bigquerySourceBuilder_ == null) {
        if (!(sourceCase_ == 4)) {
          source_ = com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
        }
        bigquerySourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.BigQuerySource,
                com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder,
                com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 4;
      onChanged();
      return bigquerySourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.FhirStoreSource,
            com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.FhirStoreSourceOrBuilder>
        fhirStoreSourceBuilder_;
    /**
     *
     *
     * <pre>
     * FhirStore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FhirStoreSource fhir_store_source = 10;</code>
     *
     * @return Whether the fhirStoreSource field is set.
     */
    @java.lang.Override
    public boolean hasFhirStoreSource() {
      return sourceCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * FhirStore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FhirStoreSource fhir_store_source = 10;</code>
     *
     * @return The fhirStoreSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FhirStoreSource getFhirStoreSource() {
      if (fhirStoreSourceBuilder_ == null) {
        if (sourceCase_ == 10) {
          return (com.google.cloud.discoveryengine.v1alpha.FhirStoreSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 10) {
          return fhirStoreSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * FhirStore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FhirStoreSource fhir_store_source = 10;</code>
     */
    public Builder setFhirStoreSource(
        com.google.cloud.discoveryengine.v1alpha.FhirStoreSource value) {
      if (fhirStoreSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        fhirStoreSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * FhirStore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FhirStoreSource fhir_store_source = 10;</code>
     */
    public Builder setFhirStoreSource(
        com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.Builder builderForValue) {
      if (fhirStoreSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        fhirStoreSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * FhirStore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FhirStoreSource fhir_store_source = 10;</code>
     */
    public Builder mergeFhirStoreSource(
        com.google.cloud.discoveryengine.v1alpha.FhirStoreSource value) {
      if (fhirStoreSourceBuilder_ == null) {
        if (sourceCase_ == 10
            && source_
                != com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.FhirStoreSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 10) {
          fhirStoreSourceBuilder_.mergeFrom(value);
        } else {
          fhirStoreSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * FhirStore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FhirStoreSource fhir_store_source = 10;</code>
     */
    public Builder clearFhirStoreSource() {
      if (fhirStoreSourceBuilder_ == null) {
        if (sourceCase_ == 10) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 10) {
          sourceCase_ = 0;
          source_ = null;
        }
        fhirStoreSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * FhirStore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FhirStoreSource fhir_store_source = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.Builder
        getFhirStoreSourceBuilder() {
      return getFhirStoreSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * FhirStore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FhirStoreSource fhir_store_source = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FhirStoreSourceOrBuilder
        getFhirStoreSourceOrBuilder() {
      if ((sourceCase_ == 10) && (fhirStoreSourceBuilder_ != null)) {
        return fhirStoreSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 10) {
          return (com.google.cloud.discoveryengine.v1alpha.FhirStoreSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * FhirStore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FhirStoreSource fhir_store_source = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.FhirStoreSource,
            com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.FhirStoreSourceOrBuilder>
        getFhirStoreSourceFieldBuilder() {
      if (fhirStoreSourceBuilder_ == null) {
        if (!(sourceCase_ == 10)) {
          source_ = com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.getDefaultInstance();
        }
        fhirStoreSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.FhirStoreSource,
                com.google.cloud.discoveryengine.v1alpha.FhirStoreSource.Builder,
                com.google.cloud.discoveryengine.v1alpha.FhirStoreSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.FhirStoreSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 10;
      onChanged();
      return fhirStoreSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.SpannerSource,
            com.google.cloud.discoveryengine.v1alpha.SpannerSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.SpannerSourceOrBuilder>
        spannerSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Spanner input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.SpannerSource spanner_source = 11;</code>
     *
     * @return Whether the spannerSource field is set.
     */
    @java.lang.Override
    public boolean hasSpannerSource() {
      return sourceCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Spanner input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.SpannerSource spanner_source = 11;</code>
     *
     * @return The spannerSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.SpannerSource getSpannerSource() {
      if (spannerSourceBuilder_ == null) {
        if (sourceCase_ == 11) {
          return (com.google.cloud.discoveryengine.v1alpha.SpannerSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.SpannerSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 11) {
          return spannerSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.SpannerSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Spanner input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.SpannerSource spanner_source = 11;</code>
     */
    public Builder setSpannerSource(com.google.cloud.discoveryengine.v1alpha.SpannerSource value) {
      if (spannerSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        spannerSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spanner input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.SpannerSource spanner_source = 11;</code>
     */
    public Builder setSpannerSource(
        com.google.cloud.discoveryengine.v1alpha.SpannerSource.Builder builderForValue) {
      if (spannerSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        spannerSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spanner input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.SpannerSource spanner_source = 11;</code>
     */
    public Builder mergeSpannerSource(
        com.google.cloud.discoveryengine.v1alpha.SpannerSource value) {
      if (spannerSourceBuilder_ == null) {
        if (sourceCase_ == 11
            && source_
                != com.google.cloud.discoveryengine.v1alpha.SpannerSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.SpannerSource.newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.SpannerSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 11) {
          spannerSourceBuilder_.mergeFrom(value);
        } else {
          spannerSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spanner input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.SpannerSource spanner_source = 11;</code>
     */
    public Builder clearSpannerSource() {
      if (spannerSourceBuilder_ == null) {
        if (sourceCase_ == 11) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 11) {
          sourceCase_ = 0;
          source_ = null;
        }
        spannerSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spanner input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.SpannerSource spanner_source = 11;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.SpannerSource.Builder
        getSpannerSourceBuilder() {
      return getSpannerSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Spanner input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.SpannerSource spanner_source = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.SpannerSourceOrBuilder
        getSpannerSourceOrBuilder() {
      if ((sourceCase_ == 11) && (spannerSourceBuilder_ != null)) {
        return spannerSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 11) {
          return (com.google.cloud.discoveryengine.v1alpha.SpannerSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.SpannerSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Spanner input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.SpannerSource spanner_source = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.SpannerSource,
            com.google.cloud.discoveryengine.v1alpha.SpannerSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.SpannerSourceOrBuilder>
        getSpannerSourceFieldBuilder() {
      if (spannerSourceBuilder_ == null) {
        if (!(sourceCase_ == 11)) {
          source_ = com.google.cloud.discoveryengine.v1alpha.SpannerSource.getDefaultInstance();
        }
        spannerSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.SpannerSource,
                com.google.cloud.discoveryengine.v1alpha.SpannerSource.Builder,
                com.google.cloud.discoveryengine.v1alpha.SpannerSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.SpannerSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 11;
      onChanged();
      return spannerSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.CloudSqlSource,
            com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.CloudSqlSourceOrBuilder>
        cloudSqlSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud SQL input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.CloudSqlSource cloud_sql_source = 12;</code>
     *
     * @return Whether the cloudSqlSource field is set.
     */
    @java.lang.Override
    public boolean hasCloudSqlSource() {
      return sourceCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Cloud SQL input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.CloudSqlSource cloud_sql_source = 12;</code>
     *
     * @return The cloudSqlSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.CloudSqlSource getCloudSqlSource() {
      if (cloudSqlSourceBuilder_ == null) {
        if (sourceCase_ == 12) {
          return (com.google.cloud.discoveryengine.v1alpha.CloudSqlSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 12) {
          return cloudSqlSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud SQL input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.CloudSqlSource cloud_sql_source = 12;</code>
     */
    public Builder setCloudSqlSource(
        com.google.cloud.discoveryengine.v1alpha.CloudSqlSource value) {
      if (cloudSqlSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        cloudSqlSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud SQL input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.CloudSqlSource cloud_sql_source = 12;</code>
     */
    public Builder setCloudSqlSource(
        com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.Builder builderForValue) {
      if (cloudSqlSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        cloudSqlSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud SQL input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.CloudSqlSource cloud_sql_source = 12;</code>
     */
    public Builder mergeCloudSqlSource(
        com.google.cloud.discoveryengine.v1alpha.CloudSqlSource value) {
      if (cloudSqlSourceBuilder_ == null) {
        if (sourceCase_ == 12
            && source_
                != com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.CloudSqlSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 12) {
          cloudSqlSourceBuilder_.mergeFrom(value);
        } else {
          cloudSqlSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud SQL input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.CloudSqlSource cloud_sql_source = 12;</code>
     */
    public Builder clearCloudSqlSource() {
      if (cloudSqlSourceBuilder_ == null) {
        if (sourceCase_ == 12) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 12) {
          sourceCase_ = 0;
          source_ = null;
        }
        cloudSqlSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud SQL input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.CloudSqlSource cloud_sql_source = 12;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.Builder
        getCloudSqlSourceBuilder() {
      return getCloudSqlSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud SQL input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.CloudSqlSource cloud_sql_source = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.CloudSqlSourceOrBuilder
        getCloudSqlSourceOrBuilder() {
      if ((sourceCase_ == 12) && (cloudSqlSourceBuilder_ != null)) {
        return cloudSqlSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 12) {
          return (com.google.cloud.discoveryengine.v1alpha.CloudSqlSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud SQL input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.CloudSqlSource cloud_sql_source = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.CloudSqlSource,
            com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.CloudSqlSourceOrBuilder>
        getCloudSqlSourceFieldBuilder() {
      if (cloudSqlSourceBuilder_ == null) {
        if (!(sourceCase_ == 12)) {
          source_ = com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.getDefaultInstance();
        }
        cloudSqlSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.CloudSqlSource,
                com.google.cloud.discoveryengine.v1alpha.CloudSqlSource.Builder,
                com.google.cloud.discoveryengine.v1alpha.CloudSqlSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.CloudSqlSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 12;
      onChanged();
      return cloudSqlSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.FirestoreSource,
            com.google.cloud.discoveryengine.v1alpha.FirestoreSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.FirestoreSourceOrBuilder>
        firestoreSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Firestore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FirestoreSource firestore_source = 13;</code>
     *
     * @return Whether the firestoreSource field is set.
     */
    @java.lang.Override
    public boolean hasFirestoreSource() {
      return sourceCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Firestore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FirestoreSource firestore_source = 13;</code>
     *
     * @return The firestoreSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FirestoreSource getFirestoreSource() {
      if (firestoreSourceBuilder_ == null) {
        if (sourceCase_ == 13) {
          return (com.google.cloud.discoveryengine.v1alpha.FirestoreSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.FirestoreSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 13) {
          return firestoreSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.FirestoreSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Firestore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FirestoreSource firestore_source = 13;</code>
     */
    public Builder setFirestoreSource(
        com.google.cloud.discoveryengine.v1alpha.FirestoreSource value) {
      if (firestoreSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        firestoreSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Firestore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FirestoreSource firestore_source = 13;</code>
     */
    public Builder setFirestoreSource(
        com.google.cloud.discoveryengine.v1alpha.FirestoreSource.Builder builderForValue) {
      if (firestoreSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        firestoreSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Firestore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FirestoreSource firestore_source = 13;</code>
     */
    public Builder mergeFirestoreSource(
        com.google.cloud.discoveryengine.v1alpha.FirestoreSource value) {
      if (firestoreSourceBuilder_ == null) {
        if (sourceCase_ == 13
            && source_
                != com.google.cloud.discoveryengine.v1alpha.FirestoreSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.FirestoreSource.newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.FirestoreSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 13) {
          firestoreSourceBuilder_.mergeFrom(value);
        } else {
          firestoreSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Firestore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FirestoreSource firestore_source = 13;</code>
     */
    public Builder clearFirestoreSource() {
      if (firestoreSourceBuilder_ == null) {
        if (sourceCase_ == 13) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 13) {
          sourceCase_ = 0;
          source_ = null;
        }
        firestoreSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Firestore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FirestoreSource firestore_source = 13;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.FirestoreSource.Builder
        getFirestoreSourceBuilder() {
      return getFirestoreSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Firestore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FirestoreSource firestore_source = 13;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.FirestoreSourceOrBuilder
        getFirestoreSourceOrBuilder() {
      if ((sourceCase_ == 13) && (firestoreSourceBuilder_ != null)) {
        return firestoreSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 13) {
          return (com.google.cloud.discoveryengine.v1alpha.FirestoreSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.FirestoreSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Firestore input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.FirestoreSource firestore_source = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.FirestoreSource,
            com.google.cloud.discoveryengine.v1alpha.FirestoreSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.FirestoreSourceOrBuilder>
        getFirestoreSourceFieldBuilder() {
      if (firestoreSourceBuilder_ == null) {
        if (!(sourceCase_ == 13)) {
          source_ = com.google.cloud.discoveryengine.v1alpha.FirestoreSource.getDefaultInstance();
        }
        firestoreSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.FirestoreSource,
                com.google.cloud.discoveryengine.v1alpha.FirestoreSource.Builder,
                com.google.cloud.discoveryengine.v1alpha.FirestoreSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.FirestoreSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 13;
      onChanged();
      return firestoreSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.AlloyDbSource,
            com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.AlloyDbSourceOrBuilder>
        alloyDbSourceBuilder_;
    /**
     *
     *
     * <pre>
     * AlloyDB input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.AlloyDbSource alloy_db_source = 14;</code>
     *
     * @return Whether the alloyDbSource field is set.
     */
    @java.lang.Override
    public boolean hasAlloyDbSource() {
      return sourceCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * AlloyDB input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.AlloyDbSource alloy_db_source = 14;</code>
     *
     * @return The alloyDbSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.AlloyDbSource getAlloyDbSource() {
      if (alloyDbSourceBuilder_ == null) {
        if (sourceCase_ == 14) {
          return (com.google.cloud.discoveryengine.v1alpha.AlloyDbSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 14) {
          return alloyDbSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * AlloyDB input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.AlloyDbSource alloy_db_source = 14;</code>
     */
    public Builder setAlloyDbSource(com.google.cloud.discoveryengine.v1alpha.AlloyDbSource value) {
      if (alloyDbSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        alloyDbSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * AlloyDB input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.AlloyDbSource alloy_db_source = 14;</code>
     */
    public Builder setAlloyDbSource(
        com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.Builder builderForValue) {
      if (alloyDbSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        alloyDbSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * AlloyDB input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.AlloyDbSource alloy_db_source = 14;</code>
     */
    public Builder mergeAlloyDbSource(
        com.google.cloud.discoveryengine.v1alpha.AlloyDbSource value) {
      if (alloyDbSourceBuilder_ == null) {
        if (sourceCase_ == 14
            && source_
                != com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.AlloyDbSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 14) {
          alloyDbSourceBuilder_.mergeFrom(value);
        } else {
          alloyDbSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * AlloyDB input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.AlloyDbSource alloy_db_source = 14;</code>
     */
    public Builder clearAlloyDbSource() {
      if (alloyDbSourceBuilder_ == null) {
        if (sourceCase_ == 14) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 14) {
          sourceCase_ = 0;
          source_ = null;
        }
        alloyDbSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * AlloyDB input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.AlloyDbSource alloy_db_source = 14;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.Builder
        getAlloyDbSourceBuilder() {
      return getAlloyDbSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * AlloyDB input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.AlloyDbSource alloy_db_source = 14;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.AlloyDbSourceOrBuilder
        getAlloyDbSourceOrBuilder() {
      if ((sourceCase_ == 14) && (alloyDbSourceBuilder_ != null)) {
        return alloyDbSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 14) {
          return (com.google.cloud.discoveryengine.v1alpha.AlloyDbSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * AlloyDB input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.AlloyDbSource alloy_db_source = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.AlloyDbSource,
            com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.AlloyDbSourceOrBuilder>
        getAlloyDbSourceFieldBuilder() {
      if (alloyDbSourceBuilder_ == null) {
        if (!(sourceCase_ == 14)) {
          source_ = com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.getDefaultInstance();
        }
        alloyDbSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.AlloyDbSource,
                com.google.cloud.discoveryengine.v1alpha.AlloyDbSource.Builder,
                com.google.cloud.discoveryengine.v1alpha.AlloyDbSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.AlloyDbSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 14;
      onChanged();
      return alloyDbSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.BigtableSource,
            com.google.cloud.discoveryengine.v1alpha.BigtableSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.BigtableSourceOrBuilder>
        bigtableSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud Bigtable input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigtableSource bigtable_source = 15;</code>
     *
     * @return Whether the bigtableSource field is set.
     */
    @java.lang.Override
    public boolean hasBigtableSource() {
      return sourceCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Cloud Bigtable input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigtableSource bigtable_source = 15;</code>
     *
     * @return The bigtableSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BigtableSource getBigtableSource() {
      if (bigtableSourceBuilder_ == null) {
        if (sourceCase_ == 15) {
          return (com.google.cloud.discoveryengine.v1alpha.BigtableSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.BigtableSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 15) {
          return bigtableSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.BigtableSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Bigtable input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigtableSource bigtable_source = 15;</code>
     */
    public Builder setBigtableSource(
        com.google.cloud.discoveryengine.v1alpha.BigtableSource value) {
      if (bigtableSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        bigtableSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Bigtable input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigtableSource bigtable_source = 15;</code>
     */
    public Builder setBigtableSource(
        com.google.cloud.discoveryengine.v1alpha.BigtableSource.Builder builderForValue) {
      if (bigtableSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        bigtableSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Bigtable input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigtableSource bigtable_source = 15;</code>
     */
    public Builder mergeBigtableSource(
        com.google.cloud.discoveryengine.v1alpha.BigtableSource value) {
      if (bigtableSourceBuilder_ == null) {
        if (sourceCase_ == 15
            && source_
                != com.google.cloud.discoveryengine.v1alpha.BigtableSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.BigtableSource.newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.BigtableSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 15) {
          bigtableSourceBuilder_.mergeFrom(value);
        } else {
          bigtableSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Bigtable input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigtableSource bigtable_source = 15;</code>
     */
    public Builder clearBigtableSource() {
      if (bigtableSourceBuilder_ == null) {
        if (sourceCase_ == 15) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 15) {
          sourceCase_ = 0;
          source_ = null;
        }
        bigtableSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Bigtable input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigtableSource bigtable_source = 15;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.BigtableSource.Builder
        getBigtableSourceBuilder() {
      return getBigtableSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud Bigtable input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigtableSource bigtable_source = 15;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BigtableSourceOrBuilder
        getBigtableSourceOrBuilder() {
      if ((sourceCase_ == 15) && (bigtableSourceBuilder_ != null)) {
        return bigtableSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 15) {
          return (com.google.cloud.discoveryengine.v1alpha.BigtableSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.BigtableSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Bigtable input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigtableSource bigtable_source = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.BigtableSource,
            com.google.cloud.discoveryengine.v1alpha.BigtableSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.BigtableSourceOrBuilder>
        getBigtableSourceFieldBuilder() {
      if (bigtableSourceBuilder_ == null) {
        if (!(sourceCase_ == 15)) {
          source_ = com.google.cloud.discoveryengine.v1alpha.BigtableSource.getDefaultInstance();
        }
        bigtableSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.BigtableSource,
                com.google.cloud.discoveryengine.v1alpha.BigtableSource.Builder,
                com.google.cloud.discoveryengine.v1alpha.BigtableSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.BigtableSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 15;
      onChanged();
      return bigtableSourceBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent branch resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
     * Requires create/update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent branch resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
     * Requires create/update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent branch resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
     * Requires create/update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent branch resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
     * Requires create/update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent branch resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.
     * Requires create/update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig errorConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig,
            com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.Builder,
            com.google.cloud.discoveryengine.v1alpha.ImportErrorConfigOrBuilder>
        errorConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     *
     * @return Whether the errorConfig field is set.
     */
    public boolean hasErrorConfig() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     *
     * @return The errorConfig.
     */
    public com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig getErrorConfig() {
      if (errorConfigBuilder_ == null) {
        return errorConfig_ == null
            ? com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.getDefaultInstance()
            : errorConfig_;
      } else {
        return errorConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    public Builder setErrorConfig(
        com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig value) {
      if (errorConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorConfig_ = value;
      } else {
        errorConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    public Builder setErrorConfig(
        com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.Builder builderForValue) {
      if (errorConfigBuilder_ == null) {
        errorConfig_ = builderForValue.build();
      } else {
        errorConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    public Builder mergeErrorConfig(
        com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig value) {
      if (errorConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && errorConfig_ != null
            && errorConfig_
                != com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig
                    .getDefaultInstance()) {
          getErrorConfigBuilder().mergeFrom(value);
        } else {
          errorConfig_ = value;
        }
      } else {
        errorConfigBuilder_.mergeFrom(value);
      }
      if (errorConfig_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    public Builder clearErrorConfig() {
      bitField0_ = (bitField0_ & ~0x00000400);
      errorConfig_ = null;
      if (errorConfigBuilder_ != null) {
        errorConfigBuilder_.dispose();
        errorConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.Builder
        getErrorConfigBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getErrorConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.ImportErrorConfigOrBuilder
        getErrorConfigOrBuilder() {
      if (errorConfigBuilder_ != null) {
        return errorConfigBuilder_.getMessageOrBuilder();
      } else {
        return errorConfig_ == null
            ? com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.getDefaultInstance()
            : errorConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig,
            com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.Builder,
            com.google.cloud.discoveryengine.v1alpha.ImportErrorConfigOrBuilder>
        getErrorConfigFieldBuilder() {
      if (errorConfigBuilder_ == null) {
        errorConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig,
                com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.Builder,
                com.google.cloud.discoveryengine.v1alpha.ImportErrorConfigOrBuilder>(
                getErrorConfig(), getParentForChildren(), isClean());
        errorConfig_ = null;
      }
      return errorConfigBuilder_;
    }

    private int reconciliationMode_ = 0;
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing documents and the documents to
     * be imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for reconciliationMode.
     */
    @java.lang.Override
    public int getReconciliationModeValue() {
      return reconciliationMode_;
    }
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing documents and the documents to
     * be imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
     * </code>
     *
     * @param value The enum numeric value on the wire for reconciliationMode to set.
     * @return This builder for chaining.
     */
    public Builder setReconciliationModeValue(int value) {
      reconciliationMode_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing documents and the documents to
     * be imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
     * </code>
     *
     * @return The reconciliationMode.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode
        getReconciliationMode() {
      com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode result =
          com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode
              .forNumber(reconciliationMode_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing documents and the documents to
     * be imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
     * </code>
     *
     * @param value The reconciliationMode to set.
     * @return This builder for chaining.
     */
    public Builder setReconciliationMode(
        com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      reconciliationMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing documents and the documents to
     * be imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode reconciliation_mode = 6;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciliationMode() {
      bitField0_ = (bitField0_ & ~0x00000800);
      reconciliationMode_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported documents to update. If
     * not set, the default is to update all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7;</code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported documents to update. If
     * not set, the default is to update all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7;</code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported documents to update. If
     * not set, the default is to update all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7;</code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported documents to update. If
     * not set, the default is to update all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7;</code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported documents to update. If
     * not set, the default is to update all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7;</code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      if (updateMask_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported documents to update. If
     * not set, the default is to update all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7;</code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00001000);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported documents to update. If
     * not set, the default is to update all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7;</code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported documents to update. If
     * not set, the default is to update all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported documents to update. If
     * not set, the default is to update all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private boolean autoGenerateIds_;
    /**
     *
     *
     * <pre>
     * Whether to automatically generate IDs for the documents if absent.
     *
     * If set to `true`,
     * [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s are
     * automatically generated based on the hash of the payload, where IDs may not
     * be consistent during multiple imports. In which case
     * [ReconciliationMode.FULL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.FULL]
     * is highly recommended to avoid duplicate contents. If unset or set to
     * `false`, [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s
     * have to be specified using
     * [id_field][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.id_field],
     * otherwise, documents without IDs fail to be imported.
     *
     * Supported data sources:
     *
     * * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
     * * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
     * * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
     * * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
     * </pre>
     *
     * <code>bool auto_generate_ids = 8;</code>
     *
     * @return The autoGenerateIds.
     */
    @java.lang.Override
    public boolean getAutoGenerateIds() {
      return autoGenerateIds_;
    }
    /**
     *
     *
     * <pre>
     * Whether to automatically generate IDs for the documents if absent.
     *
     * If set to `true`,
     * [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s are
     * automatically generated based on the hash of the payload, where IDs may not
     * be consistent during multiple imports. In which case
     * [ReconciliationMode.FULL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.FULL]
     * is highly recommended to avoid duplicate contents. If unset or set to
     * `false`, [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s
     * have to be specified using
     * [id_field][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.id_field],
     * otherwise, documents without IDs fail to be imported.
     *
     * Supported data sources:
     *
     * * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
     * * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
     * * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
     * * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
     * </pre>
     *
     * <code>bool auto_generate_ids = 8;</code>
     *
     * @param value The autoGenerateIds to set.
     * @return This builder for chaining.
     */
    public Builder setAutoGenerateIds(boolean value) {

      autoGenerateIds_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to automatically generate IDs for the documents if absent.
     *
     * If set to `true`,
     * [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s are
     * automatically generated based on the hash of the payload, where IDs may not
     * be consistent during multiple imports. In which case
     * [ReconciliationMode.FULL][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.ReconciliationMode.FULL]
     * is highly recommended to avoid duplicate contents. If unset or set to
     * `false`, [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s
     * have to be specified using
     * [id_field][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.id_field],
     * otherwise, documents without IDs fail to be imported.
     *
     * Supported data sources:
     *
     * * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
     * * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
     * * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
     * * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
     * </pre>
     *
     * <code>bool auto_generate_ids = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoGenerateIds() {
      bitField0_ = (bitField0_ & ~0x00002000);
      autoGenerateIds_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object idField_ = "";
    /**
     *
     *
     * <pre>
     * The field indicates the ID field or column to be used as unique IDs of
     * the documents.
     *
     * For [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource] it is the
     * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
     * "some_uuid"}`. For others, it may be the column name of the table where the
     * unique ids are stored.
     *
     * The values of the JSON field or the table column are used as the
     * [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s. The JSON
     * field or the table column must be of string type, and the values must be
     * set as valid strings conform to
     * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
     * Otherwise, documents without valid IDs fail to be imported.
     *
     * Only set this field when
     * [auto_generate_ids][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.auto_generate_ids]
     * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
     *
     * If it is unset, a default value `_id` is used when importing from the
     * allowed data sources.
     *
     * Supported data sources:
     *
     * * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
     * * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
     * * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
     * * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
     * </pre>
     *
     * <code>string id_field = 9;</code>
     *
     * @return The idField.
     */
    public java.lang.String getIdField() {
      java.lang.Object ref = idField_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        idField_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The field indicates the ID field or column to be used as unique IDs of
     * the documents.
     *
     * For [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource] it is the
     * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
     * "some_uuid"}`. For others, it may be the column name of the table where the
     * unique ids are stored.
     *
     * The values of the JSON field or the table column are used as the
     * [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s. The JSON
     * field or the table column must be of string type, and the values must be
     * set as valid strings conform to
     * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
     * Otherwise, documents without valid IDs fail to be imported.
     *
     * Only set this field when
     * [auto_generate_ids][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.auto_generate_ids]
     * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
     *
     * If it is unset, a default value `_id` is used when importing from the
     * allowed data sources.
     *
     * Supported data sources:
     *
     * * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
     * * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
     * * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
     * * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
     * </pre>
     *
     * <code>string id_field = 9;</code>
     *
     * @return The bytes for idField.
     */
    public com.google.protobuf.ByteString getIdFieldBytes() {
      java.lang.Object ref = idField_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        idField_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The field indicates the ID field or column to be used as unique IDs of
     * the documents.
     *
     * For [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource] it is the
     * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
     * "some_uuid"}`. For others, it may be the column name of the table where the
     * unique ids are stored.
     *
     * The values of the JSON field or the table column are used as the
     * [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s. The JSON
     * field or the table column must be of string type, and the values must be
     * set as valid strings conform to
     * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
     * Otherwise, documents without valid IDs fail to be imported.
     *
     * Only set this field when
     * [auto_generate_ids][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.auto_generate_ids]
     * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
     *
     * If it is unset, a default value `_id` is used when importing from the
     * allowed data sources.
     *
     * Supported data sources:
     *
     * * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
     * * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
     * * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
     * * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
     * </pre>
     *
     * <code>string id_field = 9;</code>
     *
     * @param value The idField to set.
     * @return This builder for chaining.
     */
    public Builder setIdField(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      idField_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field indicates the ID field or column to be used as unique IDs of
     * the documents.
     *
     * For [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource] it is the
     * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
     * "some_uuid"}`. For others, it may be the column name of the table where the
     * unique ids are stored.
     *
     * The values of the JSON field or the table column are used as the
     * [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s. The JSON
     * field or the table column must be of string type, and the values must be
     * set as valid strings conform to
     * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
     * Otherwise, documents without valid IDs fail to be imported.
     *
     * Only set this field when
     * [auto_generate_ids][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.auto_generate_ids]
     * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
     *
     * If it is unset, a default value `_id` is used when importing from the
     * allowed data sources.
     *
     * Supported data sources:
     *
     * * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
     * * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
     * * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
     * * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
     * </pre>
     *
     * <code>string id_field = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIdField() {
      idField_ = getDefaultInstance().getIdField();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field indicates the ID field or column to be used as unique IDs of
     * the documents.
     *
     * For [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource] it is the
     * key of the JSON field. For instance, `my_id` for JSON `{"my_id":
     * "some_uuid"}`. For others, it may be the column name of the table where the
     * unique ids are stored.
     *
     * The values of the JSON field or the table column are used as the
     * [Document.id][google.cloud.discoveryengine.v1alpha.Document.id]s. The JSON
     * field or the table column must be of string type, and the values must be
     * set as valid strings conform to
     * [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters.
     * Otherwise, documents without valid IDs fail to be imported.
     *
     * Only set this field when
     * [auto_generate_ids][google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest.auto_generate_ids]
     * is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown.
     *
     * If it is unset, a default value `_id` is used when importing from the
     * allowed data sources.
     *
     * Supported data sources:
     *
     * * [GcsSource][google.cloud.discoveryengine.v1alpha.GcsSource].
     * [GcsSource.data_schema][google.cloud.discoveryengine.v1alpha.GcsSource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [BigQuerySource][google.cloud.discoveryengine.v1alpha.BigQuerySource].
     * [BigQuerySource.data_schema][google.cloud.discoveryengine.v1alpha.BigQuerySource.data_schema]
     * must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
     * * [SpannerSource][google.cloud.discoveryengine.v1alpha.SpannerSource].
     * * [CloudSqlSource][google.cloud.discoveryengine.v1alpha.CloudSqlSource].
     * * [FirestoreSource][google.cloud.discoveryengine.v1alpha.FirestoreSource].
     * * [BigtableSource][google.cloud.discoveryengine.v1alpha.BigtableSource].
     * </pre>
     *
     * <code>string id_field = 9;</code>
     *
     * @param value The bytes for idField to set.
     * @return This builder for chaining.
     */
    public Builder setIdFieldBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      idField_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest)
  private static final com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest();
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportDocumentsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportDocumentsRequest>() {
        @java.lang.Override
        public ImportDocumentsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportDocumentsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportDocumentsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ImportDocumentsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
