/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1alpha/estimate_billing_service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1alpha;

/**
 *
 *
 * <pre>
 * Request message for
 * [EstimateBillingService.EstimateDataSize][google.cloud.discoveryengine.v1alpha.EstimateBillingService.EstimateDataSize]
 * method
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest}
 */
public final class EstimateDataSizeRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest)
    EstimateDataSizeRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EstimateDataSizeRequest.newBuilder() to construct.
  private EstimateDataSizeRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EstimateDataSizeRequest() {
    location_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EstimateDataSizeRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.class,
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.Builder.class);
  }

  public interface WebsiteDataSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The URI patterns to estimate the data sizes. At most 10
     * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                .EstimatorUriPattern>
        getEstimatorUriPatternsList();
    /**
     *
     *
     * <pre>
     * Required. The URI patterns to estimate the data sizes. At most 10
     * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
            .EstimatorUriPattern
        getEstimatorUriPatterns(int index);
    /**
     *
     *
     * <pre>
     * Required. The URI patterns to estimate the data sizes. At most 10
     * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getEstimatorUriPatternsCount();
    /**
     *
     *
     * <pre>
     * Required. The URI patterns to estimate the data sizes. At most 10
     * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                    .EstimatorUriPatternOrBuilder>
        getEstimatorUriPatternsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. The URI patterns to estimate the data sizes. At most 10
     * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
            .EstimatorUriPatternOrBuilder
        getEstimatorUriPatternsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Data source is a set of website patterns that we crawl to get
   * the total number of websites.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource}
   */
  public static final class WebsiteDataSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource)
      WebsiteDataSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WebsiteDataSource.newBuilder() to construct.
    private WebsiteDataSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WebsiteDataSource() {
      estimatorUriPatterns_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WebsiteDataSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_WebsiteDataSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_WebsiteDataSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .class,
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .Builder.class);
    }

    public interface EstimatorUriPatternOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * User provided URI pattern. For example, `foo.com/bar/&#42;`.
       * </pre>
       *
       * <code>string provided_uri_pattern = 1;</code>
       *
       * @return The providedUriPattern.
       */
      java.lang.String getProvidedUriPattern();
      /**
       *
       *
       * <pre>
       * User provided URI pattern. For example, `foo.com/bar/&#42;`.
       * </pre>
       *
       * <code>string provided_uri_pattern = 1;</code>
       *
       * @return The bytes for providedUriPattern.
       */
      com.google.protobuf.ByteString getProvidedUriPatternBytes();

      /**
       *
       *
       * <pre>
       * Whether we infer the generated URI or use the exact provided one.
       * </pre>
       *
       * <code>bool exact_match = 2;</code>
       *
       * @return The exactMatch.
       */
      boolean getExactMatch();

      /**
       *
       *
       * <pre>
       * Whether the pattern is exclusive or not. If set to true, the pattern is
       * considered exclusive. If unset or set to false, the pattern is
       * considered inclusive by default.
       * </pre>
       *
       * <code>bool exclusive = 3;</code>
       *
       * @return The exclusive.
       */
      boolean getExclusive();
    }
    /**
     *
     *
     * <pre>
     * URI patterns that we use to crawl.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern}
     */
    public static final class EstimatorUriPattern extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern)
        EstimatorUriPatternOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use EstimatorUriPattern.newBuilder() to construct.
      private EstimatorUriPattern(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private EstimatorUriPattern() {
        providedUriPattern_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new EstimatorUriPattern();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                    .EstimatorUriPattern.class,
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                    .EstimatorUriPattern.Builder.class);
      }

      public static final int PROVIDED_URI_PATTERN_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object providedUriPattern_ = "";
      /**
       *
       *
       * <pre>
       * User provided URI pattern. For example, `foo.com/bar/&#42;`.
       * </pre>
       *
       * <code>string provided_uri_pattern = 1;</code>
       *
       * @return The providedUriPattern.
       */
      @java.lang.Override
      public java.lang.String getProvidedUriPattern() {
        java.lang.Object ref = providedUriPattern_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          providedUriPattern_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * User provided URI pattern. For example, `foo.com/bar/&#42;`.
       * </pre>
       *
       * <code>string provided_uri_pattern = 1;</code>
       *
       * @return The bytes for providedUriPattern.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getProvidedUriPatternBytes() {
        java.lang.Object ref = providedUriPattern_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          providedUriPattern_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int EXACT_MATCH_FIELD_NUMBER = 2;
      private boolean exactMatch_ = false;
      /**
       *
       *
       * <pre>
       * Whether we infer the generated URI or use the exact provided one.
       * </pre>
       *
       * <code>bool exact_match = 2;</code>
       *
       * @return The exactMatch.
       */
      @java.lang.Override
      public boolean getExactMatch() {
        return exactMatch_;
      }

      public static final int EXCLUSIVE_FIELD_NUMBER = 3;
      private boolean exclusive_ = false;
      /**
       *
       *
       * <pre>
       * Whether the pattern is exclusive or not. If set to true, the pattern is
       * considered exclusive. If unset or set to false, the pattern is
       * considered inclusive by default.
       * </pre>
       *
       * <code>bool exclusive = 3;</code>
       *
       * @return The exclusive.
       */
      @java.lang.Override
      public boolean getExclusive() {
        return exclusive_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(providedUriPattern_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, providedUriPattern_);
        }
        if (exactMatch_ != false) {
          output.writeBool(2, exactMatch_);
        }
        if (exclusive_ != false) {
          output.writeBool(3, exclusive_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(providedUriPattern_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, providedUriPattern_);
        }
        if (exactMatch_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, exactMatch_);
        }
        if (exclusive_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, exclusive_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                .EstimatorUriPattern)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                .EstimatorUriPattern
            other =
                (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                        .EstimatorUriPattern)
                    obj;

        if (!getProvidedUriPattern().equals(other.getProvidedUriPattern())) return false;
        if (getExactMatch() != other.getExactMatch()) return false;
        if (getExclusive() != other.getExclusive()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + PROVIDED_URI_PATTERN_FIELD_NUMBER;
        hash = (53 * hash) + getProvidedUriPattern().hashCode();
        hash = (37 * hash) + EXACT_MATCH_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExactMatch());
        hash = (37 * hash) + EXCLUSIVE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExclusive());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * URI patterns that we use to crawl.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern)
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
              .EstimatorUriPatternOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
              .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
              .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                      .EstimatorUriPattern.class,
                  com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                      .EstimatorUriPattern.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          providedUriPattern_ = "";
          exactMatch_ = false;
          exclusive_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
              .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_WebsiteDataSource_EstimatorUriPattern_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                .EstimatorUriPattern
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
              .EstimatorUriPattern.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                .EstimatorUriPattern
            build() {
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                .EstimatorUriPattern
            buildPartial() {
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern
              result =
                  new com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                      .WebsiteDataSource.EstimatorUriPattern(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                    .EstimatorUriPattern
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.providedUriPattern_ = providedUriPattern_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.exactMatch_ = exactMatch_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.exclusive_ = exclusive_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                        .EstimatorUriPattern)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                    .EstimatorUriPattern
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern.getDefaultInstance()) return this;
          if (!other.getProvidedUriPattern().isEmpty()) {
            providedUriPattern_ = other.providedUriPattern_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getExactMatch() != false) {
            setExactMatch(other.getExactMatch());
          }
          if (other.getExclusive() != false) {
            setExclusive(other.getExclusive());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    providedUriPattern_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    exactMatch_ = input.readBool();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    exclusive_ = input.readBool();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object providedUriPattern_ = "";
        /**
         *
         *
         * <pre>
         * User provided URI pattern. For example, `foo.com/bar/&#42;`.
         * </pre>
         *
         * <code>string provided_uri_pattern = 1;</code>
         *
         * @return The providedUriPattern.
         */
        public java.lang.String getProvidedUriPattern() {
          java.lang.Object ref = providedUriPattern_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            providedUriPattern_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * User provided URI pattern. For example, `foo.com/bar/&#42;`.
         * </pre>
         *
         * <code>string provided_uri_pattern = 1;</code>
         *
         * @return The bytes for providedUriPattern.
         */
        public com.google.protobuf.ByteString getProvidedUriPatternBytes() {
          java.lang.Object ref = providedUriPattern_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            providedUriPattern_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * User provided URI pattern. For example, `foo.com/bar/&#42;`.
         * </pre>
         *
         * <code>string provided_uri_pattern = 1;</code>
         *
         * @param value The providedUriPattern to set.
         * @return This builder for chaining.
         */
        public Builder setProvidedUriPattern(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          providedUriPattern_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * User provided URI pattern. For example, `foo.com/bar/&#42;`.
         * </pre>
         *
         * <code>string provided_uri_pattern = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearProvidedUriPattern() {
          providedUriPattern_ = getDefaultInstance().getProvidedUriPattern();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * User provided URI pattern. For example, `foo.com/bar/&#42;`.
         * </pre>
         *
         * <code>string provided_uri_pattern = 1;</code>
         *
         * @param value The bytes for providedUriPattern to set.
         * @return This builder for chaining.
         */
        public Builder setProvidedUriPatternBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          providedUriPattern_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private boolean exactMatch_;
        /**
         *
         *
         * <pre>
         * Whether we infer the generated URI or use the exact provided one.
         * </pre>
         *
         * <code>bool exact_match = 2;</code>
         *
         * @return The exactMatch.
         */
        @java.lang.Override
        public boolean getExactMatch() {
          return exactMatch_;
        }
        /**
         *
         *
         * <pre>
         * Whether we infer the generated URI or use the exact provided one.
         * </pre>
         *
         * <code>bool exact_match = 2;</code>
         *
         * @param value The exactMatch to set.
         * @return This builder for chaining.
         */
        public Builder setExactMatch(boolean value) {

          exactMatch_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Whether we infer the generated URI or use the exact provided one.
         * </pre>
         *
         * <code>bool exact_match = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearExactMatch() {
          bitField0_ = (bitField0_ & ~0x00000002);
          exactMatch_ = false;
          onChanged();
          return this;
        }

        private boolean exclusive_;
        /**
         *
         *
         * <pre>
         * Whether the pattern is exclusive or not. If set to true, the pattern is
         * considered exclusive. If unset or set to false, the pattern is
         * considered inclusive by default.
         * </pre>
         *
         * <code>bool exclusive = 3;</code>
         *
         * @return The exclusive.
         */
        @java.lang.Override
        public boolean getExclusive() {
          return exclusive_;
        }
        /**
         *
         *
         * <pre>
         * Whether the pattern is exclusive or not. If set to true, the pattern is
         * considered exclusive. If unset or set to false, the pattern is
         * considered inclusive by default.
         * </pre>
         *
         * <code>bool exclusive = 3;</code>
         *
         * @param value The exclusive to set.
         * @return This builder for chaining.
         */
        public Builder setExclusive(boolean value) {

          exclusive_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Whether the pattern is exclusive or not. If set to true, the pattern is
         * considered exclusive. If unset or set to false, the pattern is
         * considered inclusive by default.
         * </pre>
         *
         * <code>bool exclusive = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearExclusive() {
          bitField0_ = (bitField0_ & ~0x00000004);
          exclusive_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern)
      private static final com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                .EstimatorUriPattern();
      }

      public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
              .WebsiteDataSource.EstimatorUriPattern
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<EstimatorUriPattern> PARSER =
          new com.google.protobuf.AbstractParser<EstimatorUriPattern>() {
            @java.lang.Override
            public EstimatorUriPattern parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<EstimatorUriPattern> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<EstimatorUriPattern> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
              .EstimatorUriPattern
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int ESTIMATOR_URI_PATTERNS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                .EstimatorUriPattern>
        estimatorUriPatterns_;
    /**
     *
     *
     * <pre>
     * Required. The URI patterns to estimate the data sizes. At most 10
     * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                .EstimatorUriPattern>
        getEstimatorUriPatternsList() {
      return estimatorUriPatterns_;
    }
    /**
     *
     *
     * <pre>
     * Required. The URI patterns to estimate the data sizes. At most 10
     * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                    .EstimatorUriPatternOrBuilder>
        getEstimatorUriPatternsOrBuilderList() {
      return estimatorUriPatterns_;
    }
    /**
     *
     *
     * <pre>
     * Required. The URI patterns to estimate the data sizes. At most 10
     * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getEstimatorUriPatternsCount() {
      return estimatorUriPatterns_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The URI patterns to estimate the data sizes. At most 10
     * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
            .EstimatorUriPattern
        getEstimatorUriPatterns(int index) {
      return estimatorUriPatterns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The URI patterns to estimate the data sizes. At most 10
     * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
            .EstimatorUriPatternOrBuilder
        getEstimatorUriPatternsOrBuilder(int index) {
      return estimatorUriPatterns_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < estimatorUriPatterns_.size(); i++) {
        output.writeMessage(1, estimatorUriPatterns_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < estimatorUriPatterns_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, estimatorUriPatterns_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource other =
          (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource) obj;

      if (!getEstimatorUriPatternsList().equals(other.getEstimatorUriPatternsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getEstimatorUriPatternsCount() > 0) {
        hash = (37 * hash) + ESTIMATOR_URI_PATTERNS_FIELD_NUMBER;
        hash = (53 * hash) + getEstimatorUriPatternsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Data source is a set of website patterns that we crawl to get
     * the total number of websites.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource)
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
            .WebsiteDataSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_WebsiteDataSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_WebsiteDataSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                    .class,
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (estimatorUriPatternsBuilder_ == null) {
          estimatorUriPatterns_ = java.util.Collections.emptyList();
        } else {
          estimatorUriPatterns_ = null;
          estimatorUriPatternsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_WebsiteDataSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
          build() {
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
          buildPartial() {
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource result =
            new com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
              result) {
        if (estimatorUriPatternsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            estimatorUriPatterns_ = java.util.Collections.unmodifiableList(estimatorUriPatterns_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.estimatorUriPatterns_ = estimatorUriPatterns_;
        } else {
          result.estimatorUriPatterns_ = estimatorUriPatternsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
              result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
              other) {
        if (other
            == com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                .getDefaultInstance()) return this;
        if (estimatorUriPatternsBuilder_ == null) {
          if (!other.estimatorUriPatterns_.isEmpty()) {
            if (estimatorUriPatterns_.isEmpty()) {
              estimatorUriPatterns_ = other.estimatorUriPatterns_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureEstimatorUriPatternsIsMutable();
              estimatorUriPatterns_.addAll(other.estimatorUriPatterns_);
            }
            onChanged();
          }
        } else {
          if (!other.estimatorUriPatterns_.isEmpty()) {
            if (estimatorUriPatternsBuilder_.isEmpty()) {
              estimatorUriPatternsBuilder_.dispose();
              estimatorUriPatternsBuilder_ = null;
              estimatorUriPatterns_ = other.estimatorUriPatterns_;
              bitField0_ = (bitField0_ & ~0x00000001);
              estimatorUriPatternsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getEstimatorUriPatternsFieldBuilder()
                      : null;
            } else {
              estimatorUriPatternsBuilder_.addAllMessages(other.estimatorUriPatterns_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                          .EstimatorUriPattern
                      m =
                          input.readMessage(
                              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                                  .WebsiteDataSource.EstimatorUriPattern.parser(),
                              extensionRegistry);
                  if (estimatorUriPatternsBuilder_ == null) {
                    ensureEstimatorUriPatternsIsMutable();
                    estimatorUriPatterns_.add(m);
                  } else {
                    estimatorUriPatternsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern>
          estimatorUriPatterns_ = java.util.Collections.emptyList();

      private void ensureEstimatorUriPatternsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          estimatorUriPatterns_ =
              new java.util.ArrayList<
                  com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                      .EstimatorUriPattern>(estimatorUriPatterns_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern,
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern.Builder,
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPatternOrBuilder>
          estimatorUriPatternsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern>
          getEstimatorUriPatternsList() {
        if (estimatorUriPatternsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(estimatorUriPatterns_);
        } else {
          return estimatorUriPatternsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getEstimatorUriPatternsCount() {
        if (estimatorUriPatternsBuilder_ == null) {
          return estimatorUriPatterns_.size();
        } else {
          return estimatorUriPatternsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
              .EstimatorUriPattern
          getEstimatorUriPatterns(int index) {
        if (estimatorUriPatternsBuilder_ == null) {
          return estimatorUriPatterns_.get(index);
        } else {
          return estimatorUriPatternsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setEstimatorUriPatterns(
          int index,
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern
              value) {
        if (estimatorUriPatternsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEstimatorUriPatternsIsMutable();
          estimatorUriPatterns_.set(index, value);
          onChanged();
        } else {
          estimatorUriPatternsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setEstimatorUriPatterns(
          int index,
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern.Builder
              builderForValue) {
        if (estimatorUriPatternsBuilder_ == null) {
          ensureEstimatorUriPatternsIsMutable();
          estimatorUriPatterns_.set(index, builderForValue.build());
          onChanged();
        } else {
          estimatorUriPatternsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addEstimatorUriPatterns(
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern
              value) {
        if (estimatorUriPatternsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEstimatorUriPatternsIsMutable();
          estimatorUriPatterns_.add(value);
          onChanged();
        } else {
          estimatorUriPatternsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addEstimatorUriPatterns(
          int index,
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern
              value) {
        if (estimatorUriPatternsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEstimatorUriPatternsIsMutable();
          estimatorUriPatterns_.add(index, value);
          onChanged();
        } else {
          estimatorUriPatternsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addEstimatorUriPatterns(
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern.Builder
              builderForValue) {
        if (estimatorUriPatternsBuilder_ == null) {
          ensureEstimatorUriPatternsIsMutable();
          estimatorUriPatterns_.add(builderForValue.build());
          onChanged();
        } else {
          estimatorUriPatternsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addEstimatorUriPatterns(
          int index,
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern.Builder
              builderForValue) {
        if (estimatorUriPatternsBuilder_ == null) {
          ensureEstimatorUriPatternsIsMutable();
          estimatorUriPatterns_.add(index, builderForValue.build());
          onChanged();
        } else {
          estimatorUriPatternsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllEstimatorUriPatterns(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                          .WebsiteDataSource.EstimatorUriPattern>
              values) {
        if (estimatorUriPatternsBuilder_ == null) {
          ensureEstimatorUriPatternsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, estimatorUriPatterns_);
          onChanged();
        } else {
          estimatorUriPatternsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearEstimatorUriPatterns() {
        if (estimatorUriPatternsBuilder_ == null) {
          estimatorUriPatterns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          estimatorUriPatternsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeEstimatorUriPatterns(int index) {
        if (estimatorUriPatternsBuilder_ == null) {
          ensureEstimatorUriPatternsIsMutable();
          estimatorUriPatterns_.remove(index);
          onChanged();
        } else {
          estimatorUriPatternsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
              .EstimatorUriPattern.Builder
          getEstimatorUriPatternsBuilder(int index) {
        return getEstimatorUriPatternsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
              .EstimatorUriPatternOrBuilder
          getEstimatorUriPatternsOrBuilder(int index) {
        if (estimatorUriPatternsBuilder_ == null) {
          return estimatorUriPatterns_.get(index);
        } else {
          return estimatorUriPatternsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                      .EstimatorUriPatternOrBuilder>
          getEstimatorUriPatternsOrBuilderList() {
        if (estimatorUriPatternsBuilder_ != null) {
          return estimatorUriPatternsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(estimatorUriPatterns_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
              .EstimatorUriPattern.Builder
          addEstimatorUriPatternsBuilder() {
        return getEstimatorUriPatternsFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                    .EstimatorUriPattern.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
              .EstimatorUriPattern.Builder
          addEstimatorUriPatternsBuilder(int index) {
        return getEstimatorUriPatternsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                    .EstimatorUriPattern.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. The URI patterns to estimate the data sizes. At most 10
       * patterns are allowed, otherwise an INVALID_ARGUMENT error is thrown.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.EstimatorUriPattern estimator_uri_patterns = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern.Builder>
          getEstimatorUriPatternsBuilderList() {
        return getEstimatorUriPatternsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern,
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPattern.Builder,
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .EstimatorUriPatternOrBuilder>
          getEstimatorUriPatternsFieldBuilder() {
        if (estimatorUriPatternsBuilder_ == null) {
          estimatorUriPatternsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                      .EstimatorUriPattern,
                  com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                      .EstimatorUriPattern.Builder,
                  com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                      .EstimatorUriPatternOrBuilder>(
                  estimatorUriPatterns_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          estimatorUriPatterns_ = null;
        }
        return estimatorUriPatternsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource)
    private static final com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
            .WebsiteDataSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource();
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WebsiteDataSource> PARSER =
        new com.google.protobuf.AbstractParser<WebsiteDataSource>() {
          @java.lang.Override
          public WebsiteDataSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WebsiteDataSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WebsiteDataSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FileDataSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    boolean hasGcsSource();
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
     *
     * @return The gcsSource.
     */
    com.google.cloud.discoveryengine.v1alpha.GcsSource getGcsSource();
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
     */
    com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder getGcsSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    boolean hasBigquerySource();
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
     *
     * @return The bigquerySource.
     */
    com.google.cloud.discoveryengine.v1alpha.BigQuerySource getBigquerySource();
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
     */
    com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder getBigquerySourceOrBuilder();

    com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource.SourceCase
        getSourceCase();
  }
  /**
   *
   *
   * <pre>
   * Data source contains files either in Cloud Storage or BigQuery.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource}
   */
  public static final class FileDataSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
      FileDataSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FileDataSource.newBuilder() to construct.
    private FileDataSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FileDataSource() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FileDataSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_FileDataSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_FileDataSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource.class,
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
                  .Builder.class);
    }

    private int sourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object source_;

    public enum SourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_SOURCE(1),
      BIGQUERY_SOURCE(2),
      SOURCE_NOT_SET(0);
      private final int value;

      private SourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return GCS_SOURCE;
          case 2:
            return BIGQUERY_SOURCE;
          case 0:
            return SOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public static final int GCS_SOURCE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.GcsSource getGcsSource() {
      if (sourceCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_;
      }
      return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if (sourceCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_;
      }
      return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
    }

    public static final int BIGQUERY_SOURCE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigquerySource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
     *
     * @return The bigquerySource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BigQuerySource getBigquerySource() {
      if (sourceCase_ == 2) {
        return (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_;
      }
      return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder
        getBigquerySourceOrBuilder() {
      if (sourceCase_ == 2) {
        return (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_;
      }
      return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (sourceCase_ == 1) {
        output.writeMessage(1, (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_);
      }
      if (sourceCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (sourceCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_);
      }
      if (sourceCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource other =
          (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource) obj;

      if (!getSourceCase().equals(other.getSourceCase())) return false;
      switch (sourceCase_) {
        case 1:
          if (!getGcsSource().equals(other.getGcsSource())) return false;
          break;
        case 2:
          if (!getBigquerySource().equals(other.getBigquerySource())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (sourceCase_) {
        case 1:
          hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getGcsSource().hashCode();
          break;
        case 2:
          hash = (37 * hash) + BIGQUERY_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getBigquerySource().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Data source contains files either in Cloud Storage or BigQuery.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_FileDataSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_FileDataSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
                    .class,
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (gcsSourceBuilder_ != null) {
          gcsSourceBuilder_.clear();
        }
        if (bigquerySourceBuilder_ != null) {
          bigquerySourceBuilder_.clear();
        }
        sourceCase_ = 0;
        source_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_FileDataSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
          build() {
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
          buildPartial() {
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource result =
            new com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource result) {
        result.sourceCase_ = sourceCase_;
        result.source_ = this.source_;
        if (sourceCase_ == 1 && gcsSourceBuilder_ != null) {
          result.source_ = gcsSourceBuilder_.build();
        }
        if (sourceCase_ == 2 && bigquerySourceBuilder_ != null) {
          result.source_ = bigquerySourceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource other) {
        if (other
            == com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
                .getDefaultInstance()) return this;
        switch (other.getSourceCase()) {
          case GCS_SOURCE:
            {
              mergeGcsSource(other.getGcsSource());
              break;
            }
          case BIGQUERY_SOURCE:
            {
              mergeBigquerySource(other.getBigquerySource());
              break;
            }
          case SOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getBigquerySourceFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int sourceCase_ = 0;
      private java.lang.Object source_;

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public Builder clearSource() {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.GcsSource,
              com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder,
              com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder>
          gcsSourceBuilder_;
      /**
       *
       *
       * <pre>
       * Cloud Storage location for the input content.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
       *
       * @return Whether the gcsSource field is set.
       */
      @java.lang.Override
      public boolean hasGcsSource() {
        return sourceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage location for the input content.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
       *
       * @return The gcsSource.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.GcsSource getGcsSource() {
        if (gcsSourceBuilder_ == null) {
          if (sourceCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_;
          }
          return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
        } else {
          if (sourceCase_ == 1) {
            return gcsSourceBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage location for the input content.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
       */
      public Builder setGcsSource(com.google.cloud.discoveryengine.v1alpha.GcsSource value) {
        if (gcsSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
        sourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage location for the input content.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
       */
      public Builder setGcsSource(
          com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder builderForValue) {
        if (gcsSourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          gcsSourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage location for the input content.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
       */
      public Builder mergeGcsSource(com.google.cloud.discoveryengine.v1alpha.GcsSource value) {
        if (gcsSourceBuilder_ == null) {
          if (sourceCase_ == 1
              && source_
                  != com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance()) {
            source_ =
                com.google.cloud.discoveryengine.v1alpha.GcsSource.newBuilder(
                        (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 1) {
            gcsSourceBuilder_.mergeFrom(value);
          } else {
            gcsSourceBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage location for the input content.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
       */
      public Builder clearGcsSource() {
        if (gcsSourceBuilder_ == null) {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
          }
          gcsSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage location for the input content.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
       */
      public com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder getGcsSourceBuilder() {
        return getGcsSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage location for the input content.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder getGcsSourceOrBuilder() {
        if ((sourceCase_ == 1) && (gcsSourceBuilder_ != null)) {
          return gcsSourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_;
          }
          return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage location for the input content.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.GcsSource,
              com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder,
              com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder>
          getGcsSourceFieldBuilder() {
        if (gcsSourceBuilder_ == null) {
          if (!(sourceCase_ == 1)) {
            source_ = com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
          }
          gcsSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1alpha.GcsSource,
                  com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder,
                  com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder>(
                  (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 1;
        onChanged();
        return gcsSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.BigQuerySource,
              com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder,
              com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder>
          bigquerySourceBuilder_;
      /**
       *
       *
       * <pre>
       * BigQuery input source.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
       *
       * @return Whether the bigquerySource field is set.
       */
      @java.lang.Override
      public boolean hasBigquerySource() {
        return sourceCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * BigQuery input source.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
       *
       * @return The bigquerySource.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.BigQuerySource getBigquerySource() {
        if (bigquerySourceBuilder_ == null) {
          if (sourceCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_;
          }
          return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
        } else {
          if (sourceCase_ == 2) {
            return bigquerySourceBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * BigQuery input source.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
       */
      public Builder setBigquerySource(
          com.google.cloud.discoveryengine.v1alpha.BigQuerySource value) {
        if (bigquerySourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          bigquerySourceBuilder_.setMessage(value);
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * BigQuery input source.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
       */
      public Builder setBigquerySource(
          com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder builderForValue) {
        if (bigquerySourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          bigquerySourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * BigQuery input source.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
       */
      public Builder mergeBigquerySource(
          com.google.cloud.discoveryengine.v1alpha.BigQuerySource value) {
        if (bigquerySourceBuilder_ == null) {
          if (sourceCase_ == 2
              && source_
                  != com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance()) {
            source_ =
                com.google.cloud.discoveryengine.v1alpha.BigQuerySource.newBuilder(
                        (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 2) {
            bigquerySourceBuilder_.mergeFrom(value);
          } else {
            bigquerySourceBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * BigQuery input source.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
       */
      public Builder clearBigquerySource() {
        if (bigquerySourceBuilder_ == null) {
          if (sourceCase_ == 2) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 2) {
            sourceCase_ = 0;
            source_ = null;
          }
          bigquerySourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * BigQuery input source.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder
          getBigquerySourceBuilder() {
        return getBigquerySourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * BigQuery input source.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder
          getBigquerySourceOrBuilder() {
        if ((sourceCase_ == 2) && (bigquerySourceBuilder_ != null)) {
          return bigquerySourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_;
          }
          return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * BigQuery input source.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.BigQuerySource,
              com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder,
              com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder>
          getBigquerySourceFieldBuilder() {
        if (bigquerySourceBuilder_ == null) {
          if (!(sourceCase_ == 2)) {
            source_ = com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
          }
          bigquerySourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1alpha.BigQuerySource,
                  com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder,
                  com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder>(
                  (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 2;
        onChanged();
        return bigquerySourceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
    private static final com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
            .FileDataSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource();
    }

    public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FileDataSource> PARSER =
        new com.google.protobuf.AbstractParser<FileDataSource>() {
          @java.lang.Override
          public FileDataSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FileDataSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FileDataSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int dataSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object dataSource_;

  public enum DataSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    WEBSITE_DATA_SOURCE(2),
    FILE_DATA_SOURCE(3),
    DATASOURCE_NOT_SET(0);
    private final int value;

    private DataSourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataSourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return WEBSITE_DATA_SOURCE;
        case 3:
          return FILE_DATA_SOURCE;
        case 0:
          return DATASOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataSourceCase getDataSourceCase() {
    return DataSourceCase.forNumber(dataSourceCase_);
  }

  public static final int WEBSITE_DATA_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Website data.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource website_data_source = 2;
   * </code>
   *
   * @return Whether the websiteDataSource field is set.
   */
  @java.lang.Override
  public boolean hasWebsiteDataSource() {
    return dataSourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Website data.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource website_data_source = 2;
   * </code>
   *
   * @return The websiteDataSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
      getWebsiteDataSource() {
    if (dataSourceCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource)
          dataSource_;
    }
    return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Website data.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource website_data_source = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSourceOrBuilder
      getWebsiteDataSourceOrBuilder() {
    if (dataSourceCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource)
          dataSource_;
    }
    return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        .getDefaultInstance();
  }

  public static final int FILE_DATA_SOURCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Structured or unstructured data.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource file_data_source = 3;
   * </code>
   *
   * @return Whether the fileDataSource field is set.
   */
  @java.lang.Override
  public boolean hasFileDataSource() {
    return dataSourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Structured or unstructured data.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource file_data_source = 3;
   * </code>
   *
   * @return The fileDataSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
      getFileDataSource() {
    if (dataSourceCase_ == 3) {
      return (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
          dataSource_;
    }
    return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Structured or unstructured data.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource file_data_source = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSourceOrBuilder
      getFileDataSourceOrBuilder() {
    if (dataSourceCase_ == 3) {
      return (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
          dataSource_;
    }
    return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        .getDefaultInstance();
  }

  public static final int LOCATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * Required. Full resource name of the location, such as
   * `projects/{project}/locations/{location}`.
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Full resource name of the location, such as
   * `projects/{project}/locations/{location}`.
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
    }
    if (dataSourceCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource)
              dataSource_);
    }
    if (dataSourceCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
              dataSource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
    }
    if (dataSourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource)
                  dataSource_);
    }
    if (dataSourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
                  dataSource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest other =
        (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest) obj;

    if (!getLocation().equals(other.getLocation())) return false;
    if (!getDataSourceCase().equals(other.getDataSourceCase())) return false;
    switch (dataSourceCase_) {
      case 2:
        if (!getWebsiteDataSource().equals(other.getWebsiteDataSource())) return false;
        break;
      case 3:
        if (!getFileDataSource().equals(other.getFileDataSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    switch (dataSourceCase_) {
      case 2:
        hash = (37 * hash) + WEBSITE_DATA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getWebsiteDataSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + FILE_DATA_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getFileDataSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [EstimateBillingService.EstimateDataSize][google.cloud.discoveryengine.v1alpha.EstimateBillingService.EstimateDataSize]
   * method
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest)
      com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.class,
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (websiteDataSourceBuilder_ != null) {
        websiteDataSourceBuilder_.clear();
      }
      if (fileDataSourceBuilder_ != null) {
        fileDataSourceBuilder_.clear();
      }
      location_ = "";
      dataSourceCase_ = 0;
      dataSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1alpha.EstimateBillingServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_EstimateDataSizeRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest build() {
      com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest buildPartial() {
      com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest result =
          new com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.location_ = location_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest result) {
      result.dataSourceCase_ = dataSourceCase_;
      result.dataSource_ = this.dataSource_;
      if (dataSourceCase_ == 2 && websiteDataSourceBuilder_ != null) {
        result.dataSource_ = websiteDataSourceBuilder_.build();
      }
      if (dataSourceCase_ == 3 && fileDataSourceBuilder_ != null) {
        result.dataSource_ = fileDataSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.getDefaultInstance())
        return this;
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getDataSourceCase()) {
        case WEBSITE_DATA_SOURCE:
          {
            mergeWebsiteDataSource(other.getWebsiteDataSource());
            break;
          }
        case FILE_DATA_SOURCE:
          {
            mergeFileDataSource(other.getFileDataSource());
            break;
          }
        case DATASOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getWebsiteDataSourceFieldBuilder().getBuilder(), extensionRegistry);
                dataSourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getFileDataSourceFieldBuilder().getBuilder(), extensionRegistry);
                dataSourceCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataSourceCase_ = 0;
    private java.lang.Object dataSource_;

    public DataSourceCase getDataSourceCase() {
      return DataSourceCase.forNumber(dataSourceCase_);
    }

    public Builder clearDataSource() {
      dataSourceCase_ = 0;
      dataSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource,
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                .Builder,
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                .WebsiteDataSourceOrBuilder>
        websiteDataSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Website data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource website_data_source = 2;
     * </code>
     *
     * @return Whether the websiteDataSource field is set.
     */
    @java.lang.Override
    public boolean hasWebsiteDataSource() {
      return dataSourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Website data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource website_data_source = 2;
     * </code>
     *
     * @return The websiteDataSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
        getWebsiteDataSource() {
      if (websiteDataSourceBuilder_ == null) {
        if (dataSourceCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                  .WebsiteDataSource)
              dataSource_;
        }
        return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
            .getDefaultInstance();
      } else {
        if (dataSourceCase_ == 2) {
          return websiteDataSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Website data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource website_data_source = 2;
     * </code>
     */
    public Builder setWebsiteDataSource(
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource value) {
      if (websiteDataSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataSource_ = value;
        onChanged();
      } else {
        websiteDataSourceBuilder_.setMessage(value);
      }
      dataSourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Website data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource website_data_source = 2;
     * </code>
     */
    public Builder setWebsiteDataSource(
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource.Builder
            builderForValue) {
      if (websiteDataSourceBuilder_ == null) {
        dataSource_ = builderForValue.build();
        onChanged();
      } else {
        websiteDataSourceBuilder_.setMessage(builderForValue.build());
      }
      dataSourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Website data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource website_data_source = 2;
     * </code>
     */
    public Builder mergeWebsiteDataSource(
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource value) {
      if (websiteDataSourceBuilder_ == null) {
        if (dataSourceCase_ == 2
            && dataSource_
                != com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                    .WebsiteDataSource.getDefaultInstance()) {
          dataSource_ =
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                              .WebsiteDataSource)
                          dataSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataSource_ = value;
        }
        onChanged();
      } else {
        if (dataSourceCase_ == 2) {
          websiteDataSourceBuilder_.mergeFrom(value);
        } else {
          websiteDataSourceBuilder_.setMessage(value);
        }
      }
      dataSourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Website data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource website_data_source = 2;
     * </code>
     */
    public Builder clearWebsiteDataSource() {
      if (websiteDataSourceBuilder_ == null) {
        if (dataSourceCase_ == 2) {
          dataSourceCase_ = 0;
          dataSource_ = null;
          onChanged();
        }
      } else {
        if (dataSourceCase_ == 2) {
          dataSourceCase_ = 0;
          dataSource_ = null;
        }
        websiteDataSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Website data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource website_data_source = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
            .Builder
        getWebsiteDataSourceBuilder() {
      return getWebsiteDataSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Website data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource website_data_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
            .WebsiteDataSourceOrBuilder
        getWebsiteDataSourceOrBuilder() {
      if ((dataSourceCase_ == 2) && (websiteDataSourceBuilder_ != null)) {
        return websiteDataSourceBuilder_.getMessageOrBuilder();
      } else {
        if (dataSourceCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                  .WebsiteDataSource)
              dataSource_;
        }
        return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Website data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource website_data_source = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource,
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                .Builder,
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                .WebsiteDataSourceOrBuilder>
        getWebsiteDataSourceFieldBuilder() {
      if (websiteDataSourceBuilder_ == null) {
        if (!(dataSourceCase_ == 2)) {
          dataSource_ =
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                  .getDefaultInstance();
        }
        websiteDataSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource,
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource
                    .Builder,
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                    .WebsiteDataSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.WebsiteDataSource)
                    dataSource_,
                getParentForChildren(),
                isClean());
        dataSource_ = null;
      }
      dataSourceCase_ = 2;
      onChanged();
      return websiteDataSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource,
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                .FileDataSourceOrBuilder>
        fileDataSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Structured or unstructured data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource file_data_source = 3;
     * </code>
     *
     * @return Whether the fileDataSource field is set.
     */
    @java.lang.Override
    public boolean hasFileDataSource() {
      return dataSourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Structured or unstructured data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource file_data_source = 3;
     * </code>
     *
     * @return The fileDataSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
        getFileDataSource() {
      if (fileDataSourceBuilder_ == null) {
        if (dataSourceCase_ == 3) {
          return (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
              dataSource_;
        }
        return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
            .getDefaultInstance();
      } else {
        if (dataSourceCase_ == 3) {
          return fileDataSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Structured or unstructured data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource file_data_source = 3;
     * </code>
     */
    public Builder setFileDataSource(
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource value) {
      if (fileDataSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataSource_ = value;
        onChanged();
      } else {
        fileDataSourceBuilder_.setMessage(value);
      }
      dataSourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Structured or unstructured data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource file_data_source = 3;
     * </code>
     */
    public Builder setFileDataSource(
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource.Builder
            builderForValue) {
      if (fileDataSourceBuilder_ == null) {
        dataSource_ = builderForValue.build();
        onChanged();
      } else {
        fileDataSourceBuilder_.setMessage(builderForValue.build());
      }
      dataSourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Structured or unstructured data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource file_data_source = 3;
     * </code>
     */
    public Builder mergeFileDataSource(
        com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource value) {
      if (fileDataSourceBuilder_ == null) {
        if (dataSourceCase_ == 3
            && dataSource_
                != com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
                    .getDefaultInstance()) {
          dataSource_ =
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
                  .newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                              .FileDataSource)
                          dataSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataSource_ = value;
        }
        onChanged();
      } else {
        if (dataSourceCase_ == 3) {
          fileDataSourceBuilder_.mergeFrom(value);
        } else {
          fileDataSourceBuilder_.setMessage(value);
        }
      }
      dataSourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Structured or unstructured data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource file_data_source = 3;
     * </code>
     */
    public Builder clearFileDataSource() {
      if (fileDataSourceBuilder_ == null) {
        if (dataSourceCase_ == 3) {
          dataSourceCase_ = 0;
          dataSource_ = null;
          onChanged();
        }
      } else {
        if (dataSourceCase_ == 3) {
          dataSourceCase_ = 0;
          dataSource_ = null;
        }
        fileDataSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Structured or unstructured data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource file_data_source = 3;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource.Builder
        getFileDataSourceBuilder() {
      return getFileDataSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Structured or unstructured data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource file_data_source = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSourceOrBuilder
        getFileDataSourceOrBuilder() {
      if ((dataSourceCase_ == 3) && (fileDataSourceBuilder_ != null)) {
        return fileDataSourceBuilder_.getMessageOrBuilder();
      } else {
        if (dataSourceCase_ == 3) {
          return (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
              dataSource_;
        }
        return com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Structured or unstructured data.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource file_data_source = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource,
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                .FileDataSourceOrBuilder>
        getFileDataSourceFieldBuilder() {
      if (fileDataSourceBuilder_ == null) {
        if (!(dataSourceCase_ == 3)) {
          dataSource_ =
              com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
                  .getDefaultInstance();
        }
        fileDataSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource,
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource
                    .Builder,
                com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
                    .FileDataSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest.FileDataSource)
                    dataSource_,
                getParentForChildren(),
                isClean());
        dataSource_ = null;
      }
      dataSourceCase_ = 3;
      onChanged();
      return fileDataSourceBuilder_;
    }

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the location, such as
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the location, such as
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the location, such as
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the location, such as
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the location, such as
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest)
  private static final com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest();
  }

  public static com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EstimateDataSizeRequest> PARSER =
      new com.google.protobuf.AbstractParser<EstimateDataSizeRequest>() {
        @java.lang.Override
        public EstimateDataSizeRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EstimateDataSizeRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EstimateDataSizeRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.EstimateDataSizeRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
