/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SipTrunkName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SIPTRUNK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sipTrunks/{siptrunk}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String siptrunk;

    @Deprecated
    protected SipTrunkName() {
        this.project = null;
        this.location = null;
        this.siptrunk = null;
    }

    private SipTrunkName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.siptrunk = (String)Preconditions.checkNotNull((Object)builder.getSiptrunk());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSiptrunk() {
        return this.siptrunk;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SipTrunkName of(String project, String location, String siptrunk) {
        return SipTrunkName.newBuilder().setProject(project).setLocation(location).setSiptrunk(siptrunk).build();
    }

    public static String format(String project, String location, String siptrunk) {
        return SipTrunkName.newBuilder().setProject(project).setLocation(location).setSiptrunk(siptrunk).build().toString();
    }

    public static SipTrunkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SIPTRUNK.validatedMatch(formattedString, "SipTrunkName.parse: formattedString not in valid format");
        return SipTrunkName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("siptrunk"));
    }

    public static List<SipTrunkName> parseList(List<String> formattedStrings) {
        ArrayList<SipTrunkName> list = new ArrayList<SipTrunkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SipTrunkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SipTrunkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SipTrunkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SIPTRUNK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SipTrunkName sipTrunkName = this;
            synchronized (sipTrunkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.siptrunk != null) {
                        fieldMapBuilder.put((Object)"siptrunk", (Object)this.siptrunk);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SIPTRUNK.instantiate(new String[]{"project", this.project, "location", this.location, "siptrunk", this.siptrunk});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SipTrunkName that = (SipTrunkName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.siptrunk, that.siptrunk);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.siptrunk);
    }

    public static class Builder {
        private String project;
        private String location;
        private String siptrunk;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSiptrunk() {
            return this.siptrunk;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSiptrunk(String siptrunk) {
            this.siptrunk = siptrunk;
            return this;
        }

        private Builder(SipTrunkName sipTrunkName) {
            this.project = sipTrunkName.project;
            this.location = sipTrunkName.location;
            this.siptrunk = sipTrunkName.siptrunk;
        }

        public SipTrunkName build() {
            return new SipTrunkName(this);
        }
    }
}

