/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ContextName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/sessions/{session}/contexts/{context}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String session;
    private final String context;

    public String getProject() {
        return this.project;
    }

    public String getSession() {
        return this.session;
    }

    public String getContext() {
        return this.context;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ContextName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.context = (String)Preconditions.checkNotNull((Object)builder.getContext());
    }

    public static ContextName of(String project, String session, String context) {
        return ContextName.newBuilder().setProject(project).setSession(session).setContext(context).build();
    }

    public static String format(String project, String session, String context) {
        return ContextName.newBuilder().setProject(project).setSession(session).setContext(context).build().toString();
    }

    public static ContextName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ContextName.parse: formattedString not in valid format");
        return ContextName.of((String)matchMap.get("project"), (String)matchMap.get("session"), (String)matchMap.get("context"));
    }

    public static List<ContextName> parseList(List<String> formattedStrings) {
        ArrayList<ContextName> list = new ArrayList<ContextName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ContextName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ContextName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ContextName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ContextName contextName = this;
            synchronized (contextName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"session", (Object)this.session);
                    fieldMapBuilder.put((Object)"context", (Object)this.context);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("ContextName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "session", this.session, "context", this.context});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ContextName) {
            ContextName that = (ContextName)o;
            return this.project.equals(that.project) && this.session.equals(that.session) && this.context.equals(that.context);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.session.hashCode();
        h *= 1000003;
        return h ^= this.context.hashCode();
    }

    public static class Builder {
        private String project;
        private String session;
        private String context;

        public String getProject() {
            return this.project;
        }

        public String getSession() {
            return this.session;
        }

        public String getContext() {
            return this.context;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        public Builder setContext(String context) {
            this.context = context;
            return this;
        }

        private Builder() {
        }

        private Builder(ContextName contextName) {
            this.project = contextName.project;
            this.session = contextName.session;
            this.context = contextName.context;
        }

        public ContextName build() {
            return new ContextName(this);
        }
    }
}

