/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ContinuousTestResultName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_ENVIRONMENT_CONTINUOUS_TEST_RESULT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/environments/{environment}/continuousTestResults/{continuous_test_result}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String environment;
    private final String continuousTestResult;

    @Deprecated
    protected ContinuousTestResultName() {
        this.project = null;
        this.location = null;
        this.agent = null;
        this.environment = null;
        this.continuousTestResult = null;
    }

    private ContinuousTestResultName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.continuousTestResult = (String)Preconditions.checkNotNull((Object)builder.getContinuousTestResult());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getContinuousTestResult() {
        return this.continuousTestResult;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ContinuousTestResultName of(String project, String location, String agent, String environment, String continuousTestResult) {
        return ContinuousTestResultName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setEnvironment(environment).setContinuousTestResult(continuousTestResult).build();
    }

    public static String format(String project, String location, String agent, String environment, String continuousTestResult) {
        return ContinuousTestResultName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setEnvironment(environment).setContinuousTestResult(continuousTestResult).build().toString();
    }

    public static ContinuousTestResultName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT_ENVIRONMENT_CONTINUOUS_TEST_RESULT.validatedMatch(formattedString, "ContinuousTestResultName.parse: formattedString not in valid format");
        return ContinuousTestResultName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("environment"), (String)matchMap.get("continuous_test_result"));
    }

    public static List<ContinuousTestResultName> parseList(List<String> formattedStrings) {
        ArrayList<ContinuousTestResultName> list = new ArrayList<ContinuousTestResultName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ContinuousTestResultName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ContinuousTestResultName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ContinuousTestResultName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_ENVIRONMENT_CONTINUOUS_TEST_RESULT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ContinuousTestResultName continuousTestResultName = this;
            synchronized (continuousTestResultName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    if (this.continuousTestResult != null) {
                        fieldMapBuilder.put((Object)"continuous_test_result", (Object)this.continuousTestResult);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT_ENVIRONMENT_CONTINUOUS_TEST_RESULT.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "environment", this.environment, "continuous_test_result", this.continuousTestResult});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ContinuousTestResultName that = (ContinuousTestResultName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.environment, that.environment) && Objects.equals(this.continuousTestResult, that.continuousTestResult);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        h ^= Objects.hashCode(this.environment);
        h *= 1000003;
        return h ^= Objects.hashCode(this.continuousTestResult);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String environment;
        private String continuousTestResult;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getContinuousTestResult() {
            return this.continuousTestResult;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder setContinuousTestResult(String continuousTestResult) {
            this.continuousTestResult = continuousTestResult;
            return this;
        }

        private Builder(ContinuousTestResultName continuousTestResultName) {
            this.project = continuousTestResultName.project;
            this.location = continuousTestResultName.location;
            this.agent = continuousTestResultName.agent;
            this.environment = continuousTestResultName.environment;
            this.continuousTestResult = continuousTestResultName.continuousTestResult;
        }

        public ContinuousTestResultName build() {
            return new ContinuousTestResultName(this);
        }
    }
}

