/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExampleName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_PLAYBOOK_EXAMPLE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/playbooks/{playbook}/examples/{example}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String playbook;
    private final String example;

    @Deprecated
    protected ExampleName() {
        this.project = null;
        this.location = null;
        this.agent = null;
        this.playbook = null;
        this.example = null;
    }

    private ExampleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.playbook = (String)Preconditions.checkNotNull((Object)builder.getPlaybook());
        this.example = (String)Preconditions.checkNotNull((Object)builder.getExample());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getPlaybook() {
        return this.playbook;
    }

    public String getExample() {
        return this.example;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExampleName of(String project, String location, String agent, String playbook, String example) {
        return ExampleName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setPlaybook(playbook).setExample(example).build();
    }

    public static String format(String project, String location, String agent, String playbook, String example) {
        return ExampleName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setPlaybook(playbook).setExample(example).build().toString();
    }

    public static ExampleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT_PLAYBOOK_EXAMPLE.validatedMatch(formattedString, "ExampleName.parse: formattedString not in valid format");
        return ExampleName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("playbook"), (String)matchMap.get("example"));
    }

    public static List<ExampleName> parseList(List<String> formattedStrings) {
        ArrayList<ExampleName> list = new ArrayList<ExampleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExampleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExampleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExampleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_PLAYBOOK_EXAMPLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExampleName exampleName = this;
            synchronized (exampleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.playbook != null) {
                        fieldMapBuilder.put((Object)"playbook", (Object)this.playbook);
                    }
                    if (this.example != null) {
                        fieldMapBuilder.put((Object)"example", (Object)this.example);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT_PLAYBOOK_EXAMPLE.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "playbook", this.playbook, "example", this.example});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ExampleName that = (ExampleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.playbook, that.playbook) && Objects.equals(this.example, that.example);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        h ^= Objects.hashCode(this.playbook);
        h *= 1000003;
        return h ^= Objects.hashCode(this.example);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String playbook;
        private String example;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getPlaybook() {
            return this.playbook;
        }

        public String getExample() {
            return this.example;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setPlaybook(String playbook) {
            this.playbook = playbook;
            return this;
        }

        public Builder setExample(String example) {
            this.example = example;
            return this;
        }

        private Builder(ExampleName exampleName) {
            this.project = exampleName.project;
            this.location = exampleName.location;
            this.agent = exampleName.agent;
            this.playbook = exampleName.playbook;
            this.example = exampleName.example;
        }

        public ExampleName build() {
            return new ExampleName(this);
        }
    }
}

