/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/validation_message.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Agent/flow validation message.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ValidationMessage}
 */
public final class ValidationMessage extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ValidationMessage)
    ValidationMessageOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ValidationMessage.newBuilder() to construct.
  private ValidationMessage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ValidationMessage() {
    resourceType_ = 0;
    resources_ = com.google.protobuf.LazyStringArrayList.emptyList();
    resourceNames_ = java.util.Collections.emptyList();
    severity_ = 0;
    detail_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ValidationMessage();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.ValidationMessageProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ValidationMessage_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.ValidationMessageProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ValidationMessage_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.class,
            com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Resource types.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType}
   */
  public enum ResourceType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>RESOURCE_TYPE_UNSPECIFIED = 0;</code>
     */
    RESOURCE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Agent.
     * </pre>
     *
     * <code>AGENT = 1;</code>
     */
    AGENT(1),
    /**
     *
     *
     * <pre>
     * Intent.
     * </pre>
     *
     * <code>INTENT = 2;</code>
     */
    INTENT(2),
    /**
     *
     *
     * <pre>
     * Intent training phrase.
     * </pre>
     *
     * <code>INTENT_TRAINING_PHRASE = 8;</code>
     */
    INTENT_TRAINING_PHRASE(8),
    /**
     *
     *
     * <pre>
     * Intent parameter.
     * </pre>
     *
     * <code>INTENT_PARAMETER = 9;</code>
     */
    INTENT_PARAMETER(9),
    /**
     *
     *
     * <pre>
     * Multiple intents.
     * </pre>
     *
     * <code>INTENTS = 10;</code>
     */
    INTENTS(10),
    /**
     *
     *
     * <pre>
     * Multiple training phrases.
     * </pre>
     *
     * <code>INTENT_TRAINING_PHRASES = 11;</code>
     */
    INTENT_TRAINING_PHRASES(11),
    /**
     *
     *
     * <pre>
     * Entity type.
     * </pre>
     *
     * <code>ENTITY_TYPE = 3;</code>
     */
    ENTITY_TYPE(3),
    /**
     *
     *
     * <pre>
     * Multiple entity types.
     * </pre>
     *
     * <code>ENTITY_TYPES = 12;</code>
     */
    ENTITY_TYPES(12),
    /**
     *
     *
     * <pre>
     * Webhook.
     * </pre>
     *
     * <code>WEBHOOK = 4;</code>
     */
    WEBHOOK(4),
    /**
     *
     *
     * <pre>
     * Flow.
     * </pre>
     *
     * <code>FLOW = 5;</code>
     */
    FLOW(5),
    /**
     *
     *
     * <pre>
     * Page.
     * </pre>
     *
     * <code>PAGE = 6;</code>
     */
    PAGE(6),
    /**
     *
     *
     * <pre>
     * Multiple pages.
     * </pre>
     *
     * <code>PAGES = 13;</code>
     */
    PAGES(13),
    /**
     *
     *
     * <pre>
     * Transition route group.
     * </pre>
     *
     * <code>TRANSITION_ROUTE_GROUP = 7;</code>
     */
    TRANSITION_ROUTE_GROUP(7),
    /**
     *
     *
     * <pre>
     * Agent transition route group.
     * </pre>
     *
     * <code>AGENT_TRANSITION_ROUTE_GROUP = 14;</code>
     */
    AGENT_TRANSITION_ROUTE_GROUP(14),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>RESOURCE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int RESOURCE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Agent.
     * </pre>
     *
     * <code>AGENT = 1;</code>
     */
    public static final int AGENT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Intent.
     * </pre>
     *
     * <code>INTENT = 2;</code>
     */
    public static final int INTENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Intent training phrase.
     * </pre>
     *
     * <code>INTENT_TRAINING_PHRASE = 8;</code>
     */
    public static final int INTENT_TRAINING_PHRASE_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Intent parameter.
     * </pre>
     *
     * <code>INTENT_PARAMETER = 9;</code>
     */
    public static final int INTENT_PARAMETER_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Multiple intents.
     * </pre>
     *
     * <code>INTENTS = 10;</code>
     */
    public static final int INTENTS_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Multiple training phrases.
     * </pre>
     *
     * <code>INTENT_TRAINING_PHRASES = 11;</code>
     */
    public static final int INTENT_TRAINING_PHRASES_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Entity type.
     * </pre>
     *
     * <code>ENTITY_TYPE = 3;</code>
     */
    public static final int ENTITY_TYPE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Multiple entity types.
     * </pre>
     *
     * <code>ENTITY_TYPES = 12;</code>
     */
    public static final int ENTITY_TYPES_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Webhook.
     * </pre>
     *
     * <code>WEBHOOK = 4;</code>
     */
    public static final int WEBHOOK_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Flow.
     * </pre>
     *
     * <code>FLOW = 5;</code>
     */
    public static final int FLOW_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Page.
     * </pre>
     *
     * <code>PAGE = 6;</code>
     */
    public static final int PAGE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Multiple pages.
     * </pre>
     *
     * <code>PAGES = 13;</code>
     */
    public static final int PAGES_VALUE = 13;
    /**
     *
     *
     * <pre>
     * Transition route group.
     * </pre>
     *
     * <code>TRANSITION_ROUTE_GROUP = 7;</code>
     */
    public static final int TRANSITION_ROUTE_GROUP_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Agent transition route group.
     * </pre>
     *
     * <code>AGENT_TRANSITION_ROUTE_GROUP = 14;</code>
     */
    public static final int AGENT_TRANSITION_ROUTE_GROUP_VALUE = 14;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResourceType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ResourceType forNumber(int value) {
      switch (value) {
        case 0:
          return RESOURCE_TYPE_UNSPECIFIED;
        case 1:
          return AGENT;
        case 2:
          return INTENT;
        case 8:
          return INTENT_TRAINING_PHRASE;
        case 9:
          return INTENT_PARAMETER;
        case 10:
          return INTENTS;
        case 11:
          return INTENT_TRAINING_PHRASES;
        case 3:
          return ENTITY_TYPE;
        case 12:
          return ENTITY_TYPES;
        case 4:
          return WEBHOOK;
        case 5:
          return FLOW;
        case 6:
          return PAGE;
        case 13:
          return PAGES;
        case 7:
          return TRANSITION_ROUTE_GROUP;
        case 14:
          return AGENT_TRANSITION_ROUTE_GROUP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ResourceType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ResourceType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ResourceType>() {
          public ResourceType findValueByNumber(int number) {
            return ResourceType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ResourceType[] VALUES = values();

    public static ResourceType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ResourceType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType)
  }

  /**
   *
   *
   * <pre>
   * Severity level.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity}
   */
  public enum Severity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    SEVERITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The agent doesn't follow Dialogflow best practices.
     * </pre>
     *
     * <code>INFO = 1;</code>
     */
    INFO(1),
    /**
     *
     *
     * <pre>
     * The agent may not behave as expected.
     * </pre>
     *
     * <code>WARNING = 2;</code>
     */
    WARNING(2),
    /**
     *
     *
     * <pre>
     * The agent may experience failures.
     * </pre>
     *
     * <code>ERROR = 3;</code>
     */
    ERROR(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    public static final int SEVERITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The agent doesn't follow Dialogflow best practices.
     * </pre>
     *
     * <code>INFO = 1;</code>
     */
    public static final int INFO_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The agent may not behave as expected.
     * </pre>
     *
     * <code>WARNING = 2;</code>
     */
    public static final int WARNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The agent may experience failures.
     * </pre>
     *
     * <code>ERROR = 3;</code>
     */
    public static final int ERROR_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Severity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Severity forNumber(int value) {
      switch (value) {
        case 0:
          return SEVERITY_UNSPECIFIED;
        case 1:
          return INFO;
        case 2:
          return WARNING;
        case 3:
          return ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Severity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Severity> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Severity>() {
          public Severity findValueByNumber(int number) {
            return Severity.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Severity[] VALUES = values();

    public static Severity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Severity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity)
  }

  public static final int RESOURCE_TYPE_FIELD_NUMBER = 1;
  private int resourceType_ = 0;
  /**
   *
   *
   * <pre>
   * The type of the resources where the message is found.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType resource_type = 1;
   * </code>
   *
   * @return The enum numeric value on the wire for resourceType.
   */
  @java.lang.Override
  public int getResourceTypeValue() {
    return resourceType_;
  }
  /**
   *
   *
   * <pre>
   * The type of the resources where the message is found.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType resource_type = 1;
   * </code>
   *
   * @return The resourceType.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType getResourceType() {
    com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType result =
        com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType.forNumber(
            resourceType_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType.UNRECOGNIZED
        : result;
  }

  public static final int RESOURCES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList resources_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The names of the resources where the message is found.
   * </pre>
   *
   * <code>repeated string resources = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
   *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
   * @return A list containing the resources.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ProtocolStringList getResourcesList() {
    return resources_;
  }
  /**
   *
   *
   * <pre>
   * The names of the resources where the message is found.
   * </pre>
   *
   * <code>repeated string resources = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
   *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
   * @return The count of resources.
   */
  @java.lang.Deprecated
  public int getResourcesCount() {
    return resources_.size();
  }
  /**
   *
   *
   * <pre>
   * The names of the resources where the message is found.
   * </pre>
   *
   * <code>repeated string resources = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
   *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
   * @param index The index of the element to return.
   * @return The resources at the given index.
   */
  @java.lang.Deprecated
  public java.lang.String getResources(int index) {
    return resources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The names of the resources where the message is found.
   * </pre>
   *
   * <code>repeated string resources = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
   *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
   * @param index The index of the value to return.
   * @return The bytes of the resources at the given index.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getResourcesBytes(int index) {
    return resources_.getByteString(index);
  }

  public static final int RESOURCE_NAMES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ResourceName> resourceNames_;
  /**
   *
   *
   * <pre>
   * The resource names of the resources where the message is found.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ResourceName>
      getResourceNamesList() {
    return resourceNames_;
  }
  /**
   *
   *
   * <pre>
   * The resource names of the resources where the message is found.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.ResourceNameOrBuilder>
      getResourceNamesOrBuilderList() {
    return resourceNames_;
  }
  /**
   *
   *
   * <pre>
   * The resource names of the resources where the message is found.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
   */
  @java.lang.Override
  public int getResourceNamesCount() {
    return resourceNames_.size();
  }
  /**
   *
   *
   * <pre>
   * The resource names of the resources where the message is found.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResourceName getResourceNames(int index) {
    return resourceNames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The resource names of the resources where the message is found.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ResourceNameOrBuilder getResourceNamesOrBuilder(
      int index) {
    return resourceNames_.get(index);
  }

  public static final int SEVERITY_FIELD_NUMBER = 3;
  private int severity_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates the severity of the message.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity severity = 3;</code>
   *
   * @return The enum numeric value on the wire for severity.
   */
  @java.lang.Override
  public int getSeverityValue() {
    return severity_;
  }
  /**
   *
   *
   * <pre>
   * Indicates the severity of the message.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity severity = 3;</code>
   *
   * @return The severity.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity getSeverity() {
    com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity result =
        com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity.forNumber(severity_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity.UNRECOGNIZED
        : result;
  }

  public static final int DETAIL_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object detail_ = "";
  /**
   *
   *
   * <pre>
   * The message detail.
   * </pre>
   *
   * <code>string detail = 4;</code>
   *
   * @return The detail.
   */
  @java.lang.Override
  public java.lang.String getDetail() {
    java.lang.Object ref = detail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      detail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The message detail.
   * </pre>
   *
   * <code>string detail = 4;</code>
   *
   * @return The bytes for detail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDetailBytes() {
    java.lang.Object ref = detail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      detail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (resourceType_
        != com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType
            .RESOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, resourceType_);
    }
    for (int i = 0; i < resources_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resources_.getRaw(i));
    }
    if (severity_
        != com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity.SEVERITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, severity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, detail_);
    }
    for (int i = 0; i < resourceNames_.size(); i++) {
      output.writeMessage(6, resourceNames_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (resourceType_
        != com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType
            .RESOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, resourceType_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < resources_.size(); i++) {
        dataSize += computeStringSizeNoTag(resources_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getResourcesList().size();
    }
    if (severity_
        != com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity.SEVERITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, severity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, detail_);
    }
    for (int i = 0; i < resourceNames_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, resourceNames_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage other =
        (com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage) obj;

    if (resourceType_ != other.resourceType_) return false;
    if (!getResourcesList().equals(other.getResourcesList())) return false;
    if (!getResourceNamesList().equals(other.getResourceNamesList())) return false;
    if (severity_ != other.severity_) return false;
    if (!getDetail().equals(other.getDetail())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + resourceType_;
    if (getResourcesCount() > 0) {
      hash = (37 * hash) + RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getResourcesList().hashCode();
    }
    if (getResourceNamesCount() > 0) {
      hash = (37 * hash) + RESOURCE_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getResourceNamesList().hashCode();
    }
    hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
    hash = (53 * hash) + severity_;
    hash = (37 * hash) + DETAIL_FIELD_NUMBER;
    hash = (53 * hash) + getDetail().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Agent/flow validation message.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ValidationMessage}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ValidationMessage)
      com.google.cloud.dialogflow.cx.v3beta1.ValidationMessageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ValidationMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ValidationMessage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ValidationMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ValidationMessage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.class,
              com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceType_ = 0;
      resources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (resourceNamesBuilder_ == null) {
        resourceNames_ = java.util.Collections.emptyList();
      } else {
        resourceNames_ = null;
        resourceNamesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      severity_ = 0;
      detail_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ValidationMessageProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ValidationMessage_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage build() {
      com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage result =
          new com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage result) {
      if (resourceNamesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          resourceNames_ = java.util.Collections.unmodifiableList(resourceNames_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.resourceNames_ = resourceNames_;
      } else {
        result.resourceNames_ = resourceNamesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceType_ = resourceType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        resources_.makeImmutable();
        result.resources_ = resources_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.severity_ = severity_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.detail_ = detail_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.getDefaultInstance())
        return this;
      if (other.resourceType_ != 0) {
        setResourceTypeValue(other.getResourceTypeValue());
      }
      if (!other.resources_.isEmpty()) {
        if (resources_.isEmpty()) {
          resources_ = other.resources_;
          bitField0_ |= 0x00000002;
        } else {
          ensureResourcesIsMutable();
          resources_.addAll(other.resources_);
        }
        onChanged();
      }
      if (resourceNamesBuilder_ == null) {
        if (!other.resourceNames_.isEmpty()) {
          if (resourceNames_.isEmpty()) {
            resourceNames_ = other.resourceNames_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureResourceNamesIsMutable();
            resourceNames_.addAll(other.resourceNames_);
          }
          onChanged();
        }
      } else {
        if (!other.resourceNames_.isEmpty()) {
          if (resourceNamesBuilder_.isEmpty()) {
            resourceNamesBuilder_.dispose();
            resourceNamesBuilder_ = null;
            resourceNames_ = other.resourceNames_;
            bitField0_ = (bitField0_ & ~0x00000004);
            resourceNamesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResourceNamesFieldBuilder()
                    : null;
          } else {
            resourceNamesBuilder_.addAllMessages(other.resourceNames_);
          }
        }
      }
      if (other.severity_ != 0) {
        setSeverityValue(other.getSeverityValue());
      }
      if (!other.getDetail().isEmpty()) {
        detail_ = other.detail_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                resourceType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureResourcesIsMutable();
                resources_.add(s);
                break;
              } // case 18
            case 24:
              {
                severity_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 24
            case 34:
              {
                detail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 50:
              {
                com.google.cloud.dialogflow.cx.v3beta1.ResourceName m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.ResourceName.parser(),
                        extensionRegistry);
                if (resourceNamesBuilder_ == null) {
                  ensureResourceNamesIsMutable();
                  resourceNames_.add(m);
                } else {
                  resourceNamesBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int resourceType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the resources where the message is found.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType resource_type = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for resourceType.
     */
    @java.lang.Override
    public int getResourceTypeValue() {
      return resourceType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the resources where the message is found.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType resource_type = 1;
     * </code>
     *
     * @param value The enum numeric value on the wire for resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceTypeValue(int value) {
      resourceType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the resources where the message is found.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType resource_type = 1;
     * </code>
     *
     * @return The resourceType.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType getResourceType() {
      com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType result =
          com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType.forNumber(
              resourceType_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the resources where the message is found.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType resource_type = 1;
     * </code>
     *
     * @param value The resourceType to set.
     * @return This builder for chaining.
     */
    public Builder setResourceType(
        com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      resourceType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the resources where the message is found.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.ResourceType resource_type = 1;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      resourceType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList resources_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureResourcesIsMutable() {
      if (!resources_.isModifiable()) {
        resources_ = new com.google.protobuf.LazyStringArrayList(resources_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * The names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated string resources = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
     *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
     * @return A list containing the resources.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getResourcesList() {
      resources_.makeImmutable();
      return resources_;
    }
    /**
     *
     *
     * <pre>
     * The names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated string resources = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
     *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
     * @return The count of resources.
     */
    @java.lang.Deprecated
    public int getResourcesCount() {
      return resources_.size();
    }
    /**
     *
     *
     * <pre>
     * The names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated string resources = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
     *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
     * @param index The index of the element to return.
     * @return The resources at the given index.
     */
    @java.lang.Deprecated
    public java.lang.String getResources(int index) {
      return resources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated string resources = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
     *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
     * @param index The index of the value to return.
     * @return The bytes of the resources at the given index.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getResourcesBytes(int index) {
      return resources_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated string resources = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
     *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
     * @param index The index to set the value at.
     * @param value The resources to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setResources(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourcesIsMutable();
      resources_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated string resources = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
     *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
     * @param value The resources to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addResources(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourcesIsMutable();
      resources_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated string resources = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
     *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
     * @param values The resources to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllResources(java.lang.Iterable<java.lang.String> values) {
      ensureResourcesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resources_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated string resources = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
     *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearResources() {
      resources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated string resources = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.ValidationMessage.resources is deprecated. See
     *     google/cloud/dialogflow/cx/v3beta1/validation_message.proto;l=95
     * @param value The bytes of the resources to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addResourcesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureResourcesIsMutable();
      resources_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ResourceName> resourceNames_ =
        java.util.Collections.emptyList();

    private void ensureResourceNamesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        resourceNames_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.ResourceName>(
                resourceNames_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResourceName,
            com.google.cloud.dialogflow.cx.v3beta1.ResourceName.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResourceNameOrBuilder>
        resourceNamesBuilder_;

    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ResourceName>
        getResourceNamesList() {
      if (resourceNamesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(resourceNames_);
      } else {
        return resourceNamesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public int getResourceNamesCount() {
      if (resourceNamesBuilder_ == null) {
        return resourceNames_.size();
      } else {
        return resourceNamesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResourceName getResourceNames(int index) {
      if (resourceNamesBuilder_ == null) {
        return resourceNames_.get(index);
      } else {
        return resourceNamesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public Builder setResourceNames(
        int index, com.google.cloud.dialogflow.cx.v3beta1.ResourceName value) {
      if (resourceNamesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceNamesIsMutable();
        resourceNames_.set(index, value);
        onChanged();
      } else {
        resourceNamesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public Builder setResourceNames(
        int index, com.google.cloud.dialogflow.cx.v3beta1.ResourceName.Builder builderForValue) {
      if (resourceNamesBuilder_ == null) {
        ensureResourceNamesIsMutable();
        resourceNames_.set(index, builderForValue.build());
        onChanged();
      } else {
        resourceNamesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public Builder addResourceNames(com.google.cloud.dialogflow.cx.v3beta1.ResourceName value) {
      if (resourceNamesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceNamesIsMutable();
        resourceNames_.add(value);
        onChanged();
      } else {
        resourceNamesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public Builder addResourceNames(
        int index, com.google.cloud.dialogflow.cx.v3beta1.ResourceName value) {
      if (resourceNamesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourceNamesIsMutable();
        resourceNames_.add(index, value);
        onChanged();
      } else {
        resourceNamesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public Builder addResourceNames(
        com.google.cloud.dialogflow.cx.v3beta1.ResourceName.Builder builderForValue) {
      if (resourceNamesBuilder_ == null) {
        ensureResourceNamesIsMutable();
        resourceNames_.add(builderForValue.build());
        onChanged();
      } else {
        resourceNamesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public Builder addResourceNames(
        int index, com.google.cloud.dialogflow.cx.v3beta1.ResourceName.Builder builderForValue) {
      if (resourceNamesBuilder_ == null) {
        ensureResourceNamesIsMutable();
        resourceNames_.add(index, builderForValue.build());
        onChanged();
      } else {
        resourceNamesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public Builder addAllResourceNames(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.ResourceName> values) {
      if (resourceNamesBuilder_ == null) {
        ensureResourceNamesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourceNames_);
        onChanged();
      } else {
        resourceNamesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public Builder clearResourceNames() {
      if (resourceNamesBuilder_ == null) {
        resourceNames_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        resourceNamesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public Builder removeResourceNames(int index) {
      if (resourceNamesBuilder_ == null) {
        ensureResourceNamesIsMutable();
        resourceNames_.remove(index);
        onChanged();
      } else {
        resourceNamesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResourceName.Builder getResourceNamesBuilder(
        int index) {
      return getResourceNamesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResourceNameOrBuilder getResourceNamesOrBuilder(
        int index) {
      if (resourceNamesBuilder_ == null) {
        return resourceNames_.get(index);
      } else {
        return resourceNamesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.ResourceNameOrBuilder>
        getResourceNamesOrBuilderList() {
      if (resourceNamesBuilder_ != null) {
        return resourceNamesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(resourceNames_);
      }
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResourceName.Builder addResourceNamesBuilder() {
      return getResourceNamesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.ResourceName.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ResourceName.Builder addResourceNamesBuilder(
        int index) {
      return getResourceNamesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3beta1.ResourceName.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The resource names of the resources where the message is found.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.ResourceName resource_names = 6;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ResourceName.Builder>
        getResourceNamesBuilderList() {
      return getResourceNamesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ResourceName,
            com.google.cloud.dialogflow.cx.v3beta1.ResourceName.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ResourceNameOrBuilder>
        getResourceNamesFieldBuilder() {
      if (resourceNamesBuilder_ == null) {
        resourceNamesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ResourceName,
                com.google.cloud.dialogflow.cx.v3beta1.ResourceName.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ResourceNameOrBuilder>(
                resourceNames_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        resourceNames_ = null;
      }
      return resourceNamesBuilder_;
    }

    private int severity_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates the severity of the message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity severity = 3;</code>
     *
     * @return The enum numeric value on the wire for severity.
     */
    @java.lang.Override
    public int getSeverityValue() {
      return severity_;
    }
    /**
     *
     *
     * <pre>
     * Indicates the severity of the message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity severity = 3;</code>
     *
     * @param value The enum numeric value on the wire for severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverityValue(int value) {
      severity_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the severity of the message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity severity = 3;</code>
     *
     * @return The severity.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity getSeverity() {
      com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity result =
          com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity.forNumber(severity_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates the severity of the message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity severity = 3;</code>
     *
     * @param value The severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverity(
        com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      severity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the severity of the message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ValidationMessage.Severity severity = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeverity() {
      bitField0_ = (bitField0_ & ~0x00000008);
      severity_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object detail_ = "";
    /**
     *
     *
     * <pre>
     * The message detail.
     * </pre>
     *
     * <code>string detail = 4;</code>
     *
     * @return The detail.
     */
    public java.lang.String getDetail() {
      java.lang.Object ref = detail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        detail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The message detail.
     * </pre>
     *
     * <code>string detail = 4;</code>
     *
     * @return The bytes for detail.
     */
    public com.google.protobuf.ByteString getDetailBytes() {
      java.lang.Object ref = detail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        detail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The message detail.
     * </pre>
     *
     * <code>string detail = 4;</code>
     *
     * @param value The detail to set.
     * @return This builder for chaining.
     */
    public Builder setDetail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      detail_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The message detail.
     * </pre>
     *
     * <code>string detail = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDetail() {
      detail_ = getDefaultInstance().getDetail();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The message detail.
     * </pre>
     *
     * <code>string detail = 4;</code>
     *
     * @param value The bytes for detail to set.
     * @return This builder for chaining.
     */
    public Builder setDetailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      detail_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ValidationMessage)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ValidationMessage)
  private static final com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ValidationMessage> PARSER =
      new com.google.protobuf.AbstractParser<ValidationMessage>() {
        @java.lang.Override
        public ValidationMessage parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ValidationMessage> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ValidationMessage> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ValidationMessage getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
