/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/tool_call.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * The result of calling a tool's action that has been executed by the client.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ToolCallResult}
 */
public final class ToolCallResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ToolCallResult)
    ToolCallResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ToolCallResult.newBuilder() to construct.
  private ToolCallResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ToolCallResult() {
    tool_ = "";
    action_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ToolCallResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.ToolCallProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ToolCallResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.ToolCallProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ToolCallResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.class,
            com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Builder.class);
  }

  public interface ErrorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The error message of the function.
     * </pre>
     *
     * <code>string message = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The message.
     */
    java.lang.String getMessage();
    /**
     *
     *
     * <pre>
     * The error message of the function.
     * </pre>
     *
     * <code>string message = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for message.
     */
    com.google.protobuf.ByteString getMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * An error produced by the tool call.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error}
   */
  public static final class Error extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error)
      ErrorOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Error.newBuilder() to construct.
    private Error(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Error() {
      message_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Error();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolCallProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ToolCallResult_Error_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolCallProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ToolCallResult_Error_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.class,
              com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.Builder.class);
    }

    public static final int MESSAGE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object message_ = "";
    /**
     *
     *
     * <pre>
     * The error message of the function.
     * </pre>
     *
     * <code>string message = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The message.
     */
    @java.lang.Override
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The error message of the function.
     * </pre>
     *
     * <code>string message = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for message.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, message_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, message_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error other =
          (com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error) obj;

      if (!getMessage().equals(other.getMessage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getMessage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An error produced by the tool call.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error)
        com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.ErrorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolCallProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ToolCallResult_Error_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolCallProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ToolCallResult_Error_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.class,
                com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        message_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolCallProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_ToolCallResult_Error_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error build() {
        com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error result =
            new com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.message_ = message_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.getDefaultInstance())
          return this;
        if (!other.getMessage().isEmpty()) {
          message_ = other.message_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  message_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object message_ = "";
      /**
       *
       *
       * <pre>
       * The error message of the function.
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The message.
       */
      public java.lang.String getMessage() {
        java.lang.Object ref = message_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          message_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The error message of the function.
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for message.
       */
      public com.google.protobuf.ByteString getMessageBytes() {
        java.lang.Object ref = message_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          message_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The error message of the function.
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The message to set.
       * @return This builder for chaining.
       */
      public Builder setMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error message of the function.
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMessage() {
        message_ = getDefaultInstance().getMessage();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error message of the function.
       * </pre>
       *
       * <code>string message = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for message to set.
       * @return This builder for chaining.
       */
      public Builder setMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        message_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error)
    private static final com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Error> PARSER =
        new com.google.protobuf.AbstractParser<Error>() {
          @java.lang.Override
          public Error parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Error> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Error> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int resultCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object result_;

  public enum ResultCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ERROR(3),
    OUTPUT_PARAMETERS(4),
    RESULT_NOT_SET(0);
    private final int value;

    private ResultCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResultCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResultCase forNumber(int value) {
      switch (value) {
        case 3:
          return ERROR;
        case 4:
          return OUTPUT_PARAMETERS;
        case 0:
          return RESULT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResultCase getResultCase() {
    return ResultCase.forNumber(resultCase_);
  }

  public static final int TOOL_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tool_ = "";
  /**
   *
   *
   * <pre>
   * The [tool][Tool] associated with this call.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/tools/&lt;Tool ID&gt;`.
   * </pre>
   *
   * <code>
   * string tool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The tool.
   */
  @java.lang.Override
  public java.lang.String getTool() {
    java.lang.Object ref = tool_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tool_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [tool][Tool] associated with this call.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/tools/&lt;Tool ID&gt;`.
   * </pre>
   *
   * <code>
   * string tool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for tool.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getToolBytes() {
    java.lang.Object ref = tool_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tool_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object action_ = "";
  /**
   *
   *
   * <pre>
   * The name of the tool's action associated with this call.
   * </pre>
   *
   * <code>string action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The action.
   */
  @java.lang.Override
  public java.lang.String getAction() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      action_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the tool's action associated with this call.
   * </pre>
   *
   * <code>string action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for action.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getActionBytes() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      action_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The tool call's error.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error error = 3;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return resultCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The tool call's error.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error error = 3;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error getError() {
    if (resultCase_ == 3) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error) result_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The tool call's error.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error error = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.ErrorOrBuilder getErrorOrBuilder() {
    if (resultCase_ == 3) {
      return (com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error) result_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.getDefaultInstance();
  }

  public static final int OUTPUT_PARAMETERS_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The tool call's output parameters.
   * </pre>
   *
   * <code>.google.protobuf.Struct output_parameters = 4;</code>
   *
   * @return Whether the outputParameters field is set.
   */
  @java.lang.Override
  public boolean hasOutputParameters() {
    return resultCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The tool call's output parameters.
   * </pre>
   *
   * <code>.google.protobuf.Struct output_parameters = 4;</code>
   *
   * @return The outputParameters.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getOutputParameters() {
    if (resultCase_ == 4) {
      return (com.google.protobuf.Struct) result_;
    }
    return com.google.protobuf.Struct.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The tool call's output parameters.
   * </pre>
   *
   * <code>.google.protobuf.Struct output_parameters = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getOutputParametersOrBuilder() {
    if (resultCase_ == 4) {
      return (com.google.protobuf.Struct) result_;
    }
    return com.google.protobuf.Struct.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tool_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tool_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(action_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, action_);
    }
    if (resultCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error) result_);
    }
    if (resultCase_ == 4) {
      output.writeMessage(4, (com.google.protobuf.Struct) result_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tool_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tool_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(action_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, action_);
    }
    if (resultCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error) result_);
    }
    if (resultCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.protobuf.Struct) result_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult other =
        (com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult) obj;

    if (!getTool().equals(other.getTool())) return false;
    if (!getAction().equals(other.getAction())) return false;
    if (!getResultCase().equals(other.getResultCase())) return false;
    switch (resultCase_) {
      case 3:
        if (!getError().equals(other.getError())) return false;
        break;
      case 4:
        if (!getOutputParameters().equals(other.getOutputParameters())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TOOL_FIELD_NUMBER;
    hash = (53 * hash) + getTool().hashCode();
    hash = (37 * hash) + ACTION_FIELD_NUMBER;
    hash = (53 * hash) + getAction().hashCode();
    switch (resultCase_) {
      case 3:
        hash = (37 * hash) + ERROR_FIELD_NUMBER;
        hash = (53 * hash) + getError().hashCode();
        break;
      case 4:
        hash = (37 * hash) + OUTPUT_PARAMETERS_FIELD_NUMBER;
        hash = (53 * hash) + getOutputParameters().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The result of calling a tool's action that has been executed by the client.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ToolCallResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ToolCallResult)
      com.google.cloud.dialogflow.cx.v3beta1.ToolCallResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolCallProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ToolCallResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolCallProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ToolCallResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.class,
              com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      tool_ = "";
      action_ = "";
      if (errorBuilder_ != null) {
        errorBuilder_.clear();
      }
      if (outputParametersBuilder_ != null) {
        outputParametersBuilder_.clear();
      }
      resultCase_ = 0;
      result_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolCallProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ToolCallResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult build() {
      com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult result =
          new com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.tool_ = tool_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.action_ = action_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult result) {
      result.resultCase_ = resultCase_;
      result.result_ = this.result_;
      if (resultCase_ == 3 && errorBuilder_ != null) {
        result.result_ = errorBuilder_.build();
      }
      if (resultCase_ == 4 && outputParametersBuilder_ != null) {
        result.result_ = outputParametersBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.getDefaultInstance())
        return this;
      if (!other.getTool().isEmpty()) {
        tool_ = other.tool_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAction().isEmpty()) {
        action_ = other.action_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      switch (other.getResultCase()) {
        case ERROR:
          {
            mergeError(other.getError());
            break;
          }
        case OUTPUT_PARAMETERS:
          {
            mergeOutputParameters(other.getOutputParameters());
            break;
          }
        case RESULT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                tool_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                action_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                resultCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getOutputParametersFieldBuilder().getBuilder(), extensionRegistry);
                resultCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int resultCase_ = 0;
    private java.lang.Object result_;

    public ResultCase getResultCase() {
      return ResultCase.forNumber(resultCase_);
    }

    public Builder clearResult() {
      resultCase_ = 0;
      result_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object tool_ = "";
    /**
     *
     *
     * <pre>
     * The [tool][Tool] associated with this call.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/tools/&lt;Tool ID&gt;`.
     * </pre>
     *
     * <code>
     * string tool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tool.
     */
    public java.lang.String getTool() {
      java.lang.Object ref = tool_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tool_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [tool][Tool] associated with this call.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/tools/&lt;Tool ID&gt;`.
     * </pre>
     *
     * <code>
     * string tool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tool.
     */
    public com.google.protobuf.ByteString getToolBytes() {
      java.lang.Object ref = tool_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tool_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [tool][Tool] associated with this call.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/tools/&lt;Tool ID&gt;`.
     * </pre>
     *
     * <code>
     * string tool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tool to set.
     * @return This builder for chaining.
     */
    public Builder setTool(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tool_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [tool][Tool] associated with this call.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/tools/&lt;Tool ID&gt;`.
     * </pre>
     *
     * <code>
     * string tool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTool() {
      tool_ = getDefaultInstance().getTool();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [tool][Tool] associated with this call.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/tools/&lt;Tool ID&gt;`.
     * </pre>
     *
     * <code>
     * string tool = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tool to set.
     * @return This builder for chaining.
     */
    public Builder setToolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tool_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object action_ = "";
    /**
     *
     *
     * <pre>
     * The name of the tool's action associated with this call.
     * </pre>
     *
     * <code>string action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The action.
     */
    public java.lang.String getAction() {
      java.lang.Object ref = action_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        action_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the tool's action associated with this call.
     * </pre>
     *
     * <code>string action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for action.
     */
    public com.google.protobuf.ByteString getActionBytes() {
      java.lang.Object ref = action_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        action_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the tool's action associated with this call.
     * </pre>
     *
     * <code>string action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      action_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the tool's action associated with this call.
     * </pre>
     *
     * <code>string action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      action_ = getDefaultInstance().getAction();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the tool's action associated with this call.
     * </pre>
     *
     * <code>string action = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      action_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error,
            com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.ErrorOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * The tool call's error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error error = 3;</code>
     *
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return resultCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The tool call's error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error error = 3;</code>
     *
     * @return The error.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error getError() {
      if (errorBuilder_ == null) {
        if (resultCase_ == 3) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error) result_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.getDefaultInstance();
      } else {
        if (resultCase_ == 3) {
          return errorBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The tool call's error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error error = 3;</code>
     */
    public Builder setError(com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }
      resultCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tool call's error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error error = 3;</code>
     */
    public Builder setError(
        com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.Builder builderForValue) {
      if (errorBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tool call's error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error error = 3;</code>
     */
    public Builder mergeError(com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error value) {
      if (errorBuilder_ == null) {
        if (resultCase_ == 3
            && result_
                != com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error
                    .getDefaultInstance()) {
          result_ =
              com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error) result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 3) {
          errorBuilder_.mergeFrom(value);
        } else {
          errorBuilder_.setMessage(value);
        }
      }
      resultCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tool call's error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error error = 3;</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        if (resultCase_ == 3) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 3) {
          resultCase_ = 0;
          result_ = null;
        }
        errorBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tool call's error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error error = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.Builder getErrorBuilder() {
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The tool call's error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error error = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.ErrorOrBuilder
        getErrorOrBuilder() {
      if ((resultCase_ == 3) && (errorBuilder_ != null)) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 3) {
          return (com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error) result_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The tool call's error.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error error = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error,
            com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.ErrorOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        if (!(resultCase_ == 3)) {
          result_ =
              com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.getDefaultInstance();
        }
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error,
                com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.ErrorOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult.Error) result_,
                getParentForChildren(),
                isClean());
        result_ = null;
      }
      resultCase_ = 3;
      onChanged();
      return errorBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        outputParametersBuilder_;
    /**
     *
     *
     * <pre>
     * The tool call's output parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_parameters = 4;</code>
     *
     * @return Whether the outputParameters field is set.
     */
    @java.lang.Override
    public boolean hasOutputParameters() {
      return resultCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The tool call's output parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_parameters = 4;</code>
     *
     * @return The outputParameters.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getOutputParameters() {
      if (outputParametersBuilder_ == null) {
        if (resultCase_ == 4) {
          return (com.google.protobuf.Struct) result_;
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      } else {
        if (resultCase_ == 4) {
          return outputParametersBuilder_.getMessage();
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The tool call's output parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_parameters = 4;</code>
     */
    public Builder setOutputParameters(com.google.protobuf.Struct value) {
      if (outputParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        outputParametersBuilder_.setMessage(value);
      }
      resultCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tool call's output parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_parameters = 4;</code>
     */
    public Builder setOutputParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (outputParametersBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        outputParametersBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tool call's output parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_parameters = 4;</code>
     */
    public Builder mergeOutputParameters(com.google.protobuf.Struct value) {
      if (outputParametersBuilder_ == null) {
        if (resultCase_ == 4 && result_ != com.google.protobuf.Struct.getDefaultInstance()) {
          result_ =
              com.google.protobuf.Struct.newBuilder((com.google.protobuf.Struct) result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 4) {
          outputParametersBuilder_.mergeFrom(value);
        } else {
          outputParametersBuilder_.setMessage(value);
        }
      }
      resultCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tool call's output parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_parameters = 4;</code>
     */
    public Builder clearOutputParameters() {
      if (outputParametersBuilder_ == null) {
        if (resultCase_ == 4) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 4) {
          resultCase_ = 0;
          result_ = null;
        }
        outputParametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tool call's output parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_parameters = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getOutputParametersBuilder() {
      return getOutputParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The tool call's output parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_parameters = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getOutputParametersOrBuilder() {
      if ((resultCase_ == 4) && (outputParametersBuilder_ != null)) {
        return outputParametersBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 4) {
          return (com.google.protobuf.Struct) result_;
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The tool call's output parameters.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_parameters = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getOutputParametersFieldBuilder() {
      if (outputParametersBuilder_ == null) {
        if (!(resultCase_ == 4)) {
          result_ = com.google.protobuf.Struct.getDefaultInstance();
        }
        outputParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                (com.google.protobuf.Struct) result_, getParentForChildren(), isClean());
        result_ = null;
      }
      resultCase_ = 4;
      onChanged();
      return outputParametersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ToolCallResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ToolCallResult)
  private static final com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ToolCallResult> PARSER =
      new com.google.protobuf.AbstractParser<ToolCallResult>() {
        @java.lang.Override
        public ToolCallResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ToolCallResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ToolCallResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ToolCallResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
