/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/tool.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * A tool provides a list of actions which are available to the
 * [Playbook][google.cloud.dialogflow.cx.v3beta1.Playbook] to attain its goal. A
 * Tool consists of a description of the tool's usage and a specification of the
 * tool which contains the schema and authentication information.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool}
 */
public final class Tool extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool)
    ToolOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Tool.newBuilder() to construct.
  private Tool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Tool() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    toolType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Tool();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.class,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents the type of the tool.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3beta1.Tool.ToolType}
   */
  public enum ToolType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>TOOL_TYPE_UNSPECIFIED = 0;</code>
     */
    TOOL_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Customer provided tool.
     * </pre>
     *
     * <code>CUSTOMIZED_TOOL = 1;</code>
     */
    CUSTOMIZED_TOOL(1),
    /**
     *
     *
     * <pre>
     * First party built-in tool created by Dialogflow which cannot be modified.
     * </pre>
     *
     * <code>BUILTIN_TOOL = 2;</code>
     */
    BUILTIN_TOOL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>TOOL_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TOOL_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Customer provided tool.
     * </pre>
     *
     * <code>CUSTOMIZED_TOOL = 1;</code>
     */
    public static final int CUSTOMIZED_TOOL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * First party built-in tool created by Dialogflow which cannot be modified.
     * </pre>
     *
     * <code>BUILTIN_TOOL = 2;</code>
     */
    public static final int BUILTIN_TOOL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ToolType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ToolType forNumber(int value) {
      switch (value) {
        case 0:
          return TOOL_TYPE_UNSPECIFIED;
        case 1:
          return CUSTOMIZED_TOOL;
        case 2:
          return BUILTIN_TOOL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ToolType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ToolType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ToolType>() {
          public ToolType findValueByNumber(int number) {
            return ToolType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.getDescriptor().getEnumTypes().get(0);
    }

    private static final ToolType[] VALUES = values();

    public static ToolType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ToolType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.Tool.ToolType)
  }

  public interface OpenApiToolOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The OpenAPI schema specified as a text.
     * </pre>
     *
     * <code>string text_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the textSchema field is set.
     */
    boolean hasTextSchema();
    /**
     *
     *
     * <pre>
     * Required. The OpenAPI schema specified as a text.
     * </pre>
     *
     * <code>string text_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The textSchema.
     */
    java.lang.String getTextSchema();
    /**
     *
     *
     * <pre>
     * Required. The OpenAPI schema specified as a text.
     * </pre>
     *
     * <code>string text_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for textSchema.
     */
    com.google.protobuf.ByteString getTextSchemaBytes();

    /**
     *
     *
     * <pre>
     * Optional. Authentication information required by the API.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the authentication field is set.
     */
    boolean hasAuthentication();
    /**
     *
     *
     * <pre>
     * Optional. Authentication information required by the API.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The authentication.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication getAuthentication();
    /**
     *
     *
     * <pre>
     * Optional. Authentication information required by the API.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.AuthenticationOrBuilder
        getAuthenticationOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. TLS configuration for the HTTPS verification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the tlsConfig field is set.
     */
    boolean hasTlsConfig();
    /**
     *
     *
     * <pre>
     * Optional. TLS configuration for the HTTPS verification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The tlsConfig.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig getTlsConfig();
    /**
     *
     *
     * <pre>
     * Optional. TLS configuration for the HTTPS verification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfigOrBuilder getTlsConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Service Directory configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the serviceDirectoryConfig field is set.
     */
    boolean hasServiceDirectoryConfig();
    /**
     *
     *
     * <pre>
     * Optional. Service Directory configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The serviceDirectoryConfig.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig getServiceDirectoryConfig();
    /**
     *
     *
     * <pre>
     * Optional. Service Directory configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfigOrBuilder
        getServiceDirectoryConfigOrBuilder();

    com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.SchemaCase getSchemaCase();
  }
  /**
   *
   *
   * <pre>
   * An OpenAPI tool is a way to provide the Tool specifications in the Open API
   * schema format.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool}
   */
  public static final class OpenApiTool extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool)
      OpenApiToolOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OpenApiTool.newBuilder() to construct.
    private OpenApiTool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OpenApiTool() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OpenApiTool();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_OpenApiTool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_OpenApiTool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.class,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.Builder.class);
    }

    private int bitField0_;
    private int schemaCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object schema_;

    public enum SchemaCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      TEXT_SCHEMA(1),
      SCHEMA_NOT_SET(0);
      private final int value;

      private SchemaCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SchemaCase valueOf(int value) {
        return forNumber(value);
      }

      public static SchemaCase forNumber(int value) {
        switch (value) {
          case 1:
            return TEXT_SCHEMA;
          case 0:
            return SCHEMA_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SchemaCase getSchemaCase() {
      return SchemaCase.forNumber(schemaCase_);
    }

    public static final int TEXT_SCHEMA_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Required. The OpenAPI schema specified as a text.
     * </pre>
     *
     * <code>string text_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the textSchema field is set.
     */
    public boolean hasTextSchema() {
      return schemaCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Required. The OpenAPI schema specified as a text.
     * </pre>
     *
     * <code>string text_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The textSchema.
     */
    public java.lang.String getTextSchema() {
      java.lang.Object ref = "";
      if (schemaCase_ == 1) {
        ref = schema_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (schemaCase_ == 1) {
          schema_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The OpenAPI schema specified as a text.
     * </pre>
     *
     * <code>string text_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for textSchema.
     */
    public com.google.protobuf.ByteString getTextSchemaBytes() {
      java.lang.Object ref = "";
      if (schemaCase_ == 1) {
        ref = schema_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (schemaCase_ == 1) {
          schema_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AUTHENTICATION_FIELD_NUMBER = 2;
    private com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication_;
    /**
     *
     *
     * <pre>
     * Optional. Authentication information required by the API.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the authentication field is set.
     */
    @java.lang.Override
    public boolean hasAuthentication() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Authentication information required by the API.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The authentication.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication getAuthentication() {
      return authentication_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.getDefaultInstance()
          : authentication_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Authentication information required by the API.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.AuthenticationOrBuilder
        getAuthenticationOrBuilder() {
      return authentication_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.getDefaultInstance()
          : authentication_;
    }

    public static final int TLS_CONFIG_FIELD_NUMBER = 3;
    private com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tlsConfig_;
    /**
     *
     *
     * <pre>
     * Optional. TLS configuration for the HTTPS verification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the tlsConfig field is set.
     */
    @java.lang.Override
    public boolean hasTlsConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. TLS configuration for the HTTPS verification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The tlsConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig getTlsConfig() {
      return tlsConfig_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.getDefaultInstance()
          : tlsConfig_;
    }
    /**
     *
     *
     * <pre>
     * Optional. TLS configuration for the HTTPS verification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfigOrBuilder getTlsConfigOrBuilder() {
      return tlsConfig_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.getDefaultInstance()
          : tlsConfig_;
    }

    public static final int SERVICE_DIRECTORY_CONFIG_FIELD_NUMBER = 4;
    private com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
        serviceDirectoryConfig_;
    /**
     *
     *
     * <pre>
     * Optional. Service Directory configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the serviceDirectoryConfig field is set.
     */
    @java.lang.Override
    public boolean hasServiceDirectoryConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Directory configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The serviceDirectoryConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
        getServiceDirectoryConfig() {
      return serviceDirectoryConfig_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig.getDefaultInstance()
          : serviceDirectoryConfig_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Service Directory configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfigOrBuilder
        getServiceDirectoryConfigOrBuilder() {
      return serviceDirectoryConfig_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig.getDefaultInstance()
          : serviceDirectoryConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (schemaCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, schema_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getAuthentication());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getTlsConfig());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(4, getServiceDirectoryConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (schemaCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, schema_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAuthentication());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTlsConfig());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, getServiceDirectoryConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool other =
          (com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool) obj;

      if (hasAuthentication() != other.hasAuthentication()) return false;
      if (hasAuthentication()) {
        if (!getAuthentication().equals(other.getAuthentication())) return false;
      }
      if (hasTlsConfig() != other.hasTlsConfig()) return false;
      if (hasTlsConfig()) {
        if (!getTlsConfig().equals(other.getTlsConfig())) return false;
      }
      if (hasServiceDirectoryConfig() != other.hasServiceDirectoryConfig()) return false;
      if (hasServiceDirectoryConfig()) {
        if (!getServiceDirectoryConfig().equals(other.getServiceDirectoryConfig())) return false;
      }
      if (!getSchemaCase().equals(other.getSchemaCase())) return false;
      switch (schemaCase_) {
        case 1:
          if (!getTextSchema().equals(other.getTextSchema())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAuthentication()) {
        hash = (37 * hash) + AUTHENTICATION_FIELD_NUMBER;
        hash = (53 * hash) + getAuthentication().hashCode();
      }
      if (hasTlsConfig()) {
        hash = (37 * hash) + TLS_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTlsConfig().hashCode();
      }
      if (hasServiceDirectoryConfig()) {
        hash = (37 * hash) + SERVICE_DIRECTORY_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getServiceDirectoryConfig().hashCode();
      }
      switch (schemaCase_) {
        case 1:
          hash = (37 * hash) + TEXT_SCHEMA_FIELD_NUMBER;
          hash = (53 * hash) + getTextSchema().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An OpenAPI tool is a way to provide the Tool specifications in the Open API
     * schema format.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool)
        com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiToolOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_OpenApiTool_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_OpenApiTool_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAuthenticationFieldBuilder();
          getTlsConfigFieldBuilder();
          getServiceDirectoryConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        authentication_ = null;
        if (authenticationBuilder_ != null) {
          authenticationBuilder_.dispose();
          authenticationBuilder_ = null;
        }
        tlsConfig_ = null;
        if (tlsConfigBuilder_ != null) {
          tlsConfigBuilder_.dispose();
          tlsConfigBuilder_ = null;
        }
        serviceDirectoryConfig_ = null;
        if (serviceDirectoryConfigBuilder_ != null) {
          serviceDirectoryConfigBuilder_.dispose();
          serviceDirectoryConfigBuilder_ = null;
        }
        schemaCase_ = 0;
        schema_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_OpenApiTool_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool build() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool result =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.authentication_ =
              authenticationBuilder_ == null ? authentication_ : authenticationBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.tlsConfig_ = tlsConfigBuilder_ == null ? tlsConfig_ : tlsConfigBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.serviceDirectoryConfig_ =
              serviceDirectoryConfigBuilder_ == null
                  ? serviceDirectoryConfig_
                  : serviceDirectoryConfigBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool result) {
        result.schemaCase_ = schemaCase_;
        result.schema_ = this.schema_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool other) {
        if (other == com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.getDefaultInstance())
          return this;
        if (other.hasAuthentication()) {
          mergeAuthentication(other.getAuthentication());
        }
        if (other.hasTlsConfig()) {
          mergeTlsConfig(other.getTlsConfig());
        }
        if (other.hasServiceDirectoryConfig()) {
          mergeServiceDirectoryConfig(other.getServiceDirectoryConfig());
        }
        switch (other.getSchemaCase()) {
          case TEXT_SCHEMA:
            {
              schemaCase_ = 1;
              schema_ = other.schema_;
              onChanged();
              break;
            }
          case SCHEMA_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  schemaCase_ = 1;
                  schema_ = s;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getAuthenticationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getTlsConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getServiceDirectoryConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int schemaCase_ = 0;
      private java.lang.Object schema_;

      public SchemaCase getSchemaCase() {
        return SchemaCase.forNumber(schemaCase_);
      }

      public Builder clearSchema() {
        schemaCase_ = 0;
        schema_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Required. The OpenAPI schema specified as a text.
       * </pre>
       *
       * <code>string text_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return Whether the textSchema field is set.
       */
      @java.lang.Override
      public boolean hasTextSchema() {
        return schemaCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Required. The OpenAPI schema specified as a text.
       * </pre>
       *
       * <code>string text_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The textSchema.
       */
      @java.lang.Override
      public java.lang.String getTextSchema() {
        java.lang.Object ref = "";
        if (schemaCase_ == 1) {
          ref = schema_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (schemaCase_ == 1) {
            schema_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The OpenAPI schema specified as a text.
       * </pre>
       *
       * <code>string text_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for textSchema.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTextSchemaBytes() {
        java.lang.Object ref = "";
        if (schemaCase_ == 1) {
          ref = schema_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (schemaCase_ == 1) {
            schema_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The OpenAPI schema specified as a text.
       * </pre>
       *
       * <code>string text_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The textSchema to set.
       * @return This builder for chaining.
       */
      public Builder setTextSchema(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        schemaCase_ = 1;
        schema_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The OpenAPI schema specified as a text.
       * </pre>
       *
       * <code>string text_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTextSchema() {
        if (schemaCase_ == 1) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The OpenAPI schema specified as a text.
       * </pre>
       *
       * <code>string text_schema = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for textSchema to set.
       * @return This builder for chaining.
       */
      public Builder setTextSchemaBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        schemaCase_ = 1;
        schema_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.AuthenticationOrBuilder>
          authenticationBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Authentication information required by the API.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the authentication field is set.
       */
      public boolean hasAuthentication() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Authentication information required by the API.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The authentication.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication getAuthentication() {
        if (authenticationBuilder_ == null) {
          return authentication_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.getDefaultInstance()
              : authentication_;
        } else {
          return authenticationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Authentication information required by the API.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAuthentication(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication value) {
        if (authenticationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          authentication_ = value;
        } else {
          authenticationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Authentication information required by the API.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAuthentication(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.Builder builderForValue) {
        if (authenticationBuilder_ == null) {
          authentication_ = builderForValue.build();
        } else {
          authenticationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Authentication information required by the API.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeAuthentication(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication value) {
        if (authenticationBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && authentication_ != null
              && authentication_
                  != com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
                      .getDefaultInstance()) {
            getAuthenticationBuilder().mergeFrom(value);
          } else {
            authentication_ = value;
          }
        } else {
          authenticationBuilder_.mergeFrom(value);
        }
        if (authentication_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Authentication information required by the API.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearAuthentication() {
        bitField0_ = (bitField0_ & ~0x00000002);
        authentication_ = null;
        if (authenticationBuilder_ != null) {
          authenticationBuilder_.dispose();
          authenticationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Authentication information required by the API.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.Builder
          getAuthenticationBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getAuthenticationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Authentication information required by the API.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.AuthenticationOrBuilder
          getAuthenticationOrBuilder() {
        if (authenticationBuilder_ != null) {
          return authenticationBuilder_.getMessageOrBuilder();
        } else {
          return authentication_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.getDefaultInstance()
              : authentication_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Authentication information required by the API.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication authentication = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.AuthenticationOrBuilder>
          getAuthenticationFieldBuilder() {
        if (authenticationBuilder_ == null) {
          authenticationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.AuthenticationOrBuilder>(
                  getAuthentication(), getParentForChildren(), isClean());
          authentication_ = null;
        }
        return authenticationBuilder_;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tlsConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfigOrBuilder>
          tlsConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. TLS configuration for the HTTPS verification.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the tlsConfig field is set.
       */
      public boolean hasTlsConfig() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. TLS configuration for the HTTPS verification.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The tlsConfig.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig getTlsConfig() {
        if (tlsConfigBuilder_ == null) {
          return tlsConfig_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.getDefaultInstance()
              : tlsConfig_;
        } else {
          return tlsConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. TLS configuration for the HTTPS verification.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setTlsConfig(com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig value) {
        if (tlsConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tlsConfig_ = value;
        } else {
          tlsConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. TLS configuration for the HTTPS verification.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setTlsConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.Builder builderForValue) {
        if (tlsConfigBuilder_ == null) {
          tlsConfig_ = builderForValue.build();
        } else {
          tlsConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. TLS configuration for the HTTPS verification.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeTlsConfig(com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig value) {
        if (tlsConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && tlsConfig_ != null
              && tlsConfig_
                  != com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.getDefaultInstance()) {
            getTlsConfigBuilder().mergeFrom(value);
          } else {
            tlsConfig_ = value;
          }
        } else {
          tlsConfigBuilder_.mergeFrom(value);
        }
        if (tlsConfig_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. TLS configuration for the HTTPS verification.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearTlsConfig() {
        bitField0_ = (bitField0_ & ~0x00000004);
        tlsConfig_ = null;
        if (tlsConfigBuilder_ != null) {
          tlsConfigBuilder_.dispose();
          tlsConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. TLS configuration for the HTTPS verification.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.Builder getTlsConfigBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTlsConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. TLS configuration for the HTTPS verification.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfigOrBuilder
          getTlsConfigOrBuilder() {
        if (tlsConfigBuilder_ != null) {
          return tlsConfigBuilder_.getMessageOrBuilder();
        } else {
          return tlsConfig_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.getDefaultInstance()
              : tlsConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. TLS configuration for the HTTPS verification.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig tls_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfigOrBuilder>
          getTlsConfigFieldBuilder() {
        if (tlsConfigBuilder_ == null) {
          tlsConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfigOrBuilder>(
                  getTlsConfig(), getParentForChildren(), isClean());
          tlsConfig_ = null;
        }
        return tlsConfigBuilder_;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
          serviceDirectoryConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfigOrBuilder>
          serviceDirectoryConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Service Directory configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the serviceDirectoryConfig field is set.
       */
      public boolean hasServiceDirectoryConfig() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Service Directory configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The serviceDirectoryConfig.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
          getServiceDirectoryConfig() {
        if (serviceDirectoryConfigBuilder_ == null) {
          return serviceDirectoryConfig_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
                  .getDefaultInstance()
              : serviceDirectoryConfig_;
        } else {
          return serviceDirectoryConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Service Directory configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setServiceDirectoryConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig value) {
        if (serviceDirectoryConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          serviceDirectoryConfig_ = value;
        } else {
          serviceDirectoryConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Service Directory configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setServiceDirectoryConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig.Builder
              builderForValue) {
        if (serviceDirectoryConfigBuilder_ == null) {
          serviceDirectoryConfig_ = builderForValue.build();
        } else {
          serviceDirectoryConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Service Directory configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeServiceDirectoryConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig value) {
        if (serviceDirectoryConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && serviceDirectoryConfig_ != null
              && serviceDirectoryConfig_
                  != com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
                      .getDefaultInstance()) {
            getServiceDirectoryConfigBuilder().mergeFrom(value);
          } else {
            serviceDirectoryConfig_ = value;
          }
        } else {
          serviceDirectoryConfigBuilder_.mergeFrom(value);
        }
        if (serviceDirectoryConfig_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Service Directory configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearServiceDirectoryConfig() {
        bitField0_ = (bitField0_ & ~0x00000008);
        serviceDirectoryConfig_ = null;
        if (serviceDirectoryConfigBuilder_ != null) {
          serviceDirectoryConfigBuilder_.dispose();
          serviceDirectoryConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Service Directory configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig.Builder
          getServiceDirectoryConfigBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getServiceDirectoryConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Service Directory configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfigOrBuilder
          getServiceDirectoryConfigOrBuilder() {
        if (serviceDirectoryConfigBuilder_ != null) {
          return serviceDirectoryConfigBuilder_.getMessageOrBuilder();
        } else {
          return serviceDirectoryConfig_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
                  .getDefaultInstance()
              : serviceDirectoryConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Service Directory configuration.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig service_directory_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfigOrBuilder>
          getServiceDirectoryConfigFieldBuilder() {
        if (serviceDirectoryConfigBuilder_ == null) {
          serviceDirectoryConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfigOrBuilder>(
                  getServiceDirectoryConfig(), getParentForChildren(), isClean());
          serviceDirectoryConfig_ = null;
        }
        return serviceDirectoryConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OpenApiTool> PARSER =
        new com.google.protobuf.AbstractParser<OpenApiTool>() {
          @java.lang.Override
          public OpenApiTool parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OpenApiTool> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OpenApiTool> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DataStoreToolOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. List of data stores to search.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>
        getDataStoreConnectionsList();
    /**
     *
     *
     * <pre>
     * Required. List of data stores to search.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection getDataStoreConnections(int index);
    /**
     *
     *
     * <pre>
     * Required. List of data stores to search.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getDataStoreConnectionsCount();
    /**
     *
     *
     * <pre>
     * Required. List of data stores to search.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder>
        getDataStoreConnectionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. List of data stores to search.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder
        getDataStoreConnectionsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Required. Fallback prompt configurations to use.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the fallbackPrompt field is set.
     */
    boolean hasFallbackPrompt();
    /**
     *
     *
     * <pre>
     * Required. Fallback prompt configurations to use.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The fallbackPrompt.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt getFallbackPrompt();
    /**
     *
     *
     * <pre>
     * Required. Fallback prompt configurations to use.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPromptOrBuilder
        getFallbackPromptOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A DataStoreTool is a way to provide specifications needed to search a
   * list of data stores.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool}
   */
  public static final class DataStoreTool extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool)
      DataStoreToolOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DataStoreTool.newBuilder() to construct.
    private DataStoreTool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DataStoreTool() {
      dataStoreConnections_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DataStoreTool();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_DataStoreTool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_DataStoreTool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.class,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.Builder.class);
    }

    public interface FallbackPromptOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt)
        com.google.protobuf.MessageOrBuilder {}
    /**
     *
     *
     * <pre>
     * A FallbackPrompt is a way to provide specifications for the Data Store
     * fallback prompt when generating responses.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt}
     */
    public static final class FallbackPrompt extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt)
        FallbackPromptOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FallbackPrompt.newBuilder() to construct.
      private FallbackPrompt(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FallbackPrompt() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FallbackPrompt();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_DataStoreTool_FallbackPrompt_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_DataStoreTool_FallbackPrompt_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt.Builder
                    .class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt other =
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A FallbackPrompt is a way to provide specifications for the Data Store
       * fallback prompt when generating responses.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt)
          com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPromptOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_DataStoreTool_FallbackPrompt_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_DataStoreTool_FallbackPrompt_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt.class,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_DataStoreTool_FallbackPrompt_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt build() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt result =
              new com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
                  .getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FallbackPrompt> PARSER =
          new com.google.protobuf.AbstractParser<FallbackPrompt>() {
            @java.lang.Override
            public FallbackPrompt parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FallbackPrompt> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FallbackPrompt> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int DATA_STORE_CONNECTIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>
        dataStoreConnections_;
    /**
     *
     *
     * <pre>
     * Required. List of data stores to search.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>
        getDataStoreConnectionsList() {
      return dataStoreConnections_;
    }
    /**
     *
     *
     * <pre>
     * Required. List of data stores to search.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder>
        getDataStoreConnectionsOrBuilderList() {
      return dataStoreConnections_;
    }
    /**
     *
     *
     * <pre>
     * Required. List of data stores to search.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getDataStoreConnectionsCount() {
      return dataStoreConnections_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. List of data stores to search.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection getDataStoreConnections(
        int index) {
      return dataStoreConnections_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. List of data stores to search.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder
        getDataStoreConnectionsOrBuilder(int index) {
      return dataStoreConnections_.get(index);
    }

    public static final int FALLBACK_PROMPT_FIELD_NUMBER = 3;
    private com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
        fallbackPrompt_;
    /**
     *
     *
     * <pre>
     * Required. Fallback prompt configurations to use.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the fallbackPrompt field is set.
     */
    @java.lang.Override
    public boolean hasFallbackPrompt() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Fallback prompt configurations to use.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The fallbackPrompt.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
        getFallbackPrompt() {
      return fallbackPrompt_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
              .getDefaultInstance()
          : fallbackPrompt_;
    }
    /**
     *
     *
     * <pre>
     * Required. Fallback prompt configurations to use.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPromptOrBuilder
        getFallbackPromptOrBuilder() {
      return fallbackPrompt_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
              .getDefaultInstance()
          : fallbackPrompt_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < dataStoreConnections_.size(); i++) {
        output.writeMessage(1, dataStoreConnections_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getFallbackPrompt());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < dataStoreConnections_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, dataStoreConnections_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFallbackPrompt());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool other =
          (com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool) obj;

      if (!getDataStoreConnectionsList().equals(other.getDataStoreConnectionsList())) return false;
      if (hasFallbackPrompt() != other.hasFallbackPrompt()) return false;
      if (hasFallbackPrompt()) {
        if (!getFallbackPrompt().equals(other.getFallbackPrompt())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDataStoreConnectionsCount() > 0) {
        hash = (37 * hash) + DATA_STORE_CONNECTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getDataStoreConnectionsList().hashCode();
      }
      if (hasFallbackPrompt()) {
        hash = (37 * hash) + FALLBACK_PROMPT_FIELD_NUMBER;
        hash = (53 * hash) + getFallbackPrompt().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A DataStoreTool is a way to provide specifications needed to search a
     * list of data stores.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool)
        com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreToolOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_DataStoreTool_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_DataStoreTool_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDataStoreConnectionsFieldBuilder();
          getFallbackPromptFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (dataStoreConnectionsBuilder_ == null) {
          dataStoreConnections_ = java.util.Collections.emptyList();
        } else {
          dataStoreConnections_ = null;
          dataStoreConnectionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        fallbackPrompt_ = null;
        if (fallbackPromptBuilder_ != null) {
          fallbackPromptBuilder_.dispose();
          fallbackPromptBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_DataStoreTool_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool build() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool result =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool result) {
        if (dataStoreConnectionsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            dataStoreConnections_ = java.util.Collections.unmodifiableList(dataStoreConnections_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.dataStoreConnections_ = dataStoreConnections_;
        } else {
          result.dataStoreConnections_ = dataStoreConnectionsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.fallbackPrompt_ =
              fallbackPromptBuilder_ == null ? fallbackPrompt_ : fallbackPromptBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool other) {
        if (other == com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.getDefaultInstance())
          return this;
        if (dataStoreConnectionsBuilder_ == null) {
          if (!other.dataStoreConnections_.isEmpty()) {
            if (dataStoreConnections_.isEmpty()) {
              dataStoreConnections_ = other.dataStoreConnections_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDataStoreConnectionsIsMutable();
              dataStoreConnections_.addAll(other.dataStoreConnections_);
            }
            onChanged();
          }
        } else {
          if (!other.dataStoreConnections_.isEmpty()) {
            if (dataStoreConnectionsBuilder_.isEmpty()) {
              dataStoreConnectionsBuilder_.dispose();
              dataStoreConnectionsBuilder_ = null;
              dataStoreConnections_ = other.dataStoreConnections_;
              bitField0_ = (bitField0_ & ~0x00000001);
              dataStoreConnectionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDataStoreConnectionsFieldBuilder()
                      : null;
            } else {
              dataStoreConnectionsBuilder_.addAllMessages(other.dataStoreConnections_);
            }
          }
        }
        if (other.hasFallbackPrompt()) {
          mergeFallbackPrompt(other.getFallbackPrompt());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.parser(),
                          extensionRegistry);
                  if (dataStoreConnectionsBuilder_ == null) {
                    ensureDataStoreConnectionsIsMutable();
                    dataStoreConnections_.add(m);
                  } else {
                    dataStoreConnectionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 26:
                {
                  input.readMessage(
                      getFallbackPromptFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>
          dataStoreConnections_ = java.util.Collections.emptyList();

      private void ensureDataStoreConnectionsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          dataStoreConnections_ =
              new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>(
                  dataStoreConnections_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection,
              com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder>
          dataStoreConnectionsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>
          getDataStoreConnectionsList() {
        if (dataStoreConnectionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dataStoreConnections_);
        } else {
          return dataStoreConnectionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getDataStoreConnectionsCount() {
        if (dataStoreConnectionsBuilder_ == null) {
          return dataStoreConnections_.size();
        } else {
          return dataStoreConnectionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection getDataStoreConnections(
          int index) {
        if (dataStoreConnectionsBuilder_ == null) {
          return dataStoreConnections_.get(index);
        } else {
          return dataStoreConnectionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDataStoreConnections(
          int index, com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection value) {
        if (dataStoreConnectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDataStoreConnectionsIsMutable();
          dataStoreConnections_.set(index, value);
          onChanged();
        } else {
          dataStoreConnectionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDataStoreConnections(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder builderForValue) {
        if (dataStoreConnectionsBuilder_ == null) {
          ensureDataStoreConnectionsIsMutable();
          dataStoreConnections_.set(index, builderForValue.build());
          onChanged();
        } else {
          dataStoreConnectionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDataStoreConnections(
          com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection value) {
        if (dataStoreConnectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDataStoreConnectionsIsMutable();
          dataStoreConnections_.add(value);
          onChanged();
        } else {
          dataStoreConnectionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDataStoreConnections(
          int index, com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection value) {
        if (dataStoreConnectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDataStoreConnectionsIsMutable();
          dataStoreConnections_.add(index, value);
          onChanged();
        } else {
          dataStoreConnectionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDataStoreConnections(
          com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder builderForValue) {
        if (dataStoreConnectionsBuilder_ == null) {
          ensureDataStoreConnectionsIsMutable();
          dataStoreConnections_.add(builderForValue.build());
          onChanged();
        } else {
          dataStoreConnectionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDataStoreConnections(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder builderForValue) {
        if (dataStoreConnectionsBuilder_ == null) {
          ensureDataStoreConnectionsIsMutable();
          dataStoreConnections_.add(index, builderForValue.build());
          onChanged();
        } else {
          dataStoreConnectionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllDataStoreConnections(
          java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection>
              values) {
        if (dataStoreConnectionsBuilder_ == null) {
          ensureDataStoreConnectionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataStoreConnections_);
          onChanged();
        } else {
          dataStoreConnectionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearDataStoreConnections() {
        if (dataStoreConnectionsBuilder_ == null) {
          dataStoreConnections_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          dataStoreConnectionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeDataStoreConnections(int index) {
        if (dataStoreConnectionsBuilder_ == null) {
          ensureDataStoreConnectionsIsMutable();
          dataStoreConnections_.remove(index);
          onChanged();
        } else {
          dataStoreConnectionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder
          getDataStoreConnectionsBuilder(int index) {
        return getDataStoreConnectionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder
          getDataStoreConnectionsOrBuilder(int index) {
        if (dataStoreConnectionsBuilder_ == null) {
          return dataStoreConnections_.get(index);
        } else {
          return dataStoreConnectionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder>
          getDataStoreConnectionsOrBuilderList() {
        if (dataStoreConnectionsBuilder_ != null) {
          return dataStoreConnectionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dataStoreConnections_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder
          addDataStoreConnectionsBuilder() {
        return getDataStoreConnectionsFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder
          addDataStoreConnectionsBuilder(int index) {
        return getDataStoreConnectionsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. List of data stores to search.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DataStoreConnection data_store_connections = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder>
          getDataStoreConnectionsBuilderList() {
        return getDataStoreConnectionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection,
              com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder>
          getDataStoreConnectionsFieldBuilder() {
        if (dataStoreConnectionsBuilder_ == null) {
          dataStoreConnectionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection,
                  com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnection.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionOrBuilder>(
                  dataStoreConnections_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          dataStoreConnections_ = null;
        }
        return dataStoreConnectionsBuilder_;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          fallbackPrompt_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPromptOrBuilder>
          fallbackPromptBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Fallback prompt configurations to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the fallbackPrompt field is set.
       */
      public boolean hasFallbackPrompt() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Fallback prompt configurations to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The fallbackPrompt.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
          getFallbackPrompt() {
        if (fallbackPromptBuilder_ == null) {
          return fallbackPrompt_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
                  .getDefaultInstance()
              : fallbackPrompt_;
        } else {
          return fallbackPromptBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Fallback prompt configurations to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFallbackPrompt(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt value) {
        if (fallbackPromptBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          fallbackPrompt_ = value;
        } else {
          fallbackPromptBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Fallback prompt configurations to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFallbackPrompt(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt.Builder
              builderForValue) {
        if (fallbackPromptBuilder_ == null) {
          fallbackPrompt_ = builderForValue.build();
        } else {
          fallbackPromptBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Fallback prompt configurations to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeFallbackPrompt(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt value) {
        if (fallbackPromptBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && fallbackPrompt_ != null
              && fallbackPrompt_
                  != com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
                      .getDefaultInstance()) {
            getFallbackPromptBuilder().mergeFrom(value);
          } else {
            fallbackPrompt_ = value;
          }
        } else {
          fallbackPromptBuilder_.mergeFrom(value);
        }
        if (fallbackPrompt_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Fallback prompt configurations to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearFallbackPrompt() {
        bitField0_ = (bitField0_ & ~0x00000002);
        fallbackPrompt_ = null;
        if (fallbackPromptBuilder_ != null) {
          fallbackPromptBuilder_.dispose();
          fallbackPromptBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Fallback prompt configurations to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt.Builder
          getFallbackPromptBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getFallbackPromptFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Fallback prompt configurations to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPromptOrBuilder
          getFallbackPromptOrBuilder() {
        if (fallbackPromptBuilder_ != null) {
          return fallbackPromptBuilder_.getMessageOrBuilder();
        } else {
          return fallbackPrompt_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt
                  .getDefaultInstance()
              : fallbackPrompt_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Fallback prompt configurations to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt fallback_prompt = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPromptOrBuilder>
          getFallbackPromptFieldBuilder() {
        if (fallbackPromptBuilder_ == null) {
          fallbackPromptBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.FallbackPrompt.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool
                      .FallbackPromptOrBuilder>(
                  getFallbackPrompt(), getParentForChildren(), isClean());
          fallbackPrompt_ = null;
        }
        return fallbackPromptBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataStoreTool> PARSER =
        new com.google.protobuf.AbstractParser<DataStoreTool>() {
          @java.lang.Override
          public DataStoreTool parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataStoreTool> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataStoreTool> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ExtensionToolOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The full name of the referenced vertex extension.
     * Formats:
     * `projects/{project}/locations/{location}/extensions/{extension}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The full name of the referenced vertex extension.
     * Formats:
     * `projects/{project}/locations/{location}/extensions/{extension}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * An ExtensionTool is a way to use Vertex Extensions as a tool.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool}
   */
  public static final class ExtensionTool extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool)
      ExtensionToolOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExtensionTool.newBuilder() to construct.
    private ExtensionTool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExtensionTool() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExtensionTool();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ExtensionTool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ExtensionTool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.class,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The full name of the referenced vertex extension.
     * Formats:
     * `projects/{project}/locations/{location}/extensions/{extension}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The full name of the referenced vertex extension.
     * Formats:
     * `projects/{project}/locations/{location}/extensions/{extension}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool other =
          (com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An ExtensionTool is a way to use Vertex Extensions as a tool.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool)
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionToolOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ExtensionTool_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ExtensionTool_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ExtensionTool_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool build() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool result =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool other) {
        if (other == com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The full name of the referenced vertex extension.
       * Formats:
       * `projects/{project}/locations/{location}/extensions/{extension}`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The full name of the referenced vertex extension.
       * Formats:
       * `projects/{project}/locations/{location}/extensions/{extension}`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The full name of the referenced vertex extension.
       * Formats:
       * `projects/{project}/locations/{location}/extensions/{extension}`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The full name of the referenced vertex extension.
       * Formats:
       * `projects/{project}/locations/{location}/extensions/{extension}`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The full name of the referenced vertex extension.
       * Formats:
       * `projects/{project}/locations/{location}/extensions/{extension}`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExtensionTool> PARSER =
        new com.google.protobuf.AbstractParser<ExtensionTool>() {
          @java.lang.Override
          public ExtensionTool parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExtensionTool> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExtensionTool> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FunctionToolOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The JSON schema is encapsulated in a
     * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
     * the function. This input is a JSON object that contains the function's
     * parameters as properties of the object.
     * </pre>
     *
     * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the inputSchema field is set.
     */
    boolean hasInputSchema();
    /**
     *
     *
     * <pre>
     * Optional. The JSON schema is encapsulated in a
     * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
     * the function. This input is a JSON object that contains the function's
     * parameters as properties of the object.
     * </pre>
     *
     * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The inputSchema.
     */
    com.google.protobuf.Struct getInputSchema();
    /**
     *
     *
     * <pre>
     * Optional. The JSON schema is encapsulated in a
     * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
     * the function. This input is a JSON object that contains the function's
     * parameters as properties of the object.
     * </pre>
     *
     * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.StructOrBuilder getInputSchemaOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. The JSON schema is encapsulated in a
     * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
     * of the function. This output is a JSON object that contains the
     * function's parameters as properties of the object.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the outputSchema field is set.
     */
    boolean hasOutputSchema();
    /**
     *
     *
     * <pre>
     * Optional. The JSON schema is encapsulated in a
     * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
     * of the function. This output is a JSON object that contains the
     * function's parameters as properties of the object.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The outputSchema.
     */
    com.google.protobuf.Struct getOutputSchema();
    /**
     *
     *
     * <pre>
     * Optional. The JSON schema is encapsulated in a
     * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
     * of the function. This output is a JSON object that contains the
     * function's parameters as properties of the object.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.StructOrBuilder getOutputSchemaOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A Function tool describes the functions to be invoked on the client side.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool}
   */
  public static final class FunctionTool extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool)
      FunctionToolOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FunctionTool.newBuilder() to construct.
    private FunctionTool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FunctionTool() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FunctionTool();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_FunctionTool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_FunctionTool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.class,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.Builder.class);
    }

    private int bitField0_;
    public static final int INPUT_SCHEMA_FIELD_NUMBER = 1;
    private com.google.protobuf.Struct inputSchema_;
    /**
     *
     *
     * <pre>
     * Optional. The JSON schema is encapsulated in a
     * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
     * the function. This input is a JSON object that contains the function's
     * parameters as properties of the object.
     * </pre>
     *
     * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the inputSchema field is set.
     */
    @java.lang.Override
    public boolean hasInputSchema() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The JSON schema is encapsulated in a
     * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
     * the function. This input is a JSON object that contains the function's
     * parameters as properties of the object.
     * </pre>
     *
     * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The inputSchema.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getInputSchema() {
      return inputSchema_ == null ? com.google.protobuf.Struct.getDefaultInstance() : inputSchema_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The JSON schema is encapsulated in a
     * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
     * the function. This input is a JSON object that contains the function's
     * parameters as properties of the object.
     * </pre>
     *
     * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getInputSchemaOrBuilder() {
      return inputSchema_ == null ? com.google.protobuf.Struct.getDefaultInstance() : inputSchema_;
    }

    public static final int OUTPUT_SCHEMA_FIELD_NUMBER = 2;
    private com.google.protobuf.Struct outputSchema_;
    /**
     *
     *
     * <pre>
     * Optional. The JSON schema is encapsulated in a
     * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
     * of the function. This output is a JSON object that contains the
     * function's parameters as properties of the object.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the outputSchema field is set.
     */
    @java.lang.Override
    public boolean hasOutputSchema() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The JSON schema is encapsulated in a
     * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
     * of the function. This output is a JSON object that contains the
     * function's parameters as properties of the object.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The outputSchema.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getOutputSchema() {
      return outputSchema_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : outputSchema_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The JSON schema is encapsulated in a
     * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
     * of the function. This output is a JSON object that contains the
     * function's parameters as properties of the object.
     * </pre>
     *
     * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getOutputSchemaOrBuilder() {
      return outputSchema_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : outputSchema_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getInputSchema());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getOutputSchema());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInputSchema());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOutputSchema());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool other =
          (com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool) obj;

      if (hasInputSchema() != other.hasInputSchema()) return false;
      if (hasInputSchema()) {
        if (!getInputSchema().equals(other.getInputSchema())) return false;
      }
      if (hasOutputSchema() != other.hasOutputSchema()) return false;
      if (hasOutputSchema()) {
        if (!getOutputSchema().equals(other.getOutputSchema())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasInputSchema()) {
        hash = (37 * hash) + INPUT_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getInputSchema().hashCode();
      }
      if (hasOutputSchema()) {
        hash = (37 * hash) + OUTPUT_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getOutputSchema().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A Function tool describes the functions to be invoked on the client side.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool)
        com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionToolOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_FunctionTool_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_FunctionTool_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getInputSchemaFieldBuilder();
          getOutputSchemaFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        inputSchema_ = null;
        if (inputSchemaBuilder_ != null) {
          inputSchemaBuilder_.dispose();
          inputSchemaBuilder_ = null;
        }
        outputSchema_ = null;
        if (outputSchemaBuilder_ != null) {
          outputSchemaBuilder_.dispose();
          outputSchemaBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_FunctionTool_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool build() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool result =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.inputSchema_ =
              inputSchemaBuilder_ == null ? inputSchema_ : inputSchemaBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.outputSchema_ =
              outputSchemaBuilder_ == null ? outputSchema_ : outputSchemaBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool other) {
        if (other == com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.getDefaultInstance())
          return this;
        if (other.hasInputSchema()) {
          mergeInputSchema(other.getInputSchema());
        }
        if (other.hasOutputSchema()) {
          mergeOutputSchema(other.getOutputSchema());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getInputSchemaFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getOutputSchemaFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Struct inputSchema_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          inputSchemaBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
       * the function. This input is a JSON object that contains the function's
       * parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the inputSchema field is set.
       */
      public boolean hasInputSchema() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
       * the function. This input is a JSON object that contains the function's
       * parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The inputSchema.
       */
      public com.google.protobuf.Struct getInputSchema() {
        if (inputSchemaBuilder_ == null) {
          return inputSchema_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : inputSchema_;
        } else {
          return inputSchemaBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
       * the function. This input is a JSON object that contains the function's
       * parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setInputSchema(com.google.protobuf.Struct value) {
        if (inputSchemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          inputSchema_ = value;
        } else {
          inputSchemaBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
       * the function. This input is a JSON object that contains the function's
       * parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setInputSchema(com.google.protobuf.Struct.Builder builderForValue) {
        if (inputSchemaBuilder_ == null) {
          inputSchema_ = builderForValue.build();
        } else {
          inputSchemaBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
       * the function. This input is a JSON object that contains the function's
       * parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeInputSchema(com.google.protobuf.Struct value) {
        if (inputSchemaBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && inputSchema_ != null
              && inputSchema_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getInputSchemaBuilder().mergeFrom(value);
          } else {
            inputSchema_ = value;
          }
        } else {
          inputSchemaBuilder_.mergeFrom(value);
        }
        if (inputSchema_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
       * the function. This input is a JSON object that contains the function's
       * parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearInputSchema() {
        bitField0_ = (bitField0_ & ~0x00000001);
        inputSchema_ = null;
        if (inputSchemaBuilder_ != null) {
          inputSchemaBuilder_.dispose();
          inputSchemaBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
       * the function. This input is a JSON object that contains the function's
       * parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Struct.Builder getInputSchemaBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getInputSchemaFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
       * the function. This input is a JSON object that contains the function's
       * parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.StructOrBuilder getInputSchemaOrBuilder() {
        if (inputSchemaBuilder_ != null) {
          return inputSchemaBuilder_.getMessageOrBuilder();
        } else {
          return inputSchema_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : inputSchema_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
       * the function. This input is a JSON object that contains the function's
       * parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct input_schema = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getInputSchemaFieldBuilder() {
        if (inputSchemaBuilder_ == null) {
          inputSchemaBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getInputSchema(), getParentForChildren(), isClean());
          inputSchema_ = null;
        }
        return inputSchemaBuilder_;
      }

      private com.google.protobuf.Struct outputSchema_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          outputSchemaBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
       * of the function. This output is a JSON object that contains the
       * function's parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the outputSchema field is set.
       */
      public boolean hasOutputSchema() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
       * of the function. This output is a JSON object that contains the
       * function's parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The outputSchema.
       */
      public com.google.protobuf.Struct getOutputSchema() {
        if (outputSchemaBuilder_ == null) {
          return outputSchema_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : outputSchema_;
        } else {
          return outputSchemaBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
       * of the function. This output is a JSON object that contains the
       * function's parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOutputSchema(com.google.protobuf.Struct value) {
        if (outputSchemaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          outputSchema_ = value;
        } else {
          outputSchemaBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
       * of the function. This output is a JSON object that contains the
       * function's parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOutputSchema(com.google.protobuf.Struct.Builder builderForValue) {
        if (outputSchemaBuilder_ == null) {
          outputSchema_ = builderForValue.build();
        } else {
          outputSchemaBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
       * of the function. This output is a JSON object that contains the
       * function's parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOutputSchema(com.google.protobuf.Struct value) {
        if (outputSchemaBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && outputSchema_ != null
              && outputSchema_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getOutputSchemaBuilder().mergeFrom(value);
          } else {
            outputSchema_ = value;
          }
        } else {
          outputSchemaBuilder_.mergeFrom(value);
        }
        if (outputSchema_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
       * of the function. This output is a JSON object that contains the
       * function's parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOutputSchema() {
        bitField0_ = (bitField0_ & ~0x00000002);
        outputSchema_ = null;
        if (outputSchemaBuilder_ != null) {
          outputSchemaBuilder_.dispose();
          outputSchemaBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
       * of the function. This output is a JSON object that contains the
       * function's parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Struct.Builder getOutputSchemaBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getOutputSchemaFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
       * of the function. This output is a JSON object that contains the
       * function's parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.StructOrBuilder getOutputSchemaOrBuilder() {
        if (outputSchemaBuilder_ != null) {
          return outputSchemaBuilder_.getMessageOrBuilder();
        } else {
          return outputSchema_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : outputSchema_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The JSON schema is encapsulated in a
       * [google.protobuf.Struct][google.protobuf.Struct] to describe the output
       * of the function. This output is a JSON object that contains the
       * function's parameters as properties of the object.
       * </pre>
       *
       * <code>.google.protobuf.Struct output_schema = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getOutputSchemaFieldBuilder() {
        if (outputSchemaBuilder_ == null) {
          outputSchemaBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getOutputSchema(), getParentForChildren(), isClean());
          outputSchema_ = null;
        }
        return outputSchemaBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FunctionTool> PARSER =
        new com.google.protobuf.AbstractParser<FunctionTool>() {
          @java.lang.Override
          public FunctionTool parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FunctionTool> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FunctionTool> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConnectorToolOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The full resource name of the referenced Integration Connectors
     * Connection. Format: `projects/&#42;&#47;locations/&#42;&#47;connections/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The full resource name of the referenced Integration Connectors
     * Connection. Format: `projects/&#42;&#47;locations/&#42;&#47;connections/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Required. Actions for the tool to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action>
        getActionsList();
    /**
     *
     *
     * <pre>
     * Required. Actions for the tool to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action getActions(int index);
    /**
     *
     *
     * <pre>
     * Required. Actions for the tool to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getActionsCount();
    /**
     *
     *
     * <pre>
     * Required. Actions for the tool to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.ActionOrBuilder>
        getActionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. Actions for the tool to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.ActionOrBuilder getActionsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Optional. Integration Connectors end-user authentication configuration.
     * If configured, the end-user authentication fields will be passed in the
     * Integration Connectors API request and override the admin, default
     * authentication configured for the Connection.
     * **Note**: The Connection must have authentication override enabled in
     * order to specify an EUC configuration here - otherwise, the ConnectorTool
     * creation will fail. See:
     * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the endUserAuthConfig field is set.
     */
    boolean hasEndUserAuthConfig();
    /**
     *
     *
     * <pre>
     * Optional. Integration Connectors end-user authentication configuration.
     * If configured, the end-user authentication fields will be passed in the
     * Integration Connectors API request and override the admin, default
     * authentication configured for the Connection.
     * **Note**: The Connection must have authentication override enabled in
     * order to specify an EUC configuration here - otherwise, the ConnectorTool
     * creation will fail. See:
     * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The endUserAuthConfig.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig getEndUserAuthConfig();
    /**
     *
     *
     * <pre>
     * Optional. Integration Connectors end-user authentication configuration.
     * If configured, the end-user authentication fields will be passed in the
     * Integration Connectors API request and override the admin, default
     * authentication configured for the Connection.
     * **Note**: The Connection must have authentication override enabled in
     * order to specify an EUC configuration here - otherwise, the ConnectorTool
     * creation will fail. See:
     * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfigOrBuilder
        getEndUserAuthConfigOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A ConnectorTool enabling using Integration Connectors Connections as tools.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool}
   */
  public static final class ConnectorTool extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool)
      ConnectorToolOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConnectorTool.newBuilder() to construct.
    private ConnectorTool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConnectorTool() {
      name_ = "";
      actions_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConnectorTool();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.class,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Builder.class);
    }

    public interface ActionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * ID of a Connection action for the tool to use.
       * </pre>
       *
       * <code>string connection_action_id = 4;</code>
       *
       * @return Whether the connectionActionId field is set.
       */
      boolean hasConnectionActionId();
      /**
       *
       *
       * <pre>
       * ID of a Connection action for the tool to use.
       * </pre>
       *
       * <code>string connection_action_id = 4;</code>
       *
       * @return The connectionActionId.
       */
      java.lang.String getConnectionActionId();
      /**
       *
       *
       * <pre>
       * ID of a Connection action for the tool to use.
       * </pre>
       *
       * <code>string connection_action_id = 4;</code>
       *
       * @return The bytes for connectionActionId.
       */
      com.google.protobuf.ByteString getConnectionActionIdBytes();

      /**
       *
       *
       * <pre>
       * Entity operation configuration for the tool to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
       * </code>
       *
       * @return Whether the entityOperation field is set.
       */
      boolean hasEntityOperation();
      /**
       *
       *
       * <pre>
       * Entity operation configuration for the tool to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
       * </code>
       *
       * @return The entityOperation.
       */
      com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
          getEntityOperation();
      /**
       *
       *
       * <pre>
       * Entity operation configuration for the tool to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
       * </code>
       */
      com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperationOrBuilder
          getEntityOperationOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. Entity fields to use as inputs for the operation.
       * If no fields are specified, all fields of the Entity will be used.
       * </pre>
       *
       * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the inputFields.
       */
      java.util.List<java.lang.String> getInputFieldsList();
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to use as inputs for the operation.
       * If no fields are specified, all fields of the Entity will be used.
       * </pre>
       *
       * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of inputFields.
       */
      int getInputFieldsCount();
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to use as inputs for the operation.
       * If no fields are specified, all fields of the Entity will be used.
       * </pre>
       *
       * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The inputFields at the given index.
       */
      java.lang.String getInputFields(int index);
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to use as inputs for the operation.
       * If no fields are specified, all fields of the Entity will be used.
       * </pre>
       *
       * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the inputFields at the given index.
       */
      com.google.protobuf.ByteString getInputFieldsBytes(int index);

      /**
       *
       *
       * <pre>
       * Optional. Entity fields to return from the operation.
       * If no fields are specified, all fields of the Entity will be returned.
       * </pre>
       *
       * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the outputFields.
       */
      java.util.List<java.lang.String> getOutputFieldsList();
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to return from the operation.
       * If no fields are specified, all fields of the Entity will be returned.
       * </pre>
       *
       * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of outputFields.
       */
      int getOutputFieldsCount();
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to return from the operation.
       * If no fields are specified, all fields of the Entity will be returned.
       * </pre>
       *
       * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The outputFields at the given index.
       */
      java.lang.String getOutputFields(int index);
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to return from the operation.
       * If no fields are specified, all fields of the Entity will be returned.
       * </pre>
       *
       * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the outputFields at the given index.
       */
      com.google.protobuf.ByteString getOutputFieldsBytes(int index);

      com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.ActionSpecCase
          getActionSpecCase();
    }
    /**
     *
     *
     * <pre>
     * Configuration of a Connection operation for the tool to use.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action}
     */
    public static final class Action extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action)
        ActionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Action.newBuilder() to construct.
      private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Action() {
        inputFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
        outputFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Action();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_Action_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_Action_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.Builder.class);
      }

      public interface EntityOperationOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. ID of the entity.
         * </pre>
         *
         * <code>string entity_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The entityId.
         */
        java.lang.String getEntityId();
        /**
         *
         *
         * <pre>
         * Required. ID of the entity.
         * </pre>
         *
         * <code>string entity_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for entityId.
         */
        com.google.protobuf.ByteString getEntityIdBytes();

        /**
         *
         *
         * <pre>
         * Required. Operation to perform on the entity.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType operation = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for operation.
         */
        int getOperationValue();
        /**
         *
         *
         * <pre>
         * Required. Operation to perform on the entity.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType operation = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The operation.
         */
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                .OperationType
            getOperation();
      }
      /**
       *
       *
       * <pre>
       * Entity CRUD operation specification.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation}
       */
      public static final class EntityOperation extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation)
          EntityOperationOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use EntityOperation.newBuilder() to construct.
        private EntityOperation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private EntityOperation() {
          entityId_ = "";
          operation_ = 0;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new EntityOperation();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_Action_EntityOperation_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_Action_EntityOperation_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                      .class,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                      .Builder.class);
        }

        /**
         *
         *
         * <pre>
         * The operation to perform on the entity.
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType}
         */
        public enum OperationType implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * Operation type unspecified. Invalid, ConnectorTool create/update
           * will fail.
           * </pre>
           *
           * <code>OPERATION_TYPE_UNSPECIFIED = 0;</code>
           */
          OPERATION_TYPE_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * List operation.
           * </pre>
           *
           * <code>LIST = 1;</code>
           */
          LIST(1),
          /**
           *
           *
           * <pre>
           * Get operation.
           * </pre>
           *
           * <code>GET = 2;</code>
           */
          GET(2),
          /**
           *
           *
           * <pre>
           * Create operation.
           * </pre>
           *
           * <code>CREATE = 3;</code>
           */
          CREATE(3),
          /**
           *
           *
           * <pre>
           * Update operation.
           * </pre>
           *
           * <code>UPDATE = 4;</code>
           */
          UPDATE(4),
          /**
           *
           *
           * <pre>
           * Delete operation.
           * </pre>
           *
           * <code>DELETE = 5;</code>
           */
          DELETE(5),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * Operation type unspecified. Invalid, ConnectorTool create/update
           * will fail.
           * </pre>
           *
           * <code>OPERATION_TYPE_UNSPECIFIED = 0;</code>
           */
          public static final int OPERATION_TYPE_UNSPECIFIED_VALUE = 0;
          /**
           *
           *
           * <pre>
           * List operation.
           * </pre>
           *
           * <code>LIST = 1;</code>
           */
          public static final int LIST_VALUE = 1;
          /**
           *
           *
           * <pre>
           * Get operation.
           * </pre>
           *
           * <code>GET = 2;</code>
           */
          public static final int GET_VALUE = 2;
          /**
           *
           *
           * <pre>
           * Create operation.
           * </pre>
           *
           * <code>CREATE = 3;</code>
           */
          public static final int CREATE_VALUE = 3;
          /**
           *
           *
           * <pre>
           * Update operation.
           * </pre>
           *
           * <code>UPDATE = 4;</code>
           */
          public static final int UPDATE_VALUE = 4;
          /**
           *
           *
           * <pre>
           * Delete operation.
           * </pre>
           *
           * <code>DELETE = 5;</code>
           */
          public static final int DELETE_VALUE = 5;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static OperationType valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static OperationType forNumber(int value) {
            switch (value) {
              case 0:
                return OPERATION_TYPE_UNSPECIFIED;
              case 1:
                return LIST;
              case 2:
                return GET;
              case 3:
                return CREATE;
              case 4:
                return UPDATE;
              case 5:
                return DELETE;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<OperationType>
              internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<OperationType>
              internalValueMap =
                  new com.google.protobuf.Internal.EnumLiteMap<OperationType>() {
                    public OperationType findValueByNumber(int number) {
                      return OperationType.forNumber(number);
                    }
                  };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                .getDescriptor()
                .getEnumTypes()
                .get(0);
          }

          private static final OperationType[] VALUES = values();

          public static OperationType valueOf(
              com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private OperationType(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType)
        }

        public static final int ENTITY_ID_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object entityId_ = "";
        /**
         *
         *
         * <pre>
         * Required. ID of the entity.
         * </pre>
         *
         * <code>string entity_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The entityId.
         */
        @java.lang.Override
        public java.lang.String getEntityId() {
          java.lang.Object ref = entityId_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            entityId_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. ID of the entity.
         * </pre>
         *
         * <code>string entity_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for entityId.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getEntityIdBytes() {
          java.lang.Object ref = entityId_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            entityId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int OPERATION_FIELD_NUMBER = 2;
        private int operation_ = 0;
        /**
         *
         *
         * <pre>
         * Required. Operation to perform on the entity.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType operation = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for operation.
         */
        @java.lang.Override
        public int getOperationValue() {
          return operation_;
        }
        /**
         *
         *
         * <pre>
         * Required. Operation to perform on the entity.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType operation = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The operation.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                .OperationType
            getOperation() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                  .OperationType
              result =
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                      .OperationType.forNumber(operation_);
          return result == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                  .OperationType.UNRECOGNIZED
              : result;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityId_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, entityId_);
          }
          if (operation_
              != com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                  .OperationType.OPERATION_TYPE_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(2, operation_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityId_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, entityId_);
          }
          if (operation_
              != com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                  .OperationType.OPERATION_TYPE_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, operation_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation)) {
            return super.equals(obj);
          }
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation other =
              (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation)
                  obj;

          if (!getEntityId().equals(other.getEntityId())) return false;
          if (operation_ != other.operation_) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + ENTITY_ID_FIELD_NUMBER;
          hash = (53 * hash) + getEntityId().hashCode();
          hash = (37 * hash) + OPERATION_FIELD_NUMBER;
          hash = (53 * hash) + operation_;
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Entity CRUD operation specification.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation)
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperationOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
                .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_Action_EntityOperation_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
                .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_Action_EntityOperation_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                        .class,
                    com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                        .Builder.class);
          }

          // Construct using
          // com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            entityId_ = "";
            operation_ = 0;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
                .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_Action_EntityOperation_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
              getDefaultInstanceForType() {
            return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
              build() {
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
              buildPartial() {
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                result =
                    new com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                        .EntityOperation(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.entityId_ = entityId_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.operation_ = operation_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation) {
              return mergeFrom(
                  (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                  other) {
            if (other
                == com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                    .getDefaultInstance()) return this;
            if (!other.getEntityId().isEmpty()) {
              entityId_ = other.entityId_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (other.operation_ != 0) {
              setOperationValue(other.getOperationValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      entityId_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 16:
                    {
                      operation_ = input.readEnum();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 16
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object entityId_ = "";
          /**
           *
           *
           * <pre>
           * Required. ID of the entity.
           * </pre>
           *
           * <code>string entity_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The entityId.
           */
          public java.lang.String getEntityId() {
            java.lang.Object ref = entityId_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              entityId_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. ID of the entity.
           * </pre>
           *
           * <code>string entity_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The bytes for entityId.
           */
          public com.google.protobuf.ByteString getEntityIdBytes() {
            java.lang.Object ref = entityId_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              entityId_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. ID of the entity.
           * </pre>
           *
           * <code>string entity_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The entityId to set.
           * @return This builder for chaining.
           */
          public Builder setEntityId(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            entityId_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. ID of the entity.
           * </pre>
           *
           * <code>string entity_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearEntityId() {
            entityId_ = getDefaultInstance().getEntityId();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. ID of the entity.
           * </pre>
           *
           * <code>string entity_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes for entityId to set.
           * @return This builder for chaining.
           */
          public Builder setEntityIdBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            entityId_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private int operation_ = 0;
          /**
           *
           *
           * <pre>
           * Required. Operation to perform on the entity.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType operation = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The enum numeric value on the wire for operation.
           */
          @java.lang.Override
          public int getOperationValue() {
            return operation_;
          }
          /**
           *
           *
           * <pre>
           * Required. Operation to perform on the entity.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType operation = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @param value The enum numeric value on the wire for operation to set.
           * @return This builder for chaining.
           */
          public Builder setOperationValue(int value) {
            operation_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Operation to perform on the entity.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType operation = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return The operation.
           */
          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                  .OperationType
              getOperation() {
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                    .OperationType
                result =
                    com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                        .OperationType.forNumber(operation_);
            return result == null
                ? com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                    .OperationType.UNRECOGNIZED
                : result;
          }
          /**
           *
           *
           * <pre>
           * Required. Operation to perform on the entity.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType operation = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @param value The operation to set.
           * @return This builder for chaining.
           */
          public Builder setOperation(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                      .OperationType
                  value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000002;
            operation_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Operation to perform on the entity.
           * </pre>
           *
           * <code>
           * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType operation = 2 [(.google.api.field_behavior) = REQUIRED];
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearOperation() {
            bitField0_ = (bitField0_ & ~0x00000002);
            operation_ = 0;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation)
        private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                  .EntityOperation();
        }

        public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperation
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<EntityOperation> PARSER =
            new com.google.protobuf.AbstractParser<EntityOperation>() {
              @java.lang.Override
              public EntityOperation parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<EntityOperation> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<EntityOperation> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int actionSpecCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object actionSpec_;

      public enum ActionSpecCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        CONNECTION_ACTION_ID(4),
        ENTITY_OPERATION(5),
        ACTIONSPEC_NOT_SET(0);
        private final int value;

        private ActionSpecCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ActionSpecCase valueOf(int value) {
          return forNumber(value);
        }

        public static ActionSpecCase forNumber(int value) {
          switch (value) {
            case 4:
              return CONNECTION_ACTION_ID;
            case 5:
              return ENTITY_OPERATION;
            case 0:
              return ACTIONSPEC_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public ActionSpecCase getActionSpecCase() {
        return ActionSpecCase.forNumber(actionSpecCase_);
      }

      public static final int CONNECTION_ACTION_ID_FIELD_NUMBER = 4;
      /**
       *
       *
       * <pre>
       * ID of a Connection action for the tool to use.
       * </pre>
       *
       * <code>string connection_action_id = 4;</code>
       *
       * @return Whether the connectionActionId field is set.
       */
      public boolean hasConnectionActionId() {
        return actionSpecCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * ID of a Connection action for the tool to use.
       * </pre>
       *
       * <code>string connection_action_id = 4;</code>
       *
       * @return The connectionActionId.
       */
      public java.lang.String getConnectionActionId() {
        java.lang.Object ref = "";
        if (actionSpecCase_ == 4) {
          ref = actionSpec_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (actionSpecCase_ == 4) {
            actionSpec_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * ID of a Connection action for the tool to use.
       * </pre>
       *
       * <code>string connection_action_id = 4;</code>
       *
       * @return The bytes for connectionActionId.
       */
      public com.google.protobuf.ByteString getConnectionActionIdBytes() {
        java.lang.Object ref = "";
        if (actionSpecCase_ == 4) {
          ref = actionSpec_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (actionSpecCase_ == 4) {
            actionSpec_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ENTITY_OPERATION_FIELD_NUMBER = 5;
      /**
       *
       *
       * <pre>
       * Entity operation configuration for the tool to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
       * </code>
       *
       * @return Whether the entityOperation field is set.
       */
      @java.lang.Override
      public boolean hasEntityOperation() {
        return actionSpecCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * Entity operation configuration for the tool to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
       * </code>
       *
       * @return The entityOperation.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
          getEntityOperation() {
        if (actionSpecCase_ == 5) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation)
              actionSpec_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
            .getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Entity operation configuration for the tool to use.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
              .EntityOperationOrBuilder
          getEntityOperationOrBuilder() {
        if (actionSpecCase_ == 5) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation)
              actionSpec_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
            .getDefaultInstance();
      }

      public static final int INPUT_FIELDS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList inputFields_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to use as inputs for the operation.
       * If no fields are specified, all fields of the Entity will be used.
       * </pre>
       *
       * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the inputFields.
       */
      public com.google.protobuf.ProtocolStringList getInputFieldsList() {
        return inputFields_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to use as inputs for the operation.
       * If no fields are specified, all fields of the Entity will be used.
       * </pre>
       *
       * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of inputFields.
       */
      public int getInputFieldsCount() {
        return inputFields_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to use as inputs for the operation.
       * If no fields are specified, all fields of the Entity will be used.
       * </pre>
       *
       * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The inputFields at the given index.
       */
      public java.lang.String getInputFields(int index) {
        return inputFields_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to use as inputs for the operation.
       * If no fields are specified, all fields of the Entity will be used.
       * </pre>
       *
       * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the inputFields at the given index.
       */
      public com.google.protobuf.ByteString getInputFieldsBytes(int index) {
        return inputFields_.getByteString(index);
      }

      public static final int OUTPUT_FIELDS_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList outputFields_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to return from the operation.
       * If no fields are specified, all fields of the Entity will be returned.
       * </pre>
       *
       * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the outputFields.
       */
      public com.google.protobuf.ProtocolStringList getOutputFieldsList() {
        return outputFields_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to return from the operation.
       * If no fields are specified, all fields of the Entity will be returned.
       * </pre>
       *
       * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of outputFields.
       */
      public int getOutputFieldsCount() {
        return outputFields_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to return from the operation.
       * If no fields are specified, all fields of the Entity will be returned.
       * </pre>
       *
       * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The outputFields at the given index.
       */
      public java.lang.String getOutputFields(int index) {
        return outputFields_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Entity fields to return from the operation.
       * If no fields are specified, all fields of the Entity will be returned.
       * </pre>
       *
       * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the outputFields at the given index.
       */
      public com.google.protobuf.ByteString getOutputFieldsBytes(int index) {
        return outputFields_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < inputFields_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, inputFields_.getRaw(i));
        }
        for (int i = 0; i < outputFields_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, outputFields_.getRaw(i));
        }
        if (actionSpecCase_ == 4) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, actionSpec_);
        }
        if (actionSpecCase_ == 5) {
          output.writeMessage(
              5,
              (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation)
                  actionSpec_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < inputFields_.size(); i++) {
            dataSize += computeStringSizeNoTag(inputFields_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getInputFieldsList().size();
        }
        {
          int dataSize = 0;
          for (int i = 0; i < outputFields_.size(); i++) {
            dataSize += computeStringSizeNoTag(outputFields_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getOutputFieldsList().size();
        }
        if (actionSpecCase_ == 4) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, actionSpec_);
        }
        if (actionSpecCase_ == 5) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  5,
                  (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation)
                      actionSpec_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action other =
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action) obj;

        if (!getInputFieldsList().equals(other.getInputFieldsList())) return false;
        if (!getOutputFieldsList().equals(other.getOutputFieldsList())) return false;
        if (!getActionSpecCase().equals(other.getActionSpecCase())) return false;
        switch (actionSpecCase_) {
          case 4:
            if (!getConnectionActionId().equals(other.getConnectionActionId())) return false;
            break;
          case 5:
            if (!getEntityOperation().equals(other.getEntityOperation())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getInputFieldsCount() > 0) {
          hash = (37 * hash) + INPUT_FIELDS_FIELD_NUMBER;
          hash = (53 * hash) + getInputFieldsList().hashCode();
        }
        if (getOutputFieldsCount() > 0) {
          hash = (37 * hash) + OUTPUT_FIELDS_FIELD_NUMBER;
          hash = (53 * hash) + getOutputFieldsList().hashCode();
        }
        switch (actionSpecCase_) {
          case 4:
            hash = (37 * hash) + CONNECTION_ACTION_ID_FIELD_NUMBER;
            hash = (53 * hash) + getConnectionActionId().hashCode();
            break;
          case 5:
            hash = (37 * hash) + ENTITY_OPERATION_FIELD_NUMBER;
            hash = (53 * hash) + getEntityOperation().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Configuration of a Connection operation for the tool to use.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action)
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.ActionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_Action_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_Action_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.class,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (entityOperationBuilder_ != null) {
            entityOperationBuilder_.clear();
          }
          inputFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
          outputFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
          actionSpecCase_ = 0;
          actionSpec_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_Action_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action build() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action result =
              new com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            inputFields_.makeImmutable();
            result.inputFields_ = inputFields_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            outputFields_.makeImmutable();
            result.outputFields_ = outputFields_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action result) {
          result.actionSpecCase_ = actionSpecCase_;
          result.actionSpec_ = this.actionSpec_;
          if (actionSpecCase_ == 5 && entityOperationBuilder_ != null) {
            result.actionSpec_ = entityOperationBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                  .getDefaultInstance()) return this;
          if (!other.inputFields_.isEmpty()) {
            if (inputFields_.isEmpty()) {
              inputFields_ = other.inputFields_;
              bitField0_ |= 0x00000004;
            } else {
              ensureInputFieldsIsMutable();
              inputFields_.addAll(other.inputFields_);
            }
            onChanged();
          }
          if (!other.outputFields_.isEmpty()) {
            if (outputFields_.isEmpty()) {
              outputFields_ = other.outputFields_;
              bitField0_ |= 0x00000008;
            } else {
              ensureOutputFieldsIsMutable();
              outputFields_.addAll(other.outputFields_);
            }
            onChanged();
          }
          switch (other.getActionSpecCase()) {
            case CONNECTION_ACTION_ID:
              {
                actionSpecCase_ = 4;
                actionSpec_ = other.actionSpec_;
                onChanged();
                break;
              }
            case ENTITY_OPERATION:
              {
                mergeEntityOperation(other.getEntityOperation());
                break;
              }
            case ACTIONSPEC_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureInputFieldsIsMutable();
                    inputFields_.add(s);
                    break;
                  } // case 18
                case 26:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureOutputFieldsIsMutable();
                    outputFields_.add(s);
                    break;
                  } // case 26
                case 34:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    actionSpecCase_ = 4;
                    actionSpec_ = s;
                    break;
                  } // case 34
                case 42:
                  {
                    input.readMessage(
                        getEntityOperationFieldBuilder().getBuilder(), extensionRegistry);
                    actionSpecCase_ = 5;
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int actionSpecCase_ = 0;
        private java.lang.Object actionSpec_;

        public ActionSpecCase getActionSpecCase() {
          return ActionSpecCase.forNumber(actionSpecCase_);
        }

        public Builder clearActionSpec() {
          actionSpecCase_ = 0;
          actionSpec_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * ID of a Connection action for the tool to use.
         * </pre>
         *
         * <code>string connection_action_id = 4;</code>
         *
         * @return Whether the connectionActionId field is set.
         */
        @java.lang.Override
        public boolean hasConnectionActionId() {
          return actionSpecCase_ == 4;
        }
        /**
         *
         *
         * <pre>
         * ID of a Connection action for the tool to use.
         * </pre>
         *
         * <code>string connection_action_id = 4;</code>
         *
         * @return The connectionActionId.
         */
        @java.lang.Override
        public java.lang.String getConnectionActionId() {
          java.lang.Object ref = "";
          if (actionSpecCase_ == 4) {
            ref = actionSpec_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (actionSpecCase_ == 4) {
              actionSpec_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * ID of a Connection action for the tool to use.
         * </pre>
         *
         * <code>string connection_action_id = 4;</code>
         *
         * @return The bytes for connectionActionId.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getConnectionActionIdBytes() {
          java.lang.Object ref = "";
          if (actionSpecCase_ == 4) {
            ref = actionSpec_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (actionSpecCase_ == 4) {
              actionSpec_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * ID of a Connection action for the tool to use.
         * </pre>
         *
         * <code>string connection_action_id = 4;</code>
         *
         * @param value The connectionActionId to set.
         * @return This builder for chaining.
         */
        public Builder setConnectionActionId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          actionSpecCase_ = 4;
          actionSpec_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * ID of a Connection action for the tool to use.
         * </pre>
         *
         * <code>string connection_action_id = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearConnectionActionId() {
          if (actionSpecCase_ == 4) {
            actionSpecCase_ = 0;
            actionSpec_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * ID of a Connection action for the tool to use.
         * </pre>
         *
         * <code>string connection_action_id = 4;</code>
         *
         * @param value The bytes for connectionActionId to set.
         * @return This builder for chaining.
         */
        public Builder setConnectionActionIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          actionSpecCase_ = 4;
          actionSpec_ = value;
          onChanged();
          return this;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                    .Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                    .EntityOperationOrBuilder>
            entityOperationBuilder_;
        /**
         *
         *
         * <pre>
         * Entity operation configuration for the tool to use.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
         * </code>
         *
         * @return Whether the entityOperation field is set.
         */
        @java.lang.Override
        public boolean hasEntityOperation() {
          return actionSpecCase_ == 5;
        }
        /**
         *
         *
         * <pre>
         * Entity operation configuration for the tool to use.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
         * </code>
         *
         * @return The entityOperation.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
            getEntityOperation() {
          if (entityOperationBuilder_ == null) {
            if (actionSpecCase_ == 5) {
              return (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                      .EntityOperation)
                  actionSpec_;
            }
            return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                .getDefaultInstance();
          } else {
            if (actionSpecCase_ == 5) {
              return entityOperationBuilder_.getMessage();
            }
            return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Entity operation configuration for the tool to use.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
         * </code>
         */
        public Builder setEntityOperation(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                value) {
          if (entityOperationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            actionSpec_ = value;
            onChanged();
          } else {
            entityOperationBuilder_.setMessage(value);
          }
          actionSpecCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Entity operation configuration for the tool to use.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
         * </code>
         */
        public Builder setEntityOperation(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation.Builder
                builderForValue) {
          if (entityOperationBuilder_ == null) {
            actionSpec_ = builderForValue.build();
            onChanged();
          } else {
            entityOperationBuilder_.setMessage(builderForValue.build());
          }
          actionSpecCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Entity operation configuration for the tool to use.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
         * </code>
         */
        public Builder mergeEntityOperation(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                value) {
          if (entityOperationBuilder_ == null) {
            if (actionSpecCase_ == 5
                && actionSpec_
                    != com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                        .EntityOperation.getDefaultInstance()) {
              actionSpec_ =
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                      .newBuilder(
                          (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                                  .EntityOperation)
                              actionSpec_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              actionSpec_ = value;
            }
            onChanged();
          } else {
            if (actionSpecCase_ == 5) {
              entityOperationBuilder_.mergeFrom(value);
            } else {
              entityOperationBuilder_.setMessage(value);
            }
          }
          actionSpecCase_ = 5;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Entity operation configuration for the tool to use.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
         * </code>
         */
        public Builder clearEntityOperation() {
          if (entityOperationBuilder_ == null) {
            if (actionSpecCase_ == 5) {
              actionSpecCase_ = 0;
              actionSpec_ = null;
              onChanged();
            }
          } else {
            if (actionSpecCase_ == 5) {
              actionSpecCase_ = 0;
              actionSpec_ = null;
            }
            entityOperationBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Entity operation configuration for the tool to use.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                .Builder
            getEntityOperationBuilder() {
          return getEntityOperationFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Entity operation configuration for the tool to use.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                .EntityOperationOrBuilder
            getEntityOperationOrBuilder() {
          if ((actionSpecCase_ == 5) && (entityOperationBuilder_ != null)) {
            return entityOperationBuilder_.getMessageOrBuilder();
          } else {
            if (actionSpecCase_ == 5) {
              return (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                      .EntityOperation)
                  actionSpec_;
            }
            return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Entity operation configuration for the tool to use.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation entity_operation = 5;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                    .Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                    .EntityOperationOrBuilder>
            getEntityOperationFieldBuilder() {
          if (entityOperationBuilder_ == null) {
            if (!(actionSpecCase_ == 5)) {
              actionSpec_ =
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                      .getDefaultInstance();
            }
            entityOperationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                        .EntityOperation,
                    com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.EntityOperation
                        .Builder,
                    com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                        .EntityOperationOrBuilder>(
                    (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                            .EntityOperation)
                        actionSpec_,
                    getParentForChildren(),
                    isClean());
            actionSpec_ = null;
          }
          actionSpecCase_ = 5;
          onChanged();
          return entityOperationBuilder_;
        }

        private com.google.protobuf.LazyStringArrayList inputFields_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureInputFieldsIsMutable() {
          if (!inputFields_.isModifiable()) {
            inputFields_ = new com.google.protobuf.LazyStringArrayList(inputFields_);
          }
          bitField0_ |= 0x00000004;
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to use as inputs for the operation.
         * If no fields are specified, all fields of the Entity will be used.
         * </pre>
         *
         * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the inputFields.
         */
        public com.google.protobuf.ProtocolStringList getInputFieldsList() {
          inputFields_.makeImmutable();
          return inputFields_;
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to use as inputs for the operation.
         * If no fields are specified, all fields of the Entity will be used.
         * </pre>
         *
         * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of inputFields.
         */
        public int getInputFieldsCount() {
          return inputFields_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to use as inputs for the operation.
         * If no fields are specified, all fields of the Entity will be used.
         * </pre>
         *
         * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The inputFields at the given index.
         */
        public java.lang.String getInputFields(int index) {
          return inputFields_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to use as inputs for the operation.
         * If no fields are specified, all fields of the Entity will be used.
         * </pre>
         *
         * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the inputFields at the given index.
         */
        public com.google.protobuf.ByteString getInputFieldsBytes(int index) {
          return inputFields_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to use as inputs for the operation.
         * If no fields are specified, all fields of the Entity will be used.
         * </pre>
         *
         * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The inputFields to set.
         * @return This builder for chaining.
         */
        public Builder setInputFields(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInputFieldsIsMutable();
          inputFields_.set(index, value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to use as inputs for the operation.
         * If no fields are specified, all fields of the Entity will be used.
         * </pre>
         *
         * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The inputFields to add.
         * @return This builder for chaining.
         */
        public Builder addInputFields(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInputFieldsIsMutable();
          inputFields_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to use as inputs for the operation.
         * If no fields are specified, all fields of the Entity will be used.
         * </pre>
         *
         * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The inputFields to add.
         * @return This builder for chaining.
         */
        public Builder addAllInputFields(java.lang.Iterable<java.lang.String> values) {
          ensureInputFieldsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inputFields_);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to use as inputs for the operation.
         * If no fields are specified, all fields of the Entity will be used.
         * </pre>
         *
         * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearInputFields() {
          inputFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to use as inputs for the operation.
         * If no fields are specified, all fields of the Entity will be used.
         * </pre>
         *
         * <code>repeated string input_fields = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the inputFields to add.
         * @return This builder for chaining.
         */
        public Builder addInputFieldsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureInputFieldsIsMutable();
          inputFields_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList outputFields_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureOutputFieldsIsMutable() {
          if (!outputFields_.isModifiable()) {
            outputFields_ = new com.google.protobuf.LazyStringArrayList(outputFields_);
          }
          bitField0_ |= 0x00000008;
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to return from the operation.
         * If no fields are specified, all fields of the Entity will be returned.
         * </pre>
         *
         * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the outputFields.
         */
        public com.google.protobuf.ProtocolStringList getOutputFieldsList() {
          outputFields_.makeImmutable();
          return outputFields_;
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to return from the operation.
         * If no fields are specified, all fields of the Entity will be returned.
         * </pre>
         *
         * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of outputFields.
         */
        public int getOutputFieldsCount() {
          return outputFields_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to return from the operation.
         * If no fields are specified, all fields of the Entity will be returned.
         * </pre>
         *
         * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The outputFields at the given index.
         */
        public java.lang.String getOutputFields(int index) {
          return outputFields_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to return from the operation.
         * If no fields are specified, all fields of the Entity will be returned.
         * </pre>
         *
         * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the outputFields at the given index.
         */
        public com.google.protobuf.ByteString getOutputFieldsBytes(int index) {
          return outputFields_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to return from the operation.
         * If no fields are specified, all fields of the Entity will be returned.
         * </pre>
         *
         * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The outputFields to set.
         * @return This builder for chaining.
         */
        public Builder setOutputFields(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOutputFieldsIsMutable();
          outputFields_.set(index, value);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to return from the operation.
         * If no fields are specified, all fields of the Entity will be returned.
         * </pre>
         *
         * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The outputFields to add.
         * @return This builder for chaining.
         */
        public Builder addOutputFields(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureOutputFieldsIsMutable();
          outputFields_.add(value);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to return from the operation.
         * If no fields are specified, all fields of the Entity will be returned.
         * </pre>
         *
         * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The outputFields to add.
         * @return This builder for chaining.
         */
        public Builder addAllOutputFields(java.lang.Iterable<java.lang.String> values) {
          ensureOutputFieldsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, outputFields_);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to return from the operation.
         * If no fields are specified, all fields of the Entity will be returned.
         * </pre>
         *
         * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOutputFields() {
          outputFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Entity fields to return from the operation.
         * If no fields are specified, all fields of the Entity will be returned.
         * </pre>
         *
         * <code>repeated string output_fields = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the outputFields to add.
         * @return This builder for chaining.
         */
        public Builder addOutputFieldsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureOutputFieldsIsMutable();
          outputFields_.add(value);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Action> PARSER =
          new com.google.protobuf.AbstractParser<Action>() {
            @java.lang.Override
            public Action parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Action> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Action> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The full resource name of the referenced Integration Connectors
     * Connection. Format: `projects/&#42;&#47;locations/&#42;&#47;connections/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The full resource name of the referenced Integration Connectors
     * Connection. Format: `projects/&#42;&#47;locations/&#42;&#47;connections/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ACTIONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action>
        actions_;
    /**
     *
     *
     * <pre>
     * Required. Actions for the tool to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action>
        getActionsList() {
      return actions_;
    }
    /**
     *
     *
     * <pre>
     * Required. Actions for the tool to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.ActionOrBuilder>
        getActionsOrBuilderList() {
      return actions_;
    }
    /**
     *
     *
     * <pre>
     * Required. Actions for the tool to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getActionsCount() {
      return actions_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Actions for the tool to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action getActions(int index) {
      return actions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Actions for the tool to use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.ActionOrBuilder
        getActionsOrBuilder(int index) {
      return actions_.get(index);
    }

    public static final int END_USER_AUTH_CONFIG_FIELD_NUMBER = 3;
    private com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig endUserAuthConfig_;
    /**
     *
     *
     * <pre>
     * Optional. Integration Connectors end-user authentication configuration.
     * If configured, the end-user authentication fields will be passed in the
     * Integration Connectors API request and override the admin, default
     * authentication configured for the Connection.
     * **Note**: The Connection must have authentication override enabled in
     * order to specify an EUC configuration here - otherwise, the ConnectorTool
     * creation will fail. See:
     * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the endUserAuthConfig field is set.
     */
    @java.lang.Override
    public boolean hasEndUserAuthConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Integration Connectors end-user authentication configuration.
     * If configured, the end-user authentication fields will be passed in the
     * Integration Connectors API request and override the admin, default
     * authentication configured for the Connection.
     * **Note**: The Connection must have authentication override enabled in
     * order to specify an EUC configuration here - otherwise, the ConnectorTool
     * creation will fail. See:
     * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The endUserAuthConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig getEndUserAuthConfig() {
      return endUserAuthConfig_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.getDefaultInstance()
          : endUserAuthConfig_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Integration Connectors end-user authentication configuration.
     * If configured, the end-user authentication fields will be passed in the
     * Integration Connectors API request and override the admin, default
     * authentication configured for the Connection.
     * **Note**: The Connection must have authentication override enabled in
     * order to specify an EUC configuration here - otherwise, the ConnectorTool
     * creation will fail. See:
     * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfigOrBuilder
        getEndUserAuthConfigOrBuilder() {
      return endUserAuthConfig_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.getDefaultInstance()
          : endUserAuthConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      for (int i = 0; i < actions_.size(); i++) {
        output.writeMessage(2, actions_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getEndUserAuthConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      for (int i = 0; i < actions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, actions_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEndUserAuthConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool other =
          (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getActionsList().equals(other.getActionsList())) return false;
      if (hasEndUserAuthConfig() != other.hasEndUserAuthConfig()) return false;
      if (hasEndUserAuthConfig()) {
        if (!getEndUserAuthConfig().equals(other.getEndUserAuthConfig())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (getActionsCount() > 0) {
        hash = (37 * hash) + ACTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getActionsList().hashCode();
      }
      if (hasEndUserAuthConfig()) {
        hash = (37 * hash) + END_USER_AUTH_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getEndUserAuthConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A ConnectorTool enabling using Integration Connectors Connections as tools.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool)
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorToolOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getActionsFieldBuilder();
          getEndUserAuthConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        if (actionsBuilder_ == null) {
          actions_ = java.util.Collections.emptyList();
        } else {
          actions_ = null;
          actionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        endUserAuthConfig_ = null;
        if (endUserAuthConfigBuilder_ != null) {
          endUserAuthConfigBuilder_.dispose();
          endUserAuthConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ConnectorTool_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool build() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool result =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool result) {
        if (actionsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            actions_ = java.util.Collections.unmodifiableList(actions_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.actions_ = actions_;
        } else {
          result.actions_ = actionsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.endUserAuthConfig_ =
              endUserAuthConfigBuilder_ == null
                  ? endUserAuthConfig_
                  : endUserAuthConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool other) {
        if (other == com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (actionsBuilder_ == null) {
          if (!other.actions_.isEmpty()) {
            if (actions_.isEmpty()) {
              actions_ = other.actions_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureActionsIsMutable();
              actions_.addAll(other.actions_);
            }
            onChanged();
          }
        } else {
          if (!other.actions_.isEmpty()) {
            if (actionsBuilder_.isEmpty()) {
              actionsBuilder_.dispose();
              actionsBuilder_ = null;
              actions_ = other.actions_;
              bitField0_ = (bitField0_ & ~0x00000002);
              actionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getActionsFieldBuilder()
                      : null;
            } else {
              actionsBuilder_.addAllMessages(other.actions_);
            }
          }
        }
        if (other.hasEndUserAuthConfig()) {
          mergeEndUserAuthConfig(other.getEndUserAuthConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.parser(),
                          extensionRegistry);
                  if (actionsBuilder_ == null) {
                    ensureActionsIsMutable();
                    actions_.add(m);
                  } else {
                    actionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getEndUserAuthConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The full resource name of the referenced Integration Connectors
       * Connection. Format: `projects/&#42;&#47;locations/&#42;&#47;connections/&#42;`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The full resource name of the referenced Integration Connectors
       * Connection. Format: `projects/&#42;&#47;locations/&#42;&#47;connections/&#42;`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The full resource name of the referenced Integration Connectors
       * Connection. Format: `projects/&#42;&#47;locations/&#42;&#47;connections/&#42;`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The full resource name of the referenced Integration Connectors
       * Connection. Format: `projects/&#42;&#47;locations/&#42;&#47;connections/&#42;`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The full resource name of the referenced Integration Connectors
       * Connection. Format: `projects/&#42;&#47;locations/&#42;&#47;connections/&#42;`
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action>
          actions_ = java.util.Collections.emptyList();

      private void ensureActionsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          actions_ =
              new java.util.ArrayList<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action>(actions_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.ActionOrBuilder>
          actionsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action>
          getActionsList() {
        if (actionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(actions_);
        } else {
          return actionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getActionsCount() {
        if (actionsBuilder_ == null) {
          return actions_.size();
        } else {
          return actionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action getActions(
          int index) {
        if (actionsBuilder_ == null) {
          return actions_.get(index);
        } else {
          return actionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setActions(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action value) {
        if (actionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActionsIsMutable();
          actions_.set(index, value);
          onChanged();
        } else {
          actionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setActions(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.Builder
              builderForValue) {
        if (actionsBuilder_ == null) {
          ensureActionsIsMutable();
          actions_.set(index, builderForValue.build());
          onChanged();
        } else {
          actionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addActions(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action value) {
        if (actionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActionsIsMutable();
          actions_.add(value);
          onChanged();
        } else {
          actionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addActions(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action value) {
        if (actionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActionsIsMutable();
          actions_.add(index, value);
          onChanged();
        } else {
          actionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addActions(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.Builder
              builderForValue) {
        if (actionsBuilder_ == null) {
          ensureActionsIsMutable();
          actions_.add(builderForValue.build());
          onChanged();
        } else {
          actionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addActions(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.Builder
              builderForValue) {
        if (actionsBuilder_ == null) {
          ensureActionsIsMutable();
          actions_.add(index, builderForValue.build());
          onChanged();
        } else {
          actionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllActions(
          java.lang.Iterable<
                  ? extends com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action>
              values) {
        if (actionsBuilder_ == null) {
          ensureActionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, actions_);
          onChanged();
        } else {
          actionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearActions() {
        if (actionsBuilder_ == null) {
          actions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          actionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeActions(int index) {
        if (actionsBuilder_ == null) {
          ensureActionsIsMutable();
          actions_.remove(index);
          onChanged();
        } else {
          actionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.Builder
          getActionsBuilder(int index) {
        return getActionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.ActionOrBuilder
          getActionsOrBuilder(int index) {
        if (actionsBuilder_ == null) {
          return actions_.get(index);
        } else {
          return actionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.ActionOrBuilder>
          getActionsOrBuilderList() {
        if (actionsBuilder_ != null) {
          return actionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(actions_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.Builder
          addActionsBuilder() {
        return getActionsFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.Builder
          addActionsBuilder(int index) {
        return getActionsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. Actions for the tool to use.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.Builder>
          getActionsBuilderList() {
        return getActionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.ActionOrBuilder>
          getActionsFieldBuilder() {
        if (actionsBuilder_ == null) {
          actionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Action.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.ActionOrBuilder>(
                  actions_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          actions_ = null;
        }
        return actionsBuilder_;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig endUserAuthConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfigOrBuilder>
          endUserAuthConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Integration Connectors end-user authentication configuration.
       * If configured, the end-user authentication fields will be passed in the
       * Integration Connectors API request and override the admin, default
       * authentication configured for the Connection.
       * **Note**: The Connection must have authentication override enabled in
       * order to specify an EUC configuration here - otherwise, the ConnectorTool
       * creation will fail. See:
       * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the endUserAuthConfig field is set.
       */
      public boolean hasEndUserAuthConfig() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Integration Connectors end-user authentication configuration.
       * If configured, the end-user authentication fields will be passed in the
       * Integration Connectors API request and override the admin, default
       * authentication configured for the Connection.
       * **Note**: The Connection must have authentication override enabled in
       * order to specify an EUC configuration here - otherwise, the ConnectorTool
       * creation will fail. See:
       * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The endUserAuthConfig.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig getEndUserAuthConfig() {
        if (endUserAuthConfigBuilder_ == null) {
          return endUserAuthConfig_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.getDefaultInstance()
              : endUserAuthConfig_;
        } else {
          return endUserAuthConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Integration Connectors end-user authentication configuration.
       * If configured, the end-user authentication fields will be passed in the
       * Integration Connectors API request and override the admin, default
       * authentication configured for the Connection.
       * **Note**: The Connection must have authentication override enabled in
       * order to specify an EUC configuration here - otherwise, the ConnectorTool
       * creation will fail. See:
       * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEndUserAuthConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig value) {
        if (endUserAuthConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endUserAuthConfig_ = value;
        } else {
          endUserAuthConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Integration Connectors end-user authentication configuration.
       * If configured, the end-user authentication fields will be passed in the
       * Integration Connectors API request and override the admin, default
       * authentication configured for the Connection.
       * **Note**: The Connection must have authentication override enabled in
       * order to specify an EUC configuration here - otherwise, the ConnectorTool
       * creation will fail. See:
       * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEndUserAuthConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Builder builderForValue) {
        if (endUserAuthConfigBuilder_ == null) {
          endUserAuthConfig_ = builderForValue.build();
        } else {
          endUserAuthConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Integration Connectors end-user authentication configuration.
       * If configured, the end-user authentication fields will be passed in the
       * Integration Connectors API request and override the admin, default
       * authentication configured for the Connection.
       * **Note**: The Connection must have authentication override enabled in
       * order to specify an EUC configuration here - otherwise, the ConnectorTool
       * creation will fail. See:
       * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeEndUserAuthConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig value) {
        if (endUserAuthConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && endUserAuthConfig_ != null
              && endUserAuthConfig_
                  != com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                      .getDefaultInstance()) {
            getEndUserAuthConfigBuilder().mergeFrom(value);
          } else {
            endUserAuthConfig_ = value;
          }
        } else {
          endUserAuthConfigBuilder_.mergeFrom(value);
        }
        if (endUserAuthConfig_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Integration Connectors end-user authentication configuration.
       * If configured, the end-user authentication fields will be passed in the
       * Integration Connectors API request and override the admin, default
       * authentication configured for the Connection.
       * **Note**: The Connection must have authentication override enabled in
       * order to specify an EUC configuration here - otherwise, the ConnectorTool
       * creation will fail. See:
       * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearEndUserAuthConfig() {
        bitField0_ = (bitField0_ & ~0x00000004);
        endUserAuthConfig_ = null;
        if (endUserAuthConfigBuilder_ != null) {
          endUserAuthConfigBuilder_.dispose();
          endUserAuthConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Integration Connectors end-user authentication configuration.
       * If configured, the end-user authentication fields will be passed in the
       * Integration Connectors API request and override the admin, default
       * authentication configured for the Connection.
       * **Note**: The Connection must have authentication override enabled in
       * order to specify an EUC configuration here - otherwise, the ConnectorTool
       * creation will fail. See:
       * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Builder
          getEndUserAuthConfigBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getEndUserAuthConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Integration Connectors end-user authentication configuration.
       * If configured, the end-user authentication fields will be passed in the
       * Integration Connectors API request and override the admin, default
       * authentication configured for the Connection.
       * **Note**: The Connection must have authentication override enabled in
       * order to specify an EUC configuration here - otherwise, the ConnectorTool
       * creation will fail. See:
       * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfigOrBuilder
          getEndUserAuthConfigOrBuilder() {
        if (endUserAuthConfigBuilder_ != null) {
          return endUserAuthConfigBuilder_.getMessageOrBuilder();
        } else {
          return endUserAuthConfig_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.getDefaultInstance()
              : endUserAuthConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Integration Connectors end-user authentication configuration.
       * If configured, the end-user authentication fields will be passed in the
       * Integration Connectors API request and override the admin, default
       * authentication configured for the Connection.
       * **Note**: The Connection must have authentication override enabled in
       * order to specify an EUC configuration here - otherwise, the ConnectorTool
       * creation will fail. See:
       * https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig end_user_auth_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfigOrBuilder>
          getEndUserAuthConfigFieldBuilder() {
        if (endUserAuthConfigBuilder_ == null) {
          endUserAuthConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfigOrBuilder>(
                  getEndUserAuthConfig(), getParentForChildren(), isClean());
          endUserAuthConfig_ = null;
        }
        return endUserAuthConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConnectorTool> PARSER =
        new com.google.protobuf.AbstractParser<ConnectorTool>() {
          @java.lang.Override
          public ConnectorTool parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConnectorTool> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConnectorTool> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AuthenticationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
     * </code>
     *
     * @return Whether the apiKeyConfig field is set.
     */
    boolean hasApiKeyConfig();
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
     * </code>
     *
     * @return The apiKeyConfig.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig getApiKeyConfig();
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfigOrBuilder
        getApiKeyConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Config for OAuth.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
     * </code>
     *
     * @return Whether the oauthConfig field is set.
     */
    boolean hasOauthConfig();
    /**
     *
     *
     * <pre>
     * Config for OAuth.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
     * </code>
     *
     * @return The oauthConfig.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig getOauthConfig();
    /**
     *
     *
     * <pre>
     * Config for OAuth.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfigOrBuilder
        getOauthConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Config for [Diglogflow service
     * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
     * auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
     * </code>
     *
     * @return Whether the serviceAgentAuthConfig field is set.
     */
    boolean hasServiceAgentAuthConfig();
    /**
     *
     *
     * <pre>
     * Config for [Diglogflow service
     * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
     * auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
     * </code>
     *
     * @return The serviceAgentAuthConfig.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
        getServiceAgentAuthConfig();
    /**
     *
     *
     * <pre>
     * Config for [Diglogflow service
     * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
     * auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfigOrBuilder
        getServiceAgentAuthConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Config for bearer token auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
     * </code>
     *
     * @return Whether the bearerTokenConfig field is set.
     */
    boolean hasBearerTokenConfig();
    /**
     *
     *
     * <pre>
     * Config for bearer token auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
     * </code>
     *
     * @return The bearerTokenConfig.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
        getBearerTokenConfig();
    /**
     *
     *
     * <pre>
     * Config for bearer token auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfigOrBuilder
        getBearerTokenConfigOrBuilder();

    com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.AuthConfigCase getAuthConfigCase();
  }
  /**
   *
   *
   * <pre>
   * Authentication information required for API calls
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.Authentication}
   */
  public static final class Authentication extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication)
      AuthenticationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Authentication.newBuilder() to construct.
    private Authentication(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Authentication() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Authentication();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.class,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The location of the API key in the request.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation}
     */
    public enum RequestLocation implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>REQUEST_LOCATION_UNSPECIFIED = 0;</code>
       */
      REQUEST_LOCATION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Represents the key in http header.
       * </pre>
       *
       * <code>HEADER = 1;</code>
       */
      HEADER(1),
      /**
       *
       *
       * <pre>
       * Represents the key in query string.
       * </pre>
       *
       * <code>QUERY_STRING = 2;</code>
       */
      QUERY_STRING(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>REQUEST_LOCATION_UNSPECIFIED = 0;</code>
       */
      public static final int REQUEST_LOCATION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Represents the key in http header.
       * </pre>
       *
       * <code>HEADER = 1;</code>
       */
      public static final int HEADER_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Represents the key in query string.
       * </pre>
       *
       * <code>QUERY_STRING = 2;</code>
       */
      public static final int QUERY_STRING_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RequestLocation valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static RequestLocation forNumber(int value) {
        switch (value) {
          case 0:
            return REQUEST_LOCATION_UNSPECIFIED;
          case 1:
            return HEADER;
          case 2:
            return QUERY_STRING;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<RequestLocation>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<RequestLocation>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<RequestLocation>() {
                public RequestLocation findValueByNumber(int number) {
                  return RequestLocation.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final RequestLocation[] VALUES = values();

      public static RequestLocation valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private RequestLocation(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation)
    }

    public interface ApiKeyConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The parameter name or the header name of the API key.
       * E.g., If the API request is "https://example.com/act?X-Api-Key=&lt;API
       * KEY&gt;", "X-Api-Key" would be the parameter name.
       * </pre>
       *
       * <code>string key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The keyName.
       */
      java.lang.String getKeyName();
      /**
       *
       *
       * <pre>
       * Required. The parameter name or the header name of the API key.
       * E.g., If the API request is "https://example.com/act?X-Api-Key=&lt;API
       * KEY&gt;", "X-Api-Key" would be the parameter name.
       * </pre>
       *
       * <code>string key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for keyName.
       */
      com.google.protobuf.ByteString getKeyNameBytes();

      /**
       *
       *
       * <pre>
       * Optional. The API key. If the `secret_version_for_api_key` field is
       * set, this field will be ignored.
       * </pre>
       *
       * <code>string api_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The apiKey.
       */
      java.lang.String getApiKey();
      /**
       *
       *
       * <pre>
       * Optional. The API key. If the `secret_version_for_api_key` field is
       * set, this field will be ignored.
       * </pre>
       *
       * <code>string api_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for apiKey.
       */
      com.google.protobuf.ByteString getApiKeyBytes();

      /**
       *
       *
       * <pre>
       * Required. Key location in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation request_location = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for requestLocation.
       */
      int getRequestLocationValue();
      /**
       *
       *
       * <pre>
       * Required. Key location in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation request_location = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The requestLocation.
       */
      com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation
          getRequestLocation();
    }
    /**
     *
     *
     * <pre>
     * Config for authentication with API key.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig}
     */
    public static final class ApiKeyConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)
        ApiKeyConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ApiKeyConfig.newBuilder() to construct.
      private ApiKeyConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ApiKeyConfig() {
        keyName_ = "";
        apiKey_ = "";
        requestLocation_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ApiKeyConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_ApiKeyConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_ApiKeyConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig.Builder
                    .class);
      }

      public static final int KEY_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object keyName_ = "";
      /**
       *
       *
       * <pre>
       * Required. The parameter name or the header name of the API key.
       * E.g., If the API request is "https://example.com/act?X-Api-Key=&lt;API
       * KEY&gt;", "X-Api-Key" would be the parameter name.
       * </pre>
       *
       * <code>string key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The keyName.
       */
      @java.lang.Override
      public java.lang.String getKeyName() {
        java.lang.Object ref = keyName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          keyName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The parameter name or the header name of the API key.
       * E.g., If the API request is "https://example.com/act?X-Api-Key=&lt;API
       * KEY&gt;", "X-Api-Key" would be the parameter name.
       * </pre>
       *
       * <code>string key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for keyName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getKeyNameBytes() {
        java.lang.Object ref = keyName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          keyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int API_KEY_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object apiKey_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The API key. If the `secret_version_for_api_key` field is
       * set, this field will be ignored.
       * </pre>
       *
       * <code>string api_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The apiKey.
       */
      @java.lang.Override
      public java.lang.String getApiKey() {
        java.lang.Object ref = apiKey_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          apiKey_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The API key. If the `secret_version_for_api_key` field is
       * set, this field will be ignored.
       * </pre>
       *
       * <code>string api_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for apiKey.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getApiKeyBytes() {
        java.lang.Object ref = apiKey_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          apiKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int REQUEST_LOCATION_FIELD_NUMBER = 3;
      private int requestLocation_ = 0;
      /**
       *
       *
       * <pre>
       * Required. Key location in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation request_location = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for requestLocation.
       */
      @java.lang.Override
      public int getRequestLocationValue() {
        return requestLocation_;
      }
      /**
       *
       *
       * <pre>
       * Required. Key location in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation request_location = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The requestLocation.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation
          getRequestLocation() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation result =
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation.forNumber(
                requestLocation_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation
                .UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, keyName_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiKey_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, apiKey_);
        }
        if (requestLocation_
            != com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation
                .REQUEST_LOCATION_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(3, requestLocation_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, keyName_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(apiKey_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, apiKey_);
        }
        if (requestLocation_
            != com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation
                .REQUEST_LOCATION_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, requestLocation_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig other =
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig) obj;

        if (!getKeyName().equals(other.getKeyName())) return false;
        if (!getApiKey().equals(other.getApiKey())) return false;
        if (requestLocation_ != other.requestLocation_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + KEY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getKeyName().hashCode();
        hash = (37 * hash) + API_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getApiKey().hashCode();
        hash = (37 * hash) + REQUEST_LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + requestLocation_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Config for authentication with API key.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_ApiKeyConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_ApiKeyConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig.class,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          keyName_ = "";
          apiKey_ = "";
          requestLocation_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_ApiKeyConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig build() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig result =
              new com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.keyName_ = keyName_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.apiKey_ = apiKey_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.requestLocation_ = requestLocation_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
                  .getDefaultInstance()) return this;
          if (!other.getKeyName().isEmpty()) {
            keyName_ = other.keyName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getApiKey().isEmpty()) {
            apiKey_ = other.apiKey_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (other.requestLocation_ != 0) {
            setRequestLocationValue(other.getRequestLocationValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    keyName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    apiKey_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 24:
                  {
                    requestLocation_ = input.readEnum();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object keyName_ = "";
        /**
         *
         *
         * <pre>
         * Required. The parameter name or the header name of the API key.
         * E.g., If the API request is "https://example.com/act?X-Api-Key=&lt;API
         * KEY&gt;", "X-Api-Key" would be the parameter name.
         * </pre>
         *
         * <code>string key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The keyName.
         */
        public java.lang.String getKeyName() {
          java.lang.Object ref = keyName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            keyName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The parameter name or the header name of the API key.
         * E.g., If the API request is "https://example.com/act?X-Api-Key=&lt;API
         * KEY&gt;", "X-Api-Key" would be the parameter name.
         * </pre>
         *
         * <code>string key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for keyName.
         */
        public com.google.protobuf.ByteString getKeyNameBytes() {
          java.lang.Object ref = keyName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            keyName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The parameter name or the header name of the API key.
         * E.g., If the API request is "https://example.com/act?X-Api-Key=&lt;API
         * KEY&gt;", "X-Api-Key" would be the parameter name.
         * </pre>
         *
         * <code>string key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The keyName to set.
         * @return This builder for chaining.
         */
        public Builder setKeyName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          keyName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The parameter name or the header name of the API key.
         * E.g., If the API request is "https://example.com/act?X-Api-Key=&lt;API
         * KEY&gt;", "X-Api-Key" would be the parameter name.
         * </pre>
         *
         * <code>string key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearKeyName() {
          keyName_ = getDefaultInstance().getKeyName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The parameter name or the header name of the API key.
         * E.g., If the API request is "https://example.com/act?X-Api-Key=&lt;API
         * KEY&gt;", "X-Api-Key" would be the parameter name.
         * </pre>
         *
         * <code>string key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for keyName to set.
         * @return This builder for chaining.
         */
        public Builder setKeyNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          keyName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object apiKey_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The API key. If the `secret_version_for_api_key` field is
         * set, this field will be ignored.
         * </pre>
         *
         * <code>string api_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The apiKey.
         */
        public java.lang.String getApiKey() {
          java.lang.Object ref = apiKey_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            apiKey_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The API key. If the `secret_version_for_api_key` field is
         * set, this field will be ignored.
         * </pre>
         *
         * <code>string api_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for apiKey.
         */
        public com.google.protobuf.ByteString getApiKeyBytes() {
          java.lang.Object ref = apiKey_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            apiKey_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The API key. If the `secret_version_for_api_key` field is
         * set, this field will be ignored.
         * </pre>
         *
         * <code>string api_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The apiKey to set.
         * @return This builder for chaining.
         */
        public Builder setApiKey(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          apiKey_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The API key. If the `secret_version_for_api_key` field is
         * set, this field will be ignored.
         * </pre>
         *
         * <code>string api_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearApiKey() {
          apiKey_ = getDefaultInstance().getApiKey();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The API key. If the `secret_version_for_api_key` field is
         * set, this field will be ignored.
         * </pre>
         *
         * <code>string api_key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for apiKey to set.
         * @return This builder for chaining.
         */
        public Builder setApiKeyBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          apiKey_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private int requestLocation_ = 0;
        /**
         *
         *
         * <pre>
         * Required. Key location in the request.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation request_location = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for requestLocation.
         */
        @java.lang.Override
        public int getRequestLocationValue() {
          return requestLocation_;
        }
        /**
         *
         *
         * <pre>
         * Required. Key location in the request.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation request_location = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The enum numeric value on the wire for requestLocation to set.
         * @return This builder for chaining.
         */
        public Builder setRequestLocationValue(int value) {
          requestLocation_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Key location in the request.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation request_location = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The requestLocation.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation
            getRequestLocation() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation result =
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation.forNumber(
                  requestLocation_);
          return result == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation
                  .UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Required. Key location in the request.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation request_location = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The requestLocation to set.
         * @return This builder for chaining.
         */
        public Builder setRequestLocation(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000004;
          requestLocation_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Key location in the request.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.RequestLocation request_location = 3 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRequestLocation() {
          bitField0_ = (bitField0_ & ~0x00000004);
          requestLocation_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ApiKeyConfig> PARSER =
          new com.google.protobuf.AbstractParser<ApiKeyConfig>() {
            @java.lang.Override
            public ApiKeyConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ApiKeyConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ApiKeyConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface OAuthConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. OAuth grant types.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType oauth_grant_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for oauthGrantType.
       */
      int getOauthGrantTypeValue();
      /**
       *
       *
       * <pre>
       * Required. OAuth grant types.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType oauth_grant_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The oauthGrantType.
       */
      com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType
          getOauthGrantType();

      /**
       *
       *
       * <pre>
       * Required. The client ID from the OAuth provider.
       * </pre>
       *
       * <code>string client_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The clientId.
       */
      java.lang.String getClientId();
      /**
       *
       *
       * <pre>
       * Required. The client ID from the OAuth provider.
       * </pre>
       *
       * <code>string client_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for clientId.
       */
      com.google.protobuf.ByteString getClientIdBytes();

      /**
       *
       *
       * <pre>
       * Optional. The client secret from the OAuth provider. If the
       * `secret_version_for_client_secret` field is set, this field will be
       * ignored.
       * </pre>
       *
       * <code>string client_secret = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The clientSecret.
       */
      java.lang.String getClientSecret();
      /**
       *
       *
       * <pre>
       * Optional. The client secret from the OAuth provider. If the
       * `secret_version_for_client_secret` field is set, this field will be
       * ignored.
       * </pre>
       *
       * <code>string client_secret = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for clientSecret.
       */
      com.google.protobuf.ByteString getClientSecretBytes();

      /**
       *
       *
       * <pre>
       * Required. The token endpoint in the OAuth provider to exchange for an
       * access token.
       * </pre>
       *
       * <code>string token_endpoint = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The tokenEndpoint.
       */
      java.lang.String getTokenEndpoint();
      /**
       *
       *
       * <pre>
       * Required. The token endpoint in the OAuth provider to exchange for an
       * access token.
       * </pre>
       *
       * <code>string token_endpoint = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for tokenEndpoint.
       */
      com.google.protobuf.ByteString getTokenEndpointBytes();

      /**
       *
       *
       * <pre>
       * Optional. The OAuth scopes to grant.
       * </pre>
       *
       * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the scopes.
       */
      java.util.List<java.lang.String> getScopesList();
      /**
       *
       *
       * <pre>
       * Optional. The OAuth scopes to grant.
       * </pre>
       *
       * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of scopes.
       */
      int getScopesCount();
      /**
       *
       *
       * <pre>
       * Optional. The OAuth scopes to grant.
       * </pre>
       *
       * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The scopes at the given index.
       */
      java.lang.String getScopes(int index);
      /**
       *
       *
       * <pre>
       * Optional. The OAuth scopes to grant.
       * </pre>
       *
       * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the scopes at the given index.
       */
      com.google.protobuf.ByteString getScopesBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * Config for authentication with OAuth.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig}
     */
    public static final class OAuthConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig)
        OAuthConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use OAuthConfig.newBuilder() to construct.
      private OAuthConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private OAuthConfig() {
        oauthGrantType_ = 0;
        clientId_ = "";
        clientSecret_ = "";
        tokenEndpoint_ = "";
        scopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new OAuthConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_OAuthConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_OAuthConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.Builder
                    .class);
      }

      /**
       *
       *
       * <pre>
       * OAuth grant types. Only [client credential
       * grant](https://oauth.net/2/grant-types/client-credentials) is
       * supported.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType}
       */
      public enum OauthGrantType implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Default value. This value is unused.
         * </pre>
         *
         * <code>OAUTH_GRANT_TYPE_UNSPECIFIED = 0;</code>
         */
        OAUTH_GRANT_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Represents the [client credential
         * flow](https://oauth.net/2/grant-types/client-credentials).
         * </pre>
         *
         * <code>CLIENT_CREDENTIAL = 1;</code>
         */
        CLIENT_CREDENTIAL(1),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Default value. This value is unused.
         * </pre>
         *
         * <code>OAUTH_GRANT_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int OAUTH_GRANT_TYPE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Represents the [client credential
         * flow](https://oauth.net/2/grant-types/client-credentials).
         * </pre>
         *
         * <code>CLIENT_CREDENTIAL = 1;</code>
         */
        public static final int CLIENT_CREDENTIAL_VALUE = 1;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static OauthGrantType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static OauthGrantType forNumber(int value) {
          switch (value) {
            case 0:
              return OAUTH_GRANT_TYPE_UNSPECIFIED;
            case 1:
              return CLIENT_CREDENTIAL;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<OauthGrantType>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<OauthGrantType>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<OauthGrantType>() {
                  public OauthGrantType findValueByNumber(int number) {
                    return OauthGrantType.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
              .getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final OauthGrantType[] VALUES = values();

        public static OauthGrantType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private OauthGrantType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType)
      }

      public static final int OAUTH_GRANT_TYPE_FIELD_NUMBER = 1;
      private int oauthGrantType_ = 0;
      /**
       *
       *
       * <pre>
       * Required. OAuth grant types.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType oauth_grant_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for oauthGrantType.
       */
      @java.lang.Override
      public int getOauthGrantTypeValue() {
        return oauthGrantType_;
      }
      /**
       *
       *
       * <pre>
       * Required. OAuth grant types.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType oauth_grant_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The oauthGrantType.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType
          getOauthGrantType() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType
            result =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
                    .OauthGrantType.forNumber(oauthGrantType_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType
                .UNRECOGNIZED
            : result;
      }

      public static final int CLIENT_ID_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object clientId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The client ID from the OAuth provider.
       * </pre>
       *
       * <code>string client_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The clientId.
       */
      @java.lang.Override
      public java.lang.String getClientId() {
        java.lang.Object ref = clientId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clientId_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The client ID from the OAuth provider.
       * </pre>
       *
       * <code>string client_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for clientId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getClientIdBytes() {
        java.lang.Object ref = clientId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          clientId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CLIENT_SECRET_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object clientSecret_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The client secret from the OAuth provider. If the
       * `secret_version_for_client_secret` field is set, this field will be
       * ignored.
       * </pre>
       *
       * <code>string client_secret = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The clientSecret.
       */
      @java.lang.Override
      public java.lang.String getClientSecret() {
        java.lang.Object ref = clientSecret_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clientSecret_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The client secret from the OAuth provider. If the
       * `secret_version_for_client_secret` field is set, this field will be
       * ignored.
       * </pre>
       *
       * <code>string client_secret = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for clientSecret.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getClientSecretBytes() {
        java.lang.Object ref = clientSecret_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          clientSecret_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int TOKEN_ENDPOINT_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object tokenEndpoint_ = "";
      /**
       *
       *
       * <pre>
       * Required. The token endpoint in the OAuth provider to exchange for an
       * access token.
       * </pre>
       *
       * <code>string token_endpoint = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The tokenEndpoint.
       */
      @java.lang.Override
      public java.lang.String getTokenEndpoint() {
        java.lang.Object ref = tokenEndpoint_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tokenEndpoint_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The token endpoint in the OAuth provider to exchange for an
       * access token.
       * </pre>
       *
       * <code>string token_endpoint = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for tokenEndpoint.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTokenEndpointBytes() {
        java.lang.Object ref = tokenEndpoint_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tokenEndpoint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SCOPES_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList scopes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Optional. The OAuth scopes to grant.
       * </pre>
       *
       * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the scopes.
       */
      public com.google.protobuf.ProtocolStringList getScopesList() {
        return scopes_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The OAuth scopes to grant.
       * </pre>
       *
       * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of scopes.
       */
      public int getScopesCount() {
        return scopes_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. The OAuth scopes to grant.
       * </pre>
       *
       * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The scopes at the given index.
       */
      public java.lang.String getScopes(int index) {
        return scopes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The OAuth scopes to grant.
       * </pre>
       *
       * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the scopes at the given index.
       */
      public com.google.protobuf.ByteString getScopesBytes(int index) {
        return scopes_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (oauthGrantType_
            != com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType
                .OAUTH_GRANT_TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, oauthGrantType_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, clientId_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientSecret_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, clientSecret_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tokenEndpoint_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, tokenEndpoint_);
        }
        for (int i = 0; i < scopes_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, scopes_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (oauthGrantType_
            != com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType
                .OAUTH_GRANT_TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, oauthGrantType_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, clientId_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientSecret_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, clientSecret_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tokenEndpoint_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, tokenEndpoint_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < scopes_.size(); i++) {
            dataSize += computeStringSizeNoTag(scopes_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getScopesList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig other =
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig) obj;

        if (oauthGrantType_ != other.oauthGrantType_) return false;
        if (!getClientId().equals(other.getClientId())) return false;
        if (!getClientSecret().equals(other.getClientSecret())) return false;
        if (!getTokenEndpoint().equals(other.getTokenEndpoint())) return false;
        if (!getScopesList().equals(other.getScopesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + OAUTH_GRANT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + oauthGrantType_;
        hash = (37 * hash) + CLIENT_ID_FIELD_NUMBER;
        hash = (53 * hash) + getClientId().hashCode();
        hash = (37 * hash) + CLIENT_SECRET_FIELD_NUMBER;
        hash = (53 * hash) + getClientSecret().hashCode();
        hash = (37 * hash) + TOKEN_ENDPOINT_FIELD_NUMBER;
        hash = (53 * hash) + getTokenEndpoint().hashCode();
        if (getScopesCount() > 0) {
          hash = (37 * hash) + SCOPES_FIELD_NUMBER;
          hash = (53 * hash) + getScopesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Config for authentication with OAuth.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig)
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_OAuthConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_OAuthConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.class,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          oauthGrantType_ = 0;
          clientId_ = "";
          clientSecret_ = "";
          tokenEndpoint_ = "";
          scopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_OAuthConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig build() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig result =
              new com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.oauthGrantType_ = oauthGrantType_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.clientId_ = clientId_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.clientSecret_ = clientSecret_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.tokenEndpoint_ = tokenEndpoint_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            scopes_.makeImmutable();
            result.scopes_ = scopes_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
                  .getDefaultInstance()) return this;
          if (other.oauthGrantType_ != 0) {
            setOauthGrantTypeValue(other.getOauthGrantTypeValue());
          }
          if (!other.getClientId().isEmpty()) {
            clientId_ = other.clientId_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getClientSecret().isEmpty()) {
            clientSecret_ = other.clientSecret_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (!other.getTokenEndpoint().isEmpty()) {
            tokenEndpoint_ = other.tokenEndpoint_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          if (!other.scopes_.isEmpty()) {
            if (scopes_.isEmpty()) {
              scopes_ = other.scopes_;
              bitField0_ |= 0x00000010;
            } else {
              ensureScopesIsMutable();
              scopes_.addAll(other.scopes_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    oauthGrantType_ = input.readEnum();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 18:
                  {
                    clientId_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    clientSecret_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    tokenEndpoint_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                case 42:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureScopesIsMutable();
                    scopes_.add(s);
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int oauthGrantType_ = 0;
        /**
         *
         *
         * <pre>
         * Required. OAuth grant types.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType oauth_grant_type = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The enum numeric value on the wire for oauthGrantType.
         */
        @java.lang.Override
        public int getOauthGrantTypeValue() {
          return oauthGrantType_;
        }
        /**
         *
         *
         * <pre>
         * Required. OAuth grant types.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType oauth_grant_type = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The enum numeric value on the wire for oauthGrantType to set.
         * @return This builder for chaining.
         */
        public Builder setOauthGrantTypeValue(int value) {
          oauthGrantType_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. OAuth grant types.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType oauth_grant_type = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The oauthGrantType.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType
            getOauthGrantType() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType
              result =
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
                      .OauthGrantType.forNumber(oauthGrantType_);
          return result == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
                  .OauthGrantType.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Required. OAuth grant types.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType oauth_grant_type = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The oauthGrantType to set.
         * @return This builder for chaining.
         */
        public Builder setOauthGrantType(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          oauthGrantType_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. OAuth grant types.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.OauthGrantType oauth_grant_type = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOauthGrantType() {
          bitField0_ = (bitField0_ & ~0x00000001);
          oauthGrantType_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object clientId_ = "";
        /**
         *
         *
         * <pre>
         * Required. The client ID from the OAuth provider.
         * </pre>
         *
         * <code>string client_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The clientId.
         */
        public java.lang.String getClientId() {
          java.lang.Object ref = clientId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            clientId_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The client ID from the OAuth provider.
         * </pre>
         *
         * <code>string client_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for clientId.
         */
        public com.google.protobuf.ByteString getClientIdBytes() {
          java.lang.Object ref = clientId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            clientId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The client ID from the OAuth provider.
         * </pre>
         *
         * <code>string client_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The clientId to set.
         * @return This builder for chaining.
         */
        public Builder setClientId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          clientId_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The client ID from the OAuth provider.
         * </pre>
         *
         * <code>string client_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearClientId() {
          clientId_ = getDefaultInstance().getClientId();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The client ID from the OAuth provider.
         * </pre>
         *
         * <code>string client_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for clientId to set.
         * @return This builder for chaining.
         */
        public Builder setClientIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          clientId_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object clientSecret_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The client secret from the OAuth provider. If the
         * `secret_version_for_client_secret` field is set, this field will be
         * ignored.
         * </pre>
         *
         * <code>string client_secret = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The clientSecret.
         */
        public java.lang.String getClientSecret() {
          java.lang.Object ref = clientSecret_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            clientSecret_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The client secret from the OAuth provider. If the
         * `secret_version_for_client_secret` field is set, this field will be
         * ignored.
         * </pre>
         *
         * <code>string client_secret = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for clientSecret.
         */
        public com.google.protobuf.ByteString getClientSecretBytes() {
          java.lang.Object ref = clientSecret_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            clientSecret_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The client secret from the OAuth provider. If the
         * `secret_version_for_client_secret` field is set, this field will be
         * ignored.
         * </pre>
         *
         * <code>string client_secret = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The clientSecret to set.
         * @return This builder for chaining.
         */
        public Builder setClientSecret(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          clientSecret_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The client secret from the OAuth provider. If the
         * `secret_version_for_client_secret` field is set, this field will be
         * ignored.
         * </pre>
         *
         * <code>string client_secret = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearClientSecret() {
          clientSecret_ = getDefaultInstance().getClientSecret();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The client secret from the OAuth provider. If the
         * `secret_version_for_client_secret` field is set, this field will be
         * ignored.
         * </pre>
         *
         * <code>string client_secret = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for clientSecret to set.
         * @return This builder for chaining.
         */
        public Builder setClientSecretBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          clientSecret_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.lang.Object tokenEndpoint_ = "";
        /**
         *
         *
         * <pre>
         * Required. The token endpoint in the OAuth provider to exchange for an
         * access token.
         * </pre>
         *
         * <code>string token_endpoint = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The tokenEndpoint.
         */
        public java.lang.String getTokenEndpoint() {
          java.lang.Object ref = tokenEndpoint_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            tokenEndpoint_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The token endpoint in the OAuth provider to exchange for an
         * access token.
         * </pre>
         *
         * <code>string token_endpoint = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for tokenEndpoint.
         */
        public com.google.protobuf.ByteString getTokenEndpointBytes() {
          java.lang.Object ref = tokenEndpoint_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            tokenEndpoint_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The token endpoint in the OAuth provider to exchange for an
         * access token.
         * </pre>
         *
         * <code>string token_endpoint = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The tokenEndpoint to set.
         * @return This builder for chaining.
         */
        public Builder setTokenEndpoint(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          tokenEndpoint_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The token endpoint in the OAuth provider to exchange for an
         * access token.
         * </pre>
         *
         * <code>string token_endpoint = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTokenEndpoint() {
          tokenEndpoint_ = getDefaultInstance().getTokenEndpoint();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The token endpoint in the OAuth provider to exchange for an
         * access token.
         * </pre>
         *
         * <code>string token_endpoint = 4 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for tokenEndpoint to set.
         * @return This builder for chaining.
         */
        public Builder setTokenEndpointBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          tokenEndpoint_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList scopes_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureScopesIsMutable() {
          if (!scopes_.isModifiable()) {
            scopes_ = new com.google.protobuf.LazyStringArrayList(scopes_);
          }
          bitField0_ |= 0x00000010;
        }
        /**
         *
         *
         * <pre>
         * Optional. The OAuth scopes to grant.
         * </pre>
         *
         * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the scopes.
         */
        public com.google.protobuf.ProtocolStringList getScopesList() {
          scopes_.makeImmutable();
          return scopes_;
        }
        /**
         *
         *
         * <pre>
         * Optional. The OAuth scopes to grant.
         * </pre>
         *
         * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of scopes.
         */
        public int getScopesCount() {
          return scopes_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional. The OAuth scopes to grant.
         * </pre>
         *
         * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The scopes at the given index.
         */
        public java.lang.String getScopes(int index) {
          return scopes_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. The OAuth scopes to grant.
         * </pre>
         *
         * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the scopes at the given index.
         */
        public com.google.protobuf.ByteString getScopesBytes(int index) {
          return scopes_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. The OAuth scopes to grant.
         * </pre>
         *
         * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The scopes to set.
         * @return This builder for chaining.
         */
        public Builder setScopes(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureScopesIsMutable();
          scopes_.set(index, value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The OAuth scopes to grant.
         * </pre>
         *
         * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The scopes to add.
         * @return This builder for chaining.
         */
        public Builder addScopes(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureScopesIsMutable();
          scopes_.add(value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The OAuth scopes to grant.
         * </pre>
         *
         * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The scopes to add.
         * @return This builder for chaining.
         */
        public Builder addAllScopes(java.lang.Iterable<java.lang.String> values) {
          ensureScopesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, scopes_);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The OAuth scopes to grant.
         * </pre>
         *
         * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearScopes() {
          scopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The OAuth scopes to grant.
         * </pre>
         *
         * <code>repeated string scopes = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the scopes to add.
         * @return This builder for chaining.
         */
        public Builder addScopesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureScopesIsMutable();
          scopes_.add(value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<OAuthConfig> PARSER =
          new com.google.protobuf.AbstractParser<OAuthConfig>() {
            @java.lang.Override
            public OAuthConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<OAuthConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<OAuthConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ServiceAgentAuthConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. Indicate the auth token type generated from the [Diglogflow
       * service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
       * The generated token is sent in the Authorization header.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth service_agent_auth = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for serviceAgentAuth.
       */
      int getServiceAgentAuthValue();
      /**
       *
       *
       * <pre>
       * Optional. Indicate the auth token type generated from the [Diglogflow
       * service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
       * The generated token is sent in the Authorization header.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth service_agent_auth = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The serviceAgentAuth.
       */
      com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
              .ServiceAgentAuth
          getServiceAgentAuth();
    }
    /**
     *
     *
     * <pre>
     * Config for auth using [Diglogflow service
     * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig}
     */
    public static final class ServiceAgentAuthConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig)
        ServiceAgentAuthConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ServiceAgentAuthConfig.newBuilder() to construct.
      private ServiceAgentAuthConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ServiceAgentAuthConfig() {
        serviceAgentAuth_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ServiceAgentAuthConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_ServiceAgentAuthConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_ServiceAgentAuthConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                    .class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                    .Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Indicate the auth token type generated from the [Diglogflow service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth}
       */
      public enum ServiceAgentAuth implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Service agent auth type unspecified. Default to ID_TOKEN.
         * </pre>
         *
         * <code>SERVICE_AGENT_AUTH_UNSPECIFIED = 0;</code>
         */
        SERVICE_AGENT_AUTH_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Use [ID
         * token](https://cloud.google.com/docs/authentication/token-types#id)
         * generated from service agent. This can be used to access Cloud
         * Function and Cloud Run after you grant Invoker role to
         * `service-&lt;PROJECT-NUMBER&gt;&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`.
         * </pre>
         *
         * <code>ID_TOKEN = 1;</code>
         */
        ID_TOKEN(1),
        /**
         *
         *
         * <pre>
         * Use [access
         * token](https://cloud.google.com/docs/authentication/token-types#access)
         * generated from service agent. This can be used to access other Google
         * Cloud APIs after you grant required roles to
         * `service-&lt;PROJECT-NUMBER&gt;&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`.
         * </pre>
         *
         * <code>ACCESS_TOKEN = 2;</code>
         */
        ACCESS_TOKEN(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Service agent auth type unspecified. Default to ID_TOKEN.
         * </pre>
         *
         * <code>SERVICE_AGENT_AUTH_UNSPECIFIED = 0;</code>
         */
        public static final int SERVICE_AGENT_AUTH_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Use [ID
         * token](https://cloud.google.com/docs/authentication/token-types#id)
         * generated from service agent. This can be used to access Cloud
         * Function and Cloud Run after you grant Invoker role to
         * `service-&lt;PROJECT-NUMBER&gt;&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`.
         * </pre>
         *
         * <code>ID_TOKEN = 1;</code>
         */
        public static final int ID_TOKEN_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Use [access
         * token](https://cloud.google.com/docs/authentication/token-types#access)
         * generated from service agent. This can be used to access other Google
         * Cloud APIs after you grant required roles to
         * `service-&lt;PROJECT-NUMBER&gt;&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`.
         * </pre>
         *
         * <code>ACCESS_TOKEN = 2;</code>
         */
        public static final int ACCESS_TOKEN_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ServiceAgentAuth valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static ServiceAgentAuth forNumber(int value) {
          switch (value) {
            case 0:
              return SERVICE_AGENT_AUTH_UNSPECIFIED;
            case 1:
              return ID_TOKEN;
            case 2:
              return ACCESS_TOKEN;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ServiceAgentAuth>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<ServiceAgentAuth>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<ServiceAgentAuth>() {
                  public ServiceAgentAuth findValueByNumber(int number) {
                    return ServiceAgentAuth.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
              .getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final ServiceAgentAuth[] VALUES = values();

        public static ServiceAgentAuth valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private ServiceAgentAuth(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth)
      }

      public static final int SERVICE_AGENT_AUTH_FIELD_NUMBER = 1;
      private int serviceAgentAuth_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. Indicate the auth token type generated from the [Diglogflow
       * service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
       * The generated token is sent in the Authorization header.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth service_agent_auth = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for serviceAgentAuth.
       */
      @java.lang.Override
      public int getServiceAgentAuthValue() {
        return serviceAgentAuth_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicate the auth token type generated from the [Diglogflow
       * service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
       * The generated token is sent in the Authorization header.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth service_agent_auth = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The serviceAgentAuth.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
              .ServiceAgentAuth
          getServiceAgentAuth() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                .ServiceAgentAuth
            result =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                    .ServiceAgentAuth.forNumber(serviceAgentAuth_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                .ServiceAgentAuth.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (serviceAgentAuth_
            != com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                .ServiceAgentAuth.SERVICE_AGENT_AUTH_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, serviceAgentAuth_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (serviceAgentAuth_
            != com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                .ServiceAgentAuth.SERVICE_AGENT_AUTH_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, serviceAgentAuth_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig other =
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig) obj;

        if (serviceAgentAuth_ != other.serviceAgentAuth_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SERVICE_AGENT_AUTH_FIELD_NUMBER;
        hash = (53 * hash) + serviceAgentAuth_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Config for auth using [Diglogflow service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig)
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_ServiceAgentAuthConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_ServiceAgentAuthConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                      .class,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          serviceAgentAuth_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_ServiceAgentAuthConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
            build() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig result =
              new com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.serviceAgentAuth_ = serviceAgentAuth_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                  .getDefaultInstance()) return this;
          if (other.serviceAgentAuth_ != 0) {
            setServiceAgentAuthValue(other.getServiceAgentAuthValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    serviceAgentAuth_ = input.readEnum();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int serviceAgentAuth_ = 0;
        /**
         *
         *
         * <pre>
         * Optional. Indicate the auth token type generated from the [Diglogflow
         * service
         * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
         * The generated token is sent in the Authorization header.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth service_agent_auth = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The enum numeric value on the wire for serviceAgentAuth.
         */
        @java.lang.Override
        public int getServiceAgentAuthValue() {
          return serviceAgentAuth_;
        }
        /**
         *
         *
         * <pre>
         * Optional. Indicate the auth token type generated from the [Diglogflow
         * service
         * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
         * The generated token is sent in the Authorization header.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth service_agent_auth = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The enum numeric value on the wire for serviceAgentAuth to set.
         * @return This builder for chaining.
         */
        public Builder setServiceAgentAuthValue(int value) {
          serviceAgentAuth_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Indicate the auth token type generated from the [Diglogflow
         * service
         * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
         * The generated token is sent in the Authorization header.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth service_agent_auth = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The serviceAgentAuth.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                .ServiceAgentAuth
            getServiceAgentAuth() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                  .ServiceAgentAuth
              result =
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                      .ServiceAgentAuth.forNumber(serviceAgentAuth_);
          return result == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                  .ServiceAgentAuth.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Optional. Indicate the auth token type generated from the [Diglogflow
         * service
         * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
         * The generated token is sent in the Authorization header.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth service_agent_auth = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The serviceAgentAuth to set.
         * @return This builder for chaining.
         */
        public Builder setServiceAgentAuth(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                    .ServiceAgentAuth
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          serviceAgentAuth_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Indicate the auth token type generated from the [Diglogflow
         * service
         * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
         * The generated token is sent in the Authorization header.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth service_agent_auth = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearServiceAgentAuth() {
          bitField0_ = (bitField0_ & ~0x00000001);
          serviceAgentAuth_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ServiceAgentAuthConfig> PARSER =
          new com.google.protobuf.AbstractParser<ServiceAgentAuthConfig>() {
            @java.lang.Override
            public ServiceAgentAuthConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ServiceAgentAuthConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ServiceAgentAuthConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface BearerTokenConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The text token appended to the text `Bearer` to the request
       * Authorization header.
       * [Session parameters
       * reference](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
       * can be used to pass the token dynamically, e.g.
       * `$session.params.parameter-id`.
       * </pre>
       *
       * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The token.
       */
      java.lang.String getToken();
      /**
       *
       *
       * <pre>
       * Optional. The text token appended to the text `Bearer` to the request
       * Authorization header.
       * [Session parameters
       * reference](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
       * can be used to pass the token dynamically, e.g.
       * `$session.params.parameter-id`.
       * </pre>
       *
       * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for token.
       */
      com.google.protobuf.ByteString getTokenBytes();
    }
    /**
     *
     *
     * <pre>
     * Config for authentication using bearer token.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig}
     */
    public static final class BearerTokenConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
        BearerTokenConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use BearerTokenConfig.newBuilder() to construct.
      private BearerTokenConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private BearerTokenConfig() {
        token_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new BearerTokenConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_BearerTokenConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_BearerTokenConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig.Builder
                    .class);
      }

      public static final int TOKEN_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object token_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The text token appended to the text `Bearer` to the request
       * Authorization header.
       * [Session parameters
       * reference](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
       * can be used to pass the token dynamically, e.g.
       * `$session.params.parameter-id`.
       * </pre>
       *
       * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The token.
       */
      @java.lang.Override
      public java.lang.String getToken() {
        java.lang.Object ref = token_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          token_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The text token appended to the text `Bearer` to the request
       * Authorization header.
       * [Session parameters
       * reference](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
       * can be used to pass the token dynamically, e.g.
       * `$session.params.parameter-id`.
       * </pre>
       *
       * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for token.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTokenBytes() {
        java.lang.Object ref = token_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          token_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(token_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, token_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(token_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, token_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig other =
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig) obj;

        if (!getToken().equals(other.getToken())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getToken().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Config for authentication using bearer token.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_BearerTokenConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_BearerTokenConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
                      .class,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          token_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_BearerTokenConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
            build() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig result =
              new com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.token_ = token_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
                  .getDefaultInstance()) return this;
          if (!other.getToken().isEmpty()) {
            token_ = other.token_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    token_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object token_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The text token appended to the text `Bearer` to the request
         * Authorization header.
         * [Session parameters
         * reference](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
         * can be used to pass the token dynamically, e.g.
         * `$session.params.parameter-id`.
         * </pre>
         *
         * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The token.
         */
        public java.lang.String getToken() {
          java.lang.Object ref = token_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            token_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The text token appended to the text `Bearer` to the request
         * Authorization header.
         * [Session parameters
         * reference](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
         * can be used to pass the token dynamically, e.g.
         * `$session.params.parameter-id`.
         * </pre>
         *
         * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for token.
         */
        public com.google.protobuf.ByteString getTokenBytes() {
          java.lang.Object ref = token_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            token_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The text token appended to the text `Bearer` to the request
         * Authorization header.
         * [Session parameters
         * reference](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
         * can be used to pass the token dynamically, e.g.
         * `$session.params.parameter-id`.
         * </pre>
         *
         * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The token to set.
         * @return This builder for chaining.
         */
        public Builder setToken(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          token_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The text token appended to the text `Bearer` to the request
         * Authorization header.
         * [Session parameters
         * reference](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
         * can be used to pass the token dynamically, e.g.
         * `$session.params.parameter-id`.
         * </pre>
         *
         * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearToken() {
          token_ = getDefaultInstance().getToken();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The text token appended to the text `Bearer` to the request
         * Authorization header.
         * [Session parameters
         * reference](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
         * can be used to pass the token dynamically, e.g.
         * `$session.params.parameter-id`.
         * </pre>
         *
         * <code>string token = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for token to set.
         * @return This builder for chaining.
         */
        public Builder setTokenBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          token_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .BearerTokenConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<BearerTokenConfig> PARSER =
          new com.google.protobuf.AbstractParser<BearerTokenConfig>() {
            @java.lang.Override
            public BearerTokenConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<BearerTokenConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<BearerTokenConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int authConfigCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object authConfig_;

    public enum AuthConfigCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      API_KEY_CONFIG(1),
      OAUTH_CONFIG(2),
      SERVICE_AGENT_AUTH_CONFIG(3),
      BEARER_TOKEN_CONFIG(4),
      AUTHCONFIG_NOT_SET(0);
      private final int value;

      private AuthConfigCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AuthConfigCase valueOf(int value) {
        return forNumber(value);
      }

      public static AuthConfigCase forNumber(int value) {
        switch (value) {
          case 1:
            return API_KEY_CONFIG;
          case 2:
            return OAUTH_CONFIG;
          case 3:
            return SERVICE_AGENT_AUTH_CONFIG;
          case 4:
            return BEARER_TOKEN_CONFIG;
          case 0:
            return AUTHCONFIG_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public AuthConfigCase getAuthConfigCase() {
      return AuthConfigCase.forNumber(authConfigCase_);
    }

    public static final int API_KEY_CONFIG_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
     * </code>
     *
     * @return Whether the apiKeyConfig field is set.
     */
    @java.lang.Override
    public boolean hasApiKeyConfig() {
      return authConfigCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
     * </code>
     *
     * @return The apiKeyConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
        getApiKeyConfig() {
      if (authConfigCase_ == 1) {
        return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)
            authConfig_;
      }
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Config for API key auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfigOrBuilder
        getApiKeyConfigOrBuilder() {
      if (authConfigCase_ == 1) {
        return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)
            authConfig_;
      }
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          .getDefaultInstance();
    }

    public static final int OAUTH_CONFIG_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Config for OAuth.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
     * </code>
     *
     * @return Whether the oauthConfig field is set.
     */
    @java.lang.Override
    public boolean hasOauthConfig() {
      return authConfigCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Config for OAuth.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
     * </code>
     *
     * @return The oauthConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig getOauthConfig() {
      if (authConfigCase_ == 2) {
        return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig) authConfig_;
      }
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Config for OAuth.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfigOrBuilder
        getOauthConfigOrBuilder() {
      if (authConfigCase_ == 2) {
        return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig) authConfig_;
      }
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          .getDefaultInstance();
    }

    public static final int SERVICE_AGENT_AUTH_CONFIG_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Config for [Diglogflow service
     * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
     * auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
     * </code>
     *
     * @return Whether the serviceAgentAuthConfig field is set.
     */
    @java.lang.Override
    public boolean hasServiceAgentAuthConfig() {
      return authConfigCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Config for [Diglogflow service
     * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
     * auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
     * </code>
     *
     * @return The serviceAgentAuthConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
        getServiceAgentAuthConfig() {
      if (authConfigCase_ == 3) {
        return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig)
            authConfig_;
      }
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Config for [Diglogflow service
     * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
     * auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
            .ServiceAgentAuthConfigOrBuilder
        getServiceAgentAuthConfigOrBuilder() {
      if (authConfigCase_ == 3) {
        return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig)
            authConfig_;
      }
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
          .getDefaultInstance();
    }

    public static final int BEARER_TOKEN_CONFIG_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Config for bearer token auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
     * </code>
     *
     * @return Whether the bearerTokenConfig field is set.
     */
    @java.lang.Override
    public boolean hasBearerTokenConfig() {
      return authConfigCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Config for bearer token auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
     * </code>
     *
     * @return The bearerTokenConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
        getBearerTokenConfig() {
      if (authConfigCase_ == 4) {
        return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
            authConfig_;
      }
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Config for bearer token auth.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfigOrBuilder
        getBearerTokenConfigOrBuilder() {
      if (authConfigCase_ == 4) {
        return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
            authConfig_;
      }
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (authConfigCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig) authConfig_);
      }
      if (authConfigCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig) authConfig_);
      }
      if (authConfigCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig)
                authConfig_);
      }
      if (authConfigCase_ == 4) {
        output.writeMessage(
            4,
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
                authConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (authConfigCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)
                    authConfig_);
      }
      if (authConfigCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig)
                    authConfig_);
      }
      if (authConfigCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig)
                    authConfig_);
      }
      if (authConfigCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4,
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
                    authConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication other =
          (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication) obj;

      if (!getAuthConfigCase().equals(other.getAuthConfigCase())) return false;
      switch (authConfigCase_) {
        case 1:
          if (!getApiKeyConfig().equals(other.getApiKeyConfig())) return false;
          break;
        case 2:
          if (!getOauthConfig().equals(other.getOauthConfig())) return false;
          break;
        case 3:
          if (!getServiceAgentAuthConfig().equals(other.getServiceAgentAuthConfig())) return false;
          break;
        case 4:
          if (!getBearerTokenConfig().equals(other.getBearerTokenConfig())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (authConfigCase_) {
        case 1:
          hash = (37 * hash) + API_KEY_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getApiKeyConfig().hashCode();
          break;
        case 2:
          hash = (37 * hash) + OAUTH_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getOauthConfig().hashCode();
          break;
        case 3:
          hash = (37 * hash) + SERVICE_AGENT_AUTH_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getServiceAgentAuthConfig().hashCode();
          break;
        case 4:
          hash = (37 * hash) + BEARER_TOKEN_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getBearerTokenConfig().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Authentication information required for API calls
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.Authentication}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication)
        com.google.cloud.dialogflow.cx.v3beta1.Tool.AuthenticationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (apiKeyConfigBuilder_ != null) {
          apiKeyConfigBuilder_.clear();
        }
        if (oauthConfigBuilder_ != null) {
          oauthConfigBuilder_.clear();
        }
        if (serviceAgentAuthConfigBuilder_ != null) {
          serviceAgentAuthConfigBuilder_.clear();
        }
        if (bearerTokenConfigBuilder_ != null) {
          bearerTokenConfigBuilder_.clear();
        }
        authConfigCase_ = 0;
        authConfig_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_Authentication_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication build() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication result =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication result) {
        result.authConfigCase_ = authConfigCase_;
        result.authConfig_ = this.authConfig_;
        if (authConfigCase_ == 1 && apiKeyConfigBuilder_ != null) {
          result.authConfig_ = apiKeyConfigBuilder_.build();
        }
        if (authConfigCase_ == 2 && oauthConfigBuilder_ != null) {
          result.authConfig_ = oauthConfigBuilder_.build();
        }
        if (authConfigCase_ == 3 && serviceAgentAuthConfigBuilder_ != null) {
          result.authConfig_ = serviceAgentAuthConfigBuilder_.build();
        }
        if (authConfigCase_ == 4 && bearerTokenConfigBuilder_ != null) {
          result.authConfig_ = bearerTokenConfigBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.getDefaultInstance())
          return this;
        switch (other.getAuthConfigCase()) {
          case API_KEY_CONFIG:
            {
              mergeApiKeyConfig(other.getApiKeyConfig());
              break;
            }
          case OAUTH_CONFIG:
            {
              mergeOauthConfig(other.getOauthConfig());
              break;
            }
          case SERVICE_AGENT_AUTH_CONFIG:
            {
              mergeServiceAgentAuthConfig(other.getServiceAgentAuthConfig());
              break;
            }
          case BEARER_TOKEN_CONFIG:
            {
              mergeBearerTokenConfig(other.getBearerTokenConfig());
              break;
            }
          case AUTHCONFIG_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getApiKeyConfigFieldBuilder().getBuilder(), extensionRegistry);
                  authConfigCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getOauthConfigFieldBuilder().getBuilder(), extensionRegistry);
                  authConfigCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getServiceAgentAuthConfigFieldBuilder().getBuilder(), extensionRegistry);
                  authConfigCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getBearerTokenConfigFieldBuilder().getBuilder(), extensionRegistry);
                  authConfigCase_ = 4;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int authConfigCase_ = 0;
      private java.lang.Object authConfig_;

      public AuthConfigCase getAuthConfigCase() {
        return AuthConfigCase.forNumber(authConfigCase_);
      }

      public Builder clearAuthConfig() {
        authConfigCase_ = 0;
        authConfig_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfigOrBuilder>
          apiKeyConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Config for API key auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
       * </code>
       *
       * @return Whether the apiKeyConfig field is set.
       */
      @java.lang.Override
      public boolean hasApiKeyConfig() {
        return authConfigCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Config for API key auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
       * </code>
       *
       * @return The apiKeyConfig.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
          getApiKeyConfig() {
        if (apiKeyConfigBuilder_ == null) {
          if (authConfigCase_ == 1) {
            return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)
                authConfig_;
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
              .getDefaultInstance();
        } else {
          if (authConfigCase_ == 1) {
            return apiKeyConfigBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Config for API key auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
       * </code>
       */
      public Builder setApiKeyConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig value) {
        if (apiKeyConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          authConfig_ = value;
          onChanged();
        } else {
          apiKeyConfigBuilder_.setMessage(value);
        }
        authConfigCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for API key auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
       * </code>
       */
      public Builder setApiKeyConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig.Builder
              builderForValue) {
        if (apiKeyConfigBuilder_ == null) {
          authConfig_ = builderForValue.build();
          onChanged();
        } else {
          apiKeyConfigBuilder_.setMessage(builderForValue.build());
        }
        authConfigCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for API key auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
       * </code>
       */
      public Builder mergeApiKeyConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig value) {
        if (apiKeyConfigBuilder_ == null) {
          if (authConfigCase_ == 1
              && authConfig_
                  != com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
                      .getDefaultInstance()) {
            authConfig_ =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig.newBuilder(
                        (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)
                            authConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            authConfig_ = value;
          }
          onChanged();
        } else {
          if (authConfigCase_ == 1) {
            apiKeyConfigBuilder_.mergeFrom(value);
          } else {
            apiKeyConfigBuilder_.setMessage(value);
          }
        }
        authConfigCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for API key auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
       * </code>
       */
      public Builder clearApiKeyConfig() {
        if (apiKeyConfigBuilder_ == null) {
          if (authConfigCase_ == 1) {
            authConfigCase_ = 0;
            authConfig_ = null;
            onChanged();
          }
        } else {
          if (authConfigCase_ == 1) {
            authConfigCase_ = 0;
            authConfig_ = null;
          }
          apiKeyConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for API key auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig.Builder
          getApiKeyConfigBuilder() {
        return getApiKeyConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Config for API key auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfigOrBuilder
          getApiKeyConfigOrBuilder() {
        if ((authConfigCase_ == 1) && (apiKeyConfigBuilder_ != null)) {
          return apiKeyConfigBuilder_.getMessageOrBuilder();
        } else {
          if (authConfigCase_ == 1) {
            return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)
                authConfig_;
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Config for API key auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig api_key_config = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfigOrBuilder>
          getApiKeyConfigFieldBuilder() {
        if (apiKeyConfigBuilder_ == null) {
          if (!(authConfigCase_ == 1)) {
            authConfig_ =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig
                    .getDefaultInstance();
          }
          apiKeyConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfigOrBuilder>(
                  (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ApiKeyConfig)
                      authConfig_,
                  getParentForChildren(),
                  isClean());
          authConfig_ = null;
        }
        authConfigCase_ = 1;
        onChanged();
        return apiKeyConfigBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfigOrBuilder>
          oauthConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Config for OAuth.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
       * </code>
       *
       * @return Whether the oauthConfig field is set.
       */
      @java.lang.Override
      public boolean hasOauthConfig() {
        return authConfigCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Config for OAuth.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
       * </code>
       *
       * @return The oauthConfig.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
          getOauthConfig() {
        if (oauthConfigBuilder_ == null) {
          if (authConfigCase_ == 2) {
            return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig)
                authConfig_;
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
              .getDefaultInstance();
        } else {
          if (authConfigCase_ == 2) {
            return oauthConfigBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Config for OAuth.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
       * </code>
       */
      public Builder setOauthConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig value) {
        if (oauthConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          authConfig_ = value;
          onChanged();
        } else {
          oauthConfigBuilder_.setMessage(value);
        }
        authConfigCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for OAuth.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
       * </code>
       */
      public Builder setOauthConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.Builder
              builderForValue) {
        if (oauthConfigBuilder_ == null) {
          authConfig_ = builderForValue.build();
          onChanged();
        } else {
          oauthConfigBuilder_.setMessage(builderForValue.build());
        }
        authConfigCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for OAuth.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
       * </code>
       */
      public Builder mergeOauthConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig value) {
        if (oauthConfigBuilder_ == null) {
          if (authConfigCase_ == 2
              && authConfig_
                  != com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
                      .getDefaultInstance()) {
            authConfig_ =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.newBuilder(
                        (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig)
                            authConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            authConfig_ = value;
          }
          onChanged();
        } else {
          if (authConfigCase_ == 2) {
            oauthConfigBuilder_.mergeFrom(value);
          } else {
            oauthConfigBuilder_.setMessage(value);
          }
        }
        authConfigCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for OAuth.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
       * </code>
       */
      public Builder clearOauthConfig() {
        if (oauthConfigBuilder_ == null) {
          if (authConfigCase_ == 2) {
            authConfigCase_ = 0;
            authConfig_ = null;
            onChanged();
          }
        } else {
          if (authConfigCase_ == 2) {
            authConfigCase_ = 0;
            authConfig_ = null;
          }
          oauthConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for OAuth.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.Builder
          getOauthConfigBuilder() {
        return getOauthConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Config for OAuth.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfigOrBuilder
          getOauthConfigOrBuilder() {
        if ((authConfigCase_ == 2) && (oauthConfigBuilder_ != null)) {
          return oauthConfigBuilder_.getMessageOrBuilder();
        } else {
          if (authConfigCase_ == 2) {
            return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig)
                authConfig_;
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Config for OAuth.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig oauth_config = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfigOrBuilder>
          getOauthConfigFieldBuilder() {
        if (oauthConfigBuilder_ == null) {
          if (!(authConfigCase_ == 2)) {
            authConfig_ =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig
                    .getDefaultInstance();
          }
          oauthConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfigOrBuilder>(
                  (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.OAuthConfig)
                      authConfig_,
                  getParentForChildren(),
                  isClean());
          authConfig_ = null;
        }
        authConfigCase_ = 2;
        onChanged();
        return oauthConfigBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                  .Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
                  .ServiceAgentAuthConfigOrBuilder>
          serviceAgentAuthConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Config for [Diglogflow service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
       * auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
       * </code>
       *
       * @return Whether the serviceAgentAuthConfig field is set.
       */
      @java.lang.Override
      public boolean hasServiceAgentAuthConfig() {
        return authConfigCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Config for [Diglogflow service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
       * auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
       * </code>
       *
       * @return The serviceAgentAuthConfig.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
          getServiceAgentAuthConfig() {
        if (serviceAgentAuthConfigBuilder_ == null) {
          if (authConfigCase_ == 3) {
            return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
                    .ServiceAgentAuthConfig)
                authConfig_;
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
              .getDefaultInstance();
        } else {
          if (authConfigCase_ == 3) {
            return serviceAgentAuthConfigBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Config for [Diglogflow service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
       * auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
       * </code>
       */
      public Builder setServiceAgentAuthConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig value) {
        if (serviceAgentAuthConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          authConfig_ = value;
          onChanged();
        } else {
          serviceAgentAuthConfigBuilder_.setMessage(value);
        }
        authConfigCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for [Diglogflow service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
       * auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
       * </code>
       */
      public Builder setServiceAgentAuthConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig.Builder
              builderForValue) {
        if (serviceAgentAuthConfigBuilder_ == null) {
          authConfig_ = builderForValue.build();
          onChanged();
        } else {
          serviceAgentAuthConfigBuilder_.setMessage(builderForValue.build());
        }
        authConfigCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for [Diglogflow service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
       * auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
       * </code>
       */
      public Builder mergeServiceAgentAuthConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig value) {
        if (serviceAgentAuthConfigBuilder_ == null) {
          if (authConfigCase_ == 3
              && authConfig_
                  != com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
                      .ServiceAgentAuthConfig.getDefaultInstance()) {
            authConfig_ =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                    .newBuilder(
                        (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
                                .ServiceAgentAuthConfig)
                            authConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            authConfig_ = value;
          }
          onChanged();
        } else {
          if (authConfigCase_ == 3) {
            serviceAgentAuthConfigBuilder_.mergeFrom(value);
          } else {
            serviceAgentAuthConfigBuilder_.setMessage(value);
          }
        }
        authConfigCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for [Diglogflow service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
       * auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
       * </code>
       */
      public Builder clearServiceAgentAuthConfig() {
        if (serviceAgentAuthConfigBuilder_ == null) {
          if (authConfigCase_ == 3) {
            authConfigCase_ = 0;
            authConfig_ = null;
            onChanged();
          }
        } else {
          if (authConfigCase_ == 3) {
            authConfigCase_ = 0;
            authConfig_ = null;
          }
          serviceAgentAuthConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for [Diglogflow service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
       * auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
              .Builder
          getServiceAgentAuthConfigBuilder() {
        return getServiceAgentAuthConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Config for [Diglogflow service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
       * auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
              .ServiceAgentAuthConfigOrBuilder
          getServiceAgentAuthConfigOrBuilder() {
        if ((authConfigCase_ == 3) && (serviceAgentAuthConfigBuilder_ != null)) {
          return serviceAgentAuthConfigBuilder_.getMessageOrBuilder();
        } else {
          if (authConfigCase_ == 3) {
            return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
                    .ServiceAgentAuthConfig)
                authConfig_;
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Config for [Diglogflow service
       * agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
       * auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig service_agent_auth_config = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                  .Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
                  .ServiceAgentAuthConfigOrBuilder>
          getServiceAgentAuthConfigFieldBuilder() {
        if (serviceAgentAuthConfigBuilder_ == null) {
          if (!(authConfigCase_ == 3)) {
            authConfig_ =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                    .getDefaultInstance();
          }
          serviceAgentAuthConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.ServiceAgentAuthConfig
                      .Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
                      .ServiceAgentAuthConfigOrBuilder>(
                  (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
                          .ServiceAgentAuthConfig)
                      authConfig_,
                  getParentForChildren(),
                  isClean());
          authConfig_ = null;
        }
        authConfigCase_ = 3;
        onChanged();
        return serviceAgentAuthConfigBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfigOrBuilder>
          bearerTokenConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Config for bearer token auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
       * </code>
       *
       * @return Whether the bearerTokenConfig field is set.
       */
      @java.lang.Override
      public boolean hasBearerTokenConfig() {
        return authConfigCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Config for bearer token auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
       * </code>
       *
       * @return The bearerTokenConfig.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
          getBearerTokenConfig() {
        if (bearerTokenConfigBuilder_ == null) {
          if (authConfigCase_ == 4) {
            return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
                authConfig_;
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
              .getDefaultInstance();
        } else {
          if (authConfigCase_ == 4) {
            return bearerTokenConfigBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Config for bearer token auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
       * </code>
       */
      public Builder setBearerTokenConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig value) {
        if (bearerTokenConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          authConfig_ = value;
          onChanged();
        } else {
          bearerTokenConfigBuilder_.setMessage(value);
        }
        authConfigCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for bearer token auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
       * </code>
       */
      public Builder setBearerTokenConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig.Builder
              builderForValue) {
        if (bearerTokenConfigBuilder_ == null) {
          authConfig_ = builderForValue.build();
          onChanged();
        } else {
          bearerTokenConfigBuilder_.setMessage(builderForValue.build());
        }
        authConfigCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for bearer token auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
       * </code>
       */
      public Builder mergeBearerTokenConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig value) {
        if (bearerTokenConfigBuilder_ == null) {
          if (authConfigCase_ == 4
              && authConfig_
                  != com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
                      .getDefaultInstance()) {
            authConfig_ =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
                    .newBuilder(
                        (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
                                .BearerTokenConfig)
                            authConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            authConfig_ = value;
          }
          onChanged();
        } else {
          if (authConfigCase_ == 4) {
            bearerTokenConfigBuilder_.mergeFrom(value);
          } else {
            bearerTokenConfigBuilder_.setMessage(value);
          }
        }
        authConfigCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for bearer token auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
       * </code>
       */
      public Builder clearBearerTokenConfig() {
        if (bearerTokenConfigBuilder_ == null) {
          if (authConfigCase_ == 4) {
            authConfigCase_ = 0;
            authConfig_ = null;
            onChanged();
          }
        } else {
          if (authConfigCase_ == 4) {
            authConfigCase_ = 0;
            authConfig_ = null;
          }
          bearerTokenConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Config for bearer token auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig.Builder
          getBearerTokenConfigBuilder() {
        return getBearerTokenConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Config for bearer token auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfigOrBuilder
          getBearerTokenConfigOrBuilder() {
        if ((authConfigCase_ == 4) && (bearerTokenConfigBuilder_ != null)) {
          return bearerTokenConfigBuilder_.getMessageOrBuilder();
        } else {
          if (authConfigCase_ == 4) {
            return (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
                authConfig_;
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Config for bearer token auth.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig bearer_token_config = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfigOrBuilder>
          getBearerTokenConfigFieldBuilder() {
        if (bearerTokenConfigBuilder_ == null) {
          if (!(authConfigCase_ == 4)) {
            authConfig_ =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
                    .getDefaultInstance();
          }
          bearerTokenConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig
                      .Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
                      .BearerTokenConfigOrBuilder>(
                  (com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication.BearerTokenConfig)
                      authConfig_,
                  getParentForChildren(),
                  isClean());
          authConfig_ = null;
        }
        authConfigCase_ = 4;
        onChanged();
        return bearerTokenConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.Authentication)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Authentication> PARSER =
        new com.google.protobuf.AbstractParser<Authentication>() {
          @java.lang.Override
          public Authentication parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Authentication> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Authentication> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.Authentication getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TLSConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Specifies a list of allowed custom CA certificates for HTTPS
     * verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert> getCaCertsList();
    /**
     *
     *
     * <pre>
     * Required. Specifies a list of allowed custom CA certificates for HTTPS
     * verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert getCaCerts(int index);
    /**
     *
     *
     * <pre>
     * Required. Specifies a list of allowed custom CA certificates for HTTPS
     * verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getCaCertsCount();
    /**
     *
     *
     * <pre>
     * Required. Specifies a list of allowed custom CA certificates for HTTPS
     * verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACertOrBuilder>
        getCaCertsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. Specifies a list of allowed custom CA certificates for HTTPS
     * verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACertOrBuilder getCaCertsOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * The TLS configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig}
   */
  public static final class TLSConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig)
      TLSConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TLSConfig.newBuilder() to construct.
    private TLSConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TLSConfig() {
      caCerts_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TLSConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_TLSConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_TLSConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.class,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.Builder.class);
    }

    public interface CACertOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The name of the allowed custom CA certificates. This
       * can be used to disambiguate the custom CA certificates.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The displayName.
       */
      java.lang.String getDisplayName();
      /**
       *
       *
       * <pre>
       * Required. The name of the allowed custom CA certificates. This
       * can be used to disambiguate the custom CA certificates.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for displayName.
       */
      com.google.protobuf.ByteString getDisplayNameBytes();

      /**
       *
       *
       * <pre>
       * Required. The allowed custom CA certificates (in DER format) for
       * HTTPS verification. This overrides the default SSL trust store. If this
       * is empty or unspecified, Dialogflow will use Google's default trust
       * store to verify certificates. N.B. Make sure the HTTPS server
       * certificates are signed with "subject alt name". For instance a
       * certificate can be self-signed using the following command:
       *
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>bytes cert = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The cert.
       */
      com.google.protobuf.ByteString getCert();
    }
    /**
     *
     *
     * <pre>
     * The CA certificate.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert}
     */
    public static final class CACert extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert)
        CACertOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CACert.newBuilder() to construct.
      private CACert(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CACert() {
        displayName_ = "";
        cert_ = com.google.protobuf.ByteString.EMPTY;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CACert();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_TLSConfig_CACert_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_TLSConfig_CACert_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.Builder.class);
      }

      public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the allowed custom CA certificates. This
       * can be used to disambiguate the custom CA certificates.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The displayName.
       */
      @java.lang.Override
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the allowed custom CA certificates. This
       * can be used to disambiguate the custom CA certificates.
       * </pre>
       *
       * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for displayName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CERT_FIELD_NUMBER = 2;
      private com.google.protobuf.ByteString cert_ = com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * Required. The allowed custom CA certificates (in DER format) for
       * HTTPS verification. This overrides the default SSL trust store. If this
       * is empty or unspecified, Dialogflow will use Google's default trust
       * store to verify certificates. N.B. Make sure the HTTPS server
       * certificates are signed with "subject alt name". For instance a
       * certificate can be self-signed using the following command:
       *
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>bytes cert = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The cert.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getCert() {
        return cert_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
        }
        if (!cert_.isEmpty()) {
          output.writeBytes(2, cert_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
        }
        if (!cert_.isEmpty()) {
          size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, cert_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert other =
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert) obj;

        if (!getDisplayName().equals(other.getDisplayName())) return false;
        if (!getCert().equals(other.getCert())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getDisplayName().hashCode();
        hash = (37 * hash) + CERT_FIELD_NUMBER;
        hash = (53 * hash) + getCert().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The CA certificate.
       * </pre>
       *
       * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert)
          com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACertOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_TLSConfig_CACert_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_TLSConfig_CACert_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.class,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.Builder.class);
        }

        // Construct using com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          displayName_ = "";
          cert_ = com.google.protobuf.ByteString.EMPTY;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_TLSConfig_CACert_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert build() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert result =
              new com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.displayName_ = displayName_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.cert_ = cert_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert) {
            return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.getDefaultInstance())
            return this;
          if (!other.getDisplayName().isEmpty()) {
            displayName_ = other.displayName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getCert() != com.google.protobuf.ByteString.EMPTY) {
            setCert(other.getCert());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    displayName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    cert_ = input.readBytes();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object displayName_ = "";
        /**
         *
         *
         * <pre>
         * Required. The name of the allowed custom CA certificates. This
         * can be used to disambiguate the custom CA certificates.
         * </pre>
         *
         * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The displayName.
         */
        public java.lang.String getDisplayName() {
          java.lang.Object ref = displayName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            displayName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The name of the allowed custom CA certificates. This
         * can be used to disambiguate the custom CA certificates.
         * </pre>
         *
         * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for displayName.
         */
        public com.google.protobuf.ByteString getDisplayNameBytes() {
          java.lang.Object ref = displayName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            displayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The name of the allowed custom CA certificates. This
         * can be used to disambiguate the custom CA certificates.
         * </pre>
         *
         * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          displayName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The name of the allowed custom CA certificates. This
         * can be used to disambiguate the custom CA certificates.
         * </pre>
         *
         * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDisplayName() {
          displayName_ = getDefaultInstance().getDisplayName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The name of the allowed custom CA certificates. This
         * can be used to disambiguate the custom CA certificates.
         * </pre>
         *
         * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          displayName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.ByteString cert_ = com.google.protobuf.ByteString.EMPTY;
        /**
         *
         *
         * <pre>
         * Required. The allowed custom CA certificates (in DER format) for
         * HTTPS verification. This overrides the default SSL trust store. If this
         * is empty or unspecified, Dialogflow will use Google's default trust
         * store to verify certificates. N.B. Make sure the HTTPS server
         * certificates are signed with "subject alt name". For instance a
         * certificate can be self-signed using the following command:
         *
         * ```
         *    openssl x509 -req -days 200 -in example.com.csr &#92;
         *      -signkey example.com.key &#92;
         *      -out example.com.crt &#92;
         *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
         * ```
         * </pre>
         *
         * <code>bytes cert = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The cert.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getCert() {
          return cert_;
        }
        /**
         *
         *
         * <pre>
         * Required. The allowed custom CA certificates (in DER format) for
         * HTTPS verification. This overrides the default SSL trust store. If this
         * is empty or unspecified, Dialogflow will use Google's default trust
         * store to verify certificates. N.B. Make sure the HTTPS server
         * certificates are signed with "subject alt name". For instance a
         * certificate can be self-signed using the following command:
         *
         * ```
         *    openssl x509 -req -days 200 -in example.com.csr &#92;
         *      -signkey example.com.key &#92;
         *      -out example.com.crt &#92;
         *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
         * ```
         * </pre>
         *
         * <code>bytes cert = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The cert to set.
         * @return This builder for chaining.
         */
        public Builder setCert(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          cert_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The allowed custom CA certificates (in DER format) for
         * HTTPS verification. This overrides the default SSL trust store. If this
         * is empty or unspecified, Dialogflow will use Google's default trust
         * store to verify certificates. N.B. Make sure the HTTPS server
         * certificates are signed with "subject alt name". For instance a
         * certificate can be self-signed using the following command:
         *
         * ```
         *    openssl x509 -req -days 200 -in example.com.csr &#92;
         *      -signkey example.com.key &#92;
         *      -out example.com.crt &#92;
         *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
         * ```
         * </pre>
         *
         * <code>bytes cert = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCert() {
          bitField0_ = (bitField0_ & ~0x00000002);
          cert_ = getDefaultInstance().getCert();
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CACert> PARSER =
          new com.google.protobuf.AbstractParser<CACert>() {
            @java.lang.Override
            public CACert parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CACert> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CACert> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int CA_CERTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert> caCerts_;
    /**
     *
     *
     * <pre>
     * Required. Specifies a list of allowed custom CA certificates for HTTPS
     * verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert>
        getCaCertsList() {
      return caCerts_;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies a list of allowed custom CA certificates for HTTPS
     * verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACertOrBuilder>
        getCaCertsOrBuilderList() {
      return caCerts_;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies a list of allowed custom CA certificates for HTTPS
     * verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getCaCertsCount() {
      return caCerts_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies a list of allowed custom CA certificates for HTTPS
     * verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert getCaCerts(int index) {
      return caCerts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies a list of allowed custom CA certificates for HTTPS
     * verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACertOrBuilder
        getCaCertsOrBuilder(int index) {
      return caCerts_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < caCerts_.size(); i++) {
        output.writeMessage(1, caCerts_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < caCerts_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, caCerts_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig other =
          (com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig) obj;

      if (!getCaCertsList().equals(other.getCaCertsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getCaCertsCount() > 0) {
        hash = (37 * hash) + CA_CERTS_FIELD_NUMBER;
        hash = (53 * hash) + getCaCertsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The TLS configuration.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig)
        com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_TLSConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_TLSConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (caCertsBuilder_ == null) {
          caCerts_ = java.util.Collections.emptyList();
        } else {
          caCerts_ = null;
          caCertsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_TLSConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig build() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig result =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig result) {
        if (caCertsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            caCerts_ = java.util.Collections.unmodifiableList(caCerts_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.caCerts_ = caCerts_;
        } else {
          result.caCerts_ = caCertsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig other) {
        if (other == com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.getDefaultInstance())
          return this;
        if (caCertsBuilder_ == null) {
          if (!other.caCerts_.isEmpty()) {
            if (caCerts_.isEmpty()) {
              caCerts_ = other.caCerts_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureCaCertsIsMutable();
              caCerts_.addAll(other.caCerts_);
            }
            onChanged();
          }
        } else {
          if (!other.caCerts_.isEmpty()) {
            if (caCertsBuilder_.isEmpty()) {
              caCertsBuilder_.dispose();
              caCertsBuilder_ = null;
              caCerts_ = other.caCerts_;
              bitField0_ = (bitField0_ & ~0x00000001);
              caCertsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getCaCertsFieldBuilder()
                      : null;
            } else {
              caCertsBuilder_.addAllMessages(other.caCerts_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.parser(),
                          extensionRegistry);
                  if (caCertsBuilder_ == null) {
                    ensureCaCertsIsMutable();
                    caCerts_.add(m);
                  } else {
                    caCertsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert>
          caCerts_ = java.util.Collections.emptyList();

      private void ensureCaCertsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          caCerts_ =
              new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert>(
                  caCerts_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACertOrBuilder>
          caCertsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert>
          getCaCertsList() {
        if (caCertsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(caCerts_);
        } else {
          return caCertsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getCaCertsCount() {
        if (caCertsBuilder_ == null) {
          return caCerts_.size();
        } else {
          return caCertsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert getCaCerts(int index) {
        if (caCertsBuilder_ == null) {
          return caCerts_.get(index);
        } else {
          return caCertsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setCaCerts(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert value) {
        if (caCertsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCaCertsIsMutable();
          caCerts_.set(index, value);
          onChanged();
        } else {
          caCertsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setCaCerts(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.Builder builderForValue) {
        if (caCertsBuilder_ == null) {
          ensureCaCertsIsMutable();
          caCerts_.set(index, builderForValue.build());
          onChanged();
        } else {
          caCertsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addCaCerts(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert value) {
        if (caCertsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCaCertsIsMutable();
          caCerts_.add(value);
          onChanged();
        } else {
          caCertsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addCaCerts(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert value) {
        if (caCertsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCaCertsIsMutable();
          caCerts_.add(index, value);
          onChanged();
        } else {
          caCertsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addCaCerts(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.Builder builderForValue) {
        if (caCertsBuilder_ == null) {
          ensureCaCertsIsMutable();
          caCerts_.add(builderForValue.build());
          onChanged();
        } else {
          caCertsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addCaCerts(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.Builder builderForValue) {
        if (caCertsBuilder_ == null) {
          ensureCaCertsIsMutable();
          caCerts_.add(index, builderForValue.build());
          onChanged();
        } else {
          caCertsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllCaCerts(
          java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert>
              values) {
        if (caCertsBuilder_ == null) {
          ensureCaCertsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, caCerts_);
          onChanged();
        } else {
          caCertsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearCaCerts() {
        if (caCertsBuilder_ == null) {
          caCerts_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          caCertsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeCaCerts(int index) {
        if (caCertsBuilder_ == null) {
          ensureCaCertsIsMutable();
          caCerts_.remove(index);
          onChanged();
        } else {
          caCertsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.Builder getCaCertsBuilder(
          int index) {
        return getCaCertsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACertOrBuilder
          getCaCertsOrBuilder(int index) {
        if (caCertsBuilder_ == null) {
          return caCerts_.get(index);
        } else {
          return caCertsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACertOrBuilder>
          getCaCertsOrBuilderList() {
        if (caCertsBuilder_ != null) {
          return caCertsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(caCerts_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.Builder
          addCaCertsBuilder() {
        return getCaCertsFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.Builder addCaCertsBuilder(
          int index) {
        return getCaCertsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a list of allowed custom CA certificates for HTTPS
       * verification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert ca_certs = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.Builder>
          getCaCertsBuilderList() {
        return getCaCertsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACertOrBuilder>
          getCaCertsFieldBuilder() {
        if (caCertsBuilder_ == null) {
          caCertsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACert.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig.CACertOrBuilder>(
                  caCerts_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          caCerts_ = null;
        }
        return caCertsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TLSConfig> PARSER =
        new com.google.protobuf.AbstractParser<TLSConfig>() {
          @java.lang.Override
          public TLSConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TLSConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TLSConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.TLSConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ServiceDirectoryConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/namespaces/&lt;NamespaceID&gt;/services/&lt;ServiceID&gt;`.
     * `LocationID` of the service directory must be the same as the location
     * of the agent.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The service.
     */
    java.lang.String getService();
    /**
     *
     *
     * <pre>
     * Required. The name of [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/namespaces/&lt;NamespaceID&gt;/services/&lt;ServiceID&gt;`.
     * `LocationID` of the service directory must be the same as the location
     * of the agent.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for service.
     */
    com.google.protobuf.ByteString getServiceBytes();
  }
  /**
   *
   *
   * <pre>
   * Configuration for tools using Service Directory.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig}
   */
  public static final class ServiceDirectoryConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig)
      ServiceDirectoryConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ServiceDirectoryConfig.newBuilder() to construct.
    private ServiceDirectoryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ServiceDirectoryConfig() {
      service_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ServiceDirectoryConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ServiceDirectoryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ServiceDirectoryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig.class,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig.Builder.class);
    }

    public static final int SERVICE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/namespaces/&lt;NamespaceID&gt;/services/&lt;ServiceID&gt;`.
     * `LocationID` of the service directory must be the same as the location
     * of the agent.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The service.
     */
    @java.lang.Override
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/namespaces/&lt;NamespaceID&gt;/services/&lt;ServiceID&gt;`.
     * `LocationID` of the service directory must be the same as the location
     * of the agent.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for service.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig other =
          (com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig) obj;

      if (!getService().equals(other.getService())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getService().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for tools using Service Directory.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig)
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ServiceDirectoryConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ServiceDirectoryConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        service_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_ServiceDirectoryConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig build() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig result =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.service_ = service_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
                .getDefaultInstance()) return this;
        if (!other.getService().isEmpty()) {
          service_ = other.service_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  service_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object service_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/namespaces/&lt;NamespaceID&gt;/services/&lt;ServiceID&gt;`.
       * `LocationID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The service.
       */
      public java.lang.String getService() {
        java.lang.Object ref = service_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          service_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/namespaces/&lt;NamespaceID&gt;/services/&lt;ServiceID&gt;`.
       * `LocationID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for service.
       */
      public com.google.protobuf.ByteString getServiceBytes() {
        java.lang.Object ref = service_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          service_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/namespaces/&lt;NamespaceID&gt;/services/&lt;ServiceID&gt;`.
       * `LocationID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The service to set.
       * @return This builder for chaining.
       */
      public Builder setService(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        service_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/namespaces/&lt;NamespaceID&gt;/services/&lt;ServiceID&gt;`.
       * `LocationID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearService() {
        service_ = getDefaultInstance().getService();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/namespaces/&lt;NamespaceID&gt;/services/&lt;ServiceID&gt;`.
       * `LocationID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for service to set.
       * @return This builder for chaining.
       */
      public Builder setServiceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        service_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ServiceDirectoryConfig> PARSER =
        new com.google.protobuf.AbstractParser<ServiceDirectoryConfig>() {
          @java.lang.Override
          public ServiceDirectoryConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ServiceDirectoryConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ServiceDirectoryConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ServiceDirectoryConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EndUserAuthConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Oauth 2.0 Authorization Code authentication.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
     * </code>
     *
     * @return Whether the oauth2AuthCodeConfig field is set.
     */
    boolean hasOauth2AuthCodeConfig();
    /**
     *
     *
     * <pre>
     * Oauth 2.0 Authorization Code authentication.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
     * </code>
     *
     * @return The oauth2AuthCodeConfig.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
        getOauth2AuthCodeConfig();
    /**
     *
     *
     * <pre>
     * Oauth 2.0 Authorization Code authentication.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfigOrBuilder
        getOauth2AuthCodeConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * JWT Profile Oauth 2.0 Authorization Grant authentication.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
     * </code>
     *
     * @return Whether the oauth2JwtBearerConfig field is set.
     */
    boolean hasOauth2JwtBearerConfig();
    /**
     *
     *
     * <pre>
     * JWT Profile Oauth 2.0 Authorization Grant authentication.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
     * </code>
     *
     * @return The oauth2JwtBearerConfig.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
        getOauth2JwtBearerConfig();
    /**
     *
     *
     * <pre>
     * JWT Profile Oauth 2.0 Authorization Grant authentication.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfigOrBuilder
        getOauth2JwtBearerConfigOrBuilder();

    com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.EndUserAuthConfigCase
        getEndUserAuthConfigCase();
  }
  /**
   *
   *
   * <pre>
   * End-user authentication configuration used for Connection calls.
   * The field values can either be hardcoded authentication values or the names
   * of [session
   * parameters](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
   * or [request
   * parameters](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#request-scoped).
   *
   * If parameter names are provided, then those parameters can be used to pass
   * the authentication values dynamically, through `$session.params.param-id`
   * or `$request.payload.param-id`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig}
   */
  public static final class EndUserAuthConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig)
      EndUserAuthConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EndUserAuthConfig.newBuilder() to construct.
    private EndUserAuthConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EndUserAuthConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EndUserAuthConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.class,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Builder.class);
    }

    public interface Oauth2AuthCodeConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Oauth token value or parameter name to pass it through.
       * </pre>
       *
       * <code>string oauth_token = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The oauthToken.
       */
      java.lang.String getOauthToken();
      /**
       *
       *
       * <pre>
       * Required. Oauth token value or parameter name to pass it through.
       * </pre>
       *
       * <code>string oauth_token = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for oauthToken.
       */
      com.google.protobuf.ByteString getOauthTokenBytes();
    }
    /**
     *
     *
     * <pre>
     * Oauth 2.0 Authorization Code authentication configuration.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig}
     */
    public static final class Oauth2AuthCodeConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig)
        Oauth2AuthCodeConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Oauth2AuthCodeConfig.newBuilder() to construct.
      private Oauth2AuthCodeConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Oauth2AuthCodeConfig() {
        oauthToken_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Oauth2AuthCodeConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_Oauth2AuthCodeConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_Oauth2AuthCodeConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
                    .class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
                    .Builder.class);
      }

      public static final int OAUTH_TOKEN_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object oauthToken_ = "";
      /**
       *
       *
       * <pre>
       * Required. Oauth token value or parameter name to pass it through.
       * </pre>
       *
       * <code>string oauth_token = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The oauthToken.
       */
      @java.lang.Override
      public java.lang.String getOauthToken() {
        java.lang.Object ref = oauthToken_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          oauthToken_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Oauth token value or parameter name to pass it through.
       * </pre>
       *
       * <code>string oauth_token = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for oauthToken.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getOauthTokenBytes() {
        java.lang.Object ref = oauthToken_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          oauthToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oauthToken_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, oauthToken_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oauthToken_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, oauthToken_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig other =
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig)
                obj;

        if (!getOauthToken().equals(other.getOauthToken())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + OAUTH_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getOauthToken().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Oauth 2.0 Authorization Code authentication configuration.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig)
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_Oauth2AuthCodeConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_Oauth2AuthCodeConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
                      .class,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          oauthToken_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_Oauth2AuthCodeConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
            build() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
              result =
                  new com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                      .Oauth2AuthCodeConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.oauthToken_ = oauthToken_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
                other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
                  .getDefaultInstance()) return this;
          if (!other.getOauthToken().isEmpty()) {
            oauthToken_ = other.oauthToken_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    oauthToken_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object oauthToken_ = "";
        /**
         *
         *
         * <pre>
         * Required. Oauth token value or parameter name to pass it through.
         * </pre>
         *
         * <code>string oauth_token = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The oauthToken.
         */
        public java.lang.String getOauthToken() {
          java.lang.Object ref = oauthToken_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            oauthToken_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Oauth token value or parameter name to pass it through.
         * </pre>
         *
         * <code>string oauth_token = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for oauthToken.
         */
        public com.google.protobuf.ByteString getOauthTokenBytes() {
          java.lang.Object ref = oauthToken_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            oauthToken_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Oauth token value or parameter name to pass it through.
         * </pre>
         *
         * <code>string oauth_token = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The oauthToken to set.
         * @return This builder for chaining.
         */
        public Builder setOauthToken(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          oauthToken_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Oauth token value or parameter name to pass it through.
         * </pre>
         *
         * <code>string oauth_token = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOauthToken() {
          oauthToken_ = getDefaultInstance().getOauthToken();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Oauth token value or parameter name to pass it through.
         * </pre>
         *
         * <code>string oauth_token = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for oauthToken to set.
         * @return This builder for chaining.
         */
        public Builder setOauthTokenBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          oauthToken_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                .Oauth2AuthCodeConfig();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Oauth2AuthCodeConfig> PARSER =
          new com.google.protobuf.AbstractParser<Oauth2AuthCodeConfig>() {
            @java.lang.Override
            public Oauth2AuthCodeConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Oauth2AuthCodeConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Oauth2AuthCodeConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface Oauth2JwtBearerConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Issuer value or parameter name to pass it through.
       * </pre>
       *
       * <code>string issuer = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The issuer.
       */
      java.lang.String getIssuer();
      /**
       *
       *
       * <pre>
       * Required. Issuer value or parameter name to pass it through.
       * </pre>
       *
       * <code>string issuer = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for issuer.
       */
      com.google.protobuf.ByteString getIssuerBytes();

      /**
       *
       *
       * <pre>
       * Required. Subject value or parameter name to pass it through.
       * </pre>
       *
       * <code>string subject = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The subject.
       */
      java.lang.String getSubject();
      /**
       *
       *
       * <pre>
       * Required. Subject value or parameter name to pass it through.
       * </pre>
       *
       * <code>string subject = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for subject.
       */
      com.google.protobuf.ByteString getSubjectBytes();

      /**
       *
       *
       * <pre>
       * Required. Client key value or parameter name to pass it through.
       * </pre>
       *
       * <code>string client_key = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The clientKey.
       */
      java.lang.String getClientKey();
      /**
       *
       *
       * <pre>
       * Required. Client key value or parameter name to pass it through.
       * </pre>
       *
       * <code>string client_key = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for clientKey.
       */
      com.google.protobuf.ByteString getClientKeyBytes();
    }
    /**
     *
     *
     * <pre>
     * JWT Profile Oauth 2.0 Authorization Grant authentication configuration.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig}
     */
    public static final class Oauth2JwtBearerConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig)
        Oauth2JwtBearerConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Oauth2JwtBearerConfig.newBuilder() to construct.
      private Oauth2JwtBearerConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Oauth2JwtBearerConfig() {
        issuer_ = "";
        subject_ = "";
        clientKey_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Oauth2JwtBearerConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_Oauth2JwtBearerConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_Oauth2JwtBearerConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
                    .class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
                    .Builder.class);
      }

      public static final int ISSUER_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object issuer_ = "";
      /**
       *
       *
       * <pre>
       * Required. Issuer value or parameter name to pass it through.
       * </pre>
       *
       * <code>string issuer = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The issuer.
       */
      @java.lang.Override
      public java.lang.String getIssuer() {
        java.lang.Object ref = issuer_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          issuer_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Issuer value or parameter name to pass it through.
       * </pre>
       *
       * <code>string issuer = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for issuer.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getIssuerBytes() {
        java.lang.Object ref = issuer_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          issuer_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SUBJECT_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object subject_ = "";
      /**
       *
       *
       * <pre>
       * Required. Subject value or parameter name to pass it through.
       * </pre>
       *
       * <code>string subject = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The subject.
       */
      @java.lang.Override
      public java.lang.String getSubject() {
        java.lang.Object ref = subject_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subject_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Subject value or parameter name to pass it through.
       * </pre>
       *
       * <code>string subject = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for subject.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSubjectBytes() {
        java.lang.Object ref = subject_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          subject_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CLIENT_KEY_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object clientKey_ = "";
      /**
       *
       *
       * <pre>
       * Required. Client key value or parameter name to pass it through.
       * </pre>
       *
       * <code>string client_key = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The clientKey.
       */
      @java.lang.Override
      public java.lang.String getClientKey() {
        java.lang.Object ref = clientKey_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clientKey_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Client key value or parameter name to pass it through.
       * </pre>
       *
       * <code>string client_key = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for clientKey.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getClientKeyBytes() {
        java.lang.Object ref = clientKey_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          clientKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuer_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, issuer_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subject_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, subject_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientKey_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, clientKey_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issuer_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, issuer_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subject_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, subject_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientKey_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, clientKey_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig other =
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig)
                obj;

        if (!getIssuer().equals(other.getIssuer())) return false;
        if (!getSubject().equals(other.getSubject())) return false;
        if (!getClientKey().equals(other.getClientKey())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ISSUER_FIELD_NUMBER;
        hash = (53 * hash) + getIssuer().hashCode();
        hash = (37 * hash) + SUBJECT_FIELD_NUMBER;
        hash = (53 * hash) + getSubject().hashCode();
        hash = (37 * hash) + CLIENT_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getClientKey().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * JWT Profile Oauth 2.0 Authorization Grant authentication configuration.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig)
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_Oauth2JwtBearerConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_Oauth2JwtBearerConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                      .Oauth2JwtBearerConfig.class,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                      .Oauth2JwtBearerConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          issuer_ = "";
          subject_ = "";
          clientKey_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_Oauth2JwtBearerConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
            build() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
              result =
                  new com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                      .Oauth2JwtBearerConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.issuer_ = issuer_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.subject_ = subject_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.clientKey_ = clientKey_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                        .Oauth2JwtBearerConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
                other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
                  .getDefaultInstance()) return this;
          if (!other.getIssuer().isEmpty()) {
            issuer_ = other.issuer_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getSubject().isEmpty()) {
            subject_ = other.subject_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getClientKey().isEmpty()) {
            clientKey_ = other.clientKey_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    issuer_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    subject_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    clientKey_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object issuer_ = "";
        /**
         *
         *
         * <pre>
         * Required. Issuer value or parameter name to pass it through.
         * </pre>
         *
         * <code>string issuer = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The issuer.
         */
        public java.lang.String getIssuer() {
          java.lang.Object ref = issuer_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            issuer_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Issuer value or parameter name to pass it through.
         * </pre>
         *
         * <code>string issuer = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for issuer.
         */
        public com.google.protobuf.ByteString getIssuerBytes() {
          java.lang.Object ref = issuer_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            issuer_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Issuer value or parameter name to pass it through.
         * </pre>
         *
         * <code>string issuer = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The issuer to set.
         * @return This builder for chaining.
         */
        public Builder setIssuer(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          issuer_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Issuer value or parameter name to pass it through.
         * </pre>
         *
         * <code>string issuer = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIssuer() {
          issuer_ = getDefaultInstance().getIssuer();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Issuer value or parameter name to pass it through.
         * </pre>
         *
         * <code>string issuer = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for issuer to set.
         * @return This builder for chaining.
         */
        public Builder setIssuerBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          issuer_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object subject_ = "";
        /**
         *
         *
         * <pre>
         * Required. Subject value or parameter name to pass it through.
         * </pre>
         *
         * <code>string subject = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The subject.
         */
        public java.lang.String getSubject() {
          java.lang.Object ref = subject_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            subject_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Subject value or parameter name to pass it through.
         * </pre>
         *
         * <code>string subject = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for subject.
         */
        public com.google.protobuf.ByteString getSubjectBytes() {
          java.lang.Object ref = subject_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            subject_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Subject value or parameter name to pass it through.
         * </pre>
         *
         * <code>string subject = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The subject to set.
         * @return This builder for chaining.
         */
        public Builder setSubject(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          subject_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Subject value or parameter name to pass it through.
         * </pre>
         *
         * <code>string subject = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSubject() {
          subject_ = getDefaultInstance().getSubject();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Subject value or parameter name to pass it through.
         * </pre>
         *
         * <code>string subject = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for subject to set.
         * @return This builder for chaining.
         */
        public Builder setSubjectBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          subject_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object clientKey_ = "";
        /**
         *
         *
         * <pre>
         * Required. Client key value or parameter name to pass it through.
         * </pre>
         *
         * <code>string client_key = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The clientKey.
         */
        public java.lang.String getClientKey() {
          java.lang.Object ref = clientKey_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            clientKey_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Client key value or parameter name to pass it through.
         * </pre>
         *
         * <code>string client_key = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for clientKey.
         */
        public com.google.protobuf.ByteString getClientKeyBytes() {
          java.lang.Object ref = clientKey_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            clientKey_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Client key value or parameter name to pass it through.
         * </pre>
         *
         * <code>string client_key = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The clientKey to set.
         * @return This builder for chaining.
         */
        public Builder setClientKey(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          clientKey_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Client key value or parameter name to pass it through.
         * </pre>
         *
         * <code>string client_key = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearClientKey() {
          clientKey_ = getDefaultInstance().getClientKey();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Client key value or parameter name to pass it through.
         * </pre>
         *
         * <code>string client_key = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for clientKey to set.
         * @return This builder for chaining.
         */
        public Builder setClientKeyBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          clientKey_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                .Oauth2JwtBearerConfig();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Oauth2JwtBearerConfig> PARSER =
          new com.google.protobuf.AbstractParser<Oauth2JwtBearerConfig>() {
            @java.lang.Override
            public Oauth2JwtBearerConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Oauth2JwtBearerConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Oauth2JwtBearerConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int endUserAuthConfigCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object endUserAuthConfig_;

    public enum EndUserAuthConfigCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      OAUTH2_AUTH_CODE_CONFIG(2),
      OAUTH2_JWT_BEARER_CONFIG(3),
      ENDUSERAUTHCONFIG_NOT_SET(0);
      private final int value;

      private EndUserAuthConfigCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static EndUserAuthConfigCase valueOf(int value) {
        return forNumber(value);
      }

      public static EndUserAuthConfigCase forNumber(int value) {
        switch (value) {
          case 2:
            return OAUTH2_AUTH_CODE_CONFIG;
          case 3:
            return OAUTH2_JWT_BEARER_CONFIG;
          case 0:
            return ENDUSERAUTHCONFIG_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public EndUserAuthConfigCase getEndUserAuthConfigCase() {
      return EndUserAuthConfigCase.forNumber(endUserAuthConfigCase_);
    }

    public static final int OAUTH2_AUTH_CODE_CONFIG_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Oauth 2.0 Authorization Code authentication.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
     * </code>
     *
     * @return Whether the oauth2AuthCodeConfig field is set.
     */
    @java.lang.Override
    public boolean hasOauth2AuthCodeConfig() {
      return endUserAuthConfigCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Oauth 2.0 Authorization Code authentication.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
     * </code>
     *
     * @return The oauth2AuthCodeConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
        getOauth2AuthCodeConfig() {
      if (endUserAuthConfigCase_ == 2) {
        return (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig)
            endUserAuthConfig_;
      }
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Oauth 2.0 Authorization Code authentication.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
            .Oauth2AuthCodeConfigOrBuilder
        getOauth2AuthCodeConfigOrBuilder() {
      if (endUserAuthConfigCase_ == 2) {
        return (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig)
            endUserAuthConfig_;
      }
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
          .getDefaultInstance();
    }

    public static final int OAUTH2_JWT_BEARER_CONFIG_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * JWT Profile Oauth 2.0 Authorization Grant authentication.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
     * </code>
     *
     * @return Whether the oauth2JwtBearerConfig field is set.
     */
    @java.lang.Override
    public boolean hasOauth2JwtBearerConfig() {
      return endUserAuthConfigCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * JWT Profile Oauth 2.0 Authorization Grant authentication.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
     * </code>
     *
     * @return The oauth2JwtBearerConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
        getOauth2JwtBearerConfig() {
      if (endUserAuthConfigCase_ == 3) {
        return (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig)
            endUserAuthConfig_;
      }
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * JWT Profile Oauth 2.0 Authorization Grant authentication.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
            .Oauth2JwtBearerConfigOrBuilder
        getOauth2JwtBearerConfigOrBuilder() {
      if (endUserAuthConfigCase_ == 3) {
        return (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig)
            endUserAuthConfig_;
      }
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (endUserAuthConfigCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig)
                endUserAuthConfig_);
      }
      if (endUserAuthConfigCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig)
                endUserAuthConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (endUserAuthConfigCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig)
                    endUserAuthConfig_);
      }
      if (endUserAuthConfigCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                        .Oauth2JwtBearerConfig)
                    endUserAuthConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig other =
          (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig) obj;

      if (!getEndUserAuthConfigCase().equals(other.getEndUserAuthConfigCase())) return false;
      switch (endUserAuthConfigCase_) {
        case 2:
          if (!getOauth2AuthCodeConfig().equals(other.getOauth2AuthCodeConfig())) return false;
          break;
        case 3:
          if (!getOauth2JwtBearerConfig().equals(other.getOauth2JwtBearerConfig())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (endUserAuthConfigCase_) {
        case 2:
          hash = (37 * hash) + OAUTH2_AUTH_CODE_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getOauth2AuthCodeConfig().hashCode();
          break;
        case 3:
          hash = (37 * hash) + OAUTH2_JWT_BEARER_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getOauth2JwtBearerConfig().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * End-user authentication configuration used for Connection calls.
     * The field values can either be hardcoded authentication values or the names
     * of [session
     * parameters](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
     * or [request
     * parameters](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#request-scoped).
     *
     * If parameter names are provided, then those parameters can be used to pass
     * the authentication values dynamically, through `$session.params.param-id`
     * or `$request.payload.param-id`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig)
        com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.class,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (oauth2AuthCodeConfigBuilder_ != null) {
          oauth2AuthCodeConfigBuilder_.clear();
        }
        if (oauth2JwtBearerConfigBuilder_ != null) {
          oauth2JwtBearerConfigBuilder_.clear();
        }
        endUserAuthConfigCase_ = 0;
        endUserAuthConfig_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_EndUserAuthConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig build() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig result =
            new com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig result) {
        result.endUserAuthConfigCase_ = endUserAuthConfigCase_;
        result.endUserAuthConfig_ = this.endUserAuthConfig_;
        if (endUserAuthConfigCase_ == 2 && oauth2AuthCodeConfigBuilder_ != null) {
          result.endUserAuthConfig_ = oauth2AuthCodeConfigBuilder_.build();
        }
        if (endUserAuthConfigCase_ == 3 && oauth2JwtBearerConfigBuilder_ != null) {
          result.endUserAuthConfig_ = oauth2JwtBearerConfigBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.getDefaultInstance())
          return this;
        switch (other.getEndUserAuthConfigCase()) {
          case OAUTH2_AUTH_CODE_CONFIG:
            {
              mergeOauth2AuthCodeConfig(other.getOauth2AuthCodeConfig());
              break;
            }
          case OAUTH2_JWT_BEARER_CONFIG:
            {
              mergeOauth2JwtBearerConfig(other.getOauth2JwtBearerConfig());
              break;
            }
          case ENDUSERAUTHCONFIG_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  input.readMessage(
                      getOauth2AuthCodeConfigFieldBuilder().getBuilder(), extensionRegistry);
                  endUserAuthConfigCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getOauth2JwtBearerConfigFieldBuilder().getBuilder(), extensionRegistry);
                  endUserAuthConfigCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int endUserAuthConfigCase_ = 0;
      private java.lang.Object endUserAuthConfig_;

      public EndUserAuthConfigCase getEndUserAuthConfigCase() {
        return EndUserAuthConfigCase.forNumber(endUserAuthConfigCase_);
      }

      public Builder clearEndUserAuthConfig() {
        endUserAuthConfigCase_ = 0;
        endUserAuthConfig_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
                  .Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                  .Oauth2AuthCodeConfigOrBuilder>
          oauth2AuthCodeConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Oauth 2.0 Authorization Code authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
       * </code>
       *
       * @return Whether the oauth2AuthCodeConfig field is set.
       */
      @java.lang.Override
      public boolean hasOauth2AuthCodeConfig() {
        return endUserAuthConfigCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Oauth 2.0 Authorization Code authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
       * </code>
       *
       * @return The oauth2AuthCodeConfig.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
          getOauth2AuthCodeConfig() {
        if (oauth2AuthCodeConfigBuilder_ == null) {
          if (endUserAuthConfigCase_ == 2) {
            return (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                    .Oauth2AuthCodeConfig)
                endUserAuthConfig_;
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
              .getDefaultInstance();
        } else {
          if (endUserAuthConfigCase_ == 2) {
            return oauth2AuthCodeConfigBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Oauth 2.0 Authorization Code authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
       * </code>
       */
      public Builder setOauth2AuthCodeConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
              value) {
        if (oauth2AuthCodeConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endUserAuthConfig_ = value;
          onChanged();
        } else {
          oauth2AuthCodeConfigBuilder_.setMessage(value);
        }
        endUserAuthConfigCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Oauth 2.0 Authorization Code authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
       * </code>
       */
      public Builder setOauth2AuthCodeConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig.Builder
              builderForValue) {
        if (oauth2AuthCodeConfigBuilder_ == null) {
          endUserAuthConfig_ = builderForValue.build();
          onChanged();
        } else {
          oauth2AuthCodeConfigBuilder_.setMessage(builderForValue.build());
        }
        endUserAuthConfigCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Oauth 2.0 Authorization Code authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
       * </code>
       */
      public Builder mergeOauth2AuthCodeConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
              value) {
        if (oauth2AuthCodeConfigBuilder_ == null) {
          if (endUserAuthConfigCase_ == 2
              && endUserAuthConfig_
                  != com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                      .Oauth2AuthCodeConfig.getDefaultInstance()) {
            endUserAuthConfig_ =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
                    .newBuilder(
                        (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                                .Oauth2AuthCodeConfig)
                            endUserAuthConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            endUserAuthConfig_ = value;
          }
          onChanged();
        } else {
          if (endUserAuthConfigCase_ == 2) {
            oauth2AuthCodeConfigBuilder_.mergeFrom(value);
          } else {
            oauth2AuthCodeConfigBuilder_.setMessage(value);
          }
        }
        endUserAuthConfigCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Oauth 2.0 Authorization Code authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
       * </code>
       */
      public Builder clearOauth2AuthCodeConfig() {
        if (oauth2AuthCodeConfigBuilder_ == null) {
          if (endUserAuthConfigCase_ == 2) {
            endUserAuthConfigCase_ = 0;
            endUserAuthConfig_ = null;
            onChanged();
          }
        } else {
          if (endUserAuthConfigCase_ == 2) {
            endUserAuthConfigCase_ = 0;
            endUserAuthConfig_ = null;
          }
          oauth2AuthCodeConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Oauth 2.0 Authorization Code authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
              .Builder
          getOauth2AuthCodeConfigBuilder() {
        return getOauth2AuthCodeConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Oauth 2.0 Authorization Code authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2AuthCodeConfigOrBuilder
          getOauth2AuthCodeConfigOrBuilder() {
        if ((endUserAuthConfigCase_ == 2) && (oauth2AuthCodeConfigBuilder_ != null)) {
          return oauth2AuthCodeConfigBuilder_.getMessageOrBuilder();
        } else {
          if (endUserAuthConfigCase_ == 2) {
            return (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                    .Oauth2AuthCodeConfig)
                endUserAuthConfig_;
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Oauth 2.0 Authorization Code authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig oauth2_auth_code_config = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
                  .Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                  .Oauth2AuthCodeConfigOrBuilder>
          getOauth2AuthCodeConfigFieldBuilder() {
        if (oauth2AuthCodeConfigBuilder_ == null) {
          if (!(endUserAuthConfigCase_ == 2)) {
            endUserAuthConfig_ =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
                    .getDefaultInstance();
          }
          oauth2AuthCodeConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                      .Oauth2AuthCodeConfig,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2AuthCodeConfig
                      .Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                      .Oauth2AuthCodeConfigOrBuilder>(
                  (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                          .Oauth2AuthCodeConfig)
                      endUserAuthConfig_,
                  getParentForChildren(),
                  isClean());
          endUserAuthConfig_ = null;
        }
        endUserAuthConfigCase_ = 2;
        onChanged();
        return oauth2AuthCodeConfigBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
                  .Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                  .Oauth2JwtBearerConfigOrBuilder>
          oauth2JwtBearerConfigBuilder_;
      /**
       *
       *
       * <pre>
       * JWT Profile Oauth 2.0 Authorization Grant authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
       * </code>
       *
       * @return Whether the oauth2JwtBearerConfig field is set.
       */
      @java.lang.Override
      public boolean hasOauth2JwtBearerConfig() {
        return endUserAuthConfigCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * JWT Profile Oauth 2.0 Authorization Grant authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
       * </code>
       *
       * @return The oauth2JwtBearerConfig.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
          getOauth2JwtBearerConfig() {
        if (oauth2JwtBearerConfigBuilder_ == null) {
          if (endUserAuthConfigCase_ == 3) {
            return (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                    .Oauth2JwtBearerConfig)
                endUserAuthConfig_;
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
              .getDefaultInstance();
        } else {
          if (endUserAuthConfigCase_ == 3) {
            return oauth2JwtBearerConfigBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * JWT Profile Oauth 2.0 Authorization Grant authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
       * </code>
       */
      public Builder setOauth2JwtBearerConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
              value) {
        if (oauth2JwtBearerConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endUserAuthConfig_ = value;
          onChanged();
        } else {
          oauth2JwtBearerConfigBuilder_.setMessage(value);
        }
        endUserAuthConfigCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * JWT Profile Oauth 2.0 Authorization Grant authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
       * </code>
       */
      public Builder setOauth2JwtBearerConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
                  .Builder
              builderForValue) {
        if (oauth2JwtBearerConfigBuilder_ == null) {
          endUserAuthConfig_ = builderForValue.build();
          onChanged();
        } else {
          oauth2JwtBearerConfigBuilder_.setMessage(builderForValue.build());
        }
        endUserAuthConfigCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * JWT Profile Oauth 2.0 Authorization Grant authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
       * </code>
       */
      public Builder mergeOauth2JwtBearerConfig(
          com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
              value) {
        if (oauth2JwtBearerConfigBuilder_ == null) {
          if (endUserAuthConfigCase_ == 3
              && endUserAuthConfig_
                  != com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                      .Oauth2JwtBearerConfig.getDefaultInstance()) {
            endUserAuthConfig_ =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
                    .newBuilder(
                        (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                                .Oauth2JwtBearerConfig)
                            endUserAuthConfig_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            endUserAuthConfig_ = value;
          }
          onChanged();
        } else {
          if (endUserAuthConfigCase_ == 3) {
            oauth2JwtBearerConfigBuilder_.mergeFrom(value);
          } else {
            oauth2JwtBearerConfigBuilder_.setMessage(value);
          }
        }
        endUserAuthConfigCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * JWT Profile Oauth 2.0 Authorization Grant authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
       * </code>
       */
      public Builder clearOauth2JwtBearerConfig() {
        if (oauth2JwtBearerConfigBuilder_ == null) {
          if (endUserAuthConfigCase_ == 3) {
            endUserAuthConfigCase_ = 0;
            endUserAuthConfig_ = null;
            onChanged();
          }
        } else {
          if (endUserAuthConfigCase_ == 3) {
            endUserAuthConfigCase_ = 0;
            endUserAuthConfig_ = null;
          }
          oauth2JwtBearerConfigBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * JWT Profile Oauth 2.0 Authorization Grant authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
              .Builder
          getOauth2JwtBearerConfigBuilder() {
        return getOauth2JwtBearerConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * JWT Profile Oauth 2.0 Authorization Grant authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
              .Oauth2JwtBearerConfigOrBuilder
          getOauth2JwtBearerConfigOrBuilder() {
        if ((endUserAuthConfigCase_ == 3) && (oauth2JwtBearerConfigBuilder_ != null)) {
          return oauth2JwtBearerConfigBuilder_.getMessageOrBuilder();
        } else {
          if (endUserAuthConfigCase_ == 3) {
            return (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                    .Oauth2JwtBearerConfig)
                endUserAuthConfig_;
          }
          return com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * JWT Profile Oauth 2.0 Authorization Grant authentication.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig oauth2_jwt_bearer_config = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
                  .Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                  .Oauth2JwtBearerConfigOrBuilder>
          getOauth2JwtBearerConfigFieldBuilder() {
        if (oauth2JwtBearerConfigBuilder_ == null) {
          if (!(endUserAuthConfigCase_ == 3)) {
            endUserAuthConfig_ =
                com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig.Oauth2JwtBearerConfig
                    .getDefaultInstance();
          }
          oauth2JwtBearerConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                      .Oauth2JwtBearerConfig,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                      .Oauth2JwtBearerConfig.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                      .Oauth2JwtBearerConfigOrBuilder>(
                  (com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
                          .Oauth2JwtBearerConfig)
                      endUserAuthConfig_,
                  getParentForChildren(),
                  isClean());
          endUserAuthConfig_ = null;
        }
        endUserAuthConfigCase_ = 3;
        onChanged();
        return oauth2JwtBearerConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EndUserAuthConfig> PARSER =
        new com.google.protobuf.AbstractParser<EndUserAuthConfig>() {
          @java.lang.Override
          public EndUserAuthConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EndUserAuthConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EndUserAuthConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.EndUserAuthConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int specificationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object specification_;

  public enum SpecificationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    OPEN_API_SPEC(4),
    DATA_STORE_SPEC(8),
    EXTENSION_SPEC(11),
    FUNCTION_SPEC(13),
    CONNECTOR_SPEC(15),
    SPECIFICATION_NOT_SET(0);
    private final int value;

    private SpecificationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpecificationCase valueOf(int value) {
      return forNumber(value);
    }

    public static SpecificationCase forNumber(int value) {
      switch (value) {
        case 4:
          return OPEN_API_SPEC;
        case 8:
          return DATA_STORE_SPEC;
        case 11:
          return EXTENSION_SPEC;
        case 13:
          return FUNCTION_SPEC;
        case 15:
          return CONNECTOR_SPEC;
        case 0:
          return SPECIFICATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SpecificationCase getSpecificationCase() {
    return SpecificationCase.forNumber(specificationCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the Tool.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/tools/&lt;ToolID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the Tool.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/tools/&lt;ToolID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the Tool, unique within an agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the Tool, unique within an agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Required. High level description of the Tool and its usage.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. High level description of the Tool and its usage.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPEN_API_SPEC_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * OpenAPI specification of the Tool.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool open_api_spec = 4;</code>
   *
   * @return Whether the openApiSpec field is set.
   */
  @java.lang.Override
  public boolean hasOpenApiSpec() {
    return specificationCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * OpenAPI specification of the Tool.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool open_api_spec = 4;</code>
   *
   * @return The openApiSpec.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool getOpenApiSpec() {
    if (specificationCase_ == 4) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool) specification_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * OpenAPI specification of the Tool.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool open_api_spec = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiToolOrBuilder
      getOpenApiSpecOrBuilder() {
    if (specificationCase_ == 4) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool) specification_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.getDefaultInstance();
  }

  public static final int DATA_STORE_SPEC_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Data store search tool specification.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool data_store_spec = 8;</code>
   *
   * @return Whether the dataStoreSpec field is set.
   */
  @java.lang.Override
  public boolean hasDataStoreSpec() {
    return specificationCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Data store search tool specification.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool data_store_spec = 8;</code>
   *
   * @return The dataStoreSpec.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool getDataStoreSpec() {
    if (specificationCase_ == 8) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool) specification_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Data store search tool specification.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool data_store_spec = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreToolOrBuilder
      getDataStoreSpecOrBuilder() {
    if (specificationCase_ == 8) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool) specification_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.getDefaultInstance();
  }

  public static final int EXTENSION_SPEC_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Vertex extension tool specification.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool extension_spec = 11;</code>
   *
   * @return Whether the extensionSpec field is set.
   */
  @java.lang.Override
  public boolean hasExtensionSpec() {
    return specificationCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Vertex extension tool specification.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool extension_spec = 11;</code>
   *
   * @return The extensionSpec.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool getExtensionSpec() {
    if (specificationCase_ == 11) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool) specification_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Vertex extension tool specification.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool extension_spec = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionToolOrBuilder
      getExtensionSpecOrBuilder() {
    if (specificationCase_ == 11) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool) specification_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.getDefaultInstance();
  }

  public static final int FUNCTION_SPEC_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Client side executed function specification.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool function_spec = 13;</code>
   *
   * @return Whether the functionSpec field is set.
   */
  @java.lang.Override
  public boolean hasFunctionSpec() {
    return specificationCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Client side executed function specification.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool function_spec = 13;</code>
   *
   * @return The functionSpec.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool getFunctionSpec() {
    if (specificationCase_ == 13) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool) specification_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Client side executed function specification.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool function_spec = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionToolOrBuilder
      getFunctionSpecOrBuilder() {
    if (specificationCase_ == 13) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool) specification_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.getDefaultInstance();
  }

  public static final int CONNECTOR_SPEC_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Integration connectors tool specification.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool connector_spec = 15;</code>
   *
   * @return Whether the connectorSpec field is set.
   */
  @java.lang.Override
  public boolean hasConnectorSpec() {
    return specificationCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Integration connectors tool specification.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool connector_spec = 15;</code>
   *
   * @return The connectorSpec.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool getConnectorSpec() {
    if (specificationCase_ == 15) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool) specification_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Integration connectors tool specification.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool connector_spec = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorToolOrBuilder
      getConnectorSpecOrBuilder() {
    if (specificationCase_ == 15) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool) specification_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.getDefaultInstance();
  }

  public static final int TOOL_TYPE_FIELD_NUMBER = 12;
  private int toolType_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The tool type.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.Tool.ToolType tool_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for toolType.
   */
  @java.lang.Override
  public int getToolTypeValue() {
    return toolType_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The tool type.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.Tool.ToolType tool_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The toolType.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Tool.ToolType getToolType() {
    com.google.cloud.dialogflow.cx.v3beta1.Tool.ToolType result =
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ToolType.forNumber(toolType_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Tool.ToolType.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (specificationCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool) specification_);
    }
    if (specificationCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool) specification_);
    }
    if (specificationCase_ == 11) {
      output.writeMessage(
          11, (com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool) specification_);
    }
    if (toolType_
        != com.google.cloud.dialogflow.cx.v3beta1.Tool.ToolType.TOOL_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(12, toolType_);
    }
    if (specificationCase_ == 13) {
      output.writeMessage(
          13, (com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool) specification_);
    }
    if (specificationCase_ == 15) {
      output.writeMessage(
          15, (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool) specification_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (specificationCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool) specification_);
    }
    if (specificationCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool) specification_);
    }
    if (specificationCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool) specification_);
    }
    if (toolType_
        != com.google.cloud.dialogflow.cx.v3beta1.Tool.ToolType.TOOL_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, toolType_);
    }
    if (specificationCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool) specification_);
    }
    if (specificationCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool) specification_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.Tool other =
        (com.google.cloud.dialogflow.cx.v3beta1.Tool) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (toolType_ != other.toolType_) return false;
    if (!getSpecificationCase().equals(other.getSpecificationCase())) return false;
    switch (specificationCase_) {
      case 4:
        if (!getOpenApiSpec().equals(other.getOpenApiSpec())) return false;
        break;
      case 8:
        if (!getDataStoreSpec().equals(other.getDataStoreSpec())) return false;
        break;
      case 11:
        if (!getExtensionSpec().equals(other.getExtensionSpec())) return false;
        break;
      case 13:
        if (!getFunctionSpec().equals(other.getFunctionSpec())) return false;
        break;
      case 15:
        if (!getConnectorSpec().equals(other.getConnectorSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + TOOL_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + toolType_;
    switch (specificationCase_) {
      case 4:
        hash = (37 * hash) + OPEN_API_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getOpenApiSpec().hashCode();
        break;
      case 8:
        hash = (37 * hash) + DATA_STORE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getDataStoreSpec().hashCode();
        break;
      case 11:
        hash = (37 * hash) + EXTENSION_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getExtensionSpec().hashCode();
        break;
      case 13:
        hash = (37 * hash) + FUNCTION_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getFunctionSpec().hashCode();
        break;
      case 15:
        hash = (37 * hash) + CONNECTOR_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getConnectorSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.Tool prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A tool provides a list of actions which are available to the
   * [Playbook][google.cloud.dialogflow.cx.v3beta1.Playbook] to attain its goal. A
   * Tool consists of a description of the tool's usage and a specification of the
   * tool which contains the schema and authentication information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Tool}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Tool)
      com.google.cloud.dialogflow.cx.v3beta1.ToolOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Tool.class,
              com.google.cloud.dialogflow.cx.v3beta1.Tool.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.Tool.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      if (openApiSpecBuilder_ != null) {
        openApiSpecBuilder_.clear();
      }
      if (dataStoreSpecBuilder_ != null) {
        dataStoreSpecBuilder_.clear();
      }
      if (extensionSpecBuilder_ != null) {
        extensionSpecBuilder_.clear();
      }
      if (functionSpecBuilder_ != null) {
        functionSpecBuilder_.clear();
      }
      if (connectorSpecBuilder_ != null) {
        connectorSpecBuilder_.clear();
      }
      toolType_ = 0;
      specificationCase_ = 0;
      specification_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ToolProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Tool_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.Tool.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool build() {
      com.google.cloud.dialogflow.cx.v3beta1.Tool result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.Tool result =
          new com.google.cloud.dialogflow.cx.v3beta1.Tool(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Tool result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.toolType_ = toolType_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.cx.v3beta1.Tool result) {
      result.specificationCase_ = specificationCase_;
      result.specification_ = this.specification_;
      if (specificationCase_ == 4 && openApiSpecBuilder_ != null) {
        result.specification_ = openApiSpecBuilder_.build();
      }
      if (specificationCase_ == 8 && dataStoreSpecBuilder_ != null) {
        result.specification_ = dataStoreSpecBuilder_.build();
      }
      if (specificationCase_ == 11 && extensionSpecBuilder_ != null) {
        result.specification_ = extensionSpecBuilder_.build();
      }
      if (specificationCase_ == 13 && functionSpecBuilder_ != null) {
        result.specification_ = functionSpecBuilder_.build();
      }
      if (specificationCase_ == 15 && connectorSpecBuilder_ != null) {
        result.specification_ = connectorSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Tool) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Tool) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Tool other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.Tool.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.toolType_ != 0) {
        setToolTypeValue(other.getToolTypeValue());
      }
      switch (other.getSpecificationCase()) {
        case OPEN_API_SPEC:
          {
            mergeOpenApiSpec(other.getOpenApiSpec());
            break;
          }
        case DATA_STORE_SPEC:
          {
            mergeDataStoreSpec(other.getDataStoreSpec());
            break;
          }
        case EXTENSION_SPEC:
          {
            mergeExtensionSpec(other.getExtensionSpec());
            break;
          }
        case FUNCTION_SPEC:
          {
            mergeFunctionSpec(other.getFunctionSpec());
            break;
          }
        case CONNECTOR_SPEC:
          {
            mergeConnectorSpec(other.getConnectorSpec());
            break;
          }
        case SPECIFICATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getOpenApiSpecFieldBuilder().getBuilder(), extensionRegistry);
                specificationCase_ = 4;
                break;
              } // case 34
            case 66:
              {
                input.readMessage(getDataStoreSpecFieldBuilder().getBuilder(), extensionRegistry);
                specificationCase_ = 8;
                break;
              } // case 66
            case 90:
              {
                input.readMessage(getExtensionSpecFieldBuilder().getBuilder(), extensionRegistry);
                specificationCase_ = 11;
                break;
              } // case 90
            case 96:
              {
                toolType_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 96
            case 106:
              {
                input.readMessage(getFunctionSpecFieldBuilder().getBuilder(), extensionRegistry);
                specificationCase_ = 13;
                break;
              } // case 106
            case 122:
              {
                input.readMessage(getConnectorSpecFieldBuilder().getBuilder(), extensionRegistry);
                specificationCase_ = 15;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int specificationCase_ = 0;
    private java.lang.Object specification_;

    public SpecificationCase getSpecificationCase() {
      return SpecificationCase.forNumber(specificationCase_);
    }

    public Builder clearSpecification() {
      specificationCase_ = 0;
      specification_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the Tool.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/tools/&lt;ToolID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the Tool.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/tools/&lt;ToolID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the Tool.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/tools/&lt;ToolID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the Tool.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/tools/&lt;ToolID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the Tool.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/tools/&lt;ToolID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the Tool, unique within an agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the Tool, unique within an agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the Tool, unique within an agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the Tool, unique within an agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the Tool, unique within an agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Required. High level description of the Tool and its usage.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. High level description of the Tool and its usage.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. High level description of the Tool and its usage.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. High level description of the Tool and its usage.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. High level description of the Tool and its usage.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiToolOrBuilder>
        openApiSpecBuilder_;
    /**
     *
     *
     * <pre>
     * OpenAPI specification of the Tool.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool open_api_spec = 4;</code>
     *
     * @return Whether the openApiSpec field is set.
     */
    @java.lang.Override
    public boolean hasOpenApiSpec() {
      return specificationCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * OpenAPI specification of the Tool.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool open_api_spec = 4;</code>
     *
     * @return The openApiSpec.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool getOpenApiSpec() {
      if (openApiSpecBuilder_ == null) {
        if (specificationCase_ == 4) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool) specification_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.getDefaultInstance();
      } else {
        if (specificationCase_ == 4) {
          return openApiSpecBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * OpenAPI specification of the Tool.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool open_api_spec = 4;</code>
     */
    public Builder setOpenApiSpec(com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool value) {
      if (openApiSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        specification_ = value;
        onChanged();
      } else {
        openApiSpecBuilder_.setMessage(value);
      }
      specificationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * OpenAPI specification of the Tool.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool open_api_spec = 4;</code>
     */
    public Builder setOpenApiSpec(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.Builder builderForValue) {
      if (openApiSpecBuilder_ == null) {
        specification_ = builderForValue.build();
        onChanged();
      } else {
        openApiSpecBuilder_.setMessage(builderForValue.build());
      }
      specificationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * OpenAPI specification of the Tool.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool open_api_spec = 4;</code>
     */
    public Builder mergeOpenApiSpec(com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool value) {
      if (openApiSpecBuilder_ == null) {
        if (specificationCase_ == 4
            && specification_
                != com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.getDefaultInstance()) {
          specification_ =
              com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool) specification_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          specification_ = value;
        }
        onChanged();
      } else {
        if (specificationCase_ == 4) {
          openApiSpecBuilder_.mergeFrom(value);
        } else {
          openApiSpecBuilder_.setMessage(value);
        }
      }
      specificationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * OpenAPI specification of the Tool.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool open_api_spec = 4;</code>
     */
    public Builder clearOpenApiSpec() {
      if (openApiSpecBuilder_ == null) {
        if (specificationCase_ == 4) {
          specificationCase_ = 0;
          specification_ = null;
          onChanged();
        }
      } else {
        if (specificationCase_ == 4) {
          specificationCase_ = 0;
          specification_ = null;
        }
        openApiSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OpenAPI specification of the Tool.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool open_api_spec = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.Builder getOpenApiSpecBuilder() {
      return getOpenApiSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * OpenAPI specification of the Tool.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool open_api_spec = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiToolOrBuilder
        getOpenApiSpecOrBuilder() {
      if ((specificationCase_ == 4) && (openApiSpecBuilder_ != null)) {
        return openApiSpecBuilder_.getMessageOrBuilder();
      } else {
        if (specificationCase_ == 4) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool) specification_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * OpenAPI specification of the Tool.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool open_api_spec = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiToolOrBuilder>
        getOpenApiSpecFieldBuilder() {
      if (openApiSpecBuilder_ == null) {
        if (!(specificationCase_ == 4)) {
          specification_ =
              com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.getDefaultInstance();
        }
        openApiSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiToolOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.OpenApiTool) specification_,
                getParentForChildren(),
                isClean());
        specification_ = null;
      }
      specificationCase_ = 4;
      onChanged();
      return openApiSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreToolOrBuilder>
        dataStoreSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Data store search tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool data_store_spec = 8;</code>
     *
     * @return Whether the dataStoreSpec field is set.
     */
    @java.lang.Override
    public boolean hasDataStoreSpec() {
      return specificationCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Data store search tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool data_store_spec = 8;</code>
     *
     * @return The dataStoreSpec.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool getDataStoreSpec() {
      if (dataStoreSpecBuilder_ == null) {
        if (specificationCase_ == 8) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool) specification_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.getDefaultInstance();
      } else {
        if (specificationCase_ == 8) {
          return dataStoreSpecBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data store search tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool data_store_spec = 8;</code>
     */
    public Builder setDataStoreSpec(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool value) {
      if (dataStoreSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        specification_ = value;
        onChanged();
      } else {
        dataStoreSpecBuilder_.setMessage(value);
      }
      specificationCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data store search tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool data_store_spec = 8;</code>
     */
    public Builder setDataStoreSpec(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.Builder builderForValue) {
      if (dataStoreSpecBuilder_ == null) {
        specification_ = builderForValue.build();
        onChanged();
      } else {
        dataStoreSpecBuilder_.setMessage(builderForValue.build());
      }
      specificationCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data store search tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool data_store_spec = 8;</code>
     */
    public Builder mergeDataStoreSpec(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool value) {
      if (dataStoreSpecBuilder_ == null) {
        if (specificationCase_ == 8
            && specification_
                != com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.getDefaultInstance()) {
          specification_ =
              com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool) specification_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          specification_ = value;
        }
        onChanged();
      } else {
        if (specificationCase_ == 8) {
          dataStoreSpecBuilder_.mergeFrom(value);
        } else {
          dataStoreSpecBuilder_.setMessage(value);
        }
      }
      specificationCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data store search tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool data_store_spec = 8;</code>
     */
    public Builder clearDataStoreSpec() {
      if (dataStoreSpecBuilder_ == null) {
        if (specificationCase_ == 8) {
          specificationCase_ = 0;
          specification_ = null;
          onChanged();
        }
      } else {
        if (specificationCase_ == 8) {
          specificationCase_ = 0;
          specification_ = null;
        }
        dataStoreSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data store search tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool data_store_spec = 8;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.Builder
        getDataStoreSpecBuilder() {
      return getDataStoreSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Data store search tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool data_store_spec = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreToolOrBuilder
        getDataStoreSpecOrBuilder() {
      if ((specificationCase_ == 8) && (dataStoreSpecBuilder_ != null)) {
        return dataStoreSpecBuilder_.getMessageOrBuilder();
      } else {
        if (specificationCase_ == 8) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool) specification_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data store search tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool data_store_spec = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreToolOrBuilder>
        getDataStoreSpecFieldBuilder() {
      if (dataStoreSpecBuilder_ == null) {
        if (!(specificationCase_ == 8)) {
          specification_ =
              com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.getDefaultInstance();
        }
        dataStoreSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreToolOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.DataStoreTool) specification_,
                getParentForChildren(),
                isClean());
        specification_ = null;
      }
      specificationCase_ = 8;
      onChanged();
      return dataStoreSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionToolOrBuilder>
        extensionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Vertex extension tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool extension_spec = 11;</code>
     *
     * @return Whether the extensionSpec field is set.
     */
    @java.lang.Override
    public boolean hasExtensionSpec() {
      return specificationCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Vertex extension tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool extension_spec = 11;</code>
     *
     * @return The extensionSpec.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool getExtensionSpec() {
      if (extensionSpecBuilder_ == null) {
        if (specificationCase_ == 11) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool) specification_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.getDefaultInstance();
      } else {
        if (specificationCase_ == 11) {
          return extensionSpecBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Vertex extension tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool extension_spec = 11;</code>
     */
    public Builder setExtensionSpec(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool value) {
      if (extensionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        specification_ = value;
        onChanged();
      } else {
        extensionSpecBuilder_.setMessage(value);
      }
      specificationCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vertex extension tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool extension_spec = 11;</code>
     */
    public Builder setExtensionSpec(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.Builder builderForValue) {
      if (extensionSpecBuilder_ == null) {
        specification_ = builderForValue.build();
        onChanged();
      } else {
        extensionSpecBuilder_.setMessage(builderForValue.build());
      }
      specificationCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vertex extension tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool extension_spec = 11;</code>
     */
    public Builder mergeExtensionSpec(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool value) {
      if (extensionSpecBuilder_ == null) {
        if (specificationCase_ == 11
            && specification_
                != com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.getDefaultInstance()) {
          specification_ =
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool) specification_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          specification_ = value;
        }
        onChanged();
      } else {
        if (specificationCase_ == 11) {
          extensionSpecBuilder_.mergeFrom(value);
        } else {
          extensionSpecBuilder_.setMessage(value);
        }
      }
      specificationCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vertex extension tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool extension_spec = 11;</code>
     */
    public Builder clearExtensionSpec() {
      if (extensionSpecBuilder_ == null) {
        if (specificationCase_ == 11) {
          specificationCase_ = 0;
          specification_ = null;
          onChanged();
        }
      } else {
        if (specificationCase_ == 11) {
          specificationCase_ = 0;
          specification_ = null;
        }
        extensionSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Vertex extension tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool extension_spec = 11;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.Builder
        getExtensionSpecBuilder() {
      return getExtensionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Vertex extension tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool extension_spec = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionToolOrBuilder
        getExtensionSpecOrBuilder() {
      if ((specificationCase_ == 11) && (extensionSpecBuilder_ != null)) {
        return extensionSpecBuilder_.getMessageOrBuilder();
      } else {
        if (specificationCase_ == 11) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool) specification_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Vertex extension tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool extension_spec = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionToolOrBuilder>
        getExtensionSpecFieldBuilder() {
      if (extensionSpecBuilder_ == null) {
        if (!(specificationCase_ == 11)) {
          specification_ =
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.getDefaultInstance();
        }
        extensionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionToolOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.ExtensionTool) specification_,
                getParentForChildren(),
                isClean());
        specification_ = null;
      }
      specificationCase_ = 11;
      onChanged();
      return extensionSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionToolOrBuilder>
        functionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Client side executed function specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool function_spec = 13;</code>
     *
     * @return Whether the functionSpec field is set.
     */
    @java.lang.Override
    public boolean hasFunctionSpec() {
      return specificationCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Client side executed function specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool function_spec = 13;</code>
     *
     * @return The functionSpec.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool getFunctionSpec() {
      if (functionSpecBuilder_ == null) {
        if (specificationCase_ == 13) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool) specification_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.getDefaultInstance();
      } else {
        if (specificationCase_ == 13) {
          return functionSpecBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Client side executed function specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool function_spec = 13;</code>
     */
    public Builder setFunctionSpec(com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool value) {
      if (functionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        specification_ = value;
        onChanged();
      } else {
        functionSpecBuilder_.setMessage(value);
      }
      specificationCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client side executed function specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool function_spec = 13;</code>
     */
    public Builder setFunctionSpec(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.Builder builderForValue) {
      if (functionSpecBuilder_ == null) {
        specification_ = builderForValue.build();
        onChanged();
      } else {
        functionSpecBuilder_.setMessage(builderForValue.build());
      }
      specificationCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client side executed function specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool function_spec = 13;</code>
     */
    public Builder mergeFunctionSpec(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool value) {
      if (functionSpecBuilder_ == null) {
        if (specificationCase_ == 13
            && specification_
                != com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.getDefaultInstance()) {
          specification_ =
              com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool) specification_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          specification_ = value;
        }
        onChanged();
      } else {
        if (specificationCase_ == 13) {
          functionSpecBuilder_.mergeFrom(value);
        } else {
          functionSpecBuilder_.setMessage(value);
        }
      }
      specificationCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client side executed function specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool function_spec = 13;</code>
     */
    public Builder clearFunctionSpec() {
      if (functionSpecBuilder_ == null) {
        if (specificationCase_ == 13) {
          specificationCase_ = 0;
          specification_ = null;
          onChanged();
        }
      } else {
        if (specificationCase_ == 13) {
          specificationCase_ = 0;
          specification_ = null;
        }
        functionSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client side executed function specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool function_spec = 13;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.Builder
        getFunctionSpecBuilder() {
      return getFunctionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Client side executed function specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool function_spec = 13;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionToolOrBuilder
        getFunctionSpecOrBuilder() {
      if ((specificationCase_ == 13) && (functionSpecBuilder_ != null)) {
        return functionSpecBuilder_.getMessageOrBuilder();
      } else {
        if (specificationCase_ == 13) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool) specification_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Client side executed function specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool function_spec = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionToolOrBuilder>
        getFunctionSpecFieldBuilder() {
      if (functionSpecBuilder_ == null) {
        if (!(specificationCase_ == 13)) {
          specification_ =
              com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.getDefaultInstance();
        }
        functionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionToolOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.FunctionTool) specification_,
                getParentForChildren(),
                isClean());
        specification_ = null;
      }
      specificationCase_ = 13;
      onChanged();
      return functionSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorToolOrBuilder>
        connectorSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Integration connectors tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool connector_spec = 15;</code>
     *
     * @return Whether the connectorSpec field is set.
     */
    @java.lang.Override
    public boolean hasConnectorSpec() {
      return specificationCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Integration connectors tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool connector_spec = 15;</code>
     *
     * @return The connectorSpec.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool getConnectorSpec() {
      if (connectorSpecBuilder_ == null) {
        if (specificationCase_ == 15) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool) specification_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.getDefaultInstance();
      } else {
        if (specificationCase_ == 15) {
          return connectorSpecBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Integration connectors tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool connector_spec = 15;</code>
     */
    public Builder setConnectorSpec(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool value) {
      if (connectorSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        specification_ = value;
        onChanged();
      } else {
        connectorSpecBuilder_.setMessage(value);
      }
      specificationCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integration connectors tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool connector_spec = 15;</code>
     */
    public Builder setConnectorSpec(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Builder builderForValue) {
      if (connectorSpecBuilder_ == null) {
        specification_ = builderForValue.build();
        onChanged();
      } else {
        connectorSpecBuilder_.setMessage(builderForValue.build());
      }
      specificationCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integration connectors tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool connector_spec = 15;</code>
     */
    public Builder mergeConnectorSpec(
        com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool value) {
      if (connectorSpecBuilder_ == null) {
        if (specificationCase_ == 15
            && specification_
                != com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.getDefaultInstance()) {
          specification_ =
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool) specification_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          specification_ = value;
        }
        onChanged();
      } else {
        if (specificationCase_ == 15) {
          connectorSpecBuilder_.mergeFrom(value);
        } else {
          connectorSpecBuilder_.setMessage(value);
        }
      }
      specificationCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integration connectors tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool connector_spec = 15;</code>
     */
    public Builder clearConnectorSpec() {
      if (connectorSpecBuilder_ == null) {
        if (specificationCase_ == 15) {
          specificationCase_ = 0;
          specification_ = null;
          onChanged();
        }
      } else {
        if (specificationCase_ == 15) {
          specificationCase_ = 0;
          specification_ = null;
        }
        connectorSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integration connectors tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool connector_spec = 15;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Builder
        getConnectorSpecBuilder() {
      return getConnectorSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Integration connectors tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool connector_spec = 15;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorToolOrBuilder
        getConnectorSpecOrBuilder() {
      if ((specificationCase_ == 15) && (connectorSpecBuilder_ != null)) {
        return connectorSpecBuilder_.getMessageOrBuilder();
      } else {
        if (specificationCase_ == 15) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool) specification_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Integration connectors tool specification.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool connector_spec = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorToolOrBuilder>
        getConnectorSpecFieldBuilder() {
      if (connectorSpecBuilder_ == null) {
        if (!(specificationCase_ == 15)) {
          specification_ =
              com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.getDefaultInstance();
        }
        connectorSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorToolOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.Tool.ConnectorTool) specification_,
                getParentForChildren(),
                isClean());
        specification_ = null;
      }
      specificationCase_ = 15;
      onChanged();
      return connectorSpecBuilder_;
    }

    private int toolType_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The tool type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.ToolType tool_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for toolType.
     */
    @java.lang.Override
    public int getToolTypeValue() {
      return toolType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tool type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.ToolType tool_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for toolType to set.
     * @return This builder for chaining.
     */
    public Builder setToolTypeValue(int value) {
      toolType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tool type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.ToolType tool_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The toolType.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Tool.ToolType getToolType() {
      com.google.cloud.dialogflow.cx.v3beta1.Tool.ToolType result =
          com.google.cloud.dialogflow.cx.v3beta1.Tool.ToolType.forNumber(toolType_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Tool.ToolType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tool type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.ToolType tool_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The toolType to set.
     * @return This builder for chaining.
     */
    public Builder setToolType(com.google.cloud.dialogflow.cx.v3beta1.Tool.ToolType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      toolType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The tool type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Tool.ToolType tool_type = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearToolType() {
      bitField0_ = (bitField0_ & ~0x00000100);
      toolType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Tool)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Tool)
  private static final com.google.cloud.dialogflow.cx.v3beta1.Tool DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Tool();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Tool getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Tool> PARSER =
      new com.google.protobuf.AbstractParser<Tool>() {
        @java.lang.Override
        public Tool parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Tool> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Tool> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Tool getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
