/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/test_case.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Represents a test case.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.TestCase}
 */
public final class TestCase extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.TestCase)
    TestCaseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TestCase.newBuilder() to construct.
  private TestCase(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TestCase() {
    name_ = "";
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    displayName_ = "";
    notes_ = "";
    testCaseConversationTurns_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TestCase();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_TestCase_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_TestCase_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.TestCase.class,
            com.google.cloud.dialogflow.cx.v3beta1.TestCase.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the test case.
   * [TestCases.CreateTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase]
   * will populate the name automatically. Otherwise use format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the test case.
   * [TestCases.CreateTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase]
   * will populate the name automatically. Otherwise use format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAGS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Tags are short descriptions that users may apply to test cases for
   * organizational and filtering purposes. Each tag should start with "#" and
   * has a limit of 30 characters.
   * </pre>
   *
   * <code>repeated string tags = 2;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * Tags are short descriptions that users may apply to test cases for
   * organizational and filtering purposes. Each tag should start with "#" and
   * has a limit of 30 characters.
   * </pre>
   *
   * <code>repeated string tags = 2;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * Tags are short descriptions that users may apply to test cases for
   * organizational and filtering purposes. Each tag should start with "#" and
   * has a limit of 30 characters.
   * </pre>
   *
   * <code>repeated string tags = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Tags are short descriptions that users may apply to test cases for
   * organizational and filtering purposes. Each tag should start with "#" and
   * has a limit of 30 characters.
   * </pre>
   *
   * <code>repeated string tags = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the test case, unique within the
   * agent. Limit of 200 characters.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the test case, unique within the
   * agent. Limit of 200 characters.
   * </pre>
   *
   * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NOTES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object notes_ = "";
  /**
   *
   *
   * <pre>
   * Additional freeform notes about the test case. Limit of 400 characters.
   * </pre>
   *
   * <code>string notes = 4;</code>
   *
   * @return The notes.
   */
  @java.lang.Override
  public java.lang.String getNotes() {
    java.lang.Object ref = notes_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      notes_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Additional freeform notes about the test case. Limit of 400 characters.
   * </pre>
   *
   * <code>string notes = 4;</code>
   *
   * @return The bytes for notes.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNotesBytes() {
    java.lang.Object ref = notes_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      notes_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEST_CONFIG_FIELD_NUMBER = 13;
  private com.google.cloud.dialogflow.cx.v3beta1.TestConfig testConfig_;
  /**
   *
   *
   * <pre>
   * Config for the test case.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
   *
   * @return Whether the testConfig field is set.
   */
  @java.lang.Override
  public boolean hasTestConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Config for the test case.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
   *
   * @return The testConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TestConfig getTestConfig() {
    return testConfig_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.TestConfig.getDefaultInstance()
        : testConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for the test case.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TestConfigOrBuilder getTestConfigOrBuilder() {
    return testConfig_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.TestConfig.getDefaultInstance()
        : testConfig_;
  }

  public static final int TEST_CASE_CONVERSATION_TURNS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn>
      testCaseConversationTurns_;
  /**
   *
   *
   * <pre>
   * The conversation turns uttered when the test case was created, in
   * chronological order. These include the canonical set of agent utterances
   * that should occur when the agent is working properly.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn>
      getTestCaseConversationTurnsList() {
    return testCaseConversationTurns_;
  }
  /**
   *
   *
   * <pre>
   * The conversation turns uttered when the test case was created, in
   * chronological order. These include the canonical set of agent utterances
   * that should occur when the agent is working properly.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.ConversationTurnOrBuilder>
      getTestCaseConversationTurnsOrBuilderList() {
    return testCaseConversationTurns_;
  }
  /**
   *
   *
   * <pre>
   * The conversation turns uttered when the test case was created, in
   * chronological order. These include the canonical set of agent utterances
   * that should occur when the agent is working properly.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
   * </code>
   */
  @java.lang.Override
  public int getTestCaseConversationTurnsCount() {
    return testCaseConversationTurns_.size();
  }
  /**
   *
   *
   * <pre>
   * The conversation turns uttered when the test case was created, in
   * chronological order. These include the canonical set of agent utterances
   * that should occur when the agent is working properly.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn getTestCaseConversationTurns(
      int index) {
    return testCaseConversationTurns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The conversation turns uttered when the test case was created, in
   * chronological order. These include the canonical set of agent utterances
   * that should occur when the agent is working properly.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ConversationTurnOrBuilder
      getTestCaseConversationTurnsOrBuilder(int index) {
    return testCaseConversationTurns_.get(index);
  }

  public static final int CREATION_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp creationTime_;
  /**
   *
   *
   * <pre>
   * Output only. When the test was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the creationTime field is set.
   */
  @java.lang.Override
  public boolean hasCreationTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. When the test was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The creationTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreationTime() {
    return creationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : creationTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the test was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreationTimeOrBuilder() {
    return creationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : creationTime_;
  }

  public static final int LAST_TEST_RESULT_FIELD_NUMBER = 12;
  private com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult lastTestResult_;
  /**
   *
   *
   * <pre>
   * The latest test result.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
   *
   * @return Whether the lastTestResult field is set.
   */
  @java.lang.Override
  public boolean hasLastTestResult() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The latest test result.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
   *
   * @return The lastTestResult.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult getLastTestResult() {
    return lastTestResult_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult.getDefaultInstance()
        : lastTestResult_;
  }
  /**
   *
   *
   * <pre>
   * The latest test result.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TestCaseResultOrBuilder
      getLastTestResultOrBuilder() {
    return lastTestResult_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult.getDefaultInstance()
        : lastTestResult_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, tags_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notes_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, notes_);
    }
    for (int i = 0; i < testCaseConversationTurns_.size(); i++) {
      output.writeMessage(5, testCaseConversationTurns_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getCreationTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(12, getLastTestResult());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(13, getTestConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTagsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notes_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, notes_);
    }
    for (int i = 0; i < testCaseConversationTurns_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, testCaseConversationTurns_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCreationTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getLastTestResult());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getTestConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.TestCase)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.TestCase other =
        (com.google.cloud.dialogflow.cx.v3beta1.TestCase) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getNotes().equals(other.getNotes())) return false;
    if (hasTestConfig() != other.hasTestConfig()) return false;
    if (hasTestConfig()) {
      if (!getTestConfig().equals(other.getTestConfig())) return false;
    }
    if (!getTestCaseConversationTurnsList().equals(other.getTestCaseConversationTurnsList()))
      return false;
    if (hasCreationTime() != other.hasCreationTime()) return false;
    if (hasCreationTime()) {
      if (!getCreationTime().equals(other.getCreationTime())) return false;
    }
    if (hasLastTestResult() != other.hasLastTestResult()) return false;
    if (hasLastTestResult()) {
      if (!getLastTestResult().equals(other.getLastTestResult())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + NOTES_FIELD_NUMBER;
    hash = (53 * hash) + getNotes().hashCode();
    if (hasTestConfig()) {
      hash = (37 * hash) + TEST_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getTestConfig().hashCode();
    }
    if (getTestCaseConversationTurnsCount() > 0) {
      hash = (37 * hash) + TEST_CASE_CONVERSATION_TURNS_FIELD_NUMBER;
      hash = (53 * hash) + getTestCaseConversationTurnsList().hashCode();
    }
    if (hasCreationTime()) {
      hash = (37 * hash) + CREATION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTime().hashCode();
    }
    if (hasLastTestResult()) {
      hash = (37 * hash) + LAST_TEST_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getLastTestResult().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.TestCase prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a test case.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.TestCase}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.TestCase)
      com.google.cloud.dialogflow.cx.v3beta1.TestCaseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_TestCase_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_TestCase_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.TestCase.class,
              com.google.cloud.dialogflow.cx.v3beta1.TestCase.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.TestCase.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTestConfigFieldBuilder();
        getTestCaseConversationTurnsFieldBuilder();
        getCreationTimeFieldBuilder();
        getLastTestResultFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      displayName_ = "";
      notes_ = "";
      testConfig_ = null;
      if (testConfigBuilder_ != null) {
        testConfigBuilder_.dispose();
        testConfigBuilder_ = null;
      }
      if (testCaseConversationTurnsBuilder_ == null) {
        testCaseConversationTurns_ = java.util.Collections.emptyList();
      } else {
        testCaseConversationTurns_ = null;
        testCaseConversationTurnsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      creationTime_ = null;
      if (creationTimeBuilder_ != null) {
        creationTimeBuilder_.dispose();
        creationTimeBuilder_ = null;
      }
      lastTestResult_ = null;
      if (lastTestResultBuilder_ != null) {
        lastTestResultBuilder_.dispose();
        lastTestResultBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_TestCase_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TestCase getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCase.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TestCase build() {
      com.google.cloud.dialogflow.cx.v3beta1.TestCase result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TestCase buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.TestCase result =
          new com.google.cloud.dialogflow.cx.v3beta1.TestCase(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3beta1.TestCase result) {
      if (testCaseConversationTurnsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          testCaseConversationTurns_ =
              java.util.Collections.unmodifiableList(testCaseConversationTurns_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.testCaseConversationTurns_ = testCaseConversationTurns_;
      } else {
        result.testCaseConversationTurns_ = testCaseConversationTurnsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.TestCase result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.notes_ = notes_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.testConfig_ = testConfigBuilder_ == null ? testConfig_ : testConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.creationTime_ =
            creationTimeBuilder_ == null ? creationTime_ : creationTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.lastTestResult_ =
            lastTestResultBuilder_ == null ? lastTestResult_ : lastTestResultBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.TestCase) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.TestCase) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.TestCase other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.TestCase.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00000002;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getNotes().isEmpty()) {
        notes_ = other.notes_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasTestConfig()) {
        mergeTestConfig(other.getTestConfig());
      }
      if (testCaseConversationTurnsBuilder_ == null) {
        if (!other.testCaseConversationTurns_.isEmpty()) {
          if (testCaseConversationTurns_.isEmpty()) {
            testCaseConversationTurns_ = other.testCaseConversationTurns_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureTestCaseConversationTurnsIsMutable();
            testCaseConversationTurns_.addAll(other.testCaseConversationTurns_);
          }
          onChanged();
        }
      } else {
        if (!other.testCaseConversationTurns_.isEmpty()) {
          if (testCaseConversationTurnsBuilder_.isEmpty()) {
            testCaseConversationTurnsBuilder_.dispose();
            testCaseConversationTurnsBuilder_ = null;
            testCaseConversationTurns_ = other.testCaseConversationTurns_;
            bitField0_ = (bitField0_ & ~0x00000020);
            testCaseConversationTurnsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTestCaseConversationTurnsFieldBuilder()
                    : null;
          } else {
            testCaseConversationTurnsBuilder_.addAllMessages(other.testCaseConversationTurns_);
          }
        }
      }
      if (other.hasCreationTime()) {
        mergeCreationTime(other.getCreationTime());
      }
      if (other.hasLastTestResult()) {
        mergeLastTestResult(other.getLastTestResult());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 18
            case 26:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                notes_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.parser(),
                        extensionRegistry);
                if (testCaseConversationTurnsBuilder_ == null) {
                  ensureTestCaseConversationTurnsIsMutable();
                  testCaseConversationTurns_.add(m);
                } else {
                  testCaseConversationTurnsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 82:
              {
                input.readMessage(getCreationTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 82
            case 98:
              {
                input.readMessage(getLastTestResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getTestConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the test case.
     * [TestCases.CreateTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase]
     * will populate the name automatically. Otherwise use format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the test case.
     * [TestCases.CreateTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase]
     * will populate the name automatically. Otherwise use format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the test case.
     * [TestCases.CreateTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase]
     * will populate the name automatically. Otherwise use format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the test case.
     * [TestCases.CreateTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase]
     * will populate the name automatically. Otherwise use format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the test case.
     * [TestCases.CreateTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase]
     * will populate the name automatically. Otherwise use format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/testCases/&lt;TestCaseID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Tags are short descriptions that users may apply to test cases for
     * organizational and filtering purposes. Each tag should start with "#" and
     * has a limit of 30 characters.
     * </pre>
     *
     * <code>repeated string tags = 2;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * Tags are short descriptions that users may apply to test cases for
     * organizational and filtering purposes. Each tag should start with "#" and
     * has a limit of 30 characters.
     * </pre>
     *
     * <code>repeated string tags = 2;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * Tags are short descriptions that users may apply to test cases for
     * organizational and filtering purposes. Each tag should start with "#" and
     * has a limit of 30 characters.
     * </pre>
     *
     * <code>repeated string tags = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Tags are short descriptions that users may apply to test cases for
     * organizational and filtering purposes. Each tag should start with "#" and
     * has a limit of 30 characters.
     * </pre>
     *
     * <code>repeated string tags = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Tags are short descriptions that users may apply to test cases for
     * organizational and filtering purposes. Each tag should start with "#" and
     * has a limit of 30 characters.
     * </pre>
     *
     * <code>repeated string tags = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags are short descriptions that users may apply to test cases for
     * organizational and filtering purposes. Each tag should start with "#" and
     * has a limit of 30 characters.
     * </pre>
     *
     * <code>repeated string tags = 2;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags are short descriptions that users may apply to test cases for
     * organizational and filtering purposes. Each tag should start with "#" and
     * has a limit of 30 characters.
     * </pre>
     *
     * <code>repeated string tags = 2;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags are short descriptions that users may apply to test cases for
     * organizational and filtering purposes. Each tag should start with "#" and
     * has a limit of 30 characters.
     * </pre>
     *
     * <code>repeated string tags = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags are short descriptions that users may apply to test cases for
     * organizational and filtering purposes. Each tag should start with "#" and
     * has a limit of 30 characters.
     * </pre>
     *
     * <code>repeated string tags = 2;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the test case, unique within the
     * agent. Limit of 200 characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the test case, unique within the
     * agent. Limit of 200 characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the test case, unique within the
     * agent. Limit of 200 characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the test case, unique within the
     * agent. Limit of 200 characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the test case, unique within the
     * agent. Limit of 200 characters.
     * </pre>
     *
     * <code>string display_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object notes_ = "";
    /**
     *
     *
     * <pre>
     * Additional freeform notes about the test case. Limit of 400 characters.
     * </pre>
     *
     * <code>string notes = 4;</code>
     *
     * @return The notes.
     */
    public java.lang.String getNotes() {
      java.lang.Object ref = notes_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        notes_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional freeform notes about the test case. Limit of 400 characters.
     * </pre>
     *
     * <code>string notes = 4;</code>
     *
     * @return The bytes for notes.
     */
    public com.google.protobuf.ByteString getNotesBytes() {
      java.lang.Object ref = notes_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        notes_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional freeform notes about the test case. Limit of 400 characters.
     * </pre>
     *
     * <code>string notes = 4;</code>
     *
     * @param value The notes to set.
     * @return This builder for chaining.
     */
    public Builder setNotes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      notes_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional freeform notes about the test case. Limit of 400 characters.
     * </pre>
     *
     * <code>string notes = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNotes() {
      notes_ = getDefaultInstance().getNotes();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional freeform notes about the test case. Limit of 400 characters.
     * </pre>
     *
     * <code>string notes = 4;</code>
     *
     * @param value The bytes for notes to set.
     * @return This builder for chaining.
     */
    public Builder setNotesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      notes_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.TestConfig testConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.TestConfig,
            com.google.cloud.dialogflow.cx.v3beta1.TestConfig.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.TestConfigOrBuilder>
        testConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
     *
     * @return Whether the testConfig field is set.
     */
    public boolean hasTestConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
     *
     * @return The testConfig.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TestConfig getTestConfig() {
      if (testConfigBuilder_ == null) {
        return testConfig_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.TestConfig.getDefaultInstance()
            : testConfig_;
      } else {
        return testConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
     */
    public Builder setTestConfig(com.google.cloud.dialogflow.cx.v3beta1.TestConfig value) {
      if (testConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        testConfig_ = value;
      } else {
        testConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
     */
    public Builder setTestConfig(
        com.google.cloud.dialogflow.cx.v3beta1.TestConfig.Builder builderForValue) {
      if (testConfigBuilder_ == null) {
        testConfig_ = builderForValue.build();
      } else {
        testConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
     */
    public Builder mergeTestConfig(com.google.cloud.dialogflow.cx.v3beta1.TestConfig value) {
      if (testConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && testConfig_ != null
            && testConfig_
                != com.google.cloud.dialogflow.cx.v3beta1.TestConfig.getDefaultInstance()) {
          getTestConfigBuilder().mergeFrom(value);
        } else {
          testConfig_ = value;
        }
      } else {
        testConfigBuilder_.mergeFrom(value);
      }
      if (testConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
     */
    public Builder clearTestConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      testConfig_ = null;
      if (testConfigBuilder_ != null) {
        testConfigBuilder_.dispose();
        testConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TestConfig.Builder getTestConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getTestConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TestConfigOrBuilder getTestConfigOrBuilder() {
      if (testConfigBuilder_ != null) {
        return testConfigBuilder_.getMessageOrBuilder();
      } else {
        return testConfig_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.TestConfig.getDefaultInstance()
            : testConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestConfig test_config = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.TestConfig,
            com.google.cloud.dialogflow.cx.v3beta1.TestConfig.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.TestConfigOrBuilder>
        getTestConfigFieldBuilder() {
      if (testConfigBuilder_ == null) {
        testConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.TestConfig,
                com.google.cloud.dialogflow.cx.v3beta1.TestConfig.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.TestConfigOrBuilder>(
                getTestConfig(), getParentForChildren(), isClean());
        testConfig_ = null;
      }
      return testConfigBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn>
        testCaseConversationTurns_ = java.util.Collections.emptyList();

    private void ensureTestCaseConversationTurnsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        testCaseConversationTurns_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn>(
                testCaseConversationTurns_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn,
            com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ConversationTurnOrBuilder>
        testCaseConversationTurnsBuilder_;

    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn>
        getTestCaseConversationTurnsList() {
      if (testCaseConversationTurnsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(testCaseConversationTurns_);
      } else {
        return testCaseConversationTurnsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public int getTestCaseConversationTurnsCount() {
      if (testCaseConversationTurnsBuilder_ == null) {
        return testCaseConversationTurns_.size();
      } else {
        return testCaseConversationTurnsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn getTestCaseConversationTurns(
        int index) {
      if (testCaseConversationTurnsBuilder_ == null) {
        return testCaseConversationTurns_.get(index);
      } else {
        return testCaseConversationTurnsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public Builder setTestCaseConversationTurns(
        int index, com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn value) {
      if (testCaseConversationTurnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTestCaseConversationTurnsIsMutable();
        testCaseConversationTurns_.set(index, value);
        onChanged();
      } else {
        testCaseConversationTurnsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public Builder setTestCaseConversationTurns(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.Builder builderForValue) {
      if (testCaseConversationTurnsBuilder_ == null) {
        ensureTestCaseConversationTurnsIsMutable();
        testCaseConversationTurns_.set(index, builderForValue.build());
        onChanged();
      } else {
        testCaseConversationTurnsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public Builder addTestCaseConversationTurns(
        com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn value) {
      if (testCaseConversationTurnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTestCaseConversationTurnsIsMutable();
        testCaseConversationTurns_.add(value);
        onChanged();
      } else {
        testCaseConversationTurnsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public Builder addTestCaseConversationTurns(
        int index, com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn value) {
      if (testCaseConversationTurnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTestCaseConversationTurnsIsMutable();
        testCaseConversationTurns_.add(index, value);
        onChanged();
      } else {
        testCaseConversationTurnsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public Builder addTestCaseConversationTurns(
        com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.Builder builderForValue) {
      if (testCaseConversationTurnsBuilder_ == null) {
        ensureTestCaseConversationTurnsIsMutable();
        testCaseConversationTurns_.add(builderForValue.build());
        onChanged();
      } else {
        testCaseConversationTurnsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public Builder addTestCaseConversationTurns(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.Builder builderForValue) {
      if (testCaseConversationTurnsBuilder_ == null) {
        ensureTestCaseConversationTurnsIsMutable();
        testCaseConversationTurns_.add(index, builderForValue.build());
        onChanged();
      } else {
        testCaseConversationTurnsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public Builder addAllTestCaseConversationTurns(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn>
            values) {
      if (testCaseConversationTurnsBuilder_ == null) {
        ensureTestCaseConversationTurnsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, testCaseConversationTurns_);
        onChanged();
      } else {
        testCaseConversationTurnsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public Builder clearTestCaseConversationTurns() {
      if (testCaseConversationTurnsBuilder_ == null) {
        testCaseConversationTurns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        testCaseConversationTurnsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public Builder removeTestCaseConversationTurns(int index) {
      if (testCaseConversationTurnsBuilder_ == null) {
        ensureTestCaseConversationTurnsIsMutable();
        testCaseConversationTurns_.remove(index);
        onChanged();
      } else {
        testCaseConversationTurnsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.Builder
        getTestCaseConversationTurnsBuilder(int index) {
      return getTestCaseConversationTurnsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ConversationTurnOrBuilder
        getTestCaseConversationTurnsOrBuilder(int index) {
      if (testCaseConversationTurnsBuilder_ == null) {
        return testCaseConversationTurns_.get(index);
      } else {
        return testCaseConversationTurnsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.ConversationTurnOrBuilder>
        getTestCaseConversationTurnsOrBuilderList() {
      if (testCaseConversationTurnsBuilder_ != null) {
        return testCaseConversationTurnsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(testCaseConversationTurns_);
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.Builder
        addTestCaseConversationTurnsBuilder() {
      return getTestCaseConversationTurnsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.Builder
        addTestCaseConversationTurnsBuilder(int index) {
      return getTestCaseConversationTurnsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The conversation turns uttered when the test case was created, in
     * chronological order. These include the canonical set of agent utterances
     * that should occur when the agent is working properly.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ConversationTurn test_case_conversation_turns = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.Builder>
        getTestCaseConversationTurnsBuilderList() {
      return getTestCaseConversationTurnsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn,
            com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ConversationTurnOrBuilder>
        getTestCaseConversationTurnsFieldBuilder() {
      if (testCaseConversationTurnsBuilder_ == null) {
        testCaseConversationTurnsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn,
                com.google.cloud.dialogflow.cx.v3beta1.ConversationTurn.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ConversationTurnOrBuilder>(
                testCaseConversationTurns_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        testCaseConversationTurns_ = null;
      }
      return testCaseConversationTurnsBuilder_;
    }

    private com.google.protobuf.Timestamp creationTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        creationTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. When the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the creationTime field is set.
     */
    public boolean hasCreationTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. When the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The creationTime.
     */
    public com.google.protobuf.Timestamp getCreationTime() {
      if (creationTimeBuilder_ == null) {
        return creationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : creationTime_;
      } else {
        return creationTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreationTime(com.google.protobuf.Timestamp value) {
      if (creationTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        creationTime_ = value;
      } else {
        creationTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreationTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (creationTimeBuilder_ == null) {
        creationTime_ = builderForValue.build();
      } else {
        creationTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreationTime(com.google.protobuf.Timestamp value) {
      if (creationTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && creationTime_ != null
            && creationTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreationTimeBuilder().mergeFrom(value);
        } else {
          creationTime_ = value;
        }
      } else {
        creationTimeBuilder_.mergeFrom(value);
      }
      if (creationTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreationTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      creationTime_ = null;
      if (creationTimeBuilder_ != null) {
        creationTimeBuilder_.dispose();
        creationTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreationTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreationTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. When the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreationTimeOrBuilder() {
      if (creationTimeBuilder_ != null) {
        return creationTimeBuilder_.getMessageOrBuilder();
      } else {
        return creationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : creationTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the test was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp creation_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreationTimeFieldBuilder() {
      if (creationTimeBuilder_ == null) {
        creationTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreationTime(), getParentForChildren(), isClean());
        creationTime_ = null;
      }
      return creationTimeBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult lastTestResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult,
            com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.TestCaseResultOrBuilder>
        lastTestResultBuilder_;
    /**
     *
     *
     * <pre>
     * The latest test result.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
     *
     * @return Whether the lastTestResult field is set.
     */
    public boolean hasLastTestResult() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The latest test result.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
     *
     * @return The lastTestResult.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult getLastTestResult() {
      if (lastTestResultBuilder_ == null) {
        return lastTestResult_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult.getDefaultInstance()
            : lastTestResult_;
      } else {
        return lastTestResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The latest test result.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
     */
    public Builder setLastTestResult(com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult value) {
      if (lastTestResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastTestResult_ = value;
      } else {
        lastTestResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest test result.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
     */
    public Builder setLastTestResult(
        com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult.Builder builderForValue) {
      if (lastTestResultBuilder_ == null) {
        lastTestResult_ = builderForValue.build();
      } else {
        lastTestResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest test result.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
     */
    public Builder mergeLastTestResult(
        com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult value) {
      if (lastTestResultBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && lastTestResult_ != null
            && lastTestResult_
                != com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult.getDefaultInstance()) {
          getLastTestResultBuilder().mergeFrom(value);
        } else {
          lastTestResult_ = value;
        }
      } else {
        lastTestResultBuilder_.mergeFrom(value);
      }
      if (lastTestResult_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest test result.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
     */
    public Builder clearLastTestResult() {
      bitField0_ = (bitField0_ & ~0x00000080);
      lastTestResult_ = null;
      if (lastTestResultBuilder_ != null) {
        lastTestResultBuilder_.dispose();
        lastTestResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latest test result.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult.Builder
        getLastTestResultBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getLastTestResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The latest test result.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TestCaseResultOrBuilder
        getLastTestResultOrBuilder() {
      if (lastTestResultBuilder_ != null) {
        return lastTestResultBuilder_.getMessageOrBuilder();
      } else {
        return lastTestResult_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult.getDefaultInstance()
            : lastTestResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * The latest test result.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TestCaseResult last_test_result = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult,
            com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.TestCaseResultOrBuilder>
        getLastTestResultFieldBuilder() {
      if (lastTestResultBuilder_ == null) {
        lastTestResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult,
                com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.TestCaseResultOrBuilder>(
                getLastTestResult(), getParentForChildren(), isClean());
        lastTestResult_ = null;
      }
      return lastTestResultBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.TestCase)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.TestCase)
  private static final com.google.cloud.dialogflow.cx.v3beta1.TestCase DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.TestCase();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TestCase getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TestCase> PARSER =
      new com.google.protobuf.AbstractParser<TestCase>() {
        @java.lang.Override
        public TestCase parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TestCase> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TestCase> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TestCase getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
