/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/safety_settings.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Settings for Generative Safety.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.SafetySettings}
 */
public final class SafetySettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.SafetySettings)
    SafetySettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SafetySettings.newBuilder() to construct.
  private SafetySettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SafetySettings() {
    defaultBannedPhraseMatchStrategy_ = 0;
    bannedPhrases_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SafetySettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.SafetySettingsProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_SafetySettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.SafetySettingsProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_SafetySettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.class,
            com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Strategy for matching phrases.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy}
   */
  public enum PhraseMatchStrategy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified, defaults to PARTIAL_MATCH.
     * </pre>
     *
     * <code>PHRASE_MATCH_STRATEGY_UNSPECIFIED = 0;</code>
     */
    PHRASE_MATCH_STRATEGY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Text that contains the phrase as a substring will be matched, e.g. "foo"
     * will match "afoobar".
     * </pre>
     *
     * <code>PARTIAL_MATCH = 1;</code>
     */
    PARTIAL_MATCH(1),
    /**
     *
     *
     * <pre>
     * Text that contains the tokenized words of the phrase will be matched,
     * e.g. "foo" will match "a foo bar" and "foo bar", but not "foobar".
     * </pre>
     *
     * <code>WORD_MATCH = 2;</code>
     */
    WORD_MATCH(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified, defaults to PARTIAL_MATCH.
     * </pre>
     *
     * <code>PHRASE_MATCH_STRATEGY_UNSPECIFIED = 0;</code>
     */
    public static final int PHRASE_MATCH_STRATEGY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Text that contains the phrase as a substring will be matched, e.g. "foo"
     * will match "afoobar".
     * </pre>
     *
     * <code>PARTIAL_MATCH = 1;</code>
     */
    public static final int PARTIAL_MATCH_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Text that contains the tokenized words of the phrase will be matched,
     * e.g. "foo" will match "a foo bar" and "foo bar", but not "foobar".
     * </pre>
     *
     * <code>WORD_MATCH = 2;</code>
     */
    public static final int WORD_MATCH_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PhraseMatchStrategy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PhraseMatchStrategy forNumber(int value) {
      switch (value) {
        case 0:
          return PHRASE_MATCH_STRATEGY_UNSPECIFIED;
        case 1:
          return PARTIAL_MATCH;
        case 2:
          return WORD_MATCH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PhraseMatchStrategy>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PhraseMatchStrategy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PhraseMatchStrategy>() {
              public PhraseMatchStrategy findValueByNumber(int number) {
                return PhraseMatchStrategy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final PhraseMatchStrategy[] VALUES = values();

    public static PhraseMatchStrategy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PhraseMatchStrategy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy)
  }

  public interface PhraseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Text input which can be used for prompt or banned phrases.
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The text.
     */
    java.lang.String getText();
    /**
     *
     *
     * <pre>
     * Required. Text input which can be used for prompt or banned phrases.
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();

    /**
     *
     *
     * <pre>
     * Required. Language code of the phrase.
     * </pre>
     *
     * <code>string language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The languageCode.
     */
    java.lang.String getLanguageCode();
    /**
     *
     *
     * <pre>
     * Required. Language code of the phrase.
     * </pre>
     *
     * <code>string language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for languageCode.
     */
    com.google.protobuf.ByteString getLanguageCodeBytes();
  }
  /**
   *
   *
   * <pre>
   * Text input which can be used for prompt or banned phrases.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase}
   */
  public static final class Phrase extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase)
      PhraseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Phrase.newBuilder() to construct.
    private Phrase(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Phrase() {
      text_ = "";
      languageCode_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Phrase();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.SafetySettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_SafetySettings_Phrase_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.SafetySettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_SafetySettings_Phrase_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.class,
              com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.Builder.class);
    }

    public static final int TEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object text_ = "";
    /**
     *
     *
     * <pre>
     * Required. Text input which can be used for prompt or banned phrases.
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Text input which can be used for prompt or banned phrases.
     * </pre>
     *
     * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LANGUAGE_CODE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. Language code of the phrase.
     * </pre>
     *
     * <code>string language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The languageCode.
     */
    @java.lang.Override
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Language code of the phrase.
     * </pre>
     *
     * <code>string language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for languageCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, languageCode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, languageCode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase other =
          (com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase) obj;

      if (!getText().equals(other.getText())) return false;
      if (!getLanguageCode().equals(other.getLanguageCode())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
      hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getLanguageCode().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Text input which can be used for prompt or banned phrases.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase)
        com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.SafetySettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_SafetySettings_Phrase_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.SafetySettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_SafetySettings_Phrase_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.class,
                com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        text_ = "";
        languageCode_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.SafetySettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_SafetySettings_Phrase_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase build() {
        com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase result =
            new com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.text_ = text_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.languageCode_ = languageCode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.getDefaultInstance())
          return this;
        if (!other.getText().isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getLanguageCode().isEmpty()) {
          languageCode_ = other.languageCode_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  text_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  languageCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object text_ = "";
      /**
       *
       *
       * <pre>
       * Required. Text input which can be used for prompt or banned phrases.
       * </pre>
       *
       * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The text.
       */
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Text input which can be used for prompt or banned phrases.
       * </pre>
       *
       * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for text.
       */
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Text input which can be used for prompt or banned phrases.
       * </pre>
       *
       * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Text input which can be used for prompt or banned phrases.
       * </pre>
       *
       * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = getDefaultInstance().getText();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Text input which can be used for prompt or banned phrases.
       * </pre>
       *
       * <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object languageCode_ = "";
      /**
       *
       *
       * <pre>
       * Required. Language code of the phrase.
       * </pre>
       *
       * <code>string language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The languageCode.
       */
      public java.lang.String getLanguageCode() {
        java.lang.Object ref = languageCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          languageCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Language code of the phrase.
       * </pre>
       *
       * <code>string language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for languageCode.
       */
      public com.google.protobuf.ByteString getLanguageCodeBytes() {
        java.lang.Object ref = languageCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          languageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Language code of the phrase.
       * </pre>
       *
       * <code>string language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The languageCode to set.
       * @return This builder for chaining.
       */
      public Builder setLanguageCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        languageCode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Language code of the phrase.
       * </pre>
       *
       * <code>string language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLanguageCode() {
        languageCode_ = getDefaultInstance().getLanguageCode();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Language code of the phrase.
       * </pre>
       *
       * <code>string language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for languageCode to set.
       * @return This builder for chaining.
       */
      public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        languageCode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase)
    private static final com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Phrase> PARSER =
        new com.google.protobuf.AbstractParser<Phrase>() {
          @java.lang.Override
          public Phrase parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Phrase> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Phrase> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int DEFAULT_BANNED_PHRASE_MATCH_STRATEGY_FIELD_NUMBER = 4;
  private int defaultBannedPhraseMatchStrategy_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Default phrase match strategy for banned phrases.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy default_banned_phrase_match_strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for defaultBannedPhraseMatchStrategy.
   */
  @java.lang.Override
  public int getDefaultBannedPhraseMatchStrategyValue() {
    return defaultBannedPhraseMatchStrategy_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Default phrase match strategy for banned phrases.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy default_banned_phrase_match_strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The defaultBannedPhraseMatchStrategy.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy
      getDefaultBannedPhraseMatchStrategy() {
    com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy result =
        com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy.forNumber(
            defaultBannedPhraseMatchStrategy_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy.UNRECOGNIZED
        : result;
  }

  public static final int BANNED_PHRASES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase>
      bannedPhrases_;
  /**
   *
   *
   * <pre>
   * Banned phrases for generated text.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase>
      getBannedPhrasesList() {
    return bannedPhrases_;
  }
  /**
   *
   *
   * <pre>
   * Banned phrases for generated text.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseOrBuilder>
      getBannedPhrasesOrBuilderList() {
    return bannedPhrases_;
  }
  /**
   *
   *
   * <pre>
   * Banned phrases for generated text.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
   * </code>
   */
  @java.lang.Override
  public int getBannedPhrasesCount() {
    return bannedPhrases_.size();
  }
  /**
   *
   *
   * <pre>
   * Banned phrases for generated text.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase getBannedPhrases(int index) {
    return bannedPhrases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Banned phrases for generated text.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseOrBuilder
      getBannedPhrasesOrBuilder(int index) {
    return bannedPhrases_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < bannedPhrases_.size(); i++) {
      output.writeMessage(1, bannedPhrases_.get(i));
    }
    if (defaultBannedPhraseMatchStrategy_
        != com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy
            .PHRASE_MATCH_STRATEGY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, defaultBannedPhraseMatchStrategy_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < bannedPhrases_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, bannedPhrases_.get(i));
    }
    if (defaultBannedPhraseMatchStrategy_
        != com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy
            .PHRASE_MATCH_STRATEGY_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              4, defaultBannedPhraseMatchStrategy_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.SafetySettings)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.SafetySettings other =
        (com.google.cloud.dialogflow.cx.v3beta1.SafetySettings) obj;

    if (defaultBannedPhraseMatchStrategy_ != other.defaultBannedPhraseMatchStrategy_) return false;
    if (!getBannedPhrasesList().equals(other.getBannedPhrasesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DEFAULT_BANNED_PHRASE_MATCH_STRATEGY_FIELD_NUMBER;
    hash = (53 * hash) + defaultBannedPhraseMatchStrategy_;
    if (getBannedPhrasesCount() > 0) {
      hash = (37 * hash) + BANNED_PHRASES_FIELD_NUMBER;
      hash = (53 * hash) + getBannedPhrasesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.SafetySettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Settings for Generative Safety.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.SafetySettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.SafetySettings)
      com.google.cloud.dialogflow.cx.v3beta1.SafetySettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.SafetySettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_SafetySettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.SafetySettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_SafetySettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.class,
              com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      defaultBannedPhraseMatchStrategy_ = 0;
      if (bannedPhrasesBuilder_ == null) {
        bannedPhrases_ = java.util.Collections.emptyList();
      } else {
        bannedPhrases_ = null;
        bannedPhrasesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.SafetySettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_SafetySettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings build() {
      com.google.cloud.dialogflow.cx.v3beta1.SafetySettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.SafetySettings result =
          new com.google.cloud.dialogflow.cx.v3beta1.SafetySettings(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3beta1.SafetySettings result) {
      if (bannedPhrasesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          bannedPhrases_ = java.util.Collections.unmodifiableList(bannedPhrases_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.bannedPhrases_ = bannedPhrases_;
      } else {
        result.bannedPhrases_ = bannedPhrasesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.SafetySettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.defaultBannedPhraseMatchStrategy_ = defaultBannedPhraseMatchStrategy_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.SafetySettings) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.SafetySettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.SafetySettings other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.getDefaultInstance())
        return this;
      if (other.defaultBannedPhraseMatchStrategy_ != 0) {
        setDefaultBannedPhraseMatchStrategyValue(other.getDefaultBannedPhraseMatchStrategyValue());
      }
      if (bannedPhrasesBuilder_ == null) {
        if (!other.bannedPhrases_.isEmpty()) {
          if (bannedPhrases_.isEmpty()) {
            bannedPhrases_ = other.bannedPhrases_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureBannedPhrasesIsMutable();
            bannedPhrases_.addAll(other.bannedPhrases_);
          }
          onChanged();
        }
      } else {
        if (!other.bannedPhrases_.isEmpty()) {
          if (bannedPhrasesBuilder_.isEmpty()) {
            bannedPhrasesBuilder_.dispose();
            bannedPhrasesBuilder_ = null;
            bannedPhrases_ = other.bannedPhrases_;
            bitField0_ = (bitField0_ & ~0x00000002);
            bannedPhrasesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBannedPhrasesFieldBuilder()
                    : null;
          } else {
            bannedPhrasesBuilder_.addAllMessages(other.bannedPhrases_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.parser(),
                        extensionRegistry);
                if (bannedPhrasesBuilder_ == null) {
                  ensureBannedPhrasesIsMutable();
                  bannedPhrases_.add(m);
                } else {
                  bannedPhrasesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 32:
              {
                defaultBannedPhraseMatchStrategy_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int defaultBannedPhraseMatchStrategy_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Default phrase match strategy for banned phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy default_banned_phrase_match_strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for defaultBannedPhraseMatchStrategy.
     */
    @java.lang.Override
    public int getDefaultBannedPhraseMatchStrategyValue() {
      return defaultBannedPhraseMatchStrategy_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default phrase match strategy for banned phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy default_banned_phrase_match_strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for defaultBannedPhraseMatchStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultBannedPhraseMatchStrategyValue(int value) {
      defaultBannedPhraseMatchStrategy_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default phrase match strategy for banned phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy default_banned_phrase_match_strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The defaultBannedPhraseMatchStrategy.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy
        getDefaultBannedPhraseMatchStrategy() {
      com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy result =
          com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy.forNumber(
              defaultBannedPhraseMatchStrategy_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default phrase match strategy for banned phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy default_banned_phrase_match_strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The defaultBannedPhraseMatchStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultBannedPhraseMatchStrategy(
        com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      defaultBannedPhraseMatchStrategy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default phrase match strategy for banned phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseMatchStrategy default_banned_phrase_match_strategy = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultBannedPhraseMatchStrategy() {
      bitField0_ = (bitField0_ & ~0x00000001);
      defaultBannedPhraseMatchStrategy_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase>
        bannedPhrases_ = java.util.Collections.emptyList();

    private void ensureBannedPhrasesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        bannedPhrases_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase>(
                bannedPhrases_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase,
            com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseOrBuilder>
        bannedPhrasesBuilder_;

    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase>
        getBannedPhrasesList() {
      if (bannedPhrasesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(bannedPhrases_);
      } else {
        return bannedPhrasesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public int getBannedPhrasesCount() {
      if (bannedPhrasesBuilder_ == null) {
        return bannedPhrases_.size();
      } else {
        return bannedPhrasesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase getBannedPhrases(
        int index) {
      if (bannedPhrasesBuilder_ == null) {
        return bannedPhrases_.get(index);
      } else {
        return bannedPhrasesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public Builder setBannedPhrases(
        int index, com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase value) {
      if (bannedPhrasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBannedPhrasesIsMutable();
        bannedPhrases_.set(index, value);
        onChanged();
      } else {
        bannedPhrasesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public Builder setBannedPhrases(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.Builder builderForValue) {
      if (bannedPhrasesBuilder_ == null) {
        ensureBannedPhrasesIsMutable();
        bannedPhrases_.set(index, builderForValue.build());
        onChanged();
      } else {
        bannedPhrasesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public Builder addBannedPhrases(
        com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase value) {
      if (bannedPhrasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBannedPhrasesIsMutable();
        bannedPhrases_.add(value);
        onChanged();
      } else {
        bannedPhrasesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public Builder addBannedPhrases(
        int index, com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase value) {
      if (bannedPhrasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBannedPhrasesIsMutable();
        bannedPhrases_.add(index, value);
        onChanged();
      } else {
        bannedPhrasesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public Builder addBannedPhrases(
        com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.Builder builderForValue) {
      if (bannedPhrasesBuilder_ == null) {
        ensureBannedPhrasesIsMutable();
        bannedPhrases_.add(builderForValue.build());
        onChanged();
      } else {
        bannedPhrasesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public Builder addBannedPhrases(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.Builder builderForValue) {
      if (bannedPhrasesBuilder_ == null) {
        ensureBannedPhrasesIsMutable();
        bannedPhrases_.add(index, builderForValue.build());
        onChanged();
      } else {
        bannedPhrasesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public Builder addAllBannedPhrases(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase>
            values) {
      if (bannedPhrasesBuilder_ == null) {
        ensureBannedPhrasesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bannedPhrases_);
        onChanged();
      } else {
        bannedPhrasesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public Builder clearBannedPhrases() {
      if (bannedPhrasesBuilder_ == null) {
        bannedPhrases_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        bannedPhrasesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public Builder removeBannedPhrases(int index) {
      if (bannedPhrasesBuilder_ == null) {
        ensureBannedPhrasesIsMutable();
        bannedPhrases_.remove(index);
        onChanged();
      } else {
        bannedPhrasesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.Builder
        getBannedPhrasesBuilder(int index) {
      return getBannedPhrasesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseOrBuilder
        getBannedPhrasesOrBuilder(int index) {
      if (bannedPhrasesBuilder_ == null) {
        return bannedPhrases_.get(index);
      } else {
        return bannedPhrasesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseOrBuilder>
        getBannedPhrasesOrBuilderList() {
      if (bannedPhrasesBuilder_ != null) {
        return bannedPhrasesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(bannedPhrases_);
      }
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.Builder
        addBannedPhrasesBuilder() {
      return getBannedPhrasesFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.Builder
        addBannedPhrasesBuilder(int index) {
      return getBannedPhrasesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Banned phrases for generated text.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase banned_phrases = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.Builder>
        getBannedPhrasesBuilderList() {
      return getBannedPhrasesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase,
            com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseOrBuilder>
        getBannedPhrasesFieldBuilder() {
      if (bannedPhrasesBuilder_ == null) {
        bannedPhrasesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase,
                com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.Phrase.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.SafetySettings.PhraseOrBuilder>(
                bannedPhrases_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        bannedPhrases_ = null;
      }
      return bannedPhrasesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.SafetySettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.SafetySettings)
  private static final com.google.cloud.dialogflow.cx.v3beta1.SafetySettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.SafetySettings();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.SafetySettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SafetySettings> PARSER =
      new com.google.protobuf.AbstractParser<SafetySettings>() {
        @java.lang.Override
        public SafetySettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SafetySettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SafetySettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.SafetySettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
