/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/playbook.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Playbook is the basic building block to instruct the LLM how to execute a
 * certain task.
 *
 * A playbook consists of a goal to accomplish, an optional list of step by step
 * instructions (the step instruction may refers to name of the custom or
 * default plugin tools to use) to perform the task,
 * a list of contextual input data to be passed in at the beginning of the
 * invoked, and a list of output parameters to store the playbook result.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Playbook}
 */
public final class Playbook extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Playbook)
    PlaybookOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Playbook.newBuilder() to construct.
  private Playbook(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Playbook() {
    name_ = "";
    displayName_ = "";
    goal_ = "";
    inputParameterDefinitions_ = java.util.Collections.emptyList();
    outputParameterDefinitions_ = java.util.Collections.emptyList();
    referencedPlaybooks_ = com.google.protobuf.LazyStringArrayList.emptyList();
    referencedFlows_ = com.google.protobuf.LazyStringArrayList.emptyList();
    referencedTools_ = com.google.protobuf.LazyStringArrayList.emptyList();
    handlers_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Playbook();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.Playbook.class,
            com.google.cloud.dialogflow.cx.v3beta1.Playbook.Builder.class);
  }

  public interface StepOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Playbook.Step)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Step instruction in text format.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return Whether the text field is set.
     */
    boolean hasText();
    /**
     *
     *
     * <pre>
     * Step instruction in text format.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    java.lang.String getText();
    /**
     *
     *
     * <pre>
     * Step instruction in text format.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();

    /**
     *
     *
     * <pre>
     * Sub-processing needed to execute the current step.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step> getStepsList();
    /**
     *
     *
     * <pre>
     * Sub-processing needed to execute the current step.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step getSteps(int index);
    /**
     *
     *
     * <pre>
     * Sub-processing needed to execute the current step.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    int getStepsCount();
    /**
     *
     *
     * <pre>
     * Sub-processing needed to execute the current step.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder>
        getStepsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Sub-processing needed to execute the current step.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder getStepsOrBuilder(int index);

    com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.InstructionCase getInstructionCase();
  }
  /**
   *
   *
   * <pre>
   * Message of single step execution.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Playbook.Step}
   */
  public static final class Step extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Playbook.Step)
      StepOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Step.newBuilder() to construct.
    private Step(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Step() {
      steps_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Step();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_Step_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_Step_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.class,
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder.class);
    }

    private int instructionCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object instruction_;

    public enum InstructionCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      TEXT(1),
      INSTRUCTION_NOT_SET(0);
      private final int value;

      private InstructionCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static InstructionCase valueOf(int value) {
        return forNumber(value);
      }

      public static InstructionCase forNumber(int value) {
        switch (value) {
          case 1:
            return TEXT;
          case 0:
            return INSTRUCTION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public InstructionCase getInstructionCase() {
      return InstructionCase.forNumber(instructionCase_);
    }

    public static final int TEXT_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Step instruction in text format.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return Whether the text field is set.
     */
    public boolean hasText() {
      return instructionCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Step instruction in text format.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    public java.lang.String getText() {
      java.lang.Object ref = "";
      if (instructionCase_ == 1) {
        ref = instruction_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (instructionCase_ == 1) {
          instruction_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Step instruction in text format.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = "";
      if (instructionCase_ == 1) {
        ref = instruction_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (instructionCase_ == 1) {
          instruction_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STEPS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step> steps_;
    /**
     *
     *
     * <pre>
     * Sub-processing needed to execute the current step.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step> getStepsList() {
      return steps_;
    }
    /**
     *
     *
     * <pre>
     * Sub-processing needed to execute the current step.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder>
        getStepsOrBuilderList() {
      return steps_;
    }
    /**
     *
     *
     * <pre>
     * Sub-processing needed to execute the current step.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    @java.lang.Override
    public int getStepsCount() {
      return steps_.size();
    }
    /**
     *
     *
     * <pre>
     * Sub-processing needed to execute the current step.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step getSteps(int index) {
      return steps_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Sub-processing needed to execute the current step.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder getStepsOrBuilder(
        int index) {
      return steps_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (instructionCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instruction_);
      }
      for (int i = 0; i < steps_.size(); i++) {
        output.writeMessage(2, steps_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (instructionCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instruction_);
      }
      for (int i = 0; i < steps_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, steps_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step other =
          (com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step) obj;

      if (!getStepsList().equals(other.getStepsList())) return false;
      if (!getInstructionCase().equals(other.getInstructionCase())) return false;
      switch (instructionCase_) {
        case 1:
          if (!getText().equals(other.getText())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getStepsCount() > 0) {
        hash = (37 * hash) + STEPS_FIELD_NUMBER;
        hash = (53 * hash) + getStepsList().hashCode();
      }
      switch (instructionCase_) {
        case 1:
          hash = (37 * hash) + TEXT_FIELD_NUMBER;
          hash = (53 * hash) + getText().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message of single step execution.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Playbook.Step}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Playbook.Step)
        com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_Step_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_Step_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.class,
                com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (stepsBuilder_ == null) {
          steps_ = java.util.Collections.emptyList();
        } else {
          steps_ = null;
          stepsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        instructionCase_ = 0;
        instruction_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_Step_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step build() {
        com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step result =
            new com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step result) {
        if (stepsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            steps_ = java.util.Collections.unmodifiableList(steps_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.steps_ = steps_;
        } else {
          result.steps_ = stepsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step result) {
        result.instructionCase_ = instructionCase_;
        result.instruction_ = this.instruction_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step other) {
        if (other == com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.getDefaultInstance())
          return this;
        if (stepsBuilder_ == null) {
          if (!other.steps_.isEmpty()) {
            if (steps_.isEmpty()) {
              steps_ = other.steps_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureStepsIsMutable();
              steps_.addAll(other.steps_);
            }
            onChanged();
          }
        } else {
          if (!other.steps_.isEmpty()) {
            if (stepsBuilder_.isEmpty()) {
              stepsBuilder_.dispose();
              stepsBuilder_ = null;
              steps_ = other.steps_;
              bitField0_ = (bitField0_ & ~0x00000002);
              stepsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getStepsFieldBuilder()
                      : null;
            } else {
              stepsBuilder_.addAllMessages(other.steps_);
            }
          }
        }
        switch (other.getInstructionCase()) {
          case TEXT:
            {
              instructionCase_ = 1;
              instruction_ = other.instruction_;
              onChanged();
              break;
            }
          case INSTRUCTION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  instructionCase_ = 1;
                  instruction_ = s;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.parser(),
                          extensionRegistry);
                  if (stepsBuilder_ == null) {
                    ensureStepsIsMutable();
                    steps_.add(m);
                  } else {
                    stepsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int instructionCase_ = 0;
      private java.lang.Object instruction_;

      public InstructionCase getInstructionCase() {
        return InstructionCase.forNumber(instructionCase_);
      }

      public Builder clearInstruction() {
        instructionCase_ = 0;
        instruction_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Step instruction in text format.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return Whether the text field is set.
       */
      @java.lang.Override
      public boolean hasText() {
        return instructionCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Step instruction in text format.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      @java.lang.Override
      public java.lang.String getText() {
        java.lang.Object ref = "";
        if (instructionCase_ == 1) {
          ref = instruction_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (instructionCase_ == 1) {
            instruction_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Step instruction in text format.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = "";
        if (instructionCase_ == 1) {
          ref = instruction_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (instructionCase_ == 1) {
            instruction_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Step instruction in text format.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        instructionCase_ = 1;
        instruction_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Step instruction in text format.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        if (instructionCase_ == 1) {
          instructionCase_ = 0;
          instruction_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Step instruction in text format.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        instructionCase_ = 1;
        instruction_ = value;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step> steps_ =
          java.util.Collections.emptyList();

      private void ensureStepsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          steps_ =
              new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step>(steps_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step,
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder>
          stepsBuilder_;

      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step> getStepsList() {
        if (stepsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(steps_);
        } else {
          return stepsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public int getStepsCount() {
        if (stepsBuilder_ == null) {
          return steps_.size();
        } else {
          return stepsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step getSteps(int index) {
        if (stepsBuilder_ == null) {
          return steps_.get(index);
        } else {
          return stepsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder setSteps(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step value) {
        if (stepsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStepsIsMutable();
          steps_.set(index, value);
          onChanged();
        } else {
          stepsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder setSteps(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder builderForValue) {
        if (stepsBuilder_ == null) {
          ensureStepsIsMutable();
          steps_.set(index, builderForValue.build());
          onChanged();
        } else {
          stepsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder addSteps(com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step value) {
        if (stepsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStepsIsMutable();
          steps_.add(value);
          onChanged();
        } else {
          stepsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder addSteps(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step value) {
        if (stepsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStepsIsMutable();
          steps_.add(index, value);
          onChanged();
        } else {
          stepsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder addSteps(
          com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder builderForValue) {
        if (stepsBuilder_ == null) {
          ensureStepsIsMutable();
          steps_.add(builderForValue.build());
          onChanged();
        } else {
          stepsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder addSteps(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder builderForValue) {
        if (stepsBuilder_ == null) {
          ensureStepsIsMutable();
          steps_.add(index, builderForValue.build());
          onChanged();
        } else {
          stepsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder addAllSteps(
          java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step>
              values) {
        if (stepsBuilder_ == null) {
          ensureStepsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, steps_);
          onChanged();
        } else {
          stepsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder clearSteps() {
        if (stepsBuilder_ == null) {
          steps_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          stepsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder removeSteps(int index) {
        if (stepsBuilder_ == null) {
          ensureStepsIsMutable();
          steps_.remove(index);
          onChanged();
        } else {
          stepsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder getStepsBuilder(
          int index) {
        return getStepsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder getStepsOrBuilder(
          int index) {
        if (stepsBuilder_ == null) {
          return steps_.get(index);
        } else {
          return stepsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder>
          getStepsOrBuilderList() {
        if (stepsBuilder_ != null) {
          return stepsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(steps_);
        }
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder addStepsBuilder() {
        return getStepsFieldBuilder()
            .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder addStepsBuilder(
          int index) {
        return getStepsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Sub-processing needed to execute the current step.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder>
          getStepsBuilderList() {
        return getStepsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step,
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder>
          getStepsFieldBuilder() {
        if (stepsBuilder_ == null) {
          stepsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step,
                  com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder>(
                  steps_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          steps_ = null;
        }
        return stepsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Playbook.Step)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Playbook.Step)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Step> PARSER =
        new com.google.protobuf.AbstractParser<Step>() {
          @java.lang.Override
          public Step parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Step> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Step> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InstructionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * General guidelines for the playbook. These are unstructured instructions
     * that are not directly part of the goal, e.g. "Always be polite". It's
     * valid for this text to be long and used instead of steps altogether.
     * </pre>
     *
     * <code>string guidelines = 1;</code>
     *
     * @return The guidelines.
     */
    java.lang.String getGuidelines();
    /**
     *
     *
     * <pre>
     * General guidelines for the playbook. These are unstructured instructions
     * that are not directly part of the goal, e.g. "Always be polite". It's
     * valid for this text to be long and used instead of steps altogether.
     * </pre>
     *
     * <code>string guidelines = 1;</code>
     *
     * @return The bytes for guidelines.
     */
    com.google.protobuf.ByteString getGuidelinesBytes();

    /**
     *
     *
     * <pre>
     * Ordered list of step by step execution instructions to accomplish
     * target goal.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step> getStepsList();
    /**
     *
     *
     * <pre>
     * Ordered list of step by step execution instructions to accomplish
     * target goal.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step getSteps(int index);
    /**
     *
     *
     * <pre>
     * Ordered list of step by step execution instructions to accomplish
     * target goal.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    int getStepsCount();
    /**
     *
     *
     * <pre>
     * Ordered list of step by step execution instructions to accomplish
     * target goal.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder>
        getStepsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Ordered list of step by step execution instructions to accomplish
     * target goal.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder getStepsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Message of the Instruction of the playbook.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction}
   */
  public static final class Instruction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction)
      InstructionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Instruction.newBuilder() to construct.
    private Instruction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Instruction() {
      guidelines_ = "";
      steps_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Instruction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_Instruction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_Instruction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.class,
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.Builder.class);
    }

    public static final int GUIDELINES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object guidelines_ = "";
    /**
     *
     *
     * <pre>
     * General guidelines for the playbook. These are unstructured instructions
     * that are not directly part of the goal, e.g. "Always be polite". It's
     * valid for this text to be long and used instead of steps altogether.
     * </pre>
     *
     * <code>string guidelines = 1;</code>
     *
     * @return The guidelines.
     */
    @java.lang.Override
    public java.lang.String getGuidelines() {
      java.lang.Object ref = guidelines_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        guidelines_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * General guidelines for the playbook. These are unstructured instructions
     * that are not directly part of the goal, e.g. "Always be polite". It's
     * valid for this text to be long and used instead of steps altogether.
     * </pre>
     *
     * <code>string guidelines = 1;</code>
     *
     * @return The bytes for guidelines.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGuidelinesBytes() {
      java.lang.Object ref = guidelines_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        guidelines_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STEPS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step> steps_;
    /**
     *
     *
     * <pre>
     * Ordered list of step by step execution instructions to accomplish
     * target goal.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step> getStepsList() {
      return steps_;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of step by step execution instructions to accomplish
     * target goal.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder>
        getStepsOrBuilderList() {
      return steps_;
    }
    /**
     *
     *
     * <pre>
     * Ordered list of step by step execution instructions to accomplish
     * target goal.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    @java.lang.Override
    public int getStepsCount() {
      return steps_.size();
    }
    /**
     *
     *
     * <pre>
     * Ordered list of step by step execution instructions to accomplish
     * target goal.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step getSteps(int index) {
      return steps_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Ordered list of step by step execution instructions to accomplish
     * target goal.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder getStepsOrBuilder(
        int index) {
      return steps_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(guidelines_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, guidelines_);
      }
      for (int i = 0; i < steps_.size(); i++) {
        output.writeMessage(2, steps_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(guidelines_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, guidelines_);
      }
      for (int i = 0; i < steps_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, steps_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction other =
          (com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction) obj;

      if (!getGuidelines().equals(other.getGuidelines())) return false;
      if (!getStepsList().equals(other.getStepsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GUIDELINES_FIELD_NUMBER;
      hash = (53 * hash) + getGuidelines().hashCode();
      if (getStepsCount() > 0) {
        hash = (37 * hash) + STEPS_FIELD_NUMBER;
        hash = (53 * hash) + getStepsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message of the Instruction of the playbook.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction)
        com.google.cloud.dialogflow.cx.v3beta1.Playbook.InstructionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_Instruction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_Instruction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.class,
                com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        guidelines_ = "";
        if (stepsBuilder_ == null) {
          steps_ = java.util.Collections.emptyList();
        } else {
          steps_ = null;
          stepsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_Instruction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction build() {
        com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction result =
            new com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction result) {
        if (stepsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            steps_ = java.util.Collections.unmodifiableList(steps_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.steps_ = steps_;
        } else {
          result.steps_ = stepsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.guidelines_ = guidelines_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.getDefaultInstance())
          return this;
        if (!other.getGuidelines().isEmpty()) {
          guidelines_ = other.guidelines_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (stepsBuilder_ == null) {
          if (!other.steps_.isEmpty()) {
            if (steps_.isEmpty()) {
              steps_ = other.steps_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureStepsIsMutable();
              steps_.addAll(other.steps_);
            }
            onChanged();
          }
        } else {
          if (!other.steps_.isEmpty()) {
            if (stepsBuilder_.isEmpty()) {
              stepsBuilder_.dispose();
              stepsBuilder_ = null;
              steps_ = other.steps_;
              bitField0_ = (bitField0_ & ~0x00000002);
              stepsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getStepsFieldBuilder()
                      : null;
            } else {
              stepsBuilder_.addAllMessages(other.steps_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  guidelines_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.parser(),
                          extensionRegistry);
                  if (stepsBuilder_ == null) {
                    ensureStepsIsMutable();
                    steps_.add(m);
                  } else {
                    stepsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object guidelines_ = "";
      /**
       *
       *
       * <pre>
       * General guidelines for the playbook. These are unstructured instructions
       * that are not directly part of the goal, e.g. "Always be polite". It's
       * valid for this text to be long and used instead of steps altogether.
       * </pre>
       *
       * <code>string guidelines = 1;</code>
       *
       * @return The guidelines.
       */
      public java.lang.String getGuidelines() {
        java.lang.Object ref = guidelines_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          guidelines_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * General guidelines for the playbook. These are unstructured instructions
       * that are not directly part of the goal, e.g. "Always be polite". It's
       * valid for this text to be long and used instead of steps altogether.
       * </pre>
       *
       * <code>string guidelines = 1;</code>
       *
       * @return The bytes for guidelines.
       */
      public com.google.protobuf.ByteString getGuidelinesBytes() {
        java.lang.Object ref = guidelines_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          guidelines_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * General guidelines for the playbook. These are unstructured instructions
       * that are not directly part of the goal, e.g. "Always be polite". It's
       * valid for this text to be long and used instead of steps altogether.
       * </pre>
       *
       * <code>string guidelines = 1;</code>
       *
       * @param value The guidelines to set.
       * @return This builder for chaining.
       */
      public Builder setGuidelines(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        guidelines_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * General guidelines for the playbook. These are unstructured instructions
       * that are not directly part of the goal, e.g. "Always be polite". It's
       * valid for this text to be long and used instead of steps altogether.
       * </pre>
       *
       * <code>string guidelines = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGuidelines() {
        guidelines_ = getDefaultInstance().getGuidelines();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * General guidelines for the playbook. These are unstructured instructions
       * that are not directly part of the goal, e.g. "Always be polite". It's
       * valid for this text to be long and used instead of steps altogether.
       * </pre>
       *
       * <code>string guidelines = 1;</code>
       *
       * @param value The bytes for guidelines to set.
       * @return This builder for chaining.
       */
      public Builder setGuidelinesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        guidelines_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step> steps_ =
          java.util.Collections.emptyList();

      private void ensureStepsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          steps_ =
              new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step>(steps_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step,
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder>
          stepsBuilder_;

      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step> getStepsList() {
        if (stepsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(steps_);
        } else {
          return stepsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public int getStepsCount() {
        if (stepsBuilder_ == null) {
          return steps_.size();
        } else {
          return stepsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step getSteps(int index) {
        if (stepsBuilder_ == null) {
          return steps_.get(index);
        } else {
          return stepsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder setSteps(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step value) {
        if (stepsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStepsIsMutable();
          steps_.set(index, value);
          onChanged();
        } else {
          stepsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder setSteps(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder builderForValue) {
        if (stepsBuilder_ == null) {
          ensureStepsIsMutable();
          steps_.set(index, builderForValue.build());
          onChanged();
        } else {
          stepsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder addSteps(com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step value) {
        if (stepsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStepsIsMutable();
          steps_.add(value);
          onChanged();
        } else {
          stepsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder addSteps(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step value) {
        if (stepsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStepsIsMutable();
          steps_.add(index, value);
          onChanged();
        } else {
          stepsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder addSteps(
          com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder builderForValue) {
        if (stepsBuilder_ == null) {
          ensureStepsIsMutable();
          steps_.add(builderForValue.build());
          onChanged();
        } else {
          stepsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder addSteps(
          int index, com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder builderForValue) {
        if (stepsBuilder_ == null) {
          ensureStepsIsMutable();
          steps_.add(index, builderForValue.build());
          onChanged();
        } else {
          stepsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder addAllSteps(
          java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step>
              values) {
        if (stepsBuilder_ == null) {
          ensureStepsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, steps_);
          onChanged();
        } else {
          stepsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder clearSteps() {
        if (stepsBuilder_ == null) {
          steps_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          stepsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public Builder removeSteps(int index) {
        if (stepsBuilder_ == null) {
          ensureStepsIsMutable();
          steps_.remove(index);
          onChanged();
        } else {
          stepsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder getStepsBuilder(
          int index) {
        return getStepsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder getStepsOrBuilder(
          int index) {
        if (stepsBuilder_ == null) {
          return steps_.get(index);
        } else {
          return stepsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder>
          getStepsOrBuilderList() {
        if (stepsBuilder_ != null) {
          return stepsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(steps_);
        }
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder addStepsBuilder() {
        return getStepsFieldBuilder()
            .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder addStepsBuilder(
          int index) {
        return getStepsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Ordered list of step by step execution instructions to accomplish
       * target goal.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Playbook.Step steps = 2;</code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder>
          getStepsBuilderList() {
        return getStepsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step,
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder>
          getStepsFieldBuilder() {
        if (stepsBuilder_ == null) {
          stepsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step,
                  com.google.cloud.dialogflow.cx.v3beta1.Playbook.Step.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Playbook.StepOrBuilder>(
                  steps_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          steps_ = null;
        }
        return stepsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Instruction> PARSER =
        new com.google.protobuf.AbstractParser<Instruction>() {
          @java.lang.Override
          public Instruction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Instruction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Instruction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the playbook.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the playbook.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the playbook, unique within an agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the playbook, unique within an agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GOAL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object goal_ = "";
  /**
   *
   *
   * <pre>
   * Required. High level description of the goal the playbook intend to
   * accomplish. A goal should be concise since it's visible to other playbooks
   * that may reference this playbook.
   * </pre>
   *
   * <code>string goal = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The goal.
   */
  @java.lang.Override
  public java.lang.String getGoal() {
    java.lang.Object ref = goal_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      goal_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. High level description of the goal the playbook intend to
   * accomplish. A goal should be concise since it's visible to other playbooks
   * that may reference this playbook.
   * </pre>
   *
   * <code>string goal = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for goal.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGoalBytes() {
    java.lang.Object ref = goal_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      goal_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_PARAMETER_DEFINITIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>
      inputParameterDefinitions_;
  /**
   *
   *
   * <pre>
   * Optional. Defined structured input parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>
      getInputParameterDefinitionsList() {
    return inputParameterDefinitions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Defined structured input parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder>
      getInputParameterDefinitionsOrBuilderList() {
    return inputParameterDefinitions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Defined structured input parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getInputParameterDefinitionsCount() {
    return inputParameterDefinitions_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Defined structured input parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition getInputParameterDefinitions(
      int index) {
    return inputParameterDefinitions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Defined structured input parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder
      getInputParameterDefinitionsOrBuilder(int index) {
    return inputParameterDefinitions_.get(index);
  }

  public static final int OUTPUT_PARAMETER_DEFINITIONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>
      outputParameterDefinitions_;
  /**
   *
   *
   * <pre>
   * Optional. Defined structured output parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>
      getOutputParameterDefinitionsList() {
    return outputParameterDefinitions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Defined structured output parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder>
      getOutputParameterDefinitionsOrBuilderList() {
    return outputParameterDefinitions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Defined structured output parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getOutputParameterDefinitionsCount() {
    return outputParameterDefinitions_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Defined structured output parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition getOutputParameterDefinitions(
      int index) {
    return outputParameterDefinitions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Defined structured output parameters for this playbook.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder
      getOutputParameterDefinitionsOrBuilder(int index) {
    return outputParameterDefinitions_.get(index);
  }

  public static final int INSTRUCTION_FIELD_NUMBER = 17;
  private com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction_;
  /**
   *
   *
   * <pre>
   * Instruction to accomplish target goal.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
   *
   * @return Whether the instruction field is set.
   */
  @java.lang.Override
  public boolean hasInstruction() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Instruction to accomplish target goal.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
   *
   * @return The instruction.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction getInstruction() {
    return instruction_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.getDefaultInstance()
        : instruction_;
  }
  /**
   *
   *
   * <pre>
   * Instruction to accomplish target goal.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Playbook.InstructionOrBuilder
      getInstructionOrBuilder() {
    return instruction_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.getDefaultInstance()
        : instruction_;
  }

  public static final int TOKEN_COUNT_FIELD_NUMBER = 8;
  private long tokenCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. Estimated number of tokes current playbook takes when sent to
   * the LLM.
   * </pre>
   *
   * <code>int64 token_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The tokenCount.
   */
  @java.lang.Override
  public long getTokenCount() {
    return tokenCount_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of initial playbook creation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of initial playbook creation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of initial playbook creation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Last time the playbook version was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Last time the playbook version was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Last time the playbook version was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int REFERENCED_PLAYBOOKS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList referencedPlaybooks_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of other playbooks referenced by the current
   * playbook in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the referencedPlaybooks.
   */
  public com.google.protobuf.ProtocolStringList getReferencedPlaybooksList() {
    return referencedPlaybooks_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of other playbooks referenced by the current
   * playbook in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of referencedPlaybooks.
   */
  public int getReferencedPlaybooksCount() {
    return referencedPlaybooks_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of other playbooks referenced by the current
   * playbook in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencedPlaybooks at the given index.
   */
  public java.lang.String getReferencedPlaybooks(int index) {
    return referencedPlaybooks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of other playbooks referenced by the current
   * playbook in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencedPlaybooks at the given index.
   */
  public com.google.protobuf.ByteString getReferencedPlaybooksBytes(int index) {
    return referencedPlaybooks_.getByteString(index);
  }

  public static final int REFERENCED_FLOWS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList referencedFlows_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of flows referenced by the current playbook
   * in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the referencedFlows.
   */
  public com.google.protobuf.ProtocolStringList getReferencedFlowsList() {
    return referencedFlows_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of flows referenced by the current playbook
   * in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of referencedFlows.
   */
  public int getReferencedFlowsCount() {
    return referencedFlows_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of flows referenced by the current playbook
   * in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencedFlows at the given index.
   */
  public java.lang.String getReferencedFlows(int index) {
    return referencedFlows_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of flows referenced by the current playbook
   * in the instructions.
   * </pre>
   *
   * <code>
   * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencedFlows at the given index.
   */
  public com.google.protobuf.ByteString getReferencedFlowsBytes(int index) {
    return referencedFlows_.getByteString(index);
  }

  public static final int REFERENCED_TOOLS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList referencedTools_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The resource name of tools referenced by the current playbook in
   * the instructions. If not provided explicitly, they are will
   * be implied using the tool being referenced in goal and steps.
   * </pre>
   *
   * <code>
   * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the referencedTools.
   */
  public com.google.protobuf.ProtocolStringList getReferencedToolsList() {
    return referencedTools_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource name of tools referenced by the current playbook in
   * the instructions. If not provided explicitly, they are will
   * be implied using the tool being referenced in goal and steps.
   * </pre>
   *
   * <code>
   * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of referencedTools.
   */
  public int getReferencedToolsCount() {
    return referencedTools_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource name of tools referenced by the current playbook in
   * the instructions. If not provided explicitly, they are will
   * be implied using the tool being referenced in goal and steps.
   * </pre>
   *
   * <code>
   * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencedTools at the given index.
   */
  public java.lang.String getReferencedTools(int index) {
    return referencedTools_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource name of tools referenced by the current playbook in
   * the instructions. If not provided explicitly, they are will
   * be implied using the tool being referenced in goal and steps.
   * </pre>
   *
   * <code>
   * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencedTools at the given index.
   */
  public com.google.protobuf.ByteString getReferencedToolsBytes(int index) {
    return referencedTools_.getByteString(index);
  }

  public static final int LLM_MODEL_SETTINGS_FIELD_NUMBER = 14;
  private com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llmModelSettings_;
  /**
   *
   *
   * <pre>
   * Optional. Llm model settings for the playbook.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the llmModelSettings field is set.
   */
  @java.lang.Override
  public boolean hasLlmModelSettings() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Llm model settings for the playbook.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The llmModelSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings getLlmModelSettings() {
    return llmModelSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.getDefaultInstance()
        : llmModelSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Llm model settings for the playbook.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettingsOrBuilder
      getLlmModelSettingsOrBuilder() {
    return llmModelSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.getDefaultInstance()
        : llmModelSettings_;
  }

  public static final int SPEECH_SETTINGS_FIELD_NUMBER = 20;
  private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speechSettings_;
  /**
   *
   *
   * <pre>
   * Optional. Playbook level Settings for speech to text detection.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the speechSettings field is set.
   */
  @java.lang.Override
  public boolean hasSpeechSettings() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Playbook level Settings for speech to text detection.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The speechSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
      getSpeechSettings() {
    return speechSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
            .getDefaultInstance()
        : speechSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Playbook level Settings for speech to text detection.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettingsOrBuilder
      getSpeechSettingsOrBuilder() {
    return speechSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
            .getDefaultInstance()
        : speechSettings_;
  }

  public static final int HANDLERS_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Handler> handlers_;
  /**
   *
   *
   * <pre>
   * Optional. A list of registered handlers to execute based on the specified
   * triggers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Handler> getHandlersList() {
    return handlers_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of registered handlers to execute based on the specified
   * triggers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.HandlerOrBuilder>
      getHandlersOrBuilderList() {
    return handlers_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of registered handlers to execute based on the specified
   * triggers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getHandlersCount() {
    return handlers_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of registered handlers to execute based on the specified
   * triggers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Handler getHandlers(int index) {
    return handlers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of registered handlers to execute based on the specified
   * triggers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.HandlerOrBuilder getHandlersOrBuilder(int index) {
    return handlers_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(goal_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, goal_);
    }
    for (int i = 0; i < inputParameterDefinitions_.size(); i++) {
      output.writeMessage(5, inputParameterDefinitions_.get(i));
    }
    for (int i = 0; i < outputParameterDefinitions_.size(); i++) {
      output.writeMessage(6, outputParameterDefinitions_.get(i));
    }
    if (tokenCount_ != 0L) {
      output.writeInt64(8, tokenCount_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getUpdateTime());
    }
    for (int i = 0; i < referencedPlaybooks_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 11, referencedPlaybooks_.getRaw(i));
    }
    for (int i = 0; i < referencedFlows_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, referencedFlows_.getRaw(i));
    }
    for (int i = 0; i < referencedTools_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, referencedTools_.getRaw(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(14, getLlmModelSettings());
    }
    for (int i = 0; i < handlers_.size(); i++) {
      output.writeMessage(16, handlers_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(17, getInstruction());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(20, getSpeechSettings());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(goal_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, goal_);
    }
    for (int i = 0; i < inputParameterDefinitions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, inputParameterDefinitions_.get(i));
    }
    for (int i = 0; i < outputParameterDefinitions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, outputParameterDefinitions_.get(i));
    }
    if (tokenCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, tokenCount_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUpdateTime());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < referencedPlaybooks_.size(); i++) {
        dataSize += computeStringSizeNoTag(referencedPlaybooks_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReferencedPlaybooksList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < referencedFlows_.size(); i++) {
        dataSize += computeStringSizeNoTag(referencedFlows_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReferencedFlowsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < referencedTools_.size(); i++) {
        dataSize += computeStringSizeNoTag(referencedTools_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReferencedToolsList().size();
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getLlmModelSettings());
    }
    for (int i = 0; i < handlers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, handlers_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getInstruction());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getSpeechSettings());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Playbook)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.Playbook other =
        (com.google.cloud.dialogflow.cx.v3beta1.Playbook) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getGoal().equals(other.getGoal())) return false;
    if (!getInputParameterDefinitionsList().equals(other.getInputParameterDefinitionsList()))
      return false;
    if (!getOutputParameterDefinitionsList().equals(other.getOutputParameterDefinitionsList()))
      return false;
    if (hasInstruction() != other.hasInstruction()) return false;
    if (hasInstruction()) {
      if (!getInstruction().equals(other.getInstruction())) return false;
    }
    if (getTokenCount() != other.getTokenCount()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getReferencedPlaybooksList().equals(other.getReferencedPlaybooksList())) return false;
    if (!getReferencedFlowsList().equals(other.getReferencedFlowsList())) return false;
    if (!getReferencedToolsList().equals(other.getReferencedToolsList())) return false;
    if (hasLlmModelSettings() != other.hasLlmModelSettings()) return false;
    if (hasLlmModelSettings()) {
      if (!getLlmModelSettings().equals(other.getLlmModelSettings())) return false;
    }
    if (hasSpeechSettings() != other.hasSpeechSettings()) return false;
    if (hasSpeechSettings()) {
      if (!getSpeechSettings().equals(other.getSpeechSettings())) return false;
    }
    if (!getHandlersList().equals(other.getHandlersList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + GOAL_FIELD_NUMBER;
    hash = (53 * hash) + getGoal().hashCode();
    if (getInputParameterDefinitionsCount() > 0) {
      hash = (37 * hash) + INPUT_PARAMETER_DEFINITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getInputParameterDefinitionsList().hashCode();
    }
    if (getOutputParameterDefinitionsCount() > 0) {
      hash = (37 * hash) + OUTPUT_PARAMETER_DEFINITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getOutputParameterDefinitionsList().hashCode();
    }
    if (hasInstruction()) {
      hash = (37 * hash) + INSTRUCTION_FIELD_NUMBER;
      hash = (53 * hash) + getInstruction().hashCode();
    }
    hash = (37 * hash) + TOKEN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTokenCount());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (getReferencedPlaybooksCount() > 0) {
      hash = (37 * hash) + REFERENCED_PLAYBOOKS_FIELD_NUMBER;
      hash = (53 * hash) + getReferencedPlaybooksList().hashCode();
    }
    if (getReferencedFlowsCount() > 0) {
      hash = (37 * hash) + REFERENCED_FLOWS_FIELD_NUMBER;
      hash = (53 * hash) + getReferencedFlowsList().hashCode();
    }
    if (getReferencedToolsCount() > 0) {
      hash = (37 * hash) + REFERENCED_TOOLS_FIELD_NUMBER;
      hash = (53 * hash) + getReferencedToolsList().hashCode();
    }
    if (hasLlmModelSettings()) {
      hash = (37 * hash) + LLM_MODEL_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getLlmModelSettings().hashCode();
    }
    if (hasSpeechSettings()) {
      hash = (37 * hash) + SPEECH_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechSettings().hashCode();
    }
    if (getHandlersCount() > 0) {
      hash = (37 * hash) + HANDLERS_FIELD_NUMBER;
      hash = (53 * hash) + getHandlersList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.Playbook prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Playbook is the basic building block to instruct the LLM how to execute a
   * certain task.
   *
   * A playbook consists of a goal to accomplish, an optional list of step by step
   * instructions (the step instruction may refers to name of the custom or
   * default plugin tools to use) to perform the task,
   * a list of contextual input data to be passed in at the beginning of the
   * invoked, and a list of output parameters to store the playbook result.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Playbook}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Playbook)
      com.google.cloud.dialogflow.cx.v3beta1.PlaybookOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.class,
              com.google.cloud.dialogflow.cx.v3beta1.Playbook.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.Playbook.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInputParameterDefinitionsFieldBuilder();
        getOutputParameterDefinitionsFieldBuilder();
        getInstructionFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getLlmModelSettingsFieldBuilder();
        getSpeechSettingsFieldBuilder();
        getHandlersFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      goal_ = "";
      if (inputParameterDefinitionsBuilder_ == null) {
        inputParameterDefinitions_ = java.util.Collections.emptyList();
      } else {
        inputParameterDefinitions_ = null;
        inputParameterDefinitionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (outputParameterDefinitionsBuilder_ == null) {
        outputParameterDefinitions_ = java.util.Collections.emptyList();
      } else {
        outputParameterDefinitions_ = null;
        outputParameterDefinitionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      instruction_ = null;
      if (instructionBuilder_ != null) {
        instructionBuilder_.dispose();
        instructionBuilder_ = null;
      }
      tokenCount_ = 0L;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      referencedPlaybooks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      referencedFlows_ = com.google.protobuf.LazyStringArrayList.emptyList();
      referencedTools_ = com.google.protobuf.LazyStringArrayList.emptyList();
      llmModelSettings_ = null;
      if (llmModelSettingsBuilder_ != null) {
        llmModelSettingsBuilder_.dispose();
        llmModelSettingsBuilder_ = null;
      }
      speechSettings_ = null;
      if (speechSettingsBuilder_ != null) {
        speechSettingsBuilder_.dispose();
        speechSettingsBuilder_ = null;
      }
      if (handlersBuilder_ == null) {
        handlers_ = java.util.Collections.emptyList();
      } else {
        handlers_ = null;
        handlersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Playbook_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Playbook getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.Playbook.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Playbook build() {
      com.google.cloud.dialogflow.cx.v3beta1.Playbook result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Playbook buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.Playbook result =
          new com.google.cloud.dialogflow.cx.v3beta1.Playbook(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3beta1.Playbook result) {
      if (inputParameterDefinitionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          inputParameterDefinitions_ =
              java.util.Collections.unmodifiableList(inputParameterDefinitions_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.inputParameterDefinitions_ = inputParameterDefinitions_;
      } else {
        result.inputParameterDefinitions_ = inputParameterDefinitionsBuilder_.build();
      }
      if (outputParameterDefinitionsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          outputParameterDefinitions_ =
              java.util.Collections.unmodifiableList(outputParameterDefinitions_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.outputParameterDefinitions_ = outputParameterDefinitions_;
      } else {
        result.outputParameterDefinitions_ = outputParameterDefinitionsBuilder_.build();
      }
      if (handlersBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          handlers_ = java.util.Collections.unmodifiableList(handlers_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.handlers_ = handlers_;
      } else {
        result.handlers_ = handlersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Playbook result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.goal_ = goal_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.instruction_ =
            instructionBuilder_ == null ? instruction_ : instructionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.tokenCount_ = tokenCount_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        referencedPlaybooks_.makeImmutable();
        result.referencedPlaybooks_ = referencedPlaybooks_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        referencedFlows_.makeImmutable();
        result.referencedFlows_ = referencedFlows_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        referencedTools_.makeImmutable();
        result.referencedTools_ = referencedTools_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.llmModelSettings_ =
            llmModelSettingsBuilder_ == null ? llmModelSettings_ : llmModelSettingsBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.speechSettings_ =
            speechSettingsBuilder_ == null ? speechSettings_ : speechSettingsBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Playbook) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Playbook) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Playbook other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.Playbook.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getGoal().isEmpty()) {
        goal_ = other.goal_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (inputParameterDefinitionsBuilder_ == null) {
        if (!other.inputParameterDefinitions_.isEmpty()) {
          if (inputParameterDefinitions_.isEmpty()) {
            inputParameterDefinitions_ = other.inputParameterDefinitions_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureInputParameterDefinitionsIsMutable();
            inputParameterDefinitions_.addAll(other.inputParameterDefinitions_);
          }
          onChanged();
        }
      } else {
        if (!other.inputParameterDefinitions_.isEmpty()) {
          if (inputParameterDefinitionsBuilder_.isEmpty()) {
            inputParameterDefinitionsBuilder_.dispose();
            inputParameterDefinitionsBuilder_ = null;
            inputParameterDefinitions_ = other.inputParameterDefinitions_;
            bitField0_ = (bitField0_ & ~0x00000008);
            inputParameterDefinitionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInputParameterDefinitionsFieldBuilder()
                    : null;
          } else {
            inputParameterDefinitionsBuilder_.addAllMessages(other.inputParameterDefinitions_);
          }
        }
      }
      if (outputParameterDefinitionsBuilder_ == null) {
        if (!other.outputParameterDefinitions_.isEmpty()) {
          if (outputParameterDefinitions_.isEmpty()) {
            outputParameterDefinitions_ = other.outputParameterDefinitions_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureOutputParameterDefinitionsIsMutable();
            outputParameterDefinitions_.addAll(other.outputParameterDefinitions_);
          }
          onChanged();
        }
      } else {
        if (!other.outputParameterDefinitions_.isEmpty()) {
          if (outputParameterDefinitionsBuilder_.isEmpty()) {
            outputParameterDefinitionsBuilder_.dispose();
            outputParameterDefinitionsBuilder_ = null;
            outputParameterDefinitions_ = other.outputParameterDefinitions_;
            bitField0_ = (bitField0_ & ~0x00000010);
            outputParameterDefinitionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOutputParameterDefinitionsFieldBuilder()
                    : null;
          } else {
            outputParameterDefinitionsBuilder_.addAllMessages(other.outputParameterDefinitions_);
          }
        }
      }
      if (other.hasInstruction()) {
        mergeInstruction(other.getInstruction());
      }
      if (other.getTokenCount() != 0L) {
        setTokenCount(other.getTokenCount());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.referencedPlaybooks_.isEmpty()) {
        if (referencedPlaybooks_.isEmpty()) {
          referencedPlaybooks_ = other.referencedPlaybooks_;
          bitField0_ |= 0x00000200;
        } else {
          ensureReferencedPlaybooksIsMutable();
          referencedPlaybooks_.addAll(other.referencedPlaybooks_);
        }
        onChanged();
      }
      if (!other.referencedFlows_.isEmpty()) {
        if (referencedFlows_.isEmpty()) {
          referencedFlows_ = other.referencedFlows_;
          bitField0_ |= 0x00000400;
        } else {
          ensureReferencedFlowsIsMutable();
          referencedFlows_.addAll(other.referencedFlows_);
        }
        onChanged();
      }
      if (!other.referencedTools_.isEmpty()) {
        if (referencedTools_.isEmpty()) {
          referencedTools_ = other.referencedTools_;
          bitField0_ |= 0x00000800;
        } else {
          ensureReferencedToolsIsMutable();
          referencedTools_.addAll(other.referencedTools_);
        }
        onChanged();
      }
      if (other.hasLlmModelSettings()) {
        mergeLlmModelSettings(other.getLlmModelSettings());
      }
      if (other.hasSpeechSettings()) {
        mergeSpeechSettings(other.getSpeechSettings());
      }
      if (handlersBuilder_ == null) {
        if (!other.handlers_.isEmpty()) {
          if (handlers_.isEmpty()) {
            handlers_ = other.handlers_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureHandlersIsMutable();
            handlers_.addAll(other.handlers_);
          }
          onChanged();
        }
      } else {
        if (!other.handlers_.isEmpty()) {
          if (handlersBuilder_.isEmpty()) {
            handlersBuilder_.dispose();
            handlersBuilder_ = null;
            handlers_ = other.handlers_;
            bitField0_ = (bitField0_ & ~0x00004000);
            handlersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getHandlersFieldBuilder()
                    : null;
          } else {
            handlersBuilder_.addAllMessages(other.handlers_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                goal_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.parser(),
                        extensionRegistry);
                if (inputParameterDefinitionsBuilder_ == null) {
                  ensureInputParameterDefinitionsIsMutable();
                  inputParameterDefinitions_.add(m);
                } else {
                  inputParameterDefinitionsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.parser(),
                        extensionRegistry);
                if (outputParameterDefinitionsBuilder_ == null) {
                  ensureOutputParameterDefinitionsIsMutable();
                  outputParameterDefinitions_.add(m);
                } else {
                  outputParameterDefinitionsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 64:
              {
                tokenCount_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReferencedPlaybooksIsMutable();
                referencedPlaybooks_.add(s);
                break;
              } // case 90
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReferencedFlowsIsMutable();
                referencedFlows_.add(s);
                break;
              } // case 98
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReferencedToolsIsMutable();
                referencedTools_.add(s);
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getLlmModelSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 114
            case 130:
              {
                com.google.cloud.dialogflow.cx.v3beta1.Handler m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.Handler.parser(), extensionRegistry);
                if (handlersBuilder_ == null) {
                  ensureHandlersIsMutable();
                  handlers_.add(m);
                } else {
                  handlersBuilder_.addMessage(m);
                }
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getInstructionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 138
            case 162:
              {
                input.readMessage(getSpeechSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 162
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the playbook.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the playbook.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the playbook.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the playbook.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the playbook.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the playbook, unique within an agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the playbook, unique within an agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the playbook, unique within an agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the playbook, unique within an agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the playbook, unique within an agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object goal_ = "";
    /**
     *
     *
     * <pre>
     * Required. High level description of the goal the playbook intend to
     * accomplish. A goal should be concise since it's visible to other playbooks
     * that may reference this playbook.
     * </pre>
     *
     * <code>string goal = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The goal.
     */
    public java.lang.String getGoal() {
      java.lang.Object ref = goal_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        goal_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. High level description of the goal the playbook intend to
     * accomplish. A goal should be concise since it's visible to other playbooks
     * that may reference this playbook.
     * </pre>
     *
     * <code>string goal = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for goal.
     */
    public com.google.protobuf.ByteString getGoalBytes() {
      java.lang.Object ref = goal_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        goal_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. High level description of the goal the playbook intend to
     * accomplish. A goal should be concise since it's visible to other playbooks
     * that may reference this playbook.
     * </pre>
     *
     * <code>string goal = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The goal to set.
     * @return This builder for chaining.
     */
    public Builder setGoal(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      goal_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. High level description of the goal the playbook intend to
     * accomplish. A goal should be concise since it's visible to other playbooks
     * that may reference this playbook.
     * </pre>
     *
     * <code>string goal = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGoal() {
      goal_ = getDefaultInstance().getGoal();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. High level description of the goal the playbook intend to
     * accomplish. A goal should be concise since it's visible to other playbooks
     * that may reference this playbook.
     * </pre>
     *
     * <code>string goal = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for goal to set.
     * @return This builder for chaining.
     */
    public Builder setGoalBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      goal_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>
        inputParameterDefinitions_ = java.util.Collections.emptyList();

    private void ensureInputParameterDefinitionsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        inputParameterDefinitions_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>(
                inputParameterDefinitions_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition,
            com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder>
        inputParameterDefinitionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>
        getInputParameterDefinitionsList() {
      if (inputParameterDefinitionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(inputParameterDefinitions_);
      } else {
        return inputParameterDefinitionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getInputParameterDefinitionsCount() {
      if (inputParameterDefinitionsBuilder_ == null) {
        return inputParameterDefinitions_.size();
      } else {
        return inputParameterDefinitionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition getInputParameterDefinitions(
        int index) {
      if (inputParameterDefinitionsBuilder_ == null) {
        return inputParameterDefinitions_.get(index);
      } else {
        return inputParameterDefinitionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInputParameterDefinitions(
        int index, com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition value) {
      if (inputParameterDefinitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputParameterDefinitionsIsMutable();
        inputParameterDefinitions_.set(index, value);
        onChanged();
      } else {
        inputParameterDefinitionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInputParameterDefinitions(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder builderForValue) {
      if (inputParameterDefinitionsBuilder_ == null) {
        ensureInputParameterDefinitionsIsMutable();
        inputParameterDefinitions_.set(index, builderForValue.build());
        onChanged();
      } else {
        inputParameterDefinitionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInputParameterDefinitions(
        com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition value) {
      if (inputParameterDefinitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputParameterDefinitionsIsMutable();
        inputParameterDefinitions_.add(value);
        onChanged();
      } else {
        inputParameterDefinitionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInputParameterDefinitions(
        int index, com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition value) {
      if (inputParameterDefinitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputParameterDefinitionsIsMutable();
        inputParameterDefinitions_.add(index, value);
        onChanged();
      } else {
        inputParameterDefinitionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInputParameterDefinitions(
        com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder builderForValue) {
      if (inputParameterDefinitionsBuilder_ == null) {
        ensureInputParameterDefinitionsIsMutable();
        inputParameterDefinitions_.add(builderForValue.build());
        onChanged();
      } else {
        inputParameterDefinitionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInputParameterDefinitions(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder builderForValue) {
      if (inputParameterDefinitionsBuilder_ == null) {
        ensureInputParameterDefinitionsIsMutable();
        inputParameterDefinitions_.add(index, builderForValue.build());
        onChanged();
      } else {
        inputParameterDefinitionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllInputParameterDefinitions(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>
            values) {
      if (inputParameterDefinitionsBuilder_ == null) {
        ensureInputParameterDefinitionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inputParameterDefinitions_);
        onChanged();
      } else {
        inputParameterDefinitionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInputParameterDefinitions() {
      if (inputParameterDefinitionsBuilder_ == null) {
        inputParameterDefinitions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        inputParameterDefinitionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeInputParameterDefinitions(int index) {
      if (inputParameterDefinitionsBuilder_ == null) {
        ensureInputParameterDefinitionsIsMutable();
        inputParameterDefinitions_.remove(index);
        onChanged();
      } else {
        inputParameterDefinitionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder
        getInputParameterDefinitionsBuilder(int index) {
      return getInputParameterDefinitionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder
        getInputParameterDefinitionsOrBuilder(int index) {
      if (inputParameterDefinitionsBuilder_ == null) {
        return inputParameterDefinitions_.get(index);
      } else {
        return inputParameterDefinitionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder>
        getInputParameterDefinitionsOrBuilderList() {
      if (inputParameterDefinitionsBuilder_ != null) {
        return inputParameterDefinitionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(inputParameterDefinitions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder
        addInputParameterDefinitionsBuilder() {
      return getInputParameterDefinitionsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder
        addInputParameterDefinitionsBuilder(int index) {
      return getInputParameterDefinitionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured input parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition input_parameter_definitions = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder>
        getInputParameterDefinitionsBuilderList() {
      return getInputParameterDefinitionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition,
            com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder>
        getInputParameterDefinitionsFieldBuilder() {
      if (inputParameterDefinitionsBuilder_ == null) {
        inputParameterDefinitionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition,
                com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder>(
                inputParameterDefinitions_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        inputParameterDefinitions_ = null;
      }
      return inputParameterDefinitionsBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>
        outputParameterDefinitions_ = java.util.Collections.emptyList();

    private void ensureOutputParameterDefinitionsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        outputParameterDefinitions_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>(
                outputParameterDefinitions_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition,
            com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder>
        outputParameterDefinitionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>
        getOutputParameterDefinitionsList() {
      if (outputParameterDefinitionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(outputParameterDefinitions_);
      } else {
        return outputParameterDefinitionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getOutputParameterDefinitionsCount() {
      if (outputParameterDefinitionsBuilder_ == null) {
        return outputParameterDefinitions_.size();
      } else {
        return outputParameterDefinitionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition getOutputParameterDefinitions(
        int index) {
      if (outputParameterDefinitionsBuilder_ == null) {
        return outputParameterDefinitions_.get(index);
      } else {
        return outputParameterDefinitionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOutputParameterDefinitions(
        int index, com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition value) {
      if (outputParameterDefinitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputParameterDefinitionsIsMutable();
        outputParameterDefinitions_.set(index, value);
        onChanged();
      } else {
        outputParameterDefinitionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOutputParameterDefinitions(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder builderForValue) {
      if (outputParameterDefinitionsBuilder_ == null) {
        ensureOutputParameterDefinitionsIsMutable();
        outputParameterDefinitions_.set(index, builderForValue.build());
        onChanged();
      } else {
        outputParameterDefinitionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addOutputParameterDefinitions(
        com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition value) {
      if (outputParameterDefinitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputParameterDefinitionsIsMutable();
        outputParameterDefinitions_.add(value);
        onChanged();
      } else {
        outputParameterDefinitionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addOutputParameterDefinitions(
        int index, com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition value) {
      if (outputParameterDefinitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputParameterDefinitionsIsMutable();
        outputParameterDefinitions_.add(index, value);
        onChanged();
      } else {
        outputParameterDefinitionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addOutputParameterDefinitions(
        com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder builderForValue) {
      if (outputParameterDefinitionsBuilder_ == null) {
        ensureOutputParameterDefinitionsIsMutable();
        outputParameterDefinitions_.add(builderForValue.build());
        onChanged();
      } else {
        outputParameterDefinitionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addOutputParameterDefinitions(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder builderForValue) {
      if (outputParameterDefinitionsBuilder_ == null) {
        ensureOutputParameterDefinitionsIsMutable();
        outputParameterDefinitions_.add(index, builderForValue.build());
        onChanged();
      } else {
        outputParameterDefinitionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllOutputParameterDefinitions(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition>
            values) {
      if (outputParameterDefinitionsBuilder_ == null) {
        ensureOutputParameterDefinitionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, outputParameterDefinitions_);
        onChanged();
      } else {
        outputParameterDefinitionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOutputParameterDefinitions() {
      if (outputParameterDefinitionsBuilder_ == null) {
        outputParameterDefinitions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        outputParameterDefinitionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeOutputParameterDefinitions(int index) {
      if (outputParameterDefinitionsBuilder_ == null) {
        ensureOutputParameterDefinitionsIsMutable();
        outputParameterDefinitions_.remove(index);
        onChanged();
      } else {
        outputParameterDefinitionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder
        getOutputParameterDefinitionsBuilder(int index) {
      return getOutputParameterDefinitionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder
        getOutputParameterDefinitionsOrBuilder(int index) {
      if (outputParameterDefinitionsBuilder_ == null) {
        return outputParameterDefinitions_.get(index);
      } else {
        return outputParameterDefinitionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder>
        getOutputParameterDefinitionsOrBuilderList() {
      if (outputParameterDefinitionsBuilder_ != null) {
        return outputParameterDefinitionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(outputParameterDefinitions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder
        addOutputParameterDefinitionsBuilder() {
      return getOutputParameterDefinitionsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder
        addOutputParameterDefinitionsBuilder(int index) {
      return getOutputParameterDefinitionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Defined structured output parameters for this playbook.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.ParameterDefinition output_parameter_definitions = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder>
        getOutputParameterDefinitionsBuilderList() {
      return getOutputParameterDefinitionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition,
            com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder>
        getOutputParameterDefinitionsFieldBuilder() {
      if (outputParameterDefinitionsBuilder_ == null) {
        outputParameterDefinitionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition,
                com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinition.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ParameterDefinitionOrBuilder>(
                outputParameterDefinitions_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        outputParameterDefinitions_ = null;
      }
      return outputParameterDefinitionsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction,
            com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Playbook.InstructionOrBuilder>
        instructionBuilder_;
    /**
     *
     *
     * <pre>
     * Instruction to accomplish target goal.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
     *
     * @return Whether the instruction field is set.
     */
    public boolean hasInstruction() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Instruction to accomplish target goal.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
     *
     * @return The instruction.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction getInstruction() {
      if (instructionBuilder_ == null) {
        return instruction_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.getDefaultInstance()
            : instruction_;
      } else {
        return instructionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Instruction to accomplish target goal.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
     */
    public Builder setInstruction(
        com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction value) {
      if (instructionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instruction_ = value;
      } else {
        instructionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instruction to accomplish target goal.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
     */
    public Builder setInstruction(
        com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.Builder builderForValue) {
      if (instructionBuilder_ == null) {
        instruction_ = builderForValue.build();
      } else {
        instructionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instruction to accomplish target goal.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
     */
    public Builder mergeInstruction(
        com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction value) {
      if (instructionBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && instruction_ != null
            && instruction_
                != com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction
                    .getDefaultInstance()) {
          getInstructionBuilder().mergeFrom(value);
        } else {
          instruction_ = value;
        }
      } else {
        instructionBuilder_.mergeFrom(value);
      }
      if (instruction_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instruction to accomplish target goal.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
     */
    public Builder clearInstruction() {
      bitField0_ = (bitField0_ & ~0x00000020);
      instruction_ = null;
      if (instructionBuilder_ != null) {
        instructionBuilder_.dispose();
        instructionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instruction to accomplish target goal.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.Builder
        getInstructionBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getInstructionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Instruction to accomplish target goal.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Playbook.InstructionOrBuilder
        getInstructionOrBuilder() {
      if (instructionBuilder_ != null) {
        return instructionBuilder_.getMessageOrBuilder();
      } else {
        return instruction_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.getDefaultInstance()
            : instruction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Instruction to accomplish target goal.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction instruction = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction,
            com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Playbook.InstructionOrBuilder>
        getInstructionFieldBuilder() {
      if (instructionBuilder_ == null) {
        instructionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction,
                com.google.cloud.dialogflow.cx.v3beta1.Playbook.Instruction.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Playbook.InstructionOrBuilder>(
                getInstruction(), getParentForChildren(), isClean());
        instruction_ = null;
      }
      return instructionBuilder_;
    }

    private long tokenCount_;
    /**
     *
     *
     * <pre>
     * Output only. Estimated number of tokes current playbook takes when sent to
     * the LLM.
     * </pre>
     *
     * <code>int64 token_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The tokenCount.
     */
    @java.lang.Override
    public long getTokenCount() {
      return tokenCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Estimated number of tokes current playbook takes when sent to
     * the LLM.
     * </pre>
     *
     * <code>int64 token_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The tokenCount to set.
     * @return This builder for chaining.
     */
    public Builder setTokenCount(long value) {

      tokenCount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Estimated number of tokes current playbook takes when sent to
     * the LLM.
     * </pre>
     *
     * <code>int64 token_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTokenCount() {
      bitField0_ = (bitField0_ & ~0x00000040);
      tokenCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial playbook creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial playbook creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial playbook creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial playbook creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial playbook creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial playbook creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial playbook creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial playbook creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial playbook creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Last time the playbook version was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the playbook version was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the playbook version was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the playbook version was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the playbook version was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the playbook version was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the playbook version was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the playbook version was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the playbook version was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList referencedPlaybooks_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReferencedPlaybooksIsMutable() {
      if (!referencedPlaybooks_.isModifiable()) {
        referencedPlaybooks_ = new com.google.protobuf.LazyStringArrayList(referencedPlaybooks_);
      }
      bitField0_ |= 0x00000200;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of other playbooks referenced by the current
     * playbook in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the referencedPlaybooks.
     */
    public com.google.protobuf.ProtocolStringList getReferencedPlaybooksList() {
      referencedPlaybooks_.makeImmutable();
      return referencedPlaybooks_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of other playbooks referenced by the current
     * playbook in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of referencedPlaybooks.
     */
    public int getReferencedPlaybooksCount() {
      return referencedPlaybooks_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of other playbooks referenced by the current
     * playbook in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The referencedPlaybooks at the given index.
     */
    public java.lang.String getReferencedPlaybooks(int index) {
      return referencedPlaybooks_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of other playbooks referenced by the current
     * playbook in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the referencedPlaybooks at the given index.
     */
    public com.google.protobuf.ByteString getReferencedPlaybooksBytes(int index) {
      return referencedPlaybooks_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of other playbooks referenced by the current
     * playbook in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The referencedPlaybooks to set.
     * @return This builder for chaining.
     */
    public Builder setReferencedPlaybooks(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencedPlaybooksIsMutable();
      referencedPlaybooks_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of other playbooks referenced by the current
     * playbook in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The referencedPlaybooks to add.
     * @return This builder for chaining.
     */
    public Builder addReferencedPlaybooks(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencedPlaybooksIsMutable();
      referencedPlaybooks_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of other playbooks referenced by the current
     * playbook in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The referencedPlaybooks to add.
     * @return This builder for chaining.
     */
    public Builder addAllReferencedPlaybooks(java.lang.Iterable<java.lang.String> values) {
      ensureReferencedPlaybooksIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, referencedPlaybooks_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of other playbooks referenced by the current
     * playbook in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReferencedPlaybooks() {
      referencedPlaybooks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of other playbooks referenced by the current
     * playbook in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_playbooks = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the referencedPlaybooks to add.
     * @return This builder for chaining.
     */
    public Builder addReferencedPlaybooksBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReferencedPlaybooksIsMutable();
      referencedPlaybooks_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList referencedFlows_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReferencedFlowsIsMutable() {
      if (!referencedFlows_.isModifiable()) {
        referencedFlows_ = new com.google.protobuf.LazyStringArrayList(referencedFlows_);
      }
      bitField0_ |= 0x00000400;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of flows referenced by the current playbook
     * in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the referencedFlows.
     */
    public com.google.protobuf.ProtocolStringList getReferencedFlowsList() {
      referencedFlows_.makeImmutable();
      return referencedFlows_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of flows referenced by the current playbook
     * in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of referencedFlows.
     */
    public int getReferencedFlowsCount() {
      return referencedFlows_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of flows referenced by the current playbook
     * in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The referencedFlows at the given index.
     */
    public java.lang.String getReferencedFlows(int index) {
      return referencedFlows_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of flows referenced by the current playbook
     * in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the referencedFlows at the given index.
     */
    public com.google.protobuf.ByteString getReferencedFlowsBytes(int index) {
      return referencedFlows_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of flows referenced by the current playbook
     * in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The referencedFlows to set.
     * @return This builder for chaining.
     */
    public Builder setReferencedFlows(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencedFlowsIsMutable();
      referencedFlows_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of flows referenced by the current playbook
     * in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The referencedFlows to add.
     * @return This builder for chaining.
     */
    public Builder addReferencedFlows(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencedFlowsIsMutable();
      referencedFlows_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of flows referenced by the current playbook
     * in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The referencedFlows to add.
     * @return This builder for chaining.
     */
    public Builder addAllReferencedFlows(java.lang.Iterable<java.lang.String> values) {
      ensureReferencedFlowsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, referencedFlows_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of flows referenced by the current playbook
     * in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReferencedFlows() {
      referencedFlows_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of flows referenced by the current playbook
     * in the instructions.
     * </pre>
     *
     * <code>
     * repeated string referenced_flows = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the referencedFlows to add.
     * @return This builder for chaining.
     */
    public Builder addReferencedFlowsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReferencedFlowsIsMutable();
      referencedFlows_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList referencedTools_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReferencedToolsIsMutable() {
      if (!referencedTools_.isModifiable()) {
        referencedTools_ = new com.google.protobuf.LazyStringArrayList(referencedTools_);
      }
      bitField0_ |= 0x00000800;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of tools referenced by the current playbook in
     * the instructions. If not provided explicitly, they are will
     * be implied using the tool being referenced in goal and steps.
     * </pre>
     *
     * <code>
     * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the referencedTools.
     */
    public com.google.protobuf.ProtocolStringList getReferencedToolsList() {
      referencedTools_.makeImmutable();
      return referencedTools_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of tools referenced by the current playbook in
     * the instructions. If not provided explicitly, they are will
     * be implied using the tool being referenced in goal and steps.
     * </pre>
     *
     * <code>
     * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of referencedTools.
     */
    public int getReferencedToolsCount() {
      return referencedTools_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of tools referenced by the current playbook in
     * the instructions. If not provided explicitly, they are will
     * be implied using the tool being referenced in goal and steps.
     * </pre>
     *
     * <code>
     * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The referencedTools at the given index.
     */
    public java.lang.String getReferencedTools(int index) {
      return referencedTools_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of tools referenced by the current playbook in
     * the instructions. If not provided explicitly, they are will
     * be implied using the tool being referenced in goal and steps.
     * </pre>
     *
     * <code>
     * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the referencedTools at the given index.
     */
    public com.google.protobuf.ByteString getReferencedToolsBytes(int index) {
      return referencedTools_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of tools referenced by the current playbook in
     * the instructions. If not provided explicitly, they are will
     * be implied using the tool being referenced in goal and steps.
     * </pre>
     *
     * <code>
     * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The referencedTools to set.
     * @return This builder for chaining.
     */
    public Builder setReferencedTools(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencedToolsIsMutable();
      referencedTools_.set(index, value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of tools referenced by the current playbook in
     * the instructions. If not provided explicitly, they are will
     * be implied using the tool being referenced in goal and steps.
     * </pre>
     *
     * <code>
     * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The referencedTools to add.
     * @return This builder for chaining.
     */
    public Builder addReferencedTools(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencedToolsIsMutable();
      referencedTools_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of tools referenced by the current playbook in
     * the instructions. If not provided explicitly, they are will
     * be implied using the tool being referenced in goal and steps.
     * </pre>
     *
     * <code>
     * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The referencedTools to add.
     * @return This builder for chaining.
     */
    public Builder addAllReferencedTools(java.lang.Iterable<java.lang.String> values) {
      ensureReferencedToolsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, referencedTools_);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of tools referenced by the current playbook in
     * the instructions. If not provided explicitly, they are will
     * be implied using the tool being referenced in goal and steps.
     * </pre>
     *
     * <code>
     * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReferencedTools() {
      referencedTools_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of tools referenced by the current playbook in
     * the instructions. If not provided explicitly, they are will
     * be implied using the tool being referenced in goal and steps.
     * </pre>
     *
     * <code>
     * repeated string referenced_tools = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the referencedTools to add.
     * @return This builder for chaining.
     */
    public Builder addReferencedToolsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReferencedToolsIsMutable();
      referencedTools_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llmModelSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings,
            com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettingsOrBuilder>
        llmModelSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Llm model settings for the playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the llmModelSettings field is set.
     */
    public boolean hasLlmModelSettings() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Llm model settings for the playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The llmModelSettings.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings getLlmModelSettings() {
      if (llmModelSettingsBuilder_ == null) {
        return llmModelSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.getDefaultInstance()
            : llmModelSettings_;
      } else {
        return llmModelSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Llm model settings for the playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLlmModelSettings(
        com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings value) {
      if (llmModelSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        llmModelSettings_ = value;
      } else {
        llmModelSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Llm model settings for the playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLlmModelSettings(
        com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Builder builderForValue) {
      if (llmModelSettingsBuilder_ == null) {
        llmModelSettings_ = builderForValue.build();
      } else {
        llmModelSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Llm model settings for the playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeLlmModelSettings(
        com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings value) {
      if (llmModelSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && llmModelSettings_ != null
            && llmModelSettings_
                != com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.getDefaultInstance()) {
          getLlmModelSettingsBuilder().mergeFrom(value);
        } else {
          llmModelSettings_ = value;
        }
      } else {
        llmModelSettingsBuilder_.mergeFrom(value);
      }
      if (llmModelSettings_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Llm model settings for the playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearLlmModelSettings() {
      bitField0_ = (bitField0_ & ~0x00001000);
      llmModelSettings_ = null;
      if (llmModelSettingsBuilder_ != null) {
        llmModelSettingsBuilder_.dispose();
        llmModelSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Llm model settings for the playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Builder
        getLlmModelSettingsBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getLlmModelSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Llm model settings for the playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettingsOrBuilder
        getLlmModelSettingsOrBuilder() {
      if (llmModelSettingsBuilder_ != null) {
        return llmModelSettingsBuilder_.getMessageOrBuilder();
      } else {
        return llmModelSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.getDefaultInstance()
            : llmModelSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Llm model settings for the playbook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.LlmModelSettings llm_model_settings = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings,
            com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettingsOrBuilder>
        getLlmModelSettingsFieldBuilder() {
      if (llmModelSettingsBuilder_ == null) {
        llmModelSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings,
                com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.LlmModelSettingsOrBuilder>(
                getLlmModelSettings(), getParentForChildren(), isClean());
        llmModelSettings_ = null;
      }
      return llmModelSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speechSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettingsOrBuilder>
        speechSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Playbook level Settings for speech to text detection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the speechSettings field is set.
     */
    public boolean hasSpeechSettings() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Playbook level Settings for speech to text detection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The speechSettings.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
        getSpeechSettings() {
      if (speechSettingsBuilder_ == null) {
        return speechSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
                .getDefaultInstance()
            : speechSettings_;
      } else {
        return speechSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Playbook level Settings for speech to text detection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpeechSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings value) {
      if (speechSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        speechSettings_ = value;
      } else {
        speechSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Playbook level Settings for speech to text detection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpeechSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.Builder
            builderForValue) {
      if (speechSettingsBuilder_ == null) {
        speechSettings_ = builderForValue.build();
      } else {
        speechSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Playbook level Settings for speech to text detection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSpeechSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings value) {
      if (speechSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && speechSettings_ != null
            && speechSettings_
                != com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
                    .getDefaultInstance()) {
          getSpeechSettingsBuilder().mergeFrom(value);
        } else {
          speechSettings_ = value;
        }
      } else {
        speechSettingsBuilder_.mergeFrom(value);
      }
      if (speechSettings_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Playbook level Settings for speech to text detection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSpeechSettings() {
      bitField0_ = (bitField0_ & ~0x00002000);
      speechSettings_ = null;
      if (speechSettingsBuilder_ != null) {
        speechSettingsBuilder_.dispose();
        speechSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Playbook level Settings for speech to text detection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.Builder
        getSpeechSettingsBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getSpeechSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Playbook level Settings for speech to text detection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettingsOrBuilder
        getSpeechSettingsOrBuilder() {
      if (speechSettingsBuilder_ != null) {
        return speechSettingsBuilder_.getMessageOrBuilder();
      } else {
        return speechSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
                .getDefaultInstance()
            : speechSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Playbook level Settings for speech to text detection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettingsOrBuilder>
        getSpeechSettingsFieldBuilder() {
      if (speechSettingsBuilder_ == null) {
        speechSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettingsOrBuilder>(
                getSpeechSettings(), getParentForChildren(), isClean());
        speechSettings_ = null;
      }
      return speechSettingsBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Handler> handlers_ =
        java.util.Collections.emptyList();

    private void ensureHandlersIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        handlers_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Handler>(handlers_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Handler,
            com.google.cloud.dialogflow.cx.v3beta1.Handler.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.HandlerOrBuilder>
        handlersBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Handler> getHandlersList() {
      if (handlersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(handlers_);
      } else {
        return handlersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getHandlersCount() {
      if (handlersBuilder_ == null) {
        return handlers_.size();
      } else {
        return handlersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Handler getHandlers(int index) {
      if (handlersBuilder_ == null) {
        return handlers_.get(index);
      } else {
        return handlersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHandlers(int index, com.google.cloud.dialogflow.cx.v3beta1.Handler value) {
      if (handlersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHandlersIsMutable();
        handlers_.set(index, value);
        onChanged();
      } else {
        handlersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHandlers(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Handler.Builder builderForValue) {
      if (handlersBuilder_ == null) {
        ensureHandlersIsMutable();
        handlers_.set(index, builderForValue.build());
        onChanged();
      } else {
        handlersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addHandlers(com.google.cloud.dialogflow.cx.v3beta1.Handler value) {
      if (handlersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHandlersIsMutable();
        handlers_.add(value);
        onChanged();
      } else {
        handlersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addHandlers(int index, com.google.cloud.dialogflow.cx.v3beta1.Handler value) {
      if (handlersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHandlersIsMutable();
        handlers_.add(index, value);
        onChanged();
      } else {
        handlersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addHandlers(
        com.google.cloud.dialogflow.cx.v3beta1.Handler.Builder builderForValue) {
      if (handlersBuilder_ == null) {
        ensureHandlersIsMutable();
        handlers_.add(builderForValue.build());
        onChanged();
      } else {
        handlersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addHandlers(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Handler.Builder builderForValue) {
      if (handlersBuilder_ == null) {
        ensureHandlersIsMutable();
        handlers_.add(index, builderForValue.build());
        onChanged();
      } else {
        handlersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllHandlers(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Handler> values) {
      if (handlersBuilder_ == null) {
        ensureHandlersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, handlers_);
        onChanged();
      } else {
        handlersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearHandlers() {
      if (handlersBuilder_ == null) {
        handlers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        handlersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeHandlers(int index) {
      if (handlersBuilder_ == null) {
        ensureHandlersIsMutable();
        handlers_.remove(index);
        onChanged();
      } else {
        handlersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Handler.Builder getHandlersBuilder(int index) {
      return getHandlersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.HandlerOrBuilder getHandlersOrBuilder(int index) {
      if (handlersBuilder_ == null) {
        return handlers_.get(index);
      } else {
        return handlersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.HandlerOrBuilder>
        getHandlersOrBuilderList() {
      if (handlersBuilder_ != null) {
        return handlersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(handlers_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Handler.Builder addHandlersBuilder() {
      return getHandlersFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.Handler.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Handler.Builder addHandlersBuilder(int index) {
      return getHandlersFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.cx.v3beta1.Handler.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of registered handlers to execute based on the specified
     * triggers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Handler handlers = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Handler.Builder>
        getHandlersBuilderList() {
      return getHandlersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Handler,
            com.google.cloud.dialogflow.cx.v3beta1.Handler.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.HandlerOrBuilder>
        getHandlersFieldBuilder() {
      if (handlersBuilder_ == null) {
        handlersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Handler,
                com.google.cloud.dialogflow.cx.v3beta1.Handler.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.HandlerOrBuilder>(
                handlers_, ((bitField0_ & 0x00004000) != 0), getParentForChildren(), isClean());
        handlers_ = null;
      }
      return handlersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Playbook)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Playbook)
  private static final com.google.cloud.dialogflow.cx.v3beta1.Playbook DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Playbook();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Playbook getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Playbook> PARSER =
      new com.google.protobuf.AbstractParser<Playbook>() {
        @java.lang.Override
        public Playbook parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Playbook> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Playbook> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Playbook getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
