/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/playbook.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Handler can be used to define custom logic to be executed based on the
 * user-specified triggers.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Handler}
 */
public final class Handler extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Handler)
    HandlerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Handler.newBuilder() to construct.
  private Handler(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Handler() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Handler();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.Handler.class,
            com.google.cloud.dialogflow.cx.v3beta1.Handler.Builder.class);
  }

  public interface EventHandlerOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the event that triggers this handler.
     * </pre>
     *
     * <code>string event = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The event.
     */
    java.lang.String getEvent();
    /**
     *
     *
     * <pre>
     * Required. The name of the event that triggers this handler.
     * </pre>
     *
     * <code>string event = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for event.
     */
    com.google.protobuf.ByteString getEventBytes();

    /**
     *
     *
     * <pre>
     * Optional. The condition that must be satisfied to trigger this handler.
     * </pre>
     *
     * <code>string condition = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The condition.
     */
    java.lang.String getCondition();
    /**
     *
     *
     * <pre>
     * Optional. The condition that must be satisfied to trigger this handler.
     * </pre>
     *
     * <code>string condition = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for condition.
     */
    com.google.protobuf.ByteString getConditionBytes();

    /**
     *
     *
     * <pre>
     * Required. The fulfillment to call when the event occurs.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the fulfillment field is set.
     */
    boolean hasFulfillment();
    /**
     *
     *
     * <pre>
     * Required. The fulfillment to call when the event occurs.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The fulfillment.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Fulfillment getFulfillment();
    /**
     *
     *
     * <pre>
     * Required. The fulfillment to call when the event occurs.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder getFulfillmentOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A handler that is triggered by the specified
   * [event][google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.event].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler}
   */
  public static final class EventHandler extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler)
      EventHandlerOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EventHandler.newBuilder() to construct.
    private EventHandler(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EventHandler() {
      event_ = "";
      condition_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EventHandler();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_EventHandler_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_EventHandler_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.class,
              com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.Builder.class);
    }

    private int bitField0_;
    public static final int EVENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object event_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the event that triggers this handler.
     * </pre>
     *
     * <code>string event = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The event.
     */
    @java.lang.Override
    public java.lang.String getEvent() {
      java.lang.Object ref = event_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        event_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the event that triggers this handler.
     * </pre>
     *
     * <code>string event = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for event.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEventBytes() {
      java.lang.Object ref = event_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        event_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONDITION_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object condition_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The condition that must be satisfied to trigger this handler.
     * </pre>
     *
     * <code>string condition = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The condition.
     */
    @java.lang.Override
    public java.lang.String getCondition() {
      java.lang.Object ref = condition_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        condition_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The condition that must be satisfied to trigger this handler.
     * </pre>
     *
     * <code>string condition = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for condition.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConditionBytes() {
      java.lang.Object ref = condition_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        condition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FULFILLMENT_FIELD_NUMBER = 2;
    private com.google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment_;
    /**
     *
     *
     * <pre>
     * Required. The fulfillment to call when the event occurs.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the fulfillment field is set.
     */
    @java.lang.Override
    public boolean hasFulfillment() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The fulfillment to call when the event occurs.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The fulfillment.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Fulfillment getFulfillment() {
      return fulfillment_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
          : fulfillment_;
    }
    /**
     *
     *
     * <pre>
     * Required. The fulfillment to call when the event occurs.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder getFulfillmentOrBuilder() {
      return fulfillment_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
          : fulfillment_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(event_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, event_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getFulfillment());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, condition_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(event_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, event_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFulfillment());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, condition_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler other =
          (com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler) obj;

      if (!getEvent().equals(other.getEvent())) return false;
      if (!getCondition().equals(other.getCondition())) return false;
      if (hasFulfillment() != other.hasFulfillment()) return false;
      if (hasFulfillment()) {
        if (!getFulfillment().equals(other.getFulfillment())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EVENT_FIELD_NUMBER;
      hash = (53 * hash) + getEvent().hashCode();
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getCondition().hashCode();
      if (hasFulfillment()) {
        hash = (37 * hash) + FULFILLMENT_FIELD_NUMBER;
        hash = (53 * hash) + getFulfillment().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A handler that is triggered by the specified
     * [event][google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.event].
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler)
        com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandlerOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_EventHandler_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_EventHandler_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.class,
                com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFulfillmentFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        event_ = "";
        condition_ = "";
        fulfillment_ = null;
        if (fulfillmentBuilder_ != null) {
          fulfillmentBuilder_.dispose();
          fulfillmentBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_EventHandler_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler build() {
        com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler result =
            new com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.event_ = event_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.condition_ = condition_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.fulfillment_ =
              fulfillmentBuilder_ == null ? fulfillment_ : fulfillmentBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.getDefaultInstance())
          return this;
        if (!other.getEvent().isEmpty()) {
          event_ = other.event_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getCondition().isEmpty()) {
          condition_ = other.condition_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasFulfillment()) {
          mergeFulfillment(other.getFulfillment());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  event_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getFulfillmentFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 18
              case 26:
                {
                  condition_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object event_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the event that triggers this handler.
       * </pre>
       *
       * <code>string event = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The event.
       */
      public java.lang.String getEvent() {
        java.lang.Object ref = event_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          event_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the event that triggers this handler.
       * </pre>
       *
       * <code>string event = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for event.
       */
      public com.google.protobuf.ByteString getEventBytes() {
        java.lang.Object ref = event_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          event_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the event that triggers this handler.
       * </pre>
       *
       * <code>string event = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The event to set.
       * @return This builder for chaining.
       */
      public Builder setEvent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        event_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the event that triggers this handler.
       * </pre>
       *
       * <code>string event = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEvent() {
        event_ = getDefaultInstance().getEvent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the event that triggers this handler.
       * </pre>
       *
       * <code>string event = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for event to set.
       * @return This builder for chaining.
       */
      public Builder setEventBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        event_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object condition_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The condition that must be satisfied to trigger this handler.
       * </pre>
       *
       * <code>string condition = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The condition.
       */
      public java.lang.String getCondition() {
        java.lang.Object ref = condition_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          condition_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The condition that must be satisfied to trigger this handler.
       * </pre>
       *
       * <code>string condition = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for condition.
       */
      public com.google.protobuf.ByteString getConditionBytes() {
        java.lang.Object ref = condition_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          condition_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The condition that must be satisfied to trigger this handler.
       * </pre>
       *
       * <code>string condition = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The condition to set.
       * @return This builder for chaining.
       */
      public Builder setCondition(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        condition_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The condition that must be satisfied to trigger this handler.
       * </pre>
       *
       * <code>string condition = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCondition() {
        condition_ = getDefaultInstance().getCondition();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The condition that must be satisfied to trigger this handler.
       * </pre>
       *
       * <code>string condition = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for condition to set.
       * @return This builder for chaining.
       */
      public Builder setConditionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        condition_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Fulfillment,
              com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder>
          fulfillmentBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when the event occurs.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the fulfillment field is set.
       */
      public boolean hasFulfillment() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when the event occurs.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The fulfillment.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Fulfillment getFulfillment() {
        if (fulfillmentBuilder_ == null) {
          return fulfillment_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
              : fulfillment_;
        } else {
          return fulfillmentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when the event occurs.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFulfillment(com.google.cloud.dialogflow.cx.v3beta1.Fulfillment value) {
        if (fulfillmentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          fulfillment_ = value;
        } else {
          fulfillmentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when the event occurs.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFulfillment(
          com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder builderForValue) {
        if (fulfillmentBuilder_ == null) {
          fulfillment_ = builderForValue.build();
        } else {
          fulfillmentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when the event occurs.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeFulfillment(com.google.cloud.dialogflow.cx.v3beta1.Fulfillment value) {
        if (fulfillmentBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && fulfillment_ != null
              && fulfillment_
                  != com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()) {
            getFulfillmentBuilder().mergeFrom(value);
          } else {
            fulfillment_ = value;
          }
        } else {
          fulfillmentBuilder_.mergeFrom(value);
        }
        if (fulfillment_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when the event occurs.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearFulfillment() {
        bitField0_ = (bitField0_ & ~0x00000004);
        fulfillment_ = null;
        if (fulfillmentBuilder_ != null) {
          fulfillmentBuilder_.dispose();
          fulfillmentBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when the event occurs.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder getFulfillmentBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getFulfillmentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when the event occurs.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder getFulfillmentOrBuilder() {
        if (fulfillmentBuilder_ != null) {
          return fulfillmentBuilder_.getMessageOrBuilder();
        } else {
          return fulfillment_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
              : fulfillment_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when the event occurs.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Fulfillment,
              com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder>
          getFulfillmentFieldBuilder() {
        if (fulfillmentBuilder_ == null) {
          fulfillmentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Fulfillment,
                  com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder>(
                  getFulfillment(), getParentForChildren(), isClean());
          fulfillment_ = null;
        }
        return fulfillmentBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EventHandler> PARSER =
        new com.google.protobuf.AbstractParser<EventHandler>() {
          @java.lang.Override
          public EventHandler parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EventHandler> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EventHandler> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LifecycleHandlerOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the lifecycle stage that triggers this handler.
     * Supported values:
     * * `playbook-start`
     * * `pre-action-selection`
     * * `pre-action-execution`
     * </pre>
     *
     * <code>string lifecycle_stage = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The lifecycleStage.
     */
    java.lang.String getLifecycleStage();
    /**
     *
     *
     * <pre>
     * Required. The name of the lifecycle stage that triggers this handler.
     * Supported values:
     * * `playbook-start`
     * * `pre-action-selection`
     * * `pre-action-execution`
     * </pre>
     *
     * <code>string lifecycle_stage = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for lifecycleStage.
     */
    com.google.protobuf.ByteString getLifecycleStageBytes();

    /**
     *
     *
     * <pre>
     * Optional. The condition that must be satisfied to trigger this handler.
     * </pre>
     *
     * <code>string condition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The condition.
     */
    java.lang.String getCondition();
    /**
     *
     *
     * <pre>
     * Optional. The condition that must be satisfied to trigger this handler.
     * </pre>
     *
     * <code>string condition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for condition.
     */
    com.google.protobuf.ByteString getConditionBytes();

    /**
     *
     *
     * <pre>
     * Required. The fulfillment to call when this handler is triggered.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the fulfillment field is set.
     */
    boolean hasFulfillment();
    /**
     *
     *
     * <pre>
     * Required. The fulfillment to call when this handler is triggered.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The fulfillment.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Fulfillment getFulfillment();
    /**
     *
     *
     * <pre>
     * Required. The fulfillment to call when this handler is triggered.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder getFulfillmentOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A handler that is triggered on the specific
   * [lifecycle_stage][google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.lifecycle_stage]
   * of the playbook execution.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler}
   */
  public static final class LifecycleHandler extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler)
      LifecycleHandlerOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LifecycleHandler.newBuilder() to construct.
    private LifecycleHandler(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LifecycleHandler() {
      lifecycleStage_ = "";
      condition_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LifecycleHandler();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_LifecycleHandler_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_LifecycleHandler_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.class,
              com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.Builder.class);
    }

    private int bitField0_;
    public static final int LIFECYCLE_STAGE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object lifecycleStage_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the lifecycle stage that triggers this handler.
     * Supported values:
     * * `playbook-start`
     * * `pre-action-selection`
     * * `pre-action-execution`
     * </pre>
     *
     * <code>string lifecycle_stage = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The lifecycleStage.
     */
    @java.lang.Override
    public java.lang.String getLifecycleStage() {
      java.lang.Object ref = lifecycleStage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lifecycleStage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the lifecycle stage that triggers this handler.
     * Supported values:
     * * `playbook-start`
     * * `pre-action-selection`
     * * `pre-action-execution`
     * </pre>
     *
     * <code>string lifecycle_stage = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for lifecycleStage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLifecycleStageBytes() {
      java.lang.Object ref = lifecycleStage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lifecycleStage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONDITION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object condition_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The condition that must be satisfied to trigger this handler.
     * </pre>
     *
     * <code>string condition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The condition.
     */
    @java.lang.Override
    public java.lang.String getCondition() {
      java.lang.Object ref = condition_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        condition_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The condition that must be satisfied to trigger this handler.
     * </pre>
     *
     * <code>string condition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for condition.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConditionBytes() {
      java.lang.Object ref = condition_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        condition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FULFILLMENT_FIELD_NUMBER = 3;
    private com.google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment_;
    /**
     *
     *
     * <pre>
     * Required. The fulfillment to call when this handler is triggered.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the fulfillment field is set.
     */
    @java.lang.Override
    public boolean hasFulfillment() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The fulfillment to call when this handler is triggered.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The fulfillment.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Fulfillment getFulfillment() {
      return fulfillment_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
          : fulfillment_;
    }
    /**
     *
     *
     * <pre>
     * Required. The fulfillment to call when this handler is triggered.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder getFulfillmentOrBuilder() {
      return fulfillment_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
          : fulfillment_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lifecycleStage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, lifecycleStage_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, condition_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getFulfillment());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lifecycleStage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, lifecycleStage_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, condition_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFulfillment());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler other =
          (com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler) obj;

      if (!getLifecycleStage().equals(other.getLifecycleStage())) return false;
      if (!getCondition().equals(other.getCondition())) return false;
      if (hasFulfillment() != other.hasFulfillment()) return false;
      if (hasFulfillment()) {
        if (!getFulfillment().equals(other.getFulfillment())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LIFECYCLE_STAGE_FIELD_NUMBER;
      hash = (53 * hash) + getLifecycleStage().hashCode();
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getCondition().hashCode();
      if (hasFulfillment()) {
        hash = (37 * hash) + FULFILLMENT_FIELD_NUMBER;
        hash = (53 * hash) + getFulfillment().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A handler that is triggered on the specific
     * [lifecycle_stage][google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.lifecycle_stage]
     * of the playbook execution.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler)
        com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandlerOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_LifecycleHandler_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_LifecycleHandler_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.class,
                com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFulfillmentFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        lifecycleStage_ = "";
        condition_ = "";
        fulfillment_ = null;
        if (fulfillmentBuilder_ != null) {
          fulfillmentBuilder_.dispose();
          fulfillmentBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_LifecycleHandler_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler build() {
        com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler result =
            new com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.lifecycleStage_ = lifecycleStage_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.condition_ = condition_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.fulfillment_ =
              fulfillmentBuilder_ == null ? fulfillment_ : fulfillmentBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.getDefaultInstance())
          return this;
        if (!other.getLifecycleStage().isEmpty()) {
          lifecycleStage_ = other.lifecycleStage_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getCondition().isEmpty()) {
          condition_ = other.condition_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasFulfillment()) {
          mergeFulfillment(other.getFulfillment());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  lifecycleStage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  condition_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getFulfillmentFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object lifecycleStage_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the lifecycle stage that triggers this handler.
       * Supported values:
       * * `playbook-start`
       * * `pre-action-selection`
       * * `pre-action-execution`
       * </pre>
       *
       * <code>string lifecycle_stage = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The lifecycleStage.
       */
      public java.lang.String getLifecycleStage() {
        java.lang.Object ref = lifecycleStage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          lifecycleStage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the lifecycle stage that triggers this handler.
       * Supported values:
       * * `playbook-start`
       * * `pre-action-selection`
       * * `pre-action-execution`
       * </pre>
       *
       * <code>string lifecycle_stage = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for lifecycleStage.
       */
      public com.google.protobuf.ByteString getLifecycleStageBytes() {
        java.lang.Object ref = lifecycleStage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          lifecycleStage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the lifecycle stage that triggers this handler.
       * Supported values:
       * * `playbook-start`
       * * `pre-action-selection`
       * * `pre-action-execution`
       * </pre>
       *
       * <code>string lifecycle_stage = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The lifecycleStage to set.
       * @return This builder for chaining.
       */
      public Builder setLifecycleStage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        lifecycleStage_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the lifecycle stage that triggers this handler.
       * Supported values:
       * * `playbook-start`
       * * `pre-action-selection`
       * * `pre-action-execution`
       * </pre>
       *
       * <code>string lifecycle_stage = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLifecycleStage() {
        lifecycleStage_ = getDefaultInstance().getLifecycleStage();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the lifecycle stage that triggers this handler.
       * Supported values:
       * * `playbook-start`
       * * `pre-action-selection`
       * * `pre-action-execution`
       * </pre>
       *
       * <code>string lifecycle_stage = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for lifecycleStage to set.
       * @return This builder for chaining.
       */
      public Builder setLifecycleStageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        lifecycleStage_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object condition_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The condition that must be satisfied to trigger this handler.
       * </pre>
       *
       * <code>string condition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The condition.
       */
      public java.lang.String getCondition() {
        java.lang.Object ref = condition_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          condition_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The condition that must be satisfied to trigger this handler.
       * </pre>
       *
       * <code>string condition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for condition.
       */
      public com.google.protobuf.ByteString getConditionBytes() {
        java.lang.Object ref = condition_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          condition_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The condition that must be satisfied to trigger this handler.
       * </pre>
       *
       * <code>string condition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The condition to set.
       * @return This builder for chaining.
       */
      public Builder setCondition(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        condition_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The condition that must be satisfied to trigger this handler.
       * </pre>
       *
       * <code>string condition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCondition() {
        condition_ = getDefaultInstance().getCondition();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The condition that must be satisfied to trigger this handler.
       * </pre>
       *
       * <code>string condition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for condition to set.
       * @return This builder for chaining.
       */
      public Builder setConditionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        condition_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Fulfillment,
              com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder>
          fulfillmentBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when this handler is triggered.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the fulfillment field is set.
       */
      public boolean hasFulfillment() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when this handler is triggered.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The fulfillment.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Fulfillment getFulfillment() {
        if (fulfillmentBuilder_ == null) {
          return fulfillment_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
              : fulfillment_;
        } else {
          return fulfillmentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when this handler is triggered.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFulfillment(com.google.cloud.dialogflow.cx.v3beta1.Fulfillment value) {
        if (fulfillmentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          fulfillment_ = value;
        } else {
          fulfillmentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when this handler is triggered.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFulfillment(
          com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder builderForValue) {
        if (fulfillmentBuilder_ == null) {
          fulfillment_ = builderForValue.build();
        } else {
          fulfillmentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when this handler is triggered.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeFulfillment(com.google.cloud.dialogflow.cx.v3beta1.Fulfillment value) {
        if (fulfillmentBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && fulfillment_ != null
              && fulfillment_
                  != com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()) {
            getFulfillmentBuilder().mergeFrom(value);
          } else {
            fulfillment_ = value;
          }
        } else {
          fulfillmentBuilder_.mergeFrom(value);
        }
        if (fulfillment_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when this handler is triggered.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearFulfillment() {
        bitField0_ = (bitField0_ & ~0x00000004);
        fulfillment_ = null;
        if (fulfillmentBuilder_ != null) {
          fulfillmentBuilder_.dispose();
          fulfillmentBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when this handler is triggered.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder getFulfillmentBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getFulfillmentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when this handler is triggered.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder getFulfillmentOrBuilder() {
        if (fulfillmentBuilder_ != null) {
          return fulfillmentBuilder_.getMessageOrBuilder();
        } else {
          return fulfillment_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.getDefaultInstance()
              : fulfillment_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment to call when this handler is triggered.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Fulfillment fulfillment = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Fulfillment,
              com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder>
          getFulfillmentFieldBuilder() {
        if (fulfillmentBuilder_ == null) {
          fulfillmentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Fulfillment,
                  com.google.cloud.dialogflow.cx.v3beta1.Fulfillment.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.FulfillmentOrBuilder>(
                  getFulfillment(), getParentForChildren(), isClean());
          fulfillment_ = null;
        }
        return fulfillmentBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LifecycleHandler> PARSER =
        new com.google.protobuf.AbstractParser<LifecycleHandler>() {
          @java.lang.Override
          public LifecycleHandler parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LifecycleHandler> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LifecycleHandler> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int handlerCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object handler_;

  public enum HandlerCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EVENT_HANDLER(1),
    LIFECYCLE_HANDLER(3),
    HANDLER_NOT_SET(0);
    private final int value;

    private HandlerCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HandlerCase valueOf(int value) {
      return forNumber(value);
    }

    public static HandlerCase forNumber(int value) {
      switch (value) {
        case 1:
          return EVENT_HANDLER;
        case 3:
          return LIFECYCLE_HANDLER;
        case 0:
          return HANDLER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public HandlerCase getHandlerCase() {
    return HandlerCase.forNumber(handlerCase_);
  }

  public static final int EVENT_HANDLER_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * A handler triggered by event.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler event_handler = 1;</code>
   *
   * @return Whether the eventHandler field is set.
   */
  @java.lang.Override
  public boolean hasEventHandler() {
    return handlerCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * A handler triggered by event.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler event_handler = 1;</code>
   *
   * @return The eventHandler.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler getEventHandler() {
    if (handlerCase_ == 1) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler) handler_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A handler triggered by event.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler event_handler = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandlerOrBuilder
      getEventHandlerOrBuilder() {
    if (handlerCase_ == 1) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler) handler_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.getDefaultInstance();
  }

  public static final int LIFECYCLE_HANDLER_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A handler triggered during specific lifecycle of the playbook execution.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler lifecycle_handler = 3;
   * </code>
   *
   * @return Whether the lifecycleHandler field is set.
   */
  @java.lang.Override
  public boolean hasLifecycleHandler() {
    return handlerCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A handler triggered during specific lifecycle of the playbook execution.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler lifecycle_handler = 3;
   * </code>
   *
   * @return The lifecycleHandler.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler getLifecycleHandler() {
    if (handlerCase_ == 3) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler) handler_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A handler triggered during specific lifecycle of the playbook execution.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler lifecycle_handler = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandlerOrBuilder
      getLifecycleHandlerOrBuilder() {
    if (handlerCase_ == 3) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler) handler_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (handlerCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler) handler_);
    }
    if (handlerCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler) handler_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (handlerCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler) handler_);
    }
    if (handlerCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler) handler_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Handler)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.Handler other =
        (com.google.cloud.dialogflow.cx.v3beta1.Handler) obj;

    if (!getHandlerCase().equals(other.getHandlerCase())) return false;
    switch (handlerCase_) {
      case 1:
        if (!getEventHandler().equals(other.getEventHandler())) return false;
        break;
      case 3:
        if (!getLifecycleHandler().equals(other.getLifecycleHandler())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (handlerCase_) {
      case 1:
        hash = (37 * hash) + EVENT_HANDLER_FIELD_NUMBER;
        hash = (53 * hash) + getEventHandler().hashCode();
        break;
      case 3:
        hash = (37 * hash) + LIFECYCLE_HANDLER_FIELD_NUMBER;
        hash = (53 * hash) + getLifecycleHandler().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.Handler prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Handler can be used to define custom logic to be executed based on the
   * user-specified triggers.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Handler}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Handler)
      com.google.cloud.dialogflow.cx.v3beta1.HandlerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Handler.class,
              com.google.cloud.dialogflow.cx.v3beta1.Handler.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.Handler.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (eventHandlerBuilder_ != null) {
        eventHandlerBuilder_.clear();
      }
      if (lifecycleHandlerBuilder_ != null) {
        lifecycleHandlerBuilder_.clear();
      }
      handlerCase_ = 0;
      handler_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.PlaybookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Handler_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Handler getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.Handler.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Handler build() {
      com.google.cloud.dialogflow.cx.v3beta1.Handler result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Handler buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.Handler result =
          new com.google.cloud.dialogflow.cx.v3beta1.Handler(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Handler result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.cx.v3beta1.Handler result) {
      result.handlerCase_ = handlerCase_;
      result.handler_ = this.handler_;
      if (handlerCase_ == 1 && eventHandlerBuilder_ != null) {
        result.handler_ = eventHandlerBuilder_.build();
      }
      if (handlerCase_ == 3 && lifecycleHandlerBuilder_ != null) {
        result.handler_ = lifecycleHandlerBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Handler) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Handler) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Handler other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.Handler.getDefaultInstance()) return this;
      switch (other.getHandlerCase()) {
        case EVENT_HANDLER:
          {
            mergeEventHandler(other.getEventHandler());
            break;
          }
        case LIFECYCLE_HANDLER:
          {
            mergeLifecycleHandler(other.getLifecycleHandler());
            break;
          }
        case HANDLER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getEventHandlerFieldBuilder().getBuilder(), extensionRegistry);
                handlerCase_ = 1;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(
                    getLifecycleHandlerFieldBuilder().getBuilder(), extensionRegistry);
                handlerCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int handlerCase_ = 0;
    private java.lang.Object handler_;

    public HandlerCase getHandlerCase() {
      return HandlerCase.forNumber(handlerCase_);
    }

    public Builder clearHandler() {
      handlerCase_ = 0;
      handler_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler,
            com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandlerOrBuilder>
        eventHandlerBuilder_;
    /**
     *
     *
     * <pre>
     * A handler triggered by event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler event_handler = 1;</code>
     *
     * @return Whether the eventHandler field is set.
     */
    @java.lang.Override
    public boolean hasEventHandler() {
      return handlerCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A handler triggered by event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler event_handler = 1;</code>
     *
     * @return The eventHandler.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler getEventHandler() {
      if (eventHandlerBuilder_ == null) {
        if (handlerCase_ == 1) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler) handler_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.getDefaultInstance();
      } else {
        if (handlerCase_ == 1) {
          return eventHandlerBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A handler triggered by event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler event_handler = 1;</code>
     */
    public Builder setEventHandler(
        com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler value) {
      if (eventHandlerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        handler_ = value;
        onChanged();
      } else {
        eventHandlerBuilder_.setMessage(value);
      }
      handlerCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A handler triggered by event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler event_handler = 1;</code>
     */
    public Builder setEventHandler(
        com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.Builder builderForValue) {
      if (eventHandlerBuilder_ == null) {
        handler_ = builderForValue.build();
        onChanged();
      } else {
        eventHandlerBuilder_.setMessage(builderForValue.build());
      }
      handlerCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A handler triggered by event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler event_handler = 1;</code>
     */
    public Builder mergeEventHandler(
        com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler value) {
      if (eventHandlerBuilder_ == null) {
        if (handlerCase_ == 1
            && handler_
                != com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler
                    .getDefaultInstance()) {
          handler_ =
              com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler) handler_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          handler_ = value;
        }
        onChanged();
      } else {
        if (handlerCase_ == 1) {
          eventHandlerBuilder_.mergeFrom(value);
        } else {
          eventHandlerBuilder_.setMessage(value);
        }
      }
      handlerCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A handler triggered by event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler event_handler = 1;</code>
     */
    public Builder clearEventHandler() {
      if (eventHandlerBuilder_ == null) {
        if (handlerCase_ == 1) {
          handlerCase_ = 0;
          handler_ = null;
          onChanged();
        }
      } else {
        if (handlerCase_ == 1) {
          handlerCase_ = 0;
          handler_ = null;
        }
        eventHandlerBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A handler triggered by event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler event_handler = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.Builder
        getEventHandlerBuilder() {
      return getEventHandlerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A handler triggered by event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler event_handler = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandlerOrBuilder
        getEventHandlerOrBuilder() {
      if ((handlerCase_ == 1) && (eventHandlerBuilder_ != null)) {
        return eventHandlerBuilder_.getMessageOrBuilder();
      } else {
        if (handlerCase_ == 1) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler) handler_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A handler triggered by event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler event_handler = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler,
            com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandlerOrBuilder>
        getEventHandlerFieldBuilder() {
      if (eventHandlerBuilder_ == null) {
        if (!(handlerCase_ == 1)) {
          handler_ =
              com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.getDefaultInstance();
        }
        eventHandlerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler,
                com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandlerOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.Handler.EventHandler) handler_,
                getParentForChildren(),
                isClean());
        handler_ = null;
      }
      handlerCase_ = 1;
      onChanged();
      return eventHandlerBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler,
            com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandlerOrBuilder>
        lifecycleHandlerBuilder_;
    /**
     *
     *
     * <pre>
     * A handler triggered during specific lifecycle of the playbook execution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler lifecycle_handler = 3;
     * </code>
     *
     * @return Whether the lifecycleHandler field is set.
     */
    @java.lang.Override
    public boolean hasLifecycleHandler() {
      return handlerCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A handler triggered during specific lifecycle of the playbook execution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler lifecycle_handler = 3;
     * </code>
     *
     * @return The lifecycleHandler.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler getLifecycleHandler() {
      if (lifecycleHandlerBuilder_ == null) {
        if (handlerCase_ == 3) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler) handler_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.getDefaultInstance();
      } else {
        if (handlerCase_ == 3) {
          return lifecycleHandlerBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A handler triggered during specific lifecycle of the playbook execution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler lifecycle_handler = 3;
     * </code>
     */
    public Builder setLifecycleHandler(
        com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler value) {
      if (lifecycleHandlerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        handler_ = value;
        onChanged();
      } else {
        lifecycleHandlerBuilder_.setMessage(value);
      }
      handlerCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A handler triggered during specific lifecycle of the playbook execution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler lifecycle_handler = 3;
     * </code>
     */
    public Builder setLifecycleHandler(
        com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.Builder builderForValue) {
      if (lifecycleHandlerBuilder_ == null) {
        handler_ = builderForValue.build();
        onChanged();
      } else {
        lifecycleHandlerBuilder_.setMessage(builderForValue.build());
      }
      handlerCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A handler triggered during specific lifecycle of the playbook execution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler lifecycle_handler = 3;
     * </code>
     */
    public Builder mergeLifecycleHandler(
        com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler value) {
      if (lifecycleHandlerBuilder_ == null) {
        if (handlerCase_ == 3
            && handler_
                != com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler
                    .getDefaultInstance()) {
          handler_ =
              com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler) handler_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          handler_ = value;
        }
        onChanged();
      } else {
        if (handlerCase_ == 3) {
          lifecycleHandlerBuilder_.mergeFrom(value);
        } else {
          lifecycleHandlerBuilder_.setMessage(value);
        }
      }
      handlerCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A handler triggered during specific lifecycle of the playbook execution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler lifecycle_handler = 3;
     * </code>
     */
    public Builder clearLifecycleHandler() {
      if (lifecycleHandlerBuilder_ == null) {
        if (handlerCase_ == 3) {
          handlerCase_ = 0;
          handler_ = null;
          onChanged();
        }
      } else {
        if (handlerCase_ == 3) {
          handlerCase_ = 0;
          handler_ = null;
        }
        lifecycleHandlerBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A handler triggered during specific lifecycle of the playbook execution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler lifecycle_handler = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.Builder
        getLifecycleHandlerBuilder() {
      return getLifecycleHandlerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A handler triggered during specific lifecycle of the playbook execution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler lifecycle_handler = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandlerOrBuilder
        getLifecycleHandlerOrBuilder() {
      if ((handlerCase_ == 3) && (lifecycleHandlerBuilder_ != null)) {
        return lifecycleHandlerBuilder_.getMessageOrBuilder();
      } else {
        if (handlerCase_ == 3) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler) handler_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A handler triggered during specific lifecycle of the playbook execution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler lifecycle_handler = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler,
            com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandlerOrBuilder>
        getLifecycleHandlerFieldBuilder() {
      if (lifecycleHandlerBuilder_ == null) {
        if (!(handlerCase_ == 3)) {
          handler_ =
              com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.getDefaultInstance();
        }
        lifecycleHandlerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler,
                com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandlerOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.Handler.LifecycleHandler) handler_,
                getParentForChildren(),
                isClean());
        handler_ = null;
      }
      handlerCase_ = 3;
      onChanged();
      return lifecycleHandlerBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Handler)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Handler)
  private static final com.google.cloud.dialogflow.cx.v3beta1.Handler DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Handler();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Handler getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Handler> PARSER =
      new com.google.protobuf.AbstractParser<Handler>() {
        @java.lang.Override
        public Handler parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Handler> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Handler> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Handler getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
