/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/example.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Stores metadata of the invocation of a CX flow.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.FlowInvocation}
 */
public final class FlowInvocation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.FlowInvocation)
    FlowInvocationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FlowInvocation.newBuilder() to construct.
  private FlowInvocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FlowInvocation() {
    flow_ = "";
    displayName_ = "";
    flowState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FlowInvocation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_FlowInvocation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_FlowInvocation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.class,
            com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.Builder.class);
  }

  private int bitField0_;
  public static final int FLOW_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object flow_ = "";
  /**
   *
   *
   * <pre>
   * Required. The unique identifier of the flow.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
   * </pre>
   *
   * <code>
   * string flow = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The flow.
   */
  @java.lang.Override
  public java.lang.String getFlow() {
    java.lang.Object ref = flow_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      flow_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique identifier of the flow.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
   * </pre>
   *
   * <code>
   * string flow = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for flow.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFlowBytes() {
    java.lang.Object ref = flow_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      flow_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The display name of the flow.
   * </pre>
   *
   * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The display name of the flow.
   * </pre>
   *
   * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_ACTION_PARAMETERS_FIELD_NUMBER = 5;
  private com.google.protobuf.Struct inputActionParameters_;
  /**
   *
   *
   * <pre>
   * Optional. A list of input parameters for the flow.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct input_action_parameters = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the inputActionParameters field is set.
   */
  @java.lang.Override
  public boolean hasInputActionParameters() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of input parameters for the flow.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct input_action_parameters = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The inputActionParameters.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getInputActionParameters() {
    return inputActionParameters_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : inputActionParameters_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of input parameters for the flow.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct input_action_parameters = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getInputActionParametersOrBuilder() {
    return inputActionParameters_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : inputActionParameters_;
  }

  public static final int OUTPUT_ACTION_PARAMETERS_FIELD_NUMBER = 6;
  private com.google.protobuf.Struct outputActionParameters_;
  /**
   *
   *
   * <pre>
   * Optional. A list of output parameters generated by the flow invocation.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct output_action_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the outputActionParameters field is set.
   */
  @java.lang.Override
  public boolean hasOutputActionParameters() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of output parameters generated by the flow invocation.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct output_action_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The outputActionParameters.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getOutputActionParameters() {
    return outputActionParameters_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : outputActionParameters_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of output parameters generated by the flow invocation.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct output_action_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getOutputActionParametersOrBuilder() {
    return outputActionParameters_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : outputActionParameters_;
  }

  public static final int FLOW_STATE_FIELD_NUMBER = 4;
  private int flowState_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Flow invocation's output state.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.OutputState flow_state = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for flowState.
   */
  @java.lang.Override
  public int getFlowStateValue() {
    return flowState_;
  }
  /**
   *
   *
   * <pre>
   * Required. Flow invocation's output state.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.OutputState flow_state = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The flowState.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.OutputState getFlowState() {
    com.google.cloud.dialogflow.cx.v3beta1.OutputState result =
        com.google.cloud.dialogflow.cx.v3beta1.OutputState.forNumber(flowState_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.OutputState.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(flow_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, flow_);
    }
    if (flowState_
        != com.google.cloud.dialogflow.cx.v3beta1.OutputState.OUTPUT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, flowState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getInputActionParameters());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getOutputActionParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(flow_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, flow_);
    }
    if (flowState_
        != com.google.cloud.dialogflow.cx.v3beta1.OutputState.OUTPUT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, flowState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getInputActionParameters());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOutputActionParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation other =
        (com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation) obj;

    if (!getFlow().equals(other.getFlow())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasInputActionParameters() != other.hasInputActionParameters()) return false;
    if (hasInputActionParameters()) {
      if (!getInputActionParameters().equals(other.getInputActionParameters())) return false;
    }
    if (hasOutputActionParameters() != other.hasOutputActionParameters()) return false;
    if (hasOutputActionParameters()) {
      if (!getOutputActionParameters().equals(other.getOutputActionParameters())) return false;
    }
    if (flowState_ != other.flowState_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FLOW_FIELD_NUMBER;
    hash = (53 * hash) + getFlow().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasInputActionParameters()) {
      hash = (37 * hash) + INPUT_ACTION_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getInputActionParameters().hashCode();
    }
    if (hasOutputActionParameters()) {
      hash = (37 * hash) + OUTPUT_ACTION_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getOutputActionParameters().hashCode();
    }
    hash = (37 * hash) + FLOW_STATE_FIELD_NUMBER;
    hash = (53 * hash) + flowState_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Stores metadata of the invocation of a CX flow.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.FlowInvocation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.FlowInvocation)
      com.google.cloud.dialogflow.cx.v3beta1.FlowInvocationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_FlowInvocation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_FlowInvocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.class,
              com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInputActionParametersFieldBuilder();
        getOutputActionParametersFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      flow_ = "";
      displayName_ = "";
      inputActionParameters_ = null;
      if (inputActionParametersBuilder_ != null) {
        inputActionParametersBuilder_.dispose();
        inputActionParametersBuilder_ = null;
      }
      outputActionParameters_ = null;
      if (outputActionParametersBuilder_ != null) {
        outputActionParametersBuilder_.dispose();
        outputActionParametersBuilder_ = null;
      }
      flowState_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_FlowInvocation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation build() {
      com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation result =
          new com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.flow_ = flow_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.inputActionParameters_ =
            inputActionParametersBuilder_ == null
                ? inputActionParameters_
                : inputActionParametersBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.outputActionParameters_ =
            outputActionParametersBuilder_ == null
                ? outputActionParameters_
                : outputActionParametersBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.flowState_ = flowState_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation.getDefaultInstance())
        return this;
      if (!other.getFlow().isEmpty()) {
        flow_ = other.flow_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasInputActionParameters()) {
        mergeInputActionParameters(other.getInputActionParameters());
      }
      if (other.hasOutputActionParameters()) {
        mergeOutputActionParameters(other.getOutputActionParameters());
      }
      if (other.flowState_ != 0) {
        setFlowStateValue(other.getFlowStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                flow_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 32:
              {
                flowState_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getInputActionParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getOutputActionParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 58:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object flow_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the flow.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>
     * string flow = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The flow.
     */
    public java.lang.String getFlow() {
      java.lang.Object ref = flow_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        flow_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the flow.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>
     * string flow = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for flow.
     */
    public com.google.protobuf.ByteString getFlowBytes() {
      java.lang.Object ref = flow_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        flow_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the flow.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>
     * string flow = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The flow to set.
     * @return This builder for chaining.
     */
    public Builder setFlow(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      flow_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the flow.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>
     * string flow = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFlow() {
      flow_ = getDefaultInstance().getFlow();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the flow.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>
     * string flow = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for flow to set.
     * @return This builder for chaining.
     */
    public Builder setFlowBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      flow_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The display name of the flow.
     * </pre>
     *
     * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the flow.
     * </pre>
     *
     * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the flow.
     * </pre>
     *
     * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the flow.
     * </pre>
     *
     * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the flow.
     * </pre>
     *
     * <code>string display_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct inputActionParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        inputActionParametersBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. A list of input parameters for the flow.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct input_action_parameters = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the inputActionParameters field is set.
     */
    public boolean hasInputActionParameters() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of input parameters for the flow.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct input_action_parameters = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The inputActionParameters.
     */
    public com.google.protobuf.Struct getInputActionParameters() {
      if (inputActionParametersBuilder_ == null) {
        return inputActionParameters_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : inputActionParameters_;
      } else {
        return inputActionParametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of input parameters for the flow.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct input_action_parameters = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInputActionParameters(com.google.protobuf.Struct value) {
      if (inputActionParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputActionParameters_ = value;
      } else {
        inputActionParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of input parameters for the flow.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct input_action_parameters = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInputActionParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (inputActionParametersBuilder_ == null) {
        inputActionParameters_ = builderForValue.build();
      } else {
        inputActionParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of input parameters for the flow.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct input_action_parameters = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeInputActionParameters(com.google.protobuf.Struct value) {
      if (inputActionParametersBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && inputActionParameters_ != null
            && inputActionParameters_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getInputActionParametersBuilder().mergeFrom(value);
        } else {
          inputActionParameters_ = value;
        }
      } else {
        inputActionParametersBuilder_.mergeFrom(value);
      }
      if (inputActionParameters_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of input parameters for the flow.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct input_action_parameters = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInputActionParameters() {
      bitField0_ = (bitField0_ & ~0x00000004);
      inputActionParameters_ = null;
      if (inputActionParametersBuilder_ != null) {
        inputActionParametersBuilder_.dispose();
        inputActionParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of input parameters for the flow.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct input_action_parameters = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getInputActionParametersBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getInputActionParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of input parameters for the flow.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct input_action_parameters = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getInputActionParametersOrBuilder() {
      if (inputActionParametersBuilder_ != null) {
        return inputActionParametersBuilder_.getMessageOrBuilder();
      } else {
        return inputActionParameters_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : inputActionParameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of input parameters for the flow.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct input_action_parameters = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getInputActionParametersFieldBuilder() {
      if (inputActionParametersBuilder_ == null) {
        inputActionParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getInputActionParameters(), getParentForChildren(), isClean());
        inputActionParameters_ = null;
      }
      return inputActionParametersBuilder_;
    }

    private com.google.protobuf.Struct outputActionParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        outputActionParametersBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. A list of output parameters generated by the flow invocation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct output_action_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the outputActionParameters field is set.
     */
    public boolean hasOutputActionParameters() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of output parameters generated by the flow invocation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct output_action_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The outputActionParameters.
     */
    public com.google.protobuf.Struct getOutputActionParameters() {
      if (outputActionParametersBuilder_ == null) {
        return outputActionParameters_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : outputActionParameters_;
      } else {
        return outputActionParametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of output parameters generated by the flow invocation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct output_action_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOutputActionParameters(com.google.protobuf.Struct value) {
      if (outputActionParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputActionParameters_ = value;
      } else {
        outputActionParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of output parameters generated by the flow invocation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct output_action_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOutputActionParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (outputActionParametersBuilder_ == null) {
        outputActionParameters_ = builderForValue.build();
      } else {
        outputActionParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of output parameters generated by the flow invocation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct output_action_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeOutputActionParameters(com.google.protobuf.Struct value) {
      if (outputActionParametersBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && outputActionParameters_ != null
            && outputActionParameters_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getOutputActionParametersBuilder().mergeFrom(value);
        } else {
          outputActionParameters_ = value;
        }
      } else {
        outputActionParametersBuilder_.mergeFrom(value);
      }
      if (outputActionParameters_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of output parameters generated by the flow invocation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct output_action_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOutputActionParameters() {
      bitField0_ = (bitField0_ & ~0x00000008);
      outputActionParameters_ = null;
      if (outputActionParametersBuilder_ != null) {
        outputActionParametersBuilder_.dispose();
        outputActionParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of output parameters generated by the flow invocation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct output_action_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getOutputActionParametersBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getOutputActionParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of output parameters generated by the flow invocation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct output_action_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getOutputActionParametersOrBuilder() {
      if (outputActionParametersBuilder_ != null) {
        return outputActionParametersBuilder_.getMessageOrBuilder();
      } else {
        return outputActionParameters_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : outputActionParameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of output parameters generated by the flow invocation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct output_action_parameters = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getOutputActionParametersFieldBuilder() {
      if (outputActionParametersBuilder_ == null) {
        outputActionParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getOutputActionParameters(), getParentForChildren(), isClean());
        outputActionParameters_ = null;
      }
      return outputActionParametersBuilder_;
    }

    private int flowState_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Flow invocation's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState flow_state = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for flowState.
     */
    @java.lang.Override
    public int getFlowStateValue() {
      return flowState_;
    }
    /**
     *
     *
     * <pre>
     * Required. Flow invocation's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState flow_state = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for flowState to set.
     * @return This builder for chaining.
     */
    public Builder setFlowStateValue(int value) {
      flowState_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Flow invocation's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState flow_state = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The flowState.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.OutputState getFlowState() {
      com.google.cloud.dialogflow.cx.v3beta1.OutputState result =
          com.google.cloud.dialogflow.cx.v3beta1.OutputState.forNumber(flowState_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.OutputState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Flow invocation's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState flow_state = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The flowState to set.
     * @return This builder for chaining.
     */
    public Builder setFlowState(com.google.cloud.dialogflow.cx.v3beta1.OutputState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      flowState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Flow invocation's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState flow_state = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFlowState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      flowState_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.FlowInvocation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.FlowInvocation)
  private static final com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FlowInvocation> PARSER =
      new com.google.protobuf.AbstractParser<FlowInvocation>() {
        @java.lang.Override
        public FlowInvocation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FlowInvocation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FlowInvocation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.FlowInvocation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
