/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/intent.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * The request message for
 * [Intents.ExportIntents][google.cloud.dialogflow.cx.v3beta1.Intents.ExportIntents].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest}
 */
public final class ExportIntentsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest)
    ExportIntentsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportIntentsRequest.newBuilder() to construct.
  private ExportIntentsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportIntentsRequest() {
    parent_ = "";
    intents_ = com.google.protobuf.LazyStringArrayList.emptyList();
    dataFormat_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportIntentsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ExportIntentsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_ExportIntentsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.class,
            com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Data format of the exported intents.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat}
   */
  public enum DataFormat implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified format. Treated as `BLOB`.
     * </pre>
     *
     * <code>DATA_FORMAT_UNSPECIFIED = 0;</code>
     */
    DATA_FORMAT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Intents will be exported as raw bytes.
     * </pre>
     *
     * <code>BLOB = 1;</code>
     */
    BLOB(1),
    /**
     *
     *
     * <pre>
     * Intents will be exported in JSON format.
     * </pre>
     *
     * <code>JSON = 2;</code>
     */
    JSON(2),
    /**
     *
     *
     * <pre>
     * Intents will be exported in CSV format.
     * </pre>
     *
     * <code>CSV = 3;</code>
     */
    CSV(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified format. Treated as `BLOB`.
     * </pre>
     *
     * <code>DATA_FORMAT_UNSPECIFIED = 0;</code>
     */
    public static final int DATA_FORMAT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Intents will be exported as raw bytes.
     * </pre>
     *
     * <code>BLOB = 1;</code>
     */
    public static final int BLOB_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Intents will be exported in JSON format.
     * </pre>
     *
     * <code>JSON = 2;</code>
     */
    public static final int JSON_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Intents will be exported in CSV format.
     * </pre>
     *
     * <code>CSV = 3;</code>
     */
    public static final int CSV_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataFormat valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DataFormat forNumber(int value) {
      switch (value) {
        case 0:
          return DATA_FORMAT_UNSPECIFIED;
        case 1:
          return BLOB;
        case 2:
          return JSON;
        case 3:
          return CSV;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataFormat> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DataFormat> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DataFormat>() {
          public DataFormat findValueByNumber(int number) {
            return DataFormat.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final DataFormat[] VALUES = values();

    public static DataFormat valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DataFormat(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat)
  }

  private int destinationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INTENTS_URI(3),
    INTENTS_CONTENT_INLINE(4),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 3:
          return INTENTS_URI;
        case 4:
          return INTENTS_CONTENT_INLINE;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the parent agent to export intents.
   * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the parent agent to export intents.
   * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTENTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList intents_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. The name of the intents to export.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
   * </pre>
   *
   * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the intents.
   */
  public com.google.protobuf.ProtocolStringList getIntentsList() {
    return intents_;
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the intents to export.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
   * </pre>
   *
   * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of intents.
   */
  public int getIntentsCount() {
    return intents_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the intents to export.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
   * </pre>
   *
   * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The intents at the given index.
   */
  public java.lang.String getIntents(int index) {
    return intents_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the intents to export.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
   * </pre>
   *
   * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the intents at the given index.
   */
  public com.google.protobuf.ByteString getIntentsBytes(int index) {
    return intents_.getByteString(index);
  }

  public static final int INTENTS_URI_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Optional. The [Google Cloud
   * Storage](https://cloud.google.com/storage/docs/) URI to export the
   * intents to. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a write operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have write permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string intents_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the intentsUri field is set.
   */
  public boolean hasIntentsUri() {
    return destinationCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Optional. The [Google Cloud
   * Storage](https://cloud.google.com/storage/docs/) URI to export the
   * intents to. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a write operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have write permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string intents_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The intentsUri.
   */
  public java.lang.String getIntentsUri() {
    java.lang.Object ref = "";
    if (destinationCase_ == 3) {
      ref = destination_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (destinationCase_ == 3) {
        destination_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The [Google Cloud
   * Storage](https://cloud.google.com/storage/docs/) URI to export the
   * intents to. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a write operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have write permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string intents_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for intentsUri.
   */
  public com.google.protobuf.ByteString getIntentsUriBytes() {
    java.lang.Object ref = "";
    if (destinationCase_ == 3) {
      ref = destination_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (destinationCase_ == 3) {
        destination_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTENTS_CONTENT_INLINE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. The option to return the serialized intents inline.
   * </pre>
   *
   * <code>bool intents_content_inline = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the intentsContentInline field is set.
   */
  @java.lang.Override
  public boolean hasIntentsContentInline() {
    return destinationCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. The option to return the serialized intents inline.
   * </pre>
   *
   * <code>bool intents_content_inline = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The intentsContentInline.
   */
  @java.lang.Override
  public boolean getIntentsContentInline() {
    if (destinationCase_ == 4) {
      return (java.lang.Boolean) destination_;
    }
    return false;
  }

  public static final int DATA_FORMAT_FIELD_NUMBER = 5;
  private int dataFormat_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The data format of the exported intents. If not specified, `BLOB`
   * is assumed.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat data_format = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for dataFormat.
   */
  @java.lang.Override
  public int getDataFormatValue() {
    return dataFormat_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The data format of the exported intents. If not specified, `BLOB`
   * is assumed.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat data_format = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The dataFormat.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat getDataFormat() {
    com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat result =
        com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat.forNumber(
            dataFormat_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    for (int i = 0; i < intents_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, intents_.getRaw(i));
    }
    if (destinationCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, destination_);
    }
    if (destinationCase_ == 4) {
      output.writeBool(4, (boolean) ((java.lang.Boolean) destination_));
    }
    if (dataFormat_
        != com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat
            .DATA_FORMAT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, dataFormat_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < intents_.size(); i++) {
        dataSize += computeStringSizeNoTag(intents_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIntentsList().size();
    }
    if (destinationCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, destination_);
    }
    if (destinationCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              4, (boolean) ((java.lang.Boolean) destination_));
    }
    if (dataFormat_
        != com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat
            .DATA_FORMAT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, dataFormat_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest other =
        (com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getIntentsList().equals(other.getIntentsList())) return false;
    if (dataFormat_ != other.dataFormat_) return false;
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 3:
        if (!getIntentsUri().equals(other.getIntentsUri())) return false;
        break;
      case 4:
        if (getIntentsContentInline() != other.getIntentsContentInline()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (getIntentsCount() > 0) {
      hash = (37 * hash) + INTENTS_FIELD_NUMBER;
      hash = (53 * hash) + getIntentsList().hashCode();
    }
    hash = (37 * hash) + DATA_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + dataFormat_;
    switch (destinationCase_) {
      case 3:
        hash = (37 * hash) + INTENTS_URI_FIELD_NUMBER;
        hash = (53 * hash) + getIntentsUri().hashCode();
        break;
      case 4:
        hash = (37 * hash) + INTENTS_CONTENT_INLINE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIntentsContentInline());
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for
   * [Intents.ExportIntents][google.cloud.dialogflow.cx.v3beta1.Intents.ExportIntents].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest)
      com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ExportIntentsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ExportIntentsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.class,
              com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      intents_ = com.google.protobuf.LazyStringArrayList.emptyList();
      dataFormat_ = 0;
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.IntentProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_ExportIntentsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest build() {
      com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest result =
          new com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        intents_.makeImmutable();
        result.intents_ = intents_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.dataFormat_ = dataFormat_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest result) {
      result.destinationCase_ = destinationCase_;
      result.destination_ = this.destination_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.intents_.isEmpty()) {
        if (intents_.isEmpty()) {
          intents_ = other.intents_;
          bitField0_ |= 0x00000002;
        } else {
          ensureIntentsIsMutable();
          intents_.addAll(other.intents_);
        }
        onChanged();
      }
      if (other.dataFormat_ != 0) {
        setDataFormatValue(other.getDataFormatValue());
      }
      switch (other.getDestinationCase()) {
        case INTENTS_URI:
          {
            destinationCase_ = 3;
            destination_ = other.destination_;
            onChanged();
            break;
          }
        case INTENTS_CONTENT_INLINE:
          {
            setIntentsContentInline(other.getIntentsContentInline());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIntentsIsMutable();
                intents_.add(s);
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                destinationCase_ = 3;
                destination_ = s;
                break;
              } // case 26
            case 32:
              {
                destination_ = input.readBool();
                destinationCase_ = 4;
                break;
              } // case 32
            case 40:
              {
                dataFormat_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the parent agent to export intents.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the parent agent to export intents.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the parent agent to export intents.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the parent agent to export intents.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the parent agent to export intents.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList intents_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIntentsIsMutable() {
      if (!intents_.isModifiable()) {
        intents_ = new com.google.protobuf.LazyStringArrayList(intents_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the intents to export.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the intents.
     */
    public com.google.protobuf.ProtocolStringList getIntentsList() {
      intents_.makeImmutable();
      return intents_;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the intents to export.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of intents.
     */
    public int getIntentsCount() {
      return intents_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the intents to export.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The intents at the given index.
     */
    public java.lang.String getIntents(int index) {
      return intents_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the intents to export.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the intents at the given index.
     */
    public com.google.protobuf.ByteString getIntentsBytes(int index) {
      return intents_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the intents to export.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The intents to set.
     * @return This builder for chaining.
     */
    public Builder setIntents(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIntentsIsMutable();
      intents_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the intents to export.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The intents to add.
     * @return This builder for chaining.
     */
    public Builder addIntents(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIntentsIsMutable();
      intents_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the intents to export.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The intents to add.
     * @return This builder for chaining.
     */
    public Builder addAllIntents(java.lang.Iterable<java.lang.String> values) {
      ensureIntentsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, intents_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the intents to export.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntents() {
      intents_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the intents to export.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>repeated string intents = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the intents to add.
     * @return This builder for chaining.
     */
    public Builder addIntentsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIntentsIsMutable();
      intents_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the
     * intents to. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string intents_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the intentsUri field is set.
     */
    @java.lang.Override
    public boolean hasIntentsUri() {
      return destinationCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the
     * intents to. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string intents_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The intentsUri.
     */
    @java.lang.Override
    public java.lang.String getIntentsUri() {
      java.lang.Object ref = "";
      if (destinationCase_ == 3) {
        ref = destination_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (destinationCase_ == 3) {
          destination_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the
     * intents to. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string intents_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for intentsUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIntentsUriBytes() {
      java.lang.Object ref = "";
      if (destinationCase_ == 3) {
        ref = destination_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (destinationCase_ == 3) {
          destination_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the
     * intents to. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string intents_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The intentsUri to set.
     * @return This builder for chaining.
     */
    public Builder setIntentsUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationCase_ = 3;
      destination_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the
     * intents to. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string intents_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntentsUri() {
      if (destinationCase_ == 3) {
        destinationCase_ = 0;
        destination_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the
     * intents to. The format of this URI must be
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     *
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string intents_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for intentsUri to set.
     * @return This builder for chaining.
     */
    public Builder setIntentsUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationCase_ = 3;
      destination_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The option to return the serialized intents inline.
     * </pre>
     *
     * <code>bool intents_content_inline = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the intentsContentInline field is set.
     */
    public boolean hasIntentsContentInline() {
      return destinationCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. The option to return the serialized intents inline.
     * </pre>
     *
     * <code>bool intents_content_inline = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The intentsContentInline.
     */
    public boolean getIntentsContentInline() {
      if (destinationCase_ == 4) {
        return (java.lang.Boolean) destination_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * Optional. The option to return the serialized intents inline.
     * </pre>
     *
     * <code>bool intents_content_inline = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The intentsContentInline to set.
     * @return This builder for chaining.
     */
    public Builder setIntentsContentInline(boolean value) {

      destinationCase_ = 4;
      destination_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The option to return the serialized intents inline.
     * </pre>
     *
     * <code>bool intents_content_inline = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntentsContentInline() {
      if (destinationCase_ == 4) {
        destinationCase_ = 0;
        destination_ = null;
        onChanged();
      }
      return this;
    }

    private int dataFormat_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The data format of the exported intents. If not specified, `BLOB`
     * is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat data_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for dataFormat.
     */
    @java.lang.Override
    public int getDataFormatValue() {
      return dataFormat_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The data format of the exported intents. If not specified, `BLOB`
     * is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat data_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for dataFormat to set.
     * @return This builder for chaining.
     */
    public Builder setDataFormatValue(int value) {
      dataFormat_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The data format of the exported intents. If not specified, `BLOB`
     * is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat data_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dataFormat.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat getDataFormat() {
      com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat result =
          com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat.forNumber(
              dataFormat_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The data format of the exported intents. If not specified, `BLOB`
     * is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat data_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The dataFormat to set.
     * @return This builder for chaining.
     */
    public Builder setDataFormat(
        com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      dataFormat_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The data format of the exported intents. If not specified, `BLOB`
     * is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat data_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataFormat() {
      bitField0_ = (bitField0_ & ~0x00000010);
      dataFormat_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest)
  private static final com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportIntentsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExportIntentsRequest>() {
        @java.lang.Override
        public ExportIntentsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportIntentsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportIntentsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
