/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/example.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Example represents a sample execution of the playbook in the conversation.
 *
 * An example consists of a list of ordered actions performed by end user
 * or Dialogflow agent according the playbook instructions to fulfill the task.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Example}
 */
public final class Example extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Example)
    ExampleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Example.newBuilder() to construct.
  private Example(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Example() {
    name_ = "";
    actions_ = java.util.Collections.emptyList();
    displayName_ = "";
    description_ = "";
    conversationState_ = 0;
    languageCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Example();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Example_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Example_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.Example.class,
            com.google.cloud.dialogflow.cx.v3beta1.Example.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the playbook example.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/examples/&lt;ExampleID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the playbook example.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/examples/&lt;ExampleID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PLAYBOOK_INPUT_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbookInput_;
  /**
   *
   *
   * <pre>
   * Optional. The input to the playbook in the example.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the playbookInput field is set.
   */
  @java.lang.Override
  public boolean hasPlaybookInput() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The input to the playbook in the example.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The playbookInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput getPlaybookInput() {
    return playbookInput_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.getDefaultInstance()
        : playbookInput_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The input to the playbook in the example.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInputOrBuilder getPlaybookInputOrBuilder() {
    return playbookInput_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.getDefaultInstance()
        : playbookInput_;
  }

  public static final int PLAYBOOK_OUTPUT_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbookOutput_;
  /**
   *
   *
   * <pre>
   * Optional. The output of the playbook in the example.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the playbookOutput field is set.
   */
  @java.lang.Override
  public boolean hasPlaybookOutput() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The output of the playbook in the example.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The playbookOutput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput getPlaybookOutput() {
    return playbookOutput_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.getDefaultInstance()
        : playbookOutput_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The output of the playbook in the example.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutputOrBuilder
      getPlaybookOutputOrBuilder() {
    return playbookOutput_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.getDefaultInstance()
        : playbookOutput_;
  }

  public static final int ACTIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Action> actions_;
  /**
   *
   *
   * <pre>
   * Required. The ordered list of actions performed by the end user and the
   * Dialogflow agent.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Action> getActionsList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * Required. The ordered list of actions performed by the end user and the
   * Dialogflow agent.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.ActionOrBuilder>
      getActionsOrBuilderList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * Required. The ordered list of actions performed by the end user and the
   * Dialogflow agent.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getActionsCount() {
    return actions_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The ordered list of actions performed by the end user and the
   * Dialogflow agent.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Action getActions(int index) {
    return actions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The ordered list of actions performed by the end user and the
   * Dialogflow agent.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.ActionOrBuilder getActionsOrBuilder(int index) {
    return actions_.get(index);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the example.
   * </pre>
   *
   * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the example.
   * </pre>
   *
   * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The high level concise description of the example. The max number
   * of characters is 200.
   * </pre>
   *
   * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The high level concise description of the example. The max number
   * of characters is 200.
   * </pre>
   *
   * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TOKEN_COUNT_FIELD_NUMBER = 9;
  private long tokenCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. Estimated number of tokes current example takes when sent to
   * the LLM.
   * </pre>
   *
   * <code>int64 token_count = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The tokenCount.
   */
  @java.lang.Override
  public long getTokenCount() {
    return tokenCount_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of initial example creation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of initial example creation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of initial example creation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Last time the example was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Last time the example was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Last time the example was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int CONVERSATION_STATE_FIELD_NUMBER = 12;
  private int conversationState_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Example's output state.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.OutputState conversation_state = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for conversationState.
   */
  @java.lang.Override
  public int getConversationStateValue() {
    return conversationState_;
  }
  /**
   *
   *
   * <pre>
   * Required. Example's output state.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.OutputState conversation_state = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The conversationState.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.OutputState getConversationState() {
    com.google.cloud.dialogflow.cx.v3beta1.OutputState result =
        com.google.cloud.dialogflow.cx.v3beta1.OutputState.forNumber(conversationState_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.OutputState.UNRECOGNIZED
        : result;
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The language code of the example.
   * If not specified, the agent's default language is used.
   * Note: languages must be enabled in the agent before they can be used.
   * Note: example's language code is not currently used in dialogflow agents.
   * </pre>
   *
   * <code>string language_code = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The language code of the example.
   * If not specified, the agent's default language is used.
   * Note: languages must be enabled in the agent before they can be used.
   * Note: example's language code is not currently used in dialogflow agents.
   * </pre>
   *
   * <code>string language_code = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < actions_.size(); i++) {
      output.writeMessage(2, actions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getPlaybookInput());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getPlaybookOutput());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, description_);
    }
    if (tokenCount_ != 0L) {
      output.writeInt64(9, tokenCount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(11, getUpdateTime());
    }
    if (conversationState_
        != com.google.cloud.dialogflow.cx.v3beta1.OutputState.OUTPUT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(12, conversationState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, languageCode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < actions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, actions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPlaybookInput());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPlaybookOutput());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, description_);
    }
    if (tokenCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, tokenCount_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getUpdateTime());
    }
    if (conversationState_
        != com.google.cloud.dialogflow.cx.v3beta1.OutputState.OUTPUT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, conversationState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, languageCode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Example)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.Example other =
        (com.google.cloud.dialogflow.cx.v3beta1.Example) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasPlaybookInput() != other.hasPlaybookInput()) return false;
    if (hasPlaybookInput()) {
      if (!getPlaybookInput().equals(other.getPlaybookInput())) return false;
    }
    if (hasPlaybookOutput() != other.hasPlaybookOutput()) return false;
    if (hasPlaybookOutput()) {
      if (!getPlaybookOutput().equals(other.getPlaybookOutput())) return false;
    }
    if (!getActionsList().equals(other.getActionsList())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getTokenCount() != other.getTokenCount()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (conversationState_ != other.conversationState_) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasPlaybookInput()) {
      hash = (37 * hash) + PLAYBOOK_INPUT_FIELD_NUMBER;
      hash = (53 * hash) + getPlaybookInput().hashCode();
    }
    if (hasPlaybookOutput()) {
      hash = (37 * hash) + PLAYBOOK_OUTPUT_FIELD_NUMBER;
      hash = (53 * hash) + getPlaybookOutput().hashCode();
    }
    if (getActionsCount() > 0) {
      hash = (37 * hash) + ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getActionsList().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + TOKEN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTokenCount());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + CONVERSATION_STATE_FIELD_NUMBER;
    hash = (53 * hash) + conversationState_;
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.Example prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Example represents a sample execution of the playbook in the conversation.
   *
   * An example consists of a list of ordered actions performed by end user
   * or Dialogflow agent according the playbook instructions to fulfill the task.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Example}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Example)
      com.google.cloud.dialogflow.cx.v3beta1.ExampleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Example_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Example_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Example.class,
              com.google.cloud.dialogflow.cx.v3beta1.Example.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.Example.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPlaybookInputFieldBuilder();
        getPlaybookOutputFieldBuilder();
        getActionsFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      playbookInput_ = null;
      if (playbookInputBuilder_ != null) {
        playbookInputBuilder_.dispose();
        playbookInputBuilder_ = null;
      }
      playbookOutput_ = null;
      if (playbookOutputBuilder_ != null) {
        playbookOutputBuilder_.dispose();
        playbookOutputBuilder_ = null;
      }
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
      } else {
        actions_ = null;
        actionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      displayName_ = "";
      description_ = "";
      tokenCount_ = 0L;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      conversationState_ = 0;
      languageCode_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ExampleProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Example_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Example getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.Example.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Example build() {
      com.google.cloud.dialogflow.cx.v3beta1.Example result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Example buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.Example result =
          new com.google.cloud.dialogflow.cx.v3beta1.Example(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dialogflow.cx.v3beta1.Example result) {
      if (actionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          actions_ = java.util.Collections.unmodifiableList(actions_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.actions_ = actions_;
      } else {
        result.actions_ = actionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Example result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.playbookInput_ =
            playbookInputBuilder_ == null ? playbookInput_ : playbookInputBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.playbookOutput_ =
            playbookOutputBuilder_ == null ? playbookOutput_ : playbookOutputBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.tokenCount_ = tokenCount_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.conversationState_ = conversationState_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.languageCode_ = languageCode_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Example) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Example) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Example other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.Example.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPlaybookInput()) {
        mergePlaybookInput(other.getPlaybookInput());
      }
      if (other.hasPlaybookOutput()) {
        mergePlaybookOutput(other.getPlaybookOutput());
      }
      if (actionsBuilder_ == null) {
        if (!other.actions_.isEmpty()) {
          if (actions_.isEmpty()) {
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureActionsIsMutable();
            actions_.addAll(other.actions_);
          }
          onChanged();
        }
      } else {
        if (!other.actions_.isEmpty()) {
          if (actionsBuilder_.isEmpty()) {
            actionsBuilder_.dispose();
            actionsBuilder_ = null;
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000008);
            actionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getActionsFieldBuilder()
                    : null;
          } else {
            actionsBuilder_.addAllMessages(other.actions_);
          }
        }
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getTokenCount() != 0L) {
        setTokenCount(other.getTokenCount());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.conversationState_ != 0) {
        setConversationStateValue(other.getConversationStateValue());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.dialogflow.cx.v3beta1.Action m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.Action.parser(), extensionRegistry);
                if (actionsBuilder_ == null) {
                  ensureActionsIsMutable();
                  actions_.add(m);
                } else {
                  actionsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getPlaybookInputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPlaybookOutputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 50:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 66:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 72:
              {
                tokenCount_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            case 96:
              {
                conversationState_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 96
            case 106:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the playbook example.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/examples/&lt;ExampleID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the playbook example.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/examples/&lt;ExampleID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the playbook example.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/examples/&lt;ExampleID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the playbook example.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/examples/&lt;ExampleID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the playbook example.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/playbooks/&lt;PlaybookID&gt;/examples/&lt;ExampleID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbookInput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInputOrBuilder>
        playbookInputBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The input to the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the playbookInput field is set.
     */
    public boolean hasPlaybookInput() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The input to the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The playbookInput.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput getPlaybookInput() {
      if (playbookInputBuilder_ == null) {
        return playbookInput_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.getDefaultInstance()
            : playbookInput_;
      } else {
        return playbookInputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The input to the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaybookInput(com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput value) {
      if (playbookInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        playbookInput_ = value;
      } else {
        playbookInputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The input to the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaybookInput(
        com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.Builder builderForValue) {
      if (playbookInputBuilder_ == null) {
        playbookInput_ = builderForValue.build();
      } else {
        playbookInputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The input to the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePlaybookInput(com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput value) {
      if (playbookInputBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && playbookInput_ != null
            && playbookInput_
                != com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.getDefaultInstance()) {
          getPlaybookInputBuilder().mergeFrom(value);
        } else {
          playbookInput_ = value;
        }
      } else {
        playbookInputBuilder_.mergeFrom(value);
      }
      if (playbookInput_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The input to the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPlaybookInput() {
      bitField0_ = (bitField0_ & ~0x00000002);
      playbookInput_ = null;
      if (playbookInputBuilder_ != null) {
        playbookInputBuilder_.dispose();
        playbookInputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The input to the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.Builder getPlaybookInputBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPlaybookInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The input to the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookInputOrBuilder
        getPlaybookInputOrBuilder() {
      if (playbookInputBuilder_ != null) {
        return playbookInputBuilder_.getMessageOrBuilder();
      } else {
        return playbookInput_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.getDefaultInstance()
            : playbookInput_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The input to the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookInput playbook_input = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookInputOrBuilder>
        getPlaybookInputFieldBuilder() {
      if (playbookInputBuilder_ == null) {
        playbookInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput,
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookInput.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookInputOrBuilder>(
                getPlaybookInput(), getParentForChildren(), isClean());
        playbookInput_ = null;
      }
      return playbookInputBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbookOutput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutputOrBuilder>
        playbookOutputBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The output of the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the playbookOutput field is set.
     */
    public boolean hasPlaybookOutput() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The output of the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The playbookOutput.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput getPlaybookOutput() {
      if (playbookOutputBuilder_ == null) {
        return playbookOutput_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.getDefaultInstance()
            : playbookOutput_;
      } else {
        return playbookOutputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The output of the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaybookOutput(com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput value) {
      if (playbookOutputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        playbookOutput_ = value;
      } else {
        playbookOutputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The output of the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlaybookOutput(
        com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.Builder builderForValue) {
      if (playbookOutputBuilder_ == null) {
        playbookOutput_ = builderForValue.build();
      } else {
        playbookOutputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The output of the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePlaybookOutput(
        com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput value) {
      if (playbookOutputBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && playbookOutput_ != null
            && playbookOutput_
                != com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.getDefaultInstance()) {
          getPlaybookOutputBuilder().mergeFrom(value);
        } else {
          playbookOutput_ = value;
        }
      } else {
        playbookOutputBuilder_.mergeFrom(value);
      }
      if (playbookOutput_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The output of the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPlaybookOutput() {
      bitField0_ = (bitField0_ & ~0x00000004);
      playbookOutput_ = null;
      if (playbookOutputBuilder_ != null) {
        playbookOutputBuilder_.dispose();
        playbookOutputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The output of the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.Builder
        getPlaybookOutputBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPlaybookOutputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The output of the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutputOrBuilder
        getPlaybookOutputOrBuilder() {
      if (playbookOutputBuilder_ != null) {
        return playbookOutputBuilder_.getMessageOrBuilder();
      } else {
        return playbookOutput_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.getDefaultInstance()
            : playbookOutput_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The output of the playbook in the example.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.PlaybookOutput playbook_output = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutputOrBuilder>
        getPlaybookOutputFieldBuilder() {
      if (playbookOutputBuilder_ == null) {
        playbookOutputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput,
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.PlaybookOutputOrBuilder>(
                getPlaybookOutput(), getParentForChildren(), isClean());
        playbookOutput_ = null;
      }
      return playbookOutputBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Action> actions_ =
        java.util.Collections.emptyList();

    private void ensureActionsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        actions_ = new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Action>(actions_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Action,
            com.google.cloud.dialogflow.cx.v3beta1.Action.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ActionOrBuilder>
        actionsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Action> getActionsList() {
      if (actionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(actions_);
      } else {
        return actionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getActionsCount() {
      if (actionsBuilder_ == null) {
        return actions_.size();
      } else {
        return actionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Action getActions(int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setActions(int index, com.google.cloud.dialogflow.cx.v3beta1.Action value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.set(index, value);
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setActions(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Action.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.set(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addActions(com.google.cloud.dialogflow.cx.v3beta1.Action value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addActions(int index, com.google.cloud.dialogflow.cx.v3beta1.Action value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(index, value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addActions(
        com.google.cloud.dialogflow.cx.v3beta1.Action.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addActions(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Action.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllActions(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Action> values) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, actions_);
        onChanged();
      } else {
        actionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearActions() {
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        actionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeActions(int index) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.remove(index);
        onChanged();
      } else {
        actionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Action.Builder getActionsBuilder(int index) {
      return getActionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.ActionOrBuilder getActionsOrBuilder(int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.ActionOrBuilder>
        getActionsOrBuilderList() {
      if (actionsBuilder_ != null) {
        return actionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(actions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Action.Builder addActionsBuilder() {
      return getActionsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.Action.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Action.Builder addActionsBuilder(int index) {
      return getActionsFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.cx.v3beta1.Action.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The ordered list of actions performed by the end user and the
     * Dialogflow agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Action actions = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Action.Builder>
        getActionsBuilderList() {
      return getActionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Action,
            com.google.cloud.dialogflow.cx.v3beta1.Action.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.ActionOrBuilder>
        getActionsFieldBuilder() {
      if (actionsBuilder_ == null) {
        actionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Action,
                com.google.cloud.dialogflow.cx.v3beta1.Action.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.ActionOrBuilder>(
                actions_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        actions_ = null;
      }
      return actionsBuilder_;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the example.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the example.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the example.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the example.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the example.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The high level concise description of the example. The max number
     * of characters is 200.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The high level concise description of the example. The max number
     * of characters is 200.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The high level concise description of the example. The max number
     * of characters is 200.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The high level concise description of the example. The max number
     * of characters is 200.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The high level concise description of the example. The max number
     * of characters is 200.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private long tokenCount_;
    /**
     *
     *
     * <pre>
     * Output only. Estimated number of tokes current example takes when sent to
     * the LLM.
     * </pre>
     *
     * <code>int64 token_count = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The tokenCount.
     */
    @java.lang.Override
    public long getTokenCount() {
      return tokenCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Estimated number of tokes current example takes when sent to
     * the LLM.
     * </pre>
     *
     * <code>int64 token_count = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The tokenCount to set.
     * @return This builder for chaining.
     */
    public Builder setTokenCount(long value) {

      tokenCount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Estimated number of tokes current example takes when sent to
     * the LLM.
     * </pre>
     *
     * <code>int64 token_count = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTokenCount() {
      bitField0_ = (bitField0_ & ~0x00000040);
      tokenCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial example creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial example creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial example creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial example creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial example creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial example creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial example creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial example creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of initial example creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Last time the example was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the example was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the example was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the example was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the example was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the example was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the example was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the example was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Last time the example was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int conversationState_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Example's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState conversation_state = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for conversationState.
     */
    @java.lang.Override
    public int getConversationStateValue() {
      return conversationState_;
    }
    /**
     *
     *
     * <pre>
     * Required. Example's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState conversation_state = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for conversationState to set.
     * @return This builder for chaining.
     */
    public Builder setConversationStateValue(int value) {
      conversationState_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Example's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState conversation_state = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The conversationState.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.OutputState getConversationState() {
      com.google.cloud.dialogflow.cx.v3beta1.OutputState result =
          com.google.cloud.dialogflow.cx.v3beta1.OutputState.forNumber(conversationState_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.OutputState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Example's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState conversation_state = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The conversationState to set.
     * @return This builder for chaining.
     */
    public Builder setConversationState(com.google.cloud.dialogflow.cx.v3beta1.OutputState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      conversationState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Example's output state.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.OutputState conversation_state = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversationState() {
      bitField0_ = (bitField0_ & ~0x00000200);
      conversationState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The language code of the example.
     * If not specified, the agent's default language is used.
     * Note: languages must be enabled in the agent before they can be used.
     * Note: example's language code is not currently used in dialogflow agents.
     * </pre>
     *
     * <code>string language_code = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The language code of the example.
     * If not specified, the agent's default language is used.
     * Note: languages must be enabled in the agent before they can be used.
     * Note: example's language code is not currently used in dialogflow agents.
     * </pre>
     *
     * <code>string language_code = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The language code of the example.
     * If not specified, the agent's default language is used.
     * Note: languages must be enabled in the agent before they can be used.
     * Note: example's language code is not currently used in dialogflow agents.
     * </pre>
     *
     * <code>string language_code = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The language code of the example.
     * If not specified, the agent's default language is used.
     * Note: languages must be enabled in the agent before they can be used.
     * Note: example's language code is not currently used in dialogflow agents.
     * </pre>
     *
     * <code>string language_code = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The language code of the example.
     * If not specified, the agent's default language is used.
     * Note: languages must be enabled in the agent before they can be used.
     * Note: example's language code is not currently used in dialogflow agents.
     * </pre>
     *
     * <code>string language_code = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Example)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Example)
  private static final com.google.cloud.dialogflow.cx.v3beta1.Example DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Example();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Example getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Example> PARSER =
      new com.google.protobuf.AbstractParser<Example>() {
        @java.lang.Override
        public Example parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Example> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Example> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Example getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
