/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/conversation_history.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Represents a conversation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Conversation}
 */
public final class Conversation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Conversation)
    ConversationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Conversation.newBuilder() to construct.
  private Conversation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Conversation() {
    name_ = "";
    type_ = 0;
    languageCode_ = "";
    intents_ = java.util.Collections.emptyList();
    flows_ = java.util.Collections.emptyList();
    pages_ = java.util.Collections.emptyList();
    interactions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Conversation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 12:
        return internalGetFlowVersions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.class,
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents the type of a conversation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3beta1.Conversation.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. This value should never be used.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Audio conversation. A conversation is classified as an audio conversation
     * if any request has STT input audio or any response has TTS output audio.
     * </pre>
     *
     * <code>AUDIO = 1;</code>
     */
    AUDIO(1),
    /**
     *
     *
     * <pre>
     * Text conversation. A conversation is classified as a text conversation
     * if any request has text input and no request has STT input audio and no
     * response has TTS output audio.
     * </pre>
     *
     * <code>TEXT = 2;</code>
     */
    TEXT(2),
    /**
     *
     *
     * <pre>
     * Default conversation type for a conversation. A conversation is
     * classified as undetermined if none of the requests contain text or audio
     * input (eg. event or intent input).
     * </pre>
     *
     * <code>UNDETERMINED = 3;</code>
     */
    UNDETERMINED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. This value should never be used.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Audio conversation. A conversation is classified as an audio conversation
     * if any request has STT input audio or any response has TTS output audio.
     * </pre>
     *
     * <code>AUDIO = 1;</code>
     */
    public static final int AUDIO_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Text conversation. A conversation is classified as a text conversation
     * if any request has text input and no request has STT input audio and no
     * response has TTS output audio.
     * </pre>
     *
     * <code>TEXT = 2;</code>
     */
    public static final int TEXT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Default conversation type for a conversation. A conversation is
     * classified as undetermined if none of the requests contain text or audio
     * input (eg. event or intent input).
     * </pre>
     *
     * <code>UNDETERMINED = 3;</code>
     */
    public static final int UNDETERMINED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return AUDIO;
        case 2:
          return TEXT;
        case 3:
          return UNDETERMINED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.Conversation.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Type)
  }

  public interface MetricsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The number of interactions in the conversation.
     * </pre>
     *
     * <code>int32 interaction_count = 1;</code>
     *
     * @return The interactionCount.
     */
    int getInteractionCount();

    /**
     *
     *
     * <pre>
     * Duration of all the input's audio in the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
     *
     * @return Whether the inputAudioDuration field is set.
     */
    boolean hasInputAudioDuration();
    /**
     *
     *
     * <pre>
     * Duration of all the input's audio in the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
     *
     * @return The inputAudioDuration.
     */
    com.google.protobuf.Duration getInputAudioDuration();
    /**
     *
     *
     * <pre>
     * Duration of all the input's audio in the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
     */
    com.google.protobuf.DurationOrBuilder getInputAudioDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Duration of all the output's audio in the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
     *
     * @return Whether the outputAudioDuration field is set.
     */
    boolean hasOutputAudioDuration();
    /**
     *
     *
     * <pre>
     * Duration of all the output's audio in the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
     *
     * @return The outputAudioDuration.
     */
    com.google.protobuf.Duration getOutputAudioDuration();
    /**
     *
     *
     * <pre>
     * Duration of all the output's audio in the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
     */
    com.google.protobuf.DurationOrBuilder getOutputAudioDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Maximum latency of the
     * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
     * conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
     *
     * @return Whether the maxWebhookLatency field is set.
     */
    boolean hasMaxWebhookLatency();
    /**
     *
     *
     * <pre>
     * Maximum latency of the
     * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
     * conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
     *
     * @return The maxWebhookLatency.
     */
    com.google.protobuf.Duration getMaxWebhookLatency();
    /**
     *
     *
     * <pre>
     * Maximum latency of the
     * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
     * conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
     */
    com.google.protobuf.DurationOrBuilder getMaxWebhookLatencyOrBuilder();

    /**
     *
     *
     * <pre>
     * A signal that indicates the interaction with the Dialogflow agent has
     * ended.
     * If any response has the
     * [ResponseMessage.end_interaction][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.end_interaction]
     * signal, this is set to true.
     * </pre>
     *
     * <code>bool has_end_interaction = 5;</code>
     *
     * @return The hasEndInteraction.
     */
    boolean getHasEndInteraction();

    /**
     *
     *
     * <pre>
     * Hands off conversation to a human agent.
     * If any response has the
     * [ResponseMessage.live_agent_handoff][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.live_agent_handoff]signal,
     * this is set to true.
     * </pre>
     *
     * <code>bool has_live_agent_handoff = 6;</code>
     *
     * @return The hasLiveAgentHandoff.
     */
    boolean getHasLiveAgentHandoff();

    /**
     *
     *
     * <pre>
     * The average confidence all of the
     * [Match][google.cloud.dialogflow.cx.v3beta1.Match] in the conversation.
     * Values range from 0.0 (completely uncertain) to 1.0 (completely certain).
     * </pre>
     *
     * <code>float average_match_confidence = 7;</code>
     *
     * @return The averageMatchConfidence.
     */
    float getAverageMatchConfidence();

    /**
     *
     *
     * <pre>
     * Query input counts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
     * </code>
     *
     * @return Whether the queryInputCount field is set.
     */
    boolean hasQueryInputCount();
    /**
     *
     *
     * <pre>
     * Query input counts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
     * </code>
     *
     * @return The queryInputCount.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
        getQueryInputCount();
    /**
     *
     *
     * <pre>
     * Query input counts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCountOrBuilder
        getQueryInputCountOrBuilder();

    /**
     *
     *
     * <pre>
     * Match type counts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
     * </code>
     *
     * @return Whether the matchTypeCount field is set.
     */
    boolean hasMatchTypeCount();
    /**
     *
     *
     * <pre>
     * Match type counts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
     * </code>
     *
     * @return The matchTypeCount.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount getMatchTypeCount();
    /**
     *
     *
     * <pre>
     * Match type counts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCountOrBuilder
        getMatchTypeCountOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Represents metrics for the conversation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics}
   */
  public static final class Metrics extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics)
      MetricsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Metrics.newBuilder() to construct.
    private Metrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Metrics() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Metrics();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.class,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.Builder.class);
    }

    public interface QueryInputCountOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The number of [TextInput][google.cloud.dialogflow.cx.v3beta1.TextInput]
       * in the conversation.
       * </pre>
       *
       * <code>int32 text_count = 1;</code>
       *
       * @return The textCount.
       */
      int getTextCount();

      /**
       *
       *
       * <pre>
       * The number of
       * [IntentInput][google.cloud.dialogflow.cx.v3beta1.IntentInput] in the
       * conversation.
       * </pre>
       *
       * <code>int32 intent_count = 2;</code>
       *
       * @return The intentCount.
       */
      int getIntentCount();

      /**
       *
       *
       * <pre>
       * The number of
       * [AudioInput][google.cloud.dialogflow.cx.v3beta1.AudioInput] in the
       * conversation.
       * </pre>
       *
       * <code>int32 audio_count = 3;</code>
       *
       * @return The audioCount.
       */
      int getAudioCount();

      /**
       *
       *
       * <pre>
       * The number of
       * [EventInput][google.cloud.dialogflow.cx.v3beta1.EventInput] in the
       * conversation.
       * </pre>
       *
       * <code>int32 event_count = 4;</code>
       *
       * @return The eventCount.
       */
      int getEventCount();

      /**
       *
       *
       * <pre>
       * The number of [DtmfInput][google.cloud.dialogflow.cx.v3beta1.DtmfInput]
       * in the conversation.
       * </pre>
       *
       * <code>int32 dtmf_count = 5;</code>
       *
       * @return The dtmfCount.
       */
      int getDtmfCount();
    }
    /**
     *
     *
     * <pre>
     * Count by types of
     * [QueryInput][google.cloud.dialogflow.cx.v3beta1.QueryInput] of the
     * requests in the conversation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount}
     */
    public static final class QueryInputCount extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount)
        QueryInputCountOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use QueryInputCount.newBuilder() to construct.
      private QueryInputCount(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private QueryInputCount() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new QueryInputCount();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_QueryInputCount_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_QueryInputCount_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount.class,
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount.Builder
                    .class);
      }

      public static final int TEXT_COUNT_FIELD_NUMBER = 1;
      private int textCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of [TextInput][google.cloud.dialogflow.cx.v3beta1.TextInput]
       * in the conversation.
       * </pre>
       *
       * <code>int32 text_count = 1;</code>
       *
       * @return The textCount.
       */
      @java.lang.Override
      public int getTextCount() {
        return textCount_;
      }

      public static final int INTENT_COUNT_FIELD_NUMBER = 2;
      private int intentCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of
       * [IntentInput][google.cloud.dialogflow.cx.v3beta1.IntentInput] in the
       * conversation.
       * </pre>
       *
       * <code>int32 intent_count = 2;</code>
       *
       * @return The intentCount.
       */
      @java.lang.Override
      public int getIntentCount() {
        return intentCount_;
      }

      public static final int AUDIO_COUNT_FIELD_NUMBER = 3;
      private int audioCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of
       * [AudioInput][google.cloud.dialogflow.cx.v3beta1.AudioInput] in the
       * conversation.
       * </pre>
       *
       * <code>int32 audio_count = 3;</code>
       *
       * @return The audioCount.
       */
      @java.lang.Override
      public int getAudioCount() {
        return audioCount_;
      }

      public static final int EVENT_COUNT_FIELD_NUMBER = 4;
      private int eventCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of
       * [EventInput][google.cloud.dialogflow.cx.v3beta1.EventInput] in the
       * conversation.
       * </pre>
       *
       * <code>int32 event_count = 4;</code>
       *
       * @return The eventCount.
       */
      @java.lang.Override
      public int getEventCount() {
        return eventCount_;
      }

      public static final int DTMF_COUNT_FIELD_NUMBER = 5;
      private int dtmfCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of [DtmfInput][google.cloud.dialogflow.cx.v3beta1.DtmfInput]
       * in the conversation.
       * </pre>
       *
       * <code>int32 dtmf_count = 5;</code>
       *
       * @return The dtmfCount.
       */
      @java.lang.Override
      public int getDtmfCount() {
        return dtmfCount_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (textCount_ != 0) {
          output.writeInt32(1, textCount_);
        }
        if (intentCount_ != 0) {
          output.writeInt32(2, intentCount_);
        }
        if (audioCount_ != 0) {
          output.writeInt32(3, audioCount_);
        }
        if (eventCount_ != 0) {
          output.writeInt32(4, eventCount_);
        }
        if (dtmfCount_ != 0) {
          output.writeInt32(5, dtmfCount_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (textCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, textCount_);
        }
        if (intentCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, intentCount_);
        }
        if (audioCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, audioCount_);
        }
        if (eventCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, eventCount_);
        }
        if (dtmfCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, dtmfCount_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount other =
            (com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount) obj;

        if (getTextCount() != other.getTextCount()) return false;
        if (getIntentCount() != other.getIntentCount()) return false;
        if (getAudioCount() != other.getAudioCount()) return false;
        if (getEventCount() != other.getEventCount()) return false;
        if (getDtmfCount() != other.getDtmfCount()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TEXT_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getTextCount();
        hash = (37 * hash) + INTENT_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getIntentCount();
        hash = (37 * hash) + AUDIO_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getAudioCount();
        hash = (37 * hash) + EVENT_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getEventCount();
        hash = (37 * hash) + DTMF_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getDtmfCount();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Count by types of
       * [QueryInput][google.cloud.dialogflow.cx.v3beta1.QueryInput] of the
       * requests in the conversation.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount)
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCountOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_QueryInputCount_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_QueryInputCount_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount.class,
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          textCount_ = 0;
          intentCount_ = 0;
          audioCount_ = 0;
          eventCount_ = 0;
          dtmfCount_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_QueryInputCount_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount build() {
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount result =
              new com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.textCount_ = textCount_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.intentCount_ = intentCount_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.audioCount_ = audioCount_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.eventCount_ = eventCount_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.dtmfCount_ = dtmfCount_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
                  .getDefaultInstance()) return this;
          if (other.getTextCount() != 0) {
            setTextCount(other.getTextCount());
          }
          if (other.getIntentCount() != 0) {
            setIntentCount(other.getIntentCount());
          }
          if (other.getAudioCount() != 0) {
            setAudioCount(other.getAudioCount());
          }
          if (other.getEventCount() != 0) {
            setEventCount(other.getEventCount());
          }
          if (other.getDtmfCount() != 0) {
            setDtmfCount(other.getDtmfCount());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    textCount_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    intentCount_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    audioCount_ = input.readInt32();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 32:
                  {
                    eventCount_ = input.readInt32();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                case 40:
                  {
                    dtmfCount_ = input.readInt32();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 40
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int textCount_;
        /**
         *
         *
         * <pre>
         * The number of [TextInput][google.cloud.dialogflow.cx.v3beta1.TextInput]
         * in the conversation.
         * </pre>
         *
         * <code>int32 text_count = 1;</code>
         *
         * @return The textCount.
         */
        @java.lang.Override
        public int getTextCount() {
          return textCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of [TextInput][google.cloud.dialogflow.cx.v3beta1.TextInput]
         * in the conversation.
         * </pre>
         *
         * <code>int32 text_count = 1;</code>
         *
         * @param value The textCount to set.
         * @return This builder for chaining.
         */
        public Builder setTextCount(int value) {

          textCount_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of [TextInput][google.cloud.dialogflow.cx.v3beta1.TextInput]
         * in the conversation.
         * </pre>
         *
         * <code>int32 text_count = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTextCount() {
          bitField0_ = (bitField0_ & ~0x00000001);
          textCount_ = 0;
          onChanged();
          return this;
        }

        private int intentCount_;
        /**
         *
         *
         * <pre>
         * The number of
         * [IntentInput][google.cloud.dialogflow.cx.v3beta1.IntentInput] in the
         * conversation.
         * </pre>
         *
         * <code>int32 intent_count = 2;</code>
         *
         * @return The intentCount.
         */
        @java.lang.Override
        public int getIntentCount() {
          return intentCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of
         * [IntentInput][google.cloud.dialogflow.cx.v3beta1.IntentInput] in the
         * conversation.
         * </pre>
         *
         * <code>int32 intent_count = 2;</code>
         *
         * @param value The intentCount to set.
         * @return This builder for chaining.
         */
        public Builder setIntentCount(int value) {

          intentCount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of
         * [IntentInput][google.cloud.dialogflow.cx.v3beta1.IntentInput] in the
         * conversation.
         * </pre>
         *
         * <code>int32 intent_count = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIntentCount() {
          bitField0_ = (bitField0_ & ~0x00000002);
          intentCount_ = 0;
          onChanged();
          return this;
        }

        private int audioCount_;
        /**
         *
         *
         * <pre>
         * The number of
         * [AudioInput][google.cloud.dialogflow.cx.v3beta1.AudioInput] in the
         * conversation.
         * </pre>
         *
         * <code>int32 audio_count = 3;</code>
         *
         * @return The audioCount.
         */
        @java.lang.Override
        public int getAudioCount() {
          return audioCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of
         * [AudioInput][google.cloud.dialogflow.cx.v3beta1.AudioInput] in the
         * conversation.
         * </pre>
         *
         * <code>int32 audio_count = 3;</code>
         *
         * @param value The audioCount to set.
         * @return This builder for chaining.
         */
        public Builder setAudioCount(int value) {

          audioCount_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of
         * [AudioInput][google.cloud.dialogflow.cx.v3beta1.AudioInput] in the
         * conversation.
         * </pre>
         *
         * <code>int32 audio_count = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAudioCount() {
          bitField0_ = (bitField0_ & ~0x00000004);
          audioCount_ = 0;
          onChanged();
          return this;
        }

        private int eventCount_;
        /**
         *
         *
         * <pre>
         * The number of
         * [EventInput][google.cloud.dialogflow.cx.v3beta1.EventInput] in the
         * conversation.
         * </pre>
         *
         * <code>int32 event_count = 4;</code>
         *
         * @return The eventCount.
         */
        @java.lang.Override
        public int getEventCount() {
          return eventCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of
         * [EventInput][google.cloud.dialogflow.cx.v3beta1.EventInput] in the
         * conversation.
         * </pre>
         *
         * <code>int32 event_count = 4;</code>
         *
         * @param value The eventCount to set.
         * @return This builder for chaining.
         */
        public Builder setEventCount(int value) {

          eventCount_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of
         * [EventInput][google.cloud.dialogflow.cx.v3beta1.EventInput] in the
         * conversation.
         * </pre>
         *
         * <code>int32 event_count = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEventCount() {
          bitField0_ = (bitField0_ & ~0x00000008);
          eventCount_ = 0;
          onChanged();
          return this;
        }

        private int dtmfCount_;
        /**
         *
         *
         * <pre>
         * The number of [DtmfInput][google.cloud.dialogflow.cx.v3beta1.DtmfInput]
         * in the conversation.
         * </pre>
         *
         * <code>int32 dtmf_count = 5;</code>
         *
         * @return The dtmfCount.
         */
        @java.lang.Override
        public int getDtmfCount() {
          return dtmfCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of [DtmfInput][google.cloud.dialogflow.cx.v3beta1.DtmfInput]
         * in the conversation.
         * </pre>
         *
         * <code>int32 dtmf_count = 5;</code>
         *
         * @param value The dtmfCount to set.
         * @return This builder for chaining.
         */
        public Builder setDtmfCount(int value) {

          dtmfCount_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of [DtmfInput][google.cloud.dialogflow.cx.v3beta1.DtmfInput]
         * in the conversation.
         * </pre>
         *
         * <code>int32 dtmf_count = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDtmfCount() {
          bitField0_ = (bitField0_ & ~0x00000010);
          dtmfCount_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics
              .QueryInputCount
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<QueryInputCount> PARSER =
          new com.google.protobuf.AbstractParser<QueryInputCount>() {
            @java.lang.Override
            public QueryInputCount parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<QueryInputCount> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<QueryInputCount> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MatchTypeCountOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.MATCH_TYPE_UNSPECIFIED][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.MATCH_TYPE_UNSPECIFIED].
       * </pre>
       *
       * <code>int32 unspecified_count = 1;</code>
       *
       * @return The unspecifiedCount.
       */
      int getUnspecifiedCount();

      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.INTENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.INTENT].
       * </pre>
       *
       * <code>int32 intent_count = 2;</code>
       *
       * @return The intentCount.
       */
      int getIntentCount();

      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.DIRECT_INTENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.DIRECT_INTENT].
       * </pre>
       *
       * <code>int32 direct_intent_count = 3;</code>
       *
       * @return The directIntentCount.
       */
      int getDirectIntentCount();

      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.PARAMETER_FILLING][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.PARAMETER_FILLING].
       * </pre>
       *
       * <code>int32 parameter_filling_count = 4;</code>
       *
       * @return The parameterFillingCount.
       */
      int getParameterFillingCount();

      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.NO_MATCH][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.NO_MATCH].
       * </pre>
       *
       * <code>int32 no_match_count = 5;</code>
       *
       * @return The noMatchCount.
       */
      int getNoMatchCount();

      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.NO_INPUT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.NO_INPUT].
       * </pre>
       *
       * <code>int32 no_input_count = 6;</code>
       *
       * @return The noInputCount.
       */
      int getNoInputCount();

      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.EVENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.EVENT].
       * </pre>
       *
       * <code>int32 event_count = 7;</code>
       *
       * @return The eventCount.
       */
      int getEventCount();
    }
    /**
     *
     *
     * <pre>
     * Count by
     * [Match.MatchType][google.cloud.dialogflow.cx.v3beta1.Match.MatchType] of
     * the matches in the conversation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount}
     */
    public static final class MatchTypeCount extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount)
        MatchTypeCountOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MatchTypeCount.newBuilder() to construct.
      private MatchTypeCount(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MatchTypeCount() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MatchTypeCount();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_MatchTypeCount_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_MatchTypeCount_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount.class,
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount.Builder
                    .class);
      }

      public static final int UNSPECIFIED_COUNT_FIELD_NUMBER = 1;
      private int unspecifiedCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.MATCH_TYPE_UNSPECIFIED][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.MATCH_TYPE_UNSPECIFIED].
       * </pre>
       *
       * <code>int32 unspecified_count = 1;</code>
       *
       * @return The unspecifiedCount.
       */
      @java.lang.Override
      public int getUnspecifiedCount() {
        return unspecifiedCount_;
      }

      public static final int INTENT_COUNT_FIELD_NUMBER = 2;
      private int intentCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.INTENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.INTENT].
       * </pre>
       *
       * <code>int32 intent_count = 2;</code>
       *
       * @return The intentCount.
       */
      @java.lang.Override
      public int getIntentCount() {
        return intentCount_;
      }

      public static final int DIRECT_INTENT_COUNT_FIELD_NUMBER = 3;
      private int directIntentCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.DIRECT_INTENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.DIRECT_INTENT].
       * </pre>
       *
       * <code>int32 direct_intent_count = 3;</code>
       *
       * @return The directIntentCount.
       */
      @java.lang.Override
      public int getDirectIntentCount() {
        return directIntentCount_;
      }

      public static final int PARAMETER_FILLING_COUNT_FIELD_NUMBER = 4;
      private int parameterFillingCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.PARAMETER_FILLING][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.PARAMETER_FILLING].
       * </pre>
       *
       * <code>int32 parameter_filling_count = 4;</code>
       *
       * @return The parameterFillingCount.
       */
      @java.lang.Override
      public int getParameterFillingCount() {
        return parameterFillingCount_;
      }

      public static final int NO_MATCH_COUNT_FIELD_NUMBER = 5;
      private int noMatchCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.NO_MATCH][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.NO_MATCH].
       * </pre>
       *
       * <code>int32 no_match_count = 5;</code>
       *
       * @return The noMatchCount.
       */
      @java.lang.Override
      public int getNoMatchCount() {
        return noMatchCount_;
      }

      public static final int NO_INPUT_COUNT_FIELD_NUMBER = 6;
      private int noInputCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.NO_INPUT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.NO_INPUT].
       * </pre>
       *
       * <code>int32 no_input_count = 6;</code>
       *
       * @return The noInputCount.
       */
      @java.lang.Override
      public int getNoInputCount() {
        return noInputCount_;
      }

      public static final int EVENT_COUNT_FIELD_NUMBER = 7;
      private int eventCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of matches with type
       * [Match.MatchType.EVENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.EVENT].
       * </pre>
       *
       * <code>int32 event_count = 7;</code>
       *
       * @return The eventCount.
       */
      @java.lang.Override
      public int getEventCount() {
        return eventCount_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (unspecifiedCount_ != 0) {
          output.writeInt32(1, unspecifiedCount_);
        }
        if (intentCount_ != 0) {
          output.writeInt32(2, intentCount_);
        }
        if (directIntentCount_ != 0) {
          output.writeInt32(3, directIntentCount_);
        }
        if (parameterFillingCount_ != 0) {
          output.writeInt32(4, parameterFillingCount_);
        }
        if (noMatchCount_ != 0) {
          output.writeInt32(5, noMatchCount_);
        }
        if (noInputCount_ != 0) {
          output.writeInt32(6, noInputCount_);
        }
        if (eventCount_ != 0) {
          output.writeInt32(7, eventCount_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (unspecifiedCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, unspecifiedCount_);
        }
        if (intentCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, intentCount_);
        }
        if (directIntentCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, directIntentCount_);
        }
        if (parameterFillingCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, parameterFillingCount_);
        }
        if (noMatchCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, noMatchCount_);
        }
        if (noInputCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, noInputCount_);
        }
        if (eventCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, eventCount_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount other =
            (com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount) obj;

        if (getUnspecifiedCount() != other.getUnspecifiedCount()) return false;
        if (getIntentCount() != other.getIntentCount()) return false;
        if (getDirectIntentCount() != other.getDirectIntentCount()) return false;
        if (getParameterFillingCount() != other.getParameterFillingCount()) return false;
        if (getNoMatchCount() != other.getNoMatchCount()) return false;
        if (getNoInputCount() != other.getNoInputCount()) return false;
        if (getEventCount() != other.getEventCount()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + UNSPECIFIED_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getUnspecifiedCount();
        hash = (37 * hash) + INTENT_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getIntentCount();
        hash = (37 * hash) + DIRECT_INTENT_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getDirectIntentCount();
        hash = (37 * hash) + PARAMETER_FILLING_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getParameterFillingCount();
        hash = (37 * hash) + NO_MATCH_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getNoMatchCount();
        hash = (37 * hash) + NO_INPUT_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getNoInputCount();
        hash = (37 * hash) + EVENT_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getEventCount();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Count by
       * [Match.MatchType][google.cloud.dialogflow.cx.v3beta1.Match.MatchType] of
       * the matches in the conversation.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount)
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCountOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_MatchTypeCount_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_MatchTypeCount_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount.class,
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          unspecifiedCount_ = 0;
          intentCount_ = 0;
          directIntentCount_ = 0;
          parameterFillingCount_ = 0;
          noMatchCount_ = 0;
          noInputCount_ = 0;
          eventCount_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_MatchTypeCount_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount build() {
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount result =
              new com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.unspecifiedCount_ = unspecifiedCount_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.intentCount_ = intentCount_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.directIntentCount_ = directIntentCount_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.parameterFillingCount_ = parameterFillingCount_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.noMatchCount_ = noMatchCount_;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.noInputCount_ = noInputCount_;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.eventCount_ = eventCount_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
                  .getDefaultInstance()) return this;
          if (other.getUnspecifiedCount() != 0) {
            setUnspecifiedCount(other.getUnspecifiedCount());
          }
          if (other.getIntentCount() != 0) {
            setIntentCount(other.getIntentCount());
          }
          if (other.getDirectIntentCount() != 0) {
            setDirectIntentCount(other.getDirectIntentCount());
          }
          if (other.getParameterFillingCount() != 0) {
            setParameterFillingCount(other.getParameterFillingCount());
          }
          if (other.getNoMatchCount() != 0) {
            setNoMatchCount(other.getNoMatchCount());
          }
          if (other.getNoInputCount() != 0) {
            setNoInputCount(other.getNoInputCount());
          }
          if (other.getEventCount() != 0) {
            setEventCount(other.getEventCount());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    unspecifiedCount_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    intentCount_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    directIntentCount_ = input.readInt32();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 32:
                  {
                    parameterFillingCount_ = input.readInt32();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                case 40:
                  {
                    noMatchCount_ = input.readInt32();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 40
                case 48:
                  {
                    noInputCount_ = input.readInt32();
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 48
                case 56:
                  {
                    eventCount_ = input.readInt32();
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 56
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int unspecifiedCount_;
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.MATCH_TYPE_UNSPECIFIED][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.MATCH_TYPE_UNSPECIFIED].
         * </pre>
         *
         * <code>int32 unspecified_count = 1;</code>
         *
         * @return The unspecifiedCount.
         */
        @java.lang.Override
        public int getUnspecifiedCount() {
          return unspecifiedCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.MATCH_TYPE_UNSPECIFIED][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.MATCH_TYPE_UNSPECIFIED].
         * </pre>
         *
         * <code>int32 unspecified_count = 1;</code>
         *
         * @param value The unspecifiedCount to set.
         * @return This builder for chaining.
         */
        public Builder setUnspecifiedCount(int value) {

          unspecifiedCount_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.MATCH_TYPE_UNSPECIFIED][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.MATCH_TYPE_UNSPECIFIED].
         * </pre>
         *
         * <code>int32 unspecified_count = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUnspecifiedCount() {
          bitField0_ = (bitField0_ & ~0x00000001);
          unspecifiedCount_ = 0;
          onChanged();
          return this;
        }

        private int intentCount_;
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.INTENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.INTENT].
         * </pre>
         *
         * <code>int32 intent_count = 2;</code>
         *
         * @return The intentCount.
         */
        @java.lang.Override
        public int getIntentCount() {
          return intentCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.INTENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.INTENT].
         * </pre>
         *
         * <code>int32 intent_count = 2;</code>
         *
         * @param value The intentCount to set.
         * @return This builder for chaining.
         */
        public Builder setIntentCount(int value) {

          intentCount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.INTENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.INTENT].
         * </pre>
         *
         * <code>int32 intent_count = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIntentCount() {
          bitField0_ = (bitField0_ & ~0x00000002);
          intentCount_ = 0;
          onChanged();
          return this;
        }

        private int directIntentCount_;
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.DIRECT_INTENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.DIRECT_INTENT].
         * </pre>
         *
         * <code>int32 direct_intent_count = 3;</code>
         *
         * @return The directIntentCount.
         */
        @java.lang.Override
        public int getDirectIntentCount() {
          return directIntentCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.DIRECT_INTENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.DIRECT_INTENT].
         * </pre>
         *
         * <code>int32 direct_intent_count = 3;</code>
         *
         * @param value The directIntentCount to set.
         * @return This builder for chaining.
         */
        public Builder setDirectIntentCount(int value) {

          directIntentCount_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.DIRECT_INTENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.DIRECT_INTENT].
         * </pre>
         *
         * <code>int32 direct_intent_count = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDirectIntentCount() {
          bitField0_ = (bitField0_ & ~0x00000004);
          directIntentCount_ = 0;
          onChanged();
          return this;
        }

        private int parameterFillingCount_;
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.PARAMETER_FILLING][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.PARAMETER_FILLING].
         * </pre>
         *
         * <code>int32 parameter_filling_count = 4;</code>
         *
         * @return The parameterFillingCount.
         */
        @java.lang.Override
        public int getParameterFillingCount() {
          return parameterFillingCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.PARAMETER_FILLING][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.PARAMETER_FILLING].
         * </pre>
         *
         * <code>int32 parameter_filling_count = 4;</code>
         *
         * @param value The parameterFillingCount to set.
         * @return This builder for chaining.
         */
        public Builder setParameterFillingCount(int value) {

          parameterFillingCount_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.PARAMETER_FILLING][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.PARAMETER_FILLING].
         * </pre>
         *
         * <code>int32 parameter_filling_count = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearParameterFillingCount() {
          bitField0_ = (bitField0_ & ~0x00000008);
          parameterFillingCount_ = 0;
          onChanged();
          return this;
        }

        private int noMatchCount_;
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.NO_MATCH][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.NO_MATCH].
         * </pre>
         *
         * <code>int32 no_match_count = 5;</code>
         *
         * @return The noMatchCount.
         */
        @java.lang.Override
        public int getNoMatchCount() {
          return noMatchCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.NO_MATCH][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.NO_MATCH].
         * </pre>
         *
         * <code>int32 no_match_count = 5;</code>
         *
         * @param value The noMatchCount to set.
         * @return This builder for chaining.
         */
        public Builder setNoMatchCount(int value) {

          noMatchCount_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.NO_MATCH][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.NO_MATCH].
         * </pre>
         *
         * <code>int32 no_match_count = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearNoMatchCount() {
          bitField0_ = (bitField0_ & ~0x00000010);
          noMatchCount_ = 0;
          onChanged();
          return this;
        }

        private int noInputCount_;
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.NO_INPUT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.NO_INPUT].
         * </pre>
         *
         * <code>int32 no_input_count = 6;</code>
         *
         * @return The noInputCount.
         */
        @java.lang.Override
        public int getNoInputCount() {
          return noInputCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.NO_INPUT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.NO_INPUT].
         * </pre>
         *
         * <code>int32 no_input_count = 6;</code>
         *
         * @param value The noInputCount to set.
         * @return This builder for chaining.
         */
        public Builder setNoInputCount(int value) {

          noInputCount_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.NO_INPUT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.NO_INPUT].
         * </pre>
         *
         * <code>int32 no_input_count = 6;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearNoInputCount() {
          bitField0_ = (bitField0_ & ~0x00000020);
          noInputCount_ = 0;
          onChanged();
          return this;
        }

        private int eventCount_;
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.EVENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.EVENT].
         * </pre>
         *
         * <code>int32 event_count = 7;</code>
         *
         * @return The eventCount.
         */
        @java.lang.Override
        public int getEventCount() {
          return eventCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.EVENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.EVENT].
         * </pre>
         *
         * <code>int32 event_count = 7;</code>
         *
         * @param value The eventCount to set.
         * @return This builder for chaining.
         */
        public Builder setEventCount(int value) {

          eventCount_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of matches with type
         * [Match.MatchType.EVENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.EVENT].
         * </pre>
         *
         * <code>int32 event_count = 7;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEventCount() {
          bitField0_ = (bitField0_ & ~0x00000040);
          eventCount_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics
              .MatchTypeCount
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MatchTypeCount> PARSER =
          new com.google.protobuf.AbstractParser<MatchTypeCount>() {
            @java.lang.Override
            public MatchTypeCount parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MatchTypeCount> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MatchTypeCount> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int INTERACTION_COUNT_FIELD_NUMBER = 1;
    private int interactionCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of interactions in the conversation.
     * </pre>
     *
     * <code>int32 interaction_count = 1;</code>
     *
     * @return The interactionCount.
     */
    @java.lang.Override
    public int getInteractionCount() {
      return interactionCount_;
    }

    public static final int INPUT_AUDIO_DURATION_FIELD_NUMBER = 2;
    private com.google.protobuf.Duration inputAudioDuration_;
    /**
     *
     *
     * <pre>
     * Duration of all the input's audio in the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
     *
     * @return Whether the inputAudioDuration field is set.
     */
    @java.lang.Override
    public boolean hasInputAudioDuration() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Duration of all the input's audio in the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
     *
     * @return The inputAudioDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getInputAudioDuration() {
      return inputAudioDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : inputAudioDuration_;
    }
    /**
     *
     *
     * <pre>
     * Duration of all the input's audio in the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getInputAudioDurationOrBuilder() {
      return inputAudioDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : inputAudioDuration_;
    }

    public static final int OUTPUT_AUDIO_DURATION_FIELD_NUMBER = 3;
    private com.google.protobuf.Duration outputAudioDuration_;
    /**
     *
     *
     * <pre>
     * Duration of all the output's audio in the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
     *
     * @return Whether the outputAudioDuration field is set.
     */
    @java.lang.Override
    public boolean hasOutputAudioDuration() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Duration of all the output's audio in the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
     *
     * @return The outputAudioDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getOutputAudioDuration() {
      return outputAudioDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : outputAudioDuration_;
    }
    /**
     *
     *
     * <pre>
     * Duration of all the output's audio in the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getOutputAudioDurationOrBuilder() {
      return outputAudioDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : outputAudioDuration_;
    }

    public static final int MAX_WEBHOOK_LATENCY_FIELD_NUMBER = 4;
    private com.google.protobuf.Duration maxWebhookLatency_;
    /**
     *
     *
     * <pre>
     * Maximum latency of the
     * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
     * conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
     *
     * @return Whether the maxWebhookLatency field is set.
     */
    @java.lang.Override
    public boolean hasMaxWebhookLatency() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Maximum latency of the
     * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
     * conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
     *
     * @return The maxWebhookLatency.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMaxWebhookLatency() {
      return maxWebhookLatency_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : maxWebhookLatency_;
    }
    /**
     *
     *
     * <pre>
     * Maximum latency of the
     * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
     * conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMaxWebhookLatencyOrBuilder() {
      return maxWebhookLatency_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : maxWebhookLatency_;
    }

    public static final int HAS_END_INTERACTION_FIELD_NUMBER = 5;
    private boolean hasEndInteraction_ = false;
    /**
     *
     *
     * <pre>
     * A signal that indicates the interaction with the Dialogflow agent has
     * ended.
     * If any response has the
     * [ResponseMessage.end_interaction][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.end_interaction]
     * signal, this is set to true.
     * </pre>
     *
     * <code>bool has_end_interaction = 5;</code>
     *
     * @return The hasEndInteraction.
     */
    @java.lang.Override
    public boolean getHasEndInteraction() {
      return hasEndInteraction_;
    }

    public static final int HAS_LIVE_AGENT_HANDOFF_FIELD_NUMBER = 6;
    private boolean hasLiveAgentHandoff_ = false;
    /**
     *
     *
     * <pre>
     * Hands off conversation to a human agent.
     * If any response has the
     * [ResponseMessage.live_agent_handoff][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.live_agent_handoff]signal,
     * this is set to true.
     * </pre>
     *
     * <code>bool has_live_agent_handoff = 6;</code>
     *
     * @return The hasLiveAgentHandoff.
     */
    @java.lang.Override
    public boolean getHasLiveAgentHandoff() {
      return hasLiveAgentHandoff_;
    }

    public static final int AVERAGE_MATCH_CONFIDENCE_FIELD_NUMBER = 7;
    private float averageMatchConfidence_ = 0F;
    /**
     *
     *
     * <pre>
     * The average confidence all of the
     * [Match][google.cloud.dialogflow.cx.v3beta1.Match] in the conversation.
     * Values range from 0.0 (completely uncertain) to 1.0 (completely certain).
     * </pre>
     *
     * <code>float average_match_confidence = 7;</code>
     *
     * @return The averageMatchConfidence.
     */
    @java.lang.Override
    public float getAverageMatchConfidence() {
      return averageMatchConfidence_;
    }

    public static final int QUERY_INPUT_COUNT_FIELD_NUMBER = 8;
    private com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
        queryInputCount_;
    /**
     *
     *
     * <pre>
     * Query input counts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
     * </code>
     *
     * @return Whether the queryInputCount field is set.
     */
    @java.lang.Override
    public boolean hasQueryInputCount() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Query input counts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
     * </code>
     *
     * @return The queryInputCount.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
        getQueryInputCount() {
      return queryInputCount_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
              .getDefaultInstance()
          : queryInputCount_;
    }
    /**
     *
     *
     * <pre>
     * Query input counts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCountOrBuilder
        getQueryInputCountOrBuilder() {
      return queryInputCount_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
              .getDefaultInstance()
          : queryInputCount_;
    }

    public static final int MATCH_TYPE_COUNT_FIELD_NUMBER = 9;
    private com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
        matchTypeCount_;
    /**
     *
     *
     * <pre>
     * Match type counts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
     * </code>
     *
     * @return Whether the matchTypeCount field is set.
     */
    @java.lang.Override
    public boolean hasMatchTypeCount() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Match type counts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
     * </code>
     *
     * @return The matchTypeCount.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
        getMatchTypeCount() {
      return matchTypeCount_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
              .getDefaultInstance()
          : matchTypeCount_;
    }
    /**
     *
     *
     * <pre>
     * Match type counts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCountOrBuilder
        getMatchTypeCountOrBuilder() {
      return matchTypeCount_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
              .getDefaultInstance()
          : matchTypeCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (interactionCount_ != 0) {
        output.writeInt32(1, interactionCount_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getInputAudioDuration());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getOutputAudioDuration());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(4, getMaxWebhookLatency());
      }
      if (hasEndInteraction_ != false) {
        output.writeBool(5, hasEndInteraction_);
      }
      if (hasLiveAgentHandoff_ != false) {
        output.writeBool(6, hasLiveAgentHandoff_);
      }
      if (java.lang.Float.floatToRawIntBits(averageMatchConfidence_) != 0) {
        output.writeFloat(7, averageMatchConfidence_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(8, getQueryInputCount());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeMessage(9, getMatchTypeCount());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (interactionCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, interactionCount_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getInputAudioDuration());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOutputAudioDuration());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMaxWebhookLatency());
      }
      if (hasEndInteraction_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, hasEndInteraction_);
      }
      if (hasLiveAgentHandoff_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, hasLiveAgentHandoff_);
      }
      if (java.lang.Float.floatToRawIntBits(averageMatchConfidence_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(7, averageMatchConfidence_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getQueryInputCount());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getMatchTypeCount());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics other =
          (com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics) obj;

      if (getInteractionCount() != other.getInteractionCount()) return false;
      if (hasInputAudioDuration() != other.hasInputAudioDuration()) return false;
      if (hasInputAudioDuration()) {
        if (!getInputAudioDuration().equals(other.getInputAudioDuration())) return false;
      }
      if (hasOutputAudioDuration() != other.hasOutputAudioDuration()) return false;
      if (hasOutputAudioDuration()) {
        if (!getOutputAudioDuration().equals(other.getOutputAudioDuration())) return false;
      }
      if (hasMaxWebhookLatency() != other.hasMaxWebhookLatency()) return false;
      if (hasMaxWebhookLatency()) {
        if (!getMaxWebhookLatency().equals(other.getMaxWebhookLatency())) return false;
      }
      if (getHasEndInteraction() != other.getHasEndInteraction()) return false;
      if (getHasLiveAgentHandoff() != other.getHasLiveAgentHandoff()) return false;
      if (java.lang.Float.floatToIntBits(getAverageMatchConfidence())
          != java.lang.Float.floatToIntBits(other.getAverageMatchConfidence())) return false;
      if (hasQueryInputCount() != other.hasQueryInputCount()) return false;
      if (hasQueryInputCount()) {
        if (!getQueryInputCount().equals(other.getQueryInputCount())) return false;
      }
      if (hasMatchTypeCount() != other.hasMatchTypeCount()) return false;
      if (hasMatchTypeCount()) {
        if (!getMatchTypeCount().equals(other.getMatchTypeCount())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INTERACTION_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getInteractionCount();
      if (hasInputAudioDuration()) {
        hash = (37 * hash) + INPUT_AUDIO_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getInputAudioDuration().hashCode();
      }
      if (hasOutputAudioDuration()) {
        hash = (37 * hash) + OUTPUT_AUDIO_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getOutputAudioDuration().hashCode();
      }
      if (hasMaxWebhookLatency()) {
        hash = (37 * hash) + MAX_WEBHOOK_LATENCY_FIELD_NUMBER;
        hash = (53 * hash) + getMaxWebhookLatency().hashCode();
      }
      hash = (37 * hash) + HAS_END_INTERACTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasEndInteraction());
      hash = (37 * hash) + HAS_LIVE_AGENT_HANDOFF_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasLiveAgentHandoff());
      hash = (37 * hash) + AVERAGE_MATCH_CONFIDENCE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getAverageMatchConfidence());
      if (hasQueryInputCount()) {
        hash = (37 * hash) + QUERY_INPUT_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getQueryInputCount().hashCode();
      }
      if (hasMatchTypeCount()) {
        hash = (37 * hash) + MATCH_TYPE_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getMatchTypeCount().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents metrics for the conversation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics)
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.MetricsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.class,
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getInputAudioDurationFieldBuilder();
          getOutputAudioDurationFieldBuilder();
          getMaxWebhookLatencyFieldBuilder();
          getQueryInputCountFieldBuilder();
          getMatchTypeCountFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        interactionCount_ = 0;
        inputAudioDuration_ = null;
        if (inputAudioDurationBuilder_ != null) {
          inputAudioDurationBuilder_.dispose();
          inputAudioDurationBuilder_ = null;
        }
        outputAudioDuration_ = null;
        if (outputAudioDurationBuilder_ != null) {
          outputAudioDurationBuilder_.dispose();
          outputAudioDurationBuilder_ = null;
        }
        maxWebhookLatency_ = null;
        if (maxWebhookLatencyBuilder_ != null) {
          maxWebhookLatencyBuilder_.dispose();
          maxWebhookLatencyBuilder_ = null;
        }
        hasEndInteraction_ = false;
        hasLiveAgentHandoff_ = false;
        averageMatchConfidence_ = 0F;
        queryInputCount_ = null;
        if (queryInputCountBuilder_ != null) {
          queryInputCountBuilder_.dispose();
          queryInputCountBuilder_ = null;
        }
        matchTypeCount_ = null;
        if (matchTypeCountBuilder_ != null) {
          matchTypeCountBuilder_.dispose();
          matchTypeCountBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Metrics_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics build() {
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics result =
            new com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.interactionCount_ = interactionCount_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.inputAudioDuration_ =
              inputAudioDurationBuilder_ == null
                  ? inputAudioDuration_
                  : inputAudioDurationBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.outputAudioDuration_ =
              outputAudioDurationBuilder_ == null
                  ? outputAudioDuration_
                  : outputAudioDurationBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.maxWebhookLatency_ =
              maxWebhookLatencyBuilder_ == null
                  ? maxWebhookLatency_
                  : maxWebhookLatencyBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.hasEndInteraction_ = hasEndInteraction_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.hasLiveAgentHandoff_ = hasLiveAgentHandoff_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.averageMatchConfidence_ = averageMatchConfidence_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.queryInputCount_ =
              queryInputCountBuilder_ == null ? queryInputCount_ : queryInputCountBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.matchTypeCount_ =
              matchTypeCountBuilder_ == null ? matchTypeCount_ : matchTypeCountBuilder_.build();
          to_bitField0_ |= 0x00000010;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.getDefaultInstance())
          return this;
        if (other.getInteractionCount() != 0) {
          setInteractionCount(other.getInteractionCount());
        }
        if (other.hasInputAudioDuration()) {
          mergeInputAudioDuration(other.getInputAudioDuration());
        }
        if (other.hasOutputAudioDuration()) {
          mergeOutputAudioDuration(other.getOutputAudioDuration());
        }
        if (other.hasMaxWebhookLatency()) {
          mergeMaxWebhookLatency(other.getMaxWebhookLatency());
        }
        if (other.getHasEndInteraction() != false) {
          setHasEndInteraction(other.getHasEndInteraction());
        }
        if (other.getHasLiveAgentHandoff() != false) {
          setHasLiveAgentHandoff(other.getHasLiveAgentHandoff());
        }
        if (other.getAverageMatchConfidence() != 0F) {
          setAverageMatchConfidence(other.getAverageMatchConfidence());
        }
        if (other.hasQueryInputCount()) {
          mergeQueryInputCount(other.getQueryInputCount());
        }
        if (other.hasMatchTypeCount()) {
          mergeMatchTypeCount(other.getMatchTypeCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  interactionCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(
                      getInputAudioDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getOutputAudioDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getMaxWebhookLatencyFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 40:
                {
                  hasEndInteraction_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              case 48:
                {
                  hasLiveAgentHandoff_ = input.readBool();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 48
              case 61:
                {
                  averageMatchConfidence_ = input.readFloat();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 61
              case 66:
                {
                  input.readMessage(
                      getQueryInputCountFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(
                      getMatchTypeCountFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int interactionCount_;
      /**
       *
       *
       * <pre>
       * The number of interactions in the conversation.
       * </pre>
       *
       * <code>int32 interaction_count = 1;</code>
       *
       * @return The interactionCount.
       */
      @java.lang.Override
      public int getInteractionCount() {
        return interactionCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of interactions in the conversation.
       * </pre>
       *
       * <code>int32 interaction_count = 1;</code>
       *
       * @param value The interactionCount to set.
       * @return This builder for chaining.
       */
      public Builder setInteractionCount(int value) {

        interactionCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of interactions in the conversation.
       * </pre>
       *
       * <code>int32 interaction_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInteractionCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        interactionCount_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration inputAudioDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          inputAudioDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Duration of all the input's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
       *
       * @return Whether the inputAudioDuration field is set.
       */
      public boolean hasInputAudioDuration() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Duration of all the input's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
       *
       * @return The inputAudioDuration.
       */
      public com.google.protobuf.Duration getInputAudioDuration() {
        if (inputAudioDurationBuilder_ == null) {
          return inputAudioDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : inputAudioDuration_;
        } else {
          return inputAudioDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of all the input's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
       */
      public Builder setInputAudioDuration(com.google.protobuf.Duration value) {
        if (inputAudioDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          inputAudioDuration_ = value;
        } else {
          inputAudioDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of all the input's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
       */
      public Builder setInputAudioDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (inputAudioDurationBuilder_ == null) {
          inputAudioDuration_ = builderForValue.build();
        } else {
          inputAudioDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of all the input's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
       */
      public Builder mergeInputAudioDuration(com.google.protobuf.Duration value) {
        if (inputAudioDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && inputAudioDuration_ != null
              && inputAudioDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getInputAudioDurationBuilder().mergeFrom(value);
          } else {
            inputAudioDuration_ = value;
          }
        } else {
          inputAudioDurationBuilder_.mergeFrom(value);
        }
        if (inputAudioDuration_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of all the input's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
       */
      public Builder clearInputAudioDuration() {
        bitField0_ = (bitField0_ & ~0x00000002);
        inputAudioDuration_ = null;
        if (inputAudioDurationBuilder_ != null) {
          inputAudioDurationBuilder_.dispose();
          inputAudioDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of all the input's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
       */
      public com.google.protobuf.Duration.Builder getInputAudioDurationBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getInputAudioDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Duration of all the input's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
       */
      public com.google.protobuf.DurationOrBuilder getInputAudioDurationOrBuilder() {
        if (inputAudioDurationBuilder_ != null) {
          return inputAudioDurationBuilder_.getMessageOrBuilder();
        } else {
          return inputAudioDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : inputAudioDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of all the input's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration input_audio_duration = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getInputAudioDurationFieldBuilder() {
        if (inputAudioDurationBuilder_ == null) {
          inputAudioDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getInputAudioDuration(), getParentForChildren(), isClean());
          inputAudioDuration_ = null;
        }
        return inputAudioDurationBuilder_;
      }

      private com.google.protobuf.Duration outputAudioDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          outputAudioDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Duration of all the output's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
       *
       * @return Whether the outputAudioDuration field is set.
       */
      public boolean hasOutputAudioDuration() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Duration of all the output's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
       *
       * @return The outputAudioDuration.
       */
      public com.google.protobuf.Duration getOutputAudioDuration() {
        if (outputAudioDurationBuilder_ == null) {
          return outputAudioDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : outputAudioDuration_;
        } else {
          return outputAudioDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of all the output's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
       */
      public Builder setOutputAudioDuration(com.google.protobuf.Duration value) {
        if (outputAudioDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          outputAudioDuration_ = value;
        } else {
          outputAudioDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of all the output's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
       */
      public Builder setOutputAudioDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (outputAudioDurationBuilder_ == null) {
          outputAudioDuration_ = builderForValue.build();
        } else {
          outputAudioDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of all the output's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
       */
      public Builder mergeOutputAudioDuration(com.google.protobuf.Duration value) {
        if (outputAudioDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && outputAudioDuration_ != null
              && outputAudioDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getOutputAudioDurationBuilder().mergeFrom(value);
          } else {
            outputAudioDuration_ = value;
          }
        } else {
          outputAudioDurationBuilder_.mergeFrom(value);
        }
        if (outputAudioDuration_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of all the output's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
       */
      public Builder clearOutputAudioDuration() {
        bitField0_ = (bitField0_ & ~0x00000004);
        outputAudioDuration_ = null;
        if (outputAudioDurationBuilder_ != null) {
          outputAudioDurationBuilder_.dispose();
          outputAudioDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration of all the output's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
       */
      public com.google.protobuf.Duration.Builder getOutputAudioDurationBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getOutputAudioDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Duration of all the output's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
       */
      public com.google.protobuf.DurationOrBuilder getOutputAudioDurationOrBuilder() {
        if (outputAudioDurationBuilder_ != null) {
          return outputAudioDurationBuilder_.getMessageOrBuilder();
        } else {
          return outputAudioDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : outputAudioDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Duration of all the output's audio in the conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration output_audio_duration = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getOutputAudioDurationFieldBuilder() {
        if (outputAudioDurationBuilder_ == null) {
          outputAudioDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getOutputAudioDuration(), getParentForChildren(), isClean());
          outputAudioDuration_ = null;
        }
        return outputAudioDurationBuilder_;
      }

      private com.google.protobuf.Duration maxWebhookLatency_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          maxWebhookLatencyBuilder_;
      /**
       *
       *
       * <pre>
       * Maximum latency of the
       * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
       * conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
       *
       * @return Whether the maxWebhookLatency field is set.
       */
      public boolean hasMaxWebhookLatency() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Maximum latency of the
       * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
       * conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
       *
       * @return The maxWebhookLatency.
       */
      public com.google.protobuf.Duration getMaxWebhookLatency() {
        if (maxWebhookLatencyBuilder_ == null) {
          return maxWebhookLatency_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : maxWebhookLatency_;
        } else {
          return maxWebhookLatencyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Maximum latency of the
       * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
       * conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
       */
      public Builder setMaxWebhookLatency(com.google.protobuf.Duration value) {
        if (maxWebhookLatencyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maxWebhookLatency_ = value;
        } else {
          maxWebhookLatencyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maximum latency of the
       * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
       * conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
       */
      public Builder setMaxWebhookLatency(com.google.protobuf.Duration.Builder builderForValue) {
        if (maxWebhookLatencyBuilder_ == null) {
          maxWebhookLatency_ = builderForValue.build();
        } else {
          maxWebhookLatencyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maximum latency of the
       * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
       * conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
       */
      public Builder mergeMaxWebhookLatency(com.google.protobuf.Duration value) {
        if (maxWebhookLatencyBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && maxWebhookLatency_ != null
              && maxWebhookLatency_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getMaxWebhookLatencyBuilder().mergeFrom(value);
          } else {
            maxWebhookLatency_ = value;
          }
        } else {
          maxWebhookLatencyBuilder_.mergeFrom(value);
        }
        if (maxWebhookLatency_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maximum latency of the
       * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
       * conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
       */
      public Builder clearMaxWebhookLatency() {
        bitField0_ = (bitField0_ & ~0x00000008);
        maxWebhookLatency_ = null;
        if (maxWebhookLatencyBuilder_ != null) {
          maxWebhookLatencyBuilder_.dispose();
          maxWebhookLatencyBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maximum latency of the
       * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
       * conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
       */
      public com.google.protobuf.Duration.Builder getMaxWebhookLatencyBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getMaxWebhookLatencyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Maximum latency of the
       * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
       * conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
       */
      public com.google.protobuf.DurationOrBuilder getMaxWebhookLatencyOrBuilder() {
        if (maxWebhookLatencyBuilder_ != null) {
          return maxWebhookLatencyBuilder_.getMessageOrBuilder();
        } else {
          return maxWebhookLatency_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : maxWebhookLatency_;
        }
      }
      /**
       *
       *
       * <pre>
       * Maximum latency of the
       * [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
       * conversation.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_webhook_latency = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMaxWebhookLatencyFieldBuilder() {
        if (maxWebhookLatencyBuilder_ == null) {
          maxWebhookLatencyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getMaxWebhookLatency(), getParentForChildren(), isClean());
          maxWebhookLatency_ = null;
        }
        return maxWebhookLatencyBuilder_;
      }

      private boolean hasEndInteraction_;
      /**
       *
       *
       * <pre>
       * A signal that indicates the interaction with the Dialogflow agent has
       * ended.
       * If any response has the
       * [ResponseMessage.end_interaction][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.end_interaction]
       * signal, this is set to true.
       * </pre>
       *
       * <code>bool has_end_interaction = 5;</code>
       *
       * @return The hasEndInteraction.
       */
      @java.lang.Override
      public boolean getHasEndInteraction() {
        return hasEndInteraction_;
      }
      /**
       *
       *
       * <pre>
       * A signal that indicates the interaction with the Dialogflow agent has
       * ended.
       * If any response has the
       * [ResponseMessage.end_interaction][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.end_interaction]
       * signal, this is set to true.
       * </pre>
       *
       * <code>bool has_end_interaction = 5;</code>
       *
       * @param value The hasEndInteraction to set.
       * @return This builder for chaining.
       */
      public Builder setHasEndInteraction(boolean value) {

        hasEndInteraction_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A signal that indicates the interaction with the Dialogflow agent has
       * ended.
       * If any response has the
       * [ResponseMessage.end_interaction][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.end_interaction]
       * signal, this is set to true.
       * </pre>
       *
       * <code>bool has_end_interaction = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHasEndInteraction() {
        bitField0_ = (bitField0_ & ~0x00000010);
        hasEndInteraction_ = false;
        onChanged();
        return this;
      }

      private boolean hasLiveAgentHandoff_;
      /**
       *
       *
       * <pre>
       * Hands off conversation to a human agent.
       * If any response has the
       * [ResponseMessage.live_agent_handoff][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.live_agent_handoff]signal,
       * this is set to true.
       * </pre>
       *
       * <code>bool has_live_agent_handoff = 6;</code>
       *
       * @return The hasLiveAgentHandoff.
       */
      @java.lang.Override
      public boolean getHasLiveAgentHandoff() {
        return hasLiveAgentHandoff_;
      }
      /**
       *
       *
       * <pre>
       * Hands off conversation to a human agent.
       * If any response has the
       * [ResponseMessage.live_agent_handoff][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.live_agent_handoff]signal,
       * this is set to true.
       * </pre>
       *
       * <code>bool has_live_agent_handoff = 6;</code>
       *
       * @param value The hasLiveAgentHandoff to set.
       * @return This builder for chaining.
       */
      public Builder setHasLiveAgentHandoff(boolean value) {

        hasLiveAgentHandoff_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hands off conversation to a human agent.
       * If any response has the
       * [ResponseMessage.live_agent_handoff][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.live_agent_handoff]signal,
       * this is set to true.
       * </pre>
       *
       * <code>bool has_live_agent_handoff = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHasLiveAgentHandoff() {
        bitField0_ = (bitField0_ & ~0x00000020);
        hasLiveAgentHandoff_ = false;
        onChanged();
        return this;
      }

      private float averageMatchConfidence_;
      /**
       *
       *
       * <pre>
       * The average confidence all of the
       * [Match][google.cloud.dialogflow.cx.v3beta1.Match] in the conversation.
       * Values range from 0.0 (completely uncertain) to 1.0 (completely certain).
       * </pre>
       *
       * <code>float average_match_confidence = 7;</code>
       *
       * @return The averageMatchConfidence.
       */
      @java.lang.Override
      public float getAverageMatchConfidence() {
        return averageMatchConfidence_;
      }
      /**
       *
       *
       * <pre>
       * The average confidence all of the
       * [Match][google.cloud.dialogflow.cx.v3beta1.Match] in the conversation.
       * Values range from 0.0 (completely uncertain) to 1.0 (completely certain).
       * </pre>
       *
       * <code>float average_match_confidence = 7;</code>
       *
       * @param value The averageMatchConfidence to set.
       * @return This builder for chaining.
       */
      public Builder setAverageMatchConfidence(float value) {

        averageMatchConfidence_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The average confidence all of the
       * [Match][google.cloud.dialogflow.cx.v3beta1.Match] in the conversation.
       * Values range from 0.0 (completely uncertain) to 1.0 (completely certain).
       * </pre>
       *
       * <code>float average_match_confidence = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAverageMatchConfidence() {
        bitField0_ = (bitField0_ & ~0x00000040);
        averageMatchConfidence_ = 0F;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          queryInputCount_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCountOrBuilder>
          queryInputCountBuilder_;
      /**
       *
       *
       * <pre>
       * Query input counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
       * </code>
       *
       * @return Whether the queryInputCount field is set.
       */
      public boolean hasQueryInputCount() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Query input counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
       * </code>
       *
       * @return The queryInputCount.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
          getQueryInputCount() {
        if (queryInputCountBuilder_ == null) {
          return queryInputCount_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
                  .getDefaultInstance()
              : queryInputCount_;
        } else {
          return queryInputCountBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Query input counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
       * </code>
       */
      public Builder setQueryInputCount(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount value) {
        if (queryInputCountBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          queryInputCount_ = value;
        } else {
          queryInputCountBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query input counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
       * </code>
       */
      public Builder setQueryInputCount(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount.Builder
              builderForValue) {
        if (queryInputCountBuilder_ == null) {
          queryInputCount_ = builderForValue.build();
        } else {
          queryInputCountBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query input counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
       * </code>
       */
      public Builder mergeQueryInputCount(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount value) {
        if (queryInputCountBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && queryInputCount_ != null
              && queryInputCount_
                  != com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
                      .getDefaultInstance()) {
            getQueryInputCountBuilder().mergeFrom(value);
          } else {
            queryInputCount_ = value;
          }
        } else {
          queryInputCountBuilder_.mergeFrom(value);
        }
        if (queryInputCount_ != null) {
          bitField0_ |= 0x00000080;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query input counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
       * </code>
       */
      public Builder clearQueryInputCount() {
        bitField0_ = (bitField0_ & ~0x00000080);
        queryInputCount_ = null;
        if (queryInputCountBuilder_ != null) {
          queryInputCountBuilder_.dispose();
          queryInputCountBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query input counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount.Builder
          getQueryInputCountBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getQueryInputCountFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Query input counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCountOrBuilder
          getQueryInputCountOrBuilder() {
        if (queryInputCountBuilder_ != null) {
          return queryInputCountBuilder_.getMessageOrBuilder();
        } else {
          return queryInputCount_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
                  .getDefaultInstance()
              : queryInputCount_;
        }
      }
      /**
       *
       *
       * <pre>
       * Query input counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount query_input_count = 8;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCountOrBuilder>
          getQueryInputCountFieldBuilder() {
        if (queryInputCountBuilder_ == null) {
          queryInputCountBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount,
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
                      .Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics
                      .QueryInputCountOrBuilder>(
                  getQueryInputCount(), getParentForChildren(), isClean());
          queryInputCount_ = null;
        }
        return queryInputCountBuilder_;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          matchTypeCount_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCountOrBuilder>
          matchTypeCountBuilder_;
      /**
       *
       *
       * <pre>
       * Match type counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
       * </code>
       *
       * @return Whether the matchTypeCount field is set.
       */
      public boolean hasMatchTypeCount() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       *
       *
       * <pre>
       * Match type counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
       * </code>
       *
       * @return The matchTypeCount.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
          getMatchTypeCount() {
        if (matchTypeCountBuilder_ == null) {
          return matchTypeCount_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
                  .getDefaultInstance()
              : matchTypeCount_;
        } else {
          return matchTypeCountBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Match type counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
       * </code>
       */
      public Builder setMatchTypeCount(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount value) {
        if (matchTypeCountBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          matchTypeCount_ = value;
        } else {
          matchTypeCountBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Match type counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
       * </code>
       */
      public Builder setMatchTypeCount(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount.Builder
              builderForValue) {
        if (matchTypeCountBuilder_ == null) {
          matchTypeCount_ = builderForValue.build();
        } else {
          matchTypeCountBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Match type counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
       * </code>
       */
      public Builder mergeMatchTypeCount(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount value) {
        if (matchTypeCountBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && matchTypeCount_ != null
              && matchTypeCount_
                  != com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
                      .getDefaultInstance()) {
            getMatchTypeCountBuilder().mergeFrom(value);
          } else {
            matchTypeCount_ = value;
          }
        } else {
          matchTypeCountBuilder_.mergeFrom(value);
        }
        if (matchTypeCount_ != null) {
          bitField0_ |= 0x00000100;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Match type counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
       * </code>
       */
      public Builder clearMatchTypeCount() {
        bitField0_ = (bitField0_ & ~0x00000100);
        matchTypeCount_ = null;
        if (matchTypeCountBuilder_ != null) {
          matchTypeCountBuilder_.dispose();
          matchTypeCountBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Match type counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount.Builder
          getMatchTypeCountBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getMatchTypeCountFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Match type counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCountOrBuilder
          getMatchTypeCountOrBuilder() {
        if (matchTypeCountBuilder_ != null) {
          return matchTypeCountBuilder_.getMessageOrBuilder();
        } else {
          return matchTypeCount_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
                  .getDefaultInstance()
              : matchTypeCount_;
        }
      }
      /**
       *
       *
       * <pre>
       * Match type counts.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount match_type_count = 9;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCountOrBuilder>
          getMatchTypeCountFieldBuilder() {
        if (matchTypeCountBuilder_ == null) {
          matchTypeCountBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount,
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
                      .Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics
                      .MatchTypeCountOrBuilder>(
                  getMatchTypeCount(), getParentForChildren(), isClean());
          matchTypeCount_ = null;
        }
        return matchTypeCountBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Metrics> PARSER =
        new com.google.protobuf.AbstractParser<Metrics>() {
          @java.lang.Override
          public Metrics parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Metrics> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Metrics> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InteractionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The request of the interaction.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
     *
     * @return Whether the request field is set.
     */
    boolean hasRequest();
    /**
     *
     *
     * <pre>
     * The request of the interaction.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
     *
     * @return The request.
     */
    com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest getRequest();
    /**
     *
     *
     * <pre>
     * The request of the interaction.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequestOrBuilder getRequestOrBuilder();

    /**
     *
     *
     * <pre>
     * The final response of the interaction.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
     *
     * @return Whether the response field is set.
     */
    boolean hasResponse();
    /**
     *
     *
     * <pre>
     * The final response of the interaction.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
     *
     * @return The response.
     */
    com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse getResponse();
    /**
     *
     *
     * <pre>
     * The final response of the interaction.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder getResponseOrBuilder();

    /**
     *
     *
     * <pre>
     * The partial responses of the interaction. Empty if there is no partial
     * response in the interaction.
     * See the
     * [partial response
     * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse>
        getPartialResponsesList();
    /**
     *
     *
     * <pre>
     * The partial responses of the interaction. Empty if there is no partial
     * response in the interaction.
     * See the
     * [partial response
     * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse getPartialResponses(int index);
    /**
     *
     *
     * <pre>
     * The partial responses of the interaction. Empty if there is no partial
     * response in the interaction.
     * See the
     * [partial response
     * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
     * </code>
     */
    int getPartialResponsesCount();
    /**
     *
     *
     * <pre>
     * The partial responses of the interaction. Empty if there is no partial
     * response in the interaction.
     * See the
     * [partial response
     * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
     * </code>
     */
    java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder>
        getPartialResponsesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The partial responses of the interaction. Empty if there is no partial
     * response in the interaction.
     * See the
     * [partial response
     * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder
        getPartialResponsesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * The input text or the transcript of the input audio in the request.
     * </pre>
     *
     * <code>string request_utterances = 4;</code>
     *
     * @return The requestUtterances.
     */
    java.lang.String getRequestUtterances();
    /**
     *
     *
     * <pre>
     * The input text or the transcript of the input audio in the request.
     * </pre>
     *
     * <code>string request_utterances = 4;</code>
     *
     * @return The bytes for requestUtterances.
     */
    com.google.protobuf.ByteString getRequestUtterancesBytes();

    /**
     *
     *
     * <pre>
     * The output text or the transcript of the output audio in the responses.
     * If multiple output messages are returned, they will be concatenated into
     * one.
     * </pre>
     *
     * <code>string response_utterances = 5;</code>
     *
     * @return The responseUtterances.
     */
    java.lang.String getResponseUtterances();
    /**
     *
     *
     * <pre>
     * The output text or the transcript of the output audio in the responses.
     * If multiple output messages are returned, they will be concatenated into
     * one.
     * </pre>
     *
     * <code>string response_utterances = 5;</code>
     *
     * @return The bytes for responseUtterances.
     */
    com.google.protobuf.ByteString getResponseUtterancesBytes();

    /**
     *
     *
     * <pre>
     * The time that the interaction was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return Whether the createTime field is set.
     */
    boolean hasCreateTime();
    /**
     *
     *
     * <pre>
     * The time that the interaction was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return The createTime.
     */
    com.google.protobuf.Timestamp getCreateTime();
    /**
     *
     *
     * <pre>
     * The time that the interaction was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Answer feedback for the final response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
     *
     * @return Whether the answerFeedback field is set.
     */
    boolean hasAnswerFeedback();
    /**
     *
     *
     * <pre>
     * Answer feedback for the final response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
     *
     * @return The answerFeedback.
     */
    com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback getAnswerFeedback();
    /**
     *
     *
     * <pre>
     * Answer feedback for the final response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedbackOrBuilder getAnswerFeedbackOrBuilder();

    /**
     *
     *
     * <pre>
     * Missing transition predicted for the interaction. This field is set only
     * if the interaction match type was no-match.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
     * </code>
     *
     * @return Whether the missingTransition field is set.
     */
    boolean hasMissingTransition();
    /**
     *
     *
     * <pre>
     * Missing transition predicted for the interaction. This field is set only
     * if the interaction match type was no-match.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
     * </code>
     *
     * @return The missingTransition.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
        getMissingTransition();
    /**
     *
     *
     * <pre>
     * Missing transition predicted for the interaction. This field is set only
     * if the interaction match type was no-match.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransitionOrBuilder
        getMissingTransitionOrBuilder();

    /**
     *
     *
     * <pre>
     * Metrics associated with different processing steps. Names and number of
     * steps depend on the request and can change without a notice.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics>
        getStepMetricsList();
    /**
     *
     *
     * <pre>
     * Metrics associated with different processing steps. Names and number of
     * steps depend on the request and can change without a notice.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics getStepMetrics(
        int index);
    /**
     *
     *
     * <pre>
     * Metrics associated with different processing steps. Names and number of
     * steps depend on the request and can change without a notice.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
     * </code>
     */
    int getStepMetricsCount();
    /**
     *
     *
     * <pre>
     * Metrics associated with different processing steps. Names and number of
     * steps depend on the request and can change without a notice.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
                    .StepMetricsOrBuilder>
        getStepMetricsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Metrics associated with different processing steps. Names and number of
     * steps depend on the request and can change without a notice.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetricsOrBuilder
        getStepMetricsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Represents an interaction between an end user and a Dialogflow CX agent
   * using V3 (Streaming)DetectIntent API, or an interaction between an end user
   * and a Dialogflow CX agent using V2 (Streaming)AnalyzeContent API.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction}
   */
  public static final class Interaction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction)
      InteractionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Interaction.newBuilder() to construct.
    private Interaction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Interaction() {
      partialResponses_ = java.util.Collections.emptyList();
      requestUtterances_ = "";
      responseUtterances_ = "";
      stepMetrics_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Interaction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.class,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.Builder.class);
    }

    public interface MissingTransitionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Name of the intent that could have triggered.
       * </pre>
       *
       * <code>string intent_display_name = 1;</code>
       *
       * @return The intentDisplayName.
       */
      java.lang.String getIntentDisplayName();
      /**
       *
       *
       * <pre>
       * Name of the intent that could have triggered.
       * </pre>
       *
       * <code>string intent_display_name = 1;</code>
       *
       * @return The bytes for intentDisplayName.
       */
      com.google.protobuf.ByteString getIntentDisplayNameBytes();

      /**
       *
       *
       * <pre>
       * Score of the above intent. The higher it is the more likely a
       * transition was missed on a given page.
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @return The score.
       */
      float getScore();
    }
    /**
     *
     *
     * <pre>
     * Information collected for DF CX agents in case NLU predicted an intent
     * that was filtered out as being inactive which may indicate a missing
     * transition and/or absent functionality.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition}
     */
    public static final class MissingTransition extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition)
        MissingTransitionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MissingTransition.newBuilder() to construct.
      private MissingTransition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MissingTransition() {
        intentDisplayName_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MissingTransition();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_MissingTransition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_MissingTransition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
                    .class,
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
                    .Builder.class);
      }

      public static final int INTENT_DISPLAY_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object intentDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * Name of the intent that could have triggered.
       * </pre>
       *
       * <code>string intent_display_name = 1;</code>
       *
       * @return The intentDisplayName.
       */
      @java.lang.Override
      public java.lang.String getIntentDisplayName() {
        java.lang.Object ref = intentDisplayName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          intentDisplayName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the intent that could have triggered.
       * </pre>
       *
       * <code>string intent_display_name = 1;</code>
       *
       * @return The bytes for intentDisplayName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getIntentDisplayNameBytes() {
        java.lang.Object ref = intentDisplayName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          intentDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SCORE_FIELD_NUMBER = 2;
      private float score_ = 0F;
      /**
       *
       *
       * <pre>
       * Score of the above intent. The higher it is the more likely a
       * transition was missed on a given page.
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public float getScore() {
        return score_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(intentDisplayName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, intentDisplayName_);
        }
        if (java.lang.Float.floatToRawIntBits(score_) != 0) {
          output.writeFloat(2, score_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(intentDisplayName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, intentDisplayName_);
        }
        if (java.lang.Float.floatToRawIntBits(score_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, score_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition other =
            (com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition) obj;

        if (!getIntentDisplayName().equals(other.getIntentDisplayName())) return false;
        if (java.lang.Float.floatToIntBits(getScore())
            != java.lang.Float.floatToIntBits(other.getScore())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + INTENT_DISPLAY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getIntentDisplayName().hashCode();
        hash = (37 * hash) + SCORE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Information collected for DF CX agents in case NLU predicted an intent
       * that was filtered out as being inactive which may indicate a missing
       * transition and/or absent functionality.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition)
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransitionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_MissingTransition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_MissingTransition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
                      .class,
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          intentDisplayName_ = "";
          score_ = 0F;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_MissingTransition_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
            build() {
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition result =
              new com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.intentDisplayName_ = intentDisplayName_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.score_ = score_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
                other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
                  .getDefaultInstance()) return this;
          if (!other.getIntentDisplayName().isEmpty()) {
            intentDisplayName_ = other.intentDisplayName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getScore() != 0F) {
            setScore(other.getScore());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    intentDisplayName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 21:
                  {
                    score_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object intentDisplayName_ = "";
        /**
         *
         *
         * <pre>
         * Name of the intent that could have triggered.
         * </pre>
         *
         * <code>string intent_display_name = 1;</code>
         *
         * @return The intentDisplayName.
         */
        public java.lang.String getIntentDisplayName() {
          java.lang.Object ref = intentDisplayName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            intentDisplayName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of the intent that could have triggered.
         * </pre>
         *
         * <code>string intent_display_name = 1;</code>
         *
         * @return The bytes for intentDisplayName.
         */
        public com.google.protobuf.ByteString getIntentDisplayNameBytes() {
          java.lang.Object ref = intentDisplayName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            intentDisplayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of the intent that could have triggered.
         * </pre>
         *
         * <code>string intent_display_name = 1;</code>
         *
         * @param value The intentDisplayName to set.
         * @return This builder for chaining.
         */
        public Builder setIntentDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          intentDisplayName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Name of the intent that could have triggered.
         * </pre>
         *
         * <code>string intent_display_name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIntentDisplayName() {
          intentDisplayName_ = getDefaultInstance().getIntentDisplayName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Name of the intent that could have triggered.
         * </pre>
         *
         * <code>string intent_display_name = 1;</code>
         *
         * @param value The bytes for intentDisplayName to set.
         * @return This builder for chaining.
         */
        public Builder setIntentDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          intentDisplayName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private float score_;
        /**
         *
         *
         * <pre>
         * Score of the above intent. The higher it is the more likely a
         * transition was missed on a given page.
         * </pre>
         *
         * <code>float score = 2;</code>
         *
         * @return The score.
         */
        @java.lang.Override
        public float getScore() {
          return score_;
        }
        /**
         *
         *
         * <pre>
         * Score of the above intent. The higher it is the more likely a
         * transition was missed on a given page.
         * </pre>
         *
         * <code>float score = 2;</code>
         *
         * @param value The score to set.
         * @return This builder for chaining.
         */
        public Builder setScore(float value) {

          score_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Score of the above intent. The higher it is the more likely a
         * transition was missed on a given page.
         * </pre>
         *
         * <code>float score = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearScore() {
          bitField0_ = (bitField0_ & ~0x00000002);
          score_ = 0F;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransition
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MissingTransition> PARSER =
          new com.google.protobuf.AbstractParser<MissingTransition>() {
            @java.lang.Override
            public MissingTransition parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MissingTransition> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MissingTransition> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface StepMetricsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Name of the request processing step.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      java.lang.String getName();
      /**
       *
       *
       * <pre>
       * Name of the request processing step.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();

      /**
       *
       *
       * <pre>
       * Processing latency of the step.
       * </pre>
       *
       * <code>.google.protobuf.Duration latency = 2;</code>
       *
       * @return Whether the latency field is set.
       */
      boolean hasLatency();
      /**
       *
       *
       * <pre>
       * Processing latency of the step.
       * </pre>
       *
       * <code>.google.protobuf.Duration latency = 2;</code>
       *
       * @return The latency.
       */
      com.google.protobuf.Duration getLatency();
      /**
       *
       *
       * <pre>
       * Processing latency of the step.
       * </pre>
       *
       * <code>.google.protobuf.Duration latency = 2;</code>
       */
      com.google.protobuf.DurationOrBuilder getLatencyOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metrics of each processing step.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics}
     */
    public static final class StepMetrics extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics)
        StepMetricsOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use StepMetrics.newBuilder() to construct.
      private StepMetrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private StepMetrics() {
        name_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new StepMetrics();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_StepMetrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_StepMetrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.class,
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.Builder
                    .class);
      }

      private int bitField0_;
      public static final int NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Name of the request processing step.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the request processing step.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int LATENCY_FIELD_NUMBER = 2;
      private com.google.protobuf.Duration latency_;
      /**
       *
       *
       * <pre>
       * Processing latency of the step.
       * </pre>
       *
       * <code>.google.protobuf.Duration latency = 2;</code>
       *
       * @return Whether the latency field is set.
       */
      @java.lang.Override
      public boolean hasLatency() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Processing latency of the step.
       * </pre>
       *
       * <code>.google.protobuf.Duration latency = 2;</code>
       *
       * @return The latency.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getLatency() {
        return latency_ == null ? com.google.protobuf.Duration.getDefaultInstance() : latency_;
      }
      /**
       *
       *
       * <pre>
       * Processing latency of the step.
       * </pre>
       *
       * <code>.google.protobuf.Duration latency = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getLatencyOrBuilder() {
        return latency_ == null ? com.google.protobuf.Duration.getDefaultInstance() : latency_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getLatency());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLatency());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics other =
            (com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics) obj;

        if (!getName().equals(other.getName())) return false;
        if (hasLatency() != other.hasLatency()) return false;
        if (hasLatency()) {
          if (!getLatency().equals(other.getLatency())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        if (hasLatency()) {
          hash = (37 * hash) + LATENCY_FIELD_NUMBER;
          hash = (53 * hash) + getLatency().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Metrics of each processing step.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics)
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetricsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_StepMetrics_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_StepMetrics_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.class,
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLatencyFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          name_ = "";
          latency_ = null;
          if (latencyBuilder_ != null) {
            latencyBuilder_.dispose();
            latencyBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_StepMetrics_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics build() {
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics result =
              new com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.name_ = name_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.latency_ = latencyBuilder_ == null ? latency_ : latencyBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
                  .getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasLatency()) {
            mergeLatency(other.getLatency());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    name_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getLatencyFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * Name of the request processing step.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of the request processing step.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Name of the request processing step.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Name of the request processing step.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {
          name_ = getDefaultInstance().getName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Name of the request processing step.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Duration latency_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            latencyBuilder_;
        /**
         *
         *
         * <pre>
         * Processing latency of the step.
         * </pre>
         *
         * <code>.google.protobuf.Duration latency = 2;</code>
         *
         * @return Whether the latency field is set.
         */
        public boolean hasLatency() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Processing latency of the step.
         * </pre>
         *
         * <code>.google.protobuf.Duration latency = 2;</code>
         *
         * @return The latency.
         */
        public com.google.protobuf.Duration getLatency() {
          if (latencyBuilder_ == null) {
            return latency_ == null ? com.google.protobuf.Duration.getDefaultInstance() : latency_;
          } else {
            return latencyBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Processing latency of the step.
         * </pre>
         *
         * <code>.google.protobuf.Duration latency = 2;</code>
         */
        public Builder setLatency(com.google.protobuf.Duration value) {
          if (latencyBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            latency_ = value;
          } else {
            latencyBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Processing latency of the step.
         * </pre>
         *
         * <code>.google.protobuf.Duration latency = 2;</code>
         */
        public Builder setLatency(com.google.protobuf.Duration.Builder builderForValue) {
          if (latencyBuilder_ == null) {
            latency_ = builderForValue.build();
          } else {
            latencyBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Processing latency of the step.
         * </pre>
         *
         * <code>.google.protobuf.Duration latency = 2;</code>
         */
        public Builder mergeLatency(com.google.protobuf.Duration value) {
          if (latencyBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && latency_ != null
                && latency_ != com.google.protobuf.Duration.getDefaultInstance()) {
              getLatencyBuilder().mergeFrom(value);
            } else {
              latency_ = value;
            }
          } else {
            latencyBuilder_.mergeFrom(value);
          }
          if (latency_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Processing latency of the step.
         * </pre>
         *
         * <code>.google.protobuf.Duration latency = 2;</code>
         */
        public Builder clearLatency() {
          bitField0_ = (bitField0_ & ~0x00000002);
          latency_ = null;
          if (latencyBuilder_ != null) {
            latencyBuilder_.dispose();
            latencyBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Processing latency of the step.
         * </pre>
         *
         * <code>.google.protobuf.Duration latency = 2;</code>
         */
        public com.google.protobuf.Duration.Builder getLatencyBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getLatencyFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Processing latency of the step.
         * </pre>
         *
         * <code>.google.protobuf.Duration latency = 2;</code>
         */
        public com.google.protobuf.DurationOrBuilder getLatencyOrBuilder() {
          if (latencyBuilder_ != null) {
            return latencyBuilder_.getMessageOrBuilder();
          } else {
            return latency_ == null ? com.google.protobuf.Duration.getDefaultInstance() : latency_;
          }
        }
        /**
         *
         *
         * <pre>
         * Processing latency of the step.
         * </pre>
         *
         * <code>.google.protobuf.Duration latency = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>
            getLatencyFieldBuilder() {
          if (latencyBuilder_ == null) {
            latencyBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Duration,
                    com.google.protobuf.Duration.Builder,
                    com.google.protobuf.DurationOrBuilder>(
                    getLatency(), getParentForChildren(), isClean());
            latency_ = null;
          }
          return latencyBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics)
      private static final com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .StepMetrics
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<StepMetrics> PARSER =
          new com.google.protobuf.AbstractParser<StepMetrics>() {
            @java.lang.Override
            public StepMetrics parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<StepMetrics> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<StepMetrics> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int REQUEST_FIELD_NUMBER = 1;
    private com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request_;
    /**
     *
     *
     * <pre>
     * The request of the interaction.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
     *
     * @return Whether the request field is set.
     */
    @java.lang.Override
    public boolean hasRequest() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The request of the interaction.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
     *
     * @return The request.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest getRequest() {
      return request_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.getDefaultInstance()
          : request_;
    }
    /**
     *
     *
     * <pre>
     * The request of the interaction.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequestOrBuilder
        getRequestOrBuilder() {
      return request_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.getDefaultInstance()
          : request_;
    }

    public static final int RESPONSE_FIELD_NUMBER = 2;
    private com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response_;
    /**
     *
     *
     * <pre>
     * The final response of the interaction.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
     *
     * @return Whether the response field is set.
     */
    @java.lang.Override
    public boolean hasResponse() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The final response of the interaction.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
     *
     * @return The response.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse getResponse() {
      return response_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.getDefaultInstance()
          : response_;
    }
    /**
     *
     *
     * <pre>
     * The final response of the interaction.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder
        getResponseOrBuilder() {
      return response_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.getDefaultInstance()
          : response_;
    }

    public static final int PARTIAL_RESPONSES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse>
        partialResponses_;
    /**
     *
     *
     * <pre>
     * The partial responses of the interaction. Empty if there is no partial
     * response in the interaction.
     * See the
     * [partial response
     * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse>
        getPartialResponsesList() {
      return partialResponses_;
    }
    /**
     *
     *
     * <pre>
     * The partial responses of the interaction. Empty if there is no partial
     * response in the interaction.
     * See the
     * [partial response
     * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder>
        getPartialResponsesOrBuilderList() {
      return partialResponses_;
    }
    /**
     *
     *
     * <pre>
     * The partial responses of the interaction. Empty if there is no partial
     * response in the interaction.
     * See the
     * [partial response
     * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
     * </code>
     */
    @java.lang.Override
    public int getPartialResponsesCount() {
      return partialResponses_.size();
    }
    /**
     *
     *
     * <pre>
     * The partial responses of the interaction. Empty if there is no partial
     * response in the interaction.
     * See the
     * [partial response
     * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse getPartialResponses(
        int index) {
      return partialResponses_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The partial responses of the interaction. Empty if there is no partial
     * response in the interaction.
     * See the
     * [partial response
     * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder
        getPartialResponsesOrBuilder(int index) {
      return partialResponses_.get(index);
    }

    public static final int REQUEST_UTTERANCES_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object requestUtterances_ = "";
    /**
     *
     *
     * <pre>
     * The input text or the transcript of the input audio in the request.
     * </pre>
     *
     * <code>string request_utterances = 4;</code>
     *
     * @return The requestUtterances.
     */
    @java.lang.Override
    public java.lang.String getRequestUtterances() {
      java.lang.Object ref = requestUtterances_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestUtterances_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The input text or the transcript of the input audio in the request.
     * </pre>
     *
     * <code>string request_utterances = 4;</code>
     *
     * @return The bytes for requestUtterances.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRequestUtterancesBytes() {
      java.lang.Object ref = requestUtterances_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestUtterances_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESPONSE_UTTERANCES_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object responseUtterances_ = "";
    /**
     *
     *
     * <pre>
     * The output text or the transcript of the output audio in the responses.
     * If multiple output messages are returned, they will be concatenated into
     * one.
     * </pre>
     *
     * <code>string response_utterances = 5;</code>
     *
     * @return The responseUtterances.
     */
    @java.lang.Override
    public java.lang.String getResponseUtterances() {
      java.lang.Object ref = responseUtterances_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        responseUtterances_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The output text or the transcript of the output audio in the responses.
     * If multiple output messages are returned, they will be concatenated into
     * one.
     * </pre>
     *
     * <code>string response_utterances = 5;</code>
     *
     * @return The bytes for responseUtterances.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResponseUtterancesBytes() {
      java.lang.Object ref = responseUtterances_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        responseUtterances_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CREATE_TIME_FIELD_NUMBER = 6;
    private com.google.protobuf.Timestamp createTime_;
    /**
     *
     *
     * <pre>
     * The time that the interaction was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return Whether the createTime field is set.
     */
    @java.lang.Override
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time that the interaction was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return The createTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getCreateTime() {
      return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
    }
    /**
     *
     *
     * <pre>
     * The time that the interaction was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
    }

    public static final int ANSWER_FEEDBACK_FIELD_NUMBER = 7;
    private com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answerFeedback_;
    /**
     *
     *
     * <pre>
     * Answer feedback for the final response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
     *
     * @return Whether the answerFeedback field is set.
     */
    @java.lang.Override
    public boolean hasAnswerFeedback() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Answer feedback for the final response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
     *
     * @return The answerFeedback.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback getAnswerFeedback() {
      return answerFeedback_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.getDefaultInstance()
          : answerFeedback_;
    }
    /**
     *
     *
     * <pre>
     * Answer feedback for the final response.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedbackOrBuilder
        getAnswerFeedbackOrBuilder() {
      return answerFeedback_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.getDefaultInstance()
          : answerFeedback_;
    }

    public static final int MISSING_TRANSITION_FIELD_NUMBER = 8;
    private com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
        missingTransition_;
    /**
     *
     *
     * <pre>
     * Missing transition predicted for the interaction. This field is set only
     * if the interaction match type was no-match.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
     * </code>
     *
     * @return Whether the missingTransition field is set.
     */
    @java.lang.Override
    public boolean hasMissingTransition() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Missing transition predicted for the interaction. This field is set only
     * if the interaction match type was no-match.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
     * </code>
     *
     * @return The missingTransition.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
        getMissingTransition() {
      return missingTransition_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
              .getDefaultInstance()
          : missingTransition_;
    }
    /**
     *
     *
     * <pre>
     * Missing transition predicted for the interaction. This field is set only
     * if the interaction match type was no-match.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
            .MissingTransitionOrBuilder
        getMissingTransitionOrBuilder() {
      return missingTransition_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
              .getDefaultInstance()
          : missingTransition_;
    }

    public static final int STEP_METRICS_FIELD_NUMBER = 9;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics>
        stepMetrics_;
    /**
     *
     *
     * <pre>
     * Metrics associated with different processing steps. Names and number of
     * steps depend on the request and can change without a notice.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics>
        getStepMetricsList() {
      return stepMetrics_;
    }
    /**
     *
     *
     * <pre>
     * Metrics associated with different processing steps. Names and number of
     * steps depend on the request and can change without a notice.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
                    .StepMetricsOrBuilder>
        getStepMetricsOrBuilderList() {
      return stepMetrics_;
    }
    /**
     *
     *
     * <pre>
     * Metrics associated with different processing steps. Names and number of
     * steps depend on the request and can change without a notice.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
     * </code>
     */
    @java.lang.Override
    public int getStepMetricsCount() {
      return stepMetrics_.size();
    }
    /**
     *
     *
     * <pre>
     * Metrics associated with different processing steps. Names and number of
     * steps depend on the request and can change without a notice.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
        getStepMetrics(int index) {
      return stepMetrics_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Metrics associated with different processing steps. Names and number of
     * steps depend on the request and can change without a notice.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetricsOrBuilder
        getStepMetricsOrBuilder(int index) {
      return stepMetrics_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getRequest());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getResponse());
      }
      for (int i = 0; i < partialResponses_.size(); i++) {
        output.writeMessage(3, partialResponses_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestUtterances_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, requestUtterances_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responseUtterances_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, responseUtterances_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(6, getCreateTime());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(7, getAnswerFeedback());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeMessage(8, getMissingTransition());
      }
      for (int i = 0; i < stepMetrics_.size(); i++) {
        output.writeMessage(9, stepMetrics_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getRequest());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getResponse());
      }
      for (int i = 0; i < partialResponses_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, partialResponses_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestUtterances_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, requestUtterances_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responseUtterances_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, responseUtterances_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getAnswerFeedback());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getMissingTransition());
      }
      for (int i = 0; i < stepMetrics_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, stepMetrics_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction other =
          (com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction) obj;

      if (hasRequest() != other.hasRequest()) return false;
      if (hasRequest()) {
        if (!getRequest().equals(other.getRequest())) return false;
      }
      if (hasResponse() != other.hasResponse()) return false;
      if (hasResponse()) {
        if (!getResponse().equals(other.getResponse())) return false;
      }
      if (!getPartialResponsesList().equals(other.getPartialResponsesList())) return false;
      if (!getRequestUtterances().equals(other.getRequestUtterances())) return false;
      if (!getResponseUtterances().equals(other.getResponseUtterances())) return false;
      if (hasCreateTime() != other.hasCreateTime()) return false;
      if (hasCreateTime()) {
        if (!getCreateTime().equals(other.getCreateTime())) return false;
      }
      if (hasAnswerFeedback() != other.hasAnswerFeedback()) return false;
      if (hasAnswerFeedback()) {
        if (!getAnswerFeedback().equals(other.getAnswerFeedback())) return false;
      }
      if (hasMissingTransition() != other.hasMissingTransition()) return false;
      if (hasMissingTransition()) {
        if (!getMissingTransition().equals(other.getMissingTransition())) return false;
      }
      if (!getStepMetricsList().equals(other.getStepMetricsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRequest()) {
        hash = (37 * hash) + REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getRequest().hashCode();
      }
      if (hasResponse()) {
        hash = (37 * hash) + RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getResponse().hashCode();
      }
      if (getPartialResponsesCount() > 0) {
        hash = (37 * hash) + PARTIAL_RESPONSES_FIELD_NUMBER;
        hash = (53 * hash) + getPartialResponsesList().hashCode();
      }
      hash = (37 * hash) + REQUEST_UTTERANCES_FIELD_NUMBER;
      hash = (53 * hash) + getRequestUtterances().hashCode();
      hash = (37 * hash) + RESPONSE_UTTERANCES_FIELD_NUMBER;
      hash = (53 * hash) + getResponseUtterances().hashCode();
      if (hasCreateTime()) {
        hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getCreateTime().hashCode();
      }
      if (hasAnswerFeedback()) {
        hash = (37 * hash) + ANSWER_FEEDBACK_FIELD_NUMBER;
        hash = (53 * hash) + getAnswerFeedback().hashCode();
      }
      if (hasMissingTransition()) {
        hash = (37 * hash) + MISSING_TRANSITION_FIELD_NUMBER;
        hash = (53 * hash) + getMissingTransition().hashCode();
      }
      if (getStepMetricsCount() > 0) {
        hash = (37 * hash) + STEP_METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getStepMetricsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents an interaction between an end user and a Dialogflow CX agent
     * using V3 (Streaming)DetectIntent API, or an interaction between an end user
     * and a Dialogflow CX agent using V2 (Streaming)AnalyzeContent API.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction)
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.InteractionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.class,
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRequestFieldBuilder();
          getResponseFieldBuilder();
          getPartialResponsesFieldBuilder();
          getCreateTimeFieldBuilder();
          getAnswerFeedbackFieldBuilder();
          getMissingTransitionFieldBuilder();
          getStepMetricsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        request_ = null;
        if (requestBuilder_ != null) {
          requestBuilder_.dispose();
          requestBuilder_ = null;
        }
        response_ = null;
        if (responseBuilder_ != null) {
          responseBuilder_.dispose();
          responseBuilder_ = null;
        }
        if (partialResponsesBuilder_ == null) {
          partialResponses_ = java.util.Collections.emptyList();
        } else {
          partialResponses_ = null;
          partialResponsesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        requestUtterances_ = "";
        responseUtterances_ = "";
        createTime_ = null;
        if (createTimeBuilder_ != null) {
          createTimeBuilder_.dispose();
          createTimeBuilder_ = null;
        }
        answerFeedback_ = null;
        if (answerFeedbackBuilder_ != null) {
          answerFeedbackBuilder_.dispose();
          answerFeedbackBuilder_ = null;
        }
        missingTransition_ = null;
        if (missingTransitionBuilder_ != null) {
          missingTransitionBuilder_.dispose();
          missingTransitionBuilder_ = null;
        }
        if (stepMetricsBuilder_ == null) {
          stepMetrics_ = java.util.Collections.emptyList();
        } else {
          stepMetrics_ = null;
          stepMetricsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_Interaction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction build() {
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction result =
            new com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction result) {
        if (partialResponsesBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            partialResponses_ = java.util.Collections.unmodifiableList(partialResponses_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.partialResponses_ = partialResponses_;
        } else {
          result.partialResponses_ = partialResponsesBuilder_.build();
        }
        if (stepMetricsBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)) {
            stepMetrics_ = java.util.Collections.unmodifiableList(stepMetrics_);
            bitField0_ = (bitField0_ & ~0x00000100);
          }
          result.stepMetrics_ = stepMetrics_;
        } else {
          result.stepMetrics_ = stepMetricsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.request_ = requestBuilder_ == null ? request_ : requestBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.response_ = responseBuilder_ == null ? response_ : responseBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.requestUtterances_ = requestUtterances_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.responseUtterances_ = responseUtterances_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.createTime_ =
              createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.answerFeedback_ =
              answerFeedbackBuilder_ == null ? answerFeedback_ : answerFeedbackBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.missingTransition_ =
              missingTransitionBuilder_ == null
                  ? missingTransition_
                  : missingTransitionBuilder_.build();
          to_bitField0_ |= 0x00000010;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.getDefaultInstance())
          return this;
        if (other.hasRequest()) {
          mergeRequest(other.getRequest());
        }
        if (other.hasResponse()) {
          mergeResponse(other.getResponse());
        }
        if (partialResponsesBuilder_ == null) {
          if (!other.partialResponses_.isEmpty()) {
            if (partialResponses_.isEmpty()) {
              partialResponses_ = other.partialResponses_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensurePartialResponsesIsMutable();
              partialResponses_.addAll(other.partialResponses_);
            }
            onChanged();
          }
        } else {
          if (!other.partialResponses_.isEmpty()) {
            if (partialResponsesBuilder_.isEmpty()) {
              partialResponsesBuilder_.dispose();
              partialResponsesBuilder_ = null;
              partialResponses_ = other.partialResponses_;
              bitField0_ = (bitField0_ & ~0x00000004);
              partialResponsesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPartialResponsesFieldBuilder()
                      : null;
            } else {
              partialResponsesBuilder_.addAllMessages(other.partialResponses_);
            }
          }
        }
        if (!other.getRequestUtterances().isEmpty()) {
          requestUtterances_ = other.requestUtterances_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getResponseUtterances().isEmpty()) {
          responseUtterances_ = other.responseUtterances_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.hasCreateTime()) {
          mergeCreateTime(other.getCreateTime());
        }
        if (other.hasAnswerFeedback()) {
          mergeAnswerFeedback(other.getAnswerFeedback());
        }
        if (other.hasMissingTransition()) {
          mergeMissingTransition(other.getMissingTransition());
        }
        if (stepMetricsBuilder_ == null) {
          if (!other.stepMetrics_.isEmpty()) {
            if (stepMetrics_.isEmpty()) {
              stepMetrics_ = other.stepMetrics_;
              bitField0_ = (bitField0_ & ~0x00000100);
            } else {
              ensureStepMetricsIsMutable();
              stepMetrics_.addAll(other.stepMetrics_);
            }
            onChanged();
          }
        } else {
          if (!other.stepMetrics_.isEmpty()) {
            if (stepMetricsBuilder_.isEmpty()) {
              stepMetricsBuilder_.dispose();
              stepMetricsBuilder_ = null;
              stepMetrics_ = other.stepMetrics_;
              bitField0_ = (bitField0_ & ~0x00000100);
              stepMetricsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getStepMetricsFieldBuilder()
                      : null;
            } else {
              stepMetricsBuilder_.addAllMessages(other.stepMetrics_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getRequestFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getResponseFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.parser(),
                          extensionRegistry);
                  if (partialResponsesBuilder_ == null) {
                    ensurePartialResponsesIsMutable();
                    partialResponses_.add(m);
                  } else {
                    partialResponsesBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              case 34:
                {
                  requestUtterances_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  responseUtterances_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(
                      getAnswerFeedbackFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(
                      getMissingTransitionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 66
              case 74:
                {
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
                              .StepMetrics.parser(),
                          extensionRegistry);
                  if (stepMetricsBuilder_ == null) {
                    ensureStepMetricsIsMutable();
                    stepMetrics_.add(m);
                  } else {
                    stepMetricsBuilder_.addMessage(m);
                  }
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest,
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequestOrBuilder>
          requestBuilder_;
      /**
       *
       *
       * <pre>
       * The request of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
       *
       * @return Whether the request field is set.
       */
      public boolean hasRequest() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The request of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
       *
       * @return The request.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest getRequest() {
        if (requestBuilder_ == null) {
          return request_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.getDefaultInstance()
              : request_;
        } else {
          return requestBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The request of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
       */
      public Builder setRequest(com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest value) {
        if (requestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          request_ = value;
        } else {
          requestBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The request of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
       */
      public Builder setRequest(
          com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.Builder builderForValue) {
        if (requestBuilder_ == null) {
          request_ = builderForValue.build();
        } else {
          requestBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The request of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
       */
      public Builder mergeRequest(
          com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest value) {
        if (requestBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && request_ != null
              && request_
                  != com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest
                      .getDefaultInstance()) {
            getRequestBuilder().mergeFrom(value);
          } else {
            request_ = value;
          }
        } else {
          requestBuilder_.mergeFrom(value);
        }
        if (request_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The request of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
       */
      public Builder clearRequest() {
        bitField0_ = (bitField0_ & ~0x00000001);
        request_ = null;
        if (requestBuilder_ != null) {
          requestBuilder_.dispose();
          requestBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The request of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.Builder
          getRequestBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getRequestFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The request of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequestOrBuilder
          getRequestOrBuilder() {
        if (requestBuilder_ != null) {
          return requestBuilder_.getMessageOrBuilder();
        } else {
          return request_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.getDefaultInstance()
              : request_;
        }
      }
      /**
       *
       *
       * <pre>
       * The request of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest request = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest,
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequestOrBuilder>
          getRequestFieldBuilder() {
        if (requestBuilder_ == null) {
          requestBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest,
                  com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequestOrBuilder>(
                  getRequest(), getParentForChildren(), isClean());
          request_ = null;
        }
        return requestBuilder_;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse,
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder>
          responseBuilder_;
      /**
       *
       *
       * <pre>
       * The final response of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
       *
       * @return Whether the response field is set.
       */
      public boolean hasResponse() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The final response of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
       *
       * @return The response.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse getResponse() {
        if (responseBuilder_ == null) {
          return response_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.getDefaultInstance()
              : response_;
        } else {
          return responseBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The final response of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
       */
      public Builder setResponse(
          com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse value) {
        if (responseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          response_ = value;
        } else {
          responseBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The final response of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
       */
      public Builder setResponse(
          com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder builderForValue) {
        if (responseBuilder_ == null) {
          response_ = builderForValue.build();
        } else {
          responseBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The final response of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
       */
      public Builder mergeResponse(
          com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse value) {
        if (responseBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && response_ != null
              && response_
                  != com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse
                      .getDefaultInstance()) {
            getResponseBuilder().mergeFrom(value);
          } else {
            response_ = value;
          }
        } else {
          responseBuilder_.mergeFrom(value);
        }
        if (response_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The final response of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
       */
      public Builder clearResponse() {
        bitField0_ = (bitField0_ & ~0x00000002);
        response_ = null;
        if (responseBuilder_ != null) {
          responseBuilder_.dispose();
          responseBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The final response of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder
          getResponseBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getResponseFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The final response of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder
          getResponseOrBuilder() {
        if (responseBuilder_ != null) {
          return responseBuilder_.getMessageOrBuilder();
        } else {
          return response_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.getDefaultInstance()
              : response_;
        }
      }
      /**
       *
       *
       * <pre>
       * The final response of the interaction.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse response = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse,
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder>
          getResponseFieldBuilder() {
        if (responseBuilder_ == null) {
          responseBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse,
                  com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder>(
                  getResponse(), getParentForChildren(), isClean());
          response_ = null;
        }
        return responseBuilder_;
      }

      private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse>
          partialResponses_ = java.util.Collections.emptyList();

      private void ensurePartialResponsesIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          partialResponses_ =
              new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse>(
                  partialResponses_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse,
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder>
          partialResponsesBuilder_;

      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse>
          getPartialResponsesList() {
        if (partialResponsesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(partialResponses_);
        } else {
          return partialResponsesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public int getPartialResponsesCount() {
        if (partialResponsesBuilder_ == null) {
          return partialResponses_.size();
        } else {
          return partialResponsesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse getPartialResponses(
          int index) {
        if (partialResponsesBuilder_ == null) {
          return partialResponses_.get(index);
        } else {
          return partialResponsesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public Builder setPartialResponses(
          int index, com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse value) {
        if (partialResponsesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartialResponsesIsMutable();
          partialResponses_.set(index, value);
          onChanged();
        } else {
          partialResponsesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public Builder setPartialResponses(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder builderForValue) {
        if (partialResponsesBuilder_ == null) {
          ensurePartialResponsesIsMutable();
          partialResponses_.set(index, builderForValue.build());
          onChanged();
        } else {
          partialResponsesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public Builder addPartialResponses(
          com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse value) {
        if (partialResponsesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartialResponsesIsMutable();
          partialResponses_.add(value);
          onChanged();
        } else {
          partialResponsesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public Builder addPartialResponses(
          int index, com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse value) {
        if (partialResponsesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartialResponsesIsMutable();
          partialResponses_.add(index, value);
          onChanged();
        } else {
          partialResponsesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public Builder addPartialResponses(
          com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder builderForValue) {
        if (partialResponsesBuilder_ == null) {
          ensurePartialResponsesIsMutable();
          partialResponses_.add(builderForValue.build());
          onChanged();
        } else {
          partialResponsesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public Builder addPartialResponses(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder builderForValue) {
        if (partialResponsesBuilder_ == null) {
          ensurePartialResponsesIsMutable();
          partialResponses_.add(index, builderForValue.build());
          onChanged();
        } else {
          partialResponsesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public Builder addAllPartialResponses(
          java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse>
              values) {
        if (partialResponsesBuilder_ == null) {
          ensurePartialResponsesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialResponses_);
          onChanged();
        } else {
          partialResponsesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public Builder clearPartialResponses() {
        if (partialResponsesBuilder_ == null) {
          partialResponses_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          partialResponsesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public Builder removePartialResponses(int index) {
        if (partialResponsesBuilder_ == null) {
          ensurePartialResponsesIsMutable();
          partialResponses_.remove(index);
          onChanged();
        } else {
          partialResponsesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder
          getPartialResponsesBuilder(int index) {
        return getPartialResponsesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder
          getPartialResponsesOrBuilder(int index) {
        if (partialResponsesBuilder_ == null) {
          return partialResponses_.get(index);
        } else {
          return partialResponsesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder>
          getPartialResponsesOrBuilderList() {
        if (partialResponsesBuilder_ != null) {
          return partialResponsesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(partialResponses_);
        }
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder
          addPartialResponsesBuilder() {
        return getPartialResponsesFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder
          addPartialResponsesBuilder(int index) {
        return getPartialResponsesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The partial responses of the interaction. Empty if there is no partial
       * response in the interaction.
       * See the
       * [partial response
       * documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse partial_responses = 3;
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder>
          getPartialResponsesBuilderList() {
        return getPartialResponsesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse,
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder>
          getPartialResponsesFieldBuilder() {
        if (partialResponsesBuilder_ == null) {
          partialResponsesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse,
                  com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponseOrBuilder>(
                  partialResponses_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          partialResponses_ = null;
        }
        return partialResponsesBuilder_;
      }

      private java.lang.Object requestUtterances_ = "";
      /**
       *
       *
       * <pre>
       * The input text or the transcript of the input audio in the request.
       * </pre>
       *
       * <code>string request_utterances = 4;</code>
       *
       * @return The requestUtterances.
       */
      public java.lang.String getRequestUtterances() {
        java.lang.Object ref = requestUtterances_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          requestUtterances_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The input text or the transcript of the input audio in the request.
       * </pre>
       *
       * <code>string request_utterances = 4;</code>
       *
       * @return The bytes for requestUtterances.
       */
      public com.google.protobuf.ByteString getRequestUtterancesBytes() {
        java.lang.Object ref = requestUtterances_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          requestUtterances_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The input text or the transcript of the input audio in the request.
       * </pre>
       *
       * <code>string request_utterances = 4;</code>
       *
       * @param value The requestUtterances to set.
       * @return This builder for chaining.
       */
      public Builder setRequestUtterances(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestUtterances_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The input text or the transcript of the input audio in the request.
       * </pre>
       *
       * <code>string request_utterances = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequestUtterances() {
        requestUtterances_ = getDefaultInstance().getRequestUtterances();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The input text or the transcript of the input audio in the request.
       * </pre>
       *
       * <code>string request_utterances = 4;</code>
       *
       * @param value The bytes for requestUtterances to set.
       * @return This builder for chaining.
       */
      public Builder setRequestUtterancesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        requestUtterances_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object responseUtterances_ = "";
      /**
       *
       *
       * <pre>
       * The output text or the transcript of the output audio in the responses.
       * If multiple output messages are returned, they will be concatenated into
       * one.
       * </pre>
       *
       * <code>string response_utterances = 5;</code>
       *
       * @return The responseUtterances.
       */
      public java.lang.String getResponseUtterances() {
        java.lang.Object ref = responseUtterances_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          responseUtterances_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The output text or the transcript of the output audio in the responses.
       * If multiple output messages are returned, they will be concatenated into
       * one.
       * </pre>
       *
       * <code>string response_utterances = 5;</code>
       *
       * @return The bytes for responseUtterances.
       */
      public com.google.protobuf.ByteString getResponseUtterancesBytes() {
        java.lang.Object ref = responseUtterances_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          responseUtterances_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The output text or the transcript of the output audio in the responses.
       * If multiple output messages are returned, they will be concatenated into
       * one.
       * </pre>
       *
       * <code>string response_utterances = 5;</code>
       *
       * @param value The responseUtterances to set.
       * @return This builder for chaining.
       */
      public Builder setResponseUtterances(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        responseUtterances_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The output text or the transcript of the output audio in the responses.
       * If multiple output messages are returned, they will be concatenated into
       * one.
       * </pre>
       *
       * <code>string response_utterances = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResponseUtterances() {
        responseUtterances_ = getDefaultInstance().getResponseUtterances();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The output text or the transcript of the output audio in the responses.
       * If multiple output messages are returned, they will be concatenated into
       * one.
       * </pre>
       *
       * <code>string response_utterances = 5;</code>
       *
       * @param value The bytes for responseUtterances to set.
       * @return This builder for chaining.
       */
      public Builder setResponseUtterancesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        responseUtterances_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp createTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          createTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The time that the interaction was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 6;</code>
       *
       * @return Whether the createTime field is set.
       */
      public boolean hasCreateTime() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * The time that the interaction was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 6;</code>
       *
       * @return The createTime.
       */
      public com.google.protobuf.Timestamp getCreateTime() {
        if (createTimeBuilder_ == null) {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        } else {
          return createTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time that the interaction was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 6;</code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          createTime_ = value;
        } else {
          createTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time that the interaction was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 6;</code>
       */
      public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (createTimeBuilder_ == null) {
          createTime_ = builderForValue.build();
        } else {
          createTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time that the interaction was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 6;</code>
       */
      public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
        if (createTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && createTime_ != null
              && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getCreateTimeBuilder().mergeFrom(value);
          } else {
            createTime_ = value;
          }
        } else {
          createTimeBuilder_.mergeFrom(value);
        }
        if (createTime_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time that the interaction was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 6;</code>
       */
      public Builder clearCreateTime() {
        bitField0_ = (bitField0_ & ~0x00000020);
        createTime_ = null;
        if (createTimeBuilder_ != null) {
          createTimeBuilder_.dispose();
          createTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time that the interaction was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 6;</code>
       */
      public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getCreateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time that the interaction was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 6;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
        if (createTimeBuilder_ != null) {
          return createTimeBuilder_.getMessageOrBuilder();
        } else {
          return createTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : createTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time that the interaction was created.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp create_time = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getCreateTimeFieldBuilder() {
        if (createTimeBuilder_ == null) {
          createTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getCreateTime(), getParentForChildren(), isClean());
          createTime_ = null;
        }
        return createTimeBuilder_;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answerFeedback_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback,
              com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedbackOrBuilder>
          answerFeedbackBuilder_;
      /**
       *
       *
       * <pre>
       * Answer feedback for the final response.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
       *
       * @return Whether the answerFeedback field is set.
       */
      public boolean hasAnswerFeedback() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Answer feedback for the final response.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
       *
       * @return The answerFeedback.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback getAnswerFeedback() {
        if (answerFeedbackBuilder_ == null) {
          return answerFeedback_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.getDefaultInstance()
              : answerFeedback_;
        } else {
          return answerFeedbackBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Answer feedback for the final response.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
       */
      public Builder setAnswerFeedback(
          com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback value) {
        if (answerFeedbackBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          answerFeedback_ = value;
        } else {
          answerFeedbackBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Answer feedback for the final response.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
       */
      public Builder setAnswerFeedback(
          com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Builder builderForValue) {
        if (answerFeedbackBuilder_ == null) {
          answerFeedback_ = builderForValue.build();
        } else {
          answerFeedbackBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Answer feedback for the final response.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
       */
      public Builder mergeAnswerFeedback(
          com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback value) {
        if (answerFeedbackBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && answerFeedback_ != null
              && answerFeedback_
                  != com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.getDefaultInstance()) {
            getAnswerFeedbackBuilder().mergeFrom(value);
          } else {
            answerFeedback_ = value;
          }
        } else {
          answerFeedbackBuilder_.mergeFrom(value);
        }
        if (answerFeedback_ != null) {
          bitField0_ |= 0x00000040;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Answer feedback for the final response.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
       */
      public Builder clearAnswerFeedback() {
        bitField0_ = (bitField0_ & ~0x00000040);
        answerFeedback_ = null;
        if (answerFeedbackBuilder_ != null) {
          answerFeedbackBuilder_.dispose();
          answerFeedbackBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Answer feedback for the final response.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Builder
          getAnswerFeedbackBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getAnswerFeedbackFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Answer feedback for the final response.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedbackOrBuilder
          getAnswerFeedbackOrBuilder() {
        if (answerFeedbackBuilder_ != null) {
          return answerFeedbackBuilder_.getMessageOrBuilder();
        } else {
          return answerFeedback_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.getDefaultInstance()
              : answerFeedback_;
        }
      }
      /**
       *
       *
       * <pre>
       * Answer feedback for the final response.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback answer_feedback = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback,
              com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedbackOrBuilder>
          getAnswerFeedbackFieldBuilder() {
        if (answerFeedbackBuilder_ == null) {
          answerFeedbackBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback,
                  com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedbackOrBuilder>(
                  getAnswerFeedback(), getParentForChildren(), isClean());
          answerFeedback_ = null;
        }
        return answerFeedbackBuilder_;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
          missingTransition_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
                  .Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
                  .MissingTransitionOrBuilder>
          missingTransitionBuilder_;
      /**
       *
       *
       * <pre>
       * Missing transition predicted for the interaction. This field is set only
       * if the interaction match type was no-match.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
       * </code>
       *
       * @return Whether the missingTransition field is set.
       */
      public boolean hasMissingTransition() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Missing transition predicted for the interaction. This field is set only
       * if the interaction match type was no-match.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
       * </code>
       *
       * @return The missingTransition.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
          getMissingTransition() {
        if (missingTransitionBuilder_ == null) {
          return missingTransition_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
                  .getDefaultInstance()
              : missingTransition_;
        } else {
          return missingTransitionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Missing transition predicted for the interaction. This field is set only
       * if the interaction match type was no-match.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
       * </code>
       */
      public Builder setMissingTransition(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition value) {
        if (missingTransitionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          missingTransition_ = value;
        } else {
          missingTransitionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Missing transition predicted for the interaction. This field is set only
       * if the interaction match type was no-match.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
       * </code>
       */
      public Builder setMissingTransition(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition.Builder
              builderForValue) {
        if (missingTransitionBuilder_ == null) {
          missingTransition_ = builderForValue.build();
        } else {
          missingTransitionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Missing transition predicted for the interaction. This field is set only
       * if the interaction match type was no-match.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
       * </code>
       */
      public Builder mergeMissingTransition(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition value) {
        if (missingTransitionBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && missingTransition_ != null
              && missingTransition_
                  != com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
                      .MissingTransition.getDefaultInstance()) {
            getMissingTransitionBuilder().mergeFrom(value);
          } else {
            missingTransition_ = value;
          }
        } else {
          missingTransitionBuilder_.mergeFrom(value);
        }
        if (missingTransition_ != null) {
          bitField0_ |= 0x00000080;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Missing transition predicted for the interaction. This field is set only
       * if the interaction match type was no-match.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
       * </code>
       */
      public Builder clearMissingTransition() {
        bitField0_ = (bitField0_ & ~0x00000080);
        missingTransition_ = null;
        if (missingTransitionBuilder_ != null) {
          missingTransitionBuilder_.dispose();
          missingTransitionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Missing transition predicted for the interaction. This field is set only
       * if the interaction match type was no-match.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
              .Builder
          getMissingTransitionBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getMissingTransitionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Missing transition predicted for the interaction. This field is set only
       * if the interaction match type was no-match.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
              .MissingTransitionOrBuilder
          getMissingTransitionOrBuilder() {
        if (missingTransitionBuilder_ != null) {
          return missingTransitionBuilder_.getMessageOrBuilder();
        } else {
          return missingTransition_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
                  .getDefaultInstance()
              : missingTransition_;
        }
      }
      /**
       *
       *
       * <pre>
       * Missing transition predicted for the interaction. This field is set only
       * if the interaction match type was no-match.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition missing_transition = 8;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
                  .Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
                  .MissingTransitionOrBuilder>
          getMissingTransitionFieldBuilder() {
        if (missingTransitionBuilder_ == null) {
          missingTransitionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition,
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
                      .Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
                      .MissingTransitionOrBuilder>(
                  getMissingTransition(), getParentForChildren(), isClean());
          missingTransition_ = null;
        }
        return missingTransitionBuilder_;
      }

      private java.util.List<
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics>
          stepMetrics_ = java.util.Collections.emptyList();

      private void ensureStepMetricsIsMutable() {
        if (!((bitField0_ & 0x00000100) != 0)) {
          stepMetrics_ =
              new java.util.ArrayList<
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics>(
                  stepMetrics_);
          bitField0_ |= 0x00000100;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetricsOrBuilder>
          stepMetricsBuilder_;

      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics>
          getStepMetricsList() {
        if (stepMetricsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(stepMetrics_);
        } else {
          return stepMetricsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public int getStepMetricsCount() {
        if (stepMetricsBuilder_ == null) {
          return stepMetrics_.size();
        } else {
          return stepMetricsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
          getStepMetrics(int index) {
        if (stepMetricsBuilder_ == null) {
          return stepMetrics_.get(index);
        } else {
          return stepMetricsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public Builder setStepMetrics(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics value) {
        if (stepMetricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStepMetricsIsMutable();
          stepMetrics_.set(index, value);
          onChanged();
        } else {
          stepMetricsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public Builder setStepMetrics(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.Builder
              builderForValue) {
        if (stepMetricsBuilder_ == null) {
          ensureStepMetricsIsMutable();
          stepMetrics_.set(index, builderForValue.build());
          onChanged();
        } else {
          stepMetricsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public Builder addStepMetrics(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics value) {
        if (stepMetricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStepMetricsIsMutable();
          stepMetrics_.add(value);
          onChanged();
        } else {
          stepMetricsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public Builder addStepMetrics(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics value) {
        if (stepMetricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStepMetricsIsMutable();
          stepMetrics_.add(index, value);
          onChanged();
        } else {
          stepMetricsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public Builder addStepMetrics(
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.Builder
              builderForValue) {
        if (stepMetricsBuilder_ == null) {
          ensureStepMetricsIsMutable();
          stepMetrics_.add(builderForValue.build());
          onChanged();
        } else {
          stepMetricsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public Builder addStepMetrics(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.Builder
              builderForValue) {
        if (stepMetricsBuilder_ == null) {
          ensureStepMetricsIsMutable();
          stepMetrics_.add(index, builderForValue.build());
          onChanged();
        } else {
          stepMetricsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public Builder addAllStepMetrics(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics>
              values) {
        if (stepMetricsBuilder_ == null) {
          ensureStepMetricsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stepMetrics_);
          onChanged();
        } else {
          stepMetricsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public Builder clearStepMetrics() {
        if (stepMetricsBuilder_ == null) {
          stepMetrics_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000100);
          onChanged();
        } else {
          stepMetricsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public Builder removeStepMetrics(int index) {
        if (stepMetricsBuilder_ == null) {
          ensureStepMetricsIsMutable();
          stepMetrics_.remove(index);
          onChanged();
        } else {
          stepMetricsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.Builder
          getStepMetricsBuilder(int index) {
        return getStepMetricsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetricsOrBuilder
          getStepMetricsOrBuilder(int index) {
        if (stepMetricsBuilder_ == null) {
          return stepMetrics_.get(index);
        } else {
          return stepMetricsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
                      .StepMetricsOrBuilder>
          getStepMetricsOrBuilderList() {
        if (stepMetricsBuilder_ != null) {
          return stepMetricsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(stepMetrics_);
        }
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.Builder
          addStepMetricsBuilder() {
        return getStepMetricsFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.Builder
          addStepMetricsBuilder(int index) {
        return getStepMetricsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Metrics associated with different processing steps. Names and number of
       * steps depend on the request and can change without a notice.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics step_metrics = 9;
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.Builder>
          getStepMetricsBuilderList() {
        return getStepMetricsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetricsOrBuilder>
          getStepMetricsFieldBuilder() {
        if (stepMetricsBuilder_ == null) {
          stepMetricsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics,
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.StepMetrics
                      .Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
                      .StepMetricsOrBuilder>(
                  stepMetrics_,
                  ((bitField0_ & 0x00000100) != 0),
                  getParentForChildren(),
                  isClean());
          stepMetrics_ = null;
        }
        return stepMetricsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Interaction> PARSER =
        new com.google.protobuf.AbstractParser<Interaction>() {
          @java.lang.Override
          public Interaction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Interaction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Interaction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. The identifier of the conversation.
   * If conversation ID is reused, interactions happened later than 48 hours of
   * the conversation's create time will be ignored. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/conversations/&lt;ConversationID&gt;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. The identifier of the conversation.
   * If conversation ID is reused, interactions happened later than 48 hours of
   * the conversation's create time will be ignored. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/conversations/&lt;ConversationID&gt;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * The type of the conversation.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Type type = 2;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The type of the conversation.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Type type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Type getType() {
    com.google.cloud.dialogflow.cx.v3beta1.Conversation.Type result =
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Type.forNumber(type_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Type.UNRECOGNIZED
        : result;
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * The language of the conversation, which is the language of the first
   * request in the conversation.
   * </pre>
   *
   * <code>string language_code = 3;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The language of the conversation, which is the language of the first
   * request in the conversation.
   * </pre>
   *
   * <code>string language_code = 3;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Start time of the conversation, which is the time of the first request of
   * the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Start time of the conversation, which is the time of the first request of
   * the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Start time of the conversation, which is the time of the first request of
   * the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int DURATION_FIELD_NUMBER = 5;
  private com.google.protobuf.Duration duration_;
  /**
   *
   *
   * <pre>
   * Duration of the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 5;</code>
   *
   * @return Whether the duration field is set.
   */
  @java.lang.Override
  public boolean hasDuration() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Duration of the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 5;</code>
   *
   * @return The duration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDuration() {
    return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
  }
  /**
   *
   *
   * <pre>
   * Duration of the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
    return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
  }

  public static final int METRICS_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics_;
  /**
   *
   *
   * <pre>
   * Conversation metrics.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
   *
   * @return Whether the metrics field is set.
   */
  @java.lang.Override
  public boolean hasMetrics() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Conversation metrics.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
   *
   * @return The metrics.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics getMetrics() {
    return metrics_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.getDefaultInstance()
        : metrics_;
  }
  /**
   *
   *
   * <pre>
   * Conversation metrics.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Conversation.MetricsOrBuilder
      getMetricsOrBuilder() {
    return metrics_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.getDefaultInstance()
        : metrics_;
  }

  public static final int INTENTS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent> intents_;
  /**
   *
   *
   * <pre>
   * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
   * conversation. Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent> getIntentsList() {
    return intents_;
  }
  /**
   *
   *
   * <pre>
   * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
   * conversation. Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.IntentOrBuilder>
      getIntentsOrBuilderList() {
    return intents_;
  }
  /**
   *
   *
   * <pre>
   * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
   * conversation. Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
   */
  @java.lang.Override
  public int getIntentsCount() {
    return intents_.size();
  }
  /**
   *
   *
   * <pre>
   * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
   * conversation. Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Intent getIntents(int index) {
    return intents_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
   * conversation. Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.IntentOrBuilder getIntentsOrBuilder(int index) {
    return intents_.get(index);
  }

  public static final int FLOWS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Flow> flows_;
  /**
   *
   *
   * <pre>
   * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Flow> getFlowsList() {
    return flows_;
  }
  /**
   *
   *
   * <pre>
   * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.FlowOrBuilder>
      getFlowsOrBuilderList() {
    return flows_;
  }
  /**
   *
   *
   * <pre>
   * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
   */
  @java.lang.Override
  public int getFlowsCount() {
    return flows_.size();
  }
  /**
   *
   *
   * <pre>
   * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Flow getFlows(int index) {
    return flows_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.FlowOrBuilder getFlowsOrBuilder(int index) {
    return flows_.get(index);
  }

  public static final int PAGES_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Page> pages_;
  /**
   *
   *
   * <pre>
   * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Page> getPagesList() {
    return pages_;
  }
  /**
   *
   *
   * <pre>
   * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder>
      getPagesOrBuilderList() {
    return pages_;
  }
  /**
   *
   *
   * <pre>
   * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
   */
  @java.lang.Override
  public int getPagesCount() {
    return pages_.size();
  }
  /**
   *
   *
   * <pre>
   * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Page getPages(int index) {
    return pages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
   * has went through. Only `name` and `display_name` are filled in this
   * message.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder getPagesOrBuilder(int index) {
    return pages_.get(index);
  }

  public static final int INTERACTIONS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction>
      interactions_;
  /**
   *
   *
   * <pre>
   * Interactions of the conversation.
   * Only populated for `GetConversation` and empty for `ListConversations`.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction>
      getInteractionsList() {
    return interactions_;
  }
  /**
   *
   *
   * <pre>
   * Interactions of the conversation.
   * Only populated for `GetConversation` and empty for `ListConversations`.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3beta1.Conversation.InteractionOrBuilder>
      getInteractionsOrBuilderList() {
    return interactions_;
  }
  /**
   *
   *
   * <pre>
   * Interactions of the conversation.
   * Only populated for `GetConversation` and empty for `ListConversations`.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
   * </code>
   */
  @java.lang.Override
  public int getInteractionsCount() {
    return interactions_.size();
  }
  /**
   *
   *
   * <pre>
   * Interactions of the conversation.
   * Only populated for `GetConversation` and empty for `ListConversations`.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction getInteractions(
      int index) {
    return interactions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Interactions of the conversation.
   * Only populated for `GetConversation` and empty for `ListConversations`.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Conversation.InteractionOrBuilder
      getInteractionsOrBuilder(int index) {
    return interactions_.get(index);
  }

  public static final int ENVIRONMENT_FIELD_NUMBER = 11;
  private com.google.cloud.dialogflow.cx.v3beta1.Environment environment_;
  /**
   *
   *
   * <pre>
   * Environment of the conversation.
   * Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
   *
   * @return Whether the environment field is set.
   */
  @java.lang.Override
  public boolean hasEnvironment() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Environment of the conversation.
   * Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
   *
   * @return The environment.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Environment getEnvironment() {
    return environment_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Environment.getDefaultInstance()
        : environment_;
  }
  /**
   *
   *
   * <pre>
   * Environment of the conversation.
   * Only `name` and `display_name` are filled in this message.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.EnvironmentOrBuilder getEnvironmentOrBuilder() {
    return environment_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.Environment.getDefaultInstance()
        : environment_;
  }

  public static final int FLOW_VERSIONS_FIELD_NUMBER = 12;

  private static final class FlowVersionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Long>newDefaultInstance(
            com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
                .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_FlowVersionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.INT64,
            0L);
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Long> flowVersions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Long> internalGetFlowVersions() {
    if (flowVersions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          FlowVersionsDefaultEntryHolder.defaultEntry);
    }
    return flowVersions_;
  }

  public int getFlowVersionsCount() {
    return internalGetFlowVersions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Flow versions used in the conversation.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
   */
  @java.lang.Override
  public boolean containsFlowVersions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetFlowVersions().getMap().containsKey(key);
  }
  /** Use {@link #getFlowVersionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Long> getFlowVersions() {
    return getFlowVersionsMap();
  }
  /**
   *
   *
   * <pre>
   * Flow versions used in the conversation.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Long> getFlowVersionsMap() {
    return internalGetFlowVersions().getMap();
  }
  /**
   *
   *
   * <pre>
   * Flow versions used in the conversation.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
   */
  @java.lang.Override
  public long getFlowVersionsOrDefault(java.lang.String key, long defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Long> map = internalGetFlowVersions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Flow versions used in the conversation.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
   */
  @java.lang.Override
  public long getFlowVersionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Long> map = internalGetFlowVersions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (type_
        != com.google.cloud.dialogflow.cx.v3beta1.Conversation.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, languageCode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getDuration());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getMetrics());
    }
    for (int i = 0; i < intents_.size(); i++) {
      output.writeMessage(7, intents_.get(i));
    }
    for (int i = 0; i < flows_.size(); i++) {
      output.writeMessage(8, flows_.get(i));
    }
    for (int i = 0; i < pages_.size(); i++) {
      output.writeMessage(9, pages_.get(i));
    }
    for (int i = 0; i < interactions_.size(); i++) {
      output.writeMessage(10, interactions_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(11, getEnvironment());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetFlowVersions(), FlowVersionsDefaultEntryHolder.defaultEntry, 12);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (type_
        != com.google.cloud.dialogflow.cx.v3beta1.Conversation.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, languageCode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDuration());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMetrics());
    }
    for (int i = 0; i < intents_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, intents_.get(i));
    }
    for (int i = 0; i < flows_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, flows_.get(i));
    }
    for (int i = 0; i < pages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, pages_.get(i));
    }
    for (int i = 0; i < interactions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, interactions_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getEnvironment());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Long> entry :
        internalGetFlowVersions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> flowVersions__ =
          FlowVersionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, flowVersions__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Conversation)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.Conversation other =
        (com.google.cloud.dialogflow.cx.v3beta1.Conversation) obj;

    if (!getName().equals(other.getName())) return false;
    if (type_ != other.type_) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasDuration() != other.hasDuration()) return false;
    if (hasDuration()) {
      if (!getDuration().equals(other.getDuration())) return false;
    }
    if (hasMetrics() != other.hasMetrics()) return false;
    if (hasMetrics()) {
      if (!getMetrics().equals(other.getMetrics())) return false;
    }
    if (!getIntentsList().equals(other.getIntentsList())) return false;
    if (!getFlowsList().equals(other.getFlowsList())) return false;
    if (!getPagesList().equals(other.getPagesList())) return false;
    if (!getInteractionsList().equals(other.getInteractionsList())) return false;
    if (hasEnvironment() != other.hasEnvironment()) return false;
    if (hasEnvironment()) {
      if (!getEnvironment().equals(other.getEnvironment())) return false;
    }
    if (!internalGetFlowVersions().equals(other.internalGetFlowVersions())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasDuration()) {
      hash = (37 * hash) + DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getDuration().hashCode();
    }
    if (hasMetrics()) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetrics().hashCode();
    }
    if (getIntentsCount() > 0) {
      hash = (37 * hash) + INTENTS_FIELD_NUMBER;
      hash = (53 * hash) + getIntentsList().hashCode();
    }
    if (getFlowsCount() > 0) {
      hash = (37 * hash) + FLOWS_FIELD_NUMBER;
      hash = (53 * hash) + getFlowsList().hashCode();
    }
    if (getPagesCount() > 0) {
      hash = (37 * hash) + PAGES_FIELD_NUMBER;
      hash = (53 * hash) + getPagesList().hashCode();
    }
    if (getInteractionsCount() > 0) {
      hash = (37 * hash) + INTERACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getInteractionsList().hashCode();
    }
    if (hasEnvironment()) {
      hash = (37 * hash) + ENVIRONMENT_FIELD_NUMBER;
      hash = (53 * hash) + getEnvironment().hashCode();
    }
    if (!internalGetFlowVersions().getMap().isEmpty()) {
      hash = (37 * hash) + FLOW_VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetFlowVersions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.Conversation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a conversation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Conversation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Conversation)
      com.google.cloud.dialogflow.cx.v3beta1.ConversationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetFlowVersions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetMutableFlowVersions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.class,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.Conversation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getDurationFieldBuilder();
        getMetricsFieldBuilder();
        getIntentsFieldBuilder();
        getFlowsFieldBuilder();
        getPagesFieldBuilder();
        getInteractionsFieldBuilder();
        getEnvironmentFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = 0;
      languageCode_ = "";
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      duration_ = null;
      if (durationBuilder_ != null) {
        durationBuilder_.dispose();
        durationBuilder_ = null;
      }
      metrics_ = null;
      if (metricsBuilder_ != null) {
        metricsBuilder_.dispose();
        metricsBuilder_ = null;
      }
      if (intentsBuilder_ == null) {
        intents_ = java.util.Collections.emptyList();
      } else {
        intents_ = null;
        intentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (flowsBuilder_ == null) {
        flows_ = java.util.Collections.emptyList();
      } else {
        flows_ = null;
        flowsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      if (pagesBuilder_ == null) {
        pages_ = java.util.Collections.emptyList();
      } else {
        pages_ = null;
        pagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      if (interactionsBuilder_ == null) {
        interactions_ = java.util.Collections.emptyList();
      } else {
        interactions_ = null;
        interactionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      environment_ = null;
      if (environmentBuilder_ != null) {
        environmentBuilder_.dispose();
        environmentBuilder_ = null;
      }
      internalGetMutableFlowVersions().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Conversation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.Conversation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation build() {
      com.google.cloud.dialogflow.cx.v3beta1.Conversation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.Conversation result =
          new com.google.cloud.dialogflow.cx.v3beta1.Conversation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3beta1.Conversation result) {
      if (intentsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          intents_ = java.util.Collections.unmodifiableList(intents_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.intents_ = intents_;
      } else {
        result.intents_ = intentsBuilder_.build();
      }
      if (flowsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          flows_ = java.util.Collections.unmodifiableList(flows_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.flows_ = flows_;
      } else {
        result.flows_ = flowsBuilder_.build();
      }
      if (pagesBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          pages_ = java.util.Collections.unmodifiableList(pages_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.pages_ = pages_;
      } else {
        result.pages_ = pagesBuilder_.build();
      }
      if (interactionsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          interactions_ = java.util.Collections.unmodifiableList(interactions_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.interactions_ = interactions_;
      } else {
        result.interactions_ = interactionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Conversation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.languageCode_ = languageCode_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.metrics_ = metricsBuilder_ == null ? metrics_ : metricsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.environment_ =
            environmentBuilder_ == null ? environment_ : environmentBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.flowVersions_ = internalGetFlowVersions();
        result.flowVersions_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Conversation) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Conversation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Conversation other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.Conversation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasDuration()) {
        mergeDuration(other.getDuration());
      }
      if (other.hasMetrics()) {
        mergeMetrics(other.getMetrics());
      }
      if (intentsBuilder_ == null) {
        if (!other.intents_.isEmpty()) {
          if (intents_.isEmpty()) {
            intents_ = other.intents_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureIntentsIsMutable();
            intents_.addAll(other.intents_);
          }
          onChanged();
        }
      } else {
        if (!other.intents_.isEmpty()) {
          if (intentsBuilder_.isEmpty()) {
            intentsBuilder_.dispose();
            intentsBuilder_ = null;
            intents_ = other.intents_;
            bitField0_ = (bitField0_ & ~0x00000040);
            intentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIntentsFieldBuilder()
                    : null;
          } else {
            intentsBuilder_.addAllMessages(other.intents_);
          }
        }
      }
      if (flowsBuilder_ == null) {
        if (!other.flows_.isEmpty()) {
          if (flows_.isEmpty()) {
            flows_ = other.flows_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureFlowsIsMutable();
            flows_.addAll(other.flows_);
          }
          onChanged();
        }
      } else {
        if (!other.flows_.isEmpty()) {
          if (flowsBuilder_.isEmpty()) {
            flowsBuilder_.dispose();
            flowsBuilder_ = null;
            flows_ = other.flows_;
            bitField0_ = (bitField0_ & ~0x00000080);
            flowsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFlowsFieldBuilder()
                    : null;
          } else {
            flowsBuilder_.addAllMessages(other.flows_);
          }
        }
      }
      if (pagesBuilder_ == null) {
        if (!other.pages_.isEmpty()) {
          if (pages_.isEmpty()) {
            pages_ = other.pages_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensurePagesIsMutable();
            pages_.addAll(other.pages_);
          }
          onChanged();
        }
      } else {
        if (!other.pages_.isEmpty()) {
          if (pagesBuilder_.isEmpty()) {
            pagesBuilder_.dispose();
            pagesBuilder_ = null;
            pages_ = other.pages_;
            bitField0_ = (bitField0_ & ~0x00000100);
            pagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPagesFieldBuilder()
                    : null;
          } else {
            pagesBuilder_.addAllMessages(other.pages_);
          }
        }
      }
      if (interactionsBuilder_ == null) {
        if (!other.interactions_.isEmpty()) {
          if (interactions_.isEmpty()) {
            interactions_ = other.interactions_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureInteractionsIsMutable();
            interactions_.addAll(other.interactions_);
          }
          onChanged();
        }
      } else {
        if (!other.interactions_.isEmpty()) {
          if (interactionsBuilder_.isEmpty()) {
            interactionsBuilder_.dispose();
            interactionsBuilder_ = null;
            interactions_ = other.interactions_;
            bitField0_ = (bitField0_ & ~0x00000200);
            interactionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInteractionsFieldBuilder()
                    : null;
          } else {
            interactionsBuilder_.addAllMessages(other.interactions_);
          }
        }
      }
      if (other.hasEnvironment()) {
        mergeEnvironment(other.getEnvironment());
      }
      internalGetMutableFlowVersions().mergeFrom(other.internalGetFlowVersions());
      bitField0_ |= 0x00000800;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getMetricsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.dialogflow.cx.v3beta1.Intent m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.Intent.parser(), extensionRegistry);
                if (intentsBuilder_ == null) {
                  ensureIntentsIsMutable();
                  intents_.add(m);
                } else {
                  intentsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.dialogflow.cx.v3beta1.Flow m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.Flow.parser(), extensionRegistry);
                if (flowsBuilder_ == null) {
                  ensureFlowsIsMutable();
                  flows_.add(m);
                } else {
                  flowsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.dialogflow.cx.v3beta1.Page m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.Page.parser(), extensionRegistry);
                if (pagesBuilder_ == null) {
                  ensurePagesIsMutable();
                  pages_.add(m);
                } else {
                  pagesBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.parser(),
                        extensionRegistry);
                if (interactionsBuilder_ == null) {
                  ensureInteractionsIsMutable();
                  interactions_.add(m);
                } else {
                  interactionsBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getEnvironmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> flowVersions__ =
                    input.readMessage(
                        FlowVersionsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableFlowVersions()
                    .getMutableMap()
                    .put(flowVersions__.getKey(), flowVersions__.getValue());
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. The identifier of the conversation.
     * If conversation ID is reused, interactions happened later than 48 hours of
     * the conversation's create time will be ignored. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/conversations/&lt;ConversationID&gt;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The identifier of the conversation.
     * If conversation ID is reused, interactions happened later than 48 hours of
     * the conversation's create time will be ignored. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/conversations/&lt;ConversationID&gt;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The identifier of the conversation.
     * If conversation ID is reused, interactions happened later than 48 hours of
     * the conversation's create time will be ignored. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/conversations/&lt;ConversationID&gt;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The identifier of the conversation.
     * If conversation ID is reused, interactions happened later than 48 hours of
     * the conversation's create time will be ignored. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/conversations/&lt;ConversationID&gt;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The identifier of the conversation.
     * If conversation ID is reused, interactions happened later than 48 hours of
     * the conversation's create time will be ignored. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/conversations/&lt;ConversationID&gt;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Type type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of the conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Type type = 2;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Type type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Type getType() {
      com.google.cloud.dialogflow.cx.v3beta1.Conversation.Type result =
          com.google.cloud.dialogflow.cx.v3beta1.Conversation.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Type type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.dialogflow.cx.v3beta1.Conversation.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Type type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * The language of the conversation, which is the language of the first
     * request in the conversation.
     * </pre>
     *
     * <code>string language_code = 3;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language of the conversation, which is the language of the first
     * request in the conversation.
     * </pre>
     *
     * <code>string language_code = 3;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language of the conversation, which is the language of the first
     * request in the conversation.
     * </pre>
     *
     * <code>string language_code = 3;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language of the conversation, which is the language of the first
     * request in the conversation.
     * </pre>
     *
     * <code>string language_code = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language of the conversation, which is the language of the first
     * request in the conversation.
     * </pre>
     *
     * <code>string language_code = 3;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Start time of the conversation, which is the time of the first request of
     * the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Start time of the conversation, which is the time of the first request of
     * the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Start time of the conversation, which is the time of the first request of
     * the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time of the conversation, which is the time of the first request of
     * the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time of the conversation, which is the time of the first request of
     * the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time of the conversation, which is the time of the first request of
     * the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time of the conversation, which is the time of the first request of
     * the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Start time of the conversation, which is the time of the first request of
     * the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Start time of the conversation, which is the time of the first request of
     * the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Duration duration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        durationBuilder_;
    /**
     *
     *
     * <pre>
     * Duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     *
     * @return Whether the duration field is set.
     */
    public boolean hasDuration() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     *
     * @return The duration.
     */
    public com.google.protobuf.Duration getDuration() {
      if (durationBuilder_ == null) {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      } else {
        return durationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     */
    public Builder setDuration(com.google.protobuf.Duration value) {
      if (durationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        duration_ = value;
      } else {
        durationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     */
    public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (durationBuilder_ == null) {
        duration_ = builderForValue.build();
      } else {
        durationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     */
    public Builder mergeDuration(com.google.protobuf.Duration value) {
      if (durationBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && duration_ != null
            && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getDurationBuilder().mergeFrom(value);
        } else {
          duration_ = value;
        }
      } else {
        durationBuilder_.mergeFrom(value);
      }
      if (duration_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     */
    public Builder clearDuration() {
      bitField0_ = (bitField0_ & ~0x00000010);
      duration_ = null;
      if (durationBuilder_ != null) {
        durationBuilder_.dispose();
        durationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     */
    public com.google.protobuf.Duration.Builder getDurationBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     */
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      if (durationBuilder_ != null) {
        return durationBuilder_.getMessageOrBuilder();
      } else {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDurationFieldBuilder() {
      if (durationBuilder_ == null) {
        durationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDuration(), getParentForChildren(), isClean());
        duration_ = null;
      }
      return durationBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics,
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.MetricsOrBuilder>
        metricsBuilder_;
    /**
     *
     *
     * <pre>
     * Conversation metrics.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
     *
     * @return Whether the metrics field is set.
     */
    public boolean hasMetrics() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Conversation metrics.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
     *
     * @return The metrics.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics getMetrics() {
      if (metricsBuilder_ == null) {
        return metrics_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.getDefaultInstance()
            : metrics_;
      } else {
        return metricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Conversation metrics.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
     */
    public Builder setMetrics(com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
      } else {
        metricsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conversation metrics.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
     */
    public Builder setMetrics(
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        metrics_ = builderForValue.build();
      } else {
        metricsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conversation metrics.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
     */
    public Builder mergeMetrics(com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics value) {
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && metrics_ != null
            && metrics_
                != com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics
                    .getDefaultInstance()) {
          getMetricsBuilder().mergeFrom(value);
        } else {
          metrics_ = value;
        }
      } else {
        metricsBuilder_.mergeFrom(value);
      }
      if (metrics_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conversation metrics.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
     */
    public Builder clearMetrics() {
      bitField0_ = (bitField0_ & ~0x00000020);
      metrics_ = null;
      if (metricsBuilder_ != null) {
        metricsBuilder_.dispose();
        metricsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conversation metrics.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.Builder getMetricsBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Conversation metrics.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.MetricsOrBuilder
        getMetricsOrBuilder() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilder();
      } else {
        return metrics_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.getDefaultInstance()
            : metrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Conversation metrics.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics metrics = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics,
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.MetricsOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics,
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.MetricsOrBuilder>(
                getMetrics(), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent> intents_ =
        java.util.Collections.emptyList();

    private void ensureIntentsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        intents_ = new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Intent>(intents_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Intent,
            com.google.cloud.dialogflow.cx.v3beta1.Intent.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.IntentOrBuilder>
        intentsBuilder_;

    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent> getIntentsList() {
      if (intentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(intents_);
      } else {
        return intentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public int getIntentsCount() {
      if (intentsBuilder_ == null) {
        return intents_.size();
      } else {
        return intentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent getIntents(int index) {
      if (intentsBuilder_ == null) {
        return intents_.get(index);
      } else {
        return intentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public Builder setIntents(int index, com.google.cloud.dialogflow.cx.v3beta1.Intent value) {
      if (intentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIntentsIsMutable();
        intents_.set(index, value);
        onChanged();
      } else {
        intentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public Builder setIntents(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Intent.Builder builderForValue) {
      if (intentsBuilder_ == null) {
        ensureIntentsIsMutable();
        intents_.set(index, builderForValue.build());
        onChanged();
      } else {
        intentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public Builder addIntents(com.google.cloud.dialogflow.cx.v3beta1.Intent value) {
      if (intentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIntentsIsMutable();
        intents_.add(value);
        onChanged();
      } else {
        intentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public Builder addIntents(int index, com.google.cloud.dialogflow.cx.v3beta1.Intent value) {
      if (intentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIntentsIsMutable();
        intents_.add(index, value);
        onChanged();
      } else {
        intentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public Builder addIntents(
        com.google.cloud.dialogflow.cx.v3beta1.Intent.Builder builderForValue) {
      if (intentsBuilder_ == null) {
        ensureIntentsIsMutable();
        intents_.add(builderForValue.build());
        onChanged();
      } else {
        intentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public Builder addIntents(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Intent.Builder builderForValue) {
      if (intentsBuilder_ == null) {
        ensureIntentsIsMutable();
        intents_.add(index, builderForValue.build());
        onChanged();
      } else {
        intentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public Builder addAllIntents(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Intent> values) {
      if (intentsBuilder_ == null) {
        ensureIntentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, intents_);
        onChanged();
      } else {
        intentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public Builder clearIntents() {
      if (intentsBuilder_ == null) {
        intents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        intentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public Builder removeIntents(int index) {
      if (intentsBuilder_ == null) {
        ensureIntentsIsMutable();
        intents_.remove(index);
        onChanged();
      } else {
        intentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.Builder getIntentsBuilder(int index) {
      return getIntentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.IntentOrBuilder getIntentsOrBuilder(int index) {
      if (intentsBuilder_ == null) {
        return intents_.get(index);
      } else {
        return intentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.IntentOrBuilder>
        getIntentsOrBuilderList() {
      if (intentsBuilder_ != null) {
        return intentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(intents_);
      }
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.Builder addIntentsBuilder() {
      return getIntentsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.Intent.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Intent.Builder addIntentsBuilder(int index) {
      return getIntentsFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.cx.v3beta1.Intent.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
     * conversation. Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Intent intents = 7;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Intent.Builder>
        getIntentsBuilderList() {
      return getIntentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Intent,
            com.google.cloud.dialogflow.cx.v3beta1.Intent.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.IntentOrBuilder>
        getIntentsFieldBuilder() {
      if (intentsBuilder_ == null) {
        intentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Intent,
                com.google.cloud.dialogflow.cx.v3beta1.Intent.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.IntentOrBuilder>(
                intents_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        intents_ = null;
      }
      return intentsBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Flow> flows_ =
        java.util.Collections.emptyList();

    private void ensureFlowsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        flows_ = new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Flow>(flows_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Flow,
            com.google.cloud.dialogflow.cx.v3beta1.Flow.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.FlowOrBuilder>
        flowsBuilder_;

    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Flow> getFlowsList() {
      if (flowsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(flows_);
      } else {
        return flowsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public int getFlowsCount() {
      if (flowsBuilder_ == null) {
        return flows_.size();
      } else {
        return flowsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Flow getFlows(int index) {
      if (flowsBuilder_ == null) {
        return flows_.get(index);
      } else {
        return flowsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public Builder setFlows(int index, com.google.cloud.dialogflow.cx.v3beta1.Flow value) {
      if (flowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlowsIsMutable();
        flows_.set(index, value);
        onChanged();
      } else {
        flowsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public Builder setFlows(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Flow.Builder builderForValue) {
      if (flowsBuilder_ == null) {
        ensureFlowsIsMutable();
        flows_.set(index, builderForValue.build());
        onChanged();
      } else {
        flowsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public Builder addFlows(com.google.cloud.dialogflow.cx.v3beta1.Flow value) {
      if (flowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlowsIsMutable();
        flows_.add(value);
        onChanged();
      } else {
        flowsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public Builder addFlows(int index, com.google.cloud.dialogflow.cx.v3beta1.Flow value) {
      if (flowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlowsIsMutable();
        flows_.add(index, value);
        onChanged();
      } else {
        flowsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public Builder addFlows(com.google.cloud.dialogflow.cx.v3beta1.Flow.Builder builderForValue) {
      if (flowsBuilder_ == null) {
        ensureFlowsIsMutable();
        flows_.add(builderForValue.build());
        onChanged();
      } else {
        flowsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public Builder addFlows(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Flow.Builder builderForValue) {
      if (flowsBuilder_ == null) {
        ensureFlowsIsMutable();
        flows_.add(index, builderForValue.build());
        onChanged();
      } else {
        flowsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public Builder addAllFlows(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Flow> values) {
      if (flowsBuilder_ == null) {
        ensureFlowsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, flows_);
        onChanged();
      } else {
        flowsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public Builder clearFlows() {
      if (flowsBuilder_ == null) {
        flows_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        flowsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public Builder removeFlows(int index) {
      if (flowsBuilder_ == null) {
        ensureFlowsIsMutable();
        flows_.remove(index);
        onChanged();
      } else {
        flowsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Flow.Builder getFlowsBuilder(int index) {
      return getFlowsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.FlowOrBuilder getFlowsOrBuilder(int index) {
      if (flowsBuilder_ == null) {
        return flows_.get(index);
      } else {
        return flowsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.FlowOrBuilder>
        getFlowsOrBuilderList() {
      if (flowsBuilder_ != null) {
        return flowsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(flows_);
      }
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Flow.Builder addFlowsBuilder() {
      return getFlowsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.Flow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Flow.Builder addFlowsBuilder(int index) {
      return getFlowsFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.cx.v3beta1.Flow.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Flow flows = 8;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Flow.Builder>
        getFlowsBuilderList() {
      return getFlowsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Flow,
            com.google.cloud.dialogflow.cx.v3beta1.Flow.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.FlowOrBuilder>
        getFlowsFieldBuilder() {
      if (flowsBuilder_ == null) {
        flowsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Flow,
                com.google.cloud.dialogflow.cx.v3beta1.Flow.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.FlowOrBuilder>(
                flows_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        flows_ = null;
      }
      return flowsBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Page> pages_ =
        java.util.Collections.emptyList();

    private void ensurePagesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        pages_ = new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3beta1.Page>(pages_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Page,
            com.google.cloud.dialogflow.cx.v3beta1.Page.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder>
        pagesBuilder_;

    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Page> getPagesList() {
      if (pagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pages_);
      } else {
        return pagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public int getPagesCount() {
      if (pagesBuilder_ == null) {
        return pages_.size();
      } else {
        return pagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Page getPages(int index) {
      if (pagesBuilder_ == null) {
        return pages_.get(index);
      } else {
        return pagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public Builder setPages(int index, com.google.cloud.dialogflow.cx.v3beta1.Page value) {
      if (pagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesIsMutable();
        pages_.set(index, value);
        onChanged();
      } else {
        pagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public Builder setPages(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Page.Builder builderForValue) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.set(index, builderForValue.build());
        onChanged();
      } else {
        pagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public Builder addPages(com.google.cloud.dialogflow.cx.v3beta1.Page value) {
      if (pagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesIsMutable();
        pages_.add(value);
        onChanged();
      } else {
        pagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public Builder addPages(int index, com.google.cloud.dialogflow.cx.v3beta1.Page value) {
      if (pagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesIsMutable();
        pages_.add(index, value);
        onChanged();
      } else {
        pagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public Builder addPages(com.google.cloud.dialogflow.cx.v3beta1.Page.Builder builderForValue) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.add(builderForValue.build());
        onChanged();
      } else {
        pagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public Builder addPages(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Page.Builder builderForValue) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.add(index, builderForValue.build());
        onChanged();
      } else {
        pagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public Builder addAllPages(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3beta1.Page> values) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pages_);
        onChanged();
      } else {
        pagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public Builder clearPages() {
      if (pagesBuilder_ == null) {
        pages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        pagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public Builder removePages(int index) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.remove(index);
        onChanged();
      } else {
        pagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Page.Builder getPagesBuilder(int index) {
      return getPagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder getPagesOrBuilder(int index) {
      if (pagesBuilder_ == null) {
        return pages_.get(index);
      } else {
        return pagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder>
        getPagesOrBuilderList() {
      if (pagesBuilder_ != null) {
        return pagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pages_);
      }
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Page.Builder addPagesBuilder() {
      return getPagesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3beta1.Page.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Page.Builder addPagesBuilder(int index) {
      return getPagesFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.cx.v3beta1.Page.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
     * has went through. Only `name` and `display_name` are filled in this
     * message.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3beta1.Page pages = 9;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Page.Builder>
        getPagesBuilderList() {
      return getPagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Page,
            com.google.cloud.dialogflow.cx.v3beta1.Page.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder>
        getPagesFieldBuilder() {
      if (pagesBuilder_ == null) {
        pagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Page,
                com.google.cloud.dialogflow.cx.v3beta1.Page.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.PageOrBuilder>(
                pages_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        pages_ = null;
      }
      return pagesBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction>
        interactions_ = java.util.Collections.emptyList();

    private void ensureInteractionsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        interactions_ =
            new java.util.ArrayList<
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction>(interactions_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction,
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.InteractionOrBuilder>
        interactionsBuilder_;

    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction>
        getInteractionsList() {
      if (interactionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(interactions_);
      } else {
        return interactionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public int getInteractionsCount() {
      if (interactionsBuilder_ == null) {
        return interactions_.size();
      } else {
        return interactionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction getInteractions(
        int index) {
      if (interactionsBuilder_ == null) {
        return interactions_.get(index);
      } else {
        return interactionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public Builder setInteractions(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction value) {
      if (interactionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInteractionsIsMutable();
        interactions_.set(index, value);
        onChanged();
      } else {
        interactionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public Builder setInteractions(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.Builder builderForValue) {
      if (interactionsBuilder_ == null) {
        ensureInteractionsIsMutable();
        interactions_.set(index, builderForValue.build());
        onChanged();
      } else {
        interactionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public Builder addInteractions(
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction value) {
      if (interactionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInteractionsIsMutable();
        interactions_.add(value);
        onChanged();
      } else {
        interactionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public Builder addInteractions(
        int index, com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction value) {
      if (interactionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInteractionsIsMutable();
        interactions_.add(index, value);
        onChanged();
      } else {
        interactionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public Builder addInteractions(
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.Builder builderForValue) {
      if (interactionsBuilder_ == null) {
        ensureInteractionsIsMutable();
        interactions_.add(builderForValue.build());
        onChanged();
      } else {
        interactionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public Builder addInteractions(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.Builder builderForValue) {
      if (interactionsBuilder_ == null) {
        ensureInteractionsIsMutable();
        interactions_.add(index, builderForValue.build());
        onChanged();
      } else {
        interactionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public Builder addAllInteractions(
        java.lang.Iterable<
                ? extends com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction>
            values) {
      if (interactionsBuilder_ == null) {
        ensureInteractionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, interactions_);
        onChanged();
      } else {
        interactionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public Builder clearInteractions() {
      if (interactionsBuilder_ == null) {
        interactions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        interactionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public Builder removeInteractions(int index) {
      if (interactionsBuilder_ == null) {
        ensureInteractionsIsMutable();
        interactions_.remove(index);
        onChanged();
      } else {
        interactionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.Builder
        getInteractionsBuilder(int index) {
      return getInteractionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.InteractionOrBuilder
        getInteractionsOrBuilder(int index) {
      if (interactionsBuilder_ == null) {
        return interactions_.get(index);
      } else {
        return interactionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3beta1.Conversation.InteractionOrBuilder>
        getInteractionsOrBuilderList() {
      if (interactionsBuilder_ != null) {
        return interactionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(interactions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.Builder
        addInteractionsBuilder() {
      return getInteractionsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.Builder
        addInteractionsBuilder(int index) {
      return getInteractionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Interactions of the conversation.
     * Only populated for `GetConversation` and empty for `ListConversations`.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction interactions = 10;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.Builder>
        getInteractionsBuilderList() {
      return getInteractionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction,
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Conversation.InteractionOrBuilder>
        getInteractionsFieldBuilder() {
      if (interactionsBuilder_ == null) {
        interactionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction,
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Conversation.InteractionOrBuilder>(
                interactions_, ((bitField0_ & 0x00000200) != 0), getParentForChildren(), isClean());
        interactions_ = null;
      }
      return interactionsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.Environment environment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Environment,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.EnvironmentOrBuilder>
        environmentBuilder_;
    /**
     *
     *
     * <pre>
     * Environment of the conversation.
     * Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
     *
     * @return Whether the environment field is set.
     */
    public boolean hasEnvironment() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Environment of the conversation.
     * Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
     *
     * @return The environment.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment getEnvironment() {
      if (environmentBuilder_ == null) {
        return environment_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Environment.getDefaultInstance()
            : environment_;
      } else {
        return environmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Environment of the conversation.
     * Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
     */
    public Builder setEnvironment(com.google.cloud.dialogflow.cx.v3beta1.Environment value) {
      if (environmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        environment_ = value;
      } else {
        environmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Environment of the conversation.
     * Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
     */
    public Builder setEnvironment(
        com.google.cloud.dialogflow.cx.v3beta1.Environment.Builder builderForValue) {
      if (environmentBuilder_ == null) {
        environment_ = builderForValue.build();
      } else {
        environmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Environment of the conversation.
     * Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
     */
    public Builder mergeEnvironment(com.google.cloud.dialogflow.cx.v3beta1.Environment value) {
      if (environmentBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && environment_ != null
            && environment_
                != com.google.cloud.dialogflow.cx.v3beta1.Environment.getDefaultInstance()) {
          getEnvironmentBuilder().mergeFrom(value);
        } else {
          environment_ = value;
        }
      } else {
        environmentBuilder_.mergeFrom(value);
      }
      if (environment_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Environment of the conversation.
     * Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
     */
    public Builder clearEnvironment() {
      bitField0_ = (bitField0_ & ~0x00000400);
      environment_ = null;
      if (environmentBuilder_ != null) {
        environmentBuilder_.dispose();
        environmentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Environment of the conversation.
     * Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Environment.Builder getEnvironmentBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getEnvironmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Environment of the conversation.
     * Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.EnvironmentOrBuilder getEnvironmentOrBuilder() {
      if (environmentBuilder_ != null) {
        return environmentBuilder_.getMessageOrBuilder();
      } else {
        return environment_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Environment.getDefaultInstance()
            : environment_;
      }
    }
    /**
     *
     *
     * <pre>
     * Environment of the conversation.
     * Only `name` and `display_name` are filled in this message.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Environment environment = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Environment,
            com.google.cloud.dialogflow.cx.v3beta1.Environment.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.EnvironmentOrBuilder>
        getEnvironmentFieldBuilder() {
      if (environmentBuilder_ == null) {
        environmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Environment,
                com.google.cloud.dialogflow.cx.v3beta1.Environment.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.EnvironmentOrBuilder>(
                getEnvironment(), getParentForChildren(), isClean());
        environment_ = null;
      }
      return environmentBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Long> flowVersions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Long>
        internalGetFlowVersions() {
      if (flowVersions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            FlowVersionsDefaultEntryHolder.defaultEntry);
      }
      return flowVersions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Long>
        internalGetMutableFlowVersions() {
      if (flowVersions_ == null) {
        flowVersions_ =
            com.google.protobuf.MapField.newMapField(FlowVersionsDefaultEntryHolder.defaultEntry);
      }
      if (!flowVersions_.isMutable()) {
        flowVersions_ = flowVersions_.copy();
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return flowVersions_;
    }

    public int getFlowVersionsCount() {
      return internalGetFlowVersions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Flow versions used in the conversation.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
     */
    @java.lang.Override
    public boolean containsFlowVersions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetFlowVersions().getMap().containsKey(key);
    }
    /** Use {@link #getFlowVersionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long> getFlowVersions() {
      return getFlowVersionsMap();
    }
    /**
     *
     *
     * <pre>
     * Flow versions used in the conversation.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Long> getFlowVersionsMap() {
      return internalGetFlowVersions().getMap();
    }
    /**
     *
     *
     * <pre>
     * Flow versions used in the conversation.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
     */
    @java.lang.Override
    public long getFlowVersionsOrDefault(java.lang.String key, long defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetFlowVersions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Flow versions used in the conversation.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
     */
    @java.lang.Override
    public long getFlowVersionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetFlowVersions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearFlowVersions() {
      bitField0_ = (bitField0_ & ~0x00000800);
      internalGetMutableFlowVersions().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Flow versions used in the conversation.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
     */
    public Builder removeFlowVersions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableFlowVersions().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long> getMutableFlowVersions() {
      bitField0_ |= 0x00000800;
      return internalGetMutableFlowVersions().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Flow versions used in the conversation.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
     */
    public Builder putFlowVersions(java.lang.String key, long value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableFlowVersions().getMutableMap().put(key, value);
      bitField0_ |= 0x00000800;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Flow versions used in the conversation.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; flow_versions = 12;</code>
     */
    public Builder putAllFlowVersions(java.util.Map<java.lang.String, java.lang.Long> values) {
      internalGetMutableFlowVersions().getMutableMap().putAll(values);
      bitField0_ |= 0x00000800;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Conversation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Conversation)
  private static final com.google.cloud.dialogflow.cx.v3beta1.Conversation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Conversation();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Conversation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Conversation> PARSER =
      new com.google.protobuf.AbstractParser<Conversation>() {
        @java.lang.Override
        public Conversation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Conversation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Conversation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Conversation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
