/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/advanced_settings.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Hierarchical advanced settings for agent/flow/page/fulfillment/parameter.
 * Settings exposed at lower level overrides the settings exposed at higher
 * level. Overriding occurs at the sub-setting level. For example, the
 * playback_interruption_settings at fulfillment level only overrides the
 * playback_interruption_settings at the agent level, leaving other settings
 * at the agent level unchanged.
 *
 * DTMF settings does not override each other. DTMF settings set at different
 * levels define DTMF detections running in parallel.
 *
 * Hierarchy: Agent-&gt;Flow-&gt;Page-&gt;Fulfillment/Parameter.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings}
 */
public final class AdvancedSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings)
    AdvancedSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AdvancedSettings.newBuilder() to construct.
  private AdvancedSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AdvancedSettings() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AdvancedSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.class,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder.class);
  }

  public interface SpeechSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Sensitivity of the speech model that detects the end of speech.
     * Scale from 0 to 100.
     * </pre>
     *
     * <code>int32 endpointer_sensitivity = 1;</code>
     *
     * @return The endpointerSensitivity.
     */
    int getEndpointerSensitivity();

    /**
     *
     *
     * <pre>
     * Timeout before detecting no speech.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
     *
     * @return Whether the noSpeechTimeout field is set.
     */
    boolean hasNoSpeechTimeout();
    /**
     *
     *
     * <pre>
     * Timeout before detecting no speech.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
     *
     * @return The noSpeechTimeout.
     */
    com.google.protobuf.Duration getNoSpeechTimeout();
    /**
     *
     *
     * <pre>
     * Timeout before detecting no speech.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
     */
    com.google.protobuf.DurationOrBuilder getNoSpeechTimeoutOrBuilder();

    /**
     *
     *
     * <pre>
     * Use timeout based endpointing, interpreting endpointer sensitivity as
     * seconds of timeout value.
     * </pre>
     *
     * <code>bool use_timeout_based_endpointing = 3;</code>
     *
     * @return The useTimeoutBasedEndpointing.
     */
    boolean getUseTimeoutBasedEndpointing();

    /**
     *
     *
     * <pre>
     * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
     * model will be selected for requests from its corresponding language.
     * For more information, see
     * [Speech
     * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 5;</code>
     */
    int getModelsCount();
    /**
     *
     *
     * <pre>
     * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
     * model will be selected for requests from its corresponding language.
     * For more information, see
     * [Speech
     * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 5;</code>
     */
    boolean containsModels(java.lang.String key);
    /** Use {@link #getModelsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getModels();
    /**
     *
     *
     * <pre>
     * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
     * model will be selected for requests from its corresponding language.
     * For more information, see
     * [Speech
     * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 5;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getModelsMap();
    /**
     *
     *
     * <pre>
     * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
     * model will be selected for requests from its corresponding language.
     * For more information, see
     * [Speech
     * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 5;</code>
     */
    /* nullable */
    java.lang.String getModelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
     * model will be selected for requests from its corresponding language.
     * For more information, see
     * [Speech
     * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 5;</code>
     */
    java.lang.String getModelsOrThrow(java.lang.String key);
  }
  /**
   *
   *
   * <pre>
   * Define behaviors of speech to text detection.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings}
   */
  public static final class SpeechSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings)
      SpeechSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SpeechSettings.newBuilder() to construct.
    private SpeechSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SpeechSettings() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SpeechSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_SpeechSettings_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetModels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_SpeechSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.class,
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.Builder.class);
    }

    private int bitField0_;
    public static final int ENDPOINTER_SENSITIVITY_FIELD_NUMBER = 1;
    private int endpointerSensitivity_ = 0;
    /**
     *
     *
     * <pre>
     * Sensitivity of the speech model that detects the end of speech.
     * Scale from 0 to 100.
     * </pre>
     *
     * <code>int32 endpointer_sensitivity = 1;</code>
     *
     * @return The endpointerSensitivity.
     */
    @java.lang.Override
    public int getEndpointerSensitivity() {
      return endpointerSensitivity_;
    }

    public static final int NO_SPEECH_TIMEOUT_FIELD_NUMBER = 2;
    private com.google.protobuf.Duration noSpeechTimeout_;
    /**
     *
     *
     * <pre>
     * Timeout before detecting no speech.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
     *
     * @return Whether the noSpeechTimeout field is set.
     */
    @java.lang.Override
    public boolean hasNoSpeechTimeout() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Timeout before detecting no speech.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
     *
     * @return The noSpeechTimeout.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getNoSpeechTimeout() {
      return noSpeechTimeout_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : noSpeechTimeout_;
    }
    /**
     *
     *
     * <pre>
     * Timeout before detecting no speech.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getNoSpeechTimeoutOrBuilder() {
      return noSpeechTimeout_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : noSpeechTimeout_;
    }

    public static final int USE_TIMEOUT_BASED_ENDPOINTING_FIELD_NUMBER = 3;
    private boolean useTimeoutBasedEndpointing_ = false;
    /**
     *
     *
     * <pre>
     * Use timeout based endpointing, interpreting endpointer sensitivity as
     * seconds of timeout value.
     * </pre>
     *
     * <code>bool use_timeout_based_endpointing = 3;</code>
     *
     * @return The useTimeoutBasedEndpointing.
     */
    @java.lang.Override
    public boolean getUseTimeoutBasedEndpointing() {
      return useTimeoutBasedEndpointing_;
    }

    public static final int MODELS_FIELD_NUMBER = 5;

    private static final class ModelsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
                  .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_SpeechSettings_ModelsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> models_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetModels() {
      if (models_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ModelsDefaultEntryHolder.defaultEntry);
      }
      return models_;
    }

    public int getModelsCount() {
      return internalGetModels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
     * model will be selected for requests from its corresponding language.
     * For more information, see
     * [Speech
     * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 5;</code>
     */
    @java.lang.Override
    public boolean containsModels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetModels().getMap().containsKey(key);
    }
    /** Use {@link #getModelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getModels() {
      return getModelsMap();
    }
    /**
     *
     *
     * <pre>
     * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
     * model will be selected for requests from its corresponding language.
     * For more information, see
     * [Speech
     * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getModelsMap() {
      return internalGetModels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
     * model will be selected for requests from its corresponding language.
     * For more information, see
     * [Speech
     * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getModelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetModels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
     * model will be selected for requests from its corresponding language.
     * For more information, see
     * [Speech
     * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getModelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetModels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (endpointerSensitivity_ != 0) {
        output.writeInt32(1, endpointerSensitivity_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getNoSpeechTimeout());
      }
      if (useTimeoutBasedEndpointing_ != false) {
        output.writeBool(3, useTimeoutBasedEndpointing_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetModels(), ModelsDefaultEntryHolder.defaultEntry, 5);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (endpointerSensitivity_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, endpointerSensitivity_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getNoSpeechTimeout());
      }
      if (useTimeoutBasedEndpointing_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(3, useTimeoutBasedEndpointing_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetModels().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> models__ =
            ModelsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, models__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings other =
          (com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings) obj;

      if (getEndpointerSensitivity() != other.getEndpointerSensitivity()) return false;
      if (hasNoSpeechTimeout() != other.hasNoSpeechTimeout()) return false;
      if (hasNoSpeechTimeout()) {
        if (!getNoSpeechTimeout().equals(other.getNoSpeechTimeout())) return false;
      }
      if (getUseTimeoutBasedEndpointing() != other.getUseTimeoutBasedEndpointing()) return false;
      if (!internalGetModels().equals(other.internalGetModels())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENDPOINTER_SENSITIVITY_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointerSensitivity();
      if (hasNoSpeechTimeout()) {
        hash = (37 * hash) + NO_SPEECH_TIMEOUT_FIELD_NUMBER;
        hash = (53 * hash) + getNoSpeechTimeout().hashCode();
      }
      hash = (37 * hash) + USE_TIMEOUT_BASED_ENDPOINTING_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseTimeoutBasedEndpointing());
      if (!internalGetModels().getMap().isEmpty()) {
        hash = (37 * hash) + MODELS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetModels().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Define behaviors of speech to text detection.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings)
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_SpeechSettings_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 5:
            return internalGetModels();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 5:
            return internalGetMutableModels();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_SpeechSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.class,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getNoSpeechTimeoutFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        endpointerSensitivity_ = 0;
        noSpeechTimeout_ = null;
        if (noSpeechTimeoutBuilder_ != null) {
          noSpeechTimeoutBuilder_.dispose();
          noSpeechTimeoutBuilder_ = null;
        }
        useTimeoutBasedEndpointing_ = false;
        internalGetMutableModels().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_SpeechSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings build() {
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings result =
            new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.endpointerSensitivity_ = endpointerSensitivity_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.noSpeechTimeout_ =
              noSpeechTimeoutBuilder_ == null ? noSpeechTimeout_ : noSpeechTimeoutBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.useTimeoutBasedEndpointing_ = useTimeoutBasedEndpointing_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.models_ = internalGetModels();
          result.models_.makeImmutable();
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
                .getDefaultInstance()) return this;
        if (other.getEndpointerSensitivity() != 0) {
          setEndpointerSensitivity(other.getEndpointerSensitivity());
        }
        if (other.hasNoSpeechTimeout()) {
          mergeNoSpeechTimeout(other.getNoSpeechTimeout());
        }
        if (other.getUseTimeoutBasedEndpointing() != false) {
          setUseTimeoutBasedEndpointing(other.getUseTimeoutBasedEndpointing());
        }
        internalGetMutableModels().mergeFrom(other.internalGetModels());
        bitField0_ |= 0x00000008;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  endpointerSensitivity_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(
                      getNoSpeechTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  useTimeoutBasedEndpointing_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 42:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String> models__ =
                      input.readMessage(
                          ModelsDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableModels()
                      .getMutableMap()
                      .put(models__.getKey(), models__.getValue());
                  bitField0_ |= 0x00000008;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int endpointerSensitivity_;
      /**
       *
       *
       * <pre>
       * Sensitivity of the speech model that detects the end of speech.
       * Scale from 0 to 100.
       * </pre>
       *
       * <code>int32 endpointer_sensitivity = 1;</code>
       *
       * @return The endpointerSensitivity.
       */
      @java.lang.Override
      public int getEndpointerSensitivity() {
        return endpointerSensitivity_;
      }
      /**
       *
       *
       * <pre>
       * Sensitivity of the speech model that detects the end of speech.
       * Scale from 0 to 100.
       * </pre>
       *
       * <code>int32 endpointer_sensitivity = 1;</code>
       *
       * @param value The endpointerSensitivity to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointerSensitivity(int value) {

        endpointerSensitivity_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sensitivity of the speech model that detects the end of speech.
       * Scale from 0 to 100.
       * </pre>
       *
       * <code>int32 endpointer_sensitivity = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndpointerSensitivity() {
        bitField0_ = (bitField0_ & ~0x00000001);
        endpointerSensitivity_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration noSpeechTimeout_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          noSpeechTimeoutBuilder_;
      /**
       *
       *
       * <pre>
       * Timeout before detecting no speech.
       * </pre>
       *
       * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
       *
       * @return Whether the noSpeechTimeout field is set.
       */
      public boolean hasNoSpeechTimeout() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Timeout before detecting no speech.
       * </pre>
       *
       * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
       *
       * @return The noSpeechTimeout.
       */
      public com.google.protobuf.Duration getNoSpeechTimeout() {
        if (noSpeechTimeoutBuilder_ == null) {
          return noSpeechTimeout_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : noSpeechTimeout_;
        } else {
          return noSpeechTimeoutBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Timeout before detecting no speech.
       * </pre>
       *
       * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
       */
      public Builder setNoSpeechTimeout(com.google.protobuf.Duration value) {
        if (noSpeechTimeoutBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          noSpeechTimeout_ = value;
        } else {
          noSpeechTimeoutBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Timeout before detecting no speech.
       * </pre>
       *
       * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
       */
      public Builder setNoSpeechTimeout(com.google.protobuf.Duration.Builder builderForValue) {
        if (noSpeechTimeoutBuilder_ == null) {
          noSpeechTimeout_ = builderForValue.build();
        } else {
          noSpeechTimeoutBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Timeout before detecting no speech.
       * </pre>
       *
       * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
       */
      public Builder mergeNoSpeechTimeout(com.google.protobuf.Duration value) {
        if (noSpeechTimeoutBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && noSpeechTimeout_ != null
              && noSpeechTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getNoSpeechTimeoutBuilder().mergeFrom(value);
          } else {
            noSpeechTimeout_ = value;
          }
        } else {
          noSpeechTimeoutBuilder_.mergeFrom(value);
        }
        if (noSpeechTimeout_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Timeout before detecting no speech.
       * </pre>
       *
       * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
       */
      public Builder clearNoSpeechTimeout() {
        bitField0_ = (bitField0_ & ~0x00000002);
        noSpeechTimeout_ = null;
        if (noSpeechTimeoutBuilder_ != null) {
          noSpeechTimeoutBuilder_.dispose();
          noSpeechTimeoutBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Timeout before detecting no speech.
       * </pre>
       *
       * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
       */
      public com.google.protobuf.Duration.Builder getNoSpeechTimeoutBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getNoSpeechTimeoutFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Timeout before detecting no speech.
       * </pre>
       *
       * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
       */
      public com.google.protobuf.DurationOrBuilder getNoSpeechTimeoutOrBuilder() {
        if (noSpeechTimeoutBuilder_ != null) {
          return noSpeechTimeoutBuilder_.getMessageOrBuilder();
        } else {
          return noSpeechTimeout_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : noSpeechTimeout_;
        }
      }
      /**
       *
       *
       * <pre>
       * Timeout before detecting no speech.
       * </pre>
       *
       * <code>.google.protobuf.Duration no_speech_timeout = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getNoSpeechTimeoutFieldBuilder() {
        if (noSpeechTimeoutBuilder_ == null) {
          noSpeechTimeoutBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getNoSpeechTimeout(), getParentForChildren(), isClean());
          noSpeechTimeout_ = null;
        }
        return noSpeechTimeoutBuilder_;
      }

      private boolean useTimeoutBasedEndpointing_;
      /**
       *
       *
       * <pre>
       * Use timeout based endpointing, interpreting endpointer sensitivity as
       * seconds of timeout value.
       * </pre>
       *
       * <code>bool use_timeout_based_endpointing = 3;</code>
       *
       * @return The useTimeoutBasedEndpointing.
       */
      @java.lang.Override
      public boolean getUseTimeoutBasedEndpointing() {
        return useTimeoutBasedEndpointing_;
      }
      /**
       *
       *
       * <pre>
       * Use timeout based endpointing, interpreting endpointer sensitivity as
       * seconds of timeout value.
       * </pre>
       *
       * <code>bool use_timeout_based_endpointing = 3;</code>
       *
       * @param value The useTimeoutBasedEndpointing to set.
       * @return This builder for chaining.
       */
      public Builder setUseTimeoutBasedEndpointing(boolean value) {

        useTimeoutBasedEndpointing_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use timeout based endpointing, interpreting endpointer sensitivity as
       * seconds of timeout value.
       * </pre>
       *
       * <code>bool use_timeout_based_endpointing = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUseTimeoutBasedEndpointing() {
        bitField0_ = (bitField0_ & ~0x00000004);
        useTimeoutBasedEndpointing_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> models_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetModels() {
        if (models_ == null) {
          return com.google.protobuf.MapField.emptyMapField(ModelsDefaultEntryHolder.defaultEntry);
        }
        return models_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableModels() {
        if (models_ == null) {
          models_ = com.google.protobuf.MapField.newMapField(ModelsDefaultEntryHolder.defaultEntry);
        }
        if (!models_.isMutable()) {
          models_ = models_.copy();
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return models_;
      }

      public int getModelsCount() {
        return internalGetModels().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
       * model will be selected for requests from its corresponding language.
       * For more information, see
       * [Speech
       * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
       * </pre>
       *
       * <code>map&lt;string, string&gt; models = 5;</code>
       */
      @java.lang.Override
      public boolean containsModels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetModels().getMap().containsKey(key);
      }
      /** Use {@link #getModelsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getModels() {
        return getModelsMap();
      }
      /**
       *
       *
       * <pre>
       * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
       * model will be selected for requests from its corresponding language.
       * For more information, see
       * [Speech
       * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
       * </pre>
       *
       * <code>map&lt;string, string&gt; models = 5;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getModelsMap() {
        return internalGetModels().getMap();
      }
      /**
       *
       *
       * <pre>
       * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
       * model will be selected for requests from its corresponding language.
       * For more information, see
       * [Speech
       * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
       * </pre>
       *
       * <code>map&lt;string, string&gt; models = 5;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getModelsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetModels().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
       * model will be selected for requests from its corresponding language.
       * For more information, see
       * [Speech
       * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
       * </pre>
       *
       * <code>map&lt;string, string&gt; models = 5;</code>
       */
      @java.lang.Override
      public java.lang.String getModelsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetModels().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearModels() {
        bitField0_ = (bitField0_ & ~0x00000008);
        internalGetMutableModels().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
       * model will be selected for requests from its corresponding language.
       * For more information, see
       * [Speech
       * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
       * </pre>
       *
       * <code>map&lt;string, string&gt; models = 5;</code>
       */
      public Builder removeModels(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableModels().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableModels() {
        bitField0_ |= 0x00000008;
        return internalGetMutableModels().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
       * model will be selected for requests from its corresponding language.
       * For more information, see
       * [Speech
       * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
       * </pre>
       *
       * <code>map&lt;string, string&gt; models = 5;</code>
       */
      public Builder putModels(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableModels().getMutableMap().put(key, value);
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Mapping from language to Speech-to-Text model. The mapped Speech-to-Text
       * model will be selected for requests from its corresponding language.
       * For more information, see
       * [Speech
       * models](https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
       * </pre>
       *
       * <code>map&lt;string, string&gt; models = 5;</code>
       */
      public Builder putAllModels(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableModels().getMutableMap().putAll(values);
        bitField0_ |= 0x00000008;
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings)
    private static final com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SpeechSettings> PARSER =
        new com.google.protobuf.AbstractParser<SpeechSettings>() {
          @java.lang.Override
          public SpeechSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SpeechSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SpeechSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DtmfSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If true, incoming audio is processed for DTMF (dual tone multi frequency)
     * events. For example, if the caller presses a button on their telephone
     * keypad and DTMF processing is enabled, Dialogflow will detect the
     * event (e.g. a "3" was pressed) in the incoming audio and pass the event
     * to the bot to drive business logic (e.g. when 3 is pressed, return the
     * account balance).
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();

    /**
     *
     *
     * <pre>
     * Max length of DTMF digits.
     * </pre>
     *
     * <code>int32 max_digits = 2;</code>
     *
     * @return The maxDigits.
     */
    int getMaxDigits();

    /**
     *
     *
     * <pre>
     * The digit that terminates a DTMF digit sequence.
     * </pre>
     *
     * <code>string finish_digit = 3;</code>
     *
     * @return The finishDigit.
     */
    java.lang.String getFinishDigit();
    /**
     *
     *
     * <pre>
     * The digit that terminates a DTMF digit sequence.
     * </pre>
     *
     * <code>string finish_digit = 3;</code>
     *
     * @return The bytes for finishDigit.
     */
    com.google.protobuf.ByteString getFinishDigitBytes();

    /**
     *
     *
     * <pre>
     * Interdigit timeout setting for matching dtmf input to regex.
     * </pre>
     *
     * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
     *
     * @return Whether the interdigitTimeoutDuration field is set.
     */
    boolean hasInterdigitTimeoutDuration();
    /**
     *
     *
     * <pre>
     * Interdigit timeout setting for matching dtmf input to regex.
     * </pre>
     *
     * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
     *
     * @return The interdigitTimeoutDuration.
     */
    com.google.protobuf.Duration getInterdigitTimeoutDuration();
    /**
     *
     *
     * <pre>
     * Interdigit timeout setting for matching dtmf input to regex.
     * </pre>
     *
     * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
     */
    com.google.protobuf.DurationOrBuilder getInterdigitTimeoutDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Endpoint timeout setting for matching dtmf input to regex.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
     *
     * @return Whether the endpointingTimeoutDuration field is set.
     */
    boolean hasEndpointingTimeoutDuration();
    /**
     *
     *
     * <pre>
     * Endpoint timeout setting for matching dtmf input to regex.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
     *
     * @return The endpointingTimeoutDuration.
     */
    com.google.protobuf.Duration getEndpointingTimeoutDuration();
    /**
     *
     *
     * <pre>
     * Endpoint timeout setting for matching dtmf input to regex.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
     */
    com.google.protobuf.DurationOrBuilder getEndpointingTimeoutDurationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Define behaviors for DTMF (dual tone multi frequency).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings}
   */
  public static final class DtmfSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings)
      DtmfSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DtmfSettings.newBuilder() to construct.
    private DtmfSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DtmfSettings() {
      finishDigit_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DtmfSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_DtmfSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_DtmfSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.class,
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder.class);
    }

    private int bitField0_;
    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;
    /**
     *
     *
     * <pre>
     * If true, incoming audio is processed for DTMF (dual tone multi frequency)
     * events. For example, if the caller presses a button on their telephone
     * keypad and DTMF processing is enabled, Dialogflow will detect the
     * event (e.g. a "3" was pressed) in the incoming audio and pass the event
     * to the bot to drive business logic (e.g. when 3 is pressed, return the
     * account balance).
     * </pre>
     *
     * <code>bool enabled = 1;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    public static final int MAX_DIGITS_FIELD_NUMBER = 2;
    private int maxDigits_ = 0;
    /**
     *
     *
     * <pre>
     * Max length of DTMF digits.
     * </pre>
     *
     * <code>int32 max_digits = 2;</code>
     *
     * @return The maxDigits.
     */
    @java.lang.Override
    public int getMaxDigits() {
      return maxDigits_;
    }

    public static final int FINISH_DIGIT_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object finishDigit_ = "";
    /**
     *
     *
     * <pre>
     * The digit that terminates a DTMF digit sequence.
     * </pre>
     *
     * <code>string finish_digit = 3;</code>
     *
     * @return The finishDigit.
     */
    @java.lang.Override
    public java.lang.String getFinishDigit() {
      java.lang.Object ref = finishDigit_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        finishDigit_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The digit that terminates a DTMF digit sequence.
     * </pre>
     *
     * <code>string finish_digit = 3;</code>
     *
     * @return The bytes for finishDigit.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFinishDigitBytes() {
      java.lang.Object ref = finishDigit_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        finishDigit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INTERDIGIT_TIMEOUT_DURATION_FIELD_NUMBER = 6;
    private com.google.protobuf.Duration interdigitTimeoutDuration_;
    /**
     *
     *
     * <pre>
     * Interdigit timeout setting for matching dtmf input to regex.
     * </pre>
     *
     * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
     *
     * @return Whether the interdigitTimeoutDuration field is set.
     */
    @java.lang.Override
    public boolean hasInterdigitTimeoutDuration() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Interdigit timeout setting for matching dtmf input to regex.
     * </pre>
     *
     * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
     *
     * @return The interdigitTimeoutDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getInterdigitTimeoutDuration() {
      return interdigitTimeoutDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : interdigitTimeoutDuration_;
    }
    /**
     *
     *
     * <pre>
     * Interdigit timeout setting for matching dtmf input to regex.
     * </pre>
     *
     * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getInterdigitTimeoutDurationOrBuilder() {
      return interdigitTimeoutDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : interdigitTimeoutDuration_;
    }

    public static final int ENDPOINTING_TIMEOUT_DURATION_FIELD_NUMBER = 7;
    private com.google.protobuf.Duration endpointingTimeoutDuration_;
    /**
     *
     *
     * <pre>
     * Endpoint timeout setting for matching dtmf input to regex.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
     *
     * @return Whether the endpointingTimeoutDuration field is set.
     */
    @java.lang.Override
    public boolean hasEndpointingTimeoutDuration() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Endpoint timeout setting for matching dtmf input to regex.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
     *
     * @return The endpointingTimeoutDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getEndpointingTimeoutDuration() {
      return endpointingTimeoutDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : endpointingTimeoutDuration_;
    }
    /**
     *
     *
     * <pre>
     * Endpoint timeout setting for matching dtmf input to regex.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getEndpointingTimeoutDurationOrBuilder() {
      return endpointingTimeoutDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : endpointingTimeoutDuration_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      if (maxDigits_ != 0) {
        output.writeInt32(2, maxDigits_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(finishDigit_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, finishDigit_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(6, getInterdigitTimeoutDuration());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(7, getEndpointingTimeoutDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      if (maxDigits_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxDigits_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(finishDigit_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, finishDigit_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, getInterdigitTimeoutDuration());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                7, getEndpointingTimeoutDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings other =
          (com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (getMaxDigits() != other.getMaxDigits()) return false;
      if (!getFinishDigit().equals(other.getFinishDigit())) return false;
      if (hasInterdigitTimeoutDuration() != other.hasInterdigitTimeoutDuration()) return false;
      if (hasInterdigitTimeoutDuration()) {
        if (!getInterdigitTimeoutDuration().equals(other.getInterdigitTimeoutDuration()))
          return false;
      }
      if (hasEndpointingTimeoutDuration() != other.hasEndpointingTimeoutDuration()) return false;
      if (hasEndpointingTimeoutDuration()) {
        if (!getEndpointingTimeoutDuration().equals(other.getEndpointingTimeoutDuration()))
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (37 * hash) + MAX_DIGITS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxDigits();
      hash = (37 * hash) + FINISH_DIGIT_FIELD_NUMBER;
      hash = (53 * hash) + getFinishDigit().hashCode();
      if (hasInterdigitTimeoutDuration()) {
        hash = (37 * hash) + INTERDIGIT_TIMEOUT_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getInterdigitTimeoutDuration().hashCode();
      }
      if (hasEndpointingTimeoutDuration()) {
        hash = (37 * hash) + ENDPOINTING_TIMEOUT_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getEndpointingTimeoutDuration().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Define behaviors for DTMF (dual tone multi frequency).
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings)
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_DtmfSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_DtmfSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.class,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getInterdigitTimeoutDurationFieldBuilder();
          getEndpointingTimeoutDurationFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        maxDigits_ = 0;
        finishDigit_ = "";
        interdigitTimeoutDuration_ = null;
        if (interdigitTimeoutDurationBuilder_ != null) {
          interdigitTimeoutDurationBuilder_.dispose();
          interdigitTimeoutDurationBuilder_ = null;
        }
        endpointingTimeoutDuration_ = null;
        if (endpointingTimeoutDurationBuilder_ != null) {
          endpointingTimeoutDurationBuilder_.dispose();
          endpointingTimeoutDurationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_DtmfSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings build() {
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings result =
            new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.maxDigits_ = maxDigits_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.finishDigit_ = finishDigit_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.interdigitTimeoutDuration_ =
              interdigitTimeoutDurationBuilder_ == null
                  ? interdigitTimeoutDuration_
                  : interdigitTimeoutDurationBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.endpointingTimeoutDuration_ =
              endpointingTimeoutDurationBuilder_ == null
                  ? endpointingTimeoutDuration_
                  : endpointingTimeoutDurationBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
                .getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        if (other.getMaxDigits() != 0) {
          setMaxDigits(other.getMaxDigits());
        }
        if (!other.getFinishDigit().isEmpty()) {
          finishDigit_ = other.finishDigit_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasInterdigitTimeoutDuration()) {
          mergeInterdigitTimeoutDuration(other.getInterdigitTimeoutDuration());
        }
        if (other.hasEndpointingTimeoutDuration()) {
          mergeEndpointingTimeoutDuration(other.getEndpointingTimeoutDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  maxDigits_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  finishDigit_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 50:
                {
                  input.readMessage(
                      getInterdigitTimeoutDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(
                      getEndpointingTimeoutDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * If true, incoming audio is processed for DTMF (dual tone multi frequency)
       * events. For example, if the caller presses a button on their telephone
       * keypad and DTMF processing is enabled, Dialogflow will detect the
       * event (e.g. a "3" was pressed) in the incoming audio and pass the event
       * to the bot to drive business logic (e.g. when 3 is pressed, return the
       * account balance).
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * If true, incoming audio is processed for DTMF (dual tone multi frequency)
       * events. For example, if the caller presses a button on their telephone
       * keypad and DTMF processing is enabled, Dialogflow will detect the
       * event (e.g. a "3" was pressed) in the incoming audio and pass the event
       * to the bot to drive business logic (e.g. when 3 is pressed, return the
       * account balance).
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, incoming audio is processed for DTMF (dual tone multi frequency)
       * events. For example, if the caller presses a button on their telephone
       * keypad and DTMF processing is enabled, Dialogflow will detect the
       * event (e.g. a "3" was pressed) in the incoming audio and pass the event
       * to the bot to drive business logic (e.g. when 3 is pressed, return the
       * account balance).
       * </pre>
       *
       * <code>bool enabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      private int maxDigits_;
      /**
       *
       *
       * <pre>
       * Max length of DTMF digits.
       * </pre>
       *
       * <code>int32 max_digits = 2;</code>
       *
       * @return The maxDigits.
       */
      @java.lang.Override
      public int getMaxDigits() {
        return maxDigits_;
      }
      /**
       *
       *
       * <pre>
       * Max length of DTMF digits.
       * </pre>
       *
       * <code>int32 max_digits = 2;</code>
       *
       * @param value The maxDigits to set.
       * @return This builder for chaining.
       */
      public Builder setMaxDigits(int value) {

        maxDigits_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Max length of DTMF digits.
       * </pre>
       *
       * <code>int32 max_digits = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxDigits() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maxDigits_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object finishDigit_ = "";
      /**
       *
       *
       * <pre>
       * The digit that terminates a DTMF digit sequence.
       * </pre>
       *
       * <code>string finish_digit = 3;</code>
       *
       * @return The finishDigit.
       */
      public java.lang.String getFinishDigit() {
        java.lang.Object ref = finishDigit_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          finishDigit_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The digit that terminates a DTMF digit sequence.
       * </pre>
       *
       * <code>string finish_digit = 3;</code>
       *
       * @return The bytes for finishDigit.
       */
      public com.google.protobuf.ByteString getFinishDigitBytes() {
        java.lang.Object ref = finishDigit_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          finishDigit_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The digit that terminates a DTMF digit sequence.
       * </pre>
       *
       * <code>string finish_digit = 3;</code>
       *
       * @param value The finishDigit to set.
       * @return This builder for chaining.
       */
      public Builder setFinishDigit(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        finishDigit_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The digit that terminates a DTMF digit sequence.
       * </pre>
       *
       * <code>string finish_digit = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFinishDigit() {
        finishDigit_ = getDefaultInstance().getFinishDigit();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The digit that terminates a DTMF digit sequence.
       * </pre>
       *
       * <code>string finish_digit = 3;</code>
       *
       * @param value The bytes for finishDigit to set.
       * @return This builder for chaining.
       */
      public Builder setFinishDigitBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        finishDigit_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration interdigitTimeoutDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          interdigitTimeoutDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Interdigit timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
       *
       * @return Whether the interdigitTimeoutDuration field is set.
       */
      public boolean hasInterdigitTimeoutDuration() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Interdigit timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
       *
       * @return The interdigitTimeoutDuration.
       */
      public com.google.protobuf.Duration getInterdigitTimeoutDuration() {
        if (interdigitTimeoutDurationBuilder_ == null) {
          return interdigitTimeoutDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : interdigitTimeoutDuration_;
        } else {
          return interdigitTimeoutDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Interdigit timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
       */
      public Builder setInterdigitTimeoutDuration(com.google.protobuf.Duration value) {
        if (interdigitTimeoutDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          interdigitTimeoutDuration_ = value;
        } else {
          interdigitTimeoutDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Interdigit timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
       */
      public Builder setInterdigitTimeoutDuration(
          com.google.protobuf.Duration.Builder builderForValue) {
        if (interdigitTimeoutDurationBuilder_ == null) {
          interdigitTimeoutDuration_ = builderForValue.build();
        } else {
          interdigitTimeoutDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Interdigit timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
       */
      public Builder mergeInterdigitTimeoutDuration(com.google.protobuf.Duration value) {
        if (interdigitTimeoutDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && interdigitTimeoutDuration_ != null
              && interdigitTimeoutDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getInterdigitTimeoutDurationBuilder().mergeFrom(value);
          } else {
            interdigitTimeoutDuration_ = value;
          }
        } else {
          interdigitTimeoutDurationBuilder_.mergeFrom(value);
        }
        if (interdigitTimeoutDuration_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Interdigit timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
       */
      public Builder clearInterdigitTimeoutDuration() {
        bitField0_ = (bitField0_ & ~0x00000008);
        interdigitTimeoutDuration_ = null;
        if (interdigitTimeoutDurationBuilder_ != null) {
          interdigitTimeoutDurationBuilder_.dispose();
          interdigitTimeoutDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Interdigit timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
       */
      public com.google.protobuf.Duration.Builder getInterdigitTimeoutDurationBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getInterdigitTimeoutDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Interdigit timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
       */
      public com.google.protobuf.DurationOrBuilder getInterdigitTimeoutDurationOrBuilder() {
        if (interdigitTimeoutDurationBuilder_ != null) {
          return interdigitTimeoutDurationBuilder_.getMessageOrBuilder();
        } else {
          return interdigitTimeoutDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : interdigitTimeoutDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Interdigit timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getInterdigitTimeoutDurationFieldBuilder() {
        if (interdigitTimeoutDurationBuilder_ == null) {
          interdigitTimeoutDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getInterdigitTimeoutDuration(), getParentForChildren(), isClean());
          interdigitTimeoutDuration_ = null;
        }
        return interdigitTimeoutDurationBuilder_;
      }

      private com.google.protobuf.Duration endpointingTimeoutDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          endpointingTimeoutDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Endpoint timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
       *
       * @return Whether the endpointingTimeoutDuration field is set.
       */
      public boolean hasEndpointingTimeoutDuration() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Endpoint timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
       *
       * @return The endpointingTimeoutDuration.
       */
      public com.google.protobuf.Duration getEndpointingTimeoutDuration() {
        if (endpointingTimeoutDurationBuilder_ == null) {
          return endpointingTimeoutDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : endpointingTimeoutDuration_;
        } else {
          return endpointingTimeoutDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Endpoint timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
       */
      public Builder setEndpointingTimeoutDuration(com.google.protobuf.Duration value) {
        if (endpointingTimeoutDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endpointingTimeoutDuration_ = value;
        } else {
          endpointingTimeoutDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Endpoint timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
       */
      public Builder setEndpointingTimeoutDuration(
          com.google.protobuf.Duration.Builder builderForValue) {
        if (endpointingTimeoutDurationBuilder_ == null) {
          endpointingTimeoutDuration_ = builderForValue.build();
        } else {
          endpointingTimeoutDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Endpoint timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
       */
      public Builder mergeEndpointingTimeoutDuration(com.google.protobuf.Duration value) {
        if (endpointingTimeoutDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && endpointingTimeoutDuration_ != null
              && endpointingTimeoutDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getEndpointingTimeoutDurationBuilder().mergeFrom(value);
          } else {
            endpointingTimeoutDuration_ = value;
          }
        } else {
          endpointingTimeoutDurationBuilder_.mergeFrom(value);
        }
        if (endpointingTimeoutDuration_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Endpoint timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
       */
      public Builder clearEndpointingTimeoutDuration() {
        bitField0_ = (bitField0_ & ~0x00000010);
        endpointingTimeoutDuration_ = null;
        if (endpointingTimeoutDurationBuilder_ != null) {
          endpointingTimeoutDurationBuilder_.dispose();
          endpointingTimeoutDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Endpoint timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
       */
      public com.google.protobuf.Duration.Builder getEndpointingTimeoutDurationBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getEndpointingTimeoutDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Endpoint timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
       */
      public com.google.protobuf.DurationOrBuilder getEndpointingTimeoutDurationOrBuilder() {
        if (endpointingTimeoutDurationBuilder_ != null) {
          return endpointingTimeoutDurationBuilder_.getMessageOrBuilder();
        } else {
          return endpointingTimeoutDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : endpointingTimeoutDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Endpoint timeout setting for matching dtmf input to regex.
       * </pre>
       *
       * <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getEndpointingTimeoutDurationFieldBuilder() {
        if (endpointingTimeoutDurationBuilder_ == null) {
          endpointingTimeoutDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getEndpointingTimeoutDuration(), getParentForChildren(), isClean());
          endpointingTimeoutDuration_ = null;
        }
        return endpointingTimeoutDurationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings)
    private static final com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DtmfSettings> PARSER =
        new com.google.protobuf.AbstractParser<DtmfSettings>() {
          @java.lang.Override
          public DtmfSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DtmfSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DtmfSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LoggingSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Enables Google Cloud Logging.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 2;</code>
     *
     * @return The enableStackdriverLogging.
     */
    boolean getEnableStackdriverLogging();

    /**
     *
     *
     * <pre>
     * Enables DF Interaction logging.
     * </pre>
     *
     * <code>bool enable_interaction_logging = 3;</code>
     *
     * @return The enableInteractionLogging.
     */
    boolean getEnableInteractionLogging();

    /**
     *
     *
     * <pre>
     * Enables consent-based end-user input redaction, if true, a pre-defined
     * session parameter `$session.params.conversation-redaction` will be
     * used to determine if the utterance should be redacted.
     * </pre>
     *
     * <code>bool enable_consent_based_redaction = 4;</code>
     *
     * @return The enableConsentBasedRedaction.
     */
    boolean getEnableConsentBasedRedaction();
  }
  /**
   *
   *
   * <pre>
   * Define behaviors on logging.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings}
   */
  public static final class LoggingSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings)
      LoggingSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LoggingSettings.newBuilder() to construct.
    private LoggingSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LoggingSettings() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LoggingSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_LoggingSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_LoggingSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.class,
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder
                  .class);
    }

    public static final int ENABLE_STACKDRIVER_LOGGING_FIELD_NUMBER = 2;
    private boolean enableStackdriverLogging_ = false;
    /**
     *
     *
     * <pre>
     * Enables Google Cloud Logging.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 2;</code>
     *
     * @return The enableStackdriverLogging.
     */
    @java.lang.Override
    public boolean getEnableStackdriverLogging() {
      return enableStackdriverLogging_;
    }

    public static final int ENABLE_INTERACTION_LOGGING_FIELD_NUMBER = 3;
    private boolean enableInteractionLogging_ = false;
    /**
     *
     *
     * <pre>
     * Enables DF Interaction logging.
     * </pre>
     *
     * <code>bool enable_interaction_logging = 3;</code>
     *
     * @return The enableInteractionLogging.
     */
    @java.lang.Override
    public boolean getEnableInteractionLogging() {
      return enableInteractionLogging_;
    }

    public static final int ENABLE_CONSENT_BASED_REDACTION_FIELD_NUMBER = 4;
    private boolean enableConsentBasedRedaction_ = false;
    /**
     *
     *
     * <pre>
     * Enables consent-based end-user input redaction, if true, a pre-defined
     * session parameter `$session.params.conversation-redaction` will be
     * used to determine if the utterance should be redacted.
     * </pre>
     *
     * <code>bool enable_consent_based_redaction = 4;</code>
     *
     * @return The enableConsentBasedRedaction.
     */
    @java.lang.Override
    public boolean getEnableConsentBasedRedaction() {
      return enableConsentBasedRedaction_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enableStackdriverLogging_ != false) {
        output.writeBool(2, enableStackdriverLogging_);
      }
      if (enableInteractionLogging_ != false) {
        output.writeBool(3, enableInteractionLogging_);
      }
      if (enableConsentBasedRedaction_ != false) {
        output.writeBool(4, enableConsentBasedRedaction_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enableStackdriverLogging_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, enableStackdriverLogging_);
      }
      if (enableInteractionLogging_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, enableInteractionLogging_);
      }
      if (enableConsentBasedRedaction_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(4, enableConsentBasedRedaction_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings other =
          (com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings) obj;

      if (getEnableStackdriverLogging() != other.getEnableStackdriverLogging()) return false;
      if (getEnableInteractionLogging() != other.getEnableInteractionLogging()) return false;
      if (getEnableConsentBasedRedaction() != other.getEnableConsentBasedRedaction()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLE_STACKDRIVER_LOGGING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableStackdriverLogging());
      hash = (37 * hash) + ENABLE_INTERACTION_LOGGING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableInteractionLogging());
      hash = (37 * hash) + ENABLE_CONSENT_BASED_REDACTION_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableConsentBasedRedaction());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Define behaviors on logging.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings)
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_LoggingSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_LoggingSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.class,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enableStackdriverLogging_ = false;
        enableInteractionLogging_ = false;
        enableConsentBasedRedaction_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_LoggingSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings build() {
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings result =
            new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enableStackdriverLogging_ = enableStackdriverLogging_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.enableInteractionLogging_ = enableInteractionLogging_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.enableConsentBasedRedaction_ = enableConsentBasedRedaction_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
                .getDefaultInstance()) return this;
        if (other.getEnableStackdriverLogging() != false) {
          setEnableStackdriverLogging(other.getEnableStackdriverLogging());
        }
        if (other.getEnableInteractionLogging() != false) {
          setEnableInteractionLogging(other.getEnableInteractionLogging());
        }
        if (other.getEnableConsentBasedRedaction() != false) {
          setEnableConsentBasedRedaction(other.getEnableConsentBasedRedaction());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16:
                {
                  enableStackdriverLogging_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 16
              case 24:
                {
                  enableInteractionLogging_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              case 32:
                {
                  enableConsentBasedRedaction_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enableStackdriverLogging_;
      /**
       *
       *
       * <pre>
       * Enables Google Cloud Logging.
       * </pre>
       *
       * <code>bool enable_stackdriver_logging = 2;</code>
       *
       * @return The enableStackdriverLogging.
       */
      @java.lang.Override
      public boolean getEnableStackdriverLogging() {
        return enableStackdriverLogging_;
      }
      /**
       *
       *
       * <pre>
       * Enables Google Cloud Logging.
       * </pre>
       *
       * <code>bool enable_stackdriver_logging = 2;</code>
       *
       * @param value The enableStackdriverLogging to set.
       * @return This builder for chaining.
       */
      public Builder setEnableStackdriverLogging(boolean value) {

        enableStackdriverLogging_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enables Google Cloud Logging.
       * </pre>
       *
       * <code>bool enable_stackdriver_logging = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableStackdriverLogging() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enableStackdriverLogging_ = false;
        onChanged();
        return this;
      }

      private boolean enableInteractionLogging_;
      /**
       *
       *
       * <pre>
       * Enables DF Interaction logging.
       * </pre>
       *
       * <code>bool enable_interaction_logging = 3;</code>
       *
       * @return The enableInteractionLogging.
       */
      @java.lang.Override
      public boolean getEnableInteractionLogging() {
        return enableInteractionLogging_;
      }
      /**
       *
       *
       * <pre>
       * Enables DF Interaction logging.
       * </pre>
       *
       * <code>bool enable_interaction_logging = 3;</code>
       *
       * @param value The enableInteractionLogging to set.
       * @return This builder for chaining.
       */
      public Builder setEnableInteractionLogging(boolean value) {

        enableInteractionLogging_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enables DF Interaction logging.
       * </pre>
       *
       * <code>bool enable_interaction_logging = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableInteractionLogging() {
        bitField0_ = (bitField0_ & ~0x00000002);
        enableInteractionLogging_ = false;
        onChanged();
        return this;
      }

      private boolean enableConsentBasedRedaction_;
      /**
       *
       *
       * <pre>
       * Enables consent-based end-user input redaction, if true, a pre-defined
       * session parameter `$session.params.conversation-redaction` will be
       * used to determine if the utterance should be redacted.
       * </pre>
       *
       * <code>bool enable_consent_based_redaction = 4;</code>
       *
       * @return The enableConsentBasedRedaction.
       */
      @java.lang.Override
      public boolean getEnableConsentBasedRedaction() {
        return enableConsentBasedRedaction_;
      }
      /**
       *
       *
       * <pre>
       * Enables consent-based end-user input redaction, if true, a pre-defined
       * session parameter `$session.params.conversation-redaction` will be
       * used to determine if the utterance should be redacted.
       * </pre>
       *
       * <code>bool enable_consent_based_redaction = 4;</code>
       *
       * @param value The enableConsentBasedRedaction to set.
       * @return This builder for chaining.
       */
      public Builder setEnableConsentBasedRedaction(boolean value) {

        enableConsentBasedRedaction_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enables consent-based end-user input redaction, if true, a pre-defined
       * session parameter `$session.params.conversation-redaction` will be
       * used to determine if the utterance should be redacted.
       * </pre>
       *
       * <code>bool enable_consent_based_redaction = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableConsentBasedRedaction() {
        bitField0_ = (bitField0_ & ~0x00000004);
        enableConsentBasedRedaction_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings)
    private static final com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LoggingSettings> PARSER =
        new com.google.protobuf.AbstractParser<LoggingSettings>() {
          @java.lang.Override
          public LoggingSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LoggingSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LoggingSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int AUDIO_EXPORT_GCS_DESTINATION_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.cx.v3beta1.GcsDestination audioExportGcsDestination_;
  /**
   *
   *
   * <pre>
   * If present, incoming audio is exported by Dialogflow to the configured
   * Google Cloud Storage destination.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
   * </code>
   *
   * @return Whether the audioExportGcsDestination field is set.
   */
  @java.lang.Override
  public boolean hasAudioExportGcsDestination() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * If present, incoming audio is exported by Dialogflow to the configured
   * Google Cloud Storage destination.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
   * </code>
   *
   * @return The audioExportGcsDestination.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.GcsDestination getAudioExportGcsDestination() {
    return audioExportGcsDestination_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.getDefaultInstance()
        : audioExportGcsDestination_;
  }
  /**
   *
   *
   * <pre>
   * If present, incoming audio is exported by Dialogflow to the configured
   * Google Cloud Storage destination.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.GcsDestinationOrBuilder
      getAudioExportGcsDestinationOrBuilder() {
    return audioExportGcsDestination_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.getDefaultInstance()
        : audioExportGcsDestination_;
  }

  public static final int SPEECH_SETTINGS_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speechSettings_;
  /**
   *
   *
   * <pre>
   * Settings for speech to text detection.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * - Page level
   * - Parameter level
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 3;
   * </code>
   *
   * @return Whether the speechSettings field is set.
   */
  @java.lang.Override
  public boolean hasSpeechSettings() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Settings for speech to text detection.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * - Page level
   * - Parameter level
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 3;
   * </code>
   *
   * @return The speechSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
      getSpeechSettings() {
    return speechSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
            .getDefaultInstance()
        : speechSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for speech to text detection.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * - Page level
   * - Parameter level
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettingsOrBuilder
      getSpeechSettingsOrBuilder() {
    return speechSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
            .getDefaultInstance()
        : speechSettings_;
  }

  public static final int DTMF_SETTINGS_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmfSettings_;
  /**
   *
   *
   * <pre>
   * Settings for DTMF.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * - Page level
   * - Parameter level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
   * </code>
   *
   * @return Whether the dtmfSettings field is set.
   */
  @java.lang.Override
  public boolean hasDtmfSettings() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Settings for DTMF.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * - Page level
   * - Parameter level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
   * </code>
   *
   * @return The dtmfSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings getDtmfSettings() {
    return dtmfSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.getDefaultInstance()
        : dtmfSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for DTMF.
   * Exposed at the following levels:
   * - Agent level
   * - Flow level
   * - Page level
   * - Parameter level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettingsOrBuilder
      getDtmfSettingsOrBuilder() {
    return dtmfSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.getDefaultInstance()
        : dtmfSettings_;
  }

  public static final int LOGGING_SETTINGS_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings loggingSettings_;
  /**
   *
   *
   * <pre>
   * Settings for logging.
   * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
   * and speech logging.
   * Exposed at the following levels:
   * - Agent level.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
   * </code>
   *
   * @return Whether the loggingSettings field is set.
   */
  @java.lang.Override
  public boolean hasLoggingSettings() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Settings for logging.
   * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
   * and speech logging.
   * Exposed at the following levels:
   * - Agent level.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
   * </code>
   *
   * @return The loggingSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
      getLoggingSettings() {
    return loggingSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
            .getDefaultInstance()
        : loggingSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for logging.
   * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
   * and speech logging.
   * Exposed at the following levels:
   * - Agent level.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettingsOrBuilder
      getLoggingSettingsOrBuilder() {
    return loggingSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
            .getDefaultInstance()
        : loggingSettings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getAudioExportGcsDestination());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getSpeechSettings());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getDtmfSettings());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getLoggingSettings());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, getAudioExportGcsDestination());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSpeechSettings());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDtmfSettings());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getLoggingSettings());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings other =
        (com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings) obj;

    if (hasAudioExportGcsDestination() != other.hasAudioExportGcsDestination()) return false;
    if (hasAudioExportGcsDestination()) {
      if (!getAudioExportGcsDestination().equals(other.getAudioExportGcsDestination()))
        return false;
    }
    if (hasSpeechSettings() != other.hasSpeechSettings()) return false;
    if (hasSpeechSettings()) {
      if (!getSpeechSettings().equals(other.getSpeechSettings())) return false;
    }
    if (hasDtmfSettings() != other.hasDtmfSettings()) return false;
    if (hasDtmfSettings()) {
      if (!getDtmfSettings().equals(other.getDtmfSettings())) return false;
    }
    if (hasLoggingSettings() != other.hasLoggingSettings()) return false;
    if (hasLoggingSettings()) {
      if (!getLoggingSettings().equals(other.getLoggingSettings())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAudioExportGcsDestination()) {
      hash = (37 * hash) + AUDIO_EXPORT_GCS_DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getAudioExportGcsDestination().hashCode();
    }
    if (hasSpeechSettings()) {
      hash = (37 * hash) + SPEECH_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechSettings().hashCode();
    }
    if (hasDtmfSettings()) {
      hash = (37 * hash) + DTMF_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getDtmfSettings().hashCode();
    }
    if (hasLoggingSettings()) {
      hash = (37 * hash) + LOGGING_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getLoggingSettings().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Hierarchical advanced settings for agent/flow/page/fulfillment/parameter.
   * Settings exposed at lower level overrides the settings exposed at higher
   * level. Overriding occurs at the sub-setting level. For example, the
   * playback_interruption_settings at fulfillment level only overrides the
   * playback_interruption_settings at the agent level, leaving other settings
   * at the agent level unchanged.
   *
   * DTMF settings does not override each other. DTMF settings set at different
   * levels define DTMF detections running in parallel.
   *
   * Hierarchy: Agent-&gt;Flow-&gt;Page-&gt;Fulfillment/Parameter.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.AdvancedSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings)
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.class,
              com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAudioExportGcsDestinationFieldBuilder();
        getSpeechSettingsFieldBuilder();
        getDtmfSettingsFieldBuilder();
        getLoggingSettingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      audioExportGcsDestination_ = null;
      if (audioExportGcsDestinationBuilder_ != null) {
        audioExportGcsDestinationBuilder_.dispose();
        audioExportGcsDestinationBuilder_ = null;
      }
      speechSettings_ = null;
      if (speechSettingsBuilder_ != null) {
        speechSettingsBuilder_.dispose();
        speechSettingsBuilder_ = null;
      }
      dtmfSettings_ = null;
      if (dtmfSettingsBuilder_ != null) {
        dtmfSettingsBuilder_.dispose();
        dtmfSettingsBuilder_ = null;
      }
      loggingSettings_ = null;
      if (loggingSettingsBuilder_ != null) {
        loggingSettingsBuilder_.dispose();
        loggingSettingsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_AdvancedSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings build() {
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings result =
          new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.audioExportGcsDestination_ =
            audioExportGcsDestinationBuilder_ == null
                ? audioExportGcsDestination_
                : audioExportGcsDestinationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.speechSettings_ =
            speechSettingsBuilder_ == null ? speechSettings_ : speechSettingsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dtmfSettings_ =
            dtmfSettingsBuilder_ == null ? dtmfSettings_ : dtmfSettingsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.loggingSettings_ =
            loggingSettingsBuilder_ == null ? loggingSettings_ : loggingSettingsBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.getDefaultInstance())
        return this;
      if (other.hasAudioExportGcsDestination()) {
        mergeAudioExportGcsDestination(other.getAudioExportGcsDestination());
      }
      if (other.hasSpeechSettings()) {
        mergeSpeechSettings(other.getSpeechSettings());
      }
      if (other.hasDtmfSettings()) {
        mergeDtmfSettings(other.getDtmfSettings());
      }
      if (other.hasLoggingSettings()) {
        mergeLoggingSettings(other.getLoggingSettings());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(
                    getAudioExportGcsDestinationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getSpeechSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getDtmfSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getLoggingSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.dialogflow.cx.v3beta1.GcsDestination audioExportGcsDestination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.GcsDestination,
            com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.GcsDestinationOrBuilder>
        audioExportGcsDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     *
     * @return Whether the audioExportGcsDestination field is set.
     */
    public boolean hasAudioExportGcsDestination() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     *
     * @return The audioExportGcsDestination.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.GcsDestination getAudioExportGcsDestination() {
      if (audioExportGcsDestinationBuilder_ == null) {
        return audioExportGcsDestination_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.getDefaultInstance()
            : audioExportGcsDestination_;
      } else {
        return audioExportGcsDestinationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    public Builder setAudioExportGcsDestination(
        com.google.cloud.dialogflow.cx.v3beta1.GcsDestination value) {
      if (audioExportGcsDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        audioExportGcsDestination_ = value;
      } else {
        audioExportGcsDestinationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    public Builder setAudioExportGcsDestination(
        com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.Builder builderForValue) {
      if (audioExportGcsDestinationBuilder_ == null) {
        audioExportGcsDestination_ = builderForValue.build();
      } else {
        audioExportGcsDestinationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    public Builder mergeAudioExportGcsDestination(
        com.google.cloud.dialogflow.cx.v3beta1.GcsDestination value) {
      if (audioExportGcsDestinationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && audioExportGcsDestination_ != null
            && audioExportGcsDestination_
                != com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.getDefaultInstance()) {
          getAudioExportGcsDestinationBuilder().mergeFrom(value);
        } else {
          audioExportGcsDestination_ = value;
        }
      } else {
        audioExportGcsDestinationBuilder_.mergeFrom(value);
      }
      if (audioExportGcsDestination_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    public Builder clearAudioExportGcsDestination() {
      bitField0_ = (bitField0_ & ~0x00000001);
      audioExportGcsDestination_ = null;
      if (audioExportGcsDestinationBuilder_ != null) {
        audioExportGcsDestinationBuilder_.dispose();
        audioExportGcsDestinationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.Builder
        getAudioExportGcsDestinationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAudioExportGcsDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.GcsDestinationOrBuilder
        getAudioExportGcsDestinationOrBuilder() {
      if (audioExportGcsDestinationBuilder_ != null) {
        return audioExportGcsDestinationBuilder_.getMessageOrBuilder();
      } else {
        return audioExportGcsDestination_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.getDefaultInstance()
            : audioExportGcsDestination_;
      }
    }
    /**
     *
     *
     * <pre>
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.GcsDestination audio_export_gcs_destination = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.GcsDestination,
            com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.GcsDestinationOrBuilder>
        getAudioExportGcsDestinationFieldBuilder() {
      if (audioExportGcsDestinationBuilder_ == null) {
        audioExportGcsDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.GcsDestination,
                com.google.cloud.dialogflow.cx.v3beta1.GcsDestination.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.GcsDestinationOrBuilder>(
                getAudioExportGcsDestination(), getParentForChildren(), isClean());
        audioExportGcsDestination_ = null;
      }
      return audioExportGcsDestinationBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speechSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettingsOrBuilder>
        speechSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for speech to text detection.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 3;
     * </code>
     *
     * @return Whether the speechSettings field is set.
     */
    public boolean hasSpeechSettings() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings for speech to text detection.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 3;
     * </code>
     *
     * @return The speechSettings.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
        getSpeechSettings() {
      if (speechSettingsBuilder_ == null) {
        return speechSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
                .getDefaultInstance()
            : speechSettings_;
      } else {
        return speechSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for speech to text detection.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 3;
     * </code>
     */
    public Builder setSpeechSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings value) {
      if (speechSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        speechSettings_ = value;
      } else {
        speechSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for speech to text detection.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 3;
     * </code>
     */
    public Builder setSpeechSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.Builder
            builderForValue) {
      if (speechSettingsBuilder_ == null) {
        speechSettings_ = builderForValue.build();
      } else {
        speechSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for speech to text detection.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 3;
     * </code>
     */
    public Builder mergeSpeechSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings value) {
      if (speechSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && speechSettings_ != null
            && speechSettings_
                != com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
                    .getDefaultInstance()) {
          getSpeechSettingsBuilder().mergeFrom(value);
        } else {
          speechSettings_ = value;
        }
      } else {
        speechSettingsBuilder_.mergeFrom(value);
      }
      if (speechSettings_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for speech to text detection.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 3;
     * </code>
     */
    public Builder clearSpeechSettings() {
      bitField0_ = (bitField0_ & ~0x00000002);
      speechSettings_ = null;
      if (speechSettingsBuilder_ != null) {
        speechSettingsBuilder_.dispose();
        speechSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for speech to text detection.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.Builder
        getSpeechSettingsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSpeechSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for speech to text detection.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettingsOrBuilder
        getSpeechSettingsOrBuilder() {
      if (speechSettingsBuilder_ != null) {
        return speechSettingsBuilder_.getMessageOrBuilder();
      } else {
        return speechSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings
                .getDefaultInstance()
            : speechSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for speech to text detection.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings speech_settings = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettingsOrBuilder>
        getSpeechSettingsFieldBuilder() {
      if (speechSettingsBuilder_ == null) {
        speechSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettings.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.SpeechSettingsOrBuilder>(
                getSpeechSettings(), getParentForChildren(), isClean());
        speechSettings_ = null;
      }
      return speechSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmfSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettingsOrBuilder>
        dtmfSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     *
     * @return Whether the dtmfSettings field is set.
     */
    public boolean hasDtmfSettings() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     *
     * @return The dtmfSettings.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings getDtmfSettings() {
      if (dtmfSettingsBuilder_ == null) {
        return dtmfSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
                .getDefaultInstance()
            : dtmfSettings_;
      } else {
        return dtmfSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    public Builder setDtmfSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings value) {
      if (dtmfSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dtmfSettings_ = value;
      } else {
        dtmfSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    public Builder setDtmfSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder
            builderForValue) {
      if (dtmfSettingsBuilder_ == null) {
        dtmfSettings_ = builderForValue.build();
      } else {
        dtmfSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    public Builder mergeDtmfSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings value) {
      if (dtmfSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && dtmfSettings_ != null
            && dtmfSettings_
                != com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
                    .getDefaultInstance()) {
          getDtmfSettingsBuilder().mergeFrom(value);
        } else {
          dtmfSettings_ = value;
        }
      } else {
        dtmfSettingsBuilder_.mergeFrom(value);
      }
      if (dtmfSettings_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    public Builder clearDtmfSettings() {
      bitField0_ = (bitField0_ & ~0x00000004);
      dtmfSettings_ = null;
      if (dtmfSettingsBuilder_ != null) {
        dtmfSettingsBuilder_.dispose();
        dtmfSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder
        getDtmfSettingsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDtmfSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettingsOrBuilder
        getDtmfSettingsOrBuilder() {
      if (dtmfSettingsBuilder_ != null) {
        return dtmfSettingsBuilder_.getMessageOrBuilder();
      } else {
        return dtmfSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings
                .getDefaultInstance()
            : dtmfSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings dtmf_settings = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettingsOrBuilder>
        getDtmfSettingsFieldBuilder() {
      if (dtmfSettingsBuilder_ == null) {
        dtmfSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettings.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.DtmfSettingsOrBuilder>(
                getDtmfSettings(), getParentForChildren(), isClean());
        dtmfSettings_ = null;
      }
      return dtmfSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        loggingSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettingsOrBuilder>
        loggingSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     *
     * @return Whether the loggingSettings field is set.
     */
    public boolean hasLoggingSettings() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     *
     * @return The loggingSettings.
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
        getLoggingSettings() {
      if (loggingSettingsBuilder_ == null) {
        return loggingSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
                .getDefaultInstance()
            : loggingSettings_;
      } else {
        return loggingSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public Builder setLoggingSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings value) {
      if (loggingSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        loggingSettings_ = value;
      } else {
        loggingSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public Builder setLoggingSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder
            builderForValue) {
      if (loggingSettingsBuilder_ == null) {
        loggingSettings_ = builderForValue.build();
      } else {
        loggingSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public Builder mergeLoggingSettings(
        com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings value) {
      if (loggingSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && loggingSettings_ != null
            && loggingSettings_
                != com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
                    .getDefaultInstance()) {
          getLoggingSettingsBuilder().mergeFrom(value);
        } else {
          loggingSettings_ = value;
        }
      } else {
        loggingSettingsBuilder_.mergeFrom(value);
      }
      if (loggingSettings_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public Builder clearLoggingSettings() {
      bitField0_ = (bitField0_ & ~0x00000008);
      loggingSettings_ = null;
      if (loggingSettingsBuilder_ != null) {
        loggingSettingsBuilder_.dispose();
        loggingSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder
        getLoggingSettingsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getLoggingSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettingsOrBuilder
        getLoggingSettingsOrBuilder() {
      if (loggingSettingsBuilder_ != null) {
        return loggingSettingsBuilder_.getMessageOrBuilder();
      } else {
        return loggingSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings
                .getDefaultInstance()
            : loggingSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings logging_settings = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettingsOrBuilder>
        getLoggingSettingsFieldBuilder() {
      if (loggingSettingsBuilder_ == null) {
        loggingSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettings.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings.LoggingSettingsOrBuilder>(
                getLoggingSettings(), getParentForChildren(), isClean());
        loggingSettings_ = null;
      }
      return loggingSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.AdvancedSettings)
  private static final com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdvancedSettings> PARSER =
      new com.google.protobuf.AbstractParser<AdvancedSettings>() {
        @java.lang.Override
        public AdvancedSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AdvancedSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdvancedSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.AdvancedSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
