/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PlaybookName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_PLAYBOOK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/playbooks/{playbook}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String playbook;

    @Deprecated
    protected PlaybookName() {
        this.project = null;
        this.location = null;
        this.agent = null;
        this.playbook = null;
    }

    private PlaybookName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.playbook = (String)Preconditions.checkNotNull((Object)builder.getPlaybook());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getPlaybook() {
        return this.playbook;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PlaybookName of(String project, String location, String agent, String playbook) {
        return PlaybookName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setPlaybook(playbook).build();
    }

    public static String format(String project, String location, String agent, String playbook) {
        return PlaybookName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setPlaybook(playbook).build().toString();
    }

    public static PlaybookName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT_PLAYBOOK.validatedMatch(formattedString, "PlaybookName.parse: formattedString not in valid format");
        return PlaybookName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("playbook"));
    }

    public static List<PlaybookName> parseList(List<String> formattedStrings) {
        ArrayList<PlaybookName> list = new ArrayList<PlaybookName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PlaybookName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PlaybookName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PlaybookName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_PLAYBOOK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PlaybookName playbookName = this;
            synchronized (playbookName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.playbook != null) {
                        fieldMapBuilder.put((Object)"playbook", (Object)this.playbook);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT_PLAYBOOK.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "playbook", this.playbook});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PlaybookName that = (PlaybookName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.playbook, that.playbook);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        return h ^= Objects.hashCode(this.playbook);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String playbook;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getPlaybook() {
            return this.playbook;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setPlaybook(String playbook) {
            this.playbook = playbook;
            return this;
        }

        private Builder(PlaybookName playbookName) {
            this.project = playbookName.project;
            this.location = playbookName.location;
            this.agent = playbookName.agent;
            this.playbook = playbookName.playbook;
        }

        public PlaybookName build() {
            return new PlaybookName(this);
        }
    }
}

