/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AgentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;

    @Deprecated
    protected AgentName() {
        this.project = null;
        this.location = null;
        this.agent = null;
    }

    private AgentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AgentName of(String project, String location, String agent) {
        return AgentName.newBuilder().setProject(project).setLocation(location).setAgent(agent).build();
    }

    public static String format(String project, String location, String agent) {
        return AgentName.newBuilder().setProject(project).setLocation(location).setAgent(agent).build().toString();
    }

    public static AgentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT.validatedMatch(formattedString, "AgentName.parse: formattedString not in valid format");
        return AgentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"));
    }

    public static List<AgentName> parseList(List<String> formattedStrings) {
        ArrayList<AgentName> list = new ArrayList<AgentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AgentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AgentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AgentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AgentName agentName = this;
            synchronized (agentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AgentName that = (AgentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.agent);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        private Builder(AgentName agentName) {
            this.project = agentName.project;
            this.location = agentName.location;
            this.agent = agentName.agent;
        }

        public AgentName build() {
            return new AgentName(this);
        }
    }
}

