/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AgentValidationResultName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/validationResult");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;

    @Deprecated
    protected AgentValidationResultName() {
        this.project = null;
        this.location = null;
        this.agent = null;
    }

    private AgentValidationResultName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AgentValidationResultName of(String project, String location, String agent) {
        return AgentValidationResultName.newBuilder().setProject(project).setLocation(location).setAgent(agent).build();
    }

    public static String format(String project, String location, String agent) {
        return AgentValidationResultName.newBuilder().setProject(project).setLocation(location).setAgent(agent).build().toString();
    }

    public static AgentValidationResultName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT.validatedMatch(formattedString, "AgentValidationResultName.parse: formattedString not in valid format");
        return AgentValidationResultName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"));
    }

    public static List<AgentValidationResultName> parseList(List<String> formattedStrings) {
        ArrayList<AgentValidationResultName> list = new ArrayList<AgentValidationResultName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AgentValidationResultName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AgentValidationResultName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AgentValidationResultName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AgentValidationResultName agentValidationResultName = this;
            synchronized (agentValidationResultName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AgentValidationResultName that = (AgentValidationResultName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.agent);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        private Builder(AgentValidationResultName agentValidationResultName) {
            this.project = agentValidationResultName.project;
            this.location = agentValidationResultName.location;
            this.agent = agentValidationResultName.agent;
        }

        public AgentValidationResultName build() {
            return new AgentValidationResultName(this);
        }
    }
}

