/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TransitionRouteGroupName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/transitionRouteGroups/{transition_route_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String flow;
    private final String transitionRouteGroup;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getFlow() {
        return this.flow;
    }

    public String getTransitionRouteGroup() {
        return this.transitionRouteGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TransitionRouteGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.flow = (String)Preconditions.checkNotNull((Object)builder.getFlow());
        this.transitionRouteGroup = (String)Preconditions.checkNotNull((Object)builder.getTransitionRouteGroup());
    }

    public static TransitionRouteGroupName of(String project, String location, String agent, String flow, String transitionRouteGroup) {
        return TransitionRouteGroupName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setFlow(flow).setTransitionRouteGroup(transitionRouteGroup).build();
    }

    public static String format(String project, String location, String agent, String flow, String transitionRouteGroup) {
        return TransitionRouteGroupName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setFlow(flow).setTransitionRouteGroup(transitionRouteGroup).build().toString();
    }

    public static TransitionRouteGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "TransitionRouteGroupName.parse: formattedString not in valid format");
        return TransitionRouteGroupName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("flow"), (String)matchMap.get("transition_route_group"));
    }

    public static List<TransitionRouteGroupName> parseList(List<String> formattedStrings) {
        ArrayList<TransitionRouteGroupName> list = new ArrayList<TransitionRouteGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TransitionRouteGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TransitionRouteGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TransitionRouteGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TransitionRouteGroupName transitionRouteGroupName = this;
            synchronized (transitionRouteGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    fieldMapBuilder.put((Object)"flow", (Object)this.flow);
                    fieldMapBuilder.put((Object)"transitionRouteGroup", (Object)this.transitionRouteGroup);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "flow", this.flow, "transition_route_group", this.transitionRouteGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TransitionRouteGroupName) {
            TransitionRouteGroupName that = (TransitionRouteGroupName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.agent.equals(that.agent) && this.flow.equals(that.flow) && this.transitionRouteGroup.equals(that.transitionRouteGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.agent.hashCode();
        h *= 1000003;
        h ^= this.flow.hashCode();
        h *= 1000003;
        return h ^= this.transitionRouteGroup.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String flow;
        private String transitionRouteGroup;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getFlow() {
            return this.flow;
        }

        public String getTransitionRouteGroup() {
            return this.transitionRouteGroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setFlow(String flow) {
            this.flow = flow;
            return this;
        }

        public Builder setTransitionRouteGroup(String transitionRouteGroup) {
            this.transitionRouteGroup = transitionRouteGroup;
            return this;
        }

        private Builder() {
        }

        private Builder(TransitionRouteGroupName transitionRouteGroupName) {
            this.project = transitionRouteGroupName.project;
            this.location = transitionRouteGroupName.location;
            this.agent = transitionRouteGroupName.agent;
            this.flow = transitionRouteGroupName.flow;
            this.transitionRouteGroup = transitionRouteGroupName.transitionRouteGroup;
        }

        public TransitionRouteGroupName build() {
            return new TransitionRouteGroupName(this);
        }
    }
}

