/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VersionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_FLOW_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/versions/{version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String flow;
    private final String version;

    @Deprecated
    protected VersionName() {
        this.project = null;
        this.location = null;
        this.agent = null;
        this.flow = null;
        this.version = null;
    }

    private VersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.flow = (String)Preconditions.checkNotNull((Object)builder.getFlow());
        this.version = (String)Preconditions.checkNotNull((Object)builder.getVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getFlow() {
        return this.flow;
    }

    public String getVersion() {
        return this.version;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VersionName of(String project, String location, String agent, String flow, String version) {
        return VersionName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setFlow(flow).setVersion(version).build();
    }

    public static String format(String project, String location, String agent, String flow, String version) {
        return VersionName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setFlow(flow).setVersion(version).build().toString();
    }

    public static VersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT_FLOW_VERSION.validatedMatch(formattedString, "VersionName.parse: formattedString not in valid format");
        return VersionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("flow"), (String)matchMap.get("version"));
    }

    public static List<VersionName> parseList(List<String> formattedStrings) {
        ArrayList<VersionName> list = new ArrayList<VersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_FLOW_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VersionName versionName = this;
            synchronized (versionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.flow != null) {
                        fieldMapBuilder.put((Object)"flow", (Object)this.flow);
                    }
                    if (this.version != null) {
                        fieldMapBuilder.put((Object)"version", (Object)this.version);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT_FLOW_VERSION.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "flow", this.flow, "version", this.version});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            VersionName that = (VersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.flow, that.flow) && Objects.equals(this.version, that.version);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        h ^= Objects.hashCode(this.flow);
        h *= 1000003;
        return h ^= Objects.hashCode(this.version);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String flow;
        private String version;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getFlow() {
            return this.flow;
        }

        public String getVersion() {
            return this.version;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setFlow(String flow) {
            this.flow = flow;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        private Builder(VersionName versionName) {
            this.project = versionName.project;
            this.location = versionName.location;
            this.agent = versionName.agent;
            this.flow = versionName.flow;
            this.version = versionName.version;
        }

        public VersionName build() {
            return new VersionName(this);
        }
    }
}

