/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/experiment.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * A list of flow version variants.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.VersionVariants}
 */
public final class VersionVariants extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.VersionVariants)
    VersionVariantsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VersionVariants.newBuilder() to construct.
  private VersionVariants(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VersionVariants() {
    variants_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VersionVariants();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.ExperimentProto
        .internal_static_google_cloud_dialogflow_cx_v3_VersionVariants_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.ExperimentProto
        .internal_static_google_cloud_dialogflow_cx_v3_VersionVariants_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.VersionVariants.class,
            com.google.cloud.dialogflow.cx.v3.VersionVariants.Builder.class);
  }

  public interface VariantOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.VersionVariants.Variant)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the flow version.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;`.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The version.
     */
    java.lang.String getVersion();
    /**
     *
     *
     * <pre>
     * The name of the flow version.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;`.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The bytes for version.
     */
    com.google.protobuf.ByteString getVersionBytes();

    /**
     *
     *
     * <pre>
     * Percentage of the traffic which should be routed to this
     * version of flow. Traffic allocation for a single flow must sum up to 1.0.
     * </pre>
     *
     * <code>float traffic_allocation = 2;</code>
     *
     * @return The trafficAllocation.
     */
    float getTrafficAllocation();

    /**
     *
     *
     * <pre>
     * Whether the variant is for the control group.
     * </pre>
     *
     * <code>bool is_control_group = 3;</code>
     *
     * @return The isControlGroup.
     */
    boolean getIsControlGroup();
  }
  /**
   *
   *
   * <pre>
   * A single flow version with specified traffic allocation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.VersionVariants.Variant}
   */
  public static final class Variant extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.VersionVariants.Variant)
      VariantOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Variant.newBuilder() to construct.
    private Variant(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Variant() {
      version_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Variant();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_VersionVariants_Variant_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_VersionVariants_Variant_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.class,
              com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.Builder.class);
    }

    public static final int VERSION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * The name of the flow version.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;`.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the flow version.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;`.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The bytes for version.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TRAFFIC_ALLOCATION_FIELD_NUMBER = 2;
    private float trafficAllocation_ = 0F;
    /**
     *
     *
     * <pre>
     * Percentage of the traffic which should be routed to this
     * version of flow. Traffic allocation for a single flow must sum up to 1.0.
     * </pre>
     *
     * <code>float traffic_allocation = 2;</code>
     *
     * @return The trafficAllocation.
     */
    @java.lang.Override
    public float getTrafficAllocation() {
      return trafficAllocation_;
    }

    public static final int IS_CONTROL_GROUP_FIELD_NUMBER = 3;
    private boolean isControlGroup_ = false;
    /**
     *
     *
     * <pre>
     * Whether the variant is for the control group.
     * </pre>
     *
     * <code>bool is_control_group = 3;</code>
     *
     * @return The isControlGroup.
     */
    @java.lang.Override
    public boolean getIsControlGroup() {
      return isControlGroup_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
      }
      if (java.lang.Float.floatToRawIntBits(trafficAllocation_) != 0) {
        output.writeFloat(2, trafficAllocation_);
      }
      if (isControlGroup_ != false) {
        output.writeBool(3, isControlGroup_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
      }
      if (java.lang.Float.floatToRawIntBits(trafficAllocation_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, trafficAllocation_);
      }
      if (isControlGroup_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, isControlGroup_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant other =
          (com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant) obj;

      if (!getVersion().equals(other.getVersion())) return false;
      if (java.lang.Float.floatToIntBits(getTrafficAllocation())
          != java.lang.Float.floatToIntBits(other.getTrafficAllocation())) return false;
      if (getIsControlGroup() != other.getIsControlGroup()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
      hash = (37 * hash) + TRAFFIC_ALLOCATION_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getTrafficAllocation());
      hash = (37 * hash) + IS_CONTROL_GROUP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsControlGroup());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A single flow version with specified traffic allocation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.VersionVariants.Variant}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.VersionVariants.Variant)
        com.google.cloud.dialogflow.cx.v3.VersionVariants.VariantOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_VersionVariants_Variant_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_VersionVariants_Variant_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.class,
                com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        version_ = "";
        trafficAllocation_ = 0F;
        isControlGroup_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.ExperimentProto
            .internal_static_google_cloud_dialogflow_cx_v3_VersionVariants_Variant_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant build() {
        com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant buildPartial() {
        com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant result =
            new com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.version_ = version_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.trafficAllocation_ = trafficAllocation_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.isControlGroup_ = isControlGroup_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant other) {
        if (other == com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.getDefaultInstance())
          return this;
        if (!other.getVersion().isEmpty()) {
          version_ = other.version_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getTrafficAllocation() != 0F) {
          setTrafficAllocation(other.getTrafficAllocation());
        }
        if (other.getIsControlGroup() != false) {
          setIsControlGroup(other.getIsControlGroup());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  version_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 21:
                {
                  trafficAllocation_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              case 24:
                {
                  isControlGroup_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object version_ = "";
      /**
       *
       *
       * <pre>
       * The name of the flow version.
       * Format:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;`.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return The version.
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the flow version.
       * Format:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;`.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return The bytes for version.
       */
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the flow version.
       * Format:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;`.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        version_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the flow version.
       * Format:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;`.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVersion() {
        version_ = getDefaultInstance().getVersion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the flow version.
       * Format:
       * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/versions/&lt;VersionID&gt;`.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @param value The bytes for version to set.
       * @return This builder for chaining.
       */
      public Builder setVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        version_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private float trafficAllocation_;
      /**
       *
       *
       * <pre>
       * Percentage of the traffic which should be routed to this
       * version of flow. Traffic allocation for a single flow must sum up to 1.0.
       * </pre>
       *
       * <code>float traffic_allocation = 2;</code>
       *
       * @return The trafficAllocation.
       */
      @java.lang.Override
      public float getTrafficAllocation() {
        return trafficAllocation_;
      }
      /**
       *
       *
       * <pre>
       * Percentage of the traffic which should be routed to this
       * version of flow. Traffic allocation for a single flow must sum up to 1.0.
       * </pre>
       *
       * <code>float traffic_allocation = 2;</code>
       *
       * @param value The trafficAllocation to set.
       * @return This builder for chaining.
       */
      public Builder setTrafficAllocation(float value) {

        trafficAllocation_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Percentage of the traffic which should be routed to this
       * version of flow. Traffic allocation for a single flow must sum up to 1.0.
       * </pre>
       *
       * <code>float traffic_allocation = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTrafficAllocation() {
        bitField0_ = (bitField0_ & ~0x00000002);
        trafficAllocation_ = 0F;
        onChanged();
        return this;
      }

      private boolean isControlGroup_;
      /**
       *
       *
       * <pre>
       * Whether the variant is for the control group.
       * </pre>
       *
       * <code>bool is_control_group = 3;</code>
       *
       * @return The isControlGroup.
       */
      @java.lang.Override
      public boolean getIsControlGroup() {
        return isControlGroup_;
      }
      /**
       *
       *
       * <pre>
       * Whether the variant is for the control group.
       * </pre>
       *
       * <code>bool is_control_group = 3;</code>
       *
       * @param value The isControlGroup to set.
       * @return This builder for chaining.
       */
      public Builder setIsControlGroup(boolean value) {

        isControlGroup_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether the variant is for the control group.
       * </pre>
       *
       * <code>bool is_control_group = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsControlGroup() {
        bitField0_ = (bitField0_ & ~0x00000004);
        isControlGroup_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.VersionVariants.Variant)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.VersionVariants.Variant)
    private static final com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant();
    }

    public static com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Variant> PARSER =
        new com.google.protobuf.AbstractParser<Variant>() {
          @java.lang.Override
          public Variant parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Variant> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Variant> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int VARIANTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant> variants_;
  /**
   *
   *
   * <pre>
   * A list of flow version variants.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant>
      getVariantsList() {
    return variants_;
  }
  /**
   *
   *
   * <pre>
   * A list of flow version variants.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3.VersionVariants.VariantOrBuilder>
      getVariantsOrBuilderList() {
    return variants_;
  }
  /**
   *
   *
   * <pre>
   * A list of flow version variants.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
   */
  @java.lang.Override
  public int getVariantsCount() {
    return variants_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of flow version variants.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant getVariants(int index) {
    return variants_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of flow version variants.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.VersionVariants.VariantOrBuilder getVariantsOrBuilder(
      int index) {
    return variants_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < variants_.size(); i++) {
      output.writeMessage(1, variants_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < variants_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, variants_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.VersionVariants)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.VersionVariants other =
        (com.google.cloud.dialogflow.cx.v3.VersionVariants) obj;

    if (!getVariantsList().equals(other.getVariantsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getVariantsCount() > 0) {
      hash = (37 * hash) + VARIANTS_FIELD_NUMBER;
      hash = (53 * hash) + getVariantsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.VersionVariants prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A list of flow version variants.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.VersionVariants}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.VersionVariants)
      com.google.cloud.dialogflow.cx.v3.VersionVariantsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_VersionVariants_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_VersionVariants_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.VersionVariants.class,
              com.google.cloud.dialogflow.cx.v3.VersionVariants.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.VersionVariants.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (variantsBuilder_ == null) {
        variants_ = java.util.Collections.emptyList();
      } else {
        variants_ = null;
        variantsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.ExperimentProto
          .internal_static_google_cloud_dialogflow_cx_v3_VersionVariants_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.VersionVariants getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.VersionVariants.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.VersionVariants build() {
      com.google.cloud.dialogflow.cx.v3.VersionVariants result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.VersionVariants buildPartial() {
      com.google.cloud.dialogflow.cx.v3.VersionVariants result =
          new com.google.cloud.dialogflow.cx.v3.VersionVariants(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3.VersionVariants result) {
      if (variantsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          variants_ = java.util.Collections.unmodifiableList(variants_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.variants_ = variants_;
      } else {
        result.variants_ = variantsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.VersionVariants result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.VersionVariants) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.VersionVariants) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.VersionVariants other) {
      if (other == com.google.cloud.dialogflow.cx.v3.VersionVariants.getDefaultInstance())
        return this;
      if (variantsBuilder_ == null) {
        if (!other.variants_.isEmpty()) {
          if (variants_.isEmpty()) {
            variants_ = other.variants_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureVariantsIsMutable();
            variants_.addAll(other.variants_);
          }
          onChanged();
        }
      } else {
        if (!other.variants_.isEmpty()) {
          if (variantsBuilder_.isEmpty()) {
            variantsBuilder_.dispose();
            variantsBuilder_ = null;
            variants_ = other.variants_;
            bitField0_ = (bitField0_ & ~0x00000001);
            variantsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVariantsFieldBuilder()
                    : null;
          } else {
            variantsBuilder_.addAllMessages(other.variants_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.parser(),
                        extensionRegistry);
                if (variantsBuilder_ == null) {
                  ensureVariantsIsMutable();
                  variants_.add(m);
                } else {
                  variantsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant> variants_ =
        java.util.Collections.emptyList();

    private void ensureVariantsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        variants_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant>(
                variants_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant,
            com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.Builder,
            com.google.cloud.dialogflow.cx.v3.VersionVariants.VariantOrBuilder>
        variantsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant>
        getVariantsList() {
      if (variantsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(variants_);
      } else {
        return variantsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public int getVariantsCount() {
      if (variantsBuilder_ == null) {
        return variants_.size();
      } else {
        return variantsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant getVariants(int index) {
      if (variantsBuilder_ == null) {
        return variants_.get(index);
      } else {
        return variantsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public Builder setVariants(
        int index, com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant value) {
      if (variantsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVariantsIsMutable();
        variants_.set(index, value);
        onChanged();
      } else {
        variantsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public Builder setVariants(
        int index,
        com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.Builder builderForValue) {
      if (variantsBuilder_ == null) {
        ensureVariantsIsMutable();
        variants_.set(index, builderForValue.build());
        onChanged();
      } else {
        variantsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public Builder addVariants(com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant value) {
      if (variantsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVariantsIsMutable();
        variants_.add(value);
        onChanged();
      } else {
        variantsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public Builder addVariants(
        int index, com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant value) {
      if (variantsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVariantsIsMutable();
        variants_.add(index, value);
        onChanged();
      } else {
        variantsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public Builder addVariants(
        com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.Builder builderForValue) {
      if (variantsBuilder_ == null) {
        ensureVariantsIsMutable();
        variants_.add(builderForValue.build());
        onChanged();
      } else {
        variantsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public Builder addVariants(
        int index,
        com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.Builder builderForValue) {
      if (variantsBuilder_ == null) {
        ensureVariantsIsMutable();
        variants_.add(index, builderForValue.build());
        onChanged();
      } else {
        variantsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public Builder addAllVariants(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant>
            values) {
      if (variantsBuilder_ == null) {
        ensureVariantsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, variants_);
        onChanged();
      } else {
        variantsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public Builder clearVariants() {
      if (variantsBuilder_ == null) {
        variants_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        variantsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public Builder removeVariants(int index) {
      if (variantsBuilder_ == null) {
        ensureVariantsIsMutable();
        variants_.remove(index);
        onChanged();
      } else {
        variantsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.Builder getVariantsBuilder(
        int index) {
      return getVariantsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.VersionVariants.VariantOrBuilder getVariantsOrBuilder(
        int index) {
      if (variantsBuilder_ == null) {
        return variants_.get(index);
      } else {
        return variantsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3.VersionVariants.VariantOrBuilder>
        getVariantsOrBuilderList() {
      if (variantsBuilder_ != null) {
        return variantsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(variants_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.Builder addVariantsBuilder() {
      return getVariantsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.Builder addVariantsBuilder(
        int index) {
      return getVariantsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of flow version variants.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.VersionVariants.Variant variants = 1;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.Builder>
        getVariantsBuilderList() {
      return getVariantsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant,
            com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.Builder,
            com.google.cloud.dialogflow.cx.v3.VersionVariants.VariantOrBuilder>
        getVariantsFieldBuilder() {
      if (variantsBuilder_ == null) {
        variantsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant,
                com.google.cloud.dialogflow.cx.v3.VersionVariants.Variant.Builder,
                com.google.cloud.dialogflow.cx.v3.VersionVariants.VariantOrBuilder>(
                variants_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        variants_ = null;
      }
      return variantsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.VersionVariants)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.VersionVariants)
  private static final com.google.cloud.dialogflow.cx.v3.VersionVariants DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.VersionVariants();
  }

  public static com.google.cloud.dialogflow.cx.v3.VersionVariants getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VersionVariants> PARSER =
      new com.google.protobuf.AbstractParser<VersionVariants>() {
        @java.lang.Override
        public VersionVariants parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VersionVariants> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VersionVariants> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.VersionVariants getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
