/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/transition_route_group.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * A TransitionRouteGroup represents a group of
 * [`TransitionRoutes`][google.cloud.dialogflow.cx.v3.TransitionRoute] to be
 * used by a [Page][google.cloud.dialogflow.cx.v3.Page].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.TransitionRouteGroup}
 */
public final class TransitionRouteGroup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.TransitionRouteGroup)
    TransitionRouteGroupOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransitionRouteGroup.newBuilder() to construct.
  private TransitionRouteGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransitionRouteGroup() {
    name_ = "";
    displayName_ = "";
    transitionRoutes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransitionRouteGroup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.TransitionRouteGroupProto
        .internal_static_google_cloud_dialogflow_cx_v3_TransitionRouteGroup_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.TransitionRouteGroupProto
        .internal_static_google_cloud_dialogflow_cx_v3_TransitionRouteGroup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup.class,
            com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the transition route group.
   * [TransitionRouteGroups.CreateTransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroups.CreateTransitionRouteGroup]
   * populates the name automatically. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/transitionRouteGroups/&lt;TransitionRouteGroupID&gt;`
   * .
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the transition route group.
   * [TransitionRouteGroups.CreateTransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroups.CreateTransitionRouteGroup]
   * populates the name automatically. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/transitionRouteGroups/&lt;TransitionRouteGroupID&gt;`
   * .
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the transition route group, unique
   * within the flow. The display name can be no longer than 30 characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the transition route group, unique
   * within the flow. The display name can be no longer than 30 characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSITION_ROUTES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionRoute> transitionRoutes_;
  /**
   *
   *
   * <pre>
   * Transition routes associated with the
   * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionRoute>
      getTransitionRoutesList() {
    return transitionRoutes_;
  }
  /**
   *
   *
   * <pre>
   * Transition routes associated with the
   * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>
      getTransitionRoutesOrBuilderList() {
    return transitionRoutes_;
  }
  /**
   *
   *
   * <pre>
   * Transition routes associated with the
   * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
   */
  @java.lang.Override
  public int getTransitionRoutesCount() {
    return transitionRoutes_.size();
  }
  /**
   *
   *
   * <pre>
   * Transition routes associated with the
   * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TransitionRoute getTransitionRoutes(int index) {
    return transitionRoutes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Transition routes associated with the
   * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder getTransitionRoutesOrBuilder(
      int index) {
    return transitionRoutes_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    for (int i = 0; i < transitionRoutes_.size(); i++) {
      output.writeMessage(5, transitionRoutes_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    for (int i = 0; i < transitionRoutes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, transitionRoutes_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup other =
        (com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getTransitionRoutesList().equals(other.getTransitionRoutesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getTransitionRoutesCount() > 0) {
      hash = (37 * hash) + TRANSITION_ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + getTransitionRoutesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A TransitionRouteGroup represents a group of
   * [`TransitionRoutes`][google.cloud.dialogflow.cx.v3.TransitionRoute] to be
   * used by a [Page][google.cloud.dialogflow.cx.v3.Page].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.TransitionRouteGroup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.TransitionRouteGroup)
      com.google.cloud.dialogflow.cx.v3.TransitionRouteGroupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.TransitionRouteGroupProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionRouteGroup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.TransitionRouteGroupProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionRouteGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup.class,
              com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      if (transitionRoutesBuilder_ == null) {
        transitionRoutes_ = java.util.Collections.emptyList();
      } else {
        transitionRoutes_ = null;
        transitionRoutesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.TransitionRouteGroupProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionRouteGroup_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup build() {
      com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup buildPartial() {
      com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup result =
          new com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup result) {
      if (transitionRoutesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          transitionRoutes_ = java.util.Collections.unmodifiableList(transitionRoutes_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.transitionRoutes_ = transitionRoutes_;
      } else {
        result.transitionRoutes_ = transitionRoutesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup other) {
      if (other == com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (transitionRoutesBuilder_ == null) {
        if (!other.transitionRoutes_.isEmpty()) {
          if (transitionRoutes_.isEmpty()) {
            transitionRoutes_ = other.transitionRoutes_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureTransitionRoutesIsMutable();
            transitionRoutes_.addAll(other.transitionRoutes_);
          }
          onChanged();
        }
      } else {
        if (!other.transitionRoutes_.isEmpty()) {
          if (transitionRoutesBuilder_.isEmpty()) {
            transitionRoutesBuilder_.dispose();
            transitionRoutesBuilder_ = null;
            transitionRoutes_ = other.transitionRoutes_;
            bitField0_ = (bitField0_ & ~0x00000004);
            transitionRoutesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTransitionRoutesFieldBuilder()
                    : null;
          } else {
            transitionRoutesBuilder_.addAllMessages(other.transitionRoutes_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 42:
              {
                com.google.cloud.dialogflow.cx.v3.TransitionRoute m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.TransitionRoute.parser(),
                        extensionRegistry);
                if (transitionRoutesBuilder_ == null) {
                  ensureTransitionRoutesIsMutable();
                  transitionRoutes_.add(m);
                } else {
                  transitionRoutesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the transition route group.
     * [TransitionRouteGroups.CreateTransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroups.CreateTransitionRouteGroup]
     * populates the name automatically. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/transitionRouteGroups/&lt;TransitionRouteGroupID&gt;`
     * .
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the transition route group.
     * [TransitionRouteGroups.CreateTransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroups.CreateTransitionRouteGroup]
     * populates the name automatically. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/transitionRouteGroups/&lt;TransitionRouteGroupID&gt;`
     * .
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the transition route group.
     * [TransitionRouteGroups.CreateTransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroups.CreateTransitionRouteGroup]
     * populates the name automatically. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/transitionRouteGroups/&lt;TransitionRouteGroupID&gt;`
     * .
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the transition route group.
     * [TransitionRouteGroups.CreateTransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroups.CreateTransitionRouteGroup]
     * populates the name automatically. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/transitionRouteGroups/&lt;TransitionRouteGroupID&gt;`
     * .
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the transition route group.
     * [TransitionRouteGroups.CreateTransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroups.CreateTransitionRouteGroup]
     * populates the name automatically. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/transitionRouteGroups/&lt;TransitionRouteGroupID&gt;`
     * .
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the transition route group, unique
     * within the flow. The display name can be no longer than 30 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the transition route group, unique
     * within the flow. The display name can be no longer than 30 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the transition route group, unique
     * within the flow. The display name can be no longer than 30 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the transition route group, unique
     * within the flow. The display name can be no longer than 30 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the transition route group, unique
     * within the flow. The display name can be no longer than 30 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionRoute> transitionRoutes_ =
        java.util.Collections.emptyList();

    private void ensureTransitionRoutesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        transitionRoutes_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.TransitionRoute>(
                transitionRoutes_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.TransitionRoute,
            com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder,
            com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>
        transitionRoutesBuilder_;

    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionRoute>
        getTransitionRoutesList() {
      if (transitionRoutesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(transitionRoutes_);
      } else {
        return transitionRoutesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public int getTransitionRoutesCount() {
      if (transitionRoutesBuilder_ == null) {
        return transitionRoutes_.size();
      } else {
        return transitionRoutesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionRoute getTransitionRoutes(int index) {
      if (transitionRoutesBuilder_ == null) {
        return transitionRoutes_.get(index);
      } else {
        return transitionRoutesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public Builder setTransitionRoutes(
        int index, com.google.cloud.dialogflow.cx.v3.TransitionRoute value) {
      if (transitionRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.set(index, value);
        onChanged();
      } else {
        transitionRoutesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public Builder setTransitionRoutes(
        int index, com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder builderForValue) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.set(index, builderForValue.build());
        onChanged();
      } else {
        transitionRoutesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public Builder addTransitionRoutes(com.google.cloud.dialogflow.cx.v3.TransitionRoute value) {
      if (transitionRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.add(value);
        onChanged();
      } else {
        transitionRoutesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public Builder addTransitionRoutes(
        int index, com.google.cloud.dialogflow.cx.v3.TransitionRoute value) {
      if (transitionRoutesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.add(index, value);
        onChanged();
      } else {
        transitionRoutesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public Builder addTransitionRoutes(
        com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder builderForValue) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.add(builderForValue.build());
        onChanged();
      } else {
        transitionRoutesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public Builder addTransitionRoutes(
        int index, com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder builderForValue) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.add(index, builderForValue.build());
        onChanged();
      } else {
        transitionRoutesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public Builder addAllTransitionRoutes(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.TransitionRoute> values) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transitionRoutes_);
        onChanged();
      } else {
        transitionRoutesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public Builder clearTransitionRoutes() {
      if (transitionRoutesBuilder_ == null) {
        transitionRoutes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        transitionRoutesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public Builder removeTransitionRoutes(int index) {
      if (transitionRoutesBuilder_ == null) {
        ensureTransitionRoutesIsMutable();
        transitionRoutes_.remove(index);
        onChanged();
      } else {
        transitionRoutesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder getTransitionRoutesBuilder(
        int index) {
      return getTransitionRoutesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder getTransitionRoutesOrBuilder(
        int index) {
      if (transitionRoutesBuilder_ == null) {
        return transitionRoutes_.get(index);
      } else {
        return transitionRoutesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>
        getTransitionRoutesOrBuilderList() {
      if (transitionRoutesBuilder_ != null) {
        return transitionRoutesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(transitionRoutes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder addTransitionRoutesBuilder() {
      return getTransitionRoutesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder addTransitionRoutesBuilder(
        int index) {
      return getTransitionRoutesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Transition routes associated with the
     * [TransitionRouteGroup][google.cloud.dialogflow.cx.v3.TransitionRouteGroup].
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.TransitionRoute transition_routes = 5;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder>
        getTransitionRoutesBuilderList() {
      return getTransitionRoutesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.TransitionRoute,
            com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder,
            com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>
        getTransitionRoutesFieldBuilder() {
      if (transitionRoutesBuilder_ == null) {
        transitionRoutesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.TransitionRoute,
                com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder,
                com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder>(
                transitionRoutes_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        transitionRoutes_ = null;
      }
      return transitionRoutesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.TransitionRouteGroup)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.TransitionRouteGroup)
  private static final com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup();
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransitionRouteGroup> PARSER =
      new com.google.protobuf.AbstractParser<TransitionRouteGroup>() {
        @java.lang.Override
        public TransitionRouteGroup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransitionRouteGroup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransitionRouteGroup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TransitionRouteGroup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
