/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/page.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * A transition route specifies a [intent][google.cloud.dialogflow.cx.v3.Intent]
 * that can be matched and/or a data condition that can be evaluated during a
 * session. When a specified transition is matched, the following actions are
 * taken in order:
 *
 * *   If there is a
 * [`trigger_fulfillment`][google.cloud.dialogflow.cx.v3.TransitionRoute.trigger_fulfillment]
 * associated with the transition, it will be called.
 * *   If there is a
 * [`target_page`][google.cloud.dialogflow.cx.v3.TransitionRoute.target_page]
 * associated with the transition, the session will transition into the
 * specified page.
 * *   If there is a
 * [`target_flow`][google.cloud.dialogflow.cx.v3.TransitionRoute.target_flow]
 * associated with the transition, the session will transition into the
 * specified flow.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.TransitionRoute}
 */
public final class TransitionRoute extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.TransitionRoute)
    TransitionRouteOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransitionRoute.newBuilder() to construct.
  private TransitionRoute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransitionRoute() {
    name_ = "";
    description_ = "";
    intent_ = "";
    condition_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransitionRoute();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.PageProto
        .internal_static_google_cloud_dialogflow_cx_v3_TransitionRoute_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.PageProto
        .internal_static_google_cloud_dialogflow_cx_v3_TransitionRoute_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.TransitionRoute.class,
            com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder.class);
  }

  private int bitField0_;
  private int targetCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object target_;

  public enum TargetCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TARGET_PAGE(4),
    TARGET_FLOW(5),
    TARGET_NOT_SET(0);
    private final int value;

    private TargetCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetCase valueOf(int value) {
      return forNumber(value);
    }

    public static TargetCase forNumber(int value) {
      switch (value) {
        case 4:
          return TARGET_PAGE;
        case 5:
          return TARGET_FLOW;
        case 0:
          return TARGET_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TargetCase getTargetCase() {
    return TargetCase.forNumber(targetCase_);
  }

  public static final int NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The unique identifier of this transition route.
   * </pre>
   *
   * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The unique identifier of this transition route.
   * </pre>
   *
   * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The description of the transition route. The maximum length is
   * 500 characters.
   * </pre>
   *
   * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The description of the transition route. The maximum length is
   * 500 characters.
   * </pre>
   *
   * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object intent_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of an [Intent][google.cloud.dialogflow.cx.v3.Intent].
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
   * Indicates that the transition can only happen when the given intent is
   * matched.
   * At least one of `intent` or `condition` must be specified. When both
   * `intent` and `condition` are specified, the transition can only happen
   * when both are fulfilled.
   * </pre>
   *
   * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The intent.
   */
  @java.lang.Override
  public java.lang.String getIntent() {
    java.lang.Object ref = intent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      intent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of an [Intent][google.cloud.dialogflow.cx.v3.Intent].
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
   * Indicates that the transition can only happen when the given intent is
   * matched.
   * At least one of `intent` or `condition` must be specified. When both
   * `intent` and `condition` are specified, the transition can only happen
   * when both are fulfilled.
   * </pre>
   *
   * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for intent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIntentBytes() {
    java.lang.Object ref = intent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      intent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONDITION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object condition_ = "";
  /**
   *
   *
   * <pre>
   * The condition to evaluate against [form
   * parameters][google.cloud.dialogflow.cx.v3.Form.parameters] or [session
   * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
   *
   * See the [conditions
   * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
   * At least one of `intent` or `condition` must be specified. When both
   * `intent` and `condition` are specified, the transition can only happen
   * when both are fulfilled.
   * </pre>
   *
   * <code>string condition = 2;</code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public java.lang.String getCondition() {
    java.lang.Object ref = condition_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      condition_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The condition to evaluate against [form
   * parameters][google.cloud.dialogflow.cx.v3.Form.parameters] or [session
   * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
   *
   * See the [conditions
   * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
   * At least one of `intent` or `condition` must be specified. When both
   * `intent` and `condition` are specified, the transition can only happen
   * when both are fulfilled.
   * </pre>
   *
   * <code>string condition = 2;</code>
   *
   * @return The bytes for condition.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConditionBytes() {
    java.lang.Object ref = condition_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      condition_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIGGER_FULFILLMENT_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.cx.v3.Fulfillment triggerFulfillment_;
  /**
   *
   *
   * <pre>
   * The fulfillment to call when the condition is satisfied. At least one of
   * `trigger_fulfillment` and `target` must be specified. When both are
   * defined, `trigger_fulfillment` is executed first.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 3;</code>
   *
   * @return Whether the triggerFulfillment field is set.
   */
  @java.lang.Override
  public boolean hasTriggerFulfillment() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The fulfillment to call when the condition is satisfied. At least one of
   * `trigger_fulfillment` and `target` must be specified. When both are
   * defined, `trigger_fulfillment` is executed first.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 3;</code>
   *
   * @return The triggerFulfillment.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Fulfillment getTriggerFulfillment() {
    return triggerFulfillment_ == null
        ? com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance()
        : triggerFulfillment_;
  }
  /**
   *
   *
   * <pre>
   * The fulfillment to call when the condition is satisfied. At least one of
   * `trigger_fulfillment` and `target` must be specified. When both are
   * defined, `trigger_fulfillment` is executed first.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder getTriggerFulfillmentOrBuilder() {
    return triggerFulfillment_ == null
        ? com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance()
        : triggerFulfillment_;
  }

  public static final int TARGET_PAGE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The target page to transition to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
   * </pre>
   *
   * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the targetPage field is set.
   */
  public boolean hasTargetPage() {
    return targetCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The target page to transition to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
   * </pre>
   *
   * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The targetPage.
   */
  public java.lang.String getTargetPage() {
    java.lang.Object ref = "";
    if (targetCase_ == 4) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (targetCase_ == 4) {
        target_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The target page to transition to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
   * </pre>
   *
   * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for targetPage.
   */
  public com.google.protobuf.ByteString getTargetPageBytes() {
    java.lang.Object ref = "";
    if (targetCase_ == 4) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (targetCase_ == 4) {
        target_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_FLOW_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The target flow to transition to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
   * </pre>
   *
   * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the targetFlow field is set.
   */
  public boolean hasTargetFlow() {
    return targetCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The target flow to transition to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
   * </pre>
   *
   * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The targetFlow.
   */
  public java.lang.String getTargetFlow() {
    java.lang.Object ref = "";
    if (targetCase_ == 5) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (targetCase_ == 5) {
        target_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The target flow to transition to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
   * </pre>
   *
   * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for targetFlow.
   */
  public com.google.protobuf.ByteString getTargetFlowBytes() {
    java.lang.Object ref = "";
    if (targetCase_ == 5) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (targetCase_ == 5) {
        target_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(intent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, intent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, condition_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getTriggerFulfillment());
    }
    if (targetCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, target_);
    }
    if (targetCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, target_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, description_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(intent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, intent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, condition_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTriggerFulfillment());
    }
    if (targetCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, target_);
    }
    if (targetCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, target_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, description_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.TransitionRoute)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.TransitionRoute other =
        (com.google.cloud.dialogflow.cx.v3.TransitionRoute) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getIntent().equals(other.getIntent())) return false;
    if (!getCondition().equals(other.getCondition())) return false;
    if (hasTriggerFulfillment() != other.hasTriggerFulfillment()) return false;
    if (hasTriggerFulfillment()) {
      if (!getTriggerFulfillment().equals(other.getTriggerFulfillment())) return false;
    }
    if (!getTargetCase().equals(other.getTargetCase())) return false;
    switch (targetCase_) {
      case 4:
        if (!getTargetPage().equals(other.getTargetPage())) return false;
        break;
      case 5:
        if (!getTargetFlow().equals(other.getTargetFlow())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + INTENT_FIELD_NUMBER;
    hash = (53 * hash) + getIntent().hashCode();
    hash = (37 * hash) + CONDITION_FIELD_NUMBER;
    hash = (53 * hash) + getCondition().hashCode();
    if (hasTriggerFulfillment()) {
      hash = (37 * hash) + TRIGGER_FULFILLMENT_FIELD_NUMBER;
      hash = (53 * hash) + getTriggerFulfillment().hashCode();
    }
    switch (targetCase_) {
      case 4:
        hash = (37 * hash) + TARGET_PAGE_FIELD_NUMBER;
        hash = (53 * hash) + getTargetPage().hashCode();
        break;
      case 5:
        hash = (37 * hash) + TARGET_FLOW_FIELD_NUMBER;
        hash = (53 * hash) + getTargetFlow().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.TransitionRoute prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A transition route specifies a [intent][google.cloud.dialogflow.cx.v3.Intent]
   * that can be matched and/or a data condition that can be evaluated during a
   * session. When a specified transition is matched, the following actions are
   * taken in order:
   *
   * *   If there is a
   * [`trigger_fulfillment`][google.cloud.dialogflow.cx.v3.TransitionRoute.trigger_fulfillment]
   * associated with the transition, it will be called.
   * *   If there is a
   * [`target_page`][google.cloud.dialogflow.cx.v3.TransitionRoute.target_page]
   * associated with the transition, the session will transition into the
   * specified page.
   * *   If there is a
   * [`target_flow`][google.cloud.dialogflow.cx.v3.TransitionRoute.target_flow]
   * associated with the transition, the session will transition into the
   * specified flow.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.TransitionRoute}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.TransitionRoute)
      com.google.cloud.dialogflow.cx.v3.TransitionRouteOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionRoute_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionRoute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.TransitionRoute.class,
              com.google.cloud.dialogflow.cx.v3.TransitionRoute.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.TransitionRoute.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTriggerFulfillmentFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      intent_ = "";
      condition_ = "";
      triggerFulfillment_ = null;
      if (triggerFulfillmentBuilder_ != null) {
        triggerFulfillmentBuilder_.dispose();
        triggerFulfillmentBuilder_ = null;
      }
      targetCase_ = 0;
      target_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.PageProto
          .internal_static_google_cloud_dialogflow_cx_v3_TransitionRoute_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionRoute getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionRoute build() {
      com.google.cloud.dialogflow.cx.v3.TransitionRoute result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TransitionRoute buildPartial() {
      com.google.cloud.dialogflow.cx.v3.TransitionRoute result =
          new com.google.cloud.dialogflow.cx.v3.TransitionRoute(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.TransitionRoute result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.intent_ = intent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.condition_ = condition_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.triggerFulfillment_ =
            triggerFulfillmentBuilder_ == null
                ? triggerFulfillment_
                : triggerFulfillmentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.cx.v3.TransitionRoute result) {
      result.targetCase_ = targetCase_;
      result.target_ = this.target_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.TransitionRoute) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.TransitionRoute) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.TransitionRoute other) {
      if (other == com.google.cloud.dialogflow.cx.v3.TransitionRoute.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getIntent().isEmpty()) {
        intent_ = other.intent_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getCondition().isEmpty()) {
        condition_ = other.condition_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasTriggerFulfillment()) {
        mergeTriggerFulfillment(other.getTriggerFulfillment());
      }
      switch (other.getTargetCase()) {
        case TARGET_PAGE:
          {
            targetCase_ = 4;
            target_ = other.target_;
            onChanged();
            break;
          }
        case TARGET_FLOW:
          {
            targetCase_ = 5;
            target_ = other.target_;
            onChanged();
            break;
          }
        case TARGET_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                intent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                condition_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getTriggerFulfillmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                targetCase_ = 4;
                target_ = s;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                targetCase_ = 5;
                target_ = s;
                break;
              } // case 42
            case 50:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 50
            case 66:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int targetCase_ = 0;
    private java.lang.Object target_;

    public TargetCase getTargetCase() {
      return TargetCase.forNumber(targetCase_);
    }

    public Builder clearTarget() {
      targetCase_ = 0;
      target_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this transition route.
     * </pre>
     *
     * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this transition route.
     * </pre>
     *
     * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this transition route.
     * </pre>
     *
     * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this transition route.
     * </pre>
     *
     * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this transition route.
     * </pre>
     *
     * <code>string name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The description of the transition route. The maximum length is
     * 500 characters.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the transition route. The maximum length is
     * 500 characters.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the transition route. The maximum length is
     * 500 characters.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the transition route. The maximum length is
     * 500 characters.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the transition route. The maximum length is
     * 500 characters.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object intent_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of an [Intent][google.cloud.dialogflow.cx.v3.Intent].
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * Indicates that the transition can only happen when the given intent is
     * matched.
     * At least one of `intent` or `condition` must be specified. When both
     * `intent` and `condition` are specified, the transition can only happen
     * when both are fulfilled.
     * </pre>
     *
     * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The intent.
     */
    public java.lang.String getIntent() {
      java.lang.Object ref = intent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        intent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of an [Intent][google.cloud.dialogflow.cx.v3.Intent].
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * Indicates that the transition can only happen when the given intent is
     * matched.
     * At least one of `intent` or `condition` must be specified. When both
     * `intent` and `condition` are specified, the transition can only happen
     * when both are fulfilled.
     * </pre>
     *
     * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for intent.
     */
    public com.google.protobuf.ByteString getIntentBytes() {
      java.lang.Object ref = intent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        intent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of an [Intent][google.cloud.dialogflow.cx.v3.Intent].
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * Indicates that the transition can only happen when the given intent is
     * matched.
     * At least one of `intent` or `condition` must be specified. When both
     * `intent` and `condition` are specified, the transition can only happen
     * when both are fulfilled.
     * </pre>
     *
     * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The intent to set.
     * @return This builder for chaining.
     */
    public Builder setIntent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      intent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of an [Intent][google.cloud.dialogflow.cx.v3.Intent].
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * Indicates that the transition can only happen when the given intent is
     * matched.
     * At least one of `intent` or `condition` must be specified. When both
     * `intent` and `condition` are specified, the transition can only happen
     * when both are fulfilled.
     * </pre>
     *
     * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntent() {
      intent_ = getDefaultInstance().getIntent();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of an [Intent][google.cloud.dialogflow.cx.v3.Intent].
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * Indicates that the transition can only happen when the given intent is
     * matched.
     * At least one of `intent` or `condition` must be specified. When both
     * `intent` and `condition` are specified, the transition can only happen
     * when both are fulfilled.
     * </pre>
     *
     * <code>string intent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for intent to set.
     * @return This builder for chaining.
     */
    public Builder setIntentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      intent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object condition_ = "";
    /**
     *
     *
     * <pre>
     * The condition to evaluate against [form
     * parameters][google.cloud.dialogflow.cx.v3.Form.parameters] or [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * At least one of `intent` or `condition` must be specified. When both
     * `intent` and `condition` are specified, the transition can only happen
     * when both are fulfilled.
     * </pre>
     *
     * <code>string condition = 2;</code>
     *
     * @return The condition.
     */
    public java.lang.String getCondition() {
      java.lang.Object ref = condition_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        condition_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The condition to evaluate against [form
     * parameters][google.cloud.dialogflow.cx.v3.Form.parameters] or [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * At least one of `intent` or `condition` must be specified. When both
     * `intent` and `condition` are specified, the transition can only happen
     * when both are fulfilled.
     * </pre>
     *
     * <code>string condition = 2;</code>
     *
     * @return The bytes for condition.
     */
    public com.google.protobuf.ByteString getConditionBytes() {
      java.lang.Object ref = condition_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        condition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The condition to evaluate against [form
     * parameters][google.cloud.dialogflow.cx.v3.Form.parameters] or [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * At least one of `intent` or `condition` must be specified. When both
     * `intent` and `condition` are specified, the transition can only happen
     * when both are fulfilled.
     * </pre>
     *
     * <code>string condition = 2;</code>
     *
     * @param value The condition to set.
     * @return This builder for chaining.
     */
    public Builder setCondition(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      condition_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The condition to evaluate against [form
     * parameters][google.cloud.dialogflow.cx.v3.Form.parameters] or [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * At least one of `intent` or `condition` must be specified. When both
     * `intent` and `condition` are specified, the transition can only happen
     * when both are fulfilled.
     * </pre>
     *
     * <code>string condition = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCondition() {
      condition_ = getDefaultInstance().getCondition();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The condition to evaluate against [form
     * parameters][google.cloud.dialogflow.cx.v3.Form.parameters] or [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * See the [conditions
     * reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
     * At least one of `intent` or `condition` must be specified. When both
     * `intent` and `condition` are specified, the transition can only happen
     * when both are fulfilled.
     * </pre>
     *
     * <code>string condition = 2;</code>
     *
     * @param value The bytes for condition to set.
     * @return This builder for chaining.
     */
    public Builder setConditionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      condition_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.Fulfillment triggerFulfillment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Fulfillment,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder,
            com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder>
        triggerFulfillmentBuilder_;
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the condition is satisfied. At least one of
     * `trigger_fulfillment` and `target` must be specified. When both are
     * defined, `trigger_fulfillment` is executed first.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 3;</code>
     *
     * @return Whether the triggerFulfillment field is set.
     */
    public boolean hasTriggerFulfillment() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the condition is satisfied. At least one of
     * `trigger_fulfillment` and `target` must be specified. When both are
     * defined, `trigger_fulfillment` is executed first.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 3;</code>
     *
     * @return The triggerFulfillment.
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment getTriggerFulfillment() {
      if (triggerFulfillmentBuilder_ == null) {
        return triggerFulfillment_ == null
            ? com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance()
            : triggerFulfillment_;
      } else {
        return triggerFulfillmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the condition is satisfied. At least one of
     * `trigger_fulfillment` and `target` must be specified. When both are
     * defined, `trigger_fulfillment` is executed first.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 3;</code>
     */
    public Builder setTriggerFulfillment(com.google.cloud.dialogflow.cx.v3.Fulfillment value) {
      if (triggerFulfillmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        triggerFulfillment_ = value;
      } else {
        triggerFulfillmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the condition is satisfied. At least one of
     * `trigger_fulfillment` and `target` must be specified. When both are
     * defined, `trigger_fulfillment` is executed first.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 3;</code>
     */
    public Builder setTriggerFulfillment(
        com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder builderForValue) {
      if (triggerFulfillmentBuilder_ == null) {
        triggerFulfillment_ = builderForValue.build();
      } else {
        triggerFulfillmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the condition is satisfied. At least one of
     * `trigger_fulfillment` and `target` must be specified. When both are
     * defined, `trigger_fulfillment` is executed first.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 3;</code>
     */
    public Builder mergeTriggerFulfillment(com.google.cloud.dialogflow.cx.v3.Fulfillment value) {
      if (triggerFulfillmentBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && triggerFulfillment_ != null
            && triggerFulfillment_
                != com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance()) {
          getTriggerFulfillmentBuilder().mergeFrom(value);
        } else {
          triggerFulfillment_ = value;
        }
      } else {
        triggerFulfillmentBuilder_.mergeFrom(value);
      }
      if (triggerFulfillment_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the condition is satisfied. At least one of
     * `trigger_fulfillment` and `target` must be specified. When both are
     * defined, `trigger_fulfillment` is executed first.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 3;</code>
     */
    public Builder clearTriggerFulfillment() {
      bitField0_ = (bitField0_ & ~0x00000010);
      triggerFulfillment_ = null;
      if (triggerFulfillmentBuilder_ != null) {
        triggerFulfillmentBuilder_.dispose();
        triggerFulfillmentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the condition is satisfied. At least one of
     * `trigger_fulfillment` and `target` must be specified. When both are
     * defined, `trigger_fulfillment` is executed first.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder getTriggerFulfillmentBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getTriggerFulfillmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the condition is satisfied. At least one of
     * `trigger_fulfillment` and `target` must be specified. When both are
     * defined, `trigger_fulfillment` is executed first.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder getTriggerFulfillmentOrBuilder() {
      if (triggerFulfillmentBuilder_ != null) {
        return triggerFulfillmentBuilder_.getMessageOrBuilder();
      } else {
        return triggerFulfillment_ == null
            ? com.google.cloud.dialogflow.cx.v3.Fulfillment.getDefaultInstance()
            : triggerFulfillment_;
      }
    }
    /**
     *
     *
     * <pre>
     * The fulfillment to call when the condition is satisfied. At least one of
     * `trigger_fulfillment` and `target` must be specified. When both are
     * defined, `trigger_fulfillment` is executed first.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Fulfillment trigger_fulfillment = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Fulfillment,
            com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder,
            com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder>
        getTriggerFulfillmentFieldBuilder() {
      if (triggerFulfillmentBuilder_ == null) {
        triggerFulfillmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Fulfillment,
                com.google.cloud.dialogflow.cx.v3.Fulfillment.Builder,
                com.google.cloud.dialogflow.cx.v3.FulfillmentOrBuilder>(
                getTriggerFulfillment(), getParentForChildren(), isClean());
        triggerFulfillment_ = null;
      }
      return triggerFulfillmentBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
     * </pre>
     *
     * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the targetPage field is set.
     */
    @java.lang.Override
    public boolean hasTargetPage() {
      return targetCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
     * </pre>
     *
     * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The targetPage.
     */
    @java.lang.Override
    public java.lang.String getTargetPage() {
      java.lang.Object ref = "";
      if (targetCase_ == 4) {
        ref = target_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (targetCase_ == 4) {
          target_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
     * </pre>
     *
     * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for targetPage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetPageBytes() {
      java.lang.Object ref = "";
      if (targetCase_ == 4) {
        ref = target_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (targetCase_ == 4) {
          target_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
     * </pre>
     *
     * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The targetPage to set.
     * @return This builder for chaining.
     */
    public Builder setTargetPage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetCase_ = 4;
      target_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
     * </pre>
     *
     * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetPage() {
      if (targetCase_ == 4) {
        targetCase_ = 0;
        target_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target page to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;/pages/&lt;PageID&gt;`.
     * </pre>
     *
     * <code>string target_page = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for targetPage to set.
     * @return This builder for chaining.
     */
    public Builder setTargetPageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetCase_ = 4;
      target_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the targetFlow field is set.
     */
    @java.lang.Override
    public boolean hasTargetFlow() {
      return targetCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The targetFlow.
     */
    @java.lang.Override
    public java.lang.String getTargetFlow() {
      java.lang.Object ref = "";
      if (targetCase_ == 5) {
        ref = target_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (targetCase_ == 5) {
          target_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for targetFlow.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetFlowBytes() {
      java.lang.Object ref = "";
      if (targetCase_ == 5) {
        ref = target_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (targetCase_ == 5) {
          target_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The targetFlow to set.
     * @return This builder for chaining.
     */
    public Builder setTargetFlow(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetCase_ = 5;
      target_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetFlow() {
      if (targetCase_ == 5) {
        targetCase_ = 0;
        target_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target flow to transition to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>string target_flow = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for targetFlow to set.
     * @return This builder for chaining.
     */
    public Builder setTargetFlowBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetCase_ = 5;
      target_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.TransitionRoute)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.TransitionRoute)
  private static final com.google.cloud.dialogflow.cx.v3.TransitionRoute DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.TransitionRoute();
  }

  public static com.google.cloud.dialogflow.cx.v3.TransitionRoute getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransitionRoute> PARSER =
      new com.google.protobuf.AbstractParser<TransitionRoute>() {
        @java.lang.Override
        public TransitionRoute parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransitionRoute> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransitionRoute> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TransitionRoute getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
