/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/security_settings.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Represents the settings related to security issues, such as data redaction
 * and data retention. It may take hours for updates on the settings to
 * propagate to all the related components and take effect.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.SecuritySettings}
 */
public final class SecuritySettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.SecuritySettings)
    SecuritySettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SecuritySettings.newBuilder() to construct.
  private SecuritySettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecuritySettings() {
    name_ = "";
    displayName_ = "";
    redactionStrategy_ = 0;
    redactionScope_ = 0;
    inspectTemplate_ = "";
    deidentifyTemplate_ = "";
    purgeDataTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecuritySettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
        .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
        .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.class,
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Defines how we redact data.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy}
   */
  public enum RedactionStrategy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Do not redact.
     * </pre>
     *
     * <code>REDACTION_STRATEGY_UNSPECIFIED = 0;</code>
     */
    REDACTION_STRATEGY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Call redaction service to clean up the data to be persisted.
     * </pre>
     *
     * <code>REDACT_WITH_SERVICE = 1;</code>
     */
    REDACT_WITH_SERVICE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Do not redact.
     * </pre>
     *
     * <code>REDACTION_STRATEGY_UNSPECIFIED = 0;</code>
     */
    public static final int REDACTION_STRATEGY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Call redaction service to clean up the data to be persisted.
     * </pre>
     *
     * <code>REDACT_WITH_SERVICE = 1;</code>
     */
    public static final int REDACT_WITH_SERVICE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RedactionStrategy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RedactionStrategy forNumber(int value) {
      switch (value) {
        case 0:
          return REDACTION_STRATEGY_UNSPECIFIED;
        case 1:
          return REDACT_WITH_SERVICE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RedactionStrategy>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RedactionStrategy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RedactionStrategy>() {
              public RedactionStrategy findValueByNumber(int number) {
                return RedactionStrategy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SecuritySettings.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final RedactionStrategy[] VALUES = values();

    public static RedactionStrategy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RedactionStrategy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy)
  }

  /**
   *
   *
   * <pre>
   * Defines what types of data to redact.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope}
   */
  public enum RedactionScope implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Don't redact any kind of data.
     * </pre>
     *
     * <code>REDACTION_SCOPE_UNSPECIFIED = 0;</code>
     */
    REDACTION_SCOPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * On data to be written to disk or similar devices that are capable of
     * holding data even if power is disconnected. This includes data that are
     * temporarily saved on disk.
     * </pre>
     *
     * <code>REDACT_DISK_STORAGE = 2;</code>
     */
    REDACT_DISK_STORAGE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Don't redact any kind of data.
     * </pre>
     *
     * <code>REDACTION_SCOPE_UNSPECIFIED = 0;</code>
     */
    public static final int REDACTION_SCOPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * On data to be written to disk or similar devices that are capable of
     * holding data even if power is disconnected. This includes data that are
     * temporarily saved on disk.
     * </pre>
     *
     * <code>REDACT_DISK_STORAGE = 2;</code>
     */
    public static final int REDACT_DISK_STORAGE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RedactionScope valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RedactionScope forNumber(int value) {
      switch (value) {
        case 0:
          return REDACTION_SCOPE_UNSPECIFIED;
        case 2:
          return REDACT_DISK_STORAGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RedactionScope> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RedactionScope> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RedactionScope>() {
          public RedactionScope findValueByNumber(int number) {
            return RedactionScope.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SecuritySettings.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final RedactionScope[] VALUES = values();

    public static RedactionScope valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RedactionScope(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope)
  }

  /**
   *
   *
   * <pre>
   * Defines how long we retain persisted data that contains sensitive info.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy}
   */
  public enum RetentionStrategy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Retains the persisted data with Dialogflow's internal default 365d TTLs.
     * </pre>
     *
     * <code>RETENTION_STRATEGY_UNSPECIFIED = 0;</code>
     */
    RETENTION_STRATEGY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Removes data when the conversation ends. If there is no [Conversation][]
     * explicitly established, a default conversation ends when the
     * corresponding Dialogflow session ends.
     * </pre>
     *
     * <code>REMOVE_AFTER_CONVERSATION = 1;</code>
     */
    REMOVE_AFTER_CONVERSATION(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Retains the persisted data with Dialogflow's internal default 365d TTLs.
     * </pre>
     *
     * <code>RETENTION_STRATEGY_UNSPECIFIED = 0;</code>
     */
    public static final int RETENTION_STRATEGY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Removes data when the conversation ends. If there is no [Conversation][]
     * explicitly established, a default conversation ends when the
     * corresponding Dialogflow session ends.
     * </pre>
     *
     * <code>REMOVE_AFTER_CONVERSATION = 1;</code>
     */
    public static final int REMOVE_AFTER_CONVERSATION_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RetentionStrategy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RetentionStrategy forNumber(int value) {
      switch (value) {
        case 0:
          return RETENTION_STRATEGY_UNSPECIFIED;
        case 1:
          return REMOVE_AFTER_CONVERSATION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RetentionStrategy>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RetentionStrategy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RetentionStrategy>() {
              public RetentionStrategy findValueByNumber(int number) {
                return RetentionStrategy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SecuritySettings.getDescriptor()
          .getEnumTypes()
          .get(2);
    }

    private static final RetentionStrategy[] VALUES = values();

    public static RetentionStrategy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RetentionStrategy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy)
  }

  /**
   *
   *
   * <pre>
   * Type of data we purge after retention settings triggers purge.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType}
   */
  public enum PurgeDataType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. Do not use.
     * </pre>
     *
     * <code>PURGE_DATA_TYPE_UNSPECIFIED = 0;</code>
     */
    PURGE_DATA_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Dialogflow history. This does not include Cloud logging, which is
     * owned by the user - not Dialogflow.
     * </pre>
     *
     * <code>DIALOGFLOW_HISTORY = 1;</code>
     */
    DIALOGFLOW_HISTORY(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. Do not use.
     * </pre>
     *
     * <code>PURGE_DATA_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int PURGE_DATA_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Dialogflow history. This does not include Cloud logging, which is
     * owned by the user - not Dialogflow.
     * </pre>
     *
     * <code>DIALOGFLOW_HISTORY = 1;</code>
     */
    public static final int DIALOGFLOW_HISTORY_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PurgeDataType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PurgeDataType forNumber(int value) {
      switch (value) {
        case 0:
          return PURGE_DATA_TYPE_UNSPECIFIED;
        case 1:
          return DIALOGFLOW_HISTORY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PurgeDataType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PurgeDataType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<PurgeDataType>() {
          public PurgeDataType findValueByNumber(int number) {
            return PurgeDataType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SecuritySettings.getDescriptor()
          .getEnumTypes()
          .get(3);
    }

    private static final PurgeDataType[] VALUES = values();

    public static PurgeDataType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PurgeDataType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType)
  }

  public interface AudioExportSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Cloud Storage bucket to export audio record to.
     * Setting this field would grant the Storage Object Creator role to
     * the Dialogflow Service Agent.
     * API caller that tries to modify this field should have the permission of
     * storage.buckets.setIamPolicy.
     * </pre>
     *
     * <code>string gcs_bucket = 1;</code>
     *
     * @return The gcsBucket.
     */
    java.lang.String getGcsBucket();
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket to export audio record to.
     * Setting this field would grant the Storage Object Creator role to
     * the Dialogflow Service Agent.
     * API caller that tries to modify this field should have the permission of
     * storage.buckets.setIamPolicy.
     * </pre>
     *
     * <code>string gcs_bucket = 1;</code>
     *
     * @return The bytes for gcsBucket.
     */
    com.google.protobuf.ByteString getGcsBucketBytes();

    /**
     *
     *
     * <pre>
     * Filename pattern for exported audio.
     * </pre>
     *
     * <code>string audio_export_pattern = 2;</code>
     *
     * @return The audioExportPattern.
     */
    java.lang.String getAudioExportPattern();
    /**
     *
     *
     * <pre>
     * Filename pattern for exported audio.
     * </pre>
     *
     * <code>string audio_export_pattern = 2;</code>
     *
     * @return The bytes for audioExportPattern.
     */
    com.google.protobuf.ByteString getAudioExportPatternBytes();

    /**
     *
     *
     * <pre>
     * Enable audio redaction if it is true.
     * Note that this only redacts end-user audio data;
     * Synthesised audio from the virtual agent is not redacted.
     * </pre>
     *
     * <code>bool enable_audio_redaction = 3;</code>
     *
     * @return The enableAudioRedaction.
     */
    boolean getEnableAudioRedaction();

    /**
     *
     *
     * <pre>
     * File format for exported audio file. Currently only in telephony
     * recordings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat audio_format = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for audioFormat.
     */
    int getAudioFormatValue();
    /**
     *
     *
     * <pre>
     * File format for exported audio file. Currently only in telephony
     * recordings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat audio_format = 4;
     * </code>
     *
     * @return The audioFormat.
     */
    com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat
        getAudioFormat();

    /**
     *
     *
     * <pre>
     * Whether to store TTS audio. By default, TTS audio from the virtual agent
     * is not exported.
     * </pre>
     *
     * <code>bool store_tts_audio = 6;</code>
     *
     * @return The storeTtsAudio.
     */
    boolean getStoreTtsAudio();
  }
  /**
   *
   *
   * <pre>
   * Settings for exporting audio.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings}
   */
  public static final class AudioExportSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings)
      AudioExportSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AudioExportSettings.newBuilder() to construct.
    private AudioExportSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AudioExportSettings() {
      gcsBucket_ = "";
      audioExportPattern_ = "";
      audioFormat_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AudioExportSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_AudioExportSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_AudioExportSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.class,
              com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * File format for exported audio file. Currently only in telephony
     * recordings.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat}
     */
    public enum AudioFormat implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified. Do not use.
       * </pre>
       *
       * <code>AUDIO_FORMAT_UNSPECIFIED = 0;</code>
       */
      AUDIO_FORMAT_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * G.711 mu-law PCM with 8kHz sample rate.
       * </pre>
       *
       * <code>MULAW = 1;</code>
       */
      MULAW(1),
      /**
       *
       *
       * <pre>
       * MP3 file format.
       * </pre>
       *
       * <code>MP3 = 2;</code>
       */
      MP3(2),
      /**
       *
       *
       * <pre>
       * OGG Vorbis.
       * </pre>
       *
       * <code>OGG = 3;</code>
       */
      OGG(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified. Do not use.
       * </pre>
       *
       * <code>AUDIO_FORMAT_UNSPECIFIED = 0;</code>
       */
      public static final int AUDIO_FORMAT_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * G.711 mu-law PCM with 8kHz sample rate.
       * </pre>
       *
       * <code>MULAW = 1;</code>
       */
      public static final int MULAW_VALUE = 1;
      /**
       *
       *
       * <pre>
       * MP3 file format.
       * </pre>
       *
       * <code>MP3 = 2;</code>
       */
      public static final int MP3_VALUE = 2;
      /**
       *
       *
       * <pre>
       * OGG Vorbis.
       * </pre>
       *
       * <code>OGG = 3;</code>
       */
      public static final int OGG_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AudioFormat valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static AudioFormat forNumber(int value) {
        switch (value) {
          case 0:
            return AUDIO_FORMAT_UNSPECIFIED;
          case 1:
            return MULAW;
          case 2:
            return MP3;
          case 3:
            return OGG;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<AudioFormat> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<AudioFormat> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<AudioFormat>() {
            public AudioFormat findValueByNumber(int number) {
              return AudioFormat.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final AudioFormat[] VALUES = values();

      public static AudioFormat valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private AudioFormat(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat)
    }

    public static final int GCS_BUCKET_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcsBucket_ = "";
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket to export audio record to.
     * Setting this field would grant the Storage Object Creator role to
     * the Dialogflow Service Agent.
     * API caller that tries to modify this field should have the permission of
     * storage.buckets.setIamPolicy.
     * </pre>
     *
     * <code>string gcs_bucket = 1;</code>
     *
     * @return The gcsBucket.
     */
    @java.lang.Override
    public java.lang.String getGcsBucket() {
      java.lang.Object ref = gcsBucket_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsBucket_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket to export audio record to.
     * Setting this field would grant the Storage Object Creator role to
     * the Dialogflow Service Agent.
     * API caller that tries to modify this field should have the permission of
     * storage.buckets.setIamPolicy.
     * </pre>
     *
     * <code>string gcs_bucket = 1;</code>
     *
     * @return The bytes for gcsBucket.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsBucketBytes() {
      java.lang.Object ref = gcsBucket_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AUDIO_EXPORT_PATTERN_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object audioExportPattern_ = "";
    /**
     *
     *
     * <pre>
     * Filename pattern for exported audio.
     * </pre>
     *
     * <code>string audio_export_pattern = 2;</code>
     *
     * @return The audioExportPattern.
     */
    @java.lang.Override
    public java.lang.String getAudioExportPattern() {
      java.lang.Object ref = audioExportPattern_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        audioExportPattern_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Filename pattern for exported audio.
     * </pre>
     *
     * <code>string audio_export_pattern = 2;</code>
     *
     * @return The bytes for audioExportPattern.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAudioExportPatternBytes() {
      java.lang.Object ref = audioExportPattern_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        audioExportPattern_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENABLE_AUDIO_REDACTION_FIELD_NUMBER = 3;
    private boolean enableAudioRedaction_ = false;
    /**
     *
     *
     * <pre>
     * Enable audio redaction if it is true.
     * Note that this only redacts end-user audio data;
     * Synthesised audio from the virtual agent is not redacted.
     * </pre>
     *
     * <code>bool enable_audio_redaction = 3;</code>
     *
     * @return The enableAudioRedaction.
     */
    @java.lang.Override
    public boolean getEnableAudioRedaction() {
      return enableAudioRedaction_;
    }

    public static final int AUDIO_FORMAT_FIELD_NUMBER = 4;
    private int audioFormat_ = 0;
    /**
     *
     *
     * <pre>
     * File format for exported audio file. Currently only in telephony
     * recordings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat audio_format = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for audioFormat.
     */
    @java.lang.Override
    public int getAudioFormatValue() {
      return audioFormat_;
    }
    /**
     *
     *
     * <pre>
     * File format for exported audio file. Currently only in telephony
     * recordings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat audio_format = 4;
     * </code>
     *
     * @return The audioFormat.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat
        getAudioFormat() {
      com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat result =
          com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat
              .forNumber(audioFormat_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat
              .UNRECOGNIZED
          : result;
    }

    public static final int STORE_TTS_AUDIO_FIELD_NUMBER = 6;
    private boolean storeTtsAudio_ = false;
    /**
     *
     *
     * <pre>
     * Whether to store TTS audio. By default, TTS audio from the virtual agent
     * is not exported.
     * </pre>
     *
     * <code>bool store_tts_audio = 6;</code>
     *
     * @return The storeTtsAudio.
     */
    @java.lang.Override
    public boolean getStoreTtsAudio() {
      return storeTtsAudio_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsBucket_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gcsBucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audioExportPattern_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, audioExportPattern_);
      }
      if (enableAudioRedaction_ != false) {
        output.writeBool(3, enableAudioRedaction_);
      }
      if (audioFormat_
          != com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat
              .AUDIO_FORMAT_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, audioFormat_);
      }
      if (storeTtsAudio_ != false) {
        output.writeBool(6, storeTtsAudio_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsBucket_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gcsBucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audioExportPattern_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, audioExportPattern_);
      }
      if (enableAudioRedaction_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, enableAudioRedaction_);
      }
      if (audioFormat_
          != com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat
              .AUDIO_FORMAT_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, audioFormat_);
      }
      if (storeTtsAudio_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, storeTtsAudio_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings other =
          (com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings) obj;

      if (!getGcsBucket().equals(other.getGcsBucket())) return false;
      if (!getAudioExportPattern().equals(other.getAudioExportPattern())) return false;
      if (getEnableAudioRedaction() != other.getEnableAudioRedaction()) return false;
      if (audioFormat_ != other.audioFormat_) return false;
      if (getStoreTtsAudio() != other.getStoreTtsAudio()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GCS_BUCKET_FIELD_NUMBER;
      hash = (53 * hash) + getGcsBucket().hashCode();
      hash = (37 * hash) + AUDIO_EXPORT_PATTERN_FIELD_NUMBER;
      hash = (53 * hash) + getAudioExportPattern().hashCode();
      hash = (37 * hash) + ENABLE_AUDIO_REDACTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableAudioRedaction());
      hash = (37 * hash) + AUDIO_FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + audioFormat_;
      hash = (37 * hash) + STORE_TTS_AUDIO_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getStoreTtsAudio());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Settings for exporting audio.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings)
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_AudioExportSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_AudioExportSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.class,
                com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        gcsBucket_ = "";
        audioExportPattern_ = "";
        enableAudioRedaction_ = false;
        audioFormat_ = 0;
        storeTtsAudio_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_AudioExportSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings build() {
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings buildPartial() {
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings result =
            new com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.gcsBucket_ = gcsBucket_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.audioExportPattern_ = audioExportPattern_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.enableAudioRedaction_ = enableAudioRedaction_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.audioFormat_ = audioFormat_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.storeTtsAudio_ = storeTtsAudio_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
                .getDefaultInstance()) return this;
        if (!other.getGcsBucket().isEmpty()) {
          gcsBucket_ = other.gcsBucket_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getAudioExportPattern().isEmpty()) {
          audioExportPattern_ = other.audioExportPattern_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.getEnableAudioRedaction() != false) {
          setEnableAudioRedaction(other.getEnableAudioRedaction());
        }
        if (other.audioFormat_ != 0) {
          setAudioFormatValue(other.getAudioFormatValue());
        }
        if (other.getStoreTtsAudio() != false) {
          setStoreTtsAudio(other.getStoreTtsAudio());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  gcsBucket_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  audioExportPattern_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  enableAudioRedaction_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  audioFormat_ = input.readEnum();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 48:
                {
                  storeTtsAudio_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 48
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object gcsBucket_ = "";
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket to export audio record to.
       * Setting this field would grant the Storage Object Creator role to
       * the Dialogflow Service Agent.
       * API caller that tries to modify this field should have the permission of
       * storage.buckets.setIamPolicy.
       * </pre>
       *
       * <code>string gcs_bucket = 1;</code>
       *
       * @return The gcsBucket.
       */
      public java.lang.String getGcsBucket() {
        java.lang.Object ref = gcsBucket_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsBucket_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket to export audio record to.
       * Setting this field would grant the Storage Object Creator role to
       * the Dialogflow Service Agent.
       * API caller that tries to modify this field should have the permission of
       * storage.buckets.setIamPolicy.
       * </pre>
       *
       * <code>string gcs_bucket = 1;</code>
       *
       * @return The bytes for gcsBucket.
       */
      public com.google.protobuf.ByteString getGcsBucketBytes() {
        java.lang.Object ref = gcsBucket_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsBucket_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket to export audio record to.
       * Setting this field would grant the Storage Object Creator role to
       * the Dialogflow Service Agent.
       * API caller that tries to modify this field should have the permission of
       * storage.buckets.setIamPolicy.
       * </pre>
       *
       * <code>string gcs_bucket = 1;</code>
       *
       * @param value The gcsBucket to set.
       * @return This builder for chaining.
       */
      public Builder setGcsBucket(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcsBucket_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket to export audio record to.
       * Setting this field would grant the Storage Object Creator role to
       * the Dialogflow Service Agent.
       * API caller that tries to modify this field should have the permission of
       * storage.buckets.setIamPolicy.
       * </pre>
       *
       * <code>string gcs_bucket = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsBucket() {
        gcsBucket_ = getDefaultInstance().getGcsBucket();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket to export audio record to.
       * Setting this field would grant the Storage Object Creator role to
       * the Dialogflow Service Agent.
       * API caller that tries to modify this field should have the permission of
       * storage.buckets.setIamPolicy.
       * </pre>
       *
       * <code>string gcs_bucket = 1;</code>
       *
       * @param value The bytes for gcsBucket to set.
       * @return This builder for chaining.
       */
      public Builder setGcsBucketBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcsBucket_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object audioExportPattern_ = "";
      /**
       *
       *
       * <pre>
       * Filename pattern for exported audio.
       * </pre>
       *
       * <code>string audio_export_pattern = 2;</code>
       *
       * @return The audioExportPattern.
       */
      public java.lang.String getAudioExportPattern() {
        java.lang.Object ref = audioExportPattern_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          audioExportPattern_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Filename pattern for exported audio.
       * </pre>
       *
       * <code>string audio_export_pattern = 2;</code>
       *
       * @return The bytes for audioExportPattern.
       */
      public com.google.protobuf.ByteString getAudioExportPatternBytes() {
        java.lang.Object ref = audioExportPattern_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          audioExportPattern_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Filename pattern for exported audio.
       * </pre>
       *
       * <code>string audio_export_pattern = 2;</code>
       *
       * @param value The audioExportPattern to set.
       * @return This builder for chaining.
       */
      public Builder setAudioExportPattern(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        audioExportPattern_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Filename pattern for exported audio.
       * </pre>
       *
       * <code>string audio_export_pattern = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAudioExportPattern() {
        audioExportPattern_ = getDefaultInstance().getAudioExportPattern();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Filename pattern for exported audio.
       * </pre>
       *
       * <code>string audio_export_pattern = 2;</code>
       *
       * @param value The bytes for audioExportPattern to set.
       * @return This builder for chaining.
       */
      public Builder setAudioExportPatternBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        audioExportPattern_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private boolean enableAudioRedaction_;
      /**
       *
       *
       * <pre>
       * Enable audio redaction if it is true.
       * Note that this only redacts end-user audio data;
       * Synthesised audio from the virtual agent is not redacted.
       * </pre>
       *
       * <code>bool enable_audio_redaction = 3;</code>
       *
       * @return The enableAudioRedaction.
       */
      @java.lang.Override
      public boolean getEnableAudioRedaction() {
        return enableAudioRedaction_;
      }
      /**
       *
       *
       * <pre>
       * Enable audio redaction if it is true.
       * Note that this only redacts end-user audio data;
       * Synthesised audio from the virtual agent is not redacted.
       * </pre>
       *
       * <code>bool enable_audio_redaction = 3;</code>
       *
       * @param value The enableAudioRedaction to set.
       * @return This builder for chaining.
       */
      public Builder setEnableAudioRedaction(boolean value) {

        enableAudioRedaction_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enable audio redaction if it is true.
       * Note that this only redacts end-user audio data;
       * Synthesised audio from the virtual agent is not redacted.
       * </pre>
       *
       * <code>bool enable_audio_redaction = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableAudioRedaction() {
        bitField0_ = (bitField0_ & ~0x00000004);
        enableAudioRedaction_ = false;
        onChanged();
        return this;
      }

      private int audioFormat_ = 0;
      /**
       *
       *
       * <pre>
       * File format for exported audio file. Currently only in telephony
       * recordings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat audio_format = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for audioFormat.
       */
      @java.lang.Override
      public int getAudioFormatValue() {
        return audioFormat_;
      }
      /**
       *
       *
       * <pre>
       * File format for exported audio file. Currently only in telephony
       * recordings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat audio_format = 4;
       * </code>
       *
       * @param value The enum numeric value on the wire for audioFormat to set.
       * @return This builder for chaining.
       */
      public Builder setAudioFormatValue(int value) {
        audioFormat_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * File format for exported audio file. Currently only in telephony
       * recordings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat audio_format = 4;
       * </code>
       *
       * @return The audioFormat.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat
          getAudioFormat() {
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat result =
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat
                .forNumber(audioFormat_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * File format for exported audio file. Currently only in telephony
       * recordings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat audio_format = 4;
       * </code>
       *
       * @param value The audioFormat to set.
       * @return This builder for chaining.
       */
      public Builder setAudioFormat(
          com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        audioFormat_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * File format for exported audio file. Currently only in telephony
       * recordings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.AudioFormat audio_format = 4;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAudioFormat() {
        bitField0_ = (bitField0_ & ~0x00000008);
        audioFormat_ = 0;
        onChanged();
        return this;
      }

      private boolean storeTtsAudio_;
      /**
       *
       *
       * <pre>
       * Whether to store TTS audio. By default, TTS audio from the virtual agent
       * is not exported.
       * </pre>
       *
       * <code>bool store_tts_audio = 6;</code>
       *
       * @return The storeTtsAudio.
       */
      @java.lang.Override
      public boolean getStoreTtsAudio() {
        return storeTtsAudio_;
      }
      /**
       *
       *
       * <pre>
       * Whether to store TTS audio. By default, TTS audio from the virtual agent
       * is not exported.
       * </pre>
       *
       * <code>bool store_tts_audio = 6;</code>
       *
       * @param value The storeTtsAudio to set.
       * @return This builder for chaining.
       */
      public Builder setStoreTtsAudio(boolean value) {

        storeTtsAudio_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether to store TTS audio. By default, TTS audio from the virtual agent
       * is not exported.
       * </pre>
       *
       * <code>bool store_tts_audio = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStoreTtsAudio() {
        bitField0_ = (bitField0_ & ~0x00000010);
        storeTtsAudio_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings)
    private static final com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AudioExportSettings> PARSER =
        new com.google.protobuf.AbstractParser<AudioExportSettings>() {
          @java.lang.Override
          public AudioExportSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AudioExportSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AudioExportSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InsightsExportSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If enabled, we will automatically exports
     * conversations to Insights and Insights runs its analyzers.
     * </pre>
     *
     * <code>bool enable_insights_export = 1;</code>
     *
     * @return The enableInsightsExport.
     */
    boolean getEnableInsightsExport();
  }
  /**
   *
   *
   * <pre>
   * Settings for exporting conversations to
   * [Insights](https://cloud.google.com/contact-center/insights/docs).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings}
   */
  public static final class InsightsExportSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings)
      InsightsExportSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InsightsExportSettings.newBuilder() to construct.
    private InsightsExportSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InsightsExportSettings() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InsightsExportSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_InsightsExportSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_InsightsExportSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings.class,
              com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings.Builder
                  .class);
    }

    public static final int ENABLE_INSIGHTS_EXPORT_FIELD_NUMBER = 1;
    private boolean enableInsightsExport_ = false;
    /**
     *
     *
     * <pre>
     * If enabled, we will automatically exports
     * conversations to Insights and Insights runs its analyzers.
     * </pre>
     *
     * <code>bool enable_insights_export = 1;</code>
     *
     * @return The enableInsightsExport.
     */
    @java.lang.Override
    public boolean getEnableInsightsExport() {
      return enableInsightsExport_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enableInsightsExport_ != false) {
        output.writeBool(1, enableInsightsExport_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enableInsightsExport_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enableInsightsExport_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings other =
          (com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings) obj;

      if (getEnableInsightsExport() != other.getEnableInsightsExport()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLE_INSIGHTS_EXPORT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableInsightsExport());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Settings for exporting conversations to
     * [Insights](https://cloud.google.com/contact-center/insights/docs).
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings)
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_InsightsExportSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_InsightsExportSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings.class,
                com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enableInsightsExport_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
            .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_InsightsExportSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings build() {
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings result =
            new com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enableInsightsExport_ = enableInsightsExport_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
                .getDefaultInstance()) return this;
        if (other.getEnableInsightsExport() != false) {
          setEnableInsightsExport(other.getEnableInsightsExport());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enableInsightsExport_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enableInsightsExport_;
      /**
       *
       *
       * <pre>
       * If enabled, we will automatically exports
       * conversations to Insights and Insights runs its analyzers.
       * </pre>
       *
       * <code>bool enable_insights_export = 1;</code>
       *
       * @return The enableInsightsExport.
       */
      @java.lang.Override
      public boolean getEnableInsightsExport() {
        return enableInsightsExport_;
      }
      /**
       *
       *
       * <pre>
       * If enabled, we will automatically exports
       * conversations to Insights and Insights runs its analyzers.
       * </pre>
       *
       * <code>bool enable_insights_export = 1;</code>
       *
       * @param value The enableInsightsExport to set.
       * @return This builder for chaining.
       */
      public Builder setEnableInsightsExport(boolean value) {

        enableInsightsExport_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If enabled, we will automatically exports
       * conversations to Insights and Insights runs its analyzers.
       * </pre>
       *
       * <code>bool enable_insights_export = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableInsightsExport() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enableInsightsExport_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings)
    private static final com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InsightsExportSettings> PARSER =
        new com.google.protobuf.AbstractParser<InsightsExportSettings>() {
          @java.lang.Override
          public InsightsExportSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InsightsExportSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InsightsExportSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int dataRetentionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object dataRetention_;

  public enum DataRetentionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RETENTION_WINDOW_DAYS(6),
    RETENTION_STRATEGY(7),
    DATARETENTION_NOT_SET(0);
    private final int value;

    private DataRetentionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataRetentionCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataRetentionCase forNumber(int value) {
      switch (value) {
        case 6:
          return RETENTION_WINDOW_DAYS;
        case 7:
          return RETENTION_STRATEGY;
        case 0:
          return DATARETENTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataRetentionCase getDataRetentionCase() {
    return DataRetentionCase.forNumber(dataRetentionCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Resource name of the settings.
   * Required for the
   * [SecuritySettingsService.UpdateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.UpdateSecuritySettings]
   * method.
   * [SecuritySettingsService.CreateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.CreateSecuritySettings]
   * populates the name automatically. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name of the settings.
   * Required for the
   * [SecuritySettingsService.UpdateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.UpdateSecuritySettings]
   * method.
   * [SecuritySettingsService.CreateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.CreateSecuritySettings]
   * populates the name automatically. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the security settings, unique within
   * the location.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the security settings, unique within
   * the location.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REDACTION_STRATEGY_FIELD_NUMBER = 3;
  private int redactionStrategy_ = 0;
  /**
   *
   *
   * <pre>
   * Strategy that defines how we do redaction.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy redaction_strategy = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for redactionStrategy.
   */
  @java.lang.Override
  public int getRedactionStrategyValue() {
    return redactionStrategy_;
  }
  /**
   *
   *
   * <pre>
   * Strategy that defines how we do redaction.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy redaction_strategy = 3;
   * </code>
   *
   * @return The redactionStrategy.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy
      getRedactionStrategy() {
    com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy result =
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy.forNumber(
            redactionStrategy_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy.UNRECOGNIZED
        : result;
  }

  public static final int REDACTION_SCOPE_FIELD_NUMBER = 4;
  private int redactionScope_ = 0;
  /**
   *
   *
   * <pre>
   * Defines the data for which Dialogflow applies redaction. Dialogflow does
   * not redact data that it does not have access to – for example, Cloud
   * logging.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope redaction_scope = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for redactionScope.
   */
  @java.lang.Override
  public int getRedactionScopeValue() {
    return redactionScope_;
  }
  /**
   *
   *
   * <pre>
   * Defines the data for which Dialogflow applies redaction. Dialogflow does
   * not redact data that it does not have access to – for example, Cloud
   * logging.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope redaction_scope = 4;
   * </code>
   *
   * @return The redactionScope.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope getRedactionScope() {
    com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope result =
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope.forNumber(
            redactionScope_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope.UNRECOGNIZED
        : result;
  }

  public static final int INSPECT_TEMPLATE_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object inspectTemplate_ = "";
  /**
   *
   *
   * <pre>
   * [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this
   * template to define inspect base settings.
   *
   * The `DLP Inspect Templates Reader` role is needed on the Dialogflow
   * service identity service account (has the form
   * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
   * for your agent's project.
   *
   * If empty, we use the default DLP inspect config.
   *
   * The template name will have one of the following formats:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
   * OR
   * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
   *
   * Note: `inspect_template` must be located in the same region as the
   * `SecuritySettings`.
   * </pre>
   *
   * <code>string inspect_template = 9 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The inspectTemplate.
   */
  @java.lang.Override
  public java.lang.String getInspectTemplate() {
    java.lang.Object ref = inspectTemplate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inspectTemplate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this
   * template to define inspect base settings.
   *
   * The `DLP Inspect Templates Reader` role is needed on the Dialogflow
   * service identity service account (has the form
   * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
   * for your agent's project.
   *
   * If empty, we use the default DLP inspect config.
   *
   * The template name will have one of the following formats:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
   * OR
   * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
   *
   * Note: `inspect_template` must be located in the same region as the
   * `SecuritySettings`.
   * </pre>
   *
   * <code>string inspect_template = 9 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for inspectTemplate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInspectTemplateBytes() {
    java.lang.Object ref = inspectTemplate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inspectTemplate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEIDENTIFY_TEMPLATE_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deidentifyTemplate_ = "";
  /**
   *
   *
   * <pre>
   * [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this
   * template to define de-identification configuration for the content.
   *
   * The `DLP De-identify Templates Reader` role is needed on the Dialogflow
   * service identity service account (has the form
   * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
   * for your agent's project.
   *
   * If empty, Dialogflow replaces sensitive info with `[redacted]` text.
   *
   * The template name will have one of the following formats:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
   * OR
   * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
   *
   * Note: `deidentify_template` must be located in the same region as the
   * `SecuritySettings`.
   * </pre>
   *
   * <code>string deidentify_template = 17 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The deidentifyTemplate.
   */
  @java.lang.Override
  public java.lang.String getDeidentifyTemplate() {
    java.lang.Object ref = deidentifyTemplate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deidentifyTemplate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this
   * template to define de-identification configuration for the content.
   *
   * The `DLP De-identify Templates Reader` role is needed on the Dialogflow
   * service identity service account (has the form
   * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
   * for your agent's project.
   *
   * If empty, Dialogflow replaces sensitive info with `[redacted]` text.
   *
   * The template name will have one of the following formats:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
   * OR
   * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
   *
   * Note: `deidentify_template` must be located in the same region as the
   * `SecuritySettings`.
   * </pre>
   *
   * <code>string deidentify_template = 17 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for deidentifyTemplate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeidentifyTemplateBytes() {
    java.lang.Object ref = deidentifyTemplate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deidentifyTemplate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RETENTION_WINDOW_DAYS_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Retains the data for the specified number of days.
   * User must set a value lower than Dialogflow's default 365d TTL (30 days
   * for Agent Assist traffic), higher value will be ignored and use default.
   * Setting a value higher than that has no effect. A missing value or
   * setting to 0 also means we use default TTL.
   * When data retention configuration is changed, it only applies to the data
   * created after the change; the TTL of existing data created before the
   * change stays intact.
   * </pre>
   *
   * <code>int32 retention_window_days = 6;</code>
   *
   * @return Whether the retentionWindowDays field is set.
   */
  @java.lang.Override
  public boolean hasRetentionWindowDays() {
    return dataRetentionCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Retains the data for the specified number of days.
   * User must set a value lower than Dialogflow's default 365d TTL (30 days
   * for Agent Assist traffic), higher value will be ignored and use default.
   * Setting a value higher than that has no effect. A missing value or
   * setting to 0 also means we use default TTL.
   * When data retention configuration is changed, it only applies to the data
   * created after the change; the TTL of existing data created before the
   * change stays intact.
   * </pre>
   *
   * <code>int32 retention_window_days = 6;</code>
   *
   * @return The retentionWindowDays.
   */
  @java.lang.Override
  public int getRetentionWindowDays() {
    if (dataRetentionCase_ == 6) {
      return (java.lang.Integer) dataRetention_;
    }
    return 0;
  }

  public static final int RETENTION_STRATEGY_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Specifies the retention behavior defined by
   * [SecuritySettings.RetentionStrategy][google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy].
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy retention_strategy = 7;
   * </code>
   *
   * @return Whether the retentionStrategy field is set.
   */
  public boolean hasRetentionStrategy() {
    return dataRetentionCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Specifies the retention behavior defined by
   * [SecuritySettings.RetentionStrategy][google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy].
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy retention_strategy = 7;
   * </code>
   *
   * @return The enum numeric value on the wire for retentionStrategy.
   */
  public int getRetentionStrategyValue() {
    if (dataRetentionCase_ == 7) {
      return (java.lang.Integer) dataRetention_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * Specifies the retention behavior defined by
   * [SecuritySettings.RetentionStrategy][google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy].
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy retention_strategy = 7;
   * </code>
   *
   * @return The retentionStrategy.
   */
  public com.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy
      getRetentionStrategy() {
    if (dataRetentionCase_ == 7) {
      com.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy result =
          com.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy.forNumber(
              (java.lang.Integer) dataRetention_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy.UNRECOGNIZED
          : result;
    }
    return com.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy
        .RETENTION_STRATEGY_UNSPECIFIED;
  }

  public static final int PURGE_DATA_TYPES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> purgeDataTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType>
      purgeDataTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType>() {
            public com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType convert(
                java.lang.Integer from) {
              com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType result =
                  com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType.forNumber(from);
              return result == null
                  ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * List of types of data to remove when retention settings triggers purge.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
   * </code>
   *
   * @return A list containing the purgeDataTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType>
      getPurgeDataTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType>(
        purgeDataTypes_, purgeDataTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * List of types of data to remove when retention settings triggers purge.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
   * </code>
   *
   * @return The count of purgeDataTypes.
   */
  @java.lang.Override
  public int getPurgeDataTypesCount() {
    return purgeDataTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * List of types of data to remove when retention settings triggers purge.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The purgeDataTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType getPurgeDataTypes(
      int index) {
    return purgeDataTypes_converter_.convert(purgeDataTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * List of types of data to remove when retention settings triggers purge.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for purgeDataTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getPurgeDataTypesValueList() {
    return purgeDataTypes_;
  }
  /**
   *
   *
   * <pre>
   * List of types of data to remove when retention settings triggers purge.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of purgeDataTypes at the given index.
   */
  @java.lang.Override
  public int getPurgeDataTypesValue(int index) {
    return purgeDataTypes_.get(index);
  }

  private int purgeDataTypesMemoizedSerializedSize;

  public static final int AUDIO_EXPORT_SETTINGS_FIELD_NUMBER = 12;
  private com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
      audioExportSettings_;
  /**
   *
   *
   * <pre>
   * Controls audio export settings for post-conversation analytics when
   * ingesting audio to conversations via [Participants.AnalyzeContent][] or
   * [Participants.StreamingAnalyzeContent][].
   *
   * If
   * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
   * is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
   * is empty, audio export is disabled.
   *
   * If audio export is enabled, audio is recorded and saved to
   * [audio_export_settings.gcs_bucket][], subject to retention policy of
   * [audio_export_settings.gcs_bucket][].
   *
   * This setting won't effect audio input for implicit sessions via
   * [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent]
   * or
   * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3.Sessions.StreamingDetectIntent].
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings audio_export_settings = 12;
   * </code>
   *
   * @return Whether the audioExportSettings field is set.
   */
  @java.lang.Override
  public boolean hasAudioExportSettings() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Controls audio export settings for post-conversation analytics when
   * ingesting audio to conversations via [Participants.AnalyzeContent][] or
   * [Participants.StreamingAnalyzeContent][].
   *
   * If
   * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
   * is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
   * is empty, audio export is disabled.
   *
   * If audio export is enabled, audio is recorded and saved to
   * [audio_export_settings.gcs_bucket][], subject to retention policy of
   * [audio_export_settings.gcs_bucket][].
   *
   * This setting won't effect audio input for implicit sessions via
   * [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent]
   * or
   * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3.Sessions.StreamingDetectIntent].
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings audio_export_settings = 12;
   * </code>
   *
   * @return The audioExportSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
      getAudioExportSettings() {
    return audioExportSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
            .getDefaultInstance()
        : audioExportSettings_;
  }
  /**
   *
   *
   * <pre>
   * Controls audio export settings for post-conversation analytics when
   * ingesting audio to conversations via [Participants.AnalyzeContent][] or
   * [Participants.StreamingAnalyzeContent][].
   *
   * If
   * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
   * is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
   * is empty, audio export is disabled.
   *
   * If audio export is enabled, audio is recorded and saved to
   * [audio_export_settings.gcs_bucket][], subject to retention policy of
   * [audio_export_settings.gcs_bucket][].
   *
   * This setting won't effect audio input for implicit sessions via
   * [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent]
   * or
   * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3.Sessions.StreamingDetectIntent].
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings audio_export_settings = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettingsOrBuilder
      getAudioExportSettingsOrBuilder() {
    return audioExportSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
            .getDefaultInstance()
        : audioExportSettings_;
  }

  public static final int INSIGHTS_EXPORT_SETTINGS_FIELD_NUMBER = 13;
  private com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
      insightsExportSettings_;
  /**
   *
   *
   * <pre>
   * Controls conversation exporting settings to Insights after conversation is
   * completed.
   *
   * If
   * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
   * is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
   * what you configure here.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings insights_export_settings = 13;
   * </code>
   *
   * @return Whether the insightsExportSettings field is set.
   */
  @java.lang.Override
  public boolean hasInsightsExportSettings() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Controls conversation exporting settings to Insights after conversation is
   * completed.
   *
   * If
   * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
   * is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
   * what you configure here.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings insights_export_settings = 13;
   * </code>
   *
   * @return The insightsExportSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
      getInsightsExportSettings() {
    return insightsExportSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
            .getDefaultInstance()
        : insightsExportSettings_;
  }
  /**
   *
   *
   * <pre>
   * Controls conversation exporting settings to Insights after conversation is
   * completed.
   *
   * If
   * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
   * is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
   * what you configure here.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings insights_export_settings = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettingsOrBuilder
      getInsightsExportSettingsOrBuilder() {
    return insightsExportSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
            .getDefaultInstance()
        : insightsExportSettings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (redactionStrategy_
        != com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy
            .REDACTION_STRATEGY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, redactionStrategy_);
    }
    if (redactionScope_
        != com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope
            .REDACTION_SCOPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, redactionScope_);
    }
    if (dataRetentionCase_ == 6) {
      output.writeInt32(6, (int) ((java.lang.Integer) dataRetention_));
    }
    if (dataRetentionCase_ == 7) {
      output.writeEnum(7, ((java.lang.Integer) dataRetention_));
    }
    if (getPurgeDataTypesList().size() > 0) {
      output.writeUInt32NoTag(66);
      output.writeUInt32NoTag(purgeDataTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < purgeDataTypes_.size(); i++) {
      output.writeEnumNoTag(purgeDataTypes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inspectTemplate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, inspectTemplate_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(12, getAudioExportSettings());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(13, getInsightsExportSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deidentifyTemplate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, deidentifyTemplate_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (redactionStrategy_
        != com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy
            .REDACTION_STRATEGY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, redactionStrategy_);
    }
    if (redactionScope_
        != com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope
            .REDACTION_SCOPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, redactionScope_);
    }
    if (dataRetentionCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              6, (int) ((java.lang.Integer) dataRetention_));
    }
    if (dataRetentionCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              7, ((java.lang.Integer) dataRetention_));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < purgeDataTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(purgeDataTypes_.get(i));
      }
      size += dataSize;
      if (!getPurgeDataTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      purgeDataTypesMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inspectTemplate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, inspectTemplate_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(12, getAudioExportSettings());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, getInsightsExportSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deidentifyTemplate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, deidentifyTemplate_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.SecuritySettings)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.SecuritySettings other =
        (com.google.cloud.dialogflow.cx.v3.SecuritySettings) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (redactionStrategy_ != other.redactionStrategy_) return false;
    if (redactionScope_ != other.redactionScope_) return false;
    if (!getInspectTemplate().equals(other.getInspectTemplate())) return false;
    if (!getDeidentifyTemplate().equals(other.getDeidentifyTemplate())) return false;
    if (!purgeDataTypes_.equals(other.purgeDataTypes_)) return false;
    if (hasAudioExportSettings() != other.hasAudioExportSettings()) return false;
    if (hasAudioExportSettings()) {
      if (!getAudioExportSettings().equals(other.getAudioExportSettings())) return false;
    }
    if (hasInsightsExportSettings() != other.hasInsightsExportSettings()) return false;
    if (hasInsightsExportSettings()) {
      if (!getInsightsExportSettings().equals(other.getInsightsExportSettings())) return false;
    }
    if (!getDataRetentionCase().equals(other.getDataRetentionCase())) return false;
    switch (dataRetentionCase_) {
      case 6:
        if (getRetentionWindowDays() != other.getRetentionWindowDays()) return false;
        break;
      case 7:
        if (getRetentionStrategyValue() != other.getRetentionStrategyValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + REDACTION_STRATEGY_FIELD_NUMBER;
    hash = (53 * hash) + redactionStrategy_;
    hash = (37 * hash) + REDACTION_SCOPE_FIELD_NUMBER;
    hash = (53 * hash) + redactionScope_;
    hash = (37 * hash) + INSPECT_TEMPLATE_FIELD_NUMBER;
    hash = (53 * hash) + getInspectTemplate().hashCode();
    hash = (37 * hash) + DEIDENTIFY_TEMPLATE_FIELD_NUMBER;
    hash = (53 * hash) + getDeidentifyTemplate().hashCode();
    if (getPurgeDataTypesCount() > 0) {
      hash = (37 * hash) + PURGE_DATA_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + purgeDataTypes_.hashCode();
    }
    if (hasAudioExportSettings()) {
      hash = (37 * hash) + AUDIO_EXPORT_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getAudioExportSettings().hashCode();
    }
    if (hasInsightsExportSettings()) {
      hash = (37 * hash) + INSIGHTS_EXPORT_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getInsightsExportSettings().hashCode();
    }
    switch (dataRetentionCase_) {
      case 6:
        hash = (37 * hash) + RETENTION_WINDOW_DAYS_FIELD_NUMBER;
        hash = (53 * hash) + getRetentionWindowDays();
        break;
      case 7:
        hash = (37 * hash) + RETENTION_STRATEGY_FIELD_NUMBER;
        hash = (53 * hash) + getRetentionStrategyValue();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.SecuritySettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the settings related to security issues, such as data redaction
   * and data retention. It may take hours for updates on the settings to
   * propagate to all the related components and take effect.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.SecuritySettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.SecuritySettings)
      com.google.cloud.dialogflow.cx.v3.SecuritySettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.SecuritySettings.class,
              com.google.cloud.dialogflow.cx.v3.SecuritySettings.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.SecuritySettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAudioExportSettingsFieldBuilder();
        getInsightsExportSettingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      redactionStrategy_ = 0;
      redactionScope_ = 0;
      inspectTemplate_ = "";
      deidentifyTemplate_ = "";
      purgeDataTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      audioExportSettings_ = null;
      if (audioExportSettingsBuilder_ != null) {
        audioExportSettingsBuilder_.dispose();
        audioExportSettingsBuilder_ = null;
      }
      insightsExportSettings_ = null;
      if (insightsExportSettingsBuilder_ != null) {
        insightsExportSettingsBuilder_.dispose();
        insightsExportSettingsBuilder_ = null;
      }
      dataRetentionCase_ = 0;
      dataRetention_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.SecuritySettingsProto
          .internal_static_google_cloud_dialogflow_cx_v3_SecuritySettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.SecuritySettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings build() {
      com.google.cloud.dialogflow.cx.v3.SecuritySettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings buildPartial() {
      com.google.cloud.dialogflow.cx.v3.SecuritySettings result =
          new com.google.cloud.dialogflow.cx.v3.SecuritySettings(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings result) {
      if (((bitField0_ & 0x00000100) != 0)) {
        purgeDataTypes_ = java.util.Collections.unmodifiableList(purgeDataTypes_);
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.purgeDataTypes_ = purgeDataTypes_;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.SecuritySettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.redactionStrategy_ = redactionStrategy_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.redactionScope_ = redactionScope_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.inspectTemplate_ = inspectTemplate_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.deidentifyTemplate_ = deidentifyTemplate_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.audioExportSettings_ =
            audioExportSettingsBuilder_ == null
                ? audioExportSettings_
                : audioExportSettingsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.insightsExportSettings_ =
            insightsExportSettingsBuilder_ == null
                ? insightsExportSettings_
                : insightsExportSettingsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.cx.v3.SecuritySettings result) {
      result.dataRetentionCase_ = dataRetentionCase_;
      result.dataRetention_ = this.dataRetention_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.SecuritySettings) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.SecuritySettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.SecuritySettings other) {
      if (other == com.google.cloud.dialogflow.cx.v3.SecuritySettings.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.redactionStrategy_ != 0) {
        setRedactionStrategyValue(other.getRedactionStrategyValue());
      }
      if (other.redactionScope_ != 0) {
        setRedactionScopeValue(other.getRedactionScopeValue());
      }
      if (!other.getInspectTemplate().isEmpty()) {
        inspectTemplate_ = other.inspectTemplate_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDeidentifyTemplate().isEmpty()) {
        deidentifyTemplate_ = other.deidentifyTemplate_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.purgeDataTypes_.isEmpty()) {
        if (purgeDataTypes_.isEmpty()) {
          purgeDataTypes_ = other.purgeDataTypes_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensurePurgeDataTypesIsMutable();
          purgeDataTypes_.addAll(other.purgeDataTypes_);
        }
        onChanged();
      }
      if (other.hasAudioExportSettings()) {
        mergeAudioExportSettings(other.getAudioExportSettings());
      }
      if (other.hasInsightsExportSettings()) {
        mergeInsightsExportSettings(other.getInsightsExportSettings());
      }
      switch (other.getDataRetentionCase()) {
        case RETENTION_WINDOW_DAYS:
          {
            setRetentionWindowDays(other.getRetentionWindowDays());
            break;
          }
        case RETENTION_STRATEGY:
          {
            setRetentionStrategyValue(other.getRetentionStrategyValue());
            break;
          }
        case DATARETENTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                redactionStrategy_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                redactionScope_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 48:
              {
                dataRetention_ = input.readInt32();
                dataRetentionCase_ = 6;
                break;
              } // case 48
            case 56:
              {
                int rawValue = input.readEnum();
                dataRetentionCase_ = 7;
                dataRetention_ = rawValue;
                break;
              } // case 56
            case 64:
              {
                int tmpRaw = input.readEnum();
                ensurePurgeDataTypesIsMutable();
                purgeDataTypes_.add(tmpRaw);
                break;
              } // case 64
            case 66:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensurePurgeDataTypesIsMutable();
                  purgeDataTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 66
            case 74:
              {
                inspectTemplate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 74
            case 98:
              {
                input.readMessage(
                    getAudioExportSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getInsightsExportSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 106
            case 138:
              {
                deidentifyTemplate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataRetentionCase_ = 0;
    private java.lang.Object dataRetention_;

    public DataRetentionCase getDataRetentionCase() {
      return DataRetentionCase.forNumber(dataRetentionCase_);
    }

    public Builder clearDataRetention() {
      dataRetentionCase_ = 0;
      dataRetention_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Resource name of the settings.
     * Required for the
     * [SecuritySettingsService.UpdateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.UpdateSecuritySettings]
     * method.
     * [SecuritySettingsService.CreateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.CreateSecuritySettings]
     * populates the name automatically. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the settings.
     * Required for the
     * [SecuritySettingsService.UpdateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.UpdateSecuritySettings]
     * method.
     * [SecuritySettingsService.CreateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.CreateSecuritySettings]
     * populates the name automatically. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the settings.
     * Required for the
     * [SecuritySettingsService.UpdateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.UpdateSecuritySettings]
     * method.
     * [SecuritySettingsService.CreateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.CreateSecuritySettings]
     * populates the name automatically. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the settings.
     * Required for the
     * [SecuritySettingsService.UpdateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.UpdateSecuritySettings]
     * method.
     * [SecuritySettingsService.CreateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.CreateSecuritySettings]
     * populates the name automatically. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the settings.
     * Required for the
     * [SecuritySettingsService.UpdateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.UpdateSecuritySettings]
     * method.
     * [SecuritySettingsService.CreateSecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettingsService.CreateSecuritySettings]
     * populates the name automatically. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the security settings, unique within
     * the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the security settings, unique within
     * the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the security settings, unique within
     * the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the security settings, unique within
     * the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the security settings, unique within
     * the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int redactionStrategy_ = 0;
    /**
     *
     *
     * <pre>
     * Strategy that defines how we do redaction.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy redaction_strategy = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for redactionStrategy.
     */
    @java.lang.Override
    public int getRedactionStrategyValue() {
      return redactionStrategy_;
    }
    /**
     *
     *
     * <pre>
     * Strategy that defines how we do redaction.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy redaction_strategy = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for redactionStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setRedactionStrategyValue(int value) {
      redactionStrategy_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strategy that defines how we do redaction.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy redaction_strategy = 3;
     * </code>
     *
     * @return The redactionStrategy.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy
        getRedactionStrategy() {
      com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy result =
          com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy.forNumber(
              redactionStrategy_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Strategy that defines how we do redaction.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy redaction_strategy = 3;
     * </code>
     *
     * @param value The redactionStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setRedactionStrategy(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      redactionStrategy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strategy that defines how we do redaction.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionStrategy redaction_strategy = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRedactionStrategy() {
      bitField0_ = (bitField0_ & ~0x00000004);
      redactionStrategy_ = 0;
      onChanged();
      return this;
    }

    private int redactionScope_ = 0;
    /**
     *
     *
     * <pre>
     * Defines the data for which Dialogflow applies redaction. Dialogflow does
     * not redact data that it does not have access to – for example, Cloud
     * logging.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope redaction_scope = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for redactionScope.
     */
    @java.lang.Override
    public int getRedactionScopeValue() {
      return redactionScope_;
    }
    /**
     *
     *
     * <pre>
     * Defines the data for which Dialogflow applies redaction. Dialogflow does
     * not redact data that it does not have access to – for example, Cloud
     * logging.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope redaction_scope = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for redactionScope to set.
     * @return This builder for chaining.
     */
    public Builder setRedactionScopeValue(int value) {
      redactionScope_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the data for which Dialogflow applies redaction. Dialogflow does
     * not redact data that it does not have access to – for example, Cloud
     * logging.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope redaction_scope = 4;
     * </code>
     *
     * @return The redactionScope.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope getRedactionScope() {
      com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope result =
          com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope.forNumber(
              redactionScope_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Defines the data for which Dialogflow applies redaction. Dialogflow does
     * not redact data that it does not have access to – for example, Cloud
     * logging.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope redaction_scope = 4;
     * </code>
     *
     * @param value The redactionScope to set.
     * @return This builder for chaining.
     */
    public Builder setRedactionScope(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      redactionScope_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the data for which Dialogflow applies redaction. Dialogflow does
     * not redact data that it does not have access to – for example, Cloud
     * logging.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SecuritySettings.RedactionScope redaction_scope = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRedactionScope() {
      bitField0_ = (bitField0_ & ~0x00000008);
      redactionScope_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object inspectTemplate_ = "";
    /**
     *
     *
     * <pre>
     * [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this
     * template to define inspect base settings.
     *
     * The `DLP Inspect Templates Reader` role is needed on the Dialogflow
     * service identity service account (has the form
     * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
     * for your agent's project.
     *
     * If empty, we use the default DLP inspect config.
     *
     * The template name will have one of the following formats:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
     * OR
     * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
     *
     * Note: `inspect_template` must be located in the same region as the
     * `SecuritySettings`.
     * </pre>
     *
     * <code>string inspect_template = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The inspectTemplate.
     */
    public java.lang.String getInspectTemplate() {
      java.lang.Object ref = inspectTemplate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inspectTemplate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this
     * template to define inspect base settings.
     *
     * The `DLP Inspect Templates Reader` role is needed on the Dialogflow
     * service identity service account (has the form
     * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
     * for your agent's project.
     *
     * If empty, we use the default DLP inspect config.
     *
     * The template name will have one of the following formats:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
     * OR
     * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
     *
     * Note: `inspect_template` must be located in the same region as the
     * `SecuritySettings`.
     * </pre>
     *
     * <code>string inspect_template = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for inspectTemplate.
     */
    public com.google.protobuf.ByteString getInspectTemplateBytes() {
      java.lang.Object ref = inspectTemplate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inspectTemplate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this
     * template to define inspect base settings.
     *
     * The `DLP Inspect Templates Reader` role is needed on the Dialogflow
     * service identity service account (has the form
     * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
     * for your agent's project.
     *
     * If empty, we use the default DLP inspect config.
     *
     * The template name will have one of the following formats:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
     * OR
     * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
     *
     * Note: `inspect_template` must be located in the same region as the
     * `SecuritySettings`.
     * </pre>
     *
     * <code>string inspect_template = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The inspectTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setInspectTemplate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inspectTemplate_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this
     * template to define inspect base settings.
     *
     * The `DLP Inspect Templates Reader` role is needed on the Dialogflow
     * service identity service account (has the form
     * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
     * for your agent's project.
     *
     * If empty, we use the default DLP inspect config.
     *
     * The template name will have one of the following formats:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
     * OR
     * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
     *
     * Note: `inspect_template` must be located in the same region as the
     * `SecuritySettings`.
     * </pre>
     *
     * <code>string inspect_template = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInspectTemplate() {
      inspectTemplate_ = getDefaultInstance().getInspectTemplate();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this
     * template to define inspect base settings.
     *
     * The `DLP Inspect Templates Reader` role is needed on the Dialogflow
     * service identity service account (has the form
     * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
     * for your agent's project.
     *
     * If empty, we use the default DLP inspect config.
     *
     * The template name will have one of the following formats:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
     * OR
     * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/inspectTemplates/&lt;TemplateID&gt;`
     *
     * Note: `inspect_template` must be located in the same region as the
     * `SecuritySettings`.
     * </pre>
     *
     * <code>string inspect_template = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for inspectTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setInspectTemplateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inspectTemplate_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object deidentifyTemplate_ = "";
    /**
     *
     *
     * <pre>
     * [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this
     * template to define de-identification configuration for the content.
     *
     * The `DLP De-identify Templates Reader` role is needed on the Dialogflow
     * service identity service account (has the form
     * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
     * for your agent's project.
     *
     * If empty, Dialogflow replaces sensitive info with `[redacted]` text.
     *
     * The template name will have one of the following formats:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
     * OR
     * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
     *
     * Note: `deidentify_template` must be located in the same region as the
     * `SecuritySettings`.
     * </pre>
     *
     * <code>string deidentify_template = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The deidentifyTemplate.
     */
    public java.lang.String getDeidentifyTemplate() {
      java.lang.Object ref = deidentifyTemplate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deidentifyTemplate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this
     * template to define de-identification configuration for the content.
     *
     * The `DLP De-identify Templates Reader` role is needed on the Dialogflow
     * service identity service account (has the form
     * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
     * for your agent's project.
     *
     * If empty, Dialogflow replaces sensitive info with `[redacted]` text.
     *
     * The template name will have one of the following formats:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
     * OR
     * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
     *
     * Note: `deidentify_template` must be located in the same region as the
     * `SecuritySettings`.
     * </pre>
     *
     * <code>string deidentify_template = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for deidentifyTemplate.
     */
    public com.google.protobuf.ByteString getDeidentifyTemplateBytes() {
      java.lang.Object ref = deidentifyTemplate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deidentifyTemplate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this
     * template to define de-identification configuration for the content.
     *
     * The `DLP De-identify Templates Reader` role is needed on the Dialogflow
     * service identity service account (has the form
     * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
     * for your agent's project.
     *
     * If empty, Dialogflow replaces sensitive info with `[redacted]` text.
     *
     * The template name will have one of the following formats:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
     * OR
     * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
     *
     * Note: `deidentify_template` must be located in the same region as the
     * `SecuritySettings`.
     * </pre>
     *
     * <code>string deidentify_template = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The deidentifyTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setDeidentifyTemplate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deidentifyTemplate_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this
     * template to define de-identification configuration for the content.
     *
     * The `DLP De-identify Templates Reader` role is needed on the Dialogflow
     * service identity service account (has the form
     * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
     * for your agent's project.
     *
     * If empty, Dialogflow replaces sensitive info with `[redacted]` text.
     *
     * The template name will have one of the following formats:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
     * OR
     * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
     *
     * Note: `deidentify_template` must be located in the same region as the
     * `SecuritySettings`.
     * </pre>
     *
     * <code>string deidentify_template = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeidentifyTemplate() {
      deidentifyTemplate_ = getDefaultInstance().getDeidentifyTemplate();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this
     * template to define de-identification configuration for the content.
     *
     * The `DLP De-identify Templates Reader` role is needed on the Dialogflow
     * service identity service account (has the form
     * `service-PROJECT_NUMBER&#64;gcp-sa-dialogflow.iam.gserviceaccount.com`)
     * for your agent's project.
     *
     * If empty, Dialogflow replaces sensitive info with `[redacted]` text.
     *
     * The template name will have one of the following formats:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
     * OR
     * `organizations/&lt;OrganizationID&gt;/locations/&lt;LocationID&gt;/deidentifyTemplates/&lt;TemplateID&gt;`
     *
     * Note: `deidentify_template` must be located in the same region as the
     * `SecuritySettings`.
     * </pre>
     *
     * <code>string deidentify_template = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for deidentifyTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setDeidentifyTemplateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deidentifyTemplate_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Retains the data for the specified number of days.
     * User must set a value lower than Dialogflow's default 365d TTL (30 days
     * for Agent Assist traffic), higher value will be ignored and use default.
     * Setting a value higher than that has no effect. A missing value or
     * setting to 0 also means we use default TTL.
     * When data retention configuration is changed, it only applies to the data
     * created after the change; the TTL of existing data created before the
     * change stays intact.
     * </pre>
     *
     * <code>int32 retention_window_days = 6;</code>
     *
     * @return Whether the retentionWindowDays field is set.
     */
    public boolean hasRetentionWindowDays() {
      return dataRetentionCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Retains the data for the specified number of days.
     * User must set a value lower than Dialogflow's default 365d TTL (30 days
     * for Agent Assist traffic), higher value will be ignored and use default.
     * Setting a value higher than that has no effect. A missing value or
     * setting to 0 also means we use default TTL.
     * When data retention configuration is changed, it only applies to the data
     * created after the change; the TTL of existing data created before the
     * change stays intact.
     * </pre>
     *
     * <code>int32 retention_window_days = 6;</code>
     *
     * @return The retentionWindowDays.
     */
    public int getRetentionWindowDays() {
      if (dataRetentionCase_ == 6) {
        return (java.lang.Integer) dataRetention_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Retains the data for the specified number of days.
     * User must set a value lower than Dialogflow's default 365d TTL (30 days
     * for Agent Assist traffic), higher value will be ignored and use default.
     * Setting a value higher than that has no effect. A missing value or
     * setting to 0 also means we use default TTL.
     * When data retention configuration is changed, it only applies to the data
     * created after the change; the TTL of existing data created before the
     * change stays intact.
     * </pre>
     *
     * <code>int32 retention_window_days = 6;</code>
     *
     * @param value The retentionWindowDays to set.
     * @return This builder for chaining.
     */
    public Builder setRetentionWindowDays(int value) {

      dataRetentionCase_ = 6;
      dataRetention_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Retains the data for the specified number of days.
     * User must set a value lower than Dialogflow's default 365d TTL (30 days
     * for Agent Assist traffic), higher value will be ignored and use default.
     * Setting a value higher than that has no effect. A missing value or
     * setting to 0 also means we use default TTL.
     * When data retention configuration is changed, it only applies to the data
     * created after the change; the TTL of existing data created before the
     * change stays intact.
     * </pre>
     *
     * <code>int32 retention_window_days = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetentionWindowDays() {
      if (dataRetentionCase_ == 6) {
        dataRetentionCase_ = 0;
        dataRetention_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the retention behavior defined by
     * [SecuritySettings.RetentionStrategy][google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy retention_strategy = 7;
     * </code>
     *
     * @return Whether the retentionStrategy field is set.
     */
    @java.lang.Override
    public boolean hasRetentionStrategy() {
      return dataRetentionCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Specifies the retention behavior defined by
     * [SecuritySettings.RetentionStrategy][google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy retention_strategy = 7;
     * </code>
     *
     * @return The enum numeric value on the wire for retentionStrategy.
     */
    @java.lang.Override
    public int getRetentionStrategyValue() {
      if (dataRetentionCase_ == 7) {
        return ((java.lang.Integer) dataRetention_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Specifies the retention behavior defined by
     * [SecuritySettings.RetentionStrategy][google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy retention_strategy = 7;
     * </code>
     *
     * @param value The enum numeric value on the wire for retentionStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setRetentionStrategyValue(int value) {
      dataRetentionCase_ = 7;
      dataRetention_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the retention behavior defined by
     * [SecuritySettings.RetentionStrategy][google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy retention_strategy = 7;
     * </code>
     *
     * @return The retentionStrategy.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy
        getRetentionStrategy() {
      if (dataRetentionCase_ == 7) {
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy result =
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy.forNumber(
                (java.lang.Integer) dataRetention_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy
          .RETENTION_STRATEGY_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * Specifies the retention behavior defined by
     * [SecuritySettings.RetentionStrategy][google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy retention_strategy = 7;
     * </code>
     *
     * @param value The retentionStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setRetentionStrategy(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataRetentionCase_ = 7;
      dataRetention_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the retention behavior defined by
     * [SecuritySettings.RetentionStrategy][google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.RetentionStrategy retention_strategy = 7;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetentionStrategy() {
      if (dataRetentionCase_ == 7) {
        dataRetentionCase_ = 0;
        dataRetention_ = null;
        onChanged();
      }
      return this;
    }

    private java.util.List<java.lang.Integer> purgeDataTypes_ = java.util.Collections.emptyList();

    private void ensurePurgeDataTypesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        purgeDataTypes_ = new java.util.ArrayList<java.lang.Integer>(purgeDataTypes_);
        bitField0_ |= 0x00000100;
      }
    }
    /**
     *
     *
     * <pre>
     * List of types of data to remove when retention settings triggers purge.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
     * </code>
     *
     * @return A list containing the purgeDataTypes.
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType>
        getPurgeDataTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType>(
          purgeDataTypes_, purgeDataTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * List of types of data to remove when retention settings triggers purge.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
     * </code>
     *
     * @return The count of purgeDataTypes.
     */
    public int getPurgeDataTypesCount() {
      return purgeDataTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * List of types of data to remove when retention settings triggers purge.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The purgeDataTypes at the given index.
     */
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType getPurgeDataTypes(
        int index) {
      return purgeDataTypes_converter_.convert(purgeDataTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * List of types of data to remove when retention settings triggers purge.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The purgeDataTypes to set.
     * @return This builder for chaining.
     */
    public Builder setPurgeDataTypes(
        int index, com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePurgeDataTypesIsMutable();
      purgeDataTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of types of data to remove when retention settings triggers purge.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
     * </code>
     *
     * @param value The purgeDataTypes to add.
     * @return This builder for chaining.
     */
    public Builder addPurgeDataTypes(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePurgeDataTypesIsMutable();
      purgeDataTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of types of data to remove when retention settings triggers purge.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
     * </code>
     *
     * @param values The purgeDataTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllPurgeDataTypes(
        java.lang.Iterable<
                ? extends com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType>
            values) {
      ensurePurgeDataTypesIsMutable();
      for (com.google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType value : values) {
        purgeDataTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of types of data to remove when retention settings triggers purge.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPurgeDataTypes() {
      purgeDataTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of types of data to remove when retention settings triggers purge.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for purgeDataTypes.
     */
    public java.util.List<java.lang.Integer> getPurgeDataTypesValueList() {
      return java.util.Collections.unmodifiableList(purgeDataTypes_);
    }
    /**
     *
     *
     * <pre>
     * List of types of data to remove when retention settings triggers purge.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of purgeDataTypes at the given index.
     */
    public int getPurgeDataTypesValue(int index) {
      return purgeDataTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of types of data to remove when retention settings triggers purge.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for purgeDataTypes to set.
     * @return This builder for chaining.
     */
    public Builder setPurgeDataTypesValue(int index, int value) {
      ensurePurgeDataTypesIsMutable();
      purgeDataTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of types of data to remove when retention settings triggers purge.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
     * </code>
     *
     * @param value The enum numeric value on the wire for purgeDataTypes to add.
     * @return This builder for chaining.
     */
    public Builder addPurgeDataTypesValue(int value) {
      ensurePurgeDataTypesIsMutable();
      purgeDataTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of types of data to remove when retention settings triggers purge.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.SecuritySettings.PurgeDataType purge_data_types = 8;
     * </code>
     *
     * @param values The enum numeric values on the wire for purgeDataTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllPurgeDataTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensurePurgeDataTypesIsMutable();
      for (int value : values) {
        purgeDataTypes_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
        audioExportSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings,
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettingsOrBuilder>
        audioExportSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Controls audio export settings for post-conversation analytics when
     * ingesting audio to conversations via [Participants.AnalyzeContent][] or
     * [Participants.StreamingAnalyzeContent][].
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
     * is empty, audio export is disabled.
     *
     * If audio export is enabled, audio is recorded and saved to
     * [audio_export_settings.gcs_bucket][], subject to retention policy of
     * [audio_export_settings.gcs_bucket][].
     *
     * This setting won't effect audio input for implicit sessions via
     * [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent]
     * or
     * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3.Sessions.StreamingDetectIntent].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings audio_export_settings = 12;
     * </code>
     *
     * @return Whether the audioExportSettings field is set.
     */
    public boolean hasAudioExportSettings() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls audio export settings for post-conversation analytics when
     * ingesting audio to conversations via [Participants.AnalyzeContent][] or
     * [Participants.StreamingAnalyzeContent][].
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
     * is empty, audio export is disabled.
     *
     * If audio export is enabled, audio is recorded and saved to
     * [audio_export_settings.gcs_bucket][], subject to retention policy of
     * [audio_export_settings.gcs_bucket][].
     *
     * This setting won't effect audio input for implicit sessions via
     * [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent]
     * or
     * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3.Sessions.StreamingDetectIntent].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings audio_export_settings = 12;
     * </code>
     *
     * @return The audioExportSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
        getAudioExportSettings() {
      if (audioExportSettingsBuilder_ == null) {
        return audioExportSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
                .getDefaultInstance()
            : audioExportSettings_;
      } else {
        return audioExportSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Controls audio export settings for post-conversation analytics when
     * ingesting audio to conversations via [Participants.AnalyzeContent][] or
     * [Participants.StreamingAnalyzeContent][].
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
     * is empty, audio export is disabled.
     *
     * If audio export is enabled, audio is recorded and saved to
     * [audio_export_settings.gcs_bucket][], subject to retention policy of
     * [audio_export_settings.gcs_bucket][].
     *
     * This setting won't effect audio input for implicit sessions via
     * [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent]
     * or
     * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3.Sessions.StreamingDetectIntent].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings audio_export_settings = 12;
     * </code>
     */
    public Builder setAudioExportSettings(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings value) {
      if (audioExportSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        audioExportSettings_ = value;
      } else {
        audioExportSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls audio export settings for post-conversation analytics when
     * ingesting audio to conversations via [Participants.AnalyzeContent][] or
     * [Participants.StreamingAnalyzeContent][].
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
     * is empty, audio export is disabled.
     *
     * If audio export is enabled, audio is recorded and saved to
     * [audio_export_settings.gcs_bucket][], subject to retention policy of
     * [audio_export_settings.gcs_bucket][].
     *
     * This setting won't effect audio input for implicit sessions via
     * [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent]
     * or
     * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3.Sessions.StreamingDetectIntent].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings audio_export_settings = 12;
     * </code>
     */
    public Builder setAudioExportSettings(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.Builder
            builderForValue) {
      if (audioExportSettingsBuilder_ == null) {
        audioExportSettings_ = builderForValue.build();
      } else {
        audioExportSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls audio export settings for post-conversation analytics when
     * ingesting audio to conversations via [Participants.AnalyzeContent][] or
     * [Participants.StreamingAnalyzeContent][].
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
     * is empty, audio export is disabled.
     *
     * If audio export is enabled, audio is recorded and saved to
     * [audio_export_settings.gcs_bucket][], subject to retention policy of
     * [audio_export_settings.gcs_bucket][].
     *
     * This setting won't effect audio input for implicit sessions via
     * [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent]
     * or
     * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3.Sessions.StreamingDetectIntent].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings audio_export_settings = 12;
     * </code>
     */
    public Builder mergeAudioExportSettings(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings value) {
      if (audioExportSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && audioExportSettings_ != null
            && audioExportSettings_
                != com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
                    .getDefaultInstance()) {
          getAudioExportSettingsBuilder().mergeFrom(value);
        } else {
          audioExportSettings_ = value;
        }
      } else {
        audioExportSettingsBuilder_.mergeFrom(value);
      }
      if (audioExportSettings_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls audio export settings for post-conversation analytics when
     * ingesting audio to conversations via [Participants.AnalyzeContent][] or
     * [Participants.StreamingAnalyzeContent][].
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
     * is empty, audio export is disabled.
     *
     * If audio export is enabled, audio is recorded and saved to
     * [audio_export_settings.gcs_bucket][], subject to retention policy of
     * [audio_export_settings.gcs_bucket][].
     *
     * This setting won't effect audio input for implicit sessions via
     * [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent]
     * or
     * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3.Sessions.StreamingDetectIntent].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings audio_export_settings = 12;
     * </code>
     */
    public Builder clearAudioExportSettings() {
      bitField0_ = (bitField0_ & ~0x00000200);
      audioExportSettings_ = null;
      if (audioExportSettingsBuilder_ != null) {
        audioExportSettingsBuilder_.dispose();
        audioExportSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls audio export settings for post-conversation analytics when
     * ingesting audio to conversations via [Participants.AnalyzeContent][] or
     * [Participants.StreamingAnalyzeContent][].
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
     * is empty, audio export is disabled.
     *
     * If audio export is enabled, audio is recorded and saved to
     * [audio_export_settings.gcs_bucket][], subject to retention policy of
     * [audio_export_settings.gcs_bucket][].
     *
     * This setting won't effect audio input for implicit sessions via
     * [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent]
     * or
     * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3.Sessions.StreamingDetectIntent].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings audio_export_settings = 12;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.Builder
        getAudioExportSettingsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getAudioExportSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Controls audio export settings for post-conversation analytics when
     * ingesting audio to conversations via [Participants.AnalyzeContent][] or
     * [Participants.StreamingAnalyzeContent][].
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
     * is empty, audio export is disabled.
     *
     * If audio export is enabled, audio is recorded and saved to
     * [audio_export_settings.gcs_bucket][], subject to retention policy of
     * [audio_export_settings.gcs_bucket][].
     *
     * This setting won't effect audio input for implicit sessions via
     * [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent]
     * or
     * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3.Sessions.StreamingDetectIntent].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings audio_export_settings = 12;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettingsOrBuilder
        getAudioExportSettingsOrBuilder() {
      if (audioExportSettingsBuilder_ != null) {
        return audioExportSettingsBuilder_.getMessageOrBuilder();
      } else {
        return audioExportSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings
                .getDefaultInstance()
            : audioExportSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Controls audio export settings for post-conversation analytics when
     * ingesting audio to conversations via [Participants.AnalyzeContent][] or
     * [Participants.StreamingAnalyzeContent][].
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION or [audio_export_settings.gcs_bucket][]
     * is empty, audio export is disabled.
     *
     * If audio export is enabled, audio is recorded and saved to
     * [audio_export_settings.gcs_bucket][], subject to retention policy of
     * [audio_export_settings.gcs_bucket][].
     *
     * This setting won't effect audio input for implicit sessions via
     * [Sessions.DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent]
     * or
     * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.cx.v3.Sessions.StreamingDetectIntent].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings audio_export_settings = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings,
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettingsOrBuilder>
        getAudioExportSettingsFieldBuilder() {
      if (audioExportSettingsBuilder_ == null) {
        audioExportSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings,
                com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.SecuritySettings.AudioExportSettingsOrBuilder>(
                getAudioExportSettings(), getParentForChildren(), isClean());
        audioExportSettings_ = null;
      }
      return audioExportSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        insightsExportSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings,
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettingsOrBuilder>
        insightsExportSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Controls conversation exporting settings to Insights after conversation is
     * completed.
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
     * what you configure here.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings insights_export_settings = 13;
     * </code>
     *
     * @return Whether the insightsExportSettings field is set.
     */
    public boolean hasInsightsExportSettings() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls conversation exporting settings to Insights after conversation is
     * completed.
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
     * what you configure here.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings insights_export_settings = 13;
     * </code>
     *
     * @return The insightsExportSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
        getInsightsExportSettings() {
      if (insightsExportSettingsBuilder_ == null) {
        return insightsExportSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
                .getDefaultInstance()
            : insightsExportSettings_;
      } else {
        return insightsExportSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Controls conversation exporting settings to Insights after conversation is
     * completed.
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
     * what you configure here.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings insights_export_settings = 13;
     * </code>
     */
    public Builder setInsightsExportSettings(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings value) {
      if (insightsExportSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        insightsExportSettings_ = value;
      } else {
        insightsExportSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls conversation exporting settings to Insights after conversation is
     * completed.
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
     * what you configure here.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings insights_export_settings = 13;
     * </code>
     */
    public Builder setInsightsExportSettings(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings.Builder
            builderForValue) {
      if (insightsExportSettingsBuilder_ == null) {
        insightsExportSettings_ = builderForValue.build();
      } else {
        insightsExportSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls conversation exporting settings to Insights after conversation is
     * completed.
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
     * what you configure here.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings insights_export_settings = 13;
     * </code>
     */
    public Builder mergeInsightsExportSettings(
        com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings value) {
      if (insightsExportSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && insightsExportSettings_ != null
            && insightsExportSettings_
                != com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
                    .getDefaultInstance()) {
          getInsightsExportSettingsBuilder().mergeFrom(value);
        } else {
          insightsExportSettings_ = value;
        }
      } else {
        insightsExportSettingsBuilder_.mergeFrom(value);
      }
      if (insightsExportSettings_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls conversation exporting settings to Insights after conversation is
     * completed.
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
     * what you configure here.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings insights_export_settings = 13;
     * </code>
     */
    public Builder clearInsightsExportSettings() {
      bitField0_ = (bitField0_ & ~0x00000400);
      insightsExportSettings_ = null;
      if (insightsExportSettingsBuilder_ != null) {
        insightsExportSettingsBuilder_.dispose();
        insightsExportSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls conversation exporting settings to Insights after conversation is
     * completed.
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
     * what you configure here.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings insights_export_settings = 13;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings.Builder
        getInsightsExportSettingsBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getInsightsExportSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Controls conversation exporting settings to Insights after conversation is
     * completed.
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
     * what you configure here.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings insights_export_settings = 13;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettingsOrBuilder
        getInsightsExportSettingsOrBuilder() {
      if (insightsExportSettingsBuilder_ != null) {
        return insightsExportSettingsBuilder_.getMessageOrBuilder();
      } else {
        return insightsExportSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings
                .getDefaultInstance()
            : insightsExportSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Controls conversation exporting settings to Insights after conversation is
     * completed.
     *
     * If
     * [retention_strategy][google.cloud.dialogflow.cx.v3.SecuritySettings.retention_strategy]
     * is set to REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter
     * what you configure here.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings insights_export_settings = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings,
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettingsOrBuilder>
        getInsightsExportSettingsFieldBuilder() {
      if (insightsExportSettingsBuilder_ == null) {
        insightsExportSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings,
                com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.SecuritySettings.InsightsExportSettingsOrBuilder>(
                getInsightsExportSettings(), getParentForChildren(), isClean());
        insightsExportSettings_ = null;
      }
      return insightsExportSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.SecuritySettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.SecuritySettings)
  private static final com.google.cloud.dialogflow.cx.v3.SecuritySettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.SecuritySettings();
  }

  public static com.google.cloud.dialogflow.cx.v3.SecuritySettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecuritySettings> PARSER =
      new com.google.protobuf.AbstractParser<SecuritySettings>() {
        @java.lang.Override
        public SecuritySettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecuritySettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecuritySettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SecuritySettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
