/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/agent.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

public interface RestoreAgentRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.RestoreAgentRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The name of the agent to restore into.
   * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. The name of the agent to restore into.
   * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to restore agent from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string agent_uri = 2;</code>
   *
   * @return Whether the agentUri field is set.
   */
  boolean hasAgentUri();
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to restore agent from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string agent_uri = 2;</code>
   *
   * @return The agentUri.
   */
  java.lang.String getAgentUri();
  /**
   *
   *
   * <pre>
   * The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
   * to restore agent from. The format of this URI must be
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   *
   * Dialogflow performs a read operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have read permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string agent_uri = 2;</code>
   *
   * @return The bytes for agentUri.
   */
  com.google.protobuf.ByteString getAgentUriBytes();

  /**
   *
   *
   * <pre>
   * Uncompressed raw byte content for agent.
   * </pre>
   *
   * <code>bytes agent_content = 3;</code>
   *
   * @return Whether the agentContent field is set.
   */
  boolean hasAgentContent();
  /**
   *
   *
   * <pre>
   * Uncompressed raw byte content for agent.
   * </pre>
   *
   * <code>bytes agent_content = 3;</code>
   *
   * @return The agentContent.
   */
  com.google.protobuf.ByteString getAgentContent();

  /**
   *
   *
   * <pre>
   * Setting for restoring from a git branch
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.RestoreAgentRequest.GitSource git_source = 6;</code>
   *
   * @return Whether the gitSource field is set.
   */
  boolean hasGitSource();
  /**
   *
   *
   * <pre>
   * Setting for restoring from a git branch
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.RestoreAgentRequest.GitSource git_source = 6;</code>
   *
   * @return The gitSource.
   */
  com.google.cloud.dialogflow.cx.v3.RestoreAgentRequest.GitSource getGitSource();
  /**
   *
   *
   * <pre>
   * Setting for restoring from a git branch
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.RestoreAgentRequest.GitSource git_source = 6;</code>
   */
  com.google.cloud.dialogflow.cx.v3.RestoreAgentRequest.GitSourceOrBuilder getGitSourceOrBuilder();

  /**
   *
   *
   * <pre>
   * Agent restore mode. If not specified, `KEEP` is assumed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.RestoreAgentRequest.RestoreOption restore_option = 5;
   * </code>
   *
   * @return The enum numeric value on the wire for restoreOption.
   */
  int getRestoreOptionValue();
  /**
   *
   *
   * <pre>
   * Agent restore mode. If not specified, `KEEP` is assumed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.RestoreAgentRequest.RestoreOption restore_option = 5;
   * </code>
   *
   * @return The restoreOption.
   */
  com.google.cloud.dialogflow.cx.v3.RestoreAgentRequest.RestoreOption getRestoreOption();

  com.google.cloud.dialogflow.cx.v3.RestoreAgentRequest.AgentCase getAgentCase();
}
