/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/session.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Represents the result of a conversational query.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.QueryResult}
 */
public final class QueryResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.QueryResult)
    QueryResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryResult.newBuilder() to construct.
  private QueryResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryResult() {
    languageCode_ = "";
    responseMessages_ = java.util.Collections.emptyList();
    webhookIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    webhookDisplayNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
    webhookLatencies_ = java.util.Collections.emptyList();
    webhookTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    webhookStatuses_ = java.util.Collections.emptyList();
    webhookPayloads_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_QueryResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_QueryResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.QueryResult.class,
            com.google.cloud.dialogflow.cx.v3.QueryResult.Builder.class);
  }

  private int bitField0_;
  private int queryCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object query_;

  public enum QueryCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT(1),
    TRIGGER_INTENT(11),
    TRANSCRIPT(12),
    TRIGGER_EVENT(14),
    DTMF(23),
    QUERY_NOT_SET(0);
    private final int value;

    private QueryCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryCase valueOf(int value) {
      return forNumber(value);
    }

    public static QueryCase forNumber(int value) {
      switch (value) {
        case 1:
          return TEXT;
        case 11:
          return TRIGGER_INTENT;
        case 12:
          return TRANSCRIPT;
        case 14:
          return TRIGGER_EVENT;
        case 23:
          return DTMF;
        case 0:
          return QUERY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public QueryCase getQueryCase() {
    return QueryCase.forNumber(queryCase_);
  }

  public static final int TEXT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
   * provided as input, this field will contain a copy of the text.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return Whether the text field is set.
   */
  public boolean hasText() {
    return queryCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
   * provided as input, this field will contain a copy of the text.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return The text.
   */
  public java.lang.String getText() {
    java.lang.Object ref = "";
    if (queryCase_ == 1) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queryCase_ == 1) {
        query_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
   * provided as input, this field will contain a copy of the text.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return The bytes for text.
   */
  public com.google.protobuf.ByteString getTextBytes() {
    java.lang.Object ref = "";
    if (queryCase_ == 1) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queryCase_ == 1) {
        query_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIGGER_INTENT_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
   * input, this field will contain a copy of the intent identifier. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
   * </pre>
   *
   * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the triggerIntent field is set.
   */
  public boolean hasTriggerIntent() {
    return queryCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
   * input, this field will contain a copy of the intent identifier. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
   * </pre>
   *
   * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The triggerIntent.
   */
  public java.lang.String getTriggerIntent() {
    java.lang.Object ref = "";
    if (queryCase_ == 11) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queryCase_ == 11) {
        query_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
   * input, this field will contain a copy of the intent identifier. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
   * </pre>
   *
   * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for triggerIntent.
   */
  public com.google.protobuf.ByteString getTriggerIntentBytes() {
    java.lang.Object ref = "";
    if (queryCase_ == 11) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queryCase_ == 11) {
        query_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSCRIPT_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * If [natural language speech
   * audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
   * this field will contain the transcript for the audio.
   * </pre>
   *
   * <code>string transcript = 12;</code>
   *
   * @return Whether the transcript field is set.
   */
  public boolean hasTranscript() {
    return queryCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * If [natural language speech
   * audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
   * this field will contain the transcript for the audio.
   * </pre>
   *
   * <code>string transcript = 12;</code>
   *
   * @return The transcript.
   */
  public java.lang.String getTranscript() {
    java.lang.Object ref = "";
    if (queryCase_ == 12) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queryCase_ == 12) {
        query_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If [natural language speech
   * audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
   * this field will contain the transcript for the audio.
   * </pre>
   *
   * <code>string transcript = 12;</code>
   *
   * @return The bytes for transcript.
   */
  public com.google.protobuf.ByteString getTranscriptBytes() {
    java.lang.Object ref = "";
    if (queryCase_ == 12) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queryCase_ == 12) {
        query_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIGGER_EVENT_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
   * input, this field will contain the name of the event.
   * </pre>
   *
   * <code>string trigger_event = 14;</code>
   *
   * @return Whether the triggerEvent field is set.
   */
  public boolean hasTriggerEvent() {
    return queryCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
   * input, this field will contain the name of the event.
   * </pre>
   *
   * <code>string trigger_event = 14;</code>
   *
   * @return The triggerEvent.
   */
  public java.lang.String getTriggerEvent() {
    java.lang.Object ref = "";
    if (queryCase_ == 14) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (queryCase_ == 14) {
        query_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
   * input, this field will contain the name of the event.
   * </pre>
   *
   * <code>string trigger_event = 14;</code>
   *
   * @return The bytes for triggerEvent.
   */
  public com.google.protobuf.ByteString getTriggerEventBytes() {
    java.lang.Object ref = "";
    if (queryCase_ == 14) {
      ref = query_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (queryCase_ == 14) {
        query_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DTMF_FIELD_NUMBER = 23;
  /**
   *
   *
   * <pre>
   * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
   * input, this field will contain a copy of the
   * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
   *
   * @return Whether the dtmf field is set.
   */
  @java.lang.Override
  public boolean hasDtmf() {
    return queryCase_ == 23;
  }
  /**
   *
   *
   * <pre>
   * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
   * input, this field will contain a copy of the
   * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
   *
   * @return The dtmf.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DtmfInput getDtmf() {
    if (queryCase_ == 23) {
      return (com.google.cloud.dialogflow.cx.v3.DtmfInput) query_;
    }
    return com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
   * input, this field will contain a copy of the
   * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DtmfInputOrBuilder getDtmfOrBuilder() {
    if (queryCase_ == 23) {
      return (com.google.cloud.dialogflow.cx.v3.DtmfInput) query_;
    }
    return com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance();
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * The language that was triggered during intent detection.
   * See [Language
   * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
   * for a list of the currently supported language codes.
   * </pre>
   *
   * <code>string language_code = 2;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The language that was triggered during intent detection.
   * See [Language
   * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
   * for a list of the currently supported language codes.
   * </pre>
   *
   * <code>string language_code = 2;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETERS_FIELD_NUMBER = 3;
  private com.google.protobuf.Struct parameters_;
  /**
   *
   *
   * <pre>
   * The collected [session
   * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
   *
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   *
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 3;</code>
   *
   * @return Whether the parameters field is set.
   */
  @java.lang.Override
  public boolean hasParameters() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The collected [session
   * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
   *
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   *
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 3;</code>
   *
   * @return The parameters.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getParameters() {
    return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
  }
  /**
   *
   *
   * <pre>
   * The collected [session
   * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
   *
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   *
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
    return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
  }

  public static final int RESPONSE_MESSAGES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage> responseMessages_;
  /**
   *
   *
   * <pre>
   * The list of rich messages returned to the client. Responses vary from
   * simple text messages to more sophisticated, structured payloads used
   * to drive complex logic.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage>
      getResponseMessagesList() {
    return responseMessages_;
  }
  /**
   *
   *
   * <pre>
   * The list of rich messages returned to the client. Responses vary from
   * simple text messages to more sophisticated, structured payloads used
   * to drive complex logic.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
      getResponseMessagesOrBuilderList() {
    return responseMessages_;
  }
  /**
   *
   *
   * <pre>
   * The list of rich messages returned to the client. Responses vary from
   * simple text messages to more sophisticated, structured payloads used
   * to drive complex logic.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
   */
  @java.lang.Override
  public int getResponseMessagesCount() {
    return responseMessages_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of rich messages returned to the client. Responses vary from
   * simple text messages to more sophisticated, structured payloads used
   * to drive complex logic.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ResponseMessage getResponseMessages(int index) {
    return responseMessages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of rich messages returned to the client. Responses vary from
   * simple text messages to more sophisticated, structured payloads used
   * to drive complex logic.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder getResponseMessagesOrBuilder(
      int index) {
    return responseMessages_.get(index);
  }

  public static final int WEBHOOK_IDS_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList webhookIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of webhook ids in the order of call sequence.
   * </pre>
   *
   * <code>repeated string webhook_ids = 25;</code>
   *
   * @return A list containing the webhookIds.
   */
  public com.google.protobuf.ProtocolStringList getWebhookIdsList() {
    return webhookIds_;
  }
  /**
   *
   *
   * <pre>
   * The list of webhook ids in the order of call sequence.
   * </pre>
   *
   * <code>repeated string webhook_ids = 25;</code>
   *
   * @return The count of webhookIds.
   */
  public int getWebhookIdsCount() {
    return webhookIds_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of webhook ids in the order of call sequence.
   * </pre>
   *
   * <code>repeated string webhook_ids = 25;</code>
   *
   * @param index The index of the element to return.
   * @return The webhookIds at the given index.
   */
  public java.lang.String getWebhookIds(int index) {
    return webhookIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of webhook ids in the order of call sequence.
   * </pre>
   *
   * <code>repeated string webhook_ids = 25;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the webhookIds at the given index.
   */
  public com.google.protobuf.ByteString getWebhookIdsBytes(int index) {
    return webhookIds_.getByteString(index);
  }

  public static final int WEBHOOK_DISPLAY_NAMES_FIELD_NUMBER = 26;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList webhookDisplayNames_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of webhook display names in the order of call sequence.
   * </pre>
   *
   * <code>repeated string webhook_display_names = 26;</code>
   *
   * @return A list containing the webhookDisplayNames.
   */
  public com.google.protobuf.ProtocolStringList getWebhookDisplayNamesList() {
    return webhookDisplayNames_;
  }
  /**
   *
   *
   * <pre>
   * The list of webhook display names in the order of call sequence.
   * </pre>
   *
   * <code>repeated string webhook_display_names = 26;</code>
   *
   * @return The count of webhookDisplayNames.
   */
  public int getWebhookDisplayNamesCount() {
    return webhookDisplayNames_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of webhook display names in the order of call sequence.
   * </pre>
   *
   * <code>repeated string webhook_display_names = 26;</code>
   *
   * @param index The index of the element to return.
   * @return The webhookDisplayNames at the given index.
   */
  public java.lang.String getWebhookDisplayNames(int index) {
    return webhookDisplayNames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of webhook display names in the order of call sequence.
   * </pre>
   *
   * <code>repeated string webhook_display_names = 26;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the webhookDisplayNames at the given index.
   */
  public com.google.protobuf.ByteString getWebhookDisplayNamesBytes(int index) {
    return webhookDisplayNames_.getByteString(index);
  }

  public static final int WEBHOOK_LATENCIES_FIELD_NUMBER = 27;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Duration> webhookLatencies_;
  /**
   *
   *
   * <pre>
   * The list of webhook latencies in the order of call sequence.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Duration> getWebhookLatenciesList() {
    return webhookLatencies_;
  }
  /**
   *
   *
   * <pre>
   * The list of webhook latencies in the order of call sequence.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.DurationOrBuilder>
      getWebhookLatenciesOrBuilderList() {
    return webhookLatencies_;
  }
  /**
   *
   *
   * <pre>
   * The list of webhook latencies in the order of call sequence.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
   */
  @java.lang.Override
  public int getWebhookLatenciesCount() {
    return webhookLatencies_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of webhook latencies in the order of call sequence.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Duration getWebhookLatencies(int index) {
    return webhookLatencies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of webhook latencies in the order of call sequence.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getWebhookLatenciesOrBuilder(int index) {
    return webhookLatencies_.get(index);
  }

  public static final int WEBHOOK_TAGS_FIELD_NUMBER = 29;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList webhookTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of webhook tags in the order of call sequence.
   * </pre>
   *
   * <code>repeated string webhook_tags = 29;</code>
   *
   * @return A list containing the webhookTags.
   */
  public com.google.protobuf.ProtocolStringList getWebhookTagsList() {
    return webhookTags_;
  }
  /**
   *
   *
   * <pre>
   * The list of webhook tags in the order of call sequence.
   * </pre>
   *
   * <code>repeated string webhook_tags = 29;</code>
   *
   * @return The count of webhookTags.
   */
  public int getWebhookTagsCount() {
    return webhookTags_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of webhook tags in the order of call sequence.
   * </pre>
   *
   * <code>repeated string webhook_tags = 29;</code>
   *
   * @param index The index of the element to return.
   * @return The webhookTags at the given index.
   */
  public java.lang.String getWebhookTags(int index) {
    return webhookTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of webhook tags in the order of call sequence.
   * </pre>
   *
   * <code>repeated string webhook_tags = 29;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the webhookTags at the given index.
   */
  public com.google.protobuf.ByteString getWebhookTagsBytes(int index) {
    return webhookTags_.getByteString(index);
  }

  public static final int WEBHOOK_STATUSES_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> webhookStatuses_;
  /**
   *
   *
   * <pre>
   * The list of webhook call status in the order of call sequence.
   * </pre>
   *
   * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getWebhookStatusesList() {
    return webhookStatuses_;
  }
  /**
   *
   *
   * <pre>
   * The list of webhook call status in the order of call sequence.
   * </pre>
   *
   * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder>
      getWebhookStatusesOrBuilderList() {
    return webhookStatuses_;
  }
  /**
   *
   *
   * <pre>
   * The list of webhook call status in the order of call sequence.
   * </pre>
   *
   * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
   */
  @java.lang.Override
  public int getWebhookStatusesCount() {
    return webhookStatuses_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of webhook call status in the order of call sequence.
   * </pre>
   *
   * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
   */
  @java.lang.Override
  public com.google.rpc.Status getWebhookStatuses(int index) {
    return webhookStatuses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of webhook call status in the order of call sequence.
   * </pre>
   *
   * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getWebhookStatusesOrBuilder(int index) {
    return webhookStatuses_.get(index);
  }

  public static final int WEBHOOK_PAYLOADS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Struct> webhookPayloads_;
  /**
   *
   *
   * <pre>
   * The list of webhook payload in
   * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
   * in the order of call sequence. If some webhook call fails or doesn't return
   * any payload, an empty `Struct` would be used instead.
   * </pre>
   *
   * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Struct> getWebhookPayloadsList() {
    return webhookPayloads_;
  }
  /**
   *
   *
   * <pre>
   * The list of webhook payload in
   * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
   * in the order of call sequence. If some webhook call fails or doesn't return
   * any payload, an empty `Struct` would be used instead.
   * </pre>
   *
   * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.StructOrBuilder>
      getWebhookPayloadsOrBuilderList() {
    return webhookPayloads_;
  }
  /**
   *
   *
   * <pre>
   * The list of webhook payload in
   * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
   * in the order of call sequence. If some webhook call fails or doesn't return
   * any payload, an empty `Struct` would be used instead.
   * </pre>
   *
   * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
   */
  @java.lang.Override
  public int getWebhookPayloadsCount() {
    return webhookPayloads_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of webhook payload in
   * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
   * in the order of call sequence. If some webhook call fails or doesn't return
   * any payload, an empty `Struct` would be used instead.
   * </pre>
   *
   * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Struct getWebhookPayloads(int index) {
    return webhookPayloads_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of webhook payload in
   * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
   * in the order of call sequence. If some webhook call fails or doesn't return
   * any payload, an empty `Struct` would be used instead.
   * </pre>
   *
   * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getWebhookPayloadsOrBuilder(int index) {
    return webhookPayloads_.get(index);
  }

  public static final int CURRENT_PAGE_FIELD_NUMBER = 7;
  private com.google.cloud.dialogflow.cx.v3.Page currentPage_;
  /**
   *
   *
   * <pre>
   * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
   * fields are filled in this message, including but not limited to `name` and
   * `display_name`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
   *
   * @return Whether the currentPage field is set.
   */
  @java.lang.Override
  public boolean hasCurrentPage() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
   * fields are filled in this message, including but not limited to `name` and
   * `display_name`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
   *
   * @return The currentPage.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Page getCurrentPage() {
    return currentPage_ == null
        ? com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance()
        : currentPage_;
  }
  /**
   *
   *
   * <pre>
   * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
   * fields are filled in this message, including but not limited to `name` and
   * `display_name`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.PageOrBuilder getCurrentPageOrBuilder() {
    return currentPage_ == null
        ? com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance()
        : currentPage_;
  }

  public static final int CURRENT_FLOW_FIELD_NUMBER = 31;
  private com.google.cloud.dialogflow.cx.v3.Flow currentFlow_;
  /**
   *
   *
   * <pre>
   * The current [Flow][google.cloud.dialogflow.cx.v3.Flow]. Some, not all
   * fields are filled in this message, including but not limited to `name` and
   * `display_name`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Flow current_flow = 31;</code>
   *
   * @return Whether the currentFlow field is set.
   */
  @java.lang.Override
  public boolean hasCurrentFlow() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The current [Flow][google.cloud.dialogflow.cx.v3.Flow]. Some, not all
   * fields are filled in this message, including but not limited to `name` and
   * `display_name`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Flow current_flow = 31;</code>
   *
   * @return The currentFlow.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Flow getCurrentFlow() {
    return currentFlow_ == null
        ? com.google.cloud.dialogflow.cx.v3.Flow.getDefaultInstance()
        : currentFlow_;
  }
  /**
   *
   *
   * <pre>
   * The current [Flow][google.cloud.dialogflow.cx.v3.Flow]. Some, not all
   * fields are filled in this message, including but not limited to `name` and
   * `display_name`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Flow current_flow = 31;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.FlowOrBuilder getCurrentFlowOrBuilder() {
    return currentFlow_ == null
        ? com.google.cloud.dialogflow.cx.v3.Flow.getDefaultInstance()
        : currentFlow_;
  }

  public static final int INTENT_FIELD_NUMBER = 8;
  private com.google.cloud.dialogflow.cx.v3.Intent intent_;
  /**
   *
   *
   * <pre>
   * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
   * conversational query. Some, not all fields are filled in this message,
   * including but not limited to: `name` and `display_name`. This field is
   * deprecated, please use
   * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
   * instead.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.cx.v3.QueryResult.intent is deprecated. See
   *     google/cloud/dialogflow/cx/v3/session.proto;l=1049
   * @return Whether the intent field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasIntent() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
   * conversational query. Some, not all fields are filled in this message,
   * including but not limited to: `name` and `display_name`. This field is
   * deprecated, please use
   * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
   * instead.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.cx.v3.QueryResult.intent is deprecated. See
   *     google/cloud/dialogflow/cx/v3/session.proto;l=1049
   * @return The intent.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.dialogflow.cx.v3.Intent getIntent() {
    return intent_ == null
        ? com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()
        : intent_;
  }
  /**
   *
   *
   * <pre>
   * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
   * conversational query. Some, not all fields are filled in this message,
   * including but not limited to: `name` and `display_name`. This field is
   * deprecated, please use
   * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
   * instead.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.dialogflow.cx.v3.IntentOrBuilder getIntentOrBuilder() {
    return intent_ == null
        ? com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()
        : intent_;
  }

  public static final int INTENT_DETECTION_CONFIDENCE_FIELD_NUMBER = 9;
  private float intentDetectionConfidence_ = 0F;
  /**
   *
   *
   * <pre>
   * The intent detection confidence. Values range from 0.0 (completely
   * uncertain) to 1.0 (completely certain).
   * This value is for informational purpose only and is only used to
   * help match the best intent within the classification threshold.
   * This value may change for the same end-user expression at any time due to a
   * model retraining or change in implementation.
   * This field is deprecated, please use
   * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
   * instead.
   * </pre>
   *
   * <code>float intent_detection_confidence = 9 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.cx.v3.QueryResult.intent_detection_confidence is
   *     deprecated. See google/cloud/dialogflow/cx/v3/session.proto;l=1060
   * @return The intentDetectionConfidence.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public float getIntentDetectionConfidence() {
    return intentDetectionConfidence_;
  }

  public static final int MATCH_FIELD_NUMBER = 15;
  private com.google.cloud.dialogflow.cx.v3.Match match_;
  /**
   *
   *
   * <pre>
   * Intent match result, could be an intent or an event.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
   *
   * @return Whether the match field is set.
   */
  @java.lang.Override
  public boolean hasMatch() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Intent match result, could be an intent or an event.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
   *
   * @return The match.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Match getMatch() {
    return match_ == null ? com.google.cloud.dialogflow.cx.v3.Match.getDefaultInstance() : match_;
  }
  /**
   *
   *
   * <pre>
   * Intent match result, could be an intent or an event.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.MatchOrBuilder getMatchOrBuilder() {
    return match_ == null ? com.google.cloud.dialogflow.cx.v3.Match.getDefaultInstance() : match_;
  }

  public static final int DIAGNOSTIC_INFO_FIELD_NUMBER = 10;
  private com.google.protobuf.Struct diagnosticInfo_;
  /**
   *
   *
   * <pre>
   * The free-form diagnostic info. For example, this field could contain
   * webhook call latency. The fields of this data can change without notice,
   * so you should not write code that depends on its structure.
   *
   * One of the fields is called "Alternative Matched Intents", which may
   * aid with debugging. The following describes these intent results:
   *
   * - The list is empty if no intent was matched to end-user input.
   * - Only intents that are referenced in the currently active flow are
   *   included.
   * - The matched intent is included.
   * - Other intents that could have matched end-user input, but did not match
   *   because they are referenced by intent routes that are out of
   *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
   *   are included.
   * - Other intents referenced by intent routes in scope that matched end-user
   *   input, but had a lower confidence score.
   * </pre>
   *
   * <code>.google.protobuf.Struct diagnostic_info = 10;</code>
   *
   * @return Whether the diagnosticInfo field is set.
   */
  @java.lang.Override
  public boolean hasDiagnosticInfo() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The free-form diagnostic info. For example, this field could contain
   * webhook call latency. The fields of this data can change without notice,
   * so you should not write code that depends on its structure.
   *
   * One of the fields is called "Alternative Matched Intents", which may
   * aid with debugging. The following describes these intent results:
   *
   * - The list is empty if no intent was matched to end-user input.
   * - Only intents that are referenced in the currently active flow are
   *   included.
   * - The matched intent is included.
   * - Other intents that could have matched end-user input, but did not match
   *   because they are referenced by intent routes that are out of
   *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
   *   are included.
   * - Other intents referenced by intent routes in scope that matched end-user
   *   input, but had a lower confidence score.
   * </pre>
   *
   * <code>.google.protobuf.Struct diagnostic_info = 10;</code>
   *
   * @return The diagnosticInfo.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getDiagnosticInfo() {
    return diagnosticInfo_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : diagnosticInfo_;
  }
  /**
   *
   *
   * <pre>
   * The free-form diagnostic info. For example, this field could contain
   * webhook call latency. The fields of this data can change without notice,
   * so you should not write code that depends on its structure.
   *
   * One of the fields is called "Alternative Matched Intents", which may
   * aid with debugging. The following describes these intent results:
   *
   * - The list is empty if no intent was matched to end-user input.
   * - Only intents that are referenced in the currently active flow are
   *   included.
   * - The matched intent is included.
   * - Other intents that could have matched end-user input, but did not match
   *   because they are referenced by intent routes that are out of
   *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
   *   are included.
   * - Other intents referenced by intent routes in scope that matched end-user
   *   input, but had a lower confidence score.
   * </pre>
   *
   * <code>.google.protobuf.Struct diagnostic_info = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getDiagnosticInfoOrBuilder() {
    return diagnosticInfo_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : diagnosticInfo_;
  }

  public static final int SENTIMENT_ANALYSIS_RESULT_FIELD_NUMBER = 17;
  private com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentimentAnalysisResult_;
  /**
   *
   *
   * <pre>
   * The sentiment analyss result, which depends on
   * [`analyze_query_text_sentiment`]
   * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
   * specified in the request.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;
   * </code>
   *
   * @return Whether the sentimentAnalysisResult field is set.
   */
  @java.lang.Override
  public boolean hasSentimentAnalysisResult() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The sentiment analyss result, which depends on
   * [`analyze_query_text_sentiment`]
   * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
   * specified in the request.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;
   * </code>
   *
   * @return The sentimentAnalysisResult.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult getSentimentAnalysisResult() {
    return sentimentAnalysisResult_ == null
        ? com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult.getDefaultInstance()
        : sentimentAnalysisResult_;
  }
  /**
   *
   *
   * <pre>
   * The sentiment analyss result, which depends on
   * [`analyze_query_text_sentiment`]
   * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
   * specified in the request.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResultOrBuilder
      getSentimentAnalysisResultOrBuilder() {
    return sentimentAnalysisResult_ == null
        ? com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult.getDefaultInstance()
        : sentimentAnalysisResult_;
  }

  public static final int ADVANCED_SETTINGS_FIELD_NUMBER = 21;
  private com.google.cloud.dialogflow.cx.v3.AdvancedSettings advancedSettings_;
  /**
   *
   *
   * <pre>
   * Returns the current advanced settings including IVR settings. Even though
   * the operations configured by these settings are performed by Dialogflow,
   * the client may need to perform special logic at the moment. For example, if
   * Dialogflow exports audio to Google Cloud Storage, then the client may need
   * to wait for the resulting object to appear in the bucket before proceeding.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
   *
   * @return Whether the advancedSettings field is set.
   */
  @java.lang.Override
  public boolean hasAdvancedSettings() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Returns the current advanced settings including IVR settings. Even though
   * the operations configured by these settings are performed by Dialogflow,
   * the client may need to perform special logic at the moment. For example, if
   * Dialogflow exports audio to Google Cloud Storage, then the client may need
   * to wait for the resulting object to appear in the bucket before proceeding.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
   *
   * @return The advancedSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.AdvancedSettings getAdvancedSettings() {
    return advancedSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()
        : advancedSettings_;
  }
  /**
   *
   *
   * <pre>
   * Returns the current advanced settings including IVR settings. Even though
   * the operations configured by these settings are performed by Dialogflow,
   * the client may need to perform special logic at the moment. For example, if
   * Dialogflow exports audio to Google Cloud Storage, then the client may need
   * to wait for the resulting object to appear in the bucket before proceeding.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder
      getAdvancedSettingsOrBuilder() {
    return advancedSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()
        : advancedSettings_;
  }

  public static final int ALLOW_ANSWER_FEEDBACK_FIELD_NUMBER = 32;
  private boolean allowAnswerFeedback_ = false;
  /**
   *
   *
   * <pre>
   * Indicates whether the Thumbs up/Thumbs down rating controls are need to be
   * shown for the response in the Dialogflow Messenger widget.
   * </pre>
   *
   * <code>bool allow_answer_feedback = 32;</code>
   *
   * @return The allowAnswerFeedback.
   */
  @java.lang.Override
  public boolean getAllowAnswerFeedback() {
    return allowAnswerFeedback_;
  }

  public static final int DATA_STORE_CONNECTION_SIGNALS_FIELD_NUMBER = 35;
  private com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals dataStoreConnectionSignals_;
  /**
   *
   *
   * <pre>
   * Optional. Data store connection feature output signals.
   * Filled only when data stores are involved in serving the query.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals data_store_connection_signals = 35 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the dataStoreConnectionSignals field is set.
   */
  @java.lang.Override
  public boolean hasDataStoreConnectionSignals() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Data store connection feature output signals.
   * Filled only when data stores are involved in serving the query.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals data_store_connection_signals = 35 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The dataStoreConnectionSignals.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
      getDataStoreConnectionSignals() {
    return dataStoreConnectionSignals_ == null
        ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.getDefaultInstance()
        : dataStoreConnectionSignals_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Data store connection feature output signals.
   * Filled only when data stores are involved in serving the query.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals data_store_connection_signals = 35 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignalsOrBuilder
      getDataStoreConnectionSignalsOrBuilder() {
    return dataStoreConnectionSignals_ == null
        ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.getDefaultInstance()
        : dataStoreConnectionSignals_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (queryCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, languageCode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getParameters());
    }
    for (int i = 0; i < responseMessages_.size(); i++) {
      output.writeMessage(4, responseMessages_.get(i));
    }
    for (int i = 0; i < webhookPayloads_.size(); i++) {
      output.writeMessage(6, webhookPayloads_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getCurrentPage());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getIntent());
    }
    if (java.lang.Float.floatToRawIntBits(intentDetectionConfidence_) != 0) {
      output.writeFloat(9, intentDetectionConfidence_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(10, getDiagnosticInfo());
    }
    if (queryCase_ == 11) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, query_);
    }
    if (queryCase_ == 12) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, query_);
    }
    for (int i = 0; i < webhookStatuses_.size(); i++) {
      output.writeMessage(13, webhookStatuses_.get(i));
    }
    if (queryCase_ == 14) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, query_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(15, getMatch());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(17, getSentimentAnalysisResult());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(21, getAdvancedSettings());
    }
    if (queryCase_ == 23) {
      output.writeMessage(23, (com.google.cloud.dialogflow.cx.v3.DtmfInput) query_);
    }
    for (int i = 0; i < webhookIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, webhookIds_.getRaw(i));
    }
    for (int i = 0; i < webhookDisplayNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 26, webhookDisplayNames_.getRaw(i));
    }
    for (int i = 0; i < webhookLatencies_.size(); i++) {
      output.writeMessage(27, webhookLatencies_.get(i));
    }
    for (int i = 0; i < webhookTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 29, webhookTags_.getRaw(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(31, getCurrentFlow());
    }
    if (allowAnswerFeedback_ != false) {
      output.writeBool(32, allowAnswerFeedback_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(35, getDataStoreConnectionSignals());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (queryCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, languageCode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getParameters());
    }
    for (int i = 0; i < responseMessages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, responseMessages_.get(i));
    }
    for (int i = 0; i < webhookPayloads_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, webhookPayloads_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCurrentPage());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getIntent());
    }
    if (java.lang.Float.floatToRawIntBits(intentDetectionConfidence_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(9, intentDetectionConfidence_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDiagnosticInfo());
    }
    if (queryCase_ == 11) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, query_);
    }
    if (queryCase_ == 12) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, query_);
    }
    for (int i = 0; i < webhookStatuses_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, webhookStatuses_.get(i));
    }
    if (queryCase_ == 14) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, query_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getMatch());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, getSentimentAnalysisResult());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getAdvancedSettings());
    }
    if (queryCase_ == 23) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              23, (com.google.cloud.dialogflow.cx.v3.DtmfInput) query_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < webhookIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(webhookIds_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getWebhookIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < webhookDisplayNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(webhookDisplayNames_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getWebhookDisplayNamesList().size();
    }
    for (int i = 0; i < webhookLatencies_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(27, webhookLatencies_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < webhookTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(webhookTags_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getWebhookTagsList().size();
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(31, getCurrentFlow());
    }
    if (allowAnswerFeedback_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(32, allowAnswerFeedback_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              35, getDataStoreConnectionSignals());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.QueryResult)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.QueryResult other =
        (com.google.cloud.dialogflow.cx.v3.QueryResult) obj;

    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (hasParameters() != other.hasParameters()) return false;
    if (hasParameters()) {
      if (!getParameters().equals(other.getParameters())) return false;
    }
    if (!getResponseMessagesList().equals(other.getResponseMessagesList())) return false;
    if (!getWebhookIdsList().equals(other.getWebhookIdsList())) return false;
    if (!getWebhookDisplayNamesList().equals(other.getWebhookDisplayNamesList())) return false;
    if (!getWebhookLatenciesList().equals(other.getWebhookLatenciesList())) return false;
    if (!getWebhookTagsList().equals(other.getWebhookTagsList())) return false;
    if (!getWebhookStatusesList().equals(other.getWebhookStatusesList())) return false;
    if (!getWebhookPayloadsList().equals(other.getWebhookPayloadsList())) return false;
    if (hasCurrentPage() != other.hasCurrentPage()) return false;
    if (hasCurrentPage()) {
      if (!getCurrentPage().equals(other.getCurrentPage())) return false;
    }
    if (hasCurrentFlow() != other.hasCurrentFlow()) return false;
    if (hasCurrentFlow()) {
      if (!getCurrentFlow().equals(other.getCurrentFlow())) return false;
    }
    if (hasIntent() != other.hasIntent()) return false;
    if (hasIntent()) {
      if (!getIntent().equals(other.getIntent())) return false;
    }
    if (java.lang.Float.floatToIntBits(getIntentDetectionConfidence())
        != java.lang.Float.floatToIntBits(other.getIntentDetectionConfidence())) return false;
    if (hasMatch() != other.hasMatch()) return false;
    if (hasMatch()) {
      if (!getMatch().equals(other.getMatch())) return false;
    }
    if (hasDiagnosticInfo() != other.hasDiagnosticInfo()) return false;
    if (hasDiagnosticInfo()) {
      if (!getDiagnosticInfo().equals(other.getDiagnosticInfo())) return false;
    }
    if (hasSentimentAnalysisResult() != other.hasSentimentAnalysisResult()) return false;
    if (hasSentimentAnalysisResult()) {
      if (!getSentimentAnalysisResult().equals(other.getSentimentAnalysisResult())) return false;
    }
    if (hasAdvancedSettings() != other.hasAdvancedSettings()) return false;
    if (hasAdvancedSettings()) {
      if (!getAdvancedSettings().equals(other.getAdvancedSettings())) return false;
    }
    if (getAllowAnswerFeedback() != other.getAllowAnswerFeedback()) return false;
    if (hasDataStoreConnectionSignals() != other.hasDataStoreConnectionSignals()) return false;
    if (hasDataStoreConnectionSignals()) {
      if (!getDataStoreConnectionSignals().equals(other.getDataStoreConnectionSignals()))
        return false;
    }
    if (!getQueryCase().equals(other.getQueryCase())) return false;
    switch (queryCase_) {
      case 1:
        if (!getText().equals(other.getText())) return false;
        break;
      case 11:
        if (!getTriggerIntent().equals(other.getTriggerIntent())) return false;
        break;
      case 12:
        if (!getTranscript().equals(other.getTranscript())) return false;
        break;
      case 14:
        if (!getTriggerEvent().equals(other.getTriggerEvent())) return false;
        break;
      case 23:
        if (!getDtmf().equals(other.getDtmf())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    if (hasParameters()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParameters().hashCode();
    }
    if (getResponseMessagesCount() > 0) {
      hash = (37 * hash) + RESPONSE_MESSAGES_FIELD_NUMBER;
      hash = (53 * hash) + getResponseMessagesList().hashCode();
    }
    if (getWebhookIdsCount() > 0) {
      hash = (37 * hash) + WEBHOOK_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookIdsList().hashCode();
    }
    if (getWebhookDisplayNamesCount() > 0) {
      hash = (37 * hash) + WEBHOOK_DISPLAY_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookDisplayNamesList().hashCode();
    }
    if (getWebhookLatenciesCount() > 0) {
      hash = (37 * hash) + WEBHOOK_LATENCIES_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookLatenciesList().hashCode();
    }
    if (getWebhookTagsCount() > 0) {
      hash = (37 * hash) + WEBHOOK_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookTagsList().hashCode();
    }
    if (getWebhookStatusesCount() > 0) {
      hash = (37 * hash) + WEBHOOK_STATUSES_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookStatusesList().hashCode();
    }
    if (getWebhookPayloadsCount() > 0) {
      hash = (37 * hash) + WEBHOOK_PAYLOADS_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookPayloadsList().hashCode();
    }
    if (hasCurrentPage()) {
      hash = (37 * hash) + CURRENT_PAGE_FIELD_NUMBER;
      hash = (53 * hash) + getCurrentPage().hashCode();
    }
    if (hasCurrentFlow()) {
      hash = (37 * hash) + CURRENT_FLOW_FIELD_NUMBER;
      hash = (53 * hash) + getCurrentFlow().hashCode();
    }
    if (hasIntent()) {
      hash = (37 * hash) + INTENT_FIELD_NUMBER;
      hash = (53 * hash) + getIntent().hashCode();
    }
    hash = (37 * hash) + INTENT_DETECTION_CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getIntentDetectionConfidence());
    if (hasMatch()) {
      hash = (37 * hash) + MATCH_FIELD_NUMBER;
      hash = (53 * hash) + getMatch().hashCode();
    }
    if (hasDiagnosticInfo()) {
      hash = (37 * hash) + DIAGNOSTIC_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getDiagnosticInfo().hashCode();
    }
    if (hasSentimentAnalysisResult()) {
      hash = (37 * hash) + SENTIMENT_ANALYSIS_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getSentimentAnalysisResult().hashCode();
    }
    if (hasAdvancedSettings()) {
      hash = (37 * hash) + ADVANCED_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getAdvancedSettings().hashCode();
    }
    hash = (37 * hash) + ALLOW_ANSWER_FEEDBACK_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowAnswerFeedback());
    if (hasDataStoreConnectionSignals()) {
      hash = (37 * hash) + DATA_STORE_CONNECTION_SIGNALS_FIELD_NUMBER;
      hash = (53 * hash) + getDataStoreConnectionSignals().hashCode();
    }
    switch (queryCase_) {
      case 1:
        hash = (37 * hash) + TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getText().hashCode();
        break;
      case 11:
        hash = (37 * hash) + TRIGGER_INTENT_FIELD_NUMBER;
        hash = (53 * hash) + getTriggerIntent().hashCode();
        break;
      case 12:
        hash = (37 * hash) + TRANSCRIPT_FIELD_NUMBER;
        hash = (53 * hash) + getTranscript().hashCode();
        break;
      case 14:
        hash = (37 * hash) + TRIGGER_EVENT_FIELD_NUMBER;
        hash = (53 * hash) + getTriggerEvent().hashCode();
        break;
      case 23:
        hash = (37 * hash) + DTMF_FIELD_NUMBER;
        hash = (53 * hash) + getDtmf().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.QueryResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the result of a conversational query.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.QueryResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.QueryResult)
      com.google.cloud.dialogflow.cx.v3.QueryResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_QueryResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_QueryResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.QueryResult.class,
              com.google.cloud.dialogflow.cx.v3.QueryResult.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.QueryResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getParametersFieldBuilder();
        getResponseMessagesFieldBuilder();
        getWebhookLatenciesFieldBuilder();
        getWebhookStatusesFieldBuilder();
        getWebhookPayloadsFieldBuilder();
        getCurrentPageFieldBuilder();
        getCurrentFlowFieldBuilder();
        getIntentFieldBuilder();
        getMatchFieldBuilder();
        getDiagnosticInfoFieldBuilder();
        getSentimentAnalysisResultFieldBuilder();
        getAdvancedSettingsFieldBuilder();
        getDataStoreConnectionSignalsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (dtmfBuilder_ != null) {
        dtmfBuilder_.clear();
      }
      languageCode_ = "";
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      if (responseMessagesBuilder_ == null) {
        responseMessages_ = java.util.Collections.emptyList();
      } else {
        responseMessages_ = null;
        responseMessagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      webhookIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      webhookDisplayNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (webhookLatenciesBuilder_ == null) {
        webhookLatencies_ = java.util.Collections.emptyList();
      } else {
        webhookLatencies_ = null;
        webhookLatenciesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      webhookTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (webhookStatusesBuilder_ == null) {
        webhookStatuses_ = java.util.Collections.emptyList();
      } else {
        webhookStatuses_ = null;
        webhookStatusesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      if (webhookPayloadsBuilder_ == null) {
        webhookPayloads_ = java.util.Collections.emptyList();
      } else {
        webhookPayloads_ = null;
        webhookPayloadsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      currentPage_ = null;
      if (currentPageBuilder_ != null) {
        currentPageBuilder_.dispose();
        currentPageBuilder_ = null;
      }
      currentFlow_ = null;
      if (currentFlowBuilder_ != null) {
        currentFlowBuilder_.dispose();
        currentFlowBuilder_ = null;
      }
      intent_ = null;
      if (intentBuilder_ != null) {
        intentBuilder_.dispose();
        intentBuilder_ = null;
      }
      intentDetectionConfidence_ = 0F;
      match_ = null;
      if (matchBuilder_ != null) {
        matchBuilder_.dispose();
        matchBuilder_ = null;
      }
      diagnosticInfo_ = null;
      if (diagnosticInfoBuilder_ != null) {
        diagnosticInfoBuilder_.dispose();
        diagnosticInfoBuilder_ = null;
      }
      sentimentAnalysisResult_ = null;
      if (sentimentAnalysisResultBuilder_ != null) {
        sentimentAnalysisResultBuilder_.dispose();
        sentimentAnalysisResultBuilder_ = null;
      }
      advancedSettings_ = null;
      if (advancedSettingsBuilder_ != null) {
        advancedSettingsBuilder_.dispose();
        advancedSettingsBuilder_ = null;
      }
      allowAnswerFeedback_ = false;
      dataStoreConnectionSignals_ = null;
      if (dataStoreConnectionSignalsBuilder_ != null) {
        dataStoreConnectionSignalsBuilder_.dispose();
        dataStoreConnectionSignalsBuilder_ = null;
      }
      queryCase_ = 0;
      query_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_QueryResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.QueryResult getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.QueryResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.QueryResult build() {
      com.google.cloud.dialogflow.cx.v3.QueryResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.QueryResult buildPartial() {
      com.google.cloud.dialogflow.cx.v3.QueryResult result =
          new com.google.cloud.dialogflow.cx.v3.QueryResult(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dialogflow.cx.v3.QueryResult result) {
      if (responseMessagesBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          responseMessages_ = java.util.Collections.unmodifiableList(responseMessages_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.responseMessages_ = responseMessages_;
      } else {
        result.responseMessages_ = responseMessagesBuilder_.build();
      }
      if (webhookLatenciesBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          webhookLatencies_ = java.util.Collections.unmodifiableList(webhookLatencies_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.webhookLatencies_ = webhookLatencies_;
      } else {
        result.webhookLatencies_ = webhookLatenciesBuilder_.build();
      }
      if (webhookStatusesBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          webhookStatuses_ = java.util.Collections.unmodifiableList(webhookStatuses_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.webhookStatuses_ = webhookStatuses_;
      } else {
        result.webhookStatuses_ = webhookStatusesBuilder_.build();
      }
      if (webhookPayloadsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          webhookPayloads_ = java.util.Collections.unmodifiableList(webhookPayloads_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.webhookPayloads_ = webhookPayloads_;
      } else {
        result.webhookPayloads_ = webhookPayloadsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.QueryResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.languageCode_ = languageCode_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.parameters_ = parametersBuilder_ == null ? parameters_ : parametersBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        webhookIds_.makeImmutable();
        result.webhookIds_ = webhookIds_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        webhookDisplayNames_.makeImmutable();
        result.webhookDisplayNames_ = webhookDisplayNames_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        webhookTags_.makeImmutable();
        result.webhookTags_ = webhookTags_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.currentPage_ =
            currentPageBuilder_ == null ? currentPage_ : currentPageBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.currentFlow_ =
            currentFlowBuilder_ == null ? currentFlow_ : currentFlowBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.intent_ = intentBuilder_ == null ? intent_ : intentBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.intentDetectionConfidence_ = intentDetectionConfidence_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.match_ = matchBuilder_ == null ? match_ : matchBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.diagnosticInfo_ =
            diagnosticInfoBuilder_ == null ? diagnosticInfo_ : diagnosticInfoBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.sentimentAnalysisResult_ =
            sentimentAnalysisResultBuilder_ == null
                ? sentimentAnalysisResult_
                : sentimentAnalysisResultBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.advancedSettings_ =
            advancedSettingsBuilder_ == null ? advancedSettings_ : advancedSettingsBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.allowAnswerFeedback_ = allowAnswerFeedback_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.dataStoreConnectionSignals_ =
            dataStoreConnectionSignalsBuilder_ == null
                ? dataStoreConnectionSignals_
                : dataStoreConnectionSignalsBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.cx.v3.QueryResult result) {
      result.queryCase_ = queryCase_;
      result.query_ = this.query_;
      if (queryCase_ == 23 && dtmfBuilder_ != null) {
        result.query_ = dtmfBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.QueryResult) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.QueryResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.QueryResult other) {
      if (other == com.google.cloud.dialogflow.cx.v3.QueryResult.getDefaultInstance()) return this;
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasParameters()) {
        mergeParameters(other.getParameters());
      }
      if (responseMessagesBuilder_ == null) {
        if (!other.responseMessages_.isEmpty()) {
          if (responseMessages_.isEmpty()) {
            responseMessages_ = other.responseMessages_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureResponseMessagesIsMutable();
            responseMessages_.addAll(other.responseMessages_);
          }
          onChanged();
        }
      } else {
        if (!other.responseMessages_.isEmpty()) {
          if (responseMessagesBuilder_.isEmpty()) {
            responseMessagesBuilder_.dispose();
            responseMessagesBuilder_ = null;
            responseMessages_ = other.responseMessages_;
            bitField0_ = (bitField0_ & ~0x00000080);
            responseMessagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResponseMessagesFieldBuilder()
                    : null;
          } else {
            responseMessagesBuilder_.addAllMessages(other.responseMessages_);
          }
        }
      }
      if (!other.webhookIds_.isEmpty()) {
        if (webhookIds_.isEmpty()) {
          webhookIds_ = other.webhookIds_;
          bitField0_ |= 0x00000100;
        } else {
          ensureWebhookIdsIsMutable();
          webhookIds_.addAll(other.webhookIds_);
        }
        onChanged();
      }
      if (!other.webhookDisplayNames_.isEmpty()) {
        if (webhookDisplayNames_.isEmpty()) {
          webhookDisplayNames_ = other.webhookDisplayNames_;
          bitField0_ |= 0x00000200;
        } else {
          ensureWebhookDisplayNamesIsMutable();
          webhookDisplayNames_.addAll(other.webhookDisplayNames_);
        }
        onChanged();
      }
      if (webhookLatenciesBuilder_ == null) {
        if (!other.webhookLatencies_.isEmpty()) {
          if (webhookLatencies_.isEmpty()) {
            webhookLatencies_ = other.webhookLatencies_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureWebhookLatenciesIsMutable();
            webhookLatencies_.addAll(other.webhookLatencies_);
          }
          onChanged();
        }
      } else {
        if (!other.webhookLatencies_.isEmpty()) {
          if (webhookLatenciesBuilder_.isEmpty()) {
            webhookLatenciesBuilder_.dispose();
            webhookLatenciesBuilder_ = null;
            webhookLatencies_ = other.webhookLatencies_;
            bitField0_ = (bitField0_ & ~0x00000400);
            webhookLatenciesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWebhookLatenciesFieldBuilder()
                    : null;
          } else {
            webhookLatenciesBuilder_.addAllMessages(other.webhookLatencies_);
          }
        }
      }
      if (!other.webhookTags_.isEmpty()) {
        if (webhookTags_.isEmpty()) {
          webhookTags_ = other.webhookTags_;
          bitField0_ |= 0x00000800;
        } else {
          ensureWebhookTagsIsMutable();
          webhookTags_.addAll(other.webhookTags_);
        }
        onChanged();
      }
      if (webhookStatusesBuilder_ == null) {
        if (!other.webhookStatuses_.isEmpty()) {
          if (webhookStatuses_.isEmpty()) {
            webhookStatuses_ = other.webhookStatuses_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensureWebhookStatusesIsMutable();
            webhookStatuses_.addAll(other.webhookStatuses_);
          }
          onChanged();
        }
      } else {
        if (!other.webhookStatuses_.isEmpty()) {
          if (webhookStatusesBuilder_.isEmpty()) {
            webhookStatusesBuilder_.dispose();
            webhookStatusesBuilder_ = null;
            webhookStatuses_ = other.webhookStatuses_;
            bitField0_ = (bitField0_ & ~0x00001000);
            webhookStatusesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWebhookStatusesFieldBuilder()
                    : null;
          } else {
            webhookStatusesBuilder_.addAllMessages(other.webhookStatuses_);
          }
        }
      }
      if (webhookPayloadsBuilder_ == null) {
        if (!other.webhookPayloads_.isEmpty()) {
          if (webhookPayloads_.isEmpty()) {
            webhookPayloads_ = other.webhookPayloads_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureWebhookPayloadsIsMutable();
            webhookPayloads_.addAll(other.webhookPayloads_);
          }
          onChanged();
        }
      } else {
        if (!other.webhookPayloads_.isEmpty()) {
          if (webhookPayloadsBuilder_.isEmpty()) {
            webhookPayloadsBuilder_.dispose();
            webhookPayloadsBuilder_ = null;
            webhookPayloads_ = other.webhookPayloads_;
            bitField0_ = (bitField0_ & ~0x00002000);
            webhookPayloadsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWebhookPayloadsFieldBuilder()
                    : null;
          } else {
            webhookPayloadsBuilder_.addAllMessages(other.webhookPayloads_);
          }
        }
      }
      if (other.hasCurrentPage()) {
        mergeCurrentPage(other.getCurrentPage());
      }
      if (other.hasCurrentFlow()) {
        mergeCurrentFlow(other.getCurrentFlow());
      }
      if (other.hasIntent()) {
        mergeIntent(other.getIntent());
      }
      if (other.getIntentDetectionConfidence() != 0F) {
        setIntentDetectionConfidence(other.getIntentDetectionConfidence());
      }
      if (other.hasMatch()) {
        mergeMatch(other.getMatch());
      }
      if (other.hasDiagnosticInfo()) {
        mergeDiagnosticInfo(other.getDiagnosticInfo());
      }
      if (other.hasSentimentAnalysisResult()) {
        mergeSentimentAnalysisResult(other.getSentimentAnalysisResult());
      }
      if (other.hasAdvancedSettings()) {
        mergeAdvancedSettings(other.getAdvancedSettings());
      }
      if (other.getAllowAnswerFeedback() != false) {
        setAllowAnswerFeedback(other.getAllowAnswerFeedback());
      }
      if (other.hasDataStoreConnectionSignals()) {
        mergeDataStoreConnectionSignals(other.getDataStoreConnectionSignals());
      }
      switch (other.getQueryCase()) {
        case TEXT:
          {
            queryCase_ = 1;
            query_ = other.query_;
            onChanged();
            break;
          }
        case TRIGGER_INTENT:
          {
            queryCase_ = 11;
            query_ = other.query_;
            onChanged();
            break;
          }
        case TRANSCRIPT:
          {
            queryCase_ = 12;
            query_ = other.query_;
            onChanged();
            break;
          }
        case TRIGGER_EVENT:
          {
            queryCase_ = 14;
            query_ = other.query_;
            onChanged();
            break;
          }
        case DTMF:
          {
            mergeDtmf(other.getDtmf());
            break;
          }
        case QUERY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queryCase_ = 1;
                query_ = s;
                break;
              } // case 10
            case 18:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.dialogflow.cx.v3.ResponseMessage m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.ResponseMessage.parser(),
                        extensionRegistry);
                if (responseMessagesBuilder_ == null) {
                  ensureResponseMessagesIsMutable();
                  responseMessages_.add(m);
                } else {
                  responseMessagesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 50:
              {
                com.google.protobuf.Struct m =
                    input.readMessage(com.google.protobuf.Struct.parser(), extensionRegistry);
                if (webhookPayloadsBuilder_ == null) {
                  ensureWebhookPayloadsIsMutable();
                  webhookPayloads_.add(m);
                } else {
                  webhookPayloadsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCurrentPageFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getIntentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 66
            case 77:
              {
                intentDetectionConfidence_ = input.readFloat();
                bitField0_ |= 0x00020000;
                break;
              } // case 77
            case 82:
              {
                input.readMessage(getDiagnosticInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queryCase_ = 11;
                query_ = s;
                break;
              } // case 90
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queryCase_ = 12;
                query_ = s;
                break;
              } // case 98
            case 106:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (webhookStatusesBuilder_ == null) {
                  ensureWebhookStatusesIsMutable();
                  webhookStatuses_.add(m);
                } else {
                  webhookStatusesBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                java.lang.String s = input.readStringRequireUtf8();
                queryCase_ = 14;
                query_ = s;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getMatchFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 122
            case 138:
              {
                input.readMessage(
                    getSentimentAnalysisResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 138
            case 170:
              {
                input.readMessage(
                    getAdvancedSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 170
            case 186:
              {
                input.readMessage(getDtmfFieldBuilder().getBuilder(), extensionRegistry);
                queryCase_ = 23;
                break;
              } // case 186
            case 202:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureWebhookIdsIsMutable();
                webhookIds_.add(s);
                break;
              } // case 202
            case 210:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureWebhookDisplayNamesIsMutable();
                webhookDisplayNames_.add(s);
                break;
              } // case 210
            case 218:
              {
                com.google.protobuf.Duration m =
                    input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
                if (webhookLatenciesBuilder_ == null) {
                  ensureWebhookLatenciesIsMutable();
                  webhookLatencies_.add(m);
                } else {
                  webhookLatenciesBuilder_.addMessage(m);
                }
                break;
              } // case 218
            case 234:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureWebhookTagsIsMutable();
                webhookTags_.add(s);
                break;
              } // case 234
            case 250:
              {
                input.readMessage(getCurrentFlowFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 250
            case 256:
              {
                allowAnswerFeedback_ = input.readBool();
                bitField0_ |= 0x00400000;
                break;
              } // case 256
            case 282:
              {
                input.readMessage(
                    getDataStoreConnectionSignalsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 282
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int queryCase_ = 0;
    private java.lang.Object query_;

    public QueryCase getQueryCase() {
      return QueryCase.forNumber(queryCase_);
    }

    public Builder clearQuery() {
      queryCase_ = 0;
      query_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
     * provided as input, this field will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return Whether the text field is set.
     */
    @java.lang.Override
    public boolean hasText() {
      return queryCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
     * provided as input, this field will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = "";
      if (queryCase_ == 1) {
        ref = query_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queryCase_ == 1) {
          query_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
     * provided as input, this field will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = "";
      if (queryCase_ == 1) {
        ref = query_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queryCase_ == 1) {
          query_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
     * provided as input, this field will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @param value The text to set.
     * @return This builder for chaining.
     */
    public Builder setText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryCase_ = 1;
      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
     * provided as input, this field will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearText() {
      if (queryCase_ == 1) {
        queryCase_ = 0;
        query_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
     * provided as input, this field will contain a copy of the text.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @param value The bytes for text to set.
     * @return This builder for chaining.
     */
    public Builder setTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryCase_ = 1;
      query_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
     * input, this field will contain a copy of the intent identifier. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the triggerIntent field is set.
     */
    @java.lang.Override
    public boolean hasTriggerIntent() {
      return queryCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
     * input, this field will contain a copy of the intent identifier. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The triggerIntent.
     */
    @java.lang.Override
    public java.lang.String getTriggerIntent() {
      java.lang.Object ref = "";
      if (queryCase_ == 11) {
        ref = query_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queryCase_ == 11) {
          query_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
     * input, this field will contain a copy of the intent identifier. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for triggerIntent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTriggerIntentBytes() {
      java.lang.Object ref = "";
      if (queryCase_ == 11) {
        ref = query_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queryCase_ == 11) {
          query_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
     * input, this field will contain a copy of the intent identifier. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The triggerIntent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerIntent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryCase_ = 11;
      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
     * input, this field will contain a copy of the intent identifier. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggerIntent() {
      if (queryCase_ == 11) {
        queryCase_ = 0;
        query_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
     * input, this field will contain a copy of the intent identifier. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/intents/&lt;IntentID&gt;`.
     * </pre>
     *
     * <code>string trigger_intent = 11 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for triggerIntent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerIntentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryCase_ = 11;
      query_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 12;</code>
     *
     * @return Whether the transcript field is set.
     */
    @java.lang.Override
    public boolean hasTranscript() {
      return queryCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 12;</code>
     *
     * @return The transcript.
     */
    @java.lang.Override
    public java.lang.String getTranscript() {
      java.lang.Object ref = "";
      if (queryCase_ == 12) {
        ref = query_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queryCase_ == 12) {
          query_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 12;</code>
     *
     * @return The bytes for transcript.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTranscriptBytes() {
      java.lang.Object ref = "";
      if (queryCase_ == 12) {
        ref = query_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queryCase_ == 12) {
          query_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 12;</code>
     *
     * @param value The transcript to set.
     * @return This builder for chaining.
     */
    public Builder setTranscript(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryCase_ = 12;
      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTranscript() {
      if (queryCase_ == 12) {
        queryCase_ = 0;
        query_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     * </pre>
     *
     * <code>string transcript = 12;</code>
     *
     * @param value The bytes for transcript to set.
     * @return This builder for chaining.
     */
    public Builder setTranscriptBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryCase_ = 12;
      query_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
     * input, this field will contain the name of the event.
     * </pre>
     *
     * <code>string trigger_event = 14;</code>
     *
     * @return Whether the triggerEvent field is set.
     */
    @java.lang.Override
    public boolean hasTriggerEvent() {
      return queryCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
     * input, this field will contain the name of the event.
     * </pre>
     *
     * <code>string trigger_event = 14;</code>
     *
     * @return The triggerEvent.
     */
    @java.lang.Override
    public java.lang.String getTriggerEvent() {
      java.lang.Object ref = "";
      if (queryCase_ == 14) {
        ref = query_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (queryCase_ == 14) {
          query_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
     * input, this field will contain the name of the event.
     * </pre>
     *
     * <code>string trigger_event = 14;</code>
     *
     * @return The bytes for triggerEvent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTriggerEventBytes() {
      java.lang.Object ref = "";
      if (queryCase_ == 14) {
        ref = query_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (queryCase_ == 14) {
          query_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
     * input, this field will contain the name of the event.
     * </pre>
     *
     * <code>string trigger_event = 14;</code>
     *
     * @param value The triggerEvent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerEvent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryCase_ = 14;
      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
     * input, this field will contain the name of the event.
     * </pre>
     *
     * <code>string trigger_event = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggerEvent() {
      if (queryCase_ == 14) {
        queryCase_ = 0;
        query_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
     * input, this field will contain the name of the event.
     * </pre>
     *
     * <code>string trigger_event = 14;</code>
     *
     * @param value The bytes for triggerEvent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerEventBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryCase_ = 14;
      query_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DtmfInput,
            com.google.cloud.dialogflow.cx.v3.DtmfInput.Builder,
            com.google.cloud.dialogflow.cx.v3.DtmfInputOrBuilder>
        dtmfBuilder_;
    /**
     *
     *
     * <pre>
     * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
     * input, this field will contain a copy of the
     * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
     *
     * @return Whether the dtmf field is set.
     */
    @java.lang.Override
    public boolean hasDtmf() {
      return queryCase_ == 23;
    }
    /**
     *
     *
     * <pre>
     * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
     * input, this field will contain a copy of the
     * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
     *
     * @return The dtmf.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DtmfInput getDtmf() {
      if (dtmfBuilder_ == null) {
        if (queryCase_ == 23) {
          return (com.google.cloud.dialogflow.cx.v3.DtmfInput) query_;
        }
        return com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance();
      } else {
        if (queryCase_ == 23) {
          return dtmfBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
     * input, this field will contain a copy of the
     * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
     */
    public Builder setDtmf(com.google.cloud.dialogflow.cx.v3.DtmfInput value) {
      if (dtmfBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        query_ = value;
        onChanged();
      } else {
        dtmfBuilder_.setMessage(value);
      }
      queryCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
     * input, this field will contain a copy of the
     * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
     */
    public Builder setDtmf(com.google.cloud.dialogflow.cx.v3.DtmfInput.Builder builderForValue) {
      if (dtmfBuilder_ == null) {
        query_ = builderForValue.build();
        onChanged();
      } else {
        dtmfBuilder_.setMessage(builderForValue.build());
      }
      queryCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
     * input, this field will contain a copy of the
     * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
     */
    public Builder mergeDtmf(com.google.cloud.dialogflow.cx.v3.DtmfInput value) {
      if (dtmfBuilder_ == null) {
        if (queryCase_ == 23
            && query_ != com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance()) {
          query_ =
              com.google.cloud.dialogflow.cx.v3.DtmfInput.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3.DtmfInput) query_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          query_ = value;
        }
        onChanged();
      } else {
        if (queryCase_ == 23) {
          dtmfBuilder_.mergeFrom(value);
        } else {
          dtmfBuilder_.setMessage(value);
        }
      }
      queryCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
     * input, this field will contain a copy of the
     * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
     */
    public Builder clearDtmf() {
      if (dtmfBuilder_ == null) {
        if (queryCase_ == 23) {
          queryCase_ = 0;
          query_ = null;
          onChanged();
        }
      } else {
        if (queryCase_ == 23) {
          queryCase_ = 0;
          query_ = null;
        }
        dtmfBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
     * input, this field will contain a copy of the
     * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.DtmfInput.Builder getDtmfBuilder() {
      return getDtmfFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
     * input, this field will contain a copy of the
     * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DtmfInputOrBuilder getDtmfOrBuilder() {
      if ((queryCase_ == 23) && (dtmfBuilder_ != null)) {
        return dtmfBuilder_.getMessageOrBuilder();
      } else {
        if (queryCase_ == 23) {
          return (com.google.cloud.dialogflow.cx.v3.DtmfInput) query_;
        }
        return com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
     * input, this field will contain a copy of the
     * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DtmfInput,
            com.google.cloud.dialogflow.cx.v3.DtmfInput.Builder,
            com.google.cloud.dialogflow.cx.v3.DtmfInputOrBuilder>
        getDtmfFieldBuilder() {
      if (dtmfBuilder_ == null) {
        if (!(queryCase_ == 23)) {
          query_ = com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance();
        }
        dtmfBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.DtmfInput,
                com.google.cloud.dialogflow.cx.v3.DtmfInput.Builder,
                com.google.cloud.dialogflow.cx.v3.DtmfInputOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3.DtmfInput) query_,
                getParentForChildren(),
                isClean());
        query_ = null;
      }
      queryCase_ = 23;
      onChanged();
      return dtmfBuilder_;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct parameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        parametersBuilder_;
    /**
     *
     *
     * <pre>
     * The collected [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     *
     * @return Whether the parameters field is set.
     */
    public boolean hasParameters() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The collected [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     *
     * @return The parameters.
     */
    public com.google.protobuf.Struct getParameters() {
      if (parametersBuilder_ == null) {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      } else {
        return parametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The collected [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameters_ = value;
      } else {
        parametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collected [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        parameters_ = builderForValue.build();
      } else {
        parametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collected [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    public Builder mergeParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && parameters_ != null
            && parameters_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getParametersBuilder().mergeFrom(value);
        } else {
          parameters_ = value;
        }
      } else {
        parametersBuilder_.mergeFrom(value);
      }
      if (parameters_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collected [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    public Builder clearParameters() {
      bitField0_ = (bitField0_ & ~0x00000040);
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collected [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    public com.google.protobuf.Struct.Builder getParametersBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The collected [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilder();
      } else {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * The collected [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getParameters(), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage> responseMessages_ =
        java.util.Collections.emptyList();

    private void ensureResponseMessagesIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        responseMessages_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.ResponseMessage>(
                responseMessages_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ResponseMessage,
            com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder,
            com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
        responseMessagesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage>
        getResponseMessagesList() {
      if (responseMessagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(responseMessages_);
      } else {
        return responseMessagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public int getResponseMessagesCount() {
      if (responseMessagesBuilder_ == null) {
        return responseMessages_.size();
      } else {
        return responseMessagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage getResponseMessages(int index) {
      if (responseMessagesBuilder_ == null) {
        return responseMessages_.get(index);
      } else {
        return responseMessagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public Builder setResponseMessages(
        int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage value) {
      if (responseMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseMessagesIsMutable();
        responseMessages_.set(index, value);
        onChanged();
      } else {
        responseMessagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public Builder setResponseMessages(
        int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder builderForValue) {
      if (responseMessagesBuilder_ == null) {
        ensureResponseMessagesIsMutable();
        responseMessages_.set(index, builderForValue.build());
        onChanged();
      } else {
        responseMessagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public Builder addResponseMessages(com.google.cloud.dialogflow.cx.v3.ResponseMessage value) {
      if (responseMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseMessagesIsMutable();
        responseMessages_.add(value);
        onChanged();
      } else {
        responseMessagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public Builder addResponseMessages(
        int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage value) {
      if (responseMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseMessagesIsMutable();
        responseMessages_.add(index, value);
        onChanged();
      } else {
        responseMessagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public Builder addResponseMessages(
        com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder builderForValue) {
      if (responseMessagesBuilder_ == null) {
        ensureResponseMessagesIsMutable();
        responseMessages_.add(builderForValue.build());
        onChanged();
      } else {
        responseMessagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public Builder addResponseMessages(
        int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder builderForValue) {
      if (responseMessagesBuilder_ == null) {
        ensureResponseMessagesIsMutable();
        responseMessages_.add(index, builderForValue.build());
        onChanged();
      } else {
        responseMessagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public Builder addAllResponseMessages(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.ResponseMessage> values) {
      if (responseMessagesBuilder_ == null) {
        ensureResponseMessagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, responseMessages_);
        onChanged();
      } else {
        responseMessagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public Builder clearResponseMessages() {
      if (responseMessagesBuilder_ == null) {
        responseMessages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        responseMessagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public Builder removeResponseMessages(int index) {
      if (responseMessagesBuilder_ == null) {
        ensureResponseMessagesIsMutable();
        responseMessages_.remove(index);
        onChanged();
      } else {
        responseMessagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder getResponseMessagesBuilder(
        int index) {
      return getResponseMessagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder getResponseMessagesOrBuilder(
        int index) {
      if (responseMessagesBuilder_ == null) {
        return responseMessages_.get(index);
      } else {
        return responseMessagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
        getResponseMessagesOrBuilderList() {
      if (responseMessagesBuilder_ != null) {
        return responseMessagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(responseMessages_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder addResponseMessagesBuilder() {
      return getResponseMessagesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder addResponseMessagesBuilder(
        int index) {
      return getResponseMessagesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.cx.v3.ResponseMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder>
        getResponseMessagesBuilderList() {
      return getResponseMessagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ResponseMessage,
            com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder,
            com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>
        getResponseMessagesFieldBuilder() {
      if (responseMessagesBuilder_ == null) {
        responseMessagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.ResponseMessage,
                com.google.cloud.dialogflow.cx.v3.ResponseMessage.Builder,
                com.google.cloud.dialogflow.cx.v3.ResponseMessageOrBuilder>(
                responseMessages_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        responseMessages_ = null;
      }
      return responseMessagesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList webhookIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureWebhookIdsIsMutable() {
      if (!webhookIds_.isModifiable()) {
        webhookIds_ = new com.google.protobuf.LazyStringArrayList(webhookIds_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook ids in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_ids = 25;</code>
     *
     * @return A list containing the webhookIds.
     */
    public com.google.protobuf.ProtocolStringList getWebhookIdsList() {
      webhookIds_.makeImmutable();
      return webhookIds_;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook ids in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_ids = 25;</code>
     *
     * @return The count of webhookIds.
     */
    public int getWebhookIdsCount() {
      return webhookIds_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of webhook ids in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_ids = 25;</code>
     *
     * @param index The index of the element to return.
     * @return The webhookIds at the given index.
     */
    public java.lang.String getWebhookIds(int index) {
      return webhookIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of webhook ids in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_ids = 25;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the webhookIds at the given index.
     */
    public com.google.protobuf.ByteString getWebhookIdsBytes(int index) {
      return webhookIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of webhook ids in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_ids = 25;</code>
     *
     * @param index The index to set the value at.
     * @param value The webhookIds to set.
     * @return This builder for chaining.
     */
    public Builder setWebhookIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWebhookIdsIsMutable();
      webhookIds_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook ids in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_ids = 25;</code>
     *
     * @param value The webhookIds to add.
     * @return This builder for chaining.
     */
    public Builder addWebhookIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWebhookIdsIsMutable();
      webhookIds_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook ids in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_ids = 25;</code>
     *
     * @param values The webhookIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllWebhookIds(java.lang.Iterable<java.lang.String> values) {
      ensureWebhookIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, webhookIds_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook ids in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_ids = 25;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWebhookIds() {
      webhookIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook ids in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_ids = 25;</code>
     *
     * @param value The bytes of the webhookIds to add.
     * @return This builder for chaining.
     */
    public Builder addWebhookIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureWebhookIdsIsMutable();
      webhookIds_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList webhookDisplayNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureWebhookDisplayNamesIsMutable() {
      if (!webhookDisplayNames_.isModifiable()) {
        webhookDisplayNames_ = new com.google.protobuf.LazyStringArrayList(webhookDisplayNames_);
      }
      bitField0_ |= 0x00000200;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook display names in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_display_names = 26;</code>
     *
     * @return A list containing the webhookDisplayNames.
     */
    public com.google.protobuf.ProtocolStringList getWebhookDisplayNamesList() {
      webhookDisplayNames_.makeImmutable();
      return webhookDisplayNames_;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook display names in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_display_names = 26;</code>
     *
     * @return The count of webhookDisplayNames.
     */
    public int getWebhookDisplayNamesCount() {
      return webhookDisplayNames_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of webhook display names in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_display_names = 26;</code>
     *
     * @param index The index of the element to return.
     * @return The webhookDisplayNames at the given index.
     */
    public java.lang.String getWebhookDisplayNames(int index) {
      return webhookDisplayNames_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of webhook display names in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_display_names = 26;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the webhookDisplayNames at the given index.
     */
    public com.google.protobuf.ByteString getWebhookDisplayNamesBytes(int index) {
      return webhookDisplayNames_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of webhook display names in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_display_names = 26;</code>
     *
     * @param index The index to set the value at.
     * @param value The webhookDisplayNames to set.
     * @return This builder for chaining.
     */
    public Builder setWebhookDisplayNames(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWebhookDisplayNamesIsMutable();
      webhookDisplayNames_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook display names in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_display_names = 26;</code>
     *
     * @param value The webhookDisplayNames to add.
     * @return This builder for chaining.
     */
    public Builder addWebhookDisplayNames(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWebhookDisplayNamesIsMutable();
      webhookDisplayNames_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook display names in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_display_names = 26;</code>
     *
     * @param values The webhookDisplayNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllWebhookDisplayNames(java.lang.Iterable<java.lang.String> values) {
      ensureWebhookDisplayNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, webhookDisplayNames_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook display names in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_display_names = 26;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWebhookDisplayNames() {
      webhookDisplayNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook display names in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_display_names = 26;</code>
     *
     * @param value The bytes of the webhookDisplayNames to add.
     * @return This builder for chaining.
     */
    public Builder addWebhookDisplayNamesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureWebhookDisplayNamesIsMutable();
      webhookDisplayNames_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.Duration> webhookLatencies_ =
        java.util.Collections.emptyList();

    private void ensureWebhookLatenciesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        webhookLatencies_ =
            new java.util.ArrayList<com.google.protobuf.Duration>(webhookLatencies_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        webhookLatenciesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public java.util.List<com.google.protobuf.Duration> getWebhookLatenciesList() {
      if (webhookLatenciesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(webhookLatencies_);
      } else {
        return webhookLatenciesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public int getWebhookLatenciesCount() {
      if (webhookLatenciesBuilder_ == null) {
        return webhookLatencies_.size();
      } else {
        return webhookLatenciesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public com.google.protobuf.Duration getWebhookLatencies(int index) {
      if (webhookLatenciesBuilder_ == null) {
        return webhookLatencies_.get(index);
      } else {
        return webhookLatenciesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public Builder setWebhookLatencies(int index, com.google.protobuf.Duration value) {
      if (webhookLatenciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWebhookLatenciesIsMutable();
        webhookLatencies_.set(index, value);
        onChanged();
      } else {
        webhookLatenciesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public Builder setWebhookLatencies(
        int index, com.google.protobuf.Duration.Builder builderForValue) {
      if (webhookLatenciesBuilder_ == null) {
        ensureWebhookLatenciesIsMutable();
        webhookLatencies_.set(index, builderForValue.build());
        onChanged();
      } else {
        webhookLatenciesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public Builder addWebhookLatencies(com.google.protobuf.Duration value) {
      if (webhookLatenciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWebhookLatenciesIsMutable();
        webhookLatencies_.add(value);
        onChanged();
      } else {
        webhookLatenciesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public Builder addWebhookLatencies(int index, com.google.protobuf.Duration value) {
      if (webhookLatenciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWebhookLatenciesIsMutable();
        webhookLatencies_.add(index, value);
        onChanged();
      } else {
        webhookLatenciesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public Builder addWebhookLatencies(com.google.protobuf.Duration.Builder builderForValue) {
      if (webhookLatenciesBuilder_ == null) {
        ensureWebhookLatenciesIsMutable();
        webhookLatencies_.add(builderForValue.build());
        onChanged();
      } else {
        webhookLatenciesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public Builder addWebhookLatencies(
        int index, com.google.protobuf.Duration.Builder builderForValue) {
      if (webhookLatenciesBuilder_ == null) {
        ensureWebhookLatenciesIsMutable();
        webhookLatencies_.add(index, builderForValue.build());
        onChanged();
      } else {
        webhookLatenciesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public Builder addAllWebhookLatencies(
        java.lang.Iterable<? extends com.google.protobuf.Duration> values) {
      if (webhookLatenciesBuilder_ == null) {
        ensureWebhookLatenciesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, webhookLatencies_);
        onChanged();
      } else {
        webhookLatenciesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public Builder clearWebhookLatencies() {
      if (webhookLatenciesBuilder_ == null) {
        webhookLatencies_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        webhookLatenciesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public Builder removeWebhookLatencies(int index) {
      if (webhookLatenciesBuilder_ == null) {
        ensureWebhookLatenciesIsMutable();
        webhookLatencies_.remove(index);
        onChanged();
      } else {
        webhookLatenciesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public com.google.protobuf.Duration.Builder getWebhookLatenciesBuilder(int index) {
      return getWebhookLatenciesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public com.google.protobuf.DurationOrBuilder getWebhookLatenciesOrBuilder(int index) {
      if (webhookLatenciesBuilder_ == null) {
        return webhookLatencies_.get(index);
      } else {
        return webhookLatenciesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public java.util.List<? extends com.google.protobuf.DurationOrBuilder>
        getWebhookLatenciesOrBuilderList() {
      if (webhookLatenciesBuilder_ != null) {
        return webhookLatenciesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(webhookLatencies_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public com.google.protobuf.Duration.Builder addWebhookLatenciesBuilder() {
      return getWebhookLatenciesFieldBuilder()
          .addBuilder(com.google.protobuf.Duration.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public com.google.protobuf.Duration.Builder addWebhookLatenciesBuilder(int index) {
      return getWebhookLatenciesFieldBuilder()
          .addBuilder(index, com.google.protobuf.Duration.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of webhook latencies in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration webhook_latencies = 27;</code>
     */
    public java.util.List<com.google.protobuf.Duration.Builder> getWebhookLatenciesBuilderList() {
      return getWebhookLatenciesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getWebhookLatenciesFieldBuilder() {
      if (webhookLatenciesBuilder_ == null) {
        webhookLatenciesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                webhookLatencies_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        webhookLatencies_ = null;
      }
      return webhookLatenciesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList webhookTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureWebhookTagsIsMutable() {
      if (!webhookTags_.isModifiable()) {
        webhookTags_ = new com.google.protobuf.LazyStringArrayList(webhookTags_);
      }
      bitField0_ |= 0x00000800;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook tags in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_tags = 29;</code>
     *
     * @return A list containing the webhookTags.
     */
    public com.google.protobuf.ProtocolStringList getWebhookTagsList() {
      webhookTags_.makeImmutable();
      return webhookTags_;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook tags in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_tags = 29;</code>
     *
     * @return The count of webhookTags.
     */
    public int getWebhookTagsCount() {
      return webhookTags_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of webhook tags in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_tags = 29;</code>
     *
     * @param index The index of the element to return.
     * @return The webhookTags at the given index.
     */
    public java.lang.String getWebhookTags(int index) {
      return webhookTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of webhook tags in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_tags = 29;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the webhookTags at the given index.
     */
    public com.google.protobuf.ByteString getWebhookTagsBytes(int index) {
      return webhookTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of webhook tags in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_tags = 29;</code>
     *
     * @param index The index to set the value at.
     * @param value The webhookTags to set.
     * @return This builder for chaining.
     */
    public Builder setWebhookTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWebhookTagsIsMutable();
      webhookTags_.set(index, value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook tags in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_tags = 29;</code>
     *
     * @param value The webhookTags to add.
     * @return This builder for chaining.
     */
    public Builder addWebhookTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWebhookTagsIsMutable();
      webhookTags_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook tags in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_tags = 29;</code>
     *
     * @param values The webhookTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllWebhookTags(java.lang.Iterable<java.lang.String> values) {
      ensureWebhookTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, webhookTags_);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook tags in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_tags = 29;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWebhookTags() {
      webhookTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook tags in the order of call sequence.
     * </pre>
     *
     * <code>repeated string webhook_tags = 29;</code>
     *
     * @param value The bytes of the webhookTags to add.
     * @return This builder for chaining.
     */
    public Builder addWebhookTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureWebhookTagsIsMutable();
      webhookTags_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.util.List<com.google.rpc.Status> webhookStatuses_ =
        java.util.Collections.emptyList();

    private void ensureWebhookStatusesIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        webhookStatuses_ = new java.util.ArrayList<com.google.rpc.Status>(webhookStatuses_);
        bitField0_ |= 0x00001000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        webhookStatusesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public java.util.List<com.google.rpc.Status> getWebhookStatusesList() {
      if (webhookStatusesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(webhookStatuses_);
      } else {
        return webhookStatusesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public int getWebhookStatusesCount() {
      if (webhookStatusesBuilder_ == null) {
        return webhookStatuses_.size();
      } else {
        return webhookStatusesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public com.google.rpc.Status getWebhookStatuses(int index) {
      if (webhookStatusesBuilder_ == null) {
        return webhookStatuses_.get(index);
      } else {
        return webhookStatusesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public Builder setWebhookStatuses(int index, com.google.rpc.Status value) {
      if (webhookStatusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWebhookStatusesIsMutable();
        webhookStatuses_.set(index, value);
        onChanged();
      } else {
        webhookStatusesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public Builder setWebhookStatuses(int index, com.google.rpc.Status.Builder builderForValue) {
      if (webhookStatusesBuilder_ == null) {
        ensureWebhookStatusesIsMutable();
        webhookStatuses_.set(index, builderForValue.build());
        onChanged();
      } else {
        webhookStatusesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public Builder addWebhookStatuses(com.google.rpc.Status value) {
      if (webhookStatusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWebhookStatusesIsMutable();
        webhookStatuses_.add(value);
        onChanged();
      } else {
        webhookStatusesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public Builder addWebhookStatuses(int index, com.google.rpc.Status value) {
      if (webhookStatusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWebhookStatusesIsMutable();
        webhookStatuses_.add(index, value);
        onChanged();
      } else {
        webhookStatusesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public Builder addWebhookStatuses(com.google.rpc.Status.Builder builderForValue) {
      if (webhookStatusesBuilder_ == null) {
        ensureWebhookStatusesIsMutable();
        webhookStatuses_.add(builderForValue.build());
        onChanged();
      } else {
        webhookStatusesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public Builder addWebhookStatuses(int index, com.google.rpc.Status.Builder builderForValue) {
      if (webhookStatusesBuilder_ == null) {
        ensureWebhookStatusesIsMutable();
        webhookStatuses_.add(index, builderForValue.build());
        onChanged();
      } else {
        webhookStatusesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public Builder addAllWebhookStatuses(
        java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (webhookStatusesBuilder_ == null) {
        ensureWebhookStatusesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, webhookStatuses_);
        onChanged();
      } else {
        webhookStatusesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public Builder clearWebhookStatuses() {
      if (webhookStatusesBuilder_ == null) {
        webhookStatuses_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        webhookStatusesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public Builder removeWebhookStatuses(int index) {
      if (webhookStatusesBuilder_ == null) {
        ensureWebhookStatusesIsMutable();
        webhookStatuses_.remove(index);
        onChanged();
      } else {
        webhookStatusesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public com.google.rpc.Status.Builder getWebhookStatusesBuilder(int index) {
      return getWebhookStatusesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public com.google.rpc.StatusOrBuilder getWebhookStatusesOrBuilder(int index) {
      if (webhookStatusesBuilder_ == null) {
        return webhookStatuses_.get(index);
      } else {
        return webhookStatusesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getWebhookStatusesOrBuilderList() {
      if (webhookStatusesBuilder_ != null) {
        return webhookStatusesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(webhookStatuses_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public com.google.rpc.Status.Builder addWebhookStatusesBuilder() {
      return getWebhookStatusesFieldBuilder()
          .addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public com.google.rpc.Status.Builder addWebhookStatusesBuilder(int index) {
      return getWebhookStatusesFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of webhook call status in the order of call sequence.
     * </pre>
     *
     * <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getWebhookStatusesBuilderList() {
      return getWebhookStatusesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getWebhookStatusesFieldBuilder() {
      if (webhookStatusesBuilder_ == null) {
        webhookStatusesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                webhookStatuses_,
                ((bitField0_ & 0x00001000) != 0),
                getParentForChildren(),
                isClean());
        webhookStatuses_ = null;
      }
      return webhookStatusesBuilder_;
    }

    private java.util.List<com.google.protobuf.Struct> webhookPayloads_ =
        java.util.Collections.emptyList();

    private void ensureWebhookPayloadsIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        webhookPayloads_ = new java.util.ArrayList<com.google.protobuf.Struct>(webhookPayloads_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        webhookPayloadsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public java.util.List<com.google.protobuf.Struct> getWebhookPayloadsList() {
      if (webhookPayloadsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(webhookPayloads_);
      } else {
        return webhookPayloadsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public int getWebhookPayloadsCount() {
      if (webhookPayloadsBuilder_ == null) {
        return webhookPayloads_.size();
      } else {
        return webhookPayloadsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public com.google.protobuf.Struct getWebhookPayloads(int index) {
      if (webhookPayloadsBuilder_ == null) {
        return webhookPayloads_.get(index);
      } else {
        return webhookPayloadsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public Builder setWebhookPayloads(int index, com.google.protobuf.Struct value) {
      if (webhookPayloadsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWebhookPayloadsIsMutable();
        webhookPayloads_.set(index, value);
        onChanged();
      } else {
        webhookPayloadsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public Builder setWebhookPayloads(
        int index, com.google.protobuf.Struct.Builder builderForValue) {
      if (webhookPayloadsBuilder_ == null) {
        ensureWebhookPayloadsIsMutable();
        webhookPayloads_.set(index, builderForValue.build());
        onChanged();
      } else {
        webhookPayloadsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public Builder addWebhookPayloads(com.google.protobuf.Struct value) {
      if (webhookPayloadsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWebhookPayloadsIsMutable();
        webhookPayloads_.add(value);
        onChanged();
      } else {
        webhookPayloadsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public Builder addWebhookPayloads(int index, com.google.protobuf.Struct value) {
      if (webhookPayloadsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWebhookPayloadsIsMutable();
        webhookPayloads_.add(index, value);
        onChanged();
      } else {
        webhookPayloadsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public Builder addWebhookPayloads(com.google.protobuf.Struct.Builder builderForValue) {
      if (webhookPayloadsBuilder_ == null) {
        ensureWebhookPayloadsIsMutable();
        webhookPayloads_.add(builderForValue.build());
        onChanged();
      } else {
        webhookPayloadsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public Builder addWebhookPayloads(
        int index, com.google.protobuf.Struct.Builder builderForValue) {
      if (webhookPayloadsBuilder_ == null) {
        ensureWebhookPayloadsIsMutable();
        webhookPayloads_.add(index, builderForValue.build());
        onChanged();
      } else {
        webhookPayloadsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public Builder addAllWebhookPayloads(
        java.lang.Iterable<? extends com.google.protobuf.Struct> values) {
      if (webhookPayloadsBuilder_ == null) {
        ensureWebhookPayloadsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, webhookPayloads_);
        onChanged();
      } else {
        webhookPayloadsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public Builder clearWebhookPayloads() {
      if (webhookPayloadsBuilder_ == null) {
        webhookPayloads_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        webhookPayloadsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public Builder removeWebhookPayloads(int index) {
      if (webhookPayloadsBuilder_ == null) {
        ensureWebhookPayloadsIsMutable();
        webhookPayloads_.remove(index);
        onChanged();
      } else {
        webhookPayloadsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public com.google.protobuf.Struct.Builder getWebhookPayloadsBuilder(int index) {
      return getWebhookPayloadsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public com.google.protobuf.StructOrBuilder getWebhookPayloadsOrBuilder(int index) {
      if (webhookPayloadsBuilder_ == null) {
        return webhookPayloads_.get(index);
      } else {
        return webhookPayloadsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public java.util.List<? extends com.google.protobuf.StructOrBuilder>
        getWebhookPayloadsOrBuilderList() {
      if (webhookPayloadsBuilder_ != null) {
        return webhookPayloadsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(webhookPayloads_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public com.google.protobuf.Struct.Builder addWebhookPayloadsBuilder() {
      return getWebhookPayloadsFieldBuilder()
          .addBuilder(com.google.protobuf.Struct.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public com.google.protobuf.Struct.Builder addWebhookPayloadsBuilder(int index) {
      return getWebhookPayloadsFieldBuilder()
          .addBuilder(index, com.google.protobuf.Struct.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     * </pre>
     *
     * <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    public java.util.List<com.google.protobuf.Struct.Builder> getWebhookPayloadsBuilderList() {
      return getWebhookPayloadsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getWebhookPayloadsFieldBuilder() {
      if (webhookPayloadsBuilder_ == null) {
        webhookPayloadsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                webhookPayloads_,
                ((bitField0_ & 0x00002000) != 0),
                getParentForChildren(),
                isClean());
        webhookPayloads_ = null;
      }
      return webhookPayloadsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.Page currentPage_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Page,
            com.google.cloud.dialogflow.cx.v3.Page.Builder,
            com.google.cloud.dialogflow.cx.v3.PageOrBuilder>
        currentPageBuilder_;
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
     *
     * @return Whether the currentPage field is set.
     */
    public boolean hasCurrentPage() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
     *
     * @return The currentPage.
     */
    public com.google.cloud.dialogflow.cx.v3.Page getCurrentPage() {
      if (currentPageBuilder_ == null) {
        return currentPage_ == null
            ? com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance()
            : currentPage_;
      } else {
        return currentPageBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
     */
    public Builder setCurrentPage(com.google.cloud.dialogflow.cx.v3.Page value) {
      if (currentPageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        currentPage_ = value;
      } else {
        currentPageBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
     */
    public Builder setCurrentPage(com.google.cloud.dialogflow.cx.v3.Page.Builder builderForValue) {
      if (currentPageBuilder_ == null) {
        currentPage_ = builderForValue.build();
      } else {
        currentPageBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
     */
    public Builder mergeCurrentPage(com.google.cloud.dialogflow.cx.v3.Page value) {
      if (currentPageBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && currentPage_ != null
            && currentPage_ != com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance()) {
          getCurrentPageBuilder().mergeFrom(value);
        } else {
          currentPage_ = value;
        }
      } else {
        currentPageBuilder_.mergeFrom(value);
      }
      if (currentPage_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
     */
    public Builder clearCurrentPage() {
      bitField0_ = (bitField0_ & ~0x00004000);
      currentPage_ = null;
      if (currentPageBuilder_ != null) {
        currentPageBuilder_.dispose();
        currentPageBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.Page.Builder getCurrentPageBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getCurrentPageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.PageOrBuilder getCurrentPageOrBuilder() {
      if (currentPageBuilder_ != null) {
        return currentPageBuilder_.getMessageOrBuilder();
      } else {
        return currentPage_ == null
            ? com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance()
            : currentPage_;
      }
    }
    /**
     *
     *
     * <pre>
     * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Page,
            com.google.cloud.dialogflow.cx.v3.Page.Builder,
            com.google.cloud.dialogflow.cx.v3.PageOrBuilder>
        getCurrentPageFieldBuilder() {
      if (currentPageBuilder_ == null) {
        currentPageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Page,
                com.google.cloud.dialogflow.cx.v3.Page.Builder,
                com.google.cloud.dialogflow.cx.v3.PageOrBuilder>(
                getCurrentPage(), getParentForChildren(), isClean());
        currentPage_ = null;
      }
      return currentPageBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.Flow currentFlow_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Flow,
            com.google.cloud.dialogflow.cx.v3.Flow.Builder,
            com.google.cloud.dialogflow.cx.v3.FlowOrBuilder>
        currentFlowBuilder_;
    /**
     *
     *
     * <pre>
     * The current [Flow][google.cloud.dialogflow.cx.v3.Flow]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow current_flow = 31;</code>
     *
     * @return Whether the currentFlow field is set.
     */
    public boolean hasCurrentFlow() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The current [Flow][google.cloud.dialogflow.cx.v3.Flow]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow current_flow = 31;</code>
     *
     * @return The currentFlow.
     */
    public com.google.cloud.dialogflow.cx.v3.Flow getCurrentFlow() {
      if (currentFlowBuilder_ == null) {
        return currentFlow_ == null
            ? com.google.cloud.dialogflow.cx.v3.Flow.getDefaultInstance()
            : currentFlow_;
      } else {
        return currentFlowBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The current [Flow][google.cloud.dialogflow.cx.v3.Flow]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow current_flow = 31;</code>
     */
    public Builder setCurrentFlow(com.google.cloud.dialogflow.cx.v3.Flow value) {
      if (currentFlowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        currentFlow_ = value;
      } else {
        currentFlowBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current [Flow][google.cloud.dialogflow.cx.v3.Flow]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow current_flow = 31;</code>
     */
    public Builder setCurrentFlow(com.google.cloud.dialogflow.cx.v3.Flow.Builder builderForValue) {
      if (currentFlowBuilder_ == null) {
        currentFlow_ = builderForValue.build();
      } else {
        currentFlowBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current [Flow][google.cloud.dialogflow.cx.v3.Flow]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow current_flow = 31;</code>
     */
    public Builder mergeCurrentFlow(com.google.cloud.dialogflow.cx.v3.Flow value) {
      if (currentFlowBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && currentFlow_ != null
            && currentFlow_ != com.google.cloud.dialogflow.cx.v3.Flow.getDefaultInstance()) {
          getCurrentFlowBuilder().mergeFrom(value);
        } else {
          currentFlow_ = value;
        }
      } else {
        currentFlowBuilder_.mergeFrom(value);
      }
      if (currentFlow_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current [Flow][google.cloud.dialogflow.cx.v3.Flow]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow current_flow = 31;</code>
     */
    public Builder clearCurrentFlow() {
      bitField0_ = (bitField0_ & ~0x00008000);
      currentFlow_ = null;
      if (currentFlowBuilder_ != null) {
        currentFlowBuilder_.dispose();
        currentFlowBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current [Flow][google.cloud.dialogflow.cx.v3.Flow]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow current_flow = 31;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.Flow.Builder getCurrentFlowBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getCurrentFlowFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The current [Flow][google.cloud.dialogflow.cx.v3.Flow]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow current_flow = 31;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.FlowOrBuilder getCurrentFlowOrBuilder() {
      if (currentFlowBuilder_ != null) {
        return currentFlowBuilder_.getMessageOrBuilder();
      } else {
        return currentFlow_ == null
            ? com.google.cloud.dialogflow.cx.v3.Flow.getDefaultInstance()
            : currentFlow_;
      }
    }
    /**
     *
     *
     * <pre>
     * The current [Flow][google.cloud.dialogflow.cx.v3.Flow]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Flow current_flow = 31;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Flow,
            com.google.cloud.dialogflow.cx.v3.Flow.Builder,
            com.google.cloud.dialogflow.cx.v3.FlowOrBuilder>
        getCurrentFlowFieldBuilder() {
      if (currentFlowBuilder_ == null) {
        currentFlowBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Flow,
                com.google.cloud.dialogflow.cx.v3.Flow.Builder,
                com.google.cloud.dialogflow.cx.v3.FlowOrBuilder>(
                getCurrentFlow(), getParentForChildren(), isClean());
        currentFlow_ = null;
      }
      return currentFlowBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.Intent intent_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Intent,
            com.google.cloud.dialogflow.cx.v3.Intent.Builder,
            com.google.cloud.dialogflow.cx.v3.IntentOrBuilder>
        intentBuilder_;
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     * conversational query. Some, not all fields are filled in this message,
     * including but not limited to: `name` and `display_name`. This field is
     * deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.QueryResult.intent is deprecated. See
     *     google/cloud/dialogflow/cx/v3/session.proto;l=1049
     * @return Whether the intent field is set.
     */
    @java.lang.Deprecated
    public boolean hasIntent() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     * conversational query. Some, not all fields are filled in this message,
     * including but not limited to: `name` and `display_name`. This field is
     * deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.QueryResult.intent is deprecated. See
     *     google/cloud/dialogflow/cx/v3/session.proto;l=1049
     * @return The intent.
     */
    @java.lang.Deprecated
    public com.google.cloud.dialogflow.cx.v3.Intent getIntent() {
      if (intentBuilder_ == null) {
        return intent_ == null
            ? com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()
            : intent_;
      } else {
        return intentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     * conversational query. Some, not all fields are filled in this message,
     * including but not limited to: `name` and `display_name`. This field is
     * deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setIntent(com.google.cloud.dialogflow.cx.v3.Intent value) {
      if (intentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        intent_ = value;
      } else {
        intentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     * conversational query. Some, not all fields are filled in this message,
     * including but not limited to: `name` and `display_name`. This field is
     * deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setIntent(com.google.cloud.dialogflow.cx.v3.Intent.Builder builderForValue) {
      if (intentBuilder_ == null) {
        intent_ = builderForValue.build();
      } else {
        intentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     * conversational query. Some, not all fields are filled in this message,
     * including but not limited to: `name` and `display_name`. This field is
     * deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder mergeIntent(com.google.cloud.dialogflow.cx.v3.Intent value) {
      if (intentBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && intent_ != null
            && intent_ != com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()) {
          getIntentBuilder().mergeFrom(value);
        } else {
          intent_ = value;
        }
      } else {
        intentBuilder_.mergeFrom(value);
      }
      if (intent_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     * conversational query. Some, not all fields are filled in this message,
     * including but not limited to: `name` and `display_name`. This field is
     * deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearIntent() {
      bitField0_ = (bitField0_ & ~0x00010000);
      intent_ = null;
      if (intentBuilder_ != null) {
        intentBuilder_.dispose();
        intentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     * conversational query. Some, not all fields are filled in this message,
     * including but not limited to: `name` and `display_name`. This field is
     * deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.cloud.dialogflow.cx.v3.Intent.Builder getIntentBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getIntentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     * conversational query. Some, not all fields are filled in this message,
     * including but not limited to: `name` and `display_name`. This field is
     * deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.cloud.dialogflow.cx.v3.IntentOrBuilder getIntentOrBuilder() {
      if (intentBuilder_ != null) {
        return intentBuilder_.getMessageOrBuilder();
      } else {
        return intent_ == null
            ? com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()
            : intent_;
      }
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     * conversational query. Some, not all fields are filled in this message,
     * including but not limited to: `name` and `display_name`. This field is
     * deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Intent,
            com.google.cloud.dialogflow.cx.v3.Intent.Builder,
            com.google.cloud.dialogflow.cx.v3.IntentOrBuilder>
        getIntentFieldBuilder() {
      if (intentBuilder_ == null) {
        intentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Intent,
                com.google.cloud.dialogflow.cx.v3.Intent.Builder,
                com.google.cloud.dialogflow.cx.v3.IntentOrBuilder>(
                getIntent(), getParentForChildren(), isClean());
        intent_ = null;
      }
      return intentBuilder_;
    }

    private float intentDetectionConfidence_;
    /**
     *
     *
     * <pre>
     * The intent detection confidence. Values range from 0.0 (completely
     * uncertain) to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to
     * help match the best intent within the classification threshold.
     * This value may change for the same end-user expression at any time due to a
     * model retraining or change in implementation.
     * This field is deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     * </pre>
     *
     * <code>float intent_detection_confidence = 9 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.QueryResult.intent_detection_confidence is
     *     deprecated. See google/cloud/dialogflow/cx/v3/session.proto;l=1060
     * @return The intentDetectionConfidence.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public float getIntentDetectionConfidence() {
      return intentDetectionConfidence_;
    }
    /**
     *
     *
     * <pre>
     * The intent detection confidence. Values range from 0.0 (completely
     * uncertain) to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to
     * help match the best intent within the classification threshold.
     * This value may change for the same end-user expression at any time due to a
     * model retraining or change in implementation.
     * This field is deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     * </pre>
     *
     * <code>float intent_detection_confidence = 9 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.QueryResult.intent_detection_confidence is
     *     deprecated. See google/cloud/dialogflow/cx/v3/session.proto;l=1060
     * @param value The intentDetectionConfidence to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setIntentDetectionConfidence(float value) {

      intentDetectionConfidence_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent detection confidence. Values range from 0.0 (completely
     * uncertain) to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to
     * help match the best intent within the classification threshold.
     * This value may change for the same end-user expression at any time due to a
     * model retraining or change in implementation.
     * This field is deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     * </pre>
     *
     * <code>float intent_detection_confidence = 9 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.QueryResult.intent_detection_confidence is
     *     deprecated. See google/cloud/dialogflow/cx/v3/session.proto;l=1060
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearIntentDetectionConfidence() {
      bitField0_ = (bitField0_ & ~0x00020000);
      intentDetectionConfidence_ = 0F;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.Match match_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Match,
            com.google.cloud.dialogflow.cx.v3.Match.Builder,
            com.google.cloud.dialogflow.cx.v3.MatchOrBuilder>
        matchBuilder_;
    /**
     *
     *
     * <pre>
     * Intent match result, could be an intent or an event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
     *
     * @return Whether the match field is set.
     */
    public boolean hasMatch() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Intent match result, could be an intent or an event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
     *
     * @return The match.
     */
    public com.google.cloud.dialogflow.cx.v3.Match getMatch() {
      if (matchBuilder_ == null) {
        return match_ == null
            ? com.google.cloud.dialogflow.cx.v3.Match.getDefaultInstance()
            : match_;
      } else {
        return matchBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Intent match result, could be an intent or an event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
     */
    public Builder setMatch(com.google.cloud.dialogflow.cx.v3.Match value) {
      if (matchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        match_ = value;
      } else {
        matchBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Intent match result, could be an intent or an event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
     */
    public Builder setMatch(com.google.cloud.dialogflow.cx.v3.Match.Builder builderForValue) {
      if (matchBuilder_ == null) {
        match_ = builderForValue.build();
      } else {
        matchBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Intent match result, could be an intent or an event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
     */
    public Builder mergeMatch(com.google.cloud.dialogflow.cx.v3.Match value) {
      if (matchBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && match_ != null
            && match_ != com.google.cloud.dialogflow.cx.v3.Match.getDefaultInstance()) {
          getMatchBuilder().mergeFrom(value);
        } else {
          match_ = value;
        }
      } else {
        matchBuilder_.mergeFrom(value);
      }
      if (match_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Intent match result, could be an intent or an event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
     */
    public Builder clearMatch() {
      bitField0_ = (bitField0_ & ~0x00040000);
      match_ = null;
      if (matchBuilder_ != null) {
        matchBuilder_.dispose();
        matchBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Intent match result, could be an intent or an event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.Match.Builder getMatchBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getMatchFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Intent match result, could be an intent or an event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.MatchOrBuilder getMatchOrBuilder() {
      if (matchBuilder_ != null) {
        return matchBuilder_.getMessageOrBuilder();
      } else {
        return match_ == null
            ? com.google.cloud.dialogflow.cx.v3.Match.getDefaultInstance()
            : match_;
      }
    }
    /**
     *
     *
     * <pre>
     * Intent match result, could be an intent or an event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Match,
            com.google.cloud.dialogflow.cx.v3.Match.Builder,
            com.google.cloud.dialogflow.cx.v3.MatchOrBuilder>
        getMatchFieldBuilder() {
      if (matchBuilder_ == null) {
        matchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Match,
                com.google.cloud.dialogflow.cx.v3.Match.Builder,
                com.google.cloud.dialogflow.cx.v3.MatchOrBuilder>(
                getMatch(), getParentForChildren(), isClean());
        match_ = null;
      }
      return matchBuilder_;
    }

    private com.google.protobuf.Struct diagnosticInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        diagnosticInfoBuilder_;
    /**
     *
     *
     * <pre>
     * The free-form diagnostic info. For example, this field could contain
     * webhook call latency. The fields of this data can change without notice,
     * so you should not write code that depends on its structure.
     *
     * One of the fields is called "Alternative Matched Intents", which may
     * aid with debugging. The following describes these intent results:
     *
     * - The list is empty if no intent was matched to end-user input.
     * - Only intents that are referenced in the currently active flow are
     *   included.
     * - The matched intent is included.
     * - Other intents that could have matched end-user input, but did not match
     *   because they are referenced by intent routes that are out of
     *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *   are included.
     * - Other intents referenced by intent routes in scope that matched end-user
     *   input, but had a lower confidence score.
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 10;</code>
     *
     * @return Whether the diagnosticInfo field is set.
     */
    public boolean hasDiagnosticInfo() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The free-form diagnostic info. For example, this field could contain
     * webhook call latency. The fields of this data can change without notice,
     * so you should not write code that depends on its structure.
     *
     * One of the fields is called "Alternative Matched Intents", which may
     * aid with debugging. The following describes these intent results:
     *
     * - The list is empty if no intent was matched to end-user input.
     * - Only intents that are referenced in the currently active flow are
     *   included.
     * - The matched intent is included.
     * - Other intents that could have matched end-user input, but did not match
     *   because they are referenced by intent routes that are out of
     *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *   are included.
     * - Other intents referenced by intent routes in scope that matched end-user
     *   input, but had a lower confidence score.
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 10;</code>
     *
     * @return The diagnosticInfo.
     */
    public com.google.protobuf.Struct getDiagnosticInfo() {
      if (diagnosticInfoBuilder_ == null) {
        return diagnosticInfo_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : diagnosticInfo_;
      } else {
        return diagnosticInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The free-form diagnostic info. For example, this field could contain
     * webhook call latency. The fields of this data can change without notice,
     * so you should not write code that depends on its structure.
     *
     * One of the fields is called "Alternative Matched Intents", which may
     * aid with debugging. The following describes these intent results:
     *
     * - The list is empty if no intent was matched to end-user input.
     * - Only intents that are referenced in the currently active flow are
     *   included.
     * - The matched intent is included.
     * - Other intents that could have matched end-user input, but did not match
     *   because they are referenced by intent routes that are out of
     *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *   are included.
     * - Other intents referenced by intent routes in scope that matched end-user
     *   input, but had a lower confidence score.
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 10;</code>
     */
    public Builder setDiagnosticInfo(com.google.protobuf.Struct value) {
      if (diagnosticInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        diagnosticInfo_ = value;
      } else {
        diagnosticInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The free-form diagnostic info. For example, this field could contain
     * webhook call latency. The fields of this data can change without notice,
     * so you should not write code that depends on its structure.
     *
     * One of the fields is called "Alternative Matched Intents", which may
     * aid with debugging. The following describes these intent results:
     *
     * - The list is empty if no intent was matched to end-user input.
     * - Only intents that are referenced in the currently active flow are
     *   included.
     * - The matched intent is included.
     * - Other intents that could have matched end-user input, but did not match
     *   because they are referenced by intent routes that are out of
     *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *   are included.
     * - Other intents referenced by intent routes in scope that matched end-user
     *   input, but had a lower confidence score.
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 10;</code>
     */
    public Builder setDiagnosticInfo(com.google.protobuf.Struct.Builder builderForValue) {
      if (diagnosticInfoBuilder_ == null) {
        diagnosticInfo_ = builderForValue.build();
      } else {
        diagnosticInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The free-form diagnostic info. For example, this field could contain
     * webhook call latency. The fields of this data can change without notice,
     * so you should not write code that depends on its structure.
     *
     * One of the fields is called "Alternative Matched Intents", which may
     * aid with debugging. The following describes these intent results:
     *
     * - The list is empty if no intent was matched to end-user input.
     * - Only intents that are referenced in the currently active flow are
     *   included.
     * - The matched intent is included.
     * - Other intents that could have matched end-user input, but did not match
     *   because they are referenced by intent routes that are out of
     *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *   are included.
     * - Other intents referenced by intent routes in scope that matched end-user
     *   input, but had a lower confidence score.
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 10;</code>
     */
    public Builder mergeDiagnosticInfo(com.google.protobuf.Struct value) {
      if (diagnosticInfoBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && diagnosticInfo_ != null
            && diagnosticInfo_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getDiagnosticInfoBuilder().mergeFrom(value);
        } else {
          diagnosticInfo_ = value;
        }
      } else {
        diagnosticInfoBuilder_.mergeFrom(value);
      }
      if (diagnosticInfo_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The free-form diagnostic info. For example, this field could contain
     * webhook call latency. The fields of this data can change without notice,
     * so you should not write code that depends on its structure.
     *
     * One of the fields is called "Alternative Matched Intents", which may
     * aid with debugging. The following describes these intent results:
     *
     * - The list is empty if no intent was matched to end-user input.
     * - Only intents that are referenced in the currently active flow are
     *   included.
     * - The matched intent is included.
     * - Other intents that could have matched end-user input, but did not match
     *   because they are referenced by intent routes that are out of
     *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *   are included.
     * - Other intents referenced by intent routes in scope that matched end-user
     *   input, but had a lower confidence score.
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 10;</code>
     */
    public Builder clearDiagnosticInfo() {
      bitField0_ = (bitField0_ & ~0x00080000);
      diagnosticInfo_ = null;
      if (diagnosticInfoBuilder_ != null) {
        diagnosticInfoBuilder_.dispose();
        diagnosticInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The free-form diagnostic info. For example, this field could contain
     * webhook call latency. The fields of this data can change without notice,
     * so you should not write code that depends on its structure.
     *
     * One of the fields is called "Alternative Matched Intents", which may
     * aid with debugging. The following describes these intent results:
     *
     * - The list is empty if no intent was matched to end-user input.
     * - Only intents that are referenced in the currently active flow are
     *   included.
     * - The matched intent is included.
     * - Other intents that could have matched end-user input, but did not match
     *   because they are referenced by intent routes that are out of
     *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *   are included.
     * - Other intents referenced by intent routes in scope that matched end-user
     *   input, but had a lower confidence score.
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 10;</code>
     */
    public com.google.protobuf.Struct.Builder getDiagnosticInfoBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getDiagnosticInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The free-form diagnostic info. For example, this field could contain
     * webhook call latency. The fields of this data can change without notice,
     * so you should not write code that depends on its structure.
     *
     * One of the fields is called "Alternative Matched Intents", which may
     * aid with debugging. The following describes these intent results:
     *
     * - The list is empty if no intent was matched to end-user input.
     * - Only intents that are referenced in the currently active flow are
     *   included.
     * - The matched intent is included.
     * - Other intents that could have matched end-user input, but did not match
     *   because they are referenced by intent routes that are out of
     *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *   are included.
     * - Other intents referenced by intent routes in scope that matched end-user
     *   input, but had a lower confidence score.
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 10;</code>
     */
    public com.google.protobuf.StructOrBuilder getDiagnosticInfoOrBuilder() {
      if (diagnosticInfoBuilder_ != null) {
        return diagnosticInfoBuilder_.getMessageOrBuilder();
      } else {
        return diagnosticInfo_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : diagnosticInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * The free-form diagnostic info. For example, this field could contain
     * webhook call latency. The fields of this data can change without notice,
     * so you should not write code that depends on its structure.
     *
     * One of the fields is called "Alternative Matched Intents", which may
     * aid with debugging. The following describes these intent results:
     *
     * - The list is empty if no intent was matched to end-user input.
     * - Only intents that are referenced in the currently active flow are
     *   included.
     * - The matched intent is included.
     * - Other intents that could have matched end-user input, but did not match
     *   because they are referenced by intent routes that are out of
     *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *   are included.
     * - Other intents referenced by intent routes in scope that matched end-user
     *   input, but had a lower confidence score.
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getDiagnosticInfoFieldBuilder() {
      if (diagnosticInfoBuilder_ == null) {
        diagnosticInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getDiagnosticInfo(), getParentForChildren(), isClean());
        diagnosticInfo_ = null;
      }
      return diagnosticInfoBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentimentAnalysisResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult,
            com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult.Builder,
            com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResultOrBuilder>
        sentimentAnalysisResultBuilder_;
    /**
     *
     *
     * <pre>
     * The sentiment analyss result, which depends on
     * [`analyze_query_text_sentiment`]
     * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     * specified in the request.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     *
     * @return Whether the sentimentAnalysisResult field is set.
     */
    public boolean hasSentimentAnalysisResult() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The sentiment analyss result, which depends on
     * [`analyze_query_text_sentiment`]
     * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     * specified in the request.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     *
     * @return The sentimentAnalysisResult.
     */
    public com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult getSentimentAnalysisResult() {
      if (sentimentAnalysisResultBuilder_ == null) {
        return sentimentAnalysisResult_ == null
            ? com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult.getDefaultInstance()
            : sentimentAnalysisResult_;
      } else {
        return sentimentAnalysisResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The sentiment analyss result, which depends on
     * [`analyze_query_text_sentiment`]
     * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     * specified in the request.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    public Builder setSentimentAnalysisResult(
        com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult value) {
      if (sentimentAnalysisResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sentimentAnalysisResult_ = value;
      } else {
        sentimentAnalysisResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analyss result, which depends on
     * [`analyze_query_text_sentiment`]
     * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     * specified in the request.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    public Builder setSentimentAnalysisResult(
        com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult.Builder builderForValue) {
      if (sentimentAnalysisResultBuilder_ == null) {
        sentimentAnalysisResult_ = builderForValue.build();
      } else {
        sentimentAnalysisResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analyss result, which depends on
     * [`analyze_query_text_sentiment`]
     * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     * specified in the request.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    public Builder mergeSentimentAnalysisResult(
        com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult value) {
      if (sentimentAnalysisResultBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && sentimentAnalysisResult_ != null
            && sentimentAnalysisResult_
                != com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult.getDefaultInstance()) {
          getSentimentAnalysisResultBuilder().mergeFrom(value);
        } else {
          sentimentAnalysisResult_ = value;
        }
      } else {
        sentimentAnalysisResultBuilder_.mergeFrom(value);
      }
      if (sentimentAnalysisResult_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analyss result, which depends on
     * [`analyze_query_text_sentiment`]
     * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     * specified in the request.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    public Builder clearSentimentAnalysisResult() {
      bitField0_ = (bitField0_ & ~0x00100000);
      sentimentAnalysisResult_ = null;
      if (sentimentAnalysisResultBuilder_ != null) {
        sentimentAnalysisResultBuilder_.dispose();
        sentimentAnalysisResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analyss result, which depends on
     * [`analyze_query_text_sentiment`]
     * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     * specified in the request.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult.Builder
        getSentimentAnalysisResultBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getSentimentAnalysisResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The sentiment analyss result, which depends on
     * [`analyze_query_text_sentiment`]
     * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     * specified in the request.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResultOrBuilder
        getSentimentAnalysisResultOrBuilder() {
      if (sentimentAnalysisResultBuilder_ != null) {
        return sentimentAnalysisResultBuilder_.getMessageOrBuilder();
      } else {
        return sentimentAnalysisResult_ == null
            ? com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult.getDefaultInstance()
            : sentimentAnalysisResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * The sentiment analyss result, which depends on
     * [`analyze_query_text_sentiment`]
     * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     * specified in the request.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult,
            com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult.Builder,
            com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResultOrBuilder>
        getSentimentAnalysisResultFieldBuilder() {
      if (sentimentAnalysisResultBuilder_ == null) {
        sentimentAnalysisResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult,
                com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult.Builder,
                com.google.cloud.dialogflow.cx.v3.SentimentAnalysisResultOrBuilder>(
                getSentimentAnalysisResult(), getParentForChildren(), isClean());
        sentimentAnalysisResult_ = null;
      }
      return sentimentAnalysisResultBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.AdvancedSettings advancedSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder>
        advancedSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Returns the current advanced settings including IVR settings. Even though
     * the operations configured by these settings are performed by Dialogflow,
     * the client may need to perform special logic at the moment. For example, if
     * Dialogflow exports audio to Google Cloud Storage, then the client may need
     * to wait for the resulting object to appear in the bucket before proceeding.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
     *
     * @return Whether the advancedSettings field is set.
     */
    public boolean hasAdvancedSettings() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Returns the current advanced settings including IVR settings. Even though
     * the operations configured by these settings are performed by Dialogflow,
     * the client may need to perform special logic at the moment. For example, if
     * Dialogflow exports audio to Google Cloud Storage, then the client may need
     * to wait for the resulting object to appear in the bucket before proceeding.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
     *
     * @return The advancedSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings getAdvancedSettings() {
      if (advancedSettingsBuilder_ == null) {
        return advancedSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()
            : advancedSettings_;
      } else {
        return advancedSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Returns the current advanced settings including IVR settings. Even though
     * the operations configured by these settings are performed by Dialogflow,
     * the client may need to perform special logic at the moment. For example, if
     * Dialogflow exports audio to Google Cloud Storage, then the client may need
     * to wait for the resulting object to appear in the bucket before proceeding.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
     */
    public Builder setAdvancedSettings(com.google.cloud.dialogflow.cx.v3.AdvancedSettings value) {
      if (advancedSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        advancedSettings_ = value;
      } else {
        advancedSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Returns the current advanced settings including IVR settings. Even though
     * the operations configured by these settings are performed by Dialogflow,
     * the client may need to perform special logic at the moment. For example, if
     * Dialogflow exports audio to Google Cloud Storage, then the client may need
     * to wait for the resulting object to appear in the bucket before proceeding.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
     */
    public Builder setAdvancedSettings(
        com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder builderForValue) {
      if (advancedSettingsBuilder_ == null) {
        advancedSettings_ = builderForValue.build();
      } else {
        advancedSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Returns the current advanced settings including IVR settings. Even though
     * the operations configured by these settings are performed by Dialogflow,
     * the client may need to perform special logic at the moment. For example, if
     * Dialogflow exports audio to Google Cloud Storage, then the client may need
     * to wait for the resulting object to appear in the bucket before proceeding.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
     */
    public Builder mergeAdvancedSettings(com.google.cloud.dialogflow.cx.v3.AdvancedSettings value) {
      if (advancedSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && advancedSettings_ != null
            && advancedSettings_
                != com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()) {
          getAdvancedSettingsBuilder().mergeFrom(value);
        } else {
          advancedSettings_ = value;
        }
      } else {
        advancedSettingsBuilder_.mergeFrom(value);
      }
      if (advancedSettings_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Returns the current advanced settings including IVR settings. Even though
     * the operations configured by these settings are performed by Dialogflow,
     * the client may need to perform special logic at the moment. For example, if
     * Dialogflow exports audio to Google Cloud Storage, then the client may need
     * to wait for the resulting object to appear in the bucket before proceeding.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
     */
    public Builder clearAdvancedSettings() {
      bitField0_ = (bitField0_ & ~0x00200000);
      advancedSettings_ = null;
      if (advancedSettingsBuilder_ != null) {
        advancedSettingsBuilder_.dispose();
        advancedSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Returns the current advanced settings including IVR settings. Even though
     * the operations configured by these settings are performed by Dialogflow,
     * the client may need to perform special logic at the moment. For example, if
     * Dialogflow exports audio to Google Cloud Storage, then the client may need
     * to wait for the resulting object to appear in the bucket before proceeding.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder getAdvancedSettingsBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getAdvancedSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Returns the current advanced settings including IVR settings. Even though
     * the operations configured by these settings are performed by Dialogflow,
     * the client may need to perform special logic at the moment. For example, if
     * Dialogflow exports audio to Google Cloud Storage, then the client may need
     * to wait for the resulting object to appear in the bucket before proceeding.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder
        getAdvancedSettingsOrBuilder() {
      if (advancedSettingsBuilder_ != null) {
        return advancedSettingsBuilder_.getMessageOrBuilder();
      } else {
        return advancedSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()
            : advancedSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Returns the current advanced settings including IVR settings. Even though
     * the operations configured by these settings are performed by Dialogflow,
     * the client may need to perform special logic at the moment. For example, if
     * Dialogflow exports audio to Google Cloud Storage, then the client may need
     * to wait for the resulting object to appear in the bucket before proceeding.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder>
        getAdvancedSettingsFieldBuilder() {
      if (advancedSettingsBuilder_ == null) {
        advancedSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.AdvancedSettings,
                com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder>(
                getAdvancedSettings(), getParentForChildren(), isClean());
        advancedSettings_ = null;
      }
      return advancedSettingsBuilder_;
    }

    private boolean allowAnswerFeedback_;
    /**
     *
     *
     * <pre>
     * Indicates whether the Thumbs up/Thumbs down rating controls are need to be
     * shown for the response in the Dialogflow Messenger widget.
     * </pre>
     *
     * <code>bool allow_answer_feedback = 32;</code>
     *
     * @return The allowAnswerFeedback.
     */
    @java.lang.Override
    public boolean getAllowAnswerFeedback() {
      return allowAnswerFeedback_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the Thumbs up/Thumbs down rating controls are need to be
     * shown for the response in the Dialogflow Messenger widget.
     * </pre>
     *
     * <code>bool allow_answer_feedback = 32;</code>
     *
     * @param value The allowAnswerFeedback to set.
     * @return This builder for chaining.
     */
    public Builder setAllowAnswerFeedback(boolean value) {

      allowAnswerFeedback_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the Thumbs up/Thumbs down rating controls are need to be
     * shown for the response in the Dialogflow Messenger widget.
     * </pre>
     *
     * <code>bool allow_answer_feedback = 32;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowAnswerFeedback() {
      bitField0_ = (bitField0_ & ~0x00400000);
      allowAnswerFeedback_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
        dataStoreConnectionSignals_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignalsOrBuilder>
        dataStoreConnectionSignalsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Data store connection feature output signals.
     * Filled only when data stores are involved in serving the query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals data_store_connection_signals = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the dataStoreConnectionSignals field is set.
     */
    public boolean hasDataStoreConnectionSignals() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Data store connection feature output signals.
     * Filled only when data stores are involved in serving the query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals data_store_connection_signals = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dataStoreConnectionSignals.
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
        getDataStoreConnectionSignals() {
      if (dataStoreConnectionSignalsBuilder_ == null) {
        return dataStoreConnectionSignals_ == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.getDefaultInstance()
            : dataStoreConnectionSignals_;
      } else {
        return dataStoreConnectionSignalsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Data store connection feature output signals.
     * Filled only when data stores are involved in serving the query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals data_store_connection_signals = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDataStoreConnectionSignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals value) {
      if (dataStoreConnectionSignalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStoreConnectionSignals_ = value;
      } else {
        dataStoreConnectionSignalsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data store connection feature output signals.
     * Filled only when data stores are involved in serving the query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals data_store_connection_signals = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDataStoreConnectionSignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.Builder builderForValue) {
      if (dataStoreConnectionSignalsBuilder_ == null) {
        dataStoreConnectionSignals_ = builderForValue.build();
      } else {
        dataStoreConnectionSignalsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data store connection feature output signals.
     * Filled only when data stores are involved in serving the query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals data_store_connection_signals = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDataStoreConnectionSignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals value) {
      if (dataStoreConnectionSignalsBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && dataStoreConnectionSignals_ != null
            && dataStoreConnectionSignals_
                != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .getDefaultInstance()) {
          getDataStoreConnectionSignalsBuilder().mergeFrom(value);
        } else {
          dataStoreConnectionSignals_ = value;
        }
      } else {
        dataStoreConnectionSignalsBuilder_.mergeFrom(value);
      }
      if (dataStoreConnectionSignals_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data store connection feature output signals.
     * Filled only when data stores are involved in serving the query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals data_store_connection_signals = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDataStoreConnectionSignals() {
      bitField0_ = (bitField0_ & ~0x00800000);
      dataStoreConnectionSignals_ = null;
      if (dataStoreConnectionSignalsBuilder_ != null) {
        dataStoreConnectionSignalsBuilder_.dispose();
        dataStoreConnectionSignalsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Data store connection feature output signals.
     * Filled only when data stores are involved in serving the query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals data_store_connection_signals = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.Builder
        getDataStoreConnectionSignalsBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getDataStoreConnectionSignalsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Data store connection feature output signals.
     * Filled only when data stores are involved in serving the query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals data_store_connection_signals = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignalsOrBuilder
        getDataStoreConnectionSignalsOrBuilder() {
      if (dataStoreConnectionSignalsBuilder_ != null) {
        return dataStoreConnectionSignalsBuilder_.getMessageOrBuilder();
      } else {
        return dataStoreConnectionSignals_ == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.getDefaultInstance()
            : dataStoreConnectionSignals_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Data store connection feature output signals.
     * Filled only when data stores are involved in serving the query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals data_store_connection_signals = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignalsOrBuilder>
        getDataStoreConnectionSignalsFieldBuilder() {
      if (dataStoreConnectionSignalsBuilder_ == null) {
        dataStoreConnectionSignalsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.Builder,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignalsOrBuilder>(
                getDataStoreConnectionSignals(), getParentForChildren(), isClean());
        dataStoreConnectionSignals_ = null;
      }
      return dataStoreConnectionSignalsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.QueryResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.QueryResult)
  private static final com.google.cloud.dialogflow.cx.v3.QueryResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.QueryResult();
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryResult> PARSER =
      new com.google.protobuf.AbstractParser<QueryResult>() {
        @java.lang.Override
        public QueryResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QueryResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
