/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/session.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Represents the query input. It can contain one of:
 *
 * 1. A conversational query in the form of text.
 *
 * 2. An intent query that specifies which intent to trigger.
 *
 * 3. Natural language speech audio to be processed.
 *
 * 4. An event to be triggered.
 *
 * 5. DTMF digits to invoke an intent and fill in parameter value.
 *
 * 6. The results of a tool executed by the client.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.QueryInput}
 */
public final class QueryInput extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.QueryInput)
    QueryInputOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryInput.newBuilder() to construct.
  private QueryInput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryInput() {
    languageCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryInput();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_QueryInput_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_QueryInput_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.QueryInput.class,
            com.google.cloud.dialogflow.cx.v3.QueryInput.Builder.class);
  }

  private int inputCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object input_;

  public enum InputCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT(2),
    INTENT(3),
    AUDIO(5),
    EVENT(6),
    DTMF(7),
    INPUT_NOT_SET(0);
    private final int value;

    private InputCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InputCase valueOf(int value) {
      return forNumber(value);
    }

    public static InputCase forNumber(int value) {
      switch (value) {
        case 2:
          return TEXT;
        case 3:
          return INTENT;
        case 5:
          return AUDIO;
        case 6:
          return EVENT;
        case 7:
          return DTMF;
        case 0:
          return INPUT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public InputCase getInputCase() {
    return InputCase.forNumber(inputCase_);
  }

  public static final int TEXT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.TextInput text = 2;</code>
   *
   * @return Whether the text field is set.
   */
  @java.lang.Override
  public boolean hasText() {
    return inputCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.TextInput text = 2;</code>
   *
   * @return The text.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TextInput getText() {
    if (inputCase_ == 2) {
      return (com.google.cloud.dialogflow.cx.v3.TextInput) input_;
    }
    return com.google.cloud.dialogflow.cx.v3.TextInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.TextInput text = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TextInputOrBuilder getTextOrBuilder() {
    if (inputCase_ == 2) {
      return (com.google.cloud.dialogflow.cx.v3.TextInput) input_;
    }
    return com.google.cloud.dialogflow.cx.v3.TextInput.getDefaultInstance();
  }

  public static final int INTENT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The intent to be triggered.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.IntentInput intent = 3;</code>
   *
   * @return Whether the intent field is set.
   */
  @java.lang.Override
  public boolean hasIntent() {
    return inputCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The intent to be triggered.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.IntentInput intent = 3;</code>
   *
   * @return The intent.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.IntentInput getIntent() {
    if (inputCase_ == 3) {
      return (com.google.cloud.dialogflow.cx.v3.IntentInput) input_;
    }
    return com.google.cloud.dialogflow.cx.v3.IntentInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The intent to be triggered.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.IntentInput intent = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.IntentInputOrBuilder getIntentOrBuilder() {
    if (inputCase_ == 3) {
      return (com.google.cloud.dialogflow.cx.v3.IntentInput) input_;
    }
    return com.google.cloud.dialogflow.cx.v3.IntentInput.getDefaultInstance();
  }

  public static final int AUDIO_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The natural language speech audio to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AudioInput audio = 5;</code>
   *
   * @return Whether the audio field is set.
   */
  @java.lang.Override
  public boolean hasAudio() {
    return inputCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The natural language speech audio to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AudioInput audio = 5;</code>
   *
   * @return The audio.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.AudioInput getAudio() {
    if (inputCase_ == 5) {
      return (com.google.cloud.dialogflow.cx.v3.AudioInput) input_;
    }
    return com.google.cloud.dialogflow.cx.v3.AudioInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The natural language speech audio to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AudioInput audio = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.AudioInputOrBuilder getAudioOrBuilder() {
    if (inputCase_ == 5) {
      return (com.google.cloud.dialogflow.cx.v3.AudioInput) input_;
    }
    return com.google.cloud.dialogflow.cx.v3.AudioInput.getDefaultInstance();
  }

  public static final int EVENT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The event to be triggered.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.EventInput event = 6;</code>
   *
   * @return Whether the event field is set.
   */
  @java.lang.Override
  public boolean hasEvent() {
    return inputCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The event to be triggered.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.EventInput event = 6;</code>
   *
   * @return The event.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.EventInput getEvent() {
    if (inputCase_ == 6) {
      return (com.google.cloud.dialogflow.cx.v3.EventInput) input_;
    }
    return com.google.cloud.dialogflow.cx.v3.EventInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The event to be triggered.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.EventInput event = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.EventInputOrBuilder getEventOrBuilder() {
    if (inputCase_ == 6) {
      return (com.google.cloud.dialogflow.cx.v3.EventInput) input_;
    }
    return com.google.cloud.dialogflow.cx.v3.EventInput.getDefaultInstance();
  }

  public static final int DTMF_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The DTMF event to be handled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 7;</code>
   *
   * @return Whether the dtmf field is set.
   */
  @java.lang.Override
  public boolean hasDtmf() {
    return inputCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The DTMF event to be handled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 7;</code>
   *
   * @return The dtmf.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DtmfInput getDtmf() {
    if (inputCase_ == 7) {
      return (com.google.cloud.dialogflow.cx.v3.DtmfInput) input_;
    }
    return com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The DTMF event to be handled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DtmfInputOrBuilder getDtmfOrBuilder() {
    if (inputCase_ == 7) {
      return (com.google.cloud.dialogflow.cx.v3.DtmfInput) input_;
    }
    return com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance();
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Required. The language of the input. See [Language
   * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
   * for a list of the currently supported language codes. Note that queries in
   * the same session do not necessarily need to specify the same language.
   * </pre>
   *
   * <code>string language_code = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The language of the input. See [Language
   * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
   * for a list of the currently supported language codes. Note that queries in
   * the same session do not necessarily need to specify the same language.
   * </pre>
   *
   * <code>string language_code = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (inputCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.dialogflow.cx.v3.TextInput) input_);
    }
    if (inputCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.dialogflow.cx.v3.IntentInput) input_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, languageCode_);
    }
    if (inputCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.dialogflow.cx.v3.AudioInput) input_);
    }
    if (inputCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.dialogflow.cx.v3.EventInput) input_);
    }
    if (inputCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.dialogflow.cx.v3.DtmfInput) input_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (inputCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dialogflow.cx.v3.TextInput) input_);
    }
    if (inputCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dialogflow.cx.v3.IntentInput) input_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, languageCode_);
    }
    if (inputCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.dialogflow.cx.v3.AudioInput) input_);
    }
    if (inputCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.dialogflow.cx.v3.EventInput) input_);
    }
    if (inputCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.dialogflow.cx.v3.DtmfInput) input_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.QueryInput)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.QueryInput other =
        (com.google.cloud.dialogflow.cx.v3.QueryInput) obj;

    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getInputCase().equals(other.getInputCase())) return false;
    switch (inputCase_) {
      case 2:
        if (!getText().equals(other.getText())) return false;
        break;
      case 3:
        if (!getIntent().equals(other.getIntent())) return false;
        break;
      case 5:
        if (!getAudio().equals(other.getAudio())) return false;
        break;
      case 6:
        if (!getEvent().equals(other.getEvent())) return false;
        break;
      case 7:
        if (!getDtmf().equals(other.getDtmf())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    switch (inputCase_) {
      case 2:
        hash = (37 * hash) + TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getText().hashCode();
        break;
      case 3:
        hash = (37 * hash) + INTENT_FIELD_NUMBER;
        hash = (53 * hash) + getIntent().hashCode();
        break;
      case 5:
        hash = (37 * hash) + AUDIO_FIELD_NUMBER;
        hash = (53 * hash) + getAudio().hashCode();
        break;
      case 6:
        hash = (37 * hash) + EVENT_FIELD_NUMBER;
        hash = (53 * hash) + getEvent().hashCode();
        break;
      case 7:
        hash = (37 * hash) + DTMF_FIELD_NUMBER;
        hash = (53 * hash) + getDtmf().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.QueryInput prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the query input. It can contain one of:
   *
   * 1. A conversational query in the form of text.
   *
   * 2. An intent query that specifies which intent to trigger.
   *
   * 3. Natural language speech audio to be processed.
   *
   * 4. An event to be triggered.
   *
   * 5. DTMF digits to invoke an intent and fill in parameter value.
   *
   * 6. The results of a tool executed by the client.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.QueryInput}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.QueryInput)
      com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_QueryInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_QueryInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.QueryInput.class,
              com.google.cloud.dialogflow.cx.v3.QueryInput.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.QueryInput.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (textBuilder_ != null) {
        textBuilder_.clear();
      }
      if (intentBuilder_ != null) {
        intentBuilder_.clear();
      }
      if (audioBuilder_ != null) {
        audioBuilder_.clear();
      }
      if (eventBuilder_ != null) {
        eventBuilder_.clear();
      }
      if (dtmfBuilder_ != null) {
        dtmfBuilder_.clear();
      }
      languageCode_ = "";
      inputCase_ = 0;
      input_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_QueryInput_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.QueryInput getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.QueryInput build() {
      com.google.cloud.dialogflow.cx.v3.QueryInput result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.QueryInput buildPartial() {
      com.google.cloud.dialogflow.cx.v3.QueryInput result =
          new com.google.cloud.dialogflow.cx.v3.QueryInput(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.QueryInput result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.languageCode_ = languageCode_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.cx.v3.QueryInput result) {
      result.inputCase_ = inputCase_;
      result.input_ = this.input_;
      if (inputCase_ == 2 && textBuilder_ != null) {
        result.input_ = textBuilder_.build();
      }
      if (inputCase_ == 3 && intentBuilder_ != null) {
        result.input_ = intentBuilder_.build();
      }
      if (inputCase_ == 5 && audioBuilder_ != null) {
        result.input_ = audioBuilder_.build();
      }
      if (inputCase_ == 6 && eventBuilder_ != null) {
        result.input_ = eventBuilder_.build();
      }
      if (inputCase_ == 7 && dtmfBuilder_ != null) {
        result.input_ = dtmfBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.QueryInput) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.QueryInput) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.QueryInput other) {
      if (other == com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()) return this;
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      switch (other.getInputCase()) {
        case TEXT:
          {
            mergeText(other.getText());
            break;
          }
        case INTENT:
          {
            mergeIntent(other.getIntent());
            break;
          }
        case AUDIO:
          {
            mergeAudio(other.getAudio());
            break;
          }
        case EVENT:
          {
            mergeEvent(other.getEvent());
            break;
          }
        case DTMF:
          {
            mergeDtmf(other.getDtmf());
            break;
          }
        case INPUT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getTextFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getIntentFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getAudioFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getEventFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getDtmfFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int inputCase_ = 0;
    private java.lang.Object input_;

    public InputCase getInputCase() {
      return InputCase.forNumber(inputCase_);
    }

    public Builder clearInput() {
      inputCase_ = 0;
      input_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.TextInput,
            com.google.cloud.dialogflow.cx.v3.TextInput.Builder,
            com.google.cloud.dialogflow.cx.v3.TextInputOrBuilder>
        textBuilder_;
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextInput text = 2;</code>
     *
     * @return Whether the text field is set.
     */
    @java.lang.Override
    public boolean hasText() {
      return inputCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextInput text = 2;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TextInput getText() {
      if (textBuilder_ == null) {
        if (inputCase_ == 2) {
          return (com.google.cloud.dialogflow.cx.v3.TextInput) input_;
        }
        return com.google.cloud.dialogflow.cx.v3.TextInput.getDefaultInstance();
      } else {
        if (inputCase_ == 2) {
          return textBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3.TextInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextInput text = 2;</code>
     */
    public Builder setText(com.google.cloud.dialogflow.cx.v3.TextInput value) {
      if (textBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        textBuilder_.setMessage(value);
      }
      inputCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextInput text = 2;</code>
     */
    public Builder setText(com.google.cloud.dialogflow.cx.v3.TextInput.Builder builderForValue) {
      if (textBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        textBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextInput text = 2;</code>
     */
    public Builder mergeText(com.google.cloud.dialogflow.cx.v3.TextInput value) {
      if (textBuilder_ == null) {
        if (inputCase_ == 2
            && input_ != com.google.cloud.dialogflow.cx.v3.TextInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.cx.v3.TextInput.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3.TextInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 2) {
          textBuilder_.mergeFrom(value);
        } else {
          textBuilder_.setMessage(value);
        }
      }
      inputCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextInput text = 2;</code>
     */
    public Builder clearText() {
      if (textBuilder_ == null) {
        if (inputCase_ == 2) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 2) {
          inputCase_ = 0;
          input_ = null;
        }
        textBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextInput text = 2;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.TextInput.Builder getTextBuilder() {
      return getTextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextInput text = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TextInputOrBuilder getTextOrBuilder() {
      if ((inputCase_ == 2) && (textBuilder_ != null)) {
        return textBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 2) {
          return (com.google.cloud.dialogflow.cx.v3.TextInput) input_;
        }
        return com.google.cloud.dialogflow.cx.v3.TextInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextInput text = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.TextInput,
            com.google.cloud.dialogflow.cx.v3.TextInput.Builder,
            com.google.cloud.dialogflow.cx.v3.TextInputOrBuilder>
        getTextFieldBuilder() {
      if (textBuilder_ == null) {
        if (!(inputCase_ == 2)) {
          input_ = com.google.cloud.dialogflow.cx.v3.TextInput.getDefaultInstance();
        }
        textBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.TextInput,
                com.google.cloud.dialogflow.cx.v3.TextInput.Builder,
                com.google.cloud.dialogflow.cx.v3.TextInputOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3.TextInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 2;
      onChanged();
      return textBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.IntentInput,
            com.google.cloud.dialogflow.cx.v3.IntentInput.Builder,
            com.google.cloud.dialogflow.cx.v3.IntentInputOrBuilder>
        intentBuilder_;
    /**
     *
     *
     * <pre>
     * The intent to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.IntentInput intent = 3;</code>
     *
     * @return Whether the intent field is set.
     */
    @java.lang.Override
    public boolean hasIntent() {
      return inputCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.IntentInput intent = 3;</code>
     *
     * @return The intent.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.IntentInput getIntent() {
      if (intentBuilder_ == null) {
        if (inputCase_ == 3) {
          return (com.google.cloud.dialogflow.cx.v3.IntentInput) input_;
        }
        return com.google.cloud.dialogflow.cx.v3.IntentInput.getDefaultInstance();
      } else {
        if (inputCase_ == 3) {
          return intentBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3.IntentInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.IntentInput intent = 3;</code>
     */
    public Builder setIntent(com.google.cloud.dialogflow.cx.v3.IntentInput value) {
      if (intentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        intentBuilder_.setMessage(value);
      }
      inputCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.IntentInput intent = 3;</code>
     */
    public Builder setIntent(
        com.google.cloud.dialogflow.cx.v3.IntentInput.Builder builderForValue) {
      if (intentBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        intentBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.IntentInput intent = 3;</code>
     */
    public Builder mergeIntent(com.google.cloud.dialogflow.cx.v3.IntentInput value) {
      if (intentBuilder_ == null) {
        if (inputCase_ == 3
            && input_ != com.google.cloud.dialogflow.cx.v3.IntentInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.cx.v3.IntentInput.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3.IntentInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 3) {
          intentBuilder_.mergeFrom(value);
        } else {
          intentBuilder_.setMessage(value);
        }
      }
      inputCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.IntentInput intent = 3;</code>
     */
    public Builder clearIntent() {
      if (intentBuilder_ == null) {
        if (inputCase_ == 3) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 3) {
          inputCase_ = 0;
          input_ = null;
        }
        intentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.IntentInput intent = 3;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.IntentInput.Builder getIntentBuilder() {
      return getIntentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.IntentInput intent = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.IntentInputOrBuilder getIntentOrBuilder() {
      if ((inputCase_ == 3) && (intentBuilder_ != null)) {
        return intentBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 3) {
          return (com.google.cloud.dialogflow.cx.v3.IntentInput) input_;
        }
        return com.google.cloud.dialogflow.cx.v3.IntentInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.IntentInput intent = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.IntentInput,
            com.google.cloud.dialogflow.cx.v3.IntentInput.Builder,
            com.google.cloud.dialogflow.cx.v3.IntentInputOrBuilder>
        getIntentFieldBuilder() {
      if (intentBuilder_ == null) {
        if (!(inputCase_ == 3)) {
          input_ = com.google.cloud.dialogflow.cx.v3.IntentInput.getDefaultInstance();
        }
        intentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.IntentInput,
                com.google.cloud.dialogflow.cx.v3.IntentInput.Builder,
                com.google.cloud.dialogflow.cx.v3.IntentInputOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3.IntentInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 3;
      onChanged();
      return intentBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.AudioInput,
            com.google.cloud.dialogflow.cx.v3.AudioInput.Builder,
            com.google.cloud.dialogflow.cx.v3.AudioInputOrBuilder>
        audioBuilder_;
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AudioInput audio = 5;</code>
     *
     * @return Whether the audio field is set.
     */
    @java.lang.Override
    public boolean hasAudio() {
      return inputCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AudioInput audio = 5;</code>
     *
     * @return The audio.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.AudioInput getAudio() {
      if (audioBuilder_ == null) {
        if (inputCase_ == 5) {
          return (com.google.cloud.dialogflow.cx.v3.AudioInput) input_;
        }
        return com.google.cloud.dialogflow.cx.v3.AudioInput.getDefaultInstance();
      } else {
        if (inputCase_ == 5) {
          return audioBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3.AudioInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AudioInput audio = 5;</code>
     */
    public Builder setAudio(com.google.cloud.dialogflow.cx.v3.AudioInput value) {
      if (audioBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        audioBuilder_.setMessage(value);
      }
      inputCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AudioInput audio = 5;</code>
     */
    public Builder setAudio(com.google.cloud.dialogflow.cx.v3.AudioInput.Builder builderForValue) {
      if (audioBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        audioBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AudioInput audio = 5;</code>
     */
    public Builder mergeAudio(com.google.cloud.dialogflow.cx.v3.AudioInput value) {
      if (audioBuilder_ == null) {
        if (inputCase_ == 5
            && input_ != com.google.cloud.dialogflow.cx.v3.AudioInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.cx.v3.AudioInput.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3.AudioInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 5) {
          audioBuilder_.mergeFrom(value);
        } else {
          audioBuilder_.setMessage(value);
        }
      }
      inputCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AudioInput audio = 5;</code>
     */
    public Builder clearAudio() {
      if (audioBuilder_ == null) {
        if (inputCase_ == 5) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 5) {
          inputCase_ = 0;
          input_ = null;
        }
        audioBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AudioInput audio = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.AudioInput.Builder getAudioBuilder() {
      return getAudioFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AudioInput audio = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.AudioInputOrBuilder getAudioOrBuilder() {
      if ((inputCase_ == 5) && (audioBuilder_ != null)) {
        return audioBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 5) {
          return (com.google.cloud.dialogflow.cx.v3.AudioInput) input_;
        }
        return com.google.cloud.dialogflow.cx.v3.AudioInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AudioInput audio = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.AudioInput,
            com.google.cloud.dialogflow.cx.v3.AudioInput.Builder,
            com.google.cloud.dialogflow.cx.v3.AudioInputOrBuilder>
        getAudioFieldBuilder() {
      if (audioBuilder_ == null) {
        if (!(inputCase_ == 5)) {
          input_ = com.google.cloud.dialogflow.cx.v3.AudioInput.getDefaultInstance();
        }
        audioBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.AudioInput,
                com.google.cloud.dialogflow.cx.v3.AudioInput.Builder,
                com.google.cloud.dialogflow.cx.v3.AudioInputOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3.AudioInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 5;
      onChanged();
      return audioBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.EventInput,
            com.google.cloud.dialogflow.cx.v3.EventInput.Builder,
            com.google.cloud.dialogflow.cx.v3.EventInputOrBuilder>
        eventBuilder_;
    /**
     *
     *
     * <pre>
     * The event to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventInput event = 6;</code>
     *
     * @return Whether the event field is set.
     */
    @java.lang.Override
    public boolean hasEvent() {
      return inputCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The event to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventInput event = 6;</code>
     *
     * @return The event.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.EventInput getEvent() {
      if (eventBuilder_ == null) {
        if (inputCase_ == 6) {
          return (com.google.cloud.dialogflow.cx.v3.EventInput) input_;
        }
        return com.google.cloud.dialogflow.cx.v3.EventInput.getDefaultInstance();
      } else {
        if (inputCase_ == 6) {
          return eventBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3.EventInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The event to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventInput event = 6;</code>
     */
    public Builder setEvent(com.google.cloud.dialogflow.cx.v3.EventInput value) {
      if (eventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        eventBuilder_.setMessage(value);
      }
      inputCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventInput event = 6;</code>
     */
    public Builder setEvent(com.google.cloud.dialogflow.cx.v3.EventInput.Builder builderForValue) {
      if (eventBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        eventBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventInput event = 6;</code>
     */
    public Builder mergeEvent(com.google.cloud.dialogflow.cx.v3.EventInput value) {
      if (eventBuilder_ == null) {
        if (inputCase_ == 6
            && input_ != com.google.cloud.dialogflow.cx.v3.EventInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.cx.v3.EventInput.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3.EventInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 6) {
          eventBuilder_.mergeFrom(value);
        } else {
          eventBuilder_.setMessage(value);
        }
      }
      inputCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventInput event = 6;</code>
     */
    public Builder clearEvent() {
      if (eventBuilder_ == null) {
        if (inputCase_ == 6) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 6) {
          inputCase_ = 0;
          input_ = null;
        }
        eventBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventInput event = 6;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.EventInput.Builder getEventBuilder() {
      return getEventFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The event to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventInput event = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.EventInputOrBuilder getEventOrBuilder() {
      if ((inputCase_ == 6) && (eventBuilder_ != null)) {
        return eventBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 6) {
          return (com.google.cloud.dialogflow.cx.v3.EventInput) input_;
        }
        return com.google.cloud.dialogflow.cx.v3.EventInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The event to be triggered.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.EventInput event = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.EventInput,
            com.google.cloud.dialogflow.cx.v3.EventInput.Builder,
            com.google.cloud.dialogflow.cx.v3.EventInputOrBuilder>
        getEventFieldBuilder() {
      if (eventBuilder_ == null) {
        if (!(inputCase_ == 6)) {
          input_ = com.google.cloud.dialogflow.cx.v3.EventInput.getDefaultInstance();
        }
        eventBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.EventInput,
                com.google.cloud.dialogflow.cx.v3.EventInput.Builder,
                com.google.cloud.dialogflow.cx.v3.EventInputOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3.EventInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 6;
      onChanged();
      return eventBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DtmfInput,
            com.google.cloud.dialogflow.cx.v3.DtmfInput.Builder,
            com.google.cloud.dialogflow.cx.v3.DtmfInputOrBuilder>
        dtmfBuilder_;
    /**
     *
     *
     * <pre>
     * The DTMF event to be handled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 7;</code>
     *
     * @return Whether the dtmf field is set.
     */
    @java.lang.Override
    public boolean hasDtmf() {
      return inputCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The DTMF event to be handled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 7;</code>
     *
     * @return The dtmf.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DtmfInput getDtmf() {
      if (dtmfBuilder_ == null) {
        if (inputCase_ == 7) {
          return (com.google.cloud.dialogflow.cx.v3.DtmfInput) input_;
        }
        return com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance();
      } else {
        if (inputCase_ == 7) {
          return dtmfBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The DTMF event to be handled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 7;</code>
     */
    public Builder setDtmf(com.google.cloud.dialogflow.cx.v3.DtmfInput value) {
      if (dtmfBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        dtmfBuilder_.setMessage(value);
      }
      inputCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DTMF event to be handled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 7;</code>
     */
    public Builder setDtmf(com.google.cloud.dialogflow.cx.v3.DtmfInput.Builder builderForValue) {
      if (dtmfBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        dtmfBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DTMF event to be handled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 7;</code>
     */
    public Builder mergeDtmf(com.google.cloud.dialogflow.cx.v3.DtmfInput value) {
      if (dtmfBuilder_ == null) {
        if (inputCase_ == 7
            && input_ != com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.cx.v3.DtmfInput.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3.DtmfInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 7) {
          dtmfBuilder_.mergeFrom(value);
        } else {
          dtmfBuilder_.setMessage(value);
        }
      }
      inputCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DTMF event to be handled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 7;</code>
     */
    public Builder clearDtmf() {
      if (dtmfBuilder_ == null) {
        if (inputCase_ == 7) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 7) {
          inputCase_ = 0;
          input_ = null;
        }
        dtmfBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DTMF event to be handled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 7;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.DtmfInput.Builder getDtmfBuilder() {
      return getDtmfFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The DTMF event to be handled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DtmfInputOrBuilder getDtmfOrBuilder() {
      if ((inputCase_ == 7) && (dtmfBuilder_ != null)) {
        return dtmfBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 7) {
          return (com.google.cloud.dialogflow.cx.v3.DtmfInput) input_;
        }
        return com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The DTMF event to be handled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DtmfInput,
            com.google.cloud.dialogflow.cx.v3.DtmfInput.Builder,
            com.google.cloud.dialogflow.cx.v3.DtmfInputOrBuilder>
        getDtmfFieldBuilder() {
      if (dtmfBuilder_ == null) {
        if (!(inputCase_ == 7)) {
          input_ = com.google.cloud.dialogflow.cx.v3.DtmfInput.getDefaultInstance();
        }
        dtmfBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.DtmfInput,
                com.google.cloud.dialogflow.cx.v3.DtmfInput.Builder,
                com.google.cloud.dialogflow.cx.v3.DtmfInputOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3.DtmfInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 7;
      onChanged();
      return dtmfBuilder_;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. The language of the input. See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The language of the input. See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The language of the input. See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The language of the input. See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The language of the input. See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.QueryInput)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.QueryInput)
  private static final com.google.cloud.dialogflow.cx.v3.QueryInput DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.QueryInput();
  }

  public static com.google.cloud.dialogflow.cx.v3.QueryInput getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryInput> PARSER =
      new com.google.protobuf.AbstractParser<QueryInput>() {
        @java.lang.Override
        public QueryInput parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QueryInput> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryInput> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryInput getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
