/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/session.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Request of [MatchIntent][].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.MatchIntentRequest}
 */
public final class MatchIntentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.MatchIntentRequest)
    MatchIntentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MatchIntentRequest.newBuilder() to construct.
  private MatchIntentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MatchIntentRequest() {
    session_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MatchIntentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_MatchIntentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_MatchIntentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.MatchIntentRequest.class,
            com.google.cloud.dialogflow.cx.v3.MatchIntentRequest.Builder.class);
  }

  private int bitField0_;
  public static final int SESSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object session_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the session this query is sent to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
   * or
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
   * If `Environment ID` is not specified, we assume default 'draft'
   * environment.
   * It's up to the API caller to choose an appropriate `Session ID`. It can be
   * a random number or some type of session identifiers (preferably hashed).
   * The length of the `Session ID` must not exceed 36 characters.
   *
   * For more information, see the [sessions
   * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the session this query is sent to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
   * or
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
   * If `Environment ID` is not specified, we assume default 'draft'
   * environment.
   * It's up to the API caller to choose an appropriate `Session ID`. It can be
   * a random number or some type of session identifiers (preferably hashed).
   * The length of the `Session ID` must not exceed 36 characters.
   *
   * For more information, see the [sessions
   * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_PARAMS_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.cx.v3.QueryParameters queryParams_;
  /**
   *
   *
   * <pre>
   * The parameters of this query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
   *
   * @return Whether the queryParams field is set.
   */
  @java.lang.Override
  public boolean hasQueryParams() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The parameters of this query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
   *
   * @return The queryParams.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryParameters getQueryParams() {
    return queryParams_ == null
        ? com.google.cloud.dialogflow.cx.v3.QueryParameters.getDefaultInstance()
        : queryParams_;
  }
  /**
   *
   *
   * <pre>
   * The parameters of this query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryParametersOrBuilder getQueryParamsOrBuilder() {
    return queryParams_ == null
        ? com.google.cloud.dialogflow.cx.v3.QueryParameters.getDefaultInstance()
        : queryParams_;
  }

  public static final int QUERY_INPUT_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.cx.v3.QueryInput queryInput_;
  /**
   *
   *
   * <pre>
   * Required. The input specification.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the queryInput field is set.
   */
  @java.lang.Override
  public boolean hasQueryInput() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The input specification.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The queryInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryInput getQueryInput() {
    return queryInput_ == null
        ? com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()
        : queryInput_;
  }
  /**
   *
   *
   * <pre>
   * Required. The input specification.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder getQueryInputOrBuilder() {
    return queryInput_ == null
        ? com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()
        : queryInput_;
  }

  public static final int PERSIST_PARAMETER_CHANGES_FIELD_NUMBER = 5;
  private boolean persistParameterChanges_ = false;
  /**
   *
   *
   * <pre>
   * Persist session parameter changes from `query_params`.
   * </pre>
   *
   * <code>bool persist_parameter_changes = 5;</code>
   *
   * @return The persistParameterChanges.
   */
  @java.lang.Override
  public boolean getPersistParameterChanges() {
    return persistParameterChanges_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, session_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getQueryParams());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getQueryInput());
    }
    if (persistParameterChanges_ != false) {
      output.writeBool(5, persistParameterChanges_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, session_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getQueryParams());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getQueryInput());
    }
    if (persistParameterChanges_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, persistParameterChanges_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.MatchIntentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.MatchIntentRequest other =
        (com.google.cloud.dialogflow.cx.v3.MatchIntentRequest) obj;

    if (!getSession().equals(other.getSession())) return false;
    if (hasQueryParams() != other.hasQueryParams()) return false;
    if (hasQueryParams()) {
      if (!getQueryParams().equals(other.getQueryParams())) return false;
    }
    if (hasQueryInput() != other.hasQueryInput()) return false;
    if (hasQueryInput()) {
      if (!getQueryInput().equals(other.getQueryInput())) return false;
    }
    if (getPersistParameterChanges() != other.getPersistParameterChanges()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    if (hasQueryParams()) {
      hash = (37 * hash) + QUERY_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getQueryParams().hashCode();
    }
    if (hasQueryInput()) {
      hash = (37 * hash) + QUERY_INPUT_FIELD_NUMBER;
      hash = (53 * hash) + getQueryInput().hashCode();
    }
    hash = (37 * hash) + PERSIST_PARAMETER_CHANGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPersistParameterChanges());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.MatchIntentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request of [MatchIntent][].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.MatchIntentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.MatchIntentRequest)
      com.google.cloud.dialogflow.cx.v3.MatchIntentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_MatchIntentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_MatchIntentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.MatchIntentRequest.class,
              com.google.cloud.dialogflow.cx.v3.MatchIntentRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.MatchIntentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getQueryParamsFieldBuilder();
        getQueryInputFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      session_ = "";
      queryParams_ = null;
      if (queryParamsBuilder_ != null) {
        queryParamsBuilder_.dispose();
        queryParamsBuilder_ = null;
      }
      queryInput_ = null;
      if (queryInputBuilder_ != null) {
        queryInputBuilder_.dispose();
        queryInputBuilder_ = null;
      }
      persistParameterChanges_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_MatchIntentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.MatchIntentRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.MatchIntentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.MatchIntentRequest build() {
      com.google.cloud.dialogflow.cx.v3.MatchIntentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.MatchIntentRequest buildPartial() {
      com.google.cloud.dialogflow.cx.v3.MatchIntentRequest result =
          new com.google.cloud.dialogflow.cx.v3.MatchIntentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.MatchIntentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.session_ = session_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.queryParams_ =
            queryParamsBuilder_ == null ? queryParams_ : queryParamsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.queryInput_ = queryInputBuilder_ == null ? queryInput_ : queryInputBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.persistParameterChanges_ = persistParameterChanges_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.MatchIntentRequest) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.MatchIntentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.MatchIntentRequest other) {
      if (other == com.google.cloud.dialogflow.cx.v3.MatchIntentRequest.getDefaultInstance())
        return this;
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasQueryParams()) {
        mergeQueryParams(other.getQueryParams());
      }
      if (other.hasQueryInput()) {
        mergeQueryInput(other.getQueryInput());
      }
      if (other.getPersistParameterChanges() != false) {
        setPersistParameterChanges(other.getPersistParameterChanges());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                session_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getQueryParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getQueryInputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 40:
              {
                persistParameterChanges_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object session_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the session this query is sent to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
     * or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * It's up to the API caller to choose an appropriate `Session ID`. It can be
     * a random number or some type of session identifiers (preferably hashed).
     * The length of the `Session ID` must not exceed 36 characters.
     *
     * For more information, see the [sessions
     * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The session.
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the session this query is sent to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
     * or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * It's up to the API caller to choose an appropriate `Session ID`. It can be
     * a random number or some type of session identifiers (preferably hashed).
     * The length of the `Session ID` must not exceed 36 characters.
     *
     * For more information, see the [sessions
     * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for session.
     */
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the session this query is sent to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
     * or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * It's up to the API caller to choose an appropriate `Session ID`. It can be
     * a random number or some type of session identifiers (preferably hashed).
     * The length of the `Session ID` must not exceed 36 characters.
     *
     * For more information, see the [sessions
     * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The session to set.
     * @return This builder for chaining.
     */
    public Builder setSession(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the session this query is sent to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
     * or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * It's up to the API caller to choose an appropriate `Session ID`. It can be
     * a random number or some type of session identifiers (preferably hashed).
     * The length of the `Session ID` must not exceed 36 characters.
     *
     * For more information, see the [sessions
     * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSession() {
      session_ = getDefaultInstance().getSession();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the session this query is sent to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;SessionID&gt;`
     * or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * It's up to the API caller to choose an appropriate `Session ID`. It can be
     * a random number or some type of session identifiers (preferably hashed).
     * The length of the `Session ID` must not exceed 36 characters.
     *
     * For more information, see the [sessions
     * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for session to set.
     * @return This builder for chaining.
     */
    public Builder setSessionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.QueryParameters queryParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.QueryParameters,
            com.google.cloud.dialogflow.cx.v3.QueryParameters.Builder,
            com.google.cloud.dialogflow.cx.v3.QueryParametersOrBuilder>
        queryParamsBuilder_;
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     *
     * @return Whether the queryParams field is set.
     */
    public boolean hasQueryParams() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     *
     * @return The queryParams.
     */
    public com.google.cloud.dialogflow.cx.v3.QueryParameters getQueryParams() {
      if (queryParamsBuilder_ == null) {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.cx.v3.QueryParameters.getDefaultInstance()
            : queryParams_;
      } else {
        return queryParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    public Builder setQueryParams(com.google.cloud.dialogflow.cx.v3.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryParams_ = value;
      } else {
        queryParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    public Builder setQueryParams(
        com.google.cloud.dialogflow.cx.v3.QueryParameters.Builder builderForValue) {
      if (queryParamsBuilder_ == null) {
        queryParams_ = builderForValue.build();
      } else {
        queryParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    public Builder mergeQueryParams(com.google.cloud.dialogflow.cx.v3.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && queryParams_ != null
            && queryParams_
                != com.google.cloud.dialogflow.cx.v3.QueryParameters.getDefaultInstance()) {
          getQueryParamsBuilder().mergeFrom(value);
        } else {
          queryParams_ = value;
        }
      } else {
        queryParamsBuilder_.mergeFrom(value);
      }
      if (queryParams_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    public Builder clearQueryParams() {
      bitField0_ = (bitField0_ & ~0x00000002);
      queryParams_ = null;
      if (queryParamsBuilder_ != null) {
        queryParamsBuilder_.dispose();
        queryParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.QueryParameters.Builder getQueryParamsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getQueryParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.QueryParametersOrBuilder getQueryParamsOrBuilder() {
      if (queryParamsBuilder_ != null) {
        return queryParamsBuilder_.getMessageOrBuilder();
      } else {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.cx.v3.QueryParameters.getDefaultInstance()
            : queryParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.QueryParameters,
            com.google.cloud.dialogflow.cx.v3.QueryParameters.Builder,
            com.google.cloud.dialogflow.cx.v3.QueryParametersOrBuilder>
        getQueryParamsFieldBuilder() {
      if (queryParamsBuilder_ == null) {
        queryParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.QueryParameters,
                com.google.cloud.dialogflow.cx.v3.QueryParameters.Builder,
                com.google.cloud.dialogflow.cx.v3.QueryParametersOrBuilder>(
                getQueryParams(), getParentForChildren(), isClean());
        queryParams_ = null;
      }
      return queryParamsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.QueryInput queryInput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.QueryInput,
            com.google.cloud.dialogflow.cx.v3.QueryInput.Builder,
            com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder>
        queryInputBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the queryInput field is set.
     */
    public boolean hasQueryInput() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The queryInput.
     */
    public com.google.cloud.dialogflow.cx.v3.QueryInput getQueryInput() {
      if (queryInputBuilder_ == null) {
        return queryInput_ == null
            ? com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()
            : queryInput_;
      } else {
        return queryInputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQueryInput(com.google.cloud.dialogflow.cx.v3.QueryInput value) {
      if (queryInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryInput_ = value;
      } else {
        queryInputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQueryInput(
        com.google.cloud.dialogflow.cx.v3.QueryInput.Builder builderForValue) {
      if (queryInputBuilder_ == null) {
        queryInput_ = builderForValue.build();
      } else {
        queryInputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeQueryInput(com.google.cloud.dialogflow.cx.v3.QueryInput value) {
      if (queryInputBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && queryInput_ != null
            && queryInput_ != com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()) {
          getQueryInputBuilder().mergeFrom(value);
        } else {
          queryInput_ = value;
        }
      } else {
        queryInputBuilder_.mergeFrom(value);
      }
      if (queryInput_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearQueryInput() {
      bitField0_ = (bitField0_ & ~0x00000004);
      queryInput_ = null;
      if (queryInputBuilder_ != null) {
        queryInputBuilder_.dispose();
        queryInputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.QueryInput.Builder getQueryInputBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getQueryInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder getQueryInputOrBuilder() {
      if (queryInputBuilder_ != null) {
        return queryInputBuilder_.getMessageOrBuilder();
      } else {
        return queryInput_ == null
            ? com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()
            : queryInput_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.QueryInput,
            com.google.cloud.dialogflow.cx.v3.QueryInput.Builder,
            com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder>
        getQueryInputFieldBuilder() {
      if (queryInputBuilder_ == null) {
        queryInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.QueryInput,
                com.google.cloud.dialogflow.cx.v3.QueryInput.Builder,
                com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder>(
                getQueryInput(), getParentForChildren(), isClean());
        queryInput_ = null;
      }
      return queryInputBuilder_;
    }

    private boolean persistParameterChanges_;
    /**
     *
     *
     * <pre>
     * Persist session parameter changes from `query_params`.
     * </pre>
     *
     * <code>bool persist_parameter_changes = 5;</code>
     *
     * @return The persistParameterChanges.
     */
    @java.lang.Override
    public boolean getPersistParameterChanges() {
      return persistParameterChanges_;
    }
    /**
     *
     *
     * <pre>
     * Persist session parameter changes from `query_params`.
     * </pre>
     *
     * <code>bool persist_parameter_changes = 5;</code>
     *
     * @param value The persistParameterChanges to set.
     * @return This builder for chaining.
     */
    public Builder setPersistParameterChanges(boolean value) {

      persistParameterChanges_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Persist session parameter changes from `query_params`.
     * </pre>
     *
     * <code>bool persist_parameter_changes = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPersistParameterChanges() {
      bitField0_ = (bitField0_ & ~0x00000008);
      persistParameterChanges_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.MatchIntentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.MatchIntentRequest)
  private static final com.google.cloud.dialogflow.cx.v3.MatchIntentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.MatchIntentRequest();
  }

  public static com.google.cloud.dialogflow.cx.v3.MatchIntentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MatchIntentRequest> PARSER =
      new com.google.protobuf.AbstractParser<MatchIntentRequest>() {
        @java.lang.Override
        public MatchIntentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MatchIntentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MatchIntentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.MatchIntentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
