/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/agent.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * The request message for
 * [Agents.ExportAgent][google.cloud.dialogflow.cx.v3.Agents.ExportAgent].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.ExportAgentRequest}
 */
public final class ExportAgentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.ExportAgentRequest)
    ExportAgentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportAgentRequest.newBuilder() to construct.
  private ExportAgentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportAgentRequest() {
    name_ = "";
    agentUri_ = "";
    dataFormat_ = 0;
    environment_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportAgentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.AgentProto
        .internal_static_google_cloud_dialogflow_cx_v3_ExportAgentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.AgentProto
        .internal_static_google_cloud_dialogflow_cx_v3_ExportAgentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.class,
            com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Data format of the exported agent.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat}
   */
  public enum DataFormat implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified format.
     * </pre>
     *
     * <code>DATA_FORMAT_UNSPECIFIED = 0;</code>
     */
    DATA_FORMAT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Agent content will be exported as raw bytes.
     * </pre>
     *
     * <code>BLOB = 1;</code>
     */
    BLOB(1),
    /**
     *
     *
     * <pre>
     * Agent content will be exported in JSON Package format.
     * </pre>
     *
     * <code>JSON_PACKAGE = 4;</code>
     */
    JSON_PACKAGE(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified format.
     * </pre>
     *
     * <code>DATA_FORMAT_UNSPECIFIED = 0;</code>
     */
    public static final int DATA_FORMAT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Agent content will be exported as raw bytes.
     * </pre>
     *
     * <code>BLOB = 1;</code>
     */
    public static final int BLOB_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Agent content will be exported in JSON Package format.
     * </pre>
     *
     * <code>JSON_PACKAGE = 4;</code>
     */
    public static final int JSON_PACKAGE_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataFormat valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DataFormat forNumber(int value) {
      switch (value) {
        case 0:
          return DATA_FORMAT_UNSPECIFIED;
        case 1:
          return BLOB;
        case 4:
          return JSON_PACKAGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DataFormat> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DataFormat> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DataFormat>() {
          public DataFormat findValueByNumber(int number) {
            return DataFormat.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final DataFormat[] VALUES = values();

    public static DataFormat valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DataFormat(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat)
  }

  public interface GitDestinationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Tracking branch for the git push.
     * </pre>
     *
     * <code>string tracking_branch = 1;</code>
     *
     * @return The trackingBranch.
     */
    java.lang.String getTrackingBranch();
    /**
     *
     *
     * <pre>
     * Tracking branch for the git push.
     * </pre>
     *
     * <code>string tracking_branch = 1;</code>
     *
     * @return The bytes for trackingBranch.
     */
    com.google.protobuf.ByteString getTrackingBranchBytes();

    /**
     *
     *
     * <pre>
     * Commit message for the git push.
     * </pre>
     *
     * <code>string commit_message = 2;</code>
     *
     * @return The commitMessage.
     */
    java.lang.String getCommitMessage();
    /**
     *
     *
     * <pre>
     * Commit message for the git push.
     * </pre>
     *
     * <code>string commit_message = 2;</code>
     *
     * @return The bytes for commitMessage.
     */
    com.google.protobuf.ByteString getCommitMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * Settings for exporting to a git branch.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination}
   */
  public static final class GitDestination extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination)
      GitDestinationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GitDestination.newBuilder() to construct.
    private GitDestination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GitDestination() {
      trackingBranch_ = "";
      commitMessage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GitDestination();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_ExportAgentRequest_GitDestination_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_ExportAgentRequest_GitDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination.class,
              com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination.Builder.class);
    }

    public static final int TRACKING_BRANCH_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object trackingBranch_ = "";
    /**
     *
     *
     * <pre>
     * Tracking branch for the git push.
     * </pre>
     *
     * <code>string tracking_branch = 1;</code>
     *
     * @return The trackingBranch.
     */
    @java.lang.Override
    public java.lang.String getTrackingBranch() {
      java.lang.Object ref = trackingBranch_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trackingBranch_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Tracking branch for the git push.
     * </pre>
     *
     * <code>string tracking_branch = 1;</code>
     *
     * @return The bytes for trackingBranch.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTrackingBranchBytes() {
      java.lang.Object ref = trackingBranch_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trackingBranch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COMMIT_MESSAGE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object commitMessage_ = "";
    /**
     *
     *
     * <pre>
     * Commit message for the git push.
     * </pre>
     *
     * <code>string commit_message = 2;</code>
     *
     * @return The commitMessage.
     */
    @java.lang.Override
    public java.lang.String getCommitMessage() {
      java.lang.Object ref = commitMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        commitMessage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Commit message for the git push.
     * </pre>
     *
     * <code>string commit_message = 2;</code>
     *
     * @return The bytes for commitMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCommitMessageBytes() {
      java.lang.Object ref = commitMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        commitMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trackingBranch_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, trackingBranch_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(commitMessage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, commitMessage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trackingBranch_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, trackingBranch_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(commitMessage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, commitMessage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination other =
          (com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination) obj;

      if (!getTrackingBranch().equals(other.getTrackingBranch())) return false;
      if (!getCommitMessage().equals(other.getCommitMessage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TRACKING_BRANCH_FIELD_NUMBER;
      hash = (53 * hash) + getTrackingBranch().hashCode();
      hash = (37 * hash) + COMMIT_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getCommitMessage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Settings for exporting to a git branch.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination)
        com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestinationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_ExportAgentRequest_GitDestination_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_ExportAgentRequest_GitDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination.class,
                com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        trackingBranch_ = "";
        commitMessage_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_ExportAgentRequest_GitDestination_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination build() {
        com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination buildPartial() {
        com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination result =
            new com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.trackingBranch_ = trackingBranch_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.commitMessage_ = commitMessage_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
                .getDefaultInstance()) return this;
        if (!other.getTrackingBranch().isEmpty()) {
          trackingBranch_ = other.trackingBranch_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getCommitMessage().isEmpty()) {
          commitMessage_ = other.commitMessage_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  trackingBranch_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  commitMessage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object trackingBranch_ = "";
      /**
       *
       *
       * <pre>
       * Tracking branch for the git push.
       * </pre>
       *
       * <code>string tracking_branch = 1;</code>
       *
       * @return The trackingBranch.
       */
      public java.lang.String getTrackingBranch() {
        java.lang.Object ref = trackingBranch_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          trackingBranch_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Tracking branch for the git push.
       * </pre>
       *
       * <code>string tracking_branch = 1;</code>
       *
       * @return The bytes for trackingBranch.
       */
      public com.google.protobuf.ByteString getTrackingBranchBytes() {
        java.lang.Object ref = trackingBranch_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          trackingBranch_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Tracking branch for the git push.
       * </pre>
       *
       * <code>string tracking_branch = 1;</code>
       *
       * @param value The trackingBranch to set.
       * @return This builder for chaining.
       */
      public Builder setTrackingBranch(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        trackingBranch_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Tracking branch for the git push.
       * </pre>
       *
       * <code>string tracking_branch = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTrackingBranch() {
        trackingBranch_ = getDefaultInstance().getTrackingBranch();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Tracking branch for the git push.
       * </pre>
       *
       * <code>string tracking_branch = 1;</code>
       *
       * @param value The bytes for trackingBranch to set.
       * @return This builder for chaining.
       */
      public Builder setTrackingBranchBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        trackingBranch_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object commitMessage_ = "";
      /**
       *
       *
       * <pre>
       * Commit message for the git push.
       * </pre>
       *
       * <code>string commit_message = 2;</code>
       *
       * @return The commitMessage.
       */
      public java.lang.String getCommitMessage() {
        java.lang.Object ref = commitMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          commitMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Commit message for the git push.
       * </pre>
       *
       * <code>string commit_message = 2;</code>
       *
       * @return The bytes for commitMessage.
       */
      public com.google.protobuf.ByteString getCommitMessageBytes() {
        java.lang.Object ref = commitMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          commitMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Commit message for the git push.
       * </pre>
       *
       * <code>string commit_message = 2;</code>
       *
       * @param value The commitMessage to set.
       * @return This builder for chaining.
       */
      public Builder setCommitMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        commitMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Commit message for the git push.
       * </pre>
       *
       * <code>string commit_message = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCommitMessage() {
        commitMessage_ = getDefaultInstance().getCommitMessage();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Commit message for the git push.
       * </pre>
       *
       * <code>string commit_message = 2;</code>
       *
       * @param value The bytes for commitMessage to set.
       * @return This builder for chaining.
       */
      public Builder setCommitMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        commitMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination)
    private static final com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination();
    }

    public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GitDestination> PARSER =
        new com.google.protobuf.AbstractParser<GitDestination>() {
          @java.lang.Override
          public GitDestination parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GitDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GitDestination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the agent to export.
   * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the agent to export.
   * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AGENT_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object agentUri_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The [Google Cloud
   * Storage](https://cloud.google.com/storage/docs/) URI to export the agent
   * to. The format of this URI must be `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`. If
   * left unspecified, the serialized agent is returned inline.
   *
   * Dialogflow performs a write operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have write permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string agent_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The agentUri.
   */
  @java.lang.Override
  public java.lang.String getAgentUri() {
    java.lang.Object ref = agentUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      agentUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The [Google Cloud
   * Storage](https://cloud.google.com/storage/docs/) URI to export the agent
   * to. The format of this URI must be `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`. If
   * left unspecified, the serialized agent is returned inline.
   *
   * Dialogflow performs a write operation for the Cloud Storage object
   * on the caller's behalf, so your request authentication must
   * have write permissions for the object. For more information, see
   * [Dialogflow access
   * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
   * </pre>
   *
   * <code>string agent_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for agentUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAgentUriBytes() {
    java.lang.Object ref = agentUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      agentUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_FORMAT_FIELD_NUMBER = 3;
  private int dataFormat_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The data format of the exported agent. If not specified, `BLOB`
   * is assumed.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat data_format = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for dataFormat.
   */
  @java.lang.Override
  public int getDataFormatValue() {
    return dataFormat_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The data format of the exported agent. If not specified, `BLOB`
   * is assumed.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat data_format = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The dataFormat.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat getDataFormat() {
    com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat result =
        com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat.forNumber(dataFormat_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat.UNRECOGNIZED
        : result;
  }

  public static final int ENVIRONMENT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object environment_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Environment name. If not set, draft environment is assumed.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
   * </pre>
   *
   * <code>
   * string environment = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The environment.
   */
  @java.lang.Override
  public java.lang.String getEnvironment() {
    java.lang.Object ref = environment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      environment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Environment name. If not set, draft environment is assumed.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
   * </pre>
   *
   * <code>
   * string environment = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for environment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEnvironmentBytes() {
    java.lang.Object ref = environment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      environment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GIT_DESTINATION_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination gitDestination_;
  /**
   *
   *
   * <pre>
   * Optional. The Git branch to export the agent to.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gitDestination field is set.
   */
  @java.lang.Override
  public boolean hasGitDestination() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The Git branch to export the agent to.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gitDestination.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination getGitDestination() {
    return gitDestination_ == null
        ? com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination.getDefaultInstance()
        : gitDestination_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Git branch to export the agent to.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestinationOrBuilder
      getGitDestinationOrBuilder() {
    return gitDestination_ == null
        ? com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination.getDefaultInstance()
        : gitDestination_;
  }

  public static final int INCLUDE_BIGQUERY_EXPORT_SETTINGS_FIELD_NUMBER = 7;
  private boolean includeBigqueryExportSettings_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Whether to include BigQuery Export setting.
   * </pre>
   *
   * <code>bool include_bigquery_export_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The includeBigqueryExportSettings.
   */
  @java.lang.Override
  public boolean getIncludeBigqueryExportSettings() {
    return includeBigqueryExportSettings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, agentUri_);
    }
    if (dataFormat_
        != com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat.DATA_FORMAT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, dataFormat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(environment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, environment_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getGitDestination());
    }
    if (includeBigqueryExportSettings_ != false) {
      output.writeBool(7, includeBigqueryExportSettings_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, agentUri_);
    }
    if (dataFormat_
        != com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat.DATA_FORMAT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, dataFormat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(environment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, environment_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getGitDestination());
    }
    if (includeBigqueryExportSettings_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(7, includeBigqueryExportSettings_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.ExportAgentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.ExportAgentRequest other =
        (com.google.cloud.dialogflow.cx.v3.ExportAgentRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAgentUri().equals(other.getAgentUri())) return false;
    if (dataFormat_ != other.dataFormat_) return false;
    if (!getEnvironment().equals(other.getEnvironment())) return false;
    if (hasGitDestination() != other.hasGitDestination()) return false;
    if (hasGitDestination()) {
      if (!getGitDestination().equals(other.getGitDestination())) return false;
    }
    if (getIncludeBigqueryExportSettings() != other.getIncludeBigqueryExportSettings())
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + AGENT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAgentUri().hashCode();
    hash = (37 * hash) + DATA_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + dataFormat_;
    hash = (37 * hash) + ENVIRONMENT_FIELD_NUMBER;
    hash = (53 * hash) + getEnvironment().hashCode();
    if (hasGitDestination()) {
      hash = (37 * hash) + GIT_DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getGitDestination().hashCode();
    }
    hash = (37 * hash) + INCLUDE_BIGQUERY_EXPORT_SETTINGS_FIELD_NUMBER;
    hash =
        (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeBigqueryExportSettings());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.ExportAgentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for
   * [Agents.ExportAgent][google.cloud.dialogflow.cx.v3.Agents.ExportAgent].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.ExportAgentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.ExportAgentRequest)
      com.google.cloud.dialogflow.cx.v3.ExportAgentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_ExportAgentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_ExportAgentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.class,
              com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getGitDestinationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      agentUri_ = "";
      dataFormat_ = 0;
      environment_ = "";
      gitDestination_ = null;
      if (gitDestinationBuilder_ != null) {
        gitDestinationBuilder_.dispose();
        gitDestinationBuilder_ = null;
      }
      includeBigqueryExportSettings_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_ExportAgentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest build() {
      com.google.cloud.dialogflow.cx.v3.ExportAgentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest buildPartial() {
      com.google.cloud.dialogflow.cx.v3.ExportAgentRequest result =
          new com.google.cloud.dialogflow.cx.v3.ExportAgentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.ExportAgentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.agentUri_ = agentUri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dataFormat_ = dataFormat_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.environment_ = environment_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.gitDestination_ =
            gitDestinationBuilder_ == null ? gitDestination_ : gitDestinationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.includeBigqueryExportSettings_ = includeBigqueryExportSettings_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.ExportAgentRequest) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.ExportAgentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.ExportAgentRequest other) {
      if (other == com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAgentUri().isEmpty()) {
        agentUri_ = other.agentUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.dataFormat_ != 0) {
        setDataFormatValue(other.getDataFormatValue());
      }
      if (!other.getEnvironment().isEmpty()) {
        environment_ = other.environment_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasGitDestination()) {
        mergeGitDestination(other.getGitDestination());
      }
      if (other.getIncludeBigqueryExportSettings() != false) {
        setIncludeBigqueryExportSettings(other.getIncludeBigqueryExportSettings());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                agentUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                dataFormat_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 42:
              {
                environment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getGitDestinationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 56:
              {
                includeBigqueryExportSettings_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to export.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to export.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to export.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to export.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to export.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object agentUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the agent
     * to. The format of this URI must be `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`. If
     * left unspecified, the serialized agent is returned inline.
     *
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string agent_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentUri.
     */
    public java.lang.String getAgentUri() {
      java.lang.Object ref = agentUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agentUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the agent
     * to. The format of this URI must be `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`. If
     * left unspecified, the serialized agent is returned inline.
     *
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string agent_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for agentUri.
     */
    public com.google.protobuf.ByteString getAgentUriBytes() {
      java.lang.Object ref = agentUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agentUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the agent
     * to. The format of this URI must be `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`. If
     * left unspecified, the serialized agent is returned inline.
     *
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string agent_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The agentUri to set.
     * @return This builder for chaining.
     */
    public Builder setAgentUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      agentUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the agent
     * to. The format of this URI must be `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`. If
     * left unspecified, the serialized agent is returned inline.
     *
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string agent_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgentUri() {
      agentUri_ = getDefaultInstance().getAgentUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The [Google Cloud
     * Storage](https://cloud.google.com/storage/docs/) URI to export the agent
     * to. The format of this URI must be `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`. If
     * left unspecified, the serialized agent is returned inline.
     *
     * Dialogflow performs a write operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have write permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     * </pre>
     *
     * <code>string agent_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for agentUri to set.
     * @return This builder for chaining.
     */
    public Builder setAgentUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      agentUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int dataFormat_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The data format of the exported agent. If not specified, `BLOB`
     * is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat data_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for dataFormat.
     */
    @java.lang.Override
    public int getDataFormatValue() {
      return dataFormat_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The data format of the exported agent. If not specified, `BLOB`
     * is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat data_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for dataFormat to set.
     * @return This builder for chaining.
     */
    public Builder setDataFormatValue(int value) {
      dataFormat_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The data format of the exported agent. If not specified, `BLOB`
     * is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat data_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The dataFormat.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat getDataFormat() {
      com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat result =
          com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat.forNumber(dataFormat_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The data format of the exported agent. If not specified, `BLOB`
     * is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat data_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The dataFormat to set.
     * @return This builder for chaining.
     */
    public Builder setDataFormat(
        com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      dataFormat_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The data format of the exported agent. If not specified, `BLOB`
     * is assumed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.DataFormat data_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataFormat() {
      bitField0_ = (bitField0_ & ~0x00000004);
      dataFormat_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object environment_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Environment name. If not set, draft environment is assumed.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
     * </pre>
     *
     * <code>
     * string environment = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The environment.
     */
    public java.lang.String getEnvironment() {
      java.lang.Object ref = environment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        environment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment name. If not set, draft environment is assumed.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
     * </pre>
     *
     * <code>
     * string environment = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for environment.
     */
    public com.google.protobuf.ByteString getEnvironmentBytes() {
      java.lang.Object ref = environment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        environment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment name. If not set, draft environment is assumed.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
     * </pre>
     *
     * <code>
     * string environment = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The environment to set.
     * @return This builder for chaining.
     */
    public Builder setEnvironment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      environment_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment name. If not set, draft environment is assumed.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
     * </pre>
     *
     * <code>
     * string environment = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnvironment() {
      environment_ = getDefaultInstance().getEnvironment();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment name. If not set, draft environment is assumed.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;`.
     * </pre>
     *
     * <code>
     * string environment = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for environment to set.
     * @return This builder for chaining.
     */
    public Builder setEnvironmentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      environment_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination gitDestination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination,
            com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination.Builder,
            com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestinationOrBuilder>
        gitDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The Git branch to export the agent to.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gitDestination field is set.
     */
    public boolean hasGitDestination() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The Git branch to export the agent to.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gitDestination.
     */
    public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination getGitDestination() {
      if (gitDestinationBuilder_ == null) {
        return gitDestination_ == null
            ? com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
                .getDefaultInstance()
            : gitDestination_;
      } else {
        return gitDestinationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Git branch to export the agent to.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGitDestination(
        com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination value) {
      if (gitDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gitDestination_ = value;
      } else {
        gitDestinationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Git branch to export the agent to.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGitDestination(
        com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination.Builder
            builderForValue) {
      if (gitDestinationBuilder_ == null) {
        gitDestination_ = builderForValue.build();
      } else {
        gitDestinationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Git branch to export the agent to.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGitDestination(
        com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination value) {
      if (gitDestinationBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && gitDestination_ != null
            && gitDestination_
                != com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
                    .getDefaultInstance()) {
          getGitDestinationBuilder().mergeFrom(value);
        } else {
          gitDestination_ = value;
        }
      } else {
        gitDestinationBuilder_.mergeFrom(value);
      }
      if (gitDestination_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Git branch to export the agent to.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGitDestination() {
      bitField0_ = (bitField0_ & ~0x00000010);
      gitDestination_ = null;
      if (gitDestinationBuilder_ != null) {
        gitDestinationBuilder_.dispose();
        gitDestinationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Git branch to export the agent to.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination.Builder
        getGitDestinationBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getGitDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The Git branch to export the agent to.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestinationOrBuilder
        getGitDestinationOrBuilder() {
      if (gitDestinationBuilder_ != null) {
        return gitDestinationBuilder_.getMessageOrBuilder();
      } else {
        return gitDestination_ == null
            ? com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination
                .getDefaultInstance()
            : gitDestination_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Git branch to export the agent to.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination git_destination = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination,
            com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination.Builder,
            com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestinationOrBuilder>
        getGitDestinationFieldBuilder() {
      if (gitDestinationBuilder_ == null) {
        gitDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination,
                com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestination.Builder,
                com.google.cloud.dialogflow.cx.v3.ExportAgentRequest.GitDestinationOrBuilder>(
                getGitDestination(), getParentForChildren(), isClean());
        gitDestination_ = null;
      }
      return gitDestinationBuilder_;
    }

    private boolean includeBigqueryExportSettings_;
    /**
     *
     *
     * <pre>
     * Optional. Whether to include BigQuery Export setting.
     * </pre>
     *
     * <code>bool include_bigquery_export_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The includeBigqueryExportSettings.
     */
    @java.lang.Override
    public boolean getIncludeBigqueryExportSettings() {
      return includeBigqueryExportSettings_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether to include BigQuery Export setting.
     * </pre>
     *
     * <code>bool include_bigquery_export_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The includeBigqueryExportSettings to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeBigqueryExportSettings(boolean value) {

      includeBigqueryExportSettings_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether to include BigQuery Export setting.
     * </pre>
     *
     * <code>bool include_bigquery_export_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeBigqueryExportSettings() {
      bitField0_ = (bitField0_ & ~0x00000020);
      includeBigqueryExportSettings_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.ExportAgentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.ExportAgentRequest)
  private static final com.google.cloud.dialogflow.cx.v3.ExportAgentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.ExportAgentRequest();
  }

  public static com.google.cloud.dialogflow.cx.v3.ExportAgentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportAgentRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExportAgentRequest>() {
        @java.lang.Override
        public ExportAgentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportAgentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportAgentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ExportAgentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
