/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/session.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * The message returned from the DetectIntent method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.DetectIntentResponse}
 */
public final class DetectIntentResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.DetectIntentResponse)
    DetectIntentResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DetectIntentResponse.newBuilder() to construct.
  private DetectIntentResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DetectIntentResponse() {
    responseId_ = "";
    outputAudio_ = com.google.protobuf.ByteString.EMPTY;
    responseType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DetectIntentResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_DetectIntentResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_DetectIntentResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.class,
            com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents different DetectIntentResponse types.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType}
   */
  public enum ResponseType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. This should never happen.
     * </pre>
     *
     * <code>RESPONSE_TYPE_UNSPECIFIED = 0;</code>
     */
    RESPONSE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Partial response. e.g. Aggregated responses in a Fulfillment that enables
     * `return_partial_response` can be returned as partial response.
     * WARNING: partial response is not eligible for barge-in.
     * </pre>
     *
     * <code>PARTIAL = 1;</code>
     */
    PARTIAL(1),
    /**
     *
     *
     * <pre>
     * Final response.
     * </pre>
     *
     * <code>FINAL = 2;</code>
     */
    FINAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. This should never happen.
     * </pre>
     *
     * <code>RESPONSE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int RESPONSE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Partial response. e.g. Aggregated responses in a Fulfillment that enables
     * `return_partial_response` can be returned as partial response.
     * WARNING: partial response is not eligible for barge-in.
     * </pre>
     *
     * <code>PARTIAL = 1;</code>
     */
    public static final int PARTIAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Final response.
     * </pre>
     *
     * <code>FINAL = 2;</code>
     */
    public static final int FINAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResponseType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ResponseType forNumber(int value) {
      switch (value) {
        case 0:
          return RESPONSE_TYPE_UNSPECIFIED;
        case 1:
          return PARTIAL;
        case 2:
          return FINAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ResponseType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ResponseType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ResponseType>() {
          public ResponseType findValueByNumber(int number) {
            return ResponseType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ResponseType[] VALUES = values();

    public static ResponseType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ResponseType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType)
  }

  private int bitField0_;
  public static final int RESPONSE_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object responseId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The unique identifier of the response. It can be used to
   * locate a response in the training example set or for reporting issues.
   * </pre>
   *
   * <code>string response_id = 1;</code>
   *
   * @return The responseId.
   */
  @java.lang.Override
  public java.lang.String getResponseId() {
    java.lang.Object ref = responseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      responseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The unique identifier of the response. It can be used to
   * locate a response in the training example set or for reporting issues.
   * </pre>
   *
   * <code>string response_id = 1;</code>
   *
   * @return The bytes for responseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResponseIdBytes() {
    java.lang.Object ref = responseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      responseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_RESULT_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.cx.v3.QueryResult queryResult_;
  /**
   *
   *
   * <pre>
   * The result of the conversational query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.QueryResult query_result = 2;</code>
   *
   * @return Whether the queryResult field is set.
   */
  @java.lang.Override
  public boolean hasQueryResult() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The result of the conversational query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.QueryResult query_result = 2;</code>
   *
   * @return The queryResult.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryResult getQueryResult() {
    return queryResult_ == null
        ? com.google.cloud.dialogflow.cx.v3.QueryResult.getDefaultInstance()
        : queryResult_;
  }
  /**
   *
   *
   * <pre>
   * The result of the conversational query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.QueryResult query_result = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryResultOrBuilder getQueryResultOrBuilder() {
    return queryResult_ == null
        ? com.google.cloud.dialogflow.cx.v3.QueryResult.getDefaultInstance()
        : queryResult_;
  }

  public static final int OUTPUT_AUDIO_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString outputAudio_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The audio data bytes encoded as specified in the request.
   * Note: The output audio is generated based on the values of default platform
   * text responses found in the
   * [`query_result.response_messages`][google.cloud.dialogflow.cx.v3.QueryResult.response_messages]
   * field. If multiple default text responses exist, they will be concatenated
   * when generating audio. If no default platform text responses exist, the
   * generated audio content will be empty.
   *
   * In some scenarios, multiple output audio fields may be present in the
   * response structure. In these cases, only the top-most-level audio output
   * has content.
   * </pre>
   *
   * <code>bytes output_audio = 4;</code>
   *
   * @return The outputAudio.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputAudio() {
    return outputAudio_;
  }

  public static final int OUTPUT_AUDIO_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.cx.v3.OutputAudioConfig outputAudioConfig_;
  /**
   *
   *
   * <pre>
   * The config used by the speech synthesizer to generate the output audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 5;</code>
   *
   * @return Whether the outputAudioConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputAudioConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The config used by the speech synthesizer to generate the output audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 5;</code>
   *
   * @return The outputAudioConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.OutputAudioConfig getOutputAudioConfig() {
    return outputAudioConfig_ == null
        ? com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.getDefaultInstance()
        : outputAudioConfig_;
  }
  /**
   *
   *
   * <pre>
   * The config used by the speech synthesizer to generate the output audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.OutputAudioConfigOrBuilder
      getOutputAudioConfigOrBuilder() {
    return outputAudioConfig_ == null
        ? com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.getDefaultInstance()
        : outputAudioConfig_;
  }

  public static final int RESPONSE_TYPE_FIELD_NUMBER = 6;
  private int responseType_ = 0;
  /**
   *
   *
   * <pre>
   * Response type.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType response_type = 6;
   * </code>
   *
   * @return The enum numeric value on the wire for responseType.
   */
  @java.lang.Override
  public int getResponseTypeValue() {
    return responseType_;
  }
  /**
   *
   *
   * <pre>
   * Response type.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType response_type = 6;
   * </code>
   *
   * @return The responseType.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType getResponseType() {
    com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType result =
        com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType.forNumber(
            responseType_);
    return result == null
        ? com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType.UNRECOGNIZED
        : result;
  }

  public static final int ALLOW_CANCELLATION_FIELD_NUMBER = 7;
  private boolean allowCancellation_ = false;
  /**
   *
   *
   * <pre>
   * Indicates whether the partial response can be cancelled when a later
   * response arrives. e.g. if the agent specified some music as partial
   * response, it can be cancelled.
   * </pre>
   *
   * <code>bool allow_cancellation = 7;</code>
   *
   * @return The allowCancellation.
   */
  @java.lang.Override
  public boolean getAllowCancellation() {
    return allowCancellation_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, responseId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getQueryResult());
    }
    if (!outputAudio_.isEmpty()) {
      output.writeBytes(4, outputAudio_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getOutputAudioConfig());
    }
    if (responseType_
        != com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType
            .RESPONSE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, responseType_);
    }
    if (allowCancellation_ != false) {
      output.writeBool(7, allowCancellation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, responseId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getQueryResult());
    }
    if (!outputAudio_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, outputAudio_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getOutputAudioConfig());
    }
    if (responseType_
        != com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType
            .RESPONSE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, responseType_);
    }
    if (allowCancellation_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, allowCancellation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.DetectIntentResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.DetectIntentResponse other =
        (com.google.cloud.dialogflow.cx.v3.DetectIntentResponse) obj;

    if (!getResponseId().equals(other.getResponseId())) return false;
    if (hasQueryResult() != other.hasQueryResult()) return false;
    if (hasQueryResult()) {
      if (!getQueryResult().equals(other.getQueryResult())) return false;
    }
    if (!getOutputAudio().equals(other.getOutputAudio())) return false;
    if (hasOutputAudioConfig() != other.hasOutputAudioConfig()) return false;
    if (hasOutputAudioConfig()) {
      if (!getOutputAudioConfig().equals(other.getOutputAudioConfig())) return false;
    }
    if (responseType_ != other.responseType_) return false;
    if (getAllowCancellation() != other.getAllowCancellation()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESPONSE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getResponseId().hashCode();
    if (hasQueryResult()) {
      hash = (37 * hash) + QUERY_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getQueryResult().hashCode();
    }
    hash = (37 * hash) + OUTPUT_AUDIO_FIELD_NUMBER;
    hash = (53 * hash) + getOutputAudio().hashCode();
    if (hasOutputAudioConfig()) {
      hash = (37 * hash) + OUTPUT_AUDIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputAudioConfig().hashCode();
    }
    hash = (37 * hash) + RESPONSE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + responseType_;
    hash = (37 * hash) + ALLOW_CANCELLATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowCancellation());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3.DetectIntentResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The message returned from the DetectIntent method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.DetectIntentResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.DetectIntentResponse)
      com.google.cloud.dialogflow.cx.v3.DetectIntentResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DetectIntentResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DetectIntentResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.class,
              com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getQueryResultFieldBuilder();
        getOutputAudioConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      responseId_ = "";
      queryResult_ = null;
      if (queryResultBuilder_ != null) {
        queryResultBuilder_.dispose();
        queryResultBuilder_ = null;
      }
      outputAudio_ = com.google.protobuf.ByteString.EMPTY;
      outputAudioConfig_ = null;
      if (outputAudioConfigBuilder_ != null) {
        outputAudioConfigBuilder_.dispose();
        outputAudioConfigBuilder_ = null;
      }
      responseType_ = 0;
      allowCancellation_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DetectIntentResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DetectIntentResponse getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DetectIntentResponse build() {
      com.google.cloud.dialogflow.cx.v3.DetectIntentResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DetectIntentResponse buildPartial() {
      com.google.cloud.dialogflow.cx.v3.DetectIntentResponse result =
          new com.google.cloud.dialogflow.cx.v3.DetectIntentResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.DetectIntentResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.responseId_ = responseId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.queryResult_ =
            queryResultBuilder_ == null ? queryResult_ : queryResultBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.outputAudio_ = outputAudio_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.outputAudioConfig_ =
            outputAudioConfigBuilder_ == null
                ? outputAudioConfig_
                : outputAudioConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.responseType_ = responseType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.allowCancellation_ = allowCancellation_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.DetectIntentResponse) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.DetectIntentResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.DetectIntentResponse other) {
      if (other == com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.getDefaultInstance())
        return this;
      if (!other.getResponseId().isEmpty()) {
        responseId_ = other.responseId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasQueryResult()) {
        mergeQueryResult(other.getQueryResult());
      }
      if (other.getOutputAudio() != com.google.protobuf.ByteString.EMPTY) {
        setOutputAudio(other.getOutputAudio());
      }
      if (other.hasOutputAudioConfig()) {
        mergeOutputAudioConfig(other.getOutputAudioConfig());
      }
      if (other.responseType_ != 0) {
        setResponseTypeValue(other.getResponseTypeValue());
      }
      if (other.getAllowCancellation() != false) {
        setAllowCancellation(other.getAllowCancellation());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                responseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getQueryResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                outputAudio_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getOutputAudioConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 48:
              {
                responseType_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 56:
              {
                allowCancellation_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object responseId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @return The responseId.
     */
    public java.lang.String getResponseId() {
      java.lang.Object ref = responseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        responseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @return The bytes for responseId.
     */
    public com.google.protobuf.ByteString getResponseIdBytes() {
      java.lang.Object ref = responseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        responseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @param value The responseId to set.
     * @return This builder for chaining.
     */
    public Builder setResponseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      responseId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseId() {
      responseId_ = getDefaultInstance().getResponseId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @param value The bytes for responseId to set.
     * @return This builder for chaining.
     */
    public Builder setResponseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      responseId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.QueryResult queryResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.QueryResult,
            com.google.cloud.dialogflow.cx.v3.QueryResult.Builder,
            com.google.cloud.dialogflow.cx.v3.QueryResultOrBuilder>
        queryResultBuilder_;
    /**
     *
     *
     * <pre>
     * The result of the conversational query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryResult query_result = 2;</code>
     *
     * @return Whether the queryResult field is set.
     */
    public boolean hasQueryResult() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryResult query_result = 2;</code>
     *
     * @return The queryResult.
     */
    public com.google.cloud.dialogflow.cx.v3.QueryResult getQueryResult() {
      if (queryResultBuilder_ == null) {
        return queryResult_ == null
            ? com.google.cloud.dialogflow.cx.v3.QueryResult.getDefaultInstance()
            : queryResult_;
      } else {
        return queryResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryResult query_result = 2;</code>
     */
    public Builder setQueryResult(com.google.cloud.dialogflow.cx.v3.QueryResult value) {
      if (queryResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryResult_ = value;
      } else {
        queryResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryResult query_result = 2;</code>
     */
    public Builder setQueryResult(
        com.google.cloud.dialogflow.cx.v3.QueryResult.Builder builderForValue) {
      if (queryResultBuilder_ == null) {
        queryResult_ = builderForValue.build();
      } else {
        queryResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryResult query_result = 2;</code>
     */
    public Builder mergeQueryResult(com.google.cloud.dialogflow.cx.v3.QueryResult value) {
      if (queryResultBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && queryResult_ != null
            && queryResult_ != com.google.cloud.dialogflow.cx.v3.QueryResult.getDefaultInstance()) {
          getQueryResultBuilder().mergeFrom(value);
        } else {
          queryResult_ = value;
        }
      } else {
        queryResultBuilder_.mergeFrom(value);
      }
      if (queryResult_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryResult query_result = 2;</code>
     */
    public Builder clearQueryResult() {
      bitField0_ = (bitField0_ & ~0x00000002);
      queryResult_ = null;
      if (queryResultBuilder_ != null) {
        queryResultBuilder_.dispose();
        queryResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryResult query_result = 2;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.QueryResult.Builder getQueryResultBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getQueryResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryResult query_result = 2;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.QueryResultOrBuilder getQueryResultOrBuilder() {
      if (queryResultBuilder_ != null) {
        return queryResultBuilder_.getMessageOrBuilder();
      } else {
        return queryResult_ == null
            ? com.google.cloud.dialogflow.cx.v3.QueryResult.getDefaultInstance()
            : queryResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryResult query_result = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.QueryResult,
            com.google.cloud.dialogflow.cx.v3.QueryResult.Builder,
            com.google.cloud.dialogflow.cx.v3.QueryResultOrBuilder>
        getQueryResultFieldBuilder() {
      if (queryResultBuilder_ == null) {
        queryResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.QueryResult,
                com.google.cloud.dialogflow.cx.v3.QueryResult.Builder,
                com.google.cloud.dialogflow.cx.v3.QueryResultOrBuilder>(
                getQueryResult(), getParentForChildren(), isClean());
        queryResult_ = null;
      }
      return queryResultBuilder_;
    }

    private com.google.protobuf.ByteString outputAudio_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in the request.
     * Note: The output audio is generated based on the values of default platform
     * text responses found in the
     * [`query_result.response_messages`][google.cloud.dialogflow.cx.v3.QueryResult.response_messages]
     * field. If multiple default text responses exist, they will be concatenated
     * when generating audio. If no default platform text responses exist, the
     * generated audio content will be empty.
     *
     * In some scenarios, multiple output audio fields may be present in the
     * response structure. In these cases, only the top-most-level audio output
     * has content.
     * </pre>
     *
     * <code>bytes output_audio = 4;</code>
     *
     * @return The outputAudio.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOutputAudio() {
      return outputAudio_;
    }
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in the request.
     * Note: The output audio is generated based on the values of default platform
     * text responses found in the
     * [`query_result.response_messages`][google.cloud.dialogflow.cx.v3.QueryResult.response_messages]
     * field. If multiple default text responses exist, they will be concatenated
     * when generating audio. If no default platform text responses exist, the
     * generated audio content will be empty.
     *
     * In some scenarios, multiple output audio fields may be present in the
     * response structure. In these cases, only the top-most-level audio output
     * has content.
     * </pre>
     *
     * <code>bytes output_audio = 4;</code>
     *
     * @param value The outputAudio to set.
     * @return This builder for chaining.
     */
    public Builder setOutputAudio(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      outputAudio_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in the request.
     * Note: The output audio is generated based on the values of default platform
     * text responses found in the
     * [`query_result.response_messages`][google.cloud.dialogflow.cx.v3.QueryResult.response_messages]
     * field. If multiple default text responses exist, they will be concatenated
     * when generating audio. If no default platform text responses exist, the
     * generated audio content will be empty.
     *
     * In some scenarios, multiple output audio fields may be present in the
     * response structure. In these cases, only the top-most-level audio output
     * has content.
     * </pre>
     *
     * <code>bytes output_audio = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputAudio() {
      bitField0_ = (bitField0_ & ~0x00000004);
      outputAudio_ = getDefaultInstance().getOutputAudio();
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.OutputAudioConfig outputAudioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.OutputAudioConfig,
            com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.cx.v3.OutputAudioConfigOrBuilder>
        outputAudioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 5;</code>
     *
     * @return Whether the outputAudioConfig field is set.
     */
    public boolean hasOutputAudioConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 5;</code>
     *
     * @return The outputAudioConfig.
     */
    public com.google.cloud.dialogflow.cx.v3.OutputAudioConfig getOutputAudioConfig() {
      if (outputAudioConfigBuilder_ == null) {
        return outputAudioConfig_ == null
            ? com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.getDefaultInstance()
            : outputAudioConfig_;
      } else {
        return outputAudioConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 5;</code>
     */
    public Builder setOutputAudioConfig(com.google.cloud.dialogflow.cx.v3.OutputAudioConfig value) {
      if (outputAudioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputAudioConfig_ = value;
      } else {
        outputAudioConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 5;</code>
     */
    public Builder setOutputAudioConfig(
        com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.Builder builderForValue) {
      if (outputAudioConfigBuilder_ == null) {
        outputAudioConfig_ = builderForValue.build();
      } else {
        outputAudioConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 5;</code>
     */
    public Builder mergeOutputAudioConfig(
        com.google.cloud.dialogflow.cx.v3.OutputAudioConfig value) {
      if (outputAudioConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && outputAudioConfig_ != null
            && outputAudioConfig_
                != com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.getDefaultInstance()) {
          getOutputAudioConfigBuilder().mergeFrom(value);
        } else {
          outputAudioConfig_ = value;
        }
      } else {
        outputAudioConfigBuilder_.mergeFrom(value);
      }
      if (outputAudioConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 5;</code>
     */
    public Builder clearOutputAudioConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      outputAudioConfig_ = null;
      if (outputAudioConfigBuilder_ != null) {
        outputAudioConfigBuilder_.dispose();
        outputAudioConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.Builder
        getOutputAudioConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getOutputAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 5;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.OutputAudioConfigOrBuilder
        getOutputAudioConfigOrBuilder() {
      if (outputAudioConfigBuilder_ != null) {
        return outputAudioConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputAudioConfig_ == null
            ? com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.getDefaultInstance()
            : outputAudioConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.OutputAudioConfig,
            com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.cx.v3.OutputAudioConfigOrBuilder>
        getOutputAudioConfigFieldBuilder() {
      if (outputAudioConfigBuilder_ == null) {
        outputAudioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.OutputAudioConfig,
                com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.Builder,
                com.google.cloud.dialogflow.cx.v3.OutputAudioConfigOrBuilder>(
                getOutputAudioConfig(), getParentForChildren(), isClean());
        outputAudioConfig_ = null;
      }
      return outputAudioConfigBuilder_;
    }

    private int responseType_ = 0;
    /**
     *
     *
     * <pre>
     * Response type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType response_type = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for responseType.
     */
    @java.lang.Override
    public int getResponseTypeValue() {
      return responseType_;
    }
    /**
     *
     *
     * <pre>
     * Response type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType response_type = 6;
     * </code>
     *
     * @param value The enum numeric value on the wire for responseType to set.
     * @return This builder for chaining.
     */
    public Builder setResponseTypeValue(int value) {
      responseType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType response_type = 6;
     * </code>
     *
     * @return The responseType.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType getResponseType() {
      com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType result =
          com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType.forNumber(
              responseType_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Response type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType response_type = 6;
     * </code>
     *
     * @param value The responseType to set.
     * @return This builder for chaining.
     */
    public Builder setResponseType(
        com.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      responseType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response type.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.DetectIntentResponse.ResponseType response_type = 6;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      responseType_ = 0;
      onChanged();
      return this;
    }

    private boolean allowCancellation_;
    /**
     *
     *
     * <pre>
     * Indicates whether the partial response can be cancelled when a later
     * response arrives. e.g. if the agent specified some music as partial
     * response, it can be cancelled.
     * </pre>
     *
     * <code>bool allow_cancellation = 7;</code>
     *
     * @return The allowCancellation.
     */
    @java.lang.Override
    public boolean getAllowCancellation() {
      return allowCancellation_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the partial response can be cancelled when a later
     * response arrives. e.g. if the agent specified some music as partial
     * response, it can be cancelled.
     * </pre>
     *
     * <code>bool allow_cancellation = 7;</code>
     *
     * @param value The allowCancellation to set.
     * @return This builder for chaining.
     */
    public Builder setAllowCancellation(boolean value) {

      allowCancellation_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the partial response can be cancelled when a later
     * response arrives. e.g. if the agent specified some music as partial
     * response, it can be cancelled.
     * </pre>
     *
     * <code>bool allow_cancellation = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowCancellation() {
      bitField0_ = (bitField0_ & ~0x00000020);
      allowCancellation_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.DetectIntentResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.DetectIntentResponse)
  private static final com.google.cloud.dialogflow.cx.v3.DetectIntentResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.DetectIntentResponse();
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DetectIntentResponse> PARSER =
      new com.google.protobuf.AbstractParser<DetectIntentResponse>() {
        @java.lang.Override
        public DetectIntentResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DetectIntentResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DetectIntentResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DetectIntentResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
