/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/session.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * The request to detect user's intent.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.DetectIntentRequest}
 */
public final class DetectIntentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.DetectIntentRequest)
    DetectIntentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DetectIntentRequest.newBuilder() to construct.
  private DetectIntentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DetectIntentRequest() {
    session_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DetectIntentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_DetectIntentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_DetectIntentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.DetectIntentRequest.class,
            com.google.cloud.dialogflow.cx.v3.DetectIntentRequest.Builder.class);
  }

  private int bitField0_;
  public static final int SESSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object session_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the session this query is sent to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;Session
   * ID&gt;` or
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
   * If `Environment ID` is not specified, we assume default 'draft'
   * environment.
   * It's up to the API caller to choose an appropriate `Session ID`. It can be
   * a random number or some type of session identifiers (preferably hashed).
   * The length of the `Session ID` must not exceed 36 characters.
   *
   * For more information, see the [sessions
   * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
   *
   * Note: Always use agent versions for production traffic.
   * See [Versions and
   * environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the session this query is sent to.
   * Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;Session
   * ID&gt;` or
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
   * If `Environment ID` is not specified, we assume default 'draft'
   * environment.
   * It's up to the API caller to choose an appropriate `Session ID`. It can be
   * a random number or some type of session identifiers (preferably hashed).
   * The length of the `Session ID` must not exceed 36 characters.
   *
   * For more information, see the [sessions
   * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
   *
   * Note: Always use agent versions for production traffic.
   * See [Versions and
   * environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_PARAMS_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.cx.v3.QueryParameters queryParams_;
  /**
   *
   *
   * <pre>
   * The parameters of this query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
   *
   * @return Whether the queryParams field is set.
   */
  @java.lang.Override
  public boolean hasQueryParams() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The parameters of this query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
   *
   * @return The queryParams.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryParameters getQueryParams() {
    return queryParams_ == null
        ? com.google.cloud.dialogflow.cx.v3.QueryParameters.getDefaultInstance()
        : queryParams_;
  }
  /**
   *
   *
   * <pre>
   * The parameters of this query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryParametersOrBuilder getQueryParamsOrBuilder() {
    return queryParams_ == null
        ? com.google.cloud.dialogflow.cx.v3.QueryParameters.getDefaultInstance()
        : queryParams_;
  }

  public static final int QUERY_INPUT_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.cx.v3.QueryInput queryInput_;
  /**
   *
   *
   * <pre>
   * Required. The input specification.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the queryInput field is set.
   */
  @java.lang.Override
  public boolean hasQueryInput() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The input specification.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The queryInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryInput getQueryInput() {
    return queryInput_ == null
        ? com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()
        : queryInput_;
  }
  /**
   *
   *
   * <pre>
   * Required. The input specification.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder getQueryInputOrBuilder() {
    return queryInput_ == null
        ? com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()
        : queryInput_;
  }

  public static final int OUTPUT_AUDIO_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.cx.v3.OutputAudioConfig outputAudioConfig_;
  /**
   *
   *
   * <pre>
   * Instructs the speech synthesizer how to generate the output audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 4;</code>
   *
   * @return Whether the outputAudioConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputAudioConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Instructs the speech synthesizer how to generate the output audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 4;</code>
   *
   * @return The outputAudioConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.OutputAudioConfig getOutputAudioConfig() {
    return outputAudioConfig_ == null
        ? com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.getDefaultInstance()
        : outputAudioConfig_;
  }
  /**
   *
   *
   * <pre>
   * Instructs the speech synthesizer how to generate the output audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.OutputAudioConfigOrBuilder
      getOutputAudioConfigOrBuilder() {
    return outputAudioConfig_ == null
        ? com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.getDefaultInstance()
        : outputAudioConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, session_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getQueryParams());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getQueryInput());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getOutputAudioConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, session_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getQueryParams());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getQueryInput());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getOutputAudioConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.DetectIntentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.DetectIntentRequest other =
        (com.google.cloud.dialogflow.cx.v3.DetectIntentRequest) obj;

    if (!getSession().equals(other.getSession())) return false;
    if (hasQueryParams() != other.hasQueryParams()) return false;
    if (hasQueryParams()) {
      if (!getQueryParams().equals(other.getQueryParams())) return false;
    }
    if (hasQueryInput() != other.hasQueryInput()) return false;
    if (hasQueryInput()) {
      if (!getQueryInput().equals(other.getQueryInput())) return false;
    }
    if (hasOutputAudioConfig() != other.hasOutputAudioConfig()) return false;
    if (hasOutputAudioConfig()) {
      if (!getOutputAudioConfig().equals(other.getOutputAudioConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    if (hasQueryParams()) {
      hash = (37 * hash) + QUERY_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getQueryParams().hashCode();
    }
    if (hasQueryInput()) {
      hash = (37 * hash) + QUERY_INPUT_FIELD_NUMBER;
      hash = (53 * hash) + getQueryInput().hashCode();
    }
    if (hasOutputAudioConfig()) {
      hash = (37 * hash) + OUTPUT_AUDIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputAudioConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3.DetectIntentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request to detect user's intent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.DetectIntentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.DetectIntentRequest)
      com.google.cloud.dialogflow.cx.v3.DetectIntentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DetectIntentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DetectIntentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.DetectIntentRequest.class,
              com.google.cloud.dialogflow.cx.v3.DetectIntentRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.DetectIntentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getQueryParamsFieldBuilder();
        getQueryInputFieldBuilder();
        getOutputAudioConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      session_ = "";
      queryParams_ = null;
      if (queryParamsBuilder_ != null) {
        queryParamsBuilder_.dispose();
        queryParamsBuilder_ = null;
      }
      queryInput_ = null;
      if (queryInputBuilder_ != null) {
        queryInputBuilder_.dispose();
        queryInputBuilder_ = null;
      }
      outputAudioConfig_ = null;
      if (outputAudioConfigBuilder_ != null) {
        outputAudioConfigBuilder_.dispose();
        outputAudioConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DetectIntentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DetectIntentRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.DetectIntentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DetectIntentRequest build() {
      com.google.cloud.dialogflow.cx.v3.DetectIntentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DetectIntentRequest buildPartial() {
      com.google.cloud.dialogflow.cx.v3.DetectIntentRequest result =
          new com.google.cloud.dialogflow.cx.v3.DetectIntentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.DetectIntentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.session_ = session_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.queryParams_ =
            queryParamsBuilder_ == null ? queryParams_ : queryParamsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.queryInput_ = queryInputBuilder_ == null ? queryInput_ : queryInputBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.outputAudioConfig_ =
            outputAudioConfigBuilder_ == null
                ? outputAudioConfig_
                : outputAudioConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.DetectIntentRequest) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.DetectIntentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.DetectIntentRequest other) {
      if (other == com.google.cloud.dialogflow.cx.v3.DetectIntentRequest.getDefaultInstance())
        return this;
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasQueryParams()) {
        mergeQueryParams(other.getQueryParams());
      }
      if (other.hasQueryInput()) {
        mergeQueryInput(other.getQueryInput());
      }
      if (other.hasOutputAudioConfig()) {
        mergeOutputAudioConfig(other.getOutputAudioConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                session_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getQueryParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getQueryInputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getOutputAudioConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object session_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the session this query is sent to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;Session
     * ID&gt;` or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * It's up to the API caller to choose an appropriate `Session ID`. It can be
     * a random number or some type of session identifiers (preferably hashed).
     * The length of the `Session ID` must not exceed 36 characters.
     *
     * For more information, see the [sessions
     * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The session.
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the session this query is sent to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;Session
     * ID&gt;` or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * It's up to the API caller to choose an appropriate `Session ID`. It can be
     * a random number or some type of session identifiers (preferably hashed).
     * The length of the `Session ID` must not exceed 36 characters.
     *
     * For more information, see the [sessions
     * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for session.
     */
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the session this query is sent to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;Session
     * ID&gt;` or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * It's up to the API caller to choose an appropriate `Session ID`. It can be
     * a random number or some type of session identifiers (preferably hashed).
     * The length of the `Session ID` must not exceed 36 characters.
     *
     * For more information, see the [sessions
     * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The session to set.
     * @return This builder for chaining.
     */
    public Builder setSession(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the session this query is sent to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;Session
     * ID&gt;` or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * It's up to the API caller to choose an appropriate `Session ID`. It can be
     * a random number or some type of session identifiers (preferably hashed).
     * The length of the `Session ID` must not exceed 36 characters.
     *
     * For more information, see the [sessions
     * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSession() {
      session_ = getDefaultInstance().getSession();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the session this query is sent to.
     * Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/sessions/&lt;Session
     * ID&gt;` or
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/environments/&lt;EnvironmentID&gt;/sessions/&lt;SessionID&gt;`.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment.
     * It's up to the API caller to choose an appropriate `Session ID`. It can be
     * a random number or some type of session identifiers (preferably hashed).
     * The length of the `Session ID` must not exceed 36 characters.
     *
     * For more information, see the [sessions
     * guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for session to set.
     * @return This builder for chaining.
     */
    public Builder setSessionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.QueryParameters queryParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.QueryParameters,
            com.google.cloud.dialogflow.cx.v3.QueryParameters.Builder,
            com.google.cloud.dialogflow.cx.v3.QueryParametersOrBuilder>
        queryParamsBuilder_;
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     *
     * @return Whether the queryParams field is set.
     */
    public boolean hasQueryParams() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     *
     * @return The queryParams.
     */
    public com.google.cloud.dialogflow.cx.v3.QueryParameters getQueryParams() {
      if (queryParamsBuilder_ == null) {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.cx.v3.QueryParameters.getDefaultInstance()
            : queryParams_;
      } else {
        return queryParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    public Builder setQueryParams(com.google.cloud.dialogflow.cx.v3.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryParams_ = value;
      } else {
        queryParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    public Builder setQueryParams(
        com.google.cloud.dialogflow.cx.v3.QueryParameters.Builder builderForValue) {
      if (queryParamsBuilder_ == null) {
        queryParams_ = builderForValue.build();
      } else {
        queryParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    public Builder mergeQueryParams(com.google.cloud.dialogflow.cx.v3.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && queryParams_ != null
            && queryParams_
                != com.google.cloud.dialogflow.cx.v3.QueryParameters.getDefaultInstance()) {
          getQueryParamsBuilder().mergeFrom(value);
        } else {
          queryParams_ = value;
        }
      } else {
        queryParamsBuilder_.mergeFrom(value);
      }
      if (queryParams_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    public Builder clearQueryParams() {
      bitField0_ = (bitField0_ & ~0x00000002);
      queryParams_ = null;
      if (queryParamsBuilder_ != null) {
        queryParamsBuilder_.dispose();
        queryParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.QueryParameters.Builder getQueryParamsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getQueryParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.QueryParametersOrBuilder getQueryParamsOrBuilder() {
      if (queryParamsBuilder_ != null) {
        return queryParamsBuilder_.getMessageOrBuilder();
      } else {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.cx.v3.QueryParameters.getDefaultInstance()
            : queryParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryParameters query_params = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.QueryParameters,
            com.google.cloud.dialogflow.cx.v3.QueryParameters.Builder,
            com.google.cloud.dialogflow.cx.v3.QueryParametersOrBuilder>
        getQueryParamsFieldBuilder() {
      if (queryParamsBuilder_ == null) {
        queryParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.QueryParameters,
                com.google.cloud.dialogflow.cx.v3.QueryParameters.Builder,
                com.google.cloud.dialogflow.cx.v3.QueryParametersOrBuilder>(
                getQueryParams(), getParentForChildren(), isClean());
        queryParams_ = null;
      }
      return queryParamsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.QueryInput queryInput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.QueryInput,
            com.google.cloud.dialogflow.cx.v3.QueryInput.Builder,
            com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder>
        queryInputBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the queryInput field is set.
     */
    public boolean hasQueryInput() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The queryInput.
     */
    public com.google.cloud.dialogflow.cx.v3.QueryInput getQueryInput() {
      if (queryInputBuilder_ == null) {
        return queryInput_ == null
            ? com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()
            : queryInput_;
      } else {
        return queryInputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQueryInput(com.google.cloud.dialogflow.cx.v3.QueryInput value) {
      if (queryInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryInput_ = value;
      } else {
        queryInputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQueryInput(
        com.google.cloud.dialogflow.cx.v3.QueryInput.Builder builderForValue) {
      if (queryInputBuilder_ == null) {
        queryInput_ = builderForValue.build();
      } else {
        queryInputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeQueryInput(com.google.cloud.dialogflow.cx.v3.QueryInput value) {
      if (queryInputBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && queryInput_ != null
            && queryInput_ != com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()) {
          getQueryInputBuilder().mergeFrom(value);
        } else {
          queryInput_ = value;
        }
      } else {
        queryInputBuilder_.mergeFrom(value);
      }
      if (queryInput_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearQueryInput() {
      bitField0_ = (bitField0_ & ~0x00000004);
      queryInput_ = null;
      if (queryInputBuilder_ != null) {
        queryInputBuilder_.dispose();
        queryInputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.QueryInput.Builder getQueryInputBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getQueryInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder getQueryInputOrBuilder() {
      if (queryInputBuilder_ != null) {
        return queryInputBuilder_.getMessageOrBuilder();
      } else {
        return queryInput_ == null
            ? com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()
            : queryInput_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.QueryInput,
            com.google.cloud.dialogflow.cx.v3.QueryInput.Builder,
            com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder>
        getQueryInputFieldBuilder() {
      if (queryInputBuilder_ == null) {
        queryInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.QueryInput,
                com.google.cloud.dialogflow.cx.v3.QueryInput.Builder,
                com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder>(
                getQueryInput(), getParentForChildren(), isClean());
        queryInput_ = null;
      }
      return queryInputBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.OutputAudioConfig outputAudioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.OutputAudioConfig,
            com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.cx.v3.OutputAudioConfigOrBuilder>
        outputAudioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 4;</code>
     *
     * @return Whether the outputAudioConfig field is set.
     */
    public boolean hasOutputAudioConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 4;</code>
     *
     * @return The outputAudioConfig.
     */
    public com.google.cloud.dialogflow.cx.v3.OutputAudioConfig getOutputAudioConfig() {
      if (outputAudioConfigBuilder_ == null) {
        return outputAudioConfig_ == null
            ? com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.getDefaultInstance()
            : outputAudioConfig_;
      } else {
        return outputAudioConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 4;</code>
     */
    public Builder setOutputAudioConfig(com.google.cloud.dialogflow.cx.v3.OutputAudioConfig value) {
      if (outputAudioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputAudioConfig_ = value;
      } else {
        outputAudioConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 4;</code>
     */
    public Builder setOutputAudioConfig(
        com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.Builder builderForValue) {
      if (outputAudioConfigBuilder_ == null) {
        outputAudioConfig_ = builderForValue.build();
      } else {
        outputAudioConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 4;</code>
     */
    public Builder mergeOutputAudioConfig(
        com.google.cloud.dialogflow.cx.v3.OutputAudioConfig value) {
      if (outputAudioConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && outputAudioConfig_ != null
            && outputAudioConfig_
                != com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.getDefaultInstance()) {
          getOutputAudioConfigBuilder().mergeFrom(value);
        } else {
          outputAudioConfig_ = value;
        }
      } else {
        outputAudioConfigBuilder_.mergeFrom(value);
      }
      if (outputAudioConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 4;</code>
     */
    public Builder clearOutputAudioConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      outputAudioConfig_ = null;
      if (outputAudioConfigBuilder_ != null) {
        outputAudioConfigBuilder_.dispose();
        outputAudioConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.Builder
        getOutputAudioConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getOutputAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 4;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.OutputAudioConfigOrBuilder
        getOutputAudioConfigOrBuilder() {
      if (outputAudioConfigBuilder_ != null) {
        return outputAudioConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputAudioConfig_ == null
            ? com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.getDefaultInstance()
            : outputAudioConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.OutputAudioConfig output_audio_config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.OutputAudioConfig,
            com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.cx.v3.OutputAudioConfigOrBuilder>
        getOutputAudioConfigFieldBuilder() {
      if (outputAudioConfigBuilder_ == null) {
        outputAudioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.OutputAudioConfig,
                com.google.cloud.dialogflow.cx.v3.OutputAudioConfig.Builder,
                com.google.cloud.dialogflow.cx.v3.OutputAudioConfigOrBuilder>(
                getOutputAudioConfig(), getParentForChildren(), isClean());
        outputAudioConfig_ = null;
      }
      return outputAudioConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.DetectIntentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.DetectIntentRequest)
  private static final com.google.cloud.dialogflow.cx.v3.DetectIntentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.DetectIntentRequest();
  }

  public static com.google.cloud.dialogflow.cx.v3.DetectIntentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DetectIntentRequest> PARSER =
      new com.google.protobuf.AbstractParser<DetectIntentRequest>() {
        @java.lang.Override
        public DetectIntentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DetectIntentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DetectIntentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DetectIntentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
