/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/data_store_connection.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Data store connection feature output signals.
 * Might be only partially field if processing stop before the final answer.
 * Reasons for this can be, but are not limited to: empty UCS search results,
 * positive RAI check outcome, grounding failure, ...
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals}
 */
public final class DataStoreConnectionSignals extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals)
    DataStoreConnectionSignalsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataStoreConnectionSignals.newBuilder() to construct.
  private DataStoreConnectionSignals(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataStoreConnectionSignals() {
    rewrittenQuery_ = "";
    searchSnippets_ = java.util.Collections.emptyList();
    answer_ = "";
    answerParts_ = java.util.Collections.emptyList();
    citedSnippets_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataStoreConnectionSignals();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
        .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
        .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.class,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.Builder.class);
  }

  public interface RewriterModelCallSignalsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Prompt as sent to the model.
     * </pre>
     *
     * <code>string rendered_prompt = 1;</code>
     *
     * @return The renderedPrompt.
     */
    java.lang.String getRenderedPrompt();
    /**
     *
     *
     * <pre>
     * Prompt as sent to the model.
     * </pre>
     *
     * <code>string rendered_prompt = 1;</code>
     *
     * @return The bytes for renderedPrompt.
     */
    com.google.protobuf.ByteString getRenderedPromptBytes();

    /**
     *
     *
     * <pre>
     * Output of the generative model.
     * </pre>
     *
     * <code>string model_output = 2;</code>
     *
     * @return The modelOutput.
     */
    java.lang.String getModelOutput();
    /**
     *
     *
     * <pre>
     * Output of the generative model.
     * </pre>
     *
     * <code>string model_output = 2;</code>
     *
     * @return The bytes for modelOutput.
     */
    com.google.protobuf.ByteString getModelOutputBytes();

    /**
     *
     *
     * <pre>
     * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
     * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @return The model.
     */
    java.lang.String getModel();
    /**
     *
     *
     * <pre>
     * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
     * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @return The bytes for model.
     */
    com.google.protobuf.ByteString getModelBytes();
  }
  /**
   *
   *
   * <pre>
   * Diagnostic info related to the rewriter model call.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals}
   */
  public static final class RewriterModelCallSignals extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals)
      RewriterModelCallSignalsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RewriterModelCallSignals.newBuilder() to construct.
    private RewriterModelCallSignals(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RewriterModelCallSignals() {
      renderedPrompt_ = "";
      modelOutput_ = "";
      model_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RewriterModelCallSignals();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_RewriterModelCallSignals_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_RewriterModelCallSignals_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
                  .class,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
                  .Builder.class);
    }

    public static final int RENDERED_PROMPT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object renderedPrompt_ = "";
    /**
     *
     *
     * <pre>
     * Prompt as sent to the model.
     * </pre>
     *
     * <code>string rendered_prompt = 1;</code>
     *
     * @return The renderedPrompt.
     */
    @java.lang.Override
    public java.lang.String getRenderedPrompt() {
      java.lang.Object ref = renderedPrompt_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        renderedPrompt_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Prompt as sent to the model.
     * </pre>
     *
     * <code>string rendered_prompt = 1;</code>
     *
     * @return The bytes for renderedPrompt.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRenderedPromptBytes() {
      java.lang.Object ref = renderedPrompt_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        renderedPrompt_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODEL_OUTPUT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modelOutput_ = "";
    /**
     *
     *
     * <pre>
     * Output of the generative model.
     * </pre>
     *
     * <code>string model_output = 2;</code>
     *
     * @return The modelOutput.
     */
    @java.lang.Override
    public java.lang.String getModelOutput() {
      java.lang.Object ref = modelOutput_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelOutput_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output of the generative model.
     * </pre>
     *
     * <code>string model_output = 2;</code>
     *
     * @return The bytes for modelOutput.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelOutputBytes() {
      java.lang.Object ref = modelOutput_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelOutput_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODEL_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
     * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @return The model.
     */
    @java.lang.Override
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
     * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @return The bytes for model.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(renderedPrompt_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, renderedPrompt_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelOutput_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, modelOutput_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, model_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(renderedPrompt_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, renderedPrompt_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelOutput_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, modelOutput_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, model_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals other =
          (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals)
              obj;

      if (!getRenderedPrompt().equals(other.getRenderedPrompt())) return false;
      if (!getModelOutput().equals(other.getModelOutput())) return false;
      if (!getModel().equals(other.getModel())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RENDERED_PROMPT_FIELD_NUMBER;
      hash = (53 * hash) + getRenderedPrompt().hashCode();
      hash = (37 * hash) + MODEL_OUTPUT_FIELD_NUMBER;
      hash = (53 * hash) + getModelOutput().hashCode();
      hash = (37 * hash) + MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getModel().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Diagnostic info related to the rewriter model call.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals)
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignalsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_RewriterModelCallSignals_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_RewriterModelCallSignals_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .RewriterModelCallSignals.class,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .RewriterModelCallSignals.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        renderedPrompt_ = "";
        modelOutput_ = "";
        model_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_RewriterModelCallSignals_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
          build() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
            result =
                new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .RewriterModelCallSignals(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.renderedPrompt_ = renderedPrompt_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.modelOutput_ = modelOutput_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.model_ = model_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                      .RewriterModelCallSignals)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
              other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
                .getDefaultInstance()) return this;
        if (!other.getRenderedPrompt().isEmpty()) {
          renderedPrompt_ = other.renderedPrompt_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getModelOutput().isEmpty()) {
          modelOutput_ = other.modelOutput_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getModel().isEmpty()) {
          model_ = other.model_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  renderedPrompt_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  modelOutput_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  model_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object renderedPrompt_ = "";
      /**
       *
       *
       * <pre>
       * Prompt as sent to the model.
       * </pre>
       *
       * <code>string rendered_prompt = 1;</code>
       *
       * @return The renderedPrompt.
       */
      public java.lang.String getRenderedPrompt() {
        java.lang.Object ref = renderedPrompt_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          renderedPrompt_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Prompt as sent to the model.
       * </pre>
       *
       * <code>string rendered_prompt = 1;</code>
       *
       * @return The bytes for renderedPrompt.
       */
      public com.google.protobuf.ByteString getRenderedPromptBytes() {
        java.lang.Object ref = renderedPrompt_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          renderedPrompt_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Prompt as sent to the model.
       * </pre>
       *
       * <code>string rendered_prompt = 1;</code>
       *
       * @param value The renderedPrompt to set.
       * @return This builder for chaining.
       */
      public Builder setRenderedPrompt(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        renderedPrompt_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Prompt as sent to the model.
       * </pre>
       *
       * <code>string rendered_prompt = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRenderedPrompt() {
        renderedPrompt_ = getDefaultInstance().getRenderedPrompt();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Prompt as sent to the model.
       * </pre>
       *
       * <code>string rendered_prompt = 1;</code>
       *
       * @param value The bytes for renderedPrompt to set.
       * @return This builder for chaining.
       */
      public Builder setRenderedPromptBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        renderedPrompt_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object modelOutput_ = "";
      /**
       *
       *
       * <pre>
       * Output of the generative model.
       * </pre>
       *
       * <code>string model_output = 2;</code>
       *
       * @return The modelOutput.
       */
      public java.lang.String getModelOutput() {
        java.lang.Object ref = modelOutput_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelOutput_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output of the generative model.
       * </pre>
       *
       * <code>string model_output = 2;</code>
       *
       * @return The bytes for modelOutput.
       */
      public com.google.protobuf.ByteString getModelOutputBytes() {
        java.lang.Object ref = modelOutput_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelOutput_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output of the generative model.
       * </pre>
       *
       * <code>string model_output = 2;</code>
       *
       * @param value The modelOutput to set.
       * @return This builder for chaining.
       */
      public Builder setModelOutput(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelOutput_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output of the generative model.
       * </pre>
       *
       * <code>string model_output = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelOutput() {
        modelOutput_ = getDefaultInstance().getModelOutput();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output of the generative model.
       * </pre>
       *
       * <code>string model_output = 2;</code>
       *
       * @param value The bytes for modelOutput to set.
       * @return This builder for chaining.
       */
      public Builder setModelOutputBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelOutput_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object model_ = "";
      /**
       *
       *
       * <pre>
       * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
       * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
       * </pre>
       *
       * <code>string model = 3;</code>
       *
       * @return The model.
       */
      public java.lang.String getModel() {
        java.lang.Object ref = model_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          model_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
       * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
       * </pre>
       *
       * <code>string model = 3;</code>
       *
       * @return The bytes for model.
       */
      public com.google.protobuf.ByteString getModelBytes() {
        java.lang.Object ref = model_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          model_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
       * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
       * </pre>
       *
       * <code>string model = 3;</code>
       *
       * @param value The model to set.
       * @return This builder for chaining.
       */
      public Builder setModel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        model_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
       * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
       * </pre>
       *
       * <code>string model = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModel() {
        model_ = getDefaultInstance().getModel();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
       * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
       * </pre>
       *
       * <code>string model = 3;</code>
       *
       * @param value The bytes for model to set.
       * @return This builder for chaining.
       */
      public Builder setModelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        model_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals)
    private static final com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
              .RewriterModelCallSignals();
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignals
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RewriterModelCallSignals> PARSER =
        new com.google.protobuf.AbstractParser<RewriterModelCallSignals>() {
          @java.lang.Override
          public RewriterModelCallSignals parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RewriterModelCallSignals> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RewriterModelCallSignals> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SearchSnippetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Title of the enclosing document.
     * </pre>
     *
     * <code>string document_title = 1;</code>
     *
     * @return The documentTitle.
     */
    java.lang.String getDocumentTitle();
    /**
     *
     *
     * <pre>
     * Title of the enclosing document.
     * </pre>
     *
     * <code>string document_title = 1;</code>
     *
     * @return The bytes for documentTitle.
     */
    com.google.protobuf.ByteString getDocumentTitleBytes();

    /**
     *
     *
     * <pre>
     * Uri for the document. Present if specified for the document.
     * </pre>
     *
     * <code>string document_uri = 2;</code>
     *
     * @return The documentUri.
     */
    java.lang.String getDocumentUri();
    /**
     *
     *
     * <pre>
     * Uri for the document. Present if specified for the document.
     * </pre>
     *
     * <code>string document_uri = 2;</code>
     *
     * @return The bytes for documentUri.
     */
    com.google.protobuf.ByteString getDocumentUriBytes();

    /**
     *
     *
     * <pre>
     * Text included in the prompt.
     * </pre>
     *
     * <code>string text = 3;</code>
     *
     * @return The text.
     */
    java.lang.String getText();
    /**
     *
     *
     * <pre>
     * Text included in the prompt.
     * </pre>
     *
     * <code>string text = 3;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();
  }
  /**
   *
   *
   * <pre>
   * Search snippet details.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet}
   */
  public static final class SearchSnippet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet)
      SearchSnippetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SearchSnippet.newBuilder() to construct.
    private SearchSnippet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SearchSnippet() {
      documentTitle_ = "";
      documentUri_ = "";
      text_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SearchSnippet();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_SearchSnippet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_SearchSnippet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.class,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder
                  .class);
    }

    public static final int DOCUMENT_TITLE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object documentTitle_ = "";
    /**
     *
     *
     * <pre>
     * Title of the enclosing document.
     * </pre>
     *
     * <code>string document_title = 1;</code>
     *
     * @return The documentTitle.
     */
    @java.lang.Override
    public java.lang.String getDocumentTitle() {
      java.lang.Object ref = documentTitle_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        documentTitle_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Title of the enclosing document.
     * </pre>
     *
     * <code>string document_title = 1;</code>
     *
     * @return The bytes for documentTitle.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDocumentTitleBytes() {
      java.lang.Object ref = documentTitle_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        documentTitle_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DOCUMENT_URI_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object documentUri_ = "";
    /**
     *
     *
     * <pre>
     * Uri for the document. Present if specified for the document.
     * </pre>
     *
     * <code>string document_uri = 2;</code>
     *
     * @return The documentUri.
     */
    @java.lang.Override
    public java.lang.String getDocumentUri() {
      java.lang.Object ref = documentUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        documentUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Uri for the document. Present if specified for the document.
     * </pre>
     *
     * <code>string document_uri = 2;</code>
     *
     * @return The bytes for documentUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDocumentUriBytes() {
      java.lang.Object ref = documentUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        documentUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TEXT_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object text_ = "";
    /**
     *
     *
     * <pre>
     * Text included in the prompt.
     * </pre>
     *
     * <code>string text = 3;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Text included in the prompt.
     * </pre>
     *
     * <code>string text = 3;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentTitle_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, documentTitle_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, documentUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, text_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentTitle_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, documentTitle_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, documentUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, text_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet other =
          (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet) obj;

      if (!getDocumentTitle().equals(other.getDocumentTitle())) return false;
      if (!getDocumentUri().equals(other.getDocumentUri())) return false;
      if (!getText().equals(other.getText())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DOCUMENT_TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentTitle().hashCode();
      hash = (37 * hash) + DOCUMENT_URI_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentUri().hashCode();
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Search snippet details.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet)
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_SearchSnippet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_SearchSnippet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.class,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        documentTitle_ = "";
        documentUri_ = "";
        text_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_SearchSnippet_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet build() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet result =
            new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.documentTitle_ = documentTitle_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.documentUri_ = documentUri_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.text_ = text_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
                .getDefaultInstance()) return this;
        if (!other.getDocumentTitle().isEmpty()) {
          documentTitle_ = other.documentTitle_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDocumentUri().isEmpty()) {
          documentUri_ = other.documentUri_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getText().isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  documentTitle_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  documentUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  text_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object documentTitle_ = "";
      /**
       *
       *
       * <pre>
       * Title of the enclosing document.
       * </pre>
       *
       * <code>string document_title = 1;</code>
       *
       * @return The documentTitle.
       */
      public java.lang.String getDocumentTitle() {
        java.lang.Object ref = documentTitle_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          documentTitle_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Title of the enclosing document.
       * </pre>
       *
       * <code>string document_title = 1;</code>
       *
       * @return The bytes for documentTitle.
       */
      public com.google.protobuf.ByteString getDocumentTitleBytes() {
        java.lang.Object ref = documentTitle_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          documentTitle_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Title of the enclosing document.
       * </pre>
       *
       * <code>string document_title = 1;</code>
       *
       * @param value The documentTitle to set.
       * @return This builder for chaining.
       */
      public Builder setDocumentTitle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentTitle_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Title of the enclosing document.
       * </pre>
       *
       * <code>string document_title = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDocumentTitle() {
        documentTitle_ = getDefaultInstance().getDocumentTitle();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Title of the enclosing document.
       * </pre>
       *
       * <code>string document_title = 1;</code>
       *
       * @param value The bytes for documentTitle to set.
       * @return This builder for chaining.
       */
      public Builder setDocumentTitleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        documentTitle_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object documentUri_ = "";
      /**
       *
       *
       * <pre>
       * Uri for the document. Present if specified for the document.
       * </pre>
       *
       * <code>string document_uri = 2;</code>
       *
       * @return The documentUri.
       */
      public java.lang.String getDocumentUri() {
        java.lang.Object ref = documentUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          documentUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Uri for the document. Present if specified for the document.
       * </pre>
       *
       * <code>string document_uri = 2;</code>
       *
       * @return The bytes for documentUri.
       */
      public com.google.protobuf.ByteString getDocumentUriBytes() {
        java.lang.Object ref = documentUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          documentUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Uri for the document. Present if specified for the document.
       * </pre>
       *
       * <code>string document_uri = 2;</code>
       *
       * @param value The documentUri to set.
       * @return This builder for chaining.
       */
      public Builder setDocumentUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Uri for the document. Present if specified for the document.
       * </pre>
       *
       * <code>string document_uri = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDocumentUri() {
        documentUri_ = getDefaultInstance().getDocumentUri();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Uri for the document. Present if specified for the document.
       * </pre>
       *
       * <code>string document_uri = 2;</code>
       *
       * @param value The bytes for documentUri to set.
       * @return This builder for chaining.
       */
      public Builder setDocumentUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        documentUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object text_ = "";
      /**
       *
       *
       * <pre>
       * Text included in the prompt.
       * </pre>
       *
       * <code>string text = 3;</code>
       *
       * @return The text.
       */
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Text included in the prompt.
       * </pre>
       *
       * <code>string text = 3;</code>
       *
       * @return The bytes for text.
       */
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Text included in the prompt.
       * </pre>
       *
       * <code>string text = 3;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text included in the prompt.
       * </pre>
       *
       * <code>string text = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = getDefaultInstance().getText();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text included in the prompt.
       * </pre>
       *
       * <code>string text = 3;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        text_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet)
    private static final com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet();
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SearchSnippet> PARSER =
        new com.google.protobuf.AbstractParser<SearchSnippet>() {
          @java.lang.Override
          public SearchSnippet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SearchSnippet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SearchSnippet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AnswerGenerationModelCallSignalsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Prompt as sent to the model.
     * </pre>
     *
     * <code>string rendered_prompt = 1;</code>
     *
     * @return The renderedPrompt.
     */
    java.lang.String getRenderedPrompt();
    /**
     *
     *
     * <pre>
     * Prompt as sent to the model.
     * </pre>
     *
     * <code>string rendered_prompt = 1;</code>
     *
     * @return The bytes for renderedPrompt.
     */
    com.google.protobuf.ByteString getRenderedPromptBytes();

    /**
     *
     *
     * <pre>
     * Output of the generative model.
     * </pre>
     *
     * <code>string model_output = 2;</code>
     *
     * @return The modelOutput.
     */
    java.lang.String getModelOutput();
    /**
     *
     *
     * <pre>
     * Output of the generative model.
     * </pre>
     *
     * <code>string model_output = 2;</code>
     *
     * @return The bytes for modelOutput.
     */
    com.google.protobuf.ByteString getModelOutputBytes();

    /**
     *
     *
     * <pre>
     * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
     * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @return The model.
     */
    java.lang.String getModel();
    /**
     *
     *
     * <pre>
     * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
     * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @return The bytes for model.
     */
    com.google.protobuf.ByteString getModelBytes();
  }
  /**
   *
   *
   * <pre>
   * Diagnostic info related to the answer generation model call.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals}
   */
  public static final class AnswerGenerationModelCallSignals
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals)
      AnswerGenerationModelCallSignalsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnswerGenerationModelCallSignals.newBuilder() to construct.
    private AnswerGenerationModelCallSignals(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnswerGenerationModelCallSignals() {
      renderedPrompt_ = "";
      modelOutput_ = "";
      model_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnswerGenerationModelCallSignals();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_AnswerGenerationModelCallSignals_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_AnswerGenerationModelCallSignals_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                  .AnswerGenerationModelCallSignals.class,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                  .AnswerGenerationModelCallSignals.Builder.class);
    }

    public static final int RENDERED_PROMPT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object renderedPrompt_ = "";
    /**
     *
     *
     * <pre>
     * Prompt as sent to the model.
     * </pre>
     *
     * <code>string rendered_prompt = 1;</code>
     *
     * @return The renderedPrompt.
     */
    @java.lang.Override
    public java.lang.String getRenderedPrompt() {
      java.lang.Object ref = renderedPrompt_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        renderedPrompt_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Prompt as sent to the model.
     * </pre>
     *
     * <code>string rendered_prompt = 1;</code>
     *
     * @return The bytes for renderedPrompt.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRenderedPromptBytes() {
      java.lang.Object ref = renderedPrompt_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        renderedPrompt_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODEL_OUTPUT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modelOutput_ = "";
    /**
     *
     *
     * <pre>
     * Output of the generative model.
     * </pre>
     *
     * <code>string model_output = 2;</code>
     *
     * @return The modelOutput.
     */
    @java.lang.Override
    public java.lang.String getModelOutput() {
      java.lang.Object ref = modelOutput_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelOutput_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output of the generative model.
     * </pre>
     *
     * <code>string model_output = 2;</code>
     *
     * @return The bytes for modelOutput.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelOutputBytes() {
      java.lang.Object ref = modelOutput_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelOutput_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODEL_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
     * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @return The model.
     */
    @java.lang.Override
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
     * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @return The bytes for model.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(renderedPrompt_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, renderedPrompt_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelOutput_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, modelOutput_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, model_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(renderedPrompt_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, renderedPrompt_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelOutput_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, modelOutput_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, model_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
              .AnswerGenerationModelCallSignals)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals
          other =
              (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                      .AnswerGenerationModelCallSignals)
                  obj;

      if (!getRenderedPrompt().equals(other.getRenderedPrompt())) return false;
      if (!getModelOutput().equals(other.getModelOutput())) return false;
      if (!getModel().equals(other.getModel())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RENDERED_PROMPT_FIELD_NUMBER;
      hash = (53 * hash) + getRenderedPrompt().hashCode();
      hash = (37 * hash) + MODEL_OUTPUT_FIELD_NUMBER;
      hash = (53 * hash) + getModelOutput().hashCode();
      hash = (37 * hash) + MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getModel().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Diagnostic info related to the answer generation model call.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals)
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignalsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_AnswerGenerationModelCallSignals_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_AnswerGenerationModelCallSignals_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .AnswerGenerationModelCallSignals.class,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .AnswerGenerationModelCallSignals.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        renderedPrompt_ = "";
        modelOutput_ = "";
        model_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_AnswerGenerationModelCallSignals_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
              .AnswerGenerationModelCallSignals
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
              .AnswerGenerationModelCallSignals
          build() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
              .AnswerGenerationModelCallSignals
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals
            result =
                new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .AnswerGenerationModelCallSignals(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                  .AnswerGenerationModelCallSignals
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.renderedPrompt_ = renderedPrompt_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.modelOutput_ = modelOutput_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.model_ = model_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                      .AnswerGenerationModelCallSignals)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                  .AnswerGenerationModelCallSignals
              other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals.getDefaultInstance()) return this;
        if (!other.getRenderedPrompt().isEmpty()) {
          renderedPrompt_ = other.renderedPrompt_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getModelOutput().isEmpty()) {
          modelOutput_ = other.modelOutput_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getModel().isEmpty()) {
          model_ = other.model_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  renderedPrompt_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  modelOutput_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  model_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object renderedPrompt_ = "";
      /**
       *
       *
       * <pre>
       * Prompt as sent to the model.
       * </pre>
       *
       * <code>string rendered_prompt = 1;</code>
       *
       * @return The renderedPrompt.
       */
      public java.lang.String getRenderedPrompt() {
        java.lang.Object ref = renderedPrompt_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          renderedPrompt_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Prompt as sent to the model.
       * </pre>
       *
       * <code>string rendered_prompt = 1;</code>
       *
       * @return The bytes for renderedPrompt.
       */
      public com.google.protobuf.ByteString getRenderedPromptBytes() {
        java.lang.Object ref = renderedPrompt_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          renderedPrompt_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Prompt as sent to the model.
       * </pre>
       *
       * <code>string rendered_prompt = 1;</code>
       *
       * @param value The renderedPrompt to set.
       * @return This builder for chaining.
       */
      public Builder setRenderedPrompt(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        renderedPrompt_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Prompt as sent to the model.
       * </pre>
       *
       * <code>string rendered_prompt = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRenderedPrompt() {
        renderedPrompt_ = getDefaultInstance().getRenderedPrompt();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Prompt as sent to the model.
       * </pre>
       *
       * <code>string rendered_prompt = 1;</code>
       *
       * @param value The bytes for renderedPrompt to set.
       * @return This builder for chaining.
       */
      public Builder setRenderedPromptBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        renderedPrompt_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object modelOutput_ = "";
      /**
       *
       *
       * <pre>
       * Output of the generative model.
       * </pre>
       *
       * <code>string model_output = 2;</code>
       *
       * @return The modelOutput.
       */
      public java.lang.String getModelOutput() {
        java.lang.Object ref = modelOutput_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelOutput_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output of the generative model.
       * </pre>
       *
       * <code>string model_output = 2;</code>
       *
       * @return The bytes for modelOutput.
       */
      public com.google.protobuf.ByteString getModelOutputBytes() {
        java.lang.Object ref = modelOutput_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelOutput_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output of the generative model.
       * </pre>
       *
       * <code>string model_output = 2;</code>
       *
       * @param value The modelOutput to set.
       * @return This builder for chaining.
       */
      public Builder setModelOutput(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelOutput_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output of the generative model.
       * </pre>
       *
       * <code>string model_output = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelOutput() {
        modelOutput_ = getDefaultInstance().getModelOutput();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output of the generative model.
       * </pre>
       *
       * <code>string model_output = 2;</code>
       *
       * @param value The bytes for modelOutput to set.
       * @return This builder for chaining.
       */
      public Builder setModelOutputBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelOutput_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object model_ = "";
      /**
       *
       *
       * <pre>
       * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
       * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
       * </pre>
       *
       * <code>string model = 3;</code>
       *
       * @return The model.
       */
      public java.lang.String getModel() {
        java.lang.Object ref = model_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          model_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
       * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
       * </pre>
       *
       * <code>string model = 3;</code>
       *
       * @return The bytes for model.
       */
      public com.google.protobuf.ByteString getModelBytes() {
        java.lang.Object ref = model_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          model_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
       * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
       * </pre>
       *
       * <code>string model = 3;</code>
       *
       * @param value The model to set.
       * @return This builder for chaining.
       */
      public Builder setModel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        model_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
       * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
       * </pre>
       *
       * <code>string model = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModel() {
        model_ = getDefaultInstance().getModel();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of the generative model. For example, "gemini-ultra", "gemini-pro",
       * "gemini-1.5-flash" etc. Defaults to "Other" if the model is unknown.
       * </pre>
       *
       * <code>string model = 3;</code>
       *
       * @param value The bytes for model to set.
       * @return This builder for chaining.
       */
      public Builder setModelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        model_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals)
    private static final com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
              .AnswerGenerationModelCallSignals();
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnswerGenerationModelCallSignals> PARSER =
        new com.google.protobuf.AbstractParser<AnswerGenerationModelCallSignals>() {
          @java.lang.Override
          public AnswerGenerationModelCallSignals parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnswerGenerationModelCallSignals> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnswerGenerationModelCallSignals> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AnswerPartOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Substring of the answer.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    java.lang.String getText();
    /**
     *
     *
     * <pre>
     * Substring of the answer.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();

    /**
     *
     *
     * <pre>
     * Citations for this answer part. Indices of `search_snippets`.
     * </pre>
     *
     * <code>repeated int32 supporting_indices = 2;</code>
     *
     * @return A list containing the supportingIndices.
     */
    java.util.List<java.lang.Integer> getSupportingIndicesList();
    /**
     *
     *
     * <pre>
     * Citations for this answer part. Indices of `search_snippets`.
     * </pre>
     *
     * <code>repeated int32 supporting_indices = 2;</code>
     *
     * @return The count of supportingIndices.
     */
    int getSupportingIndicesCount();
    /**
     *
     *
     * <pre>
     * Citations for this answer part. Indices of `search_snippets`.
     * </pre>
     *
     * <code>repeated int32 supporting_indices = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The supportingIndices at the given index.
     */
    int getSupportingIndices(int index);
  }
  /**
   *
   *
   * <pre>
   * Answer part with citation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart}
   */
  public static final class AnswerPart extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart)
      AnswerPartOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnswerPart.newBuilder() to construct.
    private AnswerPart(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnswerPart() {
      text_ = "";
      supportingIndices_ = emptyIntList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnswerPart();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_AnswerPart_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_AnswerPart_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.class,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.Builder
                  .class);
    }

    public static final int TEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object text_ = "";
    /**
     *
     *
     * <pre>
     * Substring of the answer.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Substring of the answer.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUPPORTING_INDICES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.IntList supportingIndices_ = emptyIntList();
    /**
     *
     *
     * <pre>
     * Citations for this answer part. Indices of `search_snippets`.
     * </pre>
     *
     * <code>repeated int32 supporting_indices = 2;</code>
     *
     * @return A list containing the supportingIndices.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getSupportingIndicesList() {
      return supportingIndices_;
    }
    /**
     *
     *
     * <pre>
     * Citations for this answer part. Indices of `search_snippets`.
     * </pre>
     *
     * <code>repeated int32 supporting_indices = 2;</code>
     *
     * @return The count of supportingIndices.
     */
    public int getSupportingIndicesCount() {
      return supportingIndices_.size();
    }
    /**
     *
     *
     * <pre>
     * Citations for this answer part. Indices of `search_snippets`.
     * </pre>
     *
     * <code>repeated int32 supporting_indices = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The supportingIndices at the given index.
     */
    public int getSupportingIndices(int index) {
      return supportingIndices_.getInt(index);
    }

    private int supportingIndicesMemoizedSerializedSize = -1;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
      }
      if (getSupportingIndicesList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(supportingIndicesMemoizedSerializedSize);
      }
      for (int i = 0; i < supportingIndices_.size(); i++) {
        output.writeInt32NoTag(supportingIndices_.getInt(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < supportingIndices_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(
                  supportingIndices_.getInt(i));
        }
        size += dataSize;
        if (!getSupportingIndicesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
        }
        supportingIndicesMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart other =
          (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart) obj;

      if (!getText().equals(other.getText())) return false;
      if (!getSupportingIndicesList().equals(other.getSupportingIndicesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
      if (getSupportingIndicesCount() > 0) {
        hash = (37 * hash) + SUPPORTING_INDICES_FIELD_NUMBER;
        hash = (53 * hash) + getSupportingIndicesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Answer part with citation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart)
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPartOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_AnswerPart_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_AnswerPart_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.class,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        text_ = "";
        supportingIndices_ = emptyIntList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_AnswerPart_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart build() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart result =
            new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.text_ = text_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          supportingIndices_.makeImmutable();
          result.supportingIndices_ = supportingIndices_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
                .getDefaultInstance()) return this;
        if (!other.getText().isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.supportingIndices_.isEmpty()) {
          if (supportingIndices_.isEmpty()) {
            supportingIndices_ = other.supportingIndices_;
            supportingIndices_.makeImmutable();
            bitField0_ |= 0x00000002;
          } else {
            ensureSupportingIndicesIsMutable();
            supportingIndices_.addAll(other.supportingIndices_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  text_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  int v = input.readInt32();
                  ensureSupportingIndicesIsMutable();
                  supportingIndices_.addInt(v);
                  break;
                } // case 16
              case 18:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  ensureSupportingIndicesIsMutable();
                  while (input.getBytesUntilLimit() > 0) {
                    supportingIndices_.addInt(input.readInt32());
                  }
                  input.popLimit(limit);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object text_ = "";
      /**
       *
       *
       * <pre>
       * Substring of the answer.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Substring of the answer.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Substring of the answer.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Substring of the answer.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = getDefaultInstance().getText();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Substring of the answer.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.Internal.IntList supportingIndices_ = emptyIntList();

      private void ensureSupportingIndicesIsMutable() {
        if (!supportingIndices_.isModifiable()) {
          supportingIndices_ = makeMutableCopy(supportingIndices_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Citations for this answer part. Indices of `search_snippets`.
       * </pre>
       *
       * <code>repeated int32 supporting_indices = 2;</code>
       *
       * @return A list containing the supportingIndices.
       */
      public java.util.List<java.lang.Integer> getSupportingIndicesList() {
        supportingIndices_.makeImmutable();
        return supportingIndices_;
      }
      /**
       *
       *
       * <pre>
       * Citations for this answer part. Indices of `search_snippets`.
       * </pre>
       *
       * <code>repeated int32 supporting_indices = 2;</code>
       *
       * @return The count of supportingIndices.
       */
      public int getSupportingIndicesCount() {
        return supportingIndices_.size();
      }
      /**
       *
       *
       * <pre>
       * Citations for this answer part. Indices of `search_snippets`.
       * </pre>
       *
       * <code>repeated int32 supporting_indices = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The supportingIndices at the given index.
       */
      public int getSupportingIndices(int index) {
        return supportingIndices_.getInt(index);
      }
      /**
       *
       *
       * <pre>
       * Citations for this answer part. Indices of `search_snippets`.
       * </pre>
       *
       * <code>repeated int32 supporting_indices = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The supportingIndices to set.
       * @return This builder for chaining.
       */
      public Builder setSupportingIndices(int index, int value) {

        ensureSupportingIndicesIsMutable();
        supportingIndices_.setInt(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Citations for this answer part. Indices of `search_snippets`.
       * </pre>
       *
       * <code>repeated int32 supporting_indices = 2;</code>
       *
       * @param value The supportingIndices to add.
       * @return This builder for chaining.
       */
      public Builder addSupportingIndices(int value) {

        ensureSupportingIndicesIsMutable();
        supportingIndices_.addInt(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Citations for this answer part. Indices of `search_snippets`.
       * </pre>
       *
       * <code>repeated int32 supporting_indices = 2;</code>
       *
       * @param values The supportingIndices to add.
       * @return This builder for chaining.
       */
      public Builder addAllSupportingIndices(
          java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureSupportingIndicesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, supportingIndices_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Citations for this answer part. Indices of `search_snippets`.
       * </pre>
       *
       * <code>repeated int32 supporting_indices = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSupportingIndices() {
        supportingIndices_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart)
    private static final com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart();
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnswerPart> PARSER =
        new com.google.protobuf.AbstractParser<AnswerPart>() {
          @java.lang.Override
          public AnswerPart parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnswerPart> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnswerPart> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CitedSnippetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Details of the snippet.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
     * </code>
     *
     * @return Whether the searchSnippet field is set.
     */
    boolean hasSearchSnippet();
    /**
     *
     *
     * <pre>
     * Details of the snippet.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
     * </code>
     *
     * @return The searchSnippet.
     */
    com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet getSearchSnippet();
    /**
     *
     *
     * <pre>
     * Details of the snippet.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippetOrBuilder
        getSearchSnippetOrBuilder();

    /**
     *
     *
     * <pre>
     * Index of the snippet in `search_snippets` field.
     * </pre>
     *
     * <code>int32 snippet_index = 2;</code>
     *
     * @return The snippetIndex.
     */
    int getSnippetIndex();
  }
  /**
   *
   *
   * <pre>
   * Snippet cited by the answer generation model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet}
   */
  public static final class CitedSnippet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet)
      CitedSnippetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CitedSnippet.newBuilder() to construct.
    private CitedSnippet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CitedSnippet() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CitedSnippet();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_CitedSnippet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_CitedSnippet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.class,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.Builder
                  .class);
    }

    private int bitField0_;
    public static final int SEARCH_SNIPPET_FIELD_NUMBER = 1;
    private com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        searchSnippet_;
    /**
     *
     *
     * <pre>
     * Details of the snippet.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
     * </code>
     *
     * @return Whether the searchSnippet field is set.
     */
    @java.lang.Override
    public boolean hasSearchSnippet() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Details of the snippet.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
     * </code>
     *
     * @return The searchSnippet.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        getSearchSnippet() {
      return searchSnippet_ == null
          ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
              .getDefaultInstance()
          : searchSnippet_;
    }
    /**
     *
     *
     * <pre>
     * Details of the snippet.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippetOrBuilder
        getSearchSnippetOrBuilder() {
      return searchSnippet_ == null
          ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
              .getDefaultInstance()
          : searchSnippet_;
    }

    public static final int SNIPPET_INDEX_FIELD_NUMBER = 2;
    private int snippetIndex_ = 0;
    /**
     *
     *
     * <pre>
     * Index of the snippet in `search_snippets` field.
     * </pre>
     *
     * <code>int32 snippet_index = 2;</code>
     *
     * @return The snippetIndex.
     */
    @java.lang.Override
    public int getSnippetIndex() {
      return snippetIndex_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getSearchSnippet());
      }
      if (snippetIndex_ != 0) {
        output.writeInt32(2, snippetIndex_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSearchSnippet());
      }
      if (snippetIndex_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, snippetIndex_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet other =
          (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet) obj;

      if (hasSearchSnippet() != other.hasSearchSnippet()) return false;
      if (hasSearchSnippet()) {
        if (!getSearchSnippet().equals(other.getSearchSnippet())) return false;
      }
      if (getSnippetIndex() != other.getSnippetIndex()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSearchSnippet()) {
        hash = (37 * hash) + SEARCH_SNIPPET_FIELD_NUMBER;
        hash = (53 * hash) + getSearchSnippet().hashCode();
      }
      hash = (37 * hash) + SNIPPET_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getSnippetIndex();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Snippet cited by the answer generation model.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet)
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_CitedSnippet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_CitedSnippet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.class,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSearchSnippetFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        searchSnippet_ = null;
        if (searchSnippetBuilder_ != null) {
          searchSnippetBuilder_.dispose();
          searchSnippetBuilder_ = null;
        }
        snippetIndex_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_CitedSnippet_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet build() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet result =
            new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.searchSnippet_ =
              searchSnippetBuilder_ == null ? searchSnippet_ : searchSnippetBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.snippetIndex_ = snippetIndex_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
                .getDefaultInstance()) return this;
        if (other.hasSearchSnippet()) {
          mergeSearchSnippet(other.getSearchSnippet());
        }
        if (other.getSnippetIndex() != 0) {
          setSnippetIndex(other.getSnippetIndex());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getSearchSnippetFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  snippetIndex_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
          searchSnippet_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippetOrBuilder>
          searchSnippetBuilder_;
      /**
       *
       *
       * <pre>
       * Details of the snippet.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
       * </code>
       *
       * @return Whether the searchSnippet field is set.
       */
      public boolean hasSearchSnippet() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Details of the snippet.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
       * </code>
       *
       * @return The searchSnippet.
       */
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
          getSearchSnippet() {
        if (searchSnippetBuilder_ == null) {
          return searchSnippet_ == null
              ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
                  .getDefaultInstance()
              : searchSnippet_;
        } else {
          return searchSnippetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Details of the snippet.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
       * </code>
       */
      public Builder setSearchSnippet(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet value) {
        if (searchSnippetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          searchSnippet_ = value;
        } else {
          searchSnippetBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of the snippet.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
       * </code>
       */
      public Builder setSearchSnippet(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder
              builderForValue) {
        if (searchSnippetBuilder_ == null) {
          searchSnippet_ = builderForValue.build();
        } else {
          searchSnippetBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of the snippet.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
       * </code>
       */
      public Builder mergeSearchSnippet(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet value) {
        if (searchSnippetBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && searchSnippet_ != null
              && searchSnippet_
                  != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
                      .getDefaultInstance()) {
            getSearchSnippetBuilder().mergeFrom(value);
          } else {
            searchSnippet_ = value;
          }
        } else {
          searchSnippetBuilder_.mergeFrom(value);
        }
        if (searchSnippet_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of the snippet.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
       * </code>
       */
      public Builder clearSearchSnippet() {
        bitField0_ = (bitField0_ & ~0x00000001);
        searchSnippet_ = null;
        if (searchSnippetBuilder_ != null) {
          searchSnippetBuilder_.dispose();
          searchSnippetBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details of the snippet.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder
          getSearchSnippetBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getSearchSnippetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Details of the snippet.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippetOrBuilder
          getSearchSnippetOrBuilder() {
        if (searchSnippetBuilder_ != null) {
          return searchSnippetBuilder_.getMessageOrBuilder();
        } else {
          return searchSnippet_ == null
              ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
                  .getDefaultInstance()
              : searchSnippet_;
        }
      }
      /**
       *
       *
       * <pre>
       * Details of the snippet.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippet = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippetOrBuilder>
          getSearchSnippetFieldBuilder() {
        if (searchSnippetBuilder_ == null) {
          searchSnippetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet,
                  com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
                      .Builder,
                  com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                      .SearchSnippetOrBuilder>(
                  getSearchSnippet(), getParentForChildren(), isClean());
          searchSnippet_ = null;
        }
        return searchSnippetBuilder_;
      }

      private int snippetIndex_;
      /**
       *
       *
       * <pre>
       * Index of the snippet in `search_snippets` field.
       * </pre>
       *
       * <code>int32 snippet_index = 2;</code>
       *
       * @return The snippetIndex.
       */
      @java.lang.Override
      public int getSnippetIndex() {
        return snippetIndex_;
      }
      /**
       *
       *
       * <pre>
       * Index of the snippet in `search_snippets` field.
       * </pre>
       *
       * <code>int32 snippet_index = 2;</code>
       *
       * @param value The snippetIndex to set.
       * @return This builder for chaining.
       */
      public Builder setSnippetIndex(int value) {

        snippetIndex_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Index of the snippet in `search_snippets` field.
       * </pre>
       *
       * <code>int32 snippet_index = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSnippetIndex() {
        bitField0_ = (bitField0_ & ~0x00000002);
        snippetIndex_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet)
    private static final com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet();
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CitedSnippet> PARSER =
        new com.google.protobuf.AbstractParser<CitedSnippet>() {
          @java.lang.Override
          public CitedSnippet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CitedSnippet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CitedSnippet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GroundingSignalsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Represents the decision of the grounding check.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision decision = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for decision.
     */
    int getDecisionValue();
    /**
     *
     *
     * <pre>
     * Represents the decision of the grounding check.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision decision = 1;
     * </code>
     *
     * @return The decision.
     */
    com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision
        getDecision();

    /**
     *
     *
     * <pre>
     * Grounding score bucket setting.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket score = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for score.
     */
    int getScoreValue();
    /**
     *
     *
     * <pre>
     * Grounding score bucket setting.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket score = 2;
     * </code>
     *
     * @return The score.
     */
    com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
            .GroundingScoreBucket
        getScore();
  }
  /**
   *
   *
   * <pre>
   * Grounding signals.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals}
   */
  public static final class GroundingSignals extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals)
      GroundingSignalsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GroundingSignals.newBuilder() to construct.
    private GroundingSignals(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GroundingSignals() {
      decision_ = 0;
      score_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GroundingSignals();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_GroundingSignals_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_GroundingSignals_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.class,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * Represents the decision of the grounding check.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision}
     */
    public enum GroundingDecision implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Decision not specified.
       * </pre>
       *
       * <code>GROUNDING_DECISION_UNSPECIFIED = 0;</code>
       */
      GROUNDING_DECISION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Grounding have accepted the answer.
       * </pre>
       *
       * <code>ACCEPTED_BY_GROUNDING = 1;</code>
       */
      ACCEPTED_BY_GROUNDING(1),
      /**
       *
       *
       * <pre>
       * Grounding have rejected the answer.
       * </pre>
       *
       * <code>REJECTED_BY_GROUNDING = 2;</code>
       */
      REJECTED_BY_GROUNDING(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Decision not specified.
       * </pre>
       *
       * <code>GROUNDING_DECISION_UNSPECIFIED = 0;</code>
       */
      public static final int GROUNDING_DECISION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Grounding have accepted the answer.
       * </pre>
       *
       * <code>ACCEPTED_BY_GROUNDING = 1;</code>
       */
      public static final int ACCEPTED_BY_GROUNDING_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Grounding have rejected the answer.
       * </pre>
       *
       * <code>REJECTED_BY_GROUNDING = 2;</code>
       */
      public static final int REJECTED_BY_GROUNDING_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static GroundingDecision valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static GroundingDecision forNumber(int value) {
        switch (value) {
          case 0:
            return GROUNDING_DECISION_UNSPECIFIED;
          case 1:
            return ACCEPTED_BY_GROUNDING;
          case 2:
            return REJECTED_BY_GROUNDING;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<GroundingDecision>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<GroundingDecision>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<GroundingDecision>() {
                public GroundingDecision findValueByNumber(int number) {
                  return GroundingDecision.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final GroundingDecision[] VALUES = values();

      public static GroundingDecision valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private GroundingDecision(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision)
    }

    /**
     *
     *
     * <pre>
     * Grounding score buckets.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket}
     */
    public enum GroundingScoreBucket implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Score not specified.
       * </pre>
       *
       * <code>GROUNDING_SCORE_BUCKET_UNSPECIFIED = 0;</code>
       */
      GROUNDING_SCORE_BUCKET_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * We have very low confidence that the answer is grounded.
       * </pre>
       *
       * <code>VERY_LOW = 1;</code>
       */
      VERY_LOW(1),
      /**
       *
       *
       * <pre>
       * We have low confidence that the answer is grounded.
       * </pre>
       *
       * <code>LOW = 3;</code>
       */
      LOW(3),
      /**
       *
       *
       * <pre>
       * We have medium confidence that the answer is grounded.
       * </pre>
       *
       * <code>MEDIUM = 4;</code>
       */
      MEDIUM(4),
      /**
       *
       *
       * <pre>
       * We have high confidence that the answer is grounded.
       * </pre>
       *
       * <code>HIGH = 5;</code>
       */
      HIGH(5),
      /**
       *
       *
       * <pre>
       * We have very high confidence that the answer is grounded.
       * </pre>
       *
       * <code>VERY_HIGH = 6;</code>
       */
      VERY_HIGH(6),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Score not specified.
       * </pre>
       *
       * <code>GROUNDING_SCORE_BUCKET_UNSPECIFIED = 0;</code>
       */
      public static final int GROUNDING_SCORE_BUCKET_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * We have very low confidence that the answer is grounded.
       * </pre>
       *
       * <code>VERY_LOW = 1;</code>
       */
      public static final int VERY_LOW_VALUE = 1;
      /**
       *
       *
       * <pre>
       * We have low confidence that the answer is grounded.
       * </pre>
       *
       * <code>LOW = 3;</code>
       */
      public static final int LOW_VALUE = 3;
      /**
       *
       *
       * <pre>
       * We have medium confidence that the answer is grounded.
       * </pre>
       *
       * <code>MEDIUM = 4;</code>
       */
      public static final int MEDIUM_VALUE = 4;
      /**
       *
       *
       * <pre>
       * We have high confidence that the answer is grounded.
       * </pre>
       *
       * <code>HIGH = 5;</code>
       */
      public static final int HIGH_VALUE = 5;
      /**
       *
       *
       * <pre>
       * We have very high confidence that the answer is grounded.
       * </pre>
       *
       * <code>VERY_HIGH = 6;</code>
       */
      public static final int VERY_HIGH_VALUE = 6;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static GroundingScoreBucket valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static GroundingScoreBucket forNumber(int value) {
        switch (value) {
          case 0:
            return GROUNDING_SCORE_BUCKET_UNSPECIFIED;
          case 1:
            return VERY_LOW;
          case 3:
            return LOW;
          case 4:
            return MEDIUM;
          case 5:
            return HIGH;
          case 6:
            return VERY_HIGH;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<GroundingScoreBucket>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<GroundingScoreBucket>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<GroundingScoreBucket>() {
                public GroundingScoreBucket findValueByNumber(int number) {
                  return GroundingScoreBucket.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
            .getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final GroundingScoreBucket[] VALUES = values();

      public static GroundingScoreBucket valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private GroundingScoreBucket(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket)
    }

    public static final int DECISION_FIELD_NUMBER = 1;
    private int decision_ = 0;
    /**
     *
     *
     * <pre>
     * Represents the decision of the grounding check.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision decision = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for decision.
     */
    @java.lang.Override
    public int getDecisionValue() {
      return decision_;
    }
    /**
     *
     *
     * <pre>
     * Represents the decision of the grounding check.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision decision = 1;
     * </code>
     *
     * @return The decision.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
            .GroundingDecision
        getDecision() {
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
              .GroundingDecision
          result =
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                  .GroundingDecision.forNumber(decision_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
              .GroundingDecision.UNRECOGNIZED
          : result;
    }

    public static final int SCORE_FIELD_NUMBER = 2;
    private int score_ = 0;
    /**
     *
     *
     * <pre>
     * Grounding score bucket setting.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket score = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for score.
     */
    @java.lang.Override
    public int getScoreValue() {
      return score_;
    }
    /**
     *
     *
     * <pre>
     * Grounding score bucket setting.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket score = 2;
     * </code>
     *
     * @return The score.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
            .GroundingScoreBucket
        getScore() {
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
              .GroundingScoreBucket
          result =
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                  .GroundingScoreBucket.forNumber(score_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
              .GroundingScoreBucket.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (decision_
          != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
              .GroundingDecision.GROUNDING_DECISION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, decision_);
      }
      if (score_
          != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
              .GroundingScoreBucket.GROUNDING_SCORE_BUCKET_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, score_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (decision_
          != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
              .GroundingDecision.GROUNDING_DECISION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, decision_);
      }
      if (score_
          != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
              .GroundingScoreBucket.GROUNDING_SCORE_BUCKET_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, score_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals other =
          (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals) obj;

      if (decision_ != other.decision_) return false;
      if (score_ != other.score_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DECISION_FIELD_NUMBER;
      hash = (53 * hash) + decision_;
      hash = (37 * hash) + SCORE_FIELD_NUMBER;
      hash = (53 * hash) + score_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Grounding signals.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals)
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignalsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_GroundingSignals_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_GroundingSignals_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.class,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        decision_ = 0;
        score_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_GroundingSignals_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals build() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals result =
            new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.decision_ = decision_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.score_ = score_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                .getDefaultInstance()) return this;
        if (other.decision_ != 0) {
          setDecisionValue(other.getDecisionValue());
        }
        if (other.score_ != 0) {
          setScoreValue(other.getScoreValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  decision_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  score_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int decision_ = 0;
      /**
       *
       *
       * <pre>
       * Represents the decision of the grounding check.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision decision = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for decision.
       */
      @java.lang.Override
      public int getDecisionValue() {
        return decision_;
      }
      /**
       *
       *
       * <pre>
       * Represents the decision of the grounding check.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision decision = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for decision to set.
       * @return This builder for chaining.
       */
      public Builder setDecisionValue(int value) {
        decision_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the decision of the grounding check.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision decision = 1;
       * </code>
       *
       * @return The decision.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
              .GroundingDecision
          getDecision() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                .GroundingDecision
            result =
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                    .GroundingDecision.forNumber(decision_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                .GroundingDecision.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Represents the decision of the grounding check.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision decision = 1;
       * </code>
       *
       * @param value The decision to set.
       * @return This builder for chaining.
       */
      public Builder setDecision(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                  .GroundingDecision
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        decision_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the decision of the grounding check.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingDecision decision = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDecision() {
        bitField0_ = (bitField0_ & ~0x00000001);
        decision_ = 0;
        onChanged();
        return this;
      }

      private int score_ = 0;
      /**
       *
       *
       * <pre>
       * Grounding score bucket setting.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket score = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for score.
       */
      @java.lang.Override
      public int getScoreValue() {
        return score_;
      }
      /**
       *
       *
       * <pre>
       * Grounding score bucket setting.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket score = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for score to set.
       * @return This builder for chaining.
       */
      public Builder setScoreValue(int value) {
        score_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding score bucket setting.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket score = 2;
       * </code>
       *
       * @return The score.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
              .GroundingScoreBucket
          getScore() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                .GroundingScoreBucket
            result =
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                    .GroundingScoreBucket.forNumber(score_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                .GroundingScoreBucket.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Grounding score bucket setting.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket score = 2;
       * </code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                  .GroundingScoreBucket
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        score_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding score bucket setting.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.GroundingScoreBucket score = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {
        bitField0_ = (bitField0_ & ~0x00000002);
        score_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals)
    private static final com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .GroundingSignals
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals();
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GroundingSignals> PARSER =
        new com.google.protobuf.AbstractParser<GroundingSignals>() {
          @java.lang.Override
          public GroundingSignals parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GroundingSignals> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GroundingSignals> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SafetySignalsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Safety decision.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision decision = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for decision.
     */
    int getDecisionValue();
    /**
     *
     *
     * <pre>
     * Safety decision.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision decision = 1;
     * </code>
     *
     * @return The decision.
     */
    com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision
        getDecision();

    /**
     *
     *
     * <pre>
     * Specifies banned phrase match subject.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch banned_phrase_match = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for bannedPhraseMatch.
     */
    int getBannedPhraseMatchValue();
    /**
     *
     *
     * <pre>
     * Specifies banned phrase match subject.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch banned_phrase_match = 2;
     * </code>
     *
     * @return The bannedPhraseMatch.
     */
    com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch
        getBannedPhraseMatch();

    /**
     *
     *
     * <pre>
     * The matched banned phrase if there was a match.
     * </pre>
     *
     * <code>string matched_banned_phrase = 3;</code>
     *
     * @return The matchedBannedPhrase.
     */
    java.lang.String getMatchedBannedPhrase();
    /**
     *
     *
     * <pre>
     * The matched banned phrase if there was a match.
     * </pre>
     *
     * <code>string matched_banned_phrase = 3;</code>
     *
     * @return The bytes for matchedBannedPhrase.
     */
    com.google.protobuf.ByteString getMatchedBannedPhraseBytes();
  }
  /**
   *
   *
   * <pre>
   * Safety check results.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals}
   */
  public static final class SafetySignals extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals)
      SafetySignalsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SafetySignals.newBuilder() to construct.
    private SafetySignals(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SafetySignals() {
      decision_ = 0;
      bannedPhraseMatch_ = 0;
      matchedBannedPhrase_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SafetySignals();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_SafetySignals_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_SafetySignals_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.class,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * Safety decision.
     * All kinds of check are incorporated into this final decision, including
     * banned phrases check.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision}
     */
    public enum SafetyDecision implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Decision not specified.
       * </pre>
       *
       * <code>SAFETY_DECISION_UNSPECIFIED = 0;</code>
       */
      SAFETY_DECISION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * No manual or automatic safety check fired.
       * </pre>
       *
       * <code>ACCEPTED_BY_SAFETY_CHECK = 1;</code>
       */
      ACCEPTED_BY_SAFETY_CHECK(1),
      /**
       *
       *
       * <pre>
       * One ore more safety checks fired.
       * </pre>
       *
       * <code>REJECTED_BY_SAFETY_CHECK = 2;</code>
       */
      REJECTED_BY_SAFETY_CHECK(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Decision not specified.
       * </pre>
       *
       * <code>SAFETY_DECISION_UNSPECIFIED = 0;</code>
       */
      public static final int SAFETY_DECISION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * No manual or automatic safety check fired.
       * </pre>
       *
       * <code>ACCEPTED_BY_SAFETY_CHECK = 1;</code>
       */
      public static final int ACCEPTED_BY_SAFETY_CHECK_VALUE = 1;
      /**
       *
       *
       * <pre>
       * One ore more safety checks fired.
       * </pre>
       *
       * <code>REJECTED_BY_SAFETY_CHECK = 2;</code>
       */
      public static final int REJECTED_BY_SAFETY_CHECK_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SafetyDecision valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static SafetyDecision forNumber(int value) {
        switch (value) {
          case 0:
            return SAFETY_DECISION_UNSPECIFIED;
          case 1:
            return ACCEPTED_BY_SAFETY_CHECK;
          case 2:
            return REJECTED_BY_SAFETY_CHECK;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<SafetyDecision> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<SafetyDecision>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<SafetyDecision>() {
                public SafetyDecision findValueByNumber(int number) {
                  return SafetyDecision.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final SafetyDecision[] VALUES = values();

      public static SafetyDecision valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private SafetyDecision(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision)
    }

    /**
     *
     *
     * <pre>
     * Specifies banned phrase match subject.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch}
     */
    public enum BannedPhraseMatch implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * No banned phrase check was executed.
       * </pre>
       *
       * <code>BANNED_PHRASE_MATCH_UNSPECIFIED = 0;</code>
       */
      BANNED_PHRASE_MATCH_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * All banned phrase checks led to no match.
       * </pre>
       *
       * <code>BANNED_PHRASE_MATCH_NONE = 1;</code>
       */
      BANNED_PHRASE_MATCH_NONE(1),
      /**
       *
       *
       * <pre>
       * A banned phrase matched the query.
       * </pre>
       *
       * <code>BANNED_PHRASE_MATCH_QUERY = 2;</code>
       */
      BANNED_PHRASE_MATCH_QUERY(2),
      /**
       *
       *
       * <pre>
       * A banned phrase matched the response.
       * </pre>
       *
       * <code>BANNED_PHRASE_MATCH_RESPONSE = 3;</code>
       */
      BANNED_PHRASE_MATCH_RESPONSE(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * No banned phrase check was executed.
       * </pre>
       *
       * <code>BANNED_PHRASE_MATCH_UNSPECIFIED = 0;</code>
       */
      public static final int BANNED_PHRASE_MATCH_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * All banned phrase checks led to no match.
       * </pre>
       *
       * <code>BANNED_PHRASE_MATCH_NONE = 1;</code>
       */
      public static final int BANNED_PHRASE_MATCH_NONE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * A banned phrase matched the query.
       * </pre>
       *
       * <code>BANNED_PHRASE_MATCH_QUERY = 2;</code>
       */
      public static final int BANNED_PHRASE_MATCH_QUERY_VALUE = 2;
      /**
       *
       *
       * <pre>
       * A banned phrase matched the response.
       * </pre>
       *
       * <code>BANNED_PHRASE_MATCH_RESPONSE = 3;</code>
       */
      public static final int BANNED_PHRASE_MATCH_RESPONSE_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static BannedPhraseMatch valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static BannedPhraseMatch forNumber(int value) {
        switch (value) {
          case 0:
            return BANNED_PHRASE_MATCH_UNSPECIFIED;
          case 1:
            return BANNED_PHRASE_MATCH_NONE;
          case 2:
            return BANNED_PHRASE_MATCH_QUERY;
          case 3:
            return BANNED_PHRASE_MATCH_RESPONSE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<BannedPhraseMatch>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<BannedPhraseMatch>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<BannedPhraseMatch>() {
                public BannedPhraseMatch findValueByNumber(int number) {
                  return BannedPhraseMatch.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
            .getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final BannedPhraseMatch[] VALUES = values();

      public static BannedPhraseMatch valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private BannedPhraseMatch(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch)
    }

    public static final int DECISION_FIELD_NUMBER = 1;
    private int decision_ = 0;
    /**
     *
     *
     * <pre>
     * Safety decision.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision decision = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for decision.
     */
    @java.lang.Override
    public int getDecisionValue() {
      return decision_;
    }
    /**
     *
     *
     * <pre>
     * Safety decision.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision decision = 1;
     * </code>
     *
     * @return The decision.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision
        getDecision() {
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision
          result =
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
                  .SafetyDecision.forNumber(decision_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
              .SafetyDecision.UNRECOGNIZED
          : result;
    }

    public static final int BANNED_PHRASE_MATCH_FIELD_NUMBER = 2;
    private int bannedPhraseMatch_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies banned phrase match subject.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch banned_phrase_match = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for bannedPhraseMatch.
     */
    @java.lang.Override
    public int getBannedPhraseMatchValue() {
      return bannedPhraseMatch_;
    }
    /**
     *
     *
     * <pre>
     * Specifies banned phrase match subject.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch banned_phrase_match = 2;
     * </code>
     *
     * @return The bannedPhraseMatch.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
            .BannedPhraseMatch
        getBannedPhraseMatch() {
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch
          result =
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
                  .BannedPhraseMatch.forNumber(bannedPhraseMatch_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
              .BannedPhraseMatch.UNRECOGNIZED
          : result;
    }

    public static final int MATCHED_BANNED_PHRASE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object matchedBannedPhrase_ = "";
    /**
     *
     *
     * <pre>
     * The matched banned phrase if there was a match.
     * </pre>
     *
     * <code>string matched_banned_phrase = 3;</code>
     *
     * @return The matchedBannedPhrase.
     */
    @java.lang.Override
    public java.lang.String getMatchedBannedPhrase() {
      java.lang.Object ref = matchedBannedPhrase_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        matchedBannedPhrase_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The matched banned phrase if there was a match.
     * </pre>
     *
     * <code>string matched_banned_phrase = 3;</code>
     *
     * @return The bytes for matchedBannedPhrase.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMatchedBannedPhraseBytes() {
      java.lang.Object ref = matchedBannedPhrase_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        matchedBannedPhrase_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (decision_
          != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
              .SafetyDecision.SAFETY_DECISION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, decision_);
      }
      if (bannedPhraseMatch_
          != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
              .BannedPhraseMatch.BANNED_PHRASE_MATCH_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, bannedPhraseMatch_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchedBannedPhrase_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, matchedBannedPhrase_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (decision_
          != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
              .SafetyDecision.SAFETY_DECISION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, decision_);
      }
      if (bannedPhraseMatch_
          != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
              .BannedPhraseMatch.BANNED_PHRASE_MATCH_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, bannedPhraseMatch_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchedBannedPhrase_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, matchedBannedPhrase_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals other =
          (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals) obj;

      if (decision_ != other.decision_) return false;
      if (bannedPhraseMatch_ != other.bannedPhraseMatch_) return false;
      if (!getMatchedBannedPhrase().equals(other.getMatchedBannedPhrase())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DECISION_FIELD_NUMBER;
      hash = (53 * hash) + decision_;
      hash = (37 * hash) + BANNED_PHRASE_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + bannedPhraseMatch_;
      hash = (37 * hash) + MATCHED_BANNED_PHRASE_FIELD_NUMBER;
      hash = (53 * hash) + getMatchedBannedPhrase().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Safety check results.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals)
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignalsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_SafetySignals_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_SafetySignals_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.class,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        decision_ = 0;
        bannedPhraseMatch_ = 0;
        matchedBannedPhrase_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
            .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_SafetySignals_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals build() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals result =
            new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.decision_ = decision_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.bannedPhraseMatch_ = bannedPhraseMatch_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.matchedBannedPhrase_ = matchedBannedPhrase_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
                .getDefaultInstance()) return this;
        if (other.decision_ != 0) {
          setDecisionValue(other.getDecisionValue());
        }
        if (other.bannedPhraseMatch_ != 0) {
          setBannedPhraseMatchValue(other.getBannedPhraseMatchValue());
        }
        if (!other.getMatchedBannedPhrase().isEmpty()) {
          matchedBannedPhrase_ = other.matchedBannedPhrase_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  decision_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  bannedPhraseMatch_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  matchedBannedPhrase_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int decision_ = 0;
      /**
       *
       *
       * <pre>
       * Safety decision.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision decision = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for decision.
       */
      @java.lang.Override
      public int getDecisionValue() {
        return decision_;
      }
      /**
       *
       *
       * <pre>
       * Safety decision.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision decision = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for decision to set.
       * @return This builder for chaining.
       */
      public Builder setDecisionValue(int value) {
        decision_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Safety decision.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision decision = 1;
       * </code>
       *
       * @return The decision.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
              .SafetyDecision
          getDecision() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision
            result =
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
                    .SafetyDecision.forNumber(decision_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
                .SafetyDecision.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Safety decision.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision decision = 1;
       * </code>
       *
       * @param value The decision to set.
       * @return This builder for chaining.
       */
      public Builder setDecision(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        decision_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Safety decision.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.SafetyDecision decision = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDecision() {
        bitField0_ = (bitField0_ & ~0x00000001);
        decision_ = 0;
        onChanged();
        return this;
      }

      private int bannedPhraseMatch_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies banned phrase match subject.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch banned_phrase_match = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for bannedPhraseMatch.
       */
      @java.lang.Override
      public int getBannedPhraseMatchValue() {
        return bannedPhraseMatch_;
      }
      /**
       *
       *
       * <pre>
       * Specifies banned phrase match subject.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch banned_phrase_match = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for bannedPhraseMatch to set.
       * @return This builder for chaining.
       */
      public Builder setBannedPhraseMatchValue(int value) {
        bannedPhraseMatch_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies banned phrase match subject.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch banned_phrase_match = 2;
       * </code>
       *
       * @return The bannedPhraseMatch.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
              .BannedPhraseMatch
          getBannedPhraseMatch() {
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch
            result =
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
                    .BannedPhraseMatch.forNumber(bannedPhraseMatch_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
                .BannedPhraseMatch.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies banned phrase match subject.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch banned_phrase_match = 2;
       * </code>
       *
       * @param value The bannedPhraseMatch to set.
       * @return This builder for chaining.
       */
      public Builder setBannedPhraseMatch(
          com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
                  .BannedPhraseMatch
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        bannedPhraseMatch_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies banned phrase match subject.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.BannedPhraseMatch banned_phrase_match = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBannedPhraseMatch() {
        bitField0_ = (bitField0_ & ~0x00000002);
        bannedPhraseMatch_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object matchedBannedPhrase_ = "";
      /**
       *
       *
       * <pre>
       * The matched banned phrase if there was a match.
       * </pre>
       *
       * <code>string matched_banned_phrase = 3;</code>
       *
       * @return The matchedBannedPhrase.
       */
      public java.lang.String getMatchedBannedPhrase() {
        java.lang.Object ref = matchedBannedPhrase_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          matchedBannedPhrase_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The matched banned phrase if there was a match.
       * </pre>
       *
       * <code>string matched_banned_phrase = 3;</code>
       *
       * @return The bytes for matchedBannedPhrase.
       */
      public com.google.protobuf.ByteString getMatchedBannedPhraseBytes() {
        java.lang.Object ref = matchedBannedPhrase_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          matchedBannedPhrase_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The matched banned phrase if there was a match.
       * </pre>
       *
       * <code>string matched_banned_phrase = 3;</code>
       *
       * @param value The matchedBannedPhrase to set.
       * @return This builder for chaining.
       */
      public Builder setMatchedBannedPhrase(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        matchedBannedPhrase_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The matched banned phrase if there was a match.
       * </pre>
       *
       * <code>string matched_banned_phrase = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMatchedBannedPhrase() {
        matchedBannedPhrase_ = getDefaultInstance().getMatchedBannedPhrase();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The matched banned phrase if there was a match.
       * </pre>
       *
       * <code>string matched_banned_phrase = 3;</code>
       *
       * @param value The bytes for matchedBannedPhrase to set.
       * @return This builder for chaining.
       */
      public Builder setMatchedBannedPhraseBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        matchedBannedPhrase_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals)
    private static final com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals();
    }

    public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SafetySignals> PARSER =
        new com.google.protobuf.AbstractParser<SafetySignals>() {
          @java.lang.Override
          public SafetySignals parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SafetySignals> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SafetySignals> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int REWRITER_MODEL_CALL_SIGNALS_FIELD_NUMBER = 1;
  private com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
      rewriterModelCallSignals_;
  /**
   *
   *
   * <pre>
   * Optional. Diagnostic info related to the rewriter model call.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals rewriter_model_call_signals = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the rewriterModelCallSignals field is set.
   */
  @java.lang.Override
  public boolean hasRewriterModelCallSignals() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Diagnostic info related to the rewriter model call.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals rewriter_model_call_signals = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The rewriterModelCallSignals.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
      getRewriterModelCallSignals() {
    return rewriterModelCallSignals_ == null
        ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
            .getDefaultInstance()
        : rewriterModelCallSignals_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Diagnostic info related to the rewriter model call.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals rewriter_model_call_signals = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
          .RewriterModelCallSignalsOrBuilder
      getRewriterModelCallSignalsOrBuilder() {
    return rewriterModelCallSignals_ == null
        ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
            .getDefaultInstance()
        : rewriterModelCallSignals_;
  }

  public static final int REWRITTEN_QUERY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rewrittenQuery_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Rewritten string query used for search.
   * </pre>
   *
   * <code>string rewritten_query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The rewrittenQuery.
   */
  @java.lang.Override
  public java.lang.String getRewrittenQuery() {
    java.lang.Object ref = rewrittenQuery_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rewrittenQuery_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Rewritten string query used for search.
   * </pre>
   *
   * <code>string rewritten_query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for rewrittenQuery.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRewrittenQueryBytes() {
    java.lang.Object ref = rewrittenQuery_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rewrittenQuery_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SEARCH_SNIPPETS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet>
      searchSnippets_;
  /**
   *
   *
   * <pre>
   * Optional. Search snippets included in the answer generation prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet>
      getSearchSnippetsList() {
    return searchSnippets_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Search snippets included in the answer generation prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippetOrBuilder>
      getSearchSnippetsOrBuilderList() {
    return searchSnippets_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Search snippets included in the answer generation prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getSearchSnippetsCount() {
    return searchSnippets_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Search snippets included in the answer generation prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
      getSearchSnippets(int index) {
    return searchSnippets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Search snippets included in the answer generation prompt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippetOrBuilder
      getSearchSnippetsOrBuilder(int index) {
    return searchSnippets_.get(index);
  }

  public static final int ANSWER_GENERATION_MODEL_CALL_SIGNALS_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
          .AnswerGenerationModelCallSignals
      answerGenerationModelCallSignals_;
  /**
   *
   *
   * <pre>
   * Optional. Diagnostic info related to the answer generation model call.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals answer_generation_model_call_signals = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the answerGenerationModelCallSignals field is set.
   */
  @java.lang.Override
  public boolean hasAnswerGenerationModelCallSignals() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Diagnostic info related to the answer generation model call.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals answer_generation_model_call_signals = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The answerGenerationModelCallSignals.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
          .AnswerGenerationModelCallSignals
      getAnswerGenerationModelCallSignals() {
    return answerGenerationModelCallSignals_ == null
        ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals.getDefaultInstance()
        : answerGenerationModelCallSignals_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Diagnostic info related to the answer generation model call.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals answer_generation_model_call_signals = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
          .AnswerGenerationModelCallSignalsOrBuilder
      getAnswerGenerationModelCallSignalsOrBuilder() {
    return answerGenerationModelCallSignals_ == null
        ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals.getDefaultInstance()
        : answerGenerationModelCallSignals_;
  }

  public static final int ANSWER_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object answer_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The final compiled answer.
   * </pre>
   *
   * <code>string answer = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The answer.
   */
  @java.lang.Override
  public java.lang.String getAnswer() {
    java.lang.Object ref = answer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      answer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The final compiled answer.
   * </pre>
   *
   * <code>string answer = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for answer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnswerBytes() {
    java.lang.Object ref = answer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      answer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANSWER_PARTS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart>
      answerParts_;
  /**
   *
   *
   * <pre>
   * Optional. Answer parts with relevant citations.
   * Concatenation of texts should add up the `answer` (not counting
   * whitespaces).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart>
      getAnswerPartsList() {
    return answerParts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Answer parts with relevant citations.
   * Concatenation of texts should add up the `answer` (not counting
   * whitespaces).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPartOrBuilder>
      getAnswerPartsOrBuilderList() {
    return answerParts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Answer parts with relevant citations.
   * Concatenation of texts should add up the `answer` (not counting
   * whitespaces).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAnswerPartsCount() {
    return answerParts_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Answer parts with relevant citations.
   * Concatenation of texts should add up the `answer` (not counting
   * whitespaces).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart getAnswerParts(
      int index) {
    return answerParts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Answer parts with relevant citations.
   * Concatenation of texts should add up the `answer` (not counting
   * whitespaces).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPartOrBuilder
      getAnswerPartsOrBuilder(int index) {
    return answerParts_.get(index);
  }

  public static final int CITED_SNIPPETS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet>
      citedSnippets_;
  /**
   *
   *
   * <pre>
   * Optional. Snippets cited by the answer generation model from the most to
   * least relevant.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet>
      getCitedSnippetsList() {
    return citedSnippets_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Snippets cited by the answer generation model from the most to
   * least relevant.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippetOrBuilder>
      getCitedSnippetsOrBuilderList() {
    return citedSnippets_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Snippets cited by the answer generation model from the most to
   * least relevant.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getCitedSnippetsCount() {
    return citedSnippets_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Snippets cited by the answer generation model from the most to
   * least relevant.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet getCitedSnippets(
      int index) {
    return citedSnippets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Snippets cited by the answer generation model from the most to
   * least relevant.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippetOrBuilder
      getCitedSnippetsOrBuilder(int index) {
    return citedSnippets_.get(index);
  }

  public static final int GROUNDING_SIGNALS_FIELD_NUMBER = 8;
  private com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
      groundingSignals_;
  /**
   *
   *
   * <pre>
   * Optional. Grounding signals.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals grounding_signals = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the groundingSignals field is set.
   */
  @java.lang.Override
  public boolean hasGroundingSignals() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Grounding signals.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals grounding_signals = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The groundingSignals.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
      getGroundingSignals() {
    return groundingSignals_ == null
        ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
            .getDefaultInstance()
        : groundingSignals_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Grounding signals.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals grounding_signals = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignalsOrBuilder
      getGroundingSignalsOrBuilder() {
    return groundingSignals_ == null
        ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
            .getDefaultInstance()
        : groundingSignals_;
  }

  public static final int SAFETY_SIGNALS_FIELD_NUMBER = 9;
  private com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safetySignals_;
  /**
   *
   *
   * <pre>
   * Optional. Safety check result.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safety_signals = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the safetySignals field is set.
   */
  @java.lang.Override
  public boolean hasSafetySignals() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Safety check result.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safety_signals = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The safetySignals.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
      getSafetySignals() {
    return safetySignals_ == null
        ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
            .getDefaultInstance()
        : safetySignals_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Safety check result.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safety_signals = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignalsOrBuilder
      getSafetySignalsOrBuilder() {
    return safetySignals_ == null
        ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
            .getDefaultInstance()
        : safetySignals_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getRewriterModelCallSignals());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rewrittenQuery_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, rewrittenQuery_);
    }
    for (int i = 0; i < searchSnippets_.size(); i++) {
      output.writeMessage(3, searchSnippets_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getAnswerGenerationModelCallSignals());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, answer_);
    }
    for (int i = 0; i < answerParts_.size(); i++) {
      output.writeMessage(6, answerParts_.get(i));
    }
    for (int i = 0; i < citedSnippets_.size(); i++) {
      output.writeMessage(7, citedSnippets_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getGroundingSignals());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(9, getSafetySignals());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, getRewriterModelCallSignals());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rewrittenQuery_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, rewrittenQuery_);
    }
    for (int i = 0; i < searchSnippets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, searchSnippets_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, getAnswerGenerationModelCallSignals());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, answer_);
    }
    for (int i = 0; i < answerParts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, answerParts_.get(i));
    }
    for (int i = 0; i < citedSnippets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, citedSnippets_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getGroundingSignals());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getSafetySignals());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals other =
        (com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals) obj;

    if (hasRewriterModelCallSignals() != other.hasRewriterModelCallSignals()) return false;
    if (hasRewriterModelCallSignals()) {
      if (!getRewriterModelCallSignals().equals(other.getRewriterModelCallSignals())) return false;
    }
    if (!getRewrittenQuery().equals(other.getRewrittenQuery())) return false;
    if (!getSearchSnippetsList().equals(other.getSearchSnippetsList())) return false;
    if (hasAnswerGenerationModelCallSignals() != other.hasAnswerGenerationModelCallSignals())
      return false;
    if (hasAnswerGenerationModelCallSignals()) {
      if (!getAnswerGenerationModelCallSignals()
          .equals(other.getAnswerGenerationModelCallSignals())) return false;
    }
    if (!getAnswer().equals(other.getAnswer())) return false;
    if (!getAnswerPartsList().equals(other.getAnswerPartsList())) return false;
    if (!getCitedSnippetsList().equals(other.getCitedSnippetsList())) return false;
    if (hasGroundingSignals() != other.hasGroundingSignals()) return false;
    if (hasGroundingSignals()) {
      if (!getGroundingSignals().equals(other.getGroundingSignals())) return false;
    }
    if (hasSafetySignals() != other.hasSafetySignals()) return false;
    if (hasSafetySignals()) {
      if (!getSafetySignals().equals(other.getSafetySignals())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasRewriterModelCallSignals()) {
      hash = (37 * hash) + REWRITER_MODEL_CALL_SIGNALS_FIELD_NUMBER;
      hash = (53 * hash) + getRewriterModelCallSignals().hashCode();
    }
    hash = (37 * hash) + REWRITTEN_QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getRewrittenQuery().hashCode();
    if (getSearchSnippetsCount() > 0) {
      hash = (37 * hash) + SEARCH_SNIPPETS_FIELD_NUMBER;
      hash = (53 * hash) + getSearchSnippetsList().hashCode();
    }
    if (hasAnswerGenerationModelCallSignals()) {
      hash = (37 * hash) + ANSWER_GENERATION_MODEL_CALL_SIGNALS_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerGenerationModelCallSignals().hashCode();
    }
    hash = (37 * hash) + ANSWER_FIELD_NUMBER;
    hash = (53 * hash) + getAnswer().hashCode();
    if (getAnswerPartsCount() > 0) {
      hash = (37 * hash) + ANSWER_PARTS_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerPartsList().hashCode();
    }
    if (getCitedSnippetsCount() > 0) {
      hash = (37 * hash) + CITED_SNIPPETS_FIELD_NUMBER;
      hash = (53 * hash) + getCitedSnippetsList().hashCode();
    }
    if (hasGroundingSignals()) {
      hash = (37 * hash) + GROUNDING_SIGNALS_FIELD_NUMBER;
      hash = (53 * hash) + getGroundingSignals().hashCode();
    }
    if (hasSafetySignals()) {
      hash = (37 * hash) + SAFETY_SIGNALS_FIELD_NUMBER;
      hash = (53 * hash) + getSafetySignals().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Data store connection feature output signals.
   * Might be only partially field if processing stop before the final answer.
   * Reasons for this can be, but are not limited to: empty UCS search results,
   * positive RAI check outcome, grounding failure, ...
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals)
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignalsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.class,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRewriterModelCallSignalsFieldBuilder();
        getSearchSnippetsFieldBuilder();
        getAnswerGenerationModelCallSignalsFieldBuilder();
        getAnswerPartsFieldBuilder();
        getCitedSnippetsFieldBuilder();
        getGroundingSignalsFieldBuilder();
        getSafetySignalsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      rewriterModelCallSignals_ = null;
      if (rewriterModelCallSignalsBuilder_ != null) {
        rewriterModelCallSignalsBuilder_.dispose();
        rewriterModelCallSignalsBuilder_ = null;
      }
      rewrittenQuery_ = "";
      if (searchSnippetsBuilder_ == null) {
        searchSnippets_ = java.util.Collections.emptyList();
      } else {
        searchSnippets_ = null;
        searchSnippetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      answerGenerationModelCallSignals_ = null;
      if (answerGenerationModelCallSignalsBuilder_ != null) {
        answerGenerationModelCallSignalsBuilder_.dispose();
        answerGenerationModelCallSignalsBuilder_ = null;
      }
      answer_ = "";
      if (answerPartsBuilder_ == null) {
        answerParts_ = java.util.Collections.emptyList();
      } else {
        answerParts_ = null;
        answerPartsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (citedSnippetsBuilder_ == null) {
        citedSnippets_ = java.util.Collections.emptyList();
      } else {
        citedSnippets_ = null;
        citedSnippetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      groundingSignals_ = null;
      if (groundingSignalsBuilder_ != null) {
        groundingSignalsBuilder_.dispose();
        groundingSignalsBuilder_ = null;
      }
      safetySignals_ = null;
      if (safetySignalsBuilder_ != null) {
        safetySignalsBuilder_.dispose();
        safetySignalsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionProto
          .internal_static_google_cloud_dialogflow_cx_v3_DataStoreConnectionSignals_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals build() {
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals buildPartial() {
      com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals result =
          new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals result) {
      if (searchSnippetsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          searchSnippets_ = java.util.Collections.unmodifiableList(searchSnippets_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.searchSnippets_ = searchSnippets_;
      } else {
        result.searchSnippets_ = searchSnippetsBuilder_.build();
      }
      if (answerPartsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          answerParts_ = java.util.Collections.unmodifiableList(answerParts_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.answerParts_ = answerParts_;
      } else {
        result.answerParts_ = answerPartsBuilder_.build();
      }
      if (citedSnippetsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          citedSnippets_ = java.util.Collections.unmodifiableList(citedSnippets_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.citedSnippets_ = citedSnippets_;
      } else {
        result.citedSnippets_ = citedSnippetsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.rewriterModelCallSignals_ =
            rewriterModelCallSignalsBuilder_ == null
                ? rewriterModelCallSignals_
                : rewriterModelCallSignalsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.rewrittenQuery_ = rewrittenQuery_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.answerGenerationModelCallSignals_ =
            answerGenerationModelCallSignalsBuilder_ == null
                ? answerGenerationModelCallSignals_
                : answerGenerationModelCallSignalsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.answer_ = answer_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.groundingSignals_ =
            groundingSignalsBuilder_ == null ? groundingSignals_ : groundingSignalsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.safetySignals_ =
            safetySignalsBuilder_ == null ? safetySignals_ : safetySignalsBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals other) {
      if (other
          == com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.getDefaultInstance())
        return this;
      if (other.hasRewriterModelCallSignals()) {
        mergeRewriterModelCallSignals(other.getRewriterModelCallSignals());
      }
      if (!other.getRewrittenQuery().isEmpty()) {
        rewrittenQuery_ = other.rewrittenQuery_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (searchSnippetsBuilder_ == null) {
        if (!other.searchSnippets_.isEmpty()) {
          if (searchSnippets_.isEmpty()) {
            searchSnippets_ = other.searchSnippets_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureSearchSnippetsIsMutable();
            searchSnippets_.addAll(other.searchSnippets_);
          }
          onChanged();
        }
      } else {
        if (!other.searchSnippets_.isEmpty()) {
          if (searchSnippetsBuilder_.isEmpty()) {
            searchSnippetsBuilder_.dispose();
            searchSnippetsBuilder_ = null;
            searchSnippets_ = other.searchSnippets_;
            bitField0_ = (bitField0_ & ~0x00000004);
            searchSnippetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSearchSnippetsFieldBuilder()
                    : null;
          } else {
            searchSnippetsBuilder_.addAllMessages(other.searchSnippets_);
          }
        }
      }
      if (other.hasAnswerGenerationModelCallSignals()) {
        mergeAnswerGenerationModelCallSignals(other.getAnswerGenerationModelCallSignals());
      }
      if (!other.getAnswer().isEmpty()) {
        answer_ = other.answer_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (answerPartsBuilder_ == null) {
        if (!other.answerParts_.isEmpty()) {
          if (answerParts_.isEmpty()) {
            answerParts_ = other.answerParts_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureAnswerPartsIsMutable();
            answerParts_.addAll(other.answerParts_);
          }
          onChanged();
        }
      } else {
        if (!other.answerParts_.isEmpty()) {
          if (answerPartsBuilder_.isEmpty()) {
            answerPartsBuilder_.dispose();
            answerPartsBuilder_ = null;
            answerParts_ = other.answerParts_;
            bitField0_ = (bitField0_ & ~0x00000020);
            answerPartsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAnswerPartsFieldBuilder()
                    : null;
          } else {
            answerPartsBuilder_.addAllMessages(other.answerParts_);
          }
        }
      }
      if (citedSnippetsBuilder_ == null) {
        if (!other.citedSnippets_.isEmpty()) {
          if (citedSnippets_.isEmpty()) {
            citedSnippets_ = other.citedSnippets_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureCitedSnippetsIsMutable();
            citedSnippets_.addAll(other.citedSnippets_);
          }
          onChanged();
        }
      } else {
        if (!other.citedSnippets_.isEmpty()) {
          if (citedSnippetsBuilder_.isEmpty()) {
            citedSnippetsBuilder_.dispose();
            citedSnippetsBuilder_ = null;
            citedSnippets_ = other.citedSnippets_;
            bitField0_ = (bitField0_ & ~0x00000040);
            citedSnippetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCitedSnippetsFieldBuilder()
                    : null;
          } else {
            citedSnippetsBuilder_.addAllMessages(other.citedSnippets_);
          }
        }
      }
      if (other.hasGroundingSignals()) {
        mergeGroundingSignals(other.getGroundingSignals());
      }
      if (other.hasSafetySignals()) {
        mergeSafetySignals(other.getSafetySignals());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getRewriterModelCallSignalsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                rewrittenQuery_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
                            .parser(),
                        extensionRegistry);
                if (searchSnippetsBuilder_ == null) {
                  ensureSearchSnippetsIsMutable();
                  searchSnippets_.add(m);
                } else {
                  searchSnippetsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getAnswerGenerationModelCallSignalsFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                answer_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
                            .parser(),
                        extensionRegistry);
                if (answerPartsBuilder_ == null) {
                  ensureAnswerPartsIsMutable();
                  answerParts_.add(m);
                } else {
                  answerPartsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
                            .parser(),
                        extensionRegistry);
                if (citedSnippetsBuilder_ == null) {
                  ensureCitedSnippetsIsMutable();
                  citedSnippets_.add(m);
                } else {
                  citedSnippetsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getGroundingSignalsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getSafetySignalsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
        rewriterModelCallSignals_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
                .Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .RewriterModelCallSignalsOrBuilder>
        rewriterModelCallSignalsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the rewriter model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals rewriter_model_call_signals = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the rewriterModelCallSignals field is set.
     */
    public boolean hasRewriterModelCallSignals() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the rewriter model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals rewriter_model_call_signals = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rewriterModelCallSignals.
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
        getRewriterModelCallSignals() {
      if (rewriterModelCallSignalsBuilder_ == null) {
        return rewriterModelCallSignals_ == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
                .getDefaultInstance()
            : rewriterModelCallSignals_;
      } else {
        return rewriterModelCallSignalsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the rewriter model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals rewriter_model_call_signals = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRewriterModelCallSignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
            value) {
      if (rewriterModelCallSignalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rewriterModelCallSignals_ = value;
      } else {
        rewriterModelCallSignalsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the rewriter model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals rewriter_model_call_signals = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRewriterModelCallSignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
                .Builder
            builderForValue) {
      if (rewriterModelCallSignalsBuilder_ == null) {
        rewriterModelCallSignals_ = builderForValue.build();
      } else {
        rewriterModelCallSignalsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the rewriter model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals rewriter_model_call_signals = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRewriterModelCallSignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
            value) {
      if (rewriterModelCallSignalsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && rewriterModelCallSignals_ != null
            && rewriterModelCallSignals_
                != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .RewriterModelCallSignals.getDefaultInstance()) {
          getRewriterModelCallSignalsBuilder().mergeFrom(value);
        } else {
          rewriterModelCallSignals_ = value;
        }
      } else {
        rewriterModelCallSignalsBuilder_.mergeFrom(value);
      }
      if (rewriterModelCallSignals_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the rewriter model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals rewriter_model_call_signals = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRewriterModelCallSignals() {
      bitField0_ = (bitField0_ & ~0x00000001);
      rewriterModelCallSignals_ = null;
      if (rewriterModelCallSignalsBuilder_ != null) {
        rewriterModelCallSignalsBuilder_.dispose();
        rewriterModelCallSignalsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the rewriter model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals rewriter_model_call_signals = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
            .Builder
        getRewriterModelCallSignalsBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getRewriterModelCallSignalsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the rewriter model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals rewriter_model_call_signals = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .RewriterModelCallSignalsOrBuilder
        getRewriterModelCallSignalsOrBuilder() {
      if (rewriterModelCallSignalsBuilder_ != null) {
        return rewriterModelCallSignalsBuilder_.getMessageOrBuilder();
      } else {
        return rewriterModelCallSignals_ == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
                .getDefaultInstance()
            : rewriterModelCallSignals_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the rewriter model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals rewriter_model_call_signals = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.RewriterModelCallSignals
                .Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .RewriterModelCallSignalsOrBuilder>
        getRewriterModelCallSignalsFieldBuilder() {
      if (rewriterModelCallSignalsBuilder_ == null) {
        rewriterModelCallSignalsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .RewriterModelCallSignals,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .RewriterModelCallSignals.Builder,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .RewriterModelCallSignalsOrBuilder>(
                getRewriterModelCallSignals(), getParentForChildren(), isClean());
        rewriterModelCallSignals_ = null;
      }
      return rewriterModelCallSignalsBuilder_;
    }

    private java.lang.Object rewrittenQuery_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Rewritten string query used for search.
     * </pre>
     *
     * <code>string rewritten_query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The rewrittenQuery.
     */
    public java.lang.String getRewrittenQuery() {
      java.lang.Object ref = rewrittenQuery_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rewrittenQuery_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rewritten string query used for search.
     * </pre>
     *
     * <code>string rewritten_query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for rewrittenQuery.
     */
    public com.google.protobuf.ByteString getRewrittenQueryBytes() {
      java.lang.Object ref = rewrittenQuery_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rewrittenQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rewritten string query used for search.
     * </pre>
     *
     * <code>string rewritten_query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The rewrittenQuery to set.
     * @return This builder for chaining.
     */
    public Builder setRewrittenQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rewrittenQuery_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rewritten string query used for search.
     * </pre>
     *
     * <code>string rewritten_query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRewrittenQuery() {
      rewrittenQuery_ = getDefaultInstance().getRewrittenQuery();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rewritten string query used for search.
     * </pre>
     *
     * <code>string rewritten_query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for rewrittenQuery to set.
     * @return This builder for chaining.
     */
    public Builder setRewrittenQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rewrittenQuery_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet>
        searchSnippets_ = java.util.Collections.emptyList();

    private void ensureSearchSnippetsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        searchSnippets_ =
            new java.util.ArrayList<
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet>(
                searchSnippets_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippetOrBuilder>
        searchSnippetsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet>
        getSearchSnippetsList() {
      if (searchSnippetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(searchSnippets_);
      } else {
        return searchSnippetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getSearchSnippetsCount() {
      if (searchSnippetsBuilder_ == null) {
        return searchSnippets_.size();
      } else {
        return searchSnippetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
        getSearchSnippets(int index) {
      if (searchSnippetsBuilder_ == null) {
        return searchSnippets_.get(index);
      } else {
        return searchSnippetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSearchSnippets(
        int index,
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet value) {
      if (searchSnippetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSearchSnippetsIsMutable();
        searchSnippets_.set(index, value);
        onChanged();
      } else {
        searchSnippetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSearchSnippets(
        int index,
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder
            builderForValue) {
      if (searchSnippetsBuilder_ == null) {
        ensureSearchSnippetsIsMutable();
        searchSnippets_.set(index, builderForValue.build());
        onChanged();
      } else {
        searchSnippetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSearchSnippets(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet value) {
      if (searchSnippetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSearchSnippetsIsMutable();
        searchSnippets_.add(value);
        onChanged();
      } else {
        searchSnippetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSearchSnippets(
        int index,
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet value) {
      if (searchSnippetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSearchSnippetsIsMutable();
        searchSnippets_.add(index, value);
        onChanged();
      } else {
        searchSnippetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSearchSnippets(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder
            builderForValue) {
      if (searchSnippetsBuilder_ == null) {
        ensureSearchSnippetsIsMutable();
        searchSnippets_.add(builderForValue.build());
        onChanged();
      } else {
        searchSnippetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSearchSnippets(
        int index,
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder
            builderForValue) {
      if (searchSnippetsBuilder_ == null) {
        ensureSearchSnippetsIsMutable();
        searchSnippets_.add(index, builderForValue.build());
        onChanged();
      } else {
        searchSnippetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllSearchSnippets(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet>
            values) {
      if (searchSnippetsBuilder_ == null) {
        ensureSearchSnippetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, searchSnippets_);
        onChanged();
      } else {
        searchSnippetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSearchSnippets() {
      if (searchSnippetsBuilder_ == null) {
        searchSnippets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        searchSnippetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeSearchSnippets(int index) {
      if (searchSnippetsBuilder_ == null) {
        ensureSearchSnippetsIsMutable();
        searchSnippets_.remove(index);
        onChanged();
      } else {
        searchSnippetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder
        getSearchSnippetsBuilder(int index) {
      return getSearchSnippetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippetOrBuilder
        getSearchSnippetsOrBuilder(int index) {
      if (searchSnippetsBuilder_ == null) {
        return searchSnippets_.get(index);
      } else {
        return searchSnippetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippetOrBuilder>
        getSearchSnippetsOrBuilderList() {
      if (searchSnippetsBuilder_ != null) {
        return searchSnippetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(searchSnippets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder
        addSearchSnippetsBuilder() {
      return getSearchSnippetsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder
        addSearchSnippetsBuilder(int index) {
      return getSearchSnippetsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Search snippets included in the answer generation prompt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet search_snippets = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder>
        getSearchSnippetsBuilderList() {
      return getSearchSnippetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippetOrBuilder>
        getSearchSnippetsFieldBuilder() {
      if (searchSnippetsBuilder_ == null) {
        searchSnippetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SearchSnippet.Builder,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .SearchSnippetOrBuilder>(
                searchSnippets_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        searchSnippets_ = null;
      }
      return searchSnippetsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        answerGenerationModelCallSignals_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignalsOrBuilder>
        answerGenerationModelCallSignalsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the answer generation model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals answer_generation_model_call_signals = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the answerGenerationModelCallSignals field is set.
     */
    public boolean hasAnswerGenerationModelCallSignals() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the answer generation model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals answer_generation_model_call_signals = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The answerGenerationModelCallSignals.
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals
        getAnswerGenerationModelCallSignals() {
      if (answerGenerationModelCallSignalsBuilder_ == null) {
        return answerGenerationModelCallSignals_ == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals.getDefaultInstance()
            : answerGenerationModelCallSignals_;
      } else {
        return answerGenerationModelCallSignalsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the answer generation model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals answer_generation_model_call_signals = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAnswerGenerationModelCallSignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals
            value) {
      if (answerGenerationModelCallSignalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        answerGenerationModelCallSignals_ = value;
      } else {
        answerGenerationModelCallSignalsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the answer generation model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals answer_generation_model_call_signals = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAnswerGenerationModelCallSignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals.Builder
            builderForValue) {
      if (answerGenerationModelCallSignalsBuilder_ == null) {
        answerGenerationModelCallSignals_ = builderForValue.build();
      } else {
        answerGenerationModelCallSignalsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the answer generation model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals answer_generation_model_call_signals = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAnswerGenerationModelCallSignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals
            value) {
      if (answerGenerationModelCallSignalsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && answerGenerationModelCallSignals_ != null
            && answerGenerationModelCallSignals_
                != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .AnswerGenerationModelCallSignals.getDefaultInstance()) {
          getAnswerGenerationModelCallSignalsBuilder().mergeFrom(value);
        } else {
          answerGenerationModelCallSignals_ = value;
        }
      } else {
        answerGenerationModelCallSignalsBuilder_.mergeFrom(value);
      }
      if (answerGenerationModelCallSignals_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the answer generation model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals answer_generation_model_call_signals = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAnswerGenerationModelCallSignals() {
      bitField0_ = (bitField0_ & ~0x00000008);
      answerGenerationModelCallSignals_ = null;
      if (answerGenerationModelCallSignalsBuilder_ != null) {
        answerGenerationModelCallSignalsBuilder_.dispose();
        answerGenerationModelCallSignalsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the answer generation model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals answer_generation_model_call_signals = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignals.Builder
        getAnswerGenerationModelCallSignalsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAnswerGenerationModelCallSignalsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the answer generation model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals answer_generation_model_call_signals = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
            .AnswerGenerationModelCallSignalsOrBuilder
        getAnswerGenerationModelCallSignalsOrBuilder() {
      if (answerGenerationModelCallSignalsBuilder_ != null) {
        return answerGenerationModelCallSignalsBuilder_.getMessageOrBuilder();
      } else {
        return answerGenerationModelCallSignals_ == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals.getDefaultInstance()
            : answerGenerationModelCallSignals_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Diagnostic info related to the answer generation model call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerGenerationModelCallSignals answer_generation_model_call_signals = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignals.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                .AnswerGenerationModelCallSignalsOrBuilder>
        getAnswerGenerationModelCallSignalsFieldBuilder() {
      if (answerGenerationModelCallSignalsBuilder_ == null) {
        answerGenerationModelCallSignalsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .AnswerGenerationModelCallSignals,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .AnswerGenerationModelCallSignals.Builder,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .AnswerGenerationModelCallSignalsOrBuilder>(
                getAnswerGenerationModelCallSignals(), getParentForChildren(), isClean());
        answerGenerationModelCallSignals_ = null;
      }
      return answerGenerationModelCallSignalsBuilder_;
    }

    private java.lang.Object answer_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The final compiled answer.
     * </pre>
     *
     * <code>string answer = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The answer.
     */
    public java.lang.String getAnswer() {
      java.lang.Object ref = answer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The final compiled answer.
     * </pre>
     *
     * <code>string answer = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for answer.
     */
    public com.google.protobuf.ByteString getAnswerBytes() {
      java.lang.Object ref = answer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The final compiled answer.
     * </pre>
     *
     * <code>string answer = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The answer to set.
     * @return This builder for chaining.
     */
    public Builder setAnswer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      answer_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The final compiled answer.
     * </pre>
     *
     * <code>string answer = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnswer() {
      answer_ = getDefaultInstance().getAnswer();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The final compiled answer.
     * </pre>
     *
     * <code>string answer = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for answer to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      answer_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart>
        answerParts_ = java.util.Collections.emptyList();

    private void ensureAnswerPartsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        answerParts_ =
            new java.util.ArrayList<
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart>(
                answerParts_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPartOrBuilder>
        answerPartsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart>
        getAnswerPartsList() {
      if (answerPartsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(answerParts_);
      } else {
        return answerPartsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAnswerPartsCount() {
      if (answerPartsBuilder_ == null) {
        return answerParts_.size();
      } else {
        return answerPartsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart getAnswerParts(
        int index) {
      if (answerPartsBuilder_ == null) {
        return answerParts_.get(index);
      } else {
        return answerPartsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAnswerParts(
        int index, com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart value) {
      if (answerPartsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswerPartsIsMutable();
        answerParts_.set(index, value);
        onChanged();
      } else {
        answerPartsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAnswerParts(
        int index,
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.Builder
            builderForValue) {
      if (answerPartsBuilder_ == null) {
        ensureAnswerPartsIsMutable();
        answerParts_.set(index, builderForValue.build());
        onChanged();
      } else {
        answerPartsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAnswerParts(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart value) {
      if (answerPartsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswerPartsIsMutable();
        answerParts_.add(value);
        onChanged();
      } else {
        answerPartsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAnswerParts(
        int index, com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart value) {
      if (answerPartsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswerPartsIsMutable();
        answerParts_.add(index, value);
        onChanged();
      } else {
        answerPartsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAnswerParts(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.Builder
            builderForValue) {
      if (answerPartsBuilder_ == null) {
        ensureAnswerPartsIsMutable();
        answerParts_.add(builderForValue.build());
        onChanged();
      } else {
        answerPartsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAnswerParts(
        int index,
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.Builder
            builderForValue) {
      if (answerPartsBuilder_ == null) {
        ensureAnswerPartsIsMutable();
        answerParts_.add(index, builderForValue.build());
        onChanged();
      } else {
        answerPartsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAnswerParts(
        java.lang.Iterable<
                ? extends com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart>
            values) {
      if (answerPartsBuilder_ == null) {
        ensureAnswerPartsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, answerParts_);
        onChanged();
      } else {
        answerPartsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAnswerParts() {
      if (answerPartsBuilder_ == null) {
        answerParts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        answerPartsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAnswerParts(int index) {
      if (answerPartsBuilder_ == null) {
        ensureAnswerPartsIsMutable();
        answerParts_.remove(index);
        onChanged();
      } else {
        answerPartsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.Builder
        getAnswerPartsBuilder(int index) {
      return getAnswerPartsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPartOrBuilder
        getAnswerPartsOrBuilder(int index) {
      if (answerPartsBuilder_ == null) {
        return answerParts_.get(index);
      } else {
        return answerPartsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPartOrBuilder>
        getAnswerPartsOrBuilderList() {
      if (answerPartsBuilder_ != null) {
        return answerPartsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(answerParts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.Builder
        addAnswerPartsBuilder() {
      return getAnswerPartsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.Builder
        addAnswerPartsBuilder(int index) {
      return getAnswerPartsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer parts with relevant citations.
     * Concatenation of texts should add up the `answer` (not counting
     * whitespaces).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart answer_parts = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.Builder>
        getAnswerPartsBuilderList() {
      return getAnswerPartsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPartOrBuilder>
        getAnswerPartsFieldBuilder() {
      if (answerPartsBuilder_ == null) {
        answerPartsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPart.Builder,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.AnswerPartOrBuilder>(
                answerParts_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        answerParts_ = null;
      }
      return answerPartsBuilder_;
    }

    private java.util.List<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet>
        citedSnippets_ = java.util.Collections.emptyList();

    private void ensureCitedSnippetsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        citedSnippets_ =
            new java.util.ArrayList<
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet>(
                citedSnippets_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippetOrBuilder>
        citedSnippetsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet>
        getCitedSnippetsList() {
      if (citedSnippetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(citedSnippets_);
      } else {
        return citedSnippetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getCitedSnippetsCount() {
      if (citedSnippetsBuilder_ == null) {
        return citedSnippets_.size();
      } else {
        return citedSnippetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
        getCitedSnippets(int index) {
      if (citedSnippetsBuilder_ == null) {
        return citedSnippets_.get(index);
      } else {
        return citedSnippetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCitedSnippets(
        int index,
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet value) {
      if (citedSnippetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCitedSnippetsIsMutable();
        citedSnippets_.set(index, value);
        onChanged();
      } else {
        citedSnippetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCitedSnippets(
        int index,
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.Builder
            builderForValue) {
      if (citedSnippetsBuilder_ == null) {
        ensureCitedSnippetsIsMutable();
        citedSnippets_.set(index, builderForValue.build());
        onChanged();
      } else {
        citedSnippetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addCitedSnippets(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet value) {
      if (citedSnippetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCitedSnippetsIsMutable();
        citedSnippets_.add(value);
        onChanged();
      } else {
        citedSnippetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addCitedSnippets(
        int index,
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet value) {
      if (citedSnippetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCitedSnippetsIsMutable();
        citedSnippets_.add(index, value);
        onChanged();
      } else {
        citedSnippetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addCitedSnippets(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.Builder
            builderForValue) {
      if (citedSnippetsBuilder_ == null) {
        ensureCitedSnippetsIsMutable();
        citedSnippets_.add(builderForValue.build());
        onChanged();
      } else {
        citedSnippetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addCitedSnippets(
        int index,
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.Builder
            builderForValue) {
      if (citedSnippetsBuilder_ == null) {
        ensureCitedSnippetsIsMutable();
        citedSnippets_.add(index, builderForValue.build());
        onChanged();
      } else {
        citedSnippetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllCitedSnippets(
        java.lang.Iterable<
                ? extends com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet>
            values) {
      if (citedSnippetsBuilder_ == null) {
        ensureCitedSnippetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, citedSnippets_);
        onChanged();
      } else {
        citedSnippetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCitedSnippets() {
      if (citedSnippetsBuilder_ == null) {
        citedSnippets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        citedSnippetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeCitedSnippets(int index) {
      if (citedSnippetsBuilder_ == null) {
        ensureCitedSnippetsIsMutable();
        citedSnippets_.remove(index);
        onChanged();
      } else {
        citedSnippetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.Builder
        getCitedSnippetsBuilder(int index) {
      return getCitedSnippetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippetOrBuilder
        getCitedSnippetsOrBuilder(int index) {
      if (citedSnippetsBuilder_ == null) {
        return citedSnippets_.get(index);
      } else {
        return citedSnippetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippetOrBuilder>
        getCitedSnippetsOrBuilderList() {
      if (citedSnippetsBuilder_ != null) {
        return citedSnippetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(citedSnippets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.Builder
        addCitedSnippetsBuilder() {
      return getCitedSnippetsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.Builder
        addCitedSnippetsBuilder(int index) {
      return getCitedSnippetsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Snippets cited by the answer generation model from the most to
     * least relevant.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet cited_snippets = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.Builder>
        getCitedSnippetsBuilderList() {
      return getCitedSnippetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippetOrBuilder>
        getCitedSnippetsFieldBuilder() {
      if (citedSnippetsBuilder_ == null) {
        citedSnippetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippet.Builder,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.CitedSnippetOrBuilder>(
                citedSnippets_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        citedSnippets_ = null;
      }
      return citedSnippetsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        groundingSignals_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignalsOrBuilder>
        groundingSignalsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Grounding signals.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals grounding_signals = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the groundingSignals field is set.
     */
    public boolean hasGroundingSignals() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Grounding signals.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals grounding_signals = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The groundingSignals.
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
        getGroundingSignals() {
      if (groundingSignalsBuilder_ == null) {
        return groundingSignals_ == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                .getDefaultInstance()
            : groundingSignals_;
      } else {
        return groundingSignalsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Grounding signals.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals grounding_signals = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGroundingSignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals value) {
      if (groundingSignalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        groundingSignals_ = value;
      } else {
        groundingSignalsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Grounding signals.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals grounding_signals = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGroundingSignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.Builder
            builderForValue) {
      if (groundingSignalsBuilder_ == null) {
        groundingSignals_ = builderForValue.build();
      } else {
        groundingSignalsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Grounding signals.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals grounding_signals = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGroundingSignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals value) {
      if (groundingSignalsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && groundingSignals_ != null
            && groundingSignals_
                != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                    .getDefaultInstance()) {
          getGroundingSignalsBuilder().mergeFrom(value);
        } else {
          groundingSignals_ = value;
        }
      } else {
        groundingSignalsBuilder_.mergeFrom(value);
      }
      if (groundingSignals_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Grounding signals.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals grounding_signals = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGroundingSignals() {
      bitField0_ = (bitField0_ & ~0x00000080);
      groundingSignals_ = null;
      if (groundingSignalsBuilder_ != null) {
        groundingSignalsBuilder_.dispose();
        groundingSignalsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Grounding signals.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals grounding_signals = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.Builder
        getGroundingSignalsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getGroundingSignalsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Grounding signals.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals grounding_signals = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignalsOrBuilder
        getGroundingSignalsOrBuilder() {
      if (groundingSignalsBuilder_ != null) {
        return groundingSignalsBuilder_.getMessageOrBuilder();
      } else {
        return groundingSignals_ == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                .getDefaultInstance()
            : groundingSignals_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Grounding signals.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals grounding_signals = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignalsOrBuilder>
        getGroundingSignalsFieldBuilder() {
      if (groundingSignalsBuilder_ == null) {
        groundingSignalsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.GroundingSignals
                    .Builder,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .GroundingSignalsOrBuilder>(
                getGroundingSignals(), getParentForChildren(), isClean());
        groundingSignals_ = null;
      }
      return groundingSignalsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        safetySignals_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignalsOrBuilder>
        safetySignalsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Safety check result.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safety_signals = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the safetySignals field is set.
     */
    public boolean hasSafetySignals() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Safety check result.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safety_signals = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The safetySignals.
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
        getSafetySignals() {
      if (safetySignalsBuilder_ == null) {
        return safetySignals_ == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
                .getDefaultInstance()
            : safetySignals_;
      } else {
        return safetySignalsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Safety check result.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safety_signals = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSafetySignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals value) {
      if (safetySignalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        safetySignals_ = value;
      } else {
        safetySignalsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Safety check result.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safety_signals = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSafetySignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.Builder
            builderForValue) {
      if (safetySignalsBuilder_ == null) {
        safetySignals_ = builderForValue.build();
      } else {
        safetySignalsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Safety check result.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safety_signals = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSafetySignals(
        com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals value) {
      if (safetySignalsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && safetySignals_ != null
            && safetySignals_
                != com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
                    .getDefaultInstance()) {
          getSafetySignalsBuilder().mergeFrom(value);
        } else {
          safetySignals_ = value;
        }
      } else {
        safetySignalsBuilder_.mergeFrom(value);
      }
      if (safetySignals_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Safety check result.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safety_signals = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSafetySignals() {
      bitField0_ = (bitField0_ & ~0x00000100);
      safetySignals_ = null;
      if (safetySignalsBuilder_ != null) {
        safetySignalsBuilder_.dispose();
        safetySignalsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Safety check result.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safety_signals = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.Builder
        getSafetySignalsBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getSafetySignalsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Safety check result.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safety_signals = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignalsOrBuilder
        getSafetySignalsOrBuilder() {
      if (safetySignalsBuilder_ != null) {
        return safetySignalsBuilder_.getMessageOrBuilder();
      } else {
        return safetySignals_ == null
            ? com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals
                .getDefaultInstance()
            : safetySignals_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Safety check result.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals safety_signals = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.Builder,
            com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignalsOrBuilder>
        getSafetySignalsFieldBuilder() {
      if (safetySignalsBuilder_ == null) {
        safetySignalsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals.SafetySignals.Builder,
                com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
                    .SafetySignalsOrBuilder>(getSafetySignals(), getParentForChildren(), isClean());
        safetySignals_ = null;
      }
      return safetySignalsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals)
  private static final com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals();
  }

  public static com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataStoreConnectionSignals> PARSER =
      new com.google.protobuf.AbstractParser<DataStoreConnectionSignals>() {
        @java.lang.Override
        public DataStoreConnectionSignals parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataStoreConnectionSignals> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataStoreConnectionSignals> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.DataStoreConnectionSignals getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
