/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/test_case.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * One interaction between a human and virtual agent. The human provides some
 * input and the virtual agent provides a response.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.ConversationTurn}
 */
public final class ConversationTurn extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.ConversationTurn)
    ConversationTurnOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConversationTurn.newBuilder() to construct.
  private ConversationTurn(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConversationTurn() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConversationTurn();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.class,
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.Builder.class);
  }

  public interface UserInputOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
     * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
     * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
     *
     * @return Whether the input field is set.
     */
    boolean hasInput();
    /**
     *
     *
     * <pre>
     * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
     * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
     * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
     *
     * @return The input.
     */
    com.google.cloud.dialogflow.cx.v3.QueryInput getInput();
    /**
     *
     *
     * <pre>
     * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
     * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
     * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
     */
    com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder getInputOrBuilder();

    /**
     *
     *
     * <pre>
     * Parameters that need to be injected into the conversation during intent
     * detection.
     * </pre>
     *
     * <code>.google.protobuf.Struct injected_parameters = 2;</code>
     *
     * @return Whether the injectedParameters field is set.
     */
    boolean hasInjectedParameters();
    /**
     *
     *
     * <pre>
     * Parameters that need to be injected into the conversation during intent
     * detection.
     * </pre>
     *
     * <code>.google.protobuf.Struct injected_parameters = 2;</code>
     *
     * @return The injectedParameters.
     */
    com.google.protobuf.Struct getInjectedParameters();
    /**
     *
     *
     * <pre>
     * Parameters that need to be injected into the conversation during intent
     * detection.
     * </pre>
     *
     * <code>.google.protobuf.Struct injected_parameters = 2;</code>
     */
    com.google.protobuf.StructOrBuilder getInjectedParametersOrBuilder();

    /**
     *
     *
     * <pre>
     * If webhooks should be allowed to trigger in response to the user
     * utterance. Often if parameters are injected, webhooks should not be
     * enabled.
     * </pre>
     *
     * <code>bool is_webhook_enabled = 3;</code>
     *
     * @return The isWebhookEnabled.
     */
    boolean getIsWebhookEnabled();

    /**
     *
     *
     * <pre>
     * Whether sentiment analysis is enabled.
     * </pre>
     *
     * <code>bool enable_sentiment_analysis = 7;</code>
     *
     * @return The enableSentimentAnalysis.
     */
    boolean getEnableSentimentAnalysis();
  }
  /**
   *
   *
   * <pre>
   * The input from the human user.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput}
   */
  public static final class UserInput extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput)
      UserInputOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UserInput.newBuilder() to construct.
    private UserInput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UserInput() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UserInput();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_UserInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_UserInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.class,
              com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.Builder.class);
    }

    private int bitField0_;
    public static final int INPUT_FIELD_NUMBER = 5;
    private com.google.cloud.dialogflow.cx.v3.QueryInput input_;
    /**
     *
     *
     * <pre>
     * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
     * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
     * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
     *
     * @return Whether the input field is set.
     */
    @java.lang.Override
    public boolean hasInput() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
     * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
     * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
     *
     * @return The input.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.QueryInput getInput() {
      return input_ == null
          ? com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()
          : input_;
    }
    /**
     *
     *
     * <pre>
     * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
     * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
     * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder getInputOrBuilder() {
      return input_ == null
          ? com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()
          : input_;
    }

    public static final int INJECTED_PARAMETERS_FIELD_NUMBER = 2;
    private com.google.protobuf.Struct injectedParameters_;
    /**
     *
     *
     * <pre>
     * Parameters that need to be injected into the conversation during intent
     * detection.
     * </pre>
     *
     * <code>.google.protobuf.Struct injected_parameters = 2;</code>
     *
     * @return Whether the injectedParameters field is set.
     */
    @java.lang.Override
    public boolean hasInjectedParameters() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters that need to be injected into the conversation during intent
     * detection.
     * </pre>
     *
     * <code>.google.protobuf.Struct injected_parameters = 2;</code>
     *
     * @return The injectedParameters.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getInjectedParameters() {
      return injectedParameters_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : injectedParameters_;
    }
    /**
     *
     *
     * <pre>
     * Parameters that need to be injected into the conversation during intent
     * detection.
     * </pre>
     *
     * <code>.google.protobuf.Struct injected_parameters = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getInjectedParametersOrBuilder() {
      return injectedParameters_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : injectedParameters_;
    }

    public static final int IS_WEBHOOK_ENABLED_FIELD_NUMBER = 3;
    private boolean isWebhookEnabled_ = false;
    /**
     *
     *
     * <pre>
     * If webhooks should be allowed to trigger in response to the user
     * utterance. Often if parameters are injected, webhooks should not be
     * enabled.
     * </pre>
     *
     * <code>bool is_webhook_enabled = 3;</code>
     *
     * @return The isWebhookEnabled.
     */
    @java.lang.Override
    public boolean getIsWebhookEnabled() {
      return isWebhookEnabled_;
    }

    public static final int ENABLE_SENTIMENT_ANALYSIS_FIELD_NUMBER = 7;
    private boolean enableSentimentAnalysis_ = false;
    /**
     *
     *
     * <pre>
     * Whether sentiment analysis is enabled.
     * </pre>
     *
     * <code>bool enable_sentiment_analysis = 7;</code>
     *
     * @return The enableSentimentAnalysis.
     */
    @java.lang.Override
    public boolean getEnableSentimentAnalysis() {
      return enableSentimentAnalysis_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getInjectedParameters());
      }
      if (isWebhookEnabled_ != false) {
        output.writeBool(3, isWebhookEnabled_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(5, getInput());
      }
      if (enableSentimentAnalysis_ != false) {
        output.writeBool(7, enableSentimentAnalysis_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getInjectedParameters());
      }
      if (isWebhookEnabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, isWebhookEnabled_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getInput());
      }
      if (enableSentimentAnalysis_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, enableSentimentAnalysis_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput other =
          (com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput) obj;

      if (hasInput() != other.hasInput()) return false;
      if (hasInput()) {
        if (!getInput().equals(other.getInput())) return false;
      }
      if (hasInjectedParameters() != other.hasInjectedParameters()) return false;
      if (hasInjectedParameters()) {
        if (!getInjectedParameters().equals(other.getInjectedParameters())) return false;
      }
      if (getIsWebhookEnabled() != other.getIsWebhookEnabled()) return false;
      if (getEnableSentimentAnalysis() != other.getEnableSentimentAnalysis()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasInput()) {
        hash = (37 * hash) + INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getInput().hashCode();
      }
      if (hasInjectedParameters()) {
        hash = (37 * hash) + INJECTED_PARAMETERS_FIELD_NUMBER;
        hash = (53 * hash) + getInjectedParameters().hashCode();
      }
      hash = (37 * hash) + IS_WEBHOOK_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsWebhookEnabled());
      hash = (37 * hash) + ENABLE_SENTIMENT_ANALYSIS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableSentimentAnalysis());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The input from the human user.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput)
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInputOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_UserInput_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_UserInput_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.class,
                com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getInputFieldBuilder();
          getInjectedParametersFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        input_ = null;
        if (inputBuilder_ != null) {
          inputBuilder_.dispose();
          inputBuilder_ = null;
        }
        injectedParameters_ = null;
        if (injectedParametersBuilder_ != null) {
          injectedParametersBuilder_.dispose();
          injectedParametersBuilder_ = null;
        }
        isWebhookEnabled_ = false;
        enableSentimentAnalysis_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_UserInput_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput build() {
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput buildPartial() {
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput result =
            new com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.input_ = inputBuilder_ == null ? input_ : inputBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.injectedParameters_ =
              injectedParametersBuilder_ == null
                  ? injectedParameters_
                  : injectedParametersBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.isWebhookEnabled_ = isWebhookEnabled_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.enableSentimentAnalysis_ = enableSentimentAnalysis_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.getDefaultInstance())
          return this;
        if (other.hasInput()) {
          mergeInput(other.getInput());
        }
        if (other.hasInjectedParameters()) {
          mergeInjectedParameters(other.getInjectedParameters());
        }
        if (other.getIsWebhookEnabled() != false) {
          setIsWebhookEnabled(other.getIsWebhookEnabled());
        }
        if (other.getEnableSentimentAnalysis() != false) {
          setEnableSentimentAnalysis(other.getEnableSentimentAnalysis());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  input.readMessage(
                      getInjectedParametersFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  isWebhookEnabled_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 42:
                {
                  input.readMessage(getInputFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 42
              case 56:
                {
                  enableSentimentAnalysis_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 56
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.dialogflow.cx.v3.QueryInput input_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.QueryInput,
              com.google.cloud.dialogflow.cx.v3.QueryInput.Builder,
              com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder>
          inputBuilder_;
      /**
       *
       *
       * <pre>
       * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
       * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
       * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
       *
       * @return Whether the input field is set.
       */
      public boolean hasInput() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
       * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
       * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
       *
       * @return The input.
       */
      public com.google.cloud.dialogflow.cx.v3.QueryInput getInput() {
        if (inputBuilder_ == null) {
          return input_ == null
              ? com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()
              : input_;
        } else {
          return inputBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
       * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
       * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
       */
      public Builder setInput(com.google.cloud.dialogflow.cx.v3.QueryInput value) {
        if (inputBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          input_ = value;
        } else {
          inputBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
       * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
       * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
       */
      public Builder setInput(
          com.google.cloud.dialogflow.cx.v3.QueryInput.Builder builderForValue) {
        if (inputBuilder_ == null) {
          input_ = builderForValue.build();
        } else {
          inputBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
       * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
       * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
       */
      public Builder mergeInput(com.google.cloud.dialogflow.cx.v3.QueryInput value) {
        if (inputBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && input_ != null
              && input_ != com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()) {
            getInputBuilder().mergeFrom(value);
          } else {
            input_ = value;
          }
        } else {
          inputBuilder_.mergeFrom(value);
        }
        if (input_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
       * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
       * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
       */
      public Builder clearInput() {
        bitField0_ = (bitField0_ & ~0x00000001);
        input_ = null;
        if (inputBuilder_ != null) {
          inputBuilder_.dispose();
          inputBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
       * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
       * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.QueryInput.Builder getInputBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getInputFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
       * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
       * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder getInputOrBuilder() {
        if (inputBuilder_ != null) {
          return inputBuilder_.getMessageOrBuilder();
        } else {
          return input_ == null
              ? com.google.cloud.dialogflow.cx.v3.QueryInput.getDefaultInstance()
              : input_;
        }
      }
      /**
       *
       *
       * <pre>
       * Supports [text input][google.cloud.dialogflow.cx.v3.QueryInput.text],
       * [event input][google.cloud.dialogflow.cx.v3.QueryInput.event], [dtmf
       * input][google.cloud.dialogflow.cx.v3.QueryInput.dtmf] in the test case.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.QueryInput input = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.QueryInput,
              com.google.cloud.dialogflow.cx.v3.QueryInput.Builder,
              com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder>
          getInputFieldBuilder() {
        if (inputBuilder_ == null) {
          inputBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.QueryInput,
                  com.google.cloud.dialogflow.cx.v3.QueryInput.Builder,
                  com.google.cloud.dialogflow.cx.v3.QueryInputOrBuilder>(
                  getInput(), getParentForChildren(), isClean());
          input_ = null;
        }
        return inputBuilder_;
      }

      private com.google.protobuf.Struct injectedParameters_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          injectedParametersBuilder_;
      /**
       *
       *
       * <pre>
       * Parameters that need to be injected into the conversation during intent
       * detection.
       * </pre>
       *
       * <code>.google.protobuf.Struct injected_parameters = 2;</code>
       *
       * @return Whether the injectedParameters field is set.
       */
      public boolean hasInjectedParameters() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Parameters that need to be injected into the conversation during intent
       * detection.
       * </pre>
       *
       * <code>.google.protobuf.Struct injected_parameters = 2;</code>
       *
       * @return The injectedParameters.
       */
      public com.google.protobuf.Struct getInjectedParameters() {
        if (injectedParametersBuilder_ == null) {
          return injectedParameters_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : injectedParameters_;
        } else {
          return injectedParametersBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Parameters that need to be injected into the conversation during intent
       * detection.
       * </pre>
       *
       * <code>.google.protobuf.Struct injected_parameters = 2;</code>
       */
      public Builder setInjectedParameters(com.google.protobuf.Struct value) {
        if (injectedParametersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          injectedParameters_ = value;
        } else {
          injectedParametersBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parameters that need to be injected into the conversation during intent
       * detection.
       * </pre>
       *
       * <code>.google.protobuf.Struct injected_parameters = 2;</code>
       */
      public Builder setInjectedParameters(com.google.protobuf.Struct.Builder builderForValue) {
        if (injectedParametersBuilder_ == null) {
          injectedParameters_ = builderForValue.build();
        } else {
          injectedParametersBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parameters that need to be injected into the conversation during intent
       * detection.
       * </pre>
       *
       * <code>.google.protobuf.Struct injected_parameters = 2;</code>
       */
      public Builder mergeInjectedParameters(com.google.protobuf.Struct value) {
        if (injectedParametersBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && injectedParameters_ != null
              && injectedParameters_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getInjectedParametersBuilder().mergeFrom(value);
          } else {
            injectedParameters_ = value;
          }
        } else {
          injectedParametersBuilder_.mergeFrom(value);
        }
        if (injectedParameters_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parameters that need to be injected into the conversation during intent
       * detection.
       * </pre>
       *
       * <code>.google.protobuf.Struct injected_parameters = 2;</code>
       */
      public Builder clearInjectedParameters() {
        bitField0_ = (bitField0_ & ~0x00000002);
        injectedParameters_ = null;
        if (injectedParametersBuilder_ != null) {
          injectedParametersBuilder_.dispose();
          injectedParametersBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parameters that need to be injected into the conversation during intent
       * detection.
       * </pre>
       *
       * <code>.google.protobuf.Struct injected_parameters = 2;</code>
       */
      public com.google.protobuf.Struct.Builder getInjectedParametersBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getInjectedParametersFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Parameters that need to be injected into the conversation during intent
       * detection.
       * </pre>
       *
       * <code>.google.protobuf.Struct injected_parameters = 2;</code>
       */
      public com.google.protobuf.StructOrBuilder getInjectedParametersOrBuilder() {
        if (injectedParametersBuilder_ != null) {
          return injectedParametersBuilder_.getMessageOrBuilder();
        } else {
          return injectedParameters_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : injectedParameters_;
        }
      }
      /**
       *
       *
       * <pre>
       * Parameters that need to be injected into the conversation during intent
       * detection.
       * </pre>
       *
       * <code>.google.protobuf.Struct injected_parameters = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getInjectedParametersFieldBuilder() {
        if (injectedParametersBuilder_ == null) {
          injectedParametersBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getInjectedParameters(), getParentForChildren(), isClean());
          injectedParameters_ = null;
        }
        return injectedParametersBuilder_;
      }

      private boolean isWebhookEnabled_;
      /**
       *
       *
       * <pre>
       * If webhooks should be allowed to trigger in response to the user
       * utterance. Often if parameters are injected, webhooks should not be
       * enabled.
       * </pre>
       *
       * <code>bool is_webhook_enabled = 3;</code>
       *
       * @return The isWebhookEnabled.
       */
      @java.lang.Override
      public boolean getIsWebhookEnabled() {
        return isWebhookEnabled_;
      }
      /**
       *
       *
       * <pre>
       * If webhooks should be allowed to trigger in response to the user
       * utterance. Often if parameters are injected, webhooks should not be
       * enabled.
       * </pre>
       *
       * <code>bool is_webhook_enabled = 3;</code>
       *
       * @param value The isWebhookEnabled to set.
       * @return This builder for chaining.
       */
      public Builder setIsWebhookEnabled(boolean value) {

        isWebhookEnabled_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If webhooks should be allowed to trigger in response to the user
       * utterance. Often if parameters are injected, webhooks should not be
       * enabled.
       * </pre>
       *
       * <code>bool is_webhook_enabled = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsWebhookEnabled() {
        bitField0_ = (bitField0_ & ~0x00000004);
        isWebhookEnabled_ = false;
        onChanged();
        return this;
      }

      private boolean enableSentimentAnalysis_;
      /**
       *
       *
       * <pre>
       * Whether sentiment analysis is enabled.
       * </pre>
       *
       * <code>bool enable_sentiment_analysis = 7;</code>
       *
       * @return The enableSentimentAnalysis.
       */
      @java.lang.Override
      public boolean getEnableSentimentAnalysis() {
        return enableSentimentAnalysis_;
      }
      /**
       *
       *
       * <pre>
       * Whether sentiment analysis is enabled.
       * </pre>
       *
       * <code>bool enable_sentiment_analysis = 7;</code>
       *
       * @param value The enableSentimentAnalysis to set.
       * @return This builder for chaining.
       */
      public Builder setEnableSentimentAnalysis(boolean value) {

        enableSentimentAnalysis_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether sentiment analysis is enabled.
       * </pre>
       *
       * <code>bool enable_sentiment_analysis = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableSentimentAnalysis() {
        bitField0_ = (bitField0_ & ~0x00000008);
        enableSentimentAnalysis_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput)
    private static final com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput();
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UserInput> PARSER =
        new com.google.protobuf.AbstractParser<UserInput>() {
          @java.lang.Override
          public UserInput parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UserInput> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UserInput> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VirtualAgentOutputOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The session parameters available to the bot at this point.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_parameters = 4;</code>
     *
     * @return Whether the sessionParameters field is set.
     */
    boolean hasSessionParameters();
    /**
     *
     *
     * <pre>
     * The session parameters available to the bot at this point.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_parameters = 4;</code>
     *
     * @return The sessionParameters.
     */
    com.google.protobuf.Struct getSessionParameters();
    /**
     *
     *
     * <pre>
     * The session parameters available to the bot at this point.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_parameters = 4;</code>
     */
    com.google.protobuf.StructOrBuilder getSessionParametersOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. If this is part of a [result conversation
     * turn][TestCaseResult.conversation_turns], the list of differences
     * between the original run and the replay for this output, if any.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3.TestRunDifference> getDifferencesList();
    /**
     *
     *
     * <pre>
     * Output only. If this is part of a [result conversation
     * turn][TestCaseResult.conversation_turns], the list of differences
     * between the original run and the replay for this output, if any.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.TestRunDifference getDifferences(int index);
    /**
     *
     *
     * <pre>
     * Output only. If this is part of a [result conversation
     * turn][TestCaseResult.conversation_turns], the list of differences
     * between the original run and the replay for this output, if any.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getDifferencesCount();
    /**
     *
     *
     * <pre>
     * Output only. If this is part of a [result conversation
     * turn][TestCaseResult.conversation_turns], the list of differences
     * between the original run and the replay for this output, if any.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<? extends com.google.cloud.dialogflow.cx.v3.TestRunDifferenceOrBuilder>
        getDifferencesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. If this is part of a [result conversation
     * turn][TestCaseResult.conversation_turns], the list of differences
     * between the original run and the replay for this output, if any.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.TestRunDifferenceOrBuilder getDifferencesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Required. Input only. The diagnostic
     * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
     * output for the turn. Required to calculate the testing coverage.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the diagnosticInfo field is set.
     */
    boolean hasDiagnosticInfo();
    /**
     *
     *
     * <pre>
     * Required. Input only. The diagnostic
     * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
     * output for the turn. Required to calculate the testing coverage.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The diagnosticInfo.
     */
    com.google.protobuf.Struct getDiagnosticInfo();
    /**
     *
     *
     * <pre>
     * Required. Input only. The diagnostic
     * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
     * output for the turn. Required to calculate the testing coverage.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    com.google.protobuf.StructOrBuilder getDiagnosticInfoOrBuilder();

    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
     * response. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
     *
     * @return Whether the triggeredIntent field is set.
     */
    boolean hasTriggeredIntent();
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
     * response. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
     *
     * @return The triggeredIntent.
     */
    com.google.cloud.dialogflow.cx.v3.Intent getTriggeredIntent();
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
     * response. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
     */
    com.google.cloud.dialogflow.cx.v3.IntentOrBuilder getTriggeredIntentOrBuilder();

    /**
     *
     *
     * <pre>
     * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
     * spoken. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
     *
     * @return Whether the currentPage field is set.
     */
    boolean hasCurrentPage();
    /**
     *
     *
     * <pre>
     * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
     * spoken. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
     *
     * @return The currentPage.
     */
    com.google.cloud.dialogflow.cx.v3.Page getCurrentPage();
    /**
     *
     *
     * <pre>
     * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
     * spoken. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
     */
    com.google.cloud.dialogflow.cx.v3.PageOrBuilder getCurrentPageOrBuilder();

    /**
     *
     *
     * <pre>
     * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
     * from the agent for the turn.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;</code>
     */
    java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text> getTextResponsesList();
    /**
     *
     *
     * <pre>
     * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
     * from the agent for the turn.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;</code>
     */
    com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text getTextResponses(int index);
    /**
     *
     *
     * <pre>
     * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
     * from the agent for the turn.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;</code>
     */
    int getTextResponsesCount();
    /**
     *
     *
     * <pre>
     * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
     * from the agent for the turn.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;</code>
     */
    java.util.List<? extends com.google.cloud.dialogflow.cx.v3.ResponseMessage.TextOrBuilder>
        getTextResponsesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
     * from the agent for the turn.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;</code>
     */
    com.google.cloud.dialogflow.cx.v3.ResponseMessage.TextOrBuilder getTextResponsesOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Response error from the agent in the test result. If set, other output
     * is empty.
     * </pre>
     *
     * <code>.google.rpc.Status status = 10;</code>
     *
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * Response error from the agent in the test result. If set, other output
     * is empty.
     * </pre>
     *
     * <code>.google.rpc.Status status = 10;</code>
     *
     * @return The status.
     */
    com.google.rpc.Status getStatus();
    /**
     *
     *
     * <pre>
     * Response error from the agent in the test result. If set, other output
     * is empty.
     * </pre>
     *
     * <code>.google.rpc.Status status = 10;</code>
     */
    com.google.rpc.StatusOrBuilder getStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The output from the virtual agent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput}
   */
  public static final class VirtualAgentOutput extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput)
      VirtualAgentOutputOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VirtualAgentOutput.newBuilder() to construct.
    private VirtualAgentOutput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VirtualAgentOutput() {
      differences_ = java.util.Collections.emptyList();
      textResponses_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VirtualAgentOutput();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_VirtualAgentOutput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_VirtualAgentOutput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput.class,
              com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput.Builder.class);
    }

    private int bitField0_;
    public static final int SESSION_PARAMETERS_FIELD_NUMBER = 4;
    private com.google.protobuf.Struct sessionParameters_;
    /**
     *
     *
     * <pre>
     * The session parameters available to the bot at this point.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_parameters = 4;</code>
     *
     * @return Whether the sessionParameters field is set.
     */
    @java.lang.Override
    public boolean hasSessionParameters() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The session parameters available to the bot at this point.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_parameters = 4;</code>
     *
     * @return The sessionParameters.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getSessionParameters() {
      return sessionParameters_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : sessionParameters_;
    }
    /**
     *
     *
     * <pre>
     * The session parameters available to the bot at this point.
     * </pre>
     *
     * <code>.google.protobuf.Struct session_parameters = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getSessionParametersOrBuilder() {
      return sessionParameters_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : sessionParameters_;
    }

    public static final int DIFFERENCES_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dialogflow.cx.v3.TestRunDifference> differences_;
    /**
     *
     *
     * <pre>
     * Output only. If this is part of a [result conversation
     * turn][TestCaseResult.conversation_turns], the list of differences
     * between the original run and the replay for this output, if any.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3.TestRunDifference>
        getDifferencesList() {
      return differences_;
    }
    /**
     *
     *
     * <pre>
     * Output only. If this is part of a [result conversation
     * turn][TestCaseResult.conversation_turns], the list of differences
     * between the original run and the replay for this output, if any.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.TestRunDifferenceOrBuilder>
        getDifferencesOrBuilderList() {
      return differences_;
    }
    /**
     *
     *
     * <pre>
     * Output only. If this is part of a [result conversation
     * turn][TestCaseResult.conversation_turns], the list of differences
     * between the original run and the replay for this output, if any.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getDifferencesCount() {
      return differences_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. If this is part of a [result conversation
     * turn][TestCaseResult.conversation_turns], the list of differences
     * between the original run and the replay for this output, if any.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TestRunDifference getDifferences(int index) {
      return differences_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. If this is part of a [result conversation
     * turn][TestCaseResult.conversation_turns], the list of differences
     * between the original run and the replay for this output, if any.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.TestRunDifferenceOrBuilder getDifferencesOrBuilder(
        int index) {
      return differences_.get(index);
    }

    public static final int DIAGNOSTIC_INFO_FIELD_NUMBER = 6;
    private com.google.protobuf.Struct diagnosticInfo_;
    /**
     *
     *
     * <pre>
     * Required. Input only. The diagnostic
     * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
     * output for the turn. Required to calculate the testing coverage.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the diagnosticInfo field is set.
     */
    @java.lang.Override
    public boolean hasDiagnosticInfo() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The diagnostic
     * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
     * output for the turn. Required to calculate the testing coverage.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The diagnosticInfo.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getDiagnosticInfo() {
      return diagnosticInfo_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : diagnosticInfo_;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. The diagnostic
     * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
     * output for the turn. Required to calculate the testing coverage.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getDiagnosticInfoOrBuilder() {
      return diagnosticInfo_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : diagnosticInfo_;
    }

    public static final int TRIGGERED_INTENT_FIELD_NUMBER = 7;
    private com.google.cloud.dialogflow.cx.v3.Intent triggeredIntent_;
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
     * response. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
     *
     * @return Whether the triggeredIntent field is set.
     */
    @java.lang.Override
    public boolean hasTriggeredIntent() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
     * response. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
     *
     * @return The triggeredIntent.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Intent getTriggeredIntent() {
      return triggeredIntent_ == null
          ? com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()
          : triggeredIntent_;
    }
    /**
     *
     *
     * <pre>
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
     * response. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.IntentOrBuilder getTriggeredIntentOrBuilder() {
      return triggeredIntent_ == null
          ? com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()
          : triggeredIntent_;
    }

    public static final int CURRENT_PAGE_FIELD_NUMBER = 8;
    private com.google.cloud.dialogflow.cx.v3.Page currentPage_;
    /**
     *
     *
     * <pre>
     * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
     * spoken. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
     *
     * @return Whether the currentPage field is set.
     */
    @java.lang.Override
    public boolean hasCurrentPage() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
     * spoken. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
     *
     * @return The currentPage.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Page getCurrentPage() {
      return currentPage_ == null
          ? com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance()
          : currentPage_;
    }
    /**
     *
     *
     * <pre>
     * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
     * spoken. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.PageOrBuilder getCurrentPageOrBuilder() {
      return currentPage_ == null
          ? com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance()
          : currentPage_;
    }

    public static final int TEXT_RESPONSES_FIELD_NUMBER = 9;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text> textResponses_;
    /**
     *
     *
     * <pre>
     * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
     * from the agent for the turn.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text>
        getTextResponsesList() {
      return textResponses_;
    }
    /**
     *
     *
     * <pre>
     * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
     * from the agent for the turn.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.ResponseMessage.TextOrBuilder>
        getTextResponsesOrBuilderList() {
      return textResponses_;
    }
    /**
     *
     *
     * <pre>
     * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
     * from the agent for the turn.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;</code>
     */
    @java.lang.Override
    public int getTextResponsesCount() {
      return textResponses_.size();
    }
    /**
     *
     *
     * <pre>
     * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
     * from the agent for the turn.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text getTextResponses(int index) {
      return textResponses_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
     * from the agent for the turn.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ResponseMessage.TextOrBuilder
        getTextResponsesOrBuilder(int index) {
      return textResponses_.get(index);
    }

    public static final int STATUS_FIELD_NUMBER = 10;
    private com.google.rpc.Status status_;
    /**
     *
     *
     * <pre>
     * Response error from the agent in the test result. If set, other output
     * is empty.
     * </pre>
     *
     * <code>.google.rpc.Status status = 10;</code>
     *
     * @return Whether the status field is set.
     */
    @java.lang.Override
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Response error from the agent in the test result. If set, other output
     * is empty.
     * </pre>
     *
     * <code>.google.rpc.Status status = 10;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.rpc.Status getStatus() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }
    /**
     *
     *
     * <pre>
     * Response error from the agent in the test result. If set, other output
     * is empty.
     * </pre>
     *
     * <code>.google.rpc.Status status = 10;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getSessionParameters());
      }
      for (int i = 0; i < differences_.size(); i++) {
        output.writeMessage(5, differences_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(6, getDiagnosticInfo());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(7, getTriggeredIntent());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(8, getCurrentPage());
      }
      for (int i = 0; i < textResponses_.size(); i++) {
        output.writeMessage(9, textResponses_.get(i));
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeMessage(10, getStatus());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSessionParameters());
      }
      for (int i = 0; i < differences_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, differences_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDiagnosticInfo());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTriggeredIntent());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCurrentPage());
      }
      for (int i = 0; i < textResponses_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, textResponses_.get(i));
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getStatus());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput other =
          (com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput) obj;

      if (hasSessionParameters() != other.hasSessionParameters()) return false;
      if (hasSessionParameters()) {
        if (!getSessionParameters().equals(other.getSessionParameters())) return false;
      }
      if (!getDifferencesList().equals(other.getDifferencesList())) return false;
      if (hasDiagnosticInfo() != other.hasDiagnosticInfo()) return false;
      if (hasDiagnosticInfo()) {
        if (!getDiagnosticInfo().equals(other.getDiagnosticInfo())) return false;
      }
      if (hasTriggeredIntent() != other.hasTriggeredIntent()) return false;
      if (hasTriggeredIntent()) {
        if (!getTriggeredIntent().equals(other.getTriggeredIntent())) return false;
      }
      if (hasCurrentPage() != other.hasCurrentPage()) return false;
      if (hasCurrentPage()) {
        if (!getCurrentPage().equals(other.getCurrentPage())) return false;
      }
      if (!getTextResponsesList().equals(other.getTextResponsesList())) return false;
      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (!getStatus().equals(other.getStatus())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSessionParameters()) {
        hash = (37 * hash) + SESSION_PARAMETERS_FIELD_NUMBER;
        hash = (53 * hash) + getSessionParameters().hashCode();
      }
      if (getDifferencesCount() > 0) {
        hash = (37 * hash) + DIFFERENCES_FIELD_NUMBER;
        hash = (53 * hash) + getDifferencesList().hashCode();
      }
      if (hasDiagnosticInfo()) {
        hash = (37 * hash) + DIAGNOSTIC_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getDiagnosticInfo().hashCode();
      }
      if (hasTriggeredIntent()) {
        hash = (37 * hash) + TRIGGERED_INTENT_FIELD_NUMBER;
        hash = (53 * hash) + getTriggeredIntent().hashCode();
      }
      if (hasCurrentPage()) {
        hash = (37 * hash) + CURRENT_PAGE_FIELD_NUMBER;
        hash = (53 * hash) + getCurrentPage().hashCode();
      }
      if (getTextResponsesCount() > 0) {
        hash = (37 * hash) + TEXT_RESPONSES_FIELD_NUMBER;
        hash = (53 * hash) + getTextResponsesList().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The output from the virtual agent.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput)
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutputOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_VirtualAgentOutput_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_VirtualAgentOutput_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput.class,
                com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSessionParametersFieldBuilder();
          getDifferencesFieldBuilder();
          getDiagnosticInfoFieldBuilder();
          getTriggeredIntentFieldBuilder();
          getCurrentPageFieldBuilder();
          getTextResponsesFieldBuilder();
          getStatusFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        sessionParameters_ = null;
        if (sessionParametersBuilder_ != null) {
          sessionParametersBuilder_.dispose();
          sessionParametersBuilder_ = null;
        }
        if (differencesBuilder_ == null) {
          differences_ = java.util.Collections.emptyList();
        } else {
          differences_ = null;
          differencesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        diagnosticInfo_ = null;
        if (diagnosticInfoBuilder_ != null) {
          diagnosticInfoBuilder_.dispose();
          diagnosticInfoBuilder_ = null;
        }
        triggeredIntent_ = null;
        if (triggeredIntentBuilder_ != null) {
          triggeredIntentBuilder_.dispose();
          triggeredIntentBuilder_ = null;
        }
        currentPage_ = null;
        if (currentPageBuilder_ != null) {
          currentPageBuilder_.dispose();
          currentPageBuilder_ = null;
        }
        if (textResponsesBuilder_ == null) {
          textResponses_ = java.util.Collections.emptyList();
        } else {
          textResponses_ = null;
          textResponsesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_VirtualAgentOutput_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput build() {
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput buildPartial() {
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput result =
            new com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput result) {
        if (differencesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            differences_ = java.util.Collections.unmodifiableList(differences_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.differences_ = differences_;
        } else {
          result.differences_ = differencesBuilder_.build();
        }
        if (textResponsesBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)) {
            textResponses_ = java.util.Collections.unmodifiableList(textResponses_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.textResponses_ = textResponses_;
        } else {
          result.textResponses_ = textResponsesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.sessionParameters_ =
              sessionParametersBuilder_ == null
                  ? sessionParameters_
                  : sessionParametersBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.diagnosticInfo_ =
              diagnosticInfoBuilder_ == null ? diagnosticInfo_ : diagnosticInfoBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.triggeredIntent_ =
              triggeredIntentBuilder_ == null ? triggeredIntent_ : triggeredIntentBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.currentPage_ =
              currentPageBuilder_ == null ? currentPage_ : currentPageBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
          to_bitField0_ |= 0x00000010;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
                .getDefaultInstance()) return this;
        if (other.hasSessionParameters()) {
          mergeSessionParameters(other.getSessionParameters());
        }
        if (differencesBuilder_ == null) {
          if (!other.differences_.isEmpty()) {
            if (differences_.isEmpty()) {
              differences_ = other.differences_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureDifferencesIsMutable();
              differences_.addAll(other.differences_);
            }
            onChanged();
          }
        } else {
          if (!other.differences_.isEmpty()) {
            if (differencesBuilder_.isEmpty()) {
              differencesBuilder_.dispose();
              differencesBuilder_ = null;
              differences_ = other.differences_;
              bitField0_ = (bitField0_ & ~0x00000002);
              differencesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDifferencesFieldBuilder()
                      : null;
            } else {
              differencesBuilder_.addAllMessages(other.differences_);
            }
          }
        }
        if (other.hasDiagnosticInfo()) {
          mergeDiagnosticInfo(other.getDiagnosticInfo());
        }
        if (other.hasTriggeredIntent()) {
          mergeTriggeredIntent(other.getTriggeredIntent());
        }
        if (other.hasCurrentPage()) {
          mergeCurrentPage(other.getCurrentPage());
        }
        if (textResponsesBuilder_ == null) {
          if (!other.textResponses_.isEmpty()) {
            if (textResponses_.isEmpty()) {
              textResponses_ = other.textResponses_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureTextResponsesIsMutable();
              textResponses_.addAll(other.textResponses_);
            }
            onChanged();
          }
        } else {
          if (!other.textResponses_.isEmpty()) {
            if (textResponsesBuilder_.isEmpty()) {
              textResponsesBuilder_.dispose();
              textResponsesBuilder_ = null;
              textResponses_ = other.textResponses_;
              bitField0_ = (bitField0_ & ~0x00000020);
              textResponsesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getTextResponsesFieldBuilder()
                      : null;
            } else {
              textResponsesBuilder_.addAllMessages(other.textResponses_);
            }
          }
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 34:
                {
                  input.readMessage(
                      getSessionParametersFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 34
              case 42:
                {
                  com.google.cloud.dialogflow.cx.v3.TestRunDifference m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3.TestRunDifference.parser(),
                          extensionRegistry);
                  if (differencesBuilder_ == null) {
                    ensureDifferencesIsMutable();
                    differences_.add(m);
                  } else {
                    differencesBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getDiagnosticInfoFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(
                      getTriggeredIntentFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(getCurrentPageFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 66
              case 74:
                {
                  com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text m =
                      input.readMessage(
                          com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.parser(),
                          extensionRegistry);
                  if (textResponsesBuilder_ == null) {
                    ensureTextResponsesIsMutable();
                    textResponses_.add(m);
                  } else {
                    textResponsesBuilder_.addMessage(m);
                  }
                  break;
                } // case 74
              case 82:
                {
                  input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 82
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Struct sessionParameters_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          sessionParametersBuilder_;
      /**
       *
       *
       * <pre>
       * The session parameters available to the bot at this point.
       * </pre>
       *
       * <code>.google.protobuf.Struct session_parameters = 4;</code>
       *
       * @return Whether the sessionParameters field is set.
       */
      public boolean hasSessionParameters() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The session parameters available to the bot at this point.
       * </pre>
       *
       * <code>.google.protobuf.Struct session_parameters = 4;</code>
       *
       * @return The sessionParameters.
       */
      public com.google.protobuf.Struct getSessionParameters() {
        if (sessionParametersBuilder_ == null) {
          return sessionParameters_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : sessionParameters_;
        } else {
          return sessionParametersBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The session parameters available to the bot at this point.
       * </pre>
       *
       * <code>.google.protobuf.Struct session_parameters = 4;</code>
       */
      public Builder setSessionParameters(com.google.protobuf.Struct value) {
        if (sessionParametersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          sessionParameters_ = value;
        } else {
          sessionParametersBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The session parameters available to the bot at this point.
       * </pre>
       *
       * <code>.google.protobuf.Struct session_parameters = 4;</code>
       */
      public Builder setSessionParameters(com.google.protobuf.Struct.Builder builderForValue) {
        if (sessionParametersBuilder_ == null) {
          sessionParameters_ = builderForValue.build();
        } else {
          sessionParametersBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The session parameters available to the bot at this point.
       * </pre>
       *
       * <code>.google.protobuf.Struct session_parameters = 4;</code>
       */
      public Builder mergeSessionParameters(com.google.protobuf.Struct value) {
        if (sessionParametersBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && sessionParameters_ != null
              && sessionParameters_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getSessionParametersBuilder().mergeFrom(value);
          } else {
            sessionParameters_ = value;
          }
        } else {
          sessionParametersBuilder_.mergeFrom(value);
        }
        if (sessionParameters_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The session parameters available to the bot at this point.
       * </pre>
       *
       * <code>.google.protobuf.Struct session_parameters = 4;</code>
       */
      public Builder clearSessionParameters() {
        bitField0_ = (bitField0_ & ~0x00000001);
        sessionParameters_ = null;
        if (sessionParametersBuilder_ != null) {
          sessionParametersBuilder_.dispose();
          sessionParametersBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The session parameters available to the bot at this point.
       * </pre>
       *
       * <code>.google.protobuf.Struct session_parameters = 4;</code>
       */
      public com.google.protobuf.Struct.Builder getSessionParametersBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getSessionParametersFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The session parameters available to the bot at this point.
       * </pre>
       *
       * <code>.google.protobuf.Struct session_parameters = 4;</code>
       */
      public com.google.protobuf.StructOrBuilder getSessionParametersOrBuilder() {
        if (sessionParametersBuilder_ != null) {
          return sessionParametersBuilder_.getMessageOrBuilder();
        } else {
          return sessionParameters_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : sessionParameters_;
        }
      }
      /**
       *
       *
       * <pre>
       * The session parameters available to the bot at this point.
       * </pre>
       *
       * <code>.google.protobuf.Struct session_parameters = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getSessionParametersFieldBuilder() {
        if (sessionParametersBuilder_ == null) {
          sessionParametersBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getSessionParameters(), getParentForChildren(), isClean());
          sessionParameters_ = null;
        }
        return sessionParametersBuilder_;
      }

      private java.util.List<com.google.cloud.dialogflow.cx.v3.TestRunDifference> differences_ =
          java.util.Collections.emptyList();

      private void ensureDifferencesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          differences_ =
              new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.TestRunDifference>(
                  differences_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.TestRunDifference,
              com.google.cloud.dialogflow.cx.v3.TestRunDifference.Builder,
              com.google.cloud.dialogflow.cx.v3.TestRunDifferenceOrBuilder>
          differencesBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3.TestRunDifference>
          getDifferencesList() {
        if (differencesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(differences_);
        } else {
          return differencesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getDifferencesCount() {
        if (differencesBuilder_ == null) {
          return differences_.size();
        } else {
          return differencesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.TestRunDifference getDifferences(int index) {
        if (differencesBuilder_ == null) {
          return differences_.get(index);
        } else {
          return differencesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setDifferences(
          int index, com.google.cloud.dialogflow.cx.v3.TestRunDifference value) {
        if (differencesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDifferencesIsMutable();
          differences_.set(index, value);
          onChanged();
        } else {
          differencesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setDifferences(
          int index, com.google.cloud.dialogflow.cx.v3.TestRunDifference.Builder builderForValue) {
        if (differencesBuilder_ == null) {
          ensureDifferencesIsMutable();
          differences_.set(index, builderForValue.build());
          onChanged();
        } else {
          differencesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addDifferences(com.google.cloud.dialogflow.cx.v3.TestRunDifference value) {
        if (differencesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDifferencesIsMutable();
          differences_.add(value);
          onChanged();
        } else {
          differencesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addDifferences(
          int index, com.google.cloud.dialogflow.cx.v3.TestRunDifference value) {
        if (differencesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDifferencesIsMutable();
          differences_.add(index, value);
          onChanged();
        } else {
          differencesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addDifferences(
          com.google.cloud.dialogflow.cx.v3.TestRunDifference.Builder builderForValue) {
        if (differencesBuilder_ == null) {
          ensureDifferencesIsMutable();
          differences_.add(builderForValue.build());
          onChanged();
        } else {
          differencesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addDifferences(
          int index, com.google.cloud.dialogflow.cx.v3.TestRunDifference.Builder builderForValue) {
        if (differencesBuilder_ == null) {
          ensureDifferencesIsMutable();
          differences_.add(index, builderForValue.build());
          onChanged();
        } else {
          differencesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllDifferences(
          java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.TestRunDifference>
              values) {
        if (differencesBuilder_ == null) {
          ensureDifferencesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, differences_);
          onChanged();
        } else {
          differencesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearDifferences() {
        if (differencesBuilder_ == null) {
          differences_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          differencesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeDifferences(int index) {
        if (differencesBuilder_ == null) {
          ensureDifferencesIsMutable();
          differences_.remove(index);
          onChanged();
        } else {
          differencesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.TestRunDifference.Builder getDifferencesBuilder(
          int index) {
        return getDifferencesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.TestRunDifferenceOrBuilder getDifferencesOrBuilder(
          int index) {
        if (differencesBuilder_ == null) {
          return differences_.get(index);
        } else {
          return differencesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.dialogflow.cx.v3.TestRunDifferenceOrBuilder>
          getDifferencesOrBuilderList() {
        if (differencesBuilder_ != null) {
          return differencesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(differences_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.TestRunDifference.Builder addDifferencesBuilder() {
        return getDifferencesFieldBuilder()
            .addBuilder(com.google.cloud.dialogflow.cx.v3.TestRunDifference.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.TestRunDifference.Builder addDifferencesBuilder(
          int index) {
        return getDifferencesFieldBuilder()
            .addBuilder(
                index, com.google.cloud.dialogflow.cx.v3.TestRunDifference.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. If this is part of a [result conversation
       * turn][TestCaseResult.conversation_turns], the list of differences
       * between the original run and the replay for this output, if any.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.TestRunDifference differences = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3.TestRunDifference.Builder>
          getDifferencesBuilderList() {
        return getDifferencesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.TestRunDifference,
              com.google.cloud.dialogflow.cx.v3.TestRunDifference.Builder,
              com.google.cloud.dialogflow.cx.v3.TestRunDifferenceOrBuilder>
          getDifferencesFieldBuilder() {
        if (differencesBuilder_ == null) {
          differencesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.TestRunDifference,
                  com.google.cloud.dialogflow.cx.v3.TestRunDifference.Builder,
                  com.google.cloud.dialogflow.cx.v3.TestRunDifferenceOrBuilder>(
                  differences_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          differences_ = null;
        }
        return differencesBuilder_;
      }

      private com.google.protobuf.Struct diagnosticInfo_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          diagnosticInfoBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Input only. The diagnostic
       * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
       * output for the turn. Required to calculate the testing coverage.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return Whether the diagnosticInfo field is set.
       */
      public boolean hasDiagnosticInfo() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. The diagnostic
       * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
       * output for the turn. Required to calculate the testing coverage.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The diagnosticInfo.
       */
      public com.google.protobuf.Struct getDiagnosticInfo() {
        if (diagnosticInfoBuilder_ == null) {
          return diagnosticInfo_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : diagnosticInfo_;
        } else {
          return diagnosticInfoBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. The diagnostic
       * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
       * output for the turn. Required to calculate the testing coverage.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder setDiagnosticInfo(com.google.protobuf.Struct value) {
        if (diagnosticInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          diagnosticInfo_ = value;
        } else {
          diagnosticInfoBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. The diagnostic
       * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
       * output for the turn. Required to calculate the testing coverage.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder setDiagnosticInfo(com.google.protobuf.Struct.Builder builderForValue) {
        if (diagnosticInfoBuilder_ == null) {
          diagnosticInfo_ = builderForValue.build();
        } else {
          diagnosticInfoBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. The diagnostic
       * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
       * output for the turn. Required to calculate the testing coverage.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder mergeDiagnosticInfo(com.google.protobuf.Struct value) {
        if (diagnosticInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && diagnosticInfo_ != null
              && diagnosticInfo_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getDiagnosticInfoBuilder().mergeFrom(value);
          } else {
            diagnosticInfo_ = value;
          }
        } else {
          diagnosticInfoBuilder_.mergeFrom(value);
        }
        if (diagnosticInfo_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. The diagnostic
       * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
       * output for the turn. Required to calculate the testing coverage.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder clearDiagnosticInfo() {
        bitField0_ = (bitField0_ & ~0x00000004);
        diagnosticInfo_ = null;
        if (diagnosticInfoBuilder_ != null) {
          diagnosticInfoBuilder_.dispose();
          diagnosticInfoBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. The diagnostic
       * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
       * output for the turn. Required to calculate the testing coverage.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Struct.Builder getDiagnosticInfoBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getDiagnosticInfoFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. The diagnostic
       * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
       * output for the turn. Required to calculate the testing coverage.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.StructOrBuilder getDiagnosticInfoOrBuilder() {
        if (diagnosticInfoBuilder_ != null) {
          return diagnosticInfoBuilder_.getMessageOrBuilder();
        } else {
          return diagnosticInfo_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : diagnosticInfo_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. The diagnostic
       * [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
       * output for the turn. Required to calculate the testing coverage.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct diagnostic_info = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getDiagnosticInfoFieldBuilder() {
        if (diagnosticInfoBuilder_ == null) {
          diagnosticInfoBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getDiagnosticInfo(), getParentForChildren(), isClean());
          diagnosticInfo_ = null;
        }
        return diagnosticInfoBuilder_;
      }

      private com.google.cloud.dialogflow.cx.v3.Intent triggeredIntent_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Intent,
              com.google.cloud.dialogflow.cx.v3.Intent.Builder,
              com.google.cloud.dialogflow.cx.v3.IntentOrBuilder>
          triggeredIntentBuilder_;
      /**
       *
       *
       * <pre>
       * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
       * response. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
       *
       * @return Whether the triggeredIntent field is set.
       */
      public boolean hasTriggeredIntent() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
       * response. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
       *
       * @return The triggeredIntent.
       */
      public com.google.cloud.dialogflow.cx.v3.Intent getTriggeredIntent() {
        if (triggeredIntentBuilder_ == null) {
          return triggeredIntent_ == null
              ? com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()
              : triggeredIntent_;
        } else {
          return triggeredIntentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
       * response. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
       */
      public Builder setTriggeredIntent(com.google.cloud.dialogflow.cx.v3.Intent value) {
        if (triggeredIntentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          triggeredIntent_ = value;
        } else {
          triggeredIntentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
       * response. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
       */
      public Builder setTriggeredIntent(
          com.google.cloud.dialogflow.cx.v3.Intent.Builder builderForValue) {
        if (triggeredIntentBuilder_ == null) {
          triggeredIntent_ = builderForValue.build();
        } else {
          triggeredIntentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
       * response. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
       */
      public Builder mergeTriggeredIntent(com.google.cloud.dialogflow.cx.v3.Intent value) {
        if (triggeredIntentBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && triggeredIntent_ != null
              && triggeredIntent_
                  != com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()) {
            getTriggeredIntentBuilder().mergeFrom(value);
          } else {
            triggeredIntent_ = value;
          }
        } else {
          triggeredIntentBuilder_.mergeFrom(value);
        }
        if (triggeredIntent_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
       * response. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
       */
      public Builder clearTriggeredIntent() {
        bitField0_ = (bitField0_ & ~0x00000008);
        triggeredIntent_ = null;
        if (triggeredIntentBuilder_ != null) {
          triggeredIntentBuilder_.dispose();
          triggeredIntentBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
       * response. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.Intent.Builder getTriggeredIntentBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getTriggeredIntentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
       * response. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.IntentOrBuilder getTriggeredIntentOrBuilder() {
        if (triggeredIntentBuilder_ != null) {
          return triggeredIntentBuilder_.getMessageOrBuilder();
        } else {
          return triggeredIntent_ == null
              ? com.google.cloud.dialogflow.cx.v3.Intent.getDefaultInstance()
              : triggeredIntent_;
        }
      }
      /**
       *
       *
       * <pre>
       * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that triggered the
       * response. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Intent triggered_intent = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Intent,
              com.google.cloud.dialogflow.cx.v3.Intent.Builder,
              com.google.cloud.dialogflow.cx.v3.IntentOrBuilder>
          getTriggeredIntentFieldBuilder() {
        if (triggeredIntentBuilder_ == null) {
          triggeredIntentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.Intent,
                  com.google.cloud.dialogflow.cx.v3.Intent.Builder,
                  com.google.cloud.dialogflow.cx.v3.IntentOrBuilder>(
                  getTriggeredIntent(), getParentForChildren(), isClean());
          triggeredIntent_ = null;
        }
        return triggeredIntentBuilder_;
      }

      private com.google.cloud.dialogflow.cx.v3.Page currentPage_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Page,
              com.google.cloud.dialogflow.cx.v3.Page.Builder,
              com.google.cloud.dialogflow.cx.v3.PageOrBuilder>
          currentPageBuilder_;
      /**
       *
       *
       * <pre>
       * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
       * spoken. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
       *
       * @return Whether the currentPage field is set.
       */
      public boolean hasCurrentPage() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
       * spoken. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
       *
       * @return The currentPage.
       */
      public com.google.cloud.dialogflow.cx.v3.Page getCurrentPage() {
        if (currentPageBuilder_ == null) {
          return currentPage_ == null
              ? com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance()
              : currentPage_;
        } else {
          return currentPageBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
       * spoken. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
       */
      public Builder setCurrentPage(com.google.cloud.dialogflow.cx.v3.Page value) {
        if (currentPageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          currentPage_ = value;
        } else {
          currentPageBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
       * spoken. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
       */
      public Builder setCurrentPage(
          com.google.cloud.dialogflow.cx.v3.Page.Builder builderForValue) {
        if (currentPageBuilder_ == null) {
          currentPage_ = builderForValue.build();
        } else {
          currentPageBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
       * spoken. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
       */
      public Builder mergeCurrentPage(com.google.cloud.dialogflow.cx.v3.Page value) {
        if (currentPageBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && currentPage_ != null
              && currentPage_ != com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance()) {
            getCurrentPageBuilder().mergeFrom(value);
          } else {
            currentPage_ = value;
          }
        } else {
          currentPageBuilder_.mergeFrom(value);
        }
        if (currentPage_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
       * spoken. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
       */
      public Builder clearCurrentPage() {
        bitField0_ = (bitField0_ & ~0x00000010);
        currentPage_ = null;
        if (currentPageBuilder_ != null) {
          currentPageBuilder_.dispose();
          currentPageBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
       * spoken. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.Page.Builder getCurrentPageBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getCurrentPageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
       * spoken. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
       */
      public com.google.cloud.dialogflow.cx.v3.PageOrBuilder getCurrentPageOrBuilder() {
        if (currentPageBuilder_ != null) {
          return currentPageBuilder_.getMessageOrBuilder();
        } else {
          return currentPage_ == null
              ? com.google.cloud.dialogflow.cx.v3.Page.getDefaultInstance()
              : currentPage_;
        }
      }
      /**
       *
       *
       * <pre>
       * The [Page][google.cloud.dialogflow.cx.v3.Page] on which the utterance was
       * spoken. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3.Page current_page = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Page,
              com.google.cloud.dialogflow.cx.v3.Page.Builder,
              com.google.cloud.dialogflow.cx.v3.PageOrBuilder>
          getCurrentPageFieldBuilder() {
        if (currentPageBuilder_ == null) {
          currentPageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.Page,
                  com.google.cloud.dialogflow.cx.v3.Page.Builder,
                  com.google.cloud.dialogflow.cx.v3.PageOrBuilder>(
                  getCurrentPage(), getParentForChildren(), isClean());
          currentPage_ = null;
        }
        return currentPageBuilder_;
      }

      private java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text>
          textResponses_ = java.util.Collections.emptyList();

      private void ensureTextResponsesIsMutable() {
        if (!((bitField0_ & 0x00000020) != 0)) {
          textResponses_ =
              new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text>(
                  textResponses_);
          bitField0_ |= 0x00000020;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text,
              com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.Builder,
              com.google.cloud.dialogflow.cx.v3.ResponseMessage.TextOrBuilder>
          textResponsesBuilder_;

      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text>
          getTextResponsesList() {
        if (textResponsesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(textResponses_);
        } else {
          return textResponsesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public int getTextResponsesCount() {
        if (textResponsesBuilder_ == null) {
          return textResponses_.size();
        } else {
          return textResponsesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text getTextResponses(int index) {
        if (textResponsesBuilder_ == null) {
          return textResponses_.get(index);
        } else {
          return textResponsesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public Builder setTextResponses(
          int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text value) {
        if (textResponsesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTextResponsesIsMutable();
          textResponses_.set(index, value);
          onChanged();
        } else {
          textResponsesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public Builder setTextResponses(
          int index,
          com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.Builder builderForValue) {
        if (textResponsesBuilder_ == null) {
          ensureTextResponsesIsMutable();
          textResponses_.set(index, builderForValue.build());
          onChanged();
        } else {
          textResponsesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public Builder addTextResponses(
          com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text value) {
        if (textResponsesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTextResponsesIsMutable();
          textResponses_.add(value);
          onChanged();
        } else {
          textResponsesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public Builder addTextResponses(
          int index, com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text value) {
        if (textResponsesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTextResponsesIsMutable();
          textResponses_.add(index, value);
          onChanged();
        } else {
          textResponsesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public Builder addTextResponses(
          com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.Builder builderForValue) {
        if (textResponsesBuilder_ == null) {
          ensureTextResponsesIsMutable();
          textResponses_.add(builderForValue.build());
          onChanged();
        } else {
          textResponsesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public Builder addTextResponses(
          int index,
          com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.Builder builderForValue) {
        if (textResponsesBuilder_ == null) {
          ensureTextResponsesIsMutable();
          textResponses_.add(index, builderForValue.build());
          onChanged();
        } else {
          textResponsesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public Builder addAllTextResponses(
          java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text>
              values) {
        if (textResponsesBuilder_ == null) {
          ensureTextResponsesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, textResponses_);
          onChanged();
        } else {
          textResponsesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public Builder clearTextResponses() {
        if (textResponsesBuilder_ == null) {
          textResponses_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          textResponsesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public Builder removeTextResponses(int index) {
        if (textResponsesBuilder_ == null) {
          ensureTextResponsesIsMutable();
          textResponses_.remove(index);
          onChanged();
        } else {
          textResponsesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.Builder getTextResponsesBuilder(
          int index) {
        return getTextResponsesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.ResponseMessage.TextOrBuilder
          getTextResponsesOrBuilder(int index) {
        if (textResponsesBuilder_ == null) {
          return textResponses_.get(index);
        } else {
          return textResponsesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.dialogflow.cx.v3.ResponseMessage.TextOrBuilder>
          getTextResponsesOrBuilderList() {
        if (textResponsesBuilder_ != null) {
          return textResponsesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(textResponses_);
        }
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.Builder
          addTextResponsesBuilder() {
        return getTextResponsesFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.Builder addTextResponsesBuilder(
          int index) {
        return getTextResponsesFieldBuilder()
            .addBuilder(
                index, com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The [text][google.cloud.dialogflow.cx.v3.ResponseMessage.Text] responses
       * from the agent for the turn.
       * </pre>
       *
       * <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage.Text text_responses = 9;
       * </code>
       */
      public java.util.List<com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.Builder>
          getTextResponsesBuilderList() {
        return getTextResponsesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text,
              com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.Builder,
              com.google.cloud.dialogflow.cx.v3.ResponseMessage.TextOrBuilder>
          getTextResponsesFieldBuilder() {
        if (textResponsesBuilder_ == null) {
          textResponsesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text,
                  com.google.cloud.dialogflow.cx.v3.ResponseMessage.Text.Builder,
                  com.google.cloud.dialogflow.cx.v3.ResponseMessage.TextOrBuilder>(
                  textResponses_,
                  ((bitField0_ & 0x00000020) != 0),
                  getParentForChildren(),
                  isClean());
          textResponses_ = null;
        }
        return textResponsesBuilder_;
      }

      private com.google.rpc.Status status_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * Response error from the agent in the test result. If set, other output
       * is empty.
       * </pre>
       *
       * <code>.google.rpc.Status status = 10;</code>
       *
       * @return Whether the status field is set.
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Response error from the agent in the test result. If set, other output
       * is empty.
       * </pre>
       *
       * <code>.google.rpc.Status status = 10;</code>
       *
       * @return The status.
       */
      public com.google.rpc.Status getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Response error from the agent in the test result. If set, other output
       * is empty.
       * </pre>
       *
       * <code>.google.rpc.Status status = 10;</code>
       */
      public Builder setStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Response error from the agent in the test result. If set, other output
       * is empty.
       * </pre>
       *
       * <code>.google.rpc.Status status = 10;</code>
       */
      public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Response error from the agent in the test result. If set, other output
       * is empty.
       * </pre>
       *
       * <code>.google.rpc.Status status = 10;</code>
       */
      public Builder mergeStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && status_ != null
              && status_ != com.google.rpc.Status.getDefaultInstance()) {
            getStatusBuilder().mergeFrom(value);
          } else {
            status_ = value;
          }
        } else {
          statusBuilder_.mergeFrom(value);
        }
        if (status_ != null) {
          bitField0_ |= 0x00000040;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Response error from the agent in the test result. If set, other output
       * is empty.
       * </pre>
       *
       * <code>.google.rpc.Status status = 10;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000040);
        status_ = null;
        if (statusBuilder_ != null) {
          statusBuilder_.dispose();
          statusBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Response error from the agent in the test result. If set, other output
       * is empty.
       * </pre>
       *
       * <code>.google.rpc.Status status = 10;</code>
       */
      public com.google.rpc.Status.Builder getStatusBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Response error from the agent in the test result. If set, other output
       * is empty.
       * </pre>
       *
       * <code>.google.rpc.Status status = 10;</code>
       */
      public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * Response error from the agent in the test result. If set, other output
       * is empty.
       * </pre>
       *
       * <code>.google.rpc.Status status = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput)
    private static final com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput();
    }

    public static com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VirtualAgentOutput> PARSER =
        new com.google.protobuf.AbstractParser<VirtualAgentOutput>() {
          @java.lang.Override
          public VirtualAgentOutput parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VirtualAgentOutput> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VirtualAgentOutput> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int USER_INPUT_FIELD_NUMBER = 1;
  private com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput userInput_;
  /**
   *
   *
   * <pre>
   * The user input.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput user_input = 1;</code>
   *
   * @return Whether the userInput field is set.
   */
  @java.lang.Override
  public boolean hasUserInput() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The user input.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput user_input = 1;</code>
   *
   * @return The userInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput getUserInput() {
    return userInput_ == null
        ? com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.getDefaultInstance()
        : userInput_;
  }
  /**
   *
   *
   * <pre>
   * The user input.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput user_input = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInputOrBuilder
      getUserInputOrBuilder() {
    return userInput_ == null
        ? com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.getDefaultInstance()
        : userInput_;
  }

  public static final int VIRTUAL_AGENT_OUTPUT_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtualAgentOutput_;
  /**
   *
   *
   * <pre>
   * The virtual agent output.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtual_agent_output = 2;
   * </code>
   *
   * @return Whether the virtualAgentOutput field is set.
   */
  @java.lang.Override
  public boolean hasVirtualAgentOutput() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The virtual agent output.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtual_agent_output = 2;
   * </code>
   *
   * @return The virtualAgentOutput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
      getVirtualAgentOutput() {
    return virtualAgentOutput_ == null
        ? com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput.getDefaultInstance()
        : virtualAgentOutput_;
  }
  /**
   *
   *
   * <pre>
   * The virtual agent output.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtual_agent_output = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutputOrBuilder
      getVirtualAgentOutputOrBuilder() {
    return virtualAgentOutput_ == null
        ? com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput.getDefaultInstance()
        : virtualAgentOutput_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getUserInput());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getVirtualAgentOutput());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getUserInput());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getVirtualAgentOutput());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.ConversationTurn)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.ConversationTurn other =
        (com.google.cloud.dialogflow.cx.v3.ConversationTurn) obj;

    if (hasUserInput() != other.hasUserInput()) return false;
    if (hasUserInput()) {
      if (!getUserInput().equals(other.getUserInput())) return false;
    }
    if (hasVirtualAgentOutput() != other.hasVirtualAgentOutput()) return false;
    if (hasVirtualAgentOutput()) {
      if (!getVirtualAgentOutput().equals(other.getVirtualAgentOutput())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasUserInput()) {
      hash = (37 * hash) + USER_INPUT_FIELD_NUMBER;
      hash = (53 * hash) + getUserInput().hashCode();
    }
    if (hasVirtualAgentOutput()) {
      hash = (37 * hash) + VIRTUAL_AGENT_OUTPUT_FIELD_NUMBER;
      hash = (53 * hash) + getVirtualAgentOutput().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.ConversationTurn prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * One interaction between a human and virtual agent. The human provides some
   * input and the virtual agent provides a response.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.ConversationTurn}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.ConversationTurn)
      com.google.cloud.dialogflow.cx.v3.ConversationTurnOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.ConversationTurn.class,
              com.google.cloud.dialogflow.cx.v3.ConversationTurn.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.ConversationTurn.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUserInputFieldBuilder();
        getVirtualAgentOutputFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      userInput_ = null;
      if (userInputBuilder_ != null) {
        userInputBuilder_.dispose();
        userInputBuilder_ = null;
      }
      virtualAgentOutput_ = null;
      if (virtualAgentOutputBuilder_ != null) {
        virtualAgentOutputBuilder_.dispose();
        virtualAgentOutputBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3_ConversationTurn_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.ConversationTurn.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn build() {
      com.google.cloud.dialogflow.cx.v3.ConversationTurn result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn buildPartial() {
      com.google.cloud.dialogflow.cx.v3.ConversationTurn result =
          new com.google.cloud.dialogflow.cx.v3.ConversationTurn(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.ConversationTurn result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.userInput_ = userInputBuilder_ == null ? userInput_ : userInputBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.virtualAgentOutput_ =
            virtualAgentOutputBuilder_ == null
                ? virtualAgentOutput_
                : virtualAgentOutputBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.ConversationTurn) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.ConversationTurn) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.ConversationTurn other) {
      if (other == com.google.cloud.dialogflow.cx.v3.ConversationTurn.getDefaultInstance())
        return this;
      if (other.hasUserInput()) {
        mergeUserInput(other.getUserInput());
      }
      if (other.hasVirtualAgentOutput()) {
        mergeVirtualAgentOutput(other.getVirtualAgentOutput());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getUserInputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getVirtualAgentOutputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput userInput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput,
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.Builder,
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInputOrBuilder>
        userInputBuilder_;
    /**
     *
     *
     * <pre>
     * The user input.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput user_input = 1;</code>
     *
     * @return Whether the userInput field is set.
     */
    public boolean hasUserInput() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The user input.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput user_input = 1;</code>
     *
     * @return The userInput.
     */
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput getUserInput() {
      if (userInputBuilder_ == null) {
        return userInput_ == null
            ? com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.getDefaultInstance()
            : userInput_;
      } else {
        return userInputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The user input.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput user_input = 1;</code>
     */
    public Builder setUserInput(
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput value) {
      if (userInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userInput_ = value;
      } else {
        userInputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user input.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput user_input = 1;</code>
     */
    public Builder setUserInput(
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.Builder builderForValue) {
      if (userInputBuilder_ == null) {
        userInput_ = builderForValue.build();
      } else {
        userInputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user input.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput user_input = 1;</code>
     */
    public Builder mergeUserInput(
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput value) {
      if (userInputBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && userInput_ != null
            && userInput_
                != com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput
                    .getDefaultInstance()) {
          getUserInputBuilder().mergeFrom(value);
        } else {
          userInput_ = value;
        }
      } else {
        userInputBuilder_.mergeFrom(value);
      }
      if (userInput_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user input.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput user_input = 1;</code>
     */
    public Builder clearUserInput() {
      bitField0_ = (bitField0_ & ~0x00000001);
      userInput_ = null;
      if (userInputBuilder_ != null) {
        userInputBuilder_.dispose();
        userInputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user input.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput user_input = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.Builder
        getUserInputBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getUserInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The user input.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput user_input = 1;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInputOrBuilder
        getUserInputOrBuilder() {
      if (userInputBuilder_ != null) {
        return userInputBuilder_.getMessageOrBuilder();
      } else {
        return userInput_ == null
            ? com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.getDefaultInstance()
            : userInput_;
      }
    }
    /**
     *
     *
     * <pre>
     * The user input.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput user_input = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput,
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.Builder,
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInputOrBuilder>
        getUserInputFieldBuilder() {
      if (userInputBuilder_ == null) {
        userInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput,
                com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInput.Builder,
                com.google.cloud.dialogflow.cx.v3.ConversationTurn.UserInputOrBuilder>(
                getUserInput(), getParentForChildren(), isClean());
        userInput_ = null;
      }
      return userInputBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
        virtualAgentOutput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput,
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput.Builder,
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutputOrBuilder>
        virtualAgentOutputBuilder_;
    /**
     *
     *
     * <pre>
     * The virtual agent output.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtual_agent_output = 2;
     * </code>
     *
     * @return Whether the virtualAgentOutput field is set.
     */
    public boolean hasVirtualAgentOutput() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The virtual agent output.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtual_agent_output = 2;
     * </code>
     *
     * @return The virtualAgentOutput.
     */
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
        getVirtualAgentOutput() {
      if (virtualAgentOutputBuilder_ == null) {
        return virtualAgentOutput_ == null
            ? com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
                .getDefaultInstance()
            : virtualAgentOutput_;
      } else {
        return virtualAgentOutputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The virtual agent output.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtual_agent_output = 2;
     * </code>
     */
    public Builder setVirtualAgentOutput(
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput value) {
      if (virtualAgentOutputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        virtualAgentOutput_ = value;
      } else {
        virtualAgentOutputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The virtual agent output.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtual_agent_output = 2;
     * </code>
     */
    public Builder setVirtualAgentOutput(
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput.Builder
            builderForValue) {
      if (virtualAgentOutputBuilder_ == null) {
        virtualAgentOutput_ = builderForValue.build();
      } else {
        virtualAgentOutputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The virtual agent output.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtual_agent_output = 2;
     * </code>
     */
    public Builder mergeVirtualAgentOutput(
        com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput value) {
      if (virtualAgentOutputBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && virtualAgentOutput_ != null
            && virtualAgentOutput_
                != com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
                    .getDefaultInstance()) {
          getVirtualAgentOutputBuilder().mergeFrom(value);
        } else {
          virtualAgentOutput_ = value;
        }
      } else {
        virtualAgentOutputBuilder_.mergeFrom(value);
      }
      if (virtualAgentOutput_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The virtual agent output.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtual_agent_output = 2;
     * </code>
     */
    public Builder clearVirtualAgentOutput() {
      bitField0_ = (bitField0_ & ~0x00000002);
      virtualAgentOutput_ = null;
      if (virtualAgentOutputBuilder_ != null) {
        virtualAgentOutputBuilder_.dispose();
        virtualAgentOutputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The virtual agent output.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtual_agent_output = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput.Builder
        getVirtualAgentOutputBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getVirtualAgentOutputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The virtual agent output.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtual_agent_output = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutputOrBuilder
        getVirtualAgentOutputOrBuilder() {
      if (virtualAgentOutputBuilder_ != null) {
        return virtualAgentOutputBuilder_.getMessageOrBuilder();
      } else {
        return virtualAgentOutput_ == null
            ? com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput
                .getDefaultInstance()
            : virtualAgentOutput_;
      }
    }
    /**
     *
     *
     * <pre>
     * The virtual agent output.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput virtual_agent_output = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput,
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput.Builder,
            com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutputOrBuilder>
        getVirtualAgentOutputFieldBuilder() {
      if (virtualAgentOutputBuilder_ == null) {
        virtualAgentOutputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput,
                com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutput.Builder,
                com.google.cloud.dialogflow.cx.v3.ConversationTurn.VirtualAgentOutputOrBuilder>(
                getVirtualAgentOutput(), getParentForChildren(), isClean());
        virtualAgentOutput_ = null;
      }
      return virtualAgentOutputBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.ConversationTurn)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.ConversationTurn)
  private static final com.google.cloud.dialogflow.cx.v3.ConversationTurn DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.ConversationTurn();
  }

  public static com.google.cloud.dialogflow.cx.v3.ConversationTurn getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConversationTurn> PARSER =
      new com.google.protobuf.AbstractParser<ConversationTurn>() {
        @java.lang.Override
        public ConversationTurn parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConversationTurn> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConversationTurn> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.ConversationTurn getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
