/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/session.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Boost specification to boost certain documents.
 * A copy of google.cloud.discoveryengine.v1main.BoostSpec, field documentation
 * is available at
 * https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1alpha/BoostSpec
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.BoostSpec}
 */
public final class BoostSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.BoostSpec)
    BoostSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BoostSpec.newBuilder() to construct.
  private BoostSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BoostSpec() {
    conditionBoostSpecs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BoostSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.SessionProto
        .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.BoostSpec.class,
            com.google.cloud.dialogflow.cx.v3.BoostSpec.Builder.class);
  }

  public interface ConditionBoostSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. An expression which specifies a boost condition. The syntax and
     * supported fields are the same as a filter expression.
     * Examples:
     *
     * * To boost documents with document ID "doc_1" or "doc_2", and
     * color
     *   "Red" or "Blue":
     *     * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
     * </pre>
     *
     * <code>string condition = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The condition.
     */
    java.lang.String getCondition();
    /**
     *
     *
     * <pre>
     * Optional. An expression which specifies a boost condition. The syntax and
     * supported fields are the same as a filter expression.
     * Examples:
     *
     * * To boost documents with document ID "doc_1" or "doc_2", and
     * color
     *   "Red" or "Blue":
     *     * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
     * </pre>
     *
     * <code>string condition = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for condition.
     */
    com.google.protobuf.ByteString getConditionBytes();

    /**
     *
     *
     * <pre>
     * Optional. Strength of the condition boost, which should be in [-1, 1].
     * Negative boost means demotion. Default is 0.0.
     *
     * Setting to 1.0 gives the document a big promotion. However, it does not
     * necessarily mean that the boosted document will be the top result at
     * all times, nor that other documents will be excluded. Results could
     * still be shown even when none of them matches the condition. And
     * results that are significantly more relevant to the search query can
     * still trump your heavily favored but irrelevant documents.
     *
     * Setting to -1.0 gives the document a big demotion. However, results
     * that are deeply relevant might still be shown. The document will have
     * an upstream battle to get a fairly high ranking, but it is not blocked
     * out completely.
     *
     * Setting to 0.0 means no boost applied. The boosting condition is
     * ignored.
     * </pre>
     *
     * <code>float boost = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The boost.
     */
    float getBoost();

    /**
     *
     *
     * <pre>
     * Optional. Complex specification for custom ranking based on customer
     * defined attribute value.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the boostControlSpec field is set.
     */
    boolean hasBoostControlSpec();
    /**
     *
     *
     * <pre>
     * Optional. Complex specification for custom ranking based on customer
     * defined attribute value.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The boostControlSpec.
     */
    com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
        getBoostControlSpec();
    /**
     *
     *
     * <pre>
     * Optional. Complex specification for custom ranking based on customer
     * defined attribute value.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpecOrBuilder
        getBoostControlSpecOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Boost applies to documents which match a condition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec}
   */
  public static final class ConditionBoostSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec)
      ConditionBoostSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConditionBoostSpec.newBuilder() to construct.
    private ConditionBoostSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConditionBoostSpec() {
      condition_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConditionBoostSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.class,
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.Builder.class);
    }

    public interface BoostControlSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The name of the field whose value will be used to determine
       * the boost amount.
       * </pre>
       *
       * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The fieldName.
       */
      java.lang.String getFieldName();
      /**
       *
       *
       * <pre>
       * Optional. The name of the field whose value will be used to determine
       * the boost amount.
       * </pre>
       *
       * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for fieldName.
       */
      com.google.protobuf.ByteString getFieldNameBytes();

      /**
       *
       *
       * <pre>
       * Optional. The attribute type to be used to determine the boost amount.
       * The attribute value can be derived from the field value of the
       * specified field_name. In the case of numerical it is straightforward
       * i.e. attribute_value = numerical_field_value. In the case of freshness
       * however, attribute_value = (time.now() - datetime_field_value).
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for attributeType.
       */
      int getAttributeTypeValue();
      /**
       *
       *
       * <pre>
       * Optional. The attribute type to be used to determine the boost amount.
       * The attribute value can be derived from the field value of the
       * specified field_name. In the case of numerical it is straightforward
       * i.e. attribute_value = numerical_field_value. In the case of freshness
       * however, attribute_value = (time.now() - datetime_field_value).
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The attributeType.
       */
      com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType
          getAttributeType();

      /**
       *
       *
       * <pre>
       * Optional. The interpolation type to be applied to connect the control
       * points listed below.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for interpolationType.
       */
      int getInterpolationTypeValue();
      /**
       *
       *
       * <pre>
       * Optional. The interpolation type to be applied to connect the control
       * points listed below.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The interpolationType.
       */
      com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
              .InterpolationType
          getInterpolationType();

      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .ControlPoint>
          getControlPointsList();
      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint
          getControlPoints(int index);
      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      int getControlPointsCount();
      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .ControlPointOrBuilder>
          getControlPointsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
              .ControlPointOrBuilder
          getControlPointsOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Specification for custom ranking based on customer specified attribute
     * value. It provides more controls for customized ranking than the simple
     * (condition, boost) combination above.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec}
     */
    public static final class BoostControlSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec)
        BoostControlSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use BoostControlSpec.newBuilder() to construct.
      private BoostControlSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private BoostControlSpec() {
        fieldName_ = "";
        attributeType_ = 0;
        interpolationType_ = 0;
        controlPoints_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new BoostControlSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.SessionProto
            .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_BoostControlSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.SessionProto
            .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_BoostControlSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .class,
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .Builder.class);
      }

      /**
       *
       *
       * <pre>
       * The attribute(or function) for which the custom ranking is to be
       * applied.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType}
       */
      public enum AttributeType implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified AttributeType.
         * </pre>
         *
         * <code>ATTRIBUTE_TYPE_UNSPECIFIED = 0;</code>
         */
        ATTRIBUTE_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * The value of the numerical field will be used to dynamically update
         * the boost amount. In this case, the attribute_value (the x value)
         * of the control point will be the actual value of the numerical
         * field for which the boost_amount is specified.
         * </pre>
         *
         * <code>NUMERICAL = 1;</code>
         */
        NUMERICAL(1),
        /**
         *
         *
         * <pre>
         * For the freshness use case the attribute value will be the duration
         * between the current time and the date in the datetime field
         * specified. The value must be formatted as an XSD `dayTimeDuration`
         * value (a restricted subset of an ISO 8601 duration value). The
         * pattern for this is: `[nD][T[nH][nM][nS]]`.
         * E.g. `5D`, `3DT12H30M`, `T24H`.
         * </pre>
         *
         * <code>FRESHNESS = 2;</code>
         */
        FRESHNESS(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified AttributeType.
         * </pre>
         *
         * <code>ATTRIBUTE_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int ATTRIBUTE_TYPE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * The value of the numerical field will be used to dynamically update
         * the boost amount. In this case, the attribute_value (the x value)
         * of the control point will be the actual value of the numerical
         * field for which the boost_amount is specified.
         * </pre>
         *
         * <code>NUMERICAL = 1;</code>
         */
        public static final int NUMERICAL_VALUE = 1;
        /**
         *
         *
         * <pre>
         * For the freshness use case the attribute value will be the duration
         * between the current time and the date in the datetime field
         * specified. The value must be formatted as an XSD `dayTimeDuration`
         * value (a restricted subset of an ISO 8601 duration value). The
         * pattern for this is: `[nD][T[nH][nM][nS]]`.
         * E.g. `5D`, `3DT12H30M`, `T24H`.
         * </pre>
         *
         * <code>FRESHNESS = 2;</code>
         */
        public static final int FRESHNESS_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static AttributeType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static AttributeType forNumber(int value) {
          switch (value) {
            case 0:
              return ATTRIBUTE_TYPE_UNSPECIFIED;
            case 1:
              return NUMERICAL;
            case 2:
              return FRESHNESS;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<AttributeType>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<AttributeType>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<AttributeType>() {
                  public AttributeType findValueByNumber(int number) {
                    return AttributeType.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
              .getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final AttributeType[] VALUES = values();

        public static AttributeType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private AttributeType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType)
      }

      /**
       *
       *
       * <pre>
       * The interpolation type to be applied. Default will be linear
       * (Piecewise Linear).
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType}
       */
      public enum InterpolationType implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Interpolation type is unspecified. In this case, it defaults to
         * Linear.
         * </pre>
         *
         * <code>INTERPOLATION_TYPE_UNSPECIFIED = 0;</code>
         */
        INTERPOLATION_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Piecewise linear interpolation will be applied.
         * </pre>
         *
         * <code>LINEAR = 1;</code>
         */
        LINEAR(1),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Interpolation type is unspecified. In this case, it defaults to
         * Linear.
         * </pre>
         *
         * <code>INTERPOLATION_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int INTERPOLATION_TYPE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Piecewise linear interpolation will be applied.
         * </pre>
         *
         * <code>LINEAR = 1;</code>
         */
        public static final int LINEAR_VALUE = 1;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static InterpolationType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static InterpolationType forNumber(int value) {
          switch (value) {
            case 0:
              return INTERPOLATION_TYPE_UNSPECIFIED;
            case 1:
              return LINEAR;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<InterpolationType>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<InterpolationType>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<InterpolationType>() {
                  public InterpolationType findValueByNumber(int number) {
                    return InterpolationType.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
              .getDescriptor()
              .getEnumTypes()
              .get(1);
        }

        private static final InterpolationType[] VALUES = values();

        public static InterpolationType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private InterpolationType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType)
      }

      public interface ControlPointOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Optional. Can be one of:
         * 1. The numerical field value.
         * 2. The duration spec for freshness:
         * The value must be formatted as an XSD `dayTimeDuration` value (a
         * restricted subset of an ISO 8601 duration value). The pattern for
         * this is: `[nD][T[nH][nM][nS]]`.
         * </pre>
         *
         * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The attributeValue.
         */
        java.lang.String getAttributeValue();
        /**
         *
         *
         * <pre>
         * Optional. Can be one of:
         * 1. The numerical field value.
         * 2. The duration spec for freshness:
         * The value must be formatted as an XSD `dayTimeDuration` value (a
         * restricted subset of an ISO 8601 duration value). The pattern for
         * this is: `[nD][T[nH][nM][nS]]`.
         * </pre>
         *
         * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for attributeValue.
         */
        com.google.protobuf.ByteString getAttributeValueBytes();

        /**
         *
         *
         * <pre>
         * Optional. The value between -1 to 1 by which to boost the score if
         * the attribute_value evaluates to the value specified above.
         * </pre>
         *
         * <code>float boost_amount = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The boostAmount.
         */
        float getBoostAmount();
      }
      /**
       *
       *
       * <pre>
       * The control points used to define the curve. The curve defined
       * through these control points can only be monotonically increasing
       * or decreasing(constant values are acceptable).
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint}
       */
      public static final class ControlPoint extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint)
          ControlPointOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use ControlPoint.newBuilder() to construct.
        private ControlPoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ControlPoint() {
          attributeValue_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ControlPoint();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.SessionProto
              .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3.SessionProto
              .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .ControlPoint.class,
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .ControlPoint.Builder.class);
        }

        public static final int ATTRIBUTE_VALUE_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object attributeValue_ = "";
        /**
         *
         *
         * <pre>
         * Optional. Can be one of:
         * 1. The numerical field value.
         * 2. The duration spec for freshness:
         * The value must be formatted as an XSD `dayTimeDuration` value (a
         * restricted subset of an ISO 8601 duration value). The pattern for
         * this is: `[nD][T[nH][nM][nS]]`.
         * </pre>
         *
         * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The attributeValue.
         */
        @java.lang.Override
        public java.lang.String getAttributeValue() {
          java.lang.Object ref = attributeValue_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            attributeValue_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Can be one of:
         * 1. The numerical field value.
         * 2. The duration spec for freshness:
         * The value must be formatted as an XSD `dayTimeDuration` value (a
         * restricted subset of an ISO 8601 duration value). The pattern for
         * this is: `[nD][T[nH][nM][nS]]`.
         * </pre>
         *
         * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for attributeValue.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getAttributeValueBytes() {
          java.lang.Object ref = attributeValue_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            attributeValue_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int BOOST_AMOUNT_FIELD_NUMBER = 2;
        private float boostAmount_ = 0F;
        /**
         *
         *
         * <pre>
         * Optional. The value between -1 to 1 by which to boost the score if
         * the attribute_value evaluates to the value specified above.
         * </pre>
         *
         * <code>float boost_amount = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The boostAmount.
         */
        @java.lang.Override
        public float getBoostAmount() {
          return boostAmount_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributeValue_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, attributeValue_);
          }
          if (java.lang.Float.floatToRawIntBits(boostAmount_) != 0) {
            output.writeFloat(2, boostAmount_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributeValue_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, attributeValue_);
          }
          if (java.lang.Float.floatToRawIntBits(boostAmount_) != 0) {
            size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, boostAmount_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .ControlPoint)) {
            return super.equals(obj);
          }
          com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .ControlPoint
              other =
                  (com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                          .ControlPoint)
                      obj;

          if (!getAttributeValue().equals(other.getAttributeValue())) return false;
          if (java.lang.Float.floatToIntBits(getBoostAmount())
              != java.lang.Float.floatToIntBits(other.getBoostAmount())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + ATTRIBUTE_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getAttributeValue().hashCode();
          hash = (37 * hash) + BOOST_AMOUNT_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getBoostAmount());
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The curve defined
         * through these control points can only be monotonically increasing
         * or decreasing(constant values are acceptable).
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint)
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .ControlPointOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.dialogflow.cx.v3.SessionProto
                .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.dialogflow.cx.v3.SessionProto
                .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                        .ControlPoint.class,
                    com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                        .ControlPoint.Builder.class);
          }

          // Construct using
          // com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            attributeValue_ = "";
            boostAmount_ = 0F;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.dialogflow.cx.v3.SessionProto
                .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .ControlPoint
              getDefaultInstanceForType() {
            return com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .ControlPoint.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .ControlPoint
              build() {
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .ControlPoint
              buildPartial() {
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint
                result =
                    new com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                        .BoostControlSpec.ControlPoint(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .ControlPoint
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.attributeValue_ = attributeValue_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.boostAmount_ = boostAmount_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint) {
              return mergeFrom(
                  (com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                          .ControlPoint)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .ControlPoint
                  other) {
            if (other
                == com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint.getDefaultInstance()) return this;
            if (!other.getAttributeValue().isEmpty()) {
              attributeValue_ = other.attributeValue_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (other.getBoostAmount() != 0F) {
              setBoostAmount(other.getBoostAmount());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      attributeValue_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 21:
                    {
                      boostAmount_ = input.readFloat();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 21
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object attributeValue_ = "";
          /**
           *
           *
           * <pre>
           * Optional. Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The attributeValue.
           */
          public java.lang.String getAttributeValue() {
            java.lang.Object ref = attributeValue_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              attributeValue_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The bytes for attributeValue.
           */
          public com.google.protobuf.ByteString getAttributeValueBytes() {
            java.lang.Object ref = attributeValue_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              attributeValue_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The attributeValue to set.
           * @return This builder for chaining.
           */
          public Builder setAttributeValue(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            attributeValue_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAttributeValue() {
            attributeValue_ = getDefaultInstance().getAttributeValue();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The bytes for attributeValue to set.
           * @return This builder for chaining.
           */
          public Builder setAttributeValueBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            attributeValue_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private float boostAmount_;
          /**
           *
           *
           * <pre>
           * Optional. The value between -1 to 1 by which to boost the score if
           * the attribute_value evaluates to the value specified above.
           * </pre>
           *
           * <code>float boost_amount = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The boostAmount.
           */
          @java.lang.Override
          public float getBoostAmount() {
            return boostAmount_;
          }
          /**
           *
           *
           * <pre>
           * Optional. The value between -1 to 1 by which to boost the score if
           * the attribute_value evaluates to the value specified above.
           * </pre>
           *
           * <code>float boost_amount = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The boostAmount to set.
           * @return This builder for chaining.
           */
          public Builder setBoostAmount(float value) {

            boostAmount_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The value between -1 to 1 by which to boost the score if
           * the attribute_value evaluates to the value specified above.
           * </pre>
           *
           * <code>float boost_amount = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearBoostAmount() {
            bitField0_ = (bitField0_ & ~0x00000002);
            boostAmount_ = 0F;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint)
        private static final com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .ControlPoint();
        }

        public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                .BoostControlSpec.ControlPoint
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<ControlPoint> PARSER =
            new com.google.protobuf.AbstractParser<ControlPoint>() {
              @java.lang.Override
              public ControlPoint parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<ControlPoint> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<ControlPoint> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .ControlPoint
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int FIELD_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object fieldName_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The name of the field whose value will be used to determine
       * the boost amount.
       * </pre>
       *
       * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The fieldName.
       */
      @java.lang.Override
      public java.lang.String getFieldName() {
        java.lang.Object ref = fieldName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fieldName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of the field whose value will be used to determine
       * the boost amount.
       * </pre>
       *
       * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for fieldName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFieldNameBytes() {
        java.lang.Object ref = fieldName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fieldName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ATTRIBUTE_TYPE_FIELD_NUMBER = 2;
      private int attributeType_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. The attribute type to be used to determine the boost amount.
       * The attribute value can be derived from the field value of the
       * specified field_name. In the case of numerical it is straightforward
       * i.e. attribute_value = numerical_field_value. In the case of freshness
       * however, attribute_value = (time.now() - datetime_field_value).
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for attributeType.
       */
      @java.lang.Override
      public int getAttributeTypeValue() {
        return attributeType_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The attribute type to be used to determine the boost amount.
       * The attribute value can be derived from the field value of the
       * specified field_name. In the case of numerical it is straightforward
       * i.e. attribute_value = numerical_field_value. In the case of freshness
       * however, attribute_value = (time.now() - datetime_field_value).
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The attributeType.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
              .AttributeType
          getAttributeType() {
        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .AttributeType
            result =
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .AttributeType.forNumber(attributeType_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .AttributeType.UNRECOGNIZED
            : result;
      }

      public static final int INTERPOLATION_TYPE_FIELD_NUMBER = 3;
      private int interpolationType_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. The interpolation type to be applied to connect the control
       * points listed below.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for interpolationType.
       */
      @java.lang.Override
      public int getInterpolationTypeValue() {
        return interpolationType_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The interpolation type to be applied to connect the control
       * points listed below.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The interpolationType.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
              .InterpolationType
          getInterpolationType() {
        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .InterpolationType
            result =
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .InterpolationType.forNumber(interpolationType_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .InterpolationType.UNRECOGNIZED
            : result;
      }

      public static final int CONTROL_POINTS_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .ControlPoint>
          controlPoints_;
      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .ControlPoint>
          getControlPointsList() {
        return controlPoints_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .ControlPointOrBuilder>
          getControlPointsOrBuilderList() {
        return controlPoints_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public int getControlPointsCount() {
        return controlPoints_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
              .ControlPoint
          getControlPoints(int index) {
        return controlPoints_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
              .ControlPointOrBuilder
          getControlPointsOrBuilder(int index) {
        return controlPoints_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldName_);
        }
        if (attributeType_
            != com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .AttributeType.ATTRIBUTE_TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(2, attributeType_);
        }
        if (interpolationType_
            != com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .InterpolationType.INTERPOLATION_TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(3, interpolationType_);
        }
        for (int i = 0; i < controlPoints_.size(); i++) {
          output.writeMessage(4, controlPoints_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldName_);
        }
        if (attributeType_
            != com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .AttributeType.ATTRIBUTE_TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, attributeType_);
        }
        if (interpolationType_
            != com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .InterpolationType.INTERPOLATION_TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, interpolationType_);
        }
        for (int i = 0; i < controlPoints_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(4, controlPoints_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec other =
            (com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec) obj;

        if (!getFieldName().equals(other.getFieldName())) return false;
        if (attributeType_ != other.attributeType_) return false;
        if (interpolationType_ != other.interpolationType_) return false;
        if (!getControlPointsList().equals(other.getControlPointsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getFieldName().hashCode();
        hash = (37 * hash) + ATTRIBUTE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + attributeType_;
        hash = (37 * hash) + INTERPOLATION_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + interpolationType_;
        if (getControlPointsCount() > 0) {
          hash = (37 * hash) + CONTROL_POINTS_FIELD_NUMBER;
          hash = (53 * hash) + getControlPointsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specification for custom ranking based on customer specified attribute
       * value. It provides more controls for customized ranking than the simple
       * (condition, boost) combination above.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec)
          com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.SessionProto
              .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_BoostControlSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3.SessionProto
              .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_BoostControlSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .class,
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          fieldName_ = "";
          attributeType_ = 0;
          interpolationType_ = 0;
          if (controlPointsBuilder_ == null) {
            controlPoints_ = java.util.Collections.emptyList();
          } else {
            controlPoints_ = null;
            controlPointsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3.SessionProto
              .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_BoostControlSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
            build() {
          com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec result =
              new com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec(
                  this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                result) {
          if (controlPointsBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              controlPoints_ = java.util.Collections.unmodifiableList(controlPoints_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.controlPoints_ = controlPoints_;
          } else {
            result.controlPoints_ = controlPointsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.fieldName_ = fieldName_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.attributeType_ = attributeType_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.interpolationType_ = interpolationType_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .getDefaultInstance()) return this;
          if (!other.getFieldName().isEmpty()) {
            fieldName_ = other.fieldName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.attributeType_ != 0) {
            setAttributeTypeValue(other.getAttributeTypeValue());
          }
          if (other.interpolationType_ != 0) {
            setInterpolationTypeValue(other.getInterpolationTypeValue());
          }
          if (controlPointsBuilder_ == null) {
            if (!other.controlPoints_.isEmpty()) {
              if (controlPoints_.isEmpty()) {
                controlPoints_ = other.controlPoints_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureControlPointsIsMutable();
                controlPoints_.addAll(other.controlPoints_);
              }
              onChanged();
            }
          } else {
            if (!other.controlPoints_.isEmpty()) {
              if (controlPointsBuilder_.isEmpty()) {
                controlPointsBuilder_.dispose();
                controlPointsBuilder_ = null;
                controlPoints_ = other.controlPoints_;
                bitField0_ = (bitField0_ & ~0x00000008);
                controlPointsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getControlPointsFieldBuilder()
                        : null;
              } else {
                controlPointsBuilder_.addAllMessages(other.controlPoints_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    fieldName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    attributeType_ = input.readEnum();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    interpolationType_ = input.readEnum();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 34:
                  {
                    com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                            .ControlPoint
                        m =
                            input.readMessage(
                                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                                    .BoostControlSpec.ControlPoint.parser(),
                                extensionRegistry);
                    if (controlPointsBuilder_ == null) {
                      ensureControlPointsIsMutable();
                      controlPoints_.add(m);
                    } else {
                      controlPointsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object fieldName_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The name of the field whose value will be used to determine
         * the boost amount.
         * </pre>
         *
         * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The fieldName.
         */
        public java.lang.String getFieldName() {
          java.lang.Object ref = fieldName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            fieldName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the field whose value will be used to determine
         * the boost amount.
         * </pre>
         *
         * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for fieldName.
         */
        public com.google.protobuf.ByteString getFieldNameBytes() {
          java.lang.Object ref = fieldName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            fieldName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the field whose value will be used to determine
         * the boost amount.
         * </pre>
         *
         * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The fieldName to set.
         * @return This builder for chaining.
         */
        public Builder setFieldName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          fieldName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the field whose value will be used to determine
         * the boost amount.
         * </pre>
         *
         * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFieldName() {
          fieldName_ = getDefaultInstance().getFieldName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the field whose value will be used to determine
         * the boost amount.
         * </pre>
         *
         * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for fieldName to set.
         * @return This builder for chaining.
         */
        public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          fieldName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private int attributeType_ = 0;
        /**
         *
         *
         * <pre>
         * Optional. The attribute type to be used to determine the boost amount.
         * The attribute value can be derived from the field value of the
         * specified field_name. In the case of numerical it is straightforward
         * i.e. attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The enum numeric value on the wire for attributeType.
         */
        @java.lang.Override
        public int getAttributeTypeValue() {
          return attributeType_;
        }
        /**
         *
         *
         * <pre>
         * Optional. The attribute type to be used to determine the boost amount.
         * The attribute value can be derived from the field value of the
         * specified field_name. In the case of numerical it is straightforward
         * i.e. attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The enum numeric value on the wire for attributeType to set.
         * @return This builder for chaining.
         */
        public Builder setAttributeTypeValue(int value) {
          attributeType_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The attribute type to be used to determine the boost amount.
         * The attribute value can be derived from the field value of the
         * specified field_name. In the case of numerical it is straightforward
         * i.e. attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The attributeType.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .AttributeType
            getAttributeType() {
          com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .AttributeType
              result =
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .AttributeType.forNumber(attributeType_);
          return result == null
              ? com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .AttributeType.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Optional. The attribute type to be used to determine the boost amount.
         * The attribute value can be derived from the field value of the
         * specified field_name. In the case of numerical it is straightforward
         * i.e. attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The attributeType to set.
         * @return This builder for chaining.
         */
        public Builder setAttributeType(
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .AttributeType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000002;
          attributeType_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The attribute type to be used to determine the boost amount.
         * The attribute value can be derived from the field value of the
         * specified field_name. In the case of numerical it is straightforward
         * i.e. attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAttributeType() {
          bitField0_ = (bitField0_ & ~0x00000002);
          attributeType_ = 0;
          onChanged();
          return this;
        }

        private int interpolationType_ = 0;
        /**
         *
         *
         * <pre>
         * Optional. The interpolation type to be applied to connect the control
         * points listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The enum numeric value on the wire for interpolationType.
         */
        @java.lang.Override
        public int getInterpolationTypeValue() {
          return interpolationType_;
        }
        /**
         *
         *
         * <pre>
         * Optional. The interpolation type to be applied to connect the control
         * points listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The enum numeric value on the wire for interpolationType to set.
         * @return This builder for chaining.
         */
        public Builder setInterpolationTypeValue(int value) {
          interpolationType_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The interpolation type to be applied to connect the control
         * points listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The interpolationType.
         */
        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .InterpolationType
            getInterpolationType() {
          com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .InterpolationType
              result =
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .InterpolationType.forNumber(interpolationType_);
          return result == null
              ? com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .InterpolationType.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Optional. The interpolation type to be applied to connect the control
         * points listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The interpolationType to set.
         * @return This builder for chaining.
         */
        public Builder setInterpolationType(
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .InterpolationType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000004;
          interpolationType_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The interpolation type to be applied to connect the control
         * points listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearInterpolationType() {
          bitField0_ = (bitField0_ & ~0x00000004);
          interpolationType_ = 0;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint>
            controlPoints_ = java.util.Collections.emptyList();

        private void ensureControlPointsIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            controlPoints_ =
                new java.util.ArrayList<
                    com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                        .ControlPoint>(controlPoints_);
            bitField0_ |= 0x00000008;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint,
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint.Builder,
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPointOrBuilder>
            controlPointsBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint>
            getControlPointsList() {
          if (controlPointsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(controlPoints_);
          } else {
            return controlPointsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public int getControlPointsCount() {
          if (controlPointsBuilder_ == null) {
            return controlPoints_.size();
          } else {
            return controlPointsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .ControlPoint
            getControlPoints(int index) {
          if (controlPointsBuilder_ == null) {
            return controlPoints_.get(index);
          } else {
            return controlPointsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setControlPoints(
            int index,
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint
                value) {
          if (controlPointsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureControlPointsIsMutable();
            controlPoints_.set(index, value);
            onChanged();
          } else {
            controlPointsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setControlPoints(
            int index,
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint.Builder
                builderForValue) {
          if (controlPointsBuilder_ == null) {
            ensureControlPointsIsMutable();
            controlPoints_.set(index, builderForValue.build());
            onChanged();
          } else {
            controlPointsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addControlPoints(
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint
                value) {
          if (controlPointsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureControlPointsIsMutable();
            controlPoints_.add(value);
            onChanged();
          } else {
            controlPointsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addControlPoints(
            int index,
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint
                value) {
          if (controlPointsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureControlPointsIsMutable();
            controlPoints_.add(index, value);
            onChanged();
          } else {
            controlPointsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addControlPoints(
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint.Builder
                builderForValue) {
          if (controlPointsBuilder_ == null) {
            ensureControlPointsIsMutable();
            controlPoints_.add(builderForValue.build());
            onChanged();
          } else {
            controlPointsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addControlPoints(
            int index,
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint.Builder
                builderForValue) {
          if (controlPointsBuilder_ == null) {
            ensureControlPointsIsMutable();
            controlPoints_.add(index, builderForValue.build());
            onChanged();
          } else {
            controlPointsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addAllControlPoints(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                            .BoostControlSpec.ControlPoint>
                values) {
          if (controlPointsBuilder_ == null) {
            ensureControlPointsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, controlPoints_);
            onChanged();
          } else {
            controlPointsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearControlPoints() {
          if (controlPointsBuilder_ == null) {
            controlPoints_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
          } else {
            controlPointsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder removeControlPoints(int index) {
          if (controlPointsBuilder_ == null) {
            ensureControlPointsIsMutable();
            controlPoints_.remove(index);
            onChanged();
          } else {
            controlPointsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .ControlPoint.Builder
            getControlPointsBuilder(int index) {
          return getControlPointsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .ControlPointOrBuilder
            getControlPointsOrBuilder(int index) {
          if (controlPointsBuilder_ == null) {
            return controlPoints_.get(index);
          } else {
            return controlPointsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                        .ControlPointOrBuilder>
            getControlPointsOrBuilderList() {
          if (controlPointsBuilder_ != null) {
            return controlPointsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(controlPoints_);
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .ControlPoint.Builder
            addControlPointsBuilder() {
          return getControlPointsFieldBuilder()
              .addBuilder(
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .ControlPoint.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                .ControlPoint.Builder
            addControlPointsBuilder(int index) {
          return getControlPointsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .ControlPoint.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint.Builder>
            getControlPointsBuilderList() {
          return getControlPointsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint,
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPoint.Builder,
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                    .ControlPointOrBuilder>
            getControlPointsFieldBuilder() {
          if (controlPointsBuilder_ == null) {
            controlPointsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                        .ControlPoint,
                    com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                        .ControlPoint.Builder,
                    com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                        .ControlPointOrBuilder>(
                    controlPoints_,
                    ((bitField0_ & 0x00000008) != 0),
                    getParentForChildren(),
                    isClean());
            controlPoints_ = null;
          }
          return controlPointsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec)
      private static final com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
              .BoostControlSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec();
      }

      public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<BoostControlSpec> PARSER =
          new com.google.protobuf.AbstractParser<BoostControlSpec>() {
            @java.lang.Override
            public BoostControlSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<BoostControlSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<BoostControlSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int CONDITION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object condition_ = "";
    /**
     *
     *
     * <pre>
     * Optional. An expression which specifies a boost condition. The syntax and
     * supported fields are the same as a filter expression.
     * Examples:
     *
     * * To boost documents with document ID "doc_1" or "doc_2", and
     * color
     *   "Red" or "Blue":
     *     * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
     * </pre>
     *
     * <code>string condition = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The condition.
     */
    @java.lang.Override
    public java.lang.String getCondition() {
      java.lang.Object ref = condition_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        condition_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An expression which specifies a boost condition. The syntax and
     * supported fields are the same as a filter expression.
     * Examples:
     *
     * * To boost documents with document ID "doc_1" or "doc_2", and
     * color
     *   "Red" or "Blue":
     *     * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
     * </pre>
     *
     * <code>string condition = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for condition.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConditionBytes() {
      java.lang.Object ref = condition_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        condition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BOOST_FIELD_NUMBER = 2;
    private float boost_ = 0F;
    /**
     *
     *
     * <pre>
     * Optional. Strength of the condition boost, which should be in [-1, 1].
     * Negative boost means demotion. Default is 0.0.
     *
     * Setting to 1.0 gives the document a big promotion. However, it does not
     * necessarily mean that the boosted document will be the top result at
     * all times, nor that other documents will be excluded. Results could
     * still be shown even when none of them matches the condition. And
     * results that are significantly more relevant to the search query can
     * still trump your heavily favored but irrelevant documents.
     *
     * Setting to -1.0 gives the document a big demotion. However, results
     * that are deeply relevant might still be shown. The document will have
     * an upstream battle to get a fairly high ranking, but it is not blocked
     * out completely.
     *
     * Setting to 0.0 means no boost applied. The boosting condition is
     * ignored.
     * </pre>
     *
     * <code>float boost = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The boost.
     */
    @java.lang.Override
    public float getBoost() {
      return boost_;
    }

    public static final int BOOST_CONTROL_SPEC_FIELD_NUMBER = 4;
    private com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
        boostControlSpec_;
    /**
     *
     *
     * <pre>
     * Optional. Complex specification for custom ranking based on customer
     * defined attribute value.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the boostControlSpec field is set.
     */
    @java.lang.Override
    public boolean hasBoostControlSpec() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Complex specification for custom ranking based on customer
     * defined attribute value.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The boostControlSpec.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
        getBoostControlSpec() {
      return boostControlSpec_ == null
          ? com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
              .getDefaultInstance()
          : boostControlSpec_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Complex specification for custom ranking based on customer
     * defined attribute value.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpecOrBuilder
        getBoostControlSpecOrBuilder() {
      return boostControlSpec_ == null
          ? com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
              .getDefaultInstance()
          : boostControlSpec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, condition_);
      }
      if (java.lang.Float.floatToRawIntBits(boost_) != 0) {
        output.writeFloat(2, boost_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getBoostControlSpec());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, condition_);
      }
      if (java.lang.Float.floatToRawIntBits(boost_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, boost_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getBoostControlSpec());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec other =
          (com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec) obj;

      if (!getCondition().equals(other.getCondition())) return false;
      if (java.lang.Float.floatToIntBits(getBoost())
          != java.lang.Float.floatToIntBits(other.getBoost())) return false;
      if (hasBoostControlSpec() != other.hasBoostControlSpec()) return false;
      if (hasBoostControlSpec()) {
        if (!getBoostControlSpec().equals(other.getBoostControlSpec())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getCondition().hashCode();
      hash = (37 * hash) + BOOST_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getBoost());
      if (hasBoostControlSpec()) {
        hash = (37 * hash) + BOOST_CONTROL_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getBoostControlSpec().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Boost applies to documents which match a condition.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec)
        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.SessionProto
            .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.SessionProto
            .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.class,
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getBoostControlSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        condition_ = "";
        boost_ = 0F;
        boostControlSpec_ = null;
        if (boostControlSpecBuilder_ != null) {
          boostControlSpecBuilder_.dispose();
          boostControlSpecBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.SessionProto
            .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_ConditionBoostSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec build() {
        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec buildPartial() {
        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec result =
            new com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.condition_ = condition_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.boost_ = boost_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.boostControlSpec_ =
              boostControlSpecBuilder_ == null
                  ? boostControlSpec_
                  : boostControlSpecBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.getDefaultInstance())
          return this;
        if (!other.getCondition().isEmpty()) {
          condition_ = other.condition_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getBoost() != 0F) {
          setBoost(other.getBoost());
        }
        if (other.hasBoostControlSpec()) {
          mergeBoostControlSpec(other.getBoostControlSpec());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  condition_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 21:
                {
                  boost_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              case 34:
                {
                  input.readMessage(
                      getBoostControlSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object condition_ = "";
      /**
       *
       *
       * <pre>
       * Optional. An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression.
       * Examples:
       *
       * * To boost documents with document ID "doc_1" or "doc_2", and
       * color
       *   "Red" or "Blue":
       *     * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
       * </pre>
       *
       * <code>string condition = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The condition.
       */
      public java.lang.String getCondition() {
        java.lang.Object ref = condition_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          condition_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression.
       * Examples:
       *
       * * To boost documents with document ID "doc_1" or "doc_2", and
       * color
       *   "Red" or "Blue":
       *     * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
       * </pre>
       *
       * <code>string condition = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for condition.
       */
      public com.google.protobuf.ByteString getConditionBytes() {
        java.lang.Object ref = condition_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          condition_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression.
       * Examples:
       *
       * * To boost documents with document ID "doc_1" or "doc_2", and
       * color
       *   "Red" or "Blue":
       *     * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
       * </pre>
       *
       * <code>string condition = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The condition to set.
       * @return This builder for chaining.
       */
      public Builder setCondition(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        condition_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression.
       * Examples:
       *
       * * To boost documents with document ID "doc_1" or "doc_2", and
       * color
       *   "Red" or "Blue":
       *     * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
       * </pre>
       *
       * <code>string condition = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCondition() {
        condition_ = getDefaultInstance().getCondition();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression.
       * Examples:
       *
       * * To boost documents with document ID "doc_1" or "doc_2", and
       * color
       *   "Red" or "Blue":
       *     * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
       * </pre>
       *
       * <code>string condition = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for condition to set.
       * @return This builder for chaining.
       */
      public Builder setConditionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        condition_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private float boost_;
      /**
       *
       *
       * <pre>
       * Optional. Strength of the condition boost, which should be in [-1, 1].
       * Negative boost means demotion. Default is 0.0.
       *
       * Setting to 1.0 gives the document a big promotion. However, it does not
       * necessarily mean that the boosted document will be the top result at
       * all times, nor that other documents will be excluded. Results could
       * still be shown even when none of them matches the condition. And
       * results that are significantly more relevant to the search query can
       * still trump your heavily favored but irrelevant documents.
       *
       * Setting to -1.0 gives the document a big demotion. However, results
       * that are deeply relevant might still be shown. The document will have
       * an upstream battle to get a fairly high ranking, but it is not blocked
       * out completely.
       *
       * Setting to 0.0 means no boost applied. The boosting condition is
       * ignored.
       * </pre>
       *
       * <code>float boost = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The boost.
       */
      @java.lang.Override
      public float getBoost() {
        return boost_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Strength of the condition boost, which should be in [-1, 1].
       * Negative boost means demotion. Default is 0.0.
       *
       * Setting to 1.0 gives the document a big promotion. However, it does not
       * necessarily mean that the boosted document will be the top result at
       * all times, nor that other documents will be excluded. Results could
       * still be shown even when none of them matches the condition. And
       * results that are significantly more relevant to the search query can
       * still trump your heavily favored but irrelevant documents.
       *
       * Setting to -1.0 gives the document a big demotion. However, results
       * that are deeply relevant might still be shown. The document will have
       * an upstream battle to get a fairly high ranking, but it is not blocked
       * out completely.
       *
       * Setting to 0.0 means no boost applied. The boosting condition is
       * ignored.
       * </pre>
       *
       * <code>float boost = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The boost to set.
       * @return This builder for chaining.
       */
      public Builder setBoost(float value) {

        boost_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Strength of the condition boost, which should be in [-1, 1].
       * Negative boost means demotion. Default is 0.0.
       *
       * Setting to 1.0 gives the document a big promotion. However, it does not
       * necessarily mean that the boosted document will be the top result at
       * all times, nor that other documents will be excluded. Results could
       * still be shown even when none of them matches the condition. And
       * results that are significantly more relevant to the search query can
       * still trump your heavily favored but irrelevant documents.
       *
       * Setting to -1.0 gives the document a big demotion. However, results
       * that are deeply relevant might still be shown. The document will have
       * an upstream battle to get a fairly high ranking, but it is not blocked
       * out completely.
       *
       * Setting to 0.0 means no boost applied. The boosting condition is
       * ignored.
       * </pre>
       *
       * <code>float boost = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBoost() {
        bitField0_ = (bitField0_ & ~0x00000002);
        boost_ = 0F;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          boostControlSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec,
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .Builder,
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                  .BoostControlSpecOrBuilder>
          boostControlSpecBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the boostControlSpec field is set.
       */
      public boolean hasBoostControlSpec() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The boostControlSpec.
       */
      public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
          getBoostControlSpec() {
        if (boostControlSpecBuilder_ == null) {
          return boostControlSpec_ == null
              ? com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .getDefaultInstance()
              : boostControlSpec_;
        } else {
          return boostControlSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setBoostControlSpec(
          com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec value) {
        if (boostControlSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          boostControlSpec_ = value;
        } else {
          boostControlSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setBoostControlSpec(
          com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.Builder
              builderForValue) {
        if (boostControlSpecBuilder_ == null) {
          boostControlSpec_ = builderForValue.build();
        } else {
          boostControlSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeBoostControlSpec(
          com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec value) {
        if (boostControlSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && boostControlSpec_ != null
              && boostControlSpec_
                  != com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .getDefaultInstance()) {
            getBoostControlSpecBuilder().mergeFrom(value);
          } else {
            boostControlSpec_ = value;
          }
        } else {
          boostControlSpecBuilder_.mergeFrom(value);
        }
        if (boostControlSpec_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearBoostControlSpec() {
        bitField0_ = (bitField0_ & ~0x00000004);
        boostControlSpec_ = null;
        if (boostControlSpecBuilder_ != null) {
          boostControlSpecBuilder_.dispose();
          boostControlSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec.Builder
          getBoostControlSpecBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getBoostControlSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
              .BoostControlSpecOrBuilder
          getBoostControlSpecOrBuilder() {
        if (boostControlSpecBuilder_ != null) {
          return boostControlSpecBuilder_.getMessageOrBuilder();
        } else {
          return boostControlSpec_ == null
              ? com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .getDefaultInstance()
              : boostControlSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec boost_control_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec,
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                  .Builder,
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                  .BoostControlSpecOrBuilder>
          getBoostControlSpecFieldBuilder() {
        if (boostControlSpecBuilder_ == null) {
          boostControlSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec,
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.BoostControlSpec
                      .Builder,
                  com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
                      .BoostControlSpecOrBuilder>(
                  getBoostControlSpec(), getParentForChildren(), isClean());
          boostControlSpec_ = null;
        }
        return boostControlSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec)
    private static final com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec();
    }

    public static com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConditionBoostSpec> PARSER =
        new com.google.protobuf.AbstractParser<ConditionBoostSpec>() {
          @java.lang.Override
          public ConditionBoostSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConditionBoostSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConditionBoostSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CONDITION_BOOST_SPECS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec>
      conditionBoostSpecs_;
  /**
   *
   *
   * <pre>
   * Optional. Condition boost specifications. If a document matches multiple
   * conditions in the specifications, boost scores from these specifications
   * are all applied and combined in a non-linear way. Maximum number of
   * specifications is 20.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec>
      getConditionBoostSpecsList() {
    return conditionBoostSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Condition boost specifications. If a document matches multiple
   * conditions in the specifications, boost scores from these specifications
   * are all applied and combined in a non-linear way. Maximum number of
   * specifications is 20.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpecOrBuilder>
      getConditionBoostSpecsOrBuilderList() {
    return conditionBoostSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Condition boost specifications. If a document matches multiple
   * conditions in the specifications, boost scores from these specifications
   * are all applied and combined in a non-linear way. Maximum number of
   * specifications is 20.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getConditionBoostSpecsCount() {
    return conditionBoostSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Condition boost specifications. If a document matches multiple
   * conditions in the specifications, boost scores from these specifications
   * are all applied and combined in a non-linear way. Maximum number of
   * specifications is 20.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec getConditionBoostSpecs(
      int index) {
    return conditionBoostSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Condition boost specifications. If a document matches multiple
   * conditions in the specifications, boost scores from these specifications
   * are all applied and combined in a non-linear way. Maximum number of
   * specifications is 20.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpecOrBuilder
      getConditionBoostSpecsOrBuilder(int index) {
    return conditionBoostSpecs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < conditionBoostSpecs_.size(); i++) {
      output.writeMessage(1, conditionBoostSpecs_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < conditionBoostSpecs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, conditionBoostSpecs_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.BoostSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.BoostSpec other =
        (com.google.cloud.dialogflow.cx.v3.BoostSpec) obj;

    if (!getConditionBoostSpecsList().equals(other.getConditionBoostSpecsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getConditionBoostSpecsCount() > 0) {
      hash = (37 * hash) + CONDITION_BOOST_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionBoostSpecsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.BoostSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Boost specification to boost certain documents.
   * A copy of google.cloud.discoveryengine.v1main.BoostSpec, field documentation
   * is available at
   * https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1alpha/BoostSpec
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.BoostSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.BoostSpec)
      com.google.cloud.dialogflow.cx.v3.BoostSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.BoostSpec.class,
              com.google.cloud.dialogflow.cx.v3.BoostSpec.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.BoostSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (conditionBoostSpecsBuilder_ == null) {
        conditionBoostSpecs_ = java.util.Collections.emptyList();
      } else {
        conditionBoostSpecs_ = null;
        conditionBoostSpecsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.SessionProto
          .internal_static_google_cloud_dialogflow_cx_v3_BoostSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.BoostSpec getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.BoostSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.BoostSpec build() {
      com.google.cloud.dialogflow.cx.v3.BoostSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.BoostSpec buildPartial() {
      com.google.cloud.dialogflow.cx.v3.BoostSpec result =
          new com.google.cloud.dialogflow.cx.v3.BoostSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dialogflow.cx.v3.BoostSpec result) {
      if (conditionBoostSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          conditionBoostSpecs_ = java.util.Collections.unmodifiableList(conditionBoostSpecs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.conditionBoostSpecs_ = conditionBoostSpecs_;
      } else {
        result.conditionBoostSpecs_ = conditionBoostSpecsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.BoostSpec result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.BoostSpec) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.BoostSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.BoostSpec other) {
      if (other == com.google.cloud.dialogflow.cx.v3.BoostSpec.getDefaultInstance()) return this;
      if (conditionBoostSpecsBuilder_ == null) {
        if (!other.conditionBoostSpecs_.isEmpty()) {
          if (conditionBoostSpecs_.isEmpty()) {
            conditionBoostSpecs_ = other.conditionBoostSpecs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureConditionBoostSpecsIsMutable();
            conditionBoostSpecs_.addAll(other.conditionBoostSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.conditionBoostSpecs_.isEmpty()) {
          if (conditionBoostSpecsBuilder_.isEmpty()) {
            conditionBoostSpecsBuilder_.dispose();
            conditionBoostSpecsBuilder_ = null;
            conditionBoostSpecs_ = other.conditionBoostSpecs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            conditionBoostSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionBoostSpecsFieldBuilder()
                    : null;
          } else {
            conditionBoostSpecsBuilder_.addAllMessages(other.conditionBoostSpecs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.parser(),
                        extensionRegistry);
                if (conditionBoostSpecsBuilder_ == null) {
                  ensureConditionBoostSpecsIsMutable();
                  conditionBoostSpecs_.add(m);
                } else {
                  conditionBoostSpecsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec>
        conditionBoostSpecs_ = java.util.Collections.emptyList();

    private void ensureConditionBoostSpecsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        conditionBoostSpecs_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec>(
                conditionBoostSpecs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec,
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.Builder,
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpecOrBuilder>
        conditionBoostSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec>
        getConditionBoostSpecsList() {
      if (conditionBoostSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditionBoostSpecs_);
      } else {
        return conditionBoostSpecsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getConditionBoostSpecsCount() {
      if (conditionBoostSpecsBuilder_ == null) {
        return conditionBoostSpecs_.size();
      } else {
        return conditionBoostSpecsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec getConditionBoostSpecs(
        int index) {
      if (conditionBoostSpecsBuilder_ == null) {
        return conditionBoostSpecs_.get(index);
      } else {
        return conditionBoostSpecsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConditionBoostSpecs(
        int index, com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec value) {
      if (conditionBoostSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionBoostSpecsIsMutable();
        conditionBoostSpecs_.set(index, value);
        onChanged();
      } else {
        conditionBoostSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConditionBoostSpecs(
        int index,
        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.Builder builderForValue) {
      if (conditionBoostSpecsBuilder_ == null) {
        ensureConditionBoostSpecsIsMutable();
        conditionBoostSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionBoostSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addConditionBoostSpecs(
        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec value) {
      if (conditionBoostSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionBoostSpecsIsMutable();
        conditionBoostSpecs_.add(value);
        onChanged();
      } else {
        conditionBoostSpecsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addConditionBoostSpecs(
        int index, com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec value) {
      if (conditionBoostSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionBoostSpecsIsMutable();
        conditionBoostSpecs_.add(index, value);
        onChanged();
      } else {
        conditionBoostSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addConditionBoostSpecs(
        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.Builder builderForValue) {
      if (conditionBoostSpecsBuilder_ == null) {
        ensureConditionBoostSpecsIsMutable();
        conditionBoostSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        conditionBoostSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addConditionBoostSpecs(
        int index,
        com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.Builder builderForValue) {
      if (conditionBoostSpecsBuilder_ == null) {
        ensureConditionBoostSpecsIsMutable();
        conditionBoostSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionBoostSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllConditionBoostSpecs(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec>
            values) {
      if (conditionBoostSpecsBuilder_ == null) {
        ensureConditionBoostSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditionBoostSpecs_);
        onChanged();
      } else {
        conditionBoostSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearConditionBoostSpecs() {
      if (conditionBoostSpecsBuilder_ == null) {
        conditionBoostSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        conditionBoostSpecsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeConditionBoostSpecs(int index) {
      if (conditionBoostSpecsBuilder_ == null) {
        ensureConditionBoostSpecsIsMutable();
        conditionBoostSpecs_.remove(index);
        onChanged();
      } else {
        conditionBoostSpecsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.Builder
        getConditionBoostSpecsBuilder(int index) {
      return getConditionBoostSpecsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpecOrBuilder
        getConditionBoostSpecsOrBuilder(int index) {
      if (conditionBoostSpecsBuilder_ == null) {
        return conditionBoostSpecs_.get(index);
      } else {
        return conditionBoostSpecsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpecOrBuilder>
        getConditionBoostSpecsOrBuilderList() {
      if (conditionBoostSpecsBuilder_ != null) {
        return conditionBoostSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditionBoostSpecs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.Builder
        addConditionBoostSpecsBuilder() {
      return getConditionBoostSpecsFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.Builder
        addConditionBoostSpecsBuilder(int index) {
      return getConditionBoostSpecsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Condition boost specifications. If a document matches multiple
     * conditions in the specifications, boost scores from these specifications
     * are all applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec condition_boost_specs = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.Builder>
        getConditionBoostSpecsBuilderList() {
      return getConditionBoostSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec,
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.Builder,
            com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpecOrBuilder>
        getConditionBoostSpecsFieldBuilder() {
      if (conditionBoostSpecsBuilder_ == null) {
        conditionBoostSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec,
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpec.Builder,
                com.google.cloud.dialogflow.cx.v3.BoostSpec.ConditionBoostSpecOrBuilder>(
                conditionBoostSpecs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        conditionBoostSpecs_ = null;
      }
      return conditionBoostSpecsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.BoostSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.BoostSpec)
  private static final com.google.cloud.dialogflow.cx.v3.BoostSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.BoostSpec();
  }

  public static com.google.cloud.dialogflow.cx.v3.BoostSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BoostSpec> PARSER =
      new com.google.protobuf.AbstractParser<BoostSpec>() {
        @java.lang.Override
        public BoostSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BoostSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BoostSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.BoostSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
