/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3/agent.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.cx.v3;

/**
 *
 *
 * <pre>
 * Agents are best described as Natural Language Understanding (NLU) modules
 * that transform user requests into actionable data. You can include agents
 * in your app, product, or service to determine user intent and respond to the
 * user in a natural way.
 *
 * After you create an agent, you can add
 * [Intents][google.cloud.dialogflow.cx.v3.Intent], [Entity
 * Types][google.cloud.dialogflow.cx.v3.EntityType],
 * [Flows][google.cloud.dialogflow.cx.v3.Flow],
 * [Fulfillments][google.cloud.dialogflow.cx.v3.Fulfillment],
 * [Webhooks][google.cloud.dialogflow.cx.v3.Webhook],
 * [TransitionRouteGroups][google.cloud.dialogflow.cx.v3.TransitionRouteGroup]
 * and so on to manage the conversation flows.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent}
 */
public final class Agent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Agent)
    AgentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Agent.newBuilder() to construct.
  private Agent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Agent() {
    name_ = "";
    displayName_ = "";
    defaultLanguageCode_ = "";
    supportedLanguageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    timeZone_ = "";
    description_ = "";
    avatarUri_ = "";
    startFlow_ = "";
    securitySettings_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Agent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3.AgentProto
        .internal_static_google_cloud_dialogflow_cx_v3_Agent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3.AgentProto
        .internal_static_google_cloud_dialogflow_cx_v3_Agent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3.Agent.class,
            com.google.cloud.dialogflow.cx.v3.Agent.Builder.class);
  }

  public interface GitIntegrationSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * GitHub settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
     * </code>
     *
     * @return Whether the githubSettings field is set.
     */
    boolean hasGithubSettings();
    /**
     *
     *
     * <pre>
     * GitHub settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
     * </code>
     *
     * @return The githubSettings.
     */
    com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
        getGithubSettings();
    /**
     *
     *
     * <pre>
     * GitHub settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettingsOrBuilder
        getGithubSettingsOrBuilder();

    com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GitSettingsCase
        getGitSettingsCase();
  }
  /**
   *
   *
   * <pre>
   * Settings for connecting to Git repository for an agent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings}
   */
  public static final class GitIntegrationSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings)
      GitIntegrationSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GitIntegrationSettings.newBuilder() to construct.
    private GitIntegrationSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GitIntegrationSettings() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GitIntegrationSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_GitIntegrationSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_GitIntegrationSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.class,
              com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.Builder.class);
    }

    public interface GithubSettingsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The unique repository display name for the GitHub repository.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      java.lang.String getDisplayName();
      /**
       *
       *
       * <pre>
       * The unique repository display name for the GitHub repository.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      com.google.protobuf.ByteString getDisplayNameBytes();

      /**
       *
       *
       * <pre>
       * The GitHub repository URI related to the agent.
       * </pre>
       *
       * <code>string repository_uri = 2;</code>
       *
       * @return The repositoryUri.
       */
      java.lang.String getRepositoryUri();
      /**
       *
       *
       * <pre>
       * The GitHub repository URI related to the agent.
       * </pre>
       *
       * <code>string repository_uri = 2;</code>
       *
       * @return The bytes for repositoryUri.
       */
      com.google.protobuf.ByteString getRepositoryUriBytes();

      /**
       *
       *
       * <pre>
       * The branch of the GitHub repository tracked for this agent.
       * </pre>
       *
       * <code>string tracking_branch = 3;</code>
       *
       * @return The trackingBranch.
       */
      java.lang.String getTrackingBranch();
      /**
       *
       *
       * <pre>
       * The branch of the GitHub repository tracked for this agent.
       * </pre>
       *
       * <code>string tracking_branch = 3;</code>
       *
       * @return The bytes for trackingBranch.
       */
      com.google.protobuf.ByteString getTrackingBranchBytes();

      /**
       *
       *
       * <pre>
       * The access token used to authenticate the access to the GitHub
       * repository.
       * </pre>
       *
       * <code>string access_token = 4;</code>
       *
       * @return The accessToken.
       */
      java.lang.String getAccessToken();
      /**
       *
       *
       * <pre>
       * The access token used to authenticate the access to the GitHub
       * repository.
       * </pre>
       *
       * <code>string access_token = 4;</code>
       *
       * @return The bytes for accessToken.
       */
      com.google.protobuf.ByteString getAccessTokenBytes();

      /**
       *
       *
       * <pre>
       * A list of branches configured to be used from Dialogflow.
       * </pre>
       *
       * <code>repeated string branches = 5;</code>
       *
       * @return A list containing the branches.
       */
      java.util.List<java.lang.String> getBranchesList();
      /**
       *
       *
       * <pre>
       * A list of branches configured to be used from Dialogflow.
       * </pre>
       *
       * <code>repeated string branches = 5;</code>
       *
       * @return The count of branches.
       */
      int getBranchesCount();
      /**
       *
       *
       * <pre>
       * A list of branches configured to be used from Dialogflow.
       * </pre>
       *
       * <code>repeated string branches = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The branches at the given index.
       */
      java.lang.String getBranches(int index);
      /**
       *
       *
       * <pre>
       * A list of branches configured to be used from Dialogflow.
       * </pre>
       *
       * <code>repeated string branches = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the branches at the given index.
       */
      com.google.protobuf.ByteString getBranchesBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * Settings of integration with GitHub.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings}
     */
    public static final class GithubSettings extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
        GithubSettingsOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use GithubSettings.newBuilder() to construct.
      private GithubSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private GithubSettings() {
        displayName_ = "";
        repositoryUri_ = "";
        trackingBranch_ = "";
        accessToken_ = "";
        branches_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new GithubSettings();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_GitIntegrationSettings_GithubSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_GitIntegrationSettings_GithubSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings.class,
                com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
                    .Builder.class);
      }

      public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * The unique repository display name for the GitHub repository.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      @java.lang.Override
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The unique repository display name for the GitHub repository.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int REPOSITORY_URI_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object repositoryUri_ = "";
      /**
       *
       *
       * <pre>
       * The GitHub repository URI related to the agent.
       * </pre>
       *
       * <code>string repository_uri = 2;</code>
       *
       * @return The repositoryUri.
       */
      @java.lang.Override
      public java.lang.String getRepositoryUri() {
        java.lang.Object ref = repositoryUri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          repositoryUri_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The GitHub repository URI related to the agent.
       * </pre>
       *
       * <code>string repository_uri = 2;</code>
       *
       * @return The bytes for repositoryUri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRepositoryUriBytes() {
        java.lang.Object ref = repositoryUri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          repositoryUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int TRACKING_BRANCH_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object trackingBranch_ = "";
      /**
       *
       *
       * <pre>
       * The branch of the GitHub repository tracked for this agent.
       * </pre>
       *
       * <code>string tracking_branch = 3;</code>
       *
       * @return The trackingBranch.
       */
      @java.lang.Override
      public java.lang.String getTrackingBranch() {
        java.lang.Object ref = trackingBranch_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          trackingBranch_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The branch of the GitHub repository tracked for this agent.
       * </pre>
       *
       * <code>string tracking_branch = 3;</code>
       *
       * @return The bytes for trackingBranch.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTrackingBranchBytes() {
        java.lang.Object ref = trackingBranch_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          trackingBranch_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ACCESS_TOKEN_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object accessToken_ = "";
      /**
       *
       *
       * <pre>
       * The access token used to authenticate the access to the GitHub
       * repository.
       * </pre>
       *
       * <code>string access_token = 4;</code>
       *
       * @return The accessToken.
       */
      @java.lang.Override
      public java.lang.String getAccessToken() {
        java.lang.Object ref = accessToken_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          accessToken_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The access token used to authenticate the access to the GitHub
       * repository.
       * </pre>
       *
       * <code>string access_token = 4;</code>
       *
       * @return The bytes for accessToken.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAccessTokenBytes() {
        java.lang.Object ref = accessToken_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          accessToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int BRANCHES_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList branches_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * A list of branches configured to be used from Dialogflow.
       * </pre>
       *
       * <code>repeated string branches = 5;</code>
       *
       * @return A list containing the branches.
       */
      public com.google.protobuf.ProtocolStringList getBranchesList() {
        return branches_;
      }
      /**
       *
       *
       * <pre>
       * A list of branches configured to be used from Dialogflow.
       * </pre>
       *
       * <code>repeated string branches = 5;</code>
       *
       * @return The count of branches.
       */
      public int getBranchesCount() {
        return branches_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of branches configured to be used from Dialogflow.
       * </pre>
       *
       * <code>repeated string branches = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The branches at the given index.
       */
      public java.lang.String getBranches(int index) {
        return branches_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of branches configured to be used from Dialogflow.
       * </pre>
       *
       * <code>repeated string branches = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the branches at the given index.
       */
      public com.google.protobuf.ByteString getBranchesBytes(int index) {
        return branches_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repositoryUri_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, repositoryUri_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trackingBranch_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, trackingBranch_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(accessToken_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, accessToken_);
        }
        for (int i = 0; i < branches_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, branches_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repositoryUri_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, repositoryUri_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trackingBranch_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, trackingBranch_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(accessToken_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, accessToken_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < branches_.size(); i++) {
            dataSize += computeStringSizeNoTag(branches_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getBranchesList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings other =
            (com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings) obj;

        if (!getDisplayName().equals(other.getDisplayName())) return false;
        if (!getRepositoryUri().equals(other.getRepositoryUri())) return false;
        if (!getTrackingBranch().equals(other.getTrackingBranch())) return false;
        if (!getAccessToken().equals(other.getAccessToken())) return false;
        if (!getBranchesList().equals(other.getBranchesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getDisplayName().hashCode();
        hash = (37 * hash) + REPOSITORY_URI_FIELD_NUMBER;
        hash = (53 * hash) + getRepositoryUri().hashCode();
        hash = (37 * hash) + TRACKING_BRANCH_FIELD_NUMBER;
        hash = (53 * hash) + getTrackingBranch().hashCode();
        hash = (37 * hash) + ACCESS_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getAccessToken().hashCode();
        if (getBranchesCount() > 0) {
          hash = (37 * hash) + BRANCHES_FIELD_NUMBER;
          hash = (53 * hash) + getBranchesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Settings of integration with GitHub.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
          com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettingsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3.AgentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Agent_GitIntegrationSettings_GithubSettings_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3.AgentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Agent_GitIntegrationSettings_GithubSettings_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
                      .class,
                  com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          displayName_ = "";
          repositoryUri_ = "";
          trackingBranch_ = "";
          accessToken_ = "";
          branches_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3.AgentProto
              .internal_static_google_cloud_dialogflow_cx_v3_Agent_GitIntegrationSettings_GithubSettings_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
            build() {
          com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings result =
              new com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.displayName_ = displayName_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.repositoryUri_ = repositoryUri_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.trackingBranch_ = trackingBranch_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.accessToken_ = accessToken_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            branches_.makeImmutable();
            result.branches_ = branches_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
                  .getDefaultInstance()) return this;
          if (!other.getDisplayName().isEmpty()) {
            displayName_ = other.displayName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getRepositoryUri().isEmpty()) {
            repositoryUri_ = other.repositoryUri_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getTrackingBranch().isEmpty()) {
            trackingBranch_ = other.trackingBranch_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (!other.getAccessToken().isEmpty()) {
            accessToken_ = other.accessToken_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          if (!other.branches_.isEmpty()) {
            if (branches_.isEmpty()) {
              branches_ = other.branches_;
              bitField0_ |= 0x00000010;
            } else {
              ensureBranchesIsMutable();
              branches_.addAll(other.branches_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    displayName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    repositoryUri_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    trackingBranch_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    accessToken_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                case 42:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureBranchesIsMutable();
                    branches_.add(s);
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object displayName_ = "";
        /**
         *
         *
         * <pre>
         * The unique repository display name for the GitHub repository.
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @return The displayName.
         */
        public java.lang.String getDisplayName() {
          java.lang.Object ref = displayName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            displayName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The unique repository display name for the GitHub repository.
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @return The bytes for displayName.
         */
        public com.google.protobuf.ByteString getDisplayNameBytes() {
          java.lang.Object ref = displayName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            displayName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The unique repository display name for the GitHub repository.
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @param value The displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          displayName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The unique repository display name for the GitHub repository.
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDisplayName() {
          displayName_ = getDefaultInstance().getDisplayName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The unique repository display name for the GitHub repository.
         * </pre>
         *
         * <code>string display_name = 1;</code>
         *
         * @param value The bytes for displayName to set.
         * @return This builder for chaining.
         */
        public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          displayName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object repositoryUri_ = "";
        /**
         *
         *
         * <pre>
         * The GitHub repository URI related to the agent.
         * </pre>
         *
         * <code>string repository_uri = 2;</code>
         *
         * @return The repositoryUri.
         */
        public java.lang.String getRepositoryUri() {
          java.lang.Object ref = repositoryUri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            repositoryUri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The GitHub repository URI related to the agent.
         * </pre>
         *
         * <code>string repository_uri = 2;</code>
         *
         * @return The bytes for repositoryUri.
         */
        public com.google.protobuf.ByteString getRepositoryUriBytes() {
          java.lang.Object ref = repositoryUri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            repositoryUri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The GitHub repository URI related to the agent.
         * </pre>
         *
         * <code>string repository_uri = 2;</code>
         *
         * @param value The repositoryUri to set.
         * @return This builder for chaining.
         */
        public Builder setRepositoryUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          repositoryUri_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The GitHub repository URI related to the agent.
         * </pre>
         *
         * <code>string repository_uri = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRepositoryUri() {
          repositoryUri_ = getDefaultInstance().getRepositoryUri();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The GitHub repository URI related to the agent.
         * </pre>
         *
         * <code>string repository_uri = 2;</code>
         *
         * @param value The bytes for repositoryUri to set.
         * @return This builder for chaining.
         */
        public Builder setRepositoryUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          repositoryUri_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object trackingBranch_ = "";
        /**
         *
         *
         * <pre>
         * The branch of the GitHub repository tracked for this agent.
         * </pre>
         *
         * <code>string tracking_branch = 3;</code>
         *
         * @return The trackingBranch.
         */
        public java.lang.String getTrackingBranch() {
          java.lang.Object ref = trackingBranch_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            trackingBranch_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The branch of the GitHub repository tracked for this agent.
         * </pre>
         *
         * <code>string tracking_branch = 3;</code>
         *
         * @return The bytes for trackingBranch.
         */
        public com.google.protobuf.ByteString getTrackingBranchBytes() {
          java.lang.Object ref = trackingBranch_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            trackingBranch_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The branch of the GitHub repository tracked for this agent.
         * </pre>
         *
         * <code>string tracking_branch = 3;</code>
         *
         * @param value The trackingBranch to set.
         * @return This builder for chaining.
         */
        public Builder setTrackingBranch(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          trackingBranch_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The branch of the GitHub repository tracked for this agent.
         * </pre>
         *
         * <code>string tracking_branch = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTrackingBranch() {
          trackingBranch_ = getDefaultInstance().getTrackingBranch();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The branch of the GitHub repository tracked for this agent.
         * </pre>
         *
         * <code>string tracking_branch = 3;</code>
         *
         * @param value The bytes for trackingBranch to set.
         * @return This builder for chaining.
         */
        public Builder setTrackingBranchBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          trackingBranch_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.lang.Object accessToken_ = "";
        /**
         *
         *
         * <pre>
         * The access token used to authenticate the access to the GitHub
         * repository.
         * </pre>
         *
         * <code>string access_token = 4;</code>
         *
         * @return The accessToken.
         */
        public java.lang.String getAccessToken() {
          java.lang.Object ref = accessToken_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            accessToken_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The access token used to authenticate the access to the GitHub
         * repository.
         * </pre>
         *
         * <code>string access_token = 4;</code>
         *
         * @return The bytes for accessToken.
         */
        public com.google.protobuf.ByteString getAccessTokenBytes() {
          java.lang.Object ref = accessToken_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            accessToken_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The access token used to authenticate the access to the GitHub
         * repository.
         * </pre>
         *
         * <code>string access_token = 4;</code>
         *
         * @param value The accessToken to set.
         * @return This builder for chaining.
         */
        public Builder setAccessToken(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          accessToken_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The access token used to authenticate the access to the GitHub
         * repository.
         * </pre>
         *
         * <code>string access_token = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAccessToken() {
          accessToken_ = getDefaultInstance().getAccessToken();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The access token used to authenticate the access to the GitHub
         * repository.
         * </pre>
         *
         * <code>string access_token = 4;</code>
         *
         * @param value The bytes for accessToken to set.
         * @return This builder for chaining.
         */
        public Builder setAccessTokenBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          accessToken_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList branches_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureBranchesIsMutable() {
          if (!branches_.isModifiable()) {
            branches_ = new com.google.protobuf.LazyStringArrayList(branches_);
          }
          bitField0_ |= 0x00000010;
        }
        /**
         *
         *
         * <pre>
         * A list of branches configured to be used from Dialogflow.
         * </pre>
         *
         * <code>repeated string branches = 5;</code>
         *
         * @return A list containing the branches.
         */
        public com.google.protobuf.ProtocolStringList getBranchesList() {
          branches_.makeImmutable();
          return branches_;
        }
        /**
         *
         *
         * <pre>
         * A list of branches configured to be used from Dialogflow.
         * </pre>
         *
         * <code>repeated string branches = 5;</code>
         *
         * @return The count of branches.
         */
        public int getBranchesCount() {
          return branches_.size();
        }
        /**
         *
         *
         * <pre>
         * A list of branches configured to be used from Dialogflow.
         * </pre>
         *
         * <code>repeated string branches = 5;</code>
         *
         * @param index The index of the element to return.
         * @return The branches at the given index.
         */
        public java.lang.String getBranches(int index) {
          return branches_.get(index);
        }
        /**
         *
         *
         * <pre>
         * A list of branches configured to be used from Dialogflow.
         * </pre>
         *
         * <code>repeated string branches = 5;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the branches at the given index.
         */
        public com.google.protobuf.ByteString getBranchesBytes(int index) {
          return branches_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * A list of branches configured to be used from Dialogflow.
         * </pre>
         *
         * <code>repeated string branches = 5;</code>
         *
         * @param index The index to set the value at.
         * @param value The branches to set.
         * @return This builder for chaining.
         */
        public Builder setBranches(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBranchesIsMutable();
          branches_.set(index, value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of branches configured to be used from Dialogflow.
         * </pre>
         *
         * <code>repeated string branches = 5;</code>
         *
         * @param value The branches to add.
         * @return This builder for chaining.
         */
        public Builder addBranches(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBranchesIsMutable();
          branches_.add(value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of branches configured to be used from Dialogflow.
         * </pre>
         *
         * <code>repeated string branches = 5;</code>
         *
         * @param values The branches to add.
         * @return This builder for chaining.
         */
        public Builder addAllBranches(java.lang.Iterable<java.lang.String> values) {
          ensureBranchesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, branches_);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of branches configured to be used from Dialogflow.
         * </pre>
         *
         * <code>repeated string branches = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBranches() {
          branches_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of branches configured to be used from Dialogflow.
         * </pre>
         *
         * <code>repeated string branches = 5;</code>
         *
         * @param value The bytes of the branches to add.
         * @return This builder for chaining.
         */
        public Builder addBranchesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureBranchesIsMutable();
          branches_.add(value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
      private static final com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
              .GithubSettings
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings();
      }

      public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<GithubSettings> PARSER =
          new com.google.protobuf.AbstractParser<GithubSettings>() {
            @java.lang.Override
            public GithubSettings parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<GithubSettings> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<GithubSettings> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int gitSettingsCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object gitSettings_;

    public enum GitSettingsCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GITHUB_SETTINGS(1),
      GITSETTINGS_NOT_SET(0);
      private final int value;

      private GitSettingsCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static GitSettingsCase valueOf(int value) {
        return forNumber(value);
      }

      public static GitSettingsCase forNumber(int value) {
        switch (value) {
          case 1:
            return GITHUB_SETTINGS;
          case 0:
            return GITSETTINGS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public GitSettingsCase getGitSettingsCase() {
      return GitSettingsCase.forNumber(gitSettingsCase_);
    }

    public static final int GITHUB_SETTINGS_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * GitHub settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
     * </code>
     *
     * @return Whether the githubSettings field is set.
     */
    @java.lang.Override
    public boolean hasGithubSettings() {
      return gitSettingsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * GitHub settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
     * </code>
     *
     * @return The githubSettings.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
        getGithubSettings() {
      if (gitSettingsCase_ == 1) {
        return (com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
            gitSettings_;
      }
      return com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * GitHub settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettingsOrBuilder
        getGithubSettingsOrBuilder() {
      if (gitSettingsCase_ == 1) {
        return (com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
            gitSettings_;
      }
      return com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (gitSettingsCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
                gitSettings_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (gitSettingsCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
                    gitSettings_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings other =
          (com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings) obj;

      if (!getGitSettingsCase().equals(other.getGitSettingsCase())) return false;
      switch (gitSettingsCase_) {
        case 1:
          if (!getGithubSettings().equals(other.getGithubSettings())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (gitSettingsCase_) {
        case 1:
          hash = (37 * hash) + GITHUB_SETTINGS_FIELD_NUMBER;
          hash = (53 * hash) + getGithubSettings().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Settings for connecting to Git repository for an agent.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings)
        com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_GitIntegrationSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_GitIntegrationSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.class,
                com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (githubSettingsBuilder_ != null) {
          githubSettingsBuilder_.clear();
        }
        gitSettingsCase_ = 0;
        gitSettings_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_GitIntegrationSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings build() {
        com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings buildPartial() {
        com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings result =
            new com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings result) {
        result.gitSettingsCase_ = gitSettingsCase_;
        result.gitSettings_ = this.gitSettings_;
        if (gitSettingsCase_ == 1 && githubSettingsBuilder_ != null) {
          result.gitSettings_ = githubSettingsBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.getDefaultInstance())
          return this;
        switch (other.getGitSettingsCase()) {
          case GITHUB_SETTINGS:
            {
              mergeGithubSettings(other.getGithubSettings());
              break;
            }
          case GITSETTINGS_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getGithubSettingsFieldBuilder().getBuilder(), extensionRegistry);
                  gitSettingsCase_ = 1;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int gitSettingsCase_ = 0;
      private java.lang.Object gitSettings_;

      public GitSettingsCase getGitSettingsCase() {
        return GitSettingsCase.forNumber(gitSettingsCase_);
      }

      public Builder clearGitSettings() {
        gitSettingsCase_ = 0;
        gitSettings_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings,
              com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings.Builder,
              com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
                  .GithubSettingsOrBuilder>
          githubSettingsBuilder_;
      /**
       *
       *
       * <pre>
       * GitHub settings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
       * </code>
       *
       * @return Whether the githubSettings field is set.
       */
      @java.lang.Override
      public boolean hasGithubSettings() {
        return gitSettingsCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * GitHub settings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
       * </code>
       *
       * @return The githubSettings.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
          getGithubSettings() {
        if (githubSettingsBuilder_ == null) {
          if (gitSettingsCase_ == 1) {
            return (com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
                gitSettings_;
          }
          return com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
              .getDefaultInstance();
        } else {
          if (gitSettingsCase_ == 1) {
            return githubSettingsBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * GitHub settings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
       * </code>
       */
      public Builder setGithubSettings(
          com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings value) {
        if (githubSettingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          gitSettings_ = value;
          onChanged();
        } else {
          githubSettingsBuilder_.setMessage(value);
        }
        gitSettingsCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * GitHub settings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
       * </code>
       */
      public Builder setGithubSettings(
          com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings.Builder
              builderForValue) {
        if (githubSettingsBuilder_ == null) {
          gitSettings_ = builderForValue.build();
          onChanged();
        } else {
          githubSettingsBuilder_.setMessage(builderForValue.build());
        }
        gitSettingsCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * GitHub settings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
       * </code>
       */
      public Builder mergeGithubSettings(
          com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings value) {
        if (githubSettingsBuilder_ == null) {
          if (gitSettingsCase_ == 1
              && gitSettings_
                  != com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
                      .getDefaultInstance()) {
            gitSettings_ =
                com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
                    .newBuilder(
                        (com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
                                .GithubSettings)
                            gitSettings_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            gitSettings_ = value;
          }
          onChanged();
        } else {
          if (gitSettingsCase_ == 1) {
            githubSettingsBuilder_.mergeFrom(value);
          } else {
            githubSettingsBuilder_.setMessage(value);
          }
        }
        gitSettingsCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * GitHub settings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
       * </code>
       */
      public Builder clearGithubSettings() {
        if (githubSettingsBuilder_ == null) {
          if (gitSettingsCase_ == 1) {
            gitSettingsCase_ = 0;
            gitSettings_ = null;
            onChanged();
          }
        } else {
          if (gitSettingsCase_ == 1) {
            gitSettingsCase_ = 0;
            gitSettings_ = null;
          }
          githubSettingsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * GitHub settings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings.Builder
          getGithubSettingsBuilder() {
        return getGithubSettingsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * GitHub settings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettingsOrBuilder
          getGithubSettingsOrBuilder() {
        if ((gitSettingsCase_ == 1) && (githubSettingsBuilder_ != null)) {
          return githubSettingsBuilder_.getMessageOrBuilder();
        } else {
          if (gitSettingsCase_ == 1) {
            return (com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
                gitSettings_;
          }
          return com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * GitHub settings.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings github_settings = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings,
              com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings.Builder,
              com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
                  .GithubSettingsOrBuilder>
          getGithubSettingsFieldBuilder() {
        if (githubSettingsBuilder_ == null) {
          if (!(gitSettingsCase_ == 1)) {
            gitSettings_ =
                com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
                    .getDefaultInstance();
          }
          githubSettingsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings,
                  com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings
                      .Builder,
                  com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
                      .GithubSettingsOrBuilder>(
                  (com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.GithubSettings)
                      gitSettings_,
                  getParentForChildren(),
                  isClean());
          gitSettings_ = null;
        }
        gitSettingsCase_ = 1;
        onChanged();
        return githubSettingsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings)
    private static final com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GitIntegrationSettings> PARSER =
        new com.google.protobuf.AbstractParser<GitIntegrationSettings>() {
          @java.lang.Override
          public GitIntegrationSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GitIntegrationSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GitIntegrationSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GenAppBuilderSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The full name of the Gen App Builder engine related to this
     * agent if there is one. Format: `projects/{Project ID}/locations/{Location
     * ID}/collections/{Collection ID}/engines/{Engine ID}`
     * </pre>
     *
     * <code>string engine = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The engine.
     */
    java.lang.String getEngine();
    /**
     *
     *
     * <pre>
     * Required. The full name of the Gen App Builder engine related to this
     * agent if there is one. Format: `projects/{Project ID}/locations/{Location
     * ID}/collections/{Collection ID}/engines/{Engine ID}`
     * </pre>
     *
     * <code>string engine = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for engine.
     */
    com.google.protobuf.ByteString getEngineBytes();
  }
  /**
   *
   *
   * <pre>
   * Settings for Gen App Builder.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings}
   */
  public static final class GenAppBuilderSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings)
      GenAppBuilderSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GenAppBuilderSettings.newBuilder() to construct.
    private GenAppBuilderSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GenAppBuilderSettings() {
      engine_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GenAppBuilderSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_GenAppBuilderSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_GenAppBuilderSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.class,
              com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.Builder.class);
    }

    public static final int ENGINE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object engine_ = "";
    /**
     *
     *
     * <pre>
     * Required. The full name of the Gen App Builder engine related to this
     * agent if there is one. Format: `projects/{Project ID}/locations/{Location
     * ID}/collections/{Collection ID}/engines/{Engine ID}`
     * </pre>
     *
     * <code>string engine = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The engine.
     */
    @java.lang.Override
    public java.lang.String getEngine() {
      java.lang.Object ref = engine_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        engine_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The full name of the Gen App Builder engine related to this
     * agent if there is one. Format: `projects/{Project ID}/locations/{Location
     * ID}/collections/{Collection ID}/engines/{Engine ID}`
     * </pre>
     *
     * <code>string engine = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for engine.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEngineBytes() {
      java.lang.Object ref = engine_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        engine_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(engine_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, engine_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(engine_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, engine_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings other =
          (com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings) obj;

      if (!getEngine().equals(other.getEngine())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENGINE_FIELD_NUMBER;
      hash = (53 * hash) + getEngine().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Settings for Gen App Builder.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings)
        com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_GenAppBuilderSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_GenAppBuilderSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.class,
                com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        engine_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_GenAppBuilderSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings build() {
        com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings buildPartial() {
        com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings result =
            new com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.engine_ = engine_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.getDefaultInstance())
          return this;
        if (!other.getEngine().isEmpty()) {
          engine_ = other.engine_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  engine_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object engine_ = "";
      /**
       *
       *
       * <pre>
       * Required. The full name of the Gen App Builder engine related to this
       * agent if there is one. Format: `projects/{Project ID}/locations/{Location
       * ID}/collections/{Collection ID}/engines/{Engine ID}`
       * </pre>
       *
       * <code>string engine = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The engine.
       */
      public java.lang.String getEngine() {
        java.lang.Object ref = engine_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          engine_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The full name of the Gen App Builder engine related to this
       * agent if there is one. Format: `projects/{Project ID}/locations/{Location
       * ID}/collections/{Collection ID}/engines/{Engine ID}`
       * </pre>
       *
       * <code>string engine = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for engine.
       */
      public com.google.protobuf.ByteString getEngineBytes() {
        java.lang.Object ref = engine_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          engine_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The full name of the Gen App Builder engine related to this
       * agent if there is one. Format: `projects/{Project ID}/locations/{Location
       * ID}/collections/{Collection ID}/engines/{Engine ID}`
       * </pre>
       *
       * <code>string engine = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The engine to set.
       * @return This builder for chaining.
       */
      public Builder setEngine(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        engine_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The full name of the Gen App Builder engine related to this
       * agent if there is one. Format: `projects/{Project ID}/locations/{Location
       * ID}/collections/{Collection ID}/engines/{Engine ID}`
       * </pre>
       *
       * <code>string engine = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEngine() {
        engine_ = getDefaultInstance().getEngine();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The full name of the Gen App Builder engine related to this
       * agent if there is one. Format: `projects/{Project ID}/locations/{Location
       * ID}/collections/{Collection ID}/engines/{Engine ID}`
       * </pre>
       *
       * <code>string engine = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for engine to set.
       * @return This builder for chaining.
       */
      public Builder setEngineBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        engine_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings)
    private static final com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GenAppBuilderSettings> PARSER =
        new com.google.protobuf.AbstractParser<GenAppBuilderSettings>() {
          @java.lang.Override
          public GenAppBuilderSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GenAppBuilderSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GenAppBuilderSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AnswerFeedbackSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. If enabled, end users will be able to provide
     * [answer feedback][google.cloud.dialogflow.cx.v3.AnswerFeedback] to
     * Dialogflow responses. Feature works only if interaction logging is
     * enabled in the Dialogflow agent.
     * </pre>
     *
     * <code>bool enable_answer_feedback = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableAnswerFeedback.
     */
    boolean getEnableAnswerFeedback();
  }
  /**
   *
   *
   * <pre>
   * Settings for answer feedback collection.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings}
   */
  public static final class AnswerFeedbackSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings)
      AnswerFeedbackSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnswerFeedbackSettings.newBuilder() to construct.
    private AnswerFeedbackSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnswerFeedbackSettings() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnswerFeedbackSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_AnswerFeedbackSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_AnswerFeedbackSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.class,
              com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.Builder.class);
    }

    public static final int ENABLE_ANSWER_FEEDBACK_FIELD_NUMBER = 1;
    private boolean enableAnswerFeedback_ = false;
    /**
     *
     *
     * <pre>
     * Optional. If enabled, end users will be able to provide
     * [answer feedback][google.cloud.dialogflow.cx.v3.AnswerFeedback] to
     * Dialogflow responses. Feature works only if interaction logging is
     * enabled in the Dialogflow agent.
     * </pre>
     *
     * <code>bool enable_answer_feedback = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableAnswerFeedback.
     */
    @java.lang.Override
    public boolean getEnableAnswerFeedback() {
      return enableAnswerFeedback_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enableAnswerFeedback_ != false) {
        output.writeBool(1, enableAnswerFeedback_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enableAnswerFeedback_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enableAnswerFeedback_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings other =
          (com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings) obj;

      if (getEnableAnswerFeedback() != other.getEnableAnswerFeedback()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLE_ANSWER_FEEDBACK_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableAnswerFeedback());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Settings for answer feedback collection.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings)
        com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_AnswerFeedbackSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_AnswerFeedbackSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.class,
                com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enableAnswerFeedback_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_AnswerFeedbackSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings build() {
        com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings buildPartial() {
        com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings result =
            new com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enableAnswerFeedback_ = enableAnswerFeedback_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.getDefaultInstance())
          return this;
        if (other.getEnableAnswerFeedback() != false) {
          setEnableAnswerFeedback(other.getEnableAnswerFeedback());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enableAnswerFeedback_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enableAnswerFeedback_;
      /**
       *
       *
       * <pre>
       * Optional. If enabled, end users will be able to provide
       * [answer feedback][google.cloud.dialogflow.cx.v3.AnswerFeedback] to
       * Dialogflow responses. Feature works only if interaction logging is
       * enabled in the Dialogflow agent.
       * </pre>
       *
       * <code>bool enable_answer_feedback = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The enableAnswerFeedback.
       */
      @java.lang.Override
      public boolean getEnableAnswerFeedback() {
        return enableAnswerFeedback_;
      }
      /**
       *
       *
       * <pre>
       * Optional. If enabled, end users will be able to provide
       * [answer feedback][google.cloud.dialogflow.cx.v3.AnswerFeedback] to
       * Dialogflow responses. Feature works only if interaction logging is
       * enabled in the Dialogflow agent.
       * </pre>
       *
       * <code>bool enable_answer_feedback = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The enableAnswerFeedback to set.
       * @return This builder for chaining.
       */
      public Builder setEnableAnswerFeedback(boolean value) {

        enableAnswerFeedback_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If enabled, end users will be able to provide
       * [answer feedback][google.cloud.dialogflow.cx.v3.AnswerFeedback] to
       * Dialogflow responses. Feature works only if interaction logging is
       * enabled in the Dialogflow agent.
       * </pre>
       *
       * <code>bool enable_answer_feedback = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableAnswerFeedback() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enableAnswerFeedback_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings)
    private static final com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnswerFeedbackSettings> PARSER =
        new com.google.protobuf.AbstractParser<AnswerFeedbackSettings>() {
          @java.lang.Override
          public AnswerFeedbackSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnswerFeedbackSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnswerFeedbackSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PersonalizationSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Default end user metadata, used when processing DetectIntent
     * requests. Recommended to be filled as a template instead of hard-coded
     * value, for example { "age": "$session.params.age" }. The data will be
     * merged with the
     * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
     * in
     * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
     * during query processing.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the defaultEndUserMetadata field is set.
     */
    boolean hasDefaultEndUserMetadata();
    /**
     *
     *
     * <pre>
     * Optional. Default end user metadata, used when processing DetectIntent
     * requests. Recommended to be filled as a template instead of hard-coded
     * value, for example { "age": "$session.params.age" }. The data will be
     * merged with the
     * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
     * in
     * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
     * during query processing.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The defaultEndUserMetadata.
     */
    com.google.protobuf.Struct getDefaultEndUserMetadata();
    /**
     *
     *
     * <pre>
     * Optional. Default end user metadata, used when processing DetectIntent
     * requests. Recommended to be filled as a template instead of hard-coded
     * value, for example { "age": "$session.params.age" }. The data will be
     * merged with the
     * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
     * in
     * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
     * during query processing.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.StructOrBuilder getDefaultEndUserMetadataOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Settings for end user personalization.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings}
   */
  public static final class PersonalizationSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings)
      PersonalizationSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PersonalizationSettings.newBuilder() to construct.
    private PersonalizationSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PersonalizationSettings() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PersonalizationSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_PersonalizationSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_PersonalizationSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.class,
              com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.Builder.class);
    }

    private int bitField0_;
    public static final int DEFAULT_END_USER_METADATA_FIELD_NUMBER = 1;
    private com.google.protobuf.Struct defaultEndUserMetadata_;
    /**
     *
     *
     * <pre>
     * Optional. Default end user metadata, used when processing DetectIntent
     * requests. Recommended to be filled as a template instead of hard-coded
     * value, for example { "age": "$session.params.age" }. The data will be
     * merged with the
     * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
     * in
     * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
     * during query processing.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the defaultEndUserMetadata field is set.
     */
    @java.lang.Override
    public boolean hasDefaultEndUserMetadata() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Default end user metadata, used when processing DetectIntent
     * requests. Recommended to be filled as a template instead of hard-coded
     * value, for example { "age": "$session.params.age" }. The data will be
     * merged with the
     * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
     * in
     * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
     * during query processing.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The defaultEndUserMetadata.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getDefaultEndUserMetadata() {
      return defaultEndUserMetadata_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : defaultEndUserMetadata_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default end user metadata, used when processing DetectIntent
     * requests. Recommended to be filled as a template instead of hard-coded
     * value, for example { "age": "$session.params.age" }. The data will be
     * merged with the
     * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
     * in
     * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
     * during query processing.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getDefaultEndUserMetadataOrBuilder() {
      return defaultEndUserMetadata_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : defaultEndUserMetadata_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getDefaultEndUserMetadata());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, getDefaultEndUserMetadata());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings other =
          (com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings) obj;

      if (hasDefaultEndUserMetadata() != other.hasDefaultEndUserMetadata()) return false;
      if (hasDefaultEndUserMetadata()) {
        if (!getDefaultEndUserMetadata().equals(other.getDefaultEndUserMetadata())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDefaultEndUserMetadata()) {
        hash = (37 * hash) + DEFAULT_END_USER_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultEndUserMetadata().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Settings for end user personalization.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings)
        com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_PersonalizationSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_PersonalizationSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.class,
                com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDefaultEndUserMetadataFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        defaultEndUserMetadata_ = null;
        if (defaultEndUserMetadataBuilder_ != null) {
          defaultEndUserMetadataBuilder_.dispose();
          defaultEndUserMetadataBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_PersonalizationSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings build() {
        com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings buildPartial() {
        com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings result =
            new com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.defaultEndUserMetadata_ =
              defaultEndUserMetadataBuilder_ == null
                  ? defaultEndUserMetadata_
                  : defaultEndUserMetadataBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings) {
          return mergeFrom((com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.getDefaultInstance())
          return this;
        if (other.hasDefaultEndUserMetadata()) {
          mergeDefaultEndUserMetadata(other.getDefaultEndUserMetadata());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getDefaultEndUserMetadataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Struct defaultEndUserMetadata_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          defaultEndUserMetadataBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Default end user metadata, used when processing DetectIntent
       * requests. Recommended to be filled as a template instead of hard-coded
       * value, for example { "age": "$session.params.age" }. The data will be
       * merged with the
       * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
       * in
       * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
       * during query processing.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the defaultEndUserMetadata field is set.
       */
      public boolean hasDefaultEndUserMetadata() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Default end user metadata, used when processing DetectIntent
       * requests. Recommended to be filled as a template instead of hard-coded
       * value, for example { "age": "$session.params.age" }. The data will be
       * merged with the
       * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
       * in
       * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
       * during query processing.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The defaultEndUserMetadata.
       */
      public com.google.protobuf.Struct getDefaultEndUserMetadata() {
        if (defaultEndUserMetadataBuilder_ == null) {
          return defaultEndUserMetadata_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : defaultEndUserMetadata_;
        } else {
          return defaultEndUserMetadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Default end user metadata, used when processing DetectIntent
       * requests. Recommended to be filled as a template instead of hard-coded
       * value, for example { "age": "$session.params.age" }. The data will be
       * merged with the
       * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
       * in
       * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
       * during query processing.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDefaultEndUserMetadata(com.google.protobuf.Struct value) {
        if (defaultEndUserMetadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultEndUserMetadata_ = value;
        } else {
          defaultEndUserMetadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Default end user metadata, used when processing DetectIntent
       * requests. Recommended to be filled as a template instead of hard-coded
       * value, for example { "age": "$session.params.age" }. The data will be
       * merged with the
       * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
       * in
       * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
       * during query processing.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setDefaultEndUserMetadata(com.google.protobuf.Struct.Builder builderForValue) {
        if (defaultEndUserMetadataBuilder_ == null) {
          defaultEndUserMetadata_ = builderForValue.build();
        } else {
          defaultEndUserMetadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Default end user metadata, used when processing DetectIntent
       * requests. Recommended to be filled as a template instead of hard-coded
       * value, for example { "age": "$session.params.age" }. The data will be
       * merged with the
       * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
       * in
       * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
       * during query processing.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeDefaultEndUserMetadata(com.google.protobuf.Struct value) {
        if (defaultEndUserMetadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && defaultEndUserMetadata_ != null
              && defaultEndUserMetadata_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getDefaultEndUserMetadataBuilder().mergeFrom(value);
          } else {
            defaultEndUserMetadata_ = value;
          }
        } else {
          defaultEndUserMetadataBuilder_.mergeFrom(value);
        }
        if (defaultEndUserMetadata_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Default end user metadata, used when processing DetectIntent
       * requests. Recommended to be filled as a template instead of hard-coded
       * value, for example { "age": "$session.params.age" }. The data will be
       * merged with the
       * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
       * in
       * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
       * during query processing.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearDefaultEndUserMetadata() {
        bitField0_ = (bitField0_ & ~0x00000001);
        defaultEndUserMetadata_ = null;
        if (defaultEndUserMetadataBuilder_ != null) {
          defaultEndUserMetadataBuilder_.dispose();
          defaultEndUserMetadataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Default end user metadata, used when processing DetectIntent
       * requests. Recommended to be filled as a template instead of hard-coded
       * value, for example { "age": "$session.params.age" }. The data will be
       * merged with the
       * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
       * in
       * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
       * during query processing.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Struct.Builder getDefaultEndUserMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getDefaultEndUserMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Default end user metadata, used when processing DetectIntent
       * requests. Recommended to be filled as a template instead of hard-coded
       * value, for example { "age": "$session.params.age" }. The data will be
       * merged with the
       * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
       * in
       * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
       * during query processing.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.StructOrBuilder getDefaultEndUserMetadataOrBuilder() {
        if (defaultEndUserMetadataBuilder_ != null) {
          return defaultEndUserMetadataBuilder_.getMessageOrBuilder();
        } else {
          return defaultEndUserMetadata_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : defaultEndUserMetadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Default end user metadata, used when processing DetectIntent
       * requests. Recommended to be filled as a template instead of hard-coded
       * value, for example { "age": "$session.params.age" }. The data will be
       * merged with the
       * [QueryParameters.end_user_metadata][google.cloud.dialogflow.cx.v3.QueryParameters.end_user_metadata]
       * in
       * [DetectIntentRequest.query_params][google.cloud.dialogflow.cx.v3.DetectIntentRequest.query_params]
       * during query processing.
       * </pre>
       *
       * <code>
       * .google.protobuf.Struct default_end_user_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getDefaultEndUserMetadataFieldBuilder() {
        if (defaultEndUserMetadataBuilder_ == null) {
          defaultEndUserMetadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getDefaultEndUserMetadata(), getParentForChildren(), isClean());
          defaultEndUserMetadata_ = null;
        }
        return defaultEndUserMetadataBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings)
    private static final com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PersonalizationSettings> PARSER =
        new com.google.protobuf.AbstractParser<PersonalizationSettings>() {
          @java.lang.Override
          public PersonalizationSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PersonalizationSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PersonalizationSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ClientCertificateSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The ssl certificate encoded in PEM format. This string must
     * include the begin header and end footer lines.
     * </pre>
     *
     * <code>string ssl_certificate = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sslCertificate.
     */
    java.lang.String getSslCertificate();
    /**
     *
     *
     * <pre>
     * Required. The ssl certificate encoded in PEM format. This string must
     * include the begin header and end footer lines.
     * </pre>
     *
     * <code>string ssl_certificate = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sslCertificate.
     */
    com.google.protobuf.ByteString getSslCertificateBytes();

    /**
     *
     *
     * <pre>
     * Required. The name of the SecretManager secret version resource storing
     * the private key encoded in PEM format. Format:
     * `projects/{project}/secrets/{secret}/versions/{version}`
     * </pre>
     *
     * <code>
     * string private_key = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The privateKey.
     */
    java.lang.String getPrivateKey();
    /**
     *
     *
     * <pre>
     * Required. The name of the SecretManager secret version resource storing
     * the private key encoded in PEM format. Format:
     * `projects/{project}/secrets/{secret}/versions/{version}`
     * </pre>
     *
     * <code>
     * string private_key = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for privateKey.
     */
    com.google.protobuf.ByteString getPrivateKeyBytes();

    /**
     *
     *
     * <pre>
     * Optional. The name of the SecretManager secret version resource storing
     * the passphrase. 'passphrase' should be left unset if the private key is
     * not encrypted.
     * Format: `projects/{project}/secrets/{secret}/versions/{version}`
     * </pre>
     *
     * <code>
     * string passphrase = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The passphrase.
     */
    java.lang.String getPassphrase();
    /**
     *
     *
     * <pre>
     * Optional. The name of the SecretManager secret version resource storing
     * the passphrase. 'passphrase' should be left unset if the private key is
     * not encrypted.
     * Format: `projects/{project}/secrets/{secret}/versions/{version}`
     * </pre>
     *
     * <code>
     * string passphrase = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for passphrase.
     */
    com.google.protobuf.ByteString getPassphraseBytes();
  }
  /**
   *
   *
   * <pre>
   * Settings for custom client certificates.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings}
   */
  public static final class ClientCertificateSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings)
      ClientCertificateSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ClientCertificateSettings.newBuilder() to construct.
    private ClientCertificateSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ClientCertificateSettings() {
      sslCertificate_ = "";
      privateKey_ = "";
      passphrase_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ClientCertificateSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_ClientCertificateSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_ClientCertificateSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.class,
              com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.Builder.class);
    }

    public static final int SSL_CERTIFICATE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object sslCertificate_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ssl certificate encoded in PEM format. This string must
     * include the begin header and end footer lines.
     * </pre>
     *
     * <code>string ssl_certificate = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sslCertificate.
     */
    @java.lang.Override
    public java.lang.String getSslCertificate() {
      java.lang.Object ref = sslCertificate_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sslCertificate_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ssl certificate encoded in PEM format. This string must
     * include the begin header and end footer lines.
     * </pre>
     *
     * <code>string ssl_certificate = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sslCertificate.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSslCertificateBytes() {
      java.lang.Object ref = sslCertificate_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sslCertificate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PRIVATE_KEY_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object privateKey_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the SecretManager secret version resource storing
     * the private key encoded in PEM format. Format:
     * `projects/{project}/secrets/{secret}/versions/{version}`
     * </pre>
     *
     * <code>
     * string private_key = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The privateKey.
     */
    @java.lang.Override
    public java.lang.String getPrivateKey() {
      java.lang.Object ref = privateKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateKey_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the SecretManager secret version resource storing
     * the private key encoded in PEM format. Format:
     * `projects/{project}/secrets/{secret}/versions/{version}`
     * </pre>
     *
     * <code>
     * string private_key = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for privateKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrivateKeyBytes() {
      java.lang.Object ref = privateKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PASSPHRASE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object passphrase_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the SecretManager secret version resource storing
     * the passphrase. 'passphrase' should be left unset if the private key is
     * not encrypted.
     * Format: `projects/{project}/secrets/{secret}/versions/{version}`
     * </pre>
     *
     * <code>
     * string passphrase = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The passphrase.
     */
    @java.lang.Override
    public java.lang.String getPassphrase() {
      java.lang.Object ref = passphrase_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        passphrase_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the SecretManager secret version resource storing
     * the passphrase. 'passphrase' should be left unset if the private key is
     * not encrypted.
     * Format: `projects/{project}/secrets/{secret}/versions/{version}`
     * </pre>
     *
     * <code>
     * string passphrase = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for passphrase.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPassphraseBytes() {
      java.lang.Object ref = passphrase_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        passphrase_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sslCertificate_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sslCertificate_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateKey_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, privateKey_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(passphrase_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, passphrase_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sslCertificate_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sslCertificate_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(privateKey_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, privateKey_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(passphrase_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, passphrase_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings other =
          (com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings) obj;

      if (!getSslCertificate().equals(other.getSslCertificate())) return false;
      if (!getPrivateKey().equals(other.getPrivateKey())) return false;
      if (!getPassphrase().equals(other.getPassphrase())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SSL_CERTIFICATE_FIELD_NUMBER;
      hash = (53 * hash) + getSslCertificate().hashCode();
      hash = (37 * hash) + PRIVATE_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateKey().hashCode();
      hash = (37 * hash) + PASSPHRASE_FIELD_NUMBER;
      hash = (53 * hash) + getPassphrase().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Settings for custom client certificates.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings)
        com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_ClientCertificateSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_ClientCertificateSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.class,
                com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        sslCertificate_ = "";
        privateKey_ = "";
        passphrase_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3.AgentProto
            .internal_static_google_cloud_dialogflow_cx_v3_Agent_ClientCertificateSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings build() {
        com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings buildPartial() {
        com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings result =
            new com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.sslCertificate_ = sslCertificate_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.privateKey_ = privateKey_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.passphrase_ = passphrase_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
                .getDefaultInstance()) return this;
        if (!other.getSslCertificate().isEmpty()) {
          sslCertificate_ = other.sslCertificate_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getPrivateKey().isEmpty()) {
          privateKey_ = other.privateKey_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getPassphrase().isEmpty()) {
          passphrase_ = other.passphrase_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  sslCertificate_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  privateKey_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  passphrase_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object sslCertificate_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ssl certificate encoded in PEM format. This string must
       * include the begin header and end footer lines.
       * </pre>
       *
       * <code>string ssl_certificate = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The sslCertificate.
       */
      public java.lang.String getSslCertificate() {
        java.lang.Object ref = sslCertificate_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sslCertificate_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ssl certificate encoded in PEM format. This string must
       * include the begin header and end footer lines.
       * </pre>
       *
       * <code>string ssl_certificate = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for sslCertificate.
       */
      public com.google.protobuf.ByteString getSslCertificateBytes() {
        java.lang.Object ref = sslCertificate_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sslCertificate_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ssl certificate encoded in PEM format. This string must
       * include the begin header and end footer lines.
       * </pre>
       *
       * <code>string ssl_certificate = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The sslCertificate to set.
       * @return This builder for chaining.
       */
      public Builder setSslCertificate(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sslCertificate_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ssl certificate encoded in PEM format. This string must
       * include the begin header and end footer lines.
       * </pre>
       *
       * <code>string ssl_certificate = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSslCertificate() {
        sslCertificate_ = getDefaultInstance().getSslCertificate();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ssl certificate encoded in PEM format. This string must
       * include the begin header and end footer lines.
       * </pre>
       *
       * <code>string ssl_certificate = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for sslCertificate to set.
       * @return This builder for chaining.
       */
      public Builder setSslCertificateBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sslCertificate_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object privateKey_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the private key encoded in PEM format. Format:
       * `projects/{project}/secrets/{secret}/versions/{version}`
       * </pre>
       *
       * <code>
       * string private_key = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The privateKey.
       */
      public java.lang.String getPrivateKey() {
        java.lang.Object ref = privateKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          privateKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the private key encoded in PEM format. Format:
       * `projects/{project}/secrets/{secret}/versions/{version}`
       * </pre>
       *
       * <code>
       * string private_key = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for privateKey.
       */
      public com.google.protobuf.ByteString getPrivateKeyBytes() {
        java.lang.Object ref = privateKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          privateKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the private key encoded in PEM format. Format:
       * `projects/{project}/secrets/{secret}/versions/{version}`
       * </pre>
       *
       * <code>
       * string private_key = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The privateKey to set.
       * @return This builder for chaining.
       */
      public Builder setPrivateKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateKey_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the private key encoded in PEM format. Format:
       * `projects/{project}/secrets/{secret}/versions/{version}`
       * </pre>
       *
       * <code>
       * string private_key = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrivateKey() {
        privateKey_ = getDefaultInstance().getPrivateKey();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the SecretManager secret version resource storing
       * the private key encoded in PEM format. Format:
       * `projects/{project}/secrets/{secret}/versions/{version}`
       * </pre>
       *
       * <code>
       * string private_key = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for privateKey to set.
       * @return This builder for chaining.
       */
      public Builder setPrivateKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        privateKey_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object passphrase_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The name of the SecretManager secret version resource storing
       * the passphrase. 'passphrase' should be left unset if the private key is
       * not encrypted.
       * Format: `projects/{project}/secrets/{secret}/versions/{version}`
       * </pre>
       *
       * <code>
       * string passphrase = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The passphrase.
       */
      public java.lang.String getPassphrase() {
        java.lang.Object ref = passphrase_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          passphrase_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of the SecretManager secret version resource storing
       * the passphrase. 'passphrase' should be left unset if the private key is
       * not encrypted.
       * Format: `projects/{project}/secrets/{secret}/versions/{version}`
       * </pre>
       *
       * <code>
       * string passphrase = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for passphrase.
       */
      public com.google.protobuf.ByteString getPassphraseBytes() {
        java.lang.Object ref = passphrase_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          passphrase_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of the SecretManager secret version resource storing
       * the passphrase. 'passphrase' should be left unset if the private key is
       * not encrypted.
       * Format: `projects/{project}/secrets/{secret}/versions/{version}`
       * </pre>
       *
       * <code>
       * string passphrase = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The passphrase to set.
       * @return This builder for chaining.
       */
      public Builder setPassphrase(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        passphrase_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of the SecretManager secret version resource storing
       * the passphrase. 'passphrase' should be left unset if the private key is
       * not encrypted.
       * Format: `projects/{project}/secrets/{secret}/versions/{version}`
       * </pre>
       *
       * <code>
       * string passphrase = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPassphrase() {
        passphrase_ = getDefaultInstance().getPassphrase();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of the SecretManager secret version resource storing
       * the passphrase. 'passphrase' should be left unset if the private key is
       * not encrypted.
       * Format: `projects/{project}/secrets/{secret}/versions/{version}`
       * </pre>
       *
       * <code>
       * string passphrase = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for passphrase to set.
       * @return This builder for chaining.
       */
      public Builder setPassphraseBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        passphrase_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings)
    private static final com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings();
    }

    public static com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ClientCertificateSettings> PARSER =
        new com.google.protobuf.AbstractParser<ClientCertificateSettings>() {
          @java.lang.Override
          public ClientCertificateSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ClientCertificateSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ClientCertificateSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the agent.
   * Required for the
   * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
   * method.
   * [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
   * populates the name automatically.
   * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the agent.
   * Required for the
   * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
   * method.
   * [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
   * populates the name automatically.
   * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the agent, unique within the location.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the agent, unique within the location.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_LANGUAGE_CODE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultLanguageCode_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. The default language of the agent as a language tag.
   * See [Language
   * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
   * for a list of the currently supported language codes.
   * This field cannot be set by the
   * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
   * method.
   * </pre>
   *
   * <code>
   * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The defaultLanguageCode.
   */
  @java.lang.Override
  public java.lang.String getDefaultLanguageCode() {
    java.lang.Object ref = defaultLanguageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultLanguageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The default language of the agent as a language tag.
   * See [Language
   * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
   * for a list of the currently supported language codes.
   * This field cannot be set by the
   * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
   * method.
   * </pre>
   *
   * <code>
   * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for defaultLanguageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultLanguageCodeBytes() {
    java.lang.Object ref = defaultLanguageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultLanguageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUPPORTED_LANGUAGE_CODES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList supportedLanguageCodes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of all languages supported by the agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4;</code>
   *
   * @return A list containing the supportedLanguageCodes.
   */
  public com.google.protobuf.ProtocolStringList getSupportedLanguageCodesList() {
    return supportedLanguageCodes_;
  }
  /**
   *
   *
   * <pre>
   * The list of all languages supported by the agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4;</code>
   *
   * @return The count of supportedLanguageCodes.
   */
  public int getSupportedLanguageCodesCount() {
    return supportedLanguageCodes_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of all languages supported by the agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The supportedLanguageCodes at the given index.
   */
  public java.lang.String getSupportedLanguageCodes(int index) {
    return supportedLanguageCodes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of all languages supported by the agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the supportedLanguageCodes at the given index.
   */
  public com.google.protobuf.ByteString getSupportedLanguageCodesBytes(int index) {
    return supportedLanguageCodes_.getByteString(index);
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";
  /**
   *
   *
   * <pre>
   * Required. The time zone of the agent from the [time zone
   * database](https://www.iana.org/time-zones), e.g., America/New_York,
   * Europe/Paris.
   * </pre>
   *
   * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The time zone of the agent from the [time zone
   * database](https://www.iana.org/time-zones), e.g., America/New_York,
   * Europe/Paris.
   * </pre>
   *
   * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The description of the agent. The maximum length is 500 characters. If
   * exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the agent. The maximum length is 500 characters. If
   * exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVATAR_URI_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object avatarUri_ = "";
  /**
   *
   *
   * <pre>
   * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
   * console and in the self-hosted [Web
   * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
   * integration.
   * </pre>
   *
   * <code>string avatar_uri = 7;</code>
   *
   * @return The avatarUri.
   */
  @java.lang.Override
  public java.lang.String getAvatarUri() {
    java.lang.Object ref = avatarUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      avatarUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
   * console and in the self-hosted [Web
   * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
   * integration.
   * </pre>
   *
   * <code>string avatar_uri = 7;</code>
   *
   * @return The bytes for avatarUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAvatarUriBytes() {
    java.lang.Object ref = avatarUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      avatarUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPEECH_TO_TEXT_SETTINGS_FIELD_NUMBER = 13;
  private com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speechToTextSettings_;
  /**
   *
   *
   * <pre>
   * Speech recognition related settings.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;</code>
   *
   * @return Whether the speechToTextSettings field is set.
   */
  @java.lang.Override
  public boolean hasSpeechToTextSettings() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Speech recognition related settings.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;</code>
   *
   * @return The speechToTextSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings getSpeechToTextSettings() {
    return speechToTextSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.getDefaultInstance()
        : speechToTextSettings_;
  }
  /**
   *
   *
   * <pre>
   * Speech recognition related settings.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.SpeechToTextSettingsOrBuilder
      getSpeechToTextSettingsOrBuilder() {
    return speechToTextSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.getDefaultInstance()
        : speechToTextSettings_;
  }

  public static final int START_FLOW_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object startFlow_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Name of the start flow in this agent. A start flow will be
   * automatically created when the agent is created, and can only be deleted by
   * deleting the agent. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
   * </pre>
   *
   * <code>
   * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The startFlow.
   */
  @java.lang.Override
  public java.lang.String getStartFlow() {
    java.lang.Object ref = startFlow_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startFlow_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Name of the start flow in this agent. A start flow will be
   * automatically created when the agent is created, and can only be deleted by
   * deleting the agent. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
   * </pre>
   *
   * <code>
   * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for startFlow.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStartFlowBytes() {
    java.lang.Object ref = startFlow_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      startFlow_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECURITY_SETTINGS_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object securitySettings_ = "";
  /**
   *
   *
   * <pre>
   * Name of the
   * [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings]
   * reference for the agent. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
   * </pre>
   *
   * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The securitySettings.
   */
  @java.lang.Override
  public java.lang.String getSecuritySettings() {
    java.lang.Object ref = securitySettings_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      securitySettings_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the
   * [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings]
   * reference for the agent. Format:
   * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
   * </pre>
   *
   * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for securitySettings.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSecuritySettingsBytes() {
    java.lang.Object ref = securitySettings_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      securitySettings_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_STACKDRIVER_LOGGING_FIELD_NUMBER = 18;
  private boolean enableStackdriverLogging_ = false;
  /**
   *
   *
   * <pre>
   * Indicates if stackdriver logging is enabled for the agent.
   * Please use
   * [agent.advanced_settings][google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings]
   * instead.
   * </pre>
   *
   * <code>bool enable_stackdriver_logging = 18 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.cx.v3.Agent.enable_stackdriver_logging is deprecated. See
   *     google/cloud/dialogflow/cx/v3/agent.proto;l=368
   * @return The enableStackdriverLogging.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getEnableStackdriverLogging() {
    return enableStackdriverLogging_;
  }

  public static final int ENABLE_SPELL_CORRECTION_FIELD_NUMBER = 20;
  private boolean enableSpellCorrection_ = false;
  /**
   *
   *
   * <pre>
   * Indicates if automatic spell correction is enabled in detect intent
   * requests.
   * </pre>
   *
   * <code>bool enable_spell_correction = 20;</code>
   *
   * @return The enableSpellCorrection.
   */
  @java.lang.Override
  public boolean getEnableSpellCorrection() {
    return enableSpellCorrection_;
  }

  public static final int ENABLE_MULTI_LANGUAGE_TRAINING_FIELD_NUMBER = 40;
  private boolean enableMultiLanguageTraining_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Enable training multi-lingual models for this agent. These models
   * will be trained on all the languages supported by the agent.
   * </pre>
   *
   * <code>bool enable_multi_language_training = 40 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enableMultiLanguageTraining.
   */
  @java.lang.Override
  public boolean getEnableMultiLanguageTraining() {
    return enableMultiLanguageTraining_;
  }

  public static final int LOCKED_FIELD_NUMBER = 27;
  private boolean locked_ = false;
  /**
   *
   *
   * <pre>
   * Indicates whether the agent is locked for changes. If the agent is locked,
   * modifications to the agent will be rejected except for [RestoreAgent][].
   * </pre>
   *
   * <code>bool locked = 27;</code>
   *
   * @return The locked.
   */
  @java.lang.Override
  public boolean getLocked() {
    return locked_;
  }

  public static final int ADVANCED_SETTINGS_FIELD_NUMBER = 22;
  private com.google.cloud.dialogflow.cx.v3.AdvancedSettings advancedSettings_;
  /**
   *
   *
   * <pre>
   * Hierarchical advanced settings for this agent. The settings exposed at the
   * lower level overrides the settings exposed at the higher level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
   *
   * @return Whether the advancedSettings field is set.
   */
  @java.lang.Override
  public boolean hasAdvancedSettings() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Hierarchical advanced settings for this agent. The settings exposed at the
   * lower level overrides the settings exposed at the higher level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
   *
   * @return The advancedSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.AdvancedSettings getAdvancedSettings() {
    return advancedSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()
        : advancedSettings_;
  }
  /**
   *
   *
   * <pre>
   * Hierarchical advanced settings for this agent. The settings exposed at the
   * lower level overrides the settings exposed at the higher level.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder
      getAdvancedSettingsOrBuilder() {
    return advancedSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()
        : advancedSettings_;
  }

  public static final int GIT_INTEGRATION_SETTINGS_FIELD_NUMBER = 30;
  private com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings gitIntegrationSettings_;
  /**
   *
   *
   * <pre>
   * Git integration settings for this agent.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings git_integration_settings = 30;
   * </code>
   *
   * @return Whether the gitIntegrationSettings field is set.
   */
  @java.lang.Override
  public boolean hasGitIntegrationSettings() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Git integration settings for this agent.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings git_integration_settings = 30;
   * </code>
   *
   * @return The gitIntegrationSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
      getGitIntegrationSettings() {
    return gitIntegrationSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.getDefaultInstance()
        : gitIntegrationSettings_;
  }
  /**
   *
   *
   * <pre>
   * Git integration settings for this agent.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings git_integration_settings = 30;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettingsOrBuilder
      getGitIntegrationSettingsOrBuilder() {
    return gitIntegrationSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.getDefaultInstance()
        : gitIntegrationSettings_;
  }

  public static final int TEXT_TO_SPEECH_SETTINGS_FIELD_NUMBER = 31;
  private com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings textToSpeechSettings_;
  /**
   *
   *
   * <pre>
   * Settings on instructing the speech synthesizer on how to generate the
   * output audio content.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.TextToSpeechSettings text_to_speech_settings = 31;</code>
   *
   * @return Whether the textToSpeechSettings field is set.
   */
  @java.lang.Override
  public boolean hasTextToSpeechSettings() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Settings on instructing the speech synthesizer on how to generate the
   * output audio content.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.TextToSpeechSettings text_to_speech_settings = 31;</code>
   *
   * @return The textToSpeechSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings getTextToSpeechSettings() {
    return textToSpeechSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings.getDefaultInstance()
        : textToSpeechSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings on instructing the speech synthesizer on how to generate the
   * output audio content.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3.TextToSpeechSettings text_to_speech_settings = 31;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.TextToSpeechSettingsOrBuilder
      getTextToSpeechSettingsOrBuilder() {
    return textToSpeechSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings.getDefaultInstance()
        : textToSpeechSettings_;
  }

  public static final int GEN_APP_BUILDER_SETTINGS_FIELD_NUMBER = 33;
  private com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings genAppBuilderSettings_;
  /**
   *
   *
   * <pre>
   * Gen App Builder-related agent-level settings.
   * </pre>
   *
   * <code>
   * optional .google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings gen_app_builder_settings = 33;
   * </code>
   *
   * @return Whether the genAppBuilderSettings field is set.
   */
  @java.lang.Override
  public boolean hasGenAppBuilderSettings() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Gen App Builder-related agent-level settings.
   * </pre>
   *
   * <code>
   * optional .google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings gen_app_builder_settings = 33;
   * </code>
   *
   * @return The genAppBuilderSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings getGenAppBuilderSettings() {
    return genAppBuilderSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.getDefaultInstance()
        : genAppBuilderSettings_;
  }
  /**
   *
   *
   * <pre>
   * Gen App Builder-related agent-level settings.
   * </pre>
   *
   * <code>
   * optional .google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings gen_app_builder_settings = 33;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettingsOrBuilder
      getGenAppBuilderSettingsOrBuilder() {
    return genAppBuilderSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.getDefaultInstance()
        : genAppBuilderSettings_;
  }

  public static final int ANSWER_FEEDBACK_SETTINGS_FIELD_NUMBER = 38;
  private com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answerFeedbackSettings_;
  /**
   *
   *
   * <pre>
   * Optional. Answer feedback collection settings.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answer_feedback_settings = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the answerFeedbackSettings field is set.
   */
  @java.lang.Override
  public boolean hasAnswerFeedbackSettings() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Answer feedback collection settings.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answer_feedback_settings = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The answerFeedbackSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings
      getAnswerFeedbackSettings() {
    return answerFeedbackSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.getDefaultInstance()
        : answerFeedbackSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Answer feedback collection settings.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answer_feedback_settings = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettingsOrBuilder
      getAnswerFeedbackSettingsOrBuilder() {
    return answerFeedbackSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.getDefaultInstance()
        : answerFeedbackSettings_;
  }

  public static final int PERSONALIZATION_SETTINGS_FIELD_NUMBER = 42;
  private com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalizationSettings_;
  /**
   *
   *
   * <pre>
   * Optional. Settings for end user personalization.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalization_settings = 42 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the personalizationSettings field is set.
   */
  @java.lang.Override
  public boolean hasPersonalizationSettings() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Settings for end user personalization.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalization_settings = 42 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The personalizationSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings
      getPersonalizationSettings() {
    return personalizationSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.getDefaultInstance()
        : personalizationSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Settings for end user personalization.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalization_settings = 42 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettingsOrBuilder
      getPersonalizationSettingsOrBuilder() {
    return personalizationSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.getDefaultInstance()
        : personalizationSettings_;
  }

  public static final int CLIENT_CERTIFICATE_SETTINGS_FIELD_NUMBER = 43;
  private com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
      clientCertificateSettings_;
  /**
   *
   *
   * <pre>
   * Optional. Settings for custom client certificates.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings client_certificate_settings = 43 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the clientCertificateSettings field is set.
   */
  @java.lang.Override
  public boolean hasClientCertificateSettings() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Settings for custom client certificates.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings client_certificate_settings = 43 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The clientCertificateSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
      getClientCertificateSettings() {
    return clientCertificateSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.getDefaultInstance()
        : clientCertificateSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Settings for custom client certificates.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings client_certificate_settings = 43 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettingsOrBuilder
      getClientCertificateSettingsOrBuilder() {
    return clientCertificateSettings_ == null
        ? com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.getDefaultInstance()
        : clientCertificateSettings_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 45;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Output only. A read only boolean field reflecting Zone Separation
   * status of the agent.
   * </pre>
   *
   * <code>
   * optional bool satisfies_pzs = 45 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzs() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Output only. A read only boolean field reflecting Zone Separation
   * status of the agent.
   * </pre>
   *
   * <code>
   * optional bool satisfies_pzs = 45 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 46;
  private boolean satisfiesPzi_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Output only. A read only boolean field reflecting Zone Isolation
   * status of the agent.
   * </pre>
   *
   * <code>
   * optional bool satisfies_pzi = 46 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the satisfiesPzi field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzi() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Output only. A read only boolean field reflecting Zone Isolation
   * status of the agent.
   * </pre>
   *
   * <code>
   * optional bool satisfies_pzi = 46 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLanguageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, defaultLanguageCode_);
    }
    for (int i = 0; i < supportedLanguageCodes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 4, supportedLanguageCodes_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, timeZone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(avatarUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, avatarUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(13, getSpeechToTextSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startFlow_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, startFlow_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(securitySettings_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, securitySettings_);
    }
    if (enableStackdriverLogging_ != false) {
      output.writeBool(18, enableStackdriverLogging_);
    }
    if (enableSpellCorrection_ != false) {
      output.writeBool(20, enableSpellCorrection_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(22, getAdvancedSettings());
    }
    if (locked_ != false) {
      output.writeBool(27, locked_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(30, getGitIntegrationSettings());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(31, getTextToSpeechSettings());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(33, getGenAppBuilderSettings());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(38, getAnswerFeedbackSettings());
    }
    if (enableMultiLanguageTraining_ != false) {
      output.writeBool(40, enableMultiLanguageTraining_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(42, getPersonalizationSettings());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(43, getClientCertificateSettings());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeBool(45, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeBool(46, satisfiesPzi_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLanguageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, defaultLanguageCode_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedLanguageCodes_.size(); i++) {
        dataSize += computeStringSizeNoTag(supportedLanguageCodes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSupportedLanguageCodesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, timeZone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(avatarUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, avatarUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, getSpeechToTextSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startFlow_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, startFlow_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(securitySettings_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, securitySettings_);
    }
    if (enableStackdriverLogging_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(18, enableStackdriverLogging_);
    }
    if (enableSpellCorrection_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(20, enableSpellCorrection_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getAdvancedSettings());
    }
    if (locked_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(27, locked_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(30, getGitIntegrationSettings());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(31, getTextToSpeechSettings());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(33, getGenAppBuilderSettings());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(38, getAnswerFeedbackSettings());
    }
    if (enableMultiLanguageTraining_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(40, enableMultiLanguageTraining_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              42, getPersonalizationSettings());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              43, getClientCertificateSettings());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(45, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(46, satisfiesPzi_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3.Agent)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3.Agent other = (com.google.cloud.dialogflow.cx.v3.Agent) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDefaultLanguageCode().equals(other.getDefaultLanguageCode())) return false;
    if (!getSupportedLanguageCodesList().equals(other.getSupportedLanguageCodesList()))
      return false;
    if (!getTimeZone().equals(other.getTimeZone())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getAvatarUri().equals(other.getAvatarUri())) return false;
    if (hasSpeechToTextSettings() != other.hasSpeechToTextSettings()) return false;
    if (hasSpeechToTextSettings()) {
      if (!getSpeechToTextSettings().equals(other.getSpeechToTextSettings())) return false;
    }
    if (!getStartFlow().equals(other.getStartFlow())) return false;
    if (!getSecuritySettings().equals(other.getSecuritySettings())) return false;
    if (getEnableStackdriverLogging() != other.getEnableStackdriverLogging()) return false;
    if (getEnableSpellCorrection() != other.getEnableSpellCorrection()) return false;
    if (getEnableMultiLanguageTraining() != other.getEnableMultiLanguageTraining()) return false;
    if (getLocked() != other.getLocked()) return false;
    if (hasAdvancedSettings() != other.hasAdvancedSettings()) return false;
    if (hasAdvancedSettings()) {
      if (!getAdvancedSettings().equals(other.getAdvancedSettings())) return false;
    }
    if (hasGitIntegrationSettings() != other.hasGitIntegrationSettings()) return false;
    if (hasGitIntegrationSettings()) {
      if (!getGitIntegrationSettings().equals(other.getGitIntegrationSettings())) return false;
    }
    if (hasTextToSpeechSettings() != other.hasTextToSpeechSettings()) return false;
    if (hasTextToSpeechSettings()) {
      if (!getTextToSpeechSettings().equals(other.getTextToSpeechSettings())) return false;
    }
    if (hasGenAppBuilderSettings() != other.hasGenAppBuilderSettings()) return false;
    if (hasGenAppBuilderSettings()) {
      if (!getGenAppBuilderSettings().equals(other.getGenAppBuilderSettings())) return false;
    }
    if (hasAnswerFeedbackSettings() != other.hasAnswerFeedbackSettings()) return false;
    if (hasAnswerFeedbackSettings()) {
      if (!getAnswerFeedbackSettings().equals(other.getAnswerFeedbackSettings())) return false;
    }
    if (hasPersonalizationSettings() != other.hasPersonalizationSettings()) return false;
    if (hasPersonalizationSettings()) {
      if (!getPersonalizationSettings().equals(other.getPersonalizationSettings())) return false;
    }
    if (hasClientCertificateSettings() != other.hasClientCertificateSettings()) return false;
    if (hasClientCertificateSettings()) {
      if (!getClientCertificateSettings().equals(other.getClientCertificateSettings()))
        return false;
    }
    if (hasSatisfiesPzs() != other.hasSatisfiesPzs()) return false;
    if (hasSatisfiesPzs()) {
      if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    }
    if (hasSatisfiesPzi() != other.hasSatisfiesPzi()) return false;
    if (hasSatisfiesPzi()) {
      if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DEFAULT_LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultLanguageCode().hashCode();
    if (getSupportedLanguageCodesCount() > 0) {
      hash = (37 * hash) + SUPPORTED_LANGUAGE_CODES_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedLanguageCodesList().hashCode();
    }
    hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimeZone().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + AVATAR_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAvatarUri().hashCode();
    if (hasSpeechToTextSettings()) {
      hash = (37 * hash) + SPEECH_TO_TEXT_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechToTextSettings().hashCode();
    }
    hash = (37 * hash) + START_FLOW_FIELD_NUMBER;
    hash = (53 * hash) + getStartFlow().hashCode();
    hash = (37 * hash) + SECURITY_SETTINGS_FIELD_NUMBER;
    hash = (53 * hash) + getSecuritySettings().hashCode();
    hash = (37 * hash) + ENABLE_STACKDRIVER_LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableStackdriverLogging());
    hash = (37 * hash) + ENABLE_SPELL_CORRECTION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableSpellCorrection());
    hash = (37 * hash) + ENABLE_MULTI_LANGUAGE_TRAINING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableMultiLanguageTraining());
    hash = (37 * hash) + LOCKED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getLocked());
    if (hasAdvancedSettings()) {
      hash = (37 * hash) + ADVANCED_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getAdvancedSettings().hashCode();
    }
    if (hasGitIntegrationSettings()) {
      hash = (37 * hash) + GIT_INTEGRATION_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getGitIntegrationSettings().hashCode();
    }
    if (hasTextToSpeechSettings()) {
      hash = (37 * hash) + TEXT_TO_SPEECH_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getTextToSpeechSettings().hashCode();
    }
    if (hasGenAppBuilderSettings()) {
      hash = (37 * hash) + GEN_APP_BUILDER_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getGenAppBuilderSettings().hashCode();
    }
    if (hasAnswerFeedbackSettings()) {
      hash = (37 * hash) + ANSWER_FEEDBACK_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerFeedbackSettings().hashCode();
    }
    if (hasPersonalizationSettings()) {
      hash = (37 * hash) + PERSONALIZATION_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getPersonalizationSettings().hashCode();
    }
    if (hasClientCertificateSettings()) {
      hash = (37 * hash) + CLIENT_CERTIFICATE_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getClientCertificateSettings().hashCode();
    }
    if (hasSatisfiesPzs()) {
      hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    }
    if (hasSatisfiesPzi()) {
      hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3.Agent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Agents are best described as Natural Language Understanding (NLU) modules
   * that transform user requests into actionable data. You can include agents
   * in your app, product, or service to determine user intent and respond to the
   * user in a natural way.
   *
   * After you create an agent, you can add
   * [Intents][google.cloud.dialogflow.cx.v3.Intent], [Entity
   * Types][google.cloud.dialogflow.cx.v3.EntityType],
   * [Flows][google.cloud.dialogflow.cx.v3.Flow],
   * [Fulfillments][google.cloud.dialogflow.cx.v3.Fulfillment],
   * [Webhooks][google.cloud.dialogflow.cx.v3.Webhook],
   * [TransitionRouteGroups][google.cloud.dialogflow.cx.v3.TransitionRouteGroup]
   * and so on to manage the conversation flows.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3.Agent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3.Agent)
      com.google.cloud.dialogflow.cx.v3.AgentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3.Agent.class,
              com.google.cloud.dialogflow.cx.v3.Agent.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3.Agent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSpeechToTextSettingsFieldBuilder();
        getAdvancedSettingsFieldBuilder();
        getGitIntegrationSettingsFieldBuilder();
        getTextToSpeechSettingsFieldBuilder();
        getGenAppBuilderSettingsFieldBuilder();
        getAnswerFeedbackSettingsFieldBuilder();
        getPersonalizationSettingsFieldBuilder();
        getClientCertificateSettingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      defaultLanguageCode_ = "";
      supportedLanguageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      timeZone_ = "";
      description_ = "";
      avatarUri_ = "";
      speechToTextSettings_ = null;
      if (speechToTextSettingsBuilder_ != null) {
        speechToTextSettingsBuilder_.dispose();
        speechToTextSettingsBuilder_ = null;
      }
      startFlow_ = "";
      securitySettings_ = "";
      enableStackdriverLogging_ = false;
      enableSpellCorrection_ = false;
      enableMultiLanguageTraining_ = false;
      locked_ = false;
      advancedSettings_ = null;
      if (advancedSettingsBuilder_ != null) {
        advancedSettingsBuilder_.dispose();
        advancedSettingsBuilder_ = null;
      }
      gitIntegrationSettings_ = null;
      if (gitIntegrationSettingsBuilder_ != null) {
        gitIntegrationSettingsBuilder_.dispose();
        gitIntegrationSettingsBuilder_ = null;
      }
      textToSpeechSettings_ = null;
      if (textToSpeechSettingsBuilder_ != null) {
        textToSpeechSettingsBuilder_.dispose();
        textToSpeechSettingsBuilder_ = null;
      }
      genAppBuilderSettings_ = null;
      if (genAppBuilderSettingsBuilder_ != null) {
        genAppBuilderSettingsBuilder_.dispose();
        genAppBuilderSettingsBuilder_ = null;
      }
      answerFeedbackSettings_ = null;
      if (answerFeedbackSettingsBuilder_ != null) {
        answerFeedbackSettingsBuilder_.dispose();
        answerFeedbackSettingsBuilder_ = null;
      }
      personalizationSettings_ = null;
      if (personalizationSettingsBuilder_ != null) {
        personalizationSettingsBuilder_.dispose();
        personalizationSettingsBuilder_ = null;
      }
      clientCertificateSettings_ = null;
      if (clientCertificateSettingsBuilder_ != null) {
        clientCertificateSettingsBuilder_.dispose();
        clientCertificateSettingsBuilder_ = null;
      }
      satisfiesPzs_ = false;
      satisfiesPzi_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3.AgentProto
          .internal_static_google_cloud_dialogflow_cx_v3_Agent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3.Agent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent build() {
      com.google.cloud.dialogflow.cx.v3.Agent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3.Agent buildPartial() {
      com.google.cloud.dialogflow.cx.v3.Agent result =
          new com.google.cloud.dialogflow.cx.v3.Agent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3.Agent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.defaultLanguageCode_ = defaultLanguageCode_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        supportedLanguageCodes_.makeImmutable();
        result.supportedLanguageCodes_ = supportedLanguageCodes_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.timeZone_ = timeZone_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.avatarUri_ = avatarUri_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.speechToTextSettings_ =
            speechToTextSettingsBuilder_ == null
                ? speechToTextSettings_
                : speechToTextSettingsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.startFlow_ = startFlow_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.securitySettings_ = securitySettings_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.enableStackdriverLogging_ = enableStackdriverLogging_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.enableSpellCorrection_ = enableSpellCorrection_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.enableMultiLanguageTraining_ = enableMultiLanguageTraining_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.locked_ = locked_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.advancedSettings_ =
            advancedSettingsBuilder_ == null ? advancedSettings_ : advancedSettingsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.gitIntegrationSettings_ =
            gitIntegrationSettingsBuilder_ == null
                ? gitIntegrationSettings_
                : gitIntegrationSettingsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.textToSpeechSettings_ =
            textToSpeechSettingsBuilder_ == null
                ? textToSpeechSettings_
                : textToSpeechSettingsBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.genAppBuilderSettings_ =
            genAppBuilderSettingsBuilder_ == null
                ? genAppBuilderSettings_
                : genAppBuilderSettingsBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.answerFeedbackSettings_ =
            answerFeedbackSettingsBuilder_ == null
                ? answerFeedbackSettings_
                : answerFeedbackSettingsBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.personalizationSettings_ =
            personalizationSettingsBuilder_ == null
                ? personalizationSettings_
                : personalizationSettingsBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.clientCertificateSettings_ =
            clientCertificateSettingsBuilder_ == null
                ? clientCertificateSettings_
                : clientCertificateSettingsBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
        to_bitField0_ |= 0x00000200;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3.Agent) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3.Agent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3.Agent other) {
      if (other == com.google.cloud.dialogflow.cx.v3.Agent.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDefaultLanguageCode().isEmpty()) {
        defaultLanguageCode_ = other.defaultLanguageCode_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.supportedLanguageCodes_.isEmpty()) {
        if (supportedLanguageCodes_.isEmpty()) {
          supportedLanguageCodes_ = other.supportedLanguageCodes_;
          bitField0_ |= 0x00000008;
        } else {
          ensureSupportedLanguageCodesIsMutable();
          supportedLanguageCodes_.addAll(other.supportedLanguageCodes_);
        }
        onChanged();
      }
      if (!other.getTimeZone().isEmpty()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getAvatarUri().isEmpty()) {
        avatarUri_ = other.avatarUri_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasSpeechToTextSettings()) {
        mergeSpeechToTextSettings(other.getSpeechToTextSettings());
      }
      if (!other.getStartFlow().isEmpty()) {
        startFlow_ = other.startFlow_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getSecuritySettings().isEmpty()) {
        securitySettings_ = other.securitySettings_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.getEnableStackdriverLogging() != false) {
        setEnableStackdriverLogging(other.getEnableStackdriverLogging());
      }
      if (other.getEnableSpellCorrection() != false) {
        setEnableSpellCorrection(other.getEnableSpellCorrection());
      }
      if (other.getEnableMultiLanguageTraining() != false) {
        setEnableMultiLanguageTraining(other.getEnableMultiLanguageTraining());
      }
      if (other.getLocked() != false) {
        setLocked(other.getLocked());
      }
      if (other.hasAdvancedSettings()) {
        mergeAdvancedSettings(other.getAdvancedSettings());
      }
      if (other.hasGitIntegrationSettings()) {
        mergeGitIntegrationSettings(other.getGitIntegrationSettings());
      }
      if (other.hasTextToSpeechSettings()) {
        mergeTextToSpeechSettings(other.getTextToSpeechSettings());
      }
      if (other.hasGenAppBuilderSettings()) {
        mergeGenAppBuilderSettings(other.getGenAppBuilderSettings());
      }
      if (other.hasAnswerFeedbackSettings()) {
        mergeAnswerFeedbackSettings(other.getAnswerFeedbackSettings());
      }
      if (other.hasPersonalizationSettings()) {
        mergePersonalizationSettings(other.getPersonalizationSettings());
      }
      if (other.hasClientCertificateSettings()) {
        mergeClientCertificateSettings(other.getClientCertificateSettings());
      }
      if (other.hasSatisfiesPzs()) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.hasSatisfiesPzi()) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                defaultLanguageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSupportedLanguageCodesIsMutable();
                supportedLanguageCodes_.add(s);
                break;
              } // case 34
            case 42:
              {
                timeZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                avatarUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 106:
              {
                input.readMessage(
                    getSpeechToTextSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 106
            case 130:
              {
                startFlow_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 130
            case 138:
              {
                securitySettings_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 138
            case 144:
              {
                enableStackdriverLogging_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 144
            case 160:
              {
                enableSpellCorrection_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 160
            case 178:
              {
                input.readMessage(
                    getAdvancedSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 178
            case 216:
              {
                locked_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 216
            case 242:
              {
                input.readMessage(
                    getGitIntegrationSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 242
            case 250:
              {
                input.readMessage(
                    getTextToSpeechSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 250
            case 266:
              {
                input.readMessage(
                    getGenAppBuilderSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 266
            case 306:
              {
                input.readMessage(
                    getAnswerFeedbackSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 306
            case 320:
              {
                enableMultiLanguageTraining_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 320
            case 338:
              {
                input.readMessage(
                    getPersonalizationSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 338
            case 346:
              {
                input.readMessage(
                    getClientCertificateSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 346
            case 360:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00200000;
                break;
              } // case 360
            case 368:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00400000;
                break;
              } // case 368
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the agent.
     * Required for the
     * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
     * method.
     * [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
     * populates the name automatically.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the agent.
     * Required for the
     * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
     * method.
     * [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
     * populates the name automatically.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the agent.
     * Required for the
     * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
     * method.
     * [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
     * populates the name automatically.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the agent.
     * Required for the
     * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
     * method.
     * [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
     * populates the name automatically.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the agent.
     * Required for the
     * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
     * method.
     * [Agents.CreateAgent][google.cloud.dialogflow.cx.v3.Agents.CreateAgent]
     * populates the name automatically.
     * Format: `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the agent, unique within the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the agent, unique within the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the agent, unique within the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the agent, unique within the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the agent, unique within the location.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object defaultLanguageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * This field cannot be set by the
     * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
     * method.
     * </pre>
     *
     * <code>
     * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The defaultLanguageCode.
     */
    public java.lang.String getDefaultLanguageCode() {
      java.lang.Object ref = defaultLanguageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultLanguageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * This field cannot be set by the
     * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
     * method.
     * </pre>
     *
     * <code>
     * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for defaultLanguageCode.
     */
    public com.google.protobuf.ByteString getDefaultLanguageCodeBytes() {
      java.lang.Object ref = defaultLanguageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * This field cannot be set by the
     * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
     * method.
     * </pre>
     *
     * <code>
     * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The defaultLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultLanguageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * This field cannot be set by the
     * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
     * method.
     * </pre>
     *
     * <code>
     * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultLanguageCode() {
      defaultLanguageCode_ = getDefaultInstance().getDefaultLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The default language of the agent as a language tag.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     * This field cannot be set by the
     * [Agents.UpdateAgent][google.cloud.dialogflow.cx.v3.Agents.UpdateAgent]
     * method.
     * </pre>
     *
     * <code>
     * string default_language_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for defaultLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultLanguageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList supportedLanguageCodes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSupportedLanguageCodesIsMutable() {
      if (!supportedLanguageCodes_.isModifiable()) {
        supportedLanguageCodes_ =
            new com.google.protobuf.LazyStringArrayList(supportedLanguageCodes_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @return A list containing the supportedLanguageCodes.
     */
    public com.google.protobuf.ProtocolStringList getSupportedLanguageCodesList() {
      supportedLanguageCodes_.makeImmutable();
      return supportedLanguageCodes_;
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @return The count of supportedLanguageCodes.
     */
    public int getSupportedLanguageCodesCount() {
      return supportedLanguageCodes_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The supportedLanguageCodes at the given index.
     */
    public java.lang.String getSupportedLanguageCodes(int index) {
      return supportedLanguageCodes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the supportedLanguageCodes at the given index.
     */
    public com.google.protobuf.ByteString getSupportedLanguageCodesBytes(int index) {
      return supportedLanguageCodes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The supportedLanguageCodes to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedLanguageCodes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedLanguageCodesIsMutable();
      supportedLanguageCodes_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param value The supportedLanguageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedLanguageCodes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedLanguageCodesIsMutable();
      supportedLanguageCodes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param values The supportedLanguageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedLanguageCodes(java.lang.Iterable<java.lang.String> values) {
      ensureSupportedLanguageCodesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, supportedLanguageCodes_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportedLanguageCodes() {
      supportedLanguageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of all languages supported by the agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param value The bytes of the supportedLanguageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedLanguageCodesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSupportedLanguageCodesIsMutable();
      supportedLanguageCodes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";
    /**
     *
     *
     * <pre>
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeZone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of the agent from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the agent. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the agent. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the agent. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the agent. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the agent. The maximum length is 500 characters. If
     * exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object avatarUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
     * console and in the self-hosted [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @return The avatarUri.
     */
    public java.lang.String getAvatarUri() {
      java.lang.Object ref = avatarUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        avatarUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
     * console and in the self-hosted [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @return The bytes for avatarUri.
     */
    public com.google.protobuf.ByteString getAvatarUriBytes() {
      java.lang.Object ref = avatarUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        avatarUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
     * console and in the self-hosted [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @param value The avatarUri to set.
     * @return This builder for chaining.
     */
    public Builder setAvatarUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      avatarUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
     * console and in the self-hosted [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvatarUri() {
      avatarUri_ = getDefaultInstance().getAvatarUri();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the agent's avatar. Avatars are used throughout the Dialogflow
     * console and in the self-hosted [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @param value The bytes for avatarUri to set.
     * @return This builder for chaining.
     */
    public Builder setAvatarUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      avatarUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speechToTextSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings,
            com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.SpeechToTextSettingsOrBuilder>
        speechToTextSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     *
     * @return Whether the speechToTextSettings field is set.
     */
    public boolean hasSpeechToTextSettings() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     *
     * @return The speechToTextSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings getSpeechToTextSettings() {
      if (speechToTextSettingsBuilder_ == null) {
        return speechToTextSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.getDefaultInstance()
            : speechToTextSettings_;
      } else {
        return speechToTextSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    public Builder setSpeechToTextSettings(
        com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings value) {
      if (speechToTextSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        speechToTextSettings_ = value;
      } else {
        speechToTextSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    public Builder setSpeechToTextSettings(
        com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.Builder builderForValue) {
      if (speechToTextSettingsBuilder_ == null) {
        speechToTextSettings_ = builderForValue.build();
      } else {
        speechToTextSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    public Builder mergeSpeechToTextSettings(
        com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings value) {
      if (speechToTextSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && speechToTextSettings_ != null
            && speechToTextSettings_
                != com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.getDefaultInstance()) {
          getSpeechToTextSettingsBuilder().mergeFrom(value);
        } else {
          speechToTextSettings_ = value;
        }
      } else {
        speechToTextSettingsBuilder_.mergeFrom(value);
      }
      if (speechToTextSettings_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    public Builder clearSpeechToTextSettings() {
      bitField0_ = (bitField0_ & ~0x00000080);
      speechToTextSettings_ = null;
      if (speechToTextSettingsBuilder_ != null) {
        speechToTextSettingsBuilder_.dispose();
        speechToTextSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.Builder
        getSpeechToTextSettingsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getSpeechToTextSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.SpeechToTextSettingsOrBuilder
        getSpeechToTextSettingsOrBuilder() {
      if (speechToTextSettingsBuilder_ != null) {
        return speechToTextSettingsBuilder_.getMessageOrBuilder();
      } else {
        return speechToTextSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.getDefaultInstance()
            : speechToTextSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Speech recognition related settings.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.SpeechToTextSettings speech_to_text_settings = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings,
            com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.SpeechToTextSettingsOrBuilder>
        getSpeechToTextSettingsFieldBuilder() {
      if (speechToTextSettingsBuilder_ == null) {
        speechToTextSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings,
                com.google.cloud.dialogflow.cx.v3.SpeechToTextSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.SpeechToTextSettingsOrBuilder>(
                getSpeechToTextSettings(), getParentForChildren(), isClean());
        speechToTextSettings_ = null;
      }
      return speechToTextSettingsBuilder_;
    }

    private java.lang.Object startFlow_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Name of the start flow in this agent. A start flow will be
     * automatically created when the agent is created, and can only be deleted by
     * deleting the agent. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>
     * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The startFlow.
     */
    public java.lang.String getStartFlow() {
      java.lang.Object ref = startFlow_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startFlow_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the start flow in this agent. A start flow will be
     * automatically created when the agent is created, and can only be deleted by
     * deleting the agent. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>
     * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for startFlow.
     */
    public com.google.protobuf.ByteString getStartFlowBytes() {
      java.lang.Object ref = startFlow_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        startFlow_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the start flow in this agent. A start flow will be
     * automatically created when the agent is created, and can only be deleted by
     * deleting the agent. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>
     * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The startFlow to set.
     * @return This builder for chaining.
     */
    public Builder setStartFlow(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      startFlow_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the start flow in this agent. A start flow will be
     * automatically created when the agent is created, and can only be deleted by
     * deleting the agent. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>
     * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartFlow() {
      startFlow_ = getDefaultInstance().getStartFlow();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Name of the start flow in this agent. A start flow will be
     * automatically created when the agent is created, and can only be deleted by
     * deleting the agent. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/agents/&lt;AgentID&gt;/flows/&lt;FlowID&gt;`.
     * </pre>
     *
     * <code>
     * string start_flow = 16 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for startFlow to set.
     * @return This builder for chaining.
     */
    public Builder setStartFlowBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      startFlow_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object securitySettings_ = "";
    /**
     *
     *
     * <pre>
     * Name of the
     * [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings]
     * reference for the agent. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
     * </pre>
     *
     * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The securitySettings.
     */
    public java.lang.String getSecuritySettings() {
      java.lang.Object ref = securitySettings_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        securitySettings_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the
     * [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings]
     * reference for the agent. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
     * </pre>
     *
     * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for securitySettings.
     */
    public com.google.protobuf.ByteString getSecuritySettingsBytes() {
      java.lang.Object ref = securitySettings_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        securitySettings_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the
     * [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings]
     * reference for the agent. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
     * </pre>
     *
     * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The securitySettings to set.
     * @return This builder for chaining.
     */
    public Builder setSecuritySettings(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      securitySettings_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the
     * [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings]
     * reference for the agent. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
     * </pre>
     *
     * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecuritySettings() {
      securitySettings_ = getDefaultInstance().getSecuritySettings();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the
     * [SecuritySettings][google.cloud.dialogflow.cx.v3.SecuritySettings]
     * reference for the agent. Format:
     * `projects/&lt;ProjectID&gt;/locations/&lt;LocationID&gt;/securitySettings/&lt;SecuritySettingsID&gt;`.
     * </pre>
     *
     * <code>string security_settings = 17 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for securitySettings to set.
     * @return This builder for chaining.
     */
    public Builder setSecuritySettingsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      securitySettings_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private boolean enableStackdriverLogging_;
    /**
     *
     *
     * <pre>
     * Indicates if stackdriver logging is enabled for the agent.
     * Please use
     * [agent.advanced_settings][google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings]
     * instead.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 18 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Agent.enable_stackdriver_logging is deprecated. See
     *     google/cloud/dialogflow/cx/v3/agent.proto;l=368
     * @return The enableStackdriverLogging.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getEnableStackdriverLogging() {
      return enableStackdriverLogging_;
    }
    /**
     *
     *
     * <pre>
     * Indicates if stackdriver logging is enabled for the agent.
     * Please use
     * [agent.advanced_settings][google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings]
     * instead.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 18 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Agent.enable_stackdriver_logging is deprecated. See
     *     google/cloud/dialogflow/cx/v3/agent.proto;l=368
     * @param value The enableStackdriverLogging to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setEnableStackdriverLogging(boolean value) {

      enableStackdriverLogging_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates if stackdriver logging is enabled for the agent.
     * Please use
     * [agent.advanced_settings][google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings]
     * instead.
     * </pre>
     *
     * <code>bool enable_stackdriver_logging = 18 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3.Agent.enable_stackdriver_logging is deprecated. See
     *     google/cloud/dialogflow/cx/v3/agent.proto;l=368
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearEnableStackdriverLogging() {
      bitField0_ = (bitField0_ & ~0x00000400);
      enableStackdriverLogging_ = false;
      onChanged();
      return this;
    }

    private boolean enableSpellCorrection_;
    /**
     *
     *
     * <pre>
     * Indicates if automatic spell correction is enabled in detect intent
     * requests.
     * </pre>
     *
     * <code>bool enable_spell_correction = 20;</code>
     *
     * @return The enableSpellCorrection.
     */
    @java.lang.Override
    public boolean getEnableSpellCorrection() {
      return enableSpellCorrection_;
    }
    /**
     *
     *
     * <pre>
     * Indicates if automatic spell correction is enabled in detect intent
     * requests.
     * </pre>
     *
     * <code>bool enable_spell_correction = 20;</code>
     *
     * @param value The enableSpellCorrection to set.
     * @return This builder for chaining.
     */
    public Builder setEnableSpellCorrection(boolean value) {

      enableSpellCorrection_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates if automatic spell correction is enabled in detect intent
     * requests.
     * </pre>
     *
     * <code>bool enable_spell_correction = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableSpellCorrection() {
      bitField0_ = (bitField0_ & ~0x00000800);
      enableSpellCorrection_ = false;
      onChanged();
      return this;
    }

    private boolean enableMultiLanguageTraining_;
    /**
     *
     *
     * <pre>
     * Optional. Enable training multi-lingual models for this agent. These models
     * will be trained on all the languages supported by the agent.
     * </pre>
     *
     * <code>bool enable_multi_language_training = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enableMultiLanguageTraining.
     */
    @java.lang.Override
    public boolean getEnableMultiLanguageTraining() {
      return enableMultiLanguageTraining_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Enable training multi-lingual models for this agent. These models
     * will be trained on all the languages supported by the agent.
     * </pre>
     *
     * <code>bool enable_multi_language_training = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enableMultiLanguageTraining to set.
     * @return This builder for chaining.
     */
    public Builder setEnableMultiLanguageTraining(boolean value) {

      enableMultiLanguageTraining_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Enable training multi-lingual models for this agent. These models
     * will be trained on all the languages supported by the agent.
     * </pre>
     *
     * <code>bool enable_multi_language_training = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableMultiLanguageTraining() {
      bitField0_ = (bitField0_ & ~0x00001000);
      enableMultiLanguageTraining_ = false;
      onChanged();
      return this;
    }

    private boolean locked_;
    /**
     *
     *
     * <pre>
     * Indicates whether the agent is locked for changes. If the agent is locked,
     * modifications to the agent will be rejected except for [RestoreAgent][].
     * </pre>
     *
     * <code>bool locked = 27;</code>
     *
     * @return The locked.
     */
    @java.lang.Override
    public boolean getLocked() {
      return locked_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the agent is locked for changes. If the agent is locked,
     * modifications to the agent will be rejected except for [RestoreAgent][].
     * </pre>
     *
     * <code>bool locked = 27;</code>
     *
     * @param value The locked to set.
     * @return This builder for chaining.
     */
    public Builder setLocked(boolean value) {

      locked_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the agent is locked for changes. If the agent is locked,
     * modifications to the agent will be rejected except for [RestoreAgent][].
     * </pre>
     *
     * <code>bool locked = 27;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocked() {
      bitField0_ = (bitField0_ & ~0x00002000);
      locked_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.cx.v3.AdvancedSettings advancedSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder>
        advancedSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     *
     * @return Whether the advancedSettings field is set.
     */
    public boolean hasAdvancedSettings() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     *
     * @return The advancedSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings getAdvancedSettings() {
      if (advancedSettingsBuilder_ == null) {
        return advancedSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()
            : advancedSettings_;
      } else {
        return advancedSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    public Builder setAdvancedSettings(com.google.cloud.dialogflow.cx.v3.AdvancedSettings value) {
      if (advancedSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        advancedSettings_ = value;
      } else {
        advancedSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    public Builder setAdvancedSettings(
        com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder builderForValue) {
      if (advancedSettingsBuilder_ == null) {
        advancedSettings_ = builderForValue.build();
      } else {
        advancedSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    public Builder mergeAdvancedSettings(com.google.cloud.dialogflow.cx.v3.AdvancedSettings value) {
      if (advancedSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && advancedSettings_ != null
            && advancedSettings_
                != com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()) {
          getAdvancedSettingsBuilder().mergeFrom(value);
        } else {
          advancedSettings_ = value;
        }
      } else {
        advancedSettingsBuilder_.mergeFrom(value);
      }
      if (advancedSettings_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    public Builder clearAdvancedSettings() {
      bitField0_ = (bitField0_ & ~0x00004000);
      advancedSettings_ = null;
      if (advancedSettingsBuilder_ != null) {
        advancedSettingsBuilder_.dispose();
        advancedSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder getAdvancedSettingsBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getAdvancedSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    public com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder
        getAdvancedSettingsOrBuilder() {
      if (advancedSettingsBuilder_ != null) {
        return advancedSettingsBuilder_.getMessageOrBuilder();
      } else {
        return advancedSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.AdvancedSettings.getDefaultInstance()
            : advancedSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Hierarchical advanced settings for this agent. The settings exposed at the
     * lower level overrides the settings exposed at the higher level.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder>
        getAdvancedSettingsFieldBuilder() {
      if (advancedSettingsBuilder_ == null) {
        advancedSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.AdvancedSettings,
                com.google.cloud.dialogflow.cx.v3.AdvancedSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.AdvancedSettingsOrBuilder>(
                getAdvancedSettings(), getParentForChildren(), isClean());
        advancedSettings_ = null;
      }
      return advancedSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings gitIntegrationSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings,
            com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettingsOrBuilder>
        gitIntegrationSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Git integration settings for this agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings git_integration_settings = 30;
     * </code>
     *
     * @return Whether the gitIntegrationSettings field is set.
     */
    public boolean hasGitIntegrationSettings() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Git integration settings for this agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings git_integration_settings = 30;
     * </code>
     *
     * @return The gitIntegrationSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
        getGitIntegrationSettings() {
      if (gitIntegrationSettingsBuilder_ == null) {
        return gitIntegrationSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.getDefaultInstance()
            : gitIntegrationSettings_;
      } else {
        return gitIntegrationSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Git integration settings for this agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings git_integration_settings = 30;
     * </code>
     */
    public Builder setGitIntegrationSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings value) {
      if (gitIntegrationSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gitIntegrationSettings_ = value;
      } else {
        gitIntegrationSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Git integration settings for this agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings git_integration_settings = 30;
     * </code>
     */
    public Builder setGitIntegrationSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.Builder builderForValue) {
      if (gitIntegrationSettingsBuilder_ == null) {
        gitIntegrationSettings_ = builderForValue.build();
      } else {
        gitIntegrationSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Git integration settings for this agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings git_integration_settings = 30;
     * </code>
     */
    public Builder mergeGitIntegrationSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings value) {
      if (gitIntegrationSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && gitIntegrationSettings_ != null
            && gitIntegrationSettings_
                != com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings
                    .getDefaultInstance()) {
          getGitIntegrationSettingsBuilder().mergeFrom(value);
        } else {
          gitIntegrationSettings_ = value;
        }
      } else {
        gitIntegrationSettingsBuilder_.mergeFrom(value);
      }
      if (gitIntegrationSettings_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Git integration settings for this agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings git_integration_settings = 30;
     * </code>
     */
    public Builder clearGitIntegrationSettings() {
      bitField0_ = (bitField0_ & ~0x00008000);
      gitIntegrationSettings_ = null;
      if (gitIntegrationSettingsBuilder_ != null) {
        gitIntegrationSettingsBuilder_.dispose();
        gitIntegrationSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Git integration settings for this agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings git_integration_settings = 30;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.Builder
        getGitIntegrationSettingsBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getGitIntegrationSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Git integration settings for this agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings git_integration_settings = 30;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettingsOrBuilder
        getGitIntegrationSettingsOrBuilder() {
      if (gitIntegrationSettingsBuilder_ != null) {
        return gitIntegrationSettingsBuilder_.getMessageOrBuilder();
      } else {
        return gitIntegrationSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.getDefaultInstance()
            : gitIntegrationSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Git integration settings for this agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings git_integration_settings = 30;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings,
            com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettingsOrBuilder>
        getGitIntegrationSettingsFieldBuilder() {
      if (gitIntegrationSettingsBuilder_ == null) {
        gitIntegrationSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings,
                com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.Agent.GitIntegrationSettingsOrBuilder>(
                getGitIntegrationSettings(), getParentForChildren(), isClean());
        gitIntegrationSettings_ = null;
      }
      return gitIntegrationSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings textToSpeechSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings,
            com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.TextToSpeechSettingsOrBuilder>
        textToSpeechSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings on instructing the speech synthesizer on how to generate the
     * output audio content.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextToSpeechSettings text_to_speech_settings = 31;
     * </code>
     *
     * @return Whether the textToSpeechSettings field is set.
     */
    public boolean hasTextToSpeechSettings() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings on instructing the speech synthesizer on how to generate the
     * output audio content.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextToSpeechSettings text_to_speech_settings = 31;
     * </code>
     *
     * @return The textToSpeechSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings getTextToSpeechSettings() {
      if (textToSpeechSettingsBuilder_ == null) {
        return textToSpeechSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings.getDefaultInstance()
            : textToSpeechSettings_;
      } else {
        return textToSpeechSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings on instructing the speech synthesizer on how to generate the
     * output audio content.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextToSpeechSettings text_to_speech_settings = 31;
     * </code>
     */
    public Builder setTextToSpeechSettings(
        com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings value) {
      if (textToSpeechSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        textToSpeechSettings_ = value;
      } else {
        textToSpeechSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings on instructing the speech synthesizer on how to generate the
     * output audio content.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextToSpeechSettings text_to_speech_settings = 31;
     * </code>
     */
    public Builder setTextToSpeechSettings(
        com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings.Builder builderForValue) {
      if (textToSpeechSettingsBuilder_ == null) {
        textToSpeechSettings_ = builderForValue.build();
      } else {
        textToSpeechSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings on instructing the speech synthesizer on how to generate the
     * output audio content.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextToSpeechSettings text_to_speech_settings = 31;
     * </code>
     */
    public Builder mergeTextToSpeechSettings(
        com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings value) {
      if (textToSpeechSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && textToSpeechSettings_ != null
            && textToSpeechSettings_
                != com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings.getDefaultInstance()) {
          getTextToSpeechSettingsBuilder().mergeFrom(value);
        } else {
          textToSpeechSettings_ = value;
        }
      } else {
        textToSpeechSettingsBuilder_.mergeFrom(value);
      }
      if (textToSpeechSettings_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings on instructing the speech synthesizer on how to generate the
     * output audio content.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextToSpeechSettings text_to_speech_settings = 31;
     * </code>
     */
    public Builder clearTextToSpeechSettings() {
      bitField0_ = (bitField0_ & ~0x00010000);
      textToSpeechSettings_ = null;
      if (textToSpeechSettingsBuilder_ != null) {
        textToSpeechSettingsBuilder_.dispose();
        textToSpeechSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings on instructing the speech synthesizer on how to generate the
     * output audio content.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextToSpeechSettings text_to_speech_settings = 31;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings.Builder
        getTextToSpeechSettingsBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getTextToSpeechSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings on instructing the speech synthesizer on how to generate the
     * output audio content.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextToSpeechSettings text_to_speech_settings = 31;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.TextToSpeechSettingsOrBuilder
        getTextToSpeechSettingsOrBuilder() {
      if (textToSpeechSettingsBuilder_ != null) {
        return textToSpeechSettingsBuilder_.getMessageOrBuilder();
      } else {
        return textToSpeechSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings.getDefaultInstance()
            : textToSpeechSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings on instructing the speech synthesizer on how to generate the
     * output audio content.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3.TextToSpeechSettings text_to_speech_settings = 31;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings,
            com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.TextToSpeechSettingsOrBuilder>
        getTextToSpeechSettingsFieldBuilder() {
      if (textToSpeechSettingsBuilder_ == null) {
        textToSpeechSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings,
                com.google.cloud.dialogflow.cx.v3.TextToSpeechSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.TextToSpeechSettingsOrBuilder>(
                getTextToSpeechSettings(), getParentForChildren(), isClean());
        textToSpeechSettings_ = null;
      }
      return textToSpeechSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings genAppBuilderSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings,
            com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettingsOrBuilder>
        genAppBuilderSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Gen App Builder-related agent-level settings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings gen_app_builder_settings = 33;
     * </code>
     *
     * @return Whether the genAppBuilderSettings field is set.
     */
    public boolean hasGenAppBuilderSettings() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Gen App Builder-related agent-level settings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings gen_app_builder_settings = 33;
     * </code>
     *
     * @return The genAppBuilderSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings
        getGenAppBuilderSettings() {
      if (genAppBuilderSettingsBuilder_ == null) {
        return genAppBuilderSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.getDefaultInstance()
            : genAppBuilderSettings_;
      } else {
        return genAppBuilderSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Gen App Builder-related agent-level settings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings gen_app_builder_settings = 33;
     * </code>
     */
    public Builder setGenAppBuilderSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings value) {
      if (genAppBuilderSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        genAppBuilderSettings_ = value;
      } else {
        genAppBuilderSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Gen App Builder-related agent-level settings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings gen_app_builder_settings = 33;
     * </code>
     */
    public Builder setGenAppBuilderSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.Builder builderForValue) {
      if (genAppBuilderSettingsBuilder_ == null) {
        genAppBuilderSettings_ = builderForValue.build();
      } else {
        genAppBuilderSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Gen App Builder-related agent-level settings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings gen_app_builder_settings = 33;
     * </code>
     */
    public Builder mergeGenAppBuilderSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings value) {
      if (genAppBuilderSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && genAppBuilderSettings_ != null
            && genAppBuilderSettings_
                != com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings
                    .getDefaultInstance()) {
          getGenAppBuilderSettingsBuilder().mergeFrom(value);
        } else {
          genAppBuilderSettings_ = value;
        }
      } else {
        genAppBuilderSettingsBuilder_.mergeFrom(value);
      }
      if (genAppBuilderSettings_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Gen App Builder-related agent-level settings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings gen_app_builder_settings = 33;
     * </code>
     */
    public Builder clearGenAppBuilderSettings() {
      bitField0_ = (bitField0_ & ~0x00020000);
      genAppBuilderSettings_ = null;
      if (genAppBuilderSettingsBuilder_ != null) {
        genAppBuilderSettingsBuilder_.dispose();
        genAppBuilderSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Gen App Builder-related agent-level settings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings gen_app_builder_settings = 33;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.Builder
        getGenAppBuilderSettingsBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getGenAppBuilderSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Gen App Builder-related agent-level settings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings gen_app_builder_settings = 33;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettingsOrBuilder
        getGenAppBuilderSettingsOrBuilder() {
      if (genAppBuilderSettingsBuilder_ != null) {
        return genAppBuilderSettingsBuilder_.getMessageOrBuilder();
      } else {
        return genAppBuilderSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.getDefaultInstance()
            : genAppBuilderSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Gen App Builder-related agent-level settings.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings gen_app_builder_settings = 33;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings,
            com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettingsOrBuilder>
        getGenAppBuilderSettingsFieldBuilder() {
      if (genAppBuilderSettingsBuilder_ == null) {
        genAppBuilderSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings,
                com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.Agent.GenAppBuilderSettingsOrBuilder>(
                getGenAppBuilderSettings(), getParentForChildren(), isClean());
        genAppBuilderSettings_ = null;
      }
      return genAppBuilderSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answerFeedbackSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings,
            com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettingsOrBuilder>
        answerFeedbackSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Answer feedback collection settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answer_feedback_settings = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the answerFeedbackSettings field is set.
     */
    public boolean hasAnswerFeedbackSettings() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer feedback collection settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answer_feedback_settings = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The answerFeedbackSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings
        getAnswerFeedbackSettings() {
      if (answerFeedbackSettingsBuilder_ == null) {
        return answerFeedbackSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.getDefaultInstance()
            : answerFeedbackSettings_;
      } else {
        return answerFeedbackSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer feedback collection settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answer_feedback_settings = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAnswerFeedbackSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings value) {
      if (answerFeedbackSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        answerFeedbackSettings_ = value;
      } else {
        answerFeedbackSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer feedback collection settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answer_feedback_settings = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAnswerFeedbackSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.Builder builderForValue) {
      if (answerFeedbackSettingsBuilder_ == null) {
        answerFeedbackSettings_ = builderForValue.build();
      } else {
        answerFeedbackSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer feedback collection settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answer_feedback_settings = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAnswerFeedbackSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings value) {
      if (answerFeedbackSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && answerFeedbackSettings_ != null
            && answerFeedbackSettings_
                != com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings
                    .getDefaultInstance()) {
          getAnswerFeedbackSettingsBuilder().mergeFrom(value);
        } else {
          answerFeedbackSettings_ = value;
        }
      } else {
        answerFeedbackSettingsBuilder_.mergeFrom(value);
      }
      if (answerFeedbackSettings_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer feedback collection settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answer_feedback_settings = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAnswerFeedbackSettings() {
      bitField0_ = (bitField0_ & ~0x00040000);
      answerFeedbackSettings_ = null;
      if (answerFeedbackSettingsBuilder_ != null) {
        answerFeedbackSettingsBuilder_.dispose();
        answerFeedbackSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer feedback collection settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answer_feedback_settings = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.Builder
        getAnswerFeedbackSettingsBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getAnswerFeedbackSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer feedback collection settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answer_feedback_settings = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettingsOrBuilder
        getAnswerFeedbackSettingsOrBuilder() {
      if (answerFeedbackSettingsBuilder_ != null) {
        return answerFeedbackSettingsBuilder_.getMessageOrBuilder();
      } else {
        return answerFeedbackSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.getDefaultInstance()
            : answerFeedbackSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Answer feedback collection settings.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings answer_feedback_settings = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings,
            com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettingsOrBuilder>
        getAnswerFeedbackSettingsFieldBuilder() {
      if (answerFeedbackSettingsBuilder_ == null) {
        answerFeedbackSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings,
                com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.Agent.AnswerFeedbackSettingsOrBuilder>(
                getAnswerFeedbackSettings(), getParentForChildren(), isClean());
        answerFeedbackSettings_ = null;
      }
      return answerFeedbackSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings
        personalizationSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings,
            com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettingsOrBuilder>
        personalizationSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Settings for end user personalization.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalization_settings = 42 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the personalizationSettings field is set.
     */
    public boolean hasPersonalizationSettings() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for end user personalization.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalization_settings = 42 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The personalizationSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings
        getPersonalizationSettings() {
      if (personalizationSettingsBuilder_ == null) {
        return personalizationSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.getDefaultInstance()
            : personalizationSettings_;
      } else {
        return personalizationSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for end user personalization.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalization_settings = 42 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPersonalizationSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings value) {
      if (personalizationSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        personalizationSettings_ = value;
      } else {
        personalizationSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for end user personalization.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalization_settings = 42 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPersonalizationSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.Builder builderForValue) {
      if (personalizationSettingsBuilder_ == null) {
        personalizationSettings_ = builderForValue.build();
      } else {
        personalizationSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for end user personalization.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalization_settings = 42 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePersonalizationSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings value) {
      if (personalizationSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && personalizationSettings_ != null
            && personalizationSettings_
                != com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings
                    .getDefaultInstance()) {
          getPersonalizationSettingsBuilder().mergeFrom(value);
        } else {
          personalizationSettings_ = value;
        }
      } else {
        personalizationSettingsBuilder_.mergeFrom(value);
      }
      if (personalizationSettings_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for end user personalization.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalization_settings = 42 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPersonalizationSettings() {
      bitField0_ = (bitField0_ & ~0x00080000);
      personalizationSettings_ = null;
      if (personalizationSettingsBuilder_ != null) {
        personalizationSettingsBuilder_.dispose();
        personalizationSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for end user personalization.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalization_settings = 42 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.Builder
        getPersonalizationSettingsBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getPersonalizationSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for end user personalization.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalization_settings = 42 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettingsOrBuilder
        getPersonalizationSettingsOrBuilder() {
      if (personalizationSettingsBuilder_ != null) {
        return personalizationSettingsBuilder_.getMessageOrBuilder();
      } else {
        return personalizationSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.getDefaultInstance()
            : personalizationSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for end user personalization.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings personalization_settings = 42 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings,
            com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettingsOrBuilder>
        getPersonalizationSettingsFieldBuilder() {
      if (personalizationSettingsBuilder_ == null) {
        personalizationSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings,
                com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.Agent.PersonalizationSettingsOrBuilder>(
                getPersonalizationSettings(), getParentForChildren(), isClean());
        personalizationSettings_ = null;
      }
      return personalizationSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
        clientCertificateSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings,
            com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettingsOrBuilder>
        clientCertificateSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Settings for custom client certificates.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings client_certificate_settings = 43 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the clientCertificateSettings field is set.
     */
    public boolean hasClientCertificateSettings() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for custom client certificates.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings client_certificate_settings = 43 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The clientCertificateSettings.
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
        getClientCertificateSettings() {
      if (clientCertificateSettingsBuilder_ == null) {
        return clientCertificateSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.getDefaultInstance()
            : clientCertificateSettings_;
      } else {
        return clientCertificateSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for custom client certificates.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings client_certificate_settings = 43 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setClientCertificateSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings value) {
      if (clientCertificateSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        clientCertificateSettings_ = value;
      } else {
        clientCertificateSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for custom client certificates.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings client_certificate_settings = 43 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setClientCertificateSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.Builder builderForValue) {
      if (clientCertificateSettingsBuilder_ == null) {
        clientCertificateSettings_ = builderForValue.build();
      } else {
        clientCertificateSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for custom client certificates.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings client_certificate_settings = 43 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeClientCertificateSettings(
        com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings value) {
      if (clientCertificateSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && clientCertificateSettings_ != null
            && clientCertificateSettings_
                != com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings
                    .getDefaultInstance()) {
          getClientCertificateSettingsBuilder().mergeFrom(value);
        } else {
          clientCertificateSettings_ = value;
        }
      } else {
        clientCertificateSettingsBuilder_.mergeFrom(value);
      }
      if (clientCertificateSettings_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for custom client certificates.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings client_certificate_settings = 43 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearClientCertificateSettings() {
      bitField0_ = (bitField0_ & ~0x00100000);
      clientCertificateSettings_ = null;
      if (clientCertificateSettingsBuilder_ != null) {
        clientCertificateSettingsBuilder_.dispose();
        clientCertificateSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for custom client certificates.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings client_certificate_settings = 43 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.Builder
        getClientCertificateSettingsBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getClientCertificateSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for custom client certificates.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings client_certificate_settings = 43 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettingsOrBuilder
        getClientCertificateSettingsOrBuilder() {
      if (clientCertificateSettingsBuilder_ != null) {
        return clientCertificateSettingsBuilder_.getMessageOrBuilder();
      } else {
        return clientCertificateSettings_ == null
            ? com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.getDefaultInstance()
            : clientCertificateSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for custom client certificates.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings client_certificate_settings = 43 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings,
            com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.Builder,
            com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettingsOrBuilder>
        getClientCertificateSettingsFieldBuilder() {
      if (clientCertificateSettingsBuilder_ == null) {
        clientCertificateSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings,
                com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettings.Builder,
                com.google.cloud.dialogflow.cx.v3.Agent.ClientCertificateSettingsOrBuilder>(
                getClientCertificateSettings(), getParentForChildren(), isClean());
        clientCertificateSettings_ = null;
      }
      return clientCertificateSettingsBuilder_;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Optional. Output only. A read only boolean field reflecting Zone Separation
     * status of the agent.
     * </pre>
     *
     * <code>
     * optional bool satisfies_pzs = 45 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the satisfiesPzs field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzs() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. A read only boolean field reflecting Zone Separation
     * status of the agent.
     * </pre>
     *
     * <code>
     * optional bool satisfies_pzs = 45 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. A read only boolean field reflecting Zone Separation
     * status of the agent.
     * </pre>
     *
     * <code>
     * optional bool satisfies_pzs = 45 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. A read only boolean field reflecting Zone Separation
     * status of the agent.
     * </pre>
     *
     * <code>
     * optional bool satisfies_pzs = 45 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00200000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;
    /**
     *
     *
     * <pre>
     * Optional. Output only. A read only boolean field reflecting Zone Isolation
     * status of the agent.
     * </pre>
     *
     * <code>
     * optional bool satisfies_pzi = 46 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the satisfiesPzi field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzi() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. A read only boolean field reflecting Zone Isolation
     * status of the agent.
     * </pre>
     *
     * <code>
     * optional bool satisfies_pzi = 46 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. A read only boolean field reflecting Zone Isolation
     * status of the agent.
     * </pre>
     *
     * <code>
     * optional bool satisfies_pzi = 46 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output only. A read only boolean field reflecting Zone Isolation
     * status of the agent.
     * </pre>
     *
     * <code>
     * optional bool satisfies_pzi = 46 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00400000);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3.Agent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3.Agent)
  private static final com.google.cloud.dialogflow.cx.v3.Agent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3.Agent();
  }

  public static com.google.cloud.dialogflow.cx.v3.Agent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Agent> PARSER =
      new com.google.protobuf.AbstractParser<Agent>() {
        @java.lang.Override
        public Agent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Agent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Agent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3.Agent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
