/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExperimentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AGENT_ENVIRONMENT_EXPERIMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agents/{agent}/environments/{environment}/experiments/{experiment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String agent;
    private final String environment;
    private final String experiment;

    @Deprecated
    protected ExperimentName() {
        this.project = null;
        this.location = null;
        this.agent = null;
        this.environment = null;
        this.experiment = null;
    }

    private ExperimentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.agent = (String)Preconditions.checkNotNull((Object)builder.getAgent());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.experiment = (String)Preconditions.checkNotNull((Object)builder.getExperiment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getExperiment() {
        return this.experiment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExperimentName of(String project, String location, String agent, String environment, String experiment) {
        return ExperimentName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setEnvironment(environment).setExperiment(experiment).build();
    }

    public static String format(String project, String location, String agent, String environment, String experiment) {
        return ExperimentName.newBuilder().setProject(project).setLocation(location).setAgent(agent).setEnvironment(environment).setExperiment(experiment).build().toString();
    }

    public static ExperimentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AGENT_ENVIRONMENT_EXPERIMENT.validatedMatch(formattedString, "ExperimentName.parse: formattedString not in valid format");
        return ExperimentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("agent"), (String)matchMap.get("environment"), (String)matchMap.get("experiment"));
    }

    public static List<ExperimentName> parseList(List<String> formattedStrings) {
        ArrayList<ExperimentName> list = new ArrayList<ExperimentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExperimentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExperimentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExperimentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AGENT_ENVIRONMENT_EXPERIMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExperimentName experimentName = this;
            synchronized (experimentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.agent != null) {
                        fieldMapBuilder.put((Object)"agent", (Object)this.agent);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    if (this.experiment != null) {
                        fieldMapBuilder.put((Object)"experiment", (Object)this.experiment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AGENT_ENVIRONMENT_EXPERIMENT.instantiate(new String[]{"project", this.project, "location", this.location, "agent", this.agent, "environment", this.environment, "experiment", this.experiment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ExperimentName that = (ExperimentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.agent, that.agent) && Objects.equals(this.environment, that.environment) && Objects.equals(this.experiment, that.experiment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.agent);
        h *= 1000003;
        h ^= Objects.hashCode(this.environment);
        h *= 1000003;
        return h ^= Objects.hashCode(this.experiment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String agent;
        private String environment;
        private String experiment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAgent() {
            return this.agent;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getExperiment() {
            return this.experiment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAgent(String agent) {
            this.agent = agent;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder setExperiment(String experiment) {
            this.experiment = experiment;
            return this;
        }

        private Builder(ExperimentName experimentName) {
            this.project = experimentName.project;
            this.location = experimentName.location;
            this.agent = experimentName.agent;
            this.environment = experimentName.environment;
            this.experiment = experimentName.experiment;
        }

        public ExperimentName build() {
            return new ExperimentName(this);
        }
    }
}

